<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'quiz', language 'no', version '4.3'.
 *
 * @package     quiz
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessnoticesheader'] = 'Du kan forhåndsvise denne quizen, men hvis det er gjort reelle forsøk vil du blokkeres, fordi:';
$string['action'] = 'Handling';
$string['activityoverview'] = 'Det er quizer som du kan gjennomføre nå';
$string['adaptive'] = 'Sjekk svar modus';
$string['adaptive_help'] = 'Dersom aktivert vil det tillates flere svar på et spørsmål i samme quizforsøket. Hvis f.eks. et svar er merket som feil kan studenten prøve igjen med en gang. Likevel - avhengig av straffepoenginnstillingene - vil hvert nye forsøk resultere i poengtrekk.';
$string['add'] = 'Legg til';
$string['addaquestion'] = 'et nytt spørsmål';
$string['addarandomquestion'] = 'et tilfeldig spørsmål';
$string['addarandomquestion_help'] = 'Når det legges til et tilfeldig spørsmål betyr det at det trekkes et tilfeldig spørsmål fra angitt kategori. Det medfører at forskjellige studenter får forskjellige quizer og gjentatte forsøk gir også ny quiz hver gang.';
$string['addarandomquestion_success'] = 'Tilfeldige spørsmål er lagt til';
$string['addarandomselectedquestion'] = 'Legg til et tilfeldig valgt spørsmål';
$string['addasection'] = 'ny seksjonsoverskrift';
$string['adddescriptionlabel'] = 'Legg til et beskrivelseselement';
$string['addingquestion'] = 'Legger til et spørsmål';
$string['addingquestions'] = '<p>Dette er siden der du håndterer databasen med spørsmål. Spørsmålene lagres i kategorier for å hjelpe deg å holde orden på dem, og de kan brukes i alle quizer på siden og evt. også på andre sider hvis du velger å \'publisere\' dem. </p><p>Etter at du har valgt eller laget en spørsmålskategori vil du få muligheten til å lage eller redigere spørsmål. Du kan velge disse spørsmålene og lege dem til quizen din på den andre siden av skjermbildet.</p>';
$string['addmoreoverallfeedbacks'] = 'Legg til {no} ekstra tilbakemeldingsfelt';
$string['addnewgroupoverride'] = 'Legg til gruppebasert overstyring';
$string['addnewpagesafterselected'] = 'Legg til nye sider etter valgte spørsmål';
$string['addnewquestionsqbank'] = 'Legg til spørsmål til kategorien {$a->catname}: {$a->link}';
$string['addnewuseroverride'] = 'Legg til brukerbasert overstyring';
$string['addpagebreak'] = 'Legg til sideskift';
$string['addpagehere'] = 'Legg til side her';
$string['addquestion'] = 'Legg til spørsmål';
$string['addquestionfrombankatend'] = 'Legg til et spørsmål fra testbanken på slutten av quizen';
$string['addquestionfrombanktopage'] = 'Legg til spørsmål fra testbanken på side {$a}';
$string['addquestions'] = 'Legg inn spørsmål';
$string['addquestionstoquiz'] = 'Legg til spørsmål i gjeldende quiz';
$string['addrandom'] = 'Legg til {$a} tilfeldige spørsmål';
$string['addrandom1'] = '<<Legg til';
$string['addrandom2'] = 'Tilfeldige spørsmål';
$string['addrandomfromcategory'] = 'Legg til tilfeldig spørsmål fra kategori:';
$string['addrandomquestion'] = 'Legg til tilfeldig spørsmål';
$string['addrandomquestionatend'] = 'Legg til et tilfeldig spørsmål fra testbanken på slutten av quizen';
$string['addrandomquestiontopage'] = 'Legg til et tilfeldig spørsmål på side {$a}';
$string['addrandomquestiontoquiz'] = 'Legg til tilfeldig spørsmål til quizen {$a}';
$string['addselectedquestionstoquiz'] = 'Legg til valgte spørsmål i quizen';
$string['addselectedtoquiz'] = 'Legg valgte til quizen';
$string['addtoquiz'] = 'Legg til';
$string['affectedstudents'] = 'Berørte {$a}';
$string['aftereachquestion'] = 'Etter å ha lagt til hvert spørsmål';
$string['afternquestions'] = 'Etter å ha lagt til {$a} spørsmål';
$string['age'] = 'alder';
$string['allattempts'] = 'Alle forsøk';
$string['allinone'] = 'Ubegrenset';
$string['allowreview'] = 'Tillat sammendrag';
$string['alreadysubmitted'] = 'Du har sannsynligvis svart allerede';
$string['alternativeunits'] = 'Alternative enheter';
$string['alwaysavailable'] = 'Alltid tilgjengelig';
$string['alwayslatest'] = 'Alltid siste';
$string['analysisoptions'] = 'Analysemuligheter';
$string['analysistitle'] = 'Tabell for elementanalyse';
$string['answer'] = 'Svar';
$string['answered'] = 'Besvart';
$string['answerhowmany'] = 'Ett eller flere svar?';
$string['answers'] = 'Vis fasit';
$string['answersingleno'] = 'Flere svar tillatt';
$string['answersingleyes'] = 'Kun ett svar';
$string['answertoolong'] = 'Svaret er for langt etter linje {$a} (Maks 255 tegn)';
$string['anytags'] = 'Enhver tag';
$string['aon'] = 'AOM-format';
$string['areyousureremoveselected'] = 'Er du sikker på at du vil fjerne alle valgte spørsmål?';
$string['asshownoneditscreen'] = 'Som vist på redigeringsskjermbildet';
$string['attempt'] = 'Forsøk {$a}';
$string['attemptalreadyclosed'] = 'Dette forsøket er allerede avsluttet';
$string['attemptclosed'] = 'Forsøket er ikke avsluttet ennå';
$string['attemptduration'] = 'Brukt tid';
$string['attemptedon'] = 'Forsøkt den';
$string['attempterror'] = 'Du har ikke lov til å forsøke på denne quizen nå fordi: {$a}';
$string['attempterrorcontentchange'] = 'Denne quizforhåndsvisningen eksister ikke lengre. (Når en quiz endres vil alle pågående forhåndsvisningsforsøk bli automatisk slettet.)';
$string['attempterrorcontentchangeforuser'] = 'Dette quizforsøket eksisterer ikke lengre.';
$string['attempterrorinvalid'] = 'Ugyldig quizforsøksID';
$string['attemptfirst'] = 'Første forsøk';
$string['attemptgradeddelay'] = 'Forsink før sending av forsøksgraderte varsler';
$string['attemptgradeddelay_desc'] = 'En forsinkelse angis før du sender en e-post til studenten for å fortelle dem at quizforsøket deres nå er vurdert. Dette er en avveining. Vi ønsker å varsle studenten så raskt som mulig. Læreren kan imidlertid gå tilbake og redigere karakteren på nytt, og vi ønsker ikke å varsle eleven før det skjer.';
$string['attemptincomplete'] = 'Forsøket (av {$a}) er ennå ikke fullført.';
$string['attemptlast'] = 'Siste forsøk';
$string['attemptnumber'] = 'Forsøk';
$string['attemptquiz'] = 'Ta quizen';
$string['attemptquiznow'] = 'Ta quizen nå';
$string['attemptreviewtitle'] = '{$a}: Forsøksgjennomgang';
$string['attemptreviewtitlepaged'] = '{$a->name}: Forsøksgjennomgang (side {$a->currentpage} av {$a->totalpages})';
$string['attempts'] = 'Forsøk';
$string['attempts_help'] = 'Totalt antall tillate forsøk (ikke antall ekstraforsøk)';
$string['attemptsallowed'] = 'Forsøk tillatt';
$string['attemptsdeleted'] = 'Quizforsøk slettet';
$string['attemptselection'] = 'Velg hvilke brukerforsøk du vil analysere';
$string['attemptsexist'] = 'Noen har allerede tatt denne quizen <br/> Du kan ikke lenger legge til eller fjerne spørsmål.';
$string['attemptsnum'] = 'Forsøk: {$a}';
$string['attemptsnumthisgroup'] = 'Forsøk:{$a->total} ({$a->group} fra denne gruppen)';
$string['attemptsnumyourgroups'] = 'Forsøk: {$a->total} ({$a->group} fra denne gruppen)';
$string['attemptsonly'] = 'Vis bare studenter som har prøvd';
$string['attemptstate'] = 'Status';
$string['attemptstillinprogress'] = 'Forsøket pågår fremdeles';
$string['attemptsummarytitle'] = '{$a}: Forsøksoppsummering';
$string['attemptsunlimited'] = 'Ubegrensede forsøk';
$string['attempttitle'] = '{$a}';
$string['attempttitlepaged'] = '{$a->name} (side {$a->currentpage} av {$a->totalpages})';
$string['autosaveperiod'] = 'Forsinkelse for autolagring';
$string['autosaveperiod_desc'] = 'Besvarelsen kan lagres automatisk mens forsøket pågår. Svarene lagres hver gag et svar endres eller etter denne forsinkelsen. Dette innbærer en avveining: Å lagre svarene medfører at serverbelastningen øker, men reduserer sjansen for at deltakerne mister arbeidet sitt. Hvis du har tenkt å gjøre forsinkelsen veldig kort bør du endre denne verdien gradvis mens du overvåker serverbelastningen. Dersom belastningen blir for stor bør du øke forsinkelsen. Om du setter forsinkelsen til 0 betyr det at automtisk lagring slås av.';
$string['back'] = 'Tilbake til forhåndsvisning av spørsmålet';
$string['backtocourse'] = 'Tilbake til kurset';
$string['backtoquestionlist'] = 'Tilbake til spørsmålslista';
$string['backtoquiz'] = 'Tilbake til quiz-redigering';
$string['basicideasofquiz'] = 'Den grunnleggende ideen bak å lage quizer';
$string['bestgrade'] = 'Beste karakter/poeng';
$string['bothattempts'] = 'Vis studenter med og uten forsøk';
$string['browsersecurity'] = 'Nettlesersikkerhet';
$string['browsersecurity_help'] = 'Dersom du har valgt "Fulll skjerm popup-vindu med noe javascript-sikkerhet";

* Quizen vil kun tas av studenter med aktivert Javascript i nettleseren.
* Quizen vil kun åpnes i et fullskjerms popup-vindu som ligger over alle andre vinduer og har ingen navigsjonselementer.
* Studenter blir forhindret, så langt det går, å bruke funksjoner som klipp og lim.';
$string['cachedef_overrides'] = 'Bruker- og gruppeoverstyringsinformasjon';
$string['calculated'] = 'Beregnet';
$string['calculatedquestion'] = 'Beregnet spørsmål er ikke støttet på linje {$a}. Spørsmålet vil bli ignorert';
$string['cannotcreatepath'] = 'Stien kan ikke opprettes ({$a})';
$string['cannoteditafterattempts'] = 'Du kan ikke legge til eller fjerne spørsmål når noen har lagrede forsøk på quizen. ({$a})';
$string['cannotfindprevattempt'] = 'Kan ikke finne tidligere forsøk å bygge på.';
$string['cannotfindquestionregard'] = 'Mislykkes i å hente spørsmål for oppdatering av karakter!';
$string['cannotinsert'] = 'Kan ikke sette inn spørsmål';
$string['cannotinsertrandomquestion'] = 'Kunne ikke sette inn et tilfeldig spørsmål!';
$string['cannotloadquestion'] = 'Kunne ikke laste spørsmålsinnstillingene';
$string['cannotloadtypeinfo'] = 'Kunne ikke laste spørsmålstype-spesifikk spørsmålsinformasjon';
$string['cannotopen'] = 'Kan ikke åpne eksportert fil ({$a})';
$string['cannotremoveallsectionslots'] = 'Du har valgt alle spørsmålene under \'{$a}\'. Det er ikke lov til å fjerne alle spørsmålene under en seksjonsoverskrift.';
$string['cannotremoveslots'] = 'Kan ikke fjerne spørsmål';
$string['cannotrestore'] = 'Kunne ikke gjenopprette spørsmålssesjoner';
$string['cannotreviewopen'] = 'Du kan ikke se på dette forsøket - det er fortsatt åpent!';
$string['cannotsavelayout'] = 'Kunne ikke lagre layout';
$string['cannotsavenumberofquestion'] = 'Kunne ikke lagre antall spørsmål pr. side';
$string['cannotsavequestion'] = 'Kunne ikke lagre spørsmålslisten';
$string['cannotsetgrade'] = 'Kunne ikke angi ny maksimumskarakter for quizen';
$string['cannotsetsumgrades'] = 'Mislykkes i å angi sum karakter';
$string['cannotstartgradesmismatch'] = 'Kan ikke starte noe forsøk på denne quizen. Quizen er satt til å vurderes basert på  {$a->grade}, men ingen av spørsmålene i quizen har noen poengsum angitt. Dette kan fikses på "Endre quiz"-siden.';
$string['cannotstartmissingquestion'] = 'Kan ikke starte noe forsøk på denne quizen. Quizoppsettet har med et spørsmål som ikke lenger eksisterer.';
$string['cannotstartnoquestions'] = 'Kan ikke starte noe forsøk på denne quizn. Quizen er ikke ferdig satt opp ennå. Det er ikke lagt til noen spørsmål.';
$string['cannotwrite'] = 'Kan ikke skrive til eksportert fil ({$a})';
$string['canredoquestions'] = 'Tillat omgjøringer innenfor et forsøk';
$string['canredoquestions_desc'] = 'Hvis dette er aktivert, vises en \'Prøv et annet spørsmål som denne\' -knappen etter å ha forsøkt et spørsmål. Dette gjør at et lignende spørsmål (valgt tilfeldig) kan forsøkes, eller det samme spørsmålet igjen, uten at hele quizforsøket må sendes inn og et nytt forsøk starte. Dette alternativet er nyttig for å øvingsquizzer.

Denne innstillingen påvirker bare spørsmål og atferd (for eksempel umiddelbar tilbakemelding eller interaktiv med flere forsøk) der det er mulig å fullføre et spørsmål før forsøket sendes inn.';
$string['canredoquestions_help'] = 'Når aktivert vil brukerne se en "Gjør om"-knapp etter å ha besvart et bestemt spørsmål. Dette tillater de å forsøke spørsmålet på nytt uten å måtte besvare alle de andre spørsmålene i quizen. Dette valget er best å benytte i øvingsquizer.

Denne innstillingen påvirker bare spørsmål (f.eks. ikke langsvarsoppgaver) og quizoppførsel (f.eks. Umiddelbar tilbakemelding) der det er mulig for brukeren å avslutte spørsmålet før quizen leveres inn.';
$string['canredoquestionsyes'] = 'Ja, gi muligheten til å prøve et annet spørsmål';
$string['caseno'] = 'Nei, store/små bokstaver må ikke stemme';
$string['casesensitive'] = 'Store/små bokstaver må stemme';
$string['caseyes'] = 'Ja, bokstaver/tegn må stemme';
$string['categoryadded'] = 'Kategorien {$a} ble lagt til';
$string['categorydeleted'] = 'Kategorien {$a} ble slettet';
$string['categorynoedit'] = 'Du har ikke rettigheter til å redigere spørsmål i kategorien \'{$a}\'';
$string['categoryupdated'] = 'Oppdateringen av denne kaegorien var vellykket';
$string['close'] = 'Lukk forhåndsvsining';
$string['closebeforeopen'] = 'Kunne ikke fullføre oppdateringen. Du har valgt en frist for fullføring som er FØR åpningsdatoen.';
$string['closed'] = 'Stengt';
$string['closepreview'] = 'Lukk forhåndsvisning';
$string['closereview'] = 'Lukk sammendrag';
$string['comment'] = 'Kommentar';
$string['commentorgrade'] = 'Skriv en kommentar eller overstyr karakteren';
$string['comments'] = 'Kommentarer';
$string['completedon'] = 'Fullført den';
$string['completionattemptsexhausted'] = 'Bestått karakter eller alle tilgjengelige forsøk fullført';
$string['completionattemptsexhausted_help'] = 'Merk quizen som fullført når brukeren har brukt opp alle forsøkene sine.';
$string['completiondetail:minattempts'] = 'Gjør forsøk: {$a}';
$string['completiondetail:passgrade'] = 'Få bestått karakter';
$string['completiondetail:passorexhaust'] = 'Få en bestått karakter eller fullfør alle tilgjengelige forsøk';
$string['completionminattempts'] = 'Minste antall forsøk';
$string['completionminattemptsdesc'] = 'Minimum antall forsøk som kreves: {$a}';
$string['completionminattemptserror'] = 'Minimum antall forsøk må være lavere eller lik antall tillatte forsøk.';
$string['completionminattemptsgroup'] = 'Krev forsøk';
$string['completionpass'] = 'Krev ståkarakter';
$string['completionpass_help'] = 'Når aktivert vil aktiviteten merkes som fullført når brukeren oppnår en ståkarakter. Ståkarakteren settes i quizinnstillingene.';
$string['completionpassdesc'] = 'Deltakeren må oppnå ståkarakter for å fullføre denne aktiviteten.';
$string['completionpassorattemptsexhausteddesc'] = 'Studenten må oppnå bestått karakter, eller bruke alle tilgjengelige forsøk på å fullføre denne aktiviteten';
$string['configadaptive'] = 'Dersom du velger JA her vil studenten kunne svare flere ganger på et spørsmål innen samme forsøk på quizen.';
$string['configattemptsallowed'] = 'Begrensninger på antall forsøk på quizen.';
$string['configdecimaldigits'] = 'Antall desimaler som skal vises i karakteren.';
$string['configdecimalplaces'] = 'Antall desimaler som skal vises i sluttkarakteren for quizen.';
$string['configdecimalplacesquestion'] = 'Antall desimaler som skal vises i karakteren for hvert spørsmål.';
$string['configdelay1'] = 'Dersom du angir en tidsutsettelse, må studenten vente den tiden før de kan prøve igjen etter det første forsøket.';
$string['configdelay1st2nd'] = 'Dersom du angir en tidsutsettelse, må studenten vente den tiden før de kan prøve igjen etter det første forsøket.';
$string['configdelay2'] = 'Dersom du angir en tidsutsettelse, må studenten vente den tiden før de kan prøve igjen - etter det andre forsøket.';
$string['configdelaylater'] = 'Dersom du angir en tidsutsettelse, må studenten vente den tiden før de kan prøve igjen etter andre forsøket.';
$string['configeachattemptbuildsonthelast'] = 'Dersom mange forsøk er tillatt vil vært nye forsøk være basert på det foregående forsøket.';
$string['configgrademethod'] = 'Dersom mange forsøk er tillatt, hvilken metode skal brukes for å beregne studentens endelige karakter for quizen.';
$string['configintro'] = 'Verdiene du setter her bestemmer standardverdiene som brukes når du lager en ny quiz. Du kan også bestemme hvilke quiz-innstillinger som skal regnes som avanserte.';
$string['configmaximumgrade'] = 'Standard karakter som quizen skal skaleres ut i fra.';
$string['confignavmethod'] = 'I fri navigasjonsmodus kan spørsmålene besvares i frivillig rekkefølge ved å bruke spørsmålsnavigasjonen. I sekvensiell modus må spørsmålene besvares i den rekkefølgen som er angitt.';
$string['confignewpageevery'] = 'Når du legger til spørsmål vil sideskiftene automatisk justeres etter de innstillingene du angir her.';
$string['configoutcomesadvanced'] = 'Dersom dette valget er aktivert, vil Læringsutbytte vises som en avansert innstilling i quizer.';
$string['configpenaltyscheme'] = 'Straffepoeng som trekkes fra hvert gale svar (i \'Sjekk svar modus\')';
$string['configpopup'] = 'Tvinger forsøket til å åpnes i et eget vindu og bruker Javascript for å forhindre klipp og lim osv. når quizen tas.';
$string['configrequirepassword'] = 'Studenten må skrive inn et passord før de kan åpne quizen.';
$string['configrequiresubnet'] = 'Studenter kan bare ta quizen fra disse pc-ene.';
$string['configreviewoptions'] = 'Disse valgene styrer hvilken informasjon brukere kan se når de ser over quiz-forsøket eller kikker på quiz-rapporter.';
$string['configshowblocks'] = 'Vis blokker samtidig med quizen.';
$string['configshowuserpicture'] = 'Vis brukerens profilbilde på skjermen under quiz-forsøket.';
$string['configshufflewithin'] = 'Dersom du aktiverer dette valget vil svaralternativene vises tilfeldig hver gang quizen tas.';
$string['configtimelimit'] = 'Standard tidsbegrensning for quizen (i minutter). 0 betyr ingen tidsbegrensning';
$string['configtimelimitsec'] = 'Standard tidsbegrensning for quizer (i sekunder). = betyr ingen tidsbegrensning.';
$string['configurerandomquestion'] = 'Endre spørsmål';
$string['confirmclose'] = 'Etter at du har sendt inn besvarelsen kan du ikke gjøre endringer på den.';
$string['confirmremovequestion'] = 'Er du sikker på at du ønsker å slette dette {$a} spørsmålet?';
$string['confirmremovesectionheading'] = 'Er du sikker på at du ønsker å fjerne seksjonsoverskriften \'{$a}\'.';
$string['confirmserverdelete'] = 'Er du sikker på at du vil fjerne tjeneren <b>{$a}</b> fra listen?';
$string['connectionerror'] = 'Nettverksforbindelsen er brutt. (Autolagring mislykkes).
Ta et notat på kommentarene du la inn på denne siden de siste minuttene og prøv igjen.

Straks forbindelsen er gjenopprettet, bør kommentarene dine bli lagret og da forsvinner denne meldingen.';
$string['connectionok'] = 'Nettverksforbindelsen er gjenopprettet. Du kan nå fortsette.';
$string['containercategorycreated'] = 'Denne kategorien ble laget for å ta vare på de kategoriene som har blitt flyttet til øverste nivå(portal)på grunn av følgende årsaker:';
$string['continueattemptquiz'] = 'Fortsett med forrige forsøk';
$string['continuepreview'] = 'Fortsett siste forhåndsvisning';
$string['copyingfrom'] = 'Lager en kopi av spørsmål \'{$a}\'';
$string['copyingquestion'] = 'Kopierer et spørsmål';
$string['correct'] = 'Riktig';
$string['correctanswer'] = 'Riktig svar';
$string['correctanswerformula'] = 'Korrekt svarformel';
$string['correctansweris'] = 'Korrekt svar: {$a}';
$string['correctanswerlength'] = 'Viktige tall';
$string['correctanswers'] = 'Riktige svar';
$string['correctanswershows'] = 'Riktig svar viser';
$string['corrresp'] = 'Korrekt respons';
$string['countdown'] = 'Nedtelling';
$string['countdownfinished'] = 'Quizen avsluttes, du bør sende svarene dine straks.';
$string['countdowntenminutes'] = 'Denne quizen avsluttes om ti minutter.';
$string['coursetestmanager'] = 'Format for administrering av kurstester';
$string['createcategoryandaddrandomquestion'] = 'Opprett kategori og legg til tilfeldig spørsmål';
$string['createfirst'] = 'Du må lage noen kort-svar-spørsmål først.';
$string['createmultiple'] = 'Legg til flere tilfeldige spørsmål i quizen';
$string['createnewquestion'] = 'Lag nytt spørsmål';
$string['createquestionandadd'] = 'Opprett et nytt spørsmål og legg det til i quizen.';
$string['custom'] = 'Eget format';
$string['dataitemneed'] = 'Må må legge til minst ett sett dataelement for å få et gyldig spørsmål';
$string['datasetdefinitions'] = 'Gjenbrukbare definisjoner for datasett for kategori {$a}';
$string['datasetnumber'] = 'Nummer';
$string['daysavailable'] = 'Dager tilgjengelig';
$string['decimaldigits'] = 'Desimaltall i karakterer';
$string['decimalplaces'] = 'Antall desimaler i karakterer';
$string['decimalplaces_help'] = 'Denne innstillingen bestemmer antall desimaler som skal være med i visningen av karakterer. Den har kun betydning for visningen av karakterer, og ikke for karakterene som lagres i databasen eller interne beregninger, som er nøyaktig utført.';
$string['decimalplacesquestion'] = 'Antall desimaler i spørsmålskarakteren';
$string['decimalplacesquestion_help'] = 'Denne innstillingen angir antall desimaler som skal vises i karakteren på hvert individuelle spørsmål.';
$string['decimalpoints'] = 'Desimalplasser';
$string['default'] = 'Standard';
$string['defaultgrade'] = 'Standardspørsmålskarakter';
$string['defaultinfo'] = 'Standard kategori med spørsmål.';
$string['delay1'] = 'Pause mellom første og andre forsøk';
$string['delay1st2nd'] = 'Tving ventetid mellom første og andre forsøk';
$string['delay1st2nd_help'] = '<p>Hvis du angir en tidsforsinkelse, må studenten vente i angitt tid før de kan prøve en gang til på quizen.</p>';
$string['delay2'] = 'Pause mellom senere forsøk';
$string['delaylater'] = 'Tving ventetid mellom hvert senere forsøk';
$string['delaylater_help'] = '<p>Dersom du angir en tidsforsinkelse her, vil studenten måtte vente angitt tid mellom hvert senere forsøk (etter det andre forsøket).</p>';
$string['deleteattemptcheck'] = 'Er du helt sikker på at du vil slette disse forsøkene fullstendig?';
$string['deleteselected'] = 'Slett valgte';
$string['deletingquestionattempts'] = 'Sletter forsøk';
$string['description'] = 'Beskrivelse';
$string['disabled'] = 'Deaktivert';
$string['displayoptions'] = 'Vis valgmuligheter';
$string['donotuseautosave'] = 'Ikke bruk auto-lagring';
$string['download'] = 'Klikk for å laste ned den eksporterte kategorifila';
$string['downloadextra'] = '(Filen blir også lagret i kursfiler i mappen /backupdata/quiz)';
$string['dragtoafter'] = 'Etter {$a}';
$string['dragtostart'] = 'Til begynnelsen';
$string['duplicateresponse'] = 'Denne innleveringa blir ignorert. Du har gitt et lignende svar tidligere.';
$string['eachattemptbuildsonthelast'] = 'Hvert forsøk bygger på det forrige';
$string['eachattemptbuildsonthelast_help'] = '<p>Hvis det tillates flere forsøk og dette valget settes til \'Ja\' vil hvert
forsøk inneholde resultatene fra det tidligere forsøket. Dette gjør det mulig å fullføre quizen med et visst antall forsøk. </p>
<p>For å vise en ny (blank) quiz for hvert forsøk velger du \'Nei\' her. </p>';
$string['edit_slotdisplaynumber_hint'] = 'Rediger spørsmålsnummer (maks 16 tegn)';
$string['edit_slotdisplaynumber_label'] = 'Ny verdi for {$a}';
$string['editcategories'] = 'Rediger kategorier';
$string['editcategory'] = 'Rediger kategori';
$string['editcatquestions'] = 'Rediger kategorispørsmål';
$string['editingquestion'] = 'Redigerer et spørsmål';
$string['editingquiz'] = 'Rediger quiz';
$string['editingquiz_help'] = 'Når en quiz opprettes er hovedkonseptet:

* Quizen, som inneholder spørsmål over en eller flere sider.
* Testbanken, som har kopier av alle spørsmål organisert i kategorier.
* Tilfeldige spørsmål - en student får da forskjellige spørsmål hver gang de tar quizen og forskjellige studenter får ulike spørsmål.';
$string['editingquiz_link'] = 'mod/quiz/edit';
$string['editingquizx'] = 'Endrer quiz: {$a}';
$string['editmaxmark'] = 'Rediger maksimumspoengsum';
$string['editoverride'] = 'Overstyr endring';
$string['editqcats'] = 'Rediger spørsmålskategorier';
$string['editquestion'] = 'Rediger spørsmål';
$string['editquestions'] = 'Rediger spørsmål';
$string['editquiz'] = 'Endre quiz';
$string['editquizquestions'] = 'Endre quiz-spørsmål';
$string['emailconfirmautosubmitsmall'] = 'Takk for at du sendte inn svarene dine til \'{$a->quizname}\'';
$string['emailconfirmbody'] = 'Hei {$a->username},

Takk for at du sendte inn svarene på \'{$a->quizname}\'
i kurset \'{$a->coursename}\' {$a->submissiontime}.

Denne e-posten bekrefter at vi har mottatt svarene dine.

Du kan åpne denne quizen på {$a->quizurl}.';
$string['emailconfirmbodyautosubmit'] = 'Hei {$a->username},

Tiden for quizen \'{$a->quizname}\' i kurset \'{$a->coursename}\' er utløpt. Svarene dine ble sendt inn automatisk kl. {$a->submissiontime}.

Denne meldingen bekrefter at svarene dine er lagret.

Du kan få tilgang til denne quizen på {$a->quizurl}.';
$string['emailconfirmsmall'] = 'Takk for at du sendte inn dine svar på  \'{$a->quizname}\'';
$string['emailconfirmsubject'] = 'Bekreftelse på innsending av quiz:  {$a->quizname}';
$string['emailmanualgradedbody'] = 'Hei {$a->studentname},

Svarene dine på \'{$a->quizname}\' i kurset \'{$a->coursename}\' på {$a->attempttimefinish} har nå blitt vurdert.

Du vil kunne se poengsummen og tilbakemeldingen din ved å gå til \'{$a->quizurl}\' og gjennomgå forsøket ditt.';
$string['emailmanualgradedsubject'] = 'Forsøket ditt på {$a->quizname} har blitt vurdert';
$string['emailnotifybody'] = 'Hei {$a->username},

{$a->studentname} har fullført quizen
\'{$a->quizname}\' ({$a->quizurl})
i kurset \'{$a->coursename}\'

Du kan se på forsøket her: {$a->quizreviewurl}.';
$string['emailnotifysmall'] = '{$a->studentname} har fullført {$a->quizname}. Se {$a->quizreviewurl}';
$string['emailnotifysubject'] = '{$a->studentname} har fullført {$a->quizname}';
$string['emailoverduebody'] = 'Hei {$a->studentname},

Du påbegynte et forsøk på \'{$a->quizname}\' i kurset \'{$a->coursename}\', men du sendte ikke inn besvarelsen. Det skulle ha vært sendt inn innen {$a->attemptduedate}.

Hvis du fortsatt vil sende inn denne besvarelsen, vennligst gå til {$a->attemptsummaryurl} og klikk på sendknappen. Du må gjøre dette før {$a->attemptgraceend}, ellers vil ikke besvarelsen din telle.';
$string['emailoverduesmall'] = 'Du har ikke sendt inn besvarelsen din til {$a->quizname}. Vennligst gå til {$a->attemptsummaryurl} før {$a->attemptgraceend} hvis du fortsatt vil sende inn besvarelsen.';
$string['emailoverduesubject'] = 'Tiden er utløpt for: {$a->quizname}';
$string['empty'] = 'Tom';
$string['enabled'] = 'Aktivert';
$string['endtest'] = 'Avslutt forsøket';
$string['erroraccessingreport'] = 'Du har ikke tilgang til denne rappoorten';
$string['errorinquestion'] = 'Feil i spørsmålet';
$string['errormissingquestion'] = 'Feil: Systemet mangler spørsmålet med id {$a}';
$string['errornotnumbers'] = 'Feil - svarene må bestå av tall';
$string['errorunexpectedevent'] = 'Uventet eventcode {$a->event} funnet for spørsmålet {$a->questionid} i forsøket {$a->attemptid}.';
$string['essay'] = 'Essay';
$string['essayquestions'] = 'Spørsmål';
$string['eventattemptautosaved'] = 'Quiz-forsøket er autolagret';
$string['eventattemptdeleted'] = 'Quizforsøk slettet';
$string['eventattemptmanualgradingcomplete'] = 'Quizforsøk manuell vurdering fullført';
$string['eventattemptpreviewstarted'] = 'Forhåndsvisning av quiz-forsøk startet';
$string['eventattemptquestionrestarted'] = 'Quiz spørsmålsforsøket er restartet';
$string['eventattemptreviewed'] = 'Quiz.forsøk gjennomgått';
$string['eventattemptsummaryviewed'] = 'Quiz-oppsummering vist';
$string['eventattemptupdated'] = 'Quizforsøk oppdatert';
$string['eventattemptviewed'] = 'Quizforsøk vist';
$string['eventeditpageviewed'] = 'Endre quiz vist';
$string['eventoverridecreated'] = 'Overstyring av quiz opprettet';
$string['eventoverridedeleted'] = 'Overstyring av quiz slettet';
$string['eventoverrideupdated'] = 'Overstyring av quiz oppdatert';
$string['eventpagebreakcreated'] = 'Sideskift opprettet';
$string['eventpagebreakdeleted'] = 'Sideskift fjernet';
$string['eventquestionmanuallygraded'] = 'Spørsmålet er karaktersatt manuelt';
$string['eventquizattemptabandoned'] = 'Quizforsøk avbrutt';
$string['eventquizattemptregraded'] = 'Quizforsøk omberegnet';
$string['eventquizattemptreopened'] = 'Quizforsøket gjenåpnet';
$string['eventquizattemptstarted'] = 'Quizforsøk startet';
$string['eventquizattemptsubmitted'] = 'Quizforsøk sendt';
$string['eventquizattempttimelimitexceeded'] = 'Tidsgrensen for quizen er overskredet';
$string['eventquizgradeupdated'] = 'Quizvurdering oppdatert';
$string['eventquizrepaginated'] = 'Quizen er repaginert';
$string['eventreportviewed'] = 'Quiz-rapport vist';
$string['eventsectionbreakcreated'] = 'Seksjonsskift opprettet';
$string['eventsectionbreakdeleted'] = 'Seksjonsskift fjernet';
$string['eventsectionshuffleupdated'] = 'Seksjonsblanding er oppdatert';
$string['eventsectiontitleupdated'] = 'Seksjonstittel er oppdatert';
$string['eventslotcreated'] = 'Tidspunkt opprettet';
$string['eventslotdeleted'] = 'Tidspunkt slettet';
$string['eventslotdisplayedquestionnumberupdated'] = 'Spørsmålsnummeret som vises på sporet, er oppdatert';
$string['eventslotmarkupdated'] = 'Merke for tidspunkt oppdatert';
$string['eventslotmoved'] = 'Tidspunkt flyttet';
$string['eventslotrequirepreviousupdated'] = 'Tidspunktet krever at foregående oppdatert';
$string['everynquestions'] = 'Hvert {$a}. spørsmål';
$string['everyquestion'] = 'Hvert spørsmål';
$string['everythingon'] = 'Alt på';
$string['existingcategory'] = 'Eksisterende kategori';
$string['exportcategory'] = 'eksportkategori';
$string['exporterror'] = 'En feil oppsto under eksportprosessen';
$string['exportingquestions'] = 'Spørsmål eksporteres til fil';
$string['exportname'] = 'Filnavn';
$string['exportquestions'] = 'Eksporter spørsmål til fil';
$string['extraattemptrestrictions'] = 'Ekstra restriksjoner på forsøkene';
$string['false'] = 'Feil';
$string['feedback'] = 'Tilbakemelding';
$string['feedbackerrorboundaryformat'] = 'Tilbakemeldingsgrenser må settes til enten prosent eller et tall. Grenseverdien {$a}, som du skrev inn, gjenkjennes ikke som gyldig verdi.';
$string['feedbackerrorboundaryoutofrange'] = 'Tilbakemeldingsgrenser må være mellom 0% og 100%. Grenseverdien {$a}, som du skrev inn, er ikke innenfor gyldig område.';
$string['feedbackerrorjunkinboundary'] = 'Du må fylle ut grenseverdiene uten gap.';
$string['feedbackerrorjunkinfeedback'] = 'Du må fylle ut tilbakemeldingsboksene uten gap.';
$string['feedbackerrororder'] = 'Grenseverdier for tilbakemelding må være ordnet med høyeste verdi først. Grenseverdien {$a}, som du skrev inn, er ikke en del av ordnet rekkefølge.';
$string['file'] = 'Fil';
$string['fileformat'] = 'Filformat';
$string['fillcorrect'] = 'Sett inn riktig ord/frase';
$string['filloutnumericalanswer'] = 'Du må legge inn minst ett mulig svar og en feilmargin. Første gyldige svar vil bli brukt til å bestemme karakter og tilbakemelding. Hvis du legger inn tilbakemelding uten svar, vil dette vises til studenter som svarer noe annet enn dine svaralternativer.';
$string['filloutoneanswer'] = 'Du må skrive minst ett riktig svar. Svarfelter som er blanke vil ikke bli brukt. \'*\' kan brukes som jokertegn for å gi treff på alle bokstaver. Første samsvarende svaralternativ blir brukt til å beregne resultat og tilbakemelding,';
$string['filloutthreequestions'] = 'Du må fylle ut minst 3 spørsmål med samsvarende svaralternativer. Du kan legge til ekstra svaralternativer for feil svar ved å la spørsmålsfeltet stå tomt. Er både spørsmåls- og svarfeltet tomt blir de ikke med i spørsmålet.';
$string['fillouttwochoices'] = 'Du må gi minst to valg. Felter som er blanke vil ikke bli brukt.';
$string['finishattemptdots'] = 'Avslutt forsøket...';
$string['finishreview'] = 'Avslutt gjennomgang';
$string['forceregeneration'] = 'tving regenerering';
$string['formatnotfound'] = 'Import/exportformat {$a} fantes ikke';
$string['formulaerror'] = 'Formelfeil!';
$string['fractionsaddwrong'] = 'Karakterene du har satt går ikke opp 100%
<br />De går opp til {$a}%
<br />Vil du gå tilbake og endre dette?';
$string['fractionsnomax'] = 'Et av svarene burde være 100%, slik at det er
<br />mulig å få høyeste karakter.
<br />Vil du gå tilbake og endre dette?';
$string['fromfile'] = 'fra filen:';
$string['functiondisabledbysecuremode'] = 'Den funksjonen er for tiden deaktivert';
$string['generalfeedback'] = 'Generell tilbakemelding';
$string['generalfeedback_help'] = '<p>Feltet "Generell tilbakemelding" i spørsmål er en tekst som skal vises straks studenten har forsøkt seg på spørsmålet. Til forskjell fra vanlig tilbakemelding, som avhenger av spørsmålstypen og svaralternativet som ble valgt, vil "Generell tilbakemelding" vise samme melding til alle studenter.</p>

<p>Du kan styre hvordan generell tilbakemelding skal vises for studentene ved å merke av boksen for "Studentene kan se over" på spørsmålets redigeringsside.</p>

<p>Du kan bruke generell tilbakemelding til å gi studenene noe bakgrunnsinformasjon om kunnskapsområdet de blir testet på - eller til å gi dem lenker til mer informasjon de kan sette seg inn i dersom de ikke forstår spørsmålene.</p>';
$string['gobacktoquiz'] = 'Gå tilbake';
$string['graceperiod'] = 'Utsettelsesperiode for innsending';
$string['graceperiod_desc'] = 'Hvis "Hva som skal skje når tiden går ut" er satt til "Tillat en utsettelsesperiode til å sende inn, men ikke til å endre svar", er dette standard ekstratid som gis.';
$string['graceperiod_help'] = 'Hvis hva som skal skje når tiden går ut er satt til "Tillat en utsettelsesperiode til å sende inn, men ikke til å endre svar", er dette hvor mye ekstra tid som skal gis.';
$string['graceperiodmin'] = 'Siste utsettelsesperiode for innsending';
$string['graceperiodmin_desc'] = 'Det er et potensielt problem helt på slutten av quizen. På den ene siden er det ønskelig å la studentene jobbe med quizen helt til siste sekund - ved hjelp av tidtakeren som sender inn besvarelsen automatisk når tiden går ut. På den andre siden så kan det hende at serveren da blir overbelastet, og bruker en del tid på å behandle bevarelsene. På grunn av dette vil vi ta imot besvarelser så lenge etter at tiden går ut, så studentene ikke blir straffet for at serveren er treg. Studenten kan imidlertid jukse og bruke disse sekundene på å svare på quizen. Du må derfor foreta en avveining ut ifra om du stoler på at serveren din kan tåle belastningen quizen medfører.';
$string['graceperiodtoosmall'] = 'Utsettelsesperioden må være lenger enn {$a}.';
$string['grade'] = 'Karakter';
$string['gradeall'] = 'Vurder alt';
$string['gradeaverage'] = 'Gjennomsnitt av forsøkene';
$string['gradeboundary'] = 'Vurderingsgrense';
$string['gradeessays'] = 'Vurder fritekstene';
$string['gradehighest'] = 'Beste forsøk';
$string['grademethod'] = 'Resultatet vurderes etter';
$string['grademethod_help'] = '<p>
Når quizen tillater flere forsøk fins det ulike måter å beregne de endelige
karakterene.
</p>
<p><b>Høyeste karakter</b></p>
<ul>
<li>
Tellende karakter er det beste av samtlige forsøk.
</li>
</ul>

<p><b>Gjennomsnittelig karakter</b><p>
<ul>
<li>
Tellende karakter er gjennomsnittet av alle forsøkene.
</li>
</ul>

<p><b>Første forsøk</b><p>
<ul>
<li>Tellende karakter er lik karakteren studentene/elevene får på det <b>første
</b>forsøket. (De andre regnes ikke med). </li>
</ul>

<p><b>Siste forsøk</b><p>
<ul>
<li>Tellende karakter er lik karakteren studentene/elevene får på det <b>siste</b>
forsøket. (De andre regnes ikke med). </li>
</ul>';
$string['gradesdeleted'] = 'Quizresultatene er slettet';
$string['gradesofar'] = '{$a->method}: {$a->mygrade} / {$a->quizgrade}.';
$string['gradetopassmustbeset'] = 'Karakteren for bestått kan ikke være null da denne quizen er satt opp til å kreve en bestått-karakter. Vennligst angi en verdi større enn null.';
$string['gradetopassnotset'] = 'Denne quizen har ikke en ståkarakter. Du kan sette en ståkarakter i Karakter-seksjonen i quizinnstillingen.';
$string['gradetopassoutof'] = 'Karakter for bestått: {$a->grade} av {$a->maxgrade}';
$string['gradingdetails'] = 'Poeng for dette svaret: {$a->raw}/{$a->max}.';
$string['gradingdetailsadjustment'] = 'Med tidligere straffepoeng blir dette <strong>{$a->cur}/{$a->max}</strong>';
$string['gradingdetailspenalty'] = 'Denne innleveringen ble pålagt et poengtrekk på {$a}.';
$string['gradingdetailszeropenalty'] = 'Denne innleveringa hadde ingen straffepoeng';
$string['gradingmethod'] = 'Resultatet vurderes etter: {$a}';
$string['groupoverrides'] = 'Overstyringer for gruppe';
$string['groupoverridesdeleted'] = 'Gruppeoverstyringer slettet';
$string['groupsnone'] = 'Ingen grupper du har tilgang til';
$string['guestsno'] = 'Beklager, gjester kan ikke se eller ta quizer.';
$string['hidebreaks'] = 'Skjul sideskift';
$string['hidereordertool'] = 'Skjul organiseringsverktøyet';
$string['history'] = 'Responshistorikk:';
$string['howquestionsbehave_desc'] = 'Standard innstilling for hvordan spørsmål oppfører seg i en quiz.';
$string['imagedisplay'] = 'Bilde som skal vises';
$string['import_help'] = 'Denne funksjonen lar deg importere spørsmål fra en tekstfil.

Dersom filen inneholder tegn utover ASCII-tegnsettet må det støtte UTF-8 kodesettet. Vær spesielt oppmerksom på tekstfiler fra Microsoft Office programmene siden de svært ofte bruker helt egne tegnsett som da ikke importeres korrekt.

Import- og eksportformatene er moduler som kan kobles til. Andre valgfrie formater kan være tilgjengelig på moodle.org sin portal.';
$string['import_link'] = 'question/import';
$string['importcategory'] = 'importkategori';
$string['importerror'] = 'Det oppstod en feil under importen';
$string['importfilearea'] = 'Importer fra en fil som allerede er lastet opp...';
$string['importfileupload'] = 'Importer ved å laste opp en fil...';
$string['importfromthisfile'] = 'Importer fra denne filen';
$string['importingquestions'] = 'Importerer {$a} spørsmål fra filen';
$string['importmax10error'] = 'Det er en feil i spørsmålet. Du kan ikke ha mer enn ti svar.';
$string['importmaxerror'] = 'Det er en fei i spørsmålet. Det er for mange svar.';
$string['importquestions'] = 'Importer spørsmål fra fil';
$string['inactiveoverridehelp'] = '* Denne overstyringen er inaktiv fordi brukerens tilgang til aktiviteten er begrenset. Dette kan skyldes gruppe- eller rolletildelinger, andre tilgangsrestriksjoner eller at aktiviteten er skjult.';
$string['incorrect'] = 'Feil';
$string['indicator:cognitivedepth'] = 'Kognitiv quiz';
$string['indicator:cognitivedepth_help'] = 'Denne indikatoren er basert på den kognitive dybden vist av studentene i en Quiz-aktivitet.';
$string['indicator:cognitivedepthdef'] = 'Quiz - kognitivt engasjement';
$string['indicator:cognitivedepthdef_help'] = 'Deltakeren har nådd denne prosentandelen av det kognitive engasjementet som tilbys av Quiz-aktivitetene i løpet av dette analyseintervallet (Nivåer = Ingen visning, Vis, Send inn, Se tilbakemelding, Kommenter tilbakemelding, Send inn igjen etter å ha sett tilbakemelding)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Sosial quiz';
$string['indicator:socialbreadth_help'] = 'Denne indikatoren er basert på den sosiale bredden vist av studenten i en Quiz-aktivitet.';
$string['indicator:socialbreadthdef'] = 'Quiz - sosialt engasjement';
$string['indicator:socialbreadthdef_help'] = 'Deltakeren har nådd denne prosentandelen av det sosiale engasjementet som tilbys av Quiz-aktivitetene i løpet av dette analyseintervallet (Nivåer = Ingen deltakelse, deltaker alene, deltaker med andre)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['indivresp'] = 'De Individuelle svarene på hvert spørsmål';
$string['info'] = 'Informasjon';
$string['infoshort'] = 'i';
$string['initialnumfeedbacks'] = 'Innledende antall felt for generelle tilbakemeldinger';
$string['initialnumfeedbacks_desc'] = 'Når du oppretter en ny quiz, får du dette antallet felt for generelle tilbakemeldinger. Når quizen er opprettet viser dette feltet antallet felt for generelle tilbakemeldinger. Innstillingen må være minst 1.';
$string['inprogress'] = 'Pågår';
$string['introduction'] = 'Beskrivelse';
$string['invalidattemptid'] = 'Ingen slike forsøks ID-er finnes';
$string['invalidcategory'] = 'KategoriID-en er ugyldig';
$string['invalidoverrideid'] = 'Ugyldig overstyrings ID';
$string['invalidquestionid'] = 'Ugyldig spørsmåls ID';
$string['invalidquizid'] = 'Ugyldig quiz-ID';
$string['invalidrandomslot'] = 'Ugyldig id for tilfedlig spørsmål';
$string['invalidsource'] = 'Kilden er ikke godkjent som gyldig';
$string['invalidsourcetype'] = 'Ugyldig kildetype';
$string['invalidstateid'] = 'Ugyldig tilstands ID';
$string['lastanswer'] = 'Det siste svaret ditt var';
$string['layout'] = 'Utseende';
$string['layoutasshown'] = 'Sideutseende slik det vises';
$string['layoutasshownwithpages'] = 'Sideoppsett som vist. <small>(Automatisk ny side for hvert {$a} spørsmål.)</small>';
$string['layoutshuffledandpaged'] = 'Spørsmålene vises i tilfeldig rekkefølge med {$a} spørsmål på hver side.';
$string['layoutshuffledsinglepage'] = 'Spørsmålene vises i tilfeldig rekkefølge, alle på samme side.';
$string['link'] = 'Lenke';
$string['listitems'] = 'Opplisting av enheter i hver quiz';
$string['literal'] = 'Bokstav';
$string['loadingquestionsfailed'] = 'Lastingen av spørsmålene mislykkes: {$a}';
$string['makecopy'] = 'Lagre som nytt spørsmål';
$string['managetypes'] = 'Administrere spørsmålstyper og servere';
$string['manualgradequestion'] = 'Gjør en manuell vurdering av spørsmål {$->question} i {$a->quiz} av {$->user}';
$string['manualgrading'] = 'Karakersetting';
$string['mark'] = 'Sjekk dette svaret';
$string['markall'] = 'Sjekk alt';
$string['marks'] = 'Poeng';
$string['marks_help'] = 'Karakteren oppnådd for hvert spørsmål og den totale poengsummen for forsøk. Du kan bare velge Merker hvis Maksimal merking er valgt.';
$string['match'] = 'Sammenfallende';
$string['matchanswer'] = 'Sammenfallende svar';
$string['matchanswerno'] = 'Samsvarerende {$a}';
$string['max'] = 'Maks';
$string['maxmark'] = 'Maksimumspoengsum';
$string['maxmarks'] = 'Max Marks';
$string['maxmarks_help'] = 'Maksimal karakter tilgjengelig for hvert spørsmål.';
$string['messageprovider:attempt_grading_complete'] = 'Melding om at ditt forsøk er vurdert';
$string['messageprovider:attempt_overdue'] = 'Advarsel nårquizforsøket har gått ut på tid';
$string['messageprovider:confirmation'] = 'Bekreftelse på dine egne quiz-forsøk';
$string['messageprovider:submission'] = 'Melding om studenters quiz-forsøk';
$string['min'] = 'Min';
$string['minutes'] = 'Minutter';
$string['missingcorrectanswer'] = 'Riktig svar må spesifiseres';
$string['missingitemtypename'] = 'Mangler navn';
$string['missingquestion'] = 'Dette spørsmålet ser ut til å ha blitt slettet';
$string['modulename'] = 'Quiz';
$string['modulename_help'] = 'Quizmodulen lar læreren designe og opprette quizer som kan bestå av flervalg, samsvarende, kortsvar, numeriske og andre spørsmålstyper.

Læreren kan velge å la studentene ta quizen flere ganger, med omstokket spørsmålsrekkefølge eller spørsmålene vilkårlig valgt fra testbanken. Grense for antall forsøk kan settes.

Hvert forsøk blir automatisk vurdert (med unntak av fritekstspørsmål), og karakteren blir registrert i karakterboken.

Læreren kan velge om og når hint, tilbakemeldinger og korrekte svar skal vises til studentene.

Quizer kan brukes

* som kurseksamener
* som minitester til leseoppgaver eller på slutten av et emne
* som eksamensøving basert på spørsmål fra tidligere eksamensoppgaver
* til å gi umiddelbare tilbakemeldinger om resultater/prestasjoner
* til egenvurdering';
$string['modulename_link'] = 'mod/quiz/view';
$string['modulenameplural'] = 'Quizer';
$string['moveselectedonpage'] = 'Flytt valgte spørsmål til side: {$a}';
$string['multichoice'] = 'Flere svaralternativer';
$string['multipleanswers'] = 'Velg minst ett svar';
$string['mustbesubmittedby'] = 'Dette forsøket må sendes innen: {$a}.';
$string['name'] = 'Navn';
$string['navigatenext'] = 'Neste side';
$string['navigateprevious'] = 'Forrige side';
$string['navmethod'] = 'Navigeringsmetode';
$string['navmethod_free'] = 'Fri';
$string['navmethod_help'] = 'Når sekvensiell navigering er aktivert, må studenten gå igjennom quizen i rekkefølgen quizen er satt opp. Studenten kan m.a.o. ikke gå tilbake til foregående sider eller hoppe fremover.';
$string['navmethod_seq'] = 'Sekvensiell';
$string['navnojswarning'] = 'Advarsel: disse lenkene vil ikke lagre dine svar. Bruk Neste-knappen på bunnen av siden.';
$string['neverallononepage'] = 'Aldri, alle spørsmålene på en side';
$string['newattemptfail'] = 'Feil: Kunne ikke starte et nytt quizforsøk.';
$string['newcategory'] = 'Ny kategori';
$string['newpage'] = 'Ny side';
$string['newpage_help'] = '<p>Dersom quizen er lang kan det være en fordel å dele quizen opp i flere sider begrenset av antall spørsmål pr. side. Når du legger til spørsmål vil sideskiftet endres automatisk avhengig av innstillingen du velger her. Du kan også endre sideskift manuelt senere.</p>';
$string['newpageevery'] = 'Automatisk starte en ny side';
$string['newsectionheading'] = 'Ny overskrift';
$string['noanswers'] = 'Ingen svar ble valgt!';
$string['noattempts'] = 'Ingen forsøk gjort på denne quizen.';
$string['noattemptsfound'] = 'Ingen forsøk funnet';
$string['noattemptstoshow'] = 'Ingen forsøk å vise';
$string['nocategory'] = 'Ugyldig eller ingen kategori oppgitt';
$string['noclose'] = 'Ingen stengningsdato';
$string['nocommentsyet'] = 'Ingen kommentarer ennå.';
$string['noconnection'] = 'Det er for øyeblikket ingen forbindelse til en nett-tjeneste som kan behandle dette spørsmålet. Vennligst kontakt din administrator.';
$string['nodataset'] = 'ingentingh - ugyldig wild card';
$string['nodatasubmitted'] = 'Ingen data ble sendt.';
$string['noessayquestionsfound'] = 'Fant ingen manuelt vurderte spørsmål';
$string['nogradewarning'] = 'Denne quizen er ikke vurdert, så du kan ikke legge inn generell tilbakemelding som differensieres på resultatene.';
$string['nomoreattempts'] = 'Ingen flere forsøk tillatt';
$string['none'] = 'Ingen';
$string['noopen'] = 'Ingen åpningsdato';
$string['nooverridedata'] = 'Du må overstyre minst en av quizens innstillinger.';
$string['nopossibledatasets'] = 'Ingen mulige datasett';
$string['noquestionintext'] = 'Spørsmålsteksten inneholder ingen luker.';
$string['noquestions'] = 'Ingen spørsmål er lagt til enda';
$string['noquestionsfound'] = 'Ingen spørsmål funnet';
$string['noquestionsinquiz'] = 'Det er ingen spørsmål i denne quizen.';
$string['noquestionsnotinuse'] = 'Dette tilfeldige spørsmålet er ikke i bruk siden kategorien er tom.';
$string['noquestionsonpage'] = 'Tom side';
$string['noresponse'] = 'Ingen forsøk gjort';
$string['noreview'] = 'Du har ikke tillatelse til å lese disse svarene';
$string['noreviewattempt'] = 'Du har ikke tillatelse til å se gjennom dette forsøket.';
$string['noreviewshort'] = 'Gjennomgang ikke tillatt';
$string['noreviewuntil'] = 'Du får ikke se svarene før {$a}';
$string['noreviewuntilshort'] = 'Tilgjengelig {$a}';
$string['noscript'] = 'Du må skru på JavaScript for å fortsette';
$string['notavailabletostudents'] = 'NB: Denne quizen er for øyeblikket ikke tilgjengelig for studenter.';
$string['notenoughrandomquestions'] = 'Det er ikke mange nok spørsmål i kategorien {$a->category} til at du kan opprette spørsmålet {$a->name} ({$a->id}).';
$string['notenoughsubquestions'] = 'Det er ikke definert nok mange delspørsmål!<br />Vil du gå tilbake og endre dette?';
$string['notifyattemptsgradedtask'] = 'Send varsler om quizforsøk som nå er vurdert';
$string['notimedependentitems'] = 'Tidsavhengige elementer støttes foreløpig ikke i quizmodulen. Som en midlertidig løsning kan du sette en tidsgrense for hele quizen. Ønsker du å velge et annet element (eller uansett bruke gjeldende)?';
$string['notyetgraded'] = 'Karakter foreløpig ikke satt';
$string['notyetviewed'] = 'Ikke vist foreløpig';
$string['notyourattempt'] = 'Dette er ikke ditt forsøk!';
$string['noview'] = 'Innloggede brukere har ikke tilgang til å se denne quizen';
$string['numattempts'] = '{$a->studentnum} {$a->studentstring} har gjort {$a->attemptnum} forsøk';
$string['numberabbr'] = '#';
$string['numerical'] = 'Numerisk';
$string['numquestionsx'] = 'Spørsmål: {$a}';
$string['oneminute'] = '1 minutt';
$string['onlyteachersexport'] = 'Bare lærere kan eksportere spørsmål';
$string['onlyteachersimport'] = 'bare lærere med redigeringstilgang kan importere spørsmål';
$string['onthispage'] = 'Denne siden';
$string['open'] = 'Ikke besvart';
$string['openafterclose'] = 'Kan ikke oppdatere quizen. Du har spesifisert en startdato som er etter sluttdatoen.';
$string['openclosedatesupdated'] = 'Quizens tilgangsdatoer er oppdatert';
$string['optional'] = 'valgfritt';
$string['orderandpaging'] = 'Rekkefølge og sidefordeling';
$string['orderandpaging_help'] = 'Tallene 10,20,30,... overfor hvert spørsmål indikerer sorteringsrekkefølgen. Tallene øker i steg på 10 for å gi plass til spørsmål som måtte bli lagt til senere. For å omorganisere spørsmålsrekkefølgen kan du endre nummeret og deretter klikke på knappen "Omorganiser spørsmålene".

Du legger til sideskift etter et spørsmål ved å merke av avkrysningsboksen ved siden av spørsmålet og deretter  knappen for "Legg til sideskift etter valgte spørsmål"

For å fordele spørsmålene over et antall sider kan du klikke på Omorganiser-knappen og velge ønsket antall spørsmål pr. side.';
$string['orderingquiz'] = 'Rekkefølge og sidefordeling';
$string['orderingquizx'] = 'Rekkefølge og sidetall: {$a}';
$string['outcomesadvanced'] = 'Læringsutbytte hører til under avanserte innstillinger.';
$string['outof'] = '{$a->grade} av maksimalt {$a->maxgrade}';
$string['outofpercent'] = '{$a->grade} av maksimum {$a->maxgrade} ({$a->percent}%)';
$string['outofshort'] = '{$a->grade}/{$a->maxgrade}';
$string['overallfeedback'] = 'Tilbakemelding på quizen';
$string['overallfeedback_help'] = '<p>Den generelle tilbakemeldingen er en tekst som vises for studentene straks de har fullført et quizforsøk. Den teksten som vises kan være avhengig av poengsummen de har fått.</p>

<p>F.eks. dersom du skriver inn:</p>

<p>Poenggrense: 100%<br />
Tilbakemelding: Utmerket!<br />
Poenggrense: 40%<br />
Tilbakemelding: Vennligst se over denne ukens lærestoff en gang til.<br />
...<br />
Poenggrense: 0%</p>

<p>Når studenter får en poengsum mellom 100% og 40% vil de få meldingen "Utmerket" og studenter med poengsum mellom 39.99% og 0% vil få den andre meldingen. Det er altså teksten mellom øvre og nedre grense som vises for hvert poengsteg du definerer.</p>

<p>Poenggrensene kan angis enten som prosent eller et tall. Dersom quizen har maks 10 poeng vil en poenggrense på 7 bety  at de må ha 7/10 eller bedre.</p>';
$string['overdue'] = 'For sent';
$string['overduehandling'] = 'Når tiden går ut';
$string['overduehandling_desc'] = 'Hva skal skje som standard hvis en student ikke leverer inn quizen før tiden går ut.';
$string['overduehandling_help'] = 'Denne innstillingen bestemmer hva som skjer hvis studenten ikke sender inn sitt quizforsøk før tiden går ut. Hvis studenten jobber aktivt med quizen der og da, vil nedtellingstidtakeren alltid sende inn forsøket automatisk for studenten, men hvis han/hun er logget ut, bestemmer denne innstillingen hva som skjer.';
$string['overduehandling_link'] = 'mod/quiz/timing';
$string['overduehandlingautoabandon'] = 'Besvarelser må leveres inn før tiden går ut, ellers blir de ikke regnet med.';
$string['overduehandlingautosubmit'] = 'Åpne besvarelser blir sendt inn automatisk';
$string['overduehandlinggraceperiod'] = 'Det er en utsettelsesperiode der åpne forsøk kan leveres inn men ingen flere spørsmål kan besvares.';
$string['overduemustbesubmittedby'] = 'Tiden har nå gått ut for dette forsøket. Besvarelsen skulle allerede ha vært levert inn. Hvis du vil ha karakter på dette forsøket, må du sende det inn innen {$a}. Hvis du ikke sender det inn innen dette tidspunktet, vil ikke noen karakter fra dette forsøket telles med.';
$string['override'] = 'Overstyr';
$string['overridedeletegroupsure'] = 'Er du sikker på at du vil slette overstyringen for gruppen {$a}?';
$string['overridedeleteusersure'] = 'Er du sikker på at du vil slette overstyringen for brukeren {$a}?';
$string['overridegroup'] = 'Overstyr gruppe';
$string['overridegroupeventname'] = '{$a->quiz} - {$a->group}';
$string['overrides'] = 'Overstyringer';
$string['overridesforquiz'] = 'Overstyringer av innstillinger: {$a}';
$string['overridesnoneforgroups'] = 'Ingen gruppeoverstyringer er opprettet for denne quizen.';
$string['overridesnoneforusers'] = 'Ingen brukeroverstyringer er opprettet for denne quizen.';
$string['overridessummary'] = 'Overstyringer eksisterer ({$a})';
$string['overridessummarygroup'] = 'Grupper: {$a}';
$string['overridessummarythisgroup'] = 'Innstillingsoverstyringer finnes ({$a}) for denne gruppen';
$string['overridessummaryuser'] = 'Brukere: {$a}';
$string['overridessummaryyourgroups'] = 'Innstillingsoverstyringer finnes ({$a}) for dine grupper';
$string['overrideuser'] = 'Overstyr bruker';
$string['overrideusereventname'] = '{$a->quiz} - Overstyring';
$string['page-mod-quiz-attempt'] = 'Oversikt over quizforsøk';
$string['page-mod-quiz-edit'] = 'Rediger quizsiden';
$string['page-mod-quiz-report'] = 'En quizrapportside';
$string['page-mod-quiz-review'] = 'Vis quizforsøk';
$string['page-mod-quiz-summary'] = 'Oppsummeringsside for quizforsøk';
$string['page-mod-quiz-view'] = 'Quizens informasjonsside';
$string['page-mod-quiz-x'] = 'Alle sider i quizmodulen';
$string['pageshort'] = 'S';
$string['pagesize'] = 'Sidestørrelse';
$string['parent'] = 'Overordnet';
$string['parentcategory'] = 'Overordnet kategori';
$string['parsingquestions'] = 'Inspiserer spørsmål fra importfila';
$string['partiallycorrect'] = 'Delvis riktig';
$string['penalty'] = 'Poengtrekk';
$string['penaltyscheme'] = 'Bruk straffepoeng';
$string['penaltyscheme_help'] = '<p>Hvis en quiz kjøres i \'Sjekk svar modus\' kan studentene prøve mer enn en gang når de svarer feil. I slike tilfeller ønsker du kanskje å benytte en straffefaktor som trekker noe fra maks poengsum hver gang de svarer feil. Hvor mye som skal trekkes fra bestemmes individuelt for hvert spørsmål når du oppretter eller redigerer spørsmålene.</p>

<p>Denne innstillingen har ingen innvirkning på quizer som ikke kjører i \'Sjekk svar modus\'.</p>';
$string['percentcorrect'] = 'Prosent riktig';
$string['pleaseclose'] = 'Forespørselen din har blitt behandlet. Du kan lukke dette vinduet.';
$string['pluginadministration'] = 'Quiz-administrasjon';
$string['pluginname'] = 'Quiz';
$string['popup'] = 'Vis quizen i et "sikkert" vindu';
$string['popupblockerwarning'] = 'Denne quizen kjøres i sikkermodus, dette betyr at du må ta quizen i et "sikkert" vindu. Vennligst slå av pop-up blokkeringen i nettleseren. Tusen takk.';
$string['popupnotice'] = 'Studentene ser denne quizen i et sikkert vindu';
$string['preprocesserror'] = 'Det oppstod en feil under pre-prosesseringen!';
$string['preview'] = 'Forhåndsvisning';
$string['previewquestion'] = 'Forhåndsvisning av spørsmålet';
$string['previewquiz'] = 'Forhåndsvis quiz {$a}';
$string['previewquiznow'] = 'Ta quizen nå';
$string['previewquizstart'] = 'Forhåndsvis quiz';
$string['previous'] = 'Tidligere tilstand';
$string['privacy:metadata:core_question'] = 'Quizaktiviteten lagrer spørsmålsbrukinformasjon i undersystemet core_question';
$string['privacy:metadata:quiz'] = 'Aktiviteten Quiz bruker quizrapporter';
$string['privacy:metadata:quiz_attempts'] = 'Detlajer om hvert quizforsøk';
$string['privacy:metadata:quiz_attempts:attempt'] = 'Forsøksnummer.';
$string['privacy:metadata:quiz_attempts:currentpage'] = 'Den nåværende siden brukeren er på.';
$string['privacy:metadata:quiz_attempts:gradednotificationsenttime'] = 'Når brukeren ble varslet om at manuell vurdering av forsøket deres var fullført';
$string['privacy:metadata:quiz_attempts:preview'] = 'Om dette er en forhåndsvisning av quizen.';
$string['privacy:metadata:quiz_attempts:state'] = 'Forsøksttus.';
$string['privacy:metadata:quiz_attempts:sumgrades'] = 'Summen av karakterer i forsøket.';
$string['privacy:metadata:quiz_attempts:timecheckstate'] = 'Tidspunktet statusen ble sjekket';
$string['privacy:metadata:quiz_attempts:timefinish'] = 'Når forsøket ble fullført.';
$string['privacy:metadata:quiz_attempts:timemodified'] = 'Når forsøket ble oppdatert.';
$string['privacy:metadata:quiz_attempts:timemodifiedoffline'] = 'Når forsøket ble oppdatert via en offline oppdatering.';
$string['privacy:metadata:quiz_attempts:timestart'] = 'Når forsøket ble startet';
$string['privacy:metadata:quiz_grades'] = 'Detaljer om totalkarakter for denne quizen.';
$string['privacy:metadata:quiz_grades:grade'] = 'Totalkarakteren for quizen.';
$string['privacy:metadata:quiz_grades:quiz'] = 'Quizen som ble karaktersatt';
$string['privacy:metadata:quiz_grades:timemodified'] = 'Tidspunktet karakteren ble endret.';
$string['privacy:metadata:quiz_grades:userid'] = 'Brukeren som fikk en karakter.';
$string['privacy:metadata:quiz_overrides'] = 'Detaljer om overstyringer for denne quizen.';
$string['privacy:metadata:quiz_overrides:quiz'] = 'Quiz med overstyringsinformasjon.';
$string['privacy:metadata:quiz_overrides:timeclose'] = 'Nytt sluttidspunkt for quizen';
$string['privacy:metadata:quiz_overrides:timelimit'] = 'Ny tidsgrense for quizen.';
$string['privacy:metadata:quiz_overrides:timeopen'] = 'Nytt åpningstidspunkt for quizen.';
$string['privacy:metadata:quiz_overrides:userid'] = 'Brukeren som blir oversyrt.';
$string['privacy:metadata:quizaccess'] = 'Aktiviteten Quiz bruker quiztilgangsregler';
$string['publish'] = 'Publiser';
$string['publishedit'] = 'For å legge til eller redigere spørsmål i denne kategorien må ha tillatelse fra kurset som har publisert den.';
$string['qbrief'] = 'Q. {$a}';
$string['qname'] = 'navn';
$string['qti'] = 'IMS QTI-format';
$string['qtypename'] = 'type, navn';
$string['question'] = 'Spørsmål';
$string['questionbank'] = 'fra testbanken';
$string['questionbankmanagement'] = 'Spørsmålsbank administrasjon';
$string['questionbehaviour'] = 'Quiz-oppførsel';
$string['questioncats'] = 'Spørsmålskategorier';
$string['questiondeleted'] = 'Dette spørsmålet er slettet. Vennligst kontakt læreren din.';
$string['questiondependencyadd'] = 'Ingen restriksjoner for når spørsmål {$a->thisq} kan forsøkes • Klikk for å endre';
$string['questiondependencyfree'] = 'Ingen restriksjoner for dette spørsmålet';
$string['questiondependencyremove'] = 'Spørsmålet {$a->thisq} kan ikke besvares før det forrige spørsmålet {$a->previousq} er besvart • Klikk for å endre';
$string['questiondependsonprevious'] = 'Dette spørsmålet kan ikke besvares før det forrige spørsmålet er besvart';
$string['questiondraftonly'] = 'For spørsmålet \'{$a}\' er alle versjoner utkastmodus og kan ikke brukes. Gå til spørsmålsbanken og endre status til Klar.';
$string['questiondraftwillnotwork'] = 'Dette spørsmålet har alle versjoner i utkastmodus. Quizen vil ikke fungerer med dette spørsmålet. Fjern spørsmålet fra quizen eller gå til spørsmålsbanken og endre status til Klar.';
$string['questioninuse'] = 'Spørsmålet \'{$a}\' er i bruk:';
$string['questionmissing'] = 'Spørsmål for denne sesjonen mangler';
$string['questionname'] = 'Spørsmålsnavn';
$string['questionnonav'] = '<span class="accesshide">Spørsmål </span>{$a->number}<span class="accesshide"> {$a->attributes}</span>';
$string['questionnonavinfo'] = '<span class="accesshide">Informasjon </span>{$a->number}<span class="accesshide"> {$a->attributes}</span>';
$string['questionnotloaded'] = 'Spørsmål {$a} har ikke blir lastet fra databasen';
$string['questionorder'] = 'Spørsmålsrekkefølge';
$string['questionposition'] = 'Ny posisjon i rekkefølgen for spørsmål {$a}';
$string['questions'] = 'Spørsmål';
$string['questionsetpreview'] = 'Forhåndsvisning';
$string['questionsinclhidden'] = 'Spørsmål (inkludert skjulte)';
$string['questionsinthisquiz'] = 'Spørsmål i denne quizen';
$string['questionsmatchingfilter'] = 'Spørsmål som matcher dette filtere';
$string['questionsperpage'] = 'Spørsmål pr.side';
$string['questionsperpageselected'] = 'Spørsmål pr side er angitt så sidefordelingen er reparert. Som resultat er sidekontrollene deaktivert. Du kan endre dette i {$a}';
$string['questionsperpagex'] = 'Spørsmål pr. side: {$a}';
$string['questiontext'] = 'Spørsmålstekst';
$string['questiontextisempty'] = '[Manglende spørsmålstekst]';
$string['questiontype'] = 'Spørsmålstype';
$string['questiontypesetupoptions'] = 'Oppsettsmuligheter for spørsmålstyper:';
$string['questionversion'] = 'v{$a}';
$string['questionversionlatest'] = 'v{$a} (siste)';
$string['quiz:addinstance'] = 'Legg til ny quiz';
$string['quiz:attempt'] = 'Quizforsøk';
$string['quiz:deleteattempts'] = 'Slett quizforsøk';
$string['quiz:emailconfirmsubmission'] = 'Motta e-postbekreftelse ved fullføring av egne Quiz-forsøk.';
$string['quiz:emailnotifyattemptgraded'] = 'Motta varsel når forsøket ditt har blitt vurdert';
$string['quiz:emailnotifysubmission'] = 'Motta e-postvarsel ved fullføring av studenters Quiz-forsøk';
$string['quiz:emailwarnoverdue'] = 'Få e-postvarsel når et quizforsøk er på overtid';
$string['quiz:grade'] = 'Vurder quizer manuelt';
$string['quiz:ignoretimelimits'] = 'Ignorer quizens tidsgrense';
$string['quiz:manage'] = 'Administrer quizer';
$string['quiz:manageoverrides'] = 'Administrere quizoverstyringer';
$string['quiz:preview'] = 'Forhåndsvis quizer';
$string['quiz:regrade'] = 'Revurder quizforsøkene';
$string['quiz:reopenattempts'] = 'Gjenåpne aldri innsendte quizforsøk';
$string['quiz:reviewmyattempts'] = 'Vis dine egne forsøk';
$string['quiz:view'] = 'Vis quizinformasjon';
$string['quiz:viewoverrides'] = 'VIs quiz innstillingsoverstyringer';
$string['quiz:viewreports'] = 'Vis quizrapporter';
$string['quizavailable'] = 'Quizen er tilgjengelig til: {$a}';
$string['quizclose'] = 'Avslutt denne quizen';
$string['quizclosed'] = 'Denne quizen avsluttes {$a}';
$string['quizcloses'] = 'Quizen avsluttes';
$string['quizcloseson'] = 'Denne quizen vil stenges {$a}.';
$string['quizeventcloses'] = '{$a} stenger';
$string['quizeventopens'] = '{$a} åpner';
$string['quizisclosed'] = 'Denne quizen er stengt';
$string['quizisclosedwillopen'] = 'Quizen er stengt (åpner {$a})';
$string['quizisopen'] = 'Denne quizen er åpen';
$string['quizisopenwillclose'] = 'Quizen åpen (stenger {$a})';
$string['quiznavigation'] = 'Oversikt';
$string['quizopen'] = 'Åpne quiz';
$string['quizopenclose'] = 'Datoer for å åpne og stenge';
$string['quizopenclose_help'] = 'Studenter kan bare starte sine forsøk etter åpningstidspunktet, og de må fullføre dem før stengetidspunktet.';
$string['quizopenclose_link'] = 'mod/quiz/timing';
$string['quizopened'] = 'Denne quizen er åpen.';
$string['quizopenedon'] = 'Quizen åpnet {$a}';
$string['quizopens'] = 'Quizen åpnes';
$string['quizopenwillclose'] = 'Denne quizen er åpen, og vil stenge {$a}';
$string['quizordernotrandom'] = 'Quizrekkefølgen er ikke satt til tilfeldig';
$string['quizorderrandom'] = '* Quizrekkefølgen er satt til tilfeldig';
$string['quizreport'] = 'Quizrapport';
$string['quizsettings'] = 'Quizinnstillinger';
$string['quiztimer'] = 'Tidtaker for quiz';
$string['quizwillopen'] = 'Denne quizen vil åpne {$a}';
$string['random'] = 'Tilfeldig spørsmål';
$string['randomcatwithsubcat'] = '{$a} og underkategorier';
$string['randomcoursecatwithsubcat'] = 'Enhver kategori under kurskategori {$a}';
$string['randomcoursewithsubcat'] = 'Enhver kategori i dette kurset';
$string['randomcreate'] = 'Lag tilfeldige spørsmål';
$string['randomediting'] = 'Redigerer et tilfeldig spørsmål';
$string['randomfaultynosubcat'] = 'Feil på spørsmål';
$string['randomfromcategory'] = 'Tilfeldig spørsmål fra kategorien: ';
$string['randomfromexistingcategory'] = 'Tilfeldige spørsmål fra en eksisterende kategori';
$string['randomfromunavailabletag'] = '{$a} (utilgjengelig)';
$string['randommodulewithsubcat'] = 'Enhver kategori i denne quizen';
$string['randomnosubcat'] = 'Spørsmål fra bare denne kategorien - ikke underkategorier.';
$string['randomnumber'] = 'Antall tilfeldige spørsmål';
$string['randomqname'] = 'Tilfeldig spørsmål basert på filtertilstand';
$string['randomqnamecat'] = 'Tilfeldig ({$a->category}) basert på filterbetingelser';
$string['randomqnamecattags'] = 'Tilfeldig ({$a->category}) basert på filterbetingelser med tagger: {$a->tags}';
$string['randomqnametags'] = 'Tilfeldig spørsmål basert på filtertilstand med tagger: {$a}';
$string['randomquestion'] = 'Tilfeldig spørsmål';
$string['randomquestion_help'] = 'Et tilfeldig spørsmål er en måte å sette inn et tilfeldig valgt spørsmål fra en spesifikk kategori eller med en spesifikk tag inn i en aktivitet.';
$string['randomquestiontags'] = 'Tagger';
$string['randomquestiontags_help'] = 'Du kan begrense utvelgelseskriteriet videre med å spesifisere spørsmålstagger her. Tilfeldig spørsmål vil da velges blant spørsmålene med denne taggen.';
$string['randomquestionusinganewcategory'] = 'Tilfeldige spørsmål fra en ny kategori';
$string['randomsystemwithsubcat'] = 'Enhver global kategori';
$string['randomwithsubcat'] = 'Spørsmål fra denne kategorien med underkategorier.';
$string['readytosend'] = 'Du er i ferd med å sende svarene dine til vurdering. Er du sikker?';
$string['reattemptquiz'] = 'Ta quizen på nytt';
$string['recentlyaddedquestion'] = 'Nylig tillagte spørsmål';
$string['recurse'] = 'Ta også med spørsmål fra underkategorier';
$string['redoesofthisquestion'] = 'Andre spørsmål forsøkt her: {$a}';
$string['redoquestion'] = 'Prøv et annet lignende spørsmål';
$string['regrade'] = 'Regn om alle forsøk';
$string['regradecomplete'] = 'Alle forsøk er regnet om';
$string['regradecount'] = '{$a->changed} av {$a->attempt} karakterer ble endret';
$string['regradedisplayexplanation'] = 'Forsøk som endres ved oppdatering av karakter blir vist som lenker i spørsmålsvinduet';
$string['regradenotallowed'] = 'Du har ikke tillatelse til å endre vurderingene i denne quizen';
$string['regradingquestion'] = 'Oppdatert karakter for "{$a}"';
$string['regradingquiz'] = 'Ny beregning av quizen "{$a}"';
$string['remove'] = 'Fjern';
$string['removeallgroupoverrides'] = 'Slett alle gruppeoverstyringer';
$string['removeallquizattempts'] = 'Slett alle quizforsøk';
$string['removealluseroverrides'] = 'Slett alle brukeroverstyringer';
$string['removeemptypage'] = 'Fjern tom side';
$string['removepagebreak'] = 'Fjern sideskift';
$string['removeselected'] = 'Fjern valgte';
$string['rename'] = 'Nytt navn';
$string['renderingserverconnectfailed'] = 'Serveren {$a} mislykkes i å behandle en RQP forespørsel. Sjekk at URL-en er korrekt.';
$string['reopenattempt'] = 'Gjenåpne';
$string['reopenattemptareyousuremessage'] = 'Er du sikker på at du vil gjenåpne quizforsøket {$an->attemptnumber} av {$a->attemptuser}?';
$string['reopenattemptareyousuretitle'] = 'Gjenåpne forsøk?';
$string['reopenattemptwrongstate'] = 'Forsøk {$a->attemptid} er i feil tilstand ({$a->state}) for å gjenåpnes.';
$string['reopenedattemptwillbeinprogress'] = 'Det gjenåpnede forsøket forblir åpent, slik at det kan fortsettes.';
$string['reopenedattemptwillbeinprogressuntil'] = 'Det gjenåpnede forsøket vil forbli åpent slik at det kan fortsette. Den skal sendes inn innen {$a}.';
$string['reopenedattemptwillbesubmitted'] = 'Det gjenåpnede forsøket vil umiddelbart bli sendt inn for vurdering.';
$string['reorderquestions'] = 'Omorganiser spørsmålene';
$string['reordertool'] = 'Vis verktøy for endring av rekkefølge';
$string['repaginate'] = 'Ompaginer med {$a} spørsmål på hver side';
$string['repaginatecommand'] = 'Repaginer';
$string['repaginatenow'] = 'Repaginer nå';
$string['replace'] = 'Bytt ut';
$string['replacementoptions'] = 'Erstatningsvalg';
$string['report'] = 'Rapporter';
$string['reportanalysis'] = 'Analyse';
$string['reportattemptsfrom'] = 'Forsøk fra';
$string['reportattemptsthatare'] = 'Forsøk som er';
$string['reportdisplayoptions'] = 'Visningsvalg';
$string['reportfullstat'] = 'Detaljert statistikk';
$string['reportmulti_percent'] = 'Multi-prosentverdier';
$string['reportmulti_q_x_student'] = 'Multi-student valg';
$string['reportmulti_resp'] = 'Individuelle besvarelser';
$string['reportmustselectstate'] = 'Du må velge minst en tilstand';
$string['reportnotfound'] = 'Rapporten ukjent ({$a})';
$string['reportoverview'] = 'Oversikt';
$string['reportregrade'] = 'Regn om karakterer';
$string['reportresponses'] = 'Detaljerte tilbakemeldinger';
$string['reports'] = 'Rapporter';
$string['reportshowonly'] = 'Vis bare forsøkene';
$string['reportshowonlyfinished'] = 'Vis maksimalt et fullført forsøk for hver bruker ({$a})';
$string['reportsimplestat'] = 'Enkel statistikk';
$string['reportusersall'] = 'alle brukere som har tatt quizen';
$string['reportuserswith'] = 'påmeldte brukere som har tatt quizen';
$string['reportuserswithorwithout'] = 'påmeldte brukere som har, eller ikke har tatt quizen';
$string['reportuserswithout'] = 'påmeldte brukere som ikke har tatt quizen';
$string['reportwhattoinclude'] = 'Hva som skal tas med i rapporten';
$string['requirepassword'] = 'Krev passord';
$string['requirepassword_help'] = '<p>Dette felter er valgfritt.</p>

<p>Dersom du skriver inn et passord her må deltakerne skrive inn samme passord for å få lov til å ta quizen.</p>';
$string['requiresubnet'] = 'Krev nettverksadresse';
$string['requiresubnet_help'] = '<p>Dette feltet er valgfritt.</p>

<p>Du kan avgrense tilgangen til en quiz til bestemte subnett på nettverket eller Internett ved å angi en kommaseparert liste av deler eller hele IP-adressenumre.</p>

<p>Dette er spesielt anvendelig ved overvåkede quizer, hvor du ønsker å være sikker på at bare deltakere i et bestemt rom har tilgang til quizen.</p>

<p>For eksempel: <b>192.168. , 231.54.211.0/20, 231.3.56.211, 231.3.56.10-20</b></p>

<p>Du kan bruke fire forskjellige nummertyper (du kan ikke bruke kanoniske navn som example.com):</p>

<ol>
<li>Fulle IP addresser, som <b>192.168.10.1</b> som vil gi tilgang for en enkelt pc/proxy eller ruter.</li>
<li>Delvise addresser, som <b>192.168</b> som vil gi tilgang for alle ip-adresser som starter med disse tallene.</li>
<li>CIDR notasjon, som <b>231.54.211.0/20</b> som lar deg angi mer detaljert hvilket subnett som skal ha tilgang.</li>
<li>Et IP-addresseområde <b>231.3.56.10-20</b> Adresseområdet angis ved de siste sifferelementene og betyr alle IP-adresser fra  231.3.56.10 til 231.3.56.20.</li>
</ol>

<p>Mellomrom blir ignorert.</p>';
$string['response'] = 'Respons';
$string['responses'] = 'Respons';
$string['results'] = 'Resultater';
$string['returnattempt'] = 'Gå tilbake til forsøket';
$string['reuseifpossible'] = 'gjenbruk tidligere fjernede';
$string['reverttodefaults'] = 'Tilbakestill til quiz-modulens standardverdier';
$string['review'] = 'Sammendrag';
$string['reviewafter'] = 'Tillat sammendrag etter at quizen er avsluttet.';
$string['reviewalways'] = 'Tillat sammendrag';
$string['reviewattempt'] = 'Vis forsøk';
$string['reviewbefore'] = 'Tillat sammendrag mens quizen er åpen';
$string['reviewclosed'] = 'Etter at quizen er avsluttet';
$string['reviewduring'] = 'Under forsøket';
$string['reviewimmediately'] = 'Rett etter et forsøk';
$string['reviewnever'] = 'Ikke tillat sammendrag';
$string['reviewofquestion'] = 'Gjennomgang av spørsmål {$a->question} i {$a->quiz} av {$a->user}';
$string['reviewopen'] = 'Senere, så lenge quizen fortsatt er åpen';
$string['reviewoptions'] = 'Studenter kan bedømme';
$string['reviewoptionsheading'] = 'Hva brukeren skal få av tilbakemelding på quizen';
$string['reviewoptionsheading_help'] = 'Disse valgene styrer hvilken informasjon studentene kan se når de ser gjennom quizforsøk eller ser på rapporter.

**Mens forsøket pågår**-innstillinger er kun relevant for noen atferder, f.eks. \'interaktivt med flere forsøk\', som kan vise tilbakemeldinger mens forsøket pågår.

**Straks etter et forsøk**-innstillinger gjelder for de første to minuttene etter at en har klikket på "Send inn og avslutt".

**Senere, mens quizen fortsatt er åpen**-innstillinger gjelder etter dette og før stengningstidpunktet for quizzen.

**Etter at quizzen er avsluttet**-innstillinger gjelder etter at tidspunktet for stenging av quizen har passert. Dersom quizen ikke har noen stengningsdato inntreffer dette aldri.';
$string['reviewoverallfeedback'] = 'Generelle tilbakemeldinger';
$string['reviewoverallfeedback_help'] = 'Tilbakemeldingen gitt etter endt forsøk, avhengig av studentens samlede karakter';
$string['reviewresponse'] = 'Gjennomgå tilbakemeldinger';
$string['reviewresponsetoq'] = 'Vis responsen (spørsmål {$a})';
$string['reviewthisattempt'] = 'Vis dine responser på dette forsøket';
$string['rqp'] = 'Eksternt spørsmål';
$string['rqps'] = 'Eksterne spørsmål';
$string['sameasoverall'] = 'Samme som for sammenlagt karakterer';
$string['save'] = 'Lagre';
$string['saveandedit'] = 'Lagre endringer og rediger spørsmål';
$string['saveattemptfailed'] = 'Lagringen av gjeldende quiz-forsøk var mislykket.';
$string['savedfromdeletedcourse'] = 'Lagret fra slettet kurs "{$a}"';
$string['savegrades'] = 'Lagre karakterer';
$string['savemyanswers'] = 'Lagre mine svar';
$string['savenosubmit'] = 'Lagre uten å sende inn';
$string['saveoverrideandstay'] = 'Lagre og åpne en annen overstyring';
$string['savequiz'] = 'Lagre hele quizen';
$string['saving'] = 'Lagrer';
$string['savingnewgradeforquestion'] = 'Lagrer ny karakter for spørsmåls-ID {$a}.';
$string['savingnewmaximumgrade'] = 'Lagrer ny makskarakter.';
$string['score'] = 'Poeng';
$string['scores'] = 'Poeng';
$string['search:activity'] = 'Quiz - aktivitetsinformasjon';
$string['sectionheadingedit'] = 'Rediger overskrift \'{$a}\'';
$string['sectionheadingremove'] = 'Fjern overskrift \'{$a}\'';
$string['sectionnoname'] = 'Seksjon uten navn';
$string['seequestions'] = '(Se spørsmål)';
$string['select'] = 'Velg';
$string['selectall'] = 'Velg alle';
$string['selectattempt'] = 'Velg forsøk';
$string['selectcategory'] = 'Velg kategori';
$string['selectedattempts'] = 'Valgte forsøk';
$string['selectmultipleitems'] = 'Velg flere elementer';
$string['selectmultipletoolbar'] = 'Velg multippel verktøylinje';
$string['selectnone'] = 'Omgjør alle valgte';
$string['selectquestionslot'] = 'Velg spørsmål {$a}';
$string['selectquestiontype'] = '- Velg spørsmålstype - ';
$string['serveradded'] = 'La til tjener';
$string['serveridentifier'] = 'Identfiser';
$string['serverinfo'] = 'Tjenerinformasjon';
$string['servers'] = 'Tjenere';
$string['serverurl'] = 'Tjeners URL';
$string['shortanswer'] = 'Kort svar';
$string['show'] = 'Vis';
$string['showall'] = 'Vis alle spørsmålene på samme side';
$string['showblocks'] = 'Vis sideblokker når quizen tas';
$string['showblocks_help'] = 'Dersom Ja vil sideblokker vises når quizen tas';
$string['showbreaks'] = 'Vis sideskift';
$string['showcategorycontents'] = 'Vis kategoriinnhold {$a->arrow}';
$string['showcorrectanswer'] = 'Vis de riktige svarene i tilbakesvar?';
$string['showdetailedmarks'] = 'Vis kommentardetaljer';
$string['showeachpage'] = 'Vis en side om gangen';
$string['showfeedback'] = 'Vis tilbakemelding etter svar?';
$string['showinsecurepopup'] = 'Bruk et "sikkert" popup-vindu for quiz-forsøk';
$string['showlargeimage'] = 'Stort bilde';
$string['shownoattempts'] = 'Vis studenter uten forsøk';
$string['shownoattemptsonly'] = 'Vis kun studenter uten forsøk';
$string['shownoimage'] = 'Uten bilde';
$string['showreport'] = 'Vis rapport';
$string['showsmallimage'] = 'Lite bilde';
$string['showteacherattempts'] = 'Vis lærernes forsøk';
$string['showuserpicture'] = 'Vis brukerens profilbilde';
$string['showuserpicture_help'] = 'Dersom aktivert vil studentens navn og bilde vises på skjermen når quizen tas og når en ser over quiz-resultatene. Dette gjør det lettere å sikre at studenten er logget inn som seg selv når det skal være en overvåket eksamen.';
$string['shuffle'] = 'Stokk om';
$string['shuffleanswers'] = 'Stokk svarene';
$string['shuffledrandomly'] = 'Tilfeldig rekkefølge';
$string['shufflequestions'] = 'Stokk spørsmålene';
$string['shufflequestions_help'] = 'Hvis du aktiverer denne, vil spørsmålene stokkes slik at spørsmålsrekkefølgen endres.

Dette kan gjøre det vanskeligere for elever å dele svar, men det kan også gjøre det vanskeligere for elever å diskutere et bestemt spørsmål med deg.';
$string['shufflewithin'] = 'Stokk svaralternativene';
$string['shufflewithin_help'] = '<p>Hvis du slår på denne innstillingen vil rekkefølgen på svaralternativene i hvert spørsmål være tilfeldig for hver gang en student tar quizen. </p>

<p>Meningen er helt enkelt å gjøre det litt vanskeligere for studenter å kopiere fra hverandre. </p>';
$string['singleanswer'] = 'Velg ett svar';
$string['sortage'] = 'Sorter etter alder';
$string['sortalpha'] = 'Sorter etter navn';
$string['sortquestionsbyx'] = 'Sorter spørsmålene etter: {$a}';
$string['sortsubmit'] = 'Sorter spørsmål';
$string['sorttypealpha'] = 'Sorter etter type, navn';
$string['specificapathnotonquestion'] = 'Den angitte filstien er ikke på det spesifiserte spørsmålet';
$string['specificquestionnotonquiz'] = 'Spesifisert spørsmål er ikke i den angitte quizen';
$string['startagain'] = 'Begynn på nytt';
$string['startattempt'] = 'Start forsøk';
$string['startedon'] = 'Begynt den';
$string['startnewpreview'] = 'Begynn på nytt';
$string['stateabandoned'] = 'Aldri sendt inn';
$string['statefinished'] = 'Ferdig';
$string['statefinisheddetails'] = 'Levert {$a}';
$string['stateinprogress'] = 'Pågår';
$string['statenotloaded'] = 'Status for spørsmål {$a} er ikke lastet fra databasen';
$string['stateoverdue'] = 'På overtid';
$string['stateoverduedetails'] = 'Må sendes inn innen {$a}';
$string['status'] = 'Status';
$string['stoponerror'] = 'Stopp ved feil';
$string['submission_confirmation'] = 'Levér inn alle svar og avslutt?';
$string['submission_confirmation_unanswered'] = 'Spørsmål uten besvarelser: {$a}';
$string['submitallandfinish'] = 'Send svarene og avslutt';
$string['subneterror'] = 'Beklager, denne quizen er låst, slik at den bare er tilgjengelig fra visse nettverk. Datamaskinen din befinner seg dessverre ikke på et slikt nettverk.';
$string['subnetnotice'] = 'Denne quizen har blitt låst slik at den kun er tilgjengelig fra visse steder. Din datamaskin er ikke på et tillatt subnett. Som lærer har du lov til å kikke på den uansett.';
$string['subplugintype_quiz'] = 'Rapport';
$string['subplugintype_quiz_plural'] = 'Rapporter';
$string['subplugintype_quizaccess'] = 'Tilgangsregel';
$string['subplugintype_quizaccess_plural'] = 'Tilgangsregler';
$string['substitutedby'] = 'vil bli byttet ut med';
$string['summaryofattempt'] = 'Oppsummering av forsøk';
$string['summaryofattempts'] = 'Oppsummering av dine tidligere forsøk';
$string['temporaryblocked'] = 'Du har midlertidig ikke lov å forsøke quizen på nytt.<br />Du vil kunne forsøke igjen den:';
$string['theattempt'] = 'Forsøket';
$string['theattempt_help'] = 'Hvorvidt studenten kan se igjennom forsøket i det hele tatt';
$string['time'] = 'Tid';
$string['timecompleted'] = 'Fullført';
$string['timedelay'] = 'Du kan ikke ta denne quizen siden det er gått for kort tid siden forrige forsøk.';
$string['timeleft'] = 'Gjenstående tid';
$string['timelimit'] = 'Tidsgrense';
$string['timelimit_help'] = 'Hvis denne funksjonen er aktivert, blir tidsbegrensningen oppgitt på den første siden av quizen og en nedtellingstidtakeren vist i quiznavigeringsblokken.';
$string['timelimit_link'] = 'mod/quiz/timing';
$string['timelimitexeeded'] = 'Beklager! Quizens tidsgrense er overskredet.';
$string['timestr'] = '%H:%M:%S on %d/%m/%y';
$string['timesup'] = 'Tida er over!';
$string['timetaken'] = 'Totalt brukt tid';
$string['timing'] = 'Tidtaging';
$string['tofile'] = 'til fil';
$string['tolerance'] = 'Toleranse';
$string['toomanyrandom'] = 'Antallet tilfeldige spørsmål er større enn denne kategorien inneholder! ({$a})';
$string['top'] = 'Topp';
$string['totalmarksx'] = 'Totalvurdering: {$a}';
$string['totalquestionsinrandomqcategory'] = 'Total for {$a} spørsmål i kategorien.';
$string['true'] = 'Riktig';
$string['truefalse'] = 'Sant/usant';
$string['type'] = 'Type';
$string['unfinished'] = 'åpen';
$string['ungraded'] = 'Ikke vurdert';
$string['unit'] = 'Enhet';
$string['unknowntype'] = 'Spørsmålstypen blir ikke støttet ved linje {$a}. Spørsmålet vill bli ignorert.';
$string['updatefilterconditon'] = 'Oppdater filterbetingelser';
$string['updatefilterconditon_success'] = 'Filterbetingelsene er oppdatert';
$string['updateoverdueattemptstask'] = 'Oppdaterer utløpte quizforsøk';
$string['updatequizslotswithrandomxofy'] = 'Oppdaterer spørsmål med data for tilfeldige spørsmål ({$a->done}/{$a->total})';
$string['updatesettings'] = 'Oppdater quizinnstillinger';
$string['updatingatttemptgrades'] = 'Oppdaterer karakteren på forsøket';
$string['updatingfinalgrades'] = 'Oppdaterer endelig karakter';
$string['updatingthegradebook'] = 'Oppdaterer karakterboken';
$string['upgradesure'] = '<div>Spesielt quizmodulen vil gjennomgå store endringer i testtabeller og denne oppgraderingen er ikke ennå tilstrekkelig testet. Vi anbefaler sterkt at du tar en backup av databasen FØR du fortsetter.</div>';
$string['upgradingquizattempts'] = 'Oppgraderer quizforsøkene: quiz {$a->done}/{$a->outof} (Quiz id {$a->info})';
$string['upgradingveryoldquizattempts'] = 'Oppgraderer veldig gamle quizforsøk: {$a->done}/{$a->outof}';
$string['url'] = 'URL';
$string['usedcategorymoved'] = 'Denne kategorien tihørte et kurs som har blitt slettet. Siden den inneholder spørsmål som er i bruk av andre kurs, har den blitt flyttet til øverste nivå(portalnivå).';
$string['useroverrides'] = 'Bruker overstyring';
$string['useroverridesdeleted'] = 'Brukeroverstyring slettet';
$string['usersnone'] = 'Ingen studenter har tilgang til denne quizen';
$string['validate'] = 'Valider';
$string['viewallanswers'] = 'Vis {$a} fullførte quizer';
$string['viewallreports'] = 'Vis rapporter for {$a} forsøk';
$string['viewed'] = 'Vist';
$string['warningmissingtype'] = '<b>Dette spørsmålet er av en type som ennå ikke er installert i din Moodle.<br />Vennligst varsle Moodle administrator.</b>';
$string['wheregrade'] = 'Hvor er karakteren min?';
$string['wildcard'] = 'Gjett';
$string['windowclosing'] = 'Dette vinduet vil straks lukkes';
$string['withsummary'] = 'med sammendragsstatistikk';
$string['wronguse'] = 'Du kan ikke bruke denne siden slik';
$string['xhtml'] = 'XHTML';
$string['youneedtoenrol'] = 'Du må melde deg på dette kurset før du kan ta quizen i den.';
$string['yourfinalgradeis'] = 'Sluttkarakter på denne quizen ble {$a}.';
