<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'quiz', language 'mn', version '4.3'.
 *
 * @package     quiz
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessnoticesheader'] = 'Та энэ шалгалтыг тоймлон харж болно. Гэхдээ таны оролдлого үнэнээсээ байсан бол та түгжигдэнэ. Учир нь:';
$string['action'] = 'Yйл ажиллагаа';
$string['activityoverview'] = '-аас өмнө өгөх шалгалттай байна';
$string['adaptive'] = 'Хялбаршуулсан горим';
$string['adaptive_help'] = 'Хэрэв идэвхжүүлсэн бол, шалгалт өгөх үедээ нэг асуултад олон хариулт өгөх боломжтой болно. Тухайлбал, сонгосон хариултыг нь буруу гэж гаргаж ирсэн бол даруй дахин өөр хариу сонгох боломжтой. Гэсэн ч, "Торгууль хүлээлгэх" тохиргооноос шалтгаалан, ихэнх тохиолдолд буруу хариулсан оролдлого бүрээр оноо хасагдана.';
$string['add'] = 'Нэмэх';
$string['addaquestion'] = 'шинэ асуулт';
$string['addarandomquestion'] = 'санамсаргүй сонгогдох асуулт';
$string['addarandomquestion_help'] = 'Санамсаргүй сонгогдох асуулт нэмэгдсэн бол, шалгалтын хуудасруу тухайн ангиллаас асуулт санамсаргүйгээр сонгогдож орно. Энэ нь суралцагч бүрт өөр өөр асуултууд сонгогдож харагдана гэсэн үг бөгөөд шалгалтад хариулах олон оролдлого хийхийг зөвшөөрсөн бол оролдого бүрт өөр асуулт сонгогдох магадлалтай гэсэн үг.';
$string['addarandomselectedquestion'] = 'Санамсаргүй сонгогдох асуулт нэмэх...';
$string['addasection'] = 'шинэ хэсгийн гарчиг';
$string['adddescriptionlabel'] = 'Тайлбар оруулах талбар нэмэх';
$string['addingquestion'] = 'Асуулт нэмэх';
$string['addingquestions'] = '<p>Хуудасны энэ тал дээр та сорилын санг удирдах боломжтой. Асуултууд ангилал тус бүрээр зохион байгуулалттай хадгалагдах ба хэрэв та асуултуудыг \'нийтлэх\' гэдгийг сонгосон бол өөрийн хичээл эсвэл бусад хичээлд асуултуудыг ашиглаж болно.<p>
<p>Асуултын ангилал сонгох эсвэл үүсгэсний дараа та асуултуудыг үүсгэх эсвэл засварлах боломжтой болно. Та энэ асуултуудын алийг нь ч сонгож энэ хуудасны нөгөө талаас өөрийн шалгалтын хуудасруу оруулж болно.<p>';
$string['addmoreoverallfeedbacks'] = 'Тайлбарын {no} талбар нэмэх';
$string['addnewgroupoverride'] = 'Бүлгийн дахин тодорхойлолт нэмэх';
$string['addnewpagesafterselected'] = 'Сонгосон асуултуудын араас шинэ хуудас нэмэх';
$string['addnewquestionsqbank'] = '{$a->catname} ангилалд асуулт нэмэх: {$a->link}';
$string['addnewuseroverride'] = 'Хэрэглэгч арилгах сонголт нэмэх';
$string['addpagebreak'] = 'Хуудас тусгаарлагч нэмэх';
$string['addpagehere'] = 'Энд хуудас нэмэх';
$string['addquestion'] = 'Асуулт нэмэх';
$string['addquestionfrombankatend'] = 'Төгсгөлд нь сорилын сангаас асуулт нэмэх';
$string['addquestionfrombanktopage'] = '{$a} хуудас руу сорилын сангаас нэмэх';
$string['addquestions'] = 'Асуултууд нэмэх';
$string['addquestionstoquiz'] = 'Сонгосон шалгалтанд асуултууд нэмэх';
$string['addrandom'] = '{$a} санамсаргүй сонгогдох асуулт нэмэх';
$string['addrandom1'] = '<< Нэмэх';
$string['addrandom2'] = 'Санамсаргүй сонгогдох асуулт';
$string['addrandomfromcategory'] = 'Дараах ангиллаас санамсаргүй сонгогдох асуулт нэмэх:';
$string['addrandomquestion'] = 'Санамсаргүй сонгогдох асуулт нэмэх';
$string['addrandomquestionatend'] = 'Төгсгөлд нь санамсаргүй сонгогдох асуулт нэмэх';
$string['addrandomquestiontopage'] = '{$a} хуудас руу санамсаргүй сонгогдох асуулт нэмэх';
$string['addrandomquestiontoquiz'] = '{$a} шалгалтын хуудсанд санамсаргүй сонгогдох асуулт нэмэх';
$string['addselectedquestionstoquiz'] = 'Шалгалтын хуудсанд сонгосон асуултуудыг нэмэх';
$string['addselectedtoquiz'] = 'Шалгалтын хуудсанд сонгогдсоныг нэмэх';
$string['addtoquiz'] = 'Шалгалтын хуудсанд нэмэх';
$string['affectedstudents'] = '{$a} нөлөөлсөн';
$string['aftereachquestion'] = 'Асуулт бүрийг нэмсний дараа';
$string['afternquestions'] = '{$a} асуулт нэмсний дараа';
$string['age'] = 'нас';
$string['allattempts'] = 'Бүх оролдлогууд';
$string['allinone'] = 'Хязгааргүй';
$string['allowreview'] = 'Хянахыг зөвшөөрөх';
$string['alreadysubmitted'] = 'Та оролдлогоо  хэдийнэ оруулсан байна.';
$string['alternativeunits'] = 'Нэгжийн өөр хувилбар';
$string['alwaysavailable'] = 'Yргэлж идэвхтэй байна';
$string['alwayslatest'] = 'Үргэлж сүүлийн';
$string['analysisoptions'] = 'Шинжлэх тохиргоо';
$string['analysistitle'] = 'Зүйлийг шинжлэх хүснэгт';
$string['answer'] = 'Хариулт';
$string['answered'] = 'Хариулсан';
$string['answerhowmany'] = 'Нэг эсвэл олон хариулттай эсэх?';
$string['answers'] = 'Хариултууд';
$string['answersingleno'] = 'Олон хариултыг зөвшөөрсөн';
$string['answersingleyes'] = 'Зөвхөн ганц хариулттай';
$string['answertoolong'] = '{$a} мөрнөөс хойшхи хариулт уртдаж байна (хамгийн ихдээ 255 тэмдэгт)';
$string['anytags'] = 'Дурын таг';
$string['aon'] = 'AON загвар';
$string['areyousureremoveselected'] = 'Та сонгосон бүх асуултуудыг устгахдаа итгэлтэй байна уу?';
$string['asshownoneditscreen'] = 'Засварлах цонхонд үзүүлсэнчлэн';
$string['attempt'] = '{$a} оролдлого';
$string['attemptalreadyclosed'] = 'Энэ оролдлого хэдийнэ дууссан байна.';
$string['attemptclosed'] = 'Хариулт хийх оролдлого хараахан хаагдаагүй байна.';
$string['attemptduration'] = 'Зарцуулсан хугацаа';
$string['attemptedon'] = '-д сорилыг хийж үзсэн';
$string['attempterror'] = 'Та яг одоо энэ шалгалтыг өгөх боломжгүй байна. Учир нь: {$a}';
$string['attempterrorcontentchange'] = 'Энэ шалгалтыг урьдчилан харах боломжгүй болсон байна. (Шалгалтыг засварлах үед, урьдчилан харах аливаа тохиргоог автоматаар устгадаг.)';
$string['attempterrorcontentchangeforuser'] = 'Энэ шалгалтын оролдлого байхгүй болсон байна.';
$string['attempterrorinvalid'] = 'Хүчингүй оролдлого ID';
$string['attemptfirst'] = 'Анхны оролдлого';
$string['attemptgradeddelay'] = 'Мэдэгдлийн хугацааны хоцрогдлоор оролдлогыг дүгнэсэн';
$string['attemptgradeddelay_desc'] = 'Багшид үнэлгээг засах цаг гаргахын тулд үнэлгээний мэдэгдэл илгээх оролдлогын өмнө хугацааны хоцрогдол тавьдаг.';
$string['attemptincomplete'] = '{$a} хийсэн оролдлого дуусаагүй байна.';
$string['attemptlast'] = 'Сүүлийн оролдлого';
$string['attemptnumber'] = 'Оролдлого';
$string['attemptquiz'] = 'Сорил өгөх';
$string['attemptquiznow'] = 'Шалгалтыг одоо эхлүүлэх';
$string['attemptreviewtitle'] = '{$a}: Оролдлогыг хянах';
$string['attemptreviewtitlepaged'] = '{$a->name}: Оролдлогыг хянах (нийт {$a->totalpages} хуудасны {$a->одоогийн хуудас})';
$string['attempts'] = 'Оролдлогууд';
$string['attempts_help'] = 'Зөвшөөрөгдсөн оролдлогын нийт тоо (нэмэлт оролдлогын тоо биш).';
$string['attemptsallowed'] = 'Зөвшөөрөгдсөн оролдлого';
$string['attemptsdeleted'] = 'Шалгалтын оролдлогууд устгагдсан.';
$string['attemptselection'] = 'Хэрэглэгчийн аль оролдлогыг шалгаж үзэхээ сонгох:';
$string['attemptsexist'] = 'Та асуулт дахиж нэмж хасч болохгүй';
$string['attemptsnum'] = 'Оролдлого: {$a}';
$string['attemptsnumthisgroup'] = 'Оролдлого: {$a->total} ({$a->group} энэ бүлгээс)';
$string['attemptsnumyourgroups'] = 'Оролдлого: {$a->total} ({$a->group} таны бүлгээс)';
$string['attemptsonly'] = 'Зөвхөн оролдлого хийсэн оюутнуудыг харуулах';
$string['attemptstate'] = 'Төлөв';
$string['attemptstillinprogress'] = 'Оролдлого дуусаагүй байна';
$string['attemptsummarytitle'] = '{$a}: Оролдлогын тойм';
$string['attemptsunlimited'] = 'Оролдлогын тоог хязгаарлахгүй';
$string['attempttitle'] = '{$a}';
$string['attempttitlepaged'] = '{$a->name} (page {{$a->totalpages}-ийн $a->currentpage} )';
$string['autosaveperiod'] = 'Автоматаар хадгалах хугацаа';
$string['autosaveperiod_desc'] = 'Шалгалтын асуултанд хариулах оролдлого хийх үед оюутнуудын хариултууд хэдэн минут тутамд автоматаар хадгалагдаж байдаг. Энэ нь сөрөг болон давуу талтай: Хугацааг багаар өгснөөр серверийн ачааллыг нэмэгдүүлдэг боловч хийсэн ажлаа алдахгүй байх боломжийг оюутнуудад өгдөг. Хугацааг 0 гэж өгснөөр автомат хадгалалтыг болиулна.';
$string['back'] = 'Асуултыг урьдчилан харах хэсэг рүү буцах';
$string['backtocourse'] = 'Хичээл рүү буцах';
$string['backtoquestionlist'] = 'Асуултын жагсаалт руу буцах';
$string['backtoquiz'] = 'Шалгалтыг засварлах хэсэг рүү буцах';
$string['basicideasofquiz'] = 'Шалгалтыг зохиомжлох санаа';
$string['bestgrade'] = 'Хамгийн сайн дүн';
$string['bothattempts'] = 'Шалгалтад оролцсон, оролцоогүй суралцагчдыг харуулах';
$string['browsersecurity'] = 'Вэб хөтчийн аюулгүй байдал';
$string['browsersecurity_help'] = 'Хэрэв "ЖаваСкриптийн аюулгүй байдал тодорхой хэмжээгээр хангагдсан бүтэн дэлгэц"-г сонгосон бол,

* ЖаваСкрипт-идэвхжүүлсэн веб хөтөч байх тохиолдолд л шалгалт эхэлнэ
* Удирдлагын цэсгүй цонх дэлгэц дүүрэн бусад бүх цонхуудыг таглаж гарч ирнэ
* copy болон paste зэрэг команд ашиглах боломжгүй байна.';
$string['cachedef_overrides'] = 'Хэрэглэгч ба бүлгийн мэдээлэл';
$string['calculated'] = 'Тооцоолсон';
$string['calculatedquestion'] = '{$a} мөрөнд тооцоолох асуултыг дэмждэггүй. Уг асуултыг хэрэгсэхгүй болгоно.';
$string['cannotcreatepath'] = '({$a}) замыг үүсгэхгүй';
$string['cannoteditafterattempts'] = 'Та асуулт нэмж, хасч чадахгүй. Учир нь шалгалтад суралцагч оролцсон байна.  ({$a})';
$string['cannotfindprevattempt'] = 'Хийсэн өмнөх оролдлогуудыг олж чадсангүй.';
$string['cannotfindquestionregard'] = 'Дахин дүгнүүлэх асуулт авч чадсангүй.';
$string['cannotinsert'] = 'Асуулт оруулах боломжгүй';
$string['cannotinsertrandomquestion'] = 'Санамсаргүй сонгогдох шинэ асуулт оруулж чадсангүй!';
$string['cannotloadquestion'] = 'Асуултын тохиргоог ачаалж чадсангүй';
$string['cannotloadtypeinfo'] = 'Асуултын төрлийн тодорхой асуултын мэдээллийг ачаалах боломжгүй';
$string['cannotopen'] = 'Экспортын файл  ({$a})-г нээх боломжгүй байна';
$string['cannotremoveallsectionslots'] = 'Та \'{$a}\' хэсгийн гарчгийн доорх бүх асуултыг сонгосон байна. Хэсгийн гарчгийн доорх бүх асуултыг устгахыг хориглоно.';
$string['cannotremoveslots'] = 'Асуултыг устгах боломжгүй';
$string['cannotrestore'] = 'Асуултын сейшнийг сэргээж чадсангүй';
$string['cannotreviewopen'] = 'Энэ оролдогыг хянаж чадахгүй. Учир нь хийж дуусаагүй байна.';
$string['cannotsavelayout'] = 'Бүтцийг хадгалах боломжгүй байна';
$string['cannotsavenumberofquestion'] = 'Нэг хуудсанд харуулах асуултын тоог хадгалж чадсангүй';
$string['cannotsavequestion'] = 'Асуултын жагсаалтыг хадгалж чадсангүй';
$string['cannotsetgrade'] = 'Шалгалтын хамгийн их үнэлгээг шинээр тохируулж чадсангүй';
$string['cannotsetsumgrades'] = 'Нийт үнэлгээг тохируулж чадсангүй';
$string['cannotstartgradesmismatch'] = 'Энэ шалгалтыг эхлүүлэх боломжгүй байна. Энэ шалгалт нь {$a->grade}-с гадуур үнэлэх тохиргоотой боловч асуултуудын нэгэнд нь ч оноо байхгүй байна. Үүнийг \'Шалгалтын хуудас засварлах\' хуудаснаас тохируулж болно.';
$string['cannotstartmissingquestion'] = 'Энэ шалгалтыг эхлүүлэх боломжгүй байна. Шалгалтын хуудсанд байхгүй асуулт тодорхойлогдсон байна.';
$string['cannotstartnoquestions'] = 'Энэ шалгалтыг эхлүүлэх боломжгүй байна. Шалгалтын тохируулга бүрэн хийгдээгүй, асуулт оруулаагүй байна.';
$string['cannotwrite'] = 'Экспортлох ({$a}) файл руу бичиж чадсангүй';
$string['canredoquestions'] = 'Оролдлого дотроо дахин хариулахыг зөвшөөрөх';
$string['canredoquestions_desc'] = 'Хэрэв идэвхжүүлсэн бол асуултад хариулж дууссаны дараа "Үүнтэй ижил өөр асуултад хариулах" товч гарч ирнэ. Энэ нь шинээр дахин шалгалт өгөх шаардлагагүйгээр тухайн асуулт, эсвэл үүнтэй ижил (санамсаргүйгээр сонгогдсон) асуултад хариулах боломжийг олгоно. Үүнийг туршилт шалгалтын үед ашиглахад тохиромжтой.

Энэ тохиргоо нь шалгалтаа дуусгахаас өмнө дуусгах боломжтой асуултууд болон горимд (хариу ба тайлбар шууд харагдах эсвэл олон оролдлоготой интерактив гэх мэт) л нөлөөлнө.';
$string['canredoquestions_help'] = 'Хэрэв идэвхжүүлсэн бол асуултад хариулж дууссаны дараа "Үүнтэй ижил өөр асуултад хариулах" товч гарч ирнэ. Энэ нь шинээр дахин шалгалт өгөх шаардлагагүйгээр тухайн асуулт, эсвэл үүнтэй ижил (санамсаргүйгээр сонгогдсон) асуултад хариулах боломжийг олгоно. Үүнийг туршилт шалгалтын үед ашиглахад тохиромжтой.

Энэ тохиргоо нь шалгалтаа дуусгахаас өмнө дуусгах боломжтой асуултууд болон горимд (хариу ба тайлбар шууд харагдах эсвэл олон оролдлоготой интерактив гэх мэт) л нөлөөлнө.';
$string['canredoquestionsyes'] = 'Тийм, өөр асуултад хариулах тохиргоог зөвшөөрөх';
$string['caseno'] = 'Yгүй, үсгийн том жижиг хамаагүй.';
$string['casesensitive'] = 'Үсгийн том жижиг хамаатай';
$string['caseyes'] = 'Тийм, үсгийн том жижиг яг адилхан байх ёстой.';
$string['categoryadded'] = '\'{$a}\' ангилал нэмэгдсэн';
$string['categorydeleted'] = '\'{$a}\' ангилал устгагдсан';
$string['categorynoedit'] = 'Танд \'{$a}\' ангиллыг засварлах эрх байхгүй.';
$string['categoryupdated'] = 'Ангилал амжилттай шинэчлэгдлээ.';
$string['close'] = 'Цонхыг хаах';
$string['closebeforeopen'] = 'Шалгалтыг шинэчилж чадахгүй. Та шалгалтыг хаах өдрийг нээх өдрөөс өмнө тавьсан байна.';
$string['closed'] = 'Хаагдсан';
$string['closepreview'] = 'Урьдчилж харах цонхыг хаах';
$string['closereview'] = 'Хянах цонхыг хаах';
$string['comment'] = 'Сэтгэгдэл';
$string['commentorgrade'] = 'Сэтгэгдэл бичих эсвэл дүнг хүчингүй болгох';
$string['comments'] = 'Сэтгэгдлүүд';
$string['completedon'] = 'Дууссан цаг';
$string['completionattemptsexhausted'] = 'Эсвэл бүх боломжит оролдлого дууссан';
$string['completionattemptsexhausted_help'] = 'Суралцагч бүх оролдлогоо гүйцээсэн бол шалгалтыг дууссан гэж тэмдэглэ';
$string['completiondetail:minattempts'] = 'Шалгалт өгөх: {$a}';
$string['completiondetail:passgrade'] = 'Тэнцсэн үнэлгээ авах';
$string['completiondetail:passorexhaust'] = 'Тэнцсэн үнэлгээ авах эсвэл бүх боломжит оролдлогыг дуусгах';
$string['completionminattempts'] = 'Хамгийн бага оролдлогын тоо:';
$string['completionminattemptsdesc'] = 'Шаардлагатай хамгийн бага оролдлогын тоо: {$a}';
$string['completionminattemptserror'] = 'Хамгийн бага оролдлогын тоо зөвшөөрөгдсөн оролдлогоос бага буюу тэнцүү байх ёстой.';
$string['completionminattemptsgroup'] = 'Шалгалт өгөхийг шаардах';
$string['completionpass'] = 'Тэнцсэн үнэлгээ шаардах';
$string['completionpass_help'] = 'Идэвхжүүлсэн бол тухайн суралцагч тэнцсэн үнэлгээ (Шалгалтын тохиргооны Үнэлгээ хэсэгт тодорхойлсны дагуу) буюу түүнээс дээш үнэлгээ авсан тохиолдолд энэ үйл ажиллагааг гүйцэтгэсэн гэж үзнэ.';
$string['completionpassdesc'] = 'Энэ үйл ажиллагааг гүйцэтгэж дуусгахын тулд суралцагч тэнцсэн үнэлгээ авсан байх ёстой';
$string['completionpassorattemptsexhausteddesc'] = 'Энэ үйл ажиллагааг гүйцэтгэж дуусгахын тулд суралцагч тэнцсэн үнэлгээ авсан байх ёстой, эсвэл боломжит бүх оролдлогоо дуусгах ёстой';
$string['configadaptive'] = 'Хэрэв та энэ тохиргоог "Тийм" гэж сонговол суралцагч шалгалт өгч байхдаа нэг асуултад хэд хэд хариулах боломжтой болно.';
$string['configattemptsallowed'] = 'Шалгалт өгч үзэх тоог хязгаарлана.';
$string['configdecimaldigits'] = 'Үнэлгээний аравтын бутархайн орны тоо';
$string['configdecimalplaces'] = 'Шалгалтын дүнгийн аравтын бутархайн орны тоо';
$string['configdecimalplacesquestion'] = 'Асуулт тус бүрийн тэмдэглэгээний аравтын бутархайн орны тоо';
$string['configdelay1'] = 'Хэрэв та хүлээх цаг оруулбал суралцагч шалгалтыг дахин хийж үзэхийн тулд заасан хугацааг хүлээх хэрэгтэй болно.';
$string['configdelay1st2nd'] = 'Хэрэв та хүлээх цаг энд оруулбал заасан хугацааг болохоос нааш суралцагч шалгалтыг дахин эхлүүлж чадахгүй.';
$string['configdelay2'] = 'Хэрэв та хүлээх цаг энд  оруулбал суралцагч шалгалтыг гурав дахь болон түүнээс олон удаа  хийж үзэхийн тулд заасан хугацааг хүлээх хэрэгтэй болно.';
$string['configdelaylater'] = 'Хэрэв та хүлээх цаг энд оруулбал заасан хугацааг болохоос нааш суралцагч шалгалтыг гурав дахь болон түүнээс цааших удаа  дахин эхлүүлж чадахгүй.';
$string['configeachattemptbuildsonthelast'] = 'Хэрэв олон удаа оролдлого хийхийг зөвшөөрсөн бол, хариулах шинэ оролдлого бүр нь өмнөх оролдлогын хариуг агуулна.';
$string['configgrademethod'] = 'Олон удаа оролдлого хийхийг зөвшөөрсөн үед, оюутны шалгалтанд авах эцсийн дүнг тооцоолоход ямар аргыг хэрэглэх хэрэгтэй вэ';
$string['configintro'] = 'Таны энд тохируулсан утгууд таныг шинэ шалгалт үүсгэх үед тохиргооны маягтанд ашиглагдах өгөгдмөл утгуудыг тодорхойлно. Та мөн шалгалтын ямар тохиргоог сайжруулсан гэж үзэж болохыг тохируулж болно.';
$string['configmaximumgrade'] = 'Шалгалтын үнэлгээг хэмжих өгөгдмөл үнэлгээ.';
$string['confignavmethod'] = 'Чөлөөт удирдлагатай үед, асуултад дурын дэс дарааллаар хариулж болно. Дараалсан үед, асуултуудад зөвхөн харагдаж буй дарааллаар нь хариулах ёстой.';
$string['confignewpageevery'] = 'Шалгалтын хуудсанд асуулт нэмэх үед таны энд сонгосон тохиргооны дагуу хуудас тусгаарлагч автоматаар орж ирнэ.';
$string['configoutcomesadvanced'] = 'Хэрэв энэ сонголтыг идэвхжүүлсэн бол, шалгалт засварлах маягт дээр гарсан Үр Дүнгүүд нь сайжруулсан тохиргоотой болно.';
$string['configpenaltyscheme'] = 'Хялбаршуулсан горимд буруу хариулт бүрд торгуулийн оноо хасагдана.';
$string['configpopup'] = 'Шалгалт өгөх үед шалгалтын хуудсыг шинэ цонхонд нээх ба Жаваскрипт ашиглан copy, paste хийхийг хориглоно.';
$string['configrequirepassword'] = 'Шалгалт өгөхийн өмнө суралцагчид энэ нууц үгийг оруулах ёстой.';
$string['configrequiresubnet'] = 'Зөвхөн эдгээр компьютеруудаас суралцагчид шалгалт өгөх боломжтой.';
$string['configreviewoptions'] = 'Шалгалтын тайлан харах эсвэл шалгалтаа хянах үед суралцагч ямар мэдээлэл харах боломжтойг эдгээр сонголтуудаар шийднэ.';
$string['configshowblocks'] = 'Шалгалт өгөх үед блокууд харуулах';
$string['configshowuserpicture'] = 'Шалгалт өгөх үед суралцагчийн зургийг дэлгэцэнд харуулах';
$string['configshufflewithin'] = 'Хэрэв та энэ сонголтыг идэвхжүүлсэн бол, мөн энэ сонголтыг асуултын тохиргоон дээр идэвхжүүлсэн бол суралцагч шалгалт өгөх оролдлого эхлүүлэх бүрт асуултууд санамсаргүйгээр хоорондоо солигдож харагдана.';
$string['configtimelimit'] = 'Шалгалтын өгөгдмөл хугацаа -минутаар. 0 утга нь хугацааны хязгааргүй болохыг илтгэнэ.';
$string['configtimelimitsec'] = 'Шалгалтын өгөгдмөл хугацаа -секундээр. 0 утга нь хугацааны хязгааргүй болохыг илтгэнэ.';
$string['configurerandomquestion'] = 'Асуулт тохируулах';
$string['confirmclose'] = 'Та хариугаа нэгэнт илгээсэн бол өөрчлөх боломжгүй.';
$string['confirmremovequestion'] = 'Та энэ  {$a} асуултыг устгахдаа итгэлтэй байна уу?';
$string['confirmremovesectionheading'] = 'Та энэ \'{$a}\' хэсгийн гарчгийг устгахдаа итгэлтэй байна уу?';
$string['confirmserverdelete'] = '<b>{$a}</b> серверийг жагсаалтаас хасмаар байна уу?';
$string['connectionerror'] = 'Сүлжээний холболт тасарсан байна. (Автомат хадгалалт амжилтгүй боллоо).

Сүүлийн хэдэн минутад энэ хуудсанд оруулсан хариултуудаа тэмдэглээд, дахин холбогдох гэж оролдоно уу.

Холболт дахин сэргээгдэхэд, таны хариултууд хадгалагдах бөгөөд энэ мэдэгдэл алга болно.';
$string['connectionok'] = 'Сүлжээ дахин холбогдлоо. Та үргэлжлүүлнэ үү.';
$string['containercategorycreated'] = 'Доор дурдсан шалтгааны улмаас сайтын түвшинд шилжсэн бүх анхны ангиллуудыг хадгалах зорилгоор энэ ангиллыг үүсгэсэн.';
$string['continueattemptquiz'] = 'Сүүлийн оролдлогыг үргэлжлүүлье';
$string['continuepreview'] = 'Сүүлд урьдчилан харснаас үргэлжлүүлэх';
$string['copyingfrom'] = '\'{$a}\' асуултын хуулбарыг бий болгох';
$string['copyingquestion'] = 'Асуултыг хуулж байна.';
$string['correct'] = 'Зөв';
$string['correctanswer'] = 'Зөв хариулт';
$string['correctanswerformula'] = 'Зөв хариултын томъёо';
$string['correctansweris'] = 'Зөв хариулт: {$a}';
$string['correctanswerlength'] = 'Чухал хэлбэрүүд';
$string['correctanswers'] = 'Зөв хариултууд';
$string['correctanswershows'] = 'Зөв хариулт харуулж байгаа нь';
$string['corrresp'] = 'Зөв хариу';
$string['countdown'] = 'Тоолох';
$string['countdownfinished'] = 'Шалгалт хаагдаж байна, та хариултуудаа илгээх хэрэгтэй.';
$string['countdowntenminutes'] = 'Шалгалт 10 минутын дараа хаагдана.';
$string['coursetestmanager'] = 'Хичээлийн тестийн удирдлагын загвар';
$string['createcategoryandaddrandomquestion'] = 'Ангилал үүсгээд санамсаргүй сонгогдох асуулт нэмэх';
$string['createfirst'] = 'Та эхлээд ямар нэгэн богино хариулттай асуулт үүсгэх ёстой.';
$string['createmultiple'] = 'Санамсаргүй сонгогдох хэд хэдэн асуулт шалгалтад нэмэх';
$string['createnewquestion'] = 'Шинэ асуулт үүсгэх';
$string['createquestionandadd'] = 'Асуулт шинээр үүсгээд шалгалтад нэмнэ.';
$string['custom'] = 'Тусгай загвар';
$string['dataitemneed'] = 'Хүчинтэй асуулт авахын тулд дор хаяж нэг өгөгдлийн зүйлсийн олонлог нэмэх хэрэгтэй';
$string['datasetdefinitions'] = '{$a} ангиллын дахин ашиглах боломжтой өгөгдлийн багцын тодорхойлолтууд';
$string['datasetnumber'] = 'Тоо';
$string['daysavailable'] = 'Боломжит өдөр';
$string['decimaldigits'] = 'Үнэлгээний аравтын бутархайн цифр';
$string['decimalplaces'] = 'Үнэлгээний аравтын бутархайн орон';
$string['decimalplaces_help'] = 'Үнэлгээг харуулах үед таслалын ард харуулах аравтын бутархайн орны цифрийн тоог энэ тохиргоогоор заана. Энэ нь зөвхөн үнэлгээг харуулахад ашиглагдах ба дээд зэргийн нарийвчлалтай хийгддэг дотоод тооцоолол болон өгөгдлийн санд хадгалах дүнд нөлөөлөхгүй.';
$string['decimalplacesquestion'] = 'Асуултын тэмдэглэгээний аравтын бутархайн орон';
$string['decimalplacesquestion_help'] = 'Асуулт тус бүрийн тэмдэглэгээг харуулах үеийн аравтын бутархайн орны тоо';
$string['decimalpoints'] = 'Аравтын бутархайн орон';
$string['default'] = 'Өгөгдмөл';
$string['defaultgrade'] = 'Асуултын өгөгдмөл үнэлгээ';
$string['defaultinfo'] = 'Асуултын өгөгдмөл ангилал';
$string['delay1'] = 'Анхны болон хоёр дахь оролдлогын хоорондох хугацаа';
$string['delay1st2nd'] = 'Анхны болон хоёр дахь оролдлого хооронд заавал авах хугацаа';
$string['delay1st2nd_help'] = 'Идэвхжүүлсэн бол, шалгалтыг хоёрдахь удаагаа өгөхийн өмнө заасан хугацаа өнгөрөхийг хүлээх ёстой болно.';
$string['delay2'] = 'Сүүлийн оролдлогууд хоорондын хугацаа';
$string['delaylater'] = 'Сүүлийн оролдлогууд хооронд заавал байх хугацаа';
$string['delaylater_help'] = 'Идэвхжүүлсэн бол, шалгалтад гуравдахь удаагаа болон түүнээс хойш хэд хэд хариулахын өмнө заасан хугацаа өнгөрөхийг хүлээх ёстой болно.';
$string['deleteattemptcheck'] = 'Та эдгээр оролдлогуудыг бүрэн устгахыг үнэхээр хүсэж байна уу?';
$string['deleteselected'] = 'Сонгосныг устгах';
$string['deletingquestionattempts'] = 'Асуултанд хариулах оролдлогуудыг устгаж байна';
$string['description'] = 'Тайлбар';
$string['disabled'] = 'Идэвхгүй болгосон';
$string['displayoptions'] = 'Сонголтуудыг харуулах';
$string['donotuseautosave'] = 'Автоматаар-хадгалах сонголтыг ашиглахгүй';
$string['download'] = 'Экспортлогдсон ангиллын файлыг татаж авах бол энд дарна уу.';
$string['downloadextra'] = '(файл нь /backupdata/quiz хавтас дахь хичээлийн файлуудад мөн хадгалагдсан)';
$string['dragtoafter'] = '{$a}-н ард';
$string['dragtostart'] = 'Эхлэл рүү очих';
$string['duplicateresponse'] = 'Та өмнө нь үүнтэй ижил хариулт өгсөн тул оруулгыг хэрэгсэхгүй болгосон.';
$string['eachattemptbuildsonthelast'] = 'Оролдлого бүр сүүлийнх дээр суурилна';
$string['eachattemptbuildsonthelast_help'] = 'Хэрэв шалгалтыг олон удаа өгөхийг зөвшөөрсөн ба энэ сонголтыг идэвхжүүлсэн бол шалгалтыг шинээр өгөх болгонд өмнөх шалгалтын үр дүнг агуулсан байх болно. Энэ нь шалгалтыг хэд хэдэн оролдлогоор дуусгах боломжийг олгодог.';
$string['edit_slotdisplaynumber_hint'] = 'Асуултын тоог засварлах (хамгийн ихдээ 16 тэмдэгт)';
$string['edit_slotdisplaynumber_label'] = '{$a}-ийн шинэ утга';
$string['editcategories'] = 'Ангиллийг засварлах';
$string['editcategory'] = 'Ангилал засварлах';
$string['editcatquestions'] = 'Ангиллын асуултыг завсарлах';
$string['editingquestion'] = 'Асуулт засварлах';
$string['editingquiz'] = 'Шалгалт засварлах';
$string['editingquiz_help'] = 'Шалгалтын хуудас үүсгэхэд дараах үндсэн зарчмуудыг баримтлана. Үүнд:

* Шалгалт нь нэг эсвэл түүнээс дээш хуудас бүхий асуултуудыг агуулсан байх
* Бүх асуултуудын хуулбарыг хадгалсан сорилын сан нь ангилалтай байх
* Санамсаргүй сонгогдох асуулт - Суралцагч шалгалт өгөх бүрт өөр өөр асуулт гарах ба суралцагч бүрт ялгаатай асуултууд гарна';
$string['editingquiz_link'] = 'mod/quiz/edit';
$string['editingquizx'] = 'Шалгалтыг засаж байна: {$a}';
$string['editmaxmark'] = 'Тэмдэглэгээний дээд оноог засварлах';
$string['editoverride'] = 'Арилгах сонголтыг засварлах';
$string['editqcats'] = 'Асуултуудын ангиллыг засварлах';
$string['editquestion'] = 'Асуулт засварлах';
$string['editquestions'] = 'Асуултуудыг засварлах';
$string['editquiz'] = 'Шалгалтын хуудсыг засварлах';
$string['editquizquestions'] = 'Шалгалтын асуултуудыг засварлах';
$string['emailconfirmautosubmitsmall'] = '\'{$a->quizname}\' -нд хариултаа илгээсэнд баярлалаа';
$string['emailconfirmbody'] = 'Хүндэт {$a->username},

\'{$a->coursename}\' хичээлийн \'{$a->quizname}\' шалгалтад өөрийн хариултуудыг {$a->submissiontime} цагт илгээсэнд баярлалаа.

Бид таны хариултуудыг хүлээн авсныг энэ мэдэгдэл баталгаажуулж байна.

Та энэ шалгалт руу {$a->quizurl} холбоосоор нэвтэрч болно.';
$string['emailconfirmbodyautosubmit'] = 'Хүндэт {$a->username},

\'{$a->coursename}\' хичээлийн \'{$a->quizname}\' шалгалтын хугацаа дууссан байна.  Таны хариултууд {$a->submissiontime} цагт автоматаар илгээгдсэн.

Бид таны хариултуудыг хүлээн авсныг энэ мэдэгдэл баталгаажуулж байна.

Та энэ шалгалт руу {$a->quizurl} холбоосоор нэвтэрч болно.';
$string['emailconfirmsmall'] = '\'{$a->quizname}\' шалгалтад өөрийн хариултуудыг илгээсэнд баярлалаа';
$string['emailconfirmsubject'] = 'Хариулт хүлээн авсан баталгаажуулалт: {$a->quizname}';
$string['emailmanualgradedbody'] = 'Хүндэт {$a->studentname},

Таны {$a->attempttimefinish}-д өгсөн  \'{$a->coursename}\' хичээлийн  \'{$a->quizname}\' шалгалтын үнэлгээ хийгдлээ.

Шалгалтын оноо болон тайлбар, зөвлөмжийг \'{$a->quizurl}\' хаягаар орж харах ба шалгалт хэрхэн өгснөө хянах боломжтой.';
$string['emailmanualgradedsubject'] = 'Таны {$a->quizname}  шалгалтын үнэлгээ хийгдсэн байна';
$string['emailnotifybody'] = 'Хүндэт {$a->username},

{$a->studentname} суралцагч \'{$a->coursename}\' хичээлийн \'{$a->quizname}\' ({$a->quizurl}) шалгалтыг амжилттай гүйцэтгэлээ.

Та хэрхэн хариулснаа {$a->quizreviewurl} хаягаар орж хянаж болно.';
$string['emailnotifysmall'] = 'Суралцагч {$a->studentname} нь {$a->quizname} шалгалтаа гүйцэтгэж дууссан байна. {$a->quizreviewurl} холбоосоор орж үзнэ үү.';
$string['emailnotifysubject'] = 'Суралцагч {$a->studentname} нь {$a->quizname} шалгалтаа гүйцэтгэж дууссан байна.';
$string['emailoverduebody'] = 'Хүндэт {$a->studentname},

Та  \'{$a->coursename}\' хичээлийн \'{$a->quizname}\' шалгалтыг эхлүүлсэн боловч хариултаа илгээгээгүй байна. Хариултаа  {$a->attemptduedate} -с өмнө илгээсэн байх ёстой.

Та хариултаа илгээх хүсэлтэй хэвээр бол {$a->attemptsummaryurl} холбоосоор орж, илгээх товчийг дарна уу.
Та хариултаа {$a->attemptgraceend}-с өмнө илгээх ёстой, эс бөгөөс таны хариулт тооцогдохгүй.';
$string['emailoverduesmall'] = 'Та {$a->quizname} шалгалтын хариултаа илгээгээгүй байна. Хэрэв та илгээх хэвээр бол  {$a->attemptgraceend}-с өмнө {$a->attemptsummaryurl} холбоосоор орно уу .';
$string['emailoverduesubject'] = 'Хугацаа хэтэрсэн оролдлого: {$a->quizname}';
$string['empty'] = 'Хоосон';
$string['enabled'] = 'Идэвхжүүлсэн';
$string['endtest'] = 'Оролдлогыг дуусгах...';
$string['erroraccessingreport'] = 'Та энэ тайланд хандах боломжгүй';
$string['errorinquestion'] = 'Асуулт дахь алдаа';
$string['errormissingquestion'] = 'Алдаа: {$a} дугаартай асуултыг системд орхисон байна.';
$string['errornotnumbers'] = 'Алдаа - хариулт нь тоон утгатай байх ёстой';
$string['errorunexpectedevent'] = '{$a->attemptid} хариулах оролдлогын {$a->questionid} асуултанд гэнэтийн арга хэмжээний код  {$a->event} олдлоо.';
$string['essay'] = 'Эсээ';
$string['essayquestions'] = 'Асуултууд';
$string['eventattemptautosaved'] = 'Оролдлого автоматаар хадгалагдсан';
$string['eventattemptdeleted'] = 'Оролдлого устгагдсан';
$string['eventattemptmanualgradingcomplete'] = 'Оролдлогод гар аргаар үнэлгээ хийж дууслаа';
$string['eventattemptpreviewstarted'] = 'Оролдлогыг урьдчилан харж эхэлсэн байна';
$string['eventattemptquestionrestarted'] = 'Оролдлогын асуулт ахин эхэлсэн';
$string['eventattemptreviewed'] = 'Оролдлогыг хянасан';
$string['eventattemptsummaryviewed'] = 'Оролдлогын тоймыг харсан';
$string['eventattemptupdated'] = 'Оролдлого шинэчлэгдсэн';
$string['eventattemptviewed'] = 'Оролдлогыг харсан';
$string['eventeditpageviewed'] = 'Шалгалт засварлах хуудсыг үзсэн байна';
$string['eventoverridecreated'] = 'Шалгалтыг хүчингүй болгох сонголт үүсгэсэн байна';
$string['eventoverridedeleted'] = 'Шалгалтыг хүчингүй болгох сонголтыг устгасан байна';
$string['eventoverrideupdated'] = 'Шалгалтыг хүчингүй болгох сонголтыг өөрчлөсөн байна';
$string['eventpagebreakcreated'] = 'Хуудас тусгаарлагч үүслээ';
$string['eventpagebreakdeleted'] = 'Хуудас тусгаарлагчийг устгасан';
$string['eventquestionmanuallygraded'] = 'Асуултыг гараар үнэлсэн';
$string['eventquizattemptabandoned'] = 'Оролдлогыг орхисон байна';
$string['eventquizattemptregraded'] = 'Оролдлогыг дахин үнэлсэн';
$string['eventquizattemptreopened'] = 'Оролдлогыг дахин нээсэн';
$string['eventquizattemptstarted'] = 'Оролдлогыг эхлүүлсэн';
$string['eventquizattemptsubmitted'] = 'Оролдлогыг илгээсэн байна';
$string['eventquizattempttimelimitexceeded'] = 'Оролдлогын хугацаа хэтэрсэн';
$string['eventquizgradeupdated'] = 'Шалгалтын үнэлгээ шинэчлэгдсэн';
$string['eventquizrepaginated'] = 'Шалгалтыг дахин хуудасласан';
$string['eventreportviewed'] = 'Шалгалтын тайланг үзсэн байна';
$string['eventsectionbreakcreated'] = 'Хэсгийн тусгаарлагч үүслээ';
$string['eventsectionbreakdeleted'] = 'Хэсгийн тусгаарлагчийг устгасан';
$string['eventsectionshuffleupdated'] = 'Хэсгийн холигч шинэчлэгдсэн';
$string['eventsectiontitleupdated'] = 'Хэсгийн гарчиг шинэчлэгдсэн';
$string['eventslotcreated'] = 'Слот үүссэн';
$string['eventslotdeleted'] = 'Слотыг устгасан';
$string['eventslotdisplayedquestionnumberupdated'] = 'Слот шинэчлэгдсэн асуултын дугаарыг харуулдаг';
$string['eventslotmarkupdated'] = 'Слот тэмдэглэгээг шинэчилсэн';
$string['eventslotmoved'] = 'Слотыг зөөсөн';
$string['eventslotrequirepreviousupdated'] = 'Слот өмнөх шинэчлэлтийг шаарддаг';
$string['everynquestions'] = '{$a} асуулт бүр';
$string['everyquestion'] = 'Асуулт бүр';
$string['everythingon'] = 'Бүгдийг идэвхжүүлэх';
$string['existingcategory'] = 'Одоогийн ангилал';
$string['exportcategory'] = 'Ангиллыг экспортлох';
$string['exporterror'] = 'Экспортлох явцад алдаа гарлаа';
$string['exportingquestions'] = 'Асуултуудыг файл руу экспортлож байна';
$string['exportname'] = 'Файлын нэр';
$string['exportquestions'] = 'Асуултуудыг файлруу экспортлох';
$string['extraattemptrestrictions'] = 'Оролдлогуудад тавигдах нэмэлт хоригууд';
$string['false'] = 'Худал';
$string['feedback'] = 'Зөвлөмж';
$string['feedbackerrorboundaryformat'] = 'Дүнтэй холбоотой зөвлөмж үнэлгээний зааг хувиар эсвэл тоогоор байх ёстой. {$a} заагт таны оруулсан  утга танигдахгүй байна.';
$string['feedbackerrorboundaryoutofrange'] = 'Дүнтэй холбоотой зөвлөмж үнэлгээний зааг 0% -ээс 100%-н хооронд байх ёстой. {$a} заагт таны оруулсан  утга хязгаараас хэтэрсэн байна.';
$string['feedbackerrorjunkinboundary'] = 'Та дүнтэй холбоотой зөвлөмж үнэлгээний заагийн хайрцагт ямар ч сул зай авалгүйгээр бөглөх ёстой.';
$string['feedbackerrorjunkinfeedback'] = 'Та зөвлөмжийн хайрцагт ямар ч сул зай үлдээлгүйгээр бөглөх ёстой.';
$string['feedbackerrororder'] = 'Дүнтэй холбоотой зөвлөмж үнэлгээний заагууд хамгийн өндөр нь эхэндээ орсон дэс дараалалтай байх ёстой. Таны {$a} заагт оруулсан утга дэс дараалалгүй байна.';
$string['file'] = 'Файл';
$string['fileformat'] = 'Файлын загвар';
$string['fillcorrect'] = 'Зөвийг бөглө';
$string['filloutnumericalanswer'] = 'Та хамгийн багадаа нэг боломжит хариулт мөн хязгаар оруулна. Эхний таарсан хариулт дүн болон зөвлөмж тодорхойлоход ашиглагдана. Хэрэв төгсгөлд нь хариултгүй зөвлөмж оруулсан бол, уг зөвлөмж нь хариулт нь аль ч хариулттай таараагүй суралцагсдад харагдана.';
$string['filloutoneanswer'] = 'Та хамгийн багадаа нэг боломжит хариулт оруулах ёстой. Хоосон орхисон хариултууд ашиглагдахгүй. \'*\' -г орлуулагч тэмдэг болгон ашиглаж дурын тэмдэгттэй тааруулж болно. Эхний таарсан хариулт дүн болон зөвлөмж тодорхойлоход ашиглагдана.';
$string['filloutthreequestions'] = 'Та харгалзуулах хариулттай дор хаяж 3 асуулт оруулах ёстой. Нэмэлт буруу хариултыг хоосон асуултад харгалзуулан оруулж болно. Асуулт, хариултын аль алиныг нь хоосон орхивол ашиглагдахгүй.';
$string['fillouttwochoices'] = 'Та хамгийн багадаа хоёр сонголт оруулах ёстой. Хоосон орхисон сонголт ашиглагдахгүй.';
$string['finishattemptdots'] = 'Оролдлогыг дуусгах...';
$string['finishreview'] = 'Хариулт хянахыг хаах';
$string['forceregeneration'] = 'хүчээр ахин үүсгэх';
$string['formatnotfound'] = 'Импорт/экспортын {$a} загвар олдсонгүй';
$string['formulaerror'] = 'Томъёоны алдаа!';
$string['fractionsaddwrong'] = 'Таны сонгосон эерэг дүн нь 100%-д нэмэгддэггүй.<br />Оронд нь, тэд {$a}% -д нэмэгддэг.<br />Буцаж очоод энэ асуултыг засахыг хүсэж байна уу?';
$string['fractionsnomax'] = 'Хариултуудын нэг нь 100% байх ёстой, ингэснээр<br />энэ асуултад бүрэн үнэлгээ авах боломжтой.<br /> Буцаж очоод энэ асуултыг засахыг хүсэж байна уу?';
$string['fromfile'] = 'файлаас:';
$string['functiondisabledbysecuremode'] = 'Тэр функцийг одоогоор идэвхгүйжүүлсэн байна';
$string['generalfeedback'] = 'Ерөнхий зөвлөмж';
$string['generalfeedback_help'] = 'Ерөнхий зөвлөмж бол асуултад хариулах оролдлого хийсний дараа харагддаг бичвэр юм. Тодорхой асуултад өгсөн хариултаас хамаардаг зөвлөмжөөс ялгаатай нь ерөнхий зөвлөмж үргэлж харагдаж байдаг.';
$string['gobacktoquiz'] = 'Буцах';
$string['graceperiod'] = 'Нэмэлт хугацаа';
$string['graceperiod_desc'] = 'Хугацаа дуусах үед хэрэв "Нэмэлт хугацаатай ..." гэж тохируулсан гэвэл энэ нь нэмэлтээр сунгагдах зөвшөөрөгдсөн хугацааны өгөгдмөл хэмжээ юм.';
$string['graceperiod_help'] = 'Хугацаа дуусах үед хэрэв "Нэмэлт хугацаатай ..." гэж тохируулсан гэвэл энэ нь нэмэлтээр сунгагдах зөвшөөрөгдсөн хугацааны өгөгдмөл хэмжээ юм.';
$string['graceperiodmin'] = 'Материал хүлээн авах нэмэлт эцсийн хугацаа';
$string['graceperiodmin_desc'] = 'Шалгалтын яг төгсгөлд асуудал үүсэх магадлалтай байдаг. Нэг талаас бид цаг нь дуусахад шалгалтын материалыг автоматаар илгээдэг таймерын тусламжтайгаар оюутнуудыг эцсийн секунд хүртэл хариулуулахыг хүсэж байдаг. Нөгөө талаас сервер хэт ачаалагдаж, хариултуудыг боловсруулахад багагүй хугацаа шаарддаг. Иймээс бид цаг дууссанаас хойш олон секундын дараа ирсэн хариултуудыг хүлээн авна, ингэснээр сервер удаан байсны улмаас хоцорч ирсэн хариултууд торгуулын оноо авахгүй. Гэсэн ч оюутан залилж, дээрх олон секундыг ашиглаж шалгалтын асуултаа гүйцээж болзошгүй. Шалгалтын үеэр өөрийн серверийн гүйцэтгэлд хэр их найдаж болоход үндэслэн шийдвэр гаргах хэрэгтэй болно.';
$string['graceperiodtoosmall'] = 'Нэмэлт хугацаа {$a}-с урт байх ёстой.';
$string['grade'] = 'Дүн';
$string['gradeall'] = 'Бүгдэд дүн тавих';
$string['gradeaverage'] = 'Дундаж оноо';
$string['gradeboundary'] = 'Дүнгийн зааг';
$string['gradeessays'] = 'Эсээг дүгнэх';
$string['gradehighest'] = 'Хамгийн өндөр дүн';
$string['grademethod'] = 'Дүгнэх аргачлал';
$string['grademethod_help'] = 'Олон удаа шалгалт өгөхийг зөвшөөрсөн бол, шалгалтын эцсийн дүнг тооцоолоход дараах аргуудыг ашиглана:

* Бүх оролдлогуудын хамгийн өндөр дүн
* Бүх оролдлогуудын дундаж дүн
* Эхний оролдлогын дүн (бусад бүх оролдлогуудыг тооцохгүй)
* Сүүлийн оролдлогын дүн (бусад бүх оролдлогуудыг тооцохгүй)';
$string['gradesdeleted'] = 'Шалгалтын дүнгүүдийг устгасан';
$string['gradesofar'] = '{$a->method}: {$a->mygrade} / {$a->quizgrade}.';
$string['gradetopassmustbeset'] = 'Энэ шалгалт нь тэнцэх үнэлгээ шаардахаар тохируулсан тул тэнцэх үнэлгээг 0-ээр өгөх боломжгүй. Тэг биш утга тохируулна уу.';
$string['gradetopassnotset'] = 'Энэ шалгалтад тэнцэх үнэлгээ хараахан байхгүй байна. Үүнийг шалгалтын тохиргооны Үнэлгээний хэсэгт тохируулж болно.';
$string['gradetopassoutof'] = 'Тэнцэх үнэлгээ: {$a->maxgrade}- аас {$a->grade}';
$string['gradingdetails'] = 'Энэ материалын үнэлгээ: {$a->raw}/{$a->max}.';
$string['gradingdetailsadjustment'] = 'Өмнөх торгуулиудтай хамт <strong>{$a->cur}/{$a->max}</strong>';
$string['gradingdetailspenalty'] = 'Энэ материалд {$a} торгууль ногдуулсан.';
$string['gradingdetailszeropenalty'] = 'Та энэ материалын хувьд торгууль авахгүй.';
$string['gradingmethod'] = 'Үнэлэх аргачлал: {$a}';
$string['groupoverrides'] = 'Бүлгийн дахин тодорхойлолт';
$string['groupoverridesdeleted'] = 'Бүлгийн дахин тодорхойлолтыг устгасан';
$string['groupsnone'] = 'Таны орж болох бүлэг алга байна.';
$string['guestsno'] = 'Уучлаарай, зочин хэрэглэгч шалгалт өгөх, харах боломжгүй.';
$string['hidebreaks'] = 'Хуудас тусгаарлагчуудыг нуух';
$string['hidereordertool'] = 'Дахин эрэмбэлэх хэрэгслийг нуух';
$string['history'] = 'Хариултуудын түүх:';
$string['howquestionsbehave_desc'] = 'Шалгалтад асуулт хэрхэн ажиллах өгөгдмөл тохиргоо';
$string['imagedisplay'] = 'Дэлгэцэнд харуулах зураг';
$string['import_help'] = 'Энэ функц нь текст файлаас асуулт импортлох боломж олгоно.

Хэрэв таны файл ascii биш тэмдэгт агуулсан бол UTF-8 кодчилол ашиглах ёстой.  Microsoft Office-ийн программ ашиглан үүсгэсэн файлууд ихэвчлэн тусгай кодчилол ашигласан байдаг тул зөв импортлогдохгүй байх магадлалтай тул анхааралдаа авна уу.

Импорт болон Экспортын загварууд нь залгаж зөөвөрлөдөг хэрэгслүүд байдаг. Бусад нэмэлт загварууд нь Модул болон Нэмэлт хэрэгсэл санд байдаг.';
$string['import_link'] = 'question/import';
$string['importcategory'] = 'импортын ангилал';
$string['importerror'] = 'Импортлох явцад алдаа гарлаа';
$string['importfilearea'] = 'Хичээлийн файлууд байгаа газраас файл импортлох...';
$string['importfileupload'] = 'Байршуулсан файлаас импортлох';
$string['importfromthisfile'] = 'Энэ файлаас импортлох';
$string['importingquestions'] = 'Файлаас  {$a} асуулт импортлож байна';
$string['importmax10error'] = 'Энэ асуултанд алдаа байна. Та арваас илvv хариулт оруулаагvй байж магадгvй.';
$string['importmaxerror'] = 'Асуултанд алдаа байна. Тэнд маш олон хариулт байна.';
$string['importquestions'] = 'Файлаас асуулт импортлох';
$string['inactiveoverridehelp'] = '* Хэрэглэгчийн энэ үйл ажиллагаанд оролцох хандалтыг хязгаарласан тул дахин тохируулга идэвхгүй байна. Энэ нь баг эсвэл үүргийн хуваарилалт, бусад хандалтын хязгаарлалт эсвэл тухайн үйл ажиллагаа нууцлагдсан байгаа зэргээс болсон байж болно.';
$string['incorrect'] = 'Буруу';
$string['indicator:cognitivedepth'] = 'Танин мэдэхүйн сорил';
$string['indicator:cognitivedepth_help'] = 'Энэ үзүүлэлт нь Шалгалтад хамрагдсан суралцагчийн хүрсэн танин мэдэхүйн түвшинд үндэслэнэ.';
$string['indicator:cognitivedepthdef'] = 'Танин мэдэхүйн сорил';
$string['indicator:cognitivedepthdef_help'] = 'Суралцагч энэхүү шинжилгээний интервалын хугацаанд шалгалтаас санал болгож буй танин мэдэхүйн оролцооны энэ хувь хэмжээнд хүрсэн байна (Түвшин = Харах боломжгүй, Харах, Илгээх, Зөвлөмж харах, Зөвлөмжийн талаар сэтгэгдэл бичих, Зөвлөмжийг үзсэний дараа дахин илгээх)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Нийгмийн сорил';
$string['indicator:socialbreadth_help'] = 'Энэ үзүүлэлт нь Шалгалтад хамрагдсан суралцагчийн хүрсэн нийгмийн түвшинд үндэслэнэ.';
$string['indicator:socialbreadthdef'] = 'Нийгмийн сорил';
$string['indicator:socialbreadthdef_help'] = 'Суралцагч энэхүү шинжилгээний интервалын хугацаанд шалгалтаас санал болгож буй нийгмийн оролцооны энэ хувь хэмжээнд хүрсэн байна (Түвшин = Оролцоогүй, Ганцаараа оролцсон, Бусадтай хамт оролцсон)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['indivresp'] = 'Зүйл тус бүрт хариулсан хүмүүсийн хариултууд';
$string['info'] = 'Мэдээлэл';
$string['infoshort'] = 'i';
$string['initialnumfeedbacks'] = 'Ерөнхий зөвлөмж талбарын анхны тоо';
$string['initialnumfeedbacks_desc'] = 'Шинэ шалгалт үүсгэх үед ийм тооны хоосон хайрцгийг зөвлөмжид зориулан үүсгэнэ. Шалгалтын хуудас үүсмэгц маягт нь шалгалтад шаардагдах хэмжээний зөвлөмжийн талбарыг харуулна.';
$string['inprogress'] = 'Ажиллаж байна';
$string['introduction'] = 'Тайлбар';
$string['invalidattemptid'] = 'Оролдлогын ийм  ID  байхгүй байна';
$string['invalidcategory'] = 'Ангиллын ID  буруу байна';
$string['invalidoverrideid'] = 'Хүчингүй болгох id  буруу';
$string['invalidquestionid'] = 'Асуултын id  буруу';
$string['invalidquizid'] = 'Шалгалтын  ID буруу';
$string['invalidrandomslot'] = 'Санамсаргүй сонгох асуултын слот ID буруу байна';
$string['invalidsource'] = 'Эх сурвалжийг хүчинтэй гэж үзээгүй.';
$string['invalidsourcetype'] = 'Эх сурвалжийн төрөл нь буруу';
$string['invalidstateid'] = 'Төлвийн id буруу';
$string['lastanswer'] = 'Таны сүүлийн хариулт бол';
$string['layout'] = 'Бүтэц';
$string['layoutasshown'] = 'Хуудасны бүтэц үзүүлсэнээр байна.';
$string['layoutasshownwithpages'] = 'Хуудасны бүтэц үзүүлсэнээр байна. <small>({$a} асуулт бүрт шинэ хуудас автоматаар үүснэ.)</small>';
$string['layoutshuffledandpaged'] = 'Хуудас бүрт {$a} асуулттай санамсаргүй байдлаар хольсон асуултууд.';
$string['layoutshuffledsinglepage'] = 'Нэг хуудас дээрх асуултууд бүгд санамсаргүй байдлаар холигдсон.';
$string['link'] = 'Холбоос';
$string['listitems'] = 'Шалгалт дахь зүйлсийн жагсаалт';
$string['literal'] = 'Үгчилсэн';
$string['loadingquestionsfailed'] = 'Асуултуудыг ачаалах явц амжилтгүй боллоо: {$a}';
$string['makecopy'] = 'Шинэ асуулт болгож хадгалах';
$string['managetypes'] = 'Сервер болон  асуултын төрлийг удирдах';
$string['manualgradequestion'] = '{$a->хэрэглэгч} {$a->quiz} доторх {$a->асуулт} асуултыг гараар үнэлнэ';
$string['manualgrading'] = 'Үнэлэх';
$string['mark'] = 'Илгээх';
$string['markall'] = 'Хуудас илгээх';
$string['marks'] = 'Тэмдэглэгээ';
$string['marks_help'] = 'Асуулт бүр дэх тоон тэмдэглэгээ ба нийт оролдлогын оноо.';
$string['match'] = 'Харгалзуулах';
$string['matchanswer'] = 'Харгалзуулах хариулт';
$string['matchanswerno'] = 'Харгалзуулах хариулт {$a}';
$string['max'] = 'Хамгийн их';
$string['maxmark'] = 'Хамгийн их тэмдэглэгээ';
$string['maxmarks'] = 'Хамгийн их оноо';
$string['maxmarks_help'] = 'Хамгийн их оноо нь дүнгийн мэдээллийг нуух эсэх эсвэл хэрхэн харагдахыг тодорхойлдог.

* Дүнгийн мэдээллийг бүрэн нуухын тулд энэ чагтыг авна (Тэмдэглэгээ нүд автоматаар идэвхгүй байдаг).

* Зөвхөн хамгийн их оноог харуулахын тулд: Тэмдэглэгээ нүдийг бус зөвхөн энэ нүдийг чагтална уу.
* Хамгийн их оноо болон оноонуудыг хамтад нь харуулахын тулд энэ нүдийг мөн тэмдэглэгээ нүдийг чагтална уу.';
$string['messageprovider:attempt_grading_complete'] = 'Шалгалт дүгнэгдсэн тухай мэдэгдэл';
$string['messageprovider:attempt_overdue'] = 'Шалгалтанд хариулах хугацаа хэтрэхэд анхааруулга өгөх';
$string['messageprovider:confirmation'] = 'Өөрийн шалгалтыг илгээсэн тухай  баталгаажуулалт';
$string['messageprovider:submission'] = 'Оюутнууд шалгалт илгээсэн тухай мэдэгдэл';
$string['min'] = 'Хамгийн бага';
$string['minutes'] = 'Минут';
$string['missingcorrectanswer'] = 'Зөв хариултыг онцолсон байх ёстой..';
$string['missingitemtypename'] = 'Нэр орхисон';
$string['missingquestion'] = 'Энэ асуулт байхгүй болсон байна';
$string['modulename'] = 'Шалгалт';
$string['modulename_help'] = 'Шалгалт үйл ажиллагаа нь олон сонголтот, харгалзуулах, богино-хариултат болон тоон гэсэн төрөл бүрийн асуултын хэлбэрийг багтаасан шалгалт үүсгэхийг боломжийг багшид олгодог.

Багш сорилын сангаас санамсаргүйгээр сонгогдох асуултууд оруулж эсвэл асуултуудыг хооронд нь холих тохиргоо хийснээр олон удаа өгөх боломжтой шалгалт үүсгэж болно. Мөн хугацааны хязгаар тавьж болно.

Шалгалт өгөх оролдлого бүрийн эсээ төрлийн асуултаас бусад хэлбэр нь автоматаар дүгнэгдэж, дүнгийн дэвтэрт бичигдэнэ.

Сануулга, зөвлөмж болон зөв хариултуудыг оюутнуудад  хэзээ харагдуулахаа багш сонгож болно.

Шалгалтууд нь

* Хичээлийн шалгалт,
* Сэдвийн төгсгөлд эсвэл унших даалгаврын богино хэмжээний сорил,
* Өмнөх шалгалтын асуултуудыг ашигласан туршилт шалгалт,
* Гүйцэтгэлийн тухай шууд зөвлөмж хүргэхэд,
* Өөрийн үнэлгээ байдлаар тус тус ашиглагдаж болно.';
$string['modulename_link'] = 'mod/quiz/view';
$string['modulenameplural'] = 'Шалгалтууд';
$string['moveselectedonpage'] = 'Сонгосон асуултуудыг хуудас руу шилжүүлэх: {$a}';
$string['multichoice'] = 'Олон сонголттой';
$string['multipleanswers'] = 'Хамгийн багадаа нэг хариулт сонго.';
$string['mustbesubmittedby'] = 'Энэ хариултыг  {$a} илгээсэн байх ёстой.';
$string['name'] = 'Нэр';
$string['navigatenext'] = 'Дараагийн хуудас';
$string['navigateprevious'] = 'Өмнөх хуудас';
$string['navmethod'] = 'Удирдлагын арга';
$string['navmethod_free'] = 'Чөлөөт';
$string['navmethod_help'] = 'Дэс дараалалтай удирдлага идэвхжүүлсэн бол суралцагч шалгалтын материалыг дарааллын дагуу үзэж, хариулах ба өмнөх хуудсууд руу очих, дараагийн хуудсууд руу очих боломжгүй байна.';
$string['navmethod_seq'] = 'Эрэмбэтэй';
$string['navnojswarning'] = 'Анхаар: эдгээр холбоосууд таны хариултуудыг хадгалахгүй. Хуудасны доор байрлах дараагийн гэсэн товчийг ашигла.';
$string['neverallononepage'] = 'Нэг хуудас дээр бүх асуултуудыг хэзээ ч битгий оруул';
$string['newattemptfail'] = 'Алдаа: энэ шалгалтанд шинэ оролдлого эхлэх боломжгvй байна.';
$string['newcategory'] = 'Шинэ ангилал';
$string['newpage'] = 'Шинэ хуудас';
$string['newpage_help'] = 'Их асуулттай шалгалтын хувьд, нэг хуудаст харуулах асуултын тоог хязгаарласнаар асуултуудыг хэд хэдэн хуудас дамжуулан байрлуулах нь илүү дээр. Шалгалтын хуудсанд асуулт нэмэхэд энэ тохиргооны дагуу хуудас тусгаарлагч автоматаар орж ирнэ. Гэсэн ч хуудас тусгаарлагчийг дараа нь хуудас засварлах тохиргооноос гараар арилгаж болно.';
$string['newpageevery'] = 'Автоматаар шинэ хуудас эхлүүлэх';
$string['newsectionheading'] = 'Шинэ гарчиг';
$string['noanswers'] = 'Хариуг сонгоогvй байна.';
$string['noattempts'] = 'Энэ шалгалт дээр оролдлогууд хийгдээгvй байна.';
$string['noattemptsfound'] = 'Оролдлого олдсонгүй.';
$string['noattemptstoshow'] = 'Тэнд харуулах оролдлогууд алга';
$string['nocategory'] = 'Буруу ангилал заасан эсвэл ангилал заагаагүй байна';
$string['noclose'] = 'Хаах огноо байхгүй';
$string['nocommentsyet'] = 'Одоогоор тайлбар оруулаагүй байна';
$string['noconnection'] = 'Одоогоор энэ асуултыг боловсруулах веб үйлчилгээтэй холбогдоогүй байна. Администратортайгаа холбогдоно уу';
$string['nodataset'] = 'nothing - энэ нь хөрвөх тэмдэг биш';
$string['nodatasubmitted'] = 'Ямар ч өгөгдөл илгээгдээгүй.';
$string['noessayquestionsfound'] = 'Гараар үнэлгээ хийсэн асуултууд олдсонгүй';
$string['nogradewarning'] = 'Энэ шалгалт дүгнэгдээгүй байна, тиймээс та дүнгээс хамаарах нэгдсэн зөвлөмж тохируулж чадахгүй.';
$string['nomoreattempts'] = 'Дахиж оролдлого хийхийг зөвшөөрөхгүй';
$string['none'] = 'Байхгүй';
$string['noopen'] = 'Эхлэх огноо байхгүй байна';
$string['nooverridedata'] = 'Та хамгийн багадаа нэг шалгалтын тохиргоог хүчингүй болгох ёстой.';
$string['nopossibledatasets'] = 'Боломжит өгөгдлийн сан алга байна';
$string['noquestionintext'] = 'Асуултын бичвэр нь ямар ч эмбэдэд асуулт агуулаагvй.';
$string['noquestions'] = 'Асуултууд хараахан нэмэгдээгvй байна.';
$string['noquestionsfound'] = 'Асуулт олдсонгvй';
$string['noquestionsinquiz'] = 'Энэ шалгалтанд ямар ч асуулт алга.';
$string['noquestionsnotinuse'] = 'Ангилал нь хоосон болохоор энэ санамсаргүй сонгогдох асуулт ашиглагдахгүй.';
$string['noquestionsonpage'] = 'Хоосон хуудас';
$string['noresponse'] = 'Хариулт байхгүй байна';
$string['noreview'] = 'Та энэ шалгалтыг хянах эрхгүй байна.';
$string['noreviewattempt'] = 'Танд энэ оролдлогыг хянах эрх олгогдоогүй байна.';
$string['noreviewshort'] = 'Зөвшөөрөгдөөгүй';
$string['noreviewuntil'] = '{$a} хүртэл энэ шалгалтыг хянах боломжгүй байна.';
$string['noreviewuntilshort'] = 'Боломжтой {$a}';
$string['noscript'] = 'Үргэлжлүүлэхийн тулд Жаваскриптийг идэвхжүүлсэн байх шаардлагатай!';
$string['notavailabletostudents'] = 'Санамж: Энэ шалгалтад таны суралцагчид хандах боломжгүй байна.';
$string['notenoughrandomquestions'] = '{$a->category} ангилалд {$a->name} ({$a->id}) асуулт үүсгэх хангалттай асуулт байхгүй байна.';
$string['notenoughsubquestions'] = 'Хангалттай дэд асуултууд тодорхойлогдоогүй байна!<br />Та буцаж очоод энэ асуултыг засмаар байна уу?';
$string['notifyattemptsgradedtask'] = 'Оролдлогыг үнэлсэн тухай мэдэгдлийг илгээх';
$string['notimedependentitems'] = 'Шалгалтын модуль нь одоогоор хугацаанаас хамааралтай зүйлсийг дэмждэггүй. Иймд шалгалтын нийт хугацааны хязгаарыг тохируулах хэрэгтэй. Та өөр зүйл сонгохыг хүсэж байна уу (эсвэл энэ сонгосон байгаа зүйлээ ашиглах)?';
$string['notyetgraded'] = 'Үнэлгээ хараахан хийгдээгүй';
$string['notyetviewed'] = 'Үзэж амжаагүй';
$string['notyourattempt'] = 'Энэ таны оролдлого биш байна!';
$string['noview'] = 'Холбогдсон хэрэглэгчид энэ шалгалтыг үзэх зөвшөөрөл олгоогүй байна';
$string['numattempts'] = '{$a->studentnum} {$a->studentstring}  {$a->attemptnum} хариулт хийсэн байна';
$string['numberabbr'] = '#';
$string['numerical'] = 'Тоон';
$string['numquestionsx'] = 'Асуултууд: {$a}';
$string['oneminute'] = 'Нэг минут';
$string['onlyteachersexport'] = 'Зөвхөн багш нар асуултыг экспортолж болно';
$string['onlyteachersimport'] = 'Зөвхөн засвар оруулах эрхтэй багш нар асуултуудыг экспортлож болно';
$string['onthispage'] = 'Энэ хуудас';
$string['open'] = 'Хариулаагүй';
$string['openafterclose'] = 'Шалгалтыг шинэчилж чадсангүй. Та шалгалт нээх өдрөө шалгалт хаах өдрийн дараа байхаар тохируулсан байна.';
$string['openclosedatesupdated'] = 'Шалгалт нээх болон хаах огноонууд шинэчлэгдлээ';
$string['optional'] = 'сонголтоор';
$string['orderandpaging'] = 'Дараалал ба хуудаслалт';
$string['orderandpaging_help'] = '10, 20, 30, ... зэрэг асуулт бүрийн эсрэг талын тоонууд асуултуудын дэс дарааллыг заана. Нэмэлт асуулт оруулах зай үлдээхийн тулд дугаар нь 10 аар нэмэгдэнэ. Асуултуудыг дахин эрэмбэлэхийн тулд, тоонуудыг өөрчлөөд, "Асуултуудыг дахин эрэмбэл" гэсэн товчийг дарна.

Тодорхой асуултуудын ард хуудас тусгаарлагч нэмэхдээ, асуултын хажуугийн чагтан нүдийг сонгож, "Сонгосон асуултын дараа шинэ хуудас нэмэх" гэсэн товчийг дарна.

Олон хуудас дамжуулан асуултуудыг эрэмбэлэхдээ, Дахин хуудаслах гэсэн товчийг дарж, нэг хуудаст харуулахыг хүссэн асуултын тоог сонгоно.';
$string['orderingquiz'] = 'Дараалал ба хуудаслалт';
$string['orderingquizx'] = 'Дараалал ба хуудаслалт: {$a}';
$string['outcomesadvanced'] = 'Гарсан үр дүнгүүд нь сайжруулсан тохиргоо болно';
$string['outof'] = 'Хамгийн ихдээ {$a->maxgrade} авахаас {$a->grade} авлаа.';
$string['outofpercent'] = 'Хамгийн ихдээ {$a->maxgrade} ({$a->percent}%) авахаас {$a->grade}';
$string['outofshort'] = '{$a->grade}/{$a->maxgrade}';
$string['overallfeedback'] = 'Ерөнхий зөвлөмж';
$string['overallfeedback_help'] = 'Ерөнхий зөвлөмж нь шалгалтыг хийж үзсэний дараа харуулах бичвэр юм. Нэмэлтээр үнэлгээний хязгаар зааж өгснөөр(тоогоор эсвэл хувиар) бичвэр нь авсан үнэлгээнээс хамаарч харагдаж болно.';
$string['overdue'] = 'Хугацаа хэтэрсэн';
$string['overduehandling'] = 'Хугацаа дуусах үед';
$string['overduehandling_desc'] = 'Хэрэв суралцагч шалгалтыг цаг дуусахаас өмнө илгээхгүй бол өгөгдмөл тохиргоогоор юу хийх ёстой вэ.';
$string['overduehandling_help'] = 'Энэ тохиргоогоор суралцагч цаг дуусахаас өмнө шалгалтаа илгээж амжаагүй үед юу болохыг хянадаг. Хэрэв суралцагч тухайн цагт асуултад хариулаад завгүй байвал, цагийн тоолуур суралцагчийн өмнөөс шалгалтыг автоматаар илгээх боловч хэрэв суралцагч системээс гарсан бол ямар үйлдэл хийж болохыг энэ тохиргоогоор шийднэ.';
$string['overduehandling_link'] = 'mod/quiz/timing';
$string['overduehandlingautoabandon'] = 'Шалгалтаа цаг дуусахаас өмнө илгээсэн байх ёстой, үгүй бол шалгалтыг тооцохгүй';
$string['overduehandlingautosubmit'] = 'Нээлттэй шалгалтууд автоматаар илгээгдэнэ';
$string['overduehandlinggraceperiod'] = 'Нээлттэй шалгалтыг илгээж болох нэмэлт хугацаа бий, гэхдээ тэр хугацаанд асуултанд хариулж болохгүй';
$string['overduemustbesubmittedby'] = 'Энэ оролдлогын хугацаа хэтэрсэн байна. Үүнийг аль эрт илгээх ёстой байсан. Хэрэв та энэ шалгалтыг үнэлүүлэх хүсэлтэй байгаа бол, {$a} гэхэд илгээх ёстой. Хэрэв энэ хугацаанд илгээгээгүй бол, энэ оролдлогын үеэр авсан оноог тооцохгүй.';
$string['override'] = 'Хүчингүй болгох/арилгах';
$string['overridedeletegroupsure'] = 'Та {$a} бүлгийг арилгахдаа итгэлтэй байна уу?';
$string['overridedeleteusersure'] = 'Та {$a} хэрэглэгчийг арилгахдаа  итгэлтэй байна уу?';
$string['overridegroup'] = 'Бүлгийг арилгах';
$string['overridegroupeventname'] = '{$a->group} - {$a->quiz}';
$string['overrides'] = 'Хүчингүй болгох/арилгах';
$string['overridesforquiz'] = 'Тохиргоог хүчингүй болгох: {$a}';
$string['overridesnoneforgroups'] = 'Энэ шалгалтад ямар ч бүлгийн тохиргоог хүчингүй болгосон зүйл байхгүй.';
$string['overridesnoneforusers'] = 'Энэ шалгалтад  хэрэглэгчийн тохиргоог хүчингүй болгосон зүйл байхгүй.';
$string['overridessummary'] = 'Тохиргоог хүчингүй болгосон ({$a})';
$string['overridessummarygroup'] = 'Бүлгүүд: {$a}';
$string['overridessummarythisgroup'] = 'Энэ бүлэгт ({$a}) тохиргоог хүчингүй болгосон';
$string['overridessummaryuser'] = 'Хэрэглэгчид: {$a}';
$string['overridessummaryyourgroups'] = 'Таны бүлгүүдэд ({$a}) тохиргоо хүчингүй болсон байна';
$string['overrideuser'] = 'Хэрэглэгчийг хүчингүй болгох';
$string['overrideusereventname'] = '{$a->quiz} - Хүчингүй болгох';
$string['page-mod-quiz-attempt'] = 'Оролдлогын хуудас';
$string['page-mod-quiz-edit'] = 'Шалгалтын хуудас засварлах';
$string['page-mod-quiz-report'] = 'Шалгалтын тайлангийн дурын хуудас';
$string['page-mod-quiz-review'] = 'Оролдлогыг хянах хуудас';
$string['page-mod-quiz-summary'] = 'Оролдлогын дүгнэлт хуудас';
$string['page-mod-quiz-view'] = 'Шалгалтын мэдээллийн хуудас';
$string['page-mod-quiz-x'] = 'Шалгалтын модулын дурын хуудас';
$string['pageshort'] = 'P';
$string['pagesize'] = 'Хуудасны хэмжээ';
$string['parent'] = 'Эх';
$string['parentcategory'] = 'Эх ангилал';
$string['parsingquestions'] = 'Импортлосон файлаас асуулт ялгах';
$string['partiallycorrect'] = 'Хэсэг нь зөв';
$string['penalty'] = 'Торгууль';
$string['penaltyscheme'] = 'Торгууль өгөх';
$string['penaltyscheme_help'] = 'Хэрэв идэвхжүүлсэн бол, буруу хариулсан асуулт бүрээр эцсийн дүнгээс торгуулын оноо хасагдана. Торгуулын  хэмжээг асуултын тохиргоонд зааж өгнө. Зөвхөн хялбаршуулсан горимыг идэвхжүүлсэн үед энэ тохиргоо хүчинтэй.';
$string['percentcorrect'] = 'Зөв хариултын хувь';
$string['pleaseclose'] = 'Таны хүсэлтийг боловсрууллаа. Одоо энэ цонхыг хааж болно.';
$string['pluginadministration'] = 'Шалгалтын удирдлага';
$string['pluginname'] = 'Шалгалт';
$string['popup'] = 'Шалгалтыг "найдвартай" цонхонд харуулах';
$string['popupblockerwarning'] = 'Тестийн энэ сейшн аюулгүй горимд байна, энэ нь та шалгалтыг найдвартай аюулгүй цонхонд өгөх шаардлагатай гэсэн үг. Нээгдэх цонх хориглогчийг идэвхгүй болгоно уу. Баярлалаа.';
$string['popupnotice'] = 'Суралцагчид энэ шалгалтыг найдвартай цонхноос үзнэ.';
$string['preprocesserror'] = 'Урьдчилсан боловсруулалт хийх үед алдаа гарлаа!';
$string['preview'] = 'Урьдчилан харах';
$string['previewquestion'] = 'Асуултыг урьдчилан харах';
$string['previewquiz'] = 'Урьдчилан харах {$a}';
$string['previewquiznow'] = 'Шалгалтыг одоо урьдчилан харах';
$string['previewquizstart'] = 'Шалгалтыг урьдчилан харах';
$string['previous'] = 'Өмнөх төлөв';
$string['privacy:metadata:core_question'] = 'Шалгалт нь асуулт ашиглалтын мэдээллийг core_question дэд системд хадгалдаг.';
$string['privacy:metadata:quiz'] = 'Шалгалт нь шалгалтын тайланг ашигладаг';
$string['privacy:metadata:quiz_attempts'] = 'Оролдлого бүрийн дэлгэрэнгүй мэдээлэл';
$string['privacy:metadata:quiz_attempts:attempt'] = 'Оролдлогын дугаар.';
$string['privacy:metadata:quiz_attempts:currentpage'] = 'Хэрэглэгчийн одоогийн байгаа хуудас';
$string['privacy:metadata:quiz_attempts:gradednotificationsenttime'] = 'Оролдлогыг гараар дүгнэж дууссан гэж мэдэгдсэн хугацаа';
$string['privacy:metadata:quiz_attempts:preview'] = 'Энэ нь шалгалтын урьдчилж харах хэсэг эсэх.';
$string['privacy:metadata:quiz_attempts:state'] = 'Оролдлогын одоогийн төлөв.';
$string['privacy:metadata:quiz_attempts:sumgrades'] = 'Оролдлого дахь үнэлгээний нийлбэр.';
$string['privacy:metadata:quiz_attempts:timecheckstate'] = 'Төлөв шалгасан хугацаа';
$string['privacy:metadata:quiz_attempts:timefinish'] = 'Оролдлогыг хийж дууссан хугацаа';
$string['privacy:metadata:quiz_attempts:timemodified'] = 'Оролдлогыг шинэчилсэн хугацаа';
$string['privacy:metadata:quiz_attempts:timemodifiedoffline'] = 'Офлайн шинэчлэлтээр оролдлогыг шинэчилсэн хугацаа';
$string['privacy:metadata:quiz_attempts:timestart'] = 'Оролдлого эхэлсэн хугацаа';
$string['privacy:metadata:quiz_grades'] = 'Энэ шалгалтын ерөнхий дүнгийн талаарх дэлгэрэнгүй мэдээлэл.';
$string['privacy:metadata:quiz_grades:grade'] = 'Энэ шалгалтын ерөнхий дүн.';
$string['privacy:metadata:quiz_grades:quiz'] = 'Дүгнэгдсэн шалгалт.';
$string['privacy:metadata:quiz_grades:timemodified'] = 'Үнэлгээ өөрчлөгдсөн хугацаа.';
$string['privacy:metadata:quiz_grades:userid'] = 'Үнэлгээ авсан хэрэглэгч.';
$string['privacy:metadata:quiz_overrides'] = 'Энэ шалгалтыг хүчингүйд тооцох тухай дэлгэрэнгүй мэдээлэл';
$string['privacy:metadata:quiz_overrides:quiz'] = 'Хүчингүй болгох мэдээлэл бүхий шалгалт';
$string['privacy:metadata:quiz_overrides:timeclose'] = 'Шалгалтын шинэчлэгдсэн хаагдах хугацаа';
$string['privacy:metadata:quiz_overrides:timelimit'] = 'Шалгалтын шинэчлэгдсэн хугацааны хязгаар';
$string['privacy:metadata:quiz_overrides:timeopen'] = 'Шалгалтын шинэчлэгдсэн нээгдэх хугацаа';
$string['privacy:metadata:quiz_overrides:userid'] = 'Хүчингүй болсон хэрэглэгч';
$string['privacy:metadata:quizaccess'] = 'Шалгалт нь шалгалтад хандах дүрмийг ашигладаг.';
$string['publish'] = 'Нийтлэх';
$string['publishedit'] = 'Энэ ангилалд асуулт нэмэх эсвэл засварлахын тулд нийтлэгдсэн хичээлд зөвшөөрөл авсан байх ёстой.';
$string['qbrief'] = 'Асуулт. {$a}';
$string['qname'] = 'нэр';
$string['qti'] = 'IMS QTI загвар';
$string['qtypename'] = 'төрөл, нэр';
$string['question'] = 'Асуулт';
$string['questionbank'] = 'сорилын сангаас';
$string['questionbankmanagement'] = 'Сорилын сангийн зохицуулалт';
$string['questionbehaviour'] = 'Асуултын харагдах байдал';
$string['questioncats'] = 'Асуултын ангиллууд';
$string['questiondeleted'] = 'Энэ асуултыг устгасан байна. Багштайгаа холбогдоно уу.';
$string['questiondependencyadd'] = '{$a->thisq} асуултыг оролдоход ямар нэг хязгаарлалт байхгүй • Өөрчлөхийн тулд товшино уу';
$string['questiondependencyfree'] = 'Энэ асуултад ямар нэг хязгаарлалт байхгүй';
$string['questiondependencyremove'] = 'Өмнөх {$a->previousq} асуултыг бөглөх хүртэл {$a->thisq} асуултад хариулах боломжгүй • Өөрчлөхийн тулд товшино уу';
$string['questiondependsonprevious'] = 'Өмнөх асуултыг дуусгахаас нааш энэ асуултыг бөглөх боломжгүй';
$string['questiondraftonly'] = '{$a} асуулт ноорог төлөвт байна. Шалгалтад ашиглахын тулд сорилын сан руу очиж төлөвийг нь бэлэн болгож өөрчилнө үү.';
$string['questiondraftwillnotwork'] = 'Энэ асуулт ноорог төлөвт байна. Шалгалтад ашиглахын тулд сорилын сан руу очиж төлөвийг нь бэлэн болгож өөрчилнө үү.';
$string['questioninuse'] = '\'{$a->questionname}\' асуултыг одоогоор дараах хэсэгт ашиглаж байна: <br />{$a->quiznames<br />Уг асуулт нь эдгээр шалгалтаас устгагдахгүй, зөвхөн ангиллын жагсаалтаас устгагдана.';
$string['questionmissing'] = 'Энэ сейшний асуулт алга болсон байна';
$string['questionname'] = 'Асуултын нэр';
$string['questionnonav'] = '<span class="accesshide">Асуулт</span>{$a->number}<span class="accesshide"> {$a->attributes}</span>';
$string['questionnonavinfo'] = '<span class="accesshide">Мэдээлэл</span>{$a->number}<span class="accesshide"> {$a->attributes}</span>';
$string['questionnotloaded'] = '{$a} асуулт өгөгдлийн сангаас ачаалагдаагүй байна';
$string['questionorder'] = 'Асуултын дараалал';
$string['questionposition'] = '{$a} асуултын дараалал дахь шинэ байрлал';
$string['questions'] = 'Асуултууд';
$string['questionsetpreview'] = 'Асуултын багцыг урьдчилан харах';
$string['questionsinclhidden'] = 'Асуултууд (нууцлагдсан асуултыг оролцуулсан)';
$string['questionsinthisquiz'] = 'Энэ шалгалтын асуултууд';
$string['questionsmatchingfilter'] = 'Хайлтад тохирсон асуултууд: {$a}';
$string['questionsperpage'] = 'Нэг хуудсанд харагдах асуулт';
$string['questionsperpageselected'] = 'Нэг хуудсанд харагдах асуултыг тохируулсан тул хуудаслалт тогтоогдсон байна. Иймээс, хуудаслалтын тохиргоог идэвхгүй болголоо. Та үүнийг {$a}-д өөрчилж болно.';
$string['questionsperpagex'] = 'Нэг хуудсанд харагдах асуулт: {$a}';
$string['questiontext'] = 'Асуултын бичвэр';
$string['questiontextisempty'] = '[Асуултын бичвэрийг хоослох]';
$string['questiontype'] = 'Асуултын төрөл {$a}';
$string['questiontypesetupoptions'] = 'Асуултын төрлийн тохиргооны сонголт:';
$string['questionversion'] = 'Хувилбар {$a}';
$string['questionversionlatest'] = 'Хувилбар {$a} (Сүүлийнх)';
$string['quiz:addinstance'] = 'Шалгалт шинээр нэмэх';
$string['quiz:attempt'] = 'Шалгалт өгөх';
$string['quiz:deleteattempts'] = 'Шалгалтын оролдлогыг устгах';
$string['quiz:emailconfirmsubmission'] = 'Шалгалтаа илгээх үед баталгаажуулалтын мессэж авах';
$string['quiz:emailnotifyattemptgraded'] = 'Оролдлого дүгнэгдэх үед мэдэгдэл авах';
$string['quiz:emailnotifysubmission'] = 'Суралцагч шалгалт илгээх үед мэдэгдэл авах';
$string['quiz:emailwarnoverdue'] = 'Оролдлогын хугацаа хэтрэх үед мэдэгдэл авах';
$string['quiz:grade'] = 'Шалгалтуудыг гараар үнэлэх';
$string['quiz:ignoretimelimits'] = 'Шалгалтын цагийн хязгаарыг хэрэгсэхгүй байх';
$string['quiz:manage'] = 'Шалгалтыг удирдах';
$string['quiz:manageoverrides'] = 'Шалгалтын тохиргоог өөрчлөхийг удирдах';
$string['quiz:preview'] = 'Шалгалтыг урьдчилан харах';
$string['quiz:regrade'] = 'Оролдлогыг дахин үнэлэх';
$string['quiz:reopenattempts'] = 'Илгээгээгүй оролдлогыг дахин нээх';
$string['quiz:reviewmyattempts'] = 'Өөрийн хариултуудыг хянах';
$string['quiz:view'] = 'Шалгалтын мэдээллийг үзэх';
$string['quiz:viewoverrides'] = 'Шалгалтын хүчингүй болсон тохиргоог харах';
$string['quiz:viewreports'] = 'Шалгалтын тайланг үзэх';
$string['quizavailable'] = 'Шалгалт {$a} хvртэл идэвхитэй байна.';
$string['quizclose'] = 'Шалгалтыг хаах';
$string['quizclosed'] = 'Энэ шалгалт {$a}-нд хаагдсан.';
$string['quizcloses'] = 'Шалгалт хаагдсан';
$string['quizcloseson'] = 'Энэ шалгалт {$a}-нд хаагдана.';
$string['quizeventcloses'] = '{$a} хаагдсан';
$string['quizeventopens'] = '{$a} нээгдсэн';
$string['quizisclosed'] = 'Энэ шалгалт хаагдсан';
$string['quizisclosedwillopen'] = 'Шалгалт хаагдсан  ({$a}} эхэлсэн)';
$string['quizisopen'] = 'Энэ шалгалт нээлттэй байна';
$string['quizisopenwillclose'] = 'Шалгалт нээлттэй байна ({$a}} дуусна)';
$string['quiznavigation'] = 'Шалгалтын удирдлага';
$string['quizopen'] = 'Шалгалтыг нээх';
$string['quizopenclose'] = 'Нээгдэх болон хаагдах огноонууд';
$string['quizopenclose_help'] = 'Суралцагч зөвхөн нээгдэх огнооноос хойш шалгалт өгч болох ба хаагдах огнооноос өмнө оролдлогуудаа гүйцээх ёстой.';
$string['quizopenclose_link'] = 'mod/quiz/timing';
$string['quizopened'] = 'Энэ шалгалт нээлттэй байна.';
$string['quizopenedon'] = 'Энэ шалгалт {$a}-д нээгдсэн байна';
$string['quizopens'] = 'Шалгалт нээсэн';
$string['quizopenwillclose'] = 'Энэ шалгалт нээлттэй байна, {$a}-нд хаагдана';
$string['quizordernotrandom'] = 'Шалгалтын асуултын дэс дараалал байр нь солигдоогүй байна';
$string['quizorderrandom'] = '* Шалгалтын асуултын дэс дараалал байр нь солигдсон байна';
$string['quizreport'] = 'Шалгалтын тайлан';
$string['quizsettings'] = 'Шалгалтын тохиргоо';
$string['quiztimer'] = 'Шалгалтын цаг тоологч';
$string['quizwillopen'] = 'Энэ шалгалт  {$a}-нд нээгдэнэ';
$string['random'] = 'Санамсаргүй сонгогдох асуулт';
$string['randomcreate'] = 'Санамсаргүй сонгогдох асуулт үүсгэх';
$string['randomediting'] = 'Санамсаргүй сонгогдсон асуултыг засах';
$string['randomfromcategory'] = 'Ангиллаас санамсаргүй асуулт сонгох:';
$string['randomfromexistingcategory'] = 'Одоо байгаа ангиллаас санамсаргүйгээр асуулт сонгох';
$string['randomfromunavailabletag'] = '{$a} (боломжгүй)';
$string['randomnosubcat'] = 'Туслах ангиллаас биш, зөвхөн энэ ангиллаас асуулт авах';
$string['randomnumber'] = 'Санамсаргүй сонгогдох асуултын тоо';
$string['randomquestion'] = 'Санамсаргүй сонгогдох асуулт';
$string['randomquestion_help'] = 'Санамсаргүй сонгогдох асуулт нь үйл ажиллагаанд тодорхой таг дагуу эсвэл тодорхой ангиллаас санамсаргүйгээр асуулт сонгож оруулах арга юм.';
$string['randomquestiontags'] = 'Таг';
$string['randomquestiontags_help'] = 'Та энд зарим асуултын тагийг зааж өгснөөр сонголтын шалгуураа хязгаарлаж болно.

Эдгээр бүх тагтай асуултуудаас "санамсаргүйгээр" асуулт сонгогдох болно.';
$string['randomquestionusinganewcategory'] = 'Шинэ ангилал ашиглан санамсаргүйгээр асуулт сонгох';
$string['randomwithsubcat'] = 'Энэ ангилал болон түүний дэд ангиллаас асуулт сонгох';
$string['readytosend'] = 'Шалгалтыг дүгнүүлэхээр илгээх гэж байна. Та үргэлжлүүлмээр байна уу?';
$string['reattemptquiz'] = 'Шалгалтыг дахин өгөх';
$string['recentlyaddedquestion'] = 'Саяхан нэмэгдсэн асуулт!';
$string['recurse'] = 'Дэд ангиллын асуултуудыг бас оруулах';
$string['redoesofthisquestion'] = 'Энд өгсөн бусад асуултууд: {$a}';
$string['redoquestion'] = 'Үүнтэй адил өөр асуултыг үзэх';
$string['regrade'] = 'Бүх оролдлогууд дахин дүгнэх';
$string['regradecomplete'] = 'Бүх оролдогууд дахин дүгнэгдсэн';
$string['regradecount'] = '{$a->changed}-аас {$a->attempt}-ны дүнг өөрчилсөн';
$string['regradedisplayexplanation'] = 'Дахин дүгнэх явцад өөрчлөгдсөн оролдлого нь асуултыг хянах цонхонд холбоос хэлбэрээр харагдана';
$string['regradenotallowed'] = 'Танд энэ шалгалтыг дахин үнэлэх зөвшөөрөл байхгүй байна';
$string['regradingquestion'] = '"{$a}" дахин дүгнэж байна.';
$string['regradingquiz'] = '"{$a}" шалгалтыг дахин дүгнэж байна.';
$string['remove'] = 'Арилгах';
$string['removeallgroupoverrides'] = 'Бүх хүчингүй бүлгийг устгах';
$string['removeallquizattempts'] = 'Бүх оролдлогуудыг устгах';
$string['removealluseroverrides'] = 'Бүх хүчингүй хэрэглэгчийг устгах';
$string['removeemptypage'] = 'Хоосон хуудсыг арилгах';
$string['removepagebreak'] = 'Хуудас тусгаарлагчийг устгах';
$string['removeselected'] = 'Тэмдэглэснийг арилга';
$string['rename'] = 'Нэр өөрчлөх';
$string['renderingserverconnectfailed'] = '{$a} сервер RQP хүсэлтийг боловсруулж чадсангүй. URL хаяг зөв эсэхийг шалгана уу.';
$string['reopenattempt'] = 'Дахин нээх';
$string['reopenattemptareyousuremessage'] = 'Энэ нь {$a->attemptuser} хэрэглэгчийн {$a->attemptnumber} оролдлогыг дахин нээх болно.';
$string['reopenattemptareyousuretitle'] = 'Оролдлогыг дахин нээх эсэх?';
$string['reopenattemptwrongstate'] = 'Оролдлого {$a->attemptid} нь ({$a->state}) буруу төлөвт орсон байна, дахин нээх.';
$string['reopenedattemptwillbeinprogress'] = 'Оролдлого нээлттэй үлдэх ба үргэлжлүүлж болно.';
$string['reopenedattemptwillbeinprogressuntil'] = 'Оролдлого нээлттэй үлдэх ба шалгалт {$a}-д хаагдах хүртэл үргэлжлүүлж болно.';
$string['reopenedattemptwillbesubmitted'] = 'Оролдлогыг дүгнэхээр нэн даруй илгээх болно.';
$string['reorderquestions'] = 'Асуултын дарааллыг шинэчлэх';
$string['reordertool'] = 'Асуултын дараалал шинэчлэх хэрэгсэл харуулах';
$string['repaginate'] = 'Нэг хуудсанд {$a} асуулт харагдахаар дахин хуудаслах';
$string['repaginatecommand'] = 'Дахин хуудаслах';
$string['repaginatenow'] = 'Одоо дахин хуудаслах';
$string['replace'] = 'Солих';
$string['replacementoptions'] = 'Орлуулах сонголтууд';
$string['report'] = 'Тайлан';
$string['reportanalysis'] = 'Зүйлийн шинжилгээ';
$string['reportattemptsfrom'] = '-с ирсэн оролдлого';
$string['reportattemptsthatare'] = 'Оролдлогууд';
$string['reportdisplayoptions'] = 'Дэлгэцэнд харуулах сонголтууд';
$string['reportfullstat'] = 'Дэлгэрэнгүй статистик';
$string['reportmulti_percent'] = 'Олон-хувьтай';
$string['reportmulti_q_x_student'] = 'Олон-оюутны сонголт';
$string['reportmulti_resp'] = 'Салангид хариултууд';
$string['reportmustselectstate'] = 'Та хамгийн багадаа нэг төлөв сонгох ёстой.';
$string['reportnotfound'] = 'Тайлан танигдахгүй байна ({$a})';
$string['reportoverview'] = 'Тойм';
$string['reportregrade'] = 'Оролдлогуудыг дахин дүгнэх';
$string['reportresponses'] = 'Дэлгэрэнгүй хариултууд';
$string['reports'] = 'Тайлан';
$string['reportshowonly'] = 'Зөвхөн оролдлогуудыг харуулах';
$string['reportshowonlyfinished'] = '({$a}) Хэрэглэгч бүрд хамгийн ихдээ нэг дууссан оролдлого харуулах';
$string['reportsimplestat'] = 'Энгийн статистик';
$string['reportusersall'] = 'шалгалт өгсөн бүх хэрэглэгч';
$string['reportuserswith'] = 'шалгалт өгсөн элссэн хэрэглэгч';
$string['reportuserswithorwithout'] = 'шалгалт өгсөн, өгөөгүй элссэн хэрэглэгч';
$string['reportuserswithout'] = 'шалгалт өгөөгүй элссэн хэрэглэгч';
$string['reportwhattoinclude'] = 'Тайланд юу оруулах вэ';
$string['requirepassword'] = 'Нууц үг шаардлагатай';
$string['requirepassword_help'] = 'Хэрэв нууц үг тодорхойлсон бол, суралцагч шалгалт өгөхийн тулд нууц үгээ оруулах ёстой.';
$string['requiresubnet'] = 'Сүлжээний хаяг шаардах';
$string['requiresubnet_help'] = 'Хэсэгчилсэн эсвэл бүтэн IP хаягийн таслалаар тусгаарласан жагсаалтыг зааж өгснөөр шалгалтанд дотоод сүлжээний(LAN) эсвэл интернетийн тодорхой дэд сүлжээнээс ханддаг байхаар хязгаарлаж болно. Энэ нь зөвхөн тодорхой байршилд байгаа хүмүүс шалгалт өгөх боломжтой байхаар, хяналттай шалгалт авахад хэрэгтэй байж болох юм.';
$string['response'] = 'Хариулт';
$string['responses'] = 'Хариултууд';
$string['results'] = 'Үр дүн';
$string['returnattempt'] = 'Оролдлого руу буцах';
$string['reuseifpossible'] = 'өмнө нь устгасныг дахин ашиглах';
$string['reverttodefaults'] = 'Шалгалтын өгөгдмөл тохиргоог сэргээх';
$string['review'] = 'Хянах';
$string['reviewafter'] = 'Шалгалт хаагдсаны дараа хянахыг зөвшөөрөх';
$string['reviewalways'] = 'Ямар ч үед хянахыг зөвшөөрөх';
$string['reviewattempt'] = 'Оролдлогыг хянах';
$string['reviewbefore'] = 'Шалгалт нээлттэй байхад хянахыг зөвшөөрөх';
$string['reviewclosed'] = 'Шалгалт хаагдсаны дараа';
$string['reviewduring'] = 'Оролдлогын үед';
$string['reviewimmediately'] = 'Оролдлогын дараа тэр даруй';
$string['reviewnever'] = 'Хянахыг хэзээ ч зөвшөөрөхгүй';
$string['reviewofquestion'] = '{$a->user} хэрэглэгчийн {$a->quiz} шалгалтын  {$a->question} асуултын хяналт';
$string['reviewopen'] = 'Шалгалт нээлттэй байх үед оролдлогын дараа';
$string['reviewoptions'] = 'Суралцагчид хянаж болно';
$string['reviewoptionsheading'] = 'Хянах тохиргоо';
$string['reviewoptionsheading_help'] = 'Эдгээр сонголтууд нь суралцагч оролдлогыг хянах эсвэл шалгалтын тайланг үзэх үед ямар мэдээлэл харж болохыг хянадаг.

**Оролдлогын хугацаанд** гэсэн тохиргоо нь оролдлогын үеэр зөвлөмжөө шууд харуулдаг \'Олон оролдлоготой интерактив\' шиг зөвхөн зарим нэг горимтой холбоотой.

**Оролдлогын дараа тэр даруй** тохиргоо нь \'Бүгдийг дуусгаад илгээх\' дарсны дараа эхний 2 минутад хэрэглэгдэнэ.

**Шалгалт нээлттэй байх үед оролдлогын дараа** тохиргоо нь шалгалтыг хаах хугацаанаас өмнө хэрэглэгдэнэ.

**Шалгалт хаагдсаны дараа** тохиргоо нь шалгалт өгөх хугацаа дууссаны дараа хэрэгжинэ. Шалгалтыг хаах хугацаа байхгүй бол энэ төлөвт хэзээ ч орохгүй.';
$string['reviewoverallfeedback'] = 'Ерөнхий зөвлөмж';
$string['reviewoverallfeedback_help'] = 'Суралцагчийн авсан нийт дүнгээс хамааран оролдлогын төгсгөлд өгөх зөвлөмж.';
$string['reviewresponse'] = 'Хариултыг хянах';
$string['reviewresponsetoq'] = 'Хариултыг хянах (question {$a})';
$string['reviewthisattempt'] = 'Энэ оролдлогод өгсөн хариултаа хянах';
$string['rqp'] = 'Алсын асуулт';
$string['rqps'] = 'Алсын асуултууд';
$string['sameasoverall'] = 'Нэгдсэн үнэлгээтэй адил';
$string['save'] = 'Хадгалах';
$string['saveandedit'] = 'Өөрчлөлтийг хадгалж, асуултыг засварлах';
$string['saveattemptfailed'] = 'Одоогийн оролдлогыг хадгалах чадсангүй.';
$string['savedfromdeletedcourse'] = 'Устгасан хичээлээс "{$a}" хадгалагдсан.';
$string['savegrades'] = 'Үнэлгээг хадгалах';
$string['savemyanswers'] = 'Миний хариултыг хадгалах';
$string['savenosubmit'] = 'Илгээхгүйгээр хадгалах';
$string['saveoverrideandstay'] = 'Хадгалаад өөр дахин тодорхойлолт оруулах';
$string['savequiz'] = 'Шалгалтыг бүхэлд нь хадгалах';
$string['saving'] = 'Хадгалж байна';
$string['savingnewgradeforquestion'] = '{$a} дугаартай асуултын шинэ үнэлгээг хадгалж байна.';
$string['savingnewmaximumgrade'] = 'Шинэ тохируулсан өндөр оноог хадгалж байна.';
$string['score'] = 'Боловсруулаагүй оноо';
$string['scores'] = 'Оноонууд';
$string['search:activity'] = 'Шалгалт - үйл ажиллагааны мэдээлэл';
$string['sectionheadingedit'] = '\'{$a}\' гарчиг засах';
$string['sectionheadingremove'] = '\'{$a}\' гарчгийг устгах';
$string['sectionnoname'] = 'Гарчиггүй хэсэг';
$string['seequestions'] = '(Асуултуудыг харах)';
$string['select'] = 'Сонгох';
$string['selectall'] = 'Бүгдийг сонгох';
$string['selectattempt'] = 'Оролдлогыг сонгох';
$string['selectcategory'] = 'Ангилал сонгох';
$string['selectedattempts'] = 'Сонгосон оролдлого ...';
$string['selectmultipleitems'] = 'Олон зүйл сонгох';
$string['selectmultipletoolbar'] = 'Олон хэрэгслийн мөр сонгох';
$string['selectnone'] = 'Бүх сонголтыг арилгах';
$string['selectquestionslot'] = '{$a} асуулт сонгох';
$string['selectquestiontype'] = '-- Асуултын төрлийг сонго --';
$string['serveradded'] = 'Сервер нэмсэн';
$string['serveridentifier'] = 'Танигч';
$string['serverinfo'] = 'Серверийн мэдээлэл';
$string['servers'] = 'Серверүүд';
$string['serverurl'] = 'Серверийн URL хаяг';
$string['shortanswer'] = 'Товч хариулт';
$string['show'] = 'Харуулах';
$string['showall'] = 'Нэг хуудсанд бүх асуултуудыг харуулах';
$string['showblocks'] = 'Оролдлогын үед блокуудыг харуулах';
$string['showblocks_help'] = 'Тийм гэж тохируулсан бол шалгалт өгөх үед ердийн блокуудыг харуулна';
$string['showbreaks'] = 'Хуудас тусгаарлагчийг харуулах';
$string['showcategorycontents'] = '{$a->arrow} ангиллын агуулгыг харуулах';
$string['showcorrectanswer'] = 'Зөвлөмж хэсэгт зөв хариултуудыг харуулах уу?';
$string['showdetailedmarks'] = 'Онооны дэлгэрэнгүйг харуулах';
$string['showeachpage'] = 'Нэг удаад нэг хуудас харуулах';
$string['showfeedback'] = 'Хариулсны дараа зөвлөмж харуулах уу?';
$string['showinsecurepopup'] = 'Шалгалт өгөхөд "найдвартай" нээгдэх цонх ашиглах';
$string['showlargeimage'] = 'Том зураг';
$string['shownoattempts'] = 'Оролдлого хийгээгүй суралцагчдыг харуулах';
$string['shownoattemptsonly'] = 'Зөвхөн оролдлого хийгээгүй оюутнуудыг харуулах';
$string['shownoimage'] = 'Зураг алга';
$string['showreport'] = 'Тайлан үзүүлэх';
$string['showsmallimage'] = 'Жижиг зураг';
$string['showteacherattempts'] = 'Багшийн оролдлогуудыг харуулах';
$string['showuserpicture'] = 'Хэрэглэгчийн зургийг харуулах';
$string['showuserpicture_help'] = 'Хэрэв идэвхжүүлсэн бол шалгалтын үед мөн хянах цонхонд суралцагчийн нэр болон зургийг харуулснаар суралцагч өөрийгөө хяналттай шалгалтад холбосон эсэхийг шалгахад хялбар болдог.';
$string['shuffle'] = 'Холих';
$string['shuffleanswers'] = 'Хариуг холих';
$string['shuffledrandomly'] = 'Санамсаргүй дарааллаар холих';
$string['shufflequestions'] = 'Асуулт холих';
$string['shufflequestions_help'] = 'Хэрэв идэвхжүүлсэн бол шалгалт өгөх гээд орох бүрд энэ хэсгийн асуултууд санамсаргүй дарааллаар холигдон гарч ирэх болно.

Энэ нь суралцагчид хоорондоо хариугаа солилцоход хүндрэлтэй болох боловч багштай тодорхой нэг асуултын талаар зөвлөлдөхөд мөн хүндрэлтэй болгодог.';
$string['shufflewithin'] = 'Асуултуудыг дотор нь холих';
$string['shufflewithin_help'] = 'Хэрэв идэвхжүүлсэн бол, суралцагч шалгалтанд хариулах оролдлого хийх бүрт асуулт бүрийг бүрдүүлж буй хэсгүүд санамсаргүйгээр байр нь солигдоно, ингэхдээ асуултын тохиргоон дахь сонголтыг мөн идэвхжүүлсэн байна. Энэ тохиргоо зөвхөн олон сонголттой эсвэл харгалзуулах хариулттай асуултууд гэх мэт олон хэсгээс бүрдэх асуултуудад ашиглагдана.';
$string['singleanswer'] = 'Нэг хариулт сонгох.';
$string['sortage'] = 'Насаар нь эрэмбэлэх';
$string['sortalpha'] = 'Нэрээр нь эрэмбэлэх';
$string['sortquestionsbyx'] = 'Асуултуудыг {$a}-аар эрэмбэлэх';
$string['sortsubmit'] = 'Асуултуудыг эрэмбэлэх';
$string['sorttypealpha'] = 'Төрөл, нэрээр эрэмбэлэх';
$string['specificapathnotonquestion'] = 'Заасан файлын зам заасан асуулт дээр алга байна';
$string['specificquestionnotonquiz'] = 'Заасан асуулт заасан шалгалт дээр алга байна';
$string['startagain'] = 'Дахин эхлэх';
$string['startattempt'] = 'Сорил эхлүүлэх';
$string['startedon'] = 'Эхэлсэн цаг';
$string['startnewpreview'] = 'Урьдчилан харахыг шинээр нээх';
$string['stateabandoned'] = 'Огт илгээгээгүй';
$string['statefinished'] = 'Дуусгасан';
$string['statefinisheddetails'] = 'Илгээсэн {$a}';
$string['stateinprogress'] = 'Хариулж байгаа';
$string['statenotloaded'] = '{$a} асуултын төлөв өгөгдлийн сангаас ачаалагдаагүй';
$string['stateoverdue'] = 'Хугацаа хэтэрсэн';
$string['stateoverduedetails'] = '{$a} гэхэд илгээсэн байх ёстой';
$string['status'] = 'Төлөв';
$string['stoponerror'] = 'Алдаа гарч зогсоох';
$string['submission_confirmation'] = 'Шалгалтыг дуусгаж илгээх үү?';
$string['submission_confirmation_unanswered'] = 'Хариулаагүй асуултууд: {$a}';
$string['submitallandfinish'] = 'Бүгдийг илгээж дуусгах';
$string['subneterror'] = 'Уучлаарай, энэ шалгалт түгжигдсэн байна. Зөвхөн тодорхой байшлуудаас хандах боломжтой. Таны компьютер энэ шалгалтад оролцох зөвшөөрөлгүй байна.';
$string['subnetnotice'] = 'Уучлаарай, энэ шалгалт түгжигдсэн  байна, харин тодорхой байшлуудаас хандах боломжтой. Таны компьютер зөвшөөрөгдсөн сүлжээнд байхгүй байна. Гэхдээ багшийн хувьд та урьдчилан харах боломжтой.';
$string['subplugintype_quiz'] = 'Тайлан';
$string['subplugintype_quiz_plural'] = 'Тайлангууд';
$string['subplugintype_quizaccess'] = 'Нэвтрэх дүрэм';
$string['subplugintype_quizaccess_plural'] = 'Нэвтрэх дүрмүүд';
$string['substitutedby'] = '-р орлуулах болно.';
$string['summaryofattempt'] = 'Оролдлогын тойм';
$string['summaryofattempts'] = 'Таны өмнөх оролдлогуудын тойм';
$string['temporaryblocked'] = 'Түр хугацаанд та шалгалтыг дахин өгөх боломжгүй болсон байна.<br /> Танд дахин нэг оролдлого хийх боломж бий:';
$string['theattempt'] = 'Оролдлого';
$string['theattempt_help'] = 'Суралцагч бүх оролдлогоо шалгаж болох эсэх.';
$string['time'] = 'Хугацаа';
$string['timecompleted'] = 'Дуусгасан';
$string['timedelay'] = 'Таны дараагийн оролдлого хийх хугацаа болоогүй байгаа тул шалгалт өгөх боломжгүй';
$string['timeleft'] = 'Үлдсэн хугацаа';
$string['timelimit'] = 'Цагийн хязгаар';
$string['timelimit_help'] = 'Хэрэв идэвхжүүлсэн бол, шалгалтын эхний хуудас дээр цагийн хязгаар харагдаж, шалгалтын удирдлагын блок дээр цаг тоологч гарч ирнэ.';
$string['timelimit_link'] = 'mod/quiz/timing';
$string['timelimitexeeded'] = 'Уучлаарай! Шалгалтын цагийн хязгаараас хэтэрсэн байна!';
$string['timestr'] = '%h:%m:%s, %d/%m/%y';
$string['timesup'] = 'Цаг дууссан!';
$string['timetaken'] = 'Зарцуулсан хугацаа';
$string['timing'] = 'Цагийн тов';
$string['tofile'] = 'файл руу';
$string['tolerance'] = 'Байж болох зөрүү';
$string['toomanyrandom'] = 'Шаардлагатай санамсаргүй сонгогдох асуултын тоо нь энэ ангилалд байгаа асуултаас илүү байна!';
$string['top'] = 'Дээшээ';
$string['totalmarksx'] = 'Нийлбэр оноо: {$a}';
$string['totalquestionsinrandomqcategory'] = 'Ангилал дахь {$a} асуултуудын нийлбэр.';
$string['true'] = 'Yнэн';
$string['truefalse'] = 'Үнэн/худал';
$string['type'] = 'Төрөл';
$string['unfinished'] = 'нээлттэй';
$string['ungraded'] = 'Үнэлгээ хийгдээгүй';
$string['unit'] = 'Нэгж';
$string['unknowntype'] = '{$a} мөрөнд асуултын төрөл дэмжигдээгvй байна. Асуулт хvчингvй болсон.';
$string['updateoverdueattemptstask'] = 'Хугацаа хэтэрсэн оролдлогуудыг шинэчилж байна';
$string['updatequizslotswithrandomxofy'] = 'Шалгалтын слотуудыг "санамсаргүй" асуултын өгөгдлөөр шинэчилж байна ({$a->done}/{$a->total})';
$string['updatesettings'] = 'Шалгалтын тохиргоог шинэчлэх';
$string['updatingatttemptgrades'] = 'Оролдлогын үнэлгээг шинэчилж байна';
$string['updatingfinalgrades'] = 'Эцсийн үнэлгээг шинэчилж байна.';
$string['updatingthegradebook'] = 'Дүнгийн дэвтрийг шинэчилж байна.';
$string['upgradesure'] = '<div>Ялангуяа шалгалтын модуль нь шалгалтын хүснэгтүүдэд өргөн хэмжээний өөрчлөлт хийдэг ба энэхүү шинэчлэлийг хангалттай туршаагүй байна. Үргэлжлүүлэхээсээ өмнө өгөгдлийн сангийн хүснэгтээ нөөцлөхийг танд зөвлөж/шаардаж байна.</div>';
$string['upgradingquizattempts'] = 'Оролдлогыг шинэчилж байна: шалгалт {$a->done}/{$a->outof} (Quiz id {$a->info})';
$string['upgradingveryoldquizattempts'] = 'Хуучин оролдлогуудыг шинэчилж байна: {$a->done}/{$a->outof}';
$string['url'] = 'URL хаяг';
$string['usedcategorymoved'] = 'Энэ ангилал нь бусад хичээлүүдэд одоог хүртэл ашиглагдаж байгаа нийтлэгдсэн ангилал учраас хадгалагдаж, сайтын түвшинд шилжсэн.';
$string['useroverrides'] = 'Хэрэглэгчийн дахин тодорхойлолт';
$string['useroverridesdeleted'] = 'Хэрэглэгчийн дахин тодорхойлолт устлаа';
$string['usersnone'] = 'Энэ шалгалтад нэвтрэх суралцагч байхгүй байна';
$string['validate'] = 'Баталгаажуулах';
$string['viewallanswers'] = '{$a} оролдлогуудыг харах';
$string['viewallreports'] = '{$a} оролдлогуудын тайланг харах';
$string['viewed'] = 'Үзсэн';
$string['warningmissingtype'] = '<b>Энэ асуулт таны Moodle системд хараахан суулгаагүй байгаа төрлийн асуулт байна.<br />Moodle системийнхээ администраторт анхааруулна уу.</b>';
$string['wheregrade'] = 'Миний үнэлгээ хаана байна?';
$string['wildcard'] = 'Хөрвөх тэмдэг';
$string['windowclosing'] = 'Энэ цонх удалгүй хаагдах болно.';
$string['withsummary'] = 'Статистик дүгнэлттэй';
$string['wronguse'] = 'Та энэ хуудсыг ийм байдлаар ашиглах боломжгүй';
$string['xhtml'] = 'XHTML';
$string['youneedtoenrol'] = 'Та энэ шалгалтанд хариулж эхлэхийн өмнө энэ хичээлд элсэх шаардлагатай';
$string['yourfinalgradeis'] = 'Таны энэ шалгалтын эцсийн дүн {$a} байна.';
