<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'badges', language 'mn', version '4.3'.
 *
 * @package     badges
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actions'] = 'Үйлдлүүд';
$string['activate'] = 'Хандалтыг идэвхжүүлэх';
$string['activatesuccess'] = 'Ялгах тэмдэгт хандахыг амжилттай идэвхжүүлсэн.';
$string['addalignment'] = 'Бодит ур чадвар эсвэл стандарт нэмэх';
$string['addbadge'] = 'Батламж тэмдэг нэмэх';
$string['addbadge_help'] = 'Энэхүү батламж тэмдгийн шаардлагад нэмэх шаардлагатай бүх батламж тэмдгийг сонгоно уу. Хэд хэдийг сонгохын тулд CTRL товчийг дарна уу.';
$string['addbadgecriteria'] = 'Ялгах тэмдгийн шалгуур нэмэх';
$string['addcohort'] = 'Кохорт нэмэх';
$string['addcohort_help'] = 'Энэхүү батламж тэмдгийн шаардлагад нэмэх шаардлагатай бүх кохортыг сонгоно уу. Хэд хэдийг сонгохын тулд CTRL товчийг дарна уу.';
$string['addcompetency'] = 'Чадамж нэмэх';
$string['addcompetency_help'] = 'Энэхүү батламж тэмдгийн шаардлагад нэмэх шаардлагатай бүх чадамжийг сонгоно уу. Хэд хэдийг сонгохын тулд CTRL товчийг дарна уу.';
$string['addcourse'] = 'Хичээл нэмэх';
$string['addcourse_help'] = 'Энэхүү батламж тэмдгийн шаардлагад нэмэх шаардлагатай бүх хичээлийг сонгоно уу. Хэд хэдийг сонгохын тулд CTRL товчийг дарна уу.';
$string['addcriteria'] = 'Шалгуур нэмэх';
$string['addcriteriatext'] = 'Шалгуур нэмж эхлэхийн тулд нээгдэх цэсний сонголтуудаас аль нэгийг сонгоно уу.';
$string['addedtobackpack'] = 'Backpack руу батламж тэмдэг нэмсэн';
$string['addrelated'] = 'Холбогдох батламж тэмдгийг нэмэх';
$string['addtobackpack'] = 'Backpack нэмэх';
$string['adminonly'] = 'Энэ хуудас нь зөвхөн сайтын администраторт зориулагдсан.';
$string['after'] = 'гаргасан огнооноос хойш.';
$string['aggregationmethod'] = 'Нэгтгэх арга';
$string['alignment'] = 'Зэрэгцүүлэлт';
$string['all'] = 'Бүх';
$string['allmethod'] = 'Сонгосон бүх нөхцөлийг хангасан';
$string['allmethodactivity'] = 'Сонгосон бүх үйл ажиллагаа дууссан';
$string['allmethodbadges'] = 'Сонгосон бүх батламж тэмдгийг авсан';
$string['allmethodcohort'] = 'Сонгосон бүх кохортын гишүүнчлэл';
$string['allmethodcompetencies'] = 'Сонгосон бүх чадамжийг эзэмшсэн';
$string['allmethodcourseset'] = 'Сонгосон бүх хичээл дууссан';
$string['allmethodmanual'] = 'Сонгогдсон бүх үүрэгт батламж тэмдэг олгох';
$string['allmethodprofile'] = 'Сонгосон профайлын бүх талбарыг бөглөсөн';
$string['allowcoursebadges'] = 'Хичээлийн ялгах тэмдгийг идэвхжүүлэх';
$string['allowcoursebadges_desc'] = 'Хичээлийн хүрээнд ялгах тэмдэг үүсгэх, олгохыг зөвшөөрнө.';
$string['allowexternalbackpack'] = 'Гадаад backpack холболт';
$string['allowexternalbackpack_desc'] = 'Идэвхжүүлсэн тохиолдолд хэрэглэгч энэ сайтаас гадаад backpack рүү холбогдож, батламж тэмдгээ хуваалцах боломжтой. Түүнчлэн хэрэглэгч гадаад backpack дээрээс цуглуулсан дурын нийтийн батламж тэмдгийн цуглуулгаа уг сайт дээрх профайл хуудсандаа харуулах эсэхийг сонгох боломжтой. Тухайн сайтад интернэтээс нэвтрэх боломжгүй тохиолдолд энэ сонголтыг идэвхгүй болгохыг зөвлөж байна.';
$string['any'] = 'Аль нэг';
$string['anymethod'] = 'Сонгосон нөхцөлийн аль нэг нь хангагдсан';
$string['anymethodactivity'] = 'Сонгосон үйл ажиллагааны аль нэг нь дууссан';
$string['anymethodbadges'] = 'Сонгосон батламж тэмдгийн аль нэг нь олгогдсон';
$string['anymethodcohort'] = 'Сонгосон аль нэг кохортын гишүүнчлэл';
$string['anymethodcompetencies'] = 'Сонгосон чадамжийн аль нэг нь биелсэн';
$string['anymethodcourseset'] = 'Сонгосон хичээлийн аль нэг нь дууссан';
$string['anymethodmanual'] = 'Сонгосон үүргийн аль нэг нь батламж тэмдгийг олгох';
$string['anymethodprofile'] = 'Сонгосон профайлын аль нэг талбарыг бөглөсөн';
$string['apiversion'] = 'API хувилбарыг дэмждэг';
$string['archivebadge'] = 'Та \'{$a}\' батламж тэмдгийг устгаж, одоогоор олгогдсон батламж тэмдгийг хэвээр үлдээхийг хүсэж байна уу?';
$string['archiveconfirm'] = 'Устгаж, одоогоор олгогдсон батламж тэмдгийг үлдээх';
$string['archivehelp'] = '<p>Энэ сонголт нь батламж тэмдгийг "ашиглагдахгүй" гэж тэмдэглэж, батламж тэмдгийн жагсаалтад харагдахгүй болгодог. Ийм батламж тэмдгийг хэрэглэгч цаашид авах боломжгүй. Харин ийм батламж тэмдгийг авсан хэрэглэгч нь профайл хуудсандаа тэмдгээ харуулж, гадаад backpack рүүгээ оруулах боломжтой хэвээр байна.</p>
<p>Хэрэв та хэрэглэгчид авсан батламж тэмдэгт хандах эрхийг хэвээр үлдээх бол уг батламж тэмдгийг бүрэн устгахын оронд энэ сонголтыг ашиглах нь чухал.</p>';
$string['attachment'] = 'Зурваст ялгах тэмдгийг хавсаргах';
$string['attachment_help'] = 'Идэвхжүүлсэн тохиолдолд хүлээн авагчийн цахим шуудангийн хаягт олгосон батламж тэмдгийг татаж авахаар хавсаргана. (Хавсралтыг Сайтын удирдлага / Сервер / Цахим шуудан / Илгээх цахим шуудангийн тохиргоонд энэ сонголтоор идэвхжүүлнэ.)';
$string['award'] = 'Ялгах тэмдэг олгох';
$string['awardedto'] = '{$a} олгосон';
$string['awardedtoyou'] = 'Надад олгосон';
$string['awardoncron'] = 'Батламж тэмдгийн хандалтыг амжилттай идэвхжүүллээ. Хэт олон хэрэглэгч уг батламж тэмдгийг шууд авах боломжтой. Сайтын гүйцэтгэлийг хангахын тулд энэ үйлдлийг боловсруулахад хэсэг хугацаа шаардагдана.';
$string['awards'] = 'Хүлээн авагчид';
$string['backpackapiurl'] = 'Backpack API URL';
$string['backpackavailability'] = 'Гадаад батламж тэмдгийн баталгаажуулалт';
$string['backpackavailability_help'] = 'Батламж тэмдэг хүлээн авагч нь танай сайтаас ялгах батламж тэмдэг авснаа батлахын тулд гадаад backpack үйлчилгээ нь тухайн сайтад нэвтэрч, олгосон батламж тэмдгийг шалгах боломжтой байх ёстой. Танай сайт одоогоор хандах боломжгүй байгаа нь өмнө гаргасан эсвэл цаашид гаргах батламж тэмдгийг баталгаажуулах боломжгүй гэсэн үг.

**Би яагаад энэ зурвасыг харж байна вэ?**

Энэ нь галт хана нь сүлжээнээс гадуурх хэрэглэгчийн хандалтаас сэргийлэх, эсвэл сайтыг нууц үгээр хамгаалсан эсвэл сайтыг интернэт ашиглах боломжгүй компьютер дээр (дотоод хөгжүүлэлтийн машин гэх мэт) ажиллуулдаг зэрэгтэй холбоотой байж магадгүй.

**Энэ нь асуудал мөн эсэх?**

Та батламж тэмдэг олгохоор төлөвлөж буй дурын хөгжүүлэлтийн сайтад энэ асуудлыг шийдэх хэрэгтэй. Эс бөгөөс хүлээн авагч нь батламж тэмдэг авснаа батлах боломжгүй болно. Сайт нь хараахан хэрэглээнд оруулаагүй бол түүнийг нээхээс өмнө туршилтын батламж тэмдгийг үүсгэж, олгох боломжтой.

**Сайтаа бүхэлд нь олон нийтэд нээлттэй болгож чадахгүй бол яах вэ?**

[your-site-url]/badges/assertion.php нь баталгаажуулахад шаардлагатай цор ганц URL хаяг болно. Тухайн файлд гадны хандалтыг зөвшөөрөх бол галт ханаа өөрчлөх боломжтой бөгөөд батламж тэмдгийн баталгаажуулалт хийгдсэн хэвээр байх болно.';
$string['backpackbadgessettings'] = 'Backpack тохиргоог өөрчлөх';
$string['backpackbadgessummary'] = 'Танд {$a->totalcollections} цуглуулгаас {$a->totalbadges} батламж тэмдэг байна.';
$string['backpackcannotsendverification'] = 'Баталгаажуулах цахим шууданг илгээх боломжгүй';
$string['backpackconnected'] = 'Backpack холбогдсон байна';
$string['backpackconnection'] = 'Backpack холболт';
$string['backpackconnection_help'] = 'Backpack руу холбогдсоноор энэ сайтаас өөрийн батламж тэмдгээ хуваалцах болон энэ сайтын өөрийн профайл хуудсандаа өөрийн backpack доторх олон нийтийн батламж тэмдгийн цуглуулгаа харуулах боломжтой.';
$string['backpackconnectioncancelattempt'] = 'Өөр цахим шуудангийн хаяг ашиглан холбогдох';
$string['backpackconnectionconnect'] = 'Backpack руу холбогдох';
$string['backpackconnectionnottested'] = 'Холболтыг зөвхөн Open Badges v2.0 backpack дэмждэг тул уг backpack холболтыг шалгах боломжгүй.';
$string['backpackconnectionok'] = 'Backpack холболт амжилттай боллоо';
$string['backpackconnectionresendemail'] = 'Баталгаажуулах цахим шууданг дахин илгээх';
$string['backpackconnectionunexpectedmessage'] = 'Backpack буцаасан алдаа: "{$a}".';
$string['backpackconnectionunexpectedresult'] = 'Таны backpack руу холбогдоход асуудал гарлаа. Итгэмжлэлийг шалгаад дахин оролдоно уу.';
$string['backpackdetails'] = 'Backpack тохиргоо';
$string['backpackdisconnected'] = 'Backpack нь холболтоос салгагдсан';
$string['backpackemail'] = 'Цахим шуудангийн хаяг';
$string['backpackemail_help'] = 'Таны backpack холбоотой цахим шуудангийн хаяг. Таныг холбогдсон үед энэ сайтаас олгосон бүх батламж тэмдгийг уг цахим шуудангийн хаягтай холбох болно.';
$string['backpackemailverificationpending'] = 'Баталгаажуулалт хүлээгдэж байна';
$string['backpackemailverifyemailbody'] = 'Сайн байна уу

Таны цахим шуудангийн хаягаар \'{$a->sitename}\' сайтаас таны батламж тэмдгийн backpack руу шинэ холболт хийх хүсэлт ирлээ.

Өөрийн backpack руу холболтыг баталгаажуулж, идэвхжүүлэхийн тулд дараах холбоосыг дарна уу

{$a->link}

Ихэнх цахим шуудангийн программд энэ нь шууд дарах боломжтой цэнхэр өнгөтэй холбоос байдлаар харагддаг. Уг холбоос ажиллахгүй байвал уг холбоосыг веб хөтчийнхөө хаягийн мөрөнд хаягийг хуулж хандана уу.

Танд тусламж хэрэгтэй бол сайтын администратортой холбогдоно уу.
{$a->admin}';
$string['backpackemailverifyemailsubject'] = '{$a}: Батламж тэмдгийн backpack цахим шуудангийн баталгаажуулалт';
$string['backpackemailverifypending'] = 'Баталгаажуулах цахим шууданг <strong>{$a}</strong> руу илгээсэн. Цахим шууданд буй баталгаажуулах холбоос дээр дарж backpack холболтоо идэвхжүүлнэ.';
$string['backpackemailverifysuccess'] = 'Цахим шуудангийн хаягаа баталгаажуулсанд баярлалаа. Та өөрийн backpack руу холбогдсон байна.';
$string['backpackemailverifytokenmismatch'] = 'Таны дарсан холбоос дээрх токен нь хадгалагдсан токентой таарахгүй байна. Хамгийн сүүлд хүлээн авсан цахим шуудан доторх холбоос дээр дарсан эсэхээ шалгаарай.';
$string['backpackexporterror'] = 'Батламж тэмдгийг backpack руу экспортлох боломжгүй';
$string['backpackexporterrorwithinfo'] = '"{$a->badgename}" батламж тэмдгийг үүргэвчиндээ экспортлох боломжгүй. Алдаа:  {$a->error}';
$string['backpackimport'] = 'Батламж тэмдгийн импортын тохиргоо';
$string['backpackimport_help'] = 'Backpack холболт амжилттай хийгдсэний дараа өөрийн backpack дотроос авсан батламж тэмдгийг таны батламж тэмдгийн хуудас болон таны профайл хуудсанд харуулах боломжтой.

Энэ хэсэгт та профайлдаа харуулахыг хүсэж буй батламж тэмдгийн цуглуулгаа өөрийн backpack дотроос сонгох боломжтой.';
$string['backpackprovider'] = 'Backpack үйлчилгээ үзүүлэгч';
$string['backpacksettings'] = 'Backpack тохиргоо';
$string['backpackweburl'] = 'Backpack URL хаяг';
$string['badgedetails'] = 'Ялгах тэмдгийн дэлгэрэнгүй мэдээлэл';
$string['badgeimage'] = 'Зураг';
$string['badgeimage_help'] = 'Зургийн хэмжээ хамгийн багадаа 300 x 300 пиксел байх ёстой. Энэ нь батламж тэмдгийн хуудсанд 300 x 300 пиксел, хэрэглэгчийн профайл хуудсанд 100 х 100 пикселээр харагдах болно.';
$string['badgeissued'] = 'Батламж тэмдгийг олгосон';
$string['badgeprivacysetting'] = 'Ялгах тэмдгийн нууцлалын тохиргоо';
$string['badgeprivacysetting_help'] = 'Та авсан батламж тэмдгээ өөрийн бүртгэлийн профайл хуудсанд харуулах боломжтой. Уг тохиргоо нь танд шинээр олгосон батламж тэмдгийн харагдах байдлыг автоматаар тохируулах боломжийг олгоно.

Та батламж тэмдгийн хуудас дээрх хувийн батламж тэмдгийн нууцлалын тохиргоог хянах боломжтой хэвээр байна.';
$string['badgeprivacysetting_str'] = 'Миний авсан ялгах тэмдгийг миний профайл хуудсанд автоматаар харуулах';
$string['badges'] = 'Ялгах тэмдгүүд';
$string['badgesalt'] = 'Хүлээн авагчийн цахим шуудангийн хаягийг хэшлэх аюулгүй тэмдэгт мөр';
$string['badgesalt_desc'] = 'Хэш ашиглах нь backpack сервист цахим шуудангийн хаягаа ил гаргахгүйгээр батламж тэмдэг эзэмшигчийг баталгаажуулах боломжийг олгодог. Уг тохиргоо нь зөвхөн тоо, үсэг ашиглах ёстой.

Тайлбар: Хүлээн авагчийг баталгаажуулахын үүднээс батламж тэмдэг олгож эхэлмэгц уг тохиргоог өөрчлөхөөс зайлсхийх хэрэгтэй.';
$string['badgesdisabled'] = 'Ялгах тэмдгийг энэ сайт дээр идэвхжүүлээгүй байна.';
$string['badgesearned'] = 'Авсан батламж тэмдгийн тоо: {$a}';
$string['badgesettings'] = 'Ялгах тэмдгийн тохиргоо';
$string['badgestatus_0'] = 'Боломжгүй';
$string['badgestatus_1'] = 'Боломжтой';
$string['badgestatus_2'] = 'Боломжгүй (шалгуурыг түгжсэн)';
$string['badgestatus_3'] = 'Боломжтой (шалгуурыг түгжсэн)';
$string['badgestatus_4'] = 'Архивлагдсан';
$string['badgestoearn'] = 'Боломжит ялгах тэмдгийн тоо: {$a}';
$string['badgesview'] = 'Хичээлийн ялгах тэмдэг';
$string['badgeurl'] = 'Олгосон ялгах тэмдгийн холбоос';
$string['balignment'] = 'Зэрэгцүүлэлт ({$a})';
$string['bawards'] = 'Хүлээн авагчид ({$a})';
$string['bcriteria'] = 'Шалгуур';
$string['bdetails'] = 'Нарийвчилсан тохиргоог засварлах';
$string['bendorsement'] = 'Баталгаа';
$string['bmessage'] = 'Зурвас';
$string['boverview'] = 'Тойм';
$string['brelated'] = 'Холбогдох батламж тэмдэг ({$a})';
$string['bydate'] = 'дуусгах';
$string['claim'] = 'Нэхэмжлэл';
$string['claimcomment'] = 'Баталгаажсан тайлбар';
$string['claimid'] = 'Нэхэмжлэлийн URL хаяг';
$string['clearsettings'] = 'Тохиргоог арилгах';
$string['completioninfo'] = 'Энэ ялгах тэмдгийг дараах шалгуурыг бүрэн гүйцэтгэснээр олгосон:';
$string['completionnotenabled'] = 'Хичээл дуусгах сонголтыг энэ хичээлд идэвхжүүлээгүй тул батламж тэмдгийн шалгуурт оруулах боломжгүй. Хичээлийн тохиргоонд хичээл дуусгах сонголтыг идэвхжүүлэх боломжтой.';
$string['configenablebadges'] = 'Идэвхжүүлсэн тохиолдолд энэ функц нь батламж тэмдгийг үүсгэж, сайтын хэрэглэгчид олгох боломжийг олгоно.';
$string['configuremessage'] = 'Ялгах тэмдгийн зурвас';
$string['connect'] = 'Холбох';
$string['connected'] = 'Холбогдсон';
$string['connecting'] = 'Холбогдож байна...';
$string['contact'] = 'Холбоо барих';
$string['contact_help'] = 'Ялгах тэмдэг олгогчтой холбогдох цахим шуудангийн хаяг.';
$string['copyof'] = '{$a}-ийн хуулбар';
$string['course'] = 'Хичээл: {$a}';
$string['coursebadges'] = 'Ялгах тэмдгүүд';
$string['coursebadgesdisabled'] = 'Энэ сайт дээр хичээлийн батламж тэмдгийг идэвхжүүлээгүй байна.';
$string['coursebadgetitle'] = '{$a} хичээлийн батламж тэмдэг';
$string['coursecompletion'] = 'Хэрэглэгч энэ хичээлийг заавал дуусгах ёстой.';
$string['create'] = 'Шинэ ялгах тэмдэг';
$string['createbutton'] = 'Ялгах тэмдгийг үүсгэх';
$string['creatorbody'] = '<p>{$a->user} хэрэглэгч ялгах тэмдэг авах бүх шалгуурыг хангаж, ялгах тэмдгээ авсан байна. Олгосон ялгах тэмдгийг {$a->link} холбоосоор харна уу. </p>';
$string['creatorsubject'] = '\'{$a}\' батламж тэмдгийг олголоо!';
$string['criteria_0'] = 'Энэ ялгах тэмдгийг авахын тулд...';
$string['criteria_1'] = 'Үйл ажиллагааны биелэлт';
$string['criteria_1_help'] = 'Хичээлийн хүрээнд багц үйл ажиллагааг гүйцэтгэсний үндсэн дээр хэрэглэгчид батламж  тэмдгийг олгохыг зөвшөөрдөг.';
$string['criteria_2'] = 'Эрх тус бүрээр гар аргаар олгох';
$string['criteria_2_help'] = 'Сайт эсвэл хичээлийн хүрээнд тодорхой үүрэг бүхий хэрэглэгчид батламж тэмдгийг гар аргаар олгохыг зөвшөөрдөг.';
$string['criteria_3'] = 'Нийгмийн оролцоо';
$string['criteria_3_help'] = 'Нийгмийн';
$string['criteria_4'] = 'Хичээлийн гүйцэтгэл';
$string['criteria_4_help'] = 'Хичээлийг дуусгасан хэрэглэгчид батламж тэмдэг олгохыг зөвшөөрдөг. Уг шалгуур нь хамгийн бага үнэлгээ, хичээл дууссан огноо зэрэг нэмэлт үзүүлэлттэй байж болно.';
$string['criteria_5'] = 'Багц хичээлийг дуусгаж байна';
$string['criteria_5_help'] = 'Багц сургалтыг дуусгасан хэрэглэгчид батламж тэмдэг олгохыг зөвшөөрдөг. Хичээл бүр нь хамгийн бага үнэлгээ, хичээл дууссан огноо зэрэг нэмэлт үзүүлэлттэй байж болно.';
$string['criteria_6'] = 'Профайлыг дуусгах';
$string['criteria_6_help'] = 'Профайл дээрх тодорхой талбарыг бөглөсөн хэрэглэгчид батламж тэмдэг олгохыг зөвшөөрдөг. Та өгөгдмөл болон хувийн профайлын талбараас хэрэглэгчид боломжтой талбарыг сонгож болно.';
$string['criteria_7'] = 'Батламж тэмдгийг олгосон';
$string['criteria_7_help'] = 'Хэрэглэгчид тэдний авсан бусад батламж тэмдэгт үндэслэн батламж тэмдэг олгохыг зөвшөөрдөг.';
$string['criteria_8'] = 'Кохорт гишүүнчлэл';
$string['criteria_8_help'] = 'Кохорт гишүүнчлэлд тулгуурлан хэрэглэгчид батламж тэмдэг олгохыг зөвшөөрдөг.';
$string['criteria_9'] = 'Чадамжууд';
$string['criteria_9_help'] = 'Эзэмшсэн чадамжид үндэслэн хэрэглэгчид батламж тэмдэг олгохыг зөвшөөрдөг.';
$string['criteria_descr'] = 'Дараах шаардлагыг хангасан хэрэглэгчид ялгах тэмдгийг олгоно:';
$string['criteria_descr_0'] = 'Жагсаалтад буй шаардлагаас <strong>{$a}</strong> шаардлагыг хангасан байна.';
$string['criteria_descr_1'] = 'Дараах үйл ажиллагаануудаас <strong>{$a}</strong> үйл ажиллагаа дууссан:';
$string['criteria_descr_2'] = 'Дараах үүрэг бүхий <strong>{$a}</strong> хэрэглэгч энэ батламж тэмдгийг олгоно:';
$string['criteria_descr_4'] = 'Хэрэглэгч хичээлээ дуусгах ёстой';
$string['criteria_descr_5'] = 'Дараах хичээлүүдээс <strong>{$a}</strong> хичээлийг дуусгасан байна:';
$string['criteria_descr_6'] = 'Дараах хэрэглэгчийн профайлын талбаруудаас <strong>{$a}</strong> талбарыг бөглөсөн байна:';
$string['criteria_descr_7'] = 'Дараах батламж тэмдгүүдээс <strong>{$a}</strong> тэмдгийг авсан байна:';
$string['criteria_descr_8'] = 'Дараах кохортуудаас <strong>{$a}</strong> кохортын гишүүнчлэлийг шаардана:';
$string['criteria_descr_9'] = 'Дараах чадамжуудаас <strong>{$a}</strong> чадамжийг эзэмшсэн байна:';
$string['criteria_descr_bydate'] = '<em>{$a}</em>';
$string['criteria_descr_grade'] = 'хамгийн бага үнэлгээтэй <em>{$a}</em>';
$string['criteria_descr_short0'] = '<strong>{$a}</strong> гүйцээнэ үү:';
$string['criteria_descr_short1'] = '<strong>{$a}</strong> гүйцээнэ үү:';
$string['criteria_descr_short2'] = '<strong>{$a}</strong> олгосон:';
$string['criteria_descr_short4'] = 'Хичээлийг дуусгах';
$string['criteria_descr_short5'] = '<strong>{$a}</strong> гүйцээнэ үү:';
$string['criteria_descr_short6'] = '<strong>{$a}</strong> гүйцээнэ үү:';
$string['criteria_descr_short7'] = '<strong>{$a}</strong> гүйцээнэ үү:';
$string['criteria_descr_short8'] = '<strong>{$a}</strong> дэх кохортын гишүүнчлэл:';
$string['criteria_descr_short9'] = '<strong>{$a}</strong> гүйцээнэ үү:';
$string['criteria_descr_single_1'] = 'Дараах үйл ажиллагааг дуусгасан байна:';
$string['criteria_descr_single_2'] = 'Дараах үүрэг бүхий хэрэглэгч энэ батламж тэмдгийг олгоно:';
$string['criteria_descr_single_4'] = 'Хэрэглэгч хичээлээ дуусгах ёстой';
$string['criteria_descr_single_5'] = 'Дараах хичээлийг дуусгасан байна:';
$string['criteria_descr_single_6'] = 'Дараах хэрэглэгчийн профайлын талбарыг бөглөсөн байна:';
$string['criteria_descr_single_7'] = 'Дараах батламж тэмдгийг авсан байна:';
$string['criteria_descr_single_8'] = 'Дараах кохортын гишүүнчлэлийг шаардана:';
$string['criteria_descr_single_9'] = 'Дараах чадамжийг эзэмшсэн байна:';
$string['criteria_descr_single_short1'] = 'Дуусгах:';
$string['criteria_descr_single_short2'] = 'Олгосон:';
$string['criteria_descr_single_short4'] = 'Хичээлийг дуусгах';
$string['criteria_descr_single_short5'] = 'Дуусгах:';
$string['criteria_descr_single_short6'] = 'Дуусгах:';
$string['criteria_descr_single_short7'] = 'Дуусгах:';
$string['criteria_descr_single_short8'] = 'Гишүүнчлэл:';
$string['criteria_descr_single_short9'] = 'Дуусгах:';
$string['criteriacreated'] = 'Ялгах тэмдгийн шалгуурыг амжилттай үүсгэсэн';
$string['criteriadeleted'] = 'Ялгах тэмдгийн шалгуурыг амжилттай устгасан';
$string['criteriasummary'] = 'Шалгуур үзүүлэлтийн хураангуй';
$string['criteriaupdated'] = 'Ялгах тэмдгийн шалгуур үзүүлэлтийг амжилттай шинэчиллээ';
$string['criterror'] = 'Параметрт гарч буй асуудлууд';
$string['criterror_help'] = 'Энэ талбарын тохиргоо нь уг батламж тэмдгийн шаардлагад анх нэмсэн ч цаашид ашиглах боломжгүй бүх параметрийг харуулдаг. Хэрэглэгч цаашид батламж тэмдгийг авах боломжтой эсэхийг шалгахын тулд ийм параметрийг сонгохгүй байхыг зөвлөж байна.';
$string['currentimage'] = 'Ашиглагдаж байгаа зураг';
$string['currentstatus'] = 'Идэвхтэй төлөв:';
$string['dateawarded'] = 'Олгосон огноо';
$string['dateearned'] = 'Огноо: {$a}';
$string['day'] = 'Өдөр(үүд)';
$string['deactivate'] = 'Хандалтыг идэвхгүй болгох';
$string['deactivatesuccess'] = 'Ялгах тэмдгийн хандалтыг амжилттай идэвхгүй болголоо.';
$string['defaultissuercontact'] = 'Ялгах тэмдэг олгогчийн цахим шуудангийн хаяг';
$string['defaultissuercontact_desc'] = 'Ялгах тэмдэг олгогчтой холбоотой цахим шуудангийн хаяг. Үүнийг Open Badges v2.0 backpack хувьд түүнд тэмдэг нийтлэх үед баталгаажуулалтад ашигладаг.';
$string['defaultissuername'] = 'Ялгах тэмдэг олгогчийн нэр';
$string['defaultissuername_desc'] = 'Олгосон эрх бүхий байгууллага, төлөөлөгчийн нэр.';
$string['defaultissuerpassword'] = 'Батламж тэмдэг олгогчийн нууц үг';
$string['defaultissuerpassword_help'] = 'Сайтын удирдлага / Батламж тэмдэг / Батламж тэмдгийн тохиргоонд батламж тэмдэг олгогчийн цахим шуудангийн хаягийн тохиргоонд буй цахим шуудангийн хаяг бүхий backpack сайтад шаардлагатай бүртгэл. Бүртгэлийн нууц үгийг энд оруулах шаардлагатай.';
$string['delbadge'] = 'Та \'{$a}\' ялгах тэмдгийг устгаж, одоогоор олгосон бүх ялгах тэмдгийг арилгахыг хүсэж байна уу?';
$string['delconfirm'] = 'Устгаж, одоогоор олгосон бүх батламж тэмдгийг арилгах';
$string['delcritconfirm'] = 'Та энэ шалгуур үзүүлэлтийг устгахдаа итгэлтэй байна уу?';
$string['deletehelp'] = '<p>Батламж тэмдгийг бүрэн устгах гэдэг нь түүний бүх мэдээлэл, шалгуур үзүүлэлтийн бичлэгийг бүрмөсөн устгана гэсэн үг. Ийм батламж тэмдгийг авсан хэрэглэгч цаашид батламж тэмдэгтээ хандаж, профайл хуудсандаа харуулах боломжгүй болно.</p>
<p>Тэмдэглэл: Энэ батламж тэмдгийг авч, гадаад backpack руу оруулсан хэрэглэгчийн тухайд уг батламж тэмдгийг гадаад backpack руу хадгалсан хэвээр байх болно. Гэвч энэ веб сайтад холбогдох хандалтын шалгуур үзүүлэлт, нотлох баримтын хуудсанд хандах боломжгүй болно.</p>';
$string['delexternalbackpack'] = 'Сайтын backpack устгах';
$string['delexternalbackpackconfirm'] = '\'{$a}\' сайтын backpack устгах эсэх?';
$string['delparamconfirm'] = 'Та энэ параметрийг устгахдаа итгэлтэй байна уу?';
$string['description'] = 'Тодорхойлолт';
$string['disconnect'] = 'Холболтыг салгах';
$string['donotaward'] = 'Одоогоор энэ батламж тэмдэг идэвхгүй байгаа тул хэрэглэгчид олгох боломжгүй. Хэрэв та уг батламж тэмдгийг олгохыг хүсвэл идэвхтэй төлөвт тохируулна уу.';
$string['enablebadges'] = 'Ялгах тэмдгийг идэвхжүүлэх';
$string['endorsement'] = 'Баталгаа';
$string['error:backpackdatainvalid'] = 'Backpack буцаасан өгөгдөл хүчингүй байна.';
$string['error:backpackemailnotfound'] = 'Backpack нь \'{$a}\' цахим шуудантай холбоогүй байна. Та тухайн бүртгэлд <a href="http://backpack.openbadges.org">backpack үүсгэх</a> эсвэл өөр цахим шуудангийн хаягаар нэвтрэх шаардлагатай.';
$string['error:badgeawardnotfound'] = 'Энэ батламж тэмдгийг баталгаажуулах боломжгүй. Уг батламж тэмдгийг хүчингүй болгосон байж болзошгүй.';
$string['error:badgenotfound'] = 'Батламж тэмдэг олдсонгүй';
$string['error:cannotact'] = 'Батламж тэмдгийг идэвхжүүлэх боломжгүй.';
$string['error:cannotawardbadge'] = 'Хэрэглэгчид батламж тэмдэг олгох боломжгүй.';
$string['error:cannotdeletecriterion'] = 'Энэ шалгуур үзүүлэлтийг устгах боломжгүй.';
$string['error:cannotrevokebadge'] = 'Хэрэглэгчээс батламж тэмдгийг нь цуцлах боломжгүй.';
$string['error:clone'] = 'Батламж тэмдгийг хуулбарлах боломжгүй.';
$string['error:connectionunknownreason'] = 'Холболт амжилтгүй болсон ч шалтгаан тодорхойгүй байна.';
$string['error:duplicatename'] = 'Системд ийм нэртэй батламж тэмдэг байна.';
$string['error:externalbadgedoesntexist'] = 'Батламж тэмдэг олдсонгүй';
$string['error:guestuseraccess'] = 'Та одоогоор зочны хандалтыг ашиглаж байна. Батламж тэмдгийг харахын тулд та хэрэглэгчийн бүртгэлээрээ нэвтрэх шаардлагатай.';
$string['error:invalidcriteriatype'] = 'Шалгуур үзүүлэлтийн төрөл буруу.';
$string['error:invalidexpiredate'] = 'Дуусах огноо нь ирээдүй цаг дээр байх ёстой.';
$string['error:invalidexpireperiod'] = 'Дуусах хугацаа сөрөг эсвэл 0 утгатай байж болохгүй.';
$string['error:invalidparambadge'] = 'Батламж тэмдэг байхгүй.';
$string['error:invalidparamcohort'] = 'Кохорт байхгүй байна.';
$string['error:noactivities'] = 'Энэ хичээлд дуусгах шалгуур үзүүлэлтийг идэвхжүүлсэн үйл ажиллагаа байхгүй байна.';
$string['error:nobadges'] = 'Одоогоор шалгуур үзүүлэлт байдлаар нэмсэн хандалтыг идэвхжүүлсэн батламж тэмдэг байхгүй байна. Сайтын батламж тэмдэг нь бусад сайтын батламж тэмдгийг шалгуур үзүүлэлт байдлаар авч болно. Хичээлийн батламж тэмдэг нь бусад хичээлийн батламж тэмдэг эсвэл сайтын батламж тэмдгийг шалгуур үзүүлэлт байдлаар авч болно.';
$string['error:nocohorts'] = 'Кохорт байхгүй';
$string['error:nocourses'] = 'Хичээл дуусгах тохиргоог энэ сайтын ямар ч хичээлд идэвхжүүлээгүй тул аль нь ч харагдахгүй. Хичээлийн тохиргоонд хичээл дуусгах тохиргоог идэвхжүүлэх боломжтой.';
$string['error:nogroupslink'] = '<p>Зөвхөн нээлттэй цуглуулгыг харуулдаг. <a href="{$a}" target="_blank" rel="nofollow">Өөрийн backpack руу хандаж</a> нээлттэй цуглуулга үүсгэнэ үү.</p>';
$string['error:nogroupssummary'] = '<p>Таны backpack дотор батламж тэмдгийн нээлттэй цуглуулга байхгүй байна. </p>';
$string['error:nopermissiontoview'] = 'Танд ялгах тэмдэг олгогдсон хэрэглэгчийн жагсаалтыг харах эрх байхгүй.';
$string['error:nosuchbadge'] = '{$a} id бүхий батламж тэмдэг байхгүй байна.';
$string['error:nosuchcohort'] = 'Анхааруулга: Энэ кохорт байхгүй болсон.';
$string['error:nosuchcourse'] = 'Анхааруулга: Энэ хичээл байхгүй болсон.';
$string['error:nosuchfield'] = 'Анхааруулга: Энэ хэрэглэгчийн профайлын талбар байхгүй болсон.';
$string['error:nosuchmod'] = 'Анхааруулга: Энэ үйл ажиллагаа байхгүй болсон.';
$string['error:nosuchrole'] = 'Анхааруулга: Энэ үүрэг байхгүй болсон.';
$string['error:nosuchuser'] = 'Энэ цахим шуудангийн хаягтай хэрэглэгч нь идэвхтэй backpack үйлчилгээ үзүүлэгчийн бүртгэлгүй байна.';
$string['error:notifycoursedate'] = 'Анхааруулга: Хичээл болон үйл ажиллагааны гүйцэтгэлтэй холбоотой батламж тэмдгийг хичээл эхлэх өдөр хүртэл олгохгүй.';
$string['error:parameter'] = 'Анхааруулга: Батламж тэмдгийн ажлын урсгалыг зөв гаргахын тулд дор хаяж нэг параметрийг сонгосон байх шаардлагатай.';
$string['error:relatedbadgedoesntexist'] = 'Энэхүү танигч бүхий нээлттэй батламж тэмдэг байхгүй байна';
$string['error:requesterror'] = 'Холболтын хүсэлт амжилтгүй болсон (алдааны код {$a}).';
$string['error:requesttimeout'] = 'Холболтын хүсэлтийг дуусгахаас өмнө хугацаа дууссан.';
$string['error:save'] = 'Батламж тэмдгийг хадгалах боломжгүй.';
$string['error:userdeleted'] = '{$a->user} (Энэ хэрэглэгч {$a->site} сайтад байхгүй болсон)';
$string['eventbadgearchived'] = 'Батламж тэмдгийг архивласан';
$string['eventbadgeawarded'] = 'Батламж тэмдгийг олгосон';
$string['eventbadgecreated'] = 'Батламж тэмдгийг үүсгэсэн';
$string['eventbadgecriteriacreated'] = 'Батламж тэмдгийн шалгуур үзүүлэлтийг үүсгэсэн';
$string['eventbadgecriteriadeleted'] = 'Батламж тэмдгийн шалгуур үзүүлэлтийг устгасан';
$string['eventbadgecriteriaupdated'] = 'Батламж тэмдгийн шалгуур үзүүлэлтийг шинэчилсэн';
$string['eventbadgedeleted'] = 'Батламж тэмдгийг устгасан';
$string['eventbadgedisabled'] = 'Батламж тэмдгийг идэвхгүй болгосон';
$string['eventbadgeduplicated'] = 'Батламж тэмдгийг хувилсан';
$string['eventbadgeenabled'] = 'Батламж тэмдгийг идэвхжүүлсэн';
$string['eventbadgelistingviewed'] = 'Батламж тэмдгийн жагсаалтыг харсан';
$string['eventbadgerevoked'] = 'Батламж тэмдгийг цуцалсан';
$string['eventbadgeupdated'] = 'Батламж тэмдгийг шинэчилсэн';
$string['eventbadgeviewed'] = 'Батламж тэмдгийг харсан';
$string['evidence'] = 'Нотолгоо';
$string['existingrecipients'] = 'Ялгах тэмдэг бүхий хэрэглэгчид';
$string['existsinbackpack'] = 'Backpack дотор батламж тэмдэг байна';
$string['expired'] = 'Хугацаа дууссан';
$string['expiredate'] = 'Энэ батламж тэмдгийн хугацаа {$a}-д дуусна.';
$string['expireddate'] = 'Энэ ялгах тэмдгийн хугацаа {$a}-д дууссан.';
$string['expiredin'] = '{$a}-д хугацаа дууссан';
$string['expireperiod'] = 'Энэ ялгах тэмдгийн хүчинтэй хугацаа олгосноос хойш {$a} өдрийн дараа дуусгавар болно.';
$string['expireperiodh'] = 'Энэ ялгах тэмдгийн хүчинтэй хугацаа олгосноос хойш {$a} цагийн дараа дуусгавар болно.';
$string['expireperiodm'] = 'Энэ ялгах тэмдгийн хүчинтэй хугацаа олгосноос хойш {$a} цагийн дараа дуусгавар болно.';
$string['expireperiods'] = 'Энэ ялгах тэмдгийн хүчинтэй хугацаа олгосноос хойш {$a} секундийн дараа дуусгавар болно.';
$string['expiresin'] = '{$a}-д хугацаа дуусна';
$string['expirydate'] = 'Дуусах огноо';
$string['expirydate_help'] = 'Сонголтоор, батламж тэмдгийг тодорхой огноогоор дуусгавар болгох эсвэл тухайн огноог хэрэглэгчид олгосон огноонд үндэслэн тооцож болно.';
$string['externalbadges'] = 'Бусад веб сайтаас олгосон миний ялгах тэмдгүүд';
$string['externalbadges_help'] = 'Энэ хэсэгт таны гадаад backpack дэх батламж тэмдгийг харуулна.';
$string['externalbadgesp'] = 'Бусад веб сайтын ялгах тэмдгүүд:';
$string['externalconnectto'] = 'Гадаад батламж тэмдгийг харуулахын тулд <a href="{$a}">backpack руу холбогдох</a> шаардлагатай.';
$string['fixed'] = 'Тогтоосон огноо';
$string['hidden'] = 'Нуугдсан';
$string['hiddenbadge'] = 'Харамсалтай нь батламж тэмдэг эзэмшигч энэ мэдээллийг нээлттэй болгоогүй байна.';
$string['hostedurl'] = 'Гадаад URL хаяг';
$string['hostedurldescription'] = 'Батламж тэмдгийг байршуулсан гадаад URL хаяг';
$string['imageauthoremail'] = 'Зургийг зурсан этгээдийн цахим шуудан';
$string['imageauthoremail_help'] = 'Тодорхойлсон тохиолдолд батламж тэмдгийн хуудсанд тухайн батламж тэмдгийн зургийг зурсан этгээдийн цахим шуудангийн хаягийг харуулна.';
$string['imageauthorname'] = 'Зургийг зурсан этгээдийн нэр';
$string['imageauthorname_help'] = 'Тодорхойлсон тохиолдолд батламж тэмдгийн хуудсанд тухайн батламж тэмдгийн зургийг зурсан этгээдийн нэрийг харуулна.';
$string['imageauthorurl'] = 'Зургийг зурсан этгээдийн URL хаяг';
$string['imageauthorurl_help'] = 'Тодорхойлсон тохиолдолд батламж тэмдгийн хуудсанд тухайн батламж тэмдгийн зургийг зурсан этгээдийн веб сайтыг харуулна. URL хаяг нь http:// эсвэл https:// угтвартай байх ёстой.';
$string['imagecaption'] = 'Зургийн гарчиг';
$string['imagecaption_help'] = 'Тодорхойлсон тохиолдолд батламж тэмдгийн хуудсанд тухайн батламж тэмдгийн зургийн гарчгийг харуулна.';
$string['includeauthdetails'] = 'Баталгаажуулалтын дэлгэрэнгүй мэдээллийг backpack-ийн хамт оруулах';
$string['invalidurl'] = 'Хүчингүй URL хаяг';
$string['issuancedetails'] = 'Ялгах тэмдгийн хүчинтэй хугацаа';
$string['issuedbadge'] = 'Олгосон ялгах тэмдгийн мэдээлэл';
$string['issuedby'] = '{$a} олгосон';
$string['issuedon'] = '{$a}-д олгосон';
$string['issuerdetails'] = 'Ялгах тэмдэг олгогчийн дэлгэрэнгүй мэдээлэл';
$string['issueremail'] = 'Цахим шуудан';
$string['issueremail_help'] = 'Баталгаауулагч байгууллагын холбоо барих цахим шуудангийн хаяг.';
$string['issuername'] = 'Олгогчийн нэр';
$string['issuername_endorsement'] = 'Баталгаажуулагчийн нэр';
$string['issuername_endorsement_help'] = 'Баталгаажуулагчийн нэр.';
$string['issuername_help'] = 'Олгох төлөөлөгч эсвэл эрх бүхий байгууллагын нэр.';
$string['issuerurl'] = 'Олгогчийн URL хаяг';
$string['issuerurl_help'] = 'Баталгаа гаргагч байгууллагын веб сайт. URL хаяг нь http:// эсвэл https:// угтвартай байх ёстой.';
$string['language'] = 'Хэл';
$string['language_help'] = 'Батламж тэмдгийн хуудсанд ашигласан хэл.';
$string['listbackpacks'] = 'Backpack жагсаалт';
$string['localbadges'] = '{$a} веб сайтаас авсан миний ялгах тэмдгүүд';
$string['localbadgesh'] = 'Энэ веб сайтаас авсан миний ялгах тэмдгүүд';
$string['localbadgesh_help'] = 'Хичээл, хичээлийн үйл ажиллагаа болон бусад шаардлагыг хангаснаар энэ веб сайтаас авсан бүх батламж тэмдгүүд.

Та энд өөрийн батламж тэмдгийг профайл хуудсандаа нээлттэй эсвэл хаалттай байдлаар удирдах боломжтой.

Та өөрийн бүх батламж тэмдгийг эсвэл батламж тэмдэг тус бүрийг тусад нь татаж авах, компьютертоо хадгалах боломжтой. Татаж авсан батламж тэмдгийг гадаад backpack сервистээ нэмж болно.';
$string['localbadgesp'] = '{$a} олгодог ялгах тэмдгүүд:';
$string['localconnectto'] = 'Эдгээр батламж тэмдгийг энэ веб сайтаас гадуур хуваалцахын тулд та <a href="{$a}">backpack руу холбох</a> хэрэгтэй.';
$string['makeprivate'] = 'Хаалттай болгох';
$string['makepublic'] = 'Нээлттэй болгох';
$string['managebackpacks'] = 'Backpack удирдах';
$string['managebadges'] = 'Ялгах тэмдгийг удирдах';
$string['message'] = 'Зурвасын үндсэн хэсэг';
$string['messagebody'] = '<p>Танд "%badgename%" батламж тэмдэг олгогдлоо!</p>
<p>Энэ батламж тэмдгийн талаарх дэлгэрэнгүй мэдээллийг %badgelink% батламж тэмдгийн мэдээллийн хуудаснаас авах боломжтой.</p>
<p>Та өөрийн {$a} хуудаснаас батламж тэмдгийг удирдах, татаж авах боломжтой.</p>';
$string['messagesubject'] = 'Баяр хүргэе! Та дөнгөж сая батламж тэмдэг авлаа!';
$string['method'] = 'Энэ шалгуур үзүүлэлт ... үед хангагдана';
$string['mingrade'] = 'Хамгийн бага үнэлгээ шаардлагатай';
$string['month'] = 'Сар(ууд)';
$string['moredetails'] = 'Илүү дэлгэрэнгүй мэдээлэл';
$string['mybackpack'] = 'Миний backpack тохиргоо';
$string['mybadges'] = 'Миний ялгах тэмдгүүд';
$string['never'] = 'Хэзээ ч үгүй';
$string['newbackpack'] = 'Шинэ backpack нэмэх';
$string['newbadge'] = 'Шинэ ялгах тэмдэг нэмэх';
$string['newimage'] = 'Шинэ зураг';
$string['noalignment'] = 'Энэхүү ялгах тэмдэг нь бодит ур чадвар, стандартыг тусгаагүй болно.';
$string['noawards'] = 'Энэ ялгах тэмдгийг хараахан олгоогүй байна.';
$string['nobackpack'] = 'Энэ бүртгэлд холбогдсон backpack сервис байхгүй байна.<br/>';
$string['nobackpackbadgessummary'] = 'Таны сонгосон цуглуулгад батламж тэмдэг байхгүй байна.';
$string['nobackpackcollectionssummary'] = 'Сонгосон батламж тэмдгийн цуглуулга байхгүй байна.';
$string['nobackpacks'] = 'Боломжит backpack байхгүй байна';
$string['nobadges'] = 'Одоогоор хэрэглэгч авах боломжтой ялгах тэмдэг байхгүй байна.';
$string['nocompetencies'] = 'Сонгосон чадамж байхгүй.';
$string['nocriteria'] = 'Энэ батламж тэмдгийн шалгуур үзүүлэлтийг хараахан тодорхойлоогүй байна.';
$string['noendorsement'] = 'Энэ батламж тэмдэг нь баталгаа байхгүй.';
$string['noexpiry'] = 'Энэ ялгах тэмдэгт хүчинтэй байх хугацаа байхгүй.';
$string['noparamstoadd'] = 'Энэ батламж тэмдгийн шаардлагад нэмэх нэмэлт параметр байхгүй.';
$string['norelated'] = 'Энэ ялгах тэмдэг нь холбогдох ялгах тэмдэг байхгүй байна.';
$string['notacceptedrole'] = 'Таны одоогийн үүрэг нь энэ батламж тэмдгийг гараар олгох үүрэгт байхгүй байна.<br/>
Энэ батламж тэмдгийг авсан хэрэглэгчийг харахыг хүсвэл {$a} хуудсанд хандаж болно.';
$string['notconnected'] = 'Холбогдоогүй';
$string['notealignment'] = 'Батламж тэмдэгт нийцэх бодит ур чадвар, стандартыг зааж өгч болно. Батламж тэмдгийн хуудсанд дурын бодит ур чадвар, стандартыг харуулдаг.';
$string['noteendorsement'] = 'Батламж тэмдгийн үнэ цэнийг нэмэгдүүлэхийн тулд гуравдагч этгээдийн баталгааг ашиглаж болно. Тухайлбал, багшийн олгосон батламж тэмдгийг сургууль, орон нутгийн эрх бүхий байгууллага баталгаажуулж болно.';
$string['noterelated'] = 'Холболт бүхий батламж тэмдгийг холбоотой гэж тэмдэглэж болно. Жишээлбэл, өөр өөр хэлээр харуулах ижил шалгуур үзүүлэлттэй батламж тэмдгийг холбоотой гэж тэмдэглэж болно. Батламж тэмдгийн хуудсанд холбоотой бүх батламж тэмдгийг харуулдаг.';
$string['nothingtoadd'] = 'Нэмэх боломжит шалгуур үзүүлэлт байхгүй байна.';
$string['notification'] = 'Ялгах тэмдэг үүсгэгчид мэдэгдэх';
$string['notification_help'] = 'Энэ тохиргоогоор ялгах тэмдгийг олгосон талаарх мэдэгдлийг ялгах тэмдэг үүсгэгчид илгээх давтамжийг удирдана.

Дараах сонголтуудтай. Үүнд:

* **ХЭЗЭЭ Ч ҮГҮЙ** – Ямар ч мэдэгдэл илгээхгүй.

* **ТУХАЙ БҮР** – Ялгах тэмдэг олгох бүрд мэдэгдэл илгээнэ.

* **ӨДӨР ТУТАМ** – Өдөрт нэг удаа мэдэгдэл илгээнэ.

* **ДОЛОО ХОНОГ ТУТАМ** – Долоо хоногт нэг удаа мэдэгдэл илгээнэ.

* **САР ТУТАМ** – Сард нэг удаа мэдэгдэл илгээнэ.';
$string['notifydaily'] = 'Өдөр тутам';
$string['notifyevery'] = 'Тухай бүр';
$string['notifymonthly'] = 'Сар тутам';
$string['notifyweekly'] = 'Долоо хоног тутам';
$string['numawards'] = 'Энэ ялгах тэмдгийг <a href="{$a->link}">{$a->count}</a> хэрэглэгчид олгосон байна.';
$string['numawardstat'] = 'Энэ ялгах тэмдгийг {$a} хэрэглэгчид олгосон байна.';
$string['oauth2issuer'] = 'OAuth 2 сервис';
$string['openbadgesv1'] = 'Open Badges v1.0';
$string['openbadgesv2'] = 'Open Badges v2.0';
$string['openbadgesv2p1'] = 'Open Badges v2.1';
$string['othernavigation'] = 'Бусад удирдлага...';
$string['overallcrit'] = 'сонгосон шалгуур үзүүлэлт хангагдсан байна.';
$string['potentialrecipients'] = 'Ялгах тэмдэг олгох боломжит хэрэглэгчид';
$string['preferences'] = 'Батламж тэмдгийн тохиргоо';
$string['privacy:metadata:backpack'] = 'Хэрэглэгчийн backpack бичлэг';
$string['privacy:metadata:backpack:backpackuid'] = 'Backpack давтагдашгүй танигч';
$string['privacy:metadata:backpack:email'] = 'Backpack руу холбосон цахим шуудан';
$string['privacy:metadata:backpack:externalbackpackid'] = 'Backpack ID дугаар';
$string['privacy:metadata:backpack:userid'] = 'Backpack эзэмшдэг хэрэглэгчийн ID дугаар';
$string['privacy:metadata:backpackoauth2'] = 'Хэрэглэгч гадаад backpack руу холбогдох үеийн OAuth 2 мэдээлэл';
$string['privacy:metadata:backpackoauth2:issuerid'] = 'OAuth 2 сервисийн ID дугаар';
$string['privacy:metadata:backpackoauth2:scope'] = 'Backpack холболтын хамрах хүрээний жагсаалт';
$string['privacy:metadata:backpackoauth2:token'] = 'Backpack холболтын токен';
$string['privacy:metadata:backpackoauth2:userid'] = 'Backpack руу холбох хэрэглэгчийн ID дугаар';
$string['privacy:metadata:backpackoauth2:usermodified'] = 'Хэрэглэгчийн өөрчилсөн холболтын ID дугаар';
$string['privacy:metadata:badge'] = 'Батламж тэмдгийн цуглуулга';
$string['privacy:metadata:badge:timecreated'] = 'Батламж тэмдгийг үүсгэсэн хугацаа';
$string['privacy:metadata:badge:timemodified'] = 'Батламж тэмдгийг хамгийн сүүлд өөрчилсөн хугацаа';
$string['privacy:metadata:badge:usercreated'] = 'Батламж тэмдгийг үүсгэсэн хэрэглэгчийн ID дугаар';
$string['privacy:metadata:badge:usermodified'] = 'Батламж тэмдгийг өөрчилсөн хэрэглэгчийн ID дугаар';
$string['privacy:metadata:criteriamet'] = 'Шаардлага хангасан шалгуур үзүүлэлтийн цуглуулга';
$string['privacy:metadata:criteriamet:datemet'] = 'Шалгуур үзүүлэлтийг хангасан огноо';
$string['privacy:metadata:criteriamet:userid'] = 'Шалгуур үзүүлэлтийг хангасан хэрэглэгчийн ID дугаар';
$string['privacy:metadata:external:backpacks'] = 'Хэрэглэгчид батламж тэмдгээ гадаад backpack руу илгээх үед хуваалцдаг мэдээлэл';
$string['privacy:metadata:external:backpacks:badge'] = 'Батламж тэмдгийн нэр';
$string['privacy:metadata:external:backpacks:description'] = 'Батламж тэмдгийн тодорхойлолт';
$string['privacy:metadata:external:backpacks:image'] = 'Батламж тэмдгийн зураг';
$string['privacy:metadata:external:backpacks:issuer'] = 'Гаргагчийн талаарх зарим мэдээлэл';
$string['privacy:metadata:external:backpacks:url'] = 'Гаргасан батламж тэмдгийн мэдээллийг харах боломжтой Moodle URL хаяг';
$string['privacy:metadata:issued'] = 'Олгосон батламж тэмдгийн бүртгэл';
$string['privacy:metadata:issued:dateexpire'] = 'Батламж тэмдгийн хугацаа дуусах огноо';
$string['privacy:metadata:issued:dateissued'] = 'Олгосон огноо';
$string['privacy:metadata:issued:userid'] = 'Батламж тэмдгийг авсан хэрэглэгчийн ID дугаар';
$string['privacy:metadata:manualaward'] = 'Гараар олгосон бүртгэл';
$string['privacy:metadata:manualaward:datemet'] = 'Хэрэглэгч батламж тэмдгийг авсан огноо';
$string['privacy:metadata:manualaward:issuerid'] = 'Батламж тэмдгийг олгосон хэрэглэгчийн ID дугаар';
$string['privacy:metadata:manualaward:issuerrole'] = 'Батламж тэмдгийг олгосон хэрэглэгчийн үүрэг';
$string['privacy:metadata:manualaward:recipientid'] = 'Батламж тэмдгийг гараар олгосон хэрэглэгчийн ID дугаар';
$string['recipient'] = 'Батламж тэмдгийг хүлээн авагч';
$string['recipientdetails'] = 'Хүлээн авагчийн дэлгэрэнгүй мэдээлэл';
$string['recipientidentificationproblem'] = 'Одоо байгаа хэрэглэгчдийн дунд уг батламж тэмдгийг авсан хэрэглэгч олдохгүй байна.';
$string['recipients'] = 'Ялгах тэмдгийг хүлээн авагч';
$string['recipientvalidationproblem'] = 'Энэ хэрэглэгчийг уг батламж тэмдгийг авсан болохыг баталгаажуулах боломжгүй.';
$string['relatedbages'] = 'Холбоотой ялгах тэмдгүүд';
$string['relative'] = 'Хамааралтай огноо';
$string['requiredbadge'] = 'Батламж тэмдгийн шалгуур үзүүлэлтэд хамгийн багадаа нэг батламж тэмдэг нэмэх шаардлагатай.';
$string['requiredcohort'] = 'Кохортын шалгуур үзүүлэлтэд хамгийн багадаа нэг кохорт нэмэх шаардлагатай.';
$string['requiredcompetency'] = 'Чадамжийн шалгуур үзүүлэлтэд хамгийн багадаа нэг чадамж нэмэх шаардлагатай.';
$string['requiredcourse'] = 'Хичээлийн тохиргооны шалгуур үзүүлэлтэд хамгийн багадаа нэг хичээл нэмэх шаардлагатай.';
$string['reviewbadge'] = 'Батламж тэмдгийн хандалтад хийсэн өөрчлөлт';
$string['reviewconfirm'] = '<p>Энэ нь таны батламж тэмдгийг хэрэглэгчдэд харуулж, тэдэнд авах боломжийг олгоно.</p>

<p>Энэ батламж тэмдгийн шалгуур үзүүлэлтийг хангасан зарим хэрэглэгчид батламж тэмдгийг идэвхжүүлмэгц олгох болно.</p>

<p>Батламж тэмдгийг олгосны дараа <strong>түгжиж</strong> - шалгуур үзүүлэлт,  хүчинтэй хугацаа зэрэг зарим тохиргоог цаашид өөрчлөх боломжгүй.</p>

<p>Та \'{$a}\' батламж тэмдгийн хандалтыг идэвхжүүлэхдээ итгэлтэй байна уу?</p>';
$string['revoke'] = 'Батламж тэмдгийг цуцлах';
$string['save'] = 'Хадгалах';
$string['searchname'] = 'Нэрээр хайх';
$string['selectaward'] = 'Энэ батламж тэмдгийг олгоход ашиглах үүргээ сонгоно уу:';
$string['selectgroup_end'] = 'Зөвхөн нээлттэй цуглуулгыг харуулна. Нээлттэй цуглуулга үүсгэхийн тулд <a href="{$a}">өөрийн backpack руу хандана уу</a>.';
$string['selectgroup_start'] = 'Энэ сайтад харуулахын тулд backpack дахь цуглуулгаа сонгоно уу:';
$string['selecting'] = 'Сонгосон ялгах тэмдгийг ...';
$string['setup'] = 'Холболт тохируулах';
$string['sitebackpackdeleted'] = 'Сайтын backpack устгагдсан.';
$string['sitebackpacknotdeleted'] = 'Энэ backpack нь уг сайтын өгөгдмөл backpack тул устгах боломжгүй.';
$string['sitebackpackwarning'] = 'Backpack руу холбогдож чадсангүй. <br/><br/>"Батламж тэмдэг гаргагчийн цахим шуудангийн хаяг" админ тохиргоо нь backpack веб сайт дээрх бүртгэлийн хүчинтэй цахим шуудан мөн эсэхийг шалгана уу. <br/><br/><a href="{$a->url}">сайтын backpack тохиргооны хуудас</a> дээрх "Батламж тэмдэг гаргагчийн нууц үг" нь backpack веб сайт  дээрх бүртгэлийн зөв нууц үг мөн эсэхийг шалгана уу. <br/><br/>Backpack "{$a->warning}" буцаасан.';
$string['sitebadges'] = 'Сайтын ялгах тэмдгүүд';
$string['sitebadges_help'] = 'Сайтын батламж тэмдгийг зөвхөн сайттай холбоотой үйл ажиллагааны хэрэглэгчид олгох боломжтой. Үүнд, багц хичээл эсвэл хэрэглэгчийн профайлын хэсгийг дуусгах зэрэг орно. Сайтын батламж тэмдгийг нэг хэрэглэгч нөгөөдөө гараар олгож болно.

Хичээлтэй холбоотой үйл ажиллагааны батламж тэмдгийг хичээлийн түвшинд үүсгэх ёстой. Хичээлийн батламж тэмдгийг Хичээлийн удирдлага > Батламж тэмдгүүд хэсгээс авч болно.';
$string['sitebadgetitle'] = '{$a} сайтын батламж тэмдэг';
$string['status'] = 'Ялгах тэмдгийн төлөв';
$string['status_help'] = 'Батламж тэмдгийн төлөв нь түүний систем дэх төлөв байдлыг тодорхойлдог. Үүнд:

* ** БОЛОМЖТОЙ** – Энэ нь тухайн батламж тэмдгийг хэрэглэгч авах боломжтой гэсэн үг. Батламж тэмдгийг хэрэглэгчид ашиглах боломжтой ч түүний шалгуур үзүүлэлтийг өөрчлөх боломжгүй.

* ** БОЛОМЖГҮЙ** – Энэ нь тухайн батламж тэмдгийг хэрэглэгчид олгох боломжгүй, авах эсвэл гараар олгох боломжгүй гэсэн үг. Хэрэв ийм батламж тэмдгийг өмнө гаргаж байгаагүй бол түүний шалгуур үзүүлэлтийг өөрчилж болно.

Батламж тэмдгийг хамгийн багадаа нэг хэрэглэгчид олгосны дараа уг батламж тэмдэг нь автоматаар **ТҮГЖИГДСЭН** болно. Түгжигдсэн батламж тэмдгийг хэрэглэгч авах боломжтой ч шалгуур үзүүлэлтийг нь өөрчлөх боломжгүй. Түгжигдсэн батламж тэмдгийн дэлгэрэнгүй мэдээлэл, шалгуур үзүүлэлтийг өөрчлөх шаардлагатай бол тухайн батламж тэмдгийг хуулбарлаж, шаардлагатай бүх өөрчлөлтийг хийж болно.

*Яагаад батламж тэмдгийг түгждэг вэ?*

Бүх хэрэглэгч батламж тэмдэг авахын тулд ижил шаардлагыг хангасан байх шаардлагатай. Одоогоор батламж тэмдгийг хүчингүй болгох боломжгүй. Батламж тэмдгийн шаардлагыг байнга өөрчлөхийг зөвшөөрвөл хэрэглэгчид огт өөр өөр шаардлагыг хангасан ижил батламж тэмдэгтэй болох магадлалтай.';
$string['statusmessage_0'] = 'Энэ ялгах тэмдгийг одоогоор хэрэглэгчид олгох боломжгүй байна. Уг ялгах тэмдгийг хэрэглэгчид олгохыг хүсэж байвал хандалтыг идэвхжүүлнэ үү.';
$string['statusmessage_1'] = 'Энэ ялгах тэмдгийг одоогоор хэрэглэгч авах боломжтой.  Ямар нэг өөрчлөлт оруулахын тулд хандалтыг идэвхгүй болгоно уу.';
$string['statusmessage_2'] = 'Энэ батламж тэмдгийг одоогоор хэрэглэгчид олгох боломжгүй, түүний шалгуур үзүүлэлт түгжигдсэн байна. Уг батламж тэмдгийг хэрэглэгчид олгохыг хүсвэл хандалтыг идэвхжүүлнэ үү.';
$string['statusmessage_3'] = 'Энэ ялгах тэмдгийг одоогоор хэрэглэгч авах боломжтой, түүний шалгуур үзүүлэлт түгжигдсэн байна.';
$string['statusmessage_4'] = 'Энэ батламж тэмдэг нь одоогоор архивлагдсан байна.';
$string['subject'] = 'Зурвасын гарчиг';
$string['targetcode'] = 'Код';
$string['targetcode_help'] = 'Хамрах хүрээний бодит ур чадвар эсвэл стандартын лавлах давтагдашгүй тэмдэгт мөр танигч.';
$string['targetdescription'] = 'Тодорхойлолт';
$string['targetdescription_help'] = 'Бодит ур чадвар эсвэл стандартын товч тодорхойлолт.';
$string['targetframework'] = 'Хамрах хүрээ';
$string['targetframework_help'] = 'Бодит ур чадвар эсвэл стандартын хамрах хүрээний нэр.';
$string['targetname'] = 'Нэр';
$string['targetname_help'] = 'Батламж тэмдгийг дүйцүүлсэн бодит ур чадвар эсвэл стандарт.';
$string['targeturl'] = 'URL хаяг';
$string['targeturl_help'] = 'Бодит ур чадвар эсвэл стандартыг тодорхойлсон хуудасны холбоос. URL хаяг нь http:// эсвэл https:// угтвартай байх ёстой.';
$string['testbackpack'] = '\'{$a}\' туршилтын backpack';
$string['testsettings'] = 'Туршилтын тохиргоо';
$string['type'] = 'Төрөл';
$string['userbadges'] = 'Хэрэглэгчийн батламж тэмдгүүд';
$string['variablesubstitution'] = 'Зурвас дахь хувьсах орлуулалт.';
$string['variablesubstitution_help'] = 'Батламж тэмдгийн зурваст тодорхой хувьсагчийг зурвасын гарчиг ба/буюу үндсэн хэсэгт оруулж болно. Ингэснээр зурвас илгээгдэх үед тэдгээрийг бодит утгаар сольдог. Хувьсагчийг дор харуулсанчлан бичвэрт оруулах шаардлагатай. Дараах хувьсагчийг ашиглаж болно. Үүнд:

%badgename%
: Үүнийг батламж тэмдгийн бүтэн нэрээр солино.

%username%
: Үүнийг хүлээн авагчийн бүтэн нэрээр солино.

%badgelink%
: Үүнийг олгосон батламж тэмдгийн талаарх мэдээлэл бүхий нээлттэй URL хаягаар солино.';
$string['version'] = 'Хувилбар';
$string['version_help'] = 'Хувилбарын талбарыг батламж тэмдгийн хөгжүүлэлтийг хянахад ашиглаж болно. Хэрэв тодорхойсон бол батламж тэмдгийн хуудсанд хувилбарыг гаргана.';
$string['viewbadge'] = 'Олгосон ялгах тэмдгийг харах';
$string['visible'] = 'Харагдах';
$string['warnexpired'] = '(Энэ ялгах тэмдгийн хугацаа дууссан!)';
$string['year'] = 'Жил';
