<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'qtype_stack', language 'el', version '4.3'.
 *
 * @package     qtype_stack
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['ATAlgEquiv_SA_not_equation'] = 'Η απάντησή σου θα πρέπει να είναι εξίσωση, αλλά δεν είναι.';
$string['ATAlgEquiv_SA_not_expression'] = 'Η απάντησή σου πρέπει να είναι παράσταση, όχι εξίσωση, ανισότητα, λίστα, σύνολο ή πίνακας.';
$string['ATAlgEquiv_SA_not_function'] = 'Η απάντησή σου θα πρέπει να είναι συνάρτηση, που ορίζεται χρησιμοποιώντας τον τελεστή <tt>:=</tt>, αλλά δεν είναι.';
$string['ATAlgEquiv_SA_not_inequality'] = 'Η απάντησή σου θα πρέπει να είναι ανισότητα, αλλά δεν είναι.';
$string['ATAlgEquiv_SA_not_list'] = 'Η απάντησή σου θα πρέπει να είναι μια λίστα, αλλά δεν είναι. Η σύνταξη για να εισαγάγεις μια λίστα είναι να περικλείεις σε αγκύλες τις τιμές της λίστας, διαχωρισμένες με κόμμα.';
$string['ATAlgEquiv_SA_not_logic'] = 'Η απάντησή σου θα πρέπει να είναι εξίσωση, ανισότητα ή ένας λογικός συνδυασμός αυτών, αλλά δεν είναι.';
$string['ATAlgEquiv_SA_not_matrix'] = 'Η απάντησή σου θα πρέπει να είναι πίνακας, αλλά δεν είναι.';
$string['ATAlgEquiv_SA_not_realset'] = 'Η απάντησή σου πρέπει να είναι ένα υποσύνολο των πραγματικών αριθμών. Αυτό θα μπορούσε να είναι ένα σύνολο αριθμών ή μια συλλογή διαστημάτων.';
$string['ATAlgEquiv_SA_not_set'] = 'Η απάντησή σου πρέπει να είναι ένα σύνολο, αλλά δεν είναι. Η σύνταξη για να εισαγάγεις ένα σύνολο είναι να περικλείεις σε άγκιστρα τις τιμές του συνόλου, διαχωρισμένες με κόμματα.';
$string['ATAlgEquiv_SA_not_string'] = 'Η απάντησή σου θα πρέπει να είναι μια συμβολοσειρά, αλλά δεν είναι.';
$string['ATAlgEquiv_TA_not_equation'] = 'Έχεις εισαγάγει μια εξίσωση, αλλά δεν αναμένεται εξίσωση εδώ. Μπορεί να έχεις πληκτρολογήσει κάτι σαν "y=2*x+1" όταν έπρεπε να πληκτρολογήσεις μόνο "2*x+1".';
$string['ATCompSquare_SA_not_depend_var'] = 'Η απάντησή σου θα πρέπει να εξαρτάται από τη μεταβλητή {$a->m0} αλλά δεν είναι!';
$string['ATCompSquare_false'] = '';
$string['ATCompSquare_false_no_summands'] = 'Το συμπληρωμένο τετράγωνο είναι της μορφής \\( a(\\cdots\\cdots)^2 + b\\) όπου τα \\(a\\) και \\(b\\) δεν εξαρτώνται από τη μεταβλητή σου. Περισσότερα από ένα από τα στοιχεία του αθροίσματός στην απάτησή σου φαίνεται να εξαρτώνται από τη μεταβλητή.';
$string['ATCompSquare_not_AlgEquiv'] = 'Η απάντησή σου φαίνεται να είναι στη σωστή μορφή, αλλά δεν είναι ισοδύναμη με τη σωστή απάντηση.';
$string['ATCompSquare_true'] = '';
$string['ATDiff_error_list'] = 'Το τεστ απαντήσεων απέτυχε. Επικοινώνησε με τον διαχειριστή του συστήματος.';
$string['ATDiff_int'] = 'Φαίνεται ότι έχεις υπολογίσει το ολοκλήρωμα!';
$string['ATEqualComAssRules_Opt_Incompatible'] = 'Η επιλογή σε αυτό το τεστ απαντήσεων περιέχει ασυμβίβαστους κανόνες. Αυτό είναι σφάλμα. Επικοινώνησε με τον δάσκαλό σου.';
$string['ATEquivFirst_SA_wrong_end'] = 'Η τελική σου απάντηση δεν είναι στη σωστή μορφή.';
$string['ATEquivFirst_SA_wrong_start'] = 'Η πρώτη γραμμή στο όρισμά σου πρέπει να είναι "{$a->m0}".';
$string['ATFacForm_error_list'] = 'Το τεστ απαντήσεων απέτυχε. Επικοινώνησε με τον διαχειριστή του συστήματος.';
$string['ATFacForm_isfactored'] = 'Η απάντησή σου είναι παραγοντοποιημένη, μπράβο σου.';
$string['ATFacForm_notalgequiv'] = 'Παρατήρησε ότι η απάντησή σου δεν είναι αλγεβρικά ισοδύναμη με τη σωστή απάντηση. Πρέπει να έκανες κάτι λάθος.';
$string['ATFacForm_notfactored'] = 'Η απάντησή σου δεν είναι παραγοντοποιημένη.';
$string['ATFacForm_notpoly'] = 'Αυτός ο όρος αναμένεται να είναι πολυώνυμο, αλλά δεν είναι.';
$string['ATInequality_backwards'] = 'Η ανισότητα φαίνεται να είναι ανεστραμμένη.';
$string['ATInequality_nonstrict'] = 'Η ανισότητα πρέπει να είναι αυστηρή, αλλά δεν είναι!';
$string['ATInequality_strict'] = 'Η ανισότητα δεν πρέπει να είναι αυστηρή!';
$string['ATInt_EqFormalDiff'] = 'Η παράγωγος της απάντησής σου ισούται με την έκφραση που σου ζητήθηκε να ολοκληρώσεις. Ωστόσο, η απάντησή σας διαφέρει από τη σωστή απάντηση κατά σημαντικό τρόπο, δηλαδή όχι μόνο, π.χ., κατά μια σταθερά ολοκλήρωσης. Ρωτήστε τον δάσκαλό σου σχετικά με αυτό.';
$string['ATInt_const'] = 'Πρέπει να προσθέσεις μια σταθερά ολοκλήρωσης, κατά τα άλλα η απάντηση φαίνεται να είναι σωστή. Μπράβο.';
$string['ATInt_const_int'] = 'Πρέπει να προσθέσεις μια σταθερά ολοκλήρωσης. Αυτή θα πρέπει να είναι μια αυθαίρετη σταθερά, όχι ένας αριθμός.';
$string['ATInt_diff'] = 'Φαίνεται ότι έχεις παραγοντοποιήσει!';
$string['ATInt_error_list'] = 'Το τεστ απαντήσεων απέτυχε. Επικοινώνησε με τον διαχειριστή του συστήματος.';
$string['ATInt_generic'] = 'Η παράγωγος της απάντησής σου θα πρέπει να είναι ίση με την έκφραση που σου ζητήθηκε να ολοκληρώσεις, δηλαδή: {$a->m0} Στην πραγματικότητα, η παράγωγος της απάντησής σου, σε σχέση με το {$a->m1} είναι: {$a->m2} άρα πρέπει να έχεις κάνει κάτι λάθος!';
$string['ATInt_logabs'] = 'Ο δάσκαλός σου μπορεί να περιμένει από να χρησιμοποιήσεις το αποτέλεσμα \\(\\int\\frac{1}{x} dx = \\log(|x|)+c\\), αντί \\(\\int\\frac{1}{x} dx = \\log(x)+c\\). Ρώτησε τον δάσκαλό σου σχετικά με αυτό.';
$string['ATInt_logabs_inconsistent'] = 'Φαίνεται να υπάρχουν περίεργες ασυνέπειες μεταξύ της χρήσης του \\(\\log(...)\\) και του \\(\\log(|...|)\\). Ρώτησε τον δάσκαλό σου σχετικά με αυτό.';
$string['ATInt_weirdconst'] = 'Η παράγωγος της απάντησής σου ισούται με την έκφραση που σου ζητήθηκε να ολοκληρώσεις. Ωστόσο, έχεις μια παράξενη σταθερά ολοκλήρωσης. Ρώτησε τον δάσκαλό σου σχετικά με αυτό.';
$string['ATLevenshtein_SA_not_string'] = 'Το πρώτο όρισμα στο τεστ απάντησης Levenshtein πρέπει να είναι μια συμβολοσειρά. Η δοκιμή απέτυχε. Επικοινώνησε με τον δάσκαλό σου.';
$string['ATLevenshtein_SB_malformed'] = 'Το δεύτερο όρισμα στο τεστ απάντησης Levenshtein πρέπει να έχει τη μορφή [allow, deny] όπου κάθε στοιχείο είναι μια λίστα συμβολοσειρών. Αυτό το όρισμα είναι εσφαλμένο και έτσι η δοκιμή απέτυχε. Επικοινώνησε με τον δάσκαλό σου.';
$string['ATLevenshtein_match'] = 'Η πιο κοντινή αντιστοίχιση ήταν "{$a->m0}".';
$string['ATLevenshtein_tol_not_number'] = 'Η ανοχή στο τεστ απάντησης Levenshtein πρέπει να είναι αριθμός, αλλά δεν είναι. Η δοκιμή απέτυχε. Επικοινώνησε με τον δάσκαλό σου.';
$string['ATLevenshtein_upper_not_boolean'] = 'Η επιλογή ευαισθησίας πεζών-κεφαλαίων στο τεστ απάντησης Levenshtein πρέπει να είναι boolean, αλλά δεν είναι. Η δοκιμή απέτυχε. Επικοινώνησε με τον δάσκαλό σου.';
$string['ATList_wrongentries'] = 'Οι καταχωρήσεις που υπογραμμίζονται με κόκκινο παρακάτω είναι αυτές που είναι λανθασμένες. {$a->m0}';
$string['ATList_wronglen'] = 'Η λίστα σου θα πρέπει να έχει {$a->m0} στοιχεία, αλλά στην πραγματικότητα έχει {$a->m1}.';
$string['ATLowestTerms_entries'] = '';
$string['ATLowestTerms_wrong'] = '';
$string['ATMatrix_wrongentries'] = 'Οι καταχωρήσεις που υπογραμμίζονται με κόκκινο παρακάτω είναι αυτές που είναι λανθασμένες. {$a->m0}';
$string['ATMatrix_wrongsz'] = 'Ο πίνακας σου πρέπει να είναι {$a->m0} επί {$a->m1}, αλλά στην πραγματικότητα είναι {$a->m2} επί {$a->m3}.';
$string['ATNumDecPlaces_Float'] = 'Η απάντησή σου πρέπει να είναι αριθμός κινητής υποδιαστολής, αλλά δεν είναι.';
$string['ATNumDecPlaces_NoDP'] = 'Η απάντησή σου πρέπει να είναι δεκαδικός αριθμός, συμπεριλαμβανομένου ενός δεκαδικού ψηφίου.';
$string['ATNumDecPlaces_Wrong_DPs'] = 'Η απάντησή σου έχει δοθεί με λάθος αριθμό δεκαδικών ψηφίων.';
$string['ATNumSigFigs_Inaccurate'] = 'Η ακρίβεια της απάντησής σου δεν είναι σωστή. Είτε δεν έχεις στρογγυλοποιήσει σωστά, είτε έχεις στρογγυλοποιήσει μια ενδιάμεση απάντηση που διαδίδει ένα σφάλμα.';
$string['ATNumSigFigs_NotDecimal'] = 'Η απάντησή σου πρέπει να είναι δεκαδικός αριθμός, αλλά δεν είναι!';
$string['ATNumSigFigs_WrongDigits'] = 'Η απάντησή σου περιέχει λάθος αριθμό σημαντικών ψηφίων.';
$string['ATNumSigFigs_WrongSign'] = 'Η απάντησή σου έχει λάθος αλγεβρικό πρόσημο.';
$string['ATNumSigFigs_error_list'] = 'Το τεστ απαντήσεων απέτυχε. Επικοινώνησε με τον διαχειριστή του συστήματος.';
$string['ATNum_OutofRange'] = 'Μια αριθμητική έκφραση βρίσκεται εκτός του υποστηριζόμενου εύρους. Επικοινώνησε με τον δάσκαλό σου.';
$string['ATNumerical_FAILED'] = 'Η απάντησή σου θα πρέπει να είναι ένας αριθμός κινητής υποδιαστολής ή μια λίστα ή ένα σύνολο αριθμών. Δεν είναι.';
$string['ATNumerical_SA_not_list'] = 'Η απάντησή σου θα πρέπει να είναι μια λίστα, αλλά δεν είναι. Η σύνταξη για να εισαγάγεις μια λίστα είναι να περικλείεις σε αγκύλες τις τιμές της λίστας, διαχωρισμένες με κόμμα.';
$string['ATNumerical_SA_not_number'] = 'Η απάντησή σου θα πρέπει να είναι αριθμός κινητής υποδιαστολής, αλλά δεν είναι.';
$string['ATNumerical_SA_not_set'] = 'Η απάντησή σου πρέπει να είναι ένα σύνολο, αλλά δεν είναι. Η σύνταξη για να εισαγάγεις ένα σύνολο είναι να περικλείεις σε άγκιστρα τις τιμές του συνόλου, διαχωρισμένες με κόμματα.';
$string['ATNumerical_SB_not_number'] = 'Η τιμή που παρέχεται ως απάντηση του δασκάλου πρέπει να είναι αριθμός κινητής υποδιαστολής, αλλά δεν είναι. Αυτό είναι ένα εσωτερικό σφάλμα του τεστ. Ρώτησε τον δάσκαλό σου σχετικά με αυτό.';
$string['ATNumerical_STACKERROR_tol'] = 'Η αριθμητική ανοχή για το ATNumerical θα πρέπει να είναι αριθμός κινητής υποδιαστολής, αλλά δεν είναι. Η αριθμητική ανοχή για το ATNumerical θα πρέπει να είναι αριθμός κινητής υποδιαστολής, αλλά δεν είναι.';
$string['ATPartFrac_denom_ret'] = 'Εάν η απάντησή σου είναι γραμμένη ως ένα κλάσμα, τότε ο παρονομαστής θα ήταν {$a->m0}. Στην πραγματικότητα, θα πρέπει να είναι {$a->m1}.';
$string['ATPartFrac_diff_variables'] = 'Οι μεταβλητές στην απάντησή σου είναι διαφορετικές από αυτές της ερώτησης, έλεγξε τις.';
$string['ATPartFrac_error_list'] = 'Το τεστ απαντήσεων απέτυχε. Επικοινώνησε με τον διαχειριστή του συστήματος.';
$string['ATPartFrac_ret_expression'] = 'Η απάντησή σου ως ένα κλάσμα είναι {$a->m0}';
$string['ATPartFrac_single_fraction'] = 'Η απάντησή σου φαίνεται να είναι ένα κλάσμα, πρέπει να είναι σε μορφή μερικών κλασμάτων.';
$string['ATPartFrac_true'] = '';
$string['ATSRegExp_SA_not_string'] = 'Το πρώτο όρισμα στο τεστ απάντησης SRegExp πρέπει να είναι μια συμβολοσειρά. Το τεστ απέτυχε. Επικοινώνησε με τον δάσκαλό σου.';
$string['ATSRegExp_SB_not_string'] = 'Το δεύτερο όρισμα στο τεστ απάντησης SRegExp πρέπει να είναι μια συμβολοσειρά. Το τεστ απέτυχε. Επικοινώνησε με τον δάσκαλό σου.';
$string['ATSet_wrongentries'] = 'Οι ακόλουθες καταχωρήσεις είναι λανθασμένες, αν και μπορεί να εμφανίζονται σε απλοποιημένη μορφή από αυτήν που πραγματικά καταχωρίσατε. {$a->m0}';
$string['ATSet_wrongsz'] = 'Το σετ σου θα πρέπει να έχει {$a->m0} διαφορετικά στοιχεία, αλλά στην πραγματικότητα έχει {$a->m1}.';
$string['ATSets_SA_not_set'] = 'Η απάντησή σου πρέπει να είναι ένα σύνολο, αλλά δεν είναι. Η σύνταξη για να εισαγάγεις ένα σύνολο είναι να περικλείεις σε άγκιστρα τις τιμές του συνόλου, διαχωρισμένες με κόμματα.';
$string['ATSets_SB_not_set'] = 'Το τεστ απαντήσεων "Set" αναμένει ότι το δεύτερο όρισμα θα είναι σύνολο. Αυτό είναι σφάλμα. Επικοινώνησε με τον δάσκαλό σου.';
$string['ATSets_duplicates'] = 'Το σύνολό σου φαίνεται να περιέχει διπλές καταχωρήσεις!';
$string['ATSets_missingentries'] = 'Τα παρακάτω λείπουν από το σύνολό σου. {$a->m0}';
$string['ATSets_wrongentries'] = 'Αυτές οι καταχωρήσεις δεν πρέπει να είναι στοιχεία του συνόλου σου. {$a->m0}';
$string['ATSingleFrac_div'] = 'Η απάντησή σου περιέχει κλάσματα μέσα σε κλάσματα. Πρέπει να τα απλοποιήσεις και να γράψεις την απάντησή σου ως ένα κλάσμα.';
$string['ATSingleFrac_error_list'] = 'Το τεστ απαντήσεων απέτυχε. Επικοινώνησε με τον διαχειριστή του συστήματος.';
$string['ATSingleFrac_part'] = 'Η απάντησή σου πρέπει να είναι ένα μόνο κλάσμα της μορφής \\( {a}\\over{b} \\).';
$string['ATSingleFrac_ret_exp'] = 'Η απάντησή σου δεν είναι αλγεβρικά ισοδύναμη με τη σωστή απάντηση. Πρέπει να έκανες κάτι λάθος.';
$string['ATSingleFrac_true'] = '';
$string['ATSingleFrac_var'] = 'Οι μεταβλητές στην απάντησή σου είναι διαφορετικές από αυτές της ερώτησης, έλεγξε τις.';
$string['ATString_SA_not_string'] = 'Η απάντησή σου θα πρέπει να είναι μια συμβολοσειρά, αλλά δεν είναι.';
$string['ATString_SB_not_string'] = 'Η απάντηση του δασκάλου πρέπει να είναι μια συμβολοσειρά, αλλά δεν είναι.';
$string['ATSubstEquiv_Opt_List'] = 'Η επιλογή σε αυτό το τεστ απάντησης πρέπει να είναι μια λίστα. Αυτό είναι σφάλμα. Επικοινώνησε με τον δάσκαλό σου.';
$string['ATSysEquiv_SA_extra_variables'] = 'Η απάντησή σου περιλαμβάνει πάρα πολλές μεταβλητές!';
$string['ATSysEquiv_SA_missing_variables'] = 'Στην απάντησή σου λείπει μία ή περισσότερες μεταβλητές!';
$string['ATSysEquiv_SA_not_eq_list'] = 'Η απάντησή σου θα πρέπει να είναι μια λίστα εξισώσεων, αλλά δεν είναι!';
$string['ATSysEquiv_SA_not_list'] = 'Η απάντησή σου θα πρέπει να είναι μια λίστα, αλλά δεν είναι!';
$string['ATSysEquiv_SA_not_poly_eq_list'] = 'Μία ή περισσότερες από τις εξισώσεις σου δεν είναι πολυώνυμο!';
$string['ATSysEquiv_SA_system_overdetermined'] = 'Οι καταχωρήσεις που υπογραμμίζονται με κόκκινο παρακάτω είναι αυτές που είναι λανθασμένες. {$a->m0}';
$string['ATSysEquiv_SA_system_underdetermined'] = 'Οι εξισώσεις στο σύστημά σου φαίνεται να είναι σωστές, αλλά χρειάζεσαι και άλλες.';
$string['ATSysEquiv_SA_wrong_variables'] = 'Η απάντησή σου έχει λάθος μεταβλητές!';
$string['ATSysEquiv_SB_not_eq_list'] = 'Η απάντηση του δασκάλου δεν είναι μια λίστα εξισώσεων, αλλά θα έπρεπε να είναι.';
$string['ATSysEquiv_SB_not_list'] = 'Η απάντηση του δασκάλου δεν είναι λίστα. Επικοινώνησε με τον δάσκαλό σου.';
$string['ATSysEquiv_SB_not_poly_eq_list'] = 'Η απάντηση του δασκάλου πρέπει να είναι μια λίστα πολυωνυμικών εξισώσεων, αλλά δεν είναι. Επικοινώνησε με τον δάσκαλό σου.';
$string['ATUnits_SA_bad_units'] = 'Η απάντησή σου πρέπει να έχει μονάδες και πρέπει να χρησιμοποιήσεις το σύμβολο του πολλαπλασιασμού για να συνδέσεις τις μονάδες σε μια τιμή, π.χ. <code>3,2*m/s</code>.';
$string['ATUnits_SA_excess_units'] = 'Η απάντησή σου έχει μονάδες (ή μεταβλητές), αλλά δεν θα έπρεπε.';
$string['ATUnits_SA_no_units'] = 'Η απάντησή σου πρέπει να έχει μονάδες.';
$string['ATUnits_SA_not_expression'] = 'Η απάντησή σoy πρέπει να είναι ένας αριθμός μαζί με μονάδες. Μη χρησιμοποιείς σύνολα, λίστες, εξισώσεις ή πίνακες.';
$string['ATUnits_SA_only_units'] = 'Η απάντησή σου πρέπει να είναι ένας αριθμός μαζί με μονάδες. Η απάντησή σου έχει μόνο μονάδες.';
$string['ATUnits_compatible_units'] = 'Οι μονάδες σου είναι διαφορετικές από αυτές που χρησιμοποιεί ο δάσκαλος, αλλά είναι συμβατές με αυτές. Οι αριθμητικές τιμές μετατρέπονται σε μονάδες SI για σύγκριση.';
$string['ATUnits_correct_numerical'] = 'Έλεγξε προσεκτικά τις μονάδες σου.';
$string['ATUnits_incompatible_units'] = 'Οι μονάδες σου δεν είναι συμβατές με αυτές που χρησιμοποιεί ο δάσκαλος.';
$string['Maxima_DivisionZero'] = 'Διαίρεση με το μηδέν.';
$string['all'] = 'Όλες';
$string['allowwords_link'] = '';
$string['answernote_link'] = '';
$string['answertest_link'] = '';
$string['assumepositive_link'] = '';
$string['assumereal_link'] = '';
$string['autosimplify_link'] = '';
$string['autosimplifyprt_link'] = '';
$string['boxsize_link'] = '';
$string['checkanswertype_link'] = '';
$string['clearingthecache'] = 'Καθαρίζεται η κρυφή μνήμη';
$string['clearthecache'] = 'Καθαρισμός της κρυφής μνήμης';
$string['complexno_link'] = '';
$string['createtestcase'] = 'Δημιουργία δοκιμαστικής περίπτωσης';
$string['debuginfo'] = 'Πληροφορίες αποσφαλμάτωσης';
$string['defaultprtcorrectfeedback'] = 'Σωστή απάντηση. Μπράβο!';
$string['defaultprtincorrectfeedback'] = 'Λανθασμένη απάντηση.';
$string['defaultprtpartiallycorrectfeedback'] = 'Η απάντησή σας είναι μερικώς σωστή.';
$string['deletethistestcase'] = 'Διαγραφή αυτής της δοκιμαστικής περίπτωσης...';
$string['deploy'] = 'Εγκατάσταση/Χρήση';
$string['deployedprogress'] = 'Εγκατάσταση/Χρήση παραλλαγής';
$string['deployedvariants'] = 'Παραλλαγές σε Χρήση';
$string['deployedvariantsn'] = 'Παραλλαγές σε Χρήση ({$a})';
$string['deploymanyerror'] = 'Σφάλμα στην εισαγωγή από χρήστη: δεν είναι δυνατή η εφαρμογή/χρήση παραλλαγών «{$a->err}».';
$string['deploymanynonew'] = 'Δημιουργήθηκαν πάρα πολλές επαναλαμβανόμενες υπάρχουσες σημειώσεις ερωτήσεων.';
$string['deployremoveall'] = 'Αναίρεση εφαρμογής/χρήσης όλων των παραλλαγών:';
$string['equiv_SAMEROOTS'] = '(Ίδιες ρίζες)';
$string['equiv_XNOR'] = 'αποκλειστικό ούτε';
$string['equiv_XOR'] = 'αποκλειστικό ή';
$string['errors'] = 'Σφάλματα';
$string['exceptionmessage'] = '{$a}';
$string['expectedpenalty'] = 'Προβλεπόμενη ποινή';
$string['expectedscore'] = 'Προβλεπόμενο σκορ';
$string['exportthisquestion'] = 'Εξαγωγή αυτής της ερώτησης';
$string['false'] = 'Λάθος';
$string['falsebranch'] = 'Λάθος κλάδος';
$string['feedbackstyle_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Potential_response_trees.md';
$string['feedbackvariables'] = 'Μεταβλητές ανατροφοδότησης';
$string['feedbackvariables_link'] = '';
$string['firstnodemusthavelowestnumber'] = 'Ο πρώτος κόμβος πρέπει να έχει τον μικρότερο αριθμό.';
$string['forbidfloat_link'] = '';
$string['forbidwords_link'] = '';
$string['generalfeedback_link'] = '';
$string['inputdisplayed'] = 'Εμφάνιση ως';
$string['inputentered'] = 'Τιμή που δόθηκε';
$string['inputextraoptions'] = 'Επιπλέον επιλογές';
$string['inputextraoptions_link'] = '';
$string['inputheading'] = 'Είσοδος: {$a}';
$string['inputstatus'] = 'Κατάσταση';
$string['inputstatusname'] = 'Κενό';
$string['inputstatusnameinvalid'] = 'Μη έγκυρο';
$string['inputstatusnamescore'] = 'Σκορ';
$string['inputstatusnamevalid'] = 'Έγκυρος';
$string['inputtype_link'] = '';
$string['inputtypeboolean'] = 'Σωστό/Λάθος';
$string['inputtypecheckbox'] = 'Πλαίσιο επιλογής';
$string['inputtypedropdown'] = 'Πτυσσόμενη λίστα';
$string['inputtypenotes'] = 'Σημειώσεις';
$string['inputtypenumerical'] = 'Αριθμητικός';
$string['inputtyperadio'] = 'Μοναδική επιλογή';
$string['inputtypesinglechar'] = 'Απλός χαρακτήρας';
$string['inputtypestring'] = 'Συμβολοσειρά';
$string['inputtypetextarea'] = 'Περιοχή κειμένου';
$string['inputtypeunits'] = 'Μονάδες';
$string['insertstars_link'] = '';
$string['inversetrig_link'] = '';
$string['logicsymbol_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Options.md#logicsymbol';
$string['matrixparens_link'] = '';
$string['multiplicationsign'] = 'Σύμβολο πολλαπλασιασμού';
$string['multiplicationsign_link'] = '';
$string['mustverify'] = 'Ο μαθητής πρέπει να επαληθεύσει';
$string['mustverify_link'] = '';
$string['namealreadyused'] = 'Έχετε ήδη χρησιμοποιήσει αυτό το όνομα.';
$string['newnameforx'] = 'Νέο όνομα για «{$a}»';
$string['next'] = 'Επόμενο';
$string['nextcannotbeself'] = 'Ένας κόμβος δεν μπορεί να συνδεθεί με τον εαυτό του ως επόμενο κόμβο.';
$string['nodex'] = 'Κόμβος {$a}';
$string['nodexdelete'] = 'Διαγραφή κόμβου {$a}';
$string['nodexfalsefeedback'] = 'Λανθασμένη ανατροφοδότηση κόμβου {$a}';
$string['nodextruefeedback'] = 'Σωστή ανατροφοδότηση κόμβου {$a}';
$string['nonempty'] = 'Αυτό δεν μπορεί να είναι κενό.';
$string['notanswered'] = '(Δεν δόθηκε καμία απάντηση)';
$string['notavalidname'] = 'Μη έγκυρο όνομα';
$string['numericalinputoptboolerr'] = 'Η τιμή της επιλογής <code>{$a->opt}</code> έπρεπε να είναι τύπου αλήθειας (boolean), αλλά είναι <code>{$a->val}</code>.';
$string['numericalinputoptinterr'] = 'Η τιμή της επιλογής <code>{$a->opt}</code> έπρεπε να είναι ακέραιος (τύπου integer), αλλά είναι <code>{$a->val}</code>.';
$string['numericalinputsf'] = 'Πρέπει να δώσετε ακριβώς {$a} σημαντικά ψηφία. \\( {$a} \\)';
$string['numericalinputvarsforbidden'] = 'Εδώ αναμένεται η εισαγωγή ενός αριθμού, και έτσι δεν επιτρέπεται να περιέχει μεταβλητές.';
$string['options'] = 'Επιλογές';
$string['optionsnotrequired'] = 'Αυτός ο τύπος μεταβλητής εισόδου δεν απαιτεί καμία επιλογή.';
$string['overallresult'] = 'Συνολικό αποτέλεσμα';
$string['penalty'] = 'Ποινή';
$string['penalty_link'] = '';
$string['penaltyerror'] = 'Η ποινή πρέπει να είναι μια αριθμητική τιμή μεταξύ 0 και 1.';
$string['penaltyerror2'] = 'Η ποινή πρέπει να είναι κενή, ή να είναι μια αριθμητική τιμή μεταξύ 0 και 1.';
$string['phpcasstring'] = 'Έξοδος PHP';
$string['phpsuitecolerror'] = 'Σφάλματα PHP';
$string['phpvalid'] = 'V1';
$string['pleaseananswerallparts'] = 'Παρακαλούμε, απαντήστε σε όλα τα μέρη της ερώτησης.';
$string['pleasecheckyourinputs'] = 'Παρακαλούμε, επαληθεύστε πως ό,τι δώσατε ερμηνεύτηκε όπως αναμενόταν.';
$string['pluginname'] = 'STACK';
$string['pluginname_help'] = 'Το STACK είναι ένα σύστημα αξιολόγησης για μαθηματικά.';
$string['pluginnameadding'] = 'Προσθήκη μιας ερώτησης STACK';
$string['pluginnameediting'] = 'Τροποποίηση μιας ερώτησης STACK';
$string['privacy:metadata'] = 'Το πρόσθετο τύπου ερώτησης STACK δεν αποθηκεύει κανένα προσωπικό δεδομένο.';
$string['prtcorrectfeedback'] = 'Τυπική ανατροφοδότηση για σωστό';
$string['prtheading'] = 'Πιθανό δέντρο αποκρίσεων: {$a}';
$string['prtincorrectfeedback'] = 'Τυπική ανατροφοδότηση για λάθος';
$string['prtnodesheading'] = 'Κόμβοι πιθανού δέντρου αποκρίσεων: {$a}';
$string['prtpartiallycorrectfeedback'] = 'Τυπική ανάδραση για μερικώς σωστό';
$string['prtremovedconfirm'] = 'Επιβεβαιώνω πως θέλω διαγραφή αυτού του πιθανού δέντρου αποκρίσεων από αυτή την ερώτηση.';
$string['prtremovedconfirmbelow'] = 'Το πιθανό δέντρο αποκρίσεων «{$a}» διαγράφηκε. Παρακαλούμε, επιβεβαιώστε το παρακάτω.';
$string['prts'] = 'Πιθανά δέντρα αποκρίσεων';
$string['questiondoesnotuserandomisation'] = 'Αυτή η ερώτηση δεν χρησιμοποιεί τυχαιοποίηση.';
$string['questionnote'] = 'Σημείωση ερώτησης';
$string['questionnote_link'] = '';
$string['questionpreview'] = 'Προεπισκόπηση ερώτησης';
$string['questionsimplify_link'] = '';
$string['questiontext'] = 'Κείμενο ερώτησης';
$string['questiontext_link'] = '';
$string['questiontextmustcontain'] = 'Το κείμενο της ερώτησης πρέπει να περιέχει το κουπόνι «{$a}».';
$string['questiontextnonempty'] = 'Το κείμενο της ερώτησης πρέπει να μην είναι κενό.';
$string['questiontextonlycontain'] = 'Το κείμενο της ερώτησης πρέπει να περιέχει το κουπόνι «{$a}» μόνο μία φορά.';
$string['questiontextplaceholderswhitespace'] = 'Τα δεσμευτικά θέσης δεν μπορούν να περιέχουν κενό διάστημα. Αυτό όμως μοιάζει να περιέχει: «{$a}».';
$string['questionvalue'] = 'Τιμή ερώτησης';
$string['questionvaluepostive'] = 'Η τιμή ερώτησης πρέπει να είναι μη αρνητική.';
$string['questionvariables'] = 'Μεταβλητές ερώτησης';
$string['questionvariables_link'] = '';
$string['questionvariablevalues'] = 'Τιμές μεταβλητών ερώτησης';
$string['quiet'] = 'Ήσυχα';
$string['renamequestionparts'] = 'Μετονομασία των σκελών της ερώτησης';
$string['replacedollarscount'] = 'Αυτή η κατηγορία περιέχει {$a} ερωτήσεις STACK.';
$string['replacedollarserrors'] = 'Οι ακόλουθες ερωτήσεις παρήγαγαν σφάλματα.';
$string['replacedollarsindextitle'] = 'Αντικατάσταση του $s στο κείμενο της ερώτησης';
$string['replacedollarstitle'] = 'Αντικατάσταση του $s στα κείμενα ερώτησης σε {$a}';
$string['requiredfield'] = 'Αυτό το πεδίο απαιτείται!';
$string['requirelowestterms_link'] = '';
$string['sans'] = 'SAns';
$string['sans_link'] = '';
$string['score'] = 'Σκορ';
$string['scoreerror'] = 'Το σκορ πρέπει να είναι μια αριθμητική τιμή μεταξύ 0 και 1.';
$string['seethisquestioninthequestionbank'] = 'Δείτε αυτή την ερώτηση στην τράπεζα ερωτήσεων';
$string['settingajaxvalidation'] = 'Άμεση επικύρωση';
$string['settingcasmaximaversion_desc'] = 'Η χρησιμοποιούμενη έκδοση του Maxima.';
$string['settingcasresultscache_db'] = 'Κρυφή μνήμη στην βάση δεδομένων';
$string['settingcasresultscache_none'] = 'Να μην γίνεται χρήση κρυφής μνήμης';
$string['settingcastimeout'] = 'Χρονικό όριο σύνδεσης CAS';
$string['settingcastimeout_desc'] = 'Το χρονικό όριο προς χρήση όταν γίνεται προσπάθεια σύνδεσης με το Maxima.';
$string['settingdefaultinputoptions'] = 'Προεπιλεγμένες επιλογές εισόδου';
$string['settingdefaultquestionoptions'] = 'Προεπιλεγμένες επιλογές εισόδου';
$string['settingdefaultquestionoptions_desc'] = 'Χρησιμοποιείται όταν δημιουργείται μια νέα ερώτηση.';
$string['settingmathsdisplay'] = 'Φίλτρο μαθηματικών';
$string['settingmathsdisplay_mathjax'] = 'MathJax';
$string['settingplatformtypeserver'] = 'Εξυπηρετητής';
$string['settingplatformtypewin'] = 'Windows';
$string['settingreplacedollars'] = 'Αντικατάσταση <code>$</code> και <code>$$</code>';
$string['settingserveruserpass'] = 'Εξυπηρετητής όνομα χρήστη:κωδικός πρόσβασης';
$string['settingsmathsdisplayheading'] = 'Επιλογές εμφάνισης μαθηματικών';
$string['settingsmaximasettings'] = 'Σύνδεση με το Maxima';
$string['settingusefullinks'] = 'Χρήσιμοι σύνδεσμοι';
$string['showvalidation_link'] = '';
$string['showvalidationno'] = 'Όχι';
$string['showvalidationyes'] = 'Ναι, με λίστα μεταβλητών';
$string['showvalidationyesnovars'] = 'Ναι, χωρίς λίστα μεταβλητών';
$string['singlechargotmorethanone'] = 'Μπορείτε να δώσετε εδώ έναν χαρακτήρα μόνο.';
$string['specificfeedback'] = 'Συγκεκριμένη ανατροφοδότηση';
$string['sqrtsign_link'] = '';
$string['stackDoc_404message'] = 'Αδυναμία εύρεσης αρχείου.';
$string['stackOptions_AnsTest_values_String'] = 'Συμβολοσειρά';
$string['stop'] = '[stop]';
$string['strictsyntax'] = 'Αυστηρή σύνταξη';
$string['strictsyntax_help'] = 'Αυτή η επιλογή δεν χρησιμοποιείται πλέον και θα καταργηθεί.';
$string['strictsyntax_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/';
$string['strlengtherror'] = 'Αυτή η συμβολοσειρά δεν μπορεί να υπερβαίνει σε μήκος τους 255 χαρακτήρες.';
$string['studentValidation_invalidAnswer'] = 'Αυτή η απάντηση είναι μη έγκυρη.';
$string['studentValidation_listofunits'] = 'Οι ενότητες που βρέθηκαν στην απάντησή σας ήταν: {$a}';
$string['studentValidation_listofvariables'] = 'Οι μεταβλητές που βρέθηκαν στην απάντησή σας ήταν: {$a}';
$string['studentValidation_notes'] = '(Αυτή η είσοδος δεν αξιολογείται αυτόματα από το STACK.)';
$string['studentValidation_yourLastAnswer'] = 'Η τελευταία σας απάντηση ερμηνεύτηκε ως εξής: {$a}';
$string['studentanswer'] = 'Απόκριση μαθητή';
$string['switchtovariant'] = 'Μετάβαση σε αυθαίρετη παραλλαγή';
$string['symbolicprtcorrectfeedback'] = '<span style="font-size: 1.5em; color:green;"><i class="fa fa-check"></i></span>';
$string['symbolicprtincorrectfeedback'] = '<span style="font-size: 1.5em; color:red;"><i class="fa fa-times"></i></span>';
$string['symbolicprtpartiallycorrectfeedback'] = '<span style="font-size: 1.5em; color:orange;"><i class="fa fa-adjust"></i></span>';
$string['syntaxattribute'] = 'Χαρακτηριστικό υπόδειξης';
$string['syntaxattribute_link'] = '';
$string['syntaxattributeplaceholder'] = 'Δεσμευτικό θέσης';
$string['syntaxattributevalue'] = 'Τιμή';
$string['syntaxhint'] = 'Υπόδειξη συντακτικού';
$string['syntaxhint_link'] = '';
$string['tans'] = 'TAns';
$string['tans_link'] = '';
$string['teacheranswer'] = 'Απάντηση διδάσκοντος';
$string['teachersanswer'] = 'Υπόδειγμα απάντησης';
$string['teachersanswer_link'] = '';
$string['testoptions_link'] = '';
$string['testoptionsinvalid'] = 'Οι επιλογές δοκιμασίας είναι μη έγκυρες: {$a}';
$string['testsuitecolpassed'] = 'Πέρασε;';
$string['testsuitefeedback'] = 'Ανατροφοδότηση';
$string['texinlinestyle'] = 'Εξίσωση ένθετου στυλ';
$string['true'] = 'Αληθής';
