<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'grades', language 'uk', version '4.3'.
 *
 * @package     grades
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activities'] = 'За видами діяльності курсу';
$string['addcategory'] = 'Додати категорію';
$string['addcategoryerror'] = 'Неможливо додати категорію';
$string['addexceptionerror'] = 'Сталася помилка при додаванні винятку для userid:gradeitem';
$string['addfeedback'] = 'Додати відгук';
$string['addgradeletter'] = 'Додати букву оцінювання';
$string['addidnumbers'] = 'Додати номера id';
$string['additem'] = 'Додати елемент оцінювання';
$string['additionalfeedback'] = 'Додатковий відгук';
$string['addoutcome'] = 'Додати результат';
$string['addoutcomeitem'] = 'Додати Елемент Результату';
$string['addscale'] = 'Додати шкалу';
$string['adjustedweight'] = 'Встановлена значимість';
$string['aggregateextracreditmean'] = 'Середній бал (з додатковими)';
$string['aggregatemax'] = 'Найвищий бал';
$string['aggregatemean'] = 'Середній бал';
$string['aggregatemedian'] = 'Медіана балів';
$string['aggregatemin'] = 'Найменший бал';
$string['aggregatemode'] = 'Мода балів';
$string['aggregatenotonlygraded'] = 'Врахувати порожні оцінки';
$string['aggregateonlygraded'] = 'Враховувати тільки непорожні оцінки';
$string['aggregateonlygraded_help'] = 'Порожня оцінка - це оцінка, якої немає в журналі оцінок. Причиною цього може бути неоцінене викладачем завдання, непройдене тестування або інше.

Це налаштування визначає, чи порожні оцінки не будуть включатися в об’єднання, чи вважатимуться мінімальними оцінками, наприклад, 0 для оціненого завдання в межах 0-100.';
$string['aggregateoutcomes'] = 'Включити результати в об\'єднання';
$string['aggregateoutcomes_help'] = 'Якщо дозволено, то результати будуть включатися в об’єднання. Це може призвести до несподіваних результатів.';
$string['aggregatesonly'] = 'Показати лише підсумки';
$string['aggregatesubcatsupgradedgrades'] = 'Примітка: Встановлення об’єднання "Включаючи підкатегорії" було вилучено під час оновлення сайту. Це об’єднання використовувалося раніше на цьому курсі, тому рекомендуємо переглянути можливі зміни в журналі оцінок.';
$string['aggregatesum'] = 'Натуральний';
$string['aggregateweightedmean'] = 'Зважена середня балів';
$string['aggregateweightedmean2'] = 'Просте середнє';
$string['aggregation'] = 'Об\'єднання';
$string['aggregation_help'] = 'Об’єднання означає, як в категорії будуть визначати підсумкову оцінку

* Середній бал - Сума всіх оцінок, поділена на їх загальну кількість
* Медіана оцінок - Середня оцінка при розташуванні оцінок за їх значенням
* Найменша оцінка
* Найвища оцінка
* Мода оцінок - оцінка, яка зустрічається найчастіше
* Сума оцінок - Сума значень оцінок перерахована з врахуванням ваги';
$string['aggregation_link'] = 'grade/aggregation';
$string['aggregationcoef'] = 'Коефіцієнт об\'єднання';
$string['aggregationcoefextra'] = 'Додаткові бали';
$string['aggregationcoefextra_help'] = 'Якщо об’єднанням є "Сума балів" або "Просте середнє" та визначено додаткові бали, то максимальна оцінка елементу не додається до максимальної оцінки по категорії, що дає можливість отримати максимальні бали (або навіть понад максимальне, якщо таке дозволено адміністратором) в категорії без потреби мати максимальні бали за абсолютно всі елементи в категорії.

Якщо об’єднанням є "Середній бал (з додатковими балами)" та додаткові бали встановлено більше 0, то додаткові бали є фактором, на який множиться оцінка перед тим як додатися до загальної після підрахунку середньої.';
$string['aggregationcoefextra_link'] = 'grade/aggregation';
$string['aggregationcoefextrasum'] = 'Додаткові бали';
$string['aggregationcoefextrasum_help'] = 'Якщо відмічено як додаткові бали, то максимальна оцінка елементу не додається до максимальної оцінки категорії, що дає можливість отримати максимальні бали (або навіть понад максимальне, якщо таке дозволено адміністратором) в категорії без потреби мати максимальні бали за абсолютно всі елементи в категорії.';
$string['aggregationcoefextrasum_link'] = 'grade/aggregation';
$string['aggregationcoefextrasumabbr'] = '+';
$string['aggregationcoefextraweight'] = 'Значимість додаткових балів';
$string['aggregationcoefextraweight_help'] = 'Якщо значимість додаткових балів встановлена більше 0, то оцінка діє як додаткові бали при обчисленні об’єднання. Число є фактором, на який множаться додаткові бали перед додаванням до обрахованої оцінки в категорії.';
$string['aggregationcoefextraweight_link'] = 'grade/aggregation';
$string['aggregationcoefweight'] = 'Значимість елемента';
$string['aggregationcoefweight_help'] = 'Значимість елемента використовується в об’єднання категорії для визначення важливості елементу оцінювання у порівнянні з іншими елементами в цій же категорії.';
$string['aggregationcoefweight_link'] = 'grade/aggregation';
$string['aggregationhintdropped'] = '(Скинуто)';
$string['aggregationhintexcluded'] = '(Виключено)';
$string['aggregationhintextra'] = '(Додаткові бали)';
$string['aggregationhintnovalue'] = '(Порожньо)';
$string['aggregationofa'] = 'Об\'єднання {$a}';
$string['aggregationposition'] = 'Позиція об\'єднання';
$string['aggregationposition_help'] = 'Це налаштування визначає, як будуть показуватися в журналі оцінок підсумкові колонки категорії та загальної оцінки курсу - на початку або в кінці';
$string['aggregationsvisible'] = 'Доступні види об\'єднання';
$string['aggregationsvisiblehelp'] = 'Вкажіть всі види об\'єднань, можливі для використання. Утримуючи клавішу Ctrl можна вибирати кілька варіантів.';
$string['allgrades'] = 'Всі оцінки за всіма категоріями';
$string['allstudents'] = 'Всі студенти';
$string['allusers'] = 'Всі користувачі';
$string['aria-toggledropdown'] = 'Перемкніть наступне спадне меню';
$string['autosort'] = 'Автосортування';
$string['availableidnumbers'] = 'Доступні номера id';
$string['average'] = 'Середня оцінка';
$string['averagesdecimalpoints'] = 'Десяткові знаки в колонці середнього';
$string['averagesdecimalpoints_help'] = 'Цей параметр визначає кількість десяткових знаків для відображення для кожного середнього значення або використовується загальне налаштування десяткових знаків для категорії або елемента оцінки (успадковується).';
$string['averagesdisplaytype'] = 'Тип показу колонки середніх';
$string['averagesdisplaytype_help'] = 'Це налаштування визначає, чи буде середня відображається у вигляді реальних балів, у відсотках або буквенно, а також тип показу для категорії або елементу оцінювання (успадковується).';
$string['backupwithoutgradebook'] = 'Резервна копія не містить конфігурації Журналу оцінок';
$string['badgrade'] = 'Проставлена оцінка - недопустима';
$string['badlyformattedscale'] = 'Введіть через кому список значень (потрібно як мінімум два значення).';
$string['baduser'] = 'Вказаний користувач - нечинний';
$string['bonuspoints'] = 'Додаткові<br />бали';
$string['bulkcheckboxes'] = 'Масові перемикачі';
$string['calculatedgrade'] = 'Розрахункова оцінка';
$string['calculation'] = 'Розрахунок';
$string['calculation_help'] = 'Розрахунок оцінки - це формула яка використовується для визначення оцінки. Формула повинна починатися зі знака (=) та може містити арифметичні операції і загальні функції, такі як max, min та sum. При бажанні, інші елементи оцінювання можуть бути введені до формули вказуванням їх кодів в подвійних квадратних дужках.';
$string['calculation_link'] = 'grade/calculation';
$string['calculationadd'] = 'Додати розрахунок';
$string['calculationedit'] = 'Редагувати розрахунок';
$string['calculationsaved'] = 'Розрахунок збережено';
$string['calculationview'] = 'Переглянути розрахунок';
$string['cannotaccessgroup'] = 'Не вдається отримати доступ до оцінок цієї групи.';
$string['categories'] = 'Категорії';
$string['category'] = 'Категорія';
$string['categoryedit'] = 'Редагувати категорію';
$string['categoryname'] = 'Назва категорії';
$string['categorytotal'] = 'Підсумок категорії';
$string['categorytotalfull'] = '{$a->category} загалом';
$string['categorytotalname'] = 'Назва об’єднання категорії';
$string['changedefaults'] = 'Типові установки';
$string['changereportdefaults'] = 'Змінити типове налаштування';
$string['chooseaction'] = 'Виберіть дію ...';
$string['choosecategory'] = 'Оберіть категорію';
$string['collapsecriterion'] = 'Критерій згортання';
$string['combo'] = 'Вкладки та спадне меню';
$string['compact'] = 'Компактно';
$string['componentcontrolsvisibility'] = 'Чи буде ця оцінка прихованою, контролюється в налаштуваннях діяльності.';
$string['contract'] = 'Контрактна категорія';
$string['contributiontocoursetotal'] = 'Внесок у підсумок курсу';
$string['controls'] = 'Контроль';
$string['courseavg'] = 'Середнє по курсу';
$string['coursegradecategory'] = 'Категорія оцінки курсу';
$string['coursegradedisplaytype'] = 'Тип показу оцінки курсу';
$string['coursegradedisplayupdated'] = 'Тип показу оцінки курсу було змінено.';
$string['coursegradesettings'] = 'Налаштування оцінювання курсу';
$string['coursename'] = 'Назва курсу';
$string['coursescales'] = 'Шкали курсу';
$string['coursesettings'] = 'Налаштування курсу';
$string['coursesettingsexplanation'] = 'Налаштування оцінок курсу визначають, як відображатиметься журнал оцінок для всіх учасників курсу.';
$string['coursesiamtaking'] = 'Курси, де я навчаюся';
$string['coursesiamteaching'] = 'Курси, де я викладаю';
$string['coursetotal'] = 'Загальне за курс';
$string['createcategory'] = 'Створити категорію';
$string['createcategoryerror'] = 'Не можу створити нову категорію';
$string['creatinggradebooksettings'] = 'Створення налаштувань Журналу оцінок';
$string['csv'] = 'CSV';
$string['currentparentaggregation'] = 'Поточне батьківське об\'єднання';
$string['curveto'] = 'Привести до';
$string['decimalpoints'] = 'Загальні десяткові знаки';
$string['decimalpoints_help'] = 'Цей параметр визначає кількість десяткових знаків для відображення для кожного класу. Це не впливає на обчислення оцінок, які виконуються з точністю до 5 знаків після коми.';
$string['default'] = 'Типово';
$string['defaultprev'] = 'Типово ({$a})';
$string['deletecategory'] = 'Вилучити категорію';
$string['deletescale'] = 'Видалити масштаб';
$string['disablegradehistory'] = 'Відключити історію оцінювання';
$string['disablegradehistory_help'] = 'Відключає стеження за зміною в пов’язаних з оцінками таблицях. Це може прискорити роботу сервера та зменшити місце в базі даних.';
$string['displaylettergrade'] = 'Показати буквені оцінки';
$string['displaypercent'] = 'Показати відсотки';
$string['displaypoints'] = 'Показати бали';
$string['displayweighted'] = 'Показати зважені суми';
$string['dropdown'] = 'Випадаюче меню';
$string['droplow'] = 'Відкинути найнижчі';
$string['droplow_help'] = 'Це налаштування дозволяє відкинути вказану кількість найнижчих балів з підсумкової обробки балів.';
$string['droplowestvalue'] = 'Встановити відкидання найнижчих значень оцінок';
$string['droplowestvalues'] = 'Скинути {$a} найнижчих значень';
$string['dropped'] = 'не враховується';
$string['dropxlowest'] = 'Відкинути X<br />найгірших';
$string['dropxlowestwarning'] = 'Примітка: якщо ви використовуєте функцію "відкинути X найгірших", то розуміється, що всі елементи в даній категорії оцінюються одним і тим же числом балів кожне. Якщо бали відрізняються, результат може стати непередбаченим.';
$string['duplicatedgradeitem'] = '{$a} (копія)';
$string['duplicatescale'] = 'Дублювати шкалу';
$string['edit'] = 'Редагувати';
$string['editcalculation'] = 'Редагувати розрахунки';
$string['editcalculationverbose'] = 'Редагувати розрахунки для {$a->category}{$a->itemmodule} {$a->itemname}';
$string['editfeedback'] = 'Редагувати відгук';
$string['editgrade'] = 'Редагувати оцінку';
$string['editgradeletters'] = 'Редагувати буквені оцінки';
$string['editoutcome'] = 'Редагувати результат';
$string['editoutcomes'] = 'Редагувати результат';
$string['editscale'] = 'Редагувати шкалу';
$string['edittree'] = 'Налаштування';
$string['editverbose'] = 'Редагувати {$a->category}{$a->itemmodule} {$a->itemname}';
$string['enableajax'] = 'Включити AJAX';
$string['enableajax_help'] = 'Додає шар функціональності AJAX до журналу оцінок для спрощення та прискорення загальних операцій. Вимагає включеного в браузері Javascript на рівні користувача.';
$string['enableoutcomes'] = 'Включити результати';
$string['enableoutcomes_help'] = 'Якщо ввімкнено, пункти оцінок можна оцінювати за допомогою однієї або кількох шкал, пов’язаних із твердженнями про результати.';
$string['encoding'] = 'Кодування';
$string['encoding_help'] = 'Виберіть кодування символів, яке використовується в даних. (Типовим кодуванням є UTF-8). Якщо помилково вибрано неправильне кодування, це буде помітно при перегляді даних для імпорту.';
$string['errorcalculationbroken'] = 'Помилка в обчисленні оцінки {$a}.';
$string['errorcalculationnoequal'] = 'Формула повинна починатися зі знаку рівності (=1+2)';
$string['errorcalculationunknown'] = 'Неправильна формула';
$string['errorgradevaluenonnumeric'] = 'Отримані нечислові значення мінімальної чи максимальної оцінки для';
$string['errornocalculationallowed'] = 'Розрахунки для цього елементу не дозволяються';
$string['errornocategorisedid'] = 'Неможливо отримати ідентифікатор без категорії!';
$string['errornocourse'] = 'Не вдалося отримати інформацію про курс';
$string['errorreprintheadersnonnumeric'] = 'Отримано нечислове значення для повтору заголовків';
$string['errorsavegrade'] = 'На жаль, не вдалося зберегти оцінку.';
$string['errorsettinggrade'] = 'Помилка при зберіганні оцінки для "{$a->itemname}" для коду користувача {$a->userid}';
$string['errorupdatinggradecategoryaggregateonlygraded'] = 'Помилка оновлення налаштування "Враховувати тільки непусті бали" в категорії оцінювання з кодом {$a->id}';
$string['errorupdatinggradecategoryaggregateoutcomes'] = 'Помилка оновлення налаштування "Включити результати в об\'єднання" в категорії оцінювання з кодом {$a->id}';
$string['errorupdatinggradecategoryaggregation'] = 'Помилка оновлення типу об ’єднання категорії оцінювання з кодом {$a->id}';
$string['errorupdatinggradeitemaggregationcoef'] = 'Помилка оновлення коефіцієнту (ваги або додаткових балів) об ’єднання категорії оцінювання з кодом {$a->id}';
$string['eventgradedeleted'] = 'Оцінку вилучено';
$string['eventgradeexported'] = 'Оцінка експортована';
$string['eventgradeitemcreated'] = 'Елемент оцінки створено';
$string['eventgradeitemdeleted'] = 'Елемент оцінки видалено';
$string['eventgradeitemupdated'] = 'Елемент оцінки оновлено';
$string['eventgradelettercreated'] = 'Оцінковий лист створено';
$string['eventgradeletterdeleted'] = 'Лист оцінки видалено';
$string['eventgradeletterupdated'] = 'Оцінковий лист оновлено';
$string['eventgradeviewed'] = 'Переглянуто оцінки в журналі оцінок';
$string['eventscalecreated'] = 'Створена шкала';
$string['eventscaledeleted'] = 'Масштаб видалено';
$string['eventscaleupdated'] = 'Масштаб оновлено';
$string['eventusergraded'] = 'Змінено бали в журналі оцінок';
$string['excluded'] = 'НЕ оці-<br />нюється';
$string['excluded_help'] = 'Якщо відмічено, то бали не будуть включатися в будь-яке об’єднання';
$string['expand'] = 'Розкрити категорію';
$string['expandcriterion'] = 'Розгорнути критерій';
$string['export'] = 'Експорт';
$string['exportalloutcomes'] = 'Експортувати всі результати';
$string['exportas'] = 'Експортувати як';
$string['exportfeedback'] = 'Додати в експорт відгуки';
$string['exportfeedback_desc'] = 'Це можна змінити під час експорту.';
$string['exportformatoptions'] = 'Опції формату експорту';
$string['exportonlyactive'] = 'Виключити заблокованих користувачів';
$string['exportonlyactive_help'] = 'Включити до експорту тільки студентів, які мають доступ до свого облікового запису, виключивши заблокованих.';
$string['exportplugins'] = 'Експорт Оцінок';
$string['exportsettings'] = 'Налаштування експорту';
$string['exportto'] = 'Експортувати до';
$string['externalurl'] = 'Зовнішній URL';
$string['externalurl_desc'] = 'Якщо використовується зовнішній журнал оцінок, то тут потрібно вказати його URL.';
$string['extracreditvalue'] = 'Додаткові бали для  {$a}';
$string['extracreditwarning'] = 'Примітка: встановлення усіх елементів категорії в якості додаткових балів виключить їх з підрахунку оцінки. Отже, не буде балів.';
$string['fail'] = 'Не вдалося';
$string['feedback'] = 'Відгук';
$string['feedback_help'] = 'Це блок дозволяє будь-які коментарі відносно проставленої оцінки.';
$string['feedbackadd'] = 'Додати відгук';
$string['feedbackedit'] = 'Редагувати відгук';
$string['feedbackfiles'] = 'Файли відгуків';
$string['feedbackforgradeitems'] = 'Відгук до {$a}';
$string['feedbackhistoryfiles'] = 'Файли історії відгуків';
$string['feedbackprovided'] = 'Зворотній зв\'язок надано';
$string['feedbacks'] = 'Відгуки';
$string['feedbacksaved'] = 'ВІдгук збережено';
$string['feedbackview'] = 'Переглянути відгук';
$string['filterbothactive'] = 'Перший ({$a->first}) Останній ({$a->last})';
$string['filterbyname'] = 'Фільтрувати за назвою';
$string['filterfirstactive'] = 'Перший ({$a->first})';
$string['filterlastactive'] = 'Останній ({$a->last})';
$string['finalgrade'] = 'Фінальна оцінка';
$string['finalgrade_help'] = 'Якщо перевизначення відмічено, то оцінки можуть бути додані або змінені.';
$string['fixedstudents'] = 'Зафіксувати колонку прізвищ';
$string['fixedstudents_help'] = 'Дозволяє таблиці оцінок прокручуватися горизонтально залишаючи видимою колонку з прізвищами, роблячи її зафіксованою.';
$string['forceimport'] = 'Примусовий імпорт';
$string['forceimport_help'] = 'Примусовий імпорт оцінок відбувається, навіть якщо оцінки були змінені після експортування файлу імпорту';
$string['forceoff'] = 'Примусово: Вимк.';
$string['forceon'] = 'Примусово: Увімк.';
$string['forelementtypes'] = 'для вибраних {$a}';
$string['forstudents'] = 'Для студентів';
$string['full'] = 'Повністю';
$string['fullmode'] = 'Показати оцінки та підсумки';
$string['generalsettings'] = 'Загальні налаштування';
$string['grade'] = 'Оцінка';
$string['grade_help'] = 'Оцінка для нагородження учня за роботу.';
$string['gradeadministration'] = 'Керування оцінками';
$string['gradealreadyupdated'] = 'Частину оцінок ({$a}) не було імпортовано, оскільки оцінки в імпортованому файлі старіше, ніж оцінки оцінювача. Щоб при цьому продовжити імпорт оцінок, використовуйте функцію примусового імпорту.';
$string['gradeanalysis'] = 'Аналіз балів';
$string['gradebook'] = 'Журнал оцінок';
$string['gradebookcalculationsfixbutton'] = 'Прийняти зміни оцінки і виправити помилки розрахунку';
$string['gradebookcalculationsuptodate'] = 'Розрахунки в журналі оцінок оновлено. Вам, можливо, буде потрібно перезавантажити цю сторінку, щоб побачити зміни.';
$string['gradebookcalculationswarning'] = 'Примітка: були виявлені деякі помилки під час обчислення оцінок, які відображаються в журналі оцінок. Якщо ваш курс не розпочався або триває, рекомендується виправити помилки, натиснувши кнопку нижче, хоча це призведе до зміни деяких оцінок. Якщо ваш курс уже закінчився, а оцінки були подані, ви, ймовірно, не хочете вирішувати цю проблему.

Новіша версія {$a->currentversion}; ви використовуєте версію журналу оцінок {$a->gradebookversion}. Ви можете побачити список змін у <a href="{$a->url}">змінах обчислення оцінки</a>.';
$string['gradebookhiddenerror'] = 'На даний час всі елементи журналу оцінок приховані від студентів';
$string['gradebookhistories'] = 'Історія оцінювання';
$string['gradebooknavigationmenu'] = 'Меню навігації за оцінками';
$string['gradebooksetup'] = 'Налаштування журналу оцінок';
$string['gradeboundary'] = 'Межа буквеної оцінки';
$string['gradeboundary_help'] = 'Відсоткова границя, при перевищенні якої оцінкам присвоюється відповідна літера (якщо передбачено відображення буквеного типу оцінки).';
$string['gradecategories'] = 'Категорії оцінювання';
$string['gradecategory'] = 'Категорія оцінки';
$string['gradecategoryonmodform'] = 'Категорія оцінки';
$string['gradecategoryonmodform_help'] = 'Цей параметр визначає категорію в Журналі оцінок, в яку буде розміщено оцінку діяльності.';
$string['gradecategorysettings'] = 'Параметри категорії оцінювання';
$string['gradedisplay'] = 'Показ оцінок';
$string['gradedisplaytype'] = 'Тип показу оцінки';
$string['gradedisplaytype_help'] = 'Цей параметр визначає спосіб відображення оцінок у звітах грейдера та користувачів.

* Буква – літери або слова використовуються для представлення діапазону оцінок, як визначено в розділі «Літери» в налаштуваннях журналу оцінок
* Відсоток - відносно максимальної та мінімальної оцінок
* Реальний – фактичні оцінки або значення шкали';
$string['gradedon'] = 'Оцінено: {$a}';
$string['gradeexport'] = 'Експорт оцінок';
$string['gradeexportcolumntype'] = '{$a->name} ({$a->extra})';
$string['gradeexportcustomprofilefields'] = 'Додаткові поля користувача для експорту';
$string['gradeexportcustomprofilefields_desc'] = 'Включає вказані додаткові поля користувача при експорті журналу оцінок, розділяються комами.';
$string['gradeexportdecimalpoints'] = 'Оцінка експорту десяткових знаків';
$string['gradeexportdecimalpoints_desc'] = 'Кількість десяткових знаків для відображення для експорту. Це можна змінити під час експорту.';
$string['gradeexportdisplaytype'] = 'Тип показу експортованих оцінок';
$string['gradeexportdisplaytype_desc'] = 'Для перегляду експорту оцінка може бути показана як реальні бали або у відсотках (з врахуванням мінімальних та максимальних балів), або як буквена оцінка (A, B, C, відмінно, добре тощо). Може бути змінено під час експорту.';
$string['gradeexportdisplaytypes'] = 'Типи показу експорту оцінок';
$string['gradeexportuserprofilefields'] = 'Поля користувача для експорту';
$string['gradeexportuserprofilefields_desc'] = 'Включає вказані поля користувача при експорті журналу оцінок, розділяються комами.';
$string['gradeforstudent'] = '{$a->student}<br />{$a->item}{$a->feedback}';
$string['gradegrademinmax'] = 'Початкові мін. та макс. оцінки';
$string['gradehelp'] = 'Довідка по оцінках';
$string['gradehistorylifetime'] = 'Час збереження історії оцінювання';
$string['gradehistorylifetime_help'] = 'Це вказує термін, протягом якого ви хочете зберігати історію оцінювання. Рекомендується зберігати настільки довго, наскільки це потрібно. Якщо у вас виникли проблеми з продуктивністю або обмежений простір бази даних, спробуйте встановити менше значення.';
$string['gradeimport'] = 'Імпорт оцінок';
$string['gradeimportfailed'] = 'Сталася помилка в процесі імпорту оцінок. Деталі:';
$string['gradeitem'] = 'Елемент оцінювання';
$string['gradeitemaddusers'] = 'НЕ оцінювати';
$string['gradeitemadvanced'] = 'Додаткові опції елементу оцінювання';
$string['gradeitemadvanced_help'] = 'Виділіть всі елементи, які повинні бути показані як додаткові при редагуванні елементів оцінювання.';
$string['gradeitemislocked'] = 'Ресурс блоковано в журналі оцінок. Зміни в оцінюванні ресурсу не будуть скопійовані до журналу оцінок поки він заблокований.';
$string['gradeitemlocked'] = 'Оцінювання закрито';
$string['gradeitemmembersselected'] = 'НЕ оцінюються';
$string['gradeitemminmax'] = 'Мінімальна та максимальна оцінки як це визначено в налаштуваннях елементу оцінювання';
$string['gradeitemnonmembers'] = 'Оцінюються';
$string['gradeitemremovemembers'] = 'Оцінювати';
$string['gradeitems'] = 'Елементи оцінювання';
$string['gradeitemsettings'] = 'Параметри елементу оцінювання';
$string['gradeitemsinc'] = 'Оцінки для включення';
$string['gradeletter'] = 'Буквена оцінка';
$string['gradeletter_help'] = 'Буквена оцінка - це букви, A, B, C, ..., або слова, наприклад, Зараховано, Незараховано, Відмінно, Добре, ..., які використовуються для словесного представлення зароблених балів.';
$string['gradeletternote'] = 'Для того щоб видалити буквену оцінку, просто видаліть будь-яке з<br />трьох текстових полів і натисніть кнопку "Зберегти зміни".';
$string['gradeletteroverridden'] = 'Типові буквені оцінки наразі відключено.';
$string['gradeletters'] = 'Буквена оцінка';
$string['gradelocked'] = 'Оцінка закрита';
$string['gradelong'] = '{$a->grade} / {$a->max}';
$string['grademax'] = 'Максимальна оцінка';
$string['grademax_help'] = 'Цей параметр визначає максимальну оцінку для елементу оцінювання або категорії. Максимальна оцінка за діяльність знаходиться на сторінці налаштування діяльності.';
$string['grademin'] = 'Мінімальна оцінка';
$string['grademin_help'] = 'Цей параметр визначає мінімальну оцінку для елементу оцінювання або категорії.';
$string['gradenotificationmessage'] = 'Ви отримали новий відгук про свою роботу для "{$a}"';
$string['gradenotificationsubject'] = 'Вам поставили оцінку';
$string['gradeoutcomeitem'] = 'Оцінка результуючого елементу';
$string['gradeoutcomes'] = 'Результати';
$string['gradeoutcomescourses'] = 'Результати курсу';
$string['gradepass'] = 'Прохідний бал';
$string['gradepass_help'] = 'Цей параметр визначає мінімальну оцінку для проходження. Значення використовується в діяльностях та проходженні курсу, а також у журналі оцінок, якщо бали вищі за прохідний бал, то підсвічується зеленим, інакше червоним.';
$string['gradepassgreaterthangrade'] = 'Прохідний бал не може бути більше ніж максимально можлива оцінка  {$a}';
$string['gradepointdefault'] = 'Типова оцінка в балах';
$string['gradepointdefault_help'] = 'Цей параметр визначає значення за замовчуванням для значення бала оцінки, доступного в елементі оцінки.';
$string['gradepointdefault_validateerror'] = 'Це значення повинно бути цілим числом в межах 1 та максимального балу.';
$string['gradepointmax'] = 'Максимальна оцінка в балах';
$string['gradepointmax_help'] = 'Цей параметр визначає максимальну оцінку в балах, яка доступна для оцінювання цієї діяльності.';
$string['gradepointmax_validateerror'] = 'Це значення повинно бути цілим числом в межах 1 та 10000.';
$string['gradepreferences'] = 'Налаштування';
$string['gradepreferenceshelp'] = 'Довідка налаштування Журналу оцінок';
$string['gradepublishing'] = 'Дозволити публікування';
$string['gradepublishing_help'] = 'Публікація оцінок – це спосіб імпорту та експорту оцінок через URL-адресу без входу в Moodle. Якщо ввімкнено, адміністраторам та користувачам з дозволом публікувати оцінки (за замовчуванням це лише користувачі з роллю менеджера) надаються параметри публікації експорту оцінок у кожному зошиті з курсу.';
$string['gradepublishinglink'] = 'Завантажити: {$a}';
$string['gradereport'] = 'Журнал оцінок';
$string['graderreport'] = 'Журнал оцінок';
$string['grades'] = 'Оцінки';
$string['gradesforuser'] = 'Оцінки для {$a->user}';
$string['gradesmoduledeletionpendingwarning'] = 'Попередження: активність видаляється! Деякі оцінки збираються вилучити.';
$string['gradesmoduledeletionprefix'] = '[Видалення триває]';
$string['gradesonly'] = 'Показувати лише оцінки';
$string['gradessettings'] = 'Параметри оцінювання';
$string['gradetype'] = 'Тип оцінювання';
$string['gradetype_help'] = 'Існує 4 типи оцінювання:

* Відсутнє - неможливе оцінення
* Значення - числове значення між мінімумом та максимумом
* Шкала - елемент списку
* Текст - тільки відгук

Тільки Значення та Шкала можуть бути обраховані в об’єднанні. Типи оцінювання для діяльностей знаходиться на сторінці налаштування діяльності.';
$string['gradevaluetoobig'] = 'Одна з оцінок має значення більше ніж дозволений максимум {$a}';
$string['gradeview'] = 'Перегляд оцінювання';
$string['gradewasmodifiedduringediting'] = 'Оцінка виставлена за {$a->itemname} для {$a->username} була проігнорована, оскільки недавно була змінена іншим.';
$string['gradeweighthelp'] = 'Довідка по зважених оцінках';
$string['gradingmodulename'] = 'Оцінювання ({$a})';
$string['groupavg'] = 'Середнє по групі';
$string['hidden'] = 'Приховано';
$string['hidden_help'] = 'Дата, до якої оцінки будуть прихованими від учасників. Зазвичай це дата після закінчення діяльності і процесу оцінювання.';
$string['hiddenasdate'] = 'Показати дати оцінення для схованих оцінок';
$string['hiddenasdate_help'] = 'Якщо користувач не може бачити бали, то показувати дату оцінування замість \'-\'.';
$string['hiddenuntil'] = 'Приховано';
$string['hiddenuntildate'] = 'Приховано до: {$a}';
$string['hideadvanced'] = 'Сховати додаткові властивості';
$string['hideaverages'] = 'Приховати середні';
$string['hidecalculations'] = 'Приховати розраховані';
$string['hidecategory'] = 'Прихована<br />кат.';
$string['hideeyecons'] = 'Приховати значки показати/приховати';
$string['hidefeedback'] = 'Приховати коментар';
$string['hideforcedsettings'] = 'Приховати примусові налаштування';
$string['hideforcedsettings_help'] = 'Не показувати примусові налаштування в інтерфейсі користувачів.';
$string['hidegroups'] = 'Приховати групи';
$string['hidelocks'] = 'Приховати блокування';
$string['hidenooutcomes'] = 'Показати результати';
$string['hidequickfeedback'] = 'Приховати швидкі коментарі';
$string['hideranges'] = 'Приховати інтервали';
$string['hidetotalifhiddenitems'] = 'Приховати загальні бали,якщо вони містять приховані елементи';
$string['hidetotalifhiddenitems_help'] = 'Цей параметр визначає, чи будуть підсумкові бали, в яких є приховані елементи оцінювання, відображаються для студентів чи замінюватися на дефіс (-). Якщо показувати, то загальні бали можуть бути розраховані або з виключенням або з включенням прихованих елементів.

Якщо приховані елементи виключені, загальна оцінка буде відрізнятися від загальної, яку бачить викладач в журналі оцінок, так як викладач завжди бачить підсумки розраховані з усіх елементів, прихованих чи неприхованих. Якщо приховані елементи включаються, студенти матимуть змогу вирахувати приховані елементи.';
$string['hidetotalshowexhiddenitems'] = 'Показати загальні за виключенням схованих елементів';
$string['hidetotalshowinchiddenitems'] = 'Показати загальні включаючи сховані елементи';
$string['hideverbose'] = 'Приховати {$a->category}{$a->itemmodule} {$a->itemname}';
$string['highgradeascending'] = 'Сортувати за зростанням рейтингу';
$string['highgradedescending'] = 'Сортувати за спаданням рейтингу';
$string['highgradeletter'] = 'Максимум';
$string['identifier'] = 'Ідентифікувати користувача';
$string['idnumbers'] = 'Номер id';
$string['ignore'] = 'Ігнорувати';
$string['import'] = 'Імпорт';
$string['importas'] = 'Імпортувати як';
$string['importcsv'] = 'Імпортувати з CSV';
$string['importcsv_help'] = 'Оцінки можна імпортувати за допомогою файлу CSV у такому форматі:

* Кожен рядок файлу містить один запис
* Кожен запис являє собою ряд даних, розділених вибраним роздільником
* Перший запис містить список імен полів, що визначають формат решти файлу
* Ім\'я поля, що містить дані про особу користувача, є обов\'язковим - або ім\'я користувача, або ідентифікаційний номер, або адреса електронної пошти

Файл правильного формату можна отримати, спочатку експортувавши деякі оцінки. Після цього файл можна відредагувати та зберегти як файл CSV.';
$string['importcsv_link'] = 'grade/import/csv/index';
$string['importcustom'] = 'Імпортувати як звичайні результати (тільки для цього курсу)';
$string['importdata'] = 'Дані';
$string['importdata_help'] = 'Оцінки можна вставити безпосередньо з електронної таблиці OpenDocument або Excel у такому форматі:

* Принаймні один стовпець повинен містити ідентифікаційні дані користувача - ім\'я користувача, адресу електронної пошти або ідентифікаційний номер.
* Інші стовпці повинні мати заголовки, як для існуючих видів діяльності або оцінок.

Правильно відформатовану електронну таблицю можна отримати, спочатку експортувавши деякі оцінки. Потім електронну таблицю можна редагувати, щоб додати більше оцінок та зберегти.

Виберіть і скопіюйте стовпці, які потрібно імпортувати з електронної таблиці, а потім вставте їх у це поле.';
$string['importerror'] = 'Виникла помилка, цей скрипт було викликано з недопустимими параметрами';
$string['importfailed'] = 'Не вдалося імпортувати. Ніякої інформації не було імпортовано.';
$string['importfeedback'] = 'Імпортувати відгуки';
$string['importfile'] = 'Файл імпорту';
$string['importfilemissing'] = 'Не отримано жодного файлу, поверніться до форми та перевірте чи правильно ви вказали файл.';
$string['importfrom'] = 'Імпорт з';
$string['importoutcomenofile'] = 'Завантажений файл порожній або битий. Будь ласка, перевірте правильність файлу. Проблема виникла в рядку {$a}; не співпадає кількість колонок цьому рядку з їх кількістю в першому (в заголовку) або імпортований файл не має рядку заголовка. Перевірте ваш файл на наявність рядку заголовка.';
$string['importoutcomes'] = 'Імпорт результатів';
$string['importoutcomes_help'] = 'Результати можуть бути імпортовані за допомогою CSV-файлу у форматі, як для CSV файлу експорту результатів.';
$string['importoutcomes_link'] = 'grade/outcome';
$string['importoutcomesuccess'] = 'Імпортовані результати "{$a->name}" з ID #{$a->id}';
$string['importplugins'] = 'Імпорт Оцінок';
$string['importpreview'] = 'Передперегляд імпорту';
$string['importsettings'] = 'Імпортувати налаштування';
$string['importskippednomanagescale'] = 'Ви не маєте права додавати нові шкали, тому результат "{$a}" було пропущено як такий, що вимагає створення нової шкали.';
$string['importskippedoutcome'] = 'Результат з короткою назвою "{$a}" вже створений в цьому контексті, тому його значення в імпортованому файлі було пропущено.';
$string['importstandard'] = 'Імпортувати як стандартні результати';
$string['importsuccess'] = 'Імпортування оцінок завершено';
$string['importxml'] = 'Імпортувати з XML';
$string['includescalesinaggregation'] = 'Включити шкали в об\'єднання';
$string['includescalesinaggregation_help'] = 'Ви можете змінити шкали оцінювання включивши їх як числа в усі об\'єднання оцінок в усіх журналах оцінок усіх курсів. ПОПЕРЕДЖЕННЯ: зміна даної установки примусить перерахувати всі об\'єднані бали.';
$string['incorrectcourseid'] = 'Помилковий ідентифікатор курсу';
$string['incorrectcustomscale'] = '(некоректна шкала, потрібно змінити.)';
$string['incorrectminmax'] = 'Мінімум повинен бути менше ніж максимум';
$string['inherit'] = 'Успадковано';
$string['intersectioninfo'] = 'Інформація Студент/Оцінка';
$string['invalidgradeexporteddate'] = 'Дата експорту є недійсною, тому що це більше, ніж рік тому, або в майбутньому, або тому, що формат є неприпустимим.';
$string['item'] = 'Елемент';
$string['iteminfo'] = 'Інформація елементу';
$string['iteminfo_help'] = 'Цей параметр забезпечує простір для введення інформації про елемент. Інформація не відображається в іншому місці.';
$string['itemname'] = 'Назва елементу';
$string['itemnamehelp'] = 'Назва цього елементу, доданого модулем.';
$string['items'] = 'Елементи';
$string['itemsedit'] = 'Редагувати елемент оцінювання';
$string['keephigh'] = 'Утримувати найвищі';
$string['keephigh_help'] = 'Якщо включено, то будуть утримуватися тільки Х найвищих оцінок, Х буде встановленим значенням для даної опції.';
$string['keephighestvalues'] = 'Утримувати {$a} найвищих значень';
$string['keymanager'] = 'Ключ управління';
$string['lessthanmin'] = 'Бали виставлені за {$a->itemname} для {$a->username} менше ніж дозволений мінімум';
$string['letter'] = 'Буква';
$string['lettergrade'] = 'Буквена оцінка';
$string['lettergradenonnumber'] = 'Мінімальна та/або максимальна нечислові оцінки для';
$string['letterpercentage'] = 'Буква (відсотки)';
$string['letterreal'] = 'Буква (значення)';
$string['letters'] = 'Букви';
$string['linkedactivity'] = 'Зв\'язана діяльність';
$string['linkedactivity_help'] = 'Цей параметр визначає діяльність, до якої цей елемент оцінювання прив’язується. Це може бути використано для оцінки успішності студентів за критеріями, які не оцінюються балами діяльності.';
$string['linktoactivity'] = 'Посилання на дію {$a->name} {$a->title}';
$string['lock'] = 'Блокувати';
$string['locked'] = 'Заблоковано';
$string['locked_help'] = 'Якщо відмічено, то бали вже не будуть автоматично оновлюватися при проходженні діяльності.';
$string['locktime'] = 'Заблоковано';
$string['locktimedate'] = 'Закрито після: {$a}';
$string['lockverbose'] = 'Закрити {$a->category}{$a->itemmodule} {$a->itemname}';
$string['lowest'] = 'Мінімальна';
$string['lowgradeletter'] = 'Мінімум';
$string['manageoutcomes'] = 'Керуйте результатами';
$string['manualitem'] = 'Ручний елемент';
$string['mapfrom'] = 'Співставити з';
$string['mapfrom_help'] = 'Вкажіть колонку в таблиці, яка містить ідентифікатор користувача - псевдоім’я, код або ел.пошту.';
$string['mappings'] = 'Співставлення елементів оцінювання';
$string['mappings_help'] = 'Для кожної колонки оцінок у таблиці, виберіть відповідний елемент оцінювання для імпортування в нього оцінок.';
$string['mapto'] = 'Співставити до';
$string['mapto_help'] = 'Вибрати ті ж ідентифікаційні дані, які вказано для "Співставити з".';
$string['max'] = 'Максимальна';
$string['maxgrade'] = 'Максимальна оцінка';
$string['meanall'] = 'Всі оцінки';
$string['meangraded'] = 'Непорожні оцінки';
$string['meanselection'] = 'Оцінки відібрані для середніх значень';
$string['meanselection_help'] = 'Це налаштування визначає, як будуть елементи без оцінення включені в середнє по категоріях та окремих елементах.';
$string['median'] = 'Медіана';
$string['min'] = 'Мінімальна';
$string['minimum_show'] = 'Показати мінімальну оцінку';
$string['minimum_show_help'] = 'МІнімальна оцінка використовується при розрахунку оцінки та значимості. Якщо не вказано, то типово мінімальна оцінка буде дорівнювати нулю і не може бути змінена.';
$string['minmaxtouse'] = 'Мінімальна та максимальна оцінки використані в обрахунку';
$string['minmaxtouse_desc'] = 'Цей параметр визначає, чи слід використовувати вихідні мінімальну та максимальну оцінки коли надана оцінка або мінімальну та максимальну оцінки як зазначено в налаштуваннях елементу оцінювання, коли розрахована оцінка показується в журналі оцінок. Рекомендується змінювати цей параметр у максимально неробочий час, оскільки будуть перераховуватися всі оцінки, що може призвести до великого навантаження сервера.';
$string['minmaxtouse_help'] = 'Цей параметр визначає, чи слід використовувати вихідні мінімальну та максимальну оцінки коли надана оцінка або мінімальну та максимальну оцінки як зазначено в налаштуваннях елементу оцінювання, коли розрахована оцінка показується в журналі оцінок.';
$string['minmaxtouse_link'] = 'Grades_min_max';
$string['minmaxupgradedgrades'] = 'Примітка: Деякі оцінки було змінено для того, щоб усунути неузгодженість в журналі оцінок, викликану зміною мінімальної та максимальної оцінок, використаних при розрахунку показаної оцінки. Рекомендується, щоб зміни було розглянуто та прийнято.';
$string['minmaxupgradefixbutton'] = 'Усунення невідповідностей';
$string['minmaxupgradewarning'] = 'Примітка: була виявлена неузгодженість з деякими оцінками у зв\'язку зі зміною мінімальної та максимальної оцінок, які використовуються при розрахунку оцінки, що показується в журналі оцінок. Рекомендується усунути невідповідність натиснувши на кнопку нижче, хоча це призведе до зміни в деяких оцінках.';
$string['missingitemtypeoreid'] = 'Бракує ключа масиву (itemtype або eid).';
$string['missingscale'] = 'Шкала повинна бути вибрана';
$string['mode'] = 'Мода';
$string['modgrade'] = 'Оцінка';
$string['modgrade_help'] = 'Виберіть тип оцінювання, який використовується для цієї діяльності. Якщо вибрано «масштаб», ви можете вибрати масштаб зі спадного меню. Якщо використовується балальна оцінка, ви можете ввести максимальну оцінку, доступну для цієї діяльності.';
$string['modgradecantchangegradetype'] = 'Ви не можете змінити тип, оскільки вже виставлено оцінки для цього елементу.';
$string['modgradecantchangegradetypemsg'] = 'Деякі оцінки вже виставлено, тому тип оцінки не можна змінювати. Якщо ви хочете змінити максимальну оцінку, то спочатку потрібно вказати, чи хочете ви перерахувати наявні оцінки за цією шкалою.';
$string['modgradecantchangegradetyporscalemsg'] = 'Деякі оцінки вже виставлено, тому тип оцінки не можна змінювати.';
$string['modgradecantchangeratingmaxgrade'] = 'Ви не можете змінити максимальну оцінку, якщо вже виставлено оцінки для цього елементу.';
$string['modgradecantchangescale'] = 'Ви не можете змінити шкалу, якщо вже виставлено оцінки для цього елементу.';
$string['modgradecategorycantchangegradetypemsg'] = 'Ця категорія пов’язана з оцінюваними елементами, які були перевизначені. Деякі оцінки вже виставлено, тому тип оцінки не можна змінити. Якщо ви хочете змінити максимальну оцінку, то спочатку потрібно визначити, чи будуть перераховані наявні оцінки.';
$string['modgradecategorycantchangegradetyporscalemsg'] = 'Ця категорія пов’язана з оцінюваними елементами, які були перевизначені. Деякі оцінки вже виставлено, тому тип оцінки та шкалу не можна змінити.';
$string['modgradecategoryrescalegrades'] = 'Перерахувати перевизначені бали';
$string['modgradecategoryrescalegrades_help'] = 'При зміні максимальних оцінок в елементі журналу оцінок вы повинні вказати, чи потрібно також оновити наявні оцінки у відсотках.

Якщо цей параметр встановлено в "Так", то всі наявні перевизначені оцінки будуть перераховані за зміненою школою так, що оцінка у відсотках залишиться такою ж.

Наприклад, якщо параметр встановлено в "Так", зміна максимальної оцінки елементу з 10 до 20 призведе до перерахунку оцінки 6/10 (60%)  в оцінку 12/20 (60%). Якщо цей параметр встановлено в "Ні",  то оцінка залишиться без змін, і потрібно буде вручну виправити бали цих елементів, щоб переконатися в коректності оцінок.';
$string['modgradedonotmodify'] = 'Не змінювати виставлені бали';
$string['modgradeerrorbadpoint'] = 'Недійсне значення оцінки. Це має бути ціле число від 1 до {$a}';
$string['modgradeerrorbadscale'] = 'Вибрано неправильну шкалу. Будь ласка, переконайтеся, що ви вибрали одну з можливих шкал оцінювання';
$string['modgrademaxgrade'] = 'Максимальна оцінка';
$string['modgraderescalegrades'] = 'Перерахувати наявні оцінки';
$string['modgraderescalegrades_help'] = 'При зміні максимальних оцінок в елементі журналу оцінок вы повинні вказати, чи потрібно також оновити наявні оцінки у відсотках.

Якщо цей параметр встановлено в "Так", то всі наявні оцінки будуть перераховані за зміненою школою так, що оцінка у відсотках залишиться такою ж.

Наприклад, якщо параметр встановлено в "Так", зміна максимальної оцінки елементу з 10 до 20 призведе до перерахунку оцінки 6/10 (60%)  в оцінку 12/20 (60%). Якщо цей параметр встановлено в "Ні",  то оцінка буде змінена з 6/10 (60%)  в оцінку 6/20 (30%), і потрібно буде вручну виправити бали цих елементів, щоб переконатися в коректності оцінок.';
$string['modgradetype'] = 'Тип';
$string['modgradetypenone'] = 'Відсутнє';
$string['modgradetypepoint'] = 'Бали';
$string['modgradetypescale'] = 'Шкала';
$string['morethanmax'] = 'Бали виставлені за {$a->itemname} для {$a->username} більше ніж дозволений максимум';
$string['moveselectedto'] = 'Перемістити вибрані елементи до';
$string['movingelement'] = 'Перемістити {$a}';
$string['multfactor'] = 'Множник';
$string['multfactor_help'] = 'Показник, на який множать усі оцінки, що відповідають даному елементу оцінки, з максимальним значенням максимальної оцінки. Наприклад, якщо Множник 2, а Максимальна оцінка 100, то всі оцінки менше 50 множаться на 2, а всі, які більше 50, стають 100.';
$string['multfactorvalue'] = 'Множник для {$a}';
$string['mustchooserescaleyesorno'] = 'Ви повинні вибрати, чи потрібно перераховувати наявні оцінки за зміненою шкалою.';
$string['mygrades'] = 'Посилання на оцінки в меню користувача';
$string['mygrades_desc'] = 'Цей параметр дозволяє створити посилання на зовнішній журнал оцінок в меню користувача.';
$string['mypreferences'] = 'Мої налаштування';
$string['myreportpreferences'] = 'Мої налаштування звіту';
$string['myself'] = 'Себе';
$string['navmethod'] = 'Метод навігації';
$string['neverdeletehistory'] = 'Ніколи не видаляти історію';
$string['newcategory'] = 'Нова категорія';
$string['newitem'] = 'Новий елемент оцінювання';
$string['newoutcomeitem'] = 'Новий елемент результату';
$string['no'] = 'Ні';
$string['nocategories'] = 'Не вдалося додати чи знайти категорію для цього курсу';
$string['nocategoryname'] = 'Не задано назву категорії';
$string['nocategoryview'] = 'Відсутні категорії для відображення';
$string['nocourses'] = 'Ще немає курсів';
$string['noexistingoutcomes'] = 'Наявних результатів немає.';
$string['noexistingscales'] = 'Немає існуючих ваг.';
$string['noforce'] = 'Не примушувати';
$string['nogradeletters'] = 'Буквені оцінки не задані';
$string['nogradesreturned'] = 'Немає оцінок';
$string['noidnumber'] = 'Немає іd номера';
$string['nolettergrade'] = 'Немає буквених оцінок для';
$string['nomode'] = 'Н/В';
$string['nonnumericweight'] = 'Отримано нечислове значення для';
$string['nonunhideableverbose'] = 'Щоб показати цю оцінку, вам потрібно показати {$a->itemname}.';
$string['nonunlockableverbose'] = 'Щоб розблокувати цю оцінку, потрібно розблокувати {$a->itemname}.';
$string['nonweightedpct'] = 'незважений %';
$string['nooutcome'] = 'Без результату';
$string['nooutcomes'] = 'Елементи результатів повинні бути пов\'язані з курсовими результатами, але в цьому курсі ще не створено результатів. Може хочете додати?';
$string['nopermissiontoresetweights'] = 'Немає прав на зміну значимості';
$string['nopublish'] = 'Не публікувати';
$string['noreports'] = 'Ви не зараховані, не викладаєте жоден курс на цьому сайті.';
$string['norolesdefined'] = 'Не визначено ролі в Керування сайтом > Журнал оцінок > Основні налаштування > Ролі для оцінення';
$string['noscales'] = 'Результати повинні бути пов\'язані з курсовими або глобальними шкалами, але цього поки що немає. Може хочете додати?';
$string['noselectedcategories'] = 'Не вибрано категорій';
$string['noselecteditems'] = 'Не вибрано елементи';
$string['notenrolled'] = 'Наразі ви не зараховані на жоден курс.';
$string['notteachererror'] = 'Ви повинні бути викладачем, щоб використовувати це в подальшому.';
$string['nousersloaded'] = 'Не завантажено користувачів';
$string['nouserstograde'] = 'No users to grade';
$string['numberofgrades'] = 'Кількість оцінок';
$string['onascaleof'] = 'від {$a->grademin} до {$a->grademax}';
$string['operations'] = 'Операції';
$string['options'] = 'Параметри';
$string['others'] = 'Інше';
$string['otheruser'] = 'Користувач';
$string['outcome'] = 'Результат';
$string['outcome_help'] = 'Цей параметр визначає результат, з яким цей елемент оцінення буде відображатися в результаті оцінювання.';
$string['outcomeassigntocourse'] = 'Призначити інший результат для цього курсу';
$string['outcomecategory'] = 'Створити результати в категорії';
$string['outcomecategorynew'] = 'Нова категорія';
$string['outcomeconfirmdelete'] = 'Ви впевнені, що бажаєте видалити результат "{$a}"?';
$string['outcomecreate'] = 'Додати новий результат';
$string['outcomedelete'] = 'Видалити результат';
$string['outcomefullname'] = 'Повна назва';
$string['outcomeitem'] = 'Елемент результату';
$string['outcomeitemsedit'] = 'Редагувати елемент результату';
$string['outcomereport'] = 'Звіт результату';
$string['outcomes'] = 'Результати';
$string['outcomescourse'] = 'Результати використані в курсі';
$string['outcomescoursecustom'] = 'Використано ручне (не видаляти)';
$string['outcomescoursenotused'] = 'Стандартне не використано';
$string['outcomescourseused'] = 'Використано стандартне (не видаляти)';
$string['outcomescustom'] = 'Результати вручну';
$string['outcomesdisabled'] = 'Результати не ввімкнено';
$string['outcomeshortname'] = 'Коротка назва';
$string['outcomesstandard'] = 'Стандартні результати';
$string['outcomesstandardavailable'] = 'Доступні стандартні результати';
$string['outcomestandard'] = 'Стандартний результат';
$string['outcomestandard_help'] = 'Стандартний результат доступний на веб-сайті, для всіх курсів.';
$string['overallaverage'] = 'Загальне середнє';
$string['overridden'] = 'Анулювати';
$string['overridden_help'] = 'Коли опція ввімкнена, тобто встановлений прапорець на відповідному пункті меню, будь-які спроби автоматичного регулювання величини оцінки не працюють. Часто цей прапорець встановлюється автоматично безпосередньо в журналі оцінок, але може бути ввімкненим/вимкненим і вручну за допомогою елементів форми.';
$string['overriddennotice'] = 'Ваші фінальні бали з даної активності були відкореговані вручну.';
$string['overridecat'] = 'Дозволити змінювати вручну оцінки категорій';
$string['overridecat_help'] = 'Відключення цього параметра робить неможливим зміну оцінок категорій.';
$string['overridesitedefaultgradedisplaytype'] = 'Відмовитися від типових установок';
$string['overridesitedefaultgradedisplaytype_help'] = 'Якщо відмічено, то можна встановити буквені оцінки та їх межі для цього курсу, а не використовувати стандартні налаштування сайту.';
$string['overrideweightofa'] = 'Змінити значимість {$a}';
$string['parentcategory'] = 'Належить до категорії';
$string['pass'] = 'Пас';
$string['pctoftotalgrade'] = '% підсумкової оцінки';
$string['percent'] = 'Від-<br />сотки';
$string['percentage'] = 'Відсоток';
$string['percentageletter'] = 'Відсоток (буква)';
$string['percentagereal'] = 'Відсоток (бали)';
$string['percentascending'] = 'Сортувати за зростанням відсотків';
$string['percentdescending'] = 'Сортувати за зниженням відсотків';
$string['percentshort'] = '%';
$string['plusfactor'] = 'Компенсація';
$string['plusfactor_help'] = 'Число, яке додається до оцінки кожного користувача у відповідному елементі оцінювання після обчислення Множника.';
$string['plusfactorvalue'] = 'Компенсація {$a}';
$string['points'] = 'бали';
$string['pointsascending'] = 'Сортувати за зростанням балів';
$string['pointsdescending'] = 'Сортувати за спаданням балів';
$string['positionfirst'] = 'Перша';
$string['positionlast'] = 'Остання';
$string['preferences'] = 'Налаштування';
$string['prefgeneral'] = 'Загальне';
$string['prefletters'] = 'Буквені оцінки та межі';
$string['prefrows'] = 'Спеціальні рядки';
$string['prefshow'] = 'Показати/Сховати значки';
$string['previewrows'] = 'Переглянути перших записів';
$string['privacy:metadata:categorieshistory'] = 'Запис попередніх версій категорій оцінок';
$string['privacy:metadata:filepurpose'] = 'Файли відгуків, що зберігаються в журналі оцінок для користувача.';
$string['privacy:metadata:grade_import_newitem'] = 'Тимчасова таблиця для зберігання нових назв grade_item з імпорту оцінок';
$string['privacy:metadata:grade_import_newitem:importcode'] = 'Унікальний код партії для ідентифікації однієї партії імпорту';
$string['privacy:metadata:grade_import_newitem:importer'] = 'Користувач імпортує дані';
$string['privacy:metadata:grade_import_newitem:itemname'] = 'Нова назва предмета класу';
$string['privacy:metadata:grade_import_values'] = 'Тимчасова таблиця для імпорту оцінок';
$string['privacy:metadata:grade_import_values:feedback'] = 'Відгук про оцінку';
$string['privacy:metadata:grade_import_values:finalgrade'] = 'Вартість сирого сорту';
$string['privacy:metadata:grade_import_values:importcode'] = 'Унікальний код партії для ідентифікації однієї партії імпорту';
$string['privacy:metadata:grade_import_values:importer'] = 'Користувач імпортує дані';
$string['privacy:metadata:grade_import_values:importonlyfeedback'] = 'Позначити, якщо імпортовано лише відгук';
$string['privacy:metadata:grade_import_values:userid'] = 'Користувач, чия оцінка була імпортована';
$string['privacy:metadata:grades'] = 'Запис оцінок';
$string['privacy:metadata:grades:aggregationstatus'] = 'Агрегаційний стан';
$string['privacy:metadata:grades:aggregationweight'] = 'Вага в сукупності';
$string['privacy:metadata:grades:feedback'] = 'Відгук';
$string['privacy:metadata:grades:finalgrade'] = 'Оцінка';
$string['privacy:metadata:grades:information'] = 'Додаткова інформація про оцінку';
$string['privacy:metadata:grades:timemodified'] = 'Час, коли оцінка була востаннє змінена';
$string['privacy:metadata:grades:userid'] = 'Ідентифікатор користувача, чия це оцінка';
$string['privacy:metadata:grades:usermodified'] = 'Ідентифікатор користувача, який востаннє змінив запис';
$string['privacy:metadata:gradeshistory'] = 'Запис попередніх класів';
$string['privacy:metadata:history:loggeduser'] = 'Ідентифікатор користувача, який увійшов у систему під час встановлення версій';
$string['privacy:metadata:history:timemodified'] = 'Час, коли відбулося встановлення версій';
$string['privacy:metadata:itemshistory'] = 'Запис попередніх версій оцінок';
$string['privacy:metadata:outcomes'] = 'Запис про результати';
$string['privacy:metadata:outcomes:timemodified'] = 'Час зміни запису';
$string['privacy:metadata:outcomes:usermodified'] = 'Користувач, який останній змінив запис';
$string['privacy:metadata:outcomeshistory'] = 'Запис попередніх версій результатів';
$string['privacy:metadata:scale'] = 'Запис терезів';
$string['privacy:metadata:scale:timemodified'] = 'Час останньої зміни запису';
$string['privacy:metadata:scale:userid'] = 'Користувач, який останній змінив запис';
$string['privacy:metadata:scalehistory'] = 'Запис попередніх версій ваг';
$string['privacy:path:relatedtome'] = 'Пов\'язаний зі мною';
$string['privacy:request:historyactiondelete'] = 'Видалити';
$string['privacy:request:historyactioninsert'] = 'Вставити';
$string['privacy:request:historyactionupdate'] = 'Оновлення';
$string['privacy:request:unknowndeletedgradeitem'] = 'Невідомо (пункт оцінки видалено)';
$string['profilereport'] = 'Звіт профілю користувача';
$string['profilereport_help'] = 'Звіт оцінювання використано на сторінці профайлу користувача.';
$string['publishing'] = 'Публікація';
$string['publishingoptions'] = 'Параметри публікування оцінок';
$string['quickfeedback'] = 'Короткий відгук';
$string['quickgrading'] = 'Швидке оцінювання';
$string['quickgrading_help'] = 'Якщо дозволено, то при включеному редагуванні, біля кожного елементу оцінювання з’явиться текстовий блок, який дозволить виставити оцінки всім студентам одразу. Всі зміни будуть збережені при натисканні кнопки збереження.

Зверніть увагу, якщо ви проставляєте оцінки таким чином, то вони не можуть бути змінені через оцінення діяльності.';
$string['range'] = 'Інтервал';
$string['rangedecimals'] = 'Діапазон десяткових знаків';
$string['rangedecimals_help'] = 'Кількість десяткових знаків для відображення діапазону.';
$string['rangesdecimalpoints'] = 'Показувати дробові значення в інтервалах';
$string['rangesdecimalpoints_help'] = 'Цей параметр визначає кількість десяткових знаків для відображення для кожного діапазону або використання загального параметра десяткового знака для категорії або елемента оцінки (успадкування).';
$string['rangesdisplaytype'] = 'Тип показу інтервалу';
$string['rangesdisplaytype_help'] = 'Це налаштування визначає як буде показано інтервал для категорій та елементів оцінювання - реальними балами, у відсотках або буквами, або інакше (успадковується).';
$string['rank'] = 'Порядок';
$string['rawpct'] = '% вико-<br />нання';
$string['real'] = 'Бали';
$string['realletter'] = 'Бали (буква)';
$string['realpercentage'] = 'Бали (відсоток)';
$string['recalculatinggrades'] = 'Перерахунок оцінок';
$string['recovergradesdefault'] = 'Повернути оцінки';
$string['recovergradesdefault_help'] = 'Типово повертати старі оцінки, коли користувачі перезараховуються на курс';
$string['refreshpreview'] = 'Оновити перегляд';
$string['regradeanyway'] = 'Переоцінити обов\'язково';
$string['removeallcoursegrades'] = 'Вилучити всі оцінки';
$string['removeallcoursegrades_help'] = 'Якщо поставлено галочку, усі оцінки та оцінки, які були додані вручну до книги оцінок, будуть видалені, а також дані про замінені, виключені, приховані та заблоковані оцінки. Залишаться лише оцінки та оцінки, пов’язані з діяльністю.';
$string['removeallcourseitems'] = 'Вилучити всі елементи та категорії';
$string['removeallcourseitems_help'] = 'Якщо відмічено, то всі категорії та елементи оцінок, які були додані в журнал оцінок вручну, будуть вивилучені разом з оцінками і даними, які є перевизначеними, виключеними (не оцінюються), приховувані чи блоковані. Залишаться лише оцінки пов’язані з активними елементами.';
$string['report'] = 'Звіт';
$string['reportdefault'] = 'Типові установки ({$a})';
$string['reportplugins'] = 'Розширення звіту';
$string['reportsettings'] = 'Налаштування звіту';
$string['reprintheaders'] = 'Повтор заголовків';
$string['resetweights'] = 'Скинути значимості {$a->itemname}';
$string['resetweightsshort'] = 'Скинути значимості';
$string['respectingcurrentdata'] = 'Залишити поточну конфігурацію немодифікованою';
$string['rowpreviewnum'] = 'Переглянути рядки';
$string['rowpreviewnum_help'] = 'Дані для імпорту можуть бути переглянуті перед підтвердженням процедури імпорту. Цей параметр визначає, скільки рядків будуть показані у вікні попереднього перегляду.';
$string['savechanges'] = 'Зберегти зміни';
$string['savepreferences'] = 'Зберегти налаштування';
$string['scaleconfirmdelete'] = 'Ви впевнені, що хочете вилучити шкалу "{$a}"?';
$string['scaledpct'] = 'Шкала %';
$string['searchcollapsedcolumns'] = 'Пошук у згорнутих стовпцях';
$string['seeallcoursegrades'] = 'Переглянути всі оцінки курсу';
$string['select'] = 'Виберіть  {$a}';
$string['selectalloroneuser'] = 'Вибрати всіх або одного користувача';
$string['selectauser'] = 'Виберіть користувача';
$string['selectdestination'] = 'Виберіть місце призначення для {$a}';
$string['selectgrouplink'] = 'Виберіть групу';
$string['selectuserlink'] = 'Виберіть користувача';
$string['separator'] = 'Розділювач';
$string['separator_help'] = 'Вкажіть розділювач, який повинен бути використаний у CSV файлі (зазвичай це кома).';
$string['sepcolon'] = 'Двокрапка';
$string['sepcomma'] = 'Кома';
$string['sepsemicolon'] = 'Крапка з комою';
$string['septab'] = 'Табуляція';
$string['setcategories'] = 'Задати категорії';
$string['setcategorieserror'] = 'Перед заданням значимості необхідно задати категорію вашого курсу.';
$string['setgradeletters'] = 'Задати буквені оцінки';
$string['setpreferences'] = 'Налаштування';
$string['setting'] = 'Установка';
$string['settings'] = 'Налаштування';
$string['setup'] = 'Налаштування';
$string['setweights'] = 'Задати значимість';
$string['showactivityicons'] = 'Показати значки';
$string['showactivityicons_help'] = 'Якщо дозволено, то значки діяльностей будуть показані біля назв діяльностей.';
$string['showallgrades'] = 'Показати всі оцінки';
$string['showallhidden'] = 'Показати приховане';
$string['showallstudents'] = 'Показати всіх студентів';
$string['showanalysisicon'] = 'Показувати значок аналізу балів';
$string['showanalysisicon_desc'] = 'Визначає типовий показ значка аналізу балів. Якщо модуль діяльності це підтримує, значок з посиланням на аналіз балів переведе до сторінки з детальнішим описом оцінки.';
$string['showanalysisicon_help'] = 'Якщо модуль діяльності це підтримує, значок з посиланням на аналіз балів переведе до сторінки з детальнішим описом оцінки.';
$string['showaverage'] = 'Показати середні бали';
$string['showaverage_help'] = 'Чи показувати середній стовпець. Зауважте, що учасники можуть оцінити оцінки інших, якщо середнє значення розраховується з невеликої кількості оцінок. З міркувань продуктивності середнє значення є приблизним, якщо воно залежить від будь-яких прихованих елементів.';
$string['showaverages'] = 'Показати середні по колонках';
$string['showaverages_help'] = 'Якщо включено, то журнал оцінок буде містити додатковий рядок, в якому показуватиметься середнє значення по всіх учасниках для кожної категорії та діяльності.';
$string['showcalculations'] = 'Показати розраховані';
$string['showcalculations_help'] = 'Якщо ввімкнено, під час редагування для кожного елемента оцінки та категорії відображається значок калькулятора з візуальним індикатором того, що елемент оцінки обчислено.';
$string['showcontributiontocoursetotal'] = 'Показати вклад в результат курсу';
$string['showcontributiontocoursetotal_help'] = 'Показати додаткову колонку із значенням у відсотках, яка вказує, скільки кожен елемент оцінювання вносить в загальний результат користувача по курсу (після врахування значимості).';
$string['showeyecons'] = 'Показати значки видимості';
$string['showeyecons_help'] = 'Якщо дозволено, то в режимі редагування показує значок показу/укриття біля кожної оцінки для контролю його видимості для студента.';
$string['showfeedback'] = 'Показати відгук';
$string['showfeedback_help'] = 'Чи показувати стовпець для відгуків.';
$string['showgrade'] = 'Показати оцінки';
$string['showgrade_help'] = 'Чи показувати стовпець для оцінок.';
$string['showgroups'] = 'Показати групи';
$string['showhiddenitems'] = 'Показати приховані елементи';
$string['showhiddenitems_help'] = 'Визначає тип приховування елементів оцінювання - чи сховані повністю, чи назви елементів доступні студентам.

* Показувати приховані - З прихованих елементів оцінювання показуються тільки назви, але оцінки студенти не бачать
* Прихований тільки до - елементи оцінювання приховані до певної дати, після якої будуть показуватися
* Не показувати - Приховані оцінки приховуються повністю';
$string['showhiddenuntilonly'] = 'Прихований тільки до';
$string['showingaggregatesonly'] = 'Показано лише підсумки';
$string['showingfullmode'] = 'Показ оцінок і підсумків';
$string['showinggradesonly'] = 'Показано лише оцінки елементів';
$string['showlettergrade'] = 'Показати буквені оцінки';
$string['showlettergrade_help'] = 'Чи показувати стовпець для літерних оцінок.';
$string['showlocks'] = 'Показати блокування';
$string['showlocks_help'] = 'Якщо дозволено, то в режимі редагування показує значок блокування біля кожного елементу оцінювання, що дозволяє контролювати можливість автоматичної зміни оцінки при зміні балів у діяльності.';
$string['shownohidden'] = 'Не показувати';
$string['shownooutcomes'] = 'Приховати результати';
$string['shownumberofgrades'] = 'Показати кількість оцінок в середній';
$string['shownumberofgrades_help'] = 'Якщо дозволено, то в дужках біля кожного середнього балу показує кількість оцінок, з яких вони були розраховані. Наприклад: 45(34)';
$string['showonlyactiveenrol'] = 'Показати тільки активних студентів';
$string['showonlyactiveenrol_help'] = 'Це налаштування визначає, що тільки активні студенти будуть показуватися у журналі оцінок. Якщо включено, то заблоковані користувачі не будуть показуватися у журналі оцінок.';
$string['showpercentage'] = 'Показувати відсотки';
$string['showpercentage_help'] = 'Чи показувати відсоткове значення кожного елемента оцінки.';
$string['showquickfeedback'] = 'Показати швидкі коментарі';
$string['showquickfeedback_help'] = 'Якщо дозволено, то при включеному редагуванні, біля кожного елементу оцінювання з’явиться текстовий блок, який дозволить додавати коментарі до оцінок всім студентам одразу. Всі зміни будуть збережені при натисканні кнопки збереження.

Зверніть увагу, якщо ви коментуєте оцінки таким чином, то вони не можуть бути змінені через коментування в діяльності.';
$string['showrange'] = 'Показати інтервали';
$string['showrange_help'] = 'Чи показувати стовпець для діапазону.';
$string['showranges'] = 'Показати інтервали';
$string['showranges_help'] = 'Якщо дозволено, то в журналі оцінок відображається рядок, який показує діапазон можливої кількості балів для кожного елементу атестації.';
$string['showrank'] = 'Показати ранг';
$string['showrank_help'] = 'Чи показувати позицію учня по відношенню до решти класу для кожного пункту оцінки.';
$string['showuserimage'] = 'Показати зображення користувача';
$string['showuserimage_help'] = 'Визначає можливість показу зображення користувача поряд з його прізвищем у журналі оцінок.';
$string['showverbose'] = 'Показати {$a->category} {$a->itemmodule} {$a->itemname}';
$string['showweight'] = 'Показати значимість оцінки';
$string['showweight_help'] = 'Чи показувати стовпець для ваги класу.';
$string['simpleview'] = 'Простий вид';
$string['sitewide'] = 'По усьому сайту';
$string['sort'] = 'сортування';
$string['sortasc'] = 'Сортувати за зростанням';
$string['sortbyfirstname'] = 'Сортувати за ім`ям';
$string['sortbylastname'] = 'Сортувати за прізвищем';
$string['sortdesc'] = 'Сортувати за спаданням';
$string['standarddeviation'] = 'Станд. відхилення';
$string['stats'] = 'Статистика';
$string['statslink'] = 'Стат.';
$string['student'] = 'Студент';
$string['studentsperpage'] = 'Студентів на сторінку';
$string['studentsperpage_help'] = 'Ця установка визначає кількість студентів, які будуть виводитися на сторінку в журналі оцінок.';
$string['studentsperpagereduced'] = 'Зменшено максимум студентів на сторінку з {$a->originalstudentsperpage} до {$a->studentsperpage}. Для можливості збільшення змініть налаштування РНР setting max_input_vars з {$a->maxinputvars}.';
$string['subcategory'] = 'Стандартна категорія';
$string['submissions'] = 'від кількості';
$string['submittedon'] = 'Здано: {$a}';
$string['sumofgradesupgradedgrades'] = 'Примітка: метод об’єднання "Сума балів" було змінено в процесі оновлення сайту. Оскільки "Сума балів" раніше використовувалося на цьому курсі, рекомендуємо переглянути правильність роботи вашого журналу оцінок.';
$string['switchtofullview'] = 'Перемкнути на повний вигляд';
$string['switchtosimpleview'] = 'Перемкнути на простий вигляд';
$string['tabs'] = 'Вкладки';
$string['topcategory'] = 'Загальна категорія';
$string['total'] = 'Всього';
$string['totalweight100'] = 'Загальна сума дорівнює 100';
$string['totalweightnot100'] = 'Загальна сума відмінна від 100';
$string['turnfeedbackoff'] = 'Відключити відгуки';
$string['turnfeedbackon'] = 'Включити відгуки';
$string['typenone'] = 'Відсутнє';
$string['typescale'] = 'Шкала';
$string['typescale_help'] = 'Установка визначає, яку шкалу використовувати в елементах, де визначено відповідний тип оцінювання. Шкала для оцінок діяльностей вибирається на сторінці налаштування діяльності.';
$string['typetext'] = 'Текст';
$string['typevalue'] = 'Значення';
$string['uncategorised'] = 'Без категорії';
$string['unchangedgrade'] = 'Незмінювана оцінка';
$string['unenrolledusersinimport'] = 'Даний імпорт включає наступні оцінки для користувачів, які на даний момент не зараховані на курс: {$a}';
$string['unlimitedgrades'] = 'Необмежені оцінки';
$string['unlimitedgrades_help'] = 'Типово оцінки обмежуються мінімальними та максимальними значеннями. Включення цієї установки відміняє ці обмеження, та дозволяє оцінки понад 100%, шляхом введення їх відразу в журнал оцінок. Рекомендується не включати цю установку в перевантаженому сервері, оскільки всі оцінки будуть перераховані, що додатково вплине на завантаженість сервера.';
$string['unlock'] = 'Відкрити';
$string['unlockverbose'] = 'Відкрити {$a->category} {$a->itemmodule} {$a->itemname}';
$string['unused'] = 'Не використовується';
$string['updatedgradesonly'] = 'Експортувати тільки нові або оновлені оцінки';
$string['upgradedgradeshidemessage'] = 'Відключити повідомлення';
$string['upgradedminmaxrevertmessage'] = 'Скасувати зміни';
$string['uploadgrades'] = 'Завантажити оцінки';
$string['useadvanced'] = 'Додаткові налаштування';
$string['usedcourses'] = 'Використовується курсами';
$string['usedgradeitem'] = 'Використовується елементами оцінювання';
$string['usenooutcome'] = 'Не використовувати результатів';
$string['usenoscale'] = 'Не використовувати шкал';
$string['usepercent'] = 'Використовувати відсотки';
$string['user'] = 'Користувач';
$string['userenrolmentsuspended'] = 'Реєстрацію користувача заблоковано';
$string['userfields_show'] = 'Показати поля користувача';
$string['userfields_show_help'] = 'Показати додаткові поля користувача (наприклад, адресу ел.пошти) у звіті оцінювача. Які власне поля будуть показуватися визначається параметром сайту "showuseridentity"';
$string['usergrade'] = 'Користувач {$a->fullname} ({$a->useridnumber}) в елементі {$a->gradeidnumber}';
$string['userid'] = 'Код користувача';
$string['useridnumberwarning'] = 'Користувачі без ідентифікаційного номера, виключаються з XML експорту, оскільки вони не можуть бути імпортовані';
$string['usermappingerror'] = 'Помилка відповідності користувача: Не вдалося знайти користувача із значенням "{$a->value}" для поля {$a->field}.';
$string['usermappingerrorcurrentgroup'] = 'Користувач не є членом поточної групи.';
$string['usermappingerrormultipleusersfound'] = 'Помилка зіставлення користувачів: знайдено кілька користувачів із {$a->field} із "{$a->value}". Будь ласка, використовуйте більш унікальне поле відображення.';
$string['usermappingerrorusernotfound'] = 'Помилка відповідності користувача: Не вдалося знайти користувача';
$string['userpreferences'] = 'Уподобання користувача';
$string['useweighted'] = 'Використовувати значимість';
$string['verbosescales'] = 'Детальні шкали';
$string['verbosescales_help'] = 'Детальні шкали використовують символи а не цифри. Встановіть \'Так\', якщо і чисельні, і буквені значення  повинні бути імпортовані. Встановіть \'Ні\', якщо тільки чисельні значення повинні бути імпортовані.';
$string['viewas'] = 'Переглянути звіт як';
$string['viewbygroup'] = 'Група';
$string['viewfeedback'] = 'Переглянути відгук';
$string['viewgrades'] = 'Перегляд оцінок';
$string['weight'] = 'значимість';
$string['weight_help'] = 'Значення використовується для визначення відносного значення декількох елементів оцінювання в категорії або курсі.';
$string['weightcourse'] = 'Використовувати зважені оцінки для курсу';
$string['weightedascending'] = 'Сортувати за зростанням зваженої суми';
$string['weighteddescending'] = 'Сортувати за зниженням зваженої суми';
$string['weightedpct'] = 'зважений %';
$string['weightedpctcontribution'] = 'Зважений внесок';
$string['weightofa'] = 'Значимість {$a}';
$string['weightorextracredit'] = 'Значимість або додаткові бали';
$string['weightoverride'] = 'регулювання значимості';
$string['weightoverride_help'] = 'Зніміть це для скидання значимості елементу оцінювання до його автоматично вирахуваного значення. Перевірка цього буде перешкоджати автоматичному регулюванню значення.';
$string['weights'] = 'Значимість';
$string['weightsadjusted'] = 'Значимості були скореговані до загальних 100.';
$string['weightsedit'] = 'Редагувати значимість та додаткові бали';
$string['weightuc'] = 'Обрахована значимість';
$string['writinggradebookinfo'] = 'Запис налаштувань Журналу оцінок';
$string['xml'] = 'XML';
$string['yes'] = 'Так';
$string['yourgrade'] = 'Ваша оцінка';
