<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'cachestore_memcached', language 'sr_lt', version '4.3'.
 *
 * @package     cachestore_memcached
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['bufferwrites'] = 'Upisi bafera';
$string['bufferwrites_help'] = 'Ova opcija omogućava ili onemogućava baferovani I/O (U/I – ulaz/izlaz). Omogućavanje baferovanog U/I dovodi do skladištenja komandi u "bafer" (pomoćnu memoriju), umesto da one budu poslate udaljenoj konekciji. Bilo koja akcija koja preuzima podatke uslovljava da ovaj bafer bude poslat udaljenoj konekciji. Prekidanje konekcije ili njeno zatvaranje će, takođe, usloviti da baferovani podaci budu poslati udaljenoj konekciji.';
$string['clustered'] = 'Omogući klastere servera';
$string['clustered_help'] = 'Ova opcija se koristi za podešavanje funkcionalnosti koja dozvoljava jedno čitanje i više postavljanja.

Namera je da se takvo podešavanje koristi radi kreiranje naprednog skladišta za konfiguracije sa balansiranim učitavanjem. Skladište će preuzimati sadržaje sa jednog servera (obično lokalnog), ali će ih smeštati na više servera (sve koji su određeni kao raspoloživi za balansiranje učitavanja). Za keš sa veoma visokim odnosom čitanja i postavljanja ovo obezbeđuje značajno oblažavanje opterećenja mreže.

Kad je ovo podešavanje uključeno gore navedeni serveri se koriste za pribavljanje sadržaja.';
$string['clusteredheader'] = 'Deljeni serveri';
$string['hash'] = 'Heš metod';
$string['hash_crc'] = 'CRC';
$string['hash_default'] = 'Podrazumevani (jedan po jedan)';
$string['hash_fnv1_32'] = 'FNV1_32';
$string['hash_fnv1_64'] = 'FNV1_64';
$string['hash_fnv1a_32'] = 'FNV1A_32';
$string['hash_fnv1a_64'] = 'FNV1A_64';
$string['hash_help'] = 'Ova opcija definiše koji heš algoritam se koristi za stavke ključeva. Svaki heš algoritam ima svoje prednosti i svoje mane. Ako ne znate ili vam nije važno, počnite sa podrazumevanim metodom.';
$string['hash_hsieh'] = 'Hsieh';
$string['hash_md5'] = 'MD5';
$string['hash_murmur'] = 'Murmur';
$string['isshared'] = 'Deljeni keš';
$string['isshared_help'] = 'Da li vaš memcached server koriste i druge aplikacije?

Ako se keš deli sa drugim aplikacijama onda će svaki ključ biti obrisan pojedinačno kako bi se osiguralo da budu očišćeni samo podaci u vlasništvu ove aplikacije (ostavljajući, istovremeno, keš podatke drugih eksternih aplikacija neizmenjene). Ovo može dovesti do smanjene performanse prilikom čišćenja keša, zavisno od konfiguracije vašeg servera.

Ako koristite namenski keš za ovu aplikaciju onda celokupan keš može biti  uklonjen bez rizika da budu uništeni keš podaci drugih aplikacija. Ovo bi tebalo da rezultira poboljšanim performansama prilikom čišćenja keša.';
$string['pluginname'] = 'Memcached';
$string['prefix'] = 'Prefiks ključa';
$string['prefix_help'] = 'Ovo može da se koristi za kreiranje "domena" za stavke vaših ključeva, dajući vam mogućnost da kreirate više memcached skladišta na jednoj memcached instalaciji. Prefiks ključa ne može da bude duži od 16 znakova, kako bi se izbegli problemi sa dužinom ključa.';
$string['prefixinvalid'] = 'Prefiks nije validan. Možete da koristite samo a-z A-Z 0-9-_.';
$string['privacy:metadata:memcached'] = 'Dodatak za keširanje Memcached kratko čuva podatke, kao deo svoje funkcionalnosti. Ovi podaci se čuvaju na Memcache serveru odakle se redovno uklanjaju.';
$string['privacy:metadata:memcached:data'] = 'Različiti podaci koji se čuvaju u kešu';
$string['serialiser_igbinary'] = 'igbinary serijalizator';
$string['serialiser_json'] = 'JSON serijalizator';
$string['serialiser_php'] = 'Standardni PHP serijalizator';
$string['servers'] = 'Serveri';
$string['servers_help'] = 'Ova opcija podešava servere koje treba da koristi ovaj memcache adapter.
Serveri treba da budu definisani po jedan u svakom redu, a definicija se sastoji od adrese servera, i opciono od porta i težine.
Ako port nije definisan koristi se podrazumevani port (11211).

Na primer:
<pre>
server.url.com
ipaddress:port
servername:port:weight
</pre>

Ako je opcija "Omogući grupisane servere" uključena ispod, onda ovde mora da bude samo jedan server. To je obično ime koje se odnosi na lokalni server, nešto poput 127.0.0.1 ili localhost.';
$string['serversclusterinvalid'] = 'Potreban je tačno jedan server kad je omogućeno klasterovanje.';
$string['sessionhandlerconflict'] = 'Upozorenje: memcache instanca ({$a}) je podešena tako da koristi isti memcache server kao sesije. Čišćenje keša će sa sobom povući i čišćenje sesija.';
$string['setservers'] = 'Podesi servere';
$string['setservers_help'] = 'Ovo je spisak servera koji će biti ažurirani kada se izmene podaci u kešu. Obično, pun naziv svakog servera u grupi raspoloživih. Spisak **mora** da sadrži server naveden gore pod opcijom *Serveri*, čak i ako je dat pod drugim nazivom.
Serveri treba da budu definisani po jedan u svakom redu, a definicija se sastoji od adrese servera, i opciono od porta.
Ako port nije definisan koristi se podrazumevani port (11211).

Na primer:
<pre>
server.url.com
ipaddress:port
</pre>';
$string['testservers'] = 'Test serveri';
$string['testservers_desc'] = 'Jedan ili više stringova za konekciju spram kojih će se testirati memcached serveri. Ako je specificiran testni server memcached performanse se mogu testirati korišćenjem stranice za keš performanse u bloku za administraciju.
Na primer: 127.0.0.1:11211';
$string['upgrade200recommended'] = 'Preporučujemo vam da nadogradite Memcached PHP ekstenziju na verziju 2.0.0 ili noviju.
Verzija Memcached PHP ekstenzije koju trenutno koristite ne obezbeđuje funkcionalnost koju Moodle koristi kako bi obezbedio keš u zaštićenom okruženju. Dok ne uradite nadogradnju preporučujemo vam da ne konfigurišete nijednu drugu aplikaciju koja bi koristila isti Memcached server, pošto je Moodle podešen da ga koristi.';
$string['usecompression'] = 'Koristi kompresiju';
$string['usecompression_help'] = 'Ova opcija omogućava ili onemogućava korišćenje protokola za kompresiju. Kada je omogućena kompresija, stavke čija je vrednost duža od određenog praga (trenutno 100 bajta) biće komprimovane u toku skladištenja i dekomprimovane u toku preuzimanja.';
$string['useserialiser'] = 'Koristi serijalizator';
$string['useserialiser_help'] = 'Ova opcija definiše serijalizator koji se koristi za serijalizaciju (serijski prenos) neskalarnih vrednosti. Važeći serijalizatori su Memcached::SERIALIZER_PHP ili Memcached::SERIALIZER_IGBINARY. Ovaj drugi je je podržan samo kada je memcached konfigurisan sa opcijom --enable-memcached-igbinary i kada je igbinary ekstenzija učitana.';
