<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'workshop', language 'id', version '4.2'.
 *
 * @package     workshop
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activitydate:assessmentsclose'] = 'Penilaian tutup:';
$string['activitydate:assessmentsclosed'] = 'Penilaian ditutup:';
$string['activitydate:assessmentsopen'] = 'Penilaian buka:';
$string['activitydate:assessmentsopened'] = 'Penilaian dibuka:';
$string['activitydate:submissionsclose'] = 'Pengajuan tutup:';
$string['activitydate:submissionsclosed'] = 'Pengajuan ditutup:';
$string['activitydate:submissionsopen'] = 'Pengajuan buka:';
$string['activitydate:submissionsopened'] = 'Pengajuan dibuka:';
$string['aggregategrades'] = 'Hitung ulang nilai';
$string['aggregation'] = 'Agregasi nilai';
$string['allocate'] = 'Alokasi pengajuan';
$string['allocatedetails'] = 'Diharapkan: {$a->expected}<br />diajukan: {$a->submitted}<br />untuk mengalokasikan: {$a->allocate}';
$string['allocation'] = 'Alokasi pengajuan';
$string['allocationconfigured'] = 'Alokasi dikonfigurasi';
$string['allocationdone'] = 'Alokasi selesai';
$string['allocationerror'] = 'Galat alokasi';
$string['allowedfiletypesforoverallfeedback'] = 'jenis berkas yang diizinkan untuk umpan balik';
$string['allowedfiletypesforoverallfeedback_help'] = 'Jenis berkas lampiran umpan balik dapat dibatasi dengan memberikan daftar jenis berkas yang diizinkan. Jika ruas dibiarkan kosong, maka semua jenis berkas diperbolehkan.';
$string['allowedfiletypesforoverallfeedback_link'] = 'admin/tool/filetypes/index';
$string['allowedfiletypesforsubmission'] = 'jenis berkas yang diizinkan untuk diajukan';
$string['allowedfiletypesforsubmission_help'] = 'Jenis berkas lampiran ajuan dapat dibatasi dengan memberikan daftar jenis berkas yang diizinkan. Jika ruas dibiarkan kosong, maka semua jenis berkas diperbolehkan.';
$string['allowedfiletypesforsubmission_link'] = 'admin/tool/filetypes/index';
$string['allsubmissions'] = 'Semua ajuan ({$a})';
$string['alreadygraded'] = 'Telah dinilai';
$string['areaconclusion'] = 'Teks kesimpulan';
$string['areainstructauthors'] = 'Instruksi pengajuan';
$string['areainstructreviewers'] = 'Intruksi penilaian';
$string['areaoverallfeedbackattachment'] = 'Lampiran umpan balik umum';
$string['areaoverallfeedbackcontent'] = 'Teks umpan balik umum';
$string['areasubmissionattachment'] = 'Lampiran ajuan';
$string['areasubmissioncontent'] = 'Teks ajuan';
$string['assess'] = 'Menilai';
$string['assessedexample'] = 'Contoh ajuan yang dinilai';
$string['assessedsubmission'] = 'Ajuan yang dinilai';
$string['assessingexample'] = 'Menilai contoh ajuan';
$string['assessingsubmission'] = 'Menilai ajuan';
$string['assessment'] = 'Penilaian';
$string['assessmentby'] = 'oleh <a href="{$a->url}">{$a->name}</a>';
$string['assessmentbyfullname'] = 'Dinilai oleh {$a}';
$string['assessmentbyyourself'] = 'Penilaian Anda';
$string['assessmentdeleted'] = 'Penilaian tidak dialokasikan';
$string['assessmentend'] = 'Batas waktu penilaian';
$string['assessmentendbeforestart'] = 'Batas waktu penilaian tidak dapat ditentukan sebelum tanggal penilaian terbuka';
$string['assessmentenddatetime'] = 'Batas waktu penilaian: {$a->daydatetime} ({$a->distanceday})';
$string['assessmentendevent'] = '{$a} batas waktu penilaian';
$string['assessmentform'] = 'Fomulir penilaian';
$string['assessmentofsubmission'] = '<a href="{$a->assessmenturl}">Penilaian</a> of <a href="{$a->submissionurl}">{$a->submissiontitle}</a>';
$string['assessmentreference'] = 'Referensi penilaian';
$string['assessmentreferenceconflict'] = 'Tidak mungkin untuk menilai contoh ajuan yang Anda berikan penilaian referensi.';
$string['assessmentreferenceneeded'] = 'Anda harus menilai contoh ajuan ini untuk memberikan penilaian referensi. Klik tombol \'Lanjutkan\' untuk menilai pengiriman.';
$string['assessments'] = 'Penilaian';
$string['assessmentsettings'] = 'Setelan Penilaian';
$string['assessmentstart'] = 'Penilaian dibuka dari';
$string['assessmentstartdatetime'] = 'Penilaian dibuka dari {$a->daydatetime} ({$a->distanceday})';
$string['assessmentstartevent'] = '{$a} terbuka untuk penilaian';
$string['assessmentweight'] = 'Bobot penilaian';
$string['assignedassessments'] = 'Ajuan yang ditugaskan untuk dinilai';
$string['assignedassessmentsnone'] = 'Anda tidak memiliki ajuan tugas untuk dinilai';
$string['backtoeditform'] = 'Kembali ke editor formulir';
$string['byfullname'] = 'oleh <a href="{$a->url}">{$a->name}</a>';
$string['byfullnamewithoutlink'] = 'oleh {$a}';
$string['calculategradinggrades'] = 'Hitung penilaian';
$string['calculategradinggradesdetails'] = 'diharapkan: {$a->expected}<br />dihitung: {$a->calculated}';
$string['calculatesubmissiongrades'] = 'Hitung nilai pengajuan';
$string['calculatesubmissiongradesdetails'] = 'diharapkan: {$a->expected}<br />dihitung: {$a->calculated}';
$string['chooseuser'] = 'Pilih pengguna...';
$string['clearaggregatedgrades'] = 'Hapus semua nilai agregat';
$string['clearaggregatedgrades_help'] = 'Nilai agregat ajuan dan nilai untuk penilaian akan diatur ulang. Anda dapat menghitung ulang nilai ini dari awal dalam tahap Evaluasi Penilaian lagi.';
$string['clearaggregatedgradesconfirm'] = 'Nilai agregat untuk pengajuan dan nilai untuk penilaian akan diatur ulang. Anda dapat menghitung ulang nilai ini dari awal dalam tahap evaluasi Penilaian lagi.';
$string['clearassessments'] = 'Bersihkan penilaian';
$string['clearassessments_help'] = 'Nilai yang dihitung untuk pengajuan dan nilai untuk penilaian akan diatur ulang. Informasi cara pengisian formulir penilaian masih disimpan, tetapi semua pengulas harus membuka kembali formulir penilaian dan menyimpannya kembali untuk mendapatkan nilai yang diberikan dihitung kembali.';
$string['clearassessmentsconfirm'] = 'Apakah Anda yakin ingin menghapus semua nilai penilaian? Anda tidak akan bisa mendapatkan informasi kembali sendiri, peninjau harus menilai kembali ajuan yang dialokasikan.';
$string['conclusion'] = 'Kesimpulan';
$string['conclusion_help'] = 'Teks kesimpulan ditampilkan kepada peserta di akhir aktivitas.';
$string['configexamplesmode'] = 'Mode bawaan penilaian contoh dalam lokakarya';
$string['configgrade'] = 'Nilai maksimum bawaan untuk pengajuan dalam lokakarya';
$string['configgradedecimals'] = 'Jumlah digit bawaan yang harus ditampilkan setelah titik desimal saat menampilkan nilai.';
$string['configgradinggrade'] = 'Nilai maksimum bawaan untuk penilaian dalam lokakarya';
$string['configmaxbytes'] = 'Ukuran berkas ajuan maksimum bawaan untuk semua lokakarya di situs (tergantung pada batas kursus dan setelan lokal lainnya)';
$string['configstrategy'] = 'Strategi penilaian bawaan untuk lokakarya';
$string['createsubmission'] = 'Tambahkan ajuan';
$string['crontask'] = 'Pemrosesan latar belakang untuk modul lokakarya';
$string['daysago'] = '{$a} hari yang lalu';
$string['daysleft'] = '{$a} hari lagi';
$string['daystoday'] = 'hari ini';
$string['daystomorrow'] = 'besok';
$string['daysyesterday'] = 'kemarin';
$string['deadlinesignored'] = 'Batasan waktu tidak berlaku untuk Anda';
$string['deletesubmission'] = 'Hapus ajuan';
$string['editassessmentform'] = 'Edit formulir penilaian';
$string['editassessmentformstrategy'] = 'Edit formulir penilaian ({$a})';
$string['editingassessmentform'] = 'Mengedit formulir penilaian';
$string['editingsubmission'] = 'Mengedit ajuan';
$string['editsubmission'] = 'Edit ajuan';
$string['err_multiplesubmissions'] = 'Saat mengedit formulir ini, versi lain dari pengajuan telah disimpan. Mengirim banyak ajuan per pengguna tidak diperbolehkan.';
$string['err_removegrademappings'] = 'Tidak dapat menghapus pemetaan nilai yang tidak digunakan';
$string['evaluategradeswait'] = 'Harap tunggu sampai penilaian dievaluasi dan nilainya dihitung';
$string['evaluation'] = 'Evaluasi penilaian';
$string['evaluationmethod'] = 'Metode evaluasi penilaian';
$string['evaluationmethod_help'] = 'Metode penilaian penilaian menentukan bagaimana nilai untuk penilaian dihitung. Anda dapat membiarkannya menghitung ulang nilai berulang kali dengan setelan yang berbeda kecuali Anda puas dengan hasilnya.';
$string['evaluationsettings'] = 'Setelan evaluasi penilaian';
$string['eventassessableuploaded'] = 'Ajuan telah diunggah.';
$string['eventassessmentevaluated'] = 'Penilaian dievaluasi';
$string['eventassessmentevaluationsreset'] = 'Evaluasi penilaian diatur ulang';
$string['eventassessmentreevaluated'] = 'Penilaian dievaluasi kembali';
$string['eventphaseautomaticallyswitched'] = 'Fase secara otomatis beralih';
$string['eventphaseswitched'] = 'Beralih fase';
$string['eventsubmissionassessed'] = 'Menilai ajuan';
$string['eventsubmissionassessmentsreset'] = 'Membersihan penilaian ajuan';
$string['eventsubmissioncreated'] = 'Membuat pengajuan';
$string['eventsubmissiondeleted'] = 'Pengajuan dihapus';
$string['eventsubmissionreassessed'] = 'Pengajuan dinilai kembali';
$string['eventsubmissionupdated'] = 'Pengajuan diperbarui';
$string['eventsubmissionviewed'] = 'Melihat ajuan';
$string['example'] = 'Contoh ajuan';
$string['exampleadd'] = 'Tambahkan contoh ajuan';
$string['exampleassess'] = 'Menilai contoh ajuan';
$string['exampleassessments'] = 'Contoh ajuan yang dinilai';
$string['exampleassesstask'] = 'Menilai contoh';
$string['exampleassesstaskdetails'] = 'diharapkan: {$a->expected}<br />dinilai: {$a->assessed}';
$string['examplecomparing'] = 'Membandingkan penilaian contoh ajuan.';
$string['exampledelete'] = 'Hapus contoh';
$string['exampledeleteconfirm'] = 'Apakah Anda yakin ingin menghapus ajuan contoh berikut? Klik tombol \'Lanjutkan\' untuk menghapus ajuan.';
$string['exampleedit'] = 'Edit contoh';
$string['exampleediting'] = 'Mengedit contoh';
$string['exampleneedassessed'] = 'Anda harus menilai semua contoh ajuan terlebih dahulu';
$string['exampleneedsubmission'] = 'Anda harus mengajuakan karya Anda dan menilai semua contoh ajuan terlebih dahulu';
$string['examplesbeforeassessment'] = 'Contoh tersedia setelah pengajuan sendiri dan harus dinilai sebelum penilaian sejawat';
$string['examplesbeforesubmission'] = 'Contoh harus dinilai sebelum pengajuan sendiri';
$string['examplesmode'] = 'Mode penilaian contoh';
$string['examplesubmissions'] = 'Contoh ajuan';
$string['examplesvoluntary'] = 'Penilaian contoh ajuan bersifat sukarela';
$string['exportsubmission'] = 'Ekspor halaman ini';
$string['feedbackauthor'] = 'Umpan balik untuk penulis';
$string['feedbackauthorattachment'] = 'Lampiran';
$string['feedbackby'] = 'Umpan balik oleh {$a}';
$string['feedbackreviewer'] = 'Umpan balik untuk pengulas';
$string['feedbacksettings'] = 'Umpan balik';
$string['formataggregatedgrade'] = '{$a->grade}';
$string['formataggregatedgradeover'] = '<del>{$a->grade}</del><br /><ins>{$a->over}</ins>';
$string['formatpeergrade'] = '<span class="grade">{$a->grade}</span> <span class="gradinggrade">({$a->gradinggrade})</span>';
$string['formatpeergradeover'] = '<span class="grade">{$a->grade}</span> <span class="gradinggrade">(<del>{$a->gradinggrade}</del> / <ins>{$a->gradinggradeover}</ins>)</span>';
$string['formatpeergradeoverweighted'] = '<span class="grade">{$a->grade}</span> <span class="gradinggrade">(<del>{$a->gradinggrade}</del> / <ins>{$a->gradinggradeover}</ins>)</span> @ <span class="weight">{$a->weight}</span>';
$string['formatpeergradeweighted'] = '<span class="grade">{$a->grade}</span> <span class="gradinggrade">({$a->gradinggrade})</span> @ <span class="weight">{$a->weight}</span>';
$string['givengrades'] = 'Nilai yang diberikan';
$string['grade_grading_name'] = 'Penilaian';
$string['grade_submission_name'] = 'Pengajuan';
$string['gradecalculated'] = 'Nilai yang dihitung untuk pengajuan.';
$string['gradedecimals'] = 'Digit desimal pada nilai';
$string['gradegivento'] = '&gt;';
$string['gradeinfo'] = 'Nilai: {$a->received} dari {$a->max}';
$string['gradeitemassessment'] = '(penilaian) {$a->workshopname}';
$string['gradeitemsubmission'] = '(pengajuan) {$a->workshopname}';
$string['gradeover'] = 'Penyampingan nilai untuk ajuan';
$string['gradereceivedfrom'] = '&lt;';
$string['gradesreport'] = 'Laporan penilaian lokakarya';
$string['gradetopassgrading'] = 'Nilai penilaian untuk lulus';
$string['gradetopasssubmission'] = 'Nilai pengajuan untuk lulus';
$string['gradinggrade'] = 'Nilai untuk penilaian';
$string['gradinggrade_help'] = 'Setelan ini menentukan nilai maksimum yang dapat diperoleh untuk penilaian ajuan.';
$string['gradinggradecalculated'] = 'Nilai yang dihitung untuk penilaian';
$string['gradinggradeof'] = 'Nilai untuk penilaian (dari {$a})';
$string['gradinggradeover'] = 'Batalkan nilai untuk penilaian';
$string['gradingsettings'] = 'Setelan penilaian';
$string['groupnoallowed'] = 'Anda tidak diperbolehkan mengakses grup mana pun dalam lokakarya ini';
$string['iamsure'] = 'Ya, saya yakin';
$string['indicator:cognitivedepth'] = 'Lokakarya kognitif';
$string['indicator:cognitivedepth_help'] = 'Indikator ini didasarkan pada kedalaman kognitif yang dicapai siswa dalam kegiatan lokakarya.';
$string['indicator:cognitivedepthdef'] = 'Lokakarya kognitif';
$string['indicator:cognitivedepthdef_help'] = 'Peserta telah mencapai persentase keterlibatan kognitif yang ditawarkan oleh aktivitas Lokakarya selama interval analisis ini (Tingkat = Tidak ada tampilan, Lihat, Ajukan, Lihat umpan balik, komentari umpan balik, Ajukan ulang setelah melihat umpan balik)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Lokakarya sosial';
$string['indicator:socialbreadth_help'] = 'Indikator ini didasarkan pada keluasan sosial yang dicapai siswa dalam suatu aktivitas lokakarya.';
$string['indicator:socialbreadthdef'] = 'Lokakarya sosial';
$string['indicator:socialbreadthdef_help'] = 'Peserta telah mencapai persentase keterlibatan sosial yang ditawarkan oleh aktivitas Lokakarya selama interval analisis ini (Tingkat = Tidak ada partisipasi, Peserta sendiri, Peserta dengan orang lain)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['info'] = 'Info';
$string['instructauthors'] = 'Petunjuk untuk pengajuan';
$string['instructreviewers'] = 'Petunjuk untuk penilaian';
$string['introduction'] = 'Deskripsi';
$string['latesubmissions'] = 'Ajuan terlambat';
$string['latesubmissions_desc'] = 'Izinkan pengajuan terlambat setelah batas waktu';
$string['latesubmissions_help'] = 'Jika diaktifkan, seorang penulis dapat mengirimkan karyanya setelah batas waktu pengiriman atau selama fase penilaian. Pengajuan yang terlambat tidak dapat diedit.';
$string['latesubmissionsallowed'] = 'Pengajuan terlambat diperbolehkan';
$string['legacyallocationplugincron'] = 'Cron lawas alokasi lokakarya';
$string['maxbytes'] = 'Ukuran maksimum lampiran';
$string['modulename'] = 'Lokakarya';
$string['modulename_help'] = 'Modul aktivitas lokakarya memungkinkan pengumpulan, ulasan dan penilaian sejawat siswa.

Siswa dapat mengirimkan konten digital (berkas), seperti dokumen atau spreadsheet yang diproses dengan kata dan juga dapat mengetik teks secara langsung ke dalam bidang menggunakan editor teks.

Kiriman dinilai menggunakan formulir penilaian multi-kriteria yang ditentukan oleh pengajar. Proses penilaian sejawat dan pemahaman formulir penilaian dapat dipraktikkan terlebih dahulu dengan contoh penyampaian yang diberikan oleh pengajar, disertai dengan penilaian acuan. Siswa diberi kesempatan untuk menilai satu atau lebih ajuan rekan-rekan mereka. Ajuan dan pengulas mungkin anonim jika diperlukan.

Siswa memperoleh dua nilai dalam kegiatan lokakarya - nilai untuk ajuan mereka dan nilai untuk penilaian mereka atas ajuan rekan-rekan mereka. Kedua nilai tersebut dicatat dalam buku nilai.';
$string['modulename_link'] = 'mod/workshop/view';
$string['modulenameplural'] = 'Lokakarya';
$string['myassessments'] = 'Penilaianku';
$string['mysubmission'] = 'Ajuanku';
$string['nattachments'] = 'Jumlah maksimum lampiran';
$string['noexamples'] = 'Belum ada contoh di lokakarya ini';
$string['noexamplesformready'] = 'Anda harus menentukan formulir penilaian sebelum memberikan contoh ajuan';
$string['nogradeyet'] = 'Belum dinilai';
$string['nosubmissionfound'] = 'Tidak ada kiriman yang ditemukan untuk pengguna ini';
$string['nosubmissions'] = 'Belum ada ajuan untuk lokakarya ini';
$string['nosubmissiontype'] = 'Setidaknya satu jenis ajuan harus tersedia';
$string['notassessed'] = 'Belum dinilai';
$string['nothingfound'] = 'Tak ada yang ditampilkan';
$string['nothingtoreview'] = 'Tidak ada yang diulas';
$string['notoverridden'] = 'Tidak dibatalkan';
$string['noworkshops'] = 'Tidak ada lokakarya dalam kursus ini';
$string['noyoursubmission'] = 'Anda belum mengajukan pekerjaan Anda';
$string['nullgrade'] = '-';
$string['overallfeedback'] = 'Umpan balik secara umum';
$string['overallfeedbackfiles'] = 'Jumlah maksimum lampiran umpan balik umum';
$string['overallfeedbackmaxbytes'] = 'Ukuran lampiran umpan balik umum maksimum';
$string['overallfeedbackmode'] = 'Mode umpan balik umum';
$string['overallfeedbackmode_0'] = 'Dinonaktifkan';
$string['overallfeedbackmode_1'] = 'Diaktifkan dan opsional';
$string['overallfeedbackmode_2'] = 'Diaktifkan dan wajib';
$string['overallfeedbackmode_help'] = 'Jika diaktifkan, ruas teks ditampilkan di bagian bawah formulir penilaian. Pengulas dapat menempatkan penilaian keseluruhan dari ajuan di sana, atau memberikan penjelasan tambahan tentang penilaian mereka.';
$string['page-mod-workshop-x'] = 'Setiap halaman modul lokakarya';
$string['participant'] = 'Peserta';
$string['participantrevierof'] = 'Peserta adalah pengulas dari';
$string['participantreviewedby'] = 'Peserta diulas oleh';
$string['phaseassessment'] = 'Fase Penilaian';
$string['phaseclosed'] = 'Ditutup';
$string['phaseevaluation'] = 'Fase Evaluasi Penilaian';
$string['phasesetup'] = 'Fase peyiapan';
$string['phasesoverlap'] = 'Fase pengajuan dan fase penilaian tidak bisa tumpang tindih';
$string['phasesubmission'] = 'Fase pengajuan';
$string['pluginadministration'] = 'Administrasi Lokakarya';
$string['pluginname'] = 'Lokakarya';
$string['prepareexamples'] = 'Siapkan contoh pengiriman';
$string['previewassessmentform'] = 'Pratinjau';
$string['privacy:metadata:aggregatedgradinggrade'] = 'Nilai gabungan untuk semua penilaian yang dibuat oleh pengguna dalam aktivitas lokakarya yang diberikan';
$string['privacy:metadata:assessmentgrade'] = 'Nilai gabungan untuk pengajuan yang disarankan oleh penilaian ini';
$string['privacy:metadata:assessmentgradinggrade'] = 'Nilai yang diberikan untuk penilaian ini';
$string['privacy:metadata:assessmentgradinggradeover'] = 'Nilai nilai yang dikesampingkan secara manual untuk memberikan penilaian ini';
$string['privacy:metadata:assessmentid'] = 'ID Penilaian';
$string['privacy:metadata:authorid'] = 'ID penulis ajuan';
$string['privacy:metadata:dimensiongrade'] = 'Nilai dalam dimensi penilaian yang diberikan';
$string['privacy:metadata:dimensionid'] = 'ID dimensi penilaian';
$string['privacy:metadata:example'] = 'Apakah rekaman ini mewakili contoh pengajuan';
$string['privacy:metadata:feedbackauthor'] = 'Umpan balik untuk penulis';
$string['privacy:metadata:feedbackauthorformat'] = 'Format teks dari umpan balik untuk penulis';
$string['privacy:metadata:feedbackreviewer'] = 'Umpan balik untuk pengguna yang memberikan penilaian';
$string['privacy:metadata:feedbackreviewerformat'] = 'Format teks umpan balik untuk pengguna yang memberikan penilaian';
$string['privacy:metadata:late'] = 'Apakah pengajuan diajukan setelah batas waktu';
$string['privacy:metadata:peercomment'] = 'Komentari nilai yang diberikan oleh pengguna yang memberikan penilaian';
$string['privacy:metadata:peercommentformat'] = 'Format teks komentar pada nilai yang diberikan';
$string['privacy:metadata:preference:perpage'] = 'Jumlah kiriman yang lebih disukai pengguna untuk dilihat dalam satu halaman';
$string['privacy:metadata:preference:viewlet-allexamples-collapsed'] = 'Status diciutkan/diperluas untuk tampilan \'Contoh pengajuan\'.';
$string['privacy:metadata:preference:viewlet-allsubmissions-collapsed'] = 'Status diciutkan/diperluas untuk tampilan \'Laporan ajuan lokakarya\'.';
$string['privacy:metadata:preference:viewlet-assessmentform-collapsed'] = 'Status diciutkan/diperluas untuk tampilan \'Formulir penilaian\'.';
$string['privacy:metadata:preference:viewlet-assignedassessments-collapsed'] = 'Status diciutkan/diperluas untuk tampilan \'Ajuan yang ditetapkan untuk dinilai\'.';
$string['privacy:metadata:preference:viewlet-cleargrades-collapsed'] = 'Status diciutkan/diperluas untuk tampilan \'Workshop toolbox\'.';
$string['privacy:metadata:preference:viewlet-conclusion-collapsed'] = 'Status diciutkan/diperluas untuk tampilan \'Kesimpulan\'.';
$string['privacy:metadata:preference:viewlet-examples-collapsed'] = 'Status diciutkan/diperluas untuk tampilan \'Contoh ajuan untuk dinilai\'.';
$string['privacy:metadata:preference:viewlet-examplesfail-collapsed'] = 'Status diciutkan/diperluas untuk tampilan \'Contoh ajuan untuk dinilai\'.';
$string['privacy:metadata:preference:viewlet-gradereport-collapsed'] = 'Status diciutkan/diluaskan untuk tampilan \'Laporan nilai lokakarya\'.';
$string['privacy:metadata:preference:viewlet-instructauthors-collapsed'] = 'Status diciutkan/diperluas untuk tampilan \'Petunjuk pengajuan\'.';
$string['privacy:metadata:preference:viewlet-instructreviewers-collapsed'] = 'Status diciutkan/diperluas untuk tampilan \'Petunjuk penilaian\'.';
$string['privacy:metadata:preference:viewlet-intro-collapsed'] = 'Status diciutkan/diperluas untuk tampilan \'Intro\'.';
$string['privacy:metadata:preference:viewlet-overallfeedback-collapsed'] = 'Status diciutkan/diperluas untuk tampilan \'Umpan balik umum\'.';
$string['privacy:metadata:preference:viewlet-ownsubmission-collapsed'] = 'Status diciutkan/diperluas untuk tampilan \'Ajuan Anda\'.';
$string['privacy:metadata:preference:viewlet-publicsubmissions-collapsed'] = 'Status diciutkan/diperluas untuk tampilan \'Ajuan yang dipublikasikan\'.';
$string['privacy:metadata:preference:viewlet-yourgrades-collapsed'] = 'Status diciutkan/diperluas untuk tampilan \'Nilai Anda\'.';
$string['privacy:metadata:published'] = 'Apakah ajuan harus dipublikasikan ke semua peserta setelah lokakarya ditutup';
$string['privacy:metadata:reviewerid'] = 'ID pengguna yang memberikan penilaian';
$string['privacy:metadata:strategy'] = 'Nama pengaya strategi penilaian yang menafsirkan nilai rekaman';
$string['privacy:metadata:submissioncontent'] = 'Konten ajuan';
$string['privacy:metadata:submissioncontentformat'] = 'Format teks dari konten ajuan';
$string['privacy:metadata:submissiongrade'] = 'Nilai gabungan untuk pengajuan yang ditulis sebagai angka desimal dari interval 0,.100';
$string['privacy:metadata:submissiongradeover'] = 'Nilai yang dikesampingkan secara manual dari nilai agregat';
$string['privacy:metadata:submissionid'] = 'ID pengajuan';
$string['privacy:metadata:submissiontitle'] = 'Judul pengajuan';
$string['privacy:metadata:subsystem:corefiles'] = 'Modul lokakarya menyimpan berkas yang disematkan / dilampirkan ke teks pengajuan';
$string['privacy:metadata:subsystem:coreplagiarism'] = 'Modul lokakarya memiliki dukungan bawaan untuk sistem pencegahan plagiarisme';
$string['privacy:metadata:timeaggregated'] = 'Ketika nilai agregat terakhir dihitung';
$string['privacy:metadata:timecreated'] = 'Ketika rekaman ini dibuat di basis data';
$string['privacy:metadata:timemodified'] = 'Kapan rekaman ini terakhir diubah dalam basis data';
$string['privacy:metadata:userid'] = 'ID pengguna yang nilai agregatnya dihitung';
$string['privacy:metadata:weight'] = 'Bobot penilaian';
$string['privacy:metadata:workshopaggregations'] = 'Menyimpan nilai agregat untuk penilaian';
$string['privacy:metadata:workshopassessments'] = 'Menyimpan informasi penilaian yang dialokasikan dari ajuan modul lokakarya';
$string['privacy:metadata:workshopgrades'] = 'Menyimpan informasi  bagaimana formulir penilaian diisi dengan nilai dan komentar';
$string['privacy:metadata:workshopid'] = 'ID aktivitas lokakarya';
$string['privacy:metadata:workshopsubmissions'] = 'Menyimpan informasi  ajuan modul lokakarya workshop';
$string['privacy:request:delete:content'] = 'Konten telah dihapus (diminta oleh pengguna atau kedaluwarsa)';
$string['privacy:request:delete:title'] = '[Dihapus]';
$string['publishedsubmissions'] = 'Ajuan yang dipublikasikan';
$string['publishsubmission'] = 'Publikasikan ajuan';
$string['publishsubmission_help'] = 'Ajuan yang dipublikasikan tersedia untuk yang lain saat lokakarya ditutup.';
$string['reassess'] = 'Menilai kembali';
$string['receivedgrades'] = 'Nilai diterima';
$string['recentassessments'] = 'Penilaian lokakarya:';
$string['recentsubmissions'] = 'Ajuan lokakarya:';
$string['resetassessments'] = 'Hapus semua penilaian';
$string['resetassessments_help'] = 'Anda dapat memilih untuk menghapus penilaian yang baru saja dialokasikan tanpa memengaruhi ajuan. Jika ajuan akan dihapus, penilaian mereka akan dihapus secara implisit dan opsi ini diabaikan. Perhatikan ini juga termasuk penilaian contoh ajuan.';
$string['resetphase'] = 'Beralih ke fase penyiapan';
$string['resetphase_help'] = 'Jika diaktifkan, semua lokakarya akan dimasukkan ke dalam fase penyiapan awal.';
$string['resetsubmissions'] = 'Hapus semua ajuan';
$string['resetsubmissions_help'] = 'Semua ajuan dan nilai mereka akan dihapus. Ini tidak memengaruhi contoh ajuan.';
$string['saveandclose'] = 'Simpan dan tutup';
$string['saveandcontinue'] = 'Simpan dan lanjutkan mengedit';
$string['saveandpreview'] = 'Simpan dan pratinjau';
$string['saveandshownext'] = 'Simpan dan perlihatkan selanjutnya';
$string['search:activity'] = 'Lokakarya - informasi aktivitas';
$string['selfassessmentdisabled'] = 'Penilaian mandiri dinonaktifkan';
$string['showingperpage'] = 'Menampilkan {$a} item per halaman';
$string['showingperpagechange'] = 'Ubah ...';
$string['someuserswosubmission'] = 'Terdapat setidaknya ada satu penulis yang belum mengirimkan karyanya';
$string['sortasc'] = 'Urut naik';
$string['sortdesc'] = 'Urut turun';
$string['strategy'] = 'Strategi penilaian';
$string['strategy_help'] = 'Strategi penilaian menentukan bentuk penilaian yang digunakan dan metode pengajuan penilaian. Ada 4 opsi:

* Penilaian akumulatif - Komentar dan nilai diberikan mengenai aspek tertentu
* Komentar - Komentar diberikan mengenai aspek tertentu tetapi tidak ada nilai yang dapat diberikan
* Jumlah kesalahan - Komentar dan penilaian ya/tidak diberikan terkait pernyataan yang ditentukan
* Rubrik - Penilaian tingkat diberikan mengenai kriteria yang ditentukan';
$string['strategyhaschanged'] = 'Strategi penilaian lokakarya telah berubah sejak formulir dibuka untuk diedit.';
$string['submission'] = 'Pengajuan';
$string['submissionattachment'] = 'Lampiran';
$string['submissionby'] = 'Diajukan oleh {$a}';
$string['submissioncontent'] = 'Konten pengajuan';
$string['submissiondeleteconfirm'] = 'Apakah Anda yakin ingin menghapus ajuan berikut?';
$string['submissiondeleteconfirmassess'] = 'Apakah Anda yakin ingin menghapus ajuan berikut? Perhatikan bahwa ini juga akan menghapus {$a->count} penilaian yang terkait dengan ajuan ini, yang dapat memengaruhi nilai peninjau.';
$string['submissionend'] = 'Batas waktu pengajuan';
$string['submissionendbeforestart'] = 'Batas waktu pengajuan tidak dapat ditentukan sebelum tanggal terbuka untuk pengajuan';
$string['submissionenddatetime'] = 'Batas waktu pengajuan: {$a->daydatetime} ({$a->distanceday})';
$string['submissionendevent'] = '{$a} batas waktu pengajuan';
$string['submissionendswitch'] = 'Beralih ke fase berikutnya setelah batas waktu pengajuan.';
$string['submissionendswitch_help'] = 'Jika batas waktu pengajuan ditentukan dan kotak ini dicentang, lokakarya akan secara otomatis beralih ke tahap penilaian setelah batas waktu pengajuan. Jika Anda mengaktifkan fitur ini, disarankan untuk mengatur metode alokasi terjadwal juga. Jika pengajuan tidak dialokasikan, penilaian tidak dapat dilakukan meskipun lokakarya itu sendiri dalam tahap penilaian.';
$string['submissiongrade'] = 'Nilai ajuan';
$string['submissiongrade_help'] = 'Setelan ini menentukan nilai maksimum yang dapat diperoleh untuk pekerjaan yang diajukan.';
$string['submissiongradeof'] = 'Nilai untuk pengajuan (dari {$a})';
$string['submissionlastmodified'] = 'Terakhir diubah';
$string['submissionrequiredcontent'] = 'Anda perlu memasukkan beberapa teks atau menambahkan file.';
$string['submissionrequiredfile'] = 'Anda perlu menambahkan berkas atau memasukkan beberapa teks.';
$string['submissionsallocation'] = 'Alokasi pengajuan';
$string['submissionsettings'] = 'Setelan pengajuan';
$string['submissionsreport'] = 'Laporan ajuan lokakarya';
$string['submissionstart'] = 'Pengajuan dibuka dari';
$string['submissionstartdatetime'] = 'Pengajuan dibuka dari {$a->daydatetime} ({$a->distanceday})';
$string['submissionstartevent'] = '{$a} terbuka untuk pengajuan';
$string['submissiontitle'] = 'Judul';
$string['submissiontypedisabled'] = 'Jenis ajuan ini dinonaktifkan untuk lokakarya ini.';
$string['submissiontypefileavailable'] = 'Lampiran berkas <span class="accesshide"> tersedia</span>';
$string['submissiontypefilerequired'] = '<span class="accesshide">Berkas lampiran </span>harus ada';
$string['submissiontypes'] = 'Jenis ajuan';
$string['submissiontypetextavailable'] = 'Teks daring <span class="accesshide"> tersedia</span>';
$string['submissiontypetextrequired'] = '<span class="accesshide">Teks daring </span> harus ada';
$string['submittednotsubmitted'] = 'Diajukan ({$a->submitted}) / tidak diajukan ({$a->notsubmitted})';
$string['subplugintype_workshopallocation'] = 'Metode alokasi pengajuan';
$string['subplugintype_workshopallocation_plural'] = 'Metode alokasi pengajuan';
$string['subplugintype_workshopeval'] = 'Metode evaluasi penilaian';
$string['subplugintype_workshopeval_plural'] = 'Metode evaluasi penilaian';
$string['subplugintype_workshopform'] = 'Strategi penilaian';
$string['subplugintype_workshopform_plural'] = 'Strategi penilaian';
$string['switchingphase'] = 'Beralih fase';
$string['switchphase'] = 'Beralih fase';
$string['switchphase10'] = 'Beralih ke fase penyiapan';
$string['switchphase10info'] = 'Anda akan mengalihkan lokakarya ke <strong>Fase Penyiapan</strong>. Pada fase ini, pengguna tidak dapat mengubah ajuan atau penilaian mereka. Pengajar dapat menggunakan fase ini untuk mengubah setelan lokakarya, memodifikasi strategi penilaian atau mengubah formulir penilaian.';
$string['switchphase20'] = 'Beralih ke fase pengajuan';
$string['switchphase20info'] = 'Anda akan mengalihkan lokakarya ke <strong>Fase Pengajuan</strong>. Siswa dapat mengajukan pekerjaan mereka selama fase ini (dalam tanggal kontrol akses pengajuan, jika ditetapkan). Pengajar dapat mengalokasikan kiriman untuk ulasan rekan sejawat.';
$string['switchphase30'] = 'Beralih ke fase penilaian';
$string['switchphase30auto'] = 'Lokakarya akan secara otomatis beralih ke fase penilaian setelah {$a->daydatetime} ({$a->distanceday})';
$string['switchphase30info'] = 'Anda akan mengalihkan lokakarya ke <strong>Fase Penilaian</strong>. Pada fase ini, peninjau dapat menilai ajuan yang telah dialokasikan (dalam tanggal kontrol akses penilaian, jika ditetapkan).';
$string['switchphase40'] = 'Beralih ke fase evaluasi';
$string['switchphase40info'] = 'Anda akan mengalihkan lokakarya ke <strong>fase Evaluasi penilaian</strong>. Pada fase ini, pengguna tidak dapat mengubah ajuan atau penilaian mereka. Pengajar dapat menggunakan alat evaluasi penilaian untuk menghitung nilai akhir dan memberikan umpan balik untuk pengulas.';
$string['switchphase50'] = 'Tutup lokakarya';
$string['switchphase50info'] = 'Anda akan menutup lokakarya. Ini akan menghasilkan nilai yang dihitung muncul di buku nilai. Siswa dapat melihat ajuan mereka dan penilaian ajuan mereka.';
$string['switchphaseauto'] = 'Peralihan telah terjadwal';
$string['switchphasenext'] = 'Beralih ke fase selanjutnya';
$string['taskassesspeers'] = 'Penilaian sejawat';
$string['taskassesspeersdetails'] = 'total: {$a->total}<br />ditangguhkan: {$a->todo}';
$string['taskassessself'] = 'Menilai sendiri';
$string['taskconclusion'] = 'Memberikan kesimpulan dari aktivitas';
$string['taskdone'] = 'Tugas terselesaikan';
$string['taskfail'] = 'Tugas gagal';
$string['taskinfo'] = 'Info tugas';
$string['taskinstructauthors'] = 'Berikan instruksi untuk pengiriman';
$string['taskinstructreviewers'] = 'Memberikan instruksi untuk penilaian';
$string['taskintro'] = 'Tetapkan deskripsi lokakarya';
$string['tasksubmit'] = 'Ajukan pekerjaanmu';
$string['tasktodo'] = 'Tugas yang harus dikerjakan';
$string['toolbox'] = 'Kotak perkakas lokakarya';
$string['undersetup'] = 'Saat ini lokakarya sedang disiapkan. Harap tunggu sampai beralih ke fase berikutnya.';
$string['useexamples'] = 'Gunakan contoh';
$string['useexamples_desc'] = 'Ajukan karyamu';
$string['useexamples_help'] = 'Jika diaktifkan, pengguna dapat mencoba menilai satu atau beberapa contoh ajuan dan membandingkan penilaian mereka dengan penilaian referensi. Nilai tidak dihitung dalam nilai untuk penilaian.';
$string['usepeerassessment'] = 'Gunakan penilaian rekan sejawat';
$string['usepeerassessment_desc'] = 'Siswa boleh menilai karya orang lain';
$string['usepeerassessment_help'] = 'Jika diaktifkan, pengguna dapat dialokasikan ajuan dari pengguna lain untuk dinilai dan akan mendapatkan nilai untuk penilaian selain nilai untuk ajuan mereka sendiri.';
$string['userdatecreated'] = 'diajukan pada <span>{$a}</span>';
$string['userdatemodified'] = 'dimodifikasi pada <span>{$a}</span>';
$string['userplan'] = 'Perencana lokakarya';
$string['userplan_help'] = 'Perencana lokakarya menampilkan semua tahapan kegiatan dan membuat daftar tugas untuk setiap tahapan. Fase saat ini disorot dan penyelesaian tugas ditunjukkan dengan tanda centang.';
$string['userplanaccessibilityskip'] = 'Lewati ke tugas saat ini';
$string['userplanaccessibilitytitle'] = 'Lini masa lokakarya dengan {$a} fase';
$string['userplancurrentphase'] = 'Fase sekarang';
$string['useselfassessment'] = 'Gunakan penilaian mandiri';
$string['useselfassessment_desc'] = 'Siswa dapat menilai pekerjaan mereka sendiri';
$string['useselfassessment_help'] = 'Jika diaktifkan, pengguna dapat mengalokasikan kiriman mereka sendiri untuk dinilai dan akan mendapatkan nilai untuk penilaian selain nilai untuk kiriman mereka.';
$string['viewworkshopsummary'] = 'Lihat ringkasan lokakarya';
$string['weightinfo'] = 'Bobot: {$a}';
$string['withoutsubmission'] = 'Pengulas tanpa ajuan sendiri';
$string['workshop:addinstance'] = 'Tambahkan lokakarya baru';
$string['workshop:allocate'] = 'Alokasikan ajuan untuk ditinjau';
$string['workshop:deletesubmissions'] = 'Hapus ajuan';
$string['workshop:editdimensions'] = 'Edit formulir penilaian';
$string['workshop:exportsubmissions'] = 'Ekspor ajuan';
$string['workshop:ignoredeadlines'] = 'Abaikan pembatasan waktu';
$string['workshop:manageexamples'] = 'Kelola contoh ajuan';
$string['workshop:overridegrades'] = 'Kesampingkan perhitungan nilai';
$string['workshop:peerassess'] = 'Penilaian rekan sejawat';
$string['workshop:publishsubmissions'] = 'Publikasikan ajuan';
$string['workshop:submit'] = 'Ajukan';
$string['workshop:switchphase'] = 'Beralih fase';
$string['workshop:view'] = 'Lihat lokakarya';
$string['workshop:viewallassessments'] = 'Lihat semua penilaian';
$string['workshop:viewallsubmissions'] = 'Lihat semua ajuan';
$string['workshop:viewauthornames'] = 'Lihat nama penulis';
$string['workshop:viewauthorpublished'] = 'Lihat penulis ajuan yang diterbitkan';
$string['workshop:viewpublishedsubmissions'] = 'Lihat ajuan yang diterbitkan';
$string['workshop:viewreviewernames'] = 'Lihat nama pengulas';
$string['workshopname'] = 'Nama lokakarya';
$string['yourassessmentfor'] = 'Penilaian Anda untuk {$a}';
$string['yourgrades'] = 'Nilai Anda';
$string['yoursubmission'] = 'Ajuan Anda';
$string['yoursubmissionwithassessments'] = 'Ajuan Anda dengan penilaian';
