<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'format_tiles', language 'ja', version '4.2'.
 *
 * @package     format_tiles
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addsections'] = 'タイルを追加';
$string['admintools'] = '管理ツール';
$string['all'] = 'すべて';
$string['allcomplete'] = '完了';
$string['allcoursescomplypalette'] = 'すべてのコースでタイルの色が許可されています。リセットする必要はありません。リセットを押す前に、許可された色の変更を保存してください。';
$string['allowphototiles'] = 'フォトタイル可';
$string['allowphototiles_desc'] = '選択された場合、教師はタイルの背景となる写真をアップロードすることができるようになります。標準のタイルアイコンも同じコースで使用することができます。(選択されていない場合は、タイルアイコンのみが許可され、以下の他の写真のタイル設定は無視されます)';
$string['allowsubtilesview'] = 'サブタイル表示を許可';
$string['allowsubtilesview_desc'] = '標準のリストではなくサブタイルとしてアクティビティ(ラベルを除く)をタイル内で表示できるようになるコース設定を許可する。';
$string['alternativelink'] = '代替リンク';
$string['areyousure'] = 'よろしいですか？';
$string['asfraction'] = '端数として表示';
$string['aspectratiotootallorwide'] = 'アップロードされた画像は保存されていますが、<strong>{$a->tallorwide}</strong>になっている可能性がありますので、ご確認ください。正しくない場合は、標準的な横長のサイズにトリミングして、再度アップロードしてください。例：幅200×高さ300がぴったりです。';
$string['aspercentagedial'] = '円形で％を表示';
$string['assumedatastoreconsent'] = 'ブラウザのローカルストレージへの同意を仮定';
$string['assumedatastoreconsent_desc'] = '選択された場合、ユーザーはブラウザのローカル・ストレージにデータを保存することへの同意を求めるダイアログを表示しない';
$string['backupfailed'] = 'バックアップ失敗';
$string['basecolour'] = 'タイルの色';
$string['basecolour_help'] = 'ここで設定された色は、コース内のすべてのタイルに適用されます。';
$string['brandcolour'] = 'ブランド色';
$string['canceltask'] = 'キャンセル';
$string['changedcolour'] = 'タイルの色をコース{$a}のデフォルトに戻す';
$string['checkforproblemcourses'] = '問題のあるコースの確認と修正';
$string['clickiffailstoload'] = 'ページの読み込みに失敗したときにクリックする';
$string['close'] = '閉じる';
$string['collapse'] = 'セクションを閉じる';
$string['collapsesections'] = 'すべてを閉じる';
$string['colourblue'] = '青';
$string['colourdarkgreen'] = '深緑色';
$string['colourgreen'] = '緑';
$string['colourlightblue'] = '水色';
$string['colourname_descr'] = '色の表示名（通常、ユーザーには色名は表示されず、色見本が表示されます';
$string['colournamegeneral'] = '上の色の表示名';
$string['colourpurple'] = '紫';
$string['colourred'] = '赤';
$string['colours'] = '色';
$string['complete'] = '完了';
$string['complete-n-auto'] = '項目が完了していません。完了基準を満たすと、完了と表示されます。これを手動で変更することはできません。';
$string['complete-y-auto'] = '項目が完了しました。完了基準を満たしたときに完了と表示されました。これを手動で変更することはできません。';
$string['completion_help'] = 'アクティビティの右にあるチェックマークは、そのアクティビティが完了したことを示すために使用できます（完了していない場合は空の円が表示されます）<br><br> 設定によっては、先生が設定した条件に沿ってアクティビティを完了すると、自動的にチェックマークが表示されます。<br><br>その他の場合は、アクティビティを完了したと思ったときに空の円をクリックすると、緑のチェックマークが付きます。気が変わったら、もう一度クリックするとチェックが消えます）。';
$string['completionswitchhelp'] = '<p>あなたは、各タイルに完了追跡を表示することを選択しました。そのため、このページのさらに下にある「完了トラッキング > 有効化」を「はい」に設定しました。</p><p>さらに、トラッキングするアイテムごとに完了トラッキングをオンにする必要があります。例えば、PDFの場合、「設定の編集」をクリックして、「アクティビティの完了」を確認し、必要な設定を選択します。</p>';
$string['completionwarning'] = 'コースレベルでは完了トラッキングが有効になっていますが、個々のアクティビティレベルではトラッキングが有効になっているアイテムがないため、トラッキングするものがありません。';
$string['completionwarning_changeinbulk'] = '一括変更';
$string['completionwarning_help'] = '個々のアイテムを編集して追跡可能にする必要があります（「アクティビティの完了」＞「完了トラッキング」）。または、「コース管理」＞「コース完了」＞「アクティビティの完了の一括編集」で一括して行うことができます。';
$string['contact'] = '連絡先';
$string['contactdeveloper'] = 'お問い合わせ';
$string['contents'] = '内容';
$string['courseshowtileprogress'] = '各タイルに進行状況を表示する';
$string['courseshowtileprogress_error'] = '完了トラッキング > 完了トラッキングを有効にする」が「No」に設定されていて（このページのさらに下を参照）、この設定と競合しています。タイル上に進捗状況を表示したい場合は、「完了トラッキング > 完了トラッキングを有効にする」を「Yes」に設定してください。それ以外の場合は、この設定を「No」にしてください。';
$string['courseshowtileprogress_help'] = '<p>選択すると、各タイルにユーザーのアクティビティの進捗状況が、分数で表示されるか（例：「Progress 2/10」は10個のアクティビティのうち2個が完了したことを意味する）、円で表示されるパーセンテージで表示されます。</p><p>これは、「完了トラッキング > 完了トラッキングを有効 」がオンになっている場合のみ使用できます。</p><p>特定のタイル内に追跡可能なアクティビティがない場合、そのタイルにはインジケータが表示されません。</p>';
$string['courseshowtileprogress_link'] = 'Activity_completion_settings#Activity_settings';
$string['coursetoomanysections'] = '編集者への警告：このコースでは、許容される最大数よりも多くのタイルが使用されています。最大で{$a->max}が学生に表示されます（"{$a->tilename}"まで）（編集者はもっと見ることができます）。';
$string['courseusebarforheadings'] = '色付きのタブで見出しを強調する';
$string['courseusebarforheadings_help'] = 'テキストエディタで見出しスタイルが選択されると、コースの見出しの左側にカラーのタブが表示されます';
$string['courseusesubtiles'] = 'アクティビティのためにサブタイルを使用';
$string['courseusesubtiles_help'] = '各タイル内では、すべてのアクティビティを、ページの下にあるアクティビティのリストとしてではなく、サブタイルとして表示します。これは、サブタイルとして表示されないラベルには適用されませんが、タイル間の見出しとして使用できます。';
$string['currentsection'] = 'このタイル';
$string['customcss'] = 'カスタムCSS';
$string['customcssdesc'] = 'コースフォーマットが使用されている間、コースコンテンツセクションに適用されるカスタムCSS。これは検証されませんので、有効なコードを入力するように注意してください。';
$string['datapref'] = 'データプリファレンス';
$string['datapreferror'] = 'データプリファレンス機能は、お使いのブラウザでJavaScriptが利用できる場合にのみ利用できます。それ以外の場合は、データ保存を有効にすることはできません。';
$string['dataprefquestion'] = '<p>本サイトをより使いやすくするために、あなたが最後に開いたタイルの内容などの機能情報をあなたのブラウザに保存しています。これは、そのページに再度アクセスするために、あなたのパソコンに少しの間残ります。追跡のために使用することはありません。いいですか？</p><p>ブラウザーの閲覧履歴を消去するまで、選択した内容は記憶されます。解除するには「キャンセル」をクリックしてください（ページの読み込みが遅くなる場合があります）。</p>';
$string['defaultthiscourse'] = 'コースデフォルト';
$string['defaulttilecolour'] = 'タイルのデフォルト色';
$string['defaulttileicon'] = 'タイルのアイコン';
$string['defaulttileicon_help'] = 'ここで選択されたアイコンは、デフォルトでこのコースのすべてのタイルに表示されます。個々のタイルはタイルレベルでの異なる設定を使用して、異なるアイコンを選択したり、背景写真を設定することができます。';
$string['deleteemptytiles'] = '空のタイルを削除する';
$string['deleteimage'] = '画像を削除する';
$string['deletesection'] = 'タイルを削除する';
$string['deletetile'] = 'タイルを削除する';
$string['developedby'] = '「タイル」は{$a}による開発';
$string['developer'] = '開発者';
$string['disabledbyadmin'] = 'サイト管理者による無効化';
$string['displayfilterbar'] = 'フィルターバー';
$string['displayfilterbar_error'] = 'このコースに成果を設定していない場合、タイル番号に基づいてのみフィルタバーを表示することができ、成果に基づいて表示することはできません。まず、成果を作成してから、ここに戻ってきてください。';
$string['displayfilterbar_help'] = '<p>選択されると、コースのタイル画面の前に自動的にボタンの配列が表示され、ユーザーはこれをクリックして、特定の範囲にタイルを絞り込むことができます。</p><p>「タイルの数に基づく」を選択すると、タイル1〜4番のボタン、タイル5〜8番のボタンなど、一連のボタンが表示されます。</p><p>「コースの成果に基づく」を選択した場合、コースの成果ごとに1つのボタンが表示されます。それぞれのタイルは、タイルの設定ページから任意の成果 (および任意のボタン) に割り当てることができます。</p>';
$string['displayfilterbar_link'] = 'Outcomes';
$string['displaytitle_mod_doc'] = 'ワード文書';
$string['displaytitle_mod_html'] = 'Webページ';
$string['displaytitle_mod_jpeg'] = '画像';
$string['displaytitle_mod_mp3'] = 'オーディオ';
$string['displaytitle_mod_mp4'] = 'ビデオ';
$string['displaytitle_mod_pdf'] = 'PDF';
$string['displaytitle_mod_ppt'] = 'パワーポイント';
$string['displaytitle_mod_txt'] = 'テキスト';
$string['displaytitle_mod_xls'] = 'スプレッドシート';
$string['displaytitle_mod_zip'] = 'Zip';
$string['documentation'] = 'ドキュメンテーション';
$string['documentationurl'] = 'ドキュメンテーションのURL';
$string['documentationurl_descr'] = '「タイル」ドキュメンテーションのURL';
$string['download'] = 'ダウンロード';
$string['editsectionname'] = 'タイル名を編集';
$string['embeddedurlerror'] = '上記のウィンドウで外部サイトの接続が拒否された場合は、こちらをご利用ください。';
$string['entersection'] = 'セクションの入力';
$string['existingimage'] = 'このタイルの既存の画像';
$string['expand'] = '展開';
$string['expandall'] = 'すべて展開';
$string['expandsections'] = 'すべての活動を公開する（すべてのセクション）';
$string['fileaddedtobottom'] = 'セクションの下部にファイルを追加';
$string['filenoshowtext'] = 'ファイルが表示されない場合は、右のボタンを使ってダウンロードするか、新しいウィンドウで表示してください。';
$string['filterboth'] = 'タイル数やコースの成果に応じたボタンを表示';
$string['filternumbers'] = 'タイルの数に応じてボタンを表示';
$string['filteroutcomes'] = 'コースの成果に応じたボタンを表示';
$string['filteroutcomesrestore'] = 'オリジナルのコースではフィルタバーに成果物が使用されていましたが、復元プロセスではまだサポートされていません。そのため、復元されたコースではフィルタバーの設定が変更されています。復元されたコースでタイルのフィルタリングに成果物を使用したい場合は、成果物を再度設定してください。なお、元のコースは変更されていません。';
$string['fittilestowidth'] = 'タイルを画面幅に合わせる';
$string['fittilestowidth_desc'] = 'チェックした場合、ユーザが非モバイルデバイスでコースにアクセスすると、最適なレイアウトを計算する間、タイルの読み込みが半秒ほど遅れます。例えば、1列に1つのタイルを避け、スクリーンの中央にタイルを配置します。これはセッション内で初めてコースに入ったときにのみ発生し、セッションまたはユーザがスクリーンサイズを調整するまで記憶されます。';
$string['fixproblems'] = '問題点の修正';
$string['folderdisplayerror'] = 'コンテンツをインラインで表示するように設定されたフォルダーは、サブタイル形式に対応していません。そのため、この<a href="{$a}">folder</a>は、別のページに表示するように変更しました。';
$string['followthemecolour'] = 'テーマカラーの強制適用';
$string['followthemecolour_desc'] = '「はい」に設定すると、教師はこのプラグインによって選択肢を与えられず、以下のすべてのタイルカラーは無視されます。代わりに、テーマのメインブランドカラーを取得しようとし、それを使用するようになります。';
$string['guidance'] = 'ガイダンス';
$string['height'] = '高さ';
$string['hidden'] = '非表示';
$string['hide'] = '隠す';
$string['hidefromothers'] = 'タイルを隠す';
$string['highestsectionnum'] = '最高のセクション番号';
$string['home'] = 'コースホーム';
$string['icontitle-address-book-o'] = 'アドレス帳';
$string['icontitle-assessment_graded'] = '評価A＋';
$string['icontitle-assessment_timer'] = '評価タイマー';
$string['icontitle-asterisk'] = '米印';
$string['icontitle-award-solid'] = '受賞';
$string['icontitle-balance-scale'] = '天秤';
$string['icontitle-bar-chart'] = '棒グラフ';
$string['icontitle-bell-o'] = 'ベル';
$string['icontitle-binoculars'] = '双眼鏡';
$string['icontitle-bitcoin'] = 'ビットコイン';
$string['icontitle-book'] = '本';
$string['icontitle-bookmark-o'] = 'お気に入り';
$string['icontitle-briefcase'] = '書類カバン';
$string['icontitle-building'] = '建物';
$string['icontitle-bullhorn'] = '拡声器';
$string['icontitle-bullseye'] = 'ブルズアイ';
$string['icontitle-calculator'] = '計算機';
$string['icontitle-calendar'] = 'カレンダー';
$string['icontitle-calendar-check-o'] = 'チェックマーク付きカレンダー';
$string['icontitle-check'] = 'チェック';
$string['icontitle-child'] = '子供';
$string['icontitle-clock-o'] = '時計';
$string['icontitle-clone'] = 'コピー';
$string['icontitle-cloud-download'] = '雲（ダウンロード）';
$string['icontitle-cloud-upload'] = '雲（アップロード）';
$string['icontitle-comment-o'] = 'コメント';
$string['icontitle-comments-o'] = 'コメント';
$string['icontitle-compass'] = 'コンパス';
$string['icontitle-diamond'] = 'ダイヤ';
$string['icontitle-dollar'] = 'ドル';
$string['icontitle-euro'] = 'ユーロ';
$string['icontitle-exclamation-triangle'] = '三角形の中の感嘆詞';
$string['icontitle-feed'] = 'フィード';
$string['icontitle-file-text-o'] = 'テキストファイル';
$string['icontitle-film'] = '映画';
$string['icontitle-flag-checkered'] = 'チェッカーフラッグ';
$string['icontitle-flag-o'] = '旗';
$string['icontitle-flash'] = 'フラッシュ';
$string['icontitle-flask'] = 'フラスコ';
$string['icontitle-flipchart'] = 'フリップチャート';
$string['icontitle-frown-o'] = 'しかめっ面';
$string['icontitle-gavel'] = '小槌';
$string['icontitle-gbp'] = '英ポンド';
$string['icontitle-globe'] = '地球';
$string['icontitle-handshake-o'] = '握手';
$string['icontitle-headphones'] = 'ヘッドフォン';
$string['icontitle-heartbeat'] = 'ハートビート';
$string['icontitle-history'] = '歴史時計';
$string['icontitle-home'] = '家';
$string['icontitle-id-card-o'] = '身分証明書';
$string['icontitle-info'] = '案内';
$string['icontitle-jigsaw'] = 'ジグソーパズル';
$string['icontitle-key'] = '鍵';
$string['icontitle-laptop'] = 'ノートパソコン';
$string['icontitle-life-buoy'] = '救命ブイ';
$string['icontitle-lightbulb-o'] = '電球';
$string['icontitle-line-chart'] = '線グラフ';
$string['icontitle-list'] = 'リスト（ビレットポイント）';
$string['icontitle-list-ol'] = 'リスト（数字）';
$string['icontitle-location-arrow'] = '位置決め矢印';
$string['icontitle-map-marker'] = '地図マーカー';
$string['icontitle-map-o'] = '地図';
$string['icontitle-map-signs'] = '地図記号';
$string['icontitle-microphone'] = 'マイク';
$string['icontitle-mobile-phone'] = '携帯電話';
$string['icontitle-mortar-board'] = 'モルタルボード';
$string['icontitle-music'] = '音楽';
$string['icontitle-newspaper-o'] = '新聞';
$string['icontitle-number_1'] = '１';
$string['icontitle-number_10'] = '１０';
$string['icontitle-number_2'] = '２';
$string['icontitle-number_3'] = '３';
$string['icontitle-number_4'] = '４';
$string['icontitle-number_5'] = '５';
$string['icontitle-number_6'] = '６';
$string['icontitle-number_7'] = '７';
$string['icontitle-number_8'] = '８';
$string['icontitle-number_9'] = '９';
$string['icontitle-pencil-square-o'] = '正方形の中の鉛筆';
$string['icontitle-person'] = '人';
$string['icontitle-pie-chart'] = 'パイチャート';
$string['icontitle-podcast'] = 'ポッドキャスト';
$string['icontitle-puzzle-piece'] = 'パズルのピース';
$string['icontitle-question-circle'] = '円の中のクエスチョンマーク';
$string['icontitle-random'] = 'ランダム';
$string['icontitle-refresh'] = 'リフレッシュ';
$string['icontitle-road'] = '道';
$string['icontitle-search'] = '虫眼鏡';
$string['icontitle-sliders'] = 'スライダー';
$string['icontitle-smile-o'] = 'スマイル';
$string['icontitle-star'] = 'スター(影付き)';
$string['icontitle-star-half-o'] = 'スター(半影付き)';
$string['icontitle-star-o'] = 'スター(影なし)';
$string['icontitle-survey'] = 'アンケート';
$string['icontitle-tags'] = 'タッグ';
$string['icontitle-tasks'] = '課題';
$string['icontitle-television'] = 'テレビ';
$string['icontitle-thinking-person'] = '電球を持つ人';
$string['icontitle-thumbs-o-down'] = '親指ダウン';
$string['icontitle-thumbs-o-up'] = '親指を立てる';
$string['icontitle-trophy'] = 'トロフィー';
$string['icontitle-umbrella'] = '傘';
$string['icontitle-university'] = '大学';
$string['icontitle-user-o'] = '人（影なし）';
$string['icontitle-users'] = '人々';
$string['icontitle-volume-up'] = 'スピーカ';
$string['icontitle-wrench'] = 'レンチ';
$string['imagecannotbeused'] = '画像は使用できません。';
$string['imagedeletedfrom'] = '"{$a}"から画像が削除されました。';
$string['imagesavedfor'] = '画像がタイル{$a}に保存されました';
$string['imagesize'] = '画像サイズ';
$string['items'] = '項目';
$string['jsactivate'] = 'アニメーション付きナビゲーション「オン」';
$string['jsdeactivate'] = 'アニメーション付きナビゲーション「オフ」';
$string['jsdeactivated'] = 'あなたのアカウントでアニメーション付きナビゲーションを無効にしました。';
$string['jsnavsettings'] = 'JavaScriptナビゲーション';
$string['jsreactivated'] = 'あなたのアカウントでは、アニメーション付きナビゲーションが有効になっています。こちらの方が早いかもしれません。JavaScriptを有効にする必要があります。';
$string['links'] = 'リンク';
$string['loading'] = '読み込み中';
$string['maxcoursesectionsallowed'] = 'この環境で許容されるコースセクションの最大数は{$a}です。';
$string['modalmodules'] = 'モーダル型モジュール';
$string['modalmodules_desc'] = 'これらのコースモジュールをモーダルウィンドウで起動する。(他のモジュールは後のリリースで追加される可能性があります)';
$string['modalresources'] = 'モーダルリソース';
$string['modalresources_desc'] = 'これらのリソースをモーダルウィンドウで起動する。注：ここで許可されている場合、URLアクティビティは、アクティビティレベルで{$a->displayembed}に設定されている場合にのみ、モーダルウィンドウで開きます（例：YouTubeやVimeoの動画など）。その場合でも、ウェブサイトの所有者によって埋め込み表示がブロックされている可能性があります（{$a->link}を参照）。';
$string['modalwindows'] = 'モーダルウィンドウ';
$string['newsectionname'] = 'トピック{$a}の新しい名前';
$string['nexttopic'] = '次のトピック';
$string['noconnectionerror'] = 'コンテンツを読み込めません。インターネットの接続状況を確認してください。';
$string['nojswarning'] = 'お使いのブラウザは、JavaScriptをサポートしていないか、または無効になっているようです。Javascriptを有効にすると、より優れたインターフェースをご利用いただけます。';
$string['none'] = 'なし';
$string['noproblemsfound'] = '問題なし';
$string['notcomplete'] = '未完成';
$string['notrecommended'] = '推奨しない';
$string['notregistered'] = 'あなたの「タイル」プラグインは、まだプラグイン開発者に登録されていません。';
$string['novaliddefaultcolour'] = '以下のデフォルトタイルカラーに有効な色が設定されていません。';
$string['numberofsections'] = 'コースのセクション数';
$string['ok'] = 'OK';
$string['other'] = 'その他';
$string['outcomes'] = 'アウトカム';
$string['outcomesunavailable'] = 'アウトカムがない';
$string['overall'] = '全体';
$string['overallprogress'] = 'アクティビティの完了 ー 全体の進捗状況';
$string['overallprogressshort'] = '全体の進捗状況';
$string['photoguidance_desc'] = '<p>写真は<strong>横長のもの</strong>をアップロードしてください。横幅は高さの1.35倍程度にしてください。例：幅270×高さ200がぴったりです。厳密でなくても構いません。</p><p>縦長の写真は、タイルの形状に合わない。大きな画像やファイルは、アップロード後、必要に応じて縮小・圧縮されます。</p>';
$string['photolibrary'] = 'フォトライブラリー';
$string['photolibrary_desc'] = 'あなたが最近アップロードまたは使用した写真です。このタイルの背景として使用する場合は、その写真をクリックしてください。新しい写真をアップロードするには、上のアップロードタブを使ってください。';
$string['phototilesaltstyle'] = 'フォトタイルの代替スタイル';
$string['phototilesaltstyle_desc'] = '選択されていない場合（デフォルト）、フォトタイルのタイトルはタイルの上部に表示されます。代替スタイルでは、タイトルが下部に表示されます。';
$string['phototilesettings'] = 'フォトタイル';
$string['phototiletitletransarency'] = 'フォトタイルのタイトル透過';
$string['phototiletitletransarency_desc'] = 'フォトタイルのタイトルオーバーレイは、背景を少し透明にしたり、無地にしたりすることができます(0%)。';
$string['phototitletitlelineheight'] = 'タイトル行の高さ';
$string['phototitletitlepadding'] = 'タイトルの縦線パディング';
$string['picknewicon'] = '新しいアイコンを選ぶ';
$string['picknewiconphoto'] = '新しいアイコンや背景写真を選ぶ';
$string['pluginname'] = 'タイルフォーマット';
$string['previoustopic'] = '前のトピック';
$string['privacy:metadata:preference:format_tiles_stopjsnav'] = 'ユーザーがJavaScriptのアニメーションを無効にしているかどうか。';
$string['privacypolicy'] = 'プライバシーポリシー';
$string['problemcourses'] = '問題ありのコース';
$string['problemcoursesintro'] = '以下のコースでは、セクション数が想定よりも多くなっています。以下のボタンを使って問題を解決してください。';
$string['progress'] = '進展';
$string['reactivate'] = '再起動';
$string['register'] = '登録する';
$string['registeragreeprivacy'] = 'プラグイン開発者の{$a->privacypolicylink}に同意します。';
$string['registerclicktocomplete'] = 'OKをクリックして処理を完了する';
$string['registeredthanks'] = 'プラグインが登録されました。ありがとうございました。';
$string['registeremailno'] = 'メールの受信を希望しません';
$string['registeremailyes'] = 'はい、「タイル」プラグインの更新通知やその他の情報を随時受け取ることを希望します。';
$string['registerintro1'] = '連絡させてください。ご登録の際は';
$string['registerintro2'] = 'このプラグインの将来の開発をサポートしてくれる';
$string['registerintro3'] = '重要なアップデートや将来の計画について迅速に情報をもらえる';
$string['registerintro4'] = 'このプラグインの新機能をリクエストすることができます。';
$string['registerintro5'] = 'あなたの個人情報は、下記の個人情報保護方針に基づき、開発者によって管理されます。ご協力ありがとうございました。';
$string['registermissingemail'] = 'メールアドレスを記入してください（下記のメールに「はい」を選択しています）。';
$string['registerpickemailpref'] = 'メールプリファレンスをお選びください。';
$string['registerpolicyagreedlinktext'] = 'プライバシーポリシーとデータ処理規約';
$string['registrationdeferred'] = 'ありがとうございます。あなたのプラグインは登録中です（まだ完了していません）。';
$string['reopenlastsection'] = '最後に訪れたタイルを再度開く';
$string['reopenlastsection_desc'] = 'チェックした場合、ユーザーがコースを再訪すると、最後に開いていたセクションが到着時に再表示されます。';
$string['resetallcoursecolours'] = 'すべてのコースカラーをリセット';
$string['resetcolours'] = 'カラーをリセット';
$string['resetcolours_desc'] = 'このボタンを押すと、下記の色以外のコースのタイルカラーをリセットします。コースは、以下のデフォルトのタイルカラーに変更されます。下のカラーパレットを変更した後でも使用できますが、このボタンを押す前に、下のカラーの変更を<strong>保存していること</strong>を確認してください。多くのコースの色が変更される可能性がありますので、ご注意ください。';
$string['restorefailed'] = 'リストアの失敗';
$string['restoreincorrectsections'] = 'エラーです。ソースコースに誤ったセクション番号が含まれているため、完了できません。例：セクション番号({$a->sectionnum})が最大許容数より({$a->maxallowed})も多い。数字が大きいセクションを除外したり、削除したりしてみてください。';
$string['restoretoomanysections'] = 'エラーです。あまりにも多くのコースセクションが含まれており ({$a->numsections})、これが許容範囲 ({$a->maxallowed}) を超えているため、バックアップまたはリストアできません。いくつかのセクションを除外または削除してみてください。';
$string['revealcontents'] = 'タイルの内容を表示する';
$string['scheduleddeleteemptysections'] = 'コースから空のセクションを削除するタスクがスケジュールされました。後日、ご確認ください。';
$string['section0name'] = '一般';
$string['sectionerrorstring'] = 'セッションの有効期限が切れている可能性があります。このページを更新してみてください。';
$string['sectionerrortitle'] = '読み込みエラー';
$string['sectionname'] = 'タイル';
$string['sectionnumber'] = 'セクション又はタイル番号';
$string['selected'] = '選択中';
$string['setavailabletilecolours'] = '許可されたタイルの色（サイト全体）';
$string['settings'] = 'タイルのフォーマット設定';
$string['show'] = '表示';
$string['showalltiles'] = '全てのタイルを表示';
$string['showfromothers'] = 'タイルを表示';
$string['showoverallprogress'] = '全体の進捗状況を示す指標を表示';
$string['showoverallprogress_desc'] = 'コース右上に「全体の進捗率」インジケータを表示する。表示される値は、コース完了ではなくアクティビティ完了に基づいて、各タイルの完了率を集計したものです。';
$string['showprogresssphototiles_desc'] = '選択した場合、学生の進捗状況（例：Progress 2/5）がフォトタイルに表示されます。';
$string['showseczerocoursewide'] = '全セクションの先頭にセクション・ゼロを表示';
$string['showseczerocoursewide_desc'] = 'チェックされた場合、セクションゼロ (一番上のセクション) はコースランディングページおよび<b>すべてのコースセクションページ</b>の一番上 (すなわちすべてのタイルのコンテンツの一番上) に表示されます。チェックされていない (推奨) 場合、コースランディングページにのみ表示されます。';
$string['showseparatewin'] = 'ファイルを別ウィンドウで表示する';
$string['sitename'] = 'サイト名';
$string['snapwarning'] = '他のテーマを使ってTiles形式のコースを編集し、編集が終わったらSnapテーマに戻すことができる場合があります。';
$string['snapwarning_help'] = 'Theme_settings#Allow_user_themes';
$string['subtileszeczerotoggled'] = 'トップセクションは、リスト形式とサブタイル形式の切り替えが可能です。';
$string['sureresetcolours'] = 'コースのタイルカラーをデフォルトに戻してよろしいでしょうか？これは{$a}コースに影響します。';
$string['tilecolourgeneral'] = 'カラーパレット-オプション色';
$string['tilecolourgeneral_descr'] = 'これらの設定により、管理者は教師がコースに適用できるカラーを設定することができます。色を黒 (#000) にすると、その色は無効になります。ここで色を変更しても、次に教師がタイルの色を変更しようとするまで、既存のコースには変更が加えられません。その時点では、ここで設定した色のみが教師に適用されます。';
$string['tilecolourschanged'] = 'タイルの色がリセットされました。すべてのタイルの色が、以下の色に適合するようになりました。';
$string['tileicon'] = 'このタイルのみに表示されるアイコン';
$string['tileicon_help'] = 'ここで選択されたアイテムは、コースレベルで設定されたどのようなタイルアイコンも、このタイルのみにオーバーライドされます。';
$string['tileicons'] = 'タイルのアイコン';
$string['tileoutcome'] = 'このタイルのアウトカム';
$string['tileoutcome_help'] = 'このタイルに結果を選択した場合、コース設定でフィルターボタンのセットを表示することができます。各結果に対して1つずつ表示され、押したときにどの結果が割り当てられているかによって表示されたタイルをフィルターします';
$string['tileselecttip'] = 'タイルのアイコンや写真を簡単に変更する方法をご紹介します。コース上で編集モードをオンにした状態で、変更したいアイコンや写真をクリックするだけです。アイコンの選択画面が表示されます。';
$string['tilesformatregistration'] = 'タイルフォーマットの登録';
$string['togglecompletion'] = 'クリックすると完了ステータスが切り替わります。';
$string['tootall'] = 'タイルに対して高すぎる';
$string['toowide'] = 'タイルに対して幅が広すぎる';
$string['transparenttitleadjustments'] = '透過型タイトル調整';
$string['transparenttitleadjustments_desc'] = 'タイトルの背景が透明なフォトタイルでは、サイトテーマによっては、タイトルの透明な線が折り返したときに重ならないように調整する必要があります。なお、これらはブラウザによって多少異なります。';
$string['uploadnewphoto'] = '新しい写真のアップロード';
$string['uploadnewphoto_help'] = 'このタイルに使用する画像をアップロードする';
$string['usejavascriptnav'] = 'タイルのメインページからJavaScriptによるナビゲーションを使用する';
$string['usejavascriptnav_desc'] = 'チェックした場合、ユーザがコース概要ページでタイルをクリックし、かつJavaScriptを使用している場合、タイルコンテンツへの遷移にJavaScriptが使用されます。タイルコンテンツは下記の他の設定に従って、ブラウザにローカルに保存されます。チェックされていない場合、JavaScriptは使用されず、代わりにレガシーナビゲーションが使用されます。以下の他のJavaScript設定は無視されます。';
$string['usejseditingexpandcollapse'] = '編集モード - JavaScriptを使用してタイルを展開/折りたたむ';
$string['usejseditingexpandcollapse_desc'] = '選択されている場合、編集モードでは、教師はアニメーションのトランジションを使用して編集用のタイルを展開または折りたたむことができます。タイルのコンテンツは展開時に読み込まれるので、ページの再読み込みは必要ありません。';
$string['usejsnavforsinglesection'] = 'シングルセクションページでのJavaScriptナビゲーションの使用する';
$string['usejsnavforsinglesection_desc'] = 'チェックした場合、シングルセクションページ (&section=xx) の呼び出しは、古いスタイルのPHPシングルセクションページを呼び出すのではなく、JavaScriptを介して要求されたセクションを開くようにアニメーションしたコースメインページを起動することにより、JavaScriptを使用して処理されます。';
$string['usesubtilesseczero'] = 'トップセクションにサブタイルを使用する';
$string['usesubtilesseczero_help'] = '選択された場合、サブタイルはコースの最上部に使用され、すべてのタイル内にも使用されます。これはサブタイルがコースの最上部に多くのスペースを占めるためです。これを選択しないでおくと、トップセクションのアイテムは標準的なリスト形式で表示されます。';
$string['usetooltips'] = 'JavaScriptのツールチップを使用';
$string['usetooltips_desc'] = 'ユーザーが特定のアイテムにカーソルを置くと、JavaScriptのツールチップを使用する（例：完了ボックス、タイルの内容のタイル';
$string['width'] = '幅';
