<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'backup', language 'eu', version '4.2'.
 *
 * @package     backup
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['asyncbackupcomplete'] = 'Segurtasun-kopiaren prozesamendua amaitu da';
$string['asyncbackupcompletebutton'] = 'Jarraitu';
$string['asyncbackupcompletedetail'] = 'Segurtasun-kopiaren prozesamendua ondo amaitu da. <br/> Segurtasun-kopia <a href="{$a}">berreskuratze-orrian</a> aurkituko duzu.';
$string['asyncbackuperror'] = 'Segurtasun-kopiaren prozesamenduak huts egin du';
$string['asyncbackuperrordetail'] = 'Segurtasun-kopiaren prozesamenduak huts egin du. Jarri harremanetan zure gunearen kudeatzailearekin.';
$string['asyncbackuppending'] = 'Segurtasun-kopiaren prozesamendua zain dago';
$string['asyncbackupprocessing'] = 'Segurtasun-kopiaren prozesamendua martxan dago';
$string['asyncbadexecution'] = 'Segurtasun-kopiaren kontrolatzaile-exekuzio desegokia, {$a} da eta 2 izan beharko litzateke.';
$string['asynccheckprogress'] = '<a href="{$a}">Berreskuratze-orrian</a> aurrerapena edozein unetan ikus dezakezu.';
$string['asyncemailenable'] = 'Gaitu jakinarazpenak';
$string['asyncemailenabledetail'] = 'Gaituz gero, erabiltzaileek jakinarazpen bat jasoko dute berreskuratze edo kopia asinkronoa amaitutakoan.';
$string['asyncgeneralsettings'] = 'Segurtasun-kopia eta berreskuratze asinkronoa';
$string['asyncmessagebody'] = 'Jakinarazpena';
$string['asyncmessagebodydefault'] = '{backupid} IDa duen zure {operation} eragiketa ondo amaitu da. Hemen ikus dezakezu: <a href="{link}">{link}</a>.';
$string['asyncmessagebodydetail'] = 'Segurtasun-kopia eta berreskuratze asinkronoa amaitutakoan bidali beharreko jakinarazpena.';
$string['asyncmessagesubject'] = 'Gaia';
$string['asyncmessagesubjectdefault'] = 'Moodleko {operation} eragiketa ondo amaitu da';
$string['asyncmessagesubjectdetail'] = 'Jakinarazpenaren gaia';
$string['asyncnowait'] = 'Ez duzu zertan hemen itxaron, prozesamenduak atzeko planoan jarraituko du-eta.';
$string['asyncprocesspending'] = 'Prozesamenduaren zain';
$string['asyncrestorecomplete'] = 'Berreskuratze-prozesua amaitu da';
$string['asyncrestorecompletebutton'] = 'Jarraitu';
$string['asyncrestorecompletedetail'] = 'Berreskuratze-prozesua ondo amaitu da. Klikatuz gero, <a href="{$a}">berreskuratutako edukia dagokion ikastarora</a> joango zara.';
$string['asyncrestoreerror'] = 'Berreskuratze-prozesuak huts egin du';
$string['asyncrestoreerrordetail'] = 'Berreskuratze-prozesuak huts egin du. Jarri harremanetan zure kudeatzailearekin, mesedez.';
$string['asyncrestoreinprogress'] = 'Berreskuratzea martxan dago';
$string['asyncrestoreinprogress_help'] = 'Prozesuan dauden ikastaro-berreskuratze asinkronoak hemen erakusten dira.';
$string['asyncrestorepending'] = 'Berreskuratze-prozesamenduaren zain';
$string['asyncrestoreprocessing'] = 'Berreskuratze-prozesua martxan dago';
$string['asyncreturn'] = 'Itzuli ikastarora';
$string['autoactivedescription'] = 'Aukeratu segurtasun-kopia automatizatuak egitea edo ez. Eskuz aukeratuz gero segurtasun-kopia automatizatuak soilik komando-lerro bidezko script-en bitartez egin ahal izango dira. Hau komando lerroan eskuz egin daiteke edo cron-aren bitartez.';
$string['autoactivedisabled'] = 'Desgaituta';
$string['autoactiveenabled'] = 'Gaituta';
$string['autoactivemanual'] = 'Eskuz';
$string['automatedbackupschedule'] = 'Programazioa';
$string['automatedbackupschedulehelp'] = 'Erabaki asteko zein egunetan egingo diren segurtasun-kopia automatizatuak';
$string['automatedbackupsinactive'] = 'Gunearen kudeatzaileak ez ditu segurtasun-kopia automatizatuak gaitu';
$string['automatedbackupstatus'] = 'Segurtasun-kopia automatizatuen egoera';
$string['automateddeletedays'] = 'Ezabatu ondokoa baino zaharragoak diren segurtasun-kopiak';
$string['automatedmaxkept'] = 'Gehienez mantendu beharreko segurtasun-kopia kopurua';
$string['automatedmaxkepthelp'] = 'Honek ikastaro bakoitzetik gehienez gorde beharreko azken aldiko segurtasun-kopia automatizatu kopurua zehazten du. Zaharragoak diren segurtasun-kopiak automatikoki ezabatuko dira.';
$string['automatedminkept'] = 'Gutxienez mantendu beharreko segurtasun-kopia kopurua';
$string['automatedminkepthelp'] = 'Zehaztutako egun kopuru bat baino zaharragoak diren segurtasun-kopiak ezabatzen badira, aktibitaterik gabeko ikastaro bat segurtasun-kopiarik gabe geratzea gertatu daiteke. Hau ekiditeko, gutxienez mantendu beharreko segurtasun-kopia kopuru bat zehaztu daiteke.';
$string['automatedsettings'] = 'Segurtasun-kopia automatizatuen ezarpenak';
$string['automatedsetup'] = 'Segurtasun-kopia automatizatuak';
$string['automatedstorage'] = 'Segurtasun-kopia automatizatuen biltegia';
$string['automatedstoragehelp'] = 'Aukeratu non gordeko diren segurtasun-kopiak automatikoki sortzen direnean.';
$string['backupactivity'] = 'Jardueraren segurtasun-kopia:{$a}';
$string['backupautoactivitiesdescription'] = 'Modu lehenetsian jarduerak segurtasun-kopietan sartu ala ez zehazten du. Zakarrontziak ondo funtzionatu dezan ezarpen hau gaituta egon behar da';
$string['backupcourse'] = 'Ikastaroaren segurtasun-kopia:{$a}';
$string['backupcoursedetails'] = 'Ikastaroaren xehetasunak';
$string['backupcoursesection'] = 'Atala: {$a}';
$string['backupcoursesections'] = 'Ikastaroaren atalak';
$string['backupdate'] = 'Egikaritze-data';
$string['backupdetails'] = 'Segurtasun-kopiaren xehetasunak';
$string['backupdetailsnonstandardinfo'] = 'Aukeratutako fitxategia ez da Moodleko segurtasun-kopia fitxategi estandarra. Berreskuratze-prozesua segurtasun-fitxategi estandarra bihurtzen eta ondoren berreskuratzen saiatuko da.';
$string['backupformat'] = 'Formatua';
$string['backupformatimscc1'] = 'IMS Common Cartridge 1.0';
$string['backupformatimscc11'] = 'IMS Common Cartridge 1.1';
$string['backupformatmoodle1'] = 'Moodle 1';
$string['backupformatmoodle2'] = 'Moodle 2';
$string['backupformatunknown'] = 'Formatu ezezaguna';
$string['backuplog'] = 'Informazio teknikoa eta abisuak';
$string['backupmode'] = 'Modua';
$string['backupmode10'] = 'Orokorra';
$string['backupmode20'] = 'Inportatu';
$string['backupmode30'] = 'Bilgunea';
$string['backupmode40'] = 'Gune bera';
$string['backupmode50'] = 'Automatizatua';
$string['backupmode60'] = 'Bihurtuta';
$string['backupmode70'] = 'Asinkronoa';
$string['backupsection'] = 'Ikastaro-atalaren segurtasun-kopia:{$a}';
$string['backupsettings'] = 'Segurtasun-kopiaren ezarpenak';
$string['backupsitedetails'] = 'Gunearen xehetasunak';
$string['backupstage16action'] = 'Jarraitu';
$string['backupstage1action'] = 'Hurrengoa';
$string['backupstage2action'] = 'Hurrengoa';
$string['backupstage4action'] = 'Egin segurtasun-kopia';
$string['backupstage8action'] = 'Jarraitu';
$string['backuptype'] = 'Mota';
$string['backuptypeactivity'] = 'Jarduera';
$string['backuptypecourse'] = 'Ikastaroa';
$string['backuptypesection'] = 'Atala';
$string['backupversion'] = 'Segurtasun-kopiaren bertsioa';
$string['cannotfindassignablerole'] = 'Segurtasun-kopiaren fitxategiko {$a} rola ezin da lotu zuk eslei dezakezun inongo rolekin.';
$string['choosefilefromactivitybackup'] = 'Jardueren segurtasun-kopien eremua';
$string['choosefilefromactivitybackup_help'] = 'Jardueren segurtasun-kopia ezarpen lehenetsiak erabiliz egiten denean, kopiaren fitxategiak hemen gordeko dira.';
$string['choosefilefromautomatedbackup'] = 'Segurtasun-kopia automatizatuak';
$string['choosefilefromautomatedbackup_help'] = 'Segurtasun-kopia automatikoak ditu';
$string['choosefilefromcoursebackup'] = 'Ikastaroaren segurtasun-kopien eremua';
$string['choosefilefromcoursebackup_help'] = 'Ikastaro baten segurtasun-kopia ezarpen lehenetsiak erabiliz egiten denean, kopiaren fitxategiak hemen gordeko dira.';
$string['choosefilefromuserbackup'] = 'Erabiltzailearen segurtasun-kopietarako eremu pribatua';
$string['choosefilefromuserbackup_help'] = 'Ikastaroen segurtasun-kopiak anonimo bihurtutako erabiltzaileen informazioa duenean, segurtasun-kopien fitxategiak hemen gordeko dira.';
$string['config_keep_groups_and_groupings'] = 'Mantendu uneko taldeak eta talde-multzoak modu lehenetsian.';
$string['config_keep_roles_and_enrolments'] = 'Mantendu uneko rolak eta matrikulazioak modu lehenetsian.';
$string['config_overwrite_conf'] = 'Baimendu erabiltzaileak uneko ikastaroaren ezarpenak gainidaztea';
$string['config_overwrite_course_fullname'] = 'Gainidatzi ikastaroaren izen osoa segurtasun-kopian dagoenarekin modu lehenetsian. Ezarpen honek "Ikastaroaren ezarpenak gainidatzi" markatuta egotea eta uneko erabiltzaileak ikastaroaren izen osoa aldatzeko gaitasuna (moodle/course:changefullname) izatea behar du.';
$string['config_overwrite_course_shortname'] = 'Gainidatzi ikastaroaren izen laburra segurtasun-kopian dagoenarekin modu lehenetsian. Ezarpen honek "Ikastaroaren ezarpenak gainidatzi" markatuta egotea eta uneko erabiltzaileak ikastaroaren izen laburra aldatzeko gaitasuna (moodle/course:changeshortname) izatea behar du.';
$string['config_overwrite_course_startdate'] = 'Gainidatzi ikastaroaren hasiera- eta amaiera-data segurtasun-kopian dagoenarekin modu lehenetsian. Ezarpen honek "Ikastaroaren ezarpenak gainidatzi" markatuta egotea eta uneko erabiltzaileak berreskuratzean ikastaroaren datak aldatzeko gaitasuna (moodle/restore:rolldates) izatea behar du.';
$string['configgeneralactivities'] = 'Jarduerak segurtasun-kopietan sartzeko lehenetsitako balioa zehazten du.';
$string['configgeneralanonymize'] = 'Gaituz gero modu lehenetsian erabiltzaileei buruzko informazio guztia anonimo bihurtuko da.';
$string['configgeneralbadges'] = 'Dominak segurtasun-kopietan sartzeko lehenetsitako balioa zehazten du.';
$string['configgeneralblocks'] = 'Blokeak segurtasun-kopia batean sartzeko lehenetsitako balioa zehazten du.';
$string['configgeneralcalendarevents'] = 'Egutegiko ekitaldiak segurtasun-kopietan sartzeko lehenetsitako balioa zehazten du.';
$string['configgeneralcomments'] = 'Iruzkinak segurtasun-kopia batean sartzeko lehenetsitako balioa zehazten du.';
$string['configgeneralcompetencies'] = 'Konpetentziak segurtasun-kopietan sartzeko lehenetsitako balioa zehazten du.';
$string['configgeneralcontentbankcontent'] = 'Eduki-bankuko edukiak segurtasun-kopietan sartzeko lehenetsitako balioa zehazten du.';
$string['configgeneralfiles'] = 'Segurtasun-kopian fitxategiak modu lehenetsian sartzeko ezarpena. Mesedez kontuan izan hurrengoa: ezarpen hau desgaitzearen emaitza fitxategietarako erreferentziak baino ez dituen segurtasun-kopia bat izango da. Hau ez da arazo bat izango segurtasun-kopia gune berean berreskuratzen bada eta bitartean fitxategiak ez badira ezabatu \'Garbitu zakarrontziko fitxategiak\' (filescleanupperiod) ezarpenaren arabera.';
$string['configgeneralfilters'] = 'Iragazkiak segurtasun-kopia batean sartzeko lehenetsitako balioa zehazten du.';
$string['configgeneralgroups'] = 'Taldeak eta talde-multzoak segurtasun-kopietan sartzeko lehenetsitako balioa zehazten du.';
$string['configgeneralhistories'] = 'Erabiltzaileen historia jarduerak segurtasun-kopian sartzeko lehenetsitako balioa zehazten du.';
$string['configgenerallogs'] = 'Gaituz gero modu lehenetsian erregistroak sartuko dira segurtasun-kopietan.';
$string['configgeneralpermissions'] = 'Gaituz gero rolen baimenak inportatuko dira. Honek matrikulatutako erabiltzaileek aurretik dituzten baimenak baliogabetu ditzake.';
$string['configgeneralquestionbank'] = 'Gaituz gero galdera-bankua modu lehenetsian segurtasun-kopietan sartuko da. KONTUAN IZAN: ezarpen hau desgaituz gero galdera-bankua erabiltzen duten jardueren segurtasun-kopia ere desgaituko du, galdetegiarena esaterako.';
$string['configgeneralroleassignments'] = 'Gaituz gero, rol-esleipenak modu lehenetsian sartuko dira segurtasun-kopietan.';
$string['configgeneralusers'] = 'Erabiltzaileak segurtasun-kopietan sartzeko lehenetsitako balioa zehazten du.';
$string['configgeneraluserscompletion'] = 'Gaituz gero, erabiltzaileen osaketa-informazioa modu lehenetsian sartuko da segurtasun-kopietan.';
$string['configgeneralxapistate'] = 'Modu lehenetsian H5P jardueren antzeko erabiltzaileen edukiaren aurrerapen egoera segurtasun-kopietan sartu ala ez zehazten du.';
$string['configlegacyfiles'] = 'Zaharkitutako ikastaro-fitxategiak segurtasun-kopietan sartzeko lehenetsitako balioa zehazten du. Zaharkitutako ikastaro-fitxategiak Moodle 2.0 bertsioa baino lehenagokoak dira.';
$string['configloglifetime'] = 'Honek agerraldian mantendu beharreko erregistroen gehieneko epea zehazten du. Epe hau baino zaharragoak diren erregistroak automatikoki ezabatuko dira. Hemen balio txikia mantentzea gomendatzen da, agerraldietako informazioaren segurtasun-kopiak erraldoiak izan daitezkeelako.';
$string['configrestoreactivities'] = 'Jarduerak berreskuratzeko lehenetsitako balioa zehazten du.';
$string['configrestorebadges'] = 'Dominak berreskuratzeko lehenetsitako balioa zehazten du.';
$string['configrestoreblocks'] = 'Blokeak berreskuratzeko lehenetsitako balioa zehazten du.';
$string['configrestorecalendarevents'] = 'Egutegiko ekitaldiak berreskuratzeko lehenetsitako balioa zehazten du.';
$string['configrestorecomments'] = 'Iruzkinak berreskuratzeko lehenetsitako balioa zehazten du.';
$string['configrestorecompetencies'] = 'Konpetentziak berreskuratzeko lehenetsitako balioa zehazten du.';
$string['configrestorecontentbankcontent'] = 'Eduki-bankuko edukiak berreskuratzeko lehenetsitako balioa zehazten du.';
$string['configrestoreenrolments'] = 'Matrikulazio-metodoak berreskuratzeko lehenetsitako balioa zehazten du.';
$string['configrestorefilters'] = 'Iragazkiak berreskuratzeko lehenetsitako balioa zehazten du.';
$string['configrestoregroups'] = 'Taldeak eta talde-multzoak berreskuratzeko lehenetsitako balioa zehazten du, segurtasun-kopian egonez gero.';
$string['configrestorehistories'] = 'Erabiltzaileen historia berreskuratzean lehenetsitako balioa zehazten du, segurtasun-kopian egonez gero.';
$string['configrestorelogs'] = 'Gaituz gero agerraldiak modu lehenetsian berreskuratuko dira, segurtasun-kopian egonez gero.';
$string['configrestorepermissions'] = 'Gaituz gero rolen baimenak berreskuratuko dira. Honek matrikulatutako erabiltzaileek aurretik dituzten baimenak baliogabetu ditzake.';
$string['configrestoreroleassignments'] = 'Gaituz gero matrikulazioak modu lehenetsian berreskuratuko dira, segurtasun-kopian egonez gero.';
$string['configrestoreusers'] = 'Erabiltzaileak berreskuratzeko lehenetsitako balioa zehazten du, segurtasun-kopian egonez gero.';
$string['configrestoreuserscompletion'] = 'Gaituz gero erabiltzaileen osatze-informazioa modu lehenetsian berreskuratuko da, segurtasun-kopian egonez gero.';
$string['configrestorexapistate'] = 'H5P jardueren antzeko erabiltzaileen edukiaren aurrerapen egoera berreskuratzeko lehenetsitako balioa zehazten du.';
$string['confirmcancel'] = 'Bertan behera utzi segurtasun-kopia';
$string['confirmcancelimport'] = 'Utzi bertan behera inportazioa';
$string['confirmcancelno'] = 'Ez utzi bertan behera';
$string['confirmcancelquestion'] = 'Ziur zaude utzi egin nahi duzula? Sartu duzun informazio guztia galdu egingo da.';
$string['confirmcancelrestore'] = 'Utzi bertan behera berreskuratzea';
$string['confirmcancelyes'] = 'Bertan behera utzi segurtasun-kopia';
$string['confirmnewcoursecontinue'] = 'Ikastaro berriaren abisua';
$string['confirmnewcoursecontinuequestion'] = 'Behin-behinean (ezkutuan) dauden ikastaroak sortuko dira berreskuratze-prozesuan. Berreskuratzea bertan behera uzteko egin klik Utzi botoian. Ez itxi nabigatzailea berreskuratze-prozesuak iraun bitartean.';
$string['copiesinprogress'] = 'Ikastaro honek martxan dauden kopiak dauzka. <a href="{$a}">Ikusi martxan dauden kopiak.</a>';
$string['copycoursedesc'] = 'Ikastaro hau bikoiztuko da eta kopia aukeratutako ikastaro-kategorian kokatuko da.';
$string['copycourseheading'] = 'Kopiatu ikastaro bat';
$string['copycoursetitle'] = 'Kopiatu ikastaroa: {$a}';
$string['copydest'] = 'Helmuga';
$string['copyfieldnotfound'] = 'Ez dira aurkitu beharrezkoa diren datuak hurrengo eremuetan: {$a}';
$string['copyformfail'] = 'Ikastaro-kopiatzea formularioaren AJAX bidalketak huts egin du.';
$string['copyingcourse'] = 'Ikastaro-kopiatzea abian dago';
$string['copyingcourseshortname'] = 'kopiatzen';
$string['copyop'] = 'Oraingo eragiketa';
$string['copyprogressheading'] = 'Ikastaro-kopiatzeak martxan';
$string['copyprogressheading_help'] = 'Taula honek';
$string['copyprogresstitle'] = 'Ikastaro-kopiatzea martxan';
$string['copyreturn'] = 'Kopiatu eta itzuli';
$string['copysource'] = 'Jatorria';
$string['copyview'] = 'Kopiatu eta ikusi';
$string['coursecategory'] = 'Ikastaroa berreskuratzeko kategoria';
$string['courseid'] = 'Jatorrizko IDa';
$string['coursesettings'] = 'Ikastaroaren ezarpenak';
$string['coursetitle'] = 'Izenburua';
$string['currentstage1'] = 'Hasierako ezarpenak';
$string['currentstage16'] = 'Osatuta';
$string['currentstage2'] = 'Egituraren ezarpenak';
$string['currentstage4'] = 'Egiaztatu eta berrikusi';
$string['currentstage8'] = 'Egin segurtasun-kopia';
$string['enableasyncbackup'] = 'Gaitu segurtasun-kopia asinkronoak';
$string['enableasyncbackup_help'] = 'Gaituz gero, segurtasun-kopia eta berreskuratze-lanak era asinkronoan egingo dira. Honek erabiltzaile-esperientzia hobea eskaintzen du segurtasun-kopiak eta berreskuratzeak atzeko planoan egiten ari diren bitartean erabiltzaileek beste eragiketak egin ditzaten ahalbidetzen dute. Honek ez du eraginik inportazio eta esportazioetan.';
$string['enterasearch'] = 'Idatzi bilaketa bat';
$string['error_block_for_module_not_found'] = 'Bloke-instantzia umezurtza (id: {$a->bid}) aurkitu da (id: {$a->mid}) ikastaro-modulurako. Bloke hau ez da berreskuratuko';
$string['error_course_module_not_found'] = 'Ikastaro-modulu umezurtza (id: {$a})  aurkitu da. Modulu hau ez da segurtausn-kopian gehituko.';
$string['errorcopyingbackupfile'] = 'Errorea gertatu da segurtasun-kopia fitxategia aldi baterako karpetara kopiatzean berreskuratzea hasi aurretik.';
$string['errorfilenamemustbezip'] = 'Sartzen duzun fitxategiak ZIP motakoa izan behar du eta .mbz luzapena behar du izan';
$string['errorfilenamerequired'] = 'Fitxategi-izen egokia zehaztu behar duzu segurtasun-kopia honetarako';
$string['errorfilenametoolong'] = 'Fitxategi-izenaren luzera gehienez 255 karakterekoa izan behar da.';
$string['errorinvalidformat'] = 'Segurtasun-kopiaren formatu ezezaguna';
$string['errorinvalidformatinfo'] = 'Aukeratutako fitxategia ez da Moodlerako segurtasun-kopiaren fitxategi baliagarria eta ezin da berreskuratu.';
$string['errorminbackup20version'] = 'Segurtasun-kopiaren fitxategia hau Moodleren segutasun-kopiaren garapen ({$a->backup}) bertsioarekin sortu da segurtasun-kopiaren fitxategi hau. Gutxienez behar dena, berriz, hau da: {$a->min}. Ezin da, beraz, berreskuratu.';
$string['errorrestorefrontpagebackup'] = 'Hasiera-orrian hasiera-orriko segurtasun-kopiak baino ezin dira berreskuratu';
$string['executionsuccess'] = 'Zure segurtasun-kopiaren fitxategia egoki osatu da.';
$string['extractingbackupfileto'] = 'Segurtasun-kopiaren fitxategia hona erauzten: {$a}';
$string['failed'] = 'Segurtasun-kopiak huts egin du';
$string['filealiasesrestorefailures'] = 'Erroreak ezizenak berreskuratzean';
$string['filealiasesrestorefailures_help'] = 'Ezizen/estekak beste fitxategietarako esteka sinbolikoak dira, kanpo-biltegietan dauden fitxategietarakoak barne. Batzuetan, Moodlek ezin ditu berreskuratu - esaterako segurtasun-kopia beste gune batean berreskuratzean edo estekatutako fitxategia existitzen ez denean.

Errorearen arrazoi zehatzaren inguruko xehetasun gehiago berreskuratzearen log fitxategian topatuko dituzu.';
$string['filealiasesrestorefailures_link'] = 'restore/filealiases';
$string['filealiasesrestorefailuresinfo'] = 'Segurtasun-kopian sartutako ezizen/esteka batzuk ezin izan dira berreskuratu. Hurrengo zerrendan hauen esperotako kokapenak eta jatorrizko guneko fitxategiaren kokapena daude.';
$string['filename'] = 'Fitxategiaren izena';
$string['filereferencesincluded'] = 'Segurtasun kopian kanpo-edukietako fitxategi-erreferentziak daude. Hauek ez dute funtzionatuko segurtasun-kopia beste gune batean berreskuratuz gero.';
$string['filereferencesnotsamesite'] = 'Segurtasun-kopia beste gune batena da, fitxategi-erreferentziak ezin dira berreskuratu.';
$string['filereferencessamesite'] = 'Segurtasun-kopia gune honetakoa da, beraz fitxategi-erreferentziak berreskuratu daitezke.';
$string['generalactivities'] = 'Jarduerak eta baliabideak barne ditu';
$string['generalanonymize'] = 'Informazioa anonimo bihurtu';
$string['generalbackdefaults'] = 'Segurtasun-kopien lehenetsitako ezarpen orokorrak';
$string['generalbadges'] = 'Dominak barne ditu';
$string['generalblocks'] = 'Blokeak barne ditu';
$string['generalcalendarevents'] = 'Egutegiko ekitaldiak barne ditu';
$string['generalcomments'] = 'Iruzkinak barne ditu';
$string['generalcompetencies'] = 'Konpetentziak barne ditu';
$string['generalcontentbankcontent'] = 'Eduki-bankuko edukiak barne ditu';
$string['generalenrolments'] = 'Matrikulazio-metodoak barne ditu';
$string['generalfiles'] = 'Fitxategiak barne ditu';
$string['generalfilters'] = 'Iragazkiak barne ditu';
$string['generalgradehistories'] = 'Kalifikazio-historia barne du';
$string['generalgroups'] = 'Taldeak eta talde-multzoak barne ditu';
$string['generalhistories'] = 'Historiak barne ditu';
$string['generallegacyfiles'] = 'Zaharkitutako ikastaro-fitxategiak barne ditu';
$string['generallogs'] = 'Agerraldiak barne ditu';
$string['generalpermissions'] = 'Baliogabetutako baimenak barne ditu';
$string['generalquestionbank'] = 'Galdera-bankua barne du';
$string['generalrestoredefaults'] = 'Berreskuratzeko lehenetsitako balio orokorrak';
$string['generalrestoresettings'] = 'Berreskuratzeko ezarpen orokorrak';
$string['generalroleassignments'] = 'Rol-esleipenak barne ditu';
$string['generalsettings'] = 'Segurtasun-kopia orokorren ezarpenak';
$string['generalusers'] = 'Erabiltzaileak barne ditu';
$string['generaluserscompletion'] = 'Erabiltzaileen osaketa-informazioa barne du';
$string['generalxapistate'] = 'H5P jardueren antzeko erabiltzaileen edukiaren aurrerapen egoera barne du';
$string['hidetypes'] = 'Ezkutatu aukera motak';
$string['importbackupstage16action'] = 'Jarraitu';
$string['importbackupstage1action'] = 'Hurrengoa';
$string['importbackupstage2action'] = 'Hurrengoa';
$string['importbackupstage4action'] = 'Egin inportazioa';
$string['importbackupstage8action'] = 'Jarraitu';
$string['importcurrentstage0'] = 'Ikastaro-aukeraketa';
$string['importcurrentstage1'] = 'Hasierako ezarpenak';
$string['importcurrentstage16'] = 'Osatuta';
$string['importcurrentstage2'] = 'Egituraren ezarpenak';
$string['importcurrentstage4'] = 'Egiaztatu eta berrikusi';
$string['importcurrentstage8'] = 'Egin inportazioa';
$string['importfile'] = 'Inportatu segurtasun-kopiaren fitxategi bat';
$string['importgeneralduplicateadminallowed'] = 'Baimendu admin gatazkaren konponketa';
$string['importgeneralduplicateadminallowed_desc'] = 'Guneak \'admin\' erabiltzaile-izena duen kontua badauka, orduan \'admin\' erabiltzaile-izena duen segurtasun-kopia bat berreskuratzeak gatazka sor lezake. Aukera hau gaituz gero, gatazka konponduko da segurtasun-kopiako erabiltzaile-izena \'admin_xyz\'-ra aldatuta.';
$string['importgeneralmaxresults'] = 'Zerendatutako ikastaroen gehieneko kopurua inportatzeko';
$string['importgeneralmaxresults_desc'] = 'Honek inportatze-prozesuaren lehen urratsean zerrendaturiko ikastaro-kopurua zehazten du.';
$string['importgeneralsettings'] = 'Inportaziorako lehenetsitako ezarpenak';
$string['importrootsettings'] = 'Inportatu ezarpenak';
$string['importsettings'] = 'Inportatze-ezarpen orokorrak';
$string['importsuccess'] = 'Inportazioa osatu da. Egin klik jarraitu botoian ikastarora itzultzeko.';
$string['includeactivities'] = 'Barne du:';
$string['includeditems'] = 'Barne dituen elementuak:';
$string['includefilereferences'] = 'Fitxategien erreferentziak kanpoko edukietara';
$string['includesection'] = '{$a} atala';
$string['includeuserinfo'] = 'Erabiltzaileen datuak';
$string['inprogress'] = 'Segurtasun-kopia egiten ari da';
$string['jumptofinalstep'] = 'Jauzi egin azken urratsera';
$string['keep'] = 'Mantendu';
$string['keptroles'] = 'Rol-esleipenak barne ditu';
$string['keptroles_help'] = 'Aukeratutako rolak dituzten erabiltzaileak ikastaro berrian matrikulatuko dira. Erabiltzaile-datuak ez dira kopiatuko "Erabiltzaileen datuak barne ditu" markatuta ez badago.';
$string['locked'] = 'Blokeatuta';
$string['lockedbyconfig'] = 'Ezarpena blokeatuta dago segurtasun-kopiaren lehenetsitako ezarpenengatik.';
$string['lockedbyhierarchy'] = 'Mendekotasunek blokeatuta';
$string['lockedbypermission'] = 'Ez duzu nahikoa baimenik ezarpen hau aldatzeko.';
$string['loglifetime'] = 'Mantendu erregistroak tarte honetan:';
$string['managefiles'] = 'Kudeatu segurtasun-kopiaren fitxategiak';
$string['mergerestoredefaults'] = 'Lehenetsitako berreskuratze-balioak segurtasun-kopia ikastaro batera batzean';
$string['missingfilesinpool'] = 'Segurtasun-kopia egitean zenbait fitxategi ezin izan dira gorde, eta beraz ezin izango dira berreskuratu.';
$string['module'] = 'Modulua';
$string['moodleversion'] = 'Moodle bertsioa';
$string['morecoursesearchresults'] = '{$a} ikastaro baino gehiago aurkitu dira, lehenbiziko {$a} emaitza erakusten';
$string['moreresults'] = 'Emaitza gehiegi daude, zehaztu gehiago bilaketa.';
$string['nomatchingcourses'] = 'Ez dago erakusteko ikastarorik';
$string['norestoreoptions'] = 'Ez dago berreskuratzeko kategoriarik edo ikastarorik.';
$string['originalwwwroot'] = 'Segurtasun-kopiaren URLa';
$string['overwrite'] = 'Gainidatzi';
$string['pendingasyncdeletedetail'] = 'Ikastaro hau segurtasun-kopia asinkronoaren zain dago.<br/>Ikastaroak ezin dira ezabatu segurtasun-kopia egin arte.';
$string['pendingasyncdetail'] = 'Segurtasun-kopia asinkronoek erabiltzaile batek aldiko baliabide bakar baten kopia zain izatea ahalbidetzen dute.<br/>
Baliabide bereko kopia asinkrono anitz ezin dira itxaron-zerrendan jarri, horrek seguruenik eduki bereko segurtasun kopiak sortuko bailituzke.';
$string['pendingasyncedit'] = 'Ikastaro honen segurtasun-kopia edo kopia baten eskaera zain dago. Ez ezazu ikastaroa editatu segurtasun-kopia osatu arte, mesedez.';
$string['pendingasyncerror'] = 'Baliabide honetarako segurtasun-kopiaren zain';
$string['preparingdata'] = 'Datuak prestatzen';
$string['preparingui'] = 'Orria erakusteko prestatzen';
$string['previousstage'] = 'Aurrekoa';
$string['privacy:metadata:backup:detailsofarchive'] = 'Artxibo honek erabiltzaileekin lotutako datuak izan ditzake, hala nola kalifikazioak, erabiltzaile-matrikulazioak eta jardueretako datuak.';
$string['privacy:metadata:backup:externalpurpose'] = 'Artxibo honen helburua ikastaro batekin lotutako informazioa gordetzea da, etorkizunean berreskuratu ahal dena.';
$string['privacy:metadata:backup_controllers'] = 'Segurtasun-kopietarako eragiketen zerrenda';
$string['privacy:metadata:backup_controllers:itemid'] = 'Ikastaroaren IDa';
$string['privacy:metadata:backup_controllers:operation'] = 'Egindako ekintza, adibidez berreskuratu.';
$string['privacy:metadata:backup_controllers:timecreated'] = 'Ekintza sortu zeneko unea';
$string['privacy:metadata:backup_controllers:timemodified'] = 'Ekintza aldatu zeneko unea';
$string['privacy:metadata:backup_controllers:type'] = 'Maneiatutako elementu mota, adibidez jarduera.';
$string['qcategory2coursefallback'] = '"{$a->name}" izeneko galdera-kategoriak, jatorrian sistema/ikastaro-kategoria testuinguruan segurtasun-kopian, berreskuratzean ikastaro testuinguruan sortuko da.';
$string['qcategorycannotberestored'] = '"{$a->name}"  galdera-kategoria ezin da sortu berreskuratuta';
$string['question2coursefallback'] = '"{$a->name}" izeneko galdera-kategoriak, jatorrian sistema/ikastaro-kategoria testuinguruan segurtasun-kopian, berreskuratzean ikastaro testuinguruan sortuko da.';
$string['questioncannotberestored'] = '"{$a->name}" galderak ezin dira sortu berreskuratuta';
$string['recyclebin_desc'] = 'Kontuan izan ezarpen hauek zakarrontzian ere aplikatuko direla.';
$string['replacerestoredefaults'] = 'Lehenetsitako berreskuratze-balioak segurtasun-kopia ikastaro bateko edukiak ezabatu eta ondoren berreskuratzean';
$string['restoreactivity'] = 'Berreskuratu jarduera';
$string['restorecourse'] = 'Berreskuratu ikastaroa';
$string['restorecoursesettings'] = 'Ikastaroaren ezarpenak';
$string['restoredcourseid'] = 'Berreskuratutako ikastaroaren IDa: {$a}';
$string['restoreexecutionsuccess'] = 'Ikastaroa ondo berreskuratu da.';
$string['restorefileweremissing'] = 'Zenbait fitxategi ezin izan dira berreskuratu segurtasun-kopian ez zeudelako.';
$string['restorenewcoursefullname'] = 'Ikastaro berriaren izena';
$string['restorenewcourseshortname'] = 'Ikastaro berriaren izen laburra';
$string['restorenewcoursestartdate'] = 'Hasiera-data berria';
$string['restorerolemappings'] = 'Berreskuratu rolen loturak';
$string['restorerootsettings'] = 'Berreskuratzearen ezarpenak';
$string['restoresection'] = 'Berreskuratu atala';
$string['restorestage1'] = 'Baieztatu';
$string['restorestage16'] = 'Berrikusi';
$string['restorestage16action'] = 'Berreskuratu';
$string['restorestage1action'] = 'Hurrengoa';
$string['restorestage2'] = 'Helmuga';
$string['restorestage2action'] = 'Hurrengoa';
$string['restorestage32'] = 'Prozesua';
$string['restorestage32action'] = 'Jarraitu';
$string['restorestage4'] = 'Ezarpenak';
$string['restorestage4action'] = 'Hurrengoa';
$string['restorestage64'] = 'Osatuta';
$string['restorestage64action'] = 'Jarraitu';
$string['restorestage8'] = 'Eskema';
$string['restorestage8action'] = 'Hurrengoa';
$string['restoretarget'] = 'Berreskuratu helburua';
$string['restoretocourse'] = 'Berreskuratu ikastarora:';
$string['restoretocurrentcourse'] = 'Berreskuratu ikastaro honetan';
$string['restoretocurrentcourseadding'] = 'Batu segurtasun-kopia ikastaro honetara';
$string['restoretocurrentcoursedeleting'] = 'Ezabatu ikastaro honetako edukiak eta ondoren berreskuratu';
$string['restoretoexistingcourse'] = 'Berreskuratu aldez aurretik dagoen ikastaro batera';
$string['restoretoexistingcourseadding'] = 'Batu segurtasun-kopia lehendik dagoen ikastaro batera';
$string['restoretoexistingcoursedeleting'] = 'Ezabatu aldez aurretik dagoen ikastaro bateko edukiak eta ondoren berreskuratu.';
$string['restoretonewcourse'] = 'Berreskuratu ikastaro berri gisa';
$string['restoringcourse'] = 'Ikastaro-berreskuraketa martxan da';
$string['restoringcourseshortname'] = 'berreskuratzen';
$string['rootenrolmanual'] = 'Berreskuratu eskuzko matrikulazio gisa.';
$string['rootsettingactivities'] = 'Jarduerak eta baliabideak barne ditu';
$string['rootsettinganonymize'] = 'Anonimo bihurtu erabiltzaileen informazioa';
$string['rootsettingbadges'] = 'Dominak barne ditu';
$string['rootsettingblocks'] = 'Blokeak barne ditu';
$string['rootsettingcalendarevents'] = 'Egutegiko ekitaldiak barne ditu';
$string['rootsettingcomments'] = 'Iruzkinak barne ditu';
$string['rootsettingcompetencies'] = 'Konpetentziak barne ditu';
$string['rootsettingcontentbankcontent'] = 'Eduki-bankuko edukiak barne ditu';
$string['rootsettingcustomfield'] = 'Eremu pertsonalizatuak barne ditu';
$string['rootsettingenrolments'] = 'Matrikulazio-metodoak barne ditu';
$string['rootsettingenrolments_always'] = 'Bai, beti';
$string['rootsettingenrolments_never'] = 'Ez, berreskuratu erabiltzaileak eskuzko matrikulazio gisa';
$string['rootsettingenrolments_withusers'] = 'Bai, baina soilik erabiltzaileak baditu.';
$string['rootsettingfiles'] = 'Fitxategiak barne ditu';
$string['rootsettingfilters'] = 'Iragazkiak barne ditu';
$string['rootsettinggradehistories'] = 'Kalifikazio-historia barne du';
$string['rootsettinggroups'] = 'Taldeak eta talde-multzoak barne ditu';
$string['rootsettingimscc1'] = 'Bihurtu IMS Common Cartridge 1.0-ra';
$string['rootsettingimscc11'] = 'Bihurtu IMS Common Cartridge 1.1-era';
$string['rootsettinglegacyfiles'] = 'Zaharkitutako ikastaro-fitxategiak barne ditu';
$string['rootsettinglogs'] = 'Ikastaroaren agerraldiak barne ditu';
$string['rootsettingpermissions'] = 'Baliogabetutako baimenak barne ditu';
$string['rootsettingquestionbank'] = 'Galdera-bankua barne du';
$string['rootsettingroleassignments'] = 'Erabiltzaileen rol-esleipenak barne ditu';
$string['rootsettings'] = 'Segurtasun-kopiaren ezarpenak';
$string['rootsettingusers'] = 'Matrikulatutako erabiltzaileak barne ditu';
$string['rootsettinguserscompletion'] = 'Erabiltzaileen osaketa-xehetasunak barne ditu';
$string['rootsettingxapistate'] = 'H5P jardueren antzeko erabiltzaileen edukiaren aurrerapen egoera barne du';
$string['samesitenotification'] = 'Segurtasun-kopia fitxategietarako erreferentziekin sortu zen, eta ez fitxategiekin. Berreskurapenak gune honetan soilik egin daiteke.';
$string['sectionactivities'] = 'Jarduerak';
$string['sectioninc'] = 'Segurtasun-kopian sartua (erabiltzaileen informaziorik gabe)';
$string['sectionincanduser'] = 'Segurtasun-kopian sartua erabiltzaileen informazioarekin';
$string['selectacategory'] = 'Aukeratu kategoria bat';
$string['selectacourse'] = 'Aukeratu ikastaro bat';
$string['setting_course_fullname'] = 'Ikastaroaren izena';
$string['setting_course_shortname'] = 'Ikastaroaren izen laburra';
$string['setting_course_startdate'] = 'Ikastaroaren hasiera-data';
$string['setting_keep_groups_and_groupings'] = 'Mantendu orain taldeak eta talde-multzoak';
$string['setting_keep_roles_and_enrolments'] = 'Mantendu oraingo rolak eta matrikulazioak';
$string['setting_overwrite_conf'] = 'Gainidatzi ikastaroaren ezarpenak';
$string['setting_overwrite_course_fullname'] = 'Gainidatzi ikastaroaren izen osoa';
$string['setting_overwrite_course_shortname'] = 'Gainidatzi ikastaroaren izen laburra';
$string['setting_overwrite_course_startdate'] = 'Gainidatzi ikastaroaren hasiera-data';
$string['showtypes'] = 'Erakutsi aukera motak';
$string['sitecourseformatwarning'] = 'Hau hasiera-orriko segurtasun-kopia bat da, soilik hasiera-orrian berreskuratu daiteke.';
$string['skiphidden'] = 'Utzi alde batera ezkutuan dauden ikastaroak';
$string['skiphiddenhelp'] = 'Aukeratu ezkutuan dauden ikastaroak alde batera uztea edo ez';
$string['skipmodifdays'] = 'Utzi alde batera orain dela gutxi aldatu ez diren ikastaroak';
$string['skipmodifdayshelp'] = 'Aukeratu azken egun-kopuru horretan aldatu ez diren ikastaroak alde batera uztea edo ez';
$string['skipmodifprev'] = 'Utzi alde batera aurreko segurtasun-kopiatik aldatu ez diren ikastaroak';
$string['skipmodifprevhelp'] = 'Aukeratu aurreko programatutako segurtasun-kopiatik aldatu ez diren ikastaroak alde batera uztea edo ez. honek erregistroa gaituta egotea behar du.';
$string['status'] = 'Egoera';
$string['storagecourseandexternal'] = 'Ikastaroko segurtasun-kopien fitxategi-eremua eta direktorio espezifikoa';
$string['storagecourseonly'] = 'Ikastaroko segurtasun-kopien fitxategi-eremua';
$string['storageexternalonly'] = 'Zehaztu direktorio bat segurtasun-kopia automatizatuetarako';
$string['successful'] = 'Segurtasun kopia arrakastatsua';
$string['successfulcopy'] = 'Kopia ondo egin da';
$string['successfulrestore'] = 'Berreskuratze arrakastatsua';
$string['timetaken'] = 'Hartutako denbora';
$string['title'] = 'Izenburua';
$string['totalcategorysearchresults'] = 'Kategoriak denera: {$a}';
$string['totalcoursesearchresults'] = 'Ikastaroak denera: {$a}';
$string['undefinedrolemapping'] = 'Rolen lotura zehaztugabea \'{$a}\' arketiporako';
$string['unnamedsection'] = 'Izenik gabeko atala';
$string['userdata'] = 'Erabiltzaileen datuak barne ditu';
$string['userdata_help'] = 'Gaituz gero, foroetako mezuak, zereginetako bidalketak eta antzeko datuak ikastaro berrira kopiatuko dira "Rol-esleipenak barne ditu" zerrendan aukeratutako rola duen edozein erabiltzaileentzat.';
$string['userinfo'] = 'Erabiltzailearen informazioa';
