<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'editor_tinymce', language 'hu', version '4.2'.
 *
 * @package     editor_tinymce
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['advanced:address'] = 'Cím';
$string['advanced:anchor_delta_height'] = '0';
$string['advanced:anchor_delta_width'] = '0';
$string['advanced:anchor_desc'] = 'Horgony beszúrása/szerkesztése';
$string['advanced:backcolor_desc'] = 'Háttérszín kiválasztása';
$string['advanced:block'] = 'Forma';
$string['advanced:blockquote'] = 'Idézőjel';
$string['advanced:blockquote_desc'] = 'Idézőjel';
$string['advanced:bold_desc'] = 'Vastag (Ctrl+B)';
$string['advanced:bullist_desc'] = 'Listajeles felsorolás beszúrása/törlése';
$string['advanced:charmap_delta_height'] = '0';
$string['advanced:charmap_delta_width'] = '0';
$string['advanced:charmap_desc'] = 'Egyedi karakter beszúrása';
$string['advanced:cleanup_desc'] = 'Kódtisztítás';
$string['advanced:clipboard_msg'] = 'Mozilla és Firefox esetén nem használható a másolás/kivágás/beillesztés.
Szeretne erről további információkat?';
$string['advanced:code'] = 'Kód';
$string['advanced:code_desc'] = 'HTML-forrásszöveg szerkesztése';
$string['advanced:colorpicker_delta_height'] = '0';
$string['advanced:colorpicker_delta_width'] = '0';
$string['advanced:copy_desc'] = 'Másolás';
$string['advanced:custom1_desc'] = 'Egyedi leírása kerül ide';
$string['advanced:cut_desc'] = 'Kivágás';
$string['advanced:dd'] = 'Definíció leírása';
$string['advanced:div'] = 'Div';
$string['advanced:dt'] = 'Definíciós terminus';
$string['advanced:font_size'] = 'Fontméret';
$string['advanced:fontdefault'] = 'Fontcsalád';
$string['advanced:forecolor_desc'] = 'Szöveg színének kiválasztása';
$string['advanced:h1'] = '1. címsor';
$string['advanced:h2'] = '2. címsor';
$string['advanced:h3'] = '3. címsor';
$string['advanced:h4'] = '4. címsor';
$string['advanced:h5'] = '5. címsor';
$string['advanced:h6'] = '6. címsor';
$string['advanced:help_desc'] = 'Súgó';
$string['advanced:help_shortcut'] = 'Nyomjon ALT-F10-et az eszköztárhoz, ALT-0-t a súgóhoz.';
$string['advanced:hr_desc'] = 'Vízszintes vonal beszúrása';
$string['advanced:image_delta_height'] = '0';
$string['advanced:image_delta_width'] = '0';
$string['advanced:image_desc'] = 'Kép beszúrása/szerkesztése';
$string['advanced:image_props_desc'] = 'Kép tulajdonságai';
$string['advanced:indent_desc'] = 'Behúzás';
$string['advanced:italic_desc'] = 'Dőlt (Ctrl+I)';
$string['advanced:justifycenter_desc'] = 'Középre igazítás';
$string['advanced:justifyfull_desc'] = 'Sorkizárt';
$string['advanced:justifyleft_desc'] = 'Balra igazítás';
$string['advanced:justifyright_desc'] = 'Jobbra igazítás';
$string['advanced:link_delta_height'] = '0';
$string['advanced:link_delta_width'] = '0';
$string['advanced:link_desc'] = 'Hivatkozás beillesztése/szerkesztése';
$string['advanced:more_colors'] = 'További színek';
$string['advanced:newdocument'] = 'Biztosan törli a tartalmat?';
$string['advanced:newdocument_desc'] = 'Új dokumentum';
$string['advanced:numlist_desc'] = 'Számozott felsorolás beszúrása/törlése';
$string['advanced:outdent_desc'] = 'Behúzás csökkentése';
$string['advanced:paragraph'] = 'Bekezdés';
$string['advanced:paste_desc'] = 'Beillesztés';
$string['advanced:path'] = 'Útvonal';
$string['advanced:pre'] = 'Előre formázott';
$string['advanced:redo_desc'] = 'Ismétlés (Ctrl+Y)';
$string['advanced:removeformat_desc'] = 'Formázás eltávolítása';
$string['advanced:rich_text_area'] = 'Rich Text terület';
$string['advanced:samp'] = 'Kódminta';
$string['advanced:shortcuts_desc'] = 'Súgó a kisegítő lehetőségekhez';
$string['advanced:striketrough_desc'] = 'Áthúzott';
$string['advanced:style_select'] = 'Stílusok';
$string['advanced:sub_desc'] = 'Alsó index';
$string['advanced:sup_desc'] = 'Felső index';
$string['advanced:toolbar'] = 'Eszköztár';
$string['advanced:toolbar_focus'] = 'Ugrás az eszköztár gombjaihoz - Alt+Q, ugrás a szerkesztőhöz - Alt-Z, ugrás az elem útvonalához - Alt-X.';
$string['advanced:underline_desc'] = 'Aláhúzott (Ctrl+U)';
$string['advanced:undo_desc'] = 'Visszavonás (Ctrl+Z)';
$string['advanced:unlink_desc'] = 'Hivatkozás törlése';
$string['advanced:visualaid_desc'] = 'Vezető/láthatatlan elemek ki-be kapcsolása';
$string['advanced_dlg:'] = '';
$string['advanced_dlg:about_author'] = 'Szerző';
$string['advanced_dlg:about_general'] = 'Névjegy';
$string['advanced_dlg:about_help'] = 'Súgó';
$string['advanced_dlg:about_license'] = 'Engedély';
$string['advanced_dlg:about_loaded'] = 'Beépülő segédprogramok';
$string['advanced_dlg:about_plugin'] = 'Beépülő segédprogram';
$string['advanced_dlg:about_plugins'] = 'Beépülő segédprogramok';
$string['advanced_dlg:about_title'] = 'A TinyMCE névjegye';
$string['advanced_dlg:about_version'] = 'Verzió';
$string['advanced_dlg:accessibility_help'] = 'Súgó a kisegítő lehetőségekhez';
$string['advanced_dlg:accessibility_usage_title'] = 'Általános használat';
$string['advanced_dlg:anchor_invalid'] = 'Adjon meg egy érvényes horgonynevet.';
$string['advanced_dlg:anchor_name'] = 'Horgony neve';
$string['advanced_dlg:anchor_title'] = 'Horgony beszúrása/szerkesztése';
$string['advanced_dlg:charmap_title'] = 'Egyedi karakter kiválasztása';
$string['advanced_dlg:charmap_usage'] = 'A navigáláshoz használja a nyilakat.';
$string['advanced_dlg:code_title'] = 'HTML-forrás szerkesztője';
$string['advanced_dlg:code_wordwrap'] = 'Sortörés';
$string['advanced_dlg:colorpicker_color'] = 'Szín:';
$string['advanced_dlg:colorpicker_name'] = 'Név:';
$string['advanced_dlg:colorpicker_named_tab'] = 'Névvel ellátott';
$string['advanced_dlg:colorpicker_named_title'] = 'Névvel ellátott színek';
$string['advanced_dlg:colorpicker_palette_tab'] = 'Paletta';
$string['advanced_dlg:colorpicker_palette_title'] = 'Paletta színei';
$string['advanced_dlg:colorpicker_picker_tab'] = 'Választó';
$string['advanced_dlg:colorpicker_picker_title'] = 'Színválasztó';
$string['advanced_dlg:colorpicker_title'] = 'Szín kiválasztása';
$string['advanced_dlg:image_align'] = 'Igazítás';
$string['advanced_dlg:image_align_baseline'] = 'Alapvonalhoz';
$string['advanced_dlg:image_align_bottom'] = 'Alulra';
$string['advanced_dlg:image_align_left'] = 'Balra';
$string['advanced_dlg:image_align_middle'] = 'Középre';
$string['advanced_dlg:image_align_right'] = 'Jobbra';
$string['advanced_dlg:image_align_textbottom'] = 'Szöveg aljához';
$string['advanced_dlg:image_align_texttop'] = 'Szöveg tetejéhez';
$string['advanced_dlg:image_align_top'] = 'Felülre';
$string['advanced_dlg:image_alt'] = 'Kép leírása';
$string['advanced_dlg:image_border'] = 'Szegély';
$string['advanced_dlg:image_dimensions'] = 'Méretek';
$string['advanced_dlg:image_hspace'] = 'Vízszintes térköz';
$string['advanced_dlg:image_list'] = 'Képek listája';
$string['advanced_dlg:image_src'] = 'Képwebcíe';
$string['advanced_dlg:image_title'] = 'Kép beszúrása/szerkesztése';
$string['advanced_dlg:image_vspace'] = 'Függőleges térköz';
$string['advanced_dlg:invalid_color_value'] = 'Érvénytelen színérték';
$string['advanced_dlg:link_is_email'] = 'A megadott webcím e-mail-címnek látszik, hozzáadja a szükséges mailto: előtagot?';
$string['advanced_dlg:link_is_external'] = 'A megadott webcím külső hivatkozásnak látszik, hozzáadja a szükséges http:// előtagot?';
$string['advanced_dlg:link_list'] = 'Hivatkozások listája';
$string['advanced_dlg:link_target'] = 'Cél';
$string['advanced_dlg:link_target_blank'] = 'Hivatkozás megnyitása új ablakban';
$string['advanced_dlg:link_target_same'] = 'Hivatkozás megnyitása ugyanabban az ablakban';
$string['advanced_dlg:link_title'] = 'Hivatkozás beszúrása/szerkesztése';
$string['advanced_dlg:link_titlefield'] = 'Cím';
$string['advanced_dlg:link_url'] = 'Hivatkozás webcímre';
$string['advhr:advhr_desc'] = 'Vízszintes vonal beszúrása';
$string['advhr:delta_height'] = '0';
$string['advhr:delta_width'] = '0';
$string['advhr_dlg:normal'] = 'Normál';
$string['advhr_dlg:noshade'] = 'Nincs árnyékolás';
$string['advhr_dlg:size'] = 'Magasság';
$string['advhr_dlg:width'] = 'Szélesség';
$string['advhr_dlg:widthunits'] = 'Egység';
$string['advimage:delta_height'] = '0';
$string['advimage:delta_width'] = '0';
$string['advimage:image_desc'] = 'Kép beszúrása/szerkesztése';
$string['advimage_dlg:align'] = 'Igazítás';
$string['advimage_dlg:align_baseline'] = 'Alapvonalhoz';
$string['advimage_dlg:align_bottom'] = 'Alulra';
$string['advimage_dlg:align_left'] = 'Balra';
$string['advimage_dlg:align_middle'] = 'Középre';
$string['advimage_dlg:align_right'] = 'Jobbra';
$string['advimage_dlg:align_textbottom'] = 'Szöveg aljához';
$string['advimage_dlg:align_texttop'] = 'Szöveg tetejéhez';
$string['advimage_dlg:align_top'] = 'Felülre';
$string['advimage_dlg:alt'] = 'Kép leírása';
$string['advimage_dlg:alt_image'] = 'Alternatív kép';
$string['advimage_dlg:border'] = 'Szegély';
$string['advimage_dlg:classes'] = 'Osztályok';
$string['advimage_dlg:constrain_proportions'] = 'Aránytartás';
$string['advimage_dlg:dialog_title'] = 'Kép beszúrása/szerkesztése';
$string['advimage_dlg:dimensions'] = 'Méretek';
$string['advimage_dlg:example_img'] = 'Kép előnézete';
$string['advimage_dlg:general'] = 'Általános';
$string['advimage_dlg:height'] = 'Magasság';
$string['advimage_dlg:hspace'] = 'Vízszintes térköz';
$string['advimage_dlg:id'] = 'Azonosító';
$string['advimage_dlg:image_list'] = 'Képek listája';
$string['advimage_dlg:langcode'] = 'Nyelvkód';
$string['advimage_dlg:langdir'] = 'Írásirány';
$string['advimage_dlg:list'] = 'Képek listája';
$string['advimage_dlg:long_desc'] = 'Hosszú leírású hivatkozás';
$string['advimage_dlg:ltr'] = 'Balról jobbra';
$string['advimage_dlg:map'] = 'Részekre osztott kép';
$string['advimage_dlg:misc'] = 'Egyéb';
$string['advimage_dlg:missing_alt'] = 'Biztosan kihagyja a képleírást? Enélkül a fogyatékkal élők vagy a szöveges, esetleg a kikapcsolt képmegjelenítéssel működő böngészőt használók számára a kép elérhetetlen lesz.';
$string['advimage_dlg:mouseout'] = 'egér elhúzása esetén';
$string['advimage_dlg:mouseover'] = 'egér föléhúzása esetén';
$string['advimage_dlg:preview'] = 'Előnézet';
$string['advimage_dlg:rtl'] = 'Jobbról balra';
$string['advimage_dlg:src'] = 'Kép webcíme';
$string['advimage_dlg:style'] = 'Stílus';
$string['advimage_dlg:swap_image'] = 'Képek felcserélése';
$string['advimage_dlg:tab_advanced'] = 'Részletes';
$string['advimage_dlg:tab_appearance'] = 'Megjelenés';
$string['advimage_dlg:tab_general'] = 'Általános';
$string['advimage_dlg:title'] = 'Cím';
$string['advimage_dlg:vspace'] = 'Függőleges térköz';
$string['advimage_dlg:width'] = 'Szélesség';
$string['advlink:delta_height'] = '0';
$string['advlink:delta_width'] = '0';
$string['advlink:link_desc'] = 'Hivatkozás beszúrása/szerkesztése';
$string['advlink_dlg:accesskey'] = 'Gyorsbillentyű';
$string['advlink_dlg:advanced_props'] = 'Részletes tulajdonságok';
$string['advlink_dlg:advanced_tab'] = 'Részletes';
$string['advlink_dlg:anchor_names'] = 'Horgonyok';
$string['advlink_dlg:classes'] = 'Osztályok';
$string['advlink_dlg:encoding'] = 'Célnyelvi karakterkódolás';
$string['advlink_dlg:event_props'] = 'Események';
$string['advlink_dlg:events_tab'] = 'Események';
$string['advlink_dlg:general_props'] = 'Általános tulajdonságok';
$string['advlink_dlg:general_tab'] = 'Általános';
$string['advlink_dlg:height'] = 'Magasság';
$string['advlink_dlg:id'] = 'Azonosító';
$string['advlink_dlg:is_email'] = 'A megadott webcím e-mail-címnek látszik, hozzáadja a szükséges mailto: előtagot?';
$string['advlink_dlg:is_external'] = 'A megadott webcím külső hivatkozásnak látszik, hozzáadja a szükséges http:// előtagot?';
$string['advlink_dlg:langcode'] = 'Nyelvkód';
$string['advlink_dlg:langdir'] = 'Írásirány';
$string['advlink_dlg:link_list'] = 'Hivatkozások listája';
$string['advlink_dlg:list'] = 'Hivatkozások listája';
$string['advlink_dlg:ltr'] = 'Balról jobbra';
$string['advlink_dlg:mime'] = 'A cél MIME-típusa';
$string['advlink_dlg:popup'] = 'Javascript előugró ablak';
$string['advlink_dlg:popup_dependent'] = 'Függő (csak Mozilla/Firefox)';
$string['advlink_dlg:popup_location'] = 'Helysáv megjelenítése';
$string['advlink_dlg:popup_menubar'] = 'Menüsáv megjelenítése';
$string['advlink_dlg:popup_name'] = 'Ablak neve';
$string['advlink_dlg:popup_opts'] = 'Lehetőségek';
$string['advlink_dlg:popup_position'] = 'Pozíció (X/Y)';
$string['advlink_dlg:popup_props'] = 'Előugró ablak tulajdonságai';
$string['advlink_dlg:popup_resizable'] = 'Átméretezhető ablak';
$string['advlink_dlg:popup_return'] = '\'return false\' beszúrása';
$string['advlink_dlg:popup_scrollbars'] = 'Görgetősávok megjelenítése';
$string['advlink_dlg:popup_size'] = 'Méret';
$string['advlink_dlg:popup_statusbar'] = 'Állapotsor megjelenítése';
$string['advlink_dlg:popup_tab'] = 'Előugró ablak';
$string['advlink_dlg:popup_toolbar'] = 'Eszközsávok megjelenítése';
$string['advlink_dlg:popup_url'] = 'Előugró ablak webcíme';
$string['advlink_dlg:rel'] = 'Oldal és cél kapcsolata';
$string['advlink_dlg:rev'] = 'Cél és az oldal kapcsolata';
$string['advlink_dlg:rtl'] = 'Jobbról balra';
$string['advlink_dlg:style'] = 'Stílus';
$string['advlink_dlg:tabindex'] = 'Tabulátorok sorrendje';
$string['advlink_dlg:target'] = 'Cél';
$string['advlink_dlg:target_blank'] = 'Megjelenítés új ablakban';
$string['advlink_dlg:target_langcode'] = 'Célnyelv';
$string['advlink_dlg:target_name'] = 'Célnyelvi név';
$string['advlink_dlg:target_parent'] = 'Megjelenítés szülőablakban/-keretben';
$string['advlink_dlg:target_same'] = 'Megjelenítés ebben az ablakban/keretben';
$string['advlink_dlg:target_top'] = 'Megjelenítés a fölső keretben (felváltja az összes keretet)';
$string['advlink_dlg:title'] = 'Hivatkozás beszúrása/szerkesztése';
$string['advlink_dlg:titlefield'] = 'Cím';
$string['advlink_dlg:url'] = 'Hivatkozás webcíme';
$string['advlink_dlg:width'] = 'Szélesség';
$string['advlist:circle'] = 'Üres kör';
$string['advlist:def'] = 'Alapbeállítás';
$string['advlist:disc'] = 'Teli kör';
$string['advlist:lower_alpha'] = 'Kisbetűs';
$string['advlist:lower_greek'] = 'Görög kisbetűs';
$string['advlist:lower_roman'] = 'Latin kisbetűs';
$string['advlist:square'] = 'Teli négyzet';
$string['advlist:types'] = 'Típusok';
$string['advlist:upper_alpha'] = 'Nagybetűs';
$string['advlist:upper_roman'] = 'Latin nagybetűs';
$string['aria:rich_text_area'] = 'Rich Text terület';
$string['autosave:restore_content'] = 'Automatikusan mentett tartalom visszaállítása.';
$string['autosave:unload_msg'] = 'A végrehajtott változások az oldal elhagyásakor elvesznek.';
$string['autosave:warning_message'] = 'A mentett tartalom visszaállításakor a szerkesztőben pillanatnyilag tárolt tartalom elvész.
Biztosan visszaállítja a mentett tartalmat? ';
$string['availablebuttons'] = 'Elérhető gombok';
$string['colors:000000'] = 'Fekete';
$string['colors:000080'] = 'Tengerészkék';
$string['colors:0000FF'] = 'Kék';
$string['colors:003300'] = 'Sötétzöld';
$string['colors:003366'] = 'Sötét égszínkék';
$string['colors:008000'] = 'Zöld';
$string['colors:008080'] = 'Pávakék';
$string['colors:00CCFF'] = 'Égszínkék';
$string['colors:00FF00'] = 'Borostyán';
$string['colors:00FFFF'] = 'Vízszínű';
$string['colors:333300'] = 'Sötét olajzöld';
$string['colors:333333'] = 'Mély sötétszürke';
$string['colors:333399'] = 'Indigókék';
$string['colors:3366FF'] = 'Királykék';
$string['colors:339966'] = 'Tengerzöld';
$string['colors:33CCCC'] = 'Türkiz';
$string['colors:666699'] = 'Szürkéskék';
$string['colors:800000'] = 'Gesztenyebarna';
$string['colors:800080'] = 'Bíborszín';
$string['colors:808000'] = 'Olívazöld';
$string['colors:808080'] = 'Szürke';
$string['colors:993300'] = 'Sötétnarancs';
$string['colors:993366'] = 'Barna';
$string['colors:999999'] = 'Középszürke';
$string['colors:99CC00'] = 'Sárgászöld';
$string['colors:99CCFF'] = 'Világos égszínkék';
$string['colors:C0C0C0'] = 'Ezüst';
$string['colors:CC99FF'] = 'Szilvakék';
$string['colors:CCFFCC'] = 'Halványzöld';
$string['colors:CCFFFF'] = 'Halvány ciánkék';
$string['colors:FF0000'] = 'Piros';
$string['colors:FF00FF'] = 'Bíbor';
$string['colors:FF6600'] = 'Narancs';
$string['colors:FF9900'] = 'Borostyán';
$string['colors:FF99CC'] = 'Rózsaszín';
$string['colors:FFCC00'] = 'Arany';
$string['colors:FFCC99'] = 'Barack';
$string['colors:FFFF00'] = 'Sárga';
$string['colors:FFFF99'] = 'Világossárga';
$string['colors:FFFFFF'] = 'Fehér';
$string['common:apply'] = 'Alkalmaz';
$string['common:browse'] = 'Böngészés';
$string['common:cancel'] = 'Mégse';
$string['common:class_name'] = 'Osztály';
$string['common:clipboard_msg'] = 'A másolás/kivágás/beillesztés Mozilla és Firefox esetén nem használható. Szeretne erről bővebben olvasni?';
$string['common:clipboard_no_support'] = 'Jelenleg böngészője nem támogatja, használja helyette a billentyűzetet.';
$string['common:close'] = 'Bezárás';
$string['common:edit_confirm'] = 'A szövegdobozhoz WYSIWYG-módot kíván használni?';
$string['common:insert'] = 'Beillesztés';
$string['common:invalid_data'] = 'Hiba: érvénytelen értékeket adott meg, ezek piros színben láthatók.';
$string['common:invalid_data_min'] = 'A(z) {#field} száma nagyobb legyen, mint {#min}';
$string['common:invalid_data_number'] = 'A(z) {#field} szám legyen!';
$string['common:invalid_data_size'] = 'A(z) {#field} szám vagy százalék legyen!';
$string['common:more_colors'] = 'További színek...';
$string['common:not_set'] = '-- Nincs beállítva --';
$string['common:popup_blocked'] = 'Az előugró ablakok blokkolása miatt ki van kapcsolva az alkalmazáshoz szükséges ablak. Az eszköz használatához ki kell kapcsolnia az előugró ablakok blokkolását.';
$string['common:update'] = 'Frissítés';
$string['common:value'] = '(érték)';
$string['contextmenu:align'] = 'Igazítás';
$string['contextmenu:center'] = 'Középre';
$string['contextmenu:full'] = 'Sorkizárás';
$string['contextmenu:left'] = 'Balra';
$string['contextmenu:right'] = 'Jobbra';
$string['customconfig'] = 'Egyéni beállítás';
$string['customconfig_desc'] = 'Egyéni részletes TinyMCE beállítás JSON-formában, pl. {"option1" : "value2", "option2" : "value2"}. Az itteni beállítások felülírják a standard és a segédprogramokhoz kapcsolódó beállításokat.';
$string['customtoolbar'] = 'Szerkesztő eszköztára';
$string['customtoolbar_desc'] = 'Minden sor vesszővel elválasztott gombneveket tartalmaz. A "wrap" választja el a csoportokat, az üres sorokat a rendszer kihagyja. A TinyMCE alapvető gombjainak felsorolását lásd: <a href="{$a}" target="_blank">{$a}</a>. Az első sor mindig megjelenik, a második és harmadik eszközsor láthatósága ki-be kapcsolható.';
$string['directionality:ltr_desc'] = 'Szövegirány balról jobbra';
$string['directionality:rtl_desc'] = 'Szövegirány jobbról balra';
$string['emotions:delta_height'] = '';
$string['emotions:delta_width'] = '';
$string['emotions:emotions_desc'] = 'Hangulatjelek';
$string['emotions_dlg:cool'] = 'Klassz';
$string['emotions_dlg:cry'] = 'Sírás';
$string['emotions_dlg:desc'] = 'Hangulatjelek';
$string['emotions_dlg:embarassed'] = 'Zavarban';
$string['emotions_dlg:foot_in_mouth'] = 'Savanyú';
$string['emotions_dlg:frown'] = 'Rosszallás';
$string['emotions_dlg:innocent'] = 'Ártatlan';
$string['emotions_dlg:kiss'] = 'Csók';
$string['emotions_dlg:laughing'] = 'Nevetés';
$string['emotions_dlg:money_mouth'] = 'Pénzéhes';
$string['emotions_dlg:sealed'] = 'Titoktartás';
$string['emotions_dlg:smile'] = 'Mosoly';
$string['emotions_dlg:surprised'] = 'Meglepődés';
$string['emotions_dlg:title'] = 'Hangulatjel beszúrása';
$string['emotions_dlg:tongue_out'] = 'Nyelvöltés';
$string['emotions_dlg:undecided'] = 'Határozatlanság';
$string['emotions_dlg:usage'] = 'Navigálás nyilakkal.';
$string['emotions_dlg:wink'] = 'Kacsintás';
$string['emotions_dlg:yell'] = 'Üvöltés';
$string['fontselectlist'] = 'Használható fontok felsorolása';
$string['fullpage:delta_height'] = '';
$string['fullpage:delta_width'] = '';
$string['fullpage:desc'] = 'Dokumentum tulajdonságai';
$string['fullpage_dlg:active_color'] = 'Aktív szín';
$string['fullpage_dlg:add'] = 'Új elem hozzáadása';
$string['fullpage_dlg:add_base'] = 'Alapelem';
$string['fullpage_dlg:add_comment'] = 'Megjegyzési csomópont';
$string['fullpage_dlg:add_link'] = 'Hivatkozáselem';
$string['fullpage_dlg:add_meta'] = 'Metaelem';
$string['fullpage_dlg:add_script'] = 'Programkód-elem';
$string['fullpage_dlg:add_style'] = 'Stíluselem';
$string['fullpage_dlg:add_title'] = 'Címelem';
$string['fullpage_dlg:advanced_props'] = 'Részletes';
$string['fullpage_dlg:advanced_tab'] = 'Részletes';
$string['fullpage_dlg:appearance_bgprops'] = 'Háttér tulajdonságai';
$string['fullpage_dlg:appearance_linkprops'] = 'Hivatkozás színei';
$string['fullpage_dlg:appearance_marginprops'] = 'Törzsrész margói';
$string['fullpage_dlg:appearance_style'] = 'Stíluslap és stílus tulajdonságai';
$string['fullpage_dlg:appearance_tab'] = 'Megjelenés';
$string['fullpage_dlg:appearance_textprops'] = 'Szöveg tulajdonságai';
$string['fullpage_dlg:author'] = 'Szerző';
$string['fullpage_dlg:base_element'] = 'Alapelem';
$string['fullpage_dlg:bgcolor'] = 'Háttérszín';
$string['fullpage_dlg:bgimage'] = 'Háttérkép';
$string['fullpage_dlg:bottom_margin'] = 'Alsó margó';
$string['fullpage_dlg:charset'] = 'Karakterkészlet';
$string['fullpage_dlg:comment_element'] = 'Megjegyzés';
$string['fullpage_dlg:content'] = 'Tartalom';
$string['fullpage_dlg:copyright'] = 'Szerzői jog';
$string['fullpage_dlg:defer'] = 'Elhalaszt';
$string['fullpage_dlg:doctypes'] = 'Dokumentumtípus';
$string['fullpage_dlg:encoding'] = 'karakterkódolás';
$string['fullpage_dlg:font_face'] = 'Betűtípus';
$string['fullpage_dlg:font_size'] = 'Betűméret';
$string['fullpage_dlg:fontface'] = 'Betűcsalád';
$string['fullpage_dlg:fontsize'] = 'Betűméret';
$string['fullpage_dlg:general_props'] = 'Általános';
$string['fullpage_dlg:head_elements'] = 'Fejrész elemei';
$string['fullpage_dlg:hover_color'] = 'Fókusz színe';
$string['fullpage_dlg:href'] = 'HREF';
$string['fullpage_dlg:hreflang'] = 'HREF nyelve';
$string['fullpage_dlg:info'] = 'Információ';
$string['fullpage_dlg:langcode'] = 'Nyelvkód';
$string['fullpage_dlg:langdir'] = 'Írásirány';
$string['fullpage_dlg:langprops'] = 'Nyelv és kódolás';
$string['fullpage_dlg:language'] = 'Nyelv';
$string['fullpage_dlg:left_margin'] = 'Bal margó';
$string['fullpage_dlg:link_color'] = 'Hivatkozás színe';
$string['fullpage_dlg:link_element'] = 'Hivatkozáselem';
$string['fullpage_dlg:ltr'] = 'Balról jobbra';
$string['fullpage_dlg:media'] = 'Média';
$string['fullpage_dlg:meta_description'] = 'Leírás';
$string['fullpage_dlg:meta_element'] = 'Metaelem';
$string['fullpage_dlg:meta_index_follow'] = 'Indexel és követi a hivatkozásokat';
$string['fullpage_dlg:meta_index_nofollow'] = 'Indexel, de nem követi a hivatkozásokat';
$string['fullpage_dlg:meta_keywords'] = 'Kulcsszavak';
$string['fullpage_dlg:meta_noindex_follow'] = 'Nem indexel, de követi a hivatkozásokat';
$string['fullpage_dlg:meta_noindex_nofollow'] = 'Nem indexel és nem követi a hivatkozásokat';
$string['fullpage_dlg:meta_props'] = 'Metainformáció';
$string['fullpage_dlg:meta_robots'] = 'Robotok';
$string['fullpage_dlg:meta_tab'] = 'Általános';
$string['fullpage_dlg:meta_title'] = 'Cím';
$string['fullpage_dlg:movedown'] = 'Kijelölt elem mozgatása lefelé';
$string['fullpage_dlg:moveup'] = 'Kijelölt elem mozgatása felfelé';
$string['fullpage_dlg:name'] = 'Név';
$string['fullpage_dlg:properties'] = 'Tulajdonságok';
$string['fullpage_dlg:rel'] = 'Viszony';
$string['fullpage_dlg:remove'] = 'Kijelölt elem eltávolítása';
$string['fullpage_dlg:rev'] = 'Fordított viszony';
$string['fullpage_dlg:right_margin'] = 'Jobb margó';
$string['fullpage_dlg:rtl'] = 'Jobbról balra';
$string['fullpage_dlg:script_element'] = 'Programkód-elem';
$string['fullpage_dlg:src'] = 'Forrás';
$string['fullpage_dlg:style'] = 'Stílus';
$string['fullpage_dlg:style_element'] = 'Stíluselem';
$string['fullpage_dlg:stylesheet'] = 'Stíluslap';
$string['fullpage_dlg:target'] = 'Cél';
$string['fullpage_dlg:text_color'] = 'Szövegszín';
$string['fullpage_dlg:textcolor'] = 'Szín';
$string['fullpage_dlg:title'] = 'Dokumentum tulajdonságai';
$string['fullpage_dlg:title_element'] = 'Címelem';
$string['fullpage_dlg:top_margin'] = 'Felső margó';
$string['fullpage_dlg:type'] = 'Típus';
$string['fullpage_dlg:value'] = 'Érték';
$string['fullpage_dlg:visited_color'] = 'Felkeresés utáni szín';
$string['fullpage_dlg:xml_pi'] = 'XML-deklaráció';
$string['fullscreen:desc'] = 'Teljes képernyős üzemmód ki-/bekapcsolása';
$string['iespell:download'] = 'Nem észlelhető az ieSpell. Telepíti most?';
$string['iespell:iespell_desc'] = 'Helyesírás ellenőrzése';
$string['insertdatetime:date_fmt'] = '%Y-%m-%d';
$string['insertdatetime:day_long'] = 'vasárnap,hétfő,kedd,szerda,csütörtök,péntek,szombat,vasárnap';
$string['insertdatetime:day_short'] = 'v,h,k,sze,cs,p,szo,v';
$string['insertdatetime:insertdate_desc'] = 'Dátum beszúrása';
$string['insertdatetime:inserttime_desc'] = 'Időpont beszúrása';
$string['insertdatetime:months_long'] = 'január,február,március,április,május,június,július,augusztus,szeptember,október,november,december';
$string['insertdatetime:months_short'] = 'jan,feb,már,ápr,máj,jún,júl,aug,szep,okt,nov,dec';
$string['insertdatetime:time_fmt'] = '%H:%M:%S';
$string['layer:absolute_desc'] = 'Abszolút elhelyezés ki-/bekapcsolása';
$string['layer:backward_desc'] = 'Mozgatás hátra';
$string['layer:content'] = 'Új réteg...';
$string['layer:forward_desc'] = 'Mozgatás előre';
$string['layer:insertlayer_desc'] = 'Új réteg beszúrása';
$string['media:delta_height'] = '0';
$string['media:delta_width'] = '0';
$string['media:desc'] = 'Beágyazott média beszúrása/szerkesztése';
$string['media:edit'] = 'Beágyazott média szerkesztése';
$string['media_dlg:advanced'] = 'Részletes';
$string['media_dlg:align'] = 'Igazítás';
$string['media_dlg:align_bottom'] = 'Lent';
$string['media_dlg:align_bottom_left'] = 'Balra lent';
$string['media_dlg:align_bottom_right'] = 'Jobbra lent';
$string['media_dlg:align_center'] = 'Középre';
$string['media_dlg:align_left'] = 'Balra';
$string['media_dlg:align_right'] = 'Jobbra';
$string['media_dlg:align_top'] = 'Fent';
$string['media_dlg:align_top_left'] = 'Balra fent';
$string['media_dlg:align_top_right'] = 'Jobbra fent';
$string['media_dlg:altsource1'] = '1. alternatív forrás';
$string['media_dlg:altsource2'] = '2. alternatív forrás';
$string['media_dlg:audio'] = 'HTML5 audio';
$string['media_dlg:autogotourl'] = 'Automatikus webcímre ugrás';
$string['media_dlg:autohref'] = 'Automatikus HREF';
$string['media_dlg:autostart'] = 'Automatikus kezdés';
$string['media_dlg:balance'] = 'Színkiegyenlítés';
$string['media_dlg:base'] = 'Alap';
$string['media_dlg:baseurl'] = 'Alap URL';
$string['media_dlg:bgcolor'] = 'Háttér';
$string['media_dlg:cache'] = 'Gyorsítótár';
$string['media_dlg:captioningid'] = 'Felirat-azonosító';
$string['media_dlg:center'] = 'Középre';
$string['media_dlg:class_name'] = 'Osztály';
$string['media_dlg:console'] = 'Konzol';
$string['media_dlg:constrain_proportions'] = 'Aránytartás';
$string['media_dlg:controller'] = 'Vezérlő';
$string['media_dlg:controls'] = 'Vezérlőelemek';
$string['media_dlg:correction'] = 'Nincs javítás';
$string['media_dlg:currentmarker'] = 'Aktuális jelölő';
$string['media_dlg:currentposition'] = 'Aktuális pozíció';
$string['media_dlg:defaultframe'] = 'Alapkeret';
$string['media_dlg:embedded_audio_options'] = 'Beágyazott audiofájl beállításai';
$string['media_dlg:embeddedaudio'] = 'Beágyazott audiofájl';
$string['media_dlg:enabled'] = 'Bekapcsolva';
$string['media_dlg:enablejavascript'] = 'JavaScript bekapcsolása';
$string['media_dlg:endtime'] = 'Befejezési idő';
$string['media_dlg:file'] = 'Fájl/URL';
$string['media_dlg:flash'] = 'Flash';
$string['media_dlg:flash_options'] = 'Flash beállításai';
$string['media_dlg:flashvars'] = 'Flash változói';
$string['media_dlg:fullscreen'] = 'Teljes képernyő';
$string['media_dlg:general'] = 'Általános';
$string['media_dlg:hidden'] = 'Rejtett';
$string['media_dlg:href'] = 'HREF';
$string['media_dlg:hspace'] = 'Vízszintes távolság';
$string['media_dlg:html5_audio_options'] = 'Audiofájl beállításai';
$string['media_dlg:html5_video_options'] = 'HTML5 video beállításai';
$string['media_dlg:id'] = 'Azonosító';
$string['media_dlg:iframe'] = 'Iframe';
$string['media_dlg:imagestatus'] = 'Kép állapota';
$string['media_dlg:invokeurls'] = 'Webcímek bekapcsolása';
$string['media_dlg:kioskmode'] = 'Kioszk mód';
$string['media_dlg:list'] = 'Lista';
$string['media_dlg:liveconnect'] = 'SWLiveConnect';
$string['media_dlg:loop'] = 'Hurok';
$string['media_dlg:maintainaspect'] = 'Aránytartás';
$string['media_dlg:menu'] = 'Menü kijelzése';
$string['media_dlg:mute'] = 'Elnémítás';
$string['media_dlg:name'] = 'Név';
$string['media_dlg:nojava'] = 'Nincs Java';
$string['media_dlg:numloop'] = 'Hurokszám';
$string['media_dlg:play'] = 'Automatikus lejátszás';
$string['media_dlg:playcount'] = 'Lejátszások száma';
$string['media_dlg:playeveryframe'] = 'Minden keret lejátszása';
$string['media_dlg:poster'] = 'Poszter';
$string['media_dlg:prefetch'] = 'Előtöltés';
$string['media_dlg:preload'] = 'Előzetes betöltés';
$string['media_dlg:preload_auto'] = 'A felhasználó böngészője dönti el';
$string['media_dlg:preload_metadata'] = 'Videó időzített eseményeinek előtöltése';
$string['media_dlg:preload_none'] = 'Ne legyen előzetes betöltés';
$string['media_dlg:preview'] = 'Előnézet';
$string['media_dlg:progress'] = 'Folyamat';
$string['media_dlg:qt_options'] = 'QuickTime beállításai';
$string['media_dlg:qt_stream_warn'] = 'A folyamatosan továbbított rtsp-tananyagokat a Részletes fülön a QT forrásmezőhöz kell hozzáadni. Egy nem folyamatosan továbbított verziót is hozzá kell adnia a forrásmezőhöz.';
$string['media_dlg:qtsrc'] = 'QT-forrás';
$string['media_dlg:qtsrcchokespeed'] = 'Fojtás sebessége';
$string['media_dlg:quality'] = 'Minőség';
$string['media_dlg:quicktime'] = 'QuickTime';
$string['media_dlg:rate'] = 'Sebesség';
$string['media_dlg:realmedia'] = 'Real Media';
$string['media_dlg:rmp_options'] = 'A real media lejátszó beállításai';
$string['media_dlg:salign'] = 'S-igazítás';
$string['media_dlg:scale'] = 'Nagyítás';
$string['media_dlg:scriptcallbacks'] = 'Programkód-visszahívások';
$string['media_dlg:shockwave'] = 'Shockwave';
$string['media_dlg:shockwave_options'] = 'Shockwave beállításai';
$string['media_dlg:shuffle'] = 'Összekeverés';
$string['media_dlg:size'] = 'Méretek';
$string['media_dlg:sound'] = 'Hang';
$string['media_dlg:source'] = 'Forrás';
$string['media_dlg:starttime'] = 'Kezdési idő';
$string['media_dlg:stretchtofit'] = 'Méretre nyújtás';
$string['media_dlg:swstretchhalign'] = 'Vízszintes igazítás nyújtással';
$string['media_dlg:swstretchstyle'] = 'Nyújtás stílusa';
$string['media_dlg:swstretchvalign'] = 'Függőleges igazítás nyújtással';
$string['media_dlg:target'] = 'Cél';
$string['media_dlg:targetcache'] = 'Célgyorsítótár';
$string['media_dlg:title'] = 'Beágyazott média beillesztése/szerkesztése';
$string['media_dlg:type'] = 'Típus';
$string['media_dlg:uimode'] = 'Felhasználói felület üzemmód';
$string['media_dlg:video'] = 'HTML5 video';
$string['media_dlg:volume'] = 'Hangerő';
$string['media_dlg:vspace'] = 'Függőleges távolság';
$string['media_dlg:windowlessvideo'] = 'Ablak nélküli videó';
$string['media_dlg:windowsmedia'] = 'Windows Media';
$string['media_dlg:wmode'] = 'W-mód';
$string['media_dlg:wmp_options'] = 'A Windows Media Player beállításai';
$string['nonbreaking:nonbreaking_desc'] = 'Nem törő szóköz beszúrása';
$string['pagebreak:desc'] = 'Oldaltörés beszúrása nyomtatáshoz';
$string['paste:paste_text_desc'] = 'Beillesztés egyszerű szövegként';
$string['paste:paste_word_desc'] = 'Beillesztés Wordből';
$string['paste:plaintext_mode'] = 'A beillesztés most egyszerű szövegként működik. A szokásos beillesztési módra újabb kattintással válthat vissza. Beillesztés után visszatér a  szokásos beillesztési módhoz.';
$string['paste:plaintext_mode_stick'] = 'A beillesztés most szöveges. Kattintson ismét a szokásos beillesztés visszaállításához.';
$string['paste:selectall_desc'] = 'Mind kiválasztása';
$string['paste_dlg:text_linebreaks'] = 'Sortörések megtartása';
$string['paste_dlg:text_title'] = 'Szöveg ablakba illesztése CTRL+V-vel';
$string['paste_dlg:word_title'] = 'Szöveg ablakba illesztése CTRL+V-vel';
$string['pluginname'] = 'TinyMCE HTML-szerkesztő';
$string['preview:preview_desc'] = 'Előnézet';
$string['print:print_desc'] = 'Nyomtatás';
$string['privacy:metadata'] = 'A TinyMCE HTML editor segédprogram semmilyen személyes adatot nem tárol.';
$string['save:cancel_desc'] = 'Az összes módosítás elvetése';
$string['save:save_desc'] = 'Mentés';
$string['searchreplace:delta_height'] = '0';
$string['searchreplace:delta_width'] = '0';
$string['searchreplace:replace_desc'] = 'Keresés/Csere';
$string['searchreplace:search_desc'] = 'Keresés';
$string['searchreplace_dlg:allreplaced'] = 'A keresett kifejezés összes előfordulása kicserélve.';
$string['searchreplace_dlg:direction'] = 'Irány';
$string['searchreplace_dlg:down'] = 'Lefelé';
$string['searchreplace_dlg:findnext'] = 'Következő keresése';
$string['searchreplace_dlg:findwhat'] = 'Keresendő';
$string['searchreplace_dlg:mcase'] = 'Kis-/nagybetű különbözik';
$string['searchreplace_dlg:notfound'] = 'A keresés véget ért. A keresett kifejezés nem található.';
$string['searchreplace_dlg:replace'] = 'Csere';
$string['searchreplace_dlg:replace_title'] = 'Keresés/Csere';
$string['searchreplace_dlg:replaceall'] = 'Az összes cseréje';
$string['searchreplace_dlg:replacewith'] = 'Mire cseréli';
$string['searchreplace_dlg:search_title'] = 'Keresés';
$string['searchreplace_dlg:searchnext_desc'] = 'Keresés ismét';
$string['searchreplace_dlg:up'] = 'Felfelé';
$string['settings'] = 'Általános beállítások';
$string['simple:bold_desc'] = 'Vastag (Ctrl+B)';
$string['simple:bullist_desc'] = 'Felsorolás beszúrása/törlése';
$string['simple:cleanup_desc'] = 'Kódtisztítás';
$string['simple:italic_desc'] = 'Dőlt (Ctrl+I)';
$string['simple:numlist_desc'] = 'Számozott felsorolás beszúrása/törlése';
$string['simple:redo_desc'] = 'Mégis (Ctrl+Y)';
$string['simple:striketrough_desc'] = 'Áthúzott';
$string['simple:underline_desc'] = 'Aláhúzás (Ctrl+U)';
$string['simple:undo_desc'] = 'Visszavonás (Ctrl+Z)';
$string['spellchecker:desc'] = 'Helyesírás-ellenőrző ki-/bekapcsolása';
$string['spellchecker:ignore_word'] = 'Szó kihagyása';
$string['spellchecker:ignore_words'] = 'Mind kihagyása';
$string['spellchecker:langs'] = 'Nyelvek';
$string['spellchecker:learn_word'] = 'Szó felvétele';
$string['spellchecker:menu'] = 'Helyesírás-ellenőrző beállításai';
$string['spellchecker:no_mpell'] = 'Nincs betűtévesztés.';
$string['spellchecker:no_sug'] = 'Nincs javaslat';
$string['spellchecker:sug'] = 'Javaslatok';
$string['spellchecker:wait'] = 'Várjon...';
$string['style:delta_height'] = '0';
$string['style:delta_width'] = '0';
$string['style:desc'] = 'CSS-stílus szerkesztése';
$string['style_dlg:apply'] = 'Alkalmaz';
$string['style_dlg:background'] = 'Háttér';
$string['style_dlg:background_attachment'] = 'Csatolmány';
$string['style_dlg:background_color'] = 'Háttérszín';
$string['style_dlg:background_hpos'] = 'Vízszintes pozíció';
$string['style_dlg:background_image'] = 'Háttérkép';
$string['style_dlg:background_repeat'] = 'Ismétlés';
$string['style_dlg:background_tab'] = 'Háttér';
$string['style_dlg:background_vpos'] = 'Függőleges pozíció';
$string['style_dlg:block'] = 'Blokk';
$string['style_dlg:block_display'] = 'Megjelenítés';
$string['style_dlg:block_letterspacing'] = 'Betűköz';
$string['style_dlg:block_tab'] = 'Tömb';
$string['style_dlg:block_text_align'] = 'Szöveg igazítása';
$string['style_dlg:block_text_indent'] = 'Szöveg behúzása';
$string['style_dlg:block_vertical_alignment'] = 'Függőleges igazítás';
$string['style_dlg:block_whitespace'] = 'Elválasztó karakter';
$string['style_dlg:block_wordspacing'] = 'Szavak közötti távolság';
$string['style_dlg:border'] = 'Szegély';
$string['style_dlg:border_tab'] = 'Szegély';
$string['style_dlg:bottom'] = 'Alul';
$string['style_dlg:box'] = 'Négyzet';
$string['style_dlg:box_clear'] = 'Törlés';
$string['style_dlg:box_float'] = 'Lebegés';
$string['style_dlg:box_height'] = 'Magasság';
$string['style_dlg:box_tab'] = 'Doboz';
$string['style_dlg:box_width'] = 'Szélesség';
$string['style_dlg:bullet_image'] = 'Felsoroláshoz használt kép';
$string['style_dlg:clip'] = 'Klip';
$string['style_dlg:color'] = 'Szín';
$string['style_dlg:height'] = 'Magasság';
$string['style_dlg:left'] = 'Bal';
$string['style_dlg:list'] = 'Lista';
$string['style_dlg:list_tab'] = 'Lista';
$string['style_dlg:list_type'] = 'Típus';
$string['style_dlg:margin'] = 'Margó';
$string['style_dlg:overflow'] = 'Kifutás';
$string['style_dlg:padding'] = 'Belső köz';
$string['style_dlg:placement'] = 'Elhelyezés';
$string['style_dlg:position'] = 'Pozíció';
$string['style_dlg:positioning_tab'] = 'Pozicionálás';
$string['style_dlg:positioning_type'] = 'Típus';
$string['style_dlg:right'] = 'Jobb';
$string['style_dlg:same'] = 'Mindegyik esetén ugyanaz';
$string['style_dlg:style'] = 'Stílus';
$string['style_dlg:text'] = 'Szöveg';
$string['style_dlg:text_blink'] = 'Villogás';
$string['style_dlg:text_case'] = 'Kis-/nagybetű';
$string['style_dlg:text_color'] = 'Szín';
$string['style_dlg:text_decoration'] = 'Díszítés';
$string['style_dlg:text_font'] = 'Betűtípus';
$string['style_dlg:text_lineheight'] = 'Sormagasság';
$string['style_dlg:text_none'] = 'Egyik sem';
$string['style_dlg:text_overline'] = 'Fölülhúzás';
$string['style_dlg:text_props'] = 'Szöveg';
$string['style_dlg:text_size'] = 'Méret';
$string['style_dlg:text_striketrough'] = 'Áthúzott';
$string['style_dlg:text_style'] = 'Stílus';
$string['style_dlg:text_tab'] = 'Szöveg';
$string['style_dlg:text_underline'] = 'Aláhúzott';
$string['style_dlg:text_variant'] = 'Változat';
$string['style_dlg:text_weight'] = 'Súly';
$string['style_dlg:title'] = 'CSS-stílus szerkesztése';
$string['style_dlg:toggle_insert_span'] = 'A kijelölésnél átnyúlás beszúrása';
$string['style_dlg:top'] = 'Fent';
$string['style_dlg:visibility'] = 'Láthatóság';
$string['style_dlg:width'] = 'Szélesség';
$string['style_dlg:zindex'] = 'Z-index';
$string['subplugintype_tinymce'] = 'Segédprogram';
$string['subplugintype_tinymce_plural'] = 'Segédprogramok';
$string['table:cell'] = 'Cella';
$string['table:cell_desc'] = 'Táblázat cellájának tulajdonságai';
$string['table:cellprops_delta_height'] = '0';
$string['table:cellprops_delta_width'] = '0';
$string['table:col'] = 'Oszlop';
$string['table:col_after_desc'] = 'Oszlop alá';
$string['table:col_before_desc'] = 'Oszlop fölé';
$string['table:copy_row_desc'] = 'Táblázat sorának másolása';
$string['table:cut_row_desc'] = 'Táblázat sorának kivágása';
$string['table:del'] = 'Táblázat törlése';
$string['table:delete_col_desc'] = 'Oszlop törlése';
$string['table:delete_row_desc'] = 'Sor törlése';
$string['table:desc'] = 'Új táblázat beszúrása/szerkesztése';
$string['table:merge_cells_delta_height'] = '0';
$string['table:merge_cells_delta_width'] = '0';
$string['table:merge_cells_desc'] = 'Táblázat celláinak egyesítése';
$string['table:paste_row_after_desc'] = 'Táblázat sorának beszúrása alá';
$string['table:paste_row_before_desc'] = 'Táblázat sorának beszúrása fölé';
$string['table:props_desc'] = 'Táblázat tulajdonságai';
$string['table:row'] = 'Sor';
$string['table:row_after_desc'] = 'Sor beszúrása alá';
$string['table:row_before_desc'] = 'Sor beszúrása fölé';
$string['table:row_desc'] = 'Táblázat sorának tulajdonságai';
$string['table:rowprops_delta_height'] = '0';
$string['table:rowprops_delta_width'] = '0';
$string['table:split_cells_desc'] = 'Táblázat egyesített celláinak felosztása';
$string['table:table_delta_height'] = '0';
$string['table:table_delta_width'] = '0';
$string['table_dlg:advanced_props'] = 'Részletes tulajdonságok';
$string['table_dlg:advanced_tab'] = 'Részletes';
$string['table_dlg:align'] = 'Igazítás';
$string['table_dlg:align_bottom'] = 'Alulra';
$string['table_dlg:align_default'] = 'Alapbeállítás';
$string['table_dlg:align_left'] = 'Balra';
$string['table_dlg:align_middle'] = 'Középre';
$string['table_dlg:align_right'] = 'Jobbra';
$string['table_dlg:align_top'] = 'Felülre';
$string['table_dlg:bgcolor'] = 'Háttérszín';
$string['table_dlg:bgimage'] = 'Háttérkép';
$string['table_dlg:border'] = 'Keret';
$string['table_dlg:bordercolor'] = 'Keretszín';
$string['table_dlg:caption'] = 'Táblázat felirata';
$string['table_dlg:cell_all'] = 'Táblázat összes cellájának frissítése';
$string['table_dlg:cell_cell'] = 'Aktuális cella frissítése';
$string['table_dlg:cell_col'] = 'Az oszlop összes cellájának frissítése';
$string['table_dlg:cell_limit'] = 'Túllépte a megengedett {$cells} cellaszámot.';
$string['table_dlg:cell_row'] = 'A sor összes cellájának frissítése';
$string['table_dlg:cell_title'] = 'Táblázat celláinak tulajdonságai';
$string['table_dlg:cell_type'] = 'Cella típusa';
$string['table_dlg:cellpadding'] = 'Cellaköz';
$string['table_dlg:cellspacing'] = 'Cellatávolság';
$string['table_dlg:col_limit'] = 'Túllépte a megengedett {$cols} oszlopszámot.';
$string['table_dlg:colgroup'] = 'Oszlopcsoport';
$string['table_dlg:cols'] = 'Oszlop';
$string['table_dlg:frame'] = 'keret';
$string['table_dlg:frame_all'] = 'mind';
$string['table_dlg:frame_cols'] = 'oszlop';
$string['table_dlg:frame_groups'] = 'csoport';
$string['table_dlg:frame_none'] = 'egy sem';
$string['table_dlg:frame_rows'] = 'sor';
$string['table_dlg:general_props'] = 'Általános tulajdonságok';
$string['table_dlg:general_tab'] = 'Általános';
$string['table_dlg:height'] = 'magasság';
$string['table_dlg:id'] = 'Azonosító';
$string['table_dlg:langcode'] = 'Nyelvkód';
$string['table_dlg:langdir'] = 'Írásirány';
$string['table_dlg:ltr'] = 'Balról jobbra';
$string['table_dlg:merge_cells_title'] = 'Táblázat celláinak egyesítése';
$string['table_dlg:mime'] = 'Cél MIME-típusa';
$string['table_dlg:missing_scope'] = 'Biztosan folytatja anélkül, hogy hatókört adna a fejléccellának? Fogyatékkal élők nehezen fogják megérteni a táblázat tartalmát.';
$string['table_dlg:row_all'] = 'Táblázat összes sorának frissítése';
$string['table_dlg:row_even'] = 'Táblázat páros sorainak frissítése';
$string['table_dlg:row_limit'] = 'Túllépte a sorok megengedett számát {$rows}.';
$string['table_dlg:row_odd'] = 'Táblázat páratlan sorainak frissítése';
$string['table_dlg:row_row'] = 'Aktuális sor frissítése';
$string['table_dlg:row_title'] = 'Táblázat sorainak tulajdonságai';
$string['table_dlg:rowgroup'] = 'Sorcsoport';
$string['table_dlg:rows'] = 'Sor';
$string['table_dlg:rowtype'] = 'Sor típusa';
$string['table_dlg:rtl'] = 'Jobbról balra';
$string['table_dlg:rules'] = 'Vonalak';
$string['table_dlg:rules_above'] = 'fölötte';
$string['table_dlg:rules_below'] = 'alatta';
$string['table_dlg:rules_border'] = 'keret';
$string['table_dlg:rules_box'] = 'doboz';
$string['table_dlg:rules_hsides'] = 'vízszintes oldalak';
$string['table_dlg:rules_lhs'] = 'bal oldal';
$string['table_dlg:rules_rhs'] = 'jobb oldal';
$string['table_dlg:rules_void'] = 'nincs';
$string['table_dlg:rules_vsides'] = 'függőleges oldalak';
$string['table_dlg:scope'] = 'Hatókör';
$string['table_dlg:style'] = 'Stílus';
$string['table_dlg:summary'] = 'Összegzés';
$string['table_dlg:tbody'] = 'Törzs';
$string['table_dlg:td'] = 'Adatok';
$string['table_dlg:tfoot'] = 'Lábléc';
$string['table_dlg:th'] = 'Fejléc';
$string['table_dlg:thead'] = 'Fejléc';
$string['table_dlg:title'] = 'Táblázat beszúrása/szerkesztése';
$string['table_dlg:valign'] = 'Függőleges igazítás';
$string['table_dlg:width'] = 'Szélesség';
$string['template:desc'] = 'Előre megadott sablon tartalmának beszúrása';
$string['template_dlg:cdate_format'] = '%Y-%m-%d %H:%M:%S';
$string['template_dlg:day_long'] = 'vasárnap,hétfő,kedd,szerda,csütörtök,péntek,szombat,vasárnap';
$string['template_dlg:day_short'] = 'v,h,k,sze,cs,p,szo,v';
$string['template_dlg:desc'] = 'Előre megadott sablon tartalmának beszúrása';
$string['template_dlg:desc_label'] = 'Leírás';
$string['template_dlg:label'] = 'Sablon';
$string['template_dlg:mdate_format'] = '%Y-%m-%d %H:%M:%S';
$string['template_dlg:months_long'] = 'január,február,március,április,május,június,július,augusztus,szeptember,október,november,december';
$string['template_dlg:months_short'] = 'jan,feb,már,ápr,máj,jún,júl,aug,szep,okt,nov,dec';
$string['template_dlg:preview'] = 'Előnézet';
$string['template_dlg:select'] = 'Sablon kiválasztása';
$string['template_dlg:title'] = 'Sablonok';
$string['template_dlg:warning'] = 'Vigyázat: a sablon másikkal való frissítése adatvesztést okozhat.';
$string['visualblocks:desc'] = 'Blokkelemek megjelenítése/elrejtése';
$string['visualchars:desc'] = 'Vizuális vezérlőkarakterek megjelenítése/elrejtése';
$string['wordcount:words'] = 'szó';
$string['xhtmlxtras:abbr_delta_height'] = '0';
$string['xhtmlxtras:abbr_delta_width'] = '0';
$string['xhtmlxtras:abbr_desc'] = 'Rövidítés';
$string['xhtmlxtras:acronym_delta_height'] = '0';
$string['xhtmlxtras:acronym_delta_width'] = '0';
$string['xhtmlxtras:acronym_desc'] = 'Mozaikszó';
$string['xhtmlxtras:attribs_delta_height'] = '0';
$string['xhtmlxtras:attribs_delta_width'] = '0';
$string['xhtmlxtras:attribs_desc'] = 'Attribútumok beszúrása/szerkesztése';
$string['xhtmlxtras:cite_delta_height'] = '0';
$string['xhtmlxtras:cite_delta_width'] = '0';
$string['xhtmlxtras:cite_desc'] = 'Idézet';
$string['xhtmlxtras:del_delta_height'] = '0';
$string['xhtmlxtras:del_delta_width'] = '0';
$string['xhtmlxtras:del_desc'] = 'Törlés';
$string['xhtmlxtras:ins_delta_height'] = '0';
$string['xhtmlxtras:ins_delta_width'] = '0';
$string['xhtmlxtras:ins_desc'] = 'Beszúrás';
$string['xhtmlxtras_dlg:attrib_tab'] = 'Attribútumok';
$string['xhtmlxtras_dlg:attribs_title'] = 'Attribútumok beszúrása/szerkesztése';
$string['xhtmlxtras_dlg:attribute_attrib_tab'] = 'Attribútumok';
$string['xhtmlxtras_dlg:attribute_events_tab'] = 'Események';
$string['xhtmlxtras_dlg:attribute_label_accesskey'] = 'Billentyű';
$string['xhtmlxtras_dlg:attribute_label_cite'] = 'Idéz';
$string['xhtmlxtras_dlg:attribute_label_class'] = 'Osztály';
$string['xhtmlxtras_dlg:attribute_label_datetime'] = 'Dátum/Időpont';
$string['xhtmlxtras_dlg:attribute_label_id'] = 'Azonosító';
$string['xhtmlxtras_dlg:attribute_label_langcode'] = 'Nyelv';
$string['xhtmlxtras_dlg:attribute_label_langdir'] = 'Írásirány';
$string['xhtmlxtras_dlg:attribute_label_style'] = 'Stílus';
$string['xhtmlxtras_dlg:attribute_label_tabindex'] = 'Tabulátorok sorrendje';
$string['xhtmlxtras_dlg:attribute_label_title'] = 'Cím';
$string['xhtmlxtras_dlg:attribute_option_ltr'] = 'Balról jobbra';
$string['xhtmlxtras_dlg:attribute_option_rtl'] = 'Jobbról balra';
$string['xhtmlxtras_dlg:events_tab'] = 'Események';
$string['xhtmlxtras_dlg:fieldset_attrib_tab'] = 'Elem attribútumai';
$string['xhtmlxtras_dlg:fieldset_events_tab'] = 'Elem eseményei';
$string['xhtmlxtras_dlg:fieldset_general_tab'] = 'Általános beállítások';
$string['xhtmlxtras_dlg:general_tab'] = 'Általános';
$string['xhtmlxtras_dlg:insert_date'] = 'Aktuális dátum/idő beszúrása';
$string['xhtmlxtras_dlg:option_ltr'] = 'Balról jobbra';
$string['xhtmlxtras_dlg:option_rtl'] = 'Jobbról balra';
$string['xhtmlxtras_dlg:remove'] = 'Törlés';
$string['xhtmlxtras_dlg:title_abbr_element'] = 'Rövidítési elem';
$string['xhtmlxtras_dlg:title_acronym_element'] = 'Mozaikszóelem';
$string['xhtmlxtras_dlg:title_cite_element'] = 'Idézetelem';
$string['xhtmlxtras_dlg:title_del_element'] = 'Törlési elem';
$string['xhtmlxtras_dlg:title_ins_element'] = 'Beszúrási elem';
