<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_brickfield', language 'ro', version '4.2'.
 *
 * @package     tool_brickfield
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessibility'] = 'Accesibilitate';
$string['accessibilitydisabled'] = 'Setul de instrumente de accesibilitate Brickfield nu este activat pe acest site. Contactați administratorul site-ului pentru activare.';
$string['accessibilityreport'] = 'Setul de instrumente pentru accesibilitate';
$string['accessibilitytool'] = 'Instrument de accesibilitate Brickfield';
$string['accessibilitytools'] = 'Instrument de accesibilitate Brickfield';
$string['activate'] = 'Activează';
$string['activated'] = 'Plugin-ul este activat și se poate folosi.';
$string['activationform'] = 'Înregistrare Brickfield';
$string['activationheader'] = 'Activare Brickfield';
$string['activationinfo'] = '<p>Pentru a utiliza acest plugin, trebuie să furnizați chei valide pentru acest site în acest formular.</p><p>Vă rugăm <a href="{$a}" data-action="send_info" target=" _blank">înregistrați-vă pe portalul Brickfield (se deschide într-o fereastră nouă)</a> pentru a primi acele chei dacă nu le aveți deja. </p><p>Odată activate, cheile vor fi apoi validate prin activități cron programate.</p>';
$string['activityresults:pluginname'] = 'Raportul detaliat al activității instrumentului de accesibilitate';
$string['activityresults:toolname'] = 'Rezumatul sumar activității';
$string['activityresults:toolshortname'] = 'Rezumatul activității';
$string['advanced:pluginname'] = 'Raport avansat despre instrumentul de accesibilitate';
$string['advanced:toolname'] = 'Rezumat avansat';
$string['advanced:toolshortname'] = 'Avansat';
$string['allcourses'] = 'Toate cursurile verificate ({$a})';
$string['allcoursescat'] = 'Toate cursurile verificate pentru categoria {$a->catname} ({$a->count})';
$string['analysis:byrequest'] = 'La cerere';
$string['analysis:disabled'] = 'Dezactivat';
$string['analysistype'] = 'Activează solicitările de analiză';
$string['analysistype_desc'] = 'Permiteți solicitarea analizei de accesibilitate a conținutului';
$string['analysistypedisabled'] = 'Analiza conținutului este dezactivată';
$string['bannercontentone'] = 'Trusa de elemente de accesibilitate de nivel premium oferă un set de caracteristici care ajută organizația ta să își îmbunătățească accesibilitatea cursurilor.<a href="{$a}">Contactează Brickfield Education Labs</a> pentru a te programa la un demo gratuit pentru prezentarea caracteristicilor avansate.';
$string['bannercontenttwo'] = 'Dezvoltă o platformă efectivă și intruzivă de predare și învățare prin găsirea de conținut care nu îndeplinește standardele de accesibilitate, remedierea problemelor și îmbunatățirea conținutului cursurilor Moodle cu fișiere accesibile, editor de text și funcții extinse.';
$string['bannerheadingone'] = 'Actualizează la Enterprise Accessibility Toolkit';
$string['batch'] = 'Limita de procesare';
$string['brickfield'] = 'Instrument de accesibilitate Brickfield';
$string['brickfield:viewcoursetools'] = 'Vizualizați rapoartele pe cursuri';
$string['brickfield:viewsystemtools'] = 'Vezi rapoartele pentru toate cursurile';
$string['bulkprocesscaches'] = 'Procesare completă a memoriei cache';
$string['bulkprocesscourses'] = 'Procesați verificarea accesibilității în bloc';
$string['buttonone'] = 'Primiți un demo gratis';
$string['cachepending'] = 'Datele de sumar au fost compilate';
$string['checkdesc:alinksdontopennewwindow'] = 'Linkurile care se deschid într-o fereastră nouă ar trebui să anunțe utilizatorii în avans.';
$string['checkdesc:amustcontaintext'] = 'Un link trebuie să conțină text pentru a fi putea fi înțeles.';
$string['checkdesc:areadontopennewwindow'] = 'Zonele, folosite în hărțile de imagini, care se deschid într-o fereastră nouă ar trebui să informeze cursanții în prealabil.';
$string['checkdesc:areahasaltvalue'] = 'Zonelor, folosite în hărțile de imagini, nu ar trebui să le lipsească alt text (text alternativ) similar cu imaginile.';
$string['checkdesc:asuspiciouslinktext'] = 'Textul link-ului ar trebui să fie descriptiv și să ofere informații despre destinația sa.';
$string['checkdesc:basefontisnotused'] = 'Elementele fontului de bază (în mod obișnuit folosite pentru formatare) nu sunt accesibile și nu ar trebui să fie folosite.';
$string['checkdesc:blinkisnotused'] = 'Elementele care clipesc și apoi se sting nu sunt accesibile și nu ar trebui să fie folosite.';
$string['checkdesc:boldisnotused'] = 'Elementele bold (b) nu ar trebui folosite; "strong" ar trebui să fie folosit, în schimb.';
$string['checkdesc:contenttoolong'] = 'Întreg conținutul paginii nu trebuie să depășească 500 de cuvinte.';
$string['checkdesc:csstexthascontrast'] = 'Contrastul de culoare dintre text și fundal este prea scăzut.';
$string['checkdesc:embedhasassociatednoembed'] = 'Elementele încorporate (pentru fișierele multimedia încorporate) trebuie să aibă elemente neîncorporate corespunzătoare.';
$string['checkdesc:headerh3'] = 'Titlurile care urmează după antetele de nivel 3 (opțiuni de editare a textelor mari) nu ar trebui să afecteze ordinea antetelor paginii.';
$string['checkdesc:headershavetext'] = 'Un antet trebuie să conțină text pentru a fi inteligibil.';
$string['checkdesc:iisnotused'] = 'Elementele italic(e) nu trebuie utilizate; „em” ar trebui folosit în schimb.';
$string['checkdesc:imgaltisdifferent'] = 'Textul alternativ al imaginii nu ar trebui să fie numele imaginii.';
$string['checkdesc:imgaltistoolong'] = 'Textul alternativ al imaginii nu ar trebui să aibă mai mult decât numărul maxim permis de caractere. (125)';
$string['checkdesc:imgaltnotemptyinanchor'] = 'Textul alternativ al imaginii nu ar trebui să fie necompletat, mai ales când imaginea are o legătură care duce în altă parte.Textul alternativ al imaginii';
$string['checkdesc:imgaltnotplaceholder'] = 'Textul alternativ al imaginii nu ar trebui să fie doar un text opțional, cum ar fi "imagine".';
$string['checkdesc:imghasalt'] = 'Textul alternativ al imaginii (alt) nu ar trebui să lipsească din descrierea imaginii, decât dacă informația are rol decorativ.';
$string['checkdesc:imgwithmaphasusemap'] = 'Hărțile de imagini cu zone active necesită potrivirea elementelor "usemap" și  "map".';
$string['checkdesc:legendtextnotempty'] = 'Elementele legendei, folosite pentru definirea elementelor setului de câmpuri, ar trebui să conțină text.';
$string['checkdesc:marqueeisnotused'] = 'Elementele în mișcare (auto-derulare) nu sunt accesibile și nu ar trebui să fie utilizate.';
$string['checkdesc:noheadings'] = 'Dacă nu există antete, conținutul e mai puțin structurat și mai greu de citit.';
$string['checkdesc:objectmusthaveembed'] = 'Obiectelor elementului (pentru a încorpora resurse externe) nu ar trebui să le lipsească elementele "încorporate" corespunzătoare.';
$string['checkdesc:objectmusthavetitle'] = 'Elemetelor obiectelor (pentru încorporarea resurselor externe) nu ar trebui să le lipsească descrierea corespunzătoare a "titlului".';
$string['checkdesc:objectmusthavevalidtitle'] = 'Elememtele obiectelor (pentru încorporarea resurselor externe) ar trebui să aibă "titlurile" corespunzătoare cu text.';
$string['checkdesc:strikeisnotused'] = 'Elementele cu linie tăiată nu ar trebui să fie folosite;  ar trebui să fie folosite în schimb "del" (deleted).';
$string['checkdesc:tabledatashouldhaveth'] = 'Tabelurilor, în mod ideal, nu ar trebui să le lipsească antetele.';
$string['checkdesc:tablesummarydoesnotduplicatecaption'] = 'Sumarul și descrierea tabelului nu ar trebui să fie identice.';
$string['checkdesc:tabletdshouldnotmerge'] = 'Tabelele nu ar trebui să aibă celule îmbinate.';
$string['checkdesc:tablethshouldhavescope'] = 'Contextul rândului sau coloanei din tabel (utilizat pentru a corela rândul și coloana cu fiecare celulă) ar trebui să fie definit.';
$string['checkidvalidation'] = 'Sarcină de lucru pentru a verifica orice id care nu este valid';
$string['checkscompleted'] = 'Verificări finalizate: {$a}';
$string['checktype'] = 'Verifică grupul';
$string['checktype:form'] = 'Formular';
$string['checktype:image'] = 'Imagine';
$string['checktype:layout'] = 'Layout';
$string['checktype:link'] = 'Link';
$string['checktype:media'] = 'Media';
$string['checktype:table'] = 'Tabel';
$string['checktype:text'] = 'Text';
$string['checktyperesults:pluginname'] = 'Raportul instrumentului de accesibilitate pentru tipurile de conținut';
$string['checktyperesults:toolname'] = 'Rezumatul tipurilor de conținut';
$string['checktyperesults:toolshortname'] = 'Tipuri de conținut';
$string['cmpercent'] = 'Procentul de activități în ansamblu';
$string['cmpercenterrors'] = 'Procentul erorilor per total';
$string['cmpercenttitle'] = 'Procentajul total de prezentare a activităților versus erori';
$string['confirmationmessage'] = 'Acest curs a fost programat pentru analiză. Analiza va fi finalizată cel mai târziu
până în {$a}. Verificați după această dată.';
$string['contactadmin'] = 'Vă rugăm să contactați administratorul pentru a vă încheia înregistrarea.';
$string['contactus'] = 'Contactați-ne';
$string['contentfive'] = 'Revizuire automată a etichetelor HTML vechi.';
$string['contentfour'] = 'Identificați care activități au cele mai multe probleme de accesibilitate pentru a prioritiza efortul.';
$string['contentone'] = 'Evaluează automat conținutul cursului tău și evaluările pentru probleme de accessibilitate.';
$string['contentsix'] = 'Oferiți sfaturi la timp profesorilor  pentru a crea conținut mai bun.';
$string['contentthree'] = 'Oferiți cursanților conținut în formate accesibile, inclusiv Audio, ePub și Electronic Braille.';
$string['contenttwo'] = 'Actualizarea în bloc a textului neclar sau care lipsește din link-urile web, descrierile imaginii sau subtitrări video.';
$string['contenttypeerrors'] = 'Rezultatele totale ale testelor de conținut de activitate per curs și per tip de conținut.';
$string['contentyperesults'] = 'Totalul rezultatelor validate/nevalidate din zonele de conținut ale cursului.';
$string['contextid'] = 'Contextid';
$string['core_course'] = 'Curs';
$string['core_question'] = 'Bancă de întrebări';
$string['count'] = 'Numărătoare';
$string['country'] = 'Țară';
$string['country_help'] = 'Țara de unde este site-ul';
$string['coursecount'] = 'Numărul de cursuri';
$string['deletehistoricaldata'] = 'Ștergere istoric al rezultatelor verificărilor';
$string['dependency'] = 'Dependent de';
$string['emptycategory'] = 'Nu s-au găsit cursuri pentru categoria {$a}';
$string['emptytagcourses'] = 'Nu s-au găsit rezultate pentru cursurile cu etichete configurate';
$string['enableaccessibilitytools'] = 'Activați instrumentele de accesibilitate';
$string['enableaccessibilitytools_desc'] = 'Instrumentul de accesibilitate ajută la indentificarea problemelor de accesibilitate în cursuri.';
$string['error:nocoursespecified'] = 'Sumarul raportului necesită un identificator de curs valid. Te rugăm să accesezi instrumentul de accesibilitate din cadrul unui curs.';
$string['errorlink'] = 'Editați instanța de eroare pentru {$a}';
$string['errors'] = 'Erori: {$a}';
$string['errors:pluginname'] = 'Lista erorilor instrumentului de accesibilitate';
$string['errors:toolname'] = 'Rezumatul listei cu erori';
$string['errors:toolshortname'] = 'Lista erorilor';
$string['eventanalysis_requested'] = 'Este necesară analiza conținutului';
$string['eventanalysis_requesteddesc'] = 'Analiza conținutului a fost solicitată pentru cursul {$a}.';
$string['eventreport_downloaded'] = 'Sumar de accesibilitate descărcat';
$string['eventreport_downloadeddesc'] = 'Sumarul de accesibilitate a fost accesat pentru identificatorul de curs {$a}.';
$string['eventreport_viewed'] = 'Raportul privind accesibilitatea vizualizat';
$string['eventreport_vieweddesc'] = 'Raportul privind accesibilitatea a fost vizualizat pentru identificatorul de curs {$a->course}, identificator categorie {$a->category}, tab {$a->tab}.';
$string['failed'] = 'Eșuat';
$string['failedcount'] = 'Eșuat: {$a}';
$string['footerheading'] = 'Secțiunea de subsol';
$string['fullcachedone'] = 'Dezactivați pentru a reindexa memoria cache';
$string['hashcorrect'] = 'Codul inserat este corect.';
$string['hashincorrect'] = 'Codul inserat este incorect.';
$string['headingfive'] = 'Formatare HTML';
$string['headingfour'] = 'Efort concentrat';
$string['headingone'] = 'Evaluare conținut';
$string['headingsix'] = 'Sprijin pentru performanță';
$string['headingthree'] = 'Formate de fișiere accesibile';
$string['headingtwo'] = 'Remediere';
$string['hideshow'] = 'Ascunde/afișează';
$string['icon:analytics-custom'] = 'Pictograma Analytics';
$string['icon:file-edit-custom'] = 'Editează pictograma fișierului';
$string['icon:hands-helping-custom'] = 'Pictogramă de ajutor';
$string['icon:search-plus-custom'] = 'Caută pictogramă';
$string['icon:tools-custom'] = 'Pictogramă instrumente';
$string['icon:wand-magic-custom'] = 'Pictogramă Baghetă magică';
$string['inactive'] = 'Acest plugin nu este activ și nu poate fi utilizat. Vă rugăm să inserați un cod de validare valid și să apăsați "Activare".';
$string['innercontextid'] = 'Contextid intern';
$string['installed'] = 'Plugin instalat';
$string['installedcli'] = 'Plugin instalat prin linie de comandă';
$string['installeddescription'] = 'Pluginul a fost instalat, redirecționați către formularul de activare.';
$string['invalidaccessibilitytool'] = 'S-a trimis o cerere de subplugin de accesibilitate neconformă.';
$string['invalidcategoryid'] = 'Categoria nu este validă, vă rugăm verificați datele introduse';
$string['invalidcourseid'] = 'Cursul nu este valid, vă rugăm să verificați datele introduse';
$string['invalidlinkphrases'] = 'click|click aici|aici|mai multe|mai multe aici|informații|informatii aici|informatii|informatii aici|citeste mai mult|citeste mai mult aici|mai multe informatii|mai multe informatii aici|mai multe detalii|mai multe detalii aici';
$string['language'] = 'Limba';
$string['language_help'] = 'Limba site-ului';
$string['messageprovider:warningcheckid'] = 'Avertizare pentru verificare id-uri incorecte';
$string['mobileservice'] = 'Servicii mobile activate ({$a})';
$string['module'] = 'Modul';
$string['modulename'] = 'Nume';
$string['moreinfo'] = 'Mai multe informații';
$string['newwindowphrases'] = 'new window|new-window|new_window';
$string['noerrorsfound'] = 'Nu au fost găsite erori comune de accesibilitate pentru parametrii dumneavoastră de căutare. Felicitări!';
$string['norecords'] = 'Nu s-au găsit rezultate revelante pentru parametrii dumneavoastră de căutare.';
$string['notregistered'] = 'Instrumentul dumneavoastră de accesibilitate trebuie să fie înregistrat.';
$string['notvalidated'] = 'Instrumentul de accesibilitate este funcțional în timp ce este validat.';
$string['numcourses'] = 'Numărul de cursuri ({$a})';
$string['numfactivities'] = 'Numărul de activități ({$a})';
$string['numfiles'] = 'Numărul de fișiere ({$a})';
$string['numinstances'] = 'Numărul de instanțe';
$string['numusers'] = 'Numărul de utilizatori ({$a})';
$string['pagedesc:checktype'] = '<p>Pentru a sumariza și a analiza rezultatele diferitelor verificări efectuate, grupăm aceste verificări în diferite tipuri de conținut. Prin urmare, toate rezultatele verificării accesibilității legate de imagini sunt în grupul de tipuri de conținut „Imagine”, toate rezultatele verificării accesibilității legate de aspect sunt în grupul de tipuri de conținut „Aspect” și așa mai departe.</p><p>Activitățile sunt incluse în raport fie ca activități, resurse sau zone de conținut ale cursului.</p><p>Pagina diagramă tip de conținut afișează împărțirea erorilor în grupuri de tip de conținut: imagine, aspect, legătură, media, tabel și text.</ p>';
$string['pagedesc:pertarget'] = '<p>Pentru a sumariza și a analiza rezultatele verificării în funcție de activitate, grupăm rezultatele verificării în diferitele activități detectate în curs.</p><p>Activitățile sunt incluse fie ca activități, resurse sau alte zone de conținut ale cursului. Fiecare activitate fără erori detectate este considerată validată, fiecare activitate cu una sau mai multe erori detectate este considerată nevalidată. Apoi este afișat raportul cu activitățile validate și nevalidate.</p><p>Pagina așează diagrama și raportul dintre elementele validate și nevalidate în total, per activitate, cum ar fi temă, curs, etichetă etc.</p>';
$string['pagedesctitle:checktype'] = 'Tipuri de conținut explicate';
$string['pagedesctitle:pertarget'] = 'Explicarea defalcării activității în etape';
$string['passed'] = 'Promovat';
$string['passedcount'] = 'Promovat: {$a}';
$string['passrate'] = 'Rata de promovare: {$a}%';
$string['pdf:filename'] = 'Brickfield_Summaryreport_CourseID-{$a}';
$string['percheckerrors'] = 'Numărul de teste specifice și erori per verificare per curs.';
$string['perpage'] = 'Itemi de afișat pe pagină';
$string['pluginname'] = 'Instrument de accesibilitate';
$string['printable:downloadpdf'] = 'Descarcă PDF';
$string['printable:pluginname'] = 'Raport sumar al instrumentului de accesibilitate';
$string['printable:printreport'] = 'Raport care se poate tipări';
$string['printable:toolname'] = 'Sumarul raportului';
$string['printable:toolshortname'] = 'Sumarul raportului';
$string['privacy:metadata'] = 'Plugin-ul de verificare a rapoartelor de accesibilitate nu stochează date personale.';
$string['processanalysisrequests'] = 'Procesarea cererilor de analiză a conținutului';
$string['registernow'] = 'Vă rugăm să vă înregistrați acum.';
$string['registration'] = 'Formular de înregistrare';
$string['registrationinfo'] = '<p>Acest proces de înregistrare vă permite să utilizați versiunea inițială a setului de instrumente de accesibilitate Brickfield pentru site-ul dvs. Moodle înregistrat.</p><p>Această utilizare este supusă <a href="{$a}" target="_blank" >Termenilor și condițiilor Brickfield Education Labs (se deschide într-o fereastră nouă)</a> și cu care sunteți de acord, utilizând acest produs.</p>';
$string['release'] = 'Versiune Moodle ({$a})';
$string['remaining'] = '({$a} erori rămase)';
$string['response:0'] = 'Acest URL nu face trimitere la nimic';
$string['response:404'] = 'Acest URL al paginii nu a fost găsit';
$string['schedule:blocknotscheduled'] = '<p>Acest curs nu a fost încă programat pentru analiză, pentru a găsi probleme generale de accesibilitate.</p>';
$string['schedule:notscheduled'] = '<p>Acest curs încă nu a fost programat pentru analiza eventualelor probleme comune de accesibilitate.</p><p>Făcând clic pe butonul „Trimiteți pentru analiză”, confirmați că doriți ca tot conținutul HTML relevant al cursului, cum ar fi descrierile secțiunilor cursului, descrierile activităților, întrebările, paginile și multe alte informații, vor urma să fie programate pentru analiză.</p><p>Această analiză va efectua mai multe verificări comune de accesibilitate asupra conținutului HTML al cursului dvs., iar acele rezultate vor fi apoi afișate în paginile de rapoarte ale setului de instrumente de accesibilitate. Analiza va fi procesată în fundal, în procese programate, astfel încât viteza sa de finalizare va depinde de calendarul proceselor și de programul de rulare al proceselor.</p>';
$string['schedule:requestanalysis'] = 'Trimite pentru a fi analizat';
$string['schedule:scheduled'] = 'Acest curs a fost programat pentru analiză.';
$string['schedule:sitenotscheduled'] = '<p>Conținutul global (independent de curs) nu a fost încă programat pentru analiză pentru a identifica eventualele probleme comune de accesibilitate.</p><p>Făcând clic pe butonul „Trimiteți pentru analiză”, confirmați că doriți ca toate informațiile globale relevante și conținut (independent de curs) să fie programat pentru analiză.</p><p>Această analiză va efectua mai multe verificări comune de accesibilitate asupra acestui conținut, iar acele rezultate vor fi apoi afișate în paginile de rapoarte ale setului de instrumente de accesibilitate. Analiza va fi procesată în fundal, în procese programate, astfel încât viteza sa de finalizare va depinde de calendarul proceselor și de programul de rulare al proceselor.</p>';
$string['schedule:sitescheduled'] = 'Conținutul global (independent de curs) a fost programat pentru analiză.';
$string['secretkey'] = 'Cheie API';
$string['secretkey_help'] = 'Acest cod este primit prin email după înregistrare.';
$string['sendfollowinginfo'] = '<p>Următoarele informații vor fi trimise periodic doar pentru a contribui la statisticile generale. Nu vor fi făcute publice pe nicio listă.</p> {$a}';
$string['settings'] = 'Setările instrumentului de accesibilitate';
$string['sitehash'] = 'Cheie de securitate';
$string['sitehash_help'] = 'Acest cod este primit prin email după înregistrare.';
$string['taberrors'] = 'Verifică erori';
$string['targetavetitle'] = 'Mediile erorilor pe activitate';
$string['targetpercentage'] = 'Procentajul instanțelor promovate/nepromovate per activitate';
$string['targetratio'] = 'Raport de complianță a activității';
$string['tblcheck'] = 'Verifică';
$string['tblcheckexample'] = 'Exemplu';
$string['tblcheckfailed'] = 'Verificări nereușite';
$string['tblchecksummary'] = 'Rezumat';
$string['tbledit'] = 'Editare';
$string['tblerrorcount'] = 'Erori';
$string['tblhtmlcode'] = 'Cod HTML existent';
$string['tblinstance'] = 'Instanță';
$string['tblline'] = 'Linie';
$string['tbloverallpercentage'] = 'Erori globale %';
$string['tblpercentage'] = 'Procentaj';
$string['tblpreview'] = 'Previzualizare';
$string['tbltarget'] = 'Activitate';
$string['tblupdateto'] = 'Actualizează la';
$string['titleactivityresultsall'] = 'Rezultatele per activitate: toate cursurile analizate ({$a->count} courses)';
$string['titleactivityresultspartial'] = 'Rezultate pe activitate: curs {$a->name}';
$string['titleall'] = 'Detalii despre eroare: toate cursurile analizate ({$a->count} cursuri)';
$string['titlechecktyperesultsall'] = 'Rezultate per tipul de conținut: toate cursurile analizate ({$a->count} courses)';
$string['titlechecktyperesultspartial'] = 'Rezultate per tipul de conținut: curs {$a->name}';
$string['titleerrorsall'] = 'Detalii despre eroare: toate cursurile analizate ({$a->count} cursuri)';
$string['titleerrorscount'] = 'Detalii eroare: (se afișează primele {$a} erori)';
$string['titleerrorspartial'] = 'Detalii eroare: curs {$a->name}';
$string['titlepartial'] = 'Detalii eroare: curs {$a->name}';
$string['titleprintableall'] = 'Curs {$a->name}';
$string['titleprintablepartial'] = 'Curs {$a->name}';
$string['tools'] = 'Rapoarte';
$string['toperrors'] = 'Cele mai multe erori';
$string['toptargets'] = 'Activități eșuate';
$string['totalactivities'] = 'Activități totale';
$string['totalactivitiescount'] = 'Activități totale: {$a}';
$string['totalareas'] = 'Toate zonele';
$string['totalerrors'] = 'Total erori';
$string['totalgrouperrors'] = 'Total (suma) erori per tip de conținut';
$string['updatesummarydata'] = 'Actualizarea informațiilor din sumarul site-ului';
$string['usersmobileregistered'] = 'Numărul de utilizatori cu dispozitive mobile înregistrare ({$a})';
$string['validationerror'] = 'Validarea cheii de înregistrare a eșuet. Te rugăm să verifici dacă URL-ul înregistrat al site-ului și cheile sunt corecte.';
$string['warningcheckidbody'] = 'Există o problemă cu o verificare Brickfield care este activă, dar nu este listată în baza de date. Te rugăm să verifici.';
$string['warningcheckidsubject'] = 'Avertizare cu privire la verificarea id-ul instrumentului Brickfield';
