<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'studentquiz', language 'sr_lt', version '4.2'.
 *
 * @package     studentquiz
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abort_button'] = 'Obustavi';
$string['add_comment'] = 'Dodajte komentar';
$string['add_reply'] = 'Dodajte odgovor';
$string['addprivatecomment'] = 'Dodajte privatni komentar (ovi komentari su samo između polaznika i predavača)';
$string['addprivatecomment_help'] = 'Ovi komentari su striktno između autora pitanja i osobe koja administrira aktivnost. Ovaj niz poruka je više za administratora aktivnosti kako bi on mogao da da povratne informacije ako i kada se promeni status pitanja.';
$string['addpubliccomment'] = 'Dodajte javni komentar';
$string['after_answering_end_date'] = 'Ovaj StudenTest je zatvoren za davanje odgovar {$ a}.';
$string['after_submission_end_date'] = 'Ovaj StudenTest je zatvoren za slanje pitanja {$ a}.';
$string['anonymous_user_name'] = 'Anonimni Korisnik #{$a}';
$string['answeringndbeforestart'] = 'Rok za davanje odgovora se ne može postaviti tako da bude pre datuma od kog je moguće davanje odgovora';
$string['api_state_change_error_content'] = 'Ovo pitanje se ne može obrisati jer je odobreno.';
$string['api_state_change_error_title'] = 'Greška prilikom brisanja pitanja';
$string['api_state_change_success_content'] = 'Status /vidljivost pitanja je uspešno promenjena';
$string['api_state_change_success_title'] = 'Uspešno';
$string['approve'] = 'Odobri';
$string['approve_toggle'] = 'Ne/Odobri';
$string['approved'] = '✓';
$string['approved_column_name'] = 'Odobreno';
$string['approved_veryshort'] = 'A';
$string['approveselectedscheck'] = 'Da li ste sigurni da želite da ne/odobrite sledeća pitanja?<br /><br />{$a}';
$string['average_column_name'] = 'Prosek';
$string['back_to_course_button'] = 'Vrati se na kurs';
$string['before_answering_end_date'] = 'Ovaj StudenTest se zatvara za davanje odgovara dana {$ a}.';
$string['before_answering_start_date'] = 'Otvoreno za davanje odgovora od {$ a}.';
$string['before_submission_end_date'] = 'Ovaj StudenTest se zatvara za slanje pitanja dana {$a}.';
$string['before_submission_start_date'] = 'Otvoreno za slanje pitanja od {$a}.';
$string['cachedef_permissionssync'] = 'Praćenje sinhronizacije ovlašćenja za StudenTest';
$string['cannotcapturecommenthistory'] = 'Nije moguće snimiti zapis istorije komentara';
$string['changecurrentstate'] = 'Promeni status iz <b>{$a}</b> u:';
$string['changestateto'] = 'Promeni statuse y:';
$string['collapseall'] = 'Skupi sve komentare';
$string['collapsecomment'] = 'Skupi komentar';
$string['comment'] = 'Komentar';
$string['comment_author'] = 'Autor';
$string['comment_cannot_update'] = 'Nije moguće ažurirati komentar';
$string['comment_column_name'] = 'Komentari';
$string['comment_error'] = 'Napišite komentar';
$string['comment_error_unsaved'] = 'Želite li prvo da sačuvate ovaj komentar?';
$string['comment_help'] = 'Napišite komentar';
$string['comment_help_help'] = 'Napišite komentar na pitanje.';
$string['comment_veryshort'] = 'C';
$string['commentcolumnexplainprivate'] = 'Broj privatnih komentara. Plava pozadina znači da imate najmanje jedan nepročitani komentar.';
$string['commentcolumnexplainpublic'] = 'Broj javnih komentara. Plava pozadina znači da imate najmanje jedan nepročitani komentar.';
$string['commenthistory'] = 'Istorija komentara';
$string['commentplural'] = 'Komentari';
$string['completiondetail:approved'] = 'Minimalni broj jedinstvenih odobrenih pitanja: {$a}';
$string['completiondetail:point'] = 'Minimalan broj poena: {$a}';
$string['completiondetail:published'] = 'Minimalni broj jedinstvenih pitanja autora: {$a}';
$string['completionpoint'] = 'Minimalan broj potrebnih poena:';
$string['completionpointgroup'] = 'Zahtevajte poene';
$string['completionpointgroup_help'] = 'Polaznici osvajaju poene kako je navedeno u podešavanjima Rangiranja, npr. 10 poena za kreiranje pitanja, 5 poena za pitanje koje je odobrio predavač, 3 poena za ocenjivanje pitanja drugih polaznika. Unošenjem numeričke vrednosti u polje, polaznici će završiti ovu aktivnost tek kada sakupe dovoljan broj poena.';
$string['completionquestionapproved'] = 'Potreban minimalan broj jedinstvenih odobrenih pitanja:';
$string['completionquestionapprovedgroup'] = 'Zahtevaj kreirana odobrena pitanja';
$string['completionquestionapprovedgroup_help'] = 'Minimalni broj jedinstvenih pitanja koja polaznik mora da kreira i koja moraju biti odobrena pre nego što se aktivnost završi. Ova opcija se može koristiti bilo da je podešavanje za objavljivanje pitanja postavljeno na"Zahteva odobrenje pre objavljivanja" ili na"Automatsko odobrenje", s tim što neće biti toliko efikasna sa ovim drugim podešavanjem, u slučaju da se automatski odobrena pitanja kasnije sakriju, obrišu ili na neki drugi način budu uklonjena.';
$string['completionquestionpublished'] = 'Potreban minimalan broj jedinstvenih pitanja koje je kreirao polaznika:';
$string['completionquestionpublishedgroup'] = 'Zahtevaj objavljena pitanja';
$string['completionquestionpublishedgroup_help'] = 'Minimalni broj jedinstvenih pitanja koja polaznik mora da kreira pre nego što se aktivnost završi. Imajte na umu da je ovo jednostavna numerička provera - dva pitanja koja su skrivena/izbrisana se i dalje tretiraju kao da ih je kreirao polaznik.';
$string['confirmdeletecomment'] = 'Da li ste sigurni da želite da obrišete ovaj komentar?';
$string['createnewquestion'] = 'Kreiraj novo pitanje';
$string['createnewquestionfirst'] = 'Kreiraj prvo pitanje';
$string['creator_anonym_fullname'] = 'Anonimni Polaznik';
$string['current_of_total'] = '{$a->current} od {$a->total}';
$string['current_state'] = 'Trenutni status';
$string['daily'] = 'dnevno';
$string['delete'] = 'Obriši';
$string['deletecomment'] = 'Obriši komentar';
$string['deleted'] = 'Obrisano';
$string['deletedbyauthor'] = 'Ovaj post je obrisan dana {$a}.';
$string['deletedbyuser'] = 'Ovaj post je obrisao/la <a href="{$a->profileurl}" >{$a->fullname}</a> dana {$a->date}.';
$string['deletedcomment'] = 'Obrisani post.';
$string['deleteorphanedquestions'] = 'Brisanje napuštenih pitanja';
$string['deleteorphanedquestionserrormdlquestion'] = '<font color="red">грешка</font>: nije moguće obrisati iz tabele mdl_question. Pitanje se verovatno negde drugo koristi.
<br><font color="red">greška</font>: brisanje iz mdl_studentquiz* tabela je preskočenoо.<br>';
$string['deleteorphanedquestionserrorstudentquiz'] = '<font color="red">greška</font>: nije moguće obrisati iz mdl_studentquiz* tabela.<br>';
$string['deleteorphanedquestionsfullmessage'] = 'Pitanja koja su neodobrena/označena za brisanje:
<ul>{$a->fullmessage}</ul>';
$string['deleteorphanedquestionsnonefound'] = '<b>није пронађено ниједино</b>';
$string['deleteorphanedquestionsquestioninfo'] = '<li><b>{$a->name}</b> (Questiontype: {$a->qtype}, ID: {$a->questionid})</li>';
$string['deleteorphanedquestionssmallmessage'] = 'StudenTest : Zadatak za brisanje napuštenih pitanja je pokrenut';
$string['deleteorphanedquestionssubject'] = 'StudenTest';
$string['deleteorphanedquestionssuccessmdlquestion'] = '<font color="green">uspešno</font>: obrisano iz tabele mdl_question<br>';
$string['deleteorphanedquestionssuccessstudentquiz'] = '<font color="green">uspešno</font>: obrisano iz tabela mdl_studentquiz*<br>';
$string['describe_already_deleted'] = 'Ovaj komentar je već obrisan.';
$string['describe_not_creator'] = 'Ovo nije vaš komentar.';
$string['describe_out_of_time_delete'] = 'Vreme za brisanje ovog komentara je isteklo';
$string['describe_out_of_time_edit'] = 'Vreme za uređivanje ovog komentara je isteklo';
$string['descriptioncofstate'] = 'Pitanje podešeno na  \'{$a->state}\'';
$string['descriptionofstatenew'] = 'Pitanje je sačuvano (\'Radna verzija\')';
$string['descriptionofvisibility'] = 'Vidljivost pitanja je podešena na \'{$ a->visibility}\'';
$string['difficulty_all_column_name'] = 'Težina za sve polaznike';
$string['difficulty_level_column_name'] = 'Težina';
$string['difficulty_title'] = 'Traka težine';
$string['editcomment'] = 'Uredi komentar';
$string['editedcomment_last_edit'] = 'Poslednji put uređeno:';
$string['editedcommenthistory'] = 'Уредник/ла {$a->laesteditedcommentauthorname} у {$a->lastededitedcommenttime}';
$string['editedcommenthistorylinktext'] = 'Istorija';
$string['editedcommenthistorywithuserlink'] = 'Uredio/la <a href="{$a->lastesteditedcommentauthorprofileurl}">{$a->lastesteditedcommentauthorname}</a> dana {$a->lastededitedcommenttime}';
$string['editorplaceholder'] = 'Unesite svoj komentar ovde...';
$string['emailautomationnote'] = 'Imajte na umu da je ovo automatska sistemska poruka – ova adresa e-pošte se ne nadgleda.';
$string['emailcommentaddedbody'] = 'Dragi/ga {$a->recepientname},

Vaše pitanje \'{$a->questionname}\' u aktivnosti StudenTest \'{$a->modulename}\' na kursu {$a->coursename}\' je komentarisao/la \'{$a->actorname}\' u {$a->timestamp}\'.

Komentar glasi: \'{$a->commenttext}

Ovo pitanje možete pregledati na: {$a->questionurl}.';
$string['emailcommentaddedsmall'] = 'Vaše pitanje \'{$a->questionname}\'je prokomentarisao/la {$a->actorname}.';
$string['emailcommentaddedsubject'] = 'Poslat je komentar na pitanje: {$a->questionname}';
$string['emailcommentdeletedbody'] = 'Dragi/ga {$a->recepientname},

komentar poslat \'{$a->commenttime}\' na vaše pitanje \'{$a->questionname}\' u aktivnosti StudenTest \'{$a->modulename}\' na kursu \'{$a->coursename}\' obrisao/la је \'{$a->actorname}\' u \'{$a->timestamp}\'.

Komentar je glasio: \'{$a->commenttext}\'

Ovo pitanje možete pregledati na: {$a->questionurl}.';
$string['emailcommentdeletedsmall'] = 'Komentar na vaše pitanje \'{$a->questionname}\' obrisao/la je {$a->actorname}.';
$string['emailcommentdeletedsubject'] = 'Obrisan je komentar na pitanje: {$a->questionname}';
$string['emaildigestbody'] = 'Ovo je vaš {$a->digesttype} sažetak obaveštenja za aktivnost StudenTest  <b>{$a->modulename}</b>, dostupan ovde:';
$string['emaildigestbody_section_content'] = 'Vaše pitanje <b>{$a->questionname}</b> <b>{$a->actorname}</b> je <b>{$a->actiontype}</b>';
$string['emaildigestbody_section_title'] = 'Obaveštenje {$a->seq}, {$a->timestamp}';
$string['emaildigestsubject'] = 'StudentTest - sažetak obaveštenja';
$string['emailminecommentdeletedbody'] = 'Dragi/ga {$a->recepientname},

Vaš komentar poslat \'{$a->commenttime}\' na pitanje \'{$a->questionname}\'u aktivnosti StudenTest \'{$a->modulename}\' na kursu \'{$a->coursename}\' obrisao/la је \'{$a->actorname}\' u \'{$a->timestamp}\'.

Komentar je glasio: \'{$a->commenttext}\'

Ovo pitanje možete pregledati na: {$a->questionurl}.';
$string['emailminecommentdeletedsmall'] = 'Vaš komentar na pitanje \'{$a->questionname}\' je obrisao/la {$a->actorname}..';
$string['emailminecommentdeletedsubject'] = 'Obrisan je komentar na pitanje: {$a->questionname}';
$string['emailnoityfyreviewablequestion_section_content'] = 'Korisnik <b>{$a->actorname<b> je status pitanja <b>"{$a->questionname}"</b> promenio u "<b>Na recenziji</b>"';
$string['emailnoityfyreviewablequestionsinglebody'] = '<b>{$a->courseshortname}</b> aktivnost StudenTest(<b>"{$a->modulename}"</b>): korisnik <b>{$a->actorname, {$a->timestamp}<b> je status pitanja <b>"{$a->questionname}"</b> promenio u "<b>Na recenziji</b>"';
$string['emailsalutation'] = 'Драгаги/a {$a},';
$string['emailsinglebody'] = 'Vaše pitanje <b>{$a->questionname}</b>aktivnosti StudenTest <b>{$a->modulename}</b> na kursu <b>{$a->coursename}</b> корисник <b>{$a->actorname} је {$a->eventname} у <b>{$a->timestamp}</b>.';
$string['emailsinglebody_reviewlink'] = 'Ovo pitanje možete pregledati na:';
$string['error_form_validation'] = '{$a}';
$string['error_permission'] = 'Žao nam je, ali morate da budete deo grupe da biste videli ovu stranicu.';
$string['error_sendalert'] = 'Došlo je do greške pri slanju izveštaja na {$ a}.
Izveštaj nije mogao da se pošalje.';
$string['expandall'] = 'Proširi sve komentare';
$string['expandcomment'] = 'Proširi komentar';
$string['filter'] = 'Filter';
$string['filter_advanced_element'] = '{$a} (Napredni element)';
$string['filter_comment_label_date'] = 'Datum';
$string['filter_comment_label_forename'] = 'Ime';
$string['filter_comment_label_sort_by'] = 'Sortiraj prema:';
$string['filter_comment_label_sort_toggle'] = 'Sortiraj prema {$a->field} {$a->type}';
$string['filter_comment_label_surname'] = 'Prezime';
$string['filter_ishigher'] = 'je veće';
$string['filter_islower'] = 'je manje';
$string['filter_label_approved'] = 'Odobrena pitanja';
$string['filter_label_comment'] = 'Komentari';
$string['filter_label_createdate'] = 'Kreiranje';
$string['filter_label_difficulty_level'] = 'Težina';
$string['filter_label_fast_filters'] = 'Brzi filter za pitanja';
$string['filter_label_myattempts'] = 'Moji pokušaji';
$string['filter_label_mydifficulty'] = 'Moja težina';
$string['filter_label_mylastattempt'] = 'Moj poslednji pokušaj';
$string['filter_label_myrate'] = 'Moja ocena';
$string['filter_label_onlyapproved'] = 'Odobrena';
$string['filter_label_onlyapproved_help'] = 'Pitanja koja je odobrio vaš predavač';
$string['filter_label_onlydifficult'] = 'Teška za sve';
$string['filter_label_onlydifficult_help'] = 'Pitanje sa prosečnom težinom većom od {$a}%';
$string['filter_label_onlydifficultforme'] = 'Teška za mene';
$string['filter_label_onlydifficultforme_help'] = 'Pitanje sa mojom težinom većom od {$a}%';
$string['filter_label_onlygood'] = 'Dobra';
$string['filter_label_onlygood_help'] = 'Pitanje sa prosečnom ocenom od najmanje {$a} zvezdice/ca';
$string['filter_label_onlymine'] = 'Moja';
$string['filter_label_onlymine_help'] = 'Pitanja koja ste vi kreirali.';
$string['filter_label_onlynew'] = 'Bez odgovora/Nova';
$string['filter_label_onlynew_help'] = 'Pitanja na koja nikada ranije niste odgovorili';
$string['filter_label_question'] = 'Naslov pitanja';
$string['filter_label_question_creation_item'] = '{$a->creationtext} {$a->rowtext} {$a->inputtext}';
$string['filter_label_question_creation_item_inputtext'] = '{$a->inputtext} {$a->inputtype}';
$string['filter_label_questiontext'] = 'Sadržaj pitanja';
$string['filter_label_rates'] = 'Ocena';
$string['filter_label_show_mine'] = 'Moja pitanja';
$string['filter_label_tags'] = 'Oznaka';
$string['finish_button'] = 'Završi';
$string['hidden'] = 'Sakriveno';
$string['history'] = 'istorija';
$string['includingunread'] = '(uključujući nepročitane)';
$string['invalidcomment'] = 'neispravankomentar';
$string['invalidemail'] = 'Ova adresa e-pošte nije ispravna. Unesite jednu adresu e-pošte.';
$string['lastattempt_right'] = '✓';
$string['lastattempt_right_label'] = 'Poslednji pokušaj je tačan';
$string['lastattempt_wrong'] = '✗';
$string['lastattempt_wrong_label'] = 'Poslednji pokušaj je pogrešan';
$string['latest_column_name'] = 'Najnovija';
$string['manager_anonym_fullname'] = 'Anonimni menadžer';
$string['message'] = 'Poruka';
$string['messageprovider:commentadded'] = 'Slanje obaveštenja o dodatom komentaru';
$string['messageprovider:commentdeleted'] = 'Slanje obaveštenja o obrisanom komentaru';
$string['messageprovider:deleteorphanedquestions'] = 'Slanje obaveštenja o obrisanom pitanju';
$string['messageprovider:minecommentdeleted'] = 'Slanje obaveštenja o mom obrisanom komentaru';
$string['messageprovider:questionchanged'] = 'Slanje obaveštenja o događaju vezanim za pitanje';
$string['migrate_already_done'] = 'Ništa nije urađeno jer je ova aktivnost već migrirana!';
$string['migrate_ask'] = 'Brzina modula StudenTest je poboljšana sa verzijom 3.2.1, ali se ovaj skup pitanja i dalje bazira na prethodnoj verziji.
Pitanja i testovi će se brže učitavati ukoliko ova pitanja migrirate na novu verziju. Videćete mnogo brže učitavanje kako pitanja tako i testova; ništa drugo se neće promeniti.';
$string['migrate_studentquiz'] = 'Migrirajte pitanja kreirana starom verzijom StudenTesta (pre verzije 3.2.1), na bržu verziju sa agregiranim vrednostima';
$string['migrate_studentquiz_short'] = 'Ubrzajte ovaj skup pitanja';
$string['migrated_successful'] = 'Ova aktivnost je uspešno migrirana!';
$string['mine_column_name'] = 'Moja';
$string['missingparam'] = 'Obavezan parametar nedostaje ili je pogrešan';
$string['moderator'] = 'Moderator';
$string['modulename'] = 'StudenTest';
$string['modulename_help'] = 'Aktivnost "StudenTest" omogućava da polaznici sami kreiraju pitanja i dodaju ih u banku pitanja. Polaznici, takođe, mogu da filtriraju pitanja prema različitim kriterijumima, kao i da filtrirana pitanja koriste za vežbanje. Predavači mogu da sakriju identitet polaznika koji su kreirali pitanja.<br><br> U okviru ove aktivnosti polaznici mogu da osvoje poene kako za kreiranje novih pitanja, tako i za rešavanje testova sa pitanjima koji kreirali svi polaznici. Poeni se prikazuju na rang listi.';
$string['modulename_link'] = 'mod/studentquiz/view';
$string['modulenameplural'] = 'StudenTestovi';
$string['more'] = 'Više';
$string['myattempts_column_name'] = 'Moji pokušaji';
$string['mydifficulty_column_name'] = 'Moja težina';
$string['mylastattempt_column_name'] = 'Moj poslednji pokušaj';
$string['myrate_column_name'] = 'Moja ocena';
$string['nav_export'] = 'Izvoz';
$string['nav_import'] = 'Uvoz';
$string['nav_question_no'] = 'Pitanje {$a->current} od {$a->total}';
$string['needtoallowatleastoneqtype'] = 'Morate da dozvolite bar jedan tip pitanja';
$string['next_button'] = 'Sledeće';
$string['no_comment'] = 'n.a.';
$string['no_comments'] = 'Nema komentara';
$string['no_difficulty_level'] = 'n.a.';
$string['no_myattempts'] = 'n.a.';
$string['no_mylastattempt'] = 'n.a.';
$string['no_mylastattempt_label'] = 'Nije bilo pokušaja da se odgovori na pitanje';
$string['no_questions_add'] = 'U ovom StudenTestu nema pitanja. Slobodno dodajte pitanja.';
$string['no_questions_filter'] = 'Nijedno od pitanja se ne poklapa sa kriterijumima vašeg filtera. Resetujte filter kako biste videli sva pitanja.';
$string['no_questions_selected_message'] = 'Izaberite bar jedno pitanje kako biste započeli test.';
$string['no_rates'] = 'n.a.';
$string['no_tags'] = 'n.a.';
$string['nocommenthistoryexist'] = 'Za ovaj komentar još uvek ne postoji istorija komentara.';
$string['nofurtherprivatecomments'] = 'Kada je pitanje \'Odobreno\' nisu dozvoljeni dalji privatni komentari';
$string['noquestionsselectedtodoaction'] = 'Izaberite jedno ili više pitanja pre nego što izaberete ovu akciju.';
$string['not_approved'] = '✗';
$string['notshowratingcomment'] = 'Ocenjivanje i javno komentarisanje nisu dostupni za vaše pitanje dok je ono u režimu recenzije.';
$string['num_questions'] = '{$a} pitanja';
$string['number_column_name'] = 'Broj';
$string['numberreply'] = '{$a} odgovora';
$string['onlyrootcommentcanreply'] = 'Može se poslati odgovor samo na komentar prvog nivoa';
$string['pagesize'] = 'Veličina stranice:';
$string['pagesize_invalid_input'] = 'Greška: navedena veličina stranice mora da bude ispravna numerička vrednost.';
$string['pin'] = 'Fiksiraj pitanje';
$string['please_enrole_message'] = 'Upišite se na ovaj kurs kako biste videli svoj lični napredak';
$string['pluginadministration'] = 'Administracija StudenTesta';
$string['pluginname'] = 'StudenTest';
$string['previous_button'] = 'Prethodno';
$string['privacy:metadata:mod_studentquiz_comment_sort'] = 'Parametar korisnika za tip filtera komentara.';
$string['privacy:metadata:mod_studentquiz_question_active_tab'] = 'Korisnička podešavanja za trenutno aktivnu karticu na stranicama sa pitanjima.';
$string['privacy:metadata:studentquiz_attempt'] = 'Predstavlja pokušaj korisnika da odgovore na skup pitanja.';
$string['privacy:metadata:studentquiz_attempt:categoryid'] = 'ID oznaka kategorije.';
$string['privacy:metadata:studentquiz_attempt:questionusageid'] = 'ID oznaka upotrebe pitanja.';
$string['privacy:metadata:studentquiz_attempt:studentquizid'] = 'ID oznaka StudenTesta.';
$string['privacy:metadata:studentquiz_attempt:userid'] = 'ID oznaka korisnika.';
$string['privacy:metadata:studentquiz_comment'] = 'Sačuvajte komentare za pitanja.';
$string['privacy:metadata:studentquiz_comment:comment'] = 'Komentar na pitanje.';
$string['privacy:metadata:studentquiz_comment:created'] = 'Vreme kreiranja komentara';
$string['privacy:metadata:studentquiz_comment:deleted'] = 'Vreme brisanja komentara';
$string['privacy:metadata:studentquiz_comment:deleteuserid'] = 'ID oznaka korisnika koji je obrisao komentar';
$string['privacy:metadata:studentquiz_comment:edited'] = 'Vreme uređivanja komentara';
$string['privacy:metadata:studentquiz_comment:edituserid'] = 'ID oznaka korisnika koji je uredio komentar';
$string['privacy:metadata:studentquiz_comment:parentid'] = 'ID oznaka nadređenog komentara. 0 : komentar najvišeg nivoa.';
$string['privacy:metadata:studentquiz_comment:status'] = 'Status komentara';
$string['privacy:metadata:studentquiz_comment:studentquizquestionid'] = 'ID oznaka pitanja polaznika (studentquizquestion).';
$string['privacy:metadata:studentquiz_comment:timemodified'] = 'Vreme izmene komentara';
$string['privacy:metadata:studentquiz_comment:type'] = 'Vrsta komentara';
$string['privacy:metadata:studentquiz_comment:userid'] = 'ID oznaka korisnika';
$string['privacy:metadata:studentquiz_comment:usermodified'] = 'ID oznaka korisnika koji je izmenio komentar';
$string['privacy:metadata:studentquiz_comment_history'] = 'Sačuvajte istorije komentara';
$string['privacy:metadata:studentquiz_comment_history:action'] = 'Tip istorije 0 - Kreiraj | 1 - Uredi | 2 - Izbriši';
$string['privacy:metadata:studentquiz_comment_history:commentid'] = 'ID oznaka komentara';
$string['privacy:metadata:studentquiz_comment_history:content'] = 'Sadržaj istorije komentara';
$string['privacy:metadata:studentquiz_comment_history:timemodified'] = 'Izmenjeno vreme komentara';
$string['privacy:metadata:studentquiz_comment_history:userid'] = 'ID oznaka korisnika koji je uredio komentar';
$string['privacy:metadata:studentquiz_notification'] = 'Obaveštenje na čekanju';
$string['privacy:metadata:studentquiz_notification:content'] = 'Sadržaj obaveštenja';
$string['privacy:metadata:studentquiz_notification:recipientid'] = 'ID oznaka primaoca';
$string['privacy:metadata:studentquiz_notification:status'] = 'Status obaveštenja';
$string['privacy:metadata:studentquiz_notification:studentquizid'] = 'ID oznaka StudenTesta.';
$string['privacy:metadata:studentquiz_notification:timetosend'] = 'Vreme za slanje obaveštenja';
$string['privacy:metadata:studentquiz_progress'] = 'Sačuvajte informacije o napretku polaznika za ovo pitanje.';
$string['privacy:metadata:studentquiz_progress:attempts'] = 'Broj pokušaja za odgovor na ovo pitanje.';
$string['privacy:metadata:studentquiz_progress:correctattempts'] = 'Broj tačnih odgovora.';
$string['privacy:metadata:studentquiz_progress:lastanswercorrect'] = '0: poslednji odgovor je bio pogrešan ili nedefinisan, 1: poslednji odgovor je bio tačan.';
$string['privacy:metadata:studentquiz_progress:lastreadprivatecomment'] = 'Vreme kada je korisnik poslednji put pročitao privatne komentare';
$string['privacy:metadata:studentquiz_progress:lastreadpubliccomment'] = 'Vreme kada je korisnik poslednji put pročitao javne komentare';
$string['privacy:metadata:studentquiz_progress:studentquizid'] = 'ID oznaka StudenTesta.';
$string['privacy:metadata:studentquiz_progress:studentquizquestionid'] = 'ID oznaka pitanja polaznika (studentquizquestion).';
$string['privacy:metadata:studentquiz_progress:userid'] = 'ID oznaka korisnika.';
$string['privacy:metadata:studentquiz_question'] = 'Sačuvajte svojstva vezana za pitanja';
$string['privacy:metadata:studentquiz_question:groupid'] = 'ID oznaka grupe kojoj pitanje pripada';
$string['privacy:metadata:studentquiz_question:hidden'] = 'Svojstvo da li je pitanje skriveno ili ne';
$string['privacy:metadata:studentquiz_question:pinned'] = 'Svojstvo da li je pitanje fiksirano ili ne';
$string['privacy:metadata:studentquiz_question:state'] = 'Svojstvo da li je pitanje odobreno, neodobreno, novo ili promenjeno';
$string['privacy:metadata:studentquiz_question:studentquizid'] = 'ID oznaka StudenTesta.';
$string['privacy:metadata:studentquiz_rate'] = 'Sačuvajte ocene za pitanja.';
$string['privacy:metadata:studentquiz_rate:rate'] = 'Ocena za pitanje.';
$string['privacy:metadata:studentquiz_rate:studentquizquestionid'] = 'ID oznaka pitanja polaznika (studentquizquestion).';
$string['privacy:metadata:studentquiz_rate:userid'] = 'ID oznaka korisnika';
$string['privacy:metadata:studentquiz_state_history:state'] = 'Svojstvo da li je pitanje odobreno, neodobreno, novo ili promenjeno';
$string['privacy:metadata:studentquiz_state_history:studentquizquestionid'] = 'ID oznaka pitanja polaznika (studentquizquestion).';
$string['privacy:metadata:studentquiz_state_history:timecreated'] = 'Vreme kreiranja';
$string['privacy:metadata:studentquiz_state_history:userid'] = 'ID oznaka korisnika';
$string['private'] = 'Privatno';
$string['privatecomments'] = 'Privatni komentari';
$string['progress_bar_caption'] = 'Vaš napredak u ovoj aktivnosti StudenTest';
$string['public'] = 'Javno';
$string['publiccomments'] = 'Javni komentari';
$string['questionchangedlowercase'] = 'promenjeno';
$string['questionsinuse'] = '(* Pitanja označena zvezdicom već se koriste u nekim testovima.)';
$string['ranking_block_title'] = 'Rangiranje';
$string['ranking_block_title_anonymised'] = 'Rangiranje (anonimizovano)';
$string['rate_all_column_name'] = 'Ocena svih polaznika';
$string['rate_column_name'] = 'Ocena';
$string['rate_error'] = 'Molimo vas da cenite';
$string['rate_help'] = 'Ocenite ovo pitanje';
$string['rate_help_help'] = 'Ocenite ovo pitanje.<br />1 zvezdica je veoma loše, a 5 zvezdica je veoma dobro';
$string['rate_multi_stars_desc'] = 'Broj izabranih zvezdica: {$ a}';
$string['rate_one_star_desc'] = 'Izabrana 1 zvezdica';
$string['rate_points'] = 'Poeni';
$string['rate_title'] = 'Procena';
$string['ratingbar_title'] = 'Traka procene';
$string['remove_comment'] = 'Ukloni';
$string['remove_comment_label'] = 'Ukloni komentar';
$string['replies'] = 'Odgovori';
$string['reply'] = 'Odgovori';
$string['replycomment'] = 'Odgovori';
$string['report_comment_condition1'] = 'Uvredljiv je';
$string['report_comment_condition2'] = 'Uznemirijući je';
$string['report_comment_condition3'] = 'Sadrži nepristojan sadržaj kao što je pornografija';
$string['report_comment_condition4'] = 'Pogrdan je i klevetnički';
$string['report_comment_condition5'] = 'Krši autorska prava';
$string['report_comment_condition6'] = 'Protiv je pravila iz nekog drugog razloga';
$string['report_comment_condition_more'] = 'Ostale informacije (opciono)';
$string['report_comment_emailappendix'] = 'Primili ste ovu e-poruku zato što je vaša adresa e-pošte podešena u StudenTestu za prijavljivanje neprihvatljivih komentara.';
$string['report_comment_emailpreface'] = 'Komentar je prijavio/la {$a->fullname} ({$a->username},
{$a->email}).';
$string['report_comment_emailsubject'] = 'Prijava komentara {$a->commentid}: {$a->coursename} {$a->studentquizname}';
$string['report_comment_feedback'] = 'Vaš izveštaj je uspešno poslat. Neko od odgovornih će ispitati ovaj problem.';
$string['report_comment_info'] = 'Funkcija \'Prijava komentara\' može da pošalje ovaj komentar nadležnim osobama koje će prijavu ispitati. <strong>Koristite ovu funkciju samo ako mislite da komentar krši pravila</strong>.';
$string['report_comment_invalid'] = 'Morate navesti razlog zbog kog prijavljujete ovaj komentar.';
$string['report_comment_invalid_checkbox'] = 'Morate označiti bar jedno polje.';
$string['report_comment_link_text'] = 'Pregledajte ovde';
$string['report_comment_not_available'] = 'Funkcija za prijavu komentara nije dostupna.';
$string['report_comment_pagename'] = 'Prijavite komentar kao neprihvatljiv';
$string['report_comment_reasons'] = 'Razlozi za prijavu komentara:';
$string['report_comment_reporter_detail'] = '{$a->fullname} ({$a->username}; {$a->email}; {$a->ip})';
$string['report_comment_reporter_info'] = '<strong>Podaci o korisniku koji prijavljuje komentar</strong>:';
$string['report_comment_submit'] = 'Pošaljite prijavu';
$string['reportcomment'] = 'Prijava';
$string['reportcomment_title'] = 'Prijavite komentar kao neprihvatljiv';
$string['reportquiz_admin_title'] = 'Statistika polaznika';
$string['reportquiz_stats_all_last_attempt_correct'] = 'Prosek poslednjih tačnih odgovora svih polaznika';
$string['reportquiz_stats_all_last_attempt_incorrect'] = 'Prosek poslednjih netačnih odgovora svih polaznika';
$string['reportquiz_stats_all_percentage_correct_answers'] = 'Procenat tačnih odgovora svih polaznika';
$string['reportquiz_stats_all_percentage_correct_answers_help'] = 'Zbir tačnih odgovora / zbir svih odgovora.';
$string['reportquiz_stats_all_progress'] = 'Prosečan napredak svih polaznika';
$string['reportquiz_stats_all_progress_help'] = 'Prosečan napredak svih polaznika baziran na svim učesnicima na kursu.';
$string['reportquiz_stats_all_question_attempts_correct'] = 'Prosek tačnih odgovora svih polaznika';
$string['reportquiz_stats_all_question_attempts_incorrect'] = 'Prosek netačnih odgovora svih polaznika';
$string['reportquiz_stats_all_questions_answered'] = 'Prosek svih odgovora svih polaznika';
$string['reportquiz_stats_all_questions_answered_help'] = 'Prosečan broj odgovora svih učesnika na kursu.';
$string['reportquiz_stats_all_questions_approved'] = 'Broj odobrenih pitanja';
$string['reportquiz_stats_all_questions_approved_help'] = 'Predavači mogu odobriti pitanja kako bi potvrdili njegovu tačnost. Ovo je broj svih odobrenih pitanja unutar ovog StudenTesta.';
$string['reportquiz_stats_all_questions_created'] = 'Broj pitanja u ovom StudenTestu';
$string['reportquiz_stats_all_questions_created_help'] = 'Broj pitanja koji su kreirali svi polaznici';
$string['reportquiz_stats_all_rates_average'] = 'Prosečna ocena svih pitanja';
$string['reportquiz_stats_all_rates_average_help'] = 'Ocena svakog pitanja je prosek zvezdica koje je pitanje dobilo od svih polaznika. Primer: svi polaznici na kursu kreirali su 4 pitanja. Ako su polaznici ocenili pitanje A sa 3 zvezdice, pitanje B sa 4 zvezdice, pitanje C sa 2 zvezdice i pitanje D sa 5 zvezdica, onda je prosečna ocena svih pitanja 3,5.';
$string['reportquiz_stats_own_last_attempt_correct'] = 'Broj vaših poslednjih tačnih odgovora';
$string['reportquiz_stats_own_last_attempt_incorrect'] = 'Broj vaših poslednjih netačnih odgovora';
$string['reportquiz_stats_own_percentage_correct_answers'] = 'Procenat vaših tačnih odgovora';
$string['reportquiz_stats_own_percentage_correct_answers_help'] = 'Procenat svih vaših tačnih odgovora iz skupa svih vaših odgovora u ovom StudenTestu. Delimično tačni odgovori se računaju kao pogrešni odgovori.';
$string['reportquiz_stats_own_progress'] = 'Lični napredak';
$string['reportquiz_stats_own_progress_help'] = 'Procenat vaših poslednjih tačnih odgovora iz skupa svih pitanja unutar ovog StudenTesta. Delimično tačni odgovori se računaju kao pogrešni odgovori.';
$string['reportquiz_stats_own_question_attempts_correct'] = 'Ukupan broj vaših tačnih odgovora';
$string['reportquiz_stats_own_question_attempts_incorrect'] = 'Ukupan broj vaših netačnih odgovora';
$string['reportquiz_stats_own_questions_answered'] = 'Ukupan broj svih vaših odgovora';
$string['reportquiz_stats_own_questions_answered_help'] = 'Broj svih vaših odgovora u okviru ovog StudenTesta.';
$string['reportquiz_stats_own_questions_approved'] = 'Broj vaših odobrenih pitanja';
$string['reportquiz_stats_own_questions_approved_help'] = 'Predavači mogu odobriti pitanja kako bi potvrdili njegovu tačnost. Ovo je broj vaših odobrenih pitanja unutar ovog StudenTesta.';
$string['reportquiz_stats_own_questions_created'] = 'Broj pitanja koja ste poslali';
$string['reportquiz_stats_own_questions_created_help'] = 'Broj pitanja koja ste poslali u ovaj StudenTest.';
$string['reportquiz_stats_own_rates_average'] = 'Vaš prosek dobijenih ocena';
$string['reportquiz_stats_own_rates_average_help'] = 'Ocena svakog pitanja je prosek zvezdica koje je pitanje dobilo od svih polaznika. Primer : kreirali ste pitanja A i B. Ako su svi polaznici ocenila vaše pitanje A sa 3 zvezdice, a vaše pitanje B sa 4 zvezdice, onda je vaša prosečna ocene 3,5.';
$string['reportquiz_stats_title'] = 'Statistika';
$string['reportquiz_total_attempt'] = 'Broj pokušaja korisnika da reši test';
$string['reportquiz_total_obtained_marks'] = 'Ukupna ocena';
$string['reportquiz_total_questions_answered'] = 'Ukupno odgovora';
$string['reportquiz_total_questions_right'] = 'Ukupno tačnih odgovora';
$string['reportquiz_total_questions_wrong'] = 'Pogrešni odgovori';
$string['reportquiz_total_users'] = 'Broj učesnika';
$string['reportrank_table_column_approvedquestions'] = 'Poeni za odobrena pitanja';
$string['reportrank_table_column_communitystatus'] = 'Statistika svih polaznika';
$string['reportrank_table_column_correctanswers'] = 'Tačni odgovori';
$string['reportrank_table_column_countquestions'] = 'Poeni za objavljena pitanja';
$string['reportrank_table_column_description'] = 'Opis';
$string['reportrank_table_column_factor'] = 'Faktor';
$string['reportrank_table_column_fullname'] = 'Prezime';
$string['reportrank_table_column_incorrectanswers'] = 'Netačni odgovori';
$string['reportrank_table_column_lastcorrectanswers'] = 'Poeni za najnovije tačne pokušaje';
$string['reportrank_table_column_lastincorrectanswers'] = 'Poeni za najnovije pogrešne pokušaje';
$string['reportrank_table_column_points'] = 'Poeni';
$string['reportrank_table_column_progress'] = 'Lični napredak';
$string['reportrank_table_column_quantifier_name'] = 'Ime';
$string['reportrank_table_column_rank'] = 'Rang';
$string['reportrank_table_column_summeanrates'] = 'Dobijeni poeni za zvezdice';
$string['reportrank_table_column_total_points'] = 'Ukupno poena';
$string['reportrank_table_column_value'] = 'Vrednost';
$string['reportrank_table_column_yourstatus'] = 'Lična statistika';
$string['reportrank_table_quantifier_caption'] = 'Kako se izračunavaju vaši poeni';
$string['reportrank_table_title'] = 'Rangiranje polaznika - 10 najboljih';
$string['reportrank_table_title_for_manager'] = 'Rangiranje polaznika';
$string['reportrank_title'] = 'Rangiranje';
$string['review_button'] = 'Pregledaj';
$string['savechanges'] = 'Sačuvaj promene';
$string['scheduled_task_send_digest_notification'] = 'Pošaljite rezime obaveštenja';
$string['setting_question_publishing'] = 'Objavljivanje pitanja';
$string['setting_question_publishing_automatic'] = 'Automatski objavi nova pitanja';
$string['setting_question_publishing_help'] = 'Objavljena pitanja se pojavljuju u grupi pitanja kako bi ih drugi polaznici mogli da odgovaraju na njih. Na raspolaganju sam dve opcije: ili dozvolite automatsko objavljivanje svih pitanja ili zahtevajte odobrenje pre objavljivanja.<br>Imajte na umu da se ovo podešavanje primenjuje isključivo na novokreirana pitanja.';
$string['setting_question_publishing_require_approval'] = 'Zahtevajte odobrenje pre objavljivanja';
$string['settings_allowallqtypes'] = 'Dozvoli sve tipove pitanja';
$string['settings_allowedqtypes'] = 'Dozvoljeni tipovi pitanja';
$string['settings_allowedqtypes_help'] = 'Ograničite dozvoljene tipove pitanja na one koje ste izabrali';
$string['settings_allowedrolestoshow'] = 'Izuzmite uloge koje se mogu menjati u svakoj aktivnosti';
$string['settings_allowedrolestoshow_help'] = 'Ovo se odnosi na prethodno podešavanje. Nisu sve uloge u sistemu relevantne za StudenTest, tako da možete da koristite ovo podešavanje kako biste smanjili broj uloga navedenih u obrascu za podešavanja aktivnosti. Ovde izabrane uloge će se pojaviti na obrascu za svaku aktivnost, tako da predavač može da promeni podešavanja. Uloge koje ovde nisu izabrane biće isključene iz izveštaja u zavisnosti od toga da li su prethodno standardno isključene.';
$string['settings_anonymous'] = 'Sakrivač identiteta polaznika';
$string['settings_anonymous_help'] = 'Polaznici ne mogu da vide imena jedni drugima.';
$string['settings_anonymous_label'] = 'Učinite polaznike anonimnim';
$string['settings_approvedquantifier'] = 'Faktor za odobrena pitanja';
$string['settings_approvedquantifier_help'] = 'Poeni za svako odobreno pitanje';
$string['settings_approvedquantifier_label'] = 'Poeni za svako odobreno pitanje';
$string['settings_availability_close_answering_from'] = 'Zatvoreno za davanje odgovora od';
$string['settings_availability_close_submission_from'] = 'Zatvoreno za slanje pitanja od';
$string['settings_availability_open_answering_from'] = 'Otvoreno za davanje odgovora od';
$string['settings_availability_open_submission_from'] = 'Otvoreno za slanje pitanja od';
$string['settings_comment_editor_toolbar'] = 'Konfiguracija trake sa alatkama u editoru komentara';
$string['settings_comment_editor_toolbar_des'] = 'Ovde se može konfigurisati spisak dodataka i njihov redosled';
$string['settings_commentdeletionperiod'] = 'Period za uređivanje/brisanja komentara (minuti)';
$string['settings_commentdeletionperiod_help'] = 'Podesite vremenski period (u minutama) u kojem će dugme Uredi/Obriši biti dostupno polaznicima kako bi mogli da urede/obrišu svoj komentar (ili odgovor na komentar) nakon što on bude objavljen. Dozvoljene su vrednosti između 0-60 minuta. Ako je period za brisanje podešen na 0, polaznici ne mogu da uređuju/brišu svoje komentare. Imajte na umu da će nastavnici i administratori uvek moći da uređuju/brišu komentare polaznika, kao i da vide sadržaj svakog obrisanog komentara.';
$string['settings_email_digest_first_day'] = 'Prvi dan u sedmici?';
$string['settings_email_digest_first_day_help'] = 'Ako ste izabrali sedmični sažetak, ova opcija vam omogućava da definišete prvi dan sedmodnevnog perioda (sa početkom u 00h:00m:00s tog dana). Ovo je posebno korisno ako aktivnost, na primer, počinje sredinom nedelje.';
$string['settings_email_digest_type'] = 'Tip sažetka koji se šalje e-poštom';
$string['settings_email_digest_type_daily_digest'] = 'Dnevni sažetak';
$string['settings_email_digest_type_help'] = 'StudenTest ima različita obaveštenja koja možete da omogućite, kao što je obaveštavanje polaznika, autora pitanja o promeni statusa (npr. predavač je odobrio neko od poslatih pitanja). Možete da koristite ovo podešavanje kako biste odredili koliko često će se slati ova obaveštenja. E -poruka sa sažetkom će se slati samo kada postoji bar jedno obaveštenje u podešenom vremenskom periodu';
$string['settings_email_digest_type_no_digest'] = 'Bez sažetka (jedna e-poruka za svaku akciju)';
$string['settings_email_digest_type_weekly_digest'] = 'Sedmični sažetak';
$string['settings_excluderoles'] = 'Standardne uloge koje treba isključiti iz rangiranja';
$string['settings_excluderoles_help'] = 'U svakom StudenTestu, predavač može da kontroliše koje su uloge isključene iz rangiranja. Spisak uloga, koji je ovde podešen, predstavlja podrazumevani spisak koji se koristi za svaki novokreirani StudenTest';
$string['settings_excluderoles_label'] = 'Uloge koje treba isključiti u rangiranju';
$string['settings_forcecommenting'] = 'Primorajte korisnike da šalju komentare';
$string['settings_forcecommenting_help'] = 'Primorajte korisnike da šalju komentare prilikom pokušaja davanja odgovora na pitanje';
$string['settings_forcerating'] = 'Primorajte korisnike da ocenjuju pitanja';
$string['settings_forcerating_help'] = 'Primorajte korisnike da ocenjuju pitanja prilikom pokušaja davanja odgovora na njih';
$string['settings_lastcorrectanswerquantifier'] = 'Faktor za poslednje tačne odgovore';
$string['settings_lastcorrectanswerquantifier_help'] = 'Poeni za svaki tačan odgovor na poslednjem pokušaju';
$string['settings_lastcorrectanswerquantifier_label'] = 'Poeni za poslednje tačne odgovore';
$string['settings_lastincorrectanswerquantifier'] = 'Faktor za poslednje pogrešne odgovore';
$string['settings_lastincorrectanswerquantifier_help'] = 'Poeni za svaki pogrešan ili delimično pogrešan odgovor na poslednjem pokušaju';
$string['settings_lastincorrectanswerquantifier_label'] = 'Poeni za poslednje pogrešne odgovore';
$string['settings_notification'] = 'Podešavanja obaveštenja';
$string['settings_privatecomment'] = 'Objašnjenje privatnog komentara';
$string['settings_privatecomment_help'] = 'Ovde možete izmeniti tekst objašnjenja, u zavisnosti od toga kako vaša organizacija koristi diskusije između polaznika i savetnika/predavača/osobe koja administrira aktivnosti.';
$string['settings_privatecommenting'] = 'Omogući privatno komentarisanje';
$string['settings_privatecommenting_help'] = 'Tok privatne diskusije, koji je dostupan kada je pitanje na recenziji (sve dok se pitanje ne odobri), omogućava diskusiju između autora pitanja i onoga ko administrira aktivnost. Ako je režim StudenTesta podešen na\'Automatski objavi nova pitanja\', onda autor pitanja ne mora nužno da ikada vidi ovu diskusiju. Međutim, diskusija ostaje dostupna onima koji administriraju aktivnost bez obzira, ko bi mogao da je iskoristiti kako bi objasnio zašto je sakrio ili izbrisao pitanje. Standardno, privatno komentarisanje je definisano u podešavanjima dodatka na nivou servera.';
$string['settings_questionquantifier'] = 'Faktor za objavljena pitanja';
$string['settings_questionquantifier_help'] = 'Poeni za svako objavljeno pitanje';
$string['settings_questionquantifier_label'] = 'Poeni za svako objavljeno pitanje';
$string['settings_ratequantifier'] = 'Faktor ocene';
$string['settings_ratequantifier_help'] = 'Poeni za svaku dobijenu zvezdicu.';
$string['settings_ratequantifier_label'] = 'Multiplikator za prosečan zvezdica dobijenih za pitanje';
$string['settings_removeqbehavior'] = 'Ukloni dodatak za ponašanje pitanja StudenTest';
$string['settings_removeqbehavior_help'] = 'Ova informacija bi trebalo da se pojavi samo jednom tokom ažuriranja. Obaveštavamo vas da smo otkrili da je instaliran naš dodatak za ponašanje pitanja StudenTest. Ovaj dodatak više nije potreban i stoga pokušavamo da ga automatski uklonimo. Ako i dalje vidite ovo podešavanje, ručno deinstalirajte dodatak za ponašanje pitanja StudenTest <a href="{$a}">ovde</a>.';
$string['settings_removeqbehavior_label'] = 'Ukloni dodatak za ponašanje pitanja StudenTest';
$string['settings_reportingemail'] = 'Adresa e-pošta za prijavljivanje uvredljivih komentara';
$string['settings_reportingemail_help'] = 'Ako je ova adresa e-pošte navedena, ona će se pojaviti kao link za Prijavu pored svakog komentara. Korisnici će moći da kliknu na link kako bi prijavili uvredljive komentare. Informacija o tome biće poslate na ovu adresu.

Ako se polje za adresu e-pošte ostavi prazno, link za Prijavu neće biti prikazan (osim ako na nivou sajta nije podešena adresa za prijavu).

Moguće je dodati više adresa e-pošte, samo je potrebno one budu odvojene tačkom i zarezom.';
$string['settings_section_description_default'] = 'Ove vrednosti definišu podrazumevane vrednosti prilikom kreiranja nove aktivnosti StudenTesta.';
$string['settings_section_header_comment_rating'] = 'Podešavanje komentara i ocena';
$string['settings_section_header_commenting'] = 'Podešavanja komentara';
$string['settings_section_header_question'] = 'Podešavanja pitanja';
$string['settings_section_header_ranking'] = 'Podešavanja rangiranja';
$string['settings_showprivatecomment'] = 'Omogući diskusiju unutar privatnih komentara';
$string['settings_showprivatecomment_help'] = 'Ova opcija omogućava naprednu diskusiju između polaznika i predavača (nazivi uloga se mogu razlikovati u zavisnosti od organizacije) dok je pitanje na recenziji.';
$string['settingsdeleteorphaned'] = 'Obrišite napuštena pitanja';
$string['settingsdeleteorphaned_help'] = 'Aktivira planirani zadatak koji će se pokretati svaki dan kako bi se obrisala sva napuštena/neodobrena pitanja iz baze podataka.';
$string['settingsdeleteorphanedtime1y'] = '1 godina';
$string['settingsdeleteorphanedtime2y'] = '2 godine';
$string['settingsdeleteorphanedtime3y'] = '3 godine';
$string['settingsdeleteorphanedtime6m'] = '6 meseci';
$string['settingsdeleteorphanedtimelimit'] = 'Vremenski okvir za brisanje napuštenih pitanja';
$string['settingsdeleteorphanedtimelimit_help'] = 'Podesite vremenski okvir za brisanje napuštenih/neodobrenih pitanja. Pitanja koja su starija biće obrisana.';
$string['show_less'] = 'Prikaži manje';
$string['show_more'] = 'Prikaži više';
$string['slot_of_slot'] = 'Pitanje {$a->slot} od {$a->slots} u ovom skupu';
$string['start_quiz_button'] = 'Započnite test';
$string['state_approved'] = 'Odobreno';
$string['state_approvedlowercase'] = 'odobreno';
$string['state_approvedplural'] = 'Odobreno';
$string['state_change_tooltip_approved'] = 'Pitanje je odobreno. Kliknite ovde kako biste promenili status ovog pitanja';
$string['state_change_tooltip_changed'] = 'Pitanje je promenjeno. Kliknite ovde kako biste promenili status ovog pitanja';
$string['state_change_tooltip_disapproved'] = 'Pitanje nije odobreno. Kliknite ovde kako biste promenili status ovog pitanja';
$string['state_change_tooltip_new'] = 'Pitanje je novo. Kliknite ovde kako biste promenili status ovog pitanja';
$string['state_change_tooltip_reviewable'] = 'Pitanje je na recenziji. Kliknite ovde kako biste promenili status ovog pitanja';
$string['state_changed'] = 'Promenjeno';
$string['state_changedlowercase'] = 'promenjeno';
$string['state_changedplural'] = 'Promenjeno';
$string['state_column_name'] = 'Status';
$string['state_column_name_veryshort'] = 'S';
$string['state_deleted'] = 'Obrisano';
$string['state_deletedlowercase'] = 'obrisano';
$string['state_deletedplural'] = 'Obrisano';
$string['state_disapproved'] = 'Neodobreno';
$string['state_disapprovedlowercase'] = 'neodobreno';
$string['state_disapprovedplural'] = 'Neodobreno';
$string['state_hidden'] = 'Sakriveno';
$string['state_hiddenlowercase'] = 'sakriveno';
$string['state_hiddenplural'] = 'Sakriveno';
$string['state_new'] = 'Novo';
$string['state_newplural'] = 'Novo';
$string['state_pinned'] = 'Fiksirano';
$string['state_pinnedlowercase'] = 'pinned';
$string['state_pinnedplural'] = 'Fiksirano';
$string['state_reviewable'] = 'Na recenziji';
$string['state_reviewablelowercase'] = 'na_recenziji';
$string['state_reviewableplural'] = 'Na recenziji';
$string['state_shown'] = 'Prikazano';
$string['state_shownlowercase'] = 'prikazano';
$string['state_shownplural'] = 'Prikazano';
$string['state_toggle'] = 'Promeni status';
$string['state_unhiddenlowercase'] = 'unhidden';
$string['state_unpinnedlowercase'] = 'unpinned';
$string['statehistory'] = 'Istorija statusa';
$string['statistic_block_approvals'] = 'Odobrena pitanja';
$string['statistic_block_created'] = 'Kreirana pitanja';
$string['statistic_block_disapprovals'] = 'Neodobrena pitanja';
$string['statistic_block_new_changed'] = 'Nova /promenjena pitanja';
$string['statistic_block_progress_available'] = 'Dostupna pitanja';
$string['statistic_block_progress_last_attempt_correct'] = 'Poslednji pokušaj je tačan';
$string['statistic_block_progress_last_attempt_incorrect'] = 'Poslednji pokušaj je pogrešan';
$string['statistic_block_progress_never'] = 'Pitanja na koje nikad nije odgovoreno';
$string['statistic_block_title'] = 'Moj napredak';
$string['studentquiz'] = 'studentest';
$string['studentquiz:addinstance'] = 'Dodavanje nove instance StudenTesta';
$string['studentquiz:cancommentprivately'] = 'Slanje privatnih komentara na sva pitanja';
$string['studentquiz:canselfcommentprivately'] = 'Slanje privatnih komentara na sopstvena pitanja';
$string['studentquiz:canselfratecomment'] = 'Ocenjivanje i slanje javnih komentara na sopstvena pitanja koja su poslata na recenziju';
$string['studentquiz:changestate'] = 'Podešavanje statusa pitanja na StudenTestu';
$string['studentquiz:emailnotifyapproved'] = 'Obaveštenje o odobrenom pitanju';
$string['studentquiz:emailnotifychanged'] = 'Slanje obaveštenja o promenjenom pitanju';
$string['studentquiz:emailnotifycommentadded'] = 'Slanje obaveštenja o dodatom komentaru';
$string['studentquiz:emailnotifycommentdeleted'] = 'Slanje obaveštenja o obrisanom komentaru';
$string['studentquiz:emailnotifyquestion'] = 'Korisnik dobija obaveštenje putem e-pošte o promeni statusa njegovih pitanja';
$string['studentquiz:emailnotifyreviewablequestion'] = 'Korisnik dobija obaveštenje putem e-pošte kada polaznik promeni status svog pitanja tako što ga šalje na recenziju';
$string['studentquiz:manage'] = 'Uređivanje i brisanje pitanja na StudenTestu';
$string['studentquiz:organize'] = 'Premeštanje pitanja u kategorije na StudenTestu';
$string['studentquiz:pinquestion'] = 'Фиксирање питања на СтуденТесту';
$string['studentquiz:preview'] = 'Recenzija pitanja';
$string['studentquiz:previewothers'] = 'Recenzija pitanja drugih na StudenTestu';
$string['studentquiz:submit'] = 'Kreiranje pitanja na StudenTestu';
$string['studentquiz:systemnotifytaskdeleteorphanedquestions'] = 'Slanje obaveštenje o obrisanim napuštenim pitanjima';
$string['studentquiz:unhideanonymous'] = 'Pregled pravih imena čak i kada je aktivna anonimizacija učesnika';
$string['studentquiz:view'] = 'Pregled i korišćenje pitanja na StudenTestu';
$string['studentquizname'] = 'Naziv StudenTesta';
$string['studentquizname_help'] = 'Naziv ove aktivnosti StudenTest';
$string['submissionendbeforestart'] = 'Rok za slanje pitanja se ne može postaviti tako da bude pre datuma od kog je moguće slanje pitanja';
$string['tags'] = 'Oznake';
$string['unapprove'] = 'Poništi odobrenje';
$string['unpin'] = 'Ukloni fiksiranje sa pitanja';
$string['visiblegroupnotyetsupport'] = '\'Vidljive grupe\' još uvek nisu podržane. Izaberite drugi grupni režim.';
$string['weekly'] = 'sedmično';
