<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'message', language 'fr', version '4.2'.
 *
 * @package     message
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['acceptandaddcontact'] = 'Accepter et ajouter aux contacts';
$string['addcontact'] = 'Ajouter ce contact';
$string['addcontactconfirm'] = 'Voulez-vous vraiment ajouter {$a} à vos contacts ?';
$string['addtofavourites'] = 'Marquer la conversation comme favorite';
$string['addtoyourcontacts'] = 'Ajouter aux contacts';
$string['addtoyourcontactsandmessage'] = 'Ajouter aux contacts et envoyer un message';
$string['ago'] = 'Il y a {$a}';
$string['allusers'] = 'Tous les messages personnels de tous les utilisateurs';
$string['backto'] = 'Retour à {$a}';
$string['backupmessageshelp'] = 'Si ce paramètre est activé, les messages personnels seront inclus dans les sauvegardes automatiques du site';
$string['blockcontact'] = 'Bloquer ce contact';
$string['blockedusers'] = 'Utilisateurs bloqués';
$string['blocknoncontacts'] = 'Empêcher les utilisateurs hors liste de contacts de m’envoyer des messages personnels';
$string['blockuser'] = 'Bloquer l’utilisateur';
$string['blockuserconfirm'] = 'Voulez-vous vraiment bloquer {$a} ?';
$string['blockuserconfirmbutton'] = 'Bloc';
$string['cancelselection'] = 'Annuler la sélection de message';
$string['cantblockuser'] = 'Vous ne pouvez pas bloquer {$a} car leur rôle leur permet d’envoyer des messages à tous les utilisateurs';
$string['contactableprivacy'] = 'Accepter des messages de :';
$string['contactableprivacy_coursemember'] = 'Mes contacts et tout le monde dans mes cours';
$string['contactableprivacy_onlycontacts'] = 'Mes contacts seulement';
$string['contactableprivacy_site'] = 'Tout le monde sur le site';
$string['contactblocked'] = 'Contact bloqué';
$string['contactrequests'] = 'Demandes de contact';
$string['contactrequestsent'] = 'Demande de contact envoyée';
$string['contacts'] = 'Contacts';
$string['conversationactions'] = 'Menu d’actions de conversation';
$string['decline'] = 'Décliner';
$string['defaultmessageoutputs'] = 'Réglages de notification';
$string['defaults'] = 'Défauts';
$string['deleteallconfirm'] = 'Voulez-vous vraiment supprimer l’intégralité de cette conversation ? Cette opération ne la supprimera pas pour les autres participants à la conversation.';
$string['deleteallmessages'] = 'Supprimer tous les messages';
$string['deleteallselfconfirm'] = 'Voulez-vous vraiment supprimer l’intégralité de cette conversation personnelle ?';
$string['deleteconversation'] = 'Supprimer la conversation';
$string['deleteforeveryone'] = 'Supprimer pour moi et et pour tous les autres';
$string['deleteforeveryoneselectedmessagesconfirm'] = 'Voulez-vous vraiment supprimer les messages sélectionnés ?';
$string['deleteselectedmessages'] = 'Supprimer les messages sélectionnés';
$string['deleteselectedmessagesconfirm'] = 'Voulez-vous vraiment supprimer les messages sélectionnés ? Cette opération ne la supprimera pas pour les autres participants à la conversation.';
$string['deleteselectedmessagesconfirmselfconversation'] = 'Voulez-vous vraiment supprimer les messages personnels sélectionnés ?';
$string['disableall'] = 'Désactiver les notifications';
$string['disabled'] = 'La messagerie personnelle est désactivée sur ce site';
$string['disallowed'] = 'Verrouillé désactivé';
$string['editmessages'] = 'Modifier les messages';
$string['emailtagline'] = 'Ceci est une copie d’un message qui vous a été envoyé sur le site {$a->sitename}. Pour répondre, visitez <a href="{$a->url}">{$a->url}</a>.';
$string['enabled'] = 'Activé';
$string['errorcallingprocessor'] = 'Erreur lors de l’appel de la notification définie';
$string['errorconversationdoesnotexist'] = 'La conversation n’existe pas';
$string['errormessagetoolong'] = 'Le message est plus long que le maximum autorisé.';
$string['errortranslatingdefault'] = 'Erreur lors de la conversion d’un réglage par défaut fourni par le plugin. Utilisation des réglages par défaut du système.';
$string['eventgroupmessagesent'] = 'Message de groupe envoyé';
$string['eventmessagecontactadded'] = 'Contact de messagerie personnelle ajouté';
$string['eventmessagecontactremoved'] = 'Contact de messagerie personnelle supprimé';
$string['eventmessagedeleted'] = 'Message supprimé';
$string['eventmessagesent'] = 'Message personnel envoyé';
$string['eventmessageuserblocked'] = 'Utilisateur bloqué';
$string['eventmessageuserunblocked'] = 'Utilisateur débloqué';
$string['eventmessageviewed'] = 'Message consulté';
$string['eventnotificationsent'] = 'Notification envoyée';
$string['eventnotificationviewed'] = 'Notification consultée';
$string['forced'] = 'Verrouillé';
$string['forcedmessage'] = 'Verrouillé activé';
$string['groupconversations'] = 'Groupe';
$string['groupinfo'] = 'Info du groupe';
$string['guestnoeditmessage'] = 'Les visiteurs anonymes ne peuvent pas modifier les réglages de notification des messages';
$string['guestnoeditmessageother'] = 'Les visiteurs anonymes ne peuvent pas modifier les réglages de notification des messages des autres utilisateurs';
$string['hidemessagewindow'] = 'Cacher la fenêtre des messages';
$string['hidenotificationwindow'] = 'Cacher la fenêtre de notification';
$string['individualconversations'] = 'Privée';
$string['info'] = 'Info utilisateur';
$string['isnotinyourcontacts'] = '{$a} n’est pas dans vos contacts';
$string['loadmore'] = 'Charger plus';
$string['loggedin'] = 'En ligne';
$string['loggedin_help'] = 'Configurez comment vous désirez recevoir les notifications lorsque vous êtes connecté sur la plateforme';
$string['loggedindescription'] = 'Quand je suis connecté à Moodle';
$string['loggedoff'] = 'Hors ligne';
$string['loggedoff_help'] = 'Configurez comment vous désirez recevoir les notifications lorsque vous n’êtes pas connecté sur la plateforme';
$string['loggedoffdescription'] = 'Quand je ne suis pas connecté à Moodle';
$string['managemessageoutputs'] = 'Préférences de notification par défaut';
$string['message'] = 'Message personnel';
$string['messagecontactrequest'] = '{$a->user} demande à être ajouté comme contact. Veuillez visiter la page des <a href="{$a->url}">demandes de contact</a> pour répondre à la demande';
$string['messagecontactrequestsubject'] = '{$a->sitename} : demande de contact de {$a->user}';
$string['messagecontentaudio'] = 'Audio';
$string['messagecontentimage'] = 'Image';
$string['messagecontentmultimediageneral'] = 'Autre média';
$string['messagecontentvideo'] = 'Vidéo';
$string['messagedrawerviewcontact'] = 'Détails d’utilisateur de {$a}';
$string['messagedrawerviewcontacts'] = 'Contacts de messagerie personnelle';
$string['messagedrawerviewconversation'] = 'Conversation avec {$a}';
$string['messagedrawerviewgroupinfo'] = 'Détails de groupe pour {$a}';
$string['messagedrawerviewoverview'] = 'Vue d’ensemble des messages';
$string['messagedrawerviewsearch'] = 'Résultats de recherche de messages pour {$a}';
$string['messagedrawerviewsettings'] = 'Réglages de messagerie personnelle';
$string['messageoutputs'] = 'Plugins de notification';
$string['messagepreferences'] = 'Préférences des messages';
$string['messages'] = 'Messages personnels';
$string['messagesselected:'] = 'Messages sélectionnés :';
$string['messagetextrequired'] = 'Veuillez saisir un message';
$string['messagingdatahasnotbeenmigrated'] = 'Vos messages sont temporairement non disponibles en raison de la mise à jour de l’infrastructure de messagerie. Veuillez attendre la mise à jour des données de messagerie.';
$string['muteconversation'] = 'Mettre en sourdine';
$string['mutedconversation'] = 'Conversation en sourdine';
$string['newmessage'] = 'Nouveau message';
$string['newmessagesearch'] = 'Sélectionner ou rechercher un contact à qui envoyer un message.';
$string['newonlymsg'] = 'N’afficher que les nouveaux';
$string['nocontactrequests'] = 'Aucune demande de contact';
$string['nocontacts'] = 'Aucun contact';
$string['nocontactsgetstarted'] = 'Aucun contact';
$string['nofavourites'] = 'Aucune conversation favorite';
$string['noframesjs'] = 'Version plus accessible';
$string['nogroupconversations'] = 'Pas de conversation de groupe';
$string['noindividualconversations'] = 'Pas de conversation privée';
$string['nomessagesfound'] = 'Aucun message personnel trouvé';
$string['noncontacts'] = 'Non contact';
$string['nonotifications'] = 'Vous n’avez pas de notification';
$string['noparticipants'] = 'Aucun participant';
$string['noreply'] = 'Ne pas répondre à ce message';
$string['notificationdatahasnotbeenmigrated'] = 'Vos notifications sont temporairement non disponibles en raison de la mise à jour de l’infrastructure de notification. Veuillez attendre la mise à jour des données de notification.';
$string['notificationimage'] = 'Image de notification';
$string['notificationpreferences'] = 'Préférences de notification';
$string['notifications'] = 'Notifications';
$string['notificationwindow'] = 'Fenêtre de notification';
$string['notincontacts'] = 'Vous devez ajouter {$a} à vos contacts pour pouvoir lui envoyer des messages.';
$string['notincontactsheading'] = '{$a} n’est pas dans vos contacts';
$string['numparticipants'] = '{$a} participants';
$string['off'] = 'Désactivé';
$string['offline'] = 'Déconnecté';
$string['on'] = 'Activé';
$string['online'] = 'En ligne';
$string['otherparticipants'] = 'Autres participants';
$string['outputnotavailable'] = 'Non disponible';
$string['page-message-x'] = 'Toute page de messagerie';
$string['participants'] = 'Participants';
$string['pendingcontactrequests'] = 'Il y a {$a} demandes de contact en attente';
$string['permitted'] = 'Autorisé';
$string['privacy'] = 'Confidentialité';
$string['privacy:export:conversationprefix'] = 'Conversation :';
$string['privacy:metadata:core_favourites'] = 'Les conversations marquées comme favorites par l’utilisateur';
$string['privacy:metadata:message_contact_requests'] = 'La liste des demandes de contact';
$string['privacy:metadata:message_contact_requests:requesteduserid'] = 'L’identifiant de l’utilisateur qui a reçu la demande de contact';
$string['privacy:metadata:message_contact_requests:timecreated'] = 'La date et l’heure à laquelle la demande de contact a été créée';
$string['privacy:metadata:message_contact_requests:userid'] = 'L’identifiant de l’utilisateur qui a envoyé la demande de contact';
$string['privacy:metadata:message_contacts'] = 'La liste des contacts';
$string['privacy:metadata:message_contacts:contactid'] = 'L’identifiant de l’utilisateur qui est un contact';
$string['privacy:metadata:message_contacts:timecreated'] = 'La date et l’heure à laquelle le contact a été créé';
$string['privacy:metadata:message_contacts:userid'] = 'L’identifiant de l’utilisateur dont c’est la liste de contacts';
$string['privacy:metadata:message_conversation_actions'] = 'La liste des actions de conversation de l’utilisateur';
$string['privacy:metadata:message_conversation_actions:action'] = 'L’action effectuée';
$string['privacy:metadata:message_conversation_actions:conversationid'] = 'L’identifiant de la conversation à laquelle appartient cette action';
$string['privacy:metadata:message_conversation_actions:timecreated'] = 'La date et l’heure de la création de l’action';
$string['privacy:metadata:message_conversation_actions:userid'] = 'L’identifiant de l’utilisateur qui a effectué l’action';
$string['privacy:metadata:message_conversation_members'] = 'La liste des utilisateurs de la conversation';
$string['privacy:metadata:message_conversation_members:conversationid'] = 'L’identifiant de la conversation';
$string['privacy:metadata:message_conversation_members:timecreated'] = 'La date et l’heure à laquelle le membre a été créé';
$string['privacy:metadata:message_conversation_members:userid'] = 'L’identifiant de l’utilisateur dans la conversation';
$string['privacy:metadata:message_user_actions'] = 'La liste des actions utilisateur du message';
$string['privacy:metadata:message_user_actions:action'] = 'L’action effectuée';
$string['privacy:metadata:message_user_actions:messageid'] = 'L’identifiant du message auquel cette action appartient';
$string['privacy:metadata:message_user_actions:timecreated'] = 'La date et l’heure de la création de l’action';
$string['privacy:metadata:message_user_actions:userid'] = 'L’identifiant de l’utilisateur qui a effectué cette action';
$string['privacy:metadata:message_users_blocked'] = 'La liste des utilisateurs bloqués';
$string['privacy:metadata:message_users_blocked:blockeduserid'] = 'L’identifiant de l’utilisateur qui a été bloqué';
$string['privacy:metadata:message_users_blocked:timecreated'] = 'La date et l’heure à laquelle l’action de blocage a été créée';
$string['privacy:metadata:message_users_blocked:userid'] = 'L’identifiant de l’utilisateur qui a effectué l’action de blocage';
$string['privacy:metadata:messages'] = 'Messages';
$string['privacy:metadata:messages:conversationid'] = 'L’identifiant de la conversation';
$string['privacy:metadata:messages:customdata'] = 'Données personnalisées, qui contiennent habituellement des identifiants internes et une URL publique de l’image de l’expéditeur (utilisateur ou groupe).';
$string['privacy:metadata:messages:fullmessage'] = 'Le message complet';
$string['privacy:metadata:messages:fullmessageformat'] = 'Le format du message complet';
$string['privacy:metadata:messages:fullmessagehtml'] = 'Le message complet en format HTML';
$string['privacy:metadata:messages:smallmessage'] = 'Une version abrégée du message';
$string['privacy:metadata:messages:subject'] = 'L’objet du message';
$string['privacy:metadata:messages:timecreated'] = 'La date et l’heure de la création du message';
$string['privacy:metadata:messages:useridfrom'] = 'L’identifiant de l’expéditeur du message';
$string['privacy:metadata:notifications'] = 'Notifications';
$string['privacy:metadata:notifications:component'] = 'Le composant responsable de l’envoi de la notification';
$string['privacy:metadata:notifications:contexturl'] = 'L’URL en lien avec cette notification';
$string['privacy:metadata:notifications:contexturlname'] = 'Le nom du contexte';
$string['privacy:metadata:notifications:customdata'] = 'Données personnalisées, qui contiennent habituellement des identifiants internes et une URL publique de l’image de l’expéditeur (le cas échéant).';
$string['privacy:metadata:notifications:eventtype'] = 'Le type d’événement';
$string['privacy:metadata:notifications:fullmessage'] = 'La notification complète';
$string['privacy:metadata:notifications:fullmessageformat'] = 'Le format de la notification';
$string['privacy:metadata:notifications:fullmessagehtml'] = 'La notification en format HTML';
$string['privacy:metadata:notifications:smallmessage'] = 'La notification abrégée de la notification';
$string['privacy:metadata:notifications:subject'] = 'L’objet de la notification';
$string['privacy:metadata:notifications:timecreated'] = 'La date et l’heure de la création de la notification';
$string['privacy:metadata:notifications:timeread'] = 'La date et l’heure de la lecture de la notification';
$string['privacy:metadata:notifications:useridfrom'] = 'L’identifiant de l’expéditeur de la notification';
$string['privacy:metadata:notifications:useridto'] = 'L’identifiant du destinataire de la notification';
$string['privacy:metadata:preference:core_message_settings'] = 'Réglages en lien avec la messagerie';
$string['privacy:request:preference:set'] = 'La valeur du réglage « {$a->name} » est « {$a->value} »';
$string['privacy_desc'] = 'Vous pouvez choisir qui peut vous envoyer un message personnel';
$string['processorsettings'] = 'Réglage du processus d’envoi de messages';
$string['providerenabled'] = 'Statut d’activation de l’envoi de « {$a} »';
$string['providerprocesorisdisallowed'] = '« {$a->provider} » par « {$a->processor} » est verrouillé en mode désactivé';
$string['providerprocesorislocked'] = '« {$a->provider} » par « {$a->processor} » est verrouillé en mode activé';
$string['removecontact'] = 'Supprimer ce contact';
$string['removecontactconfirm'] = 'Voulez-vous vraiment retirer {$a} de vos contacts ?';
$string['removecoursefilter'] = 'Supprimer le filtre pour le cours {$a}';
$string['removefromfavourites'] = 'Retirer la conversation des favoris';
$string['removefromyourcontacts'] = 'Retirer des contacts';
$string['requirecontacttomessage'] = 'Vous devez demander à {$a} de vous ajouter comme contact pour pouvoir lui envoyer un message.';
$string['requiresconfiguration'] = 'Nécessite configuration';
$string['searchcombined'] = 'Rechercher des personnes et des messages';
$string['searchforuser'] = 'Rechercher un utilisateur';
$string['searchforuserorcourse'] = 'Rechercher un utilisateur ou un cours';
$string['searchmessages'] = 'Rechercher des messages personnels';
$string['seeall'] = 'Tout afficher';
$string['selectmessagestodelete'] = 'Sélectionner les messages à supprimer';
$string['selectnotificationtoview'] = 'Sélectionner une notification dans la liste de côté pour afficher plus d’informations';
$string['selfconversation'] = 'Espace personnel';
$string['selfconversationdefaultmessage'] = 'Enregistrer des brouillons, liens, note, etc. pour un usage ultérieur.';
$string['send'] = 'Envoyer';
$string['sendbulkmessage'] = 'Envoyer le message à {$a} personnes';
$string['sendbulkmessagesent'] = 'Message envoyé à {$a} personnes';
$string['sendbulkmessagesentsingle'] = 'Message envoyé à 1 personne';
$string['sendbulkmessagesingle'] = 'Envoyer le message à 1 personne';
$string['sendcontactrequest'] = 'Envoyer une demande de contact';
$string['sender'] = '{$a} :';
$string['sendingvia'] = 'Envoi de « {$a->provider} » via « {$a->processor} »';
$string['sendingviaenabled'] = 'Statut d’activation de l’envoi de « {$a->provider} » via « {$a->processor} »';
$string['sendingvialocked'] = 'Statut de verrouillage de l’envoi de « {$a->provider} » via « {$a->processor} »';
$string['sendingviawhen'] = 'Envoi de « {$a->provider} » via « {$a->processor} » quand {$a->state}';
$string['sendmessage'] = 'Envoyer message personnel';
$string['sendmessageto'] = 'Envoyer message personnel à {$a}';
$string['sendmessagetopopup'] = 'Envoyer message personnel à {$a} - nouvelle fenêtre';
$string['settings'] = 'Réglages';
$string['showmessagewindownonew'] = 'Afficher la fenêtre des messages sans nouveau message';
$string['showmessagewindowwithcount'] = 'Afficher la fenêtre des messages avec {$a} nouveaux messages';
$string['shownotificationwindownonew'] = 'Afficher la fenêtre des notifications sans nouvelle notification';
$string['shownotificationwindowwithcount'] = 'Afficher la fenêtre des notifications avec {$a} nouvelles notifications';
$string['togglemessagemenu'] = 'Ouvrir/fermer le tiroir des messages';
$string['togglenotificationmenu'] = 'Ouvrir/fermer le menu notifications';
$string['totalconversations'] = '{$a} conversations';
$string['touserdoesntexist'] = 'Vous ne pouvez pas envoyer de message à un utilisateur (ID {$a}) qui n’existe pas.';
$string['unabletomessage'] = 'Vous ne pouvez pas envoyer un message à cet utilisateur';
$string['unblock'] = 'Débloquer';
$string['unblockcontact'] = 'Débloquer ce contact';
$string['unblockuser'] = 'Débloquer l’utilisateur';
$string['unblockuserconfirm'] = 'Voulez-vous vraiment débloquer {$a} ?';
$string['unknownuser'] = 'Utilisateur inconnu';
$string['unmuteconversation'] = 'Enlever la sourdine';
$string['unreadconversations'] = 'Il y a {$a} conversations non lues';
$string['unreadmessages'] = 'Il y a {$a} messages non lus';
$string['unreadnewgroupconversationmessage'] = 'Nouveau message de {$a->name} à {$a->conversationname}';
$string['unreadnewmessage'] = 'Nouveau message de {$a}';
$string['unreadnotification'] = 'Notifications non lues : {$a}';
$string['unreadnotifications'] = 'Il y a {$a} notifications non lues';
$string['useentertosend'] = 'Taper entrée pour envoyer';
$string['usercantbemessaged'] = 'Vous ne pouvez pas envoyer de message à cet utilisateur en raison de leurs préférences de messagerie personnelle. Essayez de les ajouter à vos contacts.';
$string['userwouldliketocontactyou'] = '{$a} aimerait vous contacter';
$string['viewfullnotification'] = 'Afficher la notification complète';
$string['viewmessageswith'] = 'Consulter les messages avec {$a}';
$string['viewnotificationresource'] = 'Aller à {$a}';
$string['viewunreadmessageswith'] = 'Consulter les messages non lus avec {$a}';
$string['wouldliketocontactyou'] = 'Aimerait vous contacter';
$string['writeamessage'] = 'Écrire un message';
$string['you'] = 'Vous :';
$string['youhaveblockeduser'] = 'Vous avez bloqué cet utilisateur.';
$string['yourcontactrequestpending'] = 'Votre demande de contact avec {$a} est en suspens';
