<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'auth_ldap', language 'sl', version '4.2'.
 *
 * @package     auth_ldap
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['auth_ldap_ad_create_req'] = 'Ne morem ustvariti novega uporabniškega računa v Active Directory. Preverite, če so izpolnjeni vsi pogoji za delovanje (povezava LDAPS, uporabnik bind z dovoljšnimi pravicami ipd.)';
$string['auth_ldap_attrcreators'] = 'Spisek skupin ali kontekstov, katerih člani lahko ustvarjajo atribute. Različne skupine ločite z \';\'. Običajno tako: ‚cn=teachers, ou=staff,o=myorg\'';
$string['auth_ldap_attrcreators_key'] = 'Ustvarjalci atributov';
$string['auth_ldap_auth_user_create_key'] = 'Zunanje tvorjenje uporabnikov';
$string['auth_ldap_bind_dn'] = 'Če želite uporabiti povezovalnega uporabnika (bind-user) za iskanje uporabnikov, ga tu navedite. Nekaj kot \'cn=ldapuser,ou=public,o=org\'';
$string['auth_ldap_bind_dn_key'] = 'Razlikovalno ime';
$string['auth_ldap_bind_pw'] = 'Geslo za povezovalnega uporabnika.';
$string['auth_ldap_bind_pw_key'] = 'Geslo';
$string['auth_ldap_bind_settings'] = 'Nastavitve';
$string['auth_ldap_changepasswordurl_key'] = 'URL za spreminjanje gesla';
$string['auth_ldap_contexts'] = 'Seznam kontekstov kjer se nahajajo uporabniki. Različne kontekste ločite s podpičjem \';\'. Na primer: ‚ou=users, o=org; ou=others,o=org';
$string['auth_ldap_contexts_key'] = 'Konteksti';
$string['auth_ldap_create_context'] = 'Če omogočite ustvarjanje uporabnika s potrditvijo prek elektronske pošte, opredelite kontekst, v katerem se uporabniki ustvarijo. Zaradi varnostnih razlogov bi moral biti ta kontekst različen od ostalih uporabnikov. Konteksta vam ni potrebno dodati v spremenljivko ldap_context, saj bo Moodle iskal uporabnike v tem kontekstu samodejno.<br /><b>Opomba! </b> Spremeniti morate funkcijo auth_user_create() v datoteki auth/ldap/lib.php, da bo delovalo ustvarjanje uporabnikov';
$string['auth_ldap_create_context_key'] = 'Kontekst za nove uporabnike';
$string['auth_ldap_create_error'] = 'Napaka pri tvorjenju uporabnika v LDAP';
$string['auth_ldap_expiration_desc'] = 'Izberite \'{$a->no}\', če želite onemogočiti preverjanje pretečenga gesla ali \'{$a->ldapserver}‘, če želite preveriti veljavnost gesla neposredno s strežnika LDAP.';
$string['auth_ldap_expiration_key'] = 'Potek';
$string['auth_ldap_expiration_warning_desc'] = 'Število dni pred potekom gesla za prikaz opozorila o tem.';
$string['auth_ldap_expiration_warning_key'] = 'Opozorilo o poteku';
$string['auth_ldap_expireattr_desc'] = 'Neobvezno: preglasi atribut LDAP, ki shranjuje datum veljavnosti gesla';
$string['auth_ldap_expireattr_key'] = 'Atribut veljavnosti';
$string['auth_ldap_graceattr_desc'] = 'Neobvezno: Preglasi atribut podaljšane prijave';
$string['auth_ldap_gracelogin_key'] = 'Atribut podaljšane prijave';
$string['auth_ldap_gracelogins_desc'] = 'Omogoči podporo za podaljšano prijavo LDAP (grace login). Ko geslo poteče, se lahko uporabnik še vedno prijavi, dokler ni števec gracelogin enak 0. Če imate to funkcijo omogočeno, se bo prikazalo sporočilo o podaljšani prijavi, če je geslo poteklo.';
$string['auth_ldap_gracelogins_key'] = 'Podaljšana prijava';
$string['auth_ldap_groupecreators'] = 'Spisek skupin ali kontekstov, katerih člani lahko ustvarjajo skupine. Različne skupine ločite z \';\'. Običajno tako: ‚cn=teachers, ou=staff,o=myorg\'';
$string['auth_ldap_groupecreators_key'] = 'Ustvarjalci skupin';
$string['auth_ldap_host_url'] = 'Določite gostitelja LDAP v obliki URL kot \'ldap://ldap.myorg.com/\' ali \'ldaps://ldap.myorg.com/\' Ločite vel strežnikov s podpičjem \';\' za podporo prevzema v primeru odpovedi (failover).';
$string['auth_ldap_host_url_key'] = 'URL gostitelja';
$string['auth_ldap_ldap_encoding'] = 'Določite jezik kodiranja strežnika LDAP (najverjetneje utf-8). Če imate izbran LDAP v2, Active Directory uporablja konfigurirano kodiranje, kot je cp1252 ali cp1250.';
$string['auth_ldap_ldap_encoding_key'] = 'LDAP kodiranje';
$string['auth_ldap_login_settings'] = 'Nastavitve prijave';
$string['auth_ldap_memberattribute'] = 'Neobvezno: Preglasi atribut uporabnikovega članstva, če uporabnik pripada skupini. Običajno \'member\'';
$string['auth_ldap_memberattribute_isdn'] = 'Neobvezno: Preglasi uporabo vrednosti atributov članov.';
$string['auth_ldap_memberattribute_isdn_key'] = 'Atribut člana uporablja dn';
$string['auth_ldap_memberattribute_key'] = 'Atribut člana';
$string['auth_ldap_no_mbstring'] = 'Za tvorjenje uporabnikov v Active Directory potrebujete razširitev mbstring.';
$string['auth_ldap_noconnect'] = 'Modul LDAP se ne more povezati s strežnikom: {$a}';
$string['auth_ldap_noconnect_all'] = 'Modul LDAP se ne more povezati z nobenim od strežnikov: {$a}';
$string['auth_ldap_noextension'] = 'Izgleda, da modul PHP LDAP ni prisoten. Če želite uporabljati ta vtičnik za preverjanje pristnosti, preverite, ali je pravilno nameščen in vklopljen.';
$string['auth_ldap_objectclass'] = 'Neobvezno: Preglasi objectClass uporabljen za imenovanje/iskanje uporabnikov v ldap_user_type. Običajno vam tega ni potrebno spreminjati.';
$string['auth_ldap_objectclass_key'] = 'Predmet razreda';
$string['auth_ldap_opt_deref'] = 'Določi, kako se ob iskanju obravnavajo vzdevki. Izberite eno od naslednjih vrednosti: "Ne" (LDAP_DEREF_NEVER) ali "Da" (LDAP_DEREF_ALWAYS)';
$string['auth_ldap_opt_deref_key'] = 'Odpriporoči vzdevke';
$string['auth_ldap_passtype'] = 'Določite format novih ali spremenjenih gesel na strežniku LDAP';
$string['auth_ldap_passtype_key'] = 'Oblika gesla';
$string['auth_ldap_passwdexpire_settings'] = 'Nastavitve poteka LDAP gesla.';
$string['auth_ldap_preventpassindb'] = 'Izberite "Da" za preprečevanje hranjenja gesel v podatkovni bazi Moodle.';
$string['auth_ldap_preventpassindb_key'] = 'Skrij gesla';
$string['auth_ldap_rolecontext'] = '{$a->localname} contekst';
$string['auth_ldap_rolecontext_help'] = 'Za preslikavo LDAP <i>{$a->localname}</i> se uporablja kontekst LDAP. Posamezne skupine ločite z \';\'. Običajno tako: »cn={$a->shortname}, ou=staff,o=myorg".';
$string['auth_ldap_search_sub'] = 'Išči uporabnike v podkontekstih.';
$string['auth_ldap_search_sub_key'] = 'Išči po podvsebinah';
$string['auth_ldap_server_settings'] = 'Nastavitve strežnika LDAP';
$string['auth_ldap_suspended_attribute'] = 'Neobvezno: S tem atributom lahko omogočite/onemogočite lokalno ustvarjen uporabniški račun.';
$string['auth_ldap_suspended_attribute_key'] = 'Onemogočen atribut';
$string['auth_ldap_unsupportedusertype'] = 'auth: ldap user_create() (še) ne podpira izbranega tipa uporabnika:"{$a}"';
$string['auth_ldap_update_userinfo'] = 'Posodobi podatke o uporabniku (ime, priimek, naslov...) iz strežnika LDAP v Moodle. Poljubno določite nastavitve "Preslikava podatkov".';
$string['auth_ldap_user_attribute'] = 'Neobvezno: Preglasi atribut, uporabljen za določanje/iskanje uporabnikov. Običajno \'cn\'.';
$string['auth_ldap_user_attribute_key'] = 'Atribut uporabnika';
$string['auth_ldap_user_exists'] = 'Uporabniško ime že obstaja v LDAP';
$string['auth_ldap_user_settings'] = 'Nastavitve poizvedb uporabnikov';
$string['auth_ldap_user_type'] = 'Izberite, kako so uporabniki shranjeni v LDAP-u. Ta nastavitev tudi določa način delovanja poteka prijave, podaljšane prijave in ustvarjanja uporabnikov.';
$string['auth_ldap_user_type_key'] = 'Vrsta uporabnika';
$string['auth_ldap_usertypeundefined'] = 'config.user_type ni definiran ali pa funkcija ldap_expirationtime2unix ne podpira izbranega tipa!';
$string['auth_ldap_usertypeundefined2'] = 'config.user_type ni definiran ali pa funkcija ldap_unixi2expirationtime ne podpira izbranega tipa!';
$string['auth_ldap_version'] = 'Različica protokola LDAP, ki ga uporablja vaš strežnik.';
$string['auth_ldap_version_key'] = 'Različica';
$string['auth_ldapdescription'] = 'Ta način omogoča preverjanje prisotnosti na zunanjem LDAP strežniku. Če sta podana uporabniško ime in geslo veljavna, Moodle v podaktovni bazi ustvari nov vnos uporabnika. Vtičnik lahko prebere uporabnikove atribute s strežnika LDAP in vnaprej izpolni zahtevana polja v Moodlu. Pri prihodnjih prijavah se preverita samo uporabniško ime in geslo.';
$string['auth_ldapextrafields'] = 'Ta polja niso obvezna. Nekatera uporabniška polja lahko vnaprej izpolnite s podatki iz <b>LDAP polj</b>, ki jih tu določite. <p>Če pustite ta polja prazna, se ne bo nič preneslo s strežnika LDAP, namesto tega pa bodo uporabljene privzete vrednosti Moodle.</p><p>V obeh primerih bo uporabnik po prijavi lahko uredil vsa ta polja.</p>';
$string['auth_ldapnotinstalled'] = 'Napaka pri uporabi LDAP preverjanju pristnosti. Modul PHP LDAP ni nameščen.';
$string['auth_ntlmsso'] = 'NLTM SSO';
$string['auth_ntlmsso_enabled'] = 'Nastavite na "Da", če želite omogočiti enotno prijavo na domeni NTLM.<strong>Opomba: </strong> ta funkcija potrebuje dodatne nastavitve na spletnem strežniku. Za več informacij si oglejte <a href="http://docs.moodle.org/en/NTLM_authentication">http://docs.moodle.org/en/NTLM_authentication</a>';
$string['auth_ntlmsso_enabled_key'] = 'Omogoči';
$string['auth_ntlmsso_ie_fastpath'] = 'Nastavite na "Da", če želite omogočiti hitro pot NTLM SSO (zaobide določene korake in deluje samo, če uporabnik uporablja brskalnik MS Internet Explorer)';
$string['auth_ntlmsso_ie_fastpath_attempt'] = 'Poskusi omogočiti NTLM v vseh brskalnikih';
$string['auth_ntlmsso_ie_fastpath_key'] = 'MS IE hitra pot?';
$string['auth_ntlmsso_ie_fastpath_yesattempt'] = 'Da, poskusi omogočiti NTLM v drugih brskalnikih';
$string['auth_ntlmsso_ie_fastpath_yesform'] = 'Da, vsi ostali brskalniki uporabljajo privzeto obliko prijave';
$string['auth_ntlmsso_maybeinvalidformat'] = 'Uporabniškega imena ni mogoče izvleči iz glave REMOTE_USER. Ali je konfigurirani format pravilen?';
$string['auth_ntlmsso_missing_username'] = 'V formatu oddaljenega uporabniškega imena je treba določiti vsaj %username%';
$string['auth_ntlmsso_remoteuserformat'] = 'Če ste pri \'Vrsta preverjanja pristnosti\' izbrali \'NTLM\', lahko zdaj izberete format oddaljenega uporabniškega imena. Če pustite polje prazno, bo uporabljen prevzeti format uporabniškega imena DOMAIN\\. Če želite, si lahko nastavite spremenljivko <b>%domain%</b> in določite mesto imena domene, obezno pa morate izbrati spremenljivko <b>%username%</b>, s katero določite mesto uporabniškega imena. <br /><br />Najpogosteje uporabljeni formati so: <tt>%domain%\\%username%</tt> (prevzeto za MS Windows), <tt>%domain%/%username%</tt>, <tt>%domain%+%username%</tt> ali <tt>%username%</tt> (če domenski del ne obstaja).';
$string['auth_ntlmsso_remoteuserformat_key'] = 'Format oddaljenega uporabniškega imena';
$string['auth_ntlmsso_subnet'] = 'Če je omogočeno, bo enkratna prijava dovoljena samo odjemalcem v tem pod-omrežju (subnet). Format: xxx.xxx.xxx.xxx/bitmask. Pod-omrežja ločite z \',\' (vejico).';
$string['auth_ntlmsso_subnet_key'] = 'Pod-omrežje';
$string['auth_ntlmsso_type'] = 'Način preverjanja pristnosti, nastavljen na spletnem strežniku za overjanje uporabnikov (če ste v dvomih, izberite NTLM)';
$string['auth_ntlmsso_type_key'] = 'Tip preverjanja pristnosti';
$string['cannotmaprole'] = 'Vloge "{$a->rolename}" ni mogoče preslikati, ker je kratko ime "{$a->shortname}" predolgo in/ali vsebuje vezaje. Če želite, da se ime vloge preslika, lahko kratko ime vsebuje največ {$a->charlimit} znakov in mora biti brez vezajev. <a href="{$a->link}">Edit the role</a>';
$string['connectingldap'] = 'Povezovanje s strežnikom LDAP...';
$string['connectingldapsuccess'] = 'Povezovanje s strežnikom LDAP je uspelo';
$string['creatingtemptable'] = 'Ustvarjanje začasne tabele {$a}';
$string['diag_contextnotfound'] = 'Kontekst {$a} ne obstaja oziroma ga bind DN ne more prebrati.';
$string['diag_emptycontext'] = 'Najdeni prazni konteksti.';
$string['diag_genericerror'] = 'Napaka LDAP{$a->code} pri branju {$a->subject}: {$a->message}.';
$string['diag_rolegroupnotfound'] = 'Skupina {$a->group} za vlogo {$a->localname} ne obstaja oziroma je bind DN ne more prebrati.';
$string['diag_toooldversion'] = 'Novejši strežniki LDAP običajno ne uporabljajo protokola LDAPv2. Z napačnimi nastavitvami se lahko vrednosti v uporabniških poljih poškodujejo. Preverite pri skrbniku LDAP.';
$string['didntfindexpiretime'] = 'password_expire() ne najde datuma veljavnosti.';
$string['didntgetusersfromldap'] = 'Iz LDAP ni prebralo nobenega uporabnika -- napaka? -- izhod';
$string['gotcountrecordsfromldap'] = 'Pridobljenih {$a} zapisov iz LDAP';
$string['ldapnotconfigured'] = 'LDAP url gostitelja trenutno ni konfiguriran';
$string['morethanoneuser'] = 'Nenavadno! Najden več kot en uporabniški zapis v LDAP. Uporabljen bo samo prvi.';
$string['needbcmath'] = 'Potrebujete razširitev BCMath razširitev za preverjanje pretečenih gesel v Active Directory.';
$string['needmbstring'] = 'Potrebujete razširitev mbstring, če želite zamenjati gesla v Active Directory';
$string['nodnforusername'] = 'Napaka na user_update_password(). Ni DN za: {$a->username}';
$string['noemail'] = 'Napaka pri poskusu pošiljanja e-pošte!';
$string['notcalledfromserver'] = 'Ne sme biti poklican s spletnega strežnika!';
$string['noupdatestobedone'] = 'Posodobitve niso potrebne';
$string['nouserentriestoremove'] = 'Ni uporabniških vnosov za izbris';
$string['nouserentriestorevive'] = 'Ni uporabniških vnosov za obnovo';
$string['nouserstobeadded'] = 'Ni uporabnikov za dodajanje';
$string['ntlmsso_attempting'] = 'Poskušam z enotno prijavo prek NTLM...';
$string['ntlmsso_failed'] = 'Samodejna prijava ni uspela. Poskusite z običajno prijavo.';
$string['ntlmsso_isdisabled'] = 'Enkratna prjava NTLM ni omogočena.';
$string['ntlmsso_unknowntype'] = 'Neznan ntlmsso tip!';
$string['pagedresultsnotsupp'] = 'Razvrščanje rezultatov na strani LDAP ni podprto (možno je, da vaša verzija PHP nima dovoljšne podpore, ali pa ste Moodle konfigurirali tako, da uporablja 2. verzijo protokola LDAP, ali pa Moodle ne more vzpostaviti povezave z vašim strežnikom LDAP, da bi preveril, ali je razvrščanje po straneh mogoče).';
$string['pagesize'] = 'Pazite, da je vrednost manjša od omejitve, ki jo ima strežnik LDAP za prikazovanje rezultatov (največje število vnosov, ki jih lahko prikaže v posameznem iskanju)';
$string['pagesize_key'] = 'Velikost strani';
$string['pluginname'] = 'Strežnik LDAP';
$string['pluginnotenabled'] = 'Vtičnik ni omogočen!';
$string['privacy:metadata'] = 'Vtičnik strežnika LDAP za preverjanje pristnosti ne shranjuje osebnih podatkov.';
$string['renamingnotallowed'] = 'Preimenovanje uporabnikov v LDAP ni dovoljeno';
$string['rootdseerror'] = 'Napaka poizvedbe rootDSE za aktivni imenik';
$string['start_tls'] = 'Uporabi običajno storitev LDAP (vrata 389) s šifriranjem TLS';
$string['start_tls_key'] = 'Uporabi TLS';
$string['syncroles'] = 'Sinhroniziraj sistemske vloge z LDAP';
$string['synctask'] = 'Opravilo sinhronizacije uporabnikov LDAP';
$string['systemrolemapping'] = 'Preslikovanje sistemskih vlog';
$string['updatepasserror'] = 'Napaka v user_update_password(). Koda napake: {$a->errno}; Niz napake: {$a->errstring}';
$string['updatepasserrorexpire'] = 'Napaka v user_update_password() pri branju veljavnosti gesel. Koda napake: {$a->errno}; Niz napake: {$a->errstring}';
$string['updatepasserrorexpiregrace'] = 'Napaka v user_update_password() pri spremljanju izteka časa in/ali "grace" prijave. Koda napake: {$a->errno}; niz napake: {$a->errstring}';
$string['updateremfail'] = 'Napaka pri posodobitvi LDAP zapisa. Koda napake: {$a->errno}; Niz napake: {$a->errstring}<br/>Ključ ({$a->key}) - stara moodle vrednost: \'{$a->ouvalue}\' nova vrednost: \'{$a->nuvalue}\'';
$string['updateremfailamb'] = 'Posodobitev LDAP z nejasnim poljem {$a->key} ni uspela; stara moodle vrednost: \'{$a->ouvalue}\', nova vrednost: \'{$a->nuvalue}\'';
$string['updateusernotfound'] = 'Med zunanjim posodabljanjem ni mogoče najti uporabnika. Podrobnosti: iskalna baza: \'{$a->userdn}\'; iskalni filter: \'(objectClass=*)\'; iskalni atributi: {$a->attribs}';
$string['user_activatenotsupportusertype'] = 'auth: ldap user_activate() ne podpira izbrane vrste uporabnika: {$a}';
$string['user_disablenotsupportusertype'] = 'auth: ldap user_disable() ne podpira izbrane vrste uporabnika: {$a}';
$string['useracctctrlerror'] = 'Napaka pri pridobivanju userAccountControl za {$a}';
$string['userentriestoadd'] = 'Uporabniški vnosi za dodajanje: {$a}';
$string['userentriestoremove'] = 'Zapis uporabnika za izbris: {$a}';
$string['userentriestorevive'] = 'Uporabniški vnosi za obnovo: {$a}';
$string['userentriestoupdate'] = 'Uporabniški vnosi za posodobitev: {$a}';
$string['usernotfound'] = 'Uporabnika ni mogoče najti v LDAP';
