<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'format_topcoll', language 'pt_br', version '4.2'.
 *
 * @package     format_topcoll
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addsection'] = 'Adicionar seção';
$string['arrow'] = 'Seta';
$string['bulb'] = 'Lâmpada';
$string['cachedef_activitymodulecountcache'] = 'Faz cache do número de estudantes que podem acessar um determinado módulo em um determinado curso.';
$string['cachedef_activitystudentrolescache'] = 'Faz cache dos papéis dos estudantes.';
$string['cachedef_activitystudentscache'] = 'Faz cache dos IDs dos estudantes em um determinado curso.';
$string['cachedef_activityusercreatedcache'] = 'Faz cache dos IDs dos novos usuários em um determinado curso.';
$string['cannotgetactivitycacheslock'] = 'Não é possível obter o bloqueio de cache da atividade para o ID do curso {$a}.';
$string['center'] = 'Centro';
$string['cloud'] = 'Nuvem';
$string['colourrule'] = 'Por favor, insira uma cor RGB válida, seis dígitos hexadecimais ou "-" para o padrão.';
$string['columndynamic'] = 'Dinâmico';
$string['columnhorizontal'] = 'Horizontal';
$string['columnvertical'] = 'Vertical';
$string['configurationheadingsub'] = 'Configuração';
$string['configurationheadingsubdesc'] = 'Configurações de nível do site';
$string['courseadditionalmoddatamaxstudents'] = 'Defina o número máximo de estudantes em um curso para o qual "Mostrar informações adicionais" será aplicado';
$string['courseadditionalmoddatamaxstudentsdesc'] = 'As informações adicionais podem levar tempo para serem calculadas, especialmente em cursos grandes. Aqui, você pode definir o número máximo de estudantes que um curso pode ter para que a funcionalidade seja exibida naquele curso. Acima desse valor, as "Informações adicionais" NÃO serão calculadas ou exibidas, independentemente das configurações do curso! Um valor de "0" significa "ilimitado". Observação: Limpa os caches de cache quando alterado.';
$string['courseadditionalmoddatastudentsinfo'] = 'Status das informações adicionais:';
$string['courseadditionalmoddatastudentsinfolimitednoshow'] = 'Informações adicionais NÃO serão exibidas para as atividades habilitadas para {$a->students} estudantes, pois o número excede o máximo de \'{$a->maxstudents}\' definido pelo administrador na configuração  \'courseadditionalmoddatamaxstudents\' do formato de curso Tópicos Contraídos.';
$string['courseadditionalmoddatastudentsinfolimitedshow'] = 'Informações adicionais serão mostradas para as atividades habilitadas para {$a->students} estudantes dado que o número não excede o máximo de \'{$a->maxstudents}\' definido pelo administrador na configuração \'courseadditionalmoddatamaxstudents\' do formato de curso Tópicos Contraídos.';
$string['courseadditionalmoddatastudentsinfounlimited'] = 'Informações adicionais serão mostradas para as atividades habilitadas para {$a} estudantes.';
$string['coursesectionactivityfurtherinformation'] = 'Informações adicionais da página do curso';
$string['coursesectionactivityfurtherinformation_desc'] = 'Configurações de informações adicionais da página do curso no nível do site';
$string['coursesectionactivityfurtherinformationassign'] = 'Mostrar informações da tarefa';
$string['coursesectionactivityfurtherinformationassigndesc'] = 'Permite selecionar as informações da tarefa a serem mostradas em um curso. Para professores/administradores, mostra o número de envios.';
$string['coursesectionactivityfurtherinformationchoice'] = 'Mostrar informações da escolha';
$string['coursesectionactivityfurtherinformationchoicedesc'] = 'Permite selecionar as informações da escolha a serem mostradas em um curso. Para professores/administradores, mostra o número de envios.';
$string['coursesectionactivityfurtherinformationdata'] = 'Mostrar informações do banco de dados';
$string['coursesectionactivityfurtherinformationdatadesc'] = 'Permite selecionar as informações de dados a serem mostradas em um curso. Para professores/administradores, mostra o número de envios.';
$string['coursesectionactivityfurtherinformationfeedback'] = 'Mostrar informações do feedback';
$string['coursesectionactivityfurtherinformationfeedbackdesc'] = 'Permite selecionar as informações do feedback a serem mostradas em um curso. Para professores/administradores, mostra o número de envios.';
$string['coursesectionactivityfurtherinformationforum'] = 'Mostrar informações do fórum';
$string['coursesectionactivityfurtherinformationforumdesc'] = 'Permite selecionar as informações do fórum a serem mostradas em um curso. Para professores/administradores, mostra o número de contribuições quando a avaliação de todo o fórum está ativada.';
$string['coursesectionactivityfurtherinformationlesson'] = 'Mostrar informações da lição';
$string['coursesectionactivityfurtherinformationlessondesc'] = 'Permite selecionar as informações da lição a serem mostradas em um curso. Para professores/administradores, mostra o número de envios.';
$string['coursesectionactivityfurtherinformationquiz'] = 'Mostrar informações do quiz';
$string['coursesectionactivityfurtherinformationquizdesc'] = 'Permite selecionar as informações do quiz a serem mostradas em um curso. Para professores/administradores, mostra o número de envios.';
$string['ctreset'] = 'Opções para reconfiguração de Tópicos Contraídos';
$string['ctreset_help'] = 'Redefinir para os padrões de Tópicos Recolhidos.';
$string['currentsection'] = 'Esta seção';
$string['default'] = 'Padrão - {$a}';
$string['defaultdisplayblocks'] = 'Blocos para exibição';
$string['defaultdisplayblocks_desc'] = 'Escolha os blocos a serem exibidos no curso quando ele for criado pela primeira vez e este formato for selecionado. Use a tecla "Ctrl" em combinação com o mouse para selecionar mais de um ou nenhum. Observação: Esta configuração só se aplicará durante a criação real do curso e em nenhum outro momento, ou seja, ao mudar para Tópicos Recolhidos de outro formato.';
$string['defaultdisplayblocksloc'] = 'Localização do bloco para exibição';
$string['defaultdisplayblocksloc_desc'] = 'Escolha a localização para os blocos escolhidos acima serem exibidos, antes ou depois do lado.';
$string['defaultdisplayinstructions'] = 'Exibir instruções aos usuários';
$string['defaultdisplayinstructions_desc'] = 'Exibir instruções aos usuários informando como usar os interruptores. Pode ser sim ou não.';
$string['defaultheadingsub'] = 'Padrões';
$string['defaultheadingsubdesc'] = 'Configurações padrão que podem ser substituídas no nível do curso';
$string['defaultlayoutcolumnorientation'] = 'Orientação da coluna';
$string['defaultlayoutcolumnorientation_desc'] = 'Orientação padrão da coluna: Dinâmica - Número de seções por "linha" ajustado ao tamanho da janela, configuração "Coluna" não usada atualmente.<br />Horizontal - Seções vão da esquerda para a direita.<br />Vertical - Seções vão de cima para baixo.';
$string['defaultlayoutcolumns'] = 'Número de colunas';
$string['defaultlayoutcolumns_desc'] = 'Número de colunas entre um e quatro.';
$string['defaultlayoutelement'] = 'Layout';
$string['defaultlayoutelement_desc'] = 'A configuração do layout pode ser uma das: <br />"Padrão" com tudo exibido.<br />Sem "Tópico x" / "Semana x" / "Dia x".<br />Sem número de seção.<br />Sem "Tópico x" / "Semana x" / "Dia x" e sem número de seção.<br />Sem palavra "Alternar".<br />Sem palavra "Alternar" e sem "Tópico x" / "Semana x" / "Dia x".<br />Sem palavra "Alternar", sem "Tópico x" / "Semana x" / "Dia x" e sem número de seção.';
$string['defaultlayoutelement_descpositive'] = 'A configuração do layout pode ser uma das: <br />Palavra "Alternar", "Tópico x" / "Semana x" / "Dia x" e número de seção.<br />Palavra "Alternar" e "Tópico x" / "Semana x" / "Dia x".<br />Palavra "Alternar" e número de seção.<br />"Tópico x" / "Semana x" / "Dia x" e número de seção.<br />Palavra "Alternar".<br />"Tópico x" / "Semana x" / "Dia x".<br />Número de seção.<br />Nenhuma adição.';
$string['defaultlayoutstructure'] = 'Configuração da estrutura';
$string['defaultlayoutstructure_desc'] = 'A configuração da estrutura pode ser uma das: <br />Tópico<br />Semana<br />Última Semana Primeiro<br />Tópico Atual Primeiro<br />Dia';
$string['defaultonesection'] = 'Uma seção';
$string['defaultonesection_desc'] = 'Determina se apenas uma seção deve ser aberta por vez. Nota: Ignorado durante a editação  para permitir que atividades e recursos sejam movidos entre as seções.';
$string['defaultonesectioniconfont'] = 'Fonte de ícone de uma seção';
$string['defaultonesectioniconfont_desc'] = 'Indique a classe da fonte de ícone a ser usada para o ícone do link de uma seção, ou seja, consulte as classes de ícones FontAwesome. Se estiver vazio, o ícone padrão "one_section" na pasta "pix" será usado.';
$string['defaultshowadditionalmoddata'] = 'Padrão do curso "Mostrar informações adicionais"';
$string['defaultshowadditionalmoddatadesc'] = 'Se uma atividade estiver configurada no nível do site (abaixo) para mostrar informações adicionais, esta configuração indica o estado padrão da instância específica do curso.';
$string['defaultshowsectionsummary'] = 'Mostrar o resumo quando a seção está contraída';
$string['defaultshowsectionsummary_desc'] = 'Indica se o resumo da seção será sempre mostrado, independentemente do estado de alternância.';
$string['defaulttgbgcolour'] = 'Cor de fundo do botão "contrair/expandir"';
$string['defaulttgbgcolour_desc'] = 'Alternar cor de fundo em RGB hexadecimal.';
$string['defaulttgbghvrcolour'] = 'Cor de fundo do botão "contrair/expandir" ao passar o mouse';
$string['defaulttgbghvrcolour_desc'] = 'Alternar cor de fundo ao passar o mouse em RGB hexadecimal.';
$string['defaulttgbghvropacity'] = 'Alternar opacidade ao passar o mouse sobre o fundo';
$string['defaulttgbghvropacity_desc'] = 'Alternar opacidade ao passar o mouse sobre o fundo entre 0 e 1 em incrementos de 0,1.';
$string['defaulttgbgopacity'] = 'Opacidade do fundo da alternância';
$string['defaulttgbgopacity_desc'] = 'Opacidade do fundo da alternância entre 0 e 1 em incrementos de 0,1.';
$string['defaulttgfgcolour'] = 'Cor do texto do botão "contrair/expandir"';
$string['defaulttgfgcolour_desc'] = 'Alternar cor do primeiro plano em RGB hexadecimal.';
$string['defaulttgfghvrcolour'] = 'Cor do texto do botão "contrair/expandir" ao passar o mouse';
$string['defaulttgfghvrcolour_desc'] = 'Alternar cor do primeiro plano ao passar o mouse em RGB hexadecimal.';
$string['defaulttgfghvropacity'] = 'Alternar opacidade ao passar o mouse sobre o primeiro plano';
$string['defaulttgfghvropacity_desc'] = 'Opacidade do texto do primeiro plano ao passar o mouse entre 0 e 1 em incrementos de 0,1.';
$string['defaulttgfgopacity'] = 'Opacidade do primeiro plano da alternância';
$string['defaulttgfgopacity_desc'] = 'Opacidade do texto do primeiro plano entre 0 e 1 em incrementos de 0,1.';
$string['defaulttogglealignment'] = 'Alternar o alinhamento do texto';
$string['defaulttogglealignment_desc'] = '\'Esquerda\', \'Centro\' ou \'Direita\'.';
$string['defaulttoggleallenabled'] = 'Alternar todos habilitado';
$string['defaulttoggleallenabled_desc'] = 'Indica se a funcionalidade de alternar tudo deve estar habilitada.';
$string['defaulttoggleallhover'] = 'Ícone \'contrair/expandir todos\' muda ao passar o mouse';
$string['defaulttoggleallhover_desc'] = '\'Não\' ou \'Sim\'.';
$string['defaulttoggleborderradiusbl'] = 'Raio da borda inferior esquerda da alternância';
$string['defaulttoggleborderradiusbl_desc'] = 'Raio da borda inferior esquerda da alternância.';
$string['defaulttoggleborderradiusbr'] = 'Raio da borda inferior direita da alternância';
$string['defaulttoggleborderradiusbr_desc'] = 'Raio da borda inferior direita da alternância.';
$string['defaulttoggleborderradiustl'] = 'Raio da borda superior esquerda da alternância';
$string['defaulttoggleborderradiustl_desc'] = 'Raio da borda superior esquerda da alternância.';
$string['defaulttoggleborderradiustr'] = 'Raio da borda superior direita da alternância';
$string['defaulttoggleborderradiustr_desc'] = 'Raio da borda superior direita da alternância.';
$string['defaulttoggleiconfontclosed'] = 'Fonte de ícone de alternância fechada';
$string['defaulttoggleiconfontclosed_desc'] = 'Quando "defaulttoggleiconset" está definido como "Fonte de Ícone", indica as classes CSS padrão a serem usadas para o ícone fechado, ou seja, consulte as classes de ícones FontAwesome.';
$string['defaulttoggleiconfontopen'] = 'Fonte de ícone de alternância aberta';
$string['defaulttoggleiconfontopen_desc'] = 'Quando "defaulttoggleiconset" está definido como "Fonte de Ícone", indica as classes CSS padrão a serem usadas para o ícone aberto, ou seja, consulte as classes de ícones FontAwesome.';
$string['defaulttoggleiconposition'] = 'Posição do ícone';
$string['defaulttoggleiconposition_desc'] = 'Indica se o ícone deve estar à esquerda ou à direita do texto de alternância.';
$string['defaulttoggleiconset'] = 'Conjunto de ícones da alternância';
$string['defaulttoggleiconset_desc'] = '<table><tbody><tr><td>Seta</td><td>{$a->arrow}</td></tr><tr><td>Lâmpada</td><td>{$a->bulb}</td></tr><tr><td>Nuvem</td><td>{$a->cloud}</td></tr><tr><td>Olho</td><td>{$a->eye}</td></tr><tr><td>Pasta</td><td>{$a->folder}</td></tr><tr><td>Sinal no Solo</td><td>{$a->groundsignal}</td></tr><tr><td>Diodo Emissor de Luz</td><td>{$a->led}</td></tr><tr><td>Ponto</td><td>{$a->point}</td></tr><tr><td>Força</td><td>{$a->power}</td></tr><tr><td>Rádio</td><td>{$a->radio}</td></tr><tr><td>Rosto Sorridente</td><td>{$a->smiley}</td></tr><tr><td>Quadrado</td><td>{$a->square}</td></tr><tr><td>Sol / Lua</td><td>{$a->sunmoon}</td></tr><tr><td>Interruptor</td><td>{$a->switch}</td></tr><tr><td>Fonte de Ícone</td><td>{$a->tif}</td></tr></tbody></table>';
$string['defaulttoggleiconsize'] = 'Tamanho do ícone da alternância';
$string['defaulttoggleiconsize_desc'] = 'Tamanho do ícone: Pequeno = 16px, Médio = 24px e Grande = 32px, ou Fonte de Ícone: Pequeno = 0.8em, Médio = 1.2em e Grande = 1.8em.';
$string['defaulttogglepersistence'] = 'Alternar persistência';
$string['defaulttogglepersistence_desc'] = '"Ligado" ou "Desligado". Desative para aumentar o desempenho AJAX, mas as seleções de alternância do usuário não serão lembradas ao atualizar a página ou revisitar. <br />Nota: Ao desativar a persistência, remova qualquer linha contendo "topcoll_toggle_x" no campo "name" da tabela "user_preferences" no banco de dados. Onde o "x" em "topcoll_toggle_x" será um ID do curso. Isso é para economizar espaço se você não pretende reativá-lo.';
$string['defaultuserpreference'] = 'Estado inicial da alternância';
$string['defaultuserpreference_desc'] = 'Indica o que fazer com as alternâncias quando o usuário acessa o curso pela primeira vez, o estado de seções adicionais quando são adicionadas ou quando a persistência de alternância está desativada.';
$string['defaultviewsinglesectionenabled'] = 'Visualizar seção única habilitada';
$string['defaultviewsinglesectionenabled_desc'] = 'Indica se a funcionalidade de visualizar seção única deve estar habilitada.';
$string['deletesection'] = 'Excluir seção';
$string['displayinstructions'] = 'Mostrar instruções';
$string['displayinstructions_help'] = 'Indica se as instruções devem ser exibidas para o usuário ou não.';
$string['donotshowdate'] = 'Não mostrar a data';
$string['donotshowdate_help'] = 'Não mostrar a data ao usar uma estrutura baseada em semana e a opção "Usar nome padrão da seção" estiver desmarcada.';
$string['editsection'] = 'Editar seção';
$string['editsectionname'] = 'Editar nome da seção';
$string['em0_0'] = '0.0em';
$string['em0_1'] = '0.1em';
$string['em0_2'] = '0.2em';
$string['em0_3'] = '0.3em';
$string['em0_4'] = '0.4em';
$string['em0_5'] = '0.5em';
$string['em0_6'] = '0.6em';
$string['em0_7'] = '0.7em';
$string['em0_8'] = '0.8em';
$string['em0_9'] = '0.9em';
$string['em1_0'] = '1.0em';
$string['em1_1'] = '1.1em';
$string['em1_2'] = '1.2em';
$string['em1_3'] = '1.3em';
$string['em1_4'] = '1.4em';
$string['em1_5'] = '1.5em';
$string['em1_6'] = '1.6em';
$string['em1_7'] = '1.7em';
$string['em1_8'] = '1.8em';
$string['em1_9'] = '1.9em';
$string['em2_0'] = '2.0em';
$string['em2_1'] = '2.1em';
$string['em2_2'] = '2.2em';
$string['em2_3'] = '2.3em';
$string['em2_4'] = '2.4em';
$string['em2_5'] = '2.5em';
$string['em2_6'] = '2.6em';
$string['em2_7'] = '2.7em';
$string['em2_8'] = '2.8em';
$string['em2_9'] = '2.9em';
$string['em3_0'] = '3.0em';
$string['em3_1'] = '3.1em';
$string['em3_2'] = '3.2em';
$string['em3_3'] = '3.3em';
$string['em3_4'] = '3.4em';
$string['em3_5'] = '3.5em';
$string['em3_6'] = '3.6em';
$string['em3_7'] = '3.7em';
$string['em3_8'] = '3.8em';
$string['em3_9'] = '3.9em';
$string['em4_0'] = '4.0em';
$string['enableadditionalmoddata'] = 'Ativar informações adicionais';
$string['enableadditionalmoddatadesc'] = 'Este é um interruptor no nível do site para ligar ou desligar as informações da atividade. Ele precisa estar "ligado" para que as configurações relacionadas que operam no nível do curso tenham efeito. Como essa funcionalidade pode ser computacionalmente cara, é altamente recomendável realizar testes completos antes de usar em um sistema de produção. Observação: Limpa os caches quando alterado.';
$string['eye'] = 'Olho';
$string['feedbackavailable'] = 'Feedback disponível';
$string['folder'] = 'Pasta';
$string['formatresponsive'] = 'Formato responsivo';
$string['formatresponsive_desc'] = 'Ative se estiver usando um tema não responsivo e o formato se ajustará ao tamanho da tela/dispositivo. Desative se estiver usando um tema responsivo. O suporte ao Bootstrap 2.3.2 está incorporado; para outros frameworks e versões, substitua os métodos "get_row_class()" e "get_column_class()" em renderer.php.';
$string['formatsettings'] = 'Configurações de redefinição do formato';
$string['formatsettingsinformation'] = '<br />Para redefinir as configurações do formato do curso para os padrões, clique no ícone à direita.';
$string['four'] = 'Quatro';
$string['hidefromothers'] = 'Ocultar seção';
$string['information'] = 'Informações';
$string['informationchanges'] = 'Alterações';
$string['informationsettings'] = 'Configurações de informações';
$string['informationsettingsdesc'] = 'Informações do formato de tópicos recolhidos';
$string['instructions'] = 'Instruções: Clique no nome da seção para mostrar/ocultar';
$string['large'] = 'Grande';
$string['layoutstructuredays'] = 'dias';
$string['layoutstructuretopics'] = 'tópicos';
$string['layoutstructureweeks'] = 'semanas';
$string['left'] = 'Esquerda';
$string['love'] = 'amor';
$string['maincoursepage'] = 'Página principal do curso';
$string['markedthissection'] = 'Esta seção está destacada como a seção atual';
$string['markthissection'] = 'Destacar esta seção como a seção atual';
$string['medium'] = 'Médio';
$string['newsectionname'] = 'Novo nome para a seção {$a}';
$string['numbersections'] = 'Número de seções';
$string['off'] = 'Off';
$string['on'] = 'On';
$string['one'] = 'Um';
$string['onesection'] = 'Uma seção';
$string['onesection_help'] = 'Determina se apenas uma seção deve ser aberta por vez. Nota: Ignorado ao editar a sala para permitir que atividades e recursos sejam movidos pelas seções.';
$string['page-course-view-topcoll'] = 'Página principal de qualquer curso no formato de tópicos recolhidos';
$string['page-course-view-topcoll-x'] = 'Página de qualquer curso no formato de tópicos recolhidos';
$string['pluginname'] = 'Tópicos Contraídos';
$string['point'] = 'Ponto';
$string['power'] = 'Ativar';
$string['radio'] = 'Rádio';
$string['readme_desc'] = 'Por favor clique em \'{$a->url}\' para muito mais informações sobre Tópicos Contraídos.';
$string['readme_title'] = 'Leia-me do Tópicos Contraídos';
$string['resetactivitymeta'] = 'Informações adicionais do módulo';
$string['resetactivitymeta_help'] = 'Redefine as informações adicionais do módulo para seguir o valor padrão do site.';
$string['resetallactivitymeta'] = 'Todas as informações adicionais do módulo';
$string['resetallactivitymeta_help'] = 'Redefine todas as informações adicionais do módulo para seguir o valor padrão do site.';
$string['resetallcolour'] = 'Cores';
$string['resetallcolour_help'] = 'Redefine as cores e opacidades para seguir o valor padrão do site.';
$string['resetalldisplayinstructions'] = 'Mostrar instruções';
$string['resetalldisplayinstructions_help'] = 'Redefine as instruções de exibição para seguir o valor padrão do site.';
$string['resetallgrp'] = 'Redefinir tudo:';
$string['resetalllayout'] = 'Layouts';
$string['resetalllayout_help'] = 'Redefine o elemento de layout, estrutura, colunas, alternar tudo, visualizar uma única seção, posição do ícone, uma seção e resumo da seção exibida para seguir o valor padrão do site.';
$string['resetalltogglealignment'] = 'Alinhamentos de alternância';
$string['resetalltoggleiconset'] = 'Conjuntos de ícones de alternância';
$string['resetcolour'] = 'Cor';
$string['resetcolour_help'] = 'Redefine as cores e opacidades para seguir o valor padrão do site.';
$string['resetdisplayinstructions'] = 'Mostrar instruções';
$string['resetdisplayinstructions_help'] = 'Redefine as instruções de exibição para seguir o valor padrão do site.';
$string['resetgrp'] = 'Redefinir:';
$string['resetlayout'] = 'Layout';
$string['resetlayout_help'] = 'Redefine o elemento de layout, estrutura, colunas, alternar tudo, visualizar uma única seção, posição do ícone, uma seção e resumo da seção exibida para seguir o valor padrão do site.';
$string['resettogglealignment'] = 'Alinhamento de alternância';
$string['resettoggleiconset'] = 'Conjunto de ícones de alternância';
$string['right'] = 'Direita';
$string['sctcloseall'] = 'Fechar tudo {$a}';
$string['sctopenall'] = 'Abrir tudo {$a}';
$string['section0name'] = 'Geral';
$string['sectionname'] = 'Seção';
$string['setcolour'] = 'Cor';
$string['setcolour_help'] = 'Contém as configurações relacionadas à cor do formato dentro do curso.';
$string['setlayout'] = 'Definir layout';
$string['setlayout_all'] = 'Alternar a palavra e o número da seção, \'Tópico x\' / \'Semana x\'/ \'Dia x\'';
$string['setlayout_default'] = 'Padrão';
$string['setlayout_help'] = 'Contém as configurações relacionadas ao layout do formato dentro do curso.';
$string['setlayout_no_additions'] = 'Sem adicionar';
$string['setlayout_no_section_no'] = 'Nenhum número de seção';
$string['setlayout_section_number'] = 'Número da seção';
$string['setlayout_toggle_section_x'] = '\'Tópico x\' / \'Semana x\' / \'Dia x\'';
$string['setlayout_toggle_section_x_section_number'] = '\'Tópico x\' / \'Semana x\' / \'Dia x\' e número da seção';
$string['setlayout_toggle_word'] = 'Alternar a palavra';
$string['setlayout_toggle_word_section_number'] = 'Alternar a palavra e o número da seção';
$string['setlayout_toggle_word_section_x'] = 'Alternar a palavra e \'Tópico x\' / \'Semana x\' / \'Dia x\'';
$string['setlayoutcolumnorientation'] = 'Orientação da coluna';
$string['setlayoutcolumnorientation_help'] = 'Vertical - Seções que vão de cima para baixo.

Horizontal - Seções que vão da esquerda para a direita.';
$string['setlayoutcolumns'] = 'Colunas';
$string['setlayoutcolumns_help'] = 'Quantas colunas usar.';
$string['setlayoutelements'] = 'Elementos';
$string['setlayoutstructure'] = 'Estrutura';
$string['setlayoutstructure_help'] = 'A estrutura de layout do curso. Você pode escolher entre:<br />"Tópicos" - onde cada seção é apresentada como um tópico em ordem numérica de seção.<br />"Semanas" - onde cada seção é apresentada como uma semana em ordem crescente a partir da data de início do curso.<br />"Semana atual primeiro" - que é o mesmo que semanas, mas a semana atual é mostrada no topo e as semanas anteriores em ordem decrescente são exibidas abaixo, exceto no modo de edição, onde a estrutura é a mesma que "Semanas".<br />"Tópico atual primeiro" - que é o mesmo que "Tópicos", exceto que o tópico atual é mostrado no topo se tiver sido definido.<br />"Dia" - onde cada seção é apresentada como um dia em ordem crescente a partir da data de início do curso.';
$string['setlayoutstructurecurrenttopicfirst'] = 'Tópico atual primeiro';
$string['setlayoutstructureday'] = 'Dia';
$string['setlayoutstructurelatweekfirst'] = 'Semana atual primeiro';
$string['setlayoutstructuretopic'] = 'Tópico';
$string['setlayoutstructureweek'] = 'Semana';
$string['setshowsectionsummary'] = 'Mostrar o sumário quando estiver contraído';
$string['settings'] = 'Configurações';
$string['settingssettings'] = 'Configurações de configuração';
$string['settingssettingsdesc'] = 'Configurações do formato de tópicos recolhidos';
$string['settogglealignment'] = 'Alternar o alinhamento do texto';
$string['settoggleallenabled'] = 'Botões Abrir/Fechar todos os tópicos habilitado';
$string['settoggleallenabled_help'] = 'Habilita/desabilita o botão Abrir/Fechar todos os tópicos';
$string['settoggleallhover'] = 'Ícone \'contrair/expandir todos\' muda ao passar o mouse';
$string['settoggleallhover_help'] = 'Define se os ícones de alternância mudarão quando o mouse passar sobre eles.';
$string['settogglebackgroundcolour'] = 'Cor de fundo do botão "contrair/expandir"';
$string['settogglebackgroundhovercolour'] = 'Cor de fundo do botão "contrair/expandir" ao passar o mouse';
$string['settogglebackgroundopacity'] = 'Opacidade da cor de fundo do botão de contrair/expandir (título do tópico)';
$string['settogglebackgroundopacity_help'] = 'Define a opacidade da cor de fundo do botão para contrair/expandir entre 0 e 1 em incrementos de 0.1.';
$string['settoggleforegroundcolour'] = 'Cor do texto do botão "contrair/expandir"';
$string['settoggleforegroundhovercolour'] = 'Cor do texto do botão "contrair/expandir" ao passar o mouse';
$string['settoggleiconfontclosed_help'] = 'Quando "toggleiconset" está definido como "Icon font", isso indica as classes CSS padrão a serem usadas para o ícone fechado, ou seja, veja as classes de ícones FontAwesome. Se definido como "-", então o padrão é usado.';
$string['settoggleiconfontopen_help'] = 'Quando "toggleiconset" está definido como "Icon font", isso indica as classes CSS padrão a serem usadas para o ícone aberto, ou seja, veja as classes de ícones FontAwesome. Se definido como "-", então o padrão é usado.';
$string['settoggleiconposition'] = 'Posição do ícone';
$string['settoggleiconset'] = 'Ícones';
$string['setviewsinglesectionenabled'] = 'Ver apenas uma seção habilitado';
$string['setviewsinglesectionenabled_help'] = 'Funcionalidade de ver apenas uma seção habilitada';
$string['showadditionalmoddata'] = 'Mostrar informações adicionais para: {$a} no curso';
$string['showadditionalmoddata_help'] = 'Permite que todos os usuários vejam o prazo da atividade e os usuários com permissão de avaliação vejam o número de envios na página do curso para atividades.';
$string['showfromothers'] = 'Mostrar seção';
$string['sidepost'] = 'Postagem';
$string['sidepre'] = 'Pré';
$string['small'] = 'Pequeno';
$string['smiley'] = 'Sorriso';
$string['square'] = 'Quadrado';
$string['sunmoon'] = 'Sol / Lua';
$string['switch'] = 'Interruptor';
$string['three'] = 'Três';
$string['tif'] = 'Fonte de ícone';
$string['toggleclose'] = 'Fechar';
$string['toggleopen'] = 'Abrir';
$string['topcoll:changeactivitymeta'] = 'Alterar ou redefinir a meta da atividade';
$string['topcoll:changecolour'] = 'Alterar ou redefinir a cor';
$string['topcoll:changelayout'] = 'Alterar ou redefinir o layout';
$string['topcoll:changetogglealignment'] = 'Alterar ou redefinir o alinhamento do "contrair/expandir"';
$string['topcoll:changetoggleiconset'] = 'Alterar ou redefinir o ícone do "contrair/expandir"';
$string['topcollall'] = 'Seções.';
$string['topcollclosed'] = 'Fechar tudo';
$string['topcollopened'] = 'Abrir tudo';
$string['topcollsidewidthlang'] = 'pt_br-28px';
$string['topcolltoggle'] = 'Alternar';
$string['two'] = 'Duas';
$string['versionalpha'] = 'Versão Alpha - Quase certamente contém bugs. Esta é uma versão de desenvolvimento apenas para desenvolvedores! Nem pense em instalar em um servidor de produção!';
$string['versionbeta'] = 'Versão Beta - Provavelmente contém bugs. Pronta para testes por administradores apenas em um servidor de teste.';
$string['versioninfo'] = 'Lançamento {$a->release}, versão {$a->version} no Moodle {$a->moodle}. Feito com {$a->love} na Grã-Bretanha.';
$string['versionrc'] = 'Versão candidata a lançamento - Pode conter bugs. Verifique completamente em um servidor de teste antes de considerar em um servidor de produção.';
$string['versionstable'] = 'Versão estável - Pode conter bugs. Verifique em um servidor de teste antes de instalar em seu servidor de produção.';
$string['viewonly'] = 'Ver apenas "{$a->sectionname}"';
$string['xanswered'] = '{$a->completed} responderam';
$string['xattempted'] = '{$a->completed} tentaram';
$string['xcontributed'] = '{$a->completed} contribuíram';
$string['xofyanswered'] = '{$a->completed} de {$a->participants} responderam';
$string['xofyattempted'] = '{$a->completed} de {$a->participants} tentativas';
$string['xofycontributed'] = '{$a->completed} de {$a->participants} contribuíram';
$string['xofyposted'] = '{$a->completed} de {$a->participants} postado';
$string['xofysubmitted'] = '{$a->completed} de {$a->participants} enviada';
$string['xposted'] = '{$a->completed} postado';
$string['xsubmitted'] = '{$a->completed} enviaram';
$string['xungraded'] = '{$a} não avaliado';
