<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'auth_db', language 'zh_cn', version '4.2'.
 *
 * @package     auth_db
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['auth_dbcannotconnect'] = '无法连接到外部数据库。';
$string['auth_dbcannotreadtable'] = '无法读取外部数据表。';
$string['auth_dbcantconnect'] = '无法连接到指定的认证数据库...';
$string['auth_dbchangepasswordurl_key'] = '更改密码 URL';
$string['auth_dbcolumnlist'] = '外部数据表包含以下字段:<br />{$a}';
$string['auth_dbdebugauthdb'] = '调试 ADOdb';
$string['auth_dbdebugauthdbhelp'] = '调试 ADOdb 连接到外部数据库，登录时显示空页面。不符合站点要求。';
$string['auth_dbdeleteuser'] = '删除用户 {$a->name} 其 id 为 {$a->id}';
$string['auth_dbdeleteusererror'] = '删除用户 {$a} 错误';
$string['auth_dbdescription'] = '该方法使用一个外部数据库来检验用户名和密码是否有效。如果是一个新帐号，该帐号其它字段的信息将一起复制到本系统中。';
$string['auth_dbextencoding'] = '外部数据库编码方式';
$string['auth_dbextencodinghelp'] = '外部数据库使用的编码方式';
$string['auth_dbextrafields'] = '这些字段是可选的。您在此指定的<b>外部数据库字段</b>将预先填入本系统的用户数据库中。<p>如果您留空不填，将使用系统默认值。</p><p>无论以上哪种情况，用户在登录后都可以改写这些字段。</p>';
$string['auth_dbfieldpass'] = '含有密码的字段名';
$string['auth_dbfieldpass_key'] = '密码字段';
$string['auth_dbfielduser'] = '含有用户名的字段名。此字段必须为varchar数据类型';
$string['auth_dbfielduser_key'] = '用户名字段';
$string['auth_dbhost'] = '数据库服务所在的主机。若使用ODBC，请使用一个系统DSN项。如果用PDO则请使用PDO DSN项。';
$string['auth_dbhost_key'] = '主机';
$string['auth_dbinsertuser'] = '已插入用户 {$a->name} 其 id 为 {$a->id}';
$string['auth_dbinsertuserduplicate'] = '插入用户 {$a->username} 时发生错误——有这一名称的用户已经由 \'{$a->auth}\' 插件所建立。';
$string['auth_dbinsertusererror'] = '插入用户 {$a} 错误';
$string['auth_dbname'] = '数据库名称。如果使用ODBC DSN 请留空。如果PDO DNS已包含数据库名称，也请留空。';
$string['auth_dbname_key'] = '数据库名称';
$string['auth_dbnoexttable'] = '未指定外部表。';
$string['auth_dbnouserfield'] = '未指定外部用户字段。';
$string['auth_dbpass'] = '与上面的用户名匹配的密码';
$string['auth_dbpass_key'] = '密码';
$string['auth_dbpasstype'] = '<p>指定密码字段使用的格式。</p> <p>如果您希望外部数据库管理用户名和电子邮件地址，而希望 Moodle 管理密码，请使用“内部”。 如果您使用“内部”，则必须在外部数据库中提供填充的电子邮件地址字段，并且必须启用 \\auth_db\\task\\sync_users 计划任务。 Moodle 将使用临时密码向新用户发送一封电子邮件。</p>';
$string['auth_dbpasstype_key'] = '密码格式';
$string['auth_dbreviveduser'] = '激活用户 {$a->name} 其 id 为 {$a->id}';
$string['auth_dbrevivedusererror'] = '激活用户{$a}错误';
$string['auth_dbsaltedcrypt'] = '以单向字串散列加密';
$string['auth_dbsetupsql'] = 'SQL 设置命令';
$string['auth_dbsetupsqlhelp'] = '特定数据库设置 SQL 命令。过去常设置通信编码方式，例如 MySQL 和 PostgreSQL：<em>SET NAMES \'utf8\'</em>';
$string['auth_dbsuspenduser'] = '暂停用户 {$a->name} 其 id 为 {$a->id}';
$string['auth_dbsuspendusererror'] = '暂停用户 {$a} 错误';
$string['auth_dbsybasequoting'] = '使用 sybase 引用';
$string['auth_dbsybasequotinghelp'] = 'Sybase 风格，需要 Oracle 支持，MS SQL 和一些其他的数据库，不要使用 MySQL！';
$string['auth_dbsyncuserstask'] = '同步用户任务';
$string['auth_dbtable'] = '数据库中的表单名';
$string['auth_dbtable_key'] = '数据表';
$string['auth_dbtableempty'] = '外部表为空。';
$string['auth_dbtype'] = '数据库类型（有关详细信息，请参阅文档 <a href="http://adodb.org/dokuwiki/doku.php" target="_blank">ADOdb - PHP的数据库抽象层</a>）。';
$string['auth_dbtype_key'] = '数据库';
$string['auth_dbupdateerror'] = '更新外部数据库时出现错误。';
$string['auth_dbupdateusers'] = '更新用户';
$string['auth_dbupdateusers_description'] = '在加入新用户同时，更新现有用户。';
$string['auth_dbupdatinguser'] = '更新用户{$a->name}，id {$a->id}';
$string['auth_dbuser'] = '对该数据库具有读权限的用户名';
$string['auth_dbuser_key'] = '数据库用户';
$string['auth_dbuserstoadd'] = '添加用户记录 {$a}';
$string['auth_dbuserstoremove'] = '删除用户记录 {$a}';
$string['pluginname'] = '使用外部数据库';
$string['privacy:metadata'] = '外部数据库身份验证插件不存储任何个人数据。';
