<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'grades', language 'lt', version '4.2'.
 *
 * @package     grades
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activities'] = 'Veiklos';
$string['addcategory'] = 'Įtraukti kategoriją';
$string['addcategoryerror'] = 'Nepavyko įtraukti kategorijos.';
$string['addexceptionerror'] = 'Įvyko klaida įtraukiant userid:gradeitem išimtį';
$string['addfeedback'] = 'Įtraukti atsiliepimą';
$string['addgradeletter'] = 'Įtraukti įvertinimo raidę';
$string['addidnumbers'] = 'Įtraukti ID numerius';
$string['additem'] = 'Įtraukti įvertinimo elementą';
$string['additionalfeedback'] = 'Papildomas grįžtamasis ryšys';
$string['addoutcome'] = 'Įtraukti rezultatą';
$string['addoutcomeitem'] = 'Įtraukti rezultato elementą';
$string['addscale'] = 'Įtraukti skalę';
$string['adjustedweight'] = 'Svertas sureguliuotas';
$string['aggregateextracreditmean'] = 'Įvertinimų vidurkis (su papildomais balais)';
$string['aggregatemax'] = 'Aukščiausias įvertinimas';
$string['aggregatemean'] = 'Įvertinimų vidurkis';
$string['aggregatemedian'] = 'Įvertinimų mediana';
$string['aggregatemin'] = 'Žemiausias įvertinimas';
$string['aggregatemode'] = 'Įvertinimų moda';
$string['aggregatenotonlygraded'] = 'Įtraukti tuščius įvertinimus';
$string['aggregateonlygraded'] = 'Neįtraukti tuščių įvertinimų';
$string['aggregateonlygraded_help'] = 'Tuščias įvertis yra toks įvertis, kurio nėra įverčių knygelėje. Jis gali būti gautas iš pateikimo įvertinti, kai dar neįvertinta, arba iš testo, kurio dar nebandyta atlikti ir kt. Šis parametras nustato, ar tušti įverčiai neįtraukiami į agregavimą, ar skaičiuojami kaip mažiausi įverčiai, pvz., 0, kai įvertinimo intervalas yra 0–100.';
$string['aggregateoutcomes'] = 'Įtraukti rezultatus į agregavimą';
$string['aggregateoutcomes_help'] = 'Jei įjungta, rezultatai įtraukiami į agregavimą. Dėl to gali gautis nenumatyta kategorijos bendroji suma.';
$string['aggregatesonly'] = 'Rodyti tik sumas';
$string['aggregatesubcatsupgradedgrades'] = 'Pastaba: agregavimo nustatymas „Agregavimas, įskaitant subkategorijas“ buvo pašalintas atnaujinant svetainę. Kadangi šiame kurse anksčiau buvo naudojamas „Agregavimo informacija, įskaitant subkategorijas“, rekomenduojama peržiūrėti šį pakeitimą įverčių knygelėje.';
$string['aggregatesum'] = 'Natūralus';
$string['aggregateweightedmean'] = 'Svertinis įvertinimų vidurkis';
$string['aggregateweightedmean2'] = 'Paprastasis svertinis įvertinimų vidurkis';
$string['aggregation'] = 'Agregavimas';
$string['aggregation_help'] = 'Agregavimas nustato, kaip jungiami kategorijos įvertinimai, pvz.,

* Įvertinimų vidurkis –  visų įvertinimų suma, padalyta iš įvertinimų skaičiaus
* Įvertinimų mediana – vidurinis įvertinimas, kai įvertinimai išdėstomi pagal dydį
* Žemiausias įvertinimas
* Aukščiausias įvertinimas
* Įvertinimų moda – dažniausiai pasitaikantis įvertinimas
* Įvertinimų suma – visų įvertinimų reikšmių suma pagal svorį';
$string['aggregation_link'] = 'grade/aggregation';
$string['aggregationcoef'] = 'Agregavimo keoficientas';
$string['aggregationcoefextra'] = 'Papildomas kreditas';
$string['aggregationcoefextra_help'] = 'Jei agregavimas yra „Natūralus“ arba „Paprastas svertinis vidurkis“ ir pažymėtas papildomo kredito žymimasis laukelis, įverčio elemento maksimalus balas nepridedamas prie kategorijos maksimalaus įverčio. Taip atsiras galimybė gauti maksimalų įvertį kategorijoje, neturint maksimalaus įvertinimo visuose įverčių punktuose. Jei svetainės administratorius įgalino balus, viršijančius maksimalų leistiną, gali būti ir aukštesnių už maksimumą įvertinimų.

Jei agregavimas yra „Įverčių vidurkis (su papildomais kreditais)“, o papildomas kreditas nustatytas didesnis nei nulis, papildomas kreditas yra koeficientas, iš kurio įvertis padauginamas prieš pridedant jį prie bendros sumos, apskaičiavus vidurkį.';
$string['aggregationcoefextra_link'] = 'grade/aggregation';
$string['aggregationcoefextrasum'] = 'Papildomas kreditas';
$string['aggregationcoefextrasum_help'] = 'Jei pažymėtas papildomo kredito žymės langelis, įverčio elemento didžiausias įvertis neįtraukiamas į kategorijos didžiausią įvertį, todėl yra tikimybė, kad bus gautas didžiausias kategorijos įvertis (arba didesni už didžiausią įverčiai, jei įjungė svetainės administratorius) neturint visų įverčių elementų didžiausio įverčio.';
$string['aggregationcoefextrasum_link'] = 'grade/aggregation';
$string['aggregationcoefextrasumabbr'] = '+';
$string['aggregationcoefextraweight'] = 'Papildomo kredito svarba';
$string['aggregationcoefextraweight_help'] = 'Jei papildomo kredito svarba nustatyta kaip didesnė už nulį reikšmė, agreguojant įvertis veikia kaip papildomas kreditas. Skaičius yra koeficientas, iš kurio dauginamas įvertis, prieš jį įtraukiant į vidurkio skaičiavimo bendrąją sumą.';
$string['aggregationcoefextraweight_link'] = 'grade/aggregation';
$string['aggregationcoefweight'] = 'Elemento svarba';
$string['aggregationcoefweight_help'] = 'Elemento svarba naudojama agreguojant kategoriją, kad padarytų įtaką elemento svarbai palyginti su kitais tos pačios kategorijos įverčių elementais.';
$string['aggregationcoefweight_link'] = 'grade/aggregation';
$string['aggregationhintdropped'] = '( Praleistas )';
$string['aggregationhintexcluded'] = '( Išimtas )';
$string['aggregationhintextra'] = '( Papildomas kreditas )';
$string['aggregationhintnovalue'] = '( Tuščia )';
$string['aggregationofa'] = '{$a} agregavimas';
$string['aggregationposition'] = 'Agregavimo padėtis';
$string['aggregationposition_help'] = 'Šis parametras nustato, ar įverčių knygelės ataskaitose kategorijos ir kursų bendrųjų sumų stulpeliai rodomi pirmi, ar paskutiniai.';
$string['aggregationsvisible'] = 'Galimi agregavimo tipai';
$string['aggregationsvisiblehelp'] = 'Pasirinkite visus agregavimo tipus, kurie turi būti pasiekiami. Norėdami pasirinkti kelis elementus, laikykite nuspaudę klavišą CTRL.';
$string['allgrades'] = 'Visi įvertinimai pagal kategoriją';
$string['allstudents'] = 'Visi besimokantieji';
$string['allusers'] = 'Visi naudotojai';
$string['aria-toggledropdown'] = 'Perjungti šį išskleidžiamąjį meniu';
$string['autosort'] = 'Automatinis rikiavimas';
$string['availableidnumbers'] = 'Galimi ID numeriai';
$string['average'] = 'Vidurkis';
$string['averagesdecimalpoints'] = 'Stulpelio vidurkių dešimtainės skiltys';
$string['averagesdecimalpoints_help'] = 'Šis nustatymas apibrėžia, kiek skaitmenų po kablelio turi būti rodoma kiekvienam vidurkiui, arba ar naudojamas (paveldėtas) bendras kategorijos ar įverčio elemento dešimtainių ženklų nustatymas.';
$string['averagesdisplaytype'] = 'Stulpelio vidurkių rodymo tipas';
$string['averagesdisplaytype_help'] = 'Šis parametras nustato, ar vidurkis bus rodomas kaip tikrieji įverčiai, procentai ar raidės arba ar bus naudojamas (paveldimas) kategorijos ar įverčio elemento rodymo tipas.';
$string['backupwithoutgradebook'] = 'Atsarginėje kopijoje nėra įvertinimų knygelės konfigūracijos';
$string['badgrade'] = 'Pateiktas netinkamas įvertinimas';
$string['badlyformattedscale'] = 'Įveskite kableliais atskirtų reikšmių sąrašą (būtinos bent dvi reikšmės).';
$string['baduser'] = 'Pateiktas netinkamas naudotojas';
$string['bonuspoints'] = 'Papildomi taškai';
$string['bulkcheckboxes'] = 'Didelio kiekio žymės langeliai';
$string['calculatedgrade'] = 'Apskaičiuotas įvertinimas';
$string['calculation'] = 'Skaičiavimas';
$string['calculation_help'] = 'Įverčio skaičiavimas – tai formulė, naudojama įverčiams nustatyti. Formulė turi prasidėti lygybės ženklu (=) ir joje gali  būti naudojami įprasti matematiniai operatoriai, pvz., „max“, „min“ ir „sum“. Norint į skaičiavimą galima įtraukti kitus įverčio elementus, stačiakampiuose skliausteliuose įvedant ID numerius.';
$string['calculation_link'] = 'grade/calculation';
$string['calculationadd'] = 'Įtraukti skaičiavimą';
$string['calculationedit'] = 'Redaguoti skaičiavimą';
$string['calculationsaved'] = 'Skaičiavimas įrašytas';
$string['calculationview'] = 'Peržiūrėti skaičiavimą';
$string['cannotaccessgroup'] = 'Atsiprašome, bet negalime pasiekti pasirinktos grupės įvertinimų.';
$string['categories'] = 'Kategorijos';
$string['category'] = 'Kategorija';
$string['categoryedit'] = 'Redaguoti kategoriją';
$string['categoryname'] = 'Kategorijos pavadinimas';
$string['categorytotal'] = 'Kategorijos bendroji suma';
$string['categorytotalfull'] = '{$a->category} bendroji suma';
$string['categorytotalname'] = 'Kategorijos bendrosios sumos pavadinimas';
$string['changedefaults'] = 'Keisti numatytąsias reikšmes';
$string['changereportdefaults'] = 'Keisti ataskaitos numatytąsias reikšmes';
$string['chooseaction'] = 'Pasirinkite veiksmą...';
$string['choosecategory'] = 'Pasirinkti kategoriją';
$string['collapsecriterion'] = 'Sutraukti kriterijų';
$string['combo'] = 'Skirtukai ir išskleidžiamasis meniu';
$string['compact'] = 'Susitarimas';
$string['componentcontrolsvisibility'] = 'Kai šis elementas paslėptas, jis yra valdomas pagal veiklos parametrus.';
$string['contract'] = 'Sutarties kategorija';
$string['contributiontocoursetotal'] = 'Indėlis į bendrąjį įvertinimą';
$string['controls'] = 'Valdikliai';
$string['courseavg'] = 'Kursų vidurkis';
$string['coursegradecategory'] = 'Kurso įvertinimo kategorija';
$string['coursegradedisplaytype'] = 'Kurso įvertinimo rodymo tipas';
$string['coursegradedisplayupdated'] = 'Atnaujintas kurso įvertinimo rodymo tipas.';
$string['coursegradesettings'] = 'Kurso įvertinimo parametrai';
$string['coursename'] = 'Kursų pavadinimas';
$string['coursescales'] = 'Kursų skalės';
$string['coursesettings'] = 'Kursų parametrai';
$string['coursesettingsexplanation'] = 'Kurso įvertinimų knygelės parametrai nustato, kaip įvertinimų knygelė  bus rodoma visiems kursų dalyviams.';
$string['coursesiamtaking'] = 'Kursai, kuriuose dalyvauju';
$string['coursesiamteaching'] = 'Kursai, kuriuos dėstau';
$string['coursetotal'] = 'Bendrasis kurso įvertinimas';
$string['createcategory'] = 'Kurti kategoriją';
$string['createcategoryerror'] = 'Nepavyko sukurti naujos kategorijos';
$string['creatinggradebooksettings'] = 'Įvertinimų knygelės parametrų kūrimas';
$string['csv'] = 'CSV';
$string['currentparentaggregation'] = 'Dabartinis pirminis agregavimas';
$string['curveto'] = 'Kreivė';
$string['decimalpoints'] = 'Bendras skaičius po kablelio';
$string['decimalpoints_help'] = 'Šis nustatymas apibrėžia kiekvieno įverčio skaitmenų po kablelio skaičių. Tai neturi įtakos įverčių skaičiavimams, kurie atliekami 5 skaitmenų po kablelio tikslumu.';
$string['default'] = 'Numatyta';
$string['defaultprev'] = 'Numatyta ({$a})';
$string['deletecategory'] = 'Naikinti kategoriją';
$string['deletescale'] = 'Ištrinti skalę';
$string['disablegradehistory'] = 'Išjungti įvetinimų istoriją';
$string['disablegradehistory_help'] = 'Išjunkite su įverčiais susijusių lentelių keitimų retrospektyvos sekimą. Tai gali šiek tiek pagreitinti serverį ir sutaupyti vietos duomenų bazėje.';
$string['displaylettergrade'] = 'Išjungti raidinius įvertinimus';
$string['displaypercent'] = 'Rodyti procentus';
$string['displaypoints'] = 'Rodyti taškus';
$string['displayweighted'] = 'Rodyti svertinius įvertinimus';
$string['dropdown'] = 'Iškrentantis meniu';
$string['droplow'] = 'Praleisti žemiausią';
$string['droplow_help'] = 'Šis parametras įjungia nurodytą žemiausių įverčių, kurie nebus įtraukiami į agregavimą, skaičių.';
$string['droplowestvalue'] = 'Nustatyti žemiausią kritimo vertę';
$string['droplowestvalues'] = 'Mesti {$a} mažiausias vertes';
$string['dropped'] = 'Praleista';
$string['dropxlowest'] = 'Praleisti X žemiausių';
$string['dropxlowestwarning'] = 'Pastaba: jei naudojate Praleisti x žemiausių, įvertinant daroma prielaida, kad visi kategorijos elementai turi tą pačią taškinę reikšmę. Jei taškinės reikšmės skiriasi, rezultatai bus neprognozuojami';
$string['duplicatedgradeitem'] = '{$a} (kopija)';
$string['duplicatescale'] = 'Dubliuoti skalę';
$string['edit'] = 'Redaguoti';
$string['editcalculation'] = 'Redaguoti skaičiavimą';
$string['editcalculationverbose'] = 'Redaguoti {$a->category} {$a->itemmodule} {$a->itemname} skaičiavimą';
$string['editfeedback'] = 'Redaguoti atsiliepimą';
$string['editgrade'] = 'Redaguoti įvertinimą';
$string['editgradeletters'] = 'Redaguoti įvertinimų raides';
$string['editoutcome'] = 'Redaguoti rezultatą';
$string['editoutcomes'] = 'Redaguoti rezultatus';
$string['editscale'] = 'Redaguoti skalę';
$string['edittree'] = 'Nuostatos';
$string['editverbose'] = 'Redaguoti {$a->category} {$a->itemmodule} {$a->itemname}';
$string['enableajax'] = 'Įjungti AJAX';
$string['enableajax_help'] = 'Į vertintojo ataskaitą įtraukiamas AJAX funkcijų sluoksnis, supaprastinantis ir pagreitinantis įprastas operacijas. Priklauso nuo to, ar naudotojo naršyklės lygiu yra įjungta „Javascript“.';
$string['enableoutcomes'] = 'Įjungti rezultatus';
$string['enableoutcomes_help'] = 'Jei įjungta, įvertinimo elementai gali būti vertinami naudojant vieną ar daugiau skalių, susietų su rezultatų teiginiais.';
$string['encoding'] = 'Kodavimas';
$string['encoding_help'] = 'Pasirinkite duomenims naudojamą simbolių kodavimą. (Standartinė koduotė yra UTF-8.) Jei per klaidą pasirinkta neteisinga koduotė, ji bus pastebėta peržiūrint importuojamus duomenis.';
$string['errorcalculationbroken'] = 'Klaida skaičiuojant įvertinimo elementą {$a}.';
$string['errorcalculationnoequal'] = 'Formulė turi prasidėti lygybės ženklu (=1+2)';
$string['errorcalculationunknown'] = 'Netinkama formulė';
$string['errorgradevaluenonnumeric'] = 'Gauta neskaitinė reikšmė; žemas arba aukštas įvertinimas,';
$string['errornocalculationallowed'] = 'Šiam elementui skaičiavimas neleidžiamas';
$string['errornocategorisedid'] = 'Nepavyko gauti kategorijai nepriskirto ID!';
$string['errornocourse'] = 'Nepavyko gauti kursų informacijos';
$string['errorreprintheadersnonnumeric'] = 'Gauta neskaitinė spausdinimo iš naujo antraščių reikšmė';
$string['errorsavegrade'] = 'Atsiprašome, bet įvertinimo įrašyti nepavyko.';
$string['errorsettinggrade'] = 'Klaida išsaugant „{$a->itemname}“ įvertinimą, skirtą naudotojo ID {$a->userid}';
$string['errorupdatinggradecategoryaggregateonlygraded'] = 'Įvyko klaida atnaujinant įvertinimų kategorijos ID {$a->id} parametrą Agreguoti tik netuščius įvertinimus';
$string['errorupdatinggradecategoryaggregateoutcomes'] = 'Įvyko klaida atnaujinant įverčio kategorijos ID {$a->id} parametrą Į agregavimą įtraukti rezultatus';
$string['errorupdatinggradecategoryaggregation'] = 'Įvyko klaida atnaujinant įvertinimo kategorijos ID {$a->id} agregavimo tipą';
$string['errorupdatinggradeitemaggregationcoef'] = 'Įvyko klaida atnaujinant įverčio kategorijos ID {$a->id} agregavimo koeficientą (svarbą arba papildomą kreditą)';
$string['eventgradedeleted'] = 'Įvertinimas ištrintas';
$string['eventgradeexported'] = 'Įvertinimas eksportuotas';
$string['eventgradeitemcreated'] = 'Įvertinimo elementas sukurtas';
$string['eventgradeitemdeleted'] = 'Įvertinimo elementas ištrintas';
$string['eventgradeitemupdated'] = 'Įvertinimo elementas atnaujintas';
$string['eventgradelettercreated'] = 'Įvertinimo raidė sukurta';
$string['eventgradeletterdeleted'] = 'Įvertinimo raidė ištrinta';
$string['eventgradeletterupdated'] = 'Įvertinimo raidė atnaujinta';
$string['eventgradeviewed'] = 'Įvertinimai peržiūrėti įvertinimų knygelėje';
$string['eventscalecreated'] = 'Sukurta skalė';
$string['eventscaledeleted'] = 'Skalė panaikinta';
$string['eventscaleupdated'] = 'Skalė atnaujinta';
$string['eventusergraded'] = 'Naudotojas įvertintas';
$string['excluded'] = 'Neįtraukta';
$string['excluded_help'] = 'Jei pažymėta, įvertinimas nebus įtrauktas į jokį agregavimą.';
$string['expand'] = 'Išplėsti kategoriją';
$string['expandcriterion'] = 'Išplėsti kriterijų';
$string['export'] = 'Eksportuoti';
$string['exportalloutcomes'] = 'Eksportuoti visus rezultatus';
$string['exportas'] = 'Eksportuoti kaip';
$string['exportfeedback'] = 'Eksportuojant įtraukti atsiliepimą';
$string['exportfeedback_desc'] = 'Tai gali būti nepaisoma eksportuojant.';
$string['exportformatoptions'] = 'Eksportavimo formato parametrai';
$string['exportonlyactive'] = 'Neįtraukti sulaikytų paskyrų naudotojų';
$string['exportonlyactive_help'] = 'Į eksportavimą įtraukti tik tuos besimokančiuosius, kurių registracija yra aktyvi ir nebuvo sustabdyta';
$string['exportplugins'] = 'Eksportuoti papildinius';
$string['exportsettings'] = 'Eksportuoti parametrus';
$string['exportto'] = 'Eksportuoti į';
$string['externalurl'] = 'Išorinis URL';
$string['externalurl_desc'] = 'Jei naudojama išorinė įvertinimų knygelė, čia turėtų būti nurodytas URL.';
$string['extracreditvalue'] = 'Papildoma kredito vertė {$a}';
$string['extracreditwarning'] = 'Pastaba: nustačius visus kategorijos elementus kaip papildomus kreditus, jie bus efektyviai pašalinti iš įverčio skaičiavimo, nes nebus taškinės bendrosios sumos.';
$string['fail'] = 'Nepavyko';
$string['feedback'] = 'Atsiliepimas';
$string['feedback_help'] = 'Šis langelis įjungia komentarus apie įtraukiamus įvertinimus.';
$string['feedbackadd'] = 'Įtraukti atsiliepimą';
$string['feedbackedit'] = 'Redaguoti atsiliepimą';
$string['feedbackfiles'] = 'Atsiliepimų failai';
$string['feedbackforgradeitems'] = 'Atsiliepimas {$a}';
$string['feedbackhistoryfiles'] = 'Atsiliepimų istorijos failai';
$string['feedbackprovided'] = 'Atsiliepimas pateiktas';
$string['feedbacks'] = 'Atsiliepimai';
$string['feedbacksaved'] = 'Atsiliepimas įrašytas';
$string['feedbackview'] = 'Peržiūrėti atsiliepimą';
$string['filterbothactive'] = 'Vardas ({$a->first}) Pavardė ({$a->last})';
$string['filterbyname'] = 'Filtruoti pagal vardą';
$string['filterfirstactive'] = 'Pirmas ({$a->first})';
$string['filterlastactive'] = 'Pavardė ({$a->last})';
$string['finalgrade'] = 'Galutinis įvertinimas';
$string['finalgrade_help'] = 'Jei pažymėtas pakeitimo žymės langelis, įvertinimą galima įtraukti arba pakeisti.';
$string['fixedstudents'] = 'Statinis besimokančiųjų stulpelis';
$string['fixedstudents_help'] = 'Leidžia horizontaliai slinkti įvertinimus nepaslepiant besimokančiųjų stulpelio, jis padaromas statiniu.';
$string['forceimport'] = 'Priverstinis importas';
$string['forceimport_help'] = 'Priverstinai importuoti įvertinimus, net jei įvertinimai buvo atnaujinti eksportavus importo failą';
$string['forceoff'] = 'Reikalauti: išjungta';
$string['forceon'] = 'Reikalauti: įjungta';
$string['forelementtypes'] = 'pasirinkto {$a}';
$string['forstudents'] = 'Besimokančiųjų';
$string['full'] = 'Visas';
$string['fullmode'] = 'Rodyti įvertinimus ir sumas';
$string['generalsettings'] = 'Bendrieji nustatymai';
$string['grade'] = 'Įvertinimas';
$string['grade_help'] = 'Įvertinimas, skirtas apdovanoti besimokantįjį už jų darbą.';
$string['gradeadministration'] = 'Rezultatai';
$string['gradealreadyupdated'] = '{$a} įvertinimai nebuvo importuoti, nes importo failo įvertinimai yra senesni nei vertintojo ataskaitoje. Jei vis tiek norite tęsti įvertinimų importavimą, naudokite priverstinio importavimo parinktį.';
$string['gradeanalysis'] = 'Įvertinimo analizė';
$string['gradebook'] = 'Įvertinimų knygelė';
$string['gradebookcalculationsfixbutton'] = 'Priimti įvertinimų pakeitimus ir ištaisyti skaičiavimo klaidas';
$string['gradebookcalculationsuptodate'] = 'Skaičiavimai įvertinimų knygelėje yra atnaujinti. Gali tekti iš naujo įkelti šį puslapį, kad pamatytumėte pakeitimus.';
$string['gradebookcalculationswarning'] = 'Pastaba: Apskaičiuojant įverčių knygelėje rodomus įverčius buvo aptiktos kai kurios klaidos. Jei jūsų kursas neprasidėjo arba šiuo metu vyksta, rekomenduojama klaidas ištaisyti paspaudus žemiau esantį mygtuką, nors dėl to kai kurie įverčiai bus pakeisti. Jei jūsų kursas jau baigėsi ir įverčiai pateikti, tikriausiai nenorite taisyti šios problemos.

Naujesnė versija yra {$a->currentversion}; naudojate įverčių knygelės versiją {$a->gradebookversion}. Pakeitimų sąrašą galite peržiūrėti <a href="{$a->url}">Įverčių knygelės skaičiavimo keitimuose</a>.';
$string['gradebookhiddenerror'] = 'Šiuo metu įvertinimų knygelėje viskas paslėpta nuo besimokančiųjų.';
$string['gradebookhistories'] = 'Įvertinimų retrospektyvos';
$string['gradebooknavigationmenu'] = 'Įvertinimų knygelės naršymo meniu';
$string['gradebooksetup'] = 'Įvertinimų knygelės nuostatos';
$string['gradeboundary'] = 'Raidinių įvertinimų ribos';
$string['gradeboundary_help'] = 'Šis parametras nustato mažiausią procentą, virš kurio įvertinimams bus priskiriamos įvertinimo raidės.';
$string['gradecategories'] = 'Įvertinimų kategorijos';
$string['gradecategory'] = 'Įvertinimo kategorija';
$string['gradecategoryonmodform'] = 'Vertinimų kategorija';
$string['gradecategoryonmodform_help'] = 'Šis nustatymas valdo kategoriją, kurioje yra šios veiklos vertinimai';
$string['gradecategorysettings'] = 'Įvertinimų kategorijų parametrai';
$string['gradedisplay'] = 'Įvertinimo rodymas';
$string['gradedisplaytype'] = 'Įvertinimo rodymo tipas';
$string['gradedisplaytype_help'] = 'Šis parametras nustato, kaip rodomi įverčiai vertintojo ir naudotojo ataskaitose.

* Raidė – raidės arba žodžiai naudojami įverčių intervalui nurodyti
* Procentai - santykinai su maksimaliais ir mažiausiais įverčiais
* Tikrasis – faktiniai įverčiai arba skalės reikšmės';
$string['gradedon'] = 'Įvertinta: {$a}';
$string['gradeexport'] = 'Įvertinimo eksportavimas';
$string['gradeexportcolumntype'] = '{$a->name} ({$a->extra})';
$string['gradeexportcustomprofilefields'] = 'Įvertinimų eksportavimo papildomi profilio laukai';
$string['gradeexportcustomprofilefields_desc'] = 'Įtraukti šiuos papildomus naudotojų profilių laukus į įvertinimų eksportavimą. Išskirti kableliu.';
$string['gradeexportdecimalpoints'] = 'Eksportuojamų įvertinimų dešimtainės dalys';
$string['gradeexportdecimalpoints_desc'] = 'Eksportuojant rodomų skaitmenų po kablelio skaičius. Tai gali būti nepaisoma eksportuojant.';
$string['gradeexportdisplaytype'] = 'Įvertinimo eksportavimo rodymo tipas';
$string['gradeexportdisplaytype_desc'] = 'Eksportuojant įverčiai gali būti rodomi kaip tikrieji įverčiai, kaip procentai (nurodant mažiausius ir didžiausius įverčius) arba kaip raidės (A, B, C ir t. t.). Eksportuojant tai galima pakeisti.';
$string['gradeexportdisplaytypes'] = 'Įvertinimų eksporto rodymo tipai';
$string['gradeexportuserprofilefields'] = 'Įvertinimų eksportavimo naudotojo profilio laukai';
$string['gradeexportuserprofilefields_desc'] = 'Įtraukti šiuos naudotojų profilių laukus į įvertinimų eksportavimą. Išskirti kableliu.';
$string['gradeforstudent'] = '{$a->student}<br />{$a->item}$a-> atsiliepimas';
$string['gradegrademinmax'] = 'Pradiniai min ir max įvertinimai';
$string['gradehelp'] = 'Įvertinimo žinynas';
$string['gradehistorylifetime'] = 'Įvertinimo retrospektyvos trukmė';
$string['gradehistorylifetime_help'] = 'Čia nurodomas laikotarpis, kurį turėtų būti laikoma su įverčiais susijusių lentelių keitimų retrospektyva. Rekomenduojama laikyti kiek įmanoma ilgiau. Jei patiriate našumo problemų arba duomenų bazei trūksta vietos, bandykite nustatyti mažesnę reikšmę.';
$string['gradeimport'] = 'Įvertinimo importavimas';
$string['gradeimportfailed'] = 'Vykdymo metu nepavyko importuoti įvertinimų. Išsami informacija:';
$string['gradeitem'] = 'Įvertinimo elementas';
$string['gradeitemaddusers'] = 'Neįtraukti į vertinimą';
$string['gradeitemadvanced'] = 'Išplėstinės įvertinimo elemento parinktys';
$string['gradeitemadvanced_help'] = 'Pasirinkite visus elementus, kurie redaguojant įvertinimų elementus turi būti rodomi kaip išplėstiniai.';
$string['gradeitemislocked'] = 'Ši veikla įvertinimų knygelėje yra užrakinta. Šios veiklos įvertinimų pakeitimai nebus nukopijuoti į įvertinimų knygelę, kol ji bus užrakinta.';
$string['gradeitemlocked'] = 'Vertinimas užrakintas';
$string['gradeitemmembersselected'] = 'Neįtraukta į vertinimą';
$string['gradeitemminmax'] = 'Minimalūs ir maksimalūs įvertinimai, kaip nurodyta įvertinimo elemento nustatymuose';
$string['gradeitemnonmembers'] = 'Įtraukta į vertinimą';
$string['gradeitemremovemembers'] = 'Įtraukti į vertinimą';
$string['gradeitems'] = 'Įvertinimų elementai';
$string['gradeitemsettings'] = 'Įvertinimų elementų parametrai';
$string['gradeitemsinc'] = 'Įtrauktini įvertinimo elementai';
$string['gradeletter'] = 'Įvertinimo raidė';
$string['gradeletter_help'] = 'Įvertinimų raidės yra raidės A, B, C ir t. t. arba žodžiai, pvz., Puikiai, Gerai, Išlaikyta ir pan., naudojami įvertinimų intervalui išreikšti.';
$string['gradeletternote'] = 'Norėdami panaikinti įverčio raidę, tiesiog išvalykite<br /> tos raidės bet kurią iš trijų teksto sričių ir spustelėkite Pateikti.';
$string['gradeletteroverridden'] = 'Numatytosios įvertinimų raidės šiuo metu yra nepaisomos.';
$string['gradeletters'] = 'Įvertinimų raidės';
$string['gradelocked'] = 'Įvertinimas užrakintas';
$string['gradelong'] = '{$a->grade} / {$a->max}';
$string['grademax'] = 'Didžiausias įvertinimas';
$string['grademax_help'] = 'Šis parametras nustato didžiausią įvertį, kai naudojamas reikšmės įverčio tipas. Veikla pagrįsto įverčio elemento didžiausias įvertis nustatomas veiklos parametrų puslapyje.';
$string['grademin'] = 'Mažiausias įvertinimas';
$string['grademin_help'] = 'Šis parametras nustato mažiausią įvertinimą, kai naudojamas reikšmės įvertinimo tipas.';
$string['gradenotificationmessage'] = 'Turite naujų atsiliepimų apie savo darbą „{$a}“';
$string['gradenotificationsubject'] = 'Jūs buvote įvertintas';
$string['gradeoutcomeitem'] = 'Įvertinimo rezultato elementas';
$string['gradeoutcomes'] = 'Rezultatai';
$string['gradeoutcomescourses'] = 'Kursų rezultatai';
$string['gradepass'] = 'Išlaikymo įvertinimas';
$string['gradepass_help'] = 'Šis parametras nustato mažiausią įvertį, reiškiantį, kad išlaikyta. Ši reikšmė naudojama veikloje ir baigiant kursus bei įverčių knygelėje, kurioje išlaikymo įverčiai paryškinami žaliai, o neišlaikymo įverčiai – raudonai.';
$string['gradepassgreaterthangrade'] = 'Išlaikymo įvertinimas negali būti didesnis už maksimalų galimą įvertinimą {$a}';
$string['gradepointdefault'] = 'Numatytas įvertinimas';
$string['gradepointdefault_help'] = 'Šis nustatymas nustato, koks veiklos įvertinimas turėtų būti numatytas.';
$string['gradepointdefault_validateerror'] = 'Turi būti sveikas skaičius nuo 1 iki didžiausios įvertinimo reikšmės.';
$string['gradepointmax'] = 'Maksimalus įvertinimas';
$string['gradepointmax_help'] = 'Šis nustatymas nurodo kokia gali būti maksimali įvertinimo reikšmė';
$string['gradepointmax_validateerror'] = 'Turi būti sveikas skaičius nuo 1 iki 10000.';
$string['gradepreferences'] = 'Įvertinimų nuostatos';
$string['gradepreferenceshelp'] = 'Įvertinimų nuostatų žinynas';
$string['gradepublishing'] = 'Įjungti publikavimą';
$string['gradepublishing_help'] = 'Įverčių paskelbimas – tai būdas importuoti ir eksportuoti įverčius naudojant URL neprisijungus prie Moodle. Jei įjungta, administratoriams ir naudotojams, turintiems leidimą skelbti įverčius (pagal numatytuosius nustatymus naudotojams, turintiems tik tvarkytojo vaidmenį), kiekvieno kurso įverčių knygelėje pateikiami įverčių eksportavimo paskelbimo nustatymai.';
$string['gradepublishinglink'] = 'Atsiųsti: {$a}';
$string['gradereport'] = 'Įvertinimų ataskaita';
$string['graderreport'] = 'Vertintojo ataskaita';
$string['grades'] = 'Įvertinimai';
$string['gradesforuser'] = '{$a->user} įvertinimai';
$string['gradesmoduledeletionpendingwarning'] = 'Įspėjimas: vykdomas veiklos naikinimas! Kai kurie įvertinimai bus pašalinti.';
$string['gradesmoduledeletionprefix'] = '[Naikinimas vyksta]';
$string['gradesonly'] = 'Rodyti tik įvertinimus';
$string['gradessettings'] = 'Įvertinimų parametrai';
$string['gradetype'] = 'Įvertinimo tipas';
$string['gradetype_help'] = 'Yra 4 įverčių tipai:
* Nieko – negalima vertinti.
* Reikšmė – skaitinė reikšmė, yra mažiausia ir didžiausia reikšmė.
* Skalė – sąrašo elementas.
* Tekstas – tik atsiliepimas.

Agreguoti galima tik reikšmės ir skalės įverčių tipus. Veikla pagrįsto įverčio elemento įverčio tipas nustatomas veiklos parametrų puslapyje.';
$string['gradevaluetoobig'] = 'Viena iš įvertinimo vertė yra didesnė, negu galima didžiausia {$a} įvertinimo vertė';
$string['gradevaluetoosmall'] = 'Viena iš įvertinimo verčių yra mažesnė už leistiną minimalų įvertinimą {$a}.';
$string['gradeview'] = 'Peržiūrėti įvertinimą';
$string['gradewasmodifiedduringediting'] = 'Įvertinimas , įvestas  {$a->itemname}, skirtas {$a->username}, buvo ignoruojamas, nes jį neseniai atnaujino kažkas kitas.';
$string['gradeweighthelp'] = 'Įvertinimo svorio žinynas';
$string['gradingmodulename'] = 'Įvertinimas ({$a})';
$string['groupavg'] = 'Grupės vidurkis';
$string['hidden'] = 'Paslėpta';
$string['hidden_help'] = 'Jei pažymėta, įvertinimai yra paslėpti nuo besimokančiųjų. Norint galima nustatyti parinktį Paslėpta iki, kad įvertinimai būtų rodomi pasibaigus vertinimui.';
$string['hiddenasdate'] = 'Rodyti paslėptų įvertinimų pateikimo datą';
$string['hiddenasdate_help'] = 'Jei naudotojas negali matyti paslėptų įvertinimų, vietoj „-“ rodyti pateikimo datą.';
$string['hiddenuntil'] = 'Paslėpta iki';
$string['hiddenuntildate'] = 'Paslėpta iki: {$a}';
$string['hideadvanced'] = 'Slėpti išplėstines funkcijas';
$string['hideaverages'] = 'Slėpti vidurkius';
$string['hidecalculations'] = 'Slėpti skaičiavimus';
$string['hidecategory'] = 'Paslėpta';
$string['hideeyecons'] = 'Slėpti rodymo / slėpimo piktogramas';
$string['hidefeedback'] = 'Slėpti atsiliepimą';
$string['hideforcedsettings'] = 'Slėpti reikalaujamus nurodyti parametrus';
$string['hideforcedsettings_help'] = 'Vertinimo UI nerodyti reikalaujamų nurodyti parametrų';
$string['hidegroups'] = 'Slėpti grupes';
$string['hidelocks'] = 'Slėpti užraktus';
$string['hidenooutcomes'] = 'Rodyti rezultatus';
$string['hidequickfeedback'] = 'Slėpti spartųjį atsiliepimą';
$string['hideranges'] = 'Slėpti intervalus';
$string['hidetotalifhiddenitems'] = 'Slėpti bendruosius kurso įvertinimus, jei juose yra paslėptų elementų';
$string['hidetotalifhiddenitems_help'] = 'Šis parametras nurodo, ar bendrosios sumos, kuriose yra paslėptų įverčių elementų, rodomos besimokantiesiems, ar pakeičiamos brūkšneliu (-). Jei rodoma, bendrąją sumą galima apskaičiuoti neįtraukiant arba įtraukiant paslėptus elementus. Jei paslėpti elementai neįtraukiami, bendroji suma skirsis nuo bendrosios sumos, kurią mato dėstytojas vertintojo ataskaitoje, nes dėstytojas visda mato bendrąsias sumas, apskaičiuotas naudojant visus elementus, tiek paslėptus, tiek nepaslėptus.';
$string['hidetotalshowexhiddenitems'] = 'Rodyti bendrąsias sumas, neįtraukiant paslėptų elementų';
$string['hidetotalshowinchiddenitems'] = 'Rodyti bendrąsias sumas, įskaitant paslėptus elementus';
$string['hideverbose'] = 'Slėpti {$a->category} {$a->itemmodule} {$a->itemname}';
$string['highgradeascending'] = 'Rikiuoti įvertinimų didėjimo tvarka';
$string['highgradedescending'] = 'Rikiuoti įvertinimų mažėjimo tvarka';
$string['highgradeletter'] = 'Aukštas';
$string['identifier'] = 'Nustatyti naudotoją pagal';
$string['idnumbers'] = 'ID numeriai';
$string['ignore'] = 'Ignoruoti';
$string['import'] = 'Importuoti';
$string['importas'] = 'Importuoti kaip';
$string['importcsv'] = 'Importuoti CSV';
$string['importcsv_help'] = 'Įvertinimus galima importuoti naudojant CSV failą tokiu formatu:

* Kiekvienoje failo eilutėje vienas įrašas
* Kiekvienas įrašas yra duomenų serija, atskirta pasirinktu skyrikliu
* Pirmajame įraše yra laukų pavadinimų sąrašas, apibrėžiantis likusio failo formatą
* Reikalingas lauko pavadinimas su naudotojo tapatybės duomenimis – vartotojo vardas (username) arba ID numeris (ID number) arba el. pašto adresas (email address)

Tinkamo formato failą galima gauti pirmiausia eksportavus keletą įverčių. Tada failą galima redaguoti ir išsaugoti kaip CSV failą.';
$string['importcsv_link'] = 'grade/import/csv/index';
$string['importcustom'] = 'Importuoti kaip pasirinktinius rezultatus (tik šių kursų)';
$string['importdata'] = 'Duomenys';
$string['importdata_help'] = 'Įvertinimus galima įklijuoti tiesiai iš „OpenDocument“ arba „Excel“ skaičiuoklės tokiu formatu:

* Bent viename stulpelyje turi būti naudotojo tapatybės duomenys – naudotojo vardas, el. pašto adresas arba ID numeris.
* Kituose stulpeliuose turi būti esamų veiklų ar įverčių elementų antraštės.

Teisingai suformatuotą skaičiuoklę galima gauti pirmiausia eksportavus keletą įverčių. Tada skaičiuoklę galima redaguoti, pridėti daugiau įverčių, ir išsaugoti.

Pasirinkite ir nukopijuokite stulpelius, kuriuos norite importuoti iš skaičiuoklės, tada įklijuokite juos į šį lauką.';
$string['importerror'] = 'Įvyko klaida, šis scenarijus iškviestas naudojant netinkamus parametrus';
$string['importfailed'] = 'Importuoti nepavyko';
$string['importfeedback'] = 'Importuoti atsiliepimą';
$string['importfile'] = 'Importuoti failą';
$string['importfilemissing'] = 'Failų negauta. Grįžkite į formą ir įsitikinkite, kad įkeliate tinkamą failą.';
$string['importfrom'] = 'Importuoti iš';
$string['importoutcomenofile'] = 'Įkeltas failas yra tuščias arba sugadintas. Patikrinkite, ar šis failas yra tinkamas. Problema aptikta eilutėje {$a}; ją iššaukė duomenų eilutės, kuriose yra mažiau stulpelių nei pirmoje eilutėje (antraštės eilutėje), arba jei importuotame faile trūksta numatytų antraščių. Peržiūrėkite eksportuotą failą, kaip turi atrodyti failas su tinkama antrašte.';
$string['importoutcomes'] = 'Importuoti rezultatus';
$string['importoutcomes_help'] = 'Rezultatus galima importuoti naudojant CSV failą, kurio formatas kaip rezultatų eksportavimo CSV failo.';
$string['importoutcomes_link'] = 'grade/outcome';
$string['importoutcomesuccess'] = 'Importas rezultatas {$a->name}, kurio ID #{$a->id}';
$string['importplugins'] = 'Importuoti papildinius';
$string['importpreview'] = 'Importuoti peržiūrą';
$string['importsettings'] = 'Importuoti parametrus';
$string['importskippednomanagescale'] = 'Neturite teisės įtraukti naują skalę, todėl rezultatas {$a} buvo praleistas, nes jam reikia sukurti naują skalę';
$string['importskippedoutcome'] = 'Šiame kontekste jau yra rezultatas, kurio pavadinimas {$a}, esantis importuojamame faile buvo praleistas.';
$string['importstandard'] = 'Importuoti kais standartinius rezultatus';
$string['importsuccess'] = 'Įvertinimai sėkmingai importuoti';
$string['importxml'] = 'Importuoti XML';
$string['includescalesinaggregation'] = 'Įtraukti skales į agregavimą';
$string['includescalesinaggregation_help'] = 'Galite keisti parametrą, ar skalės kaip skaičiai turi būti įtraukiamos į visų kursų visų įverčių knygelių visus agreguojamus įverčius. DĖMESIO: pakeitus šį parametrą bus priverstinai perskaičiuojami visi agreguoti įverčiai.';
$string['incorrectcourseid'] = 'Neteisingas kursų ID';
$string['incorrectcustomscale'] = '(Netinkama pasirinktinė skalė. Pakeiskite.)';
$string['incorrectminmax'] = 'Mažiausia reikšmė turi būti mažesnė už didžiausią reikšmę';
$string['inherit'] = 'Paveldėti';
$string['intersectioninfo'] = 'Besimokančiojo / Įvertinimo informacija';
$string['invalidgradeexporteddate'] = 'Eksportavimo data neteisinga, nes yra daugiau nei prieš metus arba ateityje, arba todėl, kad formatas netinkamas.';
$string['item'] = 'Elementas';
$string['iteminfo'] = 'Elemento informacija';
$string['iteminfo_help'] = 'Šis parametras pateikia vietą, kur galima įvesti informaciją apie elementą. Ši informacija nerodoma nieku kitur.';
$string['itemname'] = 'Elemento pavadinimas';
$string['itemnamehelp'] = 'Šio elemento pavadinimas, įterptas modulio.';
$string['items'] = 'Elementai';
$string['itemsedit'] = 'Redaguoti įvertinimo elementą';
$string['keephigh'] = 'Išlaikyti aukščiausią';
$string['keephigh_help'] = 'Jei nustatyta ši parinktis, bus išlaikoma tik X aukščiausių įvertinimų (X – pasirinkta šios parinkties vertė).';
$string['keephighestvalues'] = 'Palikti {$a} aukščiausias reikšmes';
$string['keymanager'] = 'Raktų tvarkytuvas';
$string['lessthanmin'] = '{$a->username} {$a->itemname} įvestas įvertinimas yra mažesnis nei leidžiamas mažiausias';
$string['letter'] = 'Raidė';
$string['lettergrade'] = 'Raidinis įvertinimas';
$string['lettergradenonnumber'] = 'Buvo neskaitinis žemas ir (arba) aukštas įvertinimas, skirtas';
$string['letterpercentage'] = 'Raidė (procentas)';
$string['letterreal'] = 'Raidė (tikrasis)';
$string['letters'] = 'Raidės';
$string['linkedactivity'] = 'Susieta veikla';
$string['linkedactivity_help'] = 'Šis parametras nurodo veiklą, su kuria susietas šis rezultato elementas. Tai gali būti naudojamas vertinant besimokančiųjų efektyvumą pagal kriterijus, nevertinamus veiklos įverčiu.';
$string['linktoactivity'] = 'Saitas su {$a->name} veikla {$a->title}';
$string['lock'] = 'Užrakinti';
$string['locked'] = 'Užrakinta';
$string['locked_help'] = 'Jei pažymėta, susijusi veikla nebegali automatiškai atnaujinti įvertinimų.';
$string['locktime'] = 'Užrakinti po';
$string['locktimedate'] = 'Užrakinta po: {$a}';
$string['lockverbose'] = 'Užrakinti {$a->category} {$a->itemmodule} {$a->itemname}';
$string['lowest'] = 'Žemiausias';
$string['lowgradeletter'] = 'Žemas';
$string['manageoutcomes'] = 'Tvarkyti rezultatus';
$string['manualitem'] = 'Įvertinimo elementas';
$string['mapfrom'] = 'Susieti iš';
$string['mapfrom_help'] = 'Skaičiuoklėje pasirinkite stulpelį, kuriame yra naudotojo identifikavimo duomenų, pvz., naudotojo vardas, naudotojo ID arba el. pašto adresas.';
$string['mappings'] = 'Įvertinimų elementų sususiejimai';
$string['mappings_help'] = 'Kiekviename skaičiuoklės įvertinimų stulpelyje pasirinkite atitinkamą įvertinimo elementą, į kurį norite importuoti įvertinimus.';
$string['mapto'] = 'Susieti su';
$string['mapto_help'] = 'Pasirinkti tuos pačius identifikavimo duomenis, kaip ir „Žemėlapis iš“.';
$string['max'] = 'Aukščiausias';
$string['maxgrade'] = 'Didžiausias įvertinimas';
$string['meanall'] = 'Visi įvertinimai';
$string['meangraded'] = 'Netušti įvertinimai';
$string['meanselection'] = 'Pasirinkti įvertinimai skaičiuojant stulpelio vidurkius';
$string['meanselection_help'] = 'Šis parametras nustato, ar reikia įtraukti langelius, kuriuose nėra įvertinimų, skaičiuojant kiekvienos kategorijos ar įvertinimo elemento vidurkį.';
$string['median'] = 'Mediana';
$string['min'] = 'Žemiausias';
$string['minimum_show'] = 'Rodyti mažiausią įvertinimą';
$string['minimum_show_help'] = 'Apskaičiuojant įvertinimus ir svorius naudojamas minimalus įvertinimas. Jei nerodomas, minimalus įvertinimas bus nulis ir jis negalės būti redaguojamas.';
$string['minmaxtouse'] = 'Skaičiuojant naudojami minimalūs ir maksimalūs įvertinimai';
$string['minmaxtouse_desc'] = 'Šis parametras nustato, ar skaičiuojant įverčių knygelėje rodomą įvertį naudoti pradinius minimalius ir maksimalius įverčius nuo tada, kai buvo suteiktas įvertis, ar minimalius ir maksimalius įverčius, nurodytus įverčio elemento nustatymuose. Šį nustatymą rekomenduojama keisti ne piko metu, nes visi įverčiai bus perskaičiuoti, o tai gali sukelti didelę serverio apkrovą.';
$string['minmaxtouse_help'] = 'Šis parametras nustato, ar skaičiuojant įverčių knygelėje rodomą įvertį naudoti pradinius minimalius ir maksimalius įverčius nuo tada, kai buvo suteiktas įvertis, ar minimalius ir maksimalius įverčius, nurodytus įverčio elemento nustatymuose.';
$string['minmaxtouse_link'] = 'Grades_min_max';
$string['minmaxupgradedgrades'] = 'Pastaba: Kai kurie įverčiai buvo pakeisti, siekiant pašalinti įverčių knygelės nenuoseklumą, atsiradusį dėl minimalaus ir maksimalaus įvertinimo, naudojamo apskaičiuojant rodomą įvertį, pasikeitimo. Pakeitimus rekomenduojama peržiūrėti ir priimti.';
$string['minmaxupgradefixbutton'] = 'Išspręsti nesuderinamumus';
$string['minmaxupgradewarning'] = 'Pastaba: Kai kurių įverčių neatitikimas buvo aptiktas dėl minimalaus ir maksimalaus įvertinimo, naudojamo skaičiuojant įverčių knygelėje rodomą įvertį, pasikeitimo. Rekomenduojama, kad neatitikimas būtų pašalintas spustelėjus toliau esantį mygtuką, nors dėl to kai kurie įverčiai bus pakeisti.';
$string['missingitemtypeoreid'] = 'Masyvo rakto (itemtype arba eid) trūksta 2-ame grade_edit_tree_column_select::get_item_cell($item, $params) parametre';
$string['missingscale'] = 'Reikia pasirinkti skalę';
$string['mode'] = 'Moda';
$string['modgrade'] = 'Įvertinimas';
$string['modgrade_help'] = 'Pasirinkite šiai veiklai naudojamą įvertinimo tipą. Jei pasirinkote skalę, galite pasirinkti skalę iškrentačiame meniu. Jei naudojate balų vertinimą, galite įvesti maksimalų šios veiklos įvertinimą.';
$string['modgradecantchangegradetype'] = 'Jūs negalite pakeisti tipo, nes šis elementas jau turi įvertinimus.';
$string['modgradecantchangegradetypemsg'] = 'Kai kurie įverčiai jau suteikti, todėl įverčio tipo keisti negalima. Jei norite pakeisti maksimalų įvertinimą, pirmiausia turite pasirinkti, ar pakeisti esamų įverčių skalę, ar ne.';
$string['modgradecantchangegradetyporscalemsg'] = 'Kai kurie įvertinimai jau suteikti, todėl įvertinimo tipo ir skalės keisti negalima.';
$string['modgradecantchangeratingmaxgrade'] = 'Negalite keisti maksimalaus įvertinimo, kai jau yra veikla su įvertinimais.';
$string['modgradecantchangescale'] = 'Jūs negalite pakeisti skalės, nes šis elementas jau turi įvertinimus.';
$string['modgradecategorycantchangegradetypemsg'] = 'Šioje kategorijoje yra susiję įverčių elementai, kurie buvo pakeisti. Todėl kai kurie įverčiai jau suteikti, taigi įverčio tipo keisti negalima. Jei norite pakeisti maksimalų įvertinimą, pirmiausia turite pasirinkti, ar pakeisti esamų įverčių skalę.';
$string['modgradecategorycantchangegradetyporscalemsg'] = 'Šioje kategorijoje yra susiję įverčių elementai, kurie buvo perrašyti. Todėl kai kurie balai jau suteikti, taigi įverčių tipo ir skalės keisti negalima.';
$string['modgradecategoryrescalegrades'] = 'Pakeisti perrašytų įvertinimų skalę';
$string['modgradecategoryrescalegrades_help'] = 'Keisdami maksimalius įverčius įverčių knygelės elemente, turite nurodyti, ar dėl to pasikeis ir esami procentiniai įverčiai.

Jei tai nustatyta į „Taip“, visi esami keistini įverčiai bus pakeisti taip, kad procentinis įvertinimas išliktų toks pat.

Pavyzdžiui, jei ši parinktis nustatyta į „Taip“, pakeitus maksimalų elemento įvertinimą nuo 10 iki 20, įvertinimas 6/10 (60 %) būtų pakeistas į 12/20 (60 %). Nustačius šią parinktį į „Ne“, įvertis išliks nepakitęs, todėl norint užtikrinti teisingus balus, įverčių elementus reikės koreguoti rankiniu būdu.';
$string['modgradedonotmodify'] = 'Nekeisti esamų įvertinimų';
$string['modgradeerrorbadpoint'] = 'Neteisinga įvertinimo vertė. Turi būti sveikas skaičius nuo 1 iki {$a}';
$string['modgradeerrorbadscale'] = 'Pasirinkta netinkama skalė. Įsitikinkite, kad pasirinkote skalę iš toliau pateiktų pasirinkimų.';
$string['modgrademaxgrade'] = 'Didžiausias įvertinimas';
$string['modgraderescalegrades'] = 'Pakeisti esamų įvertinimų skalę';
$string['modgraderescalegrades_help'] = 'Keisdami maksimalius įverčius įverčių knygelės elemente, turite nurodyti, ar dėl to pasikeis ir esami procentiniai įverčiai.

Jei tai nustatyta į „Taip“, visi esami keistini įverčiai bus pakeisti taip, kad procentinis įvertinimas išliktų toks pat.

Pavyzdžiui, jei ši parinktis nustatyta į „Taip“, pakeitus maksimalų elemento įvertinimą nuo 10 iki 20, įvertinimas 6/10 (60 %) būtų pakeistas į 12/20 (60 %). Nustačius šią parinktį į „Ne“, įvertis pasikeistų iš 6/10 (60 %) į 6/20 (30 %), todėl norint užtikrinti teisingus balus, reikia rankiniu būdu koreguoti įverčių elementus.';
$string['modgradetype'] = 'Tipas';
$string['modgradetypenone'] = 'Nėra';
$string['modgradetypepoint'] = 'Balas';
$string['modgradetypescale'] = 'Skalė';
$string['morethanmax'] = '{$a->username} {$a->itemname} įvestas įvertinimas yra didesnis už leidžiamą didžausią';
$string['moveselectedto'] = 'Pasirinktus elementus perkelti į';
$string['movingelement'] = 'Perkėlimas {$a}';
$string['multfactor'] = 'Daugiklis';
$string['multfactor_help'] = 'Daugiklis yra koeficientas, iš kurio bus padauginti visi šio įverčio elemento įverčiai, naudojant didžiausio įverčio didžiausią reikšmę. Pvz., jei daugiklis yra 2, o didžiausias įvertis – 100, tai visi įverčiai, mažesni už 50 bus dauginami iš 2, o visi įverčiai, lygūs 50 ir didesni, bus pakeisti į 100.';
$string['multfactorvalue'] = 'Daugiklio vertė {$a}';
$string['mustchooserescaleyesorno'] = 'Turite pasirinkti, ar pakeisti esamų įvertinimų skalę, arba ne.';
$string['mygrades'] = 'Naudotojo meniu įvertinimų nuoroda';
$string['mygrades_desc'] = 'Šis nustatymas leidžia naudotojo meniu susieti su išorine įvertinimų knygele.';
$string['mypreferences'] = 'Mano nuostatos';
$string['myreportpreferences'] = 'Mano ataskaitos nuostatos';
$string['myself'] = 'Aš pats (-i)';
$string['navmethod'] = 'Naršymo būdas';
$string['neverdeletehistory'] = 'Niekada nenaikinti retrospektyvos';
$string['newcategory'] = 'Nauja kategorija';
$string['newitem'] = 'Naujas įvertinimo elementas';
$string['newoutcomeitem'] = 'Naujas rezultato elementas';
$string['no'] = 'Ne';
$string['nocategories'] = 'Nepavyko įtraukti ar rasti šio kurso įvertinimų kategorijų';
$string['nocategoryname'] = 'Kategorijai nesuteiktas pavadinimas.';
$string['nocategoryview'] = 'Nėra kategorijos norint peržiūrėti pagal';
$string['nocourses'] = 'Dar nėra kursų';
$string['noexistingoutcomes'] = 'Esamų rezultatų nėra.';
$string['noexistingscales'] = 'Esamų skalių nėra.';
$string['noforce'] = 'Nereikalauti';
$string['nogradeletters'] = 'Nenustatyta įvertinimo raidė';
$string['nogradesreturned'] = 'Įvertinimų nepateikta';
$string['noidnumber'] = 'Nėra ID numerio';
$string['nolettergrade'] = 'Nėra raidinio įvertinimo, skirto';
$string['nomode'] = 'Nėra';
$string['nonnumericweight'] = 'Gauta neskaitinė reikšmė, skirta';
$string['nonunhideableverbose'] = 'Jei norite nebeslėpti šio įvertinimo, turite nebeslėpti {$a->itemname}.';
$string['nonunlockableverbose'] = 'Norėdami atrakinti šį įvertinimą, turite atrakinti {$a->itemname}.';
$string['nonweightedpct'] = 'nesvertiniai %';
$string['nooutcome'] = 'Rezultato nėra';
$string['nooutcomes'] = 'Rezultatų elementai turi būti susieti su kursų rezultatu, bet nėra šių kursų rezultato. Ar norite įtraukti rezultatą?';
$string['nopermissiontoresetweights'] = 'Nėra leidimo atnaujinti svertus.';
$string['nopublish'] = 'Nepublikuoti';
$string['noreports'] = 'Jūs nesate įregistruotas į jokį kursą ir neturite savo kursų.';
$string['noresultsfor'] = 'Nėra „{$a}“ rezultatų';
$string['norolesdefined'] = 'Nėra apibrėžtų vaidmenų Administravimas > Įvertinimai > Bendrieji nustatymai> Įvertinti vaidmenys';
$string['noscales'] = 'Rezultatai turi būti susieti su kursų skale arba visuotine skale, bet nė vienos nėra. Ar norite įtraukti skalę?';
$string['noselectedcategories'] = 'kategorijų nepasirinkta.';
$string['noselecteditems'] = 'elementų nepasirinkta.';
$string['notenrolled'] = 'Jūs nesate įregistruotas į jokį kursą.';
$string['notteachererror'] = 'Norėdami naudoti šią funkciją turite būti dėstytojas.';
$string['nousersloaded'] = 'Besimokančiųjų neįkelta';
$string['nouserstograde'] = 'Nėra naudotojų įvertinimui';
$string['numberofgrades'] = 'Įvertinimų skaičius';
$string['onascaleof'] = 'skalėje nuo {$a->grademin} iki {$a->grademax}';
$string['operations'] = 'Veiksmai';
$string['options'] = 'Parinktys';
$string['others'] = 'Kiti';
$string['otheruser'] = 'Naudotojas';
$string['outcome'] = 'Rezultatas';
$string['outcome_help'] = 'Šis parametras nustato rezultatą, rezultatą, kurį šis įverčio elementas nurodys įverčių knygelėje.';
$string['outcomeassigntocourse'] = 'Šiems kursams priskirti kitą rezultatą';
$string['outcomecategory'] = 'Kurti kategorijos rezultatus';
$string['outcomecategorynew'] = 'Nauja kategorija';
$string['outcomeconfirmdelete'] = 'Ar tikrai norite naikinti rezultatą {$a}?';
$string['outcomecreate'] = 'Įtraukti naują rezultatą';
$string['outcomedelete'] = 'Naikinti rezultatą';
$string['outcomefullname'] = 'Pilnas pavadinimas';
$string['outcomeitem'] = 'Rezultato elementas';
$string['outcomeitemsedit'] = 'Redaguoti rezultato elementą';
$string['outcomereport'] = 'Rezultatų ataskaita';
$string['outcomes'] = 'Rezultatai';
$string['outcomescourse'] = 'Kursuose naudojami rezultatai';
$string['outcomescoursecustom'] = 'Naudojamas pasirinktinis (be šalinimo)';
$string['outcomescoursenotused'] = 'Standartinis nenaudojamas';
$string['outcomescourseused'] = 'Naudojamas standartinis (be šalinimo)';
$string['outcomescustom'] = 'Pasirinktiniai rezultatai';
$string['outcomesdisabled'] = 'Rezultatai neįjungti';
$string['outcomeshortname'] = 'Trumpas pavadinimas';
$string['outcomesstandard'] = 'Standartiniai rezultatai';
$string['outcomesstandardavailable'] = 'Galimi standartiniai rezultatai';
$string['outcomestandard'] = 'Standartinis rezultatas';
$string['outcomestandard_help'] = 'Standartinis rezultatas pasiekiamas visoje svetainėje, visuose kursuose.';
$string['overallaverage'] = 'Bendras vidurkis';
$string['overridden'] = 'Pakeista';
$string['overridden_help'] = 'Jei pažymėta, šioje veikloje įverčio keisti nebegalima. Jei įvertis redaguojamas vertintojo ataskaitoje, automatiškai pažymimas keitimo žymės langelis. Bet jo žymėjimą galima panaikinti, kad įvertį būtų galima keisti naudojant susijusią veiklą.';
$string['overriddennotice'] = 'Šios veiklos galutinis įvertinimas buvo koreguotas rankiniu būdu.';
$string['overridecat'] = 'Leisti kategorijos įvertinimus keisti rankiniu būdu';
$string['overridecat_help'] = 'Išjungus šį nustatymą, naudotojai negali nepaisyti kategorijų įvertinimų.';
$string['overridesitedefaultgradedisplaytype'] = 'Keisti svetainės numatytąsias reikšmes';
$string['overridesitedefaultgradedisplaytype_help'] = 'Jei pažymėta, užuot naudojus svetainės numatytąsias reikšmes, galima nustatyti kursų įverčių raides ir ribas.';
$string['overrideweightofa'] = 'Keisti {$a} svertus';
$string['parentcategory'] = 'Pirminė kategorija';
$string['pass'] = 'Išlaikyta';
$string['pctoftotalgrade'] = '% nuo bendrojo įvertinimo';
$string['percent'] = 'Procentai';
$string['percentage'] = 'Procentai';
$string['percentageletter'] = 'Procentai (raidė)';
$string['percentagereal'] = 'Procentai (tikrasis)';
$string['percentascending'] = 'Rikiuoti pagal procentus didėjimo tvarka';
$string['percentdescending'] = 'Rikiuoti pagal procentus mažėjimo tvarka';
$string['percentshort'] = '%';
$string['plusfactor'] = 'Poslinkis';
$string['plusfactor_help'] = 'Poslinkis – tai skaičius, kuris pridedamas prie šio įverčio elemento kiekvieno įverčio po to, kai panaudojamas daugiklis.';
$string['plusfactorvalue'] = 'Poslinkio reikšmė {$a}';
$string['points'] = 'taškai';
$string['pointsascending'] = 'Rikiuoti pagal taškus didėjimo tvarka';
$string['pointsdescending'] = 'Rikiuoti pagal taškus mažėjimo tvarka';
$string['positionfirst'] = 'Pirmas';
$string['positionlast'] = 'Paskutinis';
$string['preferences'] = 'Nuostatos';
$string['prefgeneral'] = 'Bendra';
$string['prefletters'] = 'Įvertinimų raidės ir ribos';
$string['prefrows'] = 'Specialiosios eilutės';
$string['prefshow'] = 'Rodyti / slėpti jungiklius';
$string['previewrows'] = 'Peržiūrėti eilutes';
$string['privacy:metadata:categorieshistory'] = 'Ankstesnių įvertinimų kategorijų versijų įrašas';
$string['privacy:metadata:filepurpose'] = 'Atsiliepimų failai, saugomi naudotojo įvertinimų knygelėje.';
$string['privacy:metadata:grade_import_newitem'] = 'Laikina lentelė naujiems grade_item pavadinimams saugoti iš importuotų įvertinimų';
$string['privacy:metadata:grade_import_newitem:importcode'] = 'Unikalus partijos kodas, skirtas identifikuoti vieną importuojamą partiją';
$string['privacy:metadata:grade_import_newitem:importer'] = 'Naudotojas, importuojantis duomenis';
$string['privacy:metadata:grade_import_newitem:itemname'] = 'Naujo įvertinimo elemento pavadinimas';
$string['privacy:metadata:grade_import_values'] = 'Laikina įvertinimų importavimo lentelė';
$string['privacy:metadata:grade_import_values:feedback'] = 'Įvertinimo atsiliepimas';
$string['privacy:metadata:grade_import_values:finalgrade'] = 'Neapdoroto įvertinimo vertė';
$string['privacy:metadata:grade_import_values:importcode'] = 'Unikalus partijos kodas, skirtas identifikuoti vieną importuojamą partiją';
$string['privacy:metadata:grade_import_values:importer'] = 'Naudotojas, importuojantis duomenis';
$string['privacy:metadata:grade_import_values:importonlyfeedback'] = 'Pažymėti, jei buvo importuotas tik atsiliepimas';
$string['privacy:metadata:grade_import_values:userid'] = 'Naudotojas, kurio įvertinimas buvo importuotas';
$string['privacy:metadata:grades'] = 'Įvertinimo įrašas';
$string['privacy:metadata:grades:aggregationstatus'] = 'The aggregation status';
$string['privacy:metadata:grades:aggregationweight'] = 'Svoris agreguojant';
$string['privacy:metadata:grades:feedback'] = 'Atsiliepimas';
$string['privacy:metadata:grades:finalgrade'] = 'Įvertinimas';
$string['privacy:metadata:grades:information'] = 'Papildoma informacija apie įvertinimą';
$string['privacy:metadata:grades:timemodified'] = 'Laikas, kada įvertinimas buvo paskutinį kartą pakeistas';
$string['privacy:metadata:grades:userid'] = 'Naudotojo, kurio įvertinimas tai yra, ID';
$string['privacy:metadata:grades:usermodified'] = 'Paskutinį kartą įrašą keitusio naudotojo ID';
$string['privacy:metadata:gradeshistory'] = 'Ankstesnių įvertinimų įrašas';
$string['privacy:metadata:history:loggeduser'] = 'Naudotojo, kuris buvo prisijungęs, kai buvo sukurta versija, ID';
$string['privacy:metadata:history:timemodified'] = 'Laikas, kai įvyko įvertinimų versijų kūrimas';
$string['privacy:metadata:itemshistory'] = 'Ankstesnių įvertinimų elementų versijų įrašas';
$string['privacy:metadata:outcomes'] = 'Rezultatų įrašas';
$string['privacy:metadata:outcomes:timemodified'] = 'Laikas, kai buvo pakeistas įrašas';
$string['privacy:metadata:outcomes:usermodified'] = 'Naudotojas, paskutinį kartą pakeitęs įrašą';
$string['privacy:metadata:outcomeshistory'] = 'Ankstesnių rezultatų versijų įrašas';
$string['privacy:metadata:scale'] = 'Skalių įrašas';
$string['privacy:metadata:scale:timemodified'] = 'Laikas, kada įrašas buvo paskutinį kartą pakeistas';
$string['privacy:metadata:scale:userid'] = 'Naudotojas, paskutinį kartą pakeitęs įrašą';
$string['privacy:metadata:scalehistory'] = 'Ankstesnių skalių versijų įrašas';
$string['privacy:path:relatedtome'] = 'Su manimi susiję';
$string['privacy:request:historyactiondelete'] = 'Ištrinti';
$string['privacy:request:historyactioninsert'] = 'Įterpti';
$string['privacy:request:historyactionupdate'] = 'Atnaujinti';
$string['privacy:request:unknowndeletedgradeitem'] = 'Nežinomas (įvertinimo elementas buvo ištrintas)';
$string['profilereport'] = 'Naudotojo profilio ataskaita';
$string['profilereport_help'] = 'Įvertinimų ataskaita, naudojama naudotojo profilio puslapyje.';
$string['publishing'] = 'Publikavimas';
$string['publishingoptions'] = 'Įverčio paskelbimo parametrai';
$string['quickfeedback'] = 'Spartusis atsiliepimas';
$string['quickgrading'] = 'Spartusis vertinimas';
$string['quickgrading_help'] = 'Jei įjungta, kai įjungtas redagavimas, rodomas kiekvieno įverčio teksto įvesties laukas, leidžiantis vienu metu redaguoti kelis įverčius. Spustelėjus naujinimo mygtuką, keitimai įrašomi ir paryškinami. Atkreipkite dėmesį, kad įvertį redaguojant vertinimo ataskaitoje nustatoma pakeitimo žymė, o tai reiškia, kad įverčio nebus galima redaguoti susijusioje veikloje.';
$string['range'] = 'Intervalas';
$string['rangedecimals'] = 'Diapazonas po kablelio';
$string['rangedecimals_help'] = 'Diapazono skaitmenų po kablelio skaičius.';
$string['rangesdecimalpoints'] = 'Intervalų dešimtainės skiltys';
$string['rangesdecimalpoints_help'] = 'Šis nustatymas nustato, kiek skaitmenų po kablelio turi būti rodoma kiekviename diapazone, arba ar naudojamas (paveldėtas) bendras kategorijos ar įvertinimo elemento dešimtainių ženklų nustatymas.';
$string['rangesdisplaytype'] = 'Intervalo rodymo tipas';
$string['rangesdisplaytype_help'] = 'Šis parametras nustato, ar intervalas bus rodomas kaip tikrieji įverčiai, procentai ar raidės arba ar bus naudojamas (paveldimas) kategorijos ar įverčio elemento rodymo tipas.';
$string['rank'] = 'Rangas';
$string['rawpct'] = 'Neapdoroti %';
$string['real'] = 'Tikrasis';
$string['realletter'] = 'Tikrasis (raidė)';
$string['realpercentage'] = 'Tikrasis (procentai)';
$string['recalculatinggrades'] = 'Perskaičiuojami įvertinimai';
$string['recovergradesdefault'] = 'Atstatyti numatytuosius įvertinimus';
$string['recovergradesdefault_help'] = 'Pagal numatytuosius nustatymus, atstatyti senus naudotojo įvertinimus jį pakartotinai įregistravus į kursą.';
$string['refreshpreview'] = 'Atnaujinti peržiūrą';
$string['regradeanyway'] = 'Vis tiek vertinti iš naujo';
$string['removeallcoursegrades'] = 'Naikinti visus įvertinimus';
$string['removeallcoursegrades_help'] = 'Jei pažymėsite, visi įverčių elementai ir įverčiai, kurie buvo rankiniu būdu įtraukti į įverčių knygelę, bus ištrinti, taip pat duomenys apie nepaisytus, neįtrauktus, paslėptus ir užrakintus įverčius. Liks tik įverčių elementai ir su veikla susiję įverčiai.';
$string['removeallcourseitems'] = 'Naikinti visus elementus ir kategorijas';
$string['removeallcourseitems_help'] = 'Jei pažymėta, visos kategorijos ir įverčių elementai, kurie buvo rankiniu būdu įtraukti į įverčių knygelę, bus ištrinti kartu su įverčiais ir duomenimis apie pakeistus, neįtrauktus, paslėptus ir užrakintus įverčius. Liks tik su veikla susiję įverčių elementai.';
$string['report'] = 'Ataskaita';
$string['reportdefault'] = 'Numatytoji ataskaita ({$a})';
$string['reportplugins'] = 'Ataskaitos papildiniai';
$string['reportsettings'] = 'Ataskaitos parametrai';
$string['reprintheaders'] = 'Iš naujo spausdinti antraštes';
$string['resetweights'] = 'Iš naujo nustatyti {$a->itemname} svorį';
$string['resetweightsshort'] = 'Iš naujo nustatyti svorius';
$string['respectingcurrentdata'] = 'dabartinė konfigūracija paliekama nemodifikuota';
$string['rowpreviewnum'] = 'Peržiūrėti eilutes';
$string['rowpreviewnum_help'] = 'Importuotini duomenys gali būti peržiūrimi prieš patvirtinant importavimą. Šis nustatymas nustato, kiek eilučių bus rodoma peržiūroje.';
$string['savechanges'] = 'Įrašyti keitimus';
$string['savepreferences'] = 'Įrašyti nuostatas';
$string['scaleconfirmdelete'] = 'Ar tikrai norite naikinti skalę {$a}?';
$string['scaledpct'] = 'Skalės %';
$string['searchcollapsedcolumns'] = 'Ieškoti sutrauktų stulpelių';
$string['searchgroups'] = 'Ieškoti grupių';
$string['searchusers'] = 'Ieškoti naudotojų';
$string['seeallcoursegrades'] = 'Rodyti visus kurso įvertinimus';
$string['select'] = 'Pasirinkti {$a}';
$string['selectalloroneuser'] = 'Pasirinkti visus arba vieną naudotoją';
$string['selectauser'] = 'Pasirinkite naudotoją';
$string['selectdestination'] = 'Pasirinkite {$a} paskirtį';
$string['selectgrouplink'] = 'Pasirinkti grupę';
$string['selectuserlink'] = 'Pasirinkti naudotoją';
$string['separator'] = 'Skyriklis';
$string['separator_help'] = 'Pasirinkite skyriklį CSV faile. (Paprastai tai yra kablelis.)';
$string['sepcolon'] = 'Dvitaškis';
$string['sepcomma'] = 'Kablelis';
$string['sepsemicolon'] = 'Kabliataškis';
$string['septab'] = 'Tabuliavimo ženklas';
$string['setcategories'] = 'Nustatyti kategorijas';
$string['setcategorieserror'] = 'Pirmiausia turite nustatyti kursų kategorijas, tik tada galėsite suteikti joms svarbą.';
$string['setgradeletters'] = 'Nustatyti įvertinimų raides';
$string['setpreferences'] = 'Nustatyti nuostatas';
$string['setting'] = 'Parametras';
$string['settings'] = 'Parametrai';
$string['setup'] = 'Sąranka';
$string['setweights'] = 'Nustatyti svarbą';
$string['showactivityicons'] = 'Rodyti veiklų piktogramas';
$string['showactivityicons_help'] = 'Jei įjungta, šalia veiklų pavadinimų rodomos veiklų piktogramos.';
$string['showallgrades'] = 'Rodyti visus įvertinimus';
$string['showallhidden'] = 'Rodyti paslėptus';
$string['showallstudents'] = 'Rodyti visus besimokančiuojus';
$string['showanalysisicon'] = 'Rodyti įvertinimų analizės piktogramą.';
$string['showanalysisicon_desc'] = 'Ar rodyti įverčio analizės piktogramą pagal numatyta. Jei veiklos modulis tai palaiko, įverčio analizės piktograma veda į puslapį su detalesniu įverčio paaiškinimu ir kaip jis buvo gautas.';
$string['showanalysisicon_help'] = 'Jei veiklos modulis palaiko tai, vertinimo analizės piktograma veda į puslapį su detalesniu pažymio paaiškinimu ir kaip jis buvo gautas.';
$string['showaverage'] = 'Rodyti vidurkį';
$string['showaverage_help'] = 'Ar rodyti stulpelio vidurkį. Jei vidurkis bus apskaičiuotas naudojant mažą įverčių skaičių, besimokantieji galės apytikriai apskaičiuoti kitų besimokančiųjų įverčius. Našumo tikslais vidurkis yra apytikslis, jei jis priklauso nuo paslėptų elementų.';
$string['showaverages'] = 'Rodyti stulpelių vidurkius';
$string['showaverages_help'] = 'Jei įjungta, vertintojo ataskaitoje bus papildoma eilutė, kurioje bus rodomas kiekvienos kategorijos ir įvertinimo elemento vidurkis.';
$string['showcalculations'] = 'Rodyti skaičiavimus';
$string['showcalculations_help'] = 'Jei įjungta, redaguojant, prie kiekvieno įvertinimo elemento ir kategorijos rodoma skaičiuotuvo piktograma su vaizdiniu indikatoriumi, kad įvertinimo elementas yra apskaičiuotas.';
$string['showcontributiontocoursetotal'] = 'Rodyti indėlį į bendrą kurso įvertinimą';
$string['showcontributiontocoursetotal_help'] = 'Ar rodyti procentų stulpelį, nurodantį, kiek kiekvienas įvertinimo elementas įneša į bendrą naudotojo kurso procentinę dalį (pritaikius svorį).';
$string['showeyecons'] = 'Rodyti rodymo / slėpimo piktogramas';
$string['showeyecons_help'] = 'Jei įjungta, kai įjungtas redagavimas, rodoma kiekvieno įvertinimo rodymo / slėpimo piktograma, leidžianti valdyti, ar juos matys besimokantieji.';
$string['showfeedback'] = 'Rodyti atsiliepimą';
$string['showfeedback_help'] = 'Ar rodyti atsiliepimų stulpelį.';
$string['showgrade'] = 'Rodyti įvertinimus';
$string['showgrade_help'] = 'Ar rodyti įvertinimų stulpelį.';
$string['showgroups'] = 'Rodyti grupes';
$string['showhiddenitems'] = 'Rodyti paslėptus elementus';
$string['showhiddenitems_help'] = 'Paslėpti įverčių elementai yra paslėpti visiškai arba besimokantieji mato paslėptų įverčių elementų pavadinimus. * Rodyti paslėptus – paslėptų įverčių elementų pavadinimai rodomi, bet besimokančiųjų įverčiai yra paslėpti * Tik paslėpti iki – įverčių elementai, kuriems nustatyta data Slėpti iki, yra visiškai paslėpti iki nustatytos datos, vėliau rodomas visas elementas * Nerodyti – paslėpti įverčių elementai yra visiškai paslėpti';
$string['showhiddenuntilonly'] = 'Tik paslėpti iki';
$string['showingaggregatesonly'] = 'Rodomos tik sumos';
$string['showingfullmode'] = 'Rodomi įvertinimai ir sumos';
$string['showinggradesonly'] = 'Rodomi tik įvertinimai';
$string['showlettergrade'] = 'Rodyti raidinius įvertinimus';
$string['showlettergrade_help'] = 'Ar rodyti raidinių įvertinimų stulpelį.';
$string['showlocks'] = 'Rodyti užraktus';
$string['showlocks_help'] = 'Jei įjungta, kai įjungtas redagavimas, rodoma kiekvieno įverčio užrakinimo / atrakinimo piktograma, leidžianti valdyti, ar susijusi veikla gali automatiškai naujinti įvertį.';
$string['shownohidden'] = 'Nerodyti';
$string['shownooutcomes'] = 'Slėpti rezultatus';
$string['shownumberofgrades'] = 'Rodyti įvertinimų skaičių vidurkiuose';
$string['shownumberofgrades_help'] = 'Jei įjungta, po kiekvieno vidurkio skliausteliuose rodomas įvertinimų, naudotų apskaičiuojant vidurkį, skaičius.';
$string['showonlyactiveenrol'] = 'Rodyti tik aktyvias registracijas';
$string['showonlyactiveenrol_help'] = 'Šis nustatymas nustato, ar įverčių knygelės ataskaitoje bus matomi tik aktyvūs užsiregistravę naudotojai. Jei įjungta, sustabdyti naudotojai nebus rodomi įverčių knygelėje.';
$string['showpercentage'] = 'Rodyti procentus';
$string['showpercentage_help'] = 'Ar rodyti kiekvieno įvertinimo elemento procentinę reikšmę.';
$string['showquickfeedback'] = 'Rodyti spartųjį atsiliepimą';
$string['showquickfeedback_help'] = 'Jei įjungta, kai įjungtas redagavimas, rodomas kiekvieno įverčio atsiliepimo teksto įvesties laukas su taškinėmis kraštinėmis, leidžiantis vienu metu redaguoti kelių įverčių atsiliepimus. Spustelėjus naujinimo mygtuką, keitimai įrašomi ir paryškinami. Atkreipkite dėmesį, kad atsiliepimą redaguojant vertinimo ataskaitoje nustatoma pakeitimo žymė, o tai reiškia, kad atsiliepimo nebus galima redaguoti susijusioje veikloje.';
$string['showrange'] = 'Rodyti intervalus';
$string['showrange_help'] = 'Ar rodyti diapazono stulpelį.';
$string['showranges'] = 'Rodyti intervalus';
$string['showranges_help'] = 'Jei įjungta, vertintojo ataskaitoje bus papildoma eilutė, kurioje bus rodomas kiekvienos kategorijos ir įvertinimo elemento intervalas.';
$string['showrank'] = 'Rodyti rangą';
$string['showrank_help'] = 'Ar kiekvienam įvertinimo punktui parodyti besimokančiojo padėtį, palyginti su likusia dalyvių dalimi.';
$string['showuserimage'] = 'Rodyti naudotojų profilių vaizdus';
$string['showuserimage_help'] = 'Ar vertintojo ataskaitoje rodyti naudotojo profilio vaizdą šalia vardo?';
$string['showverbose'] = 'Rodyti {$a->category} {$a->itemmodule} {$a->itemname}';
$string['showweight'] = 'Rodyti svarbą';
$string['showweight_help'] = 'Ar rodyti įvertinimo svorio stulpelį.';
$string['simpleview'] = 'Vieno elemento rodinys';
$string['sitewide'] = 'Visos svetainės';
$string['sort'] = 'rikiuoti';
$string['sortasc'] = 'Rikiuoti didėjimo tvarka';
$string['sortbyfirstname'] = 'Rikiuoti pagal vardą';
$string['sortbylastname'] = 'Rikiuoti pagal pavardę';
$string['sortdesc'] = 'Rikiuoti mažėjimo tvarka';
$string['standarddeviation'] = 'Standartinis nuokrypis';
$string['stats'] = 'Statistika';
$string['statslink'] = 'Statistika';
$string['student'] = 'Besimokantysis';
$string['studentsperpage'] = 'Besimokančiųjų skaičius puslapyje';
$string['studentsperpage_help'] = 'Šis parametras nustato, kiek besimokančiųjų rodoma viename vertintojo ataskaitos puslapyje.';
$string['studentsperpagereduced'] = 'Didžiausias besimokančiųjų skaičius puslapyje sumažintas nuo {$a->originalstudentsperpage} iki {$a->studensperpage}. Apsvarstykite galimybę padidinti PHP nustatymą max_input_vars nuo {$a->maxinputvars}.';
$string['subcategory'] = 'Įprasta kategorija';
$string['submissions'] = 'Pateikimai';
$string['submittedon'] = 'Pateikta: {$a}';
$string['sumofgradesupgradedgrades'] = 'Pastaba: atnaujinant svetainę, apibendrinimo metodas „Įverčių suma“ buvo pakeistas į „Natūralus“. Kadangi šiame kurse anksčiau buvo naudojama „įverčių suma“, rekomenduojama šį pakeitimą peržiūrėti įverčių knygelėje.';
$string['switchtofullview'] = 'Perjungti į visą rodinį';
$string['switchtosimpleview'] = 'Perjungti į paprastą rodinį';
$string['tabs'] = 'Skirtukai';
$string['topcategory'] = 'Superkategorija';
$string['total'] = 'Bendroji suma';
$string['totalweight100'] = 'Bendra svarba yra lygi 100';
$string['totalweightnot100'] = 'Bendra svarba nelygi 100';
$string['turnfeedbackoff'] = 'Išjungti atsiliepimą';
$string['turnfeedbackon'] = 'Įjungti atsiliepimą';
$string['typenone'] = 'Nėra';
$string['typescale'] = 'Skalė';
$string['typescale_help'] = 'Šis parametras nustato naudojamą skalę, kai naudojamas skalės įverčio tipas. Veikla pagrįsto įverčio elemento skalė nustatoma veiklos parametrų puslapyje.';
$string['typetext'] = 'Tekstas';
$string['typevalue'] = 'Reikšmė';
$string['uncategorised'] = 'Neklasifikuota';
$string['unchangedgrade'] = 'Įvertinimas nepakeistas';
$string['unenrolledusersinimport'] = 'Į eksportavimą įtraukti šie naudotojų, kurie dabar neįregistruoti šiame kurse, įvertinimai: {$a}';
$string['unlimitedgrades'] = 'Neriboti įvertinimai';
$string['unlimitedgrades_help'] = 'Pagal numatytuosius nustatymus įverčiai yra apriboti didžiausia ir mažiausia įverčio elemento reikšmėmis. Įjungus šį parametrą, limitas pašalinamas ir tiesiogiai į įverčių knygelę galima įvesti didesnius nei 100 % įverčius.';
$string['unlock'] = 'Atrakinti';
$string['unlockverbose'] = 'Atrakinti {$a->category} {$a->itemmodule} {$a->itemname}';
$string['unused'] = 'Nenaudojama';
$string['updatedgradesonly'] = 'Eksportuoti tik naujus ar atnaujintus įvertinimus';
$string['upgradedgradeshidemessage'] = 'Atmesti pranešimą';
$string['upgradedminmaxrevertmessage'] = 'Grąžinti keitimus';
$string['uploadgrades'] = 'Įkelti įvertinimus';
$string['useadvanced'] = 'Naudoti išplėstines funkcijas';
$string['usedcourses'] = 'Naudoti kursai';
$string['usedgradeitem'] = 'Naudotas įvertinimo elementas';
$string['usenooutcome'] = 'Nenaudoti rezultatų';
$string['usenoscale'] = 'Nenaudoti skalės';
$string['usepercent'] = 'Naudoti procentus';
$string['user'] = 'Naudotojas';
$string['userenrolmentsuspended'] = 'Naudotojo registracija sustabdyta';
$string['userfields_show'] = 'Rodyti naudotojo laukus';
$string['userfields_show_help'] = 'Vertintojo ataskaitoje rodyti papildomus naudotojo laukus, pvz., el. pašto adresą. Konkrečius rodomus laukus valdo svetainės nustatymas showuseridentity';
$string['usergrade'] = 'Elemento {$a->gradeidnumber} naudotojas {$a->fullname} ({$a->useridnumber})';
$string['userid'] = 'Naudotojo ID';
$string['useridnumberwarning'] = 'Naudotojai, neturintys ID numerio, neįtraukiami į eksportą, nes jų nebus galima importuoti';
$string['usermappingerror'] = 'Naudotojo susiejimo klaida: nepavyko rasti naudotojo su {$a->field} iš "{$a->value}".';
$string['usermappingerrorcurrentgroup'] = 'Naudotojas nėra dabartinės grupės narys';
$string['usermappingerrormultipleusersfound'] = 'Naudotojo susiejimo klaida: rasti keli naudotojai, kurių {$a->field} iš „{$a->value}“. Naudokite unikalesnį atvaizdavimo lauką.';
$string['usermappingerrorusernotfound'] = 'Naudotojo susiejimo klaida. Nepavyko rasti naudotojo.';
$string['usermatchedon'] = 'Šis naudotojas atitinka paiešką pagal laukelį';
$string['userpreferences'] = 'Naudotojo nuostatos';
$string['useweighted'] = 'Naudoti svertinius';
$string['verbosescales'] = 'Daugiažodės skalės';
$string['verbosescales_help'] = 'Daugiareikšmėje skalėje naudojami žodžiai, o ne skaičiai. Jei norite importuoti ir skaitines, ir žodines skales, nustatykite į „Taip“. Nustatykite „Ne“, jei norite importuoti tik skaitines skales.';
$string['viewas'] = 'Peržiūrėti ataskaitą kaip';
$string['viewbygroup'] = 'Grupė';
$string['viewfeedback'] = 'Žiūrėti atsiliepimus';
$string['viewgrades'] = 'Žiūrėti įvertinimus';
$string['weight'] = 'Svarba';
$string['weight_help'] = 'Reikšmė, naudojama norint nustatyti santykinę kelių kategorijos ar kurso įverčių vertę.';
$string['weightcourse'] = 'Naudoti svertinius kursų įvertinimus';
$string['weightedascending'] = 'Rikiuoti pagal svertinius procentus didėjimo tvarka';
$string['weighteddescending'] = 'Rikiuoti pagal svertinius procentus mažėjimo tvarka';
$string['weightedpct'] = 'svertiniai %';
$string['weightedpctcontribution'] = 'Svertinis % indėlis';
$string['weightofa'] = '{$a} svertas';
$string['weightorextracredit'] = 'Svarba arba papildomas kreditas';
$string['weightoverride'] = 'sverto reguliavimas';
$string['weightoverride_help'] = 'Panaikinkite šios nuostatos žymėjimą, jei norite iš naujo nustatyti įverčio elemento svorį ir automatiškai apskaičiuoti vertę. Tai pažymėjus, svoris nebus automatiškai reguliuojamas.';
$string['weights'] = 'Svarba';
$string['weightsadjusted'] = 'Įvertinimų svoriai buvo pakoreguoti iki 100.';
$string['weightsedit'] = 'Redaguoti svarbą ir papildomus kreditus';
$string['weightuc'] = 'Apskaičiuotas svoris';
$string['writinggradebookinfo'] = 'Įvertinimų knygelės parametrų įrašymas';
$string['xml'] = 'XML';
$string['yes'] = 'Taip';
$string['yourgrade'] = 'Jūsų įvertinimas';
