<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_moodlebox', language 'de', version '4.2'.
 *
 * @package     tool_moodlebox
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['changepassworderror'] = 'Das Kennwort für den Terminalzugang und die Datenbank wurde nicht geändert, weil die Eingabefelder nicht übereinstimmen.';
$string['changepasswordmessage'] = 'Das Kennwort für den Terminalzugang und die Datenbank wurde geändert.<br /><br />Achtung: Das Kennwort für das Nutzerkonto \'moodlebox\' in Moodle <b>wurde nicht verändert</b>. Öffnen Sie dazu bitte die Einstellungen für dieses Nutzerkonto.';
$string['changewifisettings'] = 'WLAN-Einstellungen ändern';
$string['configuration'] = 'MoodleBox-Einstellungen';
$string['cpufrequency'] = 'CPU-Frequenz';
$string['cpuload'] = 'CPU-Auslastung';
$string['cputemperature'] = 'CPU-Temperatur';
$string['dashboard'] = 'MoodleBox-Dashboard';
$string['datetime'] = 'Datum und Uhrzeit';
$string['datetime_help'] = 'Ohne Verbindung zum Internet hat die MoodleBox möglicherweise eine falsche Systemzeit. Hier können Sie die Systemzeit manuell einstellen.';
$string['datetimemessage'] = 'Die Systemzeit der MoodleBox wurde neu eingestellt. Um die Systemzeit möglichst genau zu halten, sollten Sie die MoodleBox über ein Ethernetkabel mit dem Internet verbinden.';
$string['datetimeset'] = 'Systemzeit einstellen';
$string['datetimesetmessage'] = 'Die Systemzeit der MoodleBox scheint nicht richtig zu sein. Sie sollten unbedingt das aktuelle Datum und die richtige Uhrzeit einstellen.';
$string['datetimesetting'] = 'Systemzeit';
$string['defaultgateway'] = 'Standardgateway';
$string['dhcpclientinfo'] = 'Client IP-Adresse, Name und MAC-Adresse';
$string['dhcpclientnumber'] = 'Anzahl';
$string['dhcpclients'] = 'DHCP-Clients';
$string['documentation'] = 'Dokumentation';
$string['documentation_desc'] = '<p>Bei Fragen lesen Sie bitte die <a href="https://moodlebox.net/de/help/" title="MoodleBox-Dokumentation" target="_blank"> MoodleBox-Dokumentation </a>.</p>';
$string['dynamicipaddress'] = 'IP-Adresse (dynamisch)';
$string['ethernetdisconnected'] = 'Ethernet nicht verbunden';
$string['forum'] = 'Supportforum';
$string['forum_desc'] = '<p>Falls Sie keine Antwort auf Ihre Frage in der <a href="https://moodlebox.net/de/help/" title="MoodleBox-Dokumentation" target="_blank"> MoodleBox-Dokumentation </a> finden, suchen Sie bitte auch im <a href="https://discuss.moodlebox.net/" title="MoodleBox-Supportforum" target="_blank"> MoodleBox-Supportforum</a>. Möglicherweise ist Ihre Frage dort bereits beantwortet. Ansonsten können Sie gerne ein neues Thema beginnen.</p>';
$string['hardwareinfo'] = 'Hardwareinformation';
$string['hidden'] = 'Verborgen';
$string['hiddendhcpname'] = '—verborgen—';
$string['ihavedonated'] = 'Ich habe gespendet!  🎉';
$string['ihavedonated_desc'] = 'Setzen Sie einen Haken in die Box <a href="https://moodlebox.net/de/projekt-moodlebox-unterstuetzen/" title="MoodleBox-Projekt unterstützen" target="_blank"> Ich habe gespendet! </a>, wenn Sie das MoodleBox-Projekt unterstützt haben. <br />Die Einstellung hat keine Wirkung. Sie erlaubt Ihnen, einfach stolz sein, einen Beitrag zum Projekt <a href="https://moodlebox.net/de/" title="MoodleBox" target="_blank"> MoodleBox </a> geleistet zu haben. Vielen Dank!';
$string['infofileerror'] = 'Information nicht verfügbar';
$string['infoheading'] = 'MoodleBox-Supportinformation';
$string['information'] = 'Information';
$string['interfacename'] = 'Schnittstelle';
$string['ipaddress'] = 'IP-Adresse';
$string['kernelversion'] = 'Kernel-Version';
$string['missingconfigurationerror'] = 'Dieser Bereich ist nicht verfügbar. Die Installation des Plugins ist unvollständig, so dass die Einstellungen der MoodleBox nicht verwendet werden können. Lesen Sie bitte die <a href="https://github.com/moodlebox/moodle-tool_moodlebox/blob/master/README.md"" target="_blank">Installationshinweise</a> zum Plugin.';
$string['moodlebox:viewbuttonsinfooter'] = 'Tasten zum Neustart und Ausschalten im Fußbereich anzeigen';
$string['moodleboxsysteminfo'] = 'MoodleBox-Infos';
$string['moodleboxsysteminfo_help'] = 'Diese Übersicht enthält wichtige Infos und Einstellungen der MoodleBox:

* Kritische Betriebsdaten
* Freier Speicher auf der SD-Karte
* Auslastung, Temperatur und Frequenz des Prozessors
* Aktuelle WLAN-Einstellungen der MoodleBox
* Anzahl, IP- und MAC-Adressen aller verbundenen Geräte
* Raspberry Pi Modell und Betriebssystem
* MoodleBox-Version und MoodleBox-Plugin-Version';
$string['networkinterface'] = 'Kabelgebundene Schnittstelle';
$string['parameter'] = 'Parameter';
$string['passwordprotected'] = 'Mit Kennwort geschützt';
$string['passwordsetting'] = 'MoodleBox-Kennwort';
$string['passwordsetting_help'] = 'Das Systemkennwort der MoodleBox kann hier neu gesetzt werden. Es wird dringend davon abgeraten, das Standardkennwort zu behalten. Zur Sicherheit müssen Sie das Kennwort unbedingt ändern.';
$string['pijuicebatterychargelevel'] = 'PiJuice Ladezustand';
$string['pijuicebatterystatus'] = 'PiJuice Batteriestatus';
$string['pijuicebatterytemp'] = 'PiJuice Batterietemperatur';
$string['pijuiceinfo'] = 'PiJuice Statusinfo';
$string['pijuiceisfault'] = 'PiJuice Fehler';
$string['pijuicestatuserror'] = 'PiJuice Status';
$string['pluginname'] = 'MoodleBox';
$string['pluginversion'] = 'MoodleBox-Plugin-Version';
$string['privacy:metadata'] = 'Das Moodlebox-Plugin zeigt Infos zum Raspberry Pi und ermöglicht Änderungen in der Konfiguration. Das Plugin verarbeitet und speichert keine personenbezogenen Daten.';
$string['projectinfo'] = '<p>Das Projekt <a href="https://moodlebox.net/de/" title="MoodleBox" target="_blank"> MoodleBox </a> ist ein nichtkommerzielles Open-Source-Projekt, das von <a href="https://blog.martignoni.net/a-propos/" title="Nicolas Martignoni" target="_blank"> Nicolas Martignoni </a> in seiner Freizeit entwickelt wird. </p> <p>Wir freuen uns, dass Sie die MoodleBox verwenden. Sie können Ihre Anerkennung zeigen und das Projekt unterstützen, indem Sie <a href="https://moodlebox.net/de/projekt-moodlebox-unterstuetzen/" title="MoodleBox unterstützen" target="_blank"> eine Spende </a> machen ❤. Ihre Spende hilft bei der Finanzierung der Ausrüstung, die zur Entwicklung der MoodleBox und zum Bereitstellen der Dokumentation benötigt wird.</p>';
$string['raspberryhardware'] = 'Hardware';
$string['resizepartition'] = 'Partition auf der SD-Karte vergrößern';
$string['resizepartition_help'] = 'Verwenden Sie diese Taste, um die Partition auf der SD-Karte zu vergrößern.';
$string['resizepartitionmessage'] = 'Die Partition der SD-Karte wurde auf den maximalen Speicherplatz vergrößert. Die MoodleBox startet automatisch neu und ist nach kurzer Unterbrechung wieder online.';
$string['resizepartitionsetting'] = 'Partition auf der SD-Karte wird vergrößert';
$string['restart'] = ' MoodleBox neustarten ';
$string['restartmessage'] = 'Die MoodleBox startet neu und ist nach kurzer Unterbrechung wieder online.';
$string['restartstop'] = 'Neustart und Ausschalten';
$string['restartstop_help'] = 'Verwenden Sie diese Tasten zum Neustart oder Ausschalten der MoodleBox. Es wird dringend empfohlen, die MoodleBox per Software auszuschalten und erst danach die Stromversorgung zu trennen.';
$string['revision'] = 'Modellrevision';
$string['revisioncode'] = 'Code der Modellrevision';
$string['rpi1'] = 'Raspberry Pi 1';
$string['rpi2'] = 'Raspberry Pi 2B';
$string['rpi3aplus'] = 'Raspberry Pi 3A+';
$string['rpi3b'] = 'Raspberry Pi 3B';
$string['rpi3bplus'] = 'Raspberry Pi 3B+';
$string['rpi400'] = 'Raspberry Pi 400';
$string['rpi4eightgb'] = 'Raspberry Pi 4B (8GB RAM)';
$string['rpi4fourgb'] = 'Raspberry Pi 4B (4GB RAM)';
$string['rpi4onegb'] = 'Raspberry Pi 4B (1GB RAM)';
$string['rpi4twogb'] = 'Raspberry Pi 4B (2GB RAM)';
$string['rpi5eightgb'] = 'Raspberry Pi 5 (8GB RAM)';
$string['rpi5fourgb'] = 'Raspberry Pi 5 (4GB RAM)';
$string['rpiosversion'] = 'Raspberry Pi OS';
$string['rpizero2w'] = 'Raspberry Pi Zero 2 W';
$string['rpizerow'] = 'Raspberry Pi Zero W';
$string['sdcardavailablespace'] = 'Freier Speicher';
$string['showbuttonsinfooter'] = 'Tasten im Fußbereich anzeigen';
$string['showbuttonsinfooter_desc'] = 'Wenn diese Option aktiviert ist, werden die Tasten zum Neustart und Ausschalten auf jeder Seite im Fußbereich angezeigt, wenn jemand als Administrator/in oder Manager/in angemeldet ist.';
$string['showdatetimebuttonsinfooter'] = 'Einstellung für Datum und Uhrzeit im Fußbereich anzeigen';
$string['showdatetimebuttonsinfooter_desc'] = 'Wenn diese Option aktiviert ist, wird die Einstellung für Datum und Uhrzeit auf jeder Seite im Fußbereich angezeigt, falls jemand als Administrator/in oder Manager/in angemeldet ist.';
$string['showrestartshutdownbuttonsinfooter'] = 'Tasten zum Neustart und Ausschalten im Fußbereich anzeigen';
$string['showrestartshutdownbuttonsinfooter_desc'] = 'Wenn diese Option aktiviert ist, werden die Tasten zum Neustart und Ausschalten auf jeder Seite im Fußbereich angezeigt, falls jemand als Administrator/in oder Manager/in angemeldet ist.';
$string['shutdown'] = 'MoodleBox ausschalten';
$string['shutdownmessage'] = 'Die MoodleBox wird ausgeschaltet. Warten Sie bitte einige Sekunden, bevor Sie die Stromversorgung trennen.';
$string['softwareversions'] = 'Softwareversionen';
$string['staticipaddress'] = 'IP-Adresse (statisch)';
$string['staticipaddress_help'] = 'Dies ist die statische IP-Adresse für den MoodleBox-WLAN-AccessPoint. Diese IP-Adresse legt auch den DHCP-Bereich fest, der an die WLAN-Clients vergeben wird. Erlaubt sind nur gültige <strong>private</strong> IP-Adressen, wie z.B. 10.10.1.1, 172.23.222.1 oder 192.168.222.1. Das letzte Segment wird automatisch auf 1 gesetzt. Die Teilnetzmaske ist 255.255.255.0.';
$string['staticipaddressinvalid'] = 'Diese IP-Adresse ist ungültig. Erlaubt sind nur gültige <strong>private</strong> IP-Adressen, wie z.B. 10.10.1.1, 172.23.222.1 oder 192.168.222.1.';
$string['systeminfo'] = 'Systeminformation';
$string['undervoltagedetected'] = '<p><b>Achtung: Die Spannung ist zu niedrig!</b> Die Stromversorgung der MoodleBox ist unzureichend. Dies könnte verschiedene Probleme verursachen, z.B. die Anzahl der WLAN-Clients begrenzen oder die MoodleBox unerwartet herunterfahren.</p>
<p><b>Prüfen Sie Ihr Netzteil.</b> Verwenden Sie möglichst das <a href="https://www.raspberrypi.com/products/micro-usb-power-supply/" target="_blank"> Raspberry Pi 12,5 W Micro-USB-Netzteil </a> für Raspberry Pi 3A+, 3B, 3B+ und Zero 2 W, das <a href="https: //www.raspberrypi.com/products/type-c-power-supply/" target="_blank"> Raspberry Pi 15 W USB-C-Netzteil </a> für Raspberry Pi 4B. oder das <a href="https://www.raspberrypi.com/products/27w-power-supply/" target="_blank">Raspberry Pi 27W USB-C-Netzteil</a> für Raspberry Pi 5.</p>';
$string['undervoltageoccurred'] = '<p>Seit dem letzten Start der MoodleBox wurde mindestens einmal eine zu niedrige Spannung registriert. Möglicherweise ist die Stromversorgung der MoodleBox unzureichend. Dies könnte verschiedene Probleme verursachen, z.B. die Anzahl der WLAN-Clients begrenzen oder die MoodleBox unerwartet herunterfahren.</p>
<p><b>Prüfen Sie Ihr Netzteil.</b> Verwenden Sie möglichst das <a href="https://www.raspberrypi.com/products/micro-usb-power-supply/" target="_blank"> Raspberry Pi 12,5 W Micro-USB-Netzteil </a> für Raspberry Pi 3A+, 3B, 3B+ und Zero 2 W, das <a href="https: //www.raspberrypi.com/products/type-c-power-supply/" target="_blank"> Raspberry Pi 15 W USB-C-Netzteil </a> für Raspberry Pi 4B. oder das <a href="https://www.raspberrypi.com/products/27w-power-supply/" target="_blank">Raspberry Pi 27W USB-C-Netzteil</a> für Raspberry Pi 5.</p>';
$string['unknowndhcpname'] = '—unbekannt—';
$string['unknownmodel'] = 'Unbekannter oder nicht unterstützter Raspberry Pi';
$string['unsupportedhardware'] = 'Die Hardware wird scheinbar nicht unterstützt! Dieses Plugin arbeitet nur mit einem Raspberry Pi.';
$string['uptime'] = 'Betriebsdauer';
$string['version'] = 'MoodleBox-Version';
$string['visible'] = 'Sichtbar';
$string['wifichannel'] = 'WLAN-Kanal';
$string['wifichannel_help'] = 'Normalerweise kann der WLAN-Kanal unverändert bleiben, außer wenn sich mehrere WLAN-Sender überlagern und gegenseitig stören.';
$string['wificountry'] = 'WLAN-Regulierungsland';
$string['wificountry_help'] = 'Aus rechtlichen Gründen sollten Sie hier Ihren tatsächlichen Standort als WLAN-Regulierungsland eintragen.';
$string['wifipassword'] = 'WLAN-Kennwort';
$string['wifipassword_help'] = 'Wenn Sie das WLAN der MoodleBox schützen möchten, sollten Sie das standardmäßige Kennwort ändern. Das Kennwort muss zwischen 8 und 63 druckbare ASCII-Zeichen haben. Das Kennwort darf Groß- und Kleinbuchstaben, Ziffern, Satzzeichen und auch Symbole enthalten.';
$string['wifipasswordinvalid'] = 'Das WLAN-Kennwort ist ungültig. Das Kennwort muss zwischen 8 und 63 druckbare ASCII-Zeichen haben. Das Kennwort darf Groß- und Kleinbuchstaben, Ziffern, Satzzeichen und auch Symbole enthalten.';
$string['wifipasswordon'] = 'WLAN-Schutz';
$string['wifipasswordon_help'] = 'Wenn diese Option aktiviert ist, muss ein WLAN-Kennwort eingegeben werden.';
$string['wifisettings'] = 'WLAN-Einstellungen';
$string['wifisettingserror'] = 'Die WLAN-Einstellungen wurden nicht geändert, weil mindestens eine Einstellung ungültig ist.';
$string['wifisettingsmessage'] = 'Die WLAN-Einstellungen wurden geändert. Denken Sie daran, allen beteiligten Personen die neuen Zugangsdaten mitzuteilen.';
$string['wifissid'] = 'WLAN-Name (SSID)';
$string['wifissid_help'] = 'Der WLAN-Name (SSID) für die MoodleBox kann zwischen 1 und 32 Bytes lang sein. Beachten Sie bitte, dass manche Zeichen (z.B. Emoticons) mehr als nur 1 Byte verwenden.';
$string['wifissidhidden'] = 'Verborgenes WLAN';
$string['wifissidhiddenstate'] = 'WLAN-Sichtbarkeit';
$string['wifissidhiddenstate_help'] = 'Wenn diese Option aktiviert ist, wird der WLAN-Name (SSID) verborgen. Niemand kann dann sehen, ob eine MoodleBox vorhanden ist. Dies erhöht einerseits die Sicherheit der MoodleBox, reduziert aber andererseits deren Usability.';
$string['wifissidinvalid'] = 'Der angegebene WLAN-Name (SSID) ist ungültig. Der Name kann zwischen 1 und 32 Bytes lang sein.';
