<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'booking', language 'de', version '4.2'.
 *
 * @package     booking
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activitycompletionsuccess'] = 'Alle ausgewählten Nutzer/innen wurden für den Aktivitätsabschluss markiert.';
$string['addcategory'] = 'Kategorien bearbeiten';
$string['addmorebookings'] = 'Buchungen hinzufügen';
$string['addnewcategory'] = 'Neue Kategorie hinzufügen';
$string['addnewinstitution'] = 'Neue Institution hinzufügen';
$string['addnewtagtemplate'] = 'Neue Schlagwort-Vorlage hinzufügen';
$string['address'] = 'Adresse';
$string['addtocalendar'] = 'Zum Kalender hinzufügen';
$string['addtogroup'] = 'Nutzer/innen automatisch in Gruppe einschreiben';
$string['addtogroup_help'] = 'Nutzer/innen automatisch in Gruppe eintragen. Die Gruppe wird nach folgendem Schema automatisch erstellt: "Aktivitätsname - Name der Buchungsoption"';
$string['advancedoptions'] = 'Erweiterte Einstellungen';
$string['agreetobookingpolicy'] = 'Ich habe folgende Buchungsbedingungen gelesen und erkläre mich damit einverstanden';
$string['allbookingoptions'] = 'Nutzer/innen für alle Buchungsmöglichkeiten herunterladen';
$string['allmailssend'] = 'Alle Benachrichtigungen wurden erfolgreich versandt!';
$string['allowdelete'] = 'Teilnehmer/innen dürfen Buchungen selbst stornieren';
$string['allowupdate'] = 'Buchungen dürfen aktualisiert werden';
$string['allusersbooked'] = 'Alle {$a} ausgewählten Teilnehmer/innen wurden dieser Buchungsmöglichkeit zugewiesen.';
$string['answer'] = 'Antwort';
$string['answered'] = 'Beantwortet';
$string['associatedcourse'] = 'Dazu gehörender Kurs';
$string['attachedfiles'] = 'Dateianhänge';
$string['attachical'] = 'iCal Kalendereintrag hinzufügen';
$string['attachicaldesc'] = 'Wenn diese Option aktiviert ist, wird eine E-Mail Benachrichtigungen im iCal Format  hinzugefügt.';
$string['attachicalsess'] = 'Alle Sitzungsdaten als iCal Kalendereinträge hinzufügen';
$string['attachicalsessdesc'] = 'E-Mail Benachrichtigungen enthalten alle Sitzungsdaten für eine Buchungsmöglichkeit als iCal Anhang.';
$string['autoenrol'] = 'Nutzer/innen automatisch einschreiben';
$string['autoenrol_help'] = 'Falls ausgewählt werden Nutzter/innen automatisch in den Kurs eingeschrieben sobald sie die Buchung durchgeführt haben und wieder ausgetragen, wenn die Buchung storniert wird.';
$string['availability'] = 'Noch verfügbar';
$string['available'] = 'Verfügbare Plätze';
$string['backtoresponses'] = '<< Zurück zu den Antworten';
$string['banusernames'] = 'Gesperrte Benutzernamen';
$string['banusernames_help'] = 'Um Nutzerkonten mit bestimmten E-Mail-Domains auszuschließen, kann in diesem Feld eine kommagetrennte Liste eingefügt werden. Um z.B. Gmail- und Yahoo-Nutzerkonten auszuschließen, schreiben Sie: gmail.com, yahoo.com';
$string['banusernameswarning'] = 'Sie können nicht buchen, da Ihr Nutzerkonto gesperrt ist.';
$string['booked'] = 'Gebucht';
$string['bookedpast'] = 'Gebucht (Kurs wurde bereits beendet)';
$string['bookedtext'] = 'Buchungsbestätigung';
$string['bookedtext_help'] = 'Lassen Sie dieses Feld leer, um den Standardtext der Website zu verwenden. Folgende Platzhalter können im Text verwendet werden:
<ul>
<li>{status}</li>
<li>{participant}</li>
<li>{title}</li>
<li>{duration}</li>
<li>{starttime}</li>
<li>{endtime}</li>
<li>{startdate}</li>
<li>{enddate}</li>
<li>{courselink}</li>
<li>{bookinglink}</li>
<li>{location}</li>
<li>{institution}</li>
<li>{address}</li>
<li>{eventtype}</li>
<li>{teacher}</li>
<li>{teacherN} - N ist die Trainernummer. Z.B. {teacher1}</li>
<li>{pollstartdate}</li>
<li>{qr_id} - QR Code der Userid einfügen</li>
<li>{qr_username} - QR Code des Usernamens einfügen</li>
<li>{times} - Zeiten</li>
</ul>';
$string['bookedusers'] = 'Gebuchte Nutzer/innen';
$string['booking'] = 'Buchung';
$string['booking:addinstance'] = 'Neue Buchung anlegen';
$string['booking:choose'] = 'Buchen';
$string['booking:communicate'] = 'darf kommunizieren';
$string['booking:deleteresponses'] = 'Anworten löschen';
$string['booking:downloadresponses'] = 'Antworten herunterladen';
$string['booking:rate'] = 'Bewertung der Buchungsoptionen';
$string['booking:readallinstitutionusers'] = 'Alle Nutzer/innen zeigen';
$string['booking:readresponses'] = 'Antworten lesen';
$string['booking:sendpollurl'] = 'Link zur Umfrage verschicken';
$string['booking:sendpollurltoteachers'] = 'Link zur Trainer/innen-Umfrage verschicken';
$string['booking:subscribeusers'] = 'Buchungen für andere Teilnehmer/innen durchführen';
$string['booking:updatebooking'] = 'Buchungsoptionen verwalten';
$string['booking:viewallratings'] = 'Alle Bewertungen einsehen';
$string['booking:viewanyrating'] = 'Die Gesamtbewertung einer Person einsehen';
$string['booking:viewrating'] = 'Die eigene Gesamtbewertung einsehen';
$string['bookingattachment'] = 'Anhang';
$string['bookingcategory'] = 'Kategorie';
$string['bookingdeleted'] = 'Ihre Buchung wurde gelöscht';
$string['bookingduration'] = 'Dauer';
$string['bookingfull'] = 'Es gibt keine verfügbaren Orte';
$string['bookingfulldidntregister'] = 'Voll belegt, so dass ich nicht alle Nutzer/innen transferiert habe!';
$string['bookingmanagererror'] = 'Der eingegebene Nutzername ist nicht zulässig. Entweder existiert der Nutzername nicht oder es gibt mehrere Nutzer/innen mit diesem Nutzername (dies kann passieren, wenn z.B. gleichzeitig MNet und lokale Authentifizierung eingeschaltet sind).';
$string['bookingmeanwhilefull'] = 'Leider hat inzwischen jemand anderer den letzten Platz gebucht';
$string['bookingname'] = 'Buchungsbezeichnung';
$string['bookingopen'] = 'Offen';
$string['bookingoptionsmenu'] = 'Buchungsoptionen';
$string['bookingorganizatorname'] = 'Name des Veranstalters';
$string['bookingpoints'] = 'Punkte des Kurses';
$string['bookingpolicy'] = 'Buchungsbedingungen';
$string['bookingpollurl'] = 'Link zur Umfrage';
$string['bookingpollurlteachers'] = 'Link zur Trainer/innen-Umfrage';
$string['bookingsaved'] = 'Ihre Buchung wurde erfolgreich gespeichert. Sie können nun weitere Buchungen vornehmen bzw. Ihre bestehenden Buchungen verwalten.';
$string['bookingtags'] = 'Schlagwörter';
$string['bookingtext'] = 'Beschreibung der Buchung';
$string['booknow'] = 'Jetzt buchen';
$string['bookotherusers'] = 'Buchung für andere Nutzer/innen durchführen';
$string['booktootherbooking'] = 'Nutzer/innen zu anderer Buchungen hinzufügen';
$string['btnbooknowname'] = 'Bezeichnung des Buttons "Jetzt buchen"';
$string['btncacname'] = 'Bezeichnung des Buttons "Aktivitätsabschluss bestätigen"';
$string['btncancelname'] = 'Bezeichnung des Buttons "Buchung stornieren"';
$string['cancancelbook'] = 'Nutzer/innen das Stornieren und das Buchen nach dem Beginn der Veranstaltung erlauben?';
$string['cancel'] = 'Stornieren';
$string['cancelbooking'] = 'Buchung stornieren';
$string['categories'] = 'Kategorien';
$string['category'] = 'Kategorie';
$string['categoryname'] = 'Name der Kategorie';
$string['cfgsignin'] = 'Konfiguration Anmeldeformular';
$string['cfgsignin_desc'] = 'Einstellungen des Anmeldeformulars konfigurieren';
$string['choosecourse'] = 'Einen Kurs auswählen';
$string['closed'] = 'Buchung geschlossen';
$string['completed'] = 'Abgeschlossen';
$string['conectedbooking'] = 'Vorgeschaltete Buchung';
$string['conectedbooking_help'] = 'Buchung von der Teilnehmer/innen übernommen werden. Es kann bestimmt werden wie viele Teilnehmer/innen übernommen werden.';
$string['confirmationmessagesettings'] = 'E-Mail-Einstellungen bestätigen';
$string['confirmbookingoffollowing'] = 'Bitte bestätigen Sie folgende Buchung';
$string['confirmdeletebookingoption'] = 'Möchten Sie diese Buchungsmöglichkeit wirklich löschen?';
$string['copyonlythisbookingurl'] = 'Link zur Buchung kopieren';
$string['copypollurl'] = 'Link zur Umfrage kopieren';
$string['copytoclipboard'] = 'In die Zwischenablage kopieren: Strg+C, Enter';
$string['coursedate'] = 'Termin';
$string['courseendtime'] = 'Ende';
$string['coursestarttime'] = 'Beginn';
$string['csvfile'] = 'CSV-Datei';
$string['csvfile_help'] = 'CSV-Datei darf nur eine Spalte mit der Bezeichnung Institution beinhalten.';
$string['customfieldtype'] = 'Feldtyp';
$string['customlabels'] = 'Benutzerdefinierte Bezeichnungen';
$string['dateerror'] = 'Falsche Datumsangabe in Zeile {$a}:';
$string['datenotset'] = 'Datum nicht angegeben';
$string['dateparseformat'] = 'Datumsformat';
$string['dateparseformat_help'] = 'Bitte Datum so wie es im CSV definiert wurde verwenden. Hilfe unter <a href="http://php.net/manual/en/function.date.php">Datumsdokumentation</a> für diese Einstellung.';
$string['days'] = '{$a} Tage';
$string['daystonotify'] = 'Wie viele Tage vor Kursbeginn soll an die Teilnehmenden eine Benachrichtigung gesendet werden?';
$string['daystonotify2'] = 'Zweite Teilnehmerbenachrichtigung vor Veranstaltungsbeginn';
$string['daystonotify_help'] = 'Funktioniert nur, wenn Anfangs- und Endzeit angegeben sind! Um die Funktion auszuschalten 0 eintragen.';
$string['defaultbookingoption'] = 'Standardeinstellungen für Buchungen';
$string['defaultdateformat'] = 'j.n.Y H:i:s';
$string['deletebooking'] = 'Wollen Sie wirklich folgende Buchung stornieren? <br /><br /> <b>{$a}</b>';
$string['deletecategory'] = 'Löschen';
$string['deletedbookingusermessage'] = 'Guten Tag {$a->participant},

die Buchung für {$a->title} wurde erfolgreich storniert';
$string['deletedbookingusersubject'] = 'Buchung {$a->title} wurde storniert';
$string['deletedrule'] = 'Buchungsmöglichkeit erfolgreich gelöscht';
$string['deletedtext'] = 'Stornierungsbenachrichtigung';
$string['deletedtext_help'] = 'Lassen Sie dieses Feld leer, um den Standardtext der Website zu verwenden. Folgende Platzhalter können im Text verwendet werden:
<ul>
<li>{status}</li>
<li>{participant}</li>
<li>{title}</li>
<li>{duration}</li>
<li>{starttime}</li>
<li>{endtime}</li>
<li>{startdate}</li>
<li>{enddate}</li>
<li>{courselink}</li>
<li>{bookinglink}</li>
<li>{pollurl}</li>
<li>{pollurlteachers}</li>
<li>{location}</li>
<li>{institution}</li>
<li>{address}</li>
<li>{eventtype}</li>
<li>{teacher}</li>
<li>{teacherN} - N ist die Trainernummer, z.B. {teacher1}</li>
<li>{pollstartdate}</li>
<li>{qr_id} - QR Code der Userid einfügen</li>
<li>{qr_username} - QR Code des Usernamen einfügen</li>
<li>{times} - Zeiten</li>
</ul>';
$string['deleterule'] = 'Löschen';
$string['deletesubcategory'] = 'Löschen Sie zuerst alle Unterkategorien dieser Kategorie!';
$string['deleteuserfrombooking'] = 'Buchung für Nutzer/innen wirklich stornieren?';
$string['delnotification'] = 'Sie haben {$a->del} von {$a->all} Nutzer/innen gelöscht. Nutzer/innen, welche die Aktivität abgeschlossen haben, können nicht gelöscht werden!';
$string['disablebookingusers'] = 'Buchung von Teilnehmer/innen deaktivieren - "Jetzt buchen" Button unsichtbar schalten.';
$string['donotselectcourse'] = 'Kein Kurs ausgewählt';
$string['download'] = 'Herunterladen';
$string['downloadallresponses'] = 'Alle Antworten herunterladen';
$string['downloadusersforthisoptionods'] = 'Nutzer/innen im .ods-Format herunterladen';
$string['downloadusersforthisoptionxls'] = 'Nutzer/innen im .xls-Format herunterladen';
$string['duplicatebooking'] = 'Diese Buchungsmöglichkeit duplizieren';
$string['editcategory'] = 'Bearbeiten';
$string['editinstitutions'] = 'Institutionen bearbeiten';
$string['editotherbooking'] = 'Andere Buchungsmöglichkeiten';
$string['editrule'] = 'Bearbeiten';
$string['edittag'] = 'Bearbeiten';
$string['editteachers'] = 'Bearbeiten';
$string['enablecompletion'] = 'Manuellen Abschluss der Aktivität einschalten.';
$string['enablecompletiongroup'] = 'Aktivitätsabschluss';
$string['endtimenotset'] = 'Ende nicht angegeben';
$string['entervalidurl'] = 'Bitte geben Sie eine gültige URL an!';
$string['error:failedtosendconfirmation'] = 'Folgender User hat kein Bestätigungsmail erhalten

Status der Buchung: {$a->status}
Nutzer/in: {$a->participant}
Titel: {$a->title}
Termin: {$a->startdate} {$a->starttime} - {$a->enddate} {$a->endtime}
Link: {$a->bookinglink}
Kurs: {$a->courselink}';
$string['errorpagination'] = 'Bitte geben sie eine Zahl größer 0 ein';
$string['eventduration'] = 'Dauer';
$string['eventpoints'] = 'Punkte';
$string['eventreport_viewed'] = 'Übersicht über Buchungen für eine Buchungsmöglichkeit angesehen';
$string['eventtype'] = 'Art des Ereignisses';
$string['eventuserprofilefields_updated'] = 'Nutzerprofil aktualisiert';
$string['excelfile'] = 'CSV Datei mit Aktivitätsabschluss';
$string['existingsubscribers'] = 'Vorhandene Nutzer/innen';
$string['expired'] = 'Diese Aktivität wurde leider am {$a} beendet und steht nicht mehr zur Verfügung';
$string['fillinatleastoneoption'] = 'Geben Sie mindestens 2 mögliche Antworten an.';
$string['forcourse'] = 'für Kurs';
$string['full'] = 'Ausgebucht';
$string['fullname'] = 'Voller Name';
$string['generaterecnum'] = 'Eintragsnummern erstellen';
$string['generaterecnumareyousure'] = 'Neue Nummern erstellen und die alten verwerfen!';
$string['generaterecnumnotification'] = 'Neue Nummern erfolgreich erstellt.';
$string['goenrol'] = 'Gehe zu "Buchung vornehmen"';
$string['gotobooking'] = '<< Zu den Buchungen';
$string['gotop'] = 'Nach oben';
$string['groupexists'] = 'Die Gruppe existiert bereits im Zielkurs. Bitte wählen Sie für die Buchungsmöglichkeit einen anderen Namen.';
$string['groupname'] = 'Gruppenname';
$string['hours'] = '{$a} Stunden';
$string['importcsvbookingoption'] = 'Buchungsoptionen via CSV-Datei importieren';
$string['importcsvtitle'] = 'CSV-Datei importieren';
$string['importexcelbutton'] = 'Aktivitätsabschluss importieren';
$string['importexceltitle'] = 'Aktivitätsabschluss importieren';
$string['importfinished'] = 'Importieren beendet!';
$string['infonobookingoption'] = 'Bitte nutzen Sie den Block {$a}, um die erste Buchungsoption zu erstellen';
$string['institution'] = 'Institution';
$string['institutionname'] = 'Name der Institution';
$string['institutions'] = 'Institutionen';
$string['lblacceptingfrom'] = 'Bezeichnung für "Annehmen von"';
$string['lblbooking'] = 'Bezeichnung für "Buchung"';
$string['lblbooktootherbooking'] = 'Bezeichnung für den Button "Zu anderer Buchungsoption hinzufügen"';
$string['lblinstitution'] = 'Bezeichnung für "Institution"';
$string['lbllocation'] = 'Bezeichnung für "Ort"';
$string['lblname'] = 'Bezeichnung für "Name"';
$string['lblnumofusers'] = 'Bezeichnung für "Anzahl an Benutzer/innen"';
$string['lblsputtname'] = 'Bezeichnung für "Umfragelink an Trainer/innen senden"';
$string['lblsurname'] = 'Bezeichnung für "Nachname"';
$string['lblteachname'] = 'Bezeichnung für "Trainer/in"';
$string['leftandrightdate'] = '{$a->leftdate} bis {$a->righttdate}';
$string['limit'] = 'Maximale Anzahl';
$string['limitanswers'] = 'Teilnehmeranzahl beschränken';
$string['limitanswers_help'] = 'Bei Änderung dieser Einstellung und bereits vorhandenen Buchungen, werden eventuell die Buchungen für die betroffenen Nutzer/innen ohne Benachrichtigung entfernt.';
$string['location'] = 'Ort';
$string['mailconfirmationsent'] = 'Sie erhalten in Kürze ein Bestätigungsmail an die in Ihrem Profil angegebene E-Mail Adresse';
$string['managebooking'] = 'Verwalten';
$string['maxoverbooking'] = 'Maximale Anzahl der Wartelistenplätze';
$string['maxparticipantsnumber'] = 'Maximale Teilnehmeranzahl';
$string['maxperuser'] = 'Maximale Anzahl an Buchungen pro Benutzer';
$string['maxperuser_help'] = 'Die maximale Anzahl an Buchungen, die ein Benutzer auf einmal buchen kann. Nach dem Ende des gebuchten Kurses, zählt dieser nicht mehr zum Buchungslimit.';
$string['maxperuserwarning'] = 'Sie haben zur Zeit ein Limit von {$a->count}/{$a->limit} Buchungen';
$string['messagesend'] = 'Die Nachricht wurde erfolgreich versandt.';
$string['messagesubject'] = 'Betreff';
$string['messagetext'] = 'Nachricht';
$string['minutes'] = '{$a} Minuten';
$string['modulename'] = 'Buchung';
$string['modulenameplural'] = 'Buchungen';
$string['mustchooseone'] = 'Sie müssen eine Buchungsmöglichkeit auswählen.';
$string['mustfilloutuserinfobeforebooking'] = 'Bevor Sie buchen, füllen Sie bitte noch Ihre persönlichen Buchungsdaten aus';
$string['myoptions'] = 'Meine Veranstaltungen ({$a})';
$string['no'] = 'Nein';
$string['nobookingselected'] = 'Keine Buchungsmöglichkeit ausgewählt';
$string['nocourse'] = 'Kein Kurs für diese Buchungsmöglichkeit ausgewählt';
$string['nodateset'] = 'Datum nicht angegeben';
$string['noguestchoose'] = 'Gäste dürfen leider keine Buchungen vornehmen';
$string['noresultsviewable'] = 'Die Ergebnisse sind momentan nicht einsehbar';
$string['norighttobook'] = 'Sie können auf Grund Ihrer Rolle keine Buchung durchführen.';
$string['nosubscribers'] = 'Keine Trainer/innen zugewiesen!';
$string['notbooked'] = 'Noch nicht gebucht';
$string['notconectedbooking'] = 'Keine vorgeschaltete Buchung';
$string['noteacherfound'] = 'Kein/e Trainer/in in Zeile {$a} gefunden.';
$string['notificationtext'] = 'Benachrichtungstext bei Aktivitätsabschluss';
$string['notificationtext_help'] = 'Lassen Sie dieses Feld leer, um den Standardtext der Website zu verwenden. Folgende Platzhalter können im Text verwendet werden:
<ul>
<li>{status}</li>
<li>{participant}</li>
<li>{title}</li>
<li>{duration}</li>
<li>{starttime}</li>
<li>{endtime}</li>
<li>{startdate}</li>
<li>{enddate}</li>
<li>{courselink}</li>
<li>{bookinglink}</li>
<li>{pollurl}</li>
<li>{pollurlteachers}</li>
<li>{location}</li>
<li>{institution}</li>
<li>{address}</li>
<li>{eventtype}</li>
<li>{teacher}</li>
<li>{teacherN} - N ist die Trainernummer, z.B. {teacher1}</li>
<li>{pollstartdate}</li>
<li>{qr_id} - QR Code der Userid einfügen</li>
<li>{qr_username} - QR Code des Usernamen einfügen</li>
<li>{times} - Zeiten</li>
</ul>';
$string['notifyemail'] = 'Benachrichtigung vor dem Beginn';
$string['notifyemail_help'] = 'Lassen Sie dieses Feld leer, um den Standardtext der Website zu verwenden. Folgende Platzhalter können im Text verwendet werden:
<ul>
<li>{status}</li>
<li>{participant}</li>
<li>{title}</li>
<li>{duration}</li>
<li>{starttime}</li>
<li>{endtime}</li>
<li>{startdate}</li>
<li>{enddate}</li>
<li>{courselink}</li>
<li>{bookinglink}</li>
<li>{pollurl}</li>
<li>{pollurlteachers}</li>
<li>{location}</li>
<li>{institution}</li>
<li>{address}</li>
<li>{eventtype}</li>
<li>{teacher}</li>
<li>{teacherN} - N ist die Trainernummer, z.B. {teacher1}</li>
<li>{pollstartdate}</li>
<li>{qr_id} - QR Code der Userid einfügen</li>
<li>{qr_username} - QR Code des Usernamen einfügen</li>
<li>{times} - Zeiten</li>
</ul>';
$string['notopenyet'] = 'Diese Aktivität ist vor {$a} nicht verfügbar';
$string['nouserfound'] = 'Kein/e Nutzer/in gefunden:';
$string['nousers'] = 'Keine Nutzer/innen!';
$string['numgenerator'] = 'Automatische Nummerierung aktivieren?';
$string['numrec'] = 'Nummerierung';
$string['onlythisbookingurl'] = 'Nur dieser Buchungslink';
$string['onwaitinglist'] = 'Sie sind auf der Warteliste';
$string['optiondatestime'] = 'Zeiten';
$string['optionid'] = 'ID der Veranstaltung';
$string['optionmenu'] = 'Diese Veranstaltung';
$string['organizatorname'] = 'Name des Veranstalters';
$string['otherbookingaddrule'] = 'Neue Buchungsmöglichkeit hinzufügen';
$string['otherbookinglimit'] = 'Grenze';
$string['otherbookinglimit_help'] = 'Anzahl der Nutzer/innen, die diese Buchungsmöglichkeit buchen können. 0 bedeutet beliebig viele Nuter/innen sind zulässig.';
$string['otherbookingnumber'] = 'Anzahl an Nutzer/innen';
$string['otherbookingoptions'] = 'Nutzer/innen dieser Buchungsmölgichkeit zulassen';
$string['paginationnum'] = 'Anzahl der Einträge pro Seite';
$string['pluginadministration'] = 'Buchungs-Verwaltung';
$string['pluginname'] = 'Buchung';
$string['pollstrftimedate'] = '%Y-%m-%d';
$string['pollurl'] = 'Link zur Umfrage';
$string['pollurl_help'] = 'Folgende Platzhalter können im Text verwendet werden:
<ul>
<li>{status}</li>
<li>{participant}</li>
<li>{title}</li>
<li>{duration}</li>
<li>{starttime}</li>
<li>{endtime}</li>
<li>{startdate}</li>
<li>{enddate}</li>
<li>{courselink}</li>
<li>{bookinglink}</li>
<li>{location}</li>
<li>{institution}</li>
<li>{address}</li>
<li>{eventtype}</li>
<li>{teacher}</li>
<li>{teacherN} - N ist die Trainernummer, z.B. {teacher1}</li>
<li>{pollstartdate}</li>
<li>{qr_id} - QR Code der Userid einfügen</li>
<li>{qr_username} - QR Code des Usernamen einfügen</li>
<li>{times} - Zeiten</li>
</ul>';
$string['pollurlteachers'] = 'Link zur Umfrage für Trainer/innen';
$string['pollurlteachers_help'] = 'Folgende Platzhalter können im Text verwendet werden:
<ul>
<li>{status}</li>
<li>{participant}</li>
<li>{title}</li>
<li>{duration}</li>
<li>{starttime}</li>
<li>{endtime}</li>
<li>{startdate}</li>
<li>{enddate}</li>
<li>{courselink}</li>
<li>{bookinglink}</li>
<li>{location}</li>
<li>{institution}</li>
<li>{address}</li>
<li>{eventtype}</li>
<li>{teacher}</li>
<li>{teacherN} - N ist die Trainernummer, z.B. {teacher1}</li>
<li>{pollstartdate}</li>
<li>{qr_id} - QR Code der Userid einfügen</li>
<li>{qr_username} - QR Code des Usernamen einfügen</li>
<li>{times} - Zeiten</li>
</ul>';
$string['pollurlteacherstext'] = 'Link zum Absender der Umfrage für Trainer/innen';
$string['pollurlteacherstext_help'] = 'Lassen Sie dieses Feld leer, um den Standardtext der Website zu verwenden. Folgende Platzhalter können im Text verwendet werden:
<ul>
<li>{status}</li>
<li>{participant}</li>
<li>{title}</li>
<li>{duration}</li>
<li>{starttime}</li>
<li>{endtime}</li>
<li>{startdate}</li>
<li>{enddate}</li>
<li>{courselink}</li>
<li>{bookinglink}</li>
<li>{pollurl}</li>
<li>{pollurlteachers}</li>
<li>{location}</li>
<li>{institution}</li>
<li>{address}</li>
<li>{eventtype}</li>
<li>{teacher}</li>
<li>{teacherN} - N ist die Trainernummer, z.B. {teacher1}</li>
<li>{pollstartdate}</li>
<li>{qr_id} - QR Code der Userid einfügen</li>
<li>{qr_username} - QR Code des Usernamen einfügen</li>
<li>{times} - Zeiten</li>
</ul>';
$string['pollurlteacherstextmessage'] = 'Bitte nehmen Sie an der Umfrage teil:

Link zur Umfrage: {pollurlteachers}';
$string['pollurlteacherstextsubject'] = 'Bitte nehmen Sie an der Umfrage teil';
$string['pollurltext'] = 'Umfragelink versenden';
$string['pollurltext_help'] = 'Lassen Sie dieses Feld leer, um den Standardtext der Website zu verwenden. Folgende Platzhalter können im Text verwendet werden:
<ul>
<li>{status}</li>
<li>{participant}</li>
<li>{title}</li>
<li>{duration}</li>
<li>{starttime}</li>
<li>{endtime}</li>
<li>{startdate}</li>
<li>{enddate}</li>
<li>{courselink}</li>
<li>{bookinglink}</li>
<li>{pollurl}</li>
<li>{pollurlteachers}</li>
<li>{location}</li>
<li>{institution}</li>
<li>{address}</li>
<li>{eventtype}</li>
<li>{teacher}</li>
<li>{teacherN} - N ist die Trainernummer, z.B. {teacher1}</li>
<li>{pollstartdate}</li>
<li>{qr_id} - QR Code der Userid einfügen</li>
<li>{qr_username} - QR Code des Usernamen einfügen</li>
<li>{times} - Zeiten</li>
</ul>';
$string['pollurltextmessage'] = 'Bitte nehmen Sie an der Umfrage teil:

Link zur Umfrage: {pollurl}';
$string['pollurltextsubject'] = 'Bitte nehmen Sie an der Umfrage teil';
$string['potentialsubscribers'] = 'Mögliche Nutzer/innen';
$string['question'] = 'Fragen';
$string['removeafterminutes'] = 'Aktivitätsabschluss nach N Minuten löschen';
$string['removeresponses'] = 'Alle Antworten löschen';
$string['reset'] = 'Zurücksetzen';
$string['responses'] = 'Antworten';
$string['responsesto'] = 'Antworten zu {$a}';
$string['rootcategory'] = 'Übergeordnete Kategorie';
$string['savenewtagtemplate'] = 'Speichern';
$string['searchdate'] = 'Datum';
$string['searchname'] = 'Vorname';
$string['searchsurname'] = 'Nachname';
$string['searchtag'] = 'Schlagwortsuche';
$string['searchwaitinglist'] = 'Auf der Warteliste';
$string['select'] = 'Auswahl';
$string['selectatleastoneuser'] = 'Bitte mindestens 1 Nutzer/in auswählen!';
$string['selectcategory'] = 'Kategorie auswählen';
$string['selectoptionid'] = 'Bitte eine Buchungsmöglichkeit auswählen!';
$string['selectoptioninotherbooking'] = 'Auswahl';
$string['sendcustommessage'] = 'Nachricht selber schreiben und senden';
$string['sendmailtobooker'] = 'Buchung für andere durchführen: E-Mail an den/die buchende Nutzer/in senden, anstatt an den/die Nutzer/in für den/die gebucht wurde.';
$string['sendmailtobooker_help'] = 'Diese Option aktivieren, um Buchungsbestätigungsmails anstatt an die gebuchten Nutzer/innen zu senden an den/die Nutzer/in senden, die die Buchung durchgeführt hat. Dies betrifft nur Buchungen, die auf der Seite "Buchung für andere Nutzer/innen durchführen" getätigt wurden.';
$string['sendpollurltoteachers'] = 'Link zur Umfrage versenden';
$string['sendreminderemail'] = 'Erinnerungs-E-Mail versenden';
$string['sendreminderemailsuccess'] = 'Benachrichtigung per E-Mail wurde erfolgreich versendet!';
$string['showactive'] = 'Verfügbare Buchungsmöglichkeiten';
$string['showallbookings'] = 'Alle Buchungsmöglichkeiten anzeigen';
$string['showhelpfullnavigationlinks'] = 'Links zur Navigations anzeigen.';
$string['showinapi'] = 'In API anzeigen?';
$string['showonlymyinstitutions'] = 'Meine Institutionen';
$string['sign_in_sheet_download'] = 'Unterschriftenliste herunterladen';
$string['spaceleft'] = 'Verfügbarer Platz';
$string['spacesleft'] = 'Verfügbarer Platz';
$string['startendtimeknown'] = 'Beginn und Ende sind bekannt';
$string['starttimenotset'] = 'Beginn ist nicht angegeben';
$string['statuschangetext'] = 'Benachrichtigung über Statusänderung';
$string['statuschangetext_help'] = 'Lassen Sie dieses Feld leer, um den Standardtext der Website zu verwenden. Folgende Platzhalter können im Text verwendet werden:
<ul>
<li>{status}</li>
<li>{participant}</li>
<li>{title}</li>
<li>{duration}</li>
<li>{starttime}</li>
<li>{endtime}</li>
<li>{startdate}</li>
<li>{enddate}</li>
<li>{courselink}</li>
<li>{bookinglink}</li>
<li>{pollurl}</li>
<li>{pollurlteachers}</li>
<li>{location}</li>
<li>{institution}</li>
<li>{address}</li>
<li>{eventtype}</li>
<li>{teacher}</li>
<li>{teacherN} - N ist die Trainernummer, z.B. {teacher1}</li>
<li>{pollstartdate}</li>
<li>{qr_id} - QR Code der Userid einfügen</li>
<li>{qr_username} - QR Code des Usernamen einfügen</li>
<li>{times} - Zeiten</li>
</ul>';
$string['submitandaddnew'] = 'Speichern und neue Buchung hinzufügen';
$string['subscribersto'] = 'Trainer/innen für \'{$a}\'';
$string['subscribetocourse'] = 'Nutzer/innen in den Kurs einschreiben';
$string['subscribeuser'] = 'Wollen Sie diese User wirklich in diesen Kurs einschreiben';
$string['tagtag'] = 'Schlagwort';
$string['tagtemplates'] = 'Schlagwort Vorlagen';
$string['tagtext'] = 'Schlagwort-Text';
$string['taken'] = 'gebucht';
$string['teachers'] = 'Trainer/innen';
$string['timecreated'] = 'Erstellungsdatum';
$string['timerestrict'] = 'Buchungsmöglichkeit auf diesen Zeitraum beschränken: Diese Option ist veraltet und sollte nicht mehr verwendet werden. Stattdessen verwenden Sie bitte die Optionen unter "Voraussetzungen", um die Buchungen für einen bestimmten Zeitraum zu beschränken.';
$string['to'] = 'bis';
$string['toomuchusersbooked'] = 'Maximale Anzahl an Benutzern, die Sie buchen können: {$a}';
$string['topic'] = 'Thema';
$string['updatebooking'] = 'Diese Buchung bearbeiten';
$string['usedinbooking'] = 'Das Löschen dieser Kategorie ist nicht möglich, da sie verwendet wird!';
$string['userdownload'] = 'Nutzer/innenliste herunterladen';
$string['userid'] = 'ID des Nutzers/der Nutzerin';
$string['userleave'] = 'Nutzer/in hat Buchung storniert';
$string['userleave_help'] = 'Lassen Sie dieses Feld leer, um den Standardtext der Website zu verwenden. Folgende Platzhalter können im Text verwendet werden:
<ul>
<li>{status}</li>
<li>{participant}</li>
<li>{title}</li>
<li>{duration}</li>
<li>{starttime}</li>
<li>{endtime}</li>
<li>{startdate}</li>
<li>{enddate}</li>
<li>{courselink}</li>
<li>{bookinglink}</li>
<li>{pollurl}</li>
<li>{pollurlteachers}</li>
<li>{location}</li>
<li>{institution}</li>
<li>{address}</li>
<li>{eventtype}</li>
<li>{teacher}</li>
<li>{teacherN} - N ist die Trainernummer, z.B. {teacher1}</li>
<li>{pollstartdate}</li>
<li>{qr_id} - QR Code der Userid einfügen</li>
<li>{qr_username} - QR Code des Usernamen einfügen</li>
<li>{times} - Zeiten</li>
</ul>';
$string['usernameofbookingmanager'] = 'Name des Buchungsverwalters';
$string['usernameofbookingmanager_help'] = 'Benutzername des/der Nutzer/in, der als Absender/in der Buchungsbestätigunsmitteilungen angeführt wird. Wenn die Option "Eine Kopie des Bestätigungsmail an Buchungsverwalter senden" aktiviert ist, wird die Kopie der Buchungsbestätigung an diese/n Nutzer/in gesendet.';
$string['usersonlist'] = 'Nutzerliste';
$string['viewallresponses'] = '{$a} Antworten verwalten';
$string['waitinglist'] = 'Warteliste';
$string['waitinglisttaken'] = 'Auf der Warteliste';
$string['waitinglistusers'] = 'Nutzer/innen auf der Warteliste';
$string['waitingplacesavailable'] = 'Verfügbare Wartelistenplätze:  {$a->overbookingavailable} von {$a->maxoverbooking}';
$string['waitingtext'] = 'Wartelistenbestätigung';
$string['waitingtext_help'] = 'Lassen Sie dieses Feld leer, um den Standardtext der Website zu verwenden. Folgende Platzhalter können im Text verwendet werden:
<ul>
<li>{status}</li>
<li>{participant}</li>
<li>{title}</li>
<li>{duration}</li>
<li>{starttime}</li>
<li>{endtime}</li>
<li>{startdate}</li>
<li>{enddate}</li>
<li>{courselink}</li>
<li>{bookinglink}</li>
<li>{pollurl}</li>
<li>{pollurlteachers}</li>
<li>{location}</li>
<li>{institution}</li>
<li>{address}</li>
<li>{eventtype}</li>
<li>{teacher}</li>
<li>{teacherN} - N ist die Trainernummer, z.B. {teacher1}</li>
<li>{pollstartdate}</li>
<li>{qr_id} - QR Code der Userid einfügen</li>
<li>{qr_username} - QR Code des Usernamen einfügen</li>
<li>{times} - Zeiten</li>
</ul>';
$string['waitspaceavailable'] = 'Wartelistenplätze verfügbar';
$string['week'] = 'Woche';
$string['whichview'] = 'Standardansicht der Buchungsoptionen';
$string['withselected'] = 'Ausgewählte Nutzer/innen';
$string['wrongdataallfields'] = 'Bitte alle Felder ausfüllen!';
$string['yes'] = 'Ja';
$string['yourselection'] = 'Ihre Auswahl';
