<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'studentquiz', language 'it', version '4.2'.
 *
 * @package     studentquiz
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abort_button'] = 'Annulla';
$string['add_comment'] = 'Aggiungi commento';
$string['add_reply'] = 'Aggiungi risposta';
$string['addprivatecomment'] = 'Aggiungi un commento privato (solo tra lo studente e il tutor)';
$string['addprivatecomment_help'] = 'Questi commenti sono circoscritti al solo autore della domanda e chi gestisce l\'attività. La discussione è di utilità per permettere al gestore dell\'attività di fornire feedback se e quando si cambia lo stato della domanda.';
$string['addpubliccomment'] = 'Aggiungi un commento pubblico';
$string['after_answering_end_date'] = 'Lo StudentQuiz non permette ulteriori risposte da {$a}';
$string['after_submission_end_date'] = 'Lo StudentQuiz non permette la sottomissione di ulteriori domande da {$a}';
$string['anonymous_user_name'] = 'Utente anonimo #{$a}';
$string['answeringndbeforestart'] = 'La data termine per le risposte non può essere specificata prima di aver impostato la data di apertura per le risposte';
$string['api_state_change_error_content'] = 'La domanda non può essere eliminata perché è stata già approvata.';
$string['api_state_change_error_title'] = 'Errore nella cancellazione della domanda';
$string['api_state_change_success_content'] = 'Stato/Visibilità della domanda modificato con successo';
$string['api_state_change_success_title'] = 'Successo';
$string['approve'] = 'Approva';
$string['approve_toggle'] = 'Approva/Disapprova';
$string['approved'] = '✓';
$string['approved_column_name'] = 'Approvata';
$string['approved_veryshort'] = 'A';
$string['approveselectedscheck'] = 'Si è sicuri di voler approvare / non approvare la seguente domanda?<br /><br />{$a}';
$string['average_column_name'] = 'Media';
$string['back_to_course_button'] = 'Torna al corso';
$string['before_answering_end_date'] = 'La possibilità di rispondere a questo StudentQuiz è terminata il {$a}.';
$string['before_answering_start_date'] = 'Aperto alle risposte dal {$a}.';
$string['before_submission_end_date'] = 'La possibilità di sottomettere domande a questo StudentQuiz è terminata il {$a}.';
$string['before_submission_start_date'] = 'Aperto alla sottomissione di domande dal {$a}.';
$string['cachedef_permissionssync'] = 'Tracciamento sincronizzazione permessi di StudentQuiz';
$string['cannotcapturecommenthistory'] = 'Impossibile recuperare la storia dei commenti';
$string['changecurrentstate'] = 'Cambia lo stato da <b>{$a}</b> a:';
$string['changestateto'] = 'Cambia stato/i a:';
$string['collapseall'] = 'Minimizza tutti i commenti';
$string['collapsecomment'] = 'Minimizza commento';
$string['comment'] = 'Commento';
$string['comment_author'] = 'Autore';
$string['comment_cannot_update'] = 'Non è possibile aggiornare il commento';
$string['comment_column_name'] = 'Commenti';
$string['comment_error'] = 'Per favore inserisci il commento';
$string['comment_error_unsaved'] = 'Vuoi salvare subito questo commento';
$string['comment_help'] = 'Scrivi un commento';
$string['comment_help_help'] = 'Scrivi un commento alla domanda';
$string['comment_veryshort'] = 'C';
$string['commentcolumnexplainprivate'] = 'Numero di commenti privati. Uno sfondo blu significa che hai almeno un commento non letto.';
$string['commentcolumnexplainpublic'] = 'Numero di commenti pubblici. Uno sfondo blu significa che hai almeno un commento non letto.';
$string['commenthistory'] = 'Storia dei commenti';
$string['commentplural'] = 'Commenti';
$string['confirmdeletecomment'] = 'Si è sicuri di voler eliminare questo commento?';
$string['createnewquestion'] = 'Crea nuova domanda';
$string['createnewquestionfirst'] = 'Crea prima domanda';
$string['creator_anonym_fullname'] = 'Studente anonimo';
$string['current_of_total'] = '{$a->current} di {$a->total}';
$string['current_state'] = 'Stato corrente';
$string['daily'] = 'giornalmente';
$string['delete'] = 'Elimina';
$string['deletecomment'] = 'Elimina commento';
$string['deleted'] = 'Eliminato';
$string['deletedbyauthor'] = 'Questo intervento è stato eliminato il {$a}';
$string['deletedbyuser'] = 'Questo intervento è stato eliminato da <a href="{$a->profileurl}" >{$a->fullname}</a> il {$a->date}.';
$string['deletedcomment'] = 'Intervento eliminato';
$string['deleteorphanedquestions'] = 'Elimina domande orfane';
$string['deleteorphanedquestionserrormdlquestion'] = '<font color="red">error</font>: impossibile eliminare dalla tabella mdl_question. La domanda è probabilmente utilizzata da altre parti.<br><font color="red">error</font>: l\'eliminazione dalla tabella mdl_studentquiz* è stata saltata.<br>';
$string['deleteorphanedquestionserrorstudentquiz'] = '<font color="red">error</font>: impossibile eliminare dalle tabelle mdl_studentquiz*.<br>';
$string['deleteorphanedquestionsfullmessage'] = 'Domande che sono non approvate / segnate per l\'eliminazione:<ul>{$a->fullmessage}</ul>';
$string['deleteorphanedquestionsnonefound'] = '<b>nessuna trovata</b>';
$string['deleteorphanedquestionsquestioninfo'] = '<li><b>{$a->name}</b> (Tipo di domanda: {$a->qtype}, ID: {$a->questionid})</li>';
$string['deleteorphanedquestionssmallmessage'] = 'StudentQuiz: l\'elaborazione per eliminare le domande orfane è stata eseguita';
$string['deleteorphanedquestionssubject'] = 'StudentQuiz';
$string['deleteorphanedquestionssuccessmdlquestion'] = '<font color="green">success</font>: eliminate dalla tabella mdl_question<br>';
$string['deleteorphanedquestionssuccessstudentquiz'] = '<font color="green">success</font>: eliminate dalle tabelle mdl_studentquiz*.<br>';
$string['describe_already_deleted'] = 'Questo commento è stato già eliminato.';
$string['describe_not_creator'] = 'Questo non è un tuo commento.';
$string['describe_out_of_time_delete'] = 'Questo commento non può più essere eliminato.';
$string['describe_out_of_time_edit'] = 'Questo commento non può più essere modificato.';
$string['descriptioncofstate'] = 'Domanda impostata allo stato \'{$a->state}\'';
$string['descriptionofstatenew'] = 'Domanda salvata (\'Draft\')';
$string['descriptionofvisibility'] = 'Visibilità domanda impostata a \'{$a->visibility}\'';
$string['difficulty_all_column_name'] = 'Difficoltà della comunità';
$string['difficulty_level_column_name'] = 'Difficoltà';
$string['difficulty_title'] = 'Barra di difficoltà';
$string['editcomment'] = 'Modifica commento';
$string['editedcomment_last_edit'] = 'Ultima modifica:';
$string['editedcommenthistory'] = 'Modificata da {$a->lastesteditedcommentauthorname} il {$a->lastededitedcommenttime}';
$string['editedcommenthistorylinktext'] = 'Storia';
$string['editedcommenthistorywithuserlink'] = 'Modificata da <a href="{$a->lastesteditedcommentauthorprofileurl}">{$a->lastesteditedcommentauthorname}</a> il {$a->lastededitedcommenttime}';
$string['editorplaceholder'] = 'Inserisci qui il tuo commento ...';
$string['emailautomationnote'] = 'Questo è un messaggio automatizzato - questo indirizzo email non è monitorato';
$string['emailcommentaddedbody'] = 'Cara/o {$a->recepientname},

La tua domanda \'{$a->questionname}\' nell\'attività StudentQuiz \'{$a->modulename}\' nel corso \'{$a->coursename}\' è stata commentata da \'{$a->actorname}\' il \'{$a->timestamp}\'.';
$string['emailcommentaddedsmall'] = 'La tua domanda \'{$a->questionname}\' è stata commentata da {$a->actorname}.';
$string['emailcommentaddedsubject'] = 'Una domanda è stata commentata: {$a->questionname}';
$string['emailcommentdeletedbody'] = 'Cara/o {$a->recepientname},

Il commento del \'{$a->commenttime}\' alla tua domanda  \'{$a->questionname}\' nell\'attività StudentQuiz \'{$a->modulename}\' nel corso \'{$a->coursename}\' è stato cancellato da \'{$a->actorname}\' il \'{$a->timestamp}\'.

Il commento era: \'{$a->commenttext}\'

Puoi rivedere la domanda qui: {$a->questionurl}.';
$string['emailcommentdeletedsmall'] = 'Il commento alla tua domanda \'{$a->questionname}\' è stato cancellato da {$a->actorname}.';
$string['emailcommentdeletedsubject'] = 'Un commento è stato cancellato per la domanda:  {$a->questionname}';
$string['emaildigestbody'] = 'Questa è la tua notifica digest {$a->digesttype} per l\'attività StudentQuiz <b>{$a->modulename}</b>, disponibile qui:';
$string['emaildigestbody_section_content'] = 'La tua domanda <b>{$a->questionname}</b> è stata <b>{$a->actiontype}</b> da <b>{$a->actorname}</b>';
$string['emaildigestbody_section_title'] = 'Notifica {$a->seq}, {$a->timestamp}';
$string['emaildigestsubject'] = 'Notifica StudentQuiz Digest';
$string['emailminecommentdeletedbody'] = 'Cara/o {$a->recepientname},

Il tuo commento del \'{$a->commenttime}\' alla tua domanda  \'{$a->questionname}\' nell\'attività StudentQuiz \'{$a->modulename}\' nel corso \'{$a->coursename}\' è stato cancellato da \'{$a->actorname}\' il \'{$a->timestamp}\'.

Il commento era: \'{$a->commenttext}\'

Puoi rivedere la domanda qui: {$a->questionurl}.';
$string['emailminecommentdeletedsmall'] = 'Il tuo commento alla tua domanda \'{$a->questionname}\' è stato cancellato da {$a->actorname}.';
$string['emailminecommentdeletedsubject'] = 'Un commento è stato cancellato per la domanda:  {$a->questionname}';
$string['emailnoityfyreviewablequestion_section_content'] = 'La domanda "<b>{$a->questionname}</b>" è stata impostata in "<b>Revisionabile</b>" da <b>{$a->actorname}</b>';
$string['emailnoityfyreviewablequestionsinglebody'] = '<b>{$a->courseshortname}</b> Attività StudentQuiz (<b>"{$a->modulename}"</b>): la domanda <b>"{$a->questionname}"</b> è stata impostata in "<b>Revisionabile</b>" da <b>{$a->actorname}, {$a->timestamp}.</b>';
$string['emailsalutation'] = 'Cara/o {$a},';
$string['emailsinglebody'] = 'La tua domanda <b>{$a->questionname}</b> nell\'attività StudentQuiz <b>{$a->modulename}</b> del corso <b>{$a->coursename}</b> è stata {$a->eventname} da <b>{$a->actorname}</b> il <b>{$a->timestamp}</b>.';
$string['emailsinglebody_reviewlink'] = 'Puoi rivedere questa domanda qui:';
$string['error_form_validation'] = '{$a}';
$string['error_permission'] = 'Spiacenti ma devi essere membro del gruppo per rivedere questa domanda.';
$string['error_sendalert'] = 'C\'è stato un errore nell\'inviare la tua segnalazione a {$a}.
La segnalazione potrebbe non essere stata inviata.';
$string['expandall'] = 'Espandi tutti i commenti';
$string['expandcomment'] = 'Espandi commento';
$string['filter'] = 'Filtro';
$string['filter_advanced_element'] = '{$a} (Elemento avanzato)';
$string['filter_comment_label_date'] = 'Data';
$string['filter_comment_label_forename'] = 'Nome';
$string['filter_comment_label_sort_by'] = 'Ordina per:';
$string['filter_comment_label_sort_toggle'] = 'Ordina per {$a->field} {$a->type}';
$string['filter_comment_label_surname'] = 'Cognome';
$string['filter_ishigher'] = 'È superiore';
$string['filter_islower'] = 'È inferiore';
$string['filter_label_approved'] = 'Domande approvate';
$string['filter_label_comment'] = 'Commenti';
$string['filter_label_createdate'] = 'Creazione';
$string['filter_label_difficulty_level'] = 'Difficoltà';
$string['filter_label_fast_filters'] = 'Filtro veloce per le domande';
$string['filter_label_myattempts'] = 'Miei tentativi';
$string['filter_label_mydifficulty'] = 'Mia difficoltà';
$string['filter_label_mylastattempt'] = 'Mio ultimo tentativo';
$string['filter_label_myrate'] = 'Mia valutazione';
$string['filter_label_onlyapproved'] = 'Approvata';
$string['filter_label_onlyapproved_help'] = 'Domande approvate dal docente';
$string['filter_label_onlydifficult'] = 'Difficile per tutti';
$string['filter_label_onlydifficult_help'] = 'Domanda con una difficoltà media superiore al {$a}%';
$string['filter_label_onlydifficultforme'] = 'Difficile per me';
$string['filter_label_onlydifficultforme_help'] = 'Domanda con una difficoltà per me superiore al {$a}%';
$string['filter_label_onlygood'] = 'Buona';
$string['filter_label_onlygood_help'] = 'Domanda con una valutazione media di almeno {$a} stelle';
$string['filter_label_onlymine'] = 'Mia';
$string['filter_label_onlymine_help'] = 'Domande che hai creato';
$string['filter_label_onlynew'] = 'Non risposta';
$string['filter_label_onlynew_help'] = 'Domande a cui non hai mai risposto';
$string['filter_label_question'] = 'Titolo domanda';
$string['filter_label_question_creation_item'] = '{$a->creationtext} {$a->rowtext} {$a->inputtext}';
$string['filter_label_question_creation_item_inputtext'] = '{$a->inputtext} {$a->inputtype}';
$string['filter_label_questiontext'] = 'Contenuto domanda';
$string['filter_label_rates'] = 'Valutazione';
$string['filter_label_show_mine'] = 'Mie domande';
$string['filter_label_tags'] = 'Tag';
$string['finish_button'] = 'Termina';
$string['hidden'] = 'Nascosta';
$string['history'] = 'Storico';
$string['includingunread'] = '(incluse non lette)';
$string['invalidcomment'] = 'Commento non valido';
$string['invalidemail'] = 'L\'indirizzo email non è corretto. Per favore inserisci un solo indirizzo email.';
$string['lastattempt_right'] = '✓';
$string['lastattempt_right_label'] = 'Ultimo tentativo corretto';
$string['lastattempt_wrong'] = '✗';
$string['lastattempt_wrong_label'] = 'Ultimo tentativo sbagliato';
$string['latest_column_name'] = 'Ultimo';
$string['manager_anonym_fullname'] = 'Gestore anonimo';
$string['message'] = 'Messaggio';
$string['messageprovider:commentadded'] = 'Notifica commento aggiunto';
$string['messageprovider:commentdeleted'] = 'Notifica commento eliminato';
$string['messageprovider:deleteorphanedquestions'] = 'Notifica domanda eliminata';
$string['messageprovider:minecommentdeleted'] = 'Notifica mio commento eliminato';
$string['messageprovider:questionchanged'] = 'Notifica evento domanda';
$string['migrate_already_done'] = 'Non è stato fatto nulla perché l\'attività è stata già migrata!';
$string['migrate_ask'] = 'La velocità dello StudentQuiz è stata migliorata nella versione 3.2.1, ma questo gruppo di domanda è ancora basata sulla versione precedente.
Le domande e quiz saranno caricati più velocemente se esegui questa migrazione. Il caricamento sarà più veloce e non cambierà altro.';
$string['migrate_studentquiz'] = 'Migra le domande StudentQuiz da versioni precedenti alla 3.2.1 alla versione più veloce con valori aggregati';
$string['migrate_studentquiz_short'] = 'Velocizza questo gruppo di domande';
$string['migrated_successful'] = 'Questa attività è stata migrata con successo!';
$string['mine_column_name'] = 'Mie';
$string['missingparam'] = 'Un parametro richiesto è mancante o sbagliato';
$string['moderator'] = 'Moderatore';
$string['modulename'] = 'StudentQuiz';
$string['modulename_help'] = 'L\'attività StudentQuiz permette agli studenti di aggiungere domande pubblicamente. Nel riepilogo di StudentQuiz gli studenti possono filtrare le domande e possono inoltre fare pratica con le domande pubblicate. Il docente ha l\'opportunità di anonimizzare il nome del creatore della domanda.<br><br>L\'attività StudentQuiz assegna punti agli studenti per motivarli ad aggiungere domande e fare prativa. I punti sono visualizzati nella tabella Classifica.';
$string['modulename_link'] = 'mod/studentquiz/view';
$string['modulenameplural'] = 'StudentQuiz';
$string['more'] = 'Di più';
$string['myattempts_column_name'] = 'Miei tentativi';
$string['mydifficulty_column_name'] = 'Mia difficoltà';
$string['mylastattempt_column_name'] = 'Mio ultimo tentativo';
$string['myrate_column_name'] = 'Mia valutazione';
$string['nav_export'] = 'Esporta';
$string['nav_import'] = 'Importa';
$string['nav_question_no'] = 'Domanda {$a->current} di {$a->total}';
$string['needtoallowatleastoneqtype'] = 'Devi abilitare almeno un tipo di domanda';
$string['next_button'] = 'Prossima';
$string['no_comment'] = 'N.D.';
$string['no_comments'] = 'Nessun commento';
$string['no_difficulty_level'] = 'N.D.';
$string['no_myattempts'] = 'N.D.';
$string['no_mylastattempt'] = 'N.D.';
$string['no_mylastattempt_label'] = 'La domanda non ha tentativi';
$string['no_questions_add'] = 'Non ci sono domande in questo StudentQuiz. Aggiungi pure nuove domande.';
$string['no_questions_filter'] = 'Nessuna domanda corrisponde al tuo criterio di ricerca. Cancella tutti i filtri per vederle tutte.';
$string['no_questions_selected_message'] = 'Per favore selezione almeno una domanda per iniziare il quiz.';
$string['no_rates'] = 'N.D.';
$string['no_tags'] = 'N.D.';
$string['nocommenthistoryexist'] = 'Non c\'è ancora uno storico per questo commento.';
$string['nofurtherprivatecomments'] = 'Dopo che la domanda è in stato "Approvata" non sono più possibile commenti.';
$string['noquestionsselectedtodoaction'] = 'Per favore seleziona una o più domande prima di selezionare l\'azione.';
$string['not_approved'] = '✗';
$string['notshowratingcomment'] = 'Nella modalità Anteprima la valutazione e i commenti pubblici non sono disponibili per una propria domanda.';
$string['num_questions'] = '{$a} domande';
$string['number_column_name'] = 'Numero';
$string['numberreply'] = '{$a} risposte';
$string['onlyrootcommentcanreply'] = 'Si può rispondere soltanto ai commenti di primo livello';
$string['pagesize'] = 'Dimensione pagina:';
$string['pin'] = 'Fissa domanda';
$string['please_enrole_message'] = 'Per favore iscriviti al corso per vedere i tuoi progressi personali';
$string['pluginadministration'] = 'Amministrazione StudentQuiz';
$string['pluginname'] = 'StudentQuiz';
$string['previous_button'] = 'Precedente';
$string['privacy:metadata:mod_studentquiz_comment_sort'] = 'La preferenza utente per il tipo del filtro commento.';
$string['privacy:metadata:mod_studentquiz_question_active_tab'] = 'La preferenza utente per la scheda correntemente attiva nelle pagine della domanda.';
$string['privacy:metadata:studentquiz_attempt'] = 'Rappresenta il tentativo di un utente di rispondere ad un gruppo di domande.';
$string['privacy:metadata:studentquiz_attempt:categoryid'] = 'ID della categoria.';
$string['privacy:metadata:studentquiz_attempt:questionusageid'] = 'ID dell\'utilizzo domanda.';
$string['privacy:metadata:studentquiz_attempt:studentquizid'] = 'ID dello StudentQuiz';
$string['privacy:metadata:studentquiz_attempt:userid'] = 'ID dell\'utente';
$string['privacy:metadata:studentquiz_comment'] = 'Memorizza i commenti alle domande.';
$string['privacy:metadata:studentquiz_comment:comment'] = 'Commento alla domanda.';
$string['privacy:metadata:studentquiz_comment:created'] = 'Orario di creazione del commento.';
$string['privacy:metadata:studentquiz_comment:deleted'] = 'Orario di eliminazione del commento';
$string['privacy:metadata:studentquiz_comment:deleteuserid'] = 'ID dell\'utente che ha eliminato il commento.';
$string['privacy:metadata:studentquiz_comment:edited'] = 'Orario di modifica del commento.';
$string['privacy:metadata:studentquiz_comment:edituserid'] = 'ID dell\'utente che ha modificato il commento.';
$string['privacy:metadata:studentquiz_comment:parentid'] = 'ID del commento superiore. 0: commento di primo livello.';
$string['privacy:metadata:studentquiz_comment:status'] = 'Stato del commento';
$string['privacy:metadata:studentquiz_comment:timemodified'] = 'Orario di modifica del commento';
$string['privacy:metadata:studentquiz_comment:type'] = 'Tipo di commento';
$string['privacy:metadata:studentquiz_comment:userid'] = 'ID dell\'utente.';
$string['privacy:metadata:studentquiz_comment:usermodified'] = 'ID dell\'utente che ha modificato il commento';
$string['privacy:metadata:studentquiz_comment_history'] = 'Memorizza lo storico dei commenti';
$string['privacy:metadata:studentquiz_comment_history:action'] = 'Tipo di storico 0 - Creazione | 1 - Modifica | 2 - Eliminazione';
$string['privacy:metadata:studentquiz_comment_history:commentid'] = 'ID del commento';
$string['privacy:metadata:studentquiz_comment_history:content'] = 'Contenuto dello storico del commento';
$string['privacy:metadata:studentquiz_comment_history:timemodified'] = 'Orario di modifica del commento';
$string['privacy:metadata:studentquiz_comment_history:userid'] = 'ID dell\'utente che ha modificato il commento';
$string['privacy:metadata:studentquiz_notification'] = 'Coda di notifica';
$string['privacy:metadata:studentquiz_notification:content'] = 'Contenuto della notifica';
$string['privacy:metadata:studentquiz_notification:recipientid'] = 'ID del destinatario';
$string['privacy:metadata:studentquiz_notification:status'] = 'Stato della notifica';
$string['privacy:metadata:studentquiz_notification:studentquizid'] = 'ID dello StudentQuiz';
$string['privacy:metadata:studentquiz_notification:timetosend'] = 'Orario di invio della notifica';
$string['privacy:metadata:studentquiz_progress'] = 'Memorizza il progresso di uno studente con questa domanda.';
$string['privacy:metadata:studentquiz_progress:attempts'] = 'Numero di tentativi di risposta a questa domanda.';
$string['privacy:metadata:studentquiz_progress:correctattempts'] = 'Numero di risposte corrette';
$string['privacy:metadata:studentquiz_progress:lastanswercorrect'] = '0: l\'ultima risposta era sbagliata o non definita, 1: l\'ultima risposta era corretta.';
$string['privacy:metadata:studentquiz_progress:lastreadprivatecomment'] = 'Ultima volta che un utente ha letto i commenti privati';
$string['privacy:metadata:studentquiz_progress:lastreadpubliccomment'] = 'Ultima volta che un utente ha letto i commenti pubblici';
$string['privacy:metadata:studentquiz_progress:studentquizid'] = 'ID dello StudentQuiz';
$string['privacy:metadata:studentquiz_progress:userid'] = 'ID dell\'utente';
$string['privacy:metadata:studentquiz_question'] = 'Memorizza le informazioni legate alla domanda';
$string['privacy:metadata:studentquiz_question:groupid'] = 'ID del gruppo a cui appartiene la domanda';
$string['privacy:metadata:studentquiz_question:hidden'] = 'Informazione sulla visibilità della domanda';
$string['privacy:metadata:studentquiz_question:pinned'] = 'Informazione sul fissaggio della domanda';
$string['privacy:metadata:studentquiz_question:state'] = 'Informazione se la domanda è approvata, non approvata, nuovo o modificata';
$string['privacy:metadata:studentquiz_rate'] = 'Memorizza le valutazioni delle domande.';
$string['privacy:metadata:studentquiz_rate:rate'] = 'Valutazione della domanda';
$string['privacy:metadata:studentquiz_rate:userid'] = 'ID dell\'utente';
$string['privacy:metadata:studentquiz_state_history:state'] = 'Informazione sullo stato della domanda (approvata, non approvata, nuova o modificata)';
$string['privacy:metadata:studentquiz_state_history:timecreated'] = 'Data di creazione';
$string['privacy:metadata:studentquiz_state_history:userid'] = 'ID dell\'utente';
$string['private'] = 'Privato';
$string['privatecomments'] = 'Commenti privati';
$string['progress_bar_caption'] = 'I tuoi progressi in questa attività StudentQuiz';
$string['public'] = 'Pubblico';
$string['publiccomments'] = 'Commenti pubblici';
$string['questionchangedlowercase'] = 'modificata';
$string['questionsinuse'] = '(* Le domande evidenziate da un asterisco sono già utilizzate in qualche quiz.)';
$string['ranking_block_title'] = 'Classifica';
$string['ranking_block_title_anonymised'] = 'Classifica (anonima)';
$string['rate_all_column_name'] = 'Valutazione della comunità';
$string['rate_column_name'] = 'Valutazione';
$string['rate_error'] = 'Per favore inserisci la tua valutazione';
$string['rate_help'] = 'Valuta questa domanda';
$string['rate_help_help'] = 'Valuta questa domanda.<br />1 stella è molto male e 5 stelle è molto bene';
$string['rate_multi_stars_desc'] = '{$a} stelle selezionate';
$string['rate_one_star_desc'] = '1 stella selezionata';
$string['rate_points'] = 'Punti';
$string['rate_title'] = 'Valutazione';
$string['ratingbar_title'] = 'Barra di valutazione';
$string['remove_comment'] = 'Elimina';
$string['remove_comment_label'] = 'Elimina commento';
$string['replies'] = 'Risposte';
$string['reply'] = 'Rispondi';
$string['replycomment'] = 'Rispondi';
$string['report_comment_condition1'] = 'Questo commento è offensivo';
$string['report_comment_condition2'] = 'Questo commento è una molestia';
$string['report_comment_condition3'] = 'Questo commento contiene contenuti osceni (es. pornografia)';
$string['report_comment_condition4'] = 'Questo commento è calunnioso o diffamatorio';
$string['report_comment_condition5'] = 'Questo commento infrange il copyright';
$string['report_comment_condition6'] = 'Questo commento è contro le regole';
$string['report_comment_condition_more'] = 'Altre informazioni (opzionale)';
$string['report_comment_emailappendix'] = 'Stai ricevendo questa email perché il tuo indirizzo email è stato usato nell\'attività StudentQuiz per riportare l\'inserimento di un commento non ammesso.';
$string['report_comment_emailpreface'] = 'Un commento è stato segnalato da {$a->fullname} ({$a->username},
{$a->email}).';
$string['report_comment_emailsubject'] = 'Commento {$a->commentid} segnalato: {$a->coursename} {$a->studentquizname}';
$string['report_comment_feedback'] = 'La tua segnalazione è stata inviata con successo. Un membro dello staff verificherà il problema.';
$string['report_comment_info'] = 'La funzionalità "Segnala" permette di segnalare questo commento a un membro dello staff, che lo analizzerà. <strong>Per favore utilizza questa funzionalità solo se pensi che questo commento sia contro le regole</strong>.';
$string['report_comment_invalid'] = 'Devi specificare il motivo della segnalazione del commento.';
$string['report_comment_invalid_checkbox'] = 'Devi selezionare almeno un elemento dell\'elenco.';
$string['report_comment_link_text'] = 'Anteprima';
$string['report_comment_not_available'] = 'La funzionalità "Segnala commenti" non è disponibile.';
$string['report_comment_pagename'] = 'Segnala un commento come non accettabile';
$string['report_comment_reasons'] = 'Motivi della segnalazione:';
$string['report_comment_reporter_detail'] = '{$a->fullname} ({$a->username}; {$a->email}; {$a->ip})';
$string['report_comment_reporter_info'] = '<strong>Dettagli del segnalante</strong>:';
$string['report_comment_submit'] = 'Invia segnalazione';
$string['reportcomment'] = 'Segnala';
$string['reportcomment_title'] = 'Segnala commento come non accettabile';
$string['reportquiz_admin_title'] = 'Statistiche degli studenti';
$string['reportquiz_stats_all_last_attempt_correct'] = 'Media di comunità di ultime risposte corrette';
$string['reportquiz_stats_all_last_attempt_incorrect'] = 'Media di comunità di ultime risposte non corrette';
$string['reportquiz_stats_all_percentage_correct_answers'] = 'Percentuale di comunità di risposte corrette';
$string['reportquiz_stats_all_percentage_correct_answers_help'] = 'Somma di risposte corrette / Somma di tutte le risposte.';
$string['reportquiz_stats_all_progress'] = 'Media dei progressi della comunità';
$string['reportquiz_stats_all_progress_help'] = 'Media dei progressi della comunità basata su tutti i membri della comunità.';
$string['reportquiz_stats_all_question_attempts_correct'] = 'Media di comunità di risposte corrette';
$string['reportquiz_stats_all_question_attempts_incorrect'] = 'Media di comunità di risposte non corrette';
$string['reportquiz_stats_all_questions_answered'] = 'Media di comunità di tutte le risposte';
$string['reportquiz_stats_all_questions_answered_help'] = 'Media di risposte date da tutti i membri della comunità.';
$string['reportquiz_stats_all_questions_approved'] = 'Numero di domande approvate';
$string['reportquiz_stats_all_questions_approved_help'] = 'I docenti possono approvare le domande per verificarne la correttezza. Questo è il numero delle domande approvate in questo StudentQuiz.';
$string['reportquiz_stats_all_questions_created'] = 'Numero di domande in questo StudentQuiz';
$string['reportquiz_stats_all_questions_created_help'] = 'Numero di domande create dalla comunità';
$string['reportquiz_stats_all_rates_average'] = 'Valutazione media di tutte le domande';
$string['reportquiz_stats_all_rates_average_help'] = 'La valutazione di ogni domanda è la media di stelle ricevute dalla comunità.
Esempio: La comunità ha creato 4 domande. Se la domanda A è stata valutata 3 stelle dalla comunità, la domanda B = 4 stelle, la domanda C = 2 stelle e la domanda D = 5 stelle, allora la valutazione media di tutte le domande è 3.5.';
$string['reportquiz_stats_own_last_attempt_correct'] = 'Numero delle tue ultime risposte corrette';
$string['reportquiz_stats_own_last_attempt_incorrect'] = 'Numero delle tue ultimo risposte non corrette';
$string['reportquiz_stats_own_percentage_correct_answers'] = 'Percentuale delle tue risposte corrette';
$string['reportquiz_stats_own_percentage_correct_answers_help'] = 'Percentuale di tutte le tue risposte corrette su tutte le risposte date in questo StudentQuiz. Le risposte parzialmente corretti sono considerate come non corrette.';
$string['reportquiz_stats_own_progress'] = 'Progressi personali';
$string['reportquiz_stats_own_progress_help'] = 'Percentuale delle tue ultime risposte corrette su tutte le domande in questo StudentQuiz. Le risposte parzialmente corrette sono considerate come non corrette.';
$string['reportquiz_stats_own_question_attempts_correct'] = 'Totale delle tue risposte corrette';
$string['reportquiz_stats_own_question_attempts_incorrect'] = 'Totale delle tue risposte non corrette';
$string['reportquiz_stats_own_questions_answered'] = 'Totale delle tue risposte';
$string['reportquiz_stats_own_questions_answered_help'] = 'Numero di tutte le risposte che hai dato in questo StudentQuiz';
$string['reportquiz_stats_own_questions_approved'] = 'Numero di risposte approvate';
$string['reportquiz_stats_own_questions_approved_help'] = 'I docenti possono approvare le domande per verificarne la correttezza. Questo è il numero delle tue domande approvate in questo StudentQuiz.';
$string['reportquiz_stats_own_questions_created'] = 'Numero di domande che hai inserito';
$string['reportquiz_stats_own_questions_created_help'] = 'Numero di domanda che hai inserito in questo StudentQuiz.';
$string['reportquiz_stats_own_rates_average'] = 'Valutazione media che hai ricevuto';
$string['reportquiz_stats_own_rates_average_help'] = 'La valutazione di ogni domanda è la media di stelle ricevute dalla comunità.
Esempio: La comunità ha creato 4 domande. Se la domanda A è stata valutata 3 stelle dalla comunità, la domanda B = 4 stelle, la domanda C = 2 stelle e la domanda D = 5 stelle, allora la valutazione media di tutte le domande è 3.5.';
$string['reportquiz_stats_title'] = 'Statistiche';
$string['reportquiz_total_attempt'] = 'Numero di tentativi svolti dall\'utente';
$string['reportquiz_total_obtained_marks'] = 'Valutazione totale';
$string['reportquiz_total_questions_answered'] = 'Numero di risposte';
$string['reportquiz_total_questions_right'] = 'Numero di risposte corrette';
$string['reportquiz_total_questions_wrong'] = 'Risposte sbagliate';
$string['reportquiz_total_users'] = 'Numero dei partecipanti';
$string['reportrank_table_column_approvedquestions'] = 'Punti per le domande approvate';
$string['reportrank_table_column_communitystatus'] = 'Statistiche della communità';
$string['reportrank_table_column_correctanswers'] = 'Risposte corrette';
$string['reportrank_table_column_countquestions'] = 'Punti per le domande pubblicate';
$string['reportrank_table_column_description'] = 'Descrizione';
$string['reportrank_table_column_factor'] = 'Fattore';
$string['reportrank_table_column_fullname'] = 'Nome completo';
$string['reportrank_table_column_incorrectanswers'] = 'Risposte non corrette';
$string['reportrank_table_column_lastcorrectanswers'] = 'Punti per gli ultimi tentativi corretti';
$string['reportrank_table_column_lastincorrectanswers'] = 'Punti per gli ultimi tentativi sbagliati';
$string['reportrank_table_column_points'] = 'Punti';
$string['reportrank_table_column_progress'] = 'Progressi personali';
$string['reportrank_table_column_quantifier_name'] = 'Nome';
$string['reportrank_table_column_rank'] = 'Classifica';
$string['reportrank_table_column_summeanrates'] = 'Punti per stelle ricevute';
$string['reportrank_table_column_total_points'] = 'Punti totali';
$string['reportrank_table_column_value'] = 'Valore';
$string['reportrank_table_column_yourstatus'] = 'Statistiche personali';
$string['reportrank_table_quantifier_caption'] = 'Come sono calcolati i punti';
$string['reportrank_table_title'] = 'Classifica degli studenti - Top 10';
$string['reportrank_table_title_for_manager'] = 'Classifica degli studenti';
$string['reportrank_title'] = 'Classifica';
$string['review_button'] = 'Rivedi';
$string['savechanges'] = 'Salva modifiche';
$string['scheduled_task_send_digest_notification'] = 'Invia notifica digest';
$string['setting_question_publishing'] = 'Pubblicazione domanda';
$string['setting_question_publishing_automatic'] = 'Pubblica automaticamente le nuove domande';
$string['setting_question_publishing_help'] = 'Le domande pubblicate vengono mostrate nell\'elenco in modo che gli altri studenti possano provarle. Scegli per approvare tutte le domande automaticamente o se richiederne l\'approvazione prima della pubblicazione.
<br>Nota: questa impostazione si applica solamente alle nuove domande.';
$string['setting_question_publishing_require_approval'] = 'Richiedi approvazione prima di pubblicare';
$string['settings_allowallqtypes'] = 'Consenti tutti i tipi di domande';
$string['settings_allowedqtypes'] = 'Tipi di domanda consentiti';
$string['settings_allowedqtypes_help'] = 'Limita i tipi di domande consentiti ai soli selezionati';
$string['settings_allowedrolestoshow'] = 'Ruoli bloccati dalla modifica nelle singole attività';
$string['settings_allowedrolestoshow_help'] = 'Questa impostazione è legata alla precedente. Non tutti i ruoli presenti sono rilevanti per uno StudentQuiz, quindi si può usare questa impostazione per ridurre il numero di ruoli elencati nelle impostazioni delle singole attività. I ruoli selezionati qui appariranno nelle impostazioni dell\'attività, in modo da permettere al docente di sovrascrivere l\'impostazione. I ruoli non selezionati saranno esclusi dai report in base alla selezione fatta in precedenza.';
$string['settings_anonymous'] = 'Anonimizzatore studente';
$string['settings_anonymous_help'] = 'Gli studenti non potranno vedere i nomi degli altri';
$string['settings_anonymous_label'] = 'Rendi gli studenti anonimi';
$string['settings_approvedquantifier'] = 'Fattore domande approvate';
$string['settings_approvedquantifier_help'] = 'Punti per ogni domanda approvata';
$string['settings_approvedquantifier_label'] = 'Punti per ogni domanda approvata';
$string['settings_availability_close_answering_from'] = 'Data termine per rispondere alle domande';
$string['settings_availability_close_submission_from'] = 'Date termine per l\'invio delle domande';
$string['settings_availability_open_answering_from'] = 'Data di inizio per rispondere alle domande';
$string['settings_availability_open_submission_from'] = 'Date di inizio per l\'invio delle domande';
$string['settings_comment_editor_toolbar'] = 'Configurazione della toolbar dell\'editor di commenti';
$string['settings_comment_editor_toolbar_des'] = 'La lista dei plugin e l\'ordine con cui visualizzarli può essere configurata qui';
$string['settings_commentdeletionperiod'] = 'Tempo (in minuti) per la modifica/cancellazione dei commenti';
$string['settings_commentdeletionperiod_help'] = 'Imposta il tempo (in minuti) in cui il pulsante Modifica/Elimina sarà disponibile agli studenti per modificare/eliminare i propri commenti (o le risposte ai commenti) dopo l\'invio. Sono consentiti valori tra gli 0 e i 60 minuti. Se il tempo per la cancellazione è impostato a 0, gli studenti non potranno modifica/eliminare i propri commenti.';
$string['settings_email_digest_first_day'] = 'Primo giorno della settimana?';
$string['settings_email_digest_first_day_help'] = 'Se hai selezionato il digest settimanale, questa opzioni ti permette di definire il primo giorno (considerato alle 00h:00m:00 di quel giorno) del periodo di sette giorni. Questo è particolarmente utile se l\'attività inizia a metà settimana.';
$string['settings_email_digest_type'] = 'Tipo di email digest';
$string['settings_email_digest_type_daily_digest'] = 'Digest giornaliero';
$string['settings_email_digest_type_help'] = 'Lo StudentQuiz ha varie notifiche che possono essere abilitate, come informare gli studenti autori di domande di un cambiamento di stato (es. un docente ha approvato una delle loro domande). Puoi usare questa impostazione per specificare con quale frequenza inviare queste notifiche.';
$string['settings_email_digest_type_no_digest'] = 'Nessun digest (singola email per azione)';
$string['settings_email_digest_type_weekly_digest'] = 'Digest settimanale';
$string['settings_excluderoles'] = 'Ruoli da escludere dalla classifica';
$string['settings_excluderoles_help'] = 'In ogni StudentQuiz, il docente può controllare quali ruoli sono esclusi dalla classifica. La lista selezionata qui sarà quella utilizzata per i nuovi StudentQuiz creati.';
$string['settings_excluderoles_label'] = 'Ruoli da escludere dalla classifica';
$string['settings_forcecommenting'] = 'Forza i commenti';
$string['settings_forcecommenting_help'] = 'Forza i commenti quando si provano le domande';
$string['settings_forcerating'] = 'Forza la valutazione';
$string['settings_forcerating_help'] = 'Forza la valutazione quando si provano le domande';
$string['settings_lastcorrectanswerquantifier'] = 'Fattore per le ultime risposte corrette';
$string['settings_lastcorrectanswerquantifier_help'] = 'Punti per ogni risposta corretta nell\'ultimo tentativo';
$string['settings_lastcorrectanswerquantifier_label'] = 'Punti per le ultime risposte corrette';
$string['settings_lastincorrectanswerquantifier'] = 'Fattore per le ultime risposte sbagliate';
$string['settings_lastincorrectanswerquantifier_help'] = 'Punti per ogni risposta sbagliata o parzialmente sbagliata nell\'ultimo tentativo';
$string['settings_lastincorrectanswerquantifier_label'] = 'Fattore per le ultime risposte sbagliate';
$string['settings_notification'] = 'Impostazioni delle notifiche';
$string['settings_privatecomment'] = 'Spiegazione dei commenti privati';
$string['settings_privatecomment_help'] = 'Puoi modificare il testo riportato sopra in modo da adattarlo al contesto e a come la tua organizzazione gestisce le discussioni tra lo studente e i docenti/tutor.';
$string['settings_privatecommenting'] = 'Abilita i commenti privati';
$string['settings_privatecommenting_help'] = 'La discussione privata, accessibile nell\'anteprima della domanda fino a quando questa non è approvata, permette all\'autore della domanda e il gestore dell\'attività di confrontarsi. Se lo StudentQuiz ha impostato "Pubblica automaticamente le nuove domande" allora l\'autore delle domande non vedrà mai questa discussione. Rimane comunque a disposizione del gestore, che potrebbe utilizzarsi per spiegare i motivi di eventuali azioni (nascondere o eliminare) sulla domanda.';
$string['settings_questionquantifier'] = 'Fattore per le domande pubblicate';
$string['settings_questionquantifier_help'] = 'Punti per ogni domanda pubblicata';
$string['settings_questionquantifier_label'] = 'Punti per ogni domanda pubblicata';
$string['settings_ratequantifier'] = 'Fattore per la valutazione';
$string['settings_ratequantifier_help'] = 'Punti per ogni stella ricevuta';
$string['settings_ratequantifier_label'] = 'Moltiplicatore per la media di stelle ricevute per una domanda';
$string['settings_removeqbehavior'] = 'Rimuovi il plugin comportamento domanda StudentQuiz';
$string['settings_removeqbehavior_help'] = 'Questa informazioni dovrebbe apparire solamente una volta durante l\'aggiornamento. Ti informiamo che abbiamo notato che il plugin comportamento domanda StudentQuiz è installato. Questo plugin non è più richiesto e quindi proveremo a rimuoverlo automaticamente. Se continui a vedere questa impostazione, per favore disinstalla manualmente il plugin comportamento domanda StudentQuiz <a href="{$a}">qui</a>.';
$string['settings_removeqbehavior_label'] = 'Rimuovi il plugin comportamento domanda StudentQuiz';
$string['settings_reportingemail'] = 'Email per l\'invio delle segnalazioni per i commenti offensivi';
$string['settings_reportingemail_help'] = 'Se viene inserita questa email, allora comparirà il pulsante Segnala accanto a ogni commento. Gli utenti potranno usare questa funzionalità per segnalare commenti offensivi. Le informazioni saranno inviate a questo indirizzo.

Se questa email sarà lasciata vuota allora il pulsante Segnala non sarà mostrato (a meno che non sia fornito un indirizzo email a livello di sito).

Possono essere inserite più email, separate da un punto e virgola.';
$string['settings_section_description_default'] = 'Questi valori saranno utilizzati per la creazione di nuove attività StudentQuiz.';
$string['settings_section_header_comment_rating'] = 'Impostazioni dei commenti e delle valutazioni';
$string['settings_section_header_commenting'] = 'Impostazioni dei commenti';
$string['settings_section_header_question'] = 'Impostazioni delle domande';
$string['settings_section_header_ranking'] = 'Impostazioni delle valutazioni';
$string['settings_showprivatecomment'] = 'Abilita i commenti privati';
$string['settings_showprivatecomment_help'] = 'Questa impostazione abilita la possibilità di interazione tra studenti e tutor (o analogo ruolo in base all\'organizzazione) nell\'Anteprima della domanda.';
$string['settingsdeleteorphaned'] = 'Cancella domande orfane';
$string['settingsdeleteorphaned_help'] = 'Attiva un\'elaborazione programmata che viene eseguita tutti i giorni per cancellare dal database tutte le domande orfane o non approvate.';
$string['settingsdeleteorphanedtime1y'] = '1 anno';
$string['settingsdeleteorphanedtime2y'] = '2 anni';
$string['settingsdeleteorphanedtime3y'] = '3 anni';
$string['settingsdeleteorphanedtime6m'] = '6 mesi';
$string['settingsdeleteorphanedtimelimit'] = 'Limite di tempo per considerare una domanda orfana';
$string['settingsdeleteorphanedtimelimit_help'] = 'Imposta il limite di tempo per la cancellazione delle domande orfane o non approvate. Le domande più vecchie saranno cancellate.';
$string['show_less'] = 'Mostra meno';
$string['show_more'] = 'Mostra di più';
$string['slot_of_slot'] = 'Domanda {$a->slot} di {$a->slots} in questo gruppo';
$string['start_quiz_button'] = 'Inizia Quiz';
$string['state_approved'] = 'Approvata';
$string['state_approvedlowercase'] = 'approvata';
$string['state_approvedplural'] = 'Approvate';
$string['state_change_tooltip_approved'] = 'La domanda è approvata. Clicca qui per cambiare lo stato di questa domanda.';
$string['state_change_tooltip_changed'] = 'La domanda è cambiata. Clicca qui per cambiare lo stato di questa domanda.';
$string['state_change_tooltip_disapproved'] = 'La domanda è non approvata. Clicca qui per cambiare lo stato di questa domanda.';
$string['state_change_tooltip_new'] = 'La domanda è nuova. Clicca qui per cambiare lo stato di questa domanda.';
$string['state_change_tooltip_reviewable'] = 'La domanda è revisionabile. Clicca qui per cambiare lo stato di questa domanda.';
$string['state_changed'] = 'Modificata';
$string['state_changedlowercase'] = 'modificata';
$string['state_changedplural'] = 'Modificate';
$string['state_column_name'] = 'Stato';
$string['state_column_name_veryshort'] = 'S';
$string['state_deleted'] = 'Eliminata';
$string['state_deletedlowercase'] = 'eliminata';
$string['state_deletedplural'] = 'Eliminate';
$string['state_disapproved'] = 'Non approvata';
$string['state_disapprovedlowercase'] = 'non approvata';
$string['state_disapprovedplural'] = 'Non approvate';
$string['state_hidden'] = 'Nascosta';
$string['state_hiddenlowercase'] = 'nascosta';
$string['state_hiddenplural'] = 'Nascoste';
$string['state_new'] = 'Nuova';
$string['state_newplural'] = 'Nuove';
$string['state_pinned'] = 'Fissata';
$string['state_pinnedplural'] = 'Fissate';
$string['state_reviewable'] = 'Revisionabile';
$string['state_reviewablelowercase'] = 'revisionabile';
$string['state_reviewableplural'] = 'Revisionabili';
$string['state_shown'] = 'Mostrata';
$string['state_shownlowercase'] = 'mostrata';
$string['state_shownplural'] = 'Mostrate';
$string['state_toggle'] = 'Cambia stato';
$string['statehistory'] = 'Storico delle modifiche di stato';
$string['statistic_block_approvals'] = 'Domande approvate';
$string['statistic_block_created'] = 'Domande create';
$string['statistic_block_disapprovals'] = 'Domande non approvate';
$string['statistic_block_new_changed'] = 'Domande nuove/modificate';
$string['statistic_block_progress_available'] = 'Domande disponibili';
$string['statistic_block_progress_last_attempt_correct'] = 'Ultimo tentativo corretto';
$string['statistic_block_progress_last_attempt_incorrect'] = 'Ultimo tentativo sbagliato';
$string['statistic_block_progress_never'] = 'Domande senza risposta';
$string['statistic_block_title'] = 'Miei progressi';
$string['studentquiz'] = 'studentquiz';
$string['studentquiz:addinstance'] = 'Aggiungere una nuova istanza di StudentQuiz';
$string['studentquiz:cancommentprivately'] = 'Commentare privatamente ogni domanda';
$string['studentquiz:canselfcommentprivately'] = 'Commentare privatamente le proprie domande';
$string['studentquiz:canselfratecomment'] = 'Valutare e commentare pubblicamente le proprie domande nell\'anteprima';
$string['studentquiz:changestate'] = 'Impostare lo stato di una domande nello StudentQuiz';
$string['studentquiz:emailnotifyapproved'] = 'Essere notificati per una domanda approvata';
$string['studentquiz:emailnotifychanged'] = 'Essere notificati per una domanda modificata';
$string['studentquiz:emailnotifycommentadded'] = 'Essere notificati per un commento aggiunto';
$string['studentquiz:emailnotifycommentdeleted'] = 'Essere notificati per un commento eliminato';
$string['studentquiz:emailnotifyquestion'] = 'Ricevere una notifica per la modifica di stato di una propria domanda';
$string['studentquiz:emailnotifyreviewablequestion'] = 'Ricevere una notifica per la modifica di stato di una propria domanda a revisionabile';
$string['studentquiz:manage'] = 'Modifica ed eliminare le domande nello StudentQuiz';
$string['studentquiz:organize'] = 'Spostare le domande nelle categorie nello StudentQuiz';
$string['studentquiz:pinquestion'] = 'Fissare le domande nello StudentQuiz';
$string['studentquiz:preview'] = 'Effettuare l\'anteprima delle domande';
$string['studentquiz:previewothers'] = 'Effettuare l\'anteprima delle domande degli altri nello StudentQuiz';
$string['studentquiz:submit'] = 'Creare domande nello StudentQuiz';
$string['studentquiz:systemnotifytaskdeleteorphanedquestions'] = 'Essere notificati della cancellazione delle domande orfane';
$string['studentquiz:unhideanonymous'] = 'Vedere i nomi reali anche quando l\'anonimizzazione è attiva';
$string['studentquiz:view'] = 'Vedere e usare le domande nello StudentQuiz';
$string['studentquizname'] = 'Nome dello StudentQuiz';
$string['studentquizname_help'] = 'Il nome di questa attività StudentQuiz';
$string['submissionendbeforestart'] = 'La data di termine non può essere anteriore alla data di apertura';
$string['tags'] = 'Tag';
$string['unapprove'] = 'Disapprova';
$string['unpin'] = 'Togli domanda da quelle fissate';
$string['visiblegroupnotyetsupport'] = 'La modalità \'Gruppi visibili" non è ancora supportata. Per favore utilizza un\'altra modalità.';
$string['weekly'] = 'settimanale';
