<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'workshop', language 'af', version '4.2'.
 *
 * @package     workshop
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activitydate:assessmentsclose'] = 'Assesserings sluit:';
$string['activitydate:assessmentsclosed'] = 'Assesserings gesluit:';
$string['activitydate:assessmentsopen'] = 'Assesserings open:';
$string['activitydate:assessmentsopened'] = 'Assesserings geopen:';
$string['activitydate:submissionsclose'] = 'Indienings sluit:';
$string['activitydate:submissionsclosed'] = 'Indienings gesluit:';
$string['activitydate:submissionsopen'] = 'Indienings open:';
$string['activitydate:submissionsopened'] = 'Indienings geopen:';
$string['aggregategrades'] = 'Herbereken punte';
$string['aggregation'] = 'Puntaggregasie';
$string['allocate'] = 'Wys indienings toe';
$string['allocatedetails'] = 'verwag: {$a->expected}<br />ingedien: {$a->submitted}<br />vir toewysing: {$a->allocate}';
$string['allocation'] = 'Indieningtoewysing';
$string['allocationconfigured'] = 'Toewysing gekonfigureer';
$string['allocationdone'] = 'Toewysing gedoen';
$string['allocationerror'] = 'Toewysingsfout';
$string['allowedfiletypesforoverallfeedback'] = 'Terugvoeraanhangsel het lêertipes toegelaat';
$string['allowedfiletypesforoverallfeedback_help'] = 'Lêertipes vir terugvoeraanhangsels kan beperk word deur \'n lys van toegelate lêertipes te verskaf. As die veld leeg gelaat word, sal alle lêertipes toegelaat word.';
$string['allowedfiletypesforoverallfeedback_link'] = 'admin/tool/filetypes/index';
$string['allowedfiletypesforsubmission'] = 'Indieningsaanhangsel het lêertipes toegelaat';
$string['allowedfiletypesforsubmission_help'] = 'Lêertipes vir indieningsaanhangsels kan beperk word deur \'n lys van toegelate lêertipes te verskaf. As die veld leeg gelaat word, sal alle lêertipes toegelaat word.';
$string['allowedfiletypesforsubmission_link'] = 'admin/tool/filetypes/index';
$string['allsubmissions'] = 'Alle indienings ({$a})';
$string['alreadygraded'] = 'Reeds bepunt';
$string['areaconclusion'] = 'Gevolgtrekkingteks';
$string['areainstructauthors'] = 'Instruksies vir indiening';
$string['areainstructreviewers'] = 'Instruksies vir assessering';
$string['areaoverallfeedbackattachment'] = 'Oorhoofse terugvoeraanhangsels';
$string['areaoverallfeedbackcontent'] = 'Oorhoofse terugvoerteks';
$string['areasubmissionattachment'] = 'Indieningsaanhangsels';
$string['areasubmissioncontent'] = 'Indieningsteks';
$string['assess'] = 'Assesseer';
$string['assessedexample'] = 'Voorbeeld van geassesseerde indiening';
$string['assessedsubmission'] = 'Geassesseerde indiening';
$string['assessingexample'] = 'Assessering van voorbeeldindiening';
$string['assessingsubmission'] = 'Assessering van indiening';
$string['assessment'] = 'Assessering';
$string['assessmentby'] = 'deur <a href="{$a->url}">{$a->name}</a>';
$string['assessmentbyfullname'] = 'Assessering deur {$a}';
$string['assessmentbyyourself'] = 'Jou assessering';
$string['assessmentdeleted'] = 'Toewysing van assessering ontdoen';
$string['assessmentend'] = 'Keerdatum vir assessering';
$string['assessmentendbeforestart'] = 'Keerdatum vir assessering kan nie gespesifiseer word vóór die datum waarop assessering open nie';
$string['assessmentenddatetime'] = 'Assesseringkeerdatum: {$a->daydatetime} ({$a->distanceday})';
$string['assessmentendevent'] = '{$a} keerdatum vir assessering';
$string['assessmentform'] = 'Assesseringsvorm';
$string['assessmentofsubmission'] = '<a href="{$a->assessmenturl}">Assessering</a> van <a href="{$a->submissionurl}">{$a->submissiontitle}</a>';
$string['assessmentreference'] = 'Verwysende assessering';
$string['assessmentreferenceconflict'] = 'Dit is nie moontlik om \'n voorbeeldindiening waarvoor jy \'n verwysende assessering verskaf het, te assesseer nie.';
$string['assessmentreferenceneeded'] = 'Jy moet hierdie voorbeeldindiening assesseer ten einde \'n verwysende assessering te verskaf. Klik op "Gaan voort"-knoppie om hierdie indiening te assesseer.';
$string['assessments'] = 'Assesserings';
$string['assessmentsettings'] = 'Assesseringinstellings';
$string['assessmentstart'] = 'Maak oop vir assessering vanaf';
$string['assessmentstartdatetime'] = 'Maak oop vir assessering vanaf {$a->daydatetime} ({$a->distanceday})';
$string['assessmentstartevent'] = '{$a} maak oop vir assessering';
$string['assessmentweight'] = 'Assesseringsgewig';
$string['assignedassessments'] = 'Toegewese indienings om te assesseer';
$string['assignedassessmentsnone'] = 'Jy het geen toegewese indienings om te assesseer nie';
$string['backtoeditform'] = 'Terug na redigeringsvorm';
$string['byfullname'] = 'deur <a href="{$a->url}">{$a->name}</a>';
$string['byfullnamewithoutlink'] = 'deur {$a}';
$string['calculategradinggrades'] = 'Bereken assesseringspunte';
$string['calculategradinggradesdetails'] = 'verwag: {$a->expected}<br />bereken: {$a->calculated}';
$string['calculatesubmissiongrades'] = 'Bereken indieningspunte';
$string['calculatesubmissiongradesdetails'] = 'verwag: {$a->expected}<br />bereken: {$a->calculated}';
$string['chooseuser'] = 'Kies gebruiker...';
$string['clearaggregatedgrades'] = 'Wis alle geaggregeerde punte uit';
$string['clearaggregatedgrades_help'] = 'Die geaggregeerde punte vir indienings en punte vir assessering sal teruggestel word. Jy kan hierdie punte weer van vooraf in die Beputingevalueringsfase bereken.';
$string['clearaggregatedgradesconfirm'] = 'Is jy seker jy wil die berekende punte vir indienings en punte vir assessering uitwis.';
$string['clearassessments'] = 'Maak assesserings skoon';
$string['clearassessments_help'] = 'Die berekende punte vir indiening en punte vir assessering sal teruggestel word. Die inligting oor hoe die assesseringsvorm ingevul is, sal behoue bly maar alle beoordelaars sal die assesseringsvorm weer moet oopmaak en stoor sodat die toegekende punte weer bereken kan word.';
$string['clearassessmentsconfirm'] = 'Is jy seker jy wil alle assesseringspunte uitwis? Jy sal nie die inligting op jou eie kan herwin nie want beoordelaars sal die toegewese indienings weer moet assesseer.';
$string['conclusion'] = 'Gevolgtrekking';
$string['conclusion_help'] = 'Gevolgtrekkingteks word aan die einde van die aktiwiteit aan deelnemers gewys';
$string['configexamplesmode'] = 'Verstekmodus van voorbeeldassessering in werksessies';
$string['configgrade'] = 'Verstekmaksimumpunt vir indiening in werksessie';
$string['configgradedecimals'] = 'Aantal syfers wat by verstek gewys moet word ná die desimale punt wanneer punte gewys word';
$string['configgradinggrade'] = 'Verstekmaksimumpunt vir assessering in werksessie';
$string['configmaxbytes'] = 'Maksimum grootte van indieningslêers by verstek vir alle werksessies op die webwerf (onderworpe aan kursusperke en ander plaaslike instellings)';
$string['configstrategy'] = 'Verstekbepuntingstrategie vir werksessies';
$string['createsubmission'] = 'Voeg indiening by';
$string['crontask'] = 'Agtergrondbewerking vir werksessiemodule';
$string['daysago'] = '{$a} dae gelede';
$string['daysleft'] = '{$a} dae oor';
$string['daystoday'] = 'vandag';
$string['daystomorrow'] = 'more';
$string['daysyesterday'] = 'gister';
$string['deadlinesignored'] = 'Tydsbeperkings is nie op jou van toepassing nie';
$string['deletesubmission'] = 'Skrap indiening';
$string['editassessmentform'] = 'Redigeer assesseringsvorm';
$string['editassessmentformstrategy'] = 'Redigeer assesseringsvorm ({$a})';
$string['editingassessmentform'] = 'Redigering van assesseringsvorm';
$string['editingsubmission'] = 'Redigering van indiening';
$string['editsubmission'] = 'Redigeer indiening';
$string['err_multiplesubmissions'] = 'Onderwyl hierdie vorm geredigeer is, is \'n ander weergawe van die indiening gestoor. Multi-indienings per gebruiker word nie toegelaat nie.';
$string['err_removegrademappings'] = 'Kon nie die ongebruikte puntbindings verwyder nie';
$string['evaluategradeswait'] = 'Wag asseblief totdat die assesserings geëvalueer en die punte bereken is.';
$string['evaluation'] = 'Bepunting van evaluasies';
$string['evaluationmethod'] = 'Metode vir bepunting van evaluasies';
$string['evaluationmethod_help'] = 'Die bepuntingevalueringsmetode bepaal hoe die punt vir assessering bereken word. Jy kan dit toelaat om punte by herhaling met verskillende instellings te bereken tensy jy tevrede is met die resultaat.';
$string['evaluationsettings'] = 'Instellings vir bepunting van evaluasies';
$string['eventassessableuploaded'] = '\'n Indiening is opgelaai.';
$string['eventassessmentevaluated'] = 'Assessering geëvalueer';
$string['eventassessmentevaluationsreset'] = 'Stel assesseringevaluerings terug';
$string['eventassessmentreevaluated'] = 'Assessering herevalueer';
$string['eventphaseswitched'] = 'Fase oorgeskakel';
$string['eventsubmissionassessed'] = 'Indiening geassesseer';
$string['eventsubmissionassessmentsreset'] = 'Indieningassesserings gewis';
$string['eventsubmissioncreated'] = 'Indiening geskep';
$string['eventsubmissiondeleted'] = 'Indiening geskrap';
$string['eventsubmissionreassessed'] = 'Indiening herevalueer';
$string['eventsubmissionupdated'] = 'Indiening bygewerk';
$string['eventsubmissionviewed'] = 'Indiening bekyk';
$string['example'] = 'Voorbeeldindiening';
$string['exampleadd'] = 'Voeg voorbeeldindiening by';
$string['exampleassess'] = 'Assesseer voorbeeldindiening';
$string['exampleassessments'] = 'Voorbeeldindienings vir assessering';
$string['exampleassesstask'] = 'Assesseer voorbeelde';
$string['exampleassesstaskdetails'] = 'verwag: {$a->expected}<br />geassesseer: {$a->assessed}';
$string['examplecomparing'] = 'Vergelyking van voorbeeldindienings se assessering';
$string['exampledelete'] = 'Skrap voorbeeld';
$string['exampledeleteconfirm'] = 'Is jy seker jy wil die volgende voorbeeldindiening skrap? Klik "Gaan voort"-knoppie om die indiening te skrap.';
$string['exampleedit'] = 'Redigeer voorbeeld';
$string['exampleediting'] = 'Redigering van voorbeeld';
$string['exampleneedassessed'] = 'Jy moet eers alle voorbeeldindienings assesseer.';
$string['exampleneedsubmission'] = 'Jy moet jou werk indien en eers alle voorbeeldindienings assesseer.';
$string['examplesbeforeassessment'] = 'Voorbeelde is beskikbaar ná eie indiening en moet vóór portuurassessering geassesseer word.';
$string['examplesbeforesubmission'] = 'Voorbeelde moet vóór eie indiening geassesseer word';
$string['examplesmode'] = 'Modus vir assessering van voorbeelde';
$string['examplesubmissions'] = 'Voorbeeldindienings';
$string['examplesvoluntary'] = 'Assessering van voorbeeldindiening is vrywillig';
$string['exportsubmission'] = 'Eksporteer hierdie blad';
$string['feedbackauthor'] = 'Terugvoer vanaf outeur';
$string['feedbackauthorattachment'] = 'Aanhangsel';
$string['feedbackby'] = 'Terugvoer deur {$a}';
$string['feedbackreviewer'] = 'Terugvoer vir die beoordelaar';
$string['feedbacksettings'] = 'Terugvoer';
$string['formataggregatedgrade'] = '{$a->grade}';
$string['formataggregatedgradeover'] = '<del>{$a->grade}</del><br /><ins>{$a->over}</ins>';
$string['formatpeergrade'] = '<span class="grade">{$a->grade}</span> <span class="gradinggrade">({$a->gradinggrade})</span>';
$string['formatpeergradeover'] = '<span class="grade">{$a->grade}</span> <span class="gradinggrade">(<del>{$a->gradinggrade}</del> / <ins>{$a->gradinggradeover}</ins>)</span>';
$string['formatpeergradeoverweighted'] = '<span class="grade">{$a->grade}</span> <span class="gradinggrade">(<del>{$a->gradinggrade}</del> / <ins>{$a->gradinggradeover}</ins>)</span> @ <span class="weight">{$a->weight}</span>';
$string['formatpeergradeweighted'] = '<span class="grade">{$a->grade}</span> <span class="gradinggrade">({$a->gradinggrade})</span> @ <span class="weight">{$a->weight}</span>';
$string['givengrades'] = 'Punte toegeken';
$string['grade_grading_name'] = 'Assessering';
$string['grade_submission_name'] = 'Indiening';
$string['gradecalculated'] = 'Berekende punt vir indiening';
$string['gradedecimals'] = 'Desimale plekke in punte';
$string['gradegivento'] = '&gt;';
$string['gradeinfo'] = 'Punt: {$a->received} uit {$a->max}';
$string['gradeitemassessment'] = '{$a->workshopname} (assessering)';
$string['gradeitemsubmission'] = '{$a->workshopname} (indiening)';
$string['gradeover'] = 'Oorheers punt vir indiening';
$string['gradereceivedfrom'] = '&lt;';
$string['gradesreport'] = 'Werksessiepunteverslag';
$string['gradetopassgrading'] = 'Assesseringspunt om te slaag';
$string['gradetopasssubmission'] = 'Indieningspunt om te slaag';
$string['gradinggrade'] = 'Punt vir assessering';
$string['gradinggrade_help'] = 'Hierdie instelling spesifiseer die maksimum punt wat vir indieningassessering behaal kan word.';
$string['gradinggradecalculated'] = 'Berekende punt vir assessering';
$string['gradinggradeof'] = 'Punt vir assessering (uit {$a})';
$string['gradinggradeover'] = 'Oorheers punt vir assessering';
$string['gradingsettings'] = 'Bepuntingsinstellings';
$string['groupnoallowed'] = 'Jy word nie toegelaat om enige groep in hierdie werksessie te betree nie';
$string['iamsure'] = 'Ja, ek is seker';
$string['indicator:cognitivedepth'] = 'Werksessie kognitief';
$string['indicator:cognitivedepth_help'] = 'Hierdie aanwyser is gegrond op die kognitiewe diepte wat die student in \'n werksessie-aktiwiteit behaal het.';
$string['indicator:cognitivedepthdef'] = 'Werksessie kognitief';
$string['indicator:cognitivedepthdef_help'] = 'Die deelnemer het tydens hierdie ontledingsinterval hierdie persentasie van die kognitiewe betrokkenheid bereik wat deur die werksessie-aktiwiteite aangebied word (Vlakke = Nie bekyk nie, Bekyk, Ingedien, Terugvoer bekyk, Kommentaar op terugvoer, Herindiening nadat terugvoer bekyk is)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Werksessie sosiaal';
$string['indicator:socialbreadth_help'] = 'Hierdie aanwyser is gegrond op die sosiale omvang wat deur die student in \'n werksessie-aktiwiteit bereik is.';
$string['indicator:socialbreadthdef'] = 'Werksessie sosiaal';
$string['indicator:socialbreadthdef_help'] = 'Die deelnemer het tydens hierdie ontledingsinterval hierdie persentasie van die sosiale betrokkenheid bereik wat deur die werksessie-aktiwiteite aangebied word (Vlakke = Geen deelname nie, Slegs deelnemer, Deelnemer saam met ander)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['info'] = 'Info';
$string['instructauthors'] = 'Instruksies vir indiening';
$string['instructreviewers'] = 'Instruksies vir assessering';
$string['introduction'] = 'Beskrywing';
$string['latesubmissions'] = 'Laatindienings';
$string['latesubmissions_desc'] = 'Laat indienings ná die keerdatum toe';
$string['latesubmissions_help'] = 'Indien geaktiveer kan outeurs hul werk ná die indieningskeerdatum of gedurende die assesseringsfase indien. Laatindienings kan egter nie geredigeer word nie.';
$string['latesubmissionsallowed'] = 'Laatindienings word toegelaat';
$string['legacyallocationplugincron'] = 'Argaïese cron-werksessietoewysing';
$string['maxbytes'] = 'Maksimum grootte van indieningaanhangsels';
$string['modulename'] = 'Werksessie';
$string['modulename_help'] = 'Die module werksessie-aktiwiteite maak dit moontlik om studente se werk in te samel, te hersien en aan portuurassessering te onderwerp.

Studente kan enige digitale inhoud (lêers) soos woordverwerkingsdokumente of sigblaaie indien en kan ook teks direk in \'n veld intik deur die teksredigeerder te gebruik.

Indienings word geassesseer deur gebruik te maak van \'n multikriteria-assesseringsvorm wat deur die onderwyser omskryf word. Die portuurassesseringsproses en begrip van die assesseringsvorm kan vooraf ingeoefen word met voorbeeldindienings wat deur die onderwyser, tesame met \'n verwysende assessering, voorsien word. Studente word die geleentheid gebied om een of meer van hul eweknieë se indienings te assesseer. Indien verlang, kan indienings en beoordelaars anoniem wees.

Studente verwerf twee punte in \'n werksessie-aktiwiteit - \'n punt vir hul indiening en \'n punt vir hul assessering van hul eweknieë se indienings. Beide punte word in die punteboek aangeteken.';
$string['modulename_link'] = 'mod/workshop/view';
$string['modulenameplural'] = 'Werksessies';
$string['myassessments'] = 'My assesserings';
$string['mysubmission'] = 'My indiening';
$string['nattachments'] = 'Maksimum aantal indieningsaanhangsels';
$string['noexamples'] = 'Nog geen voorbeelde vir hierdie werksessie nie';
$string['noexamplesformready'] = 'Jy moet die assesseringsvorm omskryf voordat voorbeeldindienings verskaf word';
$string['nogradeyet'] = 'Nog geen punt nie';
$string['nosubmissionfound'] = 'Geen indiening vir hierdie gebruiker gevind nie';
$string['nosubmissions'] = 'Nog geen indienings in hierdie werksessie nie';
$string['nosubmissiontype'] = 'Ten minste een tipe indiening moet beskikbaar wees';
$string['notassessed'] = 'Nog nie geassesseer nie';
$string['nothingfound'] = 'Niks om te wys nie';
$string['nothingtoreview'] = 'Niks om te beoordeel nie';
$string['notoverridden'] = 'Nie oorheers nie';
$string['noworkshops'] = 'Daar is geen werksessies in hierdie kursus nie';
$string['noyoursubmission'] = 'Jy het nog nie jou werk ingedien nie';
$string['nullgrade'] = '-';
$string['overallfeedback'] = 'Algehele terugvoer';
$string['overallfeedbackfiles'] = 'Maksimum aantal aanhangsels vir algehele terugvoer';
$string['overallfeedbackmaxbytes'] = 'Maksimum grootte van aanhangsels vir algehele terugvoer';
$string['overallfeedbackmode'] = 'Modus vir algehele terugvoer';
$string['overallfeedbackmode_0'] = 'Gedeaktiveer';
$string['overallfeedbackmode_1'] = 'Geaktiveer en opsioneel';
$string['overallfeedbackmode_2'] = 'Geaktiveer en vereis';
$string['overallfeedbackmode_help'] = 'Indien geaktiveer word \'n teksveld onderaan die assesseringsvorm gewys. Beoordelaars kan die algehele assessering van die indiening daar plaas, of \'n addisionele verduideliking vir hul assessering verskaf.';
$string['page-mod-workshop-x'] = 'Enige blad van die werksessiemodule';
$string['participant'] = 'Deelnemer';
$string['participantrevierof'] = 'Deelnemer is beoordelaar van';
$string['participantreviewedby'] = 'Deelnemer word beoordeel deur';
$string['phaseassessment'] = 'Assesseringsfase';
$string['phaseclosed'] = 'Gesluit';
$string['phaseevaluation'] = 'Bepuntingevalueringsfase';
$string['phasesetup'] = 'Opstellingsfase';
$string['phasesoverlap'] = 'Die indieningsfase en die assesseringsfase kan nie oorvleuel nie.';
$string['phasesubmission'] = 'Indieningsfase';
$string['pluginadministration'] = 'Werksessie-administrasie';
$string['pluginname'] = 'Werksessie';
$string['prepareexamples'] = 'Berei voorbeeldindienings voor';
$string['previewassessmentform'] = 'Voorskou';
$string['privacy:metadata:aggregatedgradinggrade'] = 'Aggregaatpunt vir alle assesserings wat deur die gebruiker in die gegewe werksessie-aktiwiteit verskaf is';
$string['privacy:metadata:assessmentgrade'] = 'Aggregaatpunt vir die indiening wat deur hierdie assessering aan die hand gedoen word';
$string['privacy:metadata:assessmentgradinggrade'] = 'Punt vir verskaffing van hierdie assessering';
$string['privacy:metadata:assessmentgradinggradeover'] = 'Waarde van die punt vir verskaffing van hierdie assessering wat handmatig oorheers is';
$string['privacy:metadata:assessmentid'] = 'ID van die assessering';
$string['privacy:metadata:authorid'] = 'ID van die indieningsouteur';
$string['privacy:metadata:dimensiongrade'] = 'Punt in die gegewe assesseringsdimensie';
$string['privacy:metadata:dimensionid'] = 'ID van die assesseringsdimensie';
$string['privacy:metadata:example'] = 'Of hierdie rekord \'n voorbeeldindiening verteenwoordig';
$string['privacy:metadata:feedbackauthor'] = 'Terugvoer vanaf die outeur';
$string['privacy:metadata:feedbackauthorformat'] = 'Teksformaat van die terugvoer vir die outeur';
$string['privacy:metadata:feedbackreviewer'] = 'Terugvoer vir die gebruiker wat die assessering verskaf';
$string['privacy:metadata:feedbackreviewerformat'] = 'Teksformaat van die terugvoer vir die gebruiker wat die assessering verskaf';
$string['privacy:metadata:late'] = 'Of die indiening ná die keerdatum ingedien is';
$string['privacy:metadata:peercomment'] = 'Kommentaar op die toegekende punt deur die gebruiker wat die assessering verskaf';
$string['privacy:metadata:peercommentformat'] = 'Teksformaat van die kommentaar op die toegekende punt';
$string['privacy:metadata:preference:perpage'] = 'Getal indienings wat die gebruiker verkies om op een blad te sien';
$string['privacy:metadata:preference:viewlet-allexamples-collapsed'] = 'Die toegevoude/uitgevoude stand van die venstertjie "Voorbeeldindienings"';
$string['privacy:metadata:preference:viewlet-allsubmissions-collapsed'] = 'Die toegevoude/uitgevoude stand van die venstertjie "Werksessie-indieningsverslag"';
$string['privacy:metadata:preference:viewlet-assessmentform-collapsed'] = 'Die toegevoude/uitgevoude stand van die venstertjie "Assesseringsvorm"';
$string['privacy:metadata:preference:viewlet-assignedassessments-collapsed'] = 'Die toegevoude/uitgevoude stand van die venstertjie "Toegewese indienings vir assessering"';
$string['privacy:metadata:preference:viewlet-cleargrades-collapsed'] = 'Die toegevoude/uitgevoude stand van die venstertjie "Werksessienutsgoed"';
$string['privacy:metadata:preference:viewlet-conclusion-collapsed'] = 'Die toegevoude/uitgevoude stand van die venstertjie "Slotsom"';
$string['privacy:metadata:preference:viewlet-examples-collapsed'] = 'Die toegevoude/uitgevoude stand van die venstertjie "Voorbeeldindienings vir assessering"';
$string['privacy:metadata:preference:viewlet-examplesfail-collapsed'] = 'Die toegevoude/uitgevoude stand van die venstertjie "Voorbeeldindienings vir assessering"';
$string['privacy:metadata:preference:viewlet-gradereport-collapsed'] = 'Die toegevoude/uitgevoude stand van die venstertjie "Werksessie-punteverslag"';
$string['privacy:metadata:preference:viewlet-instructauthors-collapsed'] = 'Die toegevoude/uitgevoude stand van die venstertjie "Instruksies vir indiening"';
$string['privacy:metadata:preference:viewlet-instructreviewers-collapsed'] = 'Die toegevoude/uitgevoude stand van die venstertjie "Instruksies vir assessering"';
$string['privacy:metadata:preference:viewlet-intro-collapsed'] = 'Die toegevoude/uitgevoude stand van die venstertjie "Intro"';
$string['privacy:metadata:preference:viewlet-overallfeedback-collapsed'] = 'Die toegevoude/uitgevoude stand van die venstertjie "Algehele terugvoer"';
$string['privacy:metadata:preference:viewlet-ownsubmission-collapsed'] = 'Die toegevoude/uitgevoude stand van die venstertjie "Jou indiening"';
$string['privacy:metadata:preference:viewlet-publicsubmissions-collapsed'] = 'Die toegevoude/uitgevoude stand van die venstertjie "Gepubliseerde indienings"';
$string['privacy:metadata:preference:viewlet-yourgrades-collapsed'] = 'Die toegevoude/uitgevoude stand van die venstertjie "Jou punte"';
$string['privacy:metadata:published'] = 'Of die indiening vir alle deelnemers gepubliseer moet word wanneer die werksessie gesluit het';
$string['privacy:metadata:reviewerid'] = 'ID van die gebruiker wat die assessering verskaf';
$string['privacy:metadata:strategy'] = 'Naam van die subinprop vir die bepuntingstrategie wat rekordwaardes interpreteer';
$string['privacy:metadata:submissioncontent'] = 'Inhoud van die indiening';
$string['privacy:metadata:submissioncontentformat'] = 'Teksformaat van die indiening se inhoud';
$string['privacy:metadata:submissiongrade'] = 'Aggregaatpunt vir die indiening geskryf as \'n desimale syfer vanaf interval 0.. 100';
$string['privacy:metadata:submissiongradeover'] = 'Waarde van die aggregaatpunt wat handmatig oorheers is';
$string['privacy:metadata:submissionid'] = 'ID van die indiening';
$string['privacy:metadata:submissiontitle'] = 'Titel van die indiening';
$string['privacy:metadata:subsystem:corefiles'] = 'Werksessiemodule stoor lêers wat ingebed is in / aangeheg is aan die indieningsteks';
$string['privacy:metadata:subsystem:coreplagiarism'] = 'Werksessiemodule het ingeboude ondersteuningstelsels om plagiaat te voorkom';
$string['privacy:metadata:timeaggregated'] = 'Wanneer die aggregaatpunt laas bereken is';
$string['privacy:metadata:timecreated'] = 'Wanneer hierdie rekord in die databasis geskep is';
$string['privacy:metadata:timemodified'] = 'Wanneer hierdie rekord laas in die databasis gewysig is';
$string['privacy:metadata:userid'] = 'ID van die gebruiker vir wie die aggregaatpunt bereken is';
$string['privacy:metadata:weight'] = 'Gewig van die assessering';
$string['privacy:metadata:workshopaggregations'] = 'Behou aggregaatpunte vir assessering';
$string['privacy:metadata:workshopassessments'] = 'Behou inligting oor toegewese assesserings van werksessiemodule-indienings';
$string['privacy:metadata:workshopgrades'] = 'Behou inligting oor hoe punte en kommentaar op die assesseringsvorm ingevul is';
$string['privacy:metadata:workshopid'] = 'ID van die werksessie-aktiwiteit';
$string['privacy:metadata:workshopsubmissions'] = 'Behou inligting oor werksessiemodule-indienings';
$string['privacy:request:delete:content'] = 'Die inhoud is geskrap (deur die gebruiker versoek of het verstryk)';
$string['privacy:request:delete:title'] = '[Geskrap]';
$string['publishedsubmissions'] = 'Gepubliseerde indienings';
$string['publishsubmission'] = 'Publiseer indiening';
$string['publishsubmission_help'] = 'Gepubliseerde indienings is tot ander gebruikers se beskikking wanneer die werksessie gesluit het.';
$string['reassess'] = 'Herassesseer';
$string['receivedgrades'] = 'Punte ontvang';
$string['recentassessments'] = 'Werksessie-assesserings:';
$string['recentsubmissions'] = 'Werksessie-indienings:';
$string['resetassessments'] = 'Skrap alle assesserings';
$string['resetassessments_help'] = 'Jy kan kies om assesserings wat pas toegewys is, te skrap sonder dat dit \'n impak op indienings het. Indien indienings geskrap moet word, sal hul assesserings implisiet geskrap word en word hierdie opsie geïgnoreer. Let daarop dat dit ook assesserings van voorbeeldindienings insluit.';
$string['resetphase'] = 'Verwissel na opstelfase';
$string['resetphase_help'] = 'Indien geaktiveer sal alle werksessies in die aanvanklike opstelfase geplaas word.';
$string['resetsubmissions'] = 'Skrap alle indienings';
$string['resetsubmissions_help'] = 'Al die indienings en hul assesserings sal geskrap word. Dit het geen impak op voorbeeldindienings nie.';
$string['saveandclose'] = 'Stoor en maak toe';
$string['saveandcontinue'] = 'Stoor en gaan voort met redigering';
$string['saveandpreview'] = 'Stoor en kry voorskou';
$string['saveandshownext'] = 'Stoor en wys volgende';
$string['search:activity'] = 'Werksessie - aktiwiteitinligting';
$string['selfassessmentdisabled'] = 'Selfassessering versper';
$string['showingperpage'] = 'Wys tans {$a} per blad';
$string['showingperpagechange'] = 'Verander ...';
$string['someuserswosubmission'] = 'Daar is ten minste een outeur wat nog nie sy/haar werk ingedien het nie';
$string['sortasc'] = 'Stygende ordening';
$string['sortdesc'] = 'Dalende ordening';
$string['strategy'] = 'Bepuntingstrategie';
$string['strategy_help'] = 'Die bepuntingstrategie bepaal die assesseringsvorm wat gebruik word en die metode waarvolgens punte ingedien word. Daar is 4 opsies:

* Kumulatiewe bepunting - Kommentaar en \'n punt word gegee ten opsigte van gespesifiseerde aspekte
* Kommentaar - Kommentaar word gegee ten opsigte van gespesifiseerde aspekte maar geen punt kan gegee word nie
* Getal foute - Kommentaar en \'n "ja/nee"-assessering word gegee ten opsigte van gespesifiseerde aannames
* Rubriek - \'n Vlakassessering word gegee ten opsigte van gespesifiseerde kriteria';
$string['strategyhaschanged'] = 'Die bepuntingstrategie vir die werksessie het verander sedert die vorm laas vir redigering oopgemaak is.';
$string['submission'] = 'Indiening';
$string['submissionattachment'] = 'Aanhangsel';
$string['submissionby'] = 'Indiening deur {$a}';
$string['submissioncontent'] = 'Indieningsinhoud';
$string['submissiondeleteconfirm'] = 'Is jy seker jy wil die volgende indiening skrap?';
$string['submissiondeleteconfirmassess'] = 'Is jy seker jy wil die volgende indiening skrap? Let daarop dat dit ook {$a->count} assesserings sal skrap wat met hierdie indiening geassosieer word, wat dalk \'n impak op die hersieners se punte kan hê.';
$string['submissionend'] = 'Indieningkeerdatum';
$string['submissionendbeforestart'] = 'Indieningkeerdatum kan nie vóór die "oop vir indiening"-datum gespesifiseer word nie';
$string['submissionenddatetime'] = 'Indieningkeerdatum: {$a->daydatetime} ({$a->distanceday})';
$string['submissionendevent'] = '{$a} keerdatum vir indienings';
$string['submissionendswitch'] = 'Verwissel na die volgende fase ná die indieningskeerdatum';
$string['submissionendswitch_help'] = 'As die keerdatum vir indienings gespesifiseer is en hierdie blokkie gemerk is, sal die werksessie outomaties na die assesseringsfase oorskakel ná die indieningskeerdatum.

As jy hierdie kenmerk aktiveer, word daar aanbeveel om ook die geskeduleerde toewysingsmetode op te stel. As die indienings nie toegewys is nie, kan geen assessering gedoen word nie selfs al is die werksessie in die assesseringsfase.';
$string['submissiongrade'] = 'Punt vir indiening';
$string['submissiongrade_help'] = 'Hierdie instelling spesifiseer die maksimum punt wat vir ingediende werk behaal kan word.';
$string['submissiongradeof'] = 'Punt vir indiening (van {$a})';
$string['submissionlastmodified'] = 'Laas gewysig';
$string['submissionrequiredcontent'] = 'Jy moet teks intik of \'n lêer byvoeg.';
$string['submissionrequiredfile'] = 'Jy moet \'n lêer byvoeg of teks intik.';
$string['submissionsettings'] = 'Indieninginstellings';
$string['submissionsreport'] = 'Verslag oor werksessie-indienings';
$string['submissionstart'] = 'Oop vir indiening vanaf';
$string['submissionstartdatetime'] = 'Oop vir indiening vanaf {$a->daydatetime} ({$a->distanceday})';
$string['submissionstartevent'] = '{$a} open vir indienings';
$string['submissiontitle'] = 'Titel';
$string['submissiontypedisabled'] = 'Hierdie tipe indiening is versper vir hierdie werksessie.';
$string['submissiontypefileavailable'] = 'Lêeraanhangsel<span class="accesshide"> beskikbaar</span>';
$string['submissiontypefilerequired'] = '<span class="accesshide">Lêeraanhangsel </span>Verlang';
$string['submissiontypes'] = 'Indieningstipes';
$string['submissiontypetextavailable'] = 'Aanlynteks<span class="accesshide"> beskikbaar</span>';
$string['submissiontypetextrequired'] = '<span class="accesshide">Aanlynteks</span>Verlang';
$string['submittednotsubmitted'] = 'Ingedien ({$a->submitted}) / nie ingedien nie ({$a->notsubmitted})';
$string['subplugintype_workshopallocation'] = 'Toewysingsmetode vir indienings';
$string['subplugintype_workshopallocation_plural'] = 'Toewysingsmetodes vir indienings';
$string['subplugintype_workshopeval'] = 'Evalueringsmetode vir bepunting';
$string['subplugintype_workshopeval_plural'] = 'Evalueringsmetodes vir bepunting';
$string['subplugintype_workshopform'] = 'Bepuntingstrategie';
$string['subplugintype_workshopform_plural'] = 'Bepuntingstrategieë';
$string['switchingphase'] = 'Skakelingsfase';
$string['switchphase'] = 'Skakelfase';
$string['switchphase10'] = 'Skakel oor na die opstellingsfase';
$string['switchphase10info'] = 'Jy staan op die punt om die werksessie na die <strong>Opstellingsfase</strong> oor te skakel. In hierdie fase kan gebruikers nie hul indienings of hul assesserings wysig nie. Onderwysers kan hierdie fase gebruik om werksessie-instellings te verander, die bepuntingstrategie te wysig of verstellings aan assesseringsvorms te maak.';
$string['switchphase20'] = 'Skakel oor na die indieningsfase';
$string['switchphase20info'] = 'Jy staan op die punt om die werksessie na die <strong>Indieningsfase</strong> oor te skakel. Studente kan hul werk gedurende hierdie fase indien (binne die toegangsbeheerdatums wat, waar van toepassing, vir indiening gestel is). Onderwysers kan indienings vir portuurhersiening toewys.';
$string['switchphase30'] = 'Skakel oor na die assesseringsfase';
$string['switchphase30auto'] = 'Werksessie sal outomaties oorskakel na die assesseringsfase ná {$a->daydatetime} ({$a->distanceday})';
$string['switchphase30info'] = 'Jy staan op die punt om die werksessie na die <strong>Assesseringsfase</strong> oor te skakel. In hierdie fase kan beoordelaars die indienings assesseer wat aan hulle toegewys is (binne die toegangsbeheerdatums wat, waar van toepassing, vir assessering gestel is).';
$string['switchphase40'] = 'Skakel oor na die evalueringsfase';
$string['switchphase40info'] = 'Jy staan op die punt om die werksessie na die <strong>Bepuntingevalueringsfase</strong> oor te skakel. In hierdie fase kan gebruikers nie hul indienings of assesserings wysig nie. Onderwysers kan die hulpmiddel vir bepuntingsevaluering gebruik om finale punte te bereken en terugvoer aan beoordelaars te verskaf.';
$string['switchphase50'] = 'Sluit werksessie';
$string['switchphase50info'] = 'Jy staan op die punt om die werksessie te sluit. Dit sal daartoe aanleiding gee dat berekende punte in die punteboek verskyn. Studente kan hul indienings en hul indieningassesserings bekyk.';
$string['switchphaseauto'] = 'Skakeling is geskeduleer';
$string['switchphasenext'] = 'Skakel oor na die volgende fase';
$string['taskassesspeers'] = 'Assesseer portuurgroep';
$string['taskassesspeersdetails'] = 'totaal: {$a->total}<br />onafgehandel: {$a->todo}';
$string['taskassessself'] = 'Assesseer jouself';
$string['taskconclusion'] = 'Verskaf \'n gevolgtrekking vir die aktiwiteit';
$string['taskdone'] = 'Taak gedoen';
$string['taskfail'] = 'Taak gedruip';
$string['taskinfo'] = 'Taakinfo';
$string['taskinstructauthors'] = 'Verskaf instruksies vir indiening';
$string['taskinstructreviewers'] = 'Verskaf instruksies vir assessering';
$string['taskintro'] = 'Stel die werksessiebeskrywing';
$string['tasksubmit'] = 'Dien jou werk in';
$string['tasktodo'] = 'Taak wat gedoen moet word';
$string['toolbox'] = 'Werksessienutsgoed';
$string['undersetup'] = 'Die werksessie word tans opgestel. Wag asseblief totdat dit na die volgende fase oorskakel.';
$string['useexamples'] = 'Gebruik voorbeelde';
$string['useexamples_desc'] = 'Voorbeeldindienings word verskaf vir inoefening van assessering';
$string['useexamples_help'] = 'Indien geaktiveer kan gebruikers probeer om toegang te verkry tot een of meer voorbeeldindienings en hul assessering met \'n verwysingsassessering vergelyk. Die punt tel nie in die punt vir assessering nie.';
$string['usepeerassessment'] = 'Gebruik eweknie-assessering';
$string['usepeerassessment_desc'] = 'Studente kan ander se werk assesseer';
$string['usepeerassessment_help'] = 'Indien geaktiveer kan ander gebruikers indienings vir assessering aan \'n gebruiker toewys en daardie gebruiker sal \'n punt vir assessering bo en behalwe \'n punt vir sy/haar eie indiening ontvang.';
$string['userdatecreated'] = 'ingedien op <span>{$a}</span>';
$string['userdatemodified'] = 'gewysig op <span>{$a}</span>';
$string['userplan'] = 'Werksessiebeplanner';
$string['userplan_help'] = 'Die werksessiebeplanner wys alle fases van die aktiwiteit en lys die take vir elke fase. Die huidige fase word uitgelig en taakvoltooiing word met \'n regmerkie aangetoon.';
$string['userplanaccessibilityskip'] = 'Spring na huidige take';
$string['userplanaccessibilitytitle'] = 'Werksessietydlyn met {$a} fases';
$string['userplancurrentphase'] = 'Huidige fase';
$string['useselfassessment'] = 'Gebruik selfassessering';
$string['useselfassessment_desc'] = 'Studente kan hul eie werk assesseer';
$string['useselfassessment_help'] = 'Indien geaktiveer kan \'n gebruiker hul eie indienings vir assessering toewys en sal \'n punt vir assessering bo en behalwe \'n punt vir sy/haar eie indiening ontvang.';
$string['viewworkshopsummary'] = 'Bekyk werksessie-opsomming';
$string['weightinfo'] = 'Gewig: {$a}';
$string['withoutsubmission'] = 'Beoordelaar sonder eie indiening';
$string['workshop:addinstance'] = 'Voeg \'n nuwe werksessie by';
$string['workshop:allocate'] = 'Wys indienings vir hersiening toe';
$string['workshop:deletesubmissions'] = 'Skrap indienings';
$string['workshop:editdimensions'] = 'Redigeer assesseringsvorms';
$string['workshop:exportsubmissions'] = 'Eksporteer indienings';
$string['workshop:ignoredeadlines'] = 'Ignoreer tydsbeperkings';
$string['workshop:manageexamples'] = 'Bestuur voorbeeldindienings';
$string['workshop:overridegrades'] = 'Oorheers berekende punte';
$string['workshop:peerassess'] = 'Portuurassessering';
$string['workshop:publishsubmissions'] = 'Publiseer indienings';
$string['workshop:submit'] = 'Dien in';
$string['workshop:switchphase'] = 'Skakel fase oor';
$string['workshop:view'] = 'Bekyk werksessie';
$string['workshop:viewallassessments'] = 'Bekyk alle assesserings';
$string['workshop:viewallsubmissions'] = 'Bekyk alle indienings';
$string['workshop:viewauthornames'] = 'Bekyk outeurname';
$string['workshop:viewauthorpublished'] = 'Bekyk outeurs van gepubliseerde indienings';
$string['workshop:viewpublishedsubmissions'] = 'Bekyk gepubliseerde indienings';
$string['workshop:viewreviewernames'] = 'Bekyk hersienername';
$string['workshopname'] = 'Werksessie se naam';
$string['yourassessmentfor'] = 'Jou assessering vir {$a}';
$string['yourgrades'] = 'Jou punte';
$string['yoursubmission'] = 'Jou indiening';
$string['yoursubmissionwithassessments'] = 'Jou indiening met assesserings';
