<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'webservice', language 'sk', version '4.2'.
 *
 * @package     webservice
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessexception'] = 'Výnimka v riadení prístupu';
$string['actwebserviceshhdr'] = 'Aktívne protokoly web služieb';
$string['addaservice'] = 'Pridať službu';
$string['addcapabilitytousers'] = 'Skontrolovať schopnosť používateľov';
$string['addcapabilitytousersdescription'] = 'Používatelia by mali mať dve právomoci - webservice:createtoken a právomoc porovnávať použité protokoly, napríklad webservice/rest:use, webservice/soap:use. Aby to bolo možné dosiahnuť, vytvorte rolu webovej služby s povolenými príslušnými právomocami a priraďte ju používateľovi webových služieb ako systémovú rolu.';
$string['addexternalservice'] = 'Pridať externú službu';
$string['addfunction'] = 'Pridať funkciu';
$string['addfunctionhelp'] = 'Vybrať funkciu, ktorá bude pridaná k službe';
$string['addfunctions'] = 'Pridať funkcie';
$string['addfunctionsdescription'] = 'Vybrať požadovanú funkciu pre novo vytvorenú službu.';
$string['addrequiredcapability'] = 'Priradiť/Odobrať požadovanú schopnosť';
$string['addservice'] = 'Pridať novú službu: {$a->name} (identifikátor: {$a->id})';
$string['addservicefunction'] = 'Pridať funkcie k službe "{$a}"';
$string['allusers'] = 'Všetci používatelia';
$string['apiexplorer'] = 'API preskumík';
$string['apiexplorernotavalaible'] = 'API prieskumník ešte nie je dostupný.';
$string['arguments'] = 'Parametre';
$string['authmethod'] = 'Metóda autentifikácie';
$string['callablefromajax'] = 'Volatelný z AJAX-u';
$string['cannotcreatetoken'] = 'Žiadne povolenia na vytvorenie tokenu webovej služby pre službu {$a}.';
$string['cannotgetcoursecontents'] = 'Nie je možné získať obsah kurzu';
$string['checkusercapability'] = 'Skontrolovať schopnosti používateľa';
$string['checkusercapabilitydescription'] = 'Používateľ by mal mať príslušné právomoci podľa použitých protokolov, napr. webservice/rest:use, webservice/soap:use. Aby to bolo možné dosiahnuť, vytvorte rolu webovej služby s povolenými protokolovými schopnosťami a priraďte ju používateľovi webových služieb ako systémovú rolu.';
$string['configwebserviceplugins'] = 'Z bezpečnostných dôvodov by mali byť povolené iba protokoly, ktoré sa používajú.';
$string['context'] = 'Kontext';
$string['createservicedescription'] = 'Služba je súbor funkcií webovej služby. Povolíte používateľovi pristupovať k novej službe. Na stránke <strong>Pridať službu</strong> označte možnosti \'Aktivovať\' a \'Oprávnení používatelia\'. Zvoľte \'Žiadna povinná schopnosť\'.';
$string['createserviceforusersdescription'] = 'Služba je súbor funkcií webovej služby. Povolíte používateľom pristupovať k novej službe. Na stránke <strong>Pridať službu</strong> označte možnosti \'Aktivovať\' a \'Oprávnení používatelia\'. Zvoľte \'Žiadna povinná schopnosť\'.';
$string['createtoken'] = 'Vytvoriť token';
$string['createtokenforuser'] = 'Vytvoriť token pre používateľa';
$string['createtokenforuserdescription'] = 'Vytvoriť token pre používateľa web služieb.';
$string['createuser'] = 'Vytvoriť špecifického používateľa';
$string['createuserdescription'] = 'Používateľ webovej služby je povinný fungovať v systéme kontrolovateľnom cez Moodle.';
$string['criteriaerror'] = 'Chýbajúce oprávnenia pre vyhľadávanie kritéria.';
$string['default'] = 'Východzia hodnota je "{$a}"';
$string['deleteaservice'] = 'Vymazať službu';
$string['deleteservice'] = 'Vymazať službu: {$a->name} (identifikátor: {$a->id})';
$string['deleteserviceconfirm'] = 'Odstránenie služby tiež odstráni tokeny vzťahujúce sa k tejto službe. Naozaj chcete odstrániť externú službu "{$a}"?';
$string['deletetoken'] = 'Odstrániť token';
$string['deletetokenconfirm'] = 'Naozaj chcete odstrániť tento token webové služby <strong>{$a->user}</strong> pre službu <strong>{$a->service}</strong>?';
$string['deprecated'] = 'Zastarané';
$string['disabledwarning'] = 'Všetky protokoly webovej služby sú deaktivované. Nastavenie "Aktivovať webové služby" možno nájsť v Pokročilých vlastnostiach.';
$string['doc'] = 'Dokumentácia';
$string['docaccessrefused'] = 'Nemáte oprávnenie vidieť dokumentáciu pre tento token';
$string['downloadfiles'] = 'Môže sťahovať súbory';
$string['downloadfiles_help'] = 'Ak je povolené, môže každý používateľ sťahovať súbory so svojimi bezpečnostnými kľúčmi. Samozrejme, že sú obmedzené na súbory na webe, ktoré majú oprávnenia na stiahnutie.ke stažení.';
$string['editaservice'] = 'Upraviť službu';
$string['editexternalservice'] = 'Upraviť externú službu';
$string['editservice'] = 'Upraviť službu: {$a->name} (identifikátor: {$a->id})';
$string['enabled'] = 'Povolený';
$string['enabledocumentation'] = 'Povoliť dokumentáciu vývojára';
$string['enabledocumentationdescription'] = 'Podrobná dokumentácia webových služieb je dostupná pre aktivované protokoly.';
$string['enableprotocols'] = 'Povoliť protokoly';
$string['enableprotocolsdescription'] = 'Aspoň jeden protokol by mal byť aktivovaný. Z bezpečnostných dôvodov by mali byť aktivované iba skutočne použité protokoly.';
$string['enablews'] = 'Povoliť web služby';
$string['enablewsdescription'] = 'Web služby musia byť povolené v pokročilých vlastnostiach';
$string['entertoken'] = 'Zadajte bezpečnostný kľúč/token';
$string['error'] = 'Chyba: {$a}';
$string['errorcatcontextnotvalid'] = 'Nemôžete spúšťať funkcie v kontexte kategórie (category id:{$a->catid}). Chybová správa kontextu bola: {$a->message}';
$string['errorcodes'] = 'Chybová správa';
$string['errorcoursecontextnotvalid'] = 'Nemôžete spúšťať funkcie v kontexte kurzu (course id:{$a->courseid}). Chybová správa kontextu bola: {$a->message}';
$string['errorinvalidparam'] = 'Parameter "{$a}" nie je platný.';
$string['errornotemptydefaultparamarray'] = 'Parameter opisu webovej služby "{$a}" má jednoduchú alebo viacnásobnú štruktúru. Štandardne to môže byť iba prázdne pole. Skontrolujte opis webové služby.';
$string['erroroptionalparamarray'] = 'Parameter opisu webovej služby "{$a}" má jednoduchú alebo viacnásobnú štruktúru. Nemôže byť nastavený ako VALUE_OPTIONAL.  Skontrolujte opis webovej služby.';
$string['eventwebservicefunctioncalled'] = 'Bola volaná webová služba';
$string['eventwebserviceloginfailed'] = 'Prihlásenie webovej služby zhavarovalo';
$string['eventwebserviceservicecreated'] = 'Bola vytvorená webová služba';
$string['eventwebserviceservicedeleted'] = 'Bola odstránená webová služba';
$string['eventwebserviceserviceupdated'] = 'Bola aktualizovaná webová služba';
$string['eventwebserviceserviceuseradded'] = 'Používateľ webovej služby bol pridaný';
$string['eventwebserviceserviceuserremoved'] = 'Používateľ webovej služby bol odstránený';
$string['eventwebservicetokencreated'] = 'Token webovej služby bol vytvorený';
$string['eventwebservicetokensent'] = 'Token webovej služby bol odoslaný';
$string['execute'] = 'Vykonať';
$string['executewarnign'] = 'UPOZORNENIE: Ak stlačíte "vykonať", vaša databáza bude upravená a zmeny nebude možné vrátiť automaticky!';
$string['externalservice'] = 'Externá služba';
$string['externalservicefunctions'] = 'Funkcie externých služieb';
$string['externalservices'] = 'Externé služby';
$string['externalserviceusers'] = 'Používatelia externých služieb';
$string['failedtolog'] = 'Nepodarilo za zapísať do logu';
$string['filenameexist'] = 'Názov súboru už existuje: {$a}';
$string['forbiddenwsuser'] = 'Nie je možné vytvoriť token pre používateľa, ktorý je nepotvrdený, odstránený, pozastavený alebo je hosťom.';
$string['function'] = 'Funkcia';
$string['functions'] = 'Funkcie';
$string['generalstructure'] = 'Všeobecná štruktúra';
$string['information'] = 'Informácia';
$string['installexistingserviceshortnameerror'] = 'Webová služba so skráteným názvom "{$a}" už existuje. Nie je možné nainštalovať/aktualizovať inú webovú službu s týmto skráteným názvom.';
$string['installserviceshortnameerror'] = 'Chyba kódovania: skrátený názov služby "{$a}" môže obsahovať iba alfanumerické znaky (písmena a čísla), podtrhovník (_), pomlčku (-) alebo bodku (.)';
$string['invalidextparam'] = 'Neplatný externý api parameter: {$a}';
$string['invalidextresponse'] = 'Neplatný externý api parameter: {$a}';
$string['invalidiptoken'] = 'Neplatný token - vaša IP adresa nie je podporovaná';
$string['invalidtimedtoken'] = 'Neplatný token - expiroval';
$string['invalidtoken'] = 'Neplatný token - token nebol nájdený';
$string['iprestriction'] = 'Obmedzenie na IP adresy';
$string['iprestriction_help'] = 'Používateľ bude môcť zavolať web službu z IP adries zo zoznamu';
$string['key'] = 'Kľúč';
$string['keyshelp'] = 'Kľúče sa používajú k prístupu do vášho Moodle účtu z externých aplikácií.';
$string['loginrequired'] = 'Obmedzené na prihlásených používateľov.';
$string['manageprotocols'] = 'Spravovať protokoly';
$string['managetokens'] = 'Spravovať tokeny';
$string['missingcaps'] = 'Chýbajúce schopnosti';
$string['missingcaps_help'] = 'Zoznam funkcií deklarovaných službou, ktoré používateľ nemá. Bez týchto funkcií nemusia byť niektoré funkcie služby k dispozícii.';
$string['missingpassword'] = 'Chýbajúce heslo';
$string['missingrequiredcapability'] = 'Je požadovaná právomoc {$a}.';
$string['missingusername'] = 'Chýbajúci login';
$string['missingversionfile'] = 'Chyba kódovania: pre komponentu {$a} chýba súbor version.php';
$string['nameexists'] = 'Tento názov je už používaný inou službou';
$string['nocapabilitytouseparameter'] = 'Používateľ nemá požadovanú právomoc k používaniu parametra {$a}';
$string['nofunctions'] = 'Táto služba nemá žiadne funkcie';
$string['norequiredcapability'] = 'Žiadna požadovaná schopnosť';
$string['notoken'] = 'Zoznam tokenov je prázdny';
$string['onesystemcontrolling'] = 'Povoliť externý systém pre riadenie Moodle';
$string['onesystemcontrollingdescription'] = 'Následujúce kroky vám pomôžu nastaviť webovú službu Moodle, aby bolo povolené vzájomné pôsobenie externého systému a Moodle. Toto zahŕňa nastavenie metódy overenia tokenu (bezpečnostného kľúča).';
$string['onlyseecreatedtokens'] = 'Môžete zobraziť iba tokeny, ktoré ste vytvorili.';
$string['operation'] = 'Operácia';
$string['optional'] = 'Voliteľný';
$string['passwordisexpired'] = 'Platnosť hesla vypršala';
$string['phpparam'] = 'XML-RPC (PHP štruktúra)';
$string['phpresponse'] = 'XML-RPC (PHP štruktúra)';
$string['postrestparam'] = 'PHP kód pre REST (požiadavka POST)';
$string['potusers'] = 'Žiadni autorizovaní používatelia';
$string['potusersmatching'] = 'Žiadni vyhovujúci autorizovaní používatelia';
$string['print'] = 'Vytlačiť všetko';
$string['privacy:metadata'] = 'WebService API neukladá žiadne údaje';
$string['protocol'] = 'Protokol';
$string['removefunction'] = 'Odstrániť';
$string['removefunctionconfirm'] = 'Naozaj chcete odstrániť funkciu "{$a->function}" zo služby "{$a->service}"?';
$string['requireauthentication'] = 'Táto metóda vyžaduje autentifikácie s oprávnením xxx';
$string['required'] = 'Požadovaný';
$string['requiredcapability'] = 'Požadovaná schopnosť';
$string['requiredcapability_help'] = 'Ak je nastavené, iba používatelia s vyžadovanou schopnosťou môžu pristupovať k službe';
$string['requiredcaps'] = 'Požadované schopnosti';
$string['resettokencomplete'] = 'Vybraný token bol resetovaný';
$string['resettokenconfirm'] = 'Naozaj chcete resetovať tento kľúč web služby pre používateľa: <strong>{$a->user}</strong> v službe <strong>{$a->service}</strong>?';
$string['resettokenconfirmsimple'] = 'Naozaj chcete resetovať tento kľúč? Všetky uložené odkazy obsahujúce tento kľúč už nebudú funkčné.';
$string['response'] = 'Odpoveď';
$string['restcode'] = 'REST';
$string['restexception'] = 'REST';
$string['restoredaccountresetpassword'] = 'Obnovený účet potrebuje obnoviť heslo skôr, ako dostane token.';
$string['restparam'] = 'REST (parametre POST)';
$string['restrictedusers'] = 'Iba autorizovaní používatelia';
$string['restrictedusers_help'] = 'Toto nastavenie určuje, či používatelia s oprávnením vytvoriť token web služby môžu vytvoriť token pre túto službu cez stránku s ich bezpečnými kľúčmi alebo či to môžu urobiť iba autorizovaní používatelia.';
$string['securitykey'] = 'Bezpečnostný kľúč (token)';
$string['securitykeys'] = 'Bezpečnostné kľúče';
$string['selectauthorisedusers'] = 'Vybrať autorizovaných používateľov';
$string['selectedcapability'] = 'Vybraní';
$string['selectedcapabilitydoesntexit'] = 'Požadovaná schopnosť vyžadovaná v súčasnosti ({$a}) už neexistuje. Prosím, zmeňte ju a uložte zmeny.';
$string['selectservice'] = 'Vybrať službu';
$string['selectspecificuser'] = 'Vyberte určitého používateľa';
$string['selectspecificuserdescription'] = 'Pridať používateľa web služieb ako autorizovaného používateľa.';
$string['service'] = 'Služba';
$string['servicehelpexplanation'] = 'Služba je skupina funkcií. K službe môžu pristupovať alebo všetci alebo špecifickí používatelia.';
$string['servicename'] = 'Názov služby';
$string['servicenotavailable'] = 'Webová služba nie je dostupná (neexistuje albo je vypnutá)';
$string['servicerequireslogin'] = 'Webová služba nie je dostupná (relácia bola odhlásená alebo vypršala)';
$string['servicesbuiltin'] = 'Vstavané služby';
$string['servicescustom'] = 'Vlastné služby';
$string['serviceusers'] = 'Autorizovaní používatelia';
$string['serviceusersettings'] = 'Nastavenia používateľov';
$string['serviceusersmatching'] = 'Vyhovujúci autorizovaní používatelia';
$string['serviceuserssettings'] = 'Zmeniť nastavenia pre autorizovaných používateľov';
$string['shortnametaken'] = 'Skrátený názov je už používaný pre inú službu ({$a})';
$string['simpleauthlog'] = 'Jednoduché autentifikačné prihlásenie';
$string['step'] = 'Krok';
$string['supplyinfo'] = 'Viac informácií';
$string['testauserwithtestclientdescription'] = 'Simulovať externý prístup k službe použitím testovacieho klienta webovej služby. Pred simuláciou sa prihláste ako používateľ so schopnosťou moodle/webservice:createtoken capability a získajte bezpečnostný kľúč (token) cez nastavenie Môj profil. Tento kľúč použijete v testovacom klientovi. V testovacím klientovi si tiež vyberiete aktivovaný protokol s overením tokenu. <strong>VAROVANIE: Funkcie, ktoré testujete BUDÚ pre tohto používateľa VYKONAN0, preto buďte opatrní, čo si vyberiete k testovaniu!</strong>';
$string['testclient'] = 'Testovací klient web služieb';
$string['testclientdescription'] = '* Testovací klient webovej služby <strong>vykonáva SKUTOČNÉ</strong> funkcie. Netestujte funkcie, ktoré nepoznáte. <br/>* Všetky existujúce funkcie pre webové služby nie sú doteraz implementované do skúšobného klienta. <br/>* Za účelom overenia, že používateľ nemôže získať prístup k niektorým funkciám, môžete vyskúšať niektoré funkcie, ktoré nemáte povolené. <br/>* Ak chcete vidieť podrobnejšie chybové správy, nastavte ladenie na <strong>{$a->mode}</strong> do {$a->atag}.';
$string['testwithtestclient'] = 'Testovať službu';
$string['testwithtestclientdescription'] = 'Simulujte externý prístup k službe pomocou testovacieho klienta webovej služby. Použite aktivovaný protokol s overením tokenu. <strong>VAROVANIE: Funkcie, ktoré testujete BUDÚ pre tohto používateľa VYKONANÉ, preto buďte opatrní, čo si vyberiete k testovaniu!</strong>';
$string['token'] = 'Token';
$string['tokenauthlog'] = 'Autentifikácia tokenu';
$string['tokencreatedbyadmin'] = 'Môže byť resetované iba administrátorom (*)';
$string['tokencreator'] = 'Tvorca';
$string['tokenfilter'] = 'Filter tokenov';
$string['tokenfilterreset'] = 'Zobraziť všrtky tokeny';
$string['tokenfiltersubmit'] = 'Zobraziť iba odpovedajúce tokeny';
$string['unknownoptionkey'] = 'Neznámy kľúč voľby ({$a})';
$string['unnamedstringparam'] = 'Parameter reťazca nie je pomenovaný.';
$string['updateusersettings'] = 'Aktualizácia';
$string['uploadfiles'] = 'Môže nahrávať súbory';
$string['uploadfiles_help'] = 'Ak je povolené, môže každý používateľ vkladať so svojím bezpečnostným kľúčom vo vlastnom prostredí osobné súbory alebo do pracovnej oblasti súborov.  Sú platné obmedzenia súborov používateľa.';
$string['userasclients'] = 'Používatelia ako klienti s tokenom';
$string['userasclientsdescription'] = 'Nasledujúce kroky vám pomôžu nastaviť webovú službu Moodle pre používateľov ako klientov. Tieto kroky tiež pomôžu nastaviť odporúčanú metódu overovania tokenov (bezpečnostné kľúče). V tomto prípade použitia používateľ vytvorí svoj token zo stránky bezpečnostných kľúčov cez nastavenie svojho profilu.';
$string['usermissingcaps'] = 'Chýbajúce schopnosti: {$a}';
$string['usernameorid'] = 'Používateľské meno / ID používateľa';
$string['usernameorid_help'] = 'Zadajte používateľské meno alebo ID používateľa';
$string['usernameoridnousererror'] = 'Nebol nájdený používateľ pre toto používateľské meno/ID používateľa.';
$string['usernameoridoccurenceerror'] = 'Bol nájdený viac ako jeden používateľ s týmto používateľským menom. Prosím vlože ID používateľa.';
$string['usernotallowed'] = 'Používateľ nemá oprávnenie pre túto službu. Najprv ho potrebujete tomuto používateľovi pridať na stránke administratívy oprávnených používateľov {$a}.';
$string['userservices'] = 'Používateľ služby: {$a}';
$string['usersettingssaved'] = 'Používateľské nastavenia uložené';
$string['validuntil'] = 'Platný až do';
$string['validuntil_help'] = 'Ak je nastavené, služba bude deaktivovaná pre tohto používateľa po tomto dátume';
$string['webservice'] = 'Web služba';
$string['webservices'] = 'Web služby';
$string['webservicesoverview'] = 'Prehľad';
$string['webservicetokens'] = 'Tokeny web služieb';
$string['wrongusernamepassword'] = 'Nesprávny login alebo heslo';
$string['wsaccessuserdeleted'] = 'Odmietnutý prístup webovej služby pre odstránené používateľské mená: {$a}';
$string['wsaccessuserexpired'] = 'Odmietnutý prístup webovej služby pre používateľské mená s expirovaným heslom: {$a}';
$string['wsaccessusernologin'] = 'Odmietnutý prístup webovej služby pre používateľské mená bez overenia príhlásenia: {$a}';
$string['wsaccessusersuspended'] = 'Odmietnutý prístup webovej služby pre pozastavené používateľské mená: {$a}';
$string['wsaccessuserunconfirmed'] = 'Odmietnutý prístup webovej služby pre nepotvrdené používateľské mená: {$a}';
$string['wsclientdoc'] = 'Dokumentácia klienta Moodle web služieb';
$string['wsdocapi'] = 'API dokumentácia';
$string['wsdocumentation'] = 'Dokumentácia web služieb';
$string['wsdocumentationdisable'] = 'Dokumentácia web služieb nie je povolená.';
$string['wsdocumentationintro'] = 'Pred vytvorením klienta odporúčame prečítať {$a->doclink}';
$string['wsdocumentationlogin'] = 'alebo zadajte svoje meno a heslo web služby';
$string['wspassword'] = 'Heslo web služieb';
$string['wsusername'] = 'Login web služieb';
