<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'admin', language 'af', version '4.1'.
 *
 * @package     admin
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessdenied'] = 'Toegang geweier';
$string['accounts'] = 'Rekeninge';
$string['addcategory'] = 'Voeg \'n kategorie by';
$string['additionalhtml'] = 'Addisionele HTML';
$string['additionalhtml_desc'] = 'Hierdie instellings laat jou toe om HTML-te spesifiseer wat by elke bladsy gevoeg moet word. Jy kan HTML stel wat binne die \'HEAD\'-etiket vir die bladsy bygevoeg word. Hierdie gebeur  onmiddellik na die \'BODY\'-etiket oopgemaak is, of onmiddellik voor die \'BODY\'-etiket toegemaak is. <br /> Sodoende word jy toegelaat om doelgemaakte opskrifte en voetskrifte op elke bladsy by te voeg, of om ondersteuning vir dienste soos Google Analytics maklik by te voeg, onafhanklik van jou gekose tema.';
$string['additionalhtml_heading'] = 'Addisionele HTML om by elke bladsy te voeg.';
$string['additionalhtmlfooter'] = 'Voordat \'BODY\' gesluit is';
$string['additionalhtmlfooter_desc'] = 'Inhoud hier sal by elke blasdsy gevoeg word net voor die \'body\'-etiket toegemaak word.';
$string['additionalhtmlhead'] = 'Binne HEAD';
$string['additionalhtmlhead_desc'] = 'Inhoud hier sal by die onderkant van die \'HEAD\'-etiket vir elke bladsy gevoeg word.';
$string['additionalhtmltopofbody'] = 'Wanneer \'BODY\' oopgemaak word.';
$string['additionalhtmltopofbody_desc'] = 'Inhoud hier sal by elke blasdsy gevoeg word net na die \'body\'-etiket oopgemaak word.';
$string['admincategory'] = 'Kategorie: {$a}';
$string['adminseesall'] = 'Administrateurs sien alles';
$string['adminseesallevents'] = 'Administrateurs sien alle gebeure.';
$string['adminseesownevents'] = 'Administrateurs is net soos ander gebruikers';
$string['advancedfeatures'] = 'Gevorderde funksies';
$string['agedigitalconsentverification'] = 'Digitale era van toestemming verifikasie';
$string['agedigitalconsentverification_desc'] = 'Aktiveer verifikasie van die digitale era van toestemming voordat die aanmeldbladsy vir selfregistrasiegebruikers vertoon word. Dit beskerm u webwerf teen minderjariges wat aanmeld sonder toestemming van ouers / voog. <a target="_blank" href="{$a}">Ondersteuning kontakbesonderhede</a> word verskaf vir meer hulp.';
$string['ageofdigitalconsentmap'] = 'Digitale era van toestemming';
$string['ageofdigitalconsentmap_desc'] = 'Die verstek digitale era van toestemming asook die ouderdom in enige ander land waar dit verskil vanaf die verstek kan hier gespesifiseer word. Voer elke ouderdom op \'n nuwe lyn met die volgende formaat: landkode, ouderdom (geskei met \'n komma). Die verstek ouderdom word aangedui met \'n * in die plek van die landkode. Landkodes word gespesifiseerd in ISO 3166-2.';
$string['allcountrycodes'] = 'Alle landkodes';
$string['allowattachments'] = 'Aanvaar aanhegsels';
$string['allowbeforeblock'] = 'Toegelaate lys sal eerste verwerk word';
$string['allowbeforeblockdesc'] = 'By verstek word inskrywings in die lys van geblokte IP-adresse eerste opgelyn en getoets. As hierdie opsie onstper is sal inskrywings in die lys van toegelate IP-adresse verwerk word voor die lys van geblokte IP-adresse.';
$string['allowcategorythemes'] = 'Laat kategorie temas toe';
$string['allowcohortthemes'] = 'Laat kohort temas toe';
$string['allowcoursethemes'] = 'Laat kursus temas toe';
$string['allowedemaildomains'] = 'Toegelate e-pos adres domeine';
$string['allowediplist'] = 'Toegelate lys van IP-adresse';
$string['allowemailaddresses'] = 'Toegelate e-pos adres domeins';
$string['allowemojipicker'] = 'Emoji kieser';
$string['allowframembedding'] = 'Laat inbedding toe vir raam';
$string['allowframembedding_help'] = 'Indien ontsper kan hierdie webblad in \'n raam in \'n afstandstelsel ingebed word. Dit word aanbeveel wanneer die \'Publish as LTI tool\' inskrywings-inprop gebruik word. Andersins word dit aanbeveel om die raam-inbedding vir sekuriteitsredes nie toe te laat nie. Let asseblief daarop dat hierdie instelling vir die mobiele toep geïgnoreer word en dat inbedding altyd toegelaat word.';
$string['allowguestmymoodle'] = 'Laat toegang tot die Paneelbord toe vir gaste';
$string['allowindexing'] = 'Laat indeksering toe vir soekenjins';
$string['allowindexing_desc'] = 'Hierdie bepaal of soekenjins toegelaat word om jou webwerf te deursoek. "Orals" laat die soekenjins toe om orals te soek, insluitend die inteken en aanteken bladsye, wat beteken dat bladsye met die "Forseer Aanteken"-opsie aktief ook geïndekseer gaan word. Om die risiko van rommelpos betrokke met die aanteken bladsy wat ook deursoek word te beperk, gebruik "Orals behalwe inteken en aanteken bladsye". "Nêrens" sal vir soekenjins aandui om geen bladsy te indekseer nie. Let wel dat hierdie slegs \'n etiket in die opskrif van die webwerf is. Die soekenjin moet besluit om hierdie etiket te respekteer al dan nie.';
$string['allowindexingeverywhere'] = 'Oral';
$string['allowindexingexceptlogin'] = 'Oral behalwe die inteken en aanteken bladsye';
$string['allowindexingnowhere'] = 'Nêrens';
$string['allowobjectembed'] = 'Laat \'EMBED\'- en \'OBJECT\'-etikette toe';
$string['allowthemechangeonurl'] = 'Laat veranderinge van die tema in die URL toe';
$string['allowuserblockhiding'] = 'Laat gebruikers toe om blokke weg te steek';
$string['allowusermailcharset'] = 'Laat gebruikers toe om \'n karakterstel te kies';
$string['allowuserswitchrolestheycantassign'] = 'Laat gebruikers sonder die \'ken rolle toe\' vermoë om tussen rolle te wissel.';
$string['allowuserthemes'] = 'Laat gebruiker-temas toe';
$string['alternativefullnameformat'] = 'Alternatiewe formaat vir volle name';
$string['alternativefullnameformat_desc'] = 'Hierdie bepaal hoe name vertoon word vir gebruikers met die \'viewfullnames\' vermoë (by verstek gebruikers wat die rol van bestuurder, onderwyser of nie-redigerende onderwyser het). Plekhouers wat gebruik kan word is dieselfde as vir die "Volle Naam Formaat" inrstelling.';
$string['always'] = 'Altyd';
$string['appearance'] = 'Voorkoms';
$string['aspellpath'] = 'Pad na Aspell';
$string['authentication'] = 'Verifikasie';
$string['authpreventaccountcreation'] = 'Verhoed die skep van rekeninge tydens verifikasie.';
$string['authpreventaccountcreation_help'] = 'Wanneer \'n gebruik verifieer word, word \'n rekening outomaties geskep indien daar nie reeds een bestaan nie. Indien \'n eksterne databasis soos LDAP vir verifikasie gebruik word maar jy verkies om toegang tot die webwerf te beperk tot gebruikers wat reeds \'n rekening het, moet hierdie opsie ontsper word. Nuwe profiele moet met die hand geskep word of deur die oplaai van gebruikers funksie. Let wel dat hierdie nie van toepassing op die MNet verifikasie nie is nie.';
$string['authsettings'] = 'Beheer verifikasie';
$string['autolang'] = 'Bepaal taal outomaties';
$string['autolangusercreation'] = 'Stel die gebruiker se blaaier-taal as hul voorkeur-taal wanneer \'n rekening geskep word.';
$string['autologinguests'] = 'Teken gaste outomaties in';
$string['availableto'] = 'Beskikbaar vir';
$string['availabletoanyone'] = 'Beskikbaar vir almal wat die webwerf besoek';
$string['availabletoauthenticated'] = 'Beperk tot geverifieerde gebruikers';
$string['backgroundcolour'] = 'Deursigtige kleur';
$string['backup_shortname'] = 'Gebruik die kursus se naam in die lêernaam van die rugsteun.';
$string['backup_shortnamehelp'] = 'Gebruik die kursus se naam as deel van die leêrnaam van die rugsteun.';
$string['backups'] = 'Rugsteune';
$string['badwordsconfig'] = 'Voer jou lys van slegte woorde in, geskei deur kommas.';
$string['badwordsdefault'] = 'As die persoonlike lys leeg is, sal \'n standaard lys van die taal pakket gebruik word.';
$string['badwordslist'] = 'Doelgemaakte lys van slegte woorde';
$string['blockediplist'] = 'Lys van geblokkeerde IP-adresse';
$string['blockinstances'] = 'Gevalle';
$string['blockmultiple'] = 'Verskeie';
$string['blockprotect'] = 'Beskerm gevalle';
$string['blockprotect_help'] = 'Indien jy \'n spesifieke tipe blok sluit sal niemand toegelaat word om gevalle by te voeg of te verwyder nie. (Jy kan natuurlik weer die slot oopmaak indien jy gevalle moet verander.)

Hierdie is bedoel om blokke soos die navigasie en instellings te beskerm wat baie moeilik is om te herwin indien dit per ongeluk uigtewis word.';
$string['blocksettings'] = 'Bestuur blokke';
$string['blockunprotect'] = 'Onbeskerm';
$string['bloglevel'] = 'Sigbaarheid van blog';
$string['bookmarkadded'] = 'Boekmerk bygevoeg.';
$string['bookmarkalreadyexists'] = 'Jy het alreeds hierdie bladsy geboekmerk.';
$string['bookmarkdeleted'] = 'Boekmerk uitgewis.';
$string['bookmarkthispage'] = 'Boekmerk hierdie bladsy.';
$string['cacheapplication'] = 'Toepassing kas';
$string['cacheapplicationhelp'] = 'Gekasde items word tussen alle gebruikers gedeel en verval teen \'n vasgestelde leeftyd (TTL).';
$string['cachejs'] = 'Kas Javascript';
$string['cachejs_help'] = 'Javascript kasberging en samedrukking verbeter werksverrrigting tydens die laai van bladsye grootliks. Dit word sterk aanbeveel vir webwerwe wat lewendig is. Ontwikkelaars sal hierdie funksie waarskynlik wil afskakel.';
$string['cacherequest'] = 'Versoek kas';
$string['cacherequesthelp'] = 'Gebruiker-spesifieke kas wat verval wanneer die versoek voltooi is. Dit is ontwerp om areas te vervang waar ons die statiese store gebruik.';
$string['cachesession'] = 'Sessie kas';
$string['cachesessionhelp'] = 'Gebruiker-spesifieke kas wat verval wanneer die gebruiker se sessie eindig. Dit is ontwerp sessie opblaas/druk te verlig.';
$string['cachesettings'] = 'Kas instellings';
$string['cachetemplates'] = 'Kas template';
$string['cachetemplates_help'] = 'Templaat kasberging sal die werksverrigting van die laai van bladsye verbeter en word sterk aanbeveel vir lewendige webwerwe. Ontwikkelaars sal hierdie funksie waarskynlik wil afskakel.';
$string['caching'] = 'Kasberging';
$string['calendar_weekend'] = 'Naweek dae';
$string['calendarexportsalt'] = 'Kalender uitvoer sout';
$string['calendarsettings'] = 'Kalender';
$string['calendartype'] = 'Kalender tipe';
$string['calendartype_desc'] = 'Kies \'n verstek kalender-tipe vir die hele webwerf. Hierdie instelling kan oorskryf word in die kursus instellings of deur gebruikers in hul persoonlike profiel.';
$string['campaign'] = 'Veldtog';
$string['cannotdeletemodfilter'] = 'Jy kan nie die \'{$a->filter}\' verwyder nie, want dit is deel van die \'{$a->module}\' kursus.';
$string['cannotuninstall'] = '{$a} kan nie verwyder word nie.';
$string['categoryemail'] = 'E-pos';
$string['cfgwwwrootslashwarning'] = '$CFG->wwwroot is verkeerd in die config.php lêer gedefinieer. Dit sluit \'n "/"-karakter aan die einde in.';
$string['cfgwwwrootwarning'] = '$CFG->wwwroot is verkeerd in die config.php lêer gedefinieer. Dit stem nie ooreen met die URL wat jy gebruik om toegang tot hierdie bladsy te verkry nie.';
$string['change'] = 'verandering';
$string['checkboxno'] = 'Nee';
$string['checkboxyes'] = 'Ja';
$string['checkupgradepending'] = 'Gradeer op';
$string['choosefiletoedit'] = 'Kies n lêer om te wysig';
$string['cleanup'] = 'Opruim';
$string['clianswerno'] = 'n';
$string['cliansweryes'] = 'j';
$string['cliexitgraceful'] = 'Besig om grasieus uit te gaan, wag asseblief...';
$string['cliexitnow'] = 'Gaan NOU uit';
$string['cliincorrectvalueerror'] = 'Fout, verkeerde waarde "{$a->value}" vir "{$a->option}"';
$string['cliincorrectvalueretry'] = 'Verkeerde waarde, probeer weer';
$string['clistatusdisabled'] = 'Status: versper';
$string['clistatusenabled'] = 'Status: ontsper';
$string['clistatusenabledlater'] = 'status: CLI instandhouding sal ontsper word op {$a}';
$string['clitypevalue'] = 'tipe waarde';
$string['clitypevaluedefault'] = 'tipe waarde, druk Enter om die verstekwaarde te gebruik ({$a})';
$string['cliunknowoption'] = 'Onerkende opsies:
  {$a}
Gebruik asseblief die --help opsie.';
$string['cliupgradedefault'] = 'Nuwe instelling: {$a}';
$string['cliupgradedefaultheading'] = 'Besig om nuwe nuwe verstekwaardes in te stel';
$string['cliupgradedefaultverbose'] = 'Nuwe instelling: {$a->name}, Verstekwaarde: {$a->defaultsetting}';
$string['cliupgradefinished'] = 'Bevellyn opgradering vanaf {$a->oldversion} na {$a->newversion} suksesvol voltooi.';
$string['cliupgradenoneed'] = 'Geen opgradering nodig vir geïnstalleerde weergawe {$a} nie. Dankie in elk geval!';
$string['cliupgradepending'] = '\'n Opgradering is afwagtend';
$string['cliyesnoprompt'] = 'Tik j (beteken ja) of n (beteken nee)';
$string['close'] = 'Maak toe';
$string['commentsperpage'] = 'Kommentaar per bladsy vertoon';
$string['commonactivitysettings'] = 'Algemene aktiwiteit instellings';
$string['commonfiltersettings'] = 'Algemene filter instellings';
$string['commonsettings'] = 'Algemene instellings';
$string['componentinstalled'] = 'Komponent geïnstalleer';
$string['computedfromlogs'] = 'Bereken vanaf logs sedert {$a}.';
$string['condifmodeditdefaults'] = 'Verstekwaardes word in die instellingsvorm gebruik wanneer \'n nuwe aktiwiteit of hulpbron geskep word.';
$string['confeditorhidebuttons'] = 'Selekteer die knoppies wat in die HTML-redigeerder weggesteek moet word.';
$string['configallcountrycodes'] = 'Hierdie is die lys van lande wat op verskillende plekke gekies kan word, byvoorbeeld in \'n gebruiker se profiel. Indien leeg (by verstek) word die lys in countries.php gebruik in die standaard Engelse taalpakket. Dit is die lys van ISO 3166-1. Andersins kan jy \'n komma-geskeide lys van kodes spesifiseer, byvoorbeeld, \'GB,FR,ES\'. As jy nuwe, nie-standaard kodes hier byvoeg,moet jy dit by die countries.php lys in \'en\' sowel as jou taalpakket byvoeg.';
$string['configallowassign'] = 'Vir elke rol in die linkerkolom, kies watter rolle hulle aan ander kan toeken.';
$string['configallowattachments'] = 'Indien ontsper, kan e-posse wat vanaf die webwerf gestuur word aanhegsels, byvoorbeeld wapens, bevat.';
$string['configallowcategorythemes'] = 'Indien ontsper kan temas op die kategorie-vlak gestel word. Dit sal alle kinder kategorieë en kursusse raak tensy hulle spesifiek hul eie tema gestel het. WAARSKUWING: Om kategorie temas temas te ontsper kan die werksverrigting affekteer.';
$string['configallowcohortthemes'] = 'Indien ontsper kan temas op die kohort vlak gestel word. Dit sal gebruikers met slegs een of meer as een kohort (maar met dieselfde tema) affekteer.';
$string['configallowcoursethemes'] = 'Indien ontsper, sal kursusse toegaat word om hul eie temas in te stel. Kursus temas oorskryf alle ander tema-keuses (webwerf, gebruiker, kategorie, kohort of URlL gedefinieerde temas).';
$string['configallowedemaildomains'] = 'Lys e-pos domeine wat toegelaat is om in die "From" afdeling van uitgaande e-posse vertoon te word. Die verstekinstelling van "Empty" sal die Geen-antwoord e-posadres gebruik vir alle uitgaande e-posse. Die gebruik van \'wildcards\' word toegelaat, byvoorbeeld *.example.com sal toelaat dat e-posse vanaf enige sub-domein van example.com gestuur word, maar nie example.com self nie. Dit sal \'n aparte inskrywing vereis.';
$string['configallowemailaddresses'] = 'Om alle nuwe e-posadresse tot spesifieke domeine te beperk, lys hulle hier (deur spasies geskei). Alle ander domeine sal verwerp word. Om sub-domeine toe te laat, voeg die domein met \'n voorafgaande \'.\' by. Om \'n worteldomein saam met al sy sub-domeine toe te laat, voeg die domein twee keer by - een keer met \'n voorafgaande \'.\' en een keer daarsonder, byvoorbeeld .ourcollege.edu.au ourcollege.edu.au.';
$string['configallowemojipicker'] = 'Die emoji-kieser laat gebruikers toe om emoji\'s, byvoorbeeld \'n glimlaggende gesiggie, by boodskappe en ander teks-areas te voeg deur gebruik van \'n emoji kieser knoppie in die Atto hulpstafie.';
$string['configallowemojipickerincompatible'] = 'Jou huidige databasis konfigurasie ondersteun nie emoji\'s behoorlik nie. Om die emoji kieser te ontsper sal jy  <a href="https://docs.moodle.org/en/MySQL_full_unicode_support">gradeer jou databasis op vir volle unikode ondersteuning</a>.';
$string['configallowguestmymoodle'] = 'Indien geaktiveerd is, kan gaste toegang tot die Dashboard kry. Andersins word gaste na die webtuiste tuisblad geneem.';
$string['configallowobjectembed'] = 'As \'n verstek veiligheidsmaatreël word normale gebruikers nie toegelaat om multimedia (soos Flash) binne tekste in te bed met die gebruik van die eksplisiete \'EMBED\'- en \'OBJECT\'-etikette in HTML nie (alhoewel dit steeds gedoen kan word met behulp van die media-inprop filter). Indien jy hierdie etikette wil toelaat kan jy hierdie opsie aktiveer.';
$string['configallowoverride'] = 'Jy kan mense wat rolle aan die linkerkant het, toelaat om \'n sommige van die kolom-rolle aan ander mense toe te ken.';
$string['configallowoverride2'] = 'Vir elke rol in die linkerkolom, kies watter rolle hulle kan oorskryf.<br />Gebruikers moet die vermoë hê van moodle/role:override óf moodle/role:safeoverride.';
$string['configallowswitch'] = 'Kies vir elke rol in die linkerkolom na watter rolle hulle kan oorskakel.<br />Gebruikers moet ook die vermoë hê moodle/role:switchroles.';
$string['configallowthemechangeonurl'] = 'Indien ontsper kan die tema verander word deur óf<br />?theme=themename na enige Moodle URL (bv: mymoodlesite.com/?theme=afterburner ) óf <br />&theme=themename na enige interne Moodle URL (bv: mymoodlesite.com/course/view.php?id=2&theme=afterburner) by te voeg .';
$string['configallowuserblockhiding'] = 'Wil jy gebruikers toelaat om kantblokke te vertoon of weg te steek deur die hele webwerf? Hierdie funksie maak gebruik Javascript en koekies om die toestand van elke invoubare blok te onthou en affekteer slegs die gebruiker se eie uitleg.';
$string['configallowusermailcharset'] = 'Indien ontsper kan gebruikers \'n e-pos karakterstel in hul boodskap voorkeure kies.';
$string['configallowuserswitchrolestheycantassign'] = 'By verstek word moodle/role:assign vereis vir gebruikers om tussen rolle te wissel. Deur hierdie instelling te ontsper word hierdie vereiste verwyder en die "Wissel rol na" aftrek-kieslys word alleenlik deur die instellings in die "Laat rol opdragte toe" tabel bepaal. Dit word voorgestel dat die instellings in die "Laat rol opdragte toe" tabel nie gebruikers toelaat om rolle te wissel na \'n rol met meer vermoëns as hul huidige rol nie.';
$string['configallowuserthemes'] = 'Indien ontsper sal gebruikers toegelaat word om hul eie temas in te stel. Gebruikertemas oorheers webwerf-temas (maar nie kursus-temas nie).';
$string['configallowview'] = 'Vir elke rol in die linkerkolom, kies watter rolle hul kan sien, soek en filter volgens.';
$string['configallusersaresitestudents'] = 'Vir aktiwiteite op die tuisblad, moet ALLE gebruikers as studente beskou word? Indien wel, sal enigiemand met \'n rekening toegelaat word om as student aan hierdie aktiwiteite deel te neem. Indien nie, dan sal slegs gebruikers wat reeds \'n deelnemer aan ten minste een kursus is, aan hierdie aktiwiteite kan deelneem. Slegs administrateurs en spesiaal toegewysde onderwysers kan as onderwysers optree vir tuisblad aktiwiteite.';
$string['configauthenticationplugins'] = 'Kies asseblief die verifikasie inproppe wat jy wil gebruik en rangskik hulle in orde van verkose gebruik.';
$string['configautolang'] = 'Bepaal verstektaal vanuit die blaaier instellings. Indien ontsper word die webwerf se verstektaal gebruik.';
$string['configautolangusercreation'] = 'Indien ontsper sal die gebruiker se blaaiertaal as hul voorkeurtaal ingestel word wanneer \'n gebruiker se rekening outomaties op eerste inteken geskep word (byvoorbeeld wanneer LDAP of OAuth 2 verifikasie gebruik word. Andersins sal die vestektaal van die webwerf as die gebruiker se voorkeurtaal ingestel word.';
$string['configautologinguests'] = 'Moet kuiergaste outomaties as gaste ingeteken word wanneer hulle kursusse intree met gastetoegang?';
$string['configbloglevel'] = 'Hierdie instelling laat jou toe om beperkinge te stel vir die vlak waartoe gebruikerswebjoernale op hierdie webwerf gesien kan word. Let daarop dat hulle die maksimum kontekste vir die KYKER spesifiseer en nie die persoon wat die inskrywing maak of die tipe inskrywings wat gemaak word nie. Webjoernale kan ook geheel en al versper word indien jy dit nie wil hê nie.';
$string['configcalendarcustomexport'] = 'Ontsper doelgemaakte datumreeks-uitvoer van kalender.';
$string['configcalendarexportsalt'] = 'Hierdie ewekansige teks word gebruik vir die verbetering van die sekuriteit van verifikasie-tekens wat gebruik word om kalenders uit te voer. Let asseblief daarop dat alle huidige tekens ongeldig word as jy hierdie "hash salt" verander. huts';
$string['configcookiehttponly'] = 'Ontsper die nuwe PHP 5.2.0 funksie - blaaiers word die instruksie gegee om slegs koekies met egte http versoeke te stuur. Koekies moet nie toeganklik met skriptale wees nie. Hierdie word nie in alle blaaiers ondersteun nie en mag dalk nie versoenbaar wees met die huidige kode nie. Dit help om sommige tipes XSS aanvalle te voorkom.';
$string['configcookiesecure'] = 'Indien die bediener slegs http konneksies aanvaar word dit aanbeveel om die stuur van veilige koekies te ontsper. Indien ontsper, maak asseblief seker dat die webbediener nie http:// konneksies aanvaar nie, of stel \'n permanente herleiding na \'n https:// adres op en stuur verkieslik HSTS . Indien die <em>wwwroot</em> adres nie met https:// begin nie, word hierdie verstelling geïgnoreer.';
$string['configcountry'] = 'Indien jy \'n land hier instel, sal hierdie land by verstek op nuwe gebruikersrekeninge geselekteer word. Om gebruikers te forseer om \'n land te kies, moenie hierdie instel nie.';
$string['configcoursegraceperiodafter'] = 'Klassifiseer kursusse in die verlede as aan die gang vir hierdie hoeveelheid dae na die kursus se einddatum.';
$string['configcoursegraceperiodbefore'] = 'Klassifiseer kursusse in die toekoms as aan die gang vir hierdie hoeveelheid dae voor die kursus se begindatum.';
$string['configcourseoverviewfilesext'] = '\'n Komma-geskeide lys van kursus beeld lêeruitbreidings wat toegelaat word.';
$string['configcourseoverviewfileslimit'] = 'Die maksimum aantal lêers wat langs die kursus-opsomming vertoon kan word op die bladsy waar die lys van kursusse verskyn. Die eerste beeld lêer wat bygevoeg word, word as die beeld vir die kursus gebruik in die kursusoorsig op gebruikers se Paneelborde. Enige addisionele lêers word slegs op die bladsy waar die lys van kursusse verskyn vertoon.';
$string['configcourserequestnotify'] = 'Spesifiseer die gebruikersnaam van die gebruiker wat in kennis gestel moet word as \'n nuwe kursus versoek word.';
$string['configcourserequestnotify2'] = 'Gebruikers wie in kennis gestel gaan word as \'n kursus versoek word. Slegs gebruikers wat hierdie versoeke mag goedkeur word hier gelys.';
$string['configcoursesperpage'] = 'Voer die aantal kursusse in wat per bladsy in \'n kursus naamlys vertoon moet word.';
$string['configcourseswithsummarieslimit'] = 'Die maksimum aantal kursusse om te vertoon in \'n kursus naamlys, insluitend opsommings, voordat daar teruggekeer word na \'n meer eenvoudig naamlys.';
$string['configcronclionly'] = 'Bevoorregte informasie kan aan anonieme gebruikers blootgestel word indien die \'cron\' vanaf \'n webblaaier gehardloop word. Dit word dus aanbeveel om slegs die \'cron\' vanaf die bevellyn of om \'n ingestelde \'cron\' wagwoord vir afstandstoegang in plek te stel.';
$string['configcronremotepassword'] = 'Hierdie beteken dat die cron.php skrip nie vanuit \'n webblaaier gehardloop kan word sonder om die wagwoord te verskaf in die volgende tipe URL nie:<pre> http://site.example.com/admin/cron.php?password=opensesame </pre>Indien hierdie leeg gelaat word, word geen wagwoord benodig nie.';
$string['configcurlcache'] = 'Leeftyd vir cURL kasgeheue in sekondes.';
$string['configcustommenuitems'] = '\'n Doelgemaakte kieslys kan hier gekonfigureer word. Voer elke kieslys-item in op \'n nuwe reël met formaat: teks, \'n skakel (opsioneel, nie vir \'n boonste kieslys-item met subitems nie), \'n gereedskapstiptitel (opsioneel) en \'n taalkode of komma-geskeide lys kodes (opsioneel, om die lyn slegs aan gebruikers van die gespesifiseerde taal te vertoon), geskei deur pypkarakters. Lyne wat met \'n koppelteken begin, sal as kieslys-items in die vorige topvlakkieslys verskyn en ### maak \'n verdeler. Byvoorbeeld:
<pre>
Kursusse
-Alle kursusse|/course/
-Kursus soek|/course/search.php
-###
-FAQ|https://someurl.xyz/faq
-Preguntas más frecuentes|https://someurl.xyz/pmf||es
Mobile app|https://someurl.xyz/app|Download our app
</pre>';
$string['configcustomusermenuitems'] = 'U kan die inhoud van die gebruikerskieslys opstel (met die uitsondering van die afmeldskakel, wat outomaties bygevoeg word). Elke reël word geskei deur pypkarakters en bestaan uit 1) \'n string in "langstringname, komponentnaam"-vorm of as gewone teks, en 2) \'n skakel. Verdelers kan gebruik word deur \'n reël van een of meer # karakters by te voeg waar nodig.';
$string['configdbsessions'] = 'Indien ontsper sal hierdie instelling die databasis gebruik om inligting oor huidige sessies te stoor. Let wel dat as jy nou hierdie instelling verander, alle gebruikers uit hul sessies sal teken (insluitend jy self). Indien jy MySQL gebruik, maak asseblief seker dat \'max_allowed_packet\' in my.cnf (of my.ini) ten minste 4M is. Ander sessie-aandrywers kan direk in config.php gekonfigureer word. Sien config-dist.php vir meer inligting. Hierdie opsie verdwyn indien jy die sessie-aandrywer in die config.php lêer spesifiseer.';
$string['configdebug'] = 'Indien jy hierdie aanskakel sal PHP se error_reporting vermeerder sodat meer waarskuwings uitgedruk word. Hierdie is net nuttig vir ontwikkelaars.';
$string['configdebugdisplay'] = 'Indien aangeskakel sal die foutrapportering na die HTML blad gaan. Hierdie is prakties, maar breek XHTML, JS. koekies en HTTP opskrifte oor die algemeen. Indien dit afgesit is sal die afvoer na jou bediener logs gestuur word wat vir beter ontfouting toelaat. Die PHP instelling error_log beheer na watter log hierdie gaan.';
$string['configdebugpageinfo'] = 'Ontsper indien jy bladsy inligting in die bladsy se voetskrif uitgedruk wil hê.';
$string['configdebugvalidators'] = 'Ontsper indien jy skakels na eksterne geldigheidsbepaler-bedieners in die bladsy se voetskrif wil hê. Dit mag nodig wees om \'n nuwe gebruiker met die gebruikersnaam <em>w3cvalidator</em> te skep en gastetoegang toe te laat. Hierdie veranderinge kan ongemagtigde toegang tot die bediener toelaat, so moet dit nie op lewendige webwerwe ontsper nie!';
$string['configdefaulthomepage'] = 'Watter bladsy moet gebruikers sien nadat hul ingeteken is op die site? Hierdie instelling bepaal ook wat die eerste skakel sal wees op die navigasie vir gebruikers wat die Classic-based tema gebruik.';
$string['configdefaultrequestcategory'] = 'Kursusse wat deur gebruikers versoek word wat die vermoë het om nuwe kursusse in die stelsel konteks aan te vra sal in hierdie kategorie geplaas word, tensy gebruikers \'n ander kategorie kan kies.';
$string['configdefaultrequestedcategory'] = 'Verstek kategorie om kursusse waarna aangevra is te plaas indien hulle goedgekeur is.';
$string['configdefaultuserroleid'] = 'Alle gebruikers wat ingeteken is sal die vermoëns gegee word van die rol wat hier, op werfvlak, gespesifiseer word BO-OP enige ander rolle wat aan hulle gegee is. Die verstek is die Geverifieerde gebruiker rol. Let daarop dat dit nie in konflik sal wees met enige ander rolle wat hulle het nie, tensy jy vermoëns beperk. Dit verseker slegs dat alle gebruikers vermoëns het wat nie op kursusvlak toegeken kan word nie (bv. inskrywings in webjoernale, om hul eie kalender te bestuur, ens.).';
$string['configdeleteincompleteusers'] = 'Na hierdie periode word enige rekening wat nie \'n naam, van of e-posadres het nie, uitgewis.';
$string['configdeleteunconfirmed'] = 'Vir sekere verifikasie metodes, soos e-pos gebaseerde self-registrasie, moet gebruikers hul rekening binne \'n sekere tyd bevestig. Na hierdie tydperk word alle onbevestigde rekeninge uitgewis.';
$string['configdenyemailaddresses'] = 'Om e-posadresse vanaf spesifieke domeine te weier, lys die adresse hier in dieselfde manier. Alle ander domeine gaan aanvaar word. Om enige sub-domein te weier, voeg die domein by met \'n voorafgaande \'.\'. Byvoorbeeld <strong>hotmail.com yahoo.co.uk .live.com</strong>';
$string['configdisableuserimages'] = 'Skakel die vermoë af wat gebruikers toelaat om hul profiel-foto\'s te verander.';
$string['configdisplayloginfailures'] = 'Hierdie gaan inligting aan gebruikers vertoon oor vorige onsuksesvolle pogings om in te teken.';
$string['configdndallowtextandlinks'] = 'Ontsper of versper die vermoë om teks, skakels en lêers na \'n kursus bladsy te sleep en los.
Let daarop dat om teks na Firefox of tussen verskillende blaaiers te sleep onbetroubaar is en kan veroorsaak dat geen data opgelaai word nie. Korrup teks kan ook so opgelaai word.';
$string['configdoclang'] = 'Hierdie taal sal gebruik word in die skakels vir die dokumentasie bladsye.';
$string['configdocroot'] = 'Definieer die pad na Moodle Docs vir die verskaffing van konteksspesifieke dokumentasie via \'Hulp en dokumentasie\'-skakels in die voetskrif van elke bladsy. As die veld leeg gelaat word, sal skakels nie vertoon word nie.';
$string['configdoctonewwindow'] = 'As dit geaktiveer is, sal skakels na Moodle Docs in \'n nuwe venster gewys word.';
$string['configeditordictionary'] = 'Hierdie waarde gaan gebruik word as Aspell nie \'n woordeboek vir gebruikers se eie taal het nie.';
$string['configeditorfontlist'] = 'Selekteer die karakterfonts wat in die redakteur se aftrek keuselys moet verskyn.';
$string['configemailchangeconfirmation'] = 'Vereis \'n e-pos verifikasie stap wanneer gebruikers hul e-posadres hul profiel verander.';
$string['configemaildkimselector'] = 'Die DKIM selekteerder is arbitrêr en jou DNS rekord(s) moet hiermee ooreenstem.';
$string['configemailfromvia'] = 'Voeg by deur middel van informasie in die "Van" gedeelte van uitgaande e-posse. Hierdie stel die ontvanger in kennis waarvandaan hierdie e-pos kom en help ook om te verhoed dat ontvangers per ongeluk aan geen-antwoord e-posadresse antwoord.';
$string['configemailheaders'] = 'Rou e-pos opskrifte sal woord vir woord by alle uitgaande e-posse gevoeg word.';
$string['configemailsubjectprefix'] = 'Teks wat vooraan die onderwerp-lyn van alle uitgaande e-posse gevoeg word.';
$string['configenableactivitychooser'] = 'Die aktiwiteit kieser is \'n dialoog-boksie met \'n kort beskrywing van elke aktiwiteit en hulpbron. Indien vesper sal aparte hulpbron en aktiwiteit aftrek kieslyste voorsien word.';
$string['configenableanalytics'] = 'Analitiese modelle, soos \'Studente wat die gevaar loop om studies te staak\' of \'Opkomende aktiwiteite wat ingehandig moet word\', kan voorspellings genereer, insig kennisgewings aanstuur en verdere aksies uitvoer soos boodskappe aan gebruikers stuur';
$string['configenableblogs'] = 'Hierdie skakel voorsien al die webwerf gebruikers van hul eie webjoernaal.';
$string['configenablecalendarexport'] = 'Ontsper uitvoer of inteken tot kalenders.';
$string['configenablecomments'] = 'Ontsper kommentaar.';
$string['configenablecourserequests'] = 'Indien ontsper sal gebruikers met die vermoë om nuwe kursusse aan te vra (moodle/course:request) die posie hê om \'n kursus aan te vra. Hierdie vermoë word nie toegelaat vir enige van die verstek rolle nie. Dit kan in die stelsel of kategorie konteks aangewend word.';
$string['configenabledevicedetection'] = 'Ontsper die optel van sellulêre fone, intelligente fone, tablette of verstektoestelle (tafelrekenaars, skootrekenaars, ens.) vir die aanwending van temas en ander kenmerke.';
$string['configenablemobilewebservice'] = 'Ontsper mobiele diens vir die amptelike Moodle toep of enige ander toep wat toegang versoek. Vir meer inligting, lees die {$a}';
$string['configenablerssfeeds'] = 'Indien ontsper word RSS toevoer deur verskeie funksies regdeur die webwerf gegenereer soos webjoernale, forums, databasis aktiwiteite en woordelyste. Let daarop dat RSS toevoer ook vir die bepaalde aktiwiteit modules ontsper moet word.';
$string['configenablerssfeedsdisabled'] = 'Dit is nie beskikbaar nie omdat RSS toevoer in die hele webwerf vesper is. Om hulle te ontsper, gaan na die Veranderlikes instellings onder Administrasie Konfigurasie.';
$string['configenablerssfeedsdisabled2'] = 'RSS toevoer is tans op webwerf-vlak versper. Hulle kan in Gevorderde funksies in die webwerf administrasie ontsper word.';
$string['configenablestats'] = 'Indien jy \'ja\' kies gaan die Moodle se \'cronjob\' die logs prosesseer en sommige statistieke versamel. Afhangend van die aantal verkeer op die webwerf kan hierdie \'n tydjie neem. Indien jy hierdie ontsper sal jy in staat wees om interessante grafieke en statistieke van elkeen van jou kursusse te kan sien, of statistieke vanaf die hele webwerf.';
$string['configenabletrusttext'] = 'By verstek sal Moodle altyd teks wat van gebruikers af kom deeglik skoonmaak om enige moontlike skadelike skripteks en media te verwyder wat \'n sekuriteitsrisiko kan wees. Die Betroubare Inhoud sisteem is \'n manier om sekere gebruikers wat jy vertrou die vermoë te gee om hierdie gevorderde funksies in hul inhoud in te sluit sonder inmenging. Om hierdie sisteem te ontsper moet jy eerstens hierdie instelling ontsper en dan die Betroubare Inhoud toestemming aan \'n spesifieke Moodle rol toestaan. Teks wat deur hierdie gebruikers geskep of opgelaai word sal gemerk word as betroubaar en sal nie skoongemaak word voor dit vertoon word nie.';
$string['configenablewebservices'] = 'Webdienste ontsper ander sisteme, soos byvoorbeeld die Moodle toep, om by die webwerf in te teken en opdragte uit te voer. Vir ekstra sekuriteit moet hierdie instelling versper word indien jy nie die toep of \'n eksterne hulpmiddel/diens wat integrasie deur webdienste gebruik nie.';
$string['configenablewsdocumentation'] = 'Ontsper outo-generasie van dokumentasie vir webdienste. \'n Gebruiker kan toegang tot sy eie dokumentasie op sy sekuriteitssleutels bladsy {$a }verkry. Die vertoon slegs die dokumentasie van die protokols wat ontsper is.';
$string['configerrorlevel'] = 'Kies die aantal PHP waarskuwings wat jy wil laat vertoon. \'Normaal\' is gewoonlik die beste opsie.';
$string['configexportlookahead'] = 'Dae om vooruit te kyk tydens uitvoer.';
$string['configexportlookback'] = 'Dae om terug te kyk tydens uitvoer.';
$string['configextendedusernamechars'] = 'Indien ontsper kan gebruikersname enige karakters behalwe hoofletters bevat. Andersins sal slegs alfanumeriese karakters met kleinletters, onderstreeptekens (_), koppelteken (-), punt (.) en die aapstert (@) toegelaat word..';
$string['configextramemorylimit'] = 'Seker skiptekste soos soek, rugsteun/herstel of \'cronjob\' vereis meer geheue. Stel hoër waardes vir groter webwerwe.';
$string['configfilterall'] = 'Filtreer alle stringe, insluitend opskrifte, titels, navigasiestafie, ens. Dit is meestal nuttig wanner die \'multilang\' filter gebruik word, andersins gaan dit net ekstra las op jou webwerf laai en jou baie min baat.';
$string['configfiltermatchoneperpage'] = 'Outomatiese skakelings-filters gaan slegs \'n enkele skakel genereer vir die eerste keer wat ooreenkomstige teks op die bladsy as \'n geheel gevind word. Alle ander word geïgnoreer.';
$string['configfiltermatchonepertext'] = 'Outomatiese skakelings-filters gaan slegs \'n enkele skakel genereer vir die eerste keer wat ooreenkomstige teks in elke item van teks op die bladsy gevind word. Alle ander word geïgnoreer. Hierdie instelling het geen effek as \'Filter ooreenstemming een keer per bladsy\' ontsper is nie.';
$string['configfilternavigationwithsystemcontext'] = 'Normale gebruik van die filter is gekoppel aan die konteks waarin dit gebruik word (bv. kursuskonteks), maar vir die werfnavigasie, om alles uitdruklik te laat filtreer met werfkonteks kan prestasieverbeterings oplewer wanneer "inhoud en opskrifte"-filtrering gebruik word.';
$string['configfilteruploadedfiles'] = 'Prosesseer alle opgelaaide HTML en tekslêers met die filter voordat hulle vertoon word, slegs HTML bladsye of andersins geen.';
$string['configforcelogin'] = 'Normaalweg kan die tuisblad en die kursuslyste (maar nie kursusse nie) deur mense gelees word sonder om by die webwerf aan te meld. As u mense wil dwing om aan te meld voordat hulle IETS op die webwerf doen, moet u hierdie instelling inskakel.';
$string['configforceloginforprofiles'] = 'Hierdie instelling forseer mense om in te teken as \'n gebruiker (en nie \'n gas nie) voordat enige gebruiker se profiel besigtig kan word. Indien hierdie opsie versper is kan jy moontlik vind dat sommige gebruikers advertensies (rommelpos) of ander inhoud wat onvanpas is in hul profiele plaas. Hierdie is dan vir die hele wêreld sigbaar.';
$string['configfrontpage'] = 'Die items wat hierbo gekies is, sal op die werf se tuiste vertoon word.';
$string['configfrontpagecourselimit'] = 'Maksimum aantal kursusse';
$string['configfrontpagecourselimithelp'] = 'Maksimum aantal kursusse wat op die webtuiste in kursuslyste vertoon moet word.';
$string['configfrontpageloggedin'] = 'Die items wat hierbo gekies is, sal op die webwerf se tuiste vertoon word wanneer \'n gebruiker ingeteken is.';
$string['configfullnamedisplay'] = 'Dit definieer hoe name getoon word wanneer dit volledig vertoon word. Die standaardwaarde, "language", laat dit oor aan die string "fullnamedisplay" in die huidige taalpakket om te besluit. Sommige tale het verskillende naamvertoonkonvensies.

Vir die meeste eentalige webwerwe is die doeltreffendste instelling \'firstname lastname\', maar u kan kies om vanne heeltemal weg te steek. Plekhouers wat gebruik kan word, is: firstname, lastname, firstnamephonetic, lastnamephonetic, middlename en alternatename.';
$string['configgeoipfile'] = 'Plek van die GeoLite2 City binêre data-lêer. Hierdie lêer is nie deel van Moodle verspreiding nie en moet apart vanaf <a href="http://www.maxmind.com/">MaxMind</a> verkry word. Jy kan of \'n kommersiële weergawe koop of die gratis weergawe gebruik. Jy sal moet registreer om die City databasis lêer af te laai by <a href="http://geolite.maxmind.com/download/geoip/database/GeoLite2-City.mmdb.gz" >http://geolite.maxmind.com/download/geoip/database/GeoLite2-City.mmdb.gz</a>. Wanneer jy geregistreer is en die lêer afgelaai het kan jy dit na die "{$a}" lêergids op jou bediener onttrek.';
$string['configgetremoteaddrconf'] = 'Indien jou bediener agter \'n omgekeerde instaanbediener is, kan jy hierdie instellling gebruik om te spesifiseer watter HTTP opskrifte vertrou kan word om die afgeleë IP-adres te behou. Die opskrifte word in volgorde gelees en die eerste beskikbare een word gebruik.';
$string['configgradebookroles'] = 'Hierdie instelling laat jou toe om te beheer wie op die punteboek verskyn. Gebruikers moet ten minste een van hierdie rolle in \'n kursus hê om in die punteboek vir daardie kursus gewys te word.';
$string['configgradeexport'] = 'Kies watter uitvoer formate vir jou punteboek jou primêre metode is vir die uitvoer van punte. Gekose inproppe sal dan \'n "laas uitgevoer" veld vir elke punt instel en gebruik. Hierdie kan byvoorbeeld versoorsaak dat rekords wat uitgevoer is geïdentifiseer word as "nuut" of "opgedateer". As jy onseker is hieroor, los alles eerder ongemerk.

Kies watter manier die verstel manier moet wees om punteboeke af te laai. Die gekose plugin sal dan \'n ekstra veld (\'last exported\') byvoeg en byhou vir elke punt. Byvoorbeeld, hierdie kan veroorsaak dat punte slegs afgelaai word wat as "nuut" of "verander" geïdentifiseer word. Indien jy nie hieroor seker is nie, los die opsie af.';
$string['confighiddenuserfields'] = 'Selekteer watter inligting jy graag wil versteek van ander gebruikers wat nie die kursus administrateurs en/of onderwysers is nie. Dit sal studente-privaatheid verhoog. Hou die CTRL-sleutel in om meer as een veld te kies.';
$string['configidnumber'] = 'Hierdie opsie spesifiseer of (a) Gebruikers glad nie gevra word vir \'n ID-nommer nie, (b) Gebruikers gevra word vir \'n ID-nommer maar dit leeg kan los, of (c) Gebruikers gevra word vir \'n ID-nommer en dit nie leeg kan los nie. Indien die gebruiker se ID-nommer gegee word, word dit in hul Profiel vertoon.';
$string['configintro'] = 'Op hierdie bladsy kan jy \'n aantal konfigurasie veranderlikes spesifiseer wat sal help dat Moodle behoorlik op jou bediener werk. Moenie te veel daaroor bekommer nie - die verstekinstellings werk gewoonlik goed en jy kan altyd later na hierdie bladsy terugkeer en hierdie instellings verander.';
$string['configintroadmin'] = 'Op hierdie bladsy moet jy die hoof administrateur rekening konfigureer. Hierdie rekening sal totale beheer oor die webwerf hê. Maak seker dat jy dit met \'n veilige gebruikersnaam en wagwoord verskaf, sowel as \'n geldige e-posadres. Jy kan later meer administasie rekeninge oopmaak.';
$string['configintrosite'] = 'Met hierdie bladsy kan u die webwerf se tuisblad en naam van hierdie nuwe webwerf opstel.  U kan later hierheen terugkom om hierdie instellings te eniger tyd te verander met behulp van die administrasie-kieslyste.';
$string['configiplookup'] = 'Wanneer jy op \'n IP-adres klik (soos 34.12.222.93) soos wat in die logs voorkom, gaan die stelsel vir jou \'n kaart vertoon met die beste raaiskoot van waar daardie IP-adres voorkom. Daar is verskeie inproppe hiervoor beskikbaar, elkeen met sy voor- en nadele.';
$string['configkeeptagnamecase'] = 'Kies hierdie opsie indien jy wil hê dat etiket name die oorspronklike hoof- en kleinletters moet behou soos deur die gebruiker geskep.';
$string['configlang'] = 'Kies die verstek taal vir die hele webwerf. Gebruikers kan hierdie instelling oorheers deur die taal kieslys in hul persoonlike profiel te gebruik.';
$string['configlanglist'] = 'Indien leeg gelaat word alle tale wat op die webwerf geïnstalleer is in die taal kieslys vertoon. Alternatiewelik kan die taal kieslys verkort word deur \'n lys van taalkodes, geskei deur kommas (byvoorbeeld en, de, fr) in te voer. Jy kan ook \'n ander naam vir \'n taal gee as hoe die taalpakket die naam gespesifiseer het deur die voglende formaat te gebruik: taalkode|taal naam bv. en_kids|English,de_kids|Deutsch.';
$string['configlangmenu'] = 'Kies of jy die algemene taal kieslys op die tuisblad, inteken blad, ens. wil vertoon of nie. Hierdie opsie beïnvloed nie die gebruiker se keuse om \'n voorkeurtaal in hul eie profiel in te stel nie.';
$string['configlangstringcache'] = 'Kas al die taalstringe in gekompileerde lêers in die data gidslêer. As jy besig is om Moodle te vertaal of stringe in die Moodle bronkode te verander sal jy moontlik hierdie wil afskakel. Jy kan dit ook aanlos om werksverrigting voordele te sien.

 gekombineerde lêers in die data-gids. Indien jy besig is om Moodle te vertaal of besig is om stringe te verander in die Moodle bronkode, dan moet jy verkieslik hierdie opsie afskakel. Andersins, los die opsie aangeskakel en sien die prestasie voordele.';
$string['configlatinexcelexport'] = 'Kies die enkodering wat gebruik moet word vir Excel uitvoere.';
$string['configlocale'] = 'Kies webwerfwye lokaliteit - hierdie sal die formaat en taal van datums oorheers vir alle taalpakkette (name van dae in kalenders sal nie geaffekteer word nie). Hierdie data van die lokaliteit moet op jou bedryfstelsel geïnstalleer wees (bv. for linux en_US.UTF-8 of es_ES.UTF-8). In meeste gevalle moet hierdie veld leeg gelaat word.';
$string['configlockrequestcategory'] = 'Indien ontsper kan gebruikers met die vermoë om nuwe kursusse aan te vra in die stelsel konteks nie toegelaat word om \'n kategorie te kies in die vorm waarin nuwe kursusse aangevra word nie. \'n Alternatiewe manier om gebruikers te beperk om \'n nuwe kursus in slegs een kategorie aan te vra, is om die vermoë om nuwe kursusse aan te vra in die kategorie konteks aan te wend.';
$string['configloglifetime'] = 'Hierdie spesifiseer hoe lank jy logs van gebruikersaktiwiteite wil hou. Logs wat ouer as hierdie ouderdom is word outomaties uitgewis. Dit is beter om logs so lank as moontlik te hou ingeval jy hulle benodig, maar as jy \'n baie besige bediener het en probleme met werksverrigting ervaar sal jy moontlik die leeftyd van die logs wil verminder. Waardes minder as 30 word nie voorgestel nie, omdat statistieke dan nie behoorlik sal werk nie.';
$string['configlookahead'] = 'Dae om vooruit te kyk';
$string['configmailnewline'] = 'Karakters wat gebruik word om \'n nuwe lyn aan te dui in e-pos boodskappe. CRLF word vereis volgens RFC 822bis, sekere e-posbedieners skakel LF na CRLF outomaties oor en ander e-posbedieners skakel verkeerd van CRLF na CRCRLF om. Sommige e-posbedieners verwerp e-posse wat bloot LF bevat (byvoorbeeld qmail). Probeer om hierdie instelling aan te pas indien jy probleme ondervind met onafgelewerde e-posse of e-posse met dubbele spasies (dubbele skoon lyne).';
$string['configmaxbytes'] = 'Hierdie spesifiseer die maksimum grootte vir lêers wat na die webwerf opgelaai kan
word. Hierdie instelling word beperk deur die PHP instellings post_max_size en upload_max_filesize, sowel as die Apache instelling LimitRequestBody. Daarmee saam beperk maxbytes die reeks van groottes wat op kursus- of aktiwiteitsvlak gekies kan word. Indien die \'Webwerf oplaai limiet\' gekies word, sal maksimum grootte wat die bediener toelaat gebruik word.';
$string['configmaxconsecutiveidentchars'] = 'Wagwoorde moet nie meer as hierdie aantal opeenvolgende identiese karakters bevat nie. Gebruik 0 om hierdie kontole te ontsper.';
$string['configmaxeditingtime'] = 'Hierdie spesifiseer die hoeveelheid tyd wat mense het om inskrywings op forums, kommentaar op woordelyste, ens. weer te redigeer. 30 Minute is gewoonlik \'n goeie waarde.';
$string['configmaxevents'] = 'Gebeure vir Vooruitkyk';
$string['configmaxusersperpage'] = 'Maksimum aantal gebruikers wat vertoon word binne die gebruiker selekteerder in die kursus, groep, kohort, webdiens, ens.';
$string['configmessaging'] = 'Indien ontsper kan gebruikers boodskappe na ander gebuikers op die webwerf stuur.';
$string['configmessagingallowemailoverride'] = 'Laat gebruikers toe om e-posboodskap kennisgewings na \'n e-posadres te stuur wat verskil van die e-posadres in hul profiel.';
$string['configmessagingallusers'] = 'Indien ontsper kan gebruikers die lys van alle gebruikers op die webwerf besigtig wanneer hulle kies vir wie hulle \'n boodskap wil stuur en hul boodskapvoorkeure sluit die opsie in om boodskappe van enigiemand op die webwerf te aanvaar. Indien versper sal gebruikers slegs die lys van gebruikers in hul kursusse kan besigtig. Hulle het ook net twee opsies by boodskapvoorkeure: om boodskappe slegs van hul kontakte te aanvaar of om boodskappe vanaf hul kontakte en gebruikers in hul kursusse te aanvaar.';
$string['configmessagingdefaultpressenter'] = 'Of \'Gebruik die invoersleutel om te stuur\' by verstek in gebruikers se boodskap instellings onstper is.';
$string['configmessagingdeleteallnotificationsdelay'] = 'Gelees en nie-gelees kennisgewings kan uitgewis word om spasie te maak. Hoe lank nadat \'n kennisgewing geskep is kan dit uitgewis word?';
$string['configmessagingdeletereadnotificationsdelay'] = 'Gelees kennisgewings kan uitgewis word om plek te spaar. Hoe lank nadat \'n kennisgewing gelees is kan dit uitgewis word?';
$string['configminpassworddigits'] = 'Wagwoorde moet ten minste hierdie aantal syfers bevat.';
$string['configminpasswordlength'] = 'Wagwoorde moet ten minste hierdie aantal karakters bevat.';
$string['configminpasswordlower'] = 'Wagwoorde moet ten minste hierdie aantal kleinletters bevat.';
$string['configminpasswordnonalphanum'] = 'Wagwoorde moet ten minste hierdie aantal nie-alfanumeriese karakters bevat.';
$string['configminpasswordupper'] = 'Wagwoorde moet ten minste hierdie aantal hoofletters bevat.';
$string['configmodchooserdefault'] = 'Moet die aktiwiteitskieser by verstek aan gebruikers vertoon word?';
$string['configmycoursesperpage'] = 'Maksimum aantal kursusse wat in enige lys van \'n gebruiker se eie kursusse vertoon moet word.';
$string['configmymoodleredirect'] = 'Hierdie instelling forseer herleidings na /my wanneer ingeteken word vir nie-admin gebruikers en vervang die boonste vlak webwerf se navigasie met /my';
$string['configmypagelocked'] = 'Hierdie instelling voorkom dat enige nie-admin gebruikers die verstekbladsy redigeer.';
$string['confignavcourselimit'] = 'Beperk die aantal kursusse wat vir die gebruiker vertoon word in die navigasie.';
$string['confignavshowallcourses'] = 'Hierdie instelling bepaal of gebruikers wat vir kursusse ingeskryf is Kursusse (die naamlys van alle kursusse) in die navigasie kan sien, tesame met My Kursusse (lys van kursusse waarin die gebruiker ingeskryf is).';
$string['confignavshowcategories'] = 'Vertoon die kategorieë van kursusse in die navigasiestafie en navigasieblokke. Hierdie gebeur nie vir kursusse waarvoor die gebruiker ingeskryf is nie. Hulle sal nog steeds beskikbaar wees onder \'My Kursusse\' sonder kategorieë.';
$string['confignoreplyaddress'] = 'E-posse word soms namens gebruikers uitgestuur (bv. inskrywings op forums). Die e-posadres wat hier gespesifiseer word sal as die "Van" adres gebruik word in daardie gevalle waar die ontvangers nie in staat sal wees om die gebruiker direk te antwoord nie (bv. wanneer \'n gebruiker verkies om hul adres privaat te hou). Hierdie instelling sal ook gebruik word as die koevert-afsender wanneer e-posse gestuur word.

uitgestuur namens gebruikers (bv. forum inskrywings). Die e-posadres wat jy hier spesifiseer word gebruik in die "From" adres in die gevalle waar die ontvanger nie in staat moet wees om direk na die gebruiker mag antwoord nie (bv. wanneer \'n gebruiker gekies het om hul e-posadres as privaat te merk). Hierdie instelling gaan ook gebruik word as die koevert sender wanneer e-posse gestuur word.';
$string['confignotifyloginfailures'] = 'Stuur kennisgewings van mislukte pogings om in te teken na hierdie geselekteerde gebruikers. Dit vereis \'n interne logstoor (bv. Standaard Logstoor) om ontsper te wees.';
$string['confignotifyloginthreshold'] = 'Indien kennisgewings oor mislukte intekens aktief is, hoeveel mislukte inteken pogings deur een gebruiker of IP-adres is die moeite werd om kennisgewings oor te stuur?';
$string['confignotloggedinroleid'] = 'Gebruikers wat nie op die webwerf ingeteken is nie sal behandel word asof hulle hierdie rol in webwerf konteks verkry het. \'Gas\' is amper altyd wat jy hier wil hê, maar jy sal moontlik rolle wil skep wat minder of meer beperk is. Om byvoorbeeld \'n plasing te skep sal steeds vereis dat die gebruiker behoorlik inteken.';
$string['configopentowebcrawlers'] = 'Indien hierdie instelling ontsper is, sal soekenjins toegelaat word om webwerf as \'n gas binne te tree. Mense wat na jou webwerf toe kom deur \'n soekenjin sal ook outomaties as \'n gas ingeteken word. Let daarop dat hierdie slegs deursigtige toegang bied tot kursusse wat reeds gastetoegang toelaat.';
$string['configoverride'] = 'Gedefinieer in config.php';
$string['configpasswordpolicy'] = 'Indien ontsper sal gebruiker wagwoorde met die wagwoordbeleid soos in die instellings hier onder uiteengesit gekontroleer word. Om die wagwoordbeleid te ontsper sal nie bestaande gebruikers affekteer totdat hulle besluit of aangemaan word om hul wagwoorde te verander nie, of as die \'Kontroleer wagwoord op inteken\' instelling ontsper is nie';
$string['configpasswordpolicycheckonlogin'] = 'Indien ontsper sal gebruikerswagwoorde elke keer wanneer gebruikers inteken met die wagwoordbeleid gekontroleer word. Indien daar \'n fout opduik sal die gebruiker hul wagwoord moet verander voordat hulle verder kan gaan. Dit is nuttig om hierdie instelling te ontsper nadat die wagwoordbeleid opgedateer is.';
$string['configpasswordresettime'] = 'Hierdie spesifiseer die hoeveelheid tyd wat gebruikers het om \'n wagwoord terugstelling te verifieer voordat dit verval. 30 minute is gwoonlik \'n goeie waarde.';
$string['configpathtodu'] = 'Baan na du. Gewoonlik iets soos /usr/bin/du. Indien jy hierdie insleutel sal bladsye wat die inhoud van gidslêers vertoon baie vinniger hardloop vir gidslêers wat baie lêers bevat.';
$string['configpathtophp'] = 'Baan na PHP CLI. Gewoonlik iets soos /usr/bin/php. Indien jy hierdie insleutel sal cron skriptekste vanaf die admin web koppelvlak uitvoer.';
$string['configperfdebug'] = 'Indien jy hierdie aanskakel sal werksverrigting inligting in die voetstuk van die standaard tema uitgedruk word.';
$string['configprofileroles'] = 'Rolle wat in gebruikersprofiele en op die deelnemersbladsy gelys word.';
$string['configprofilesforenrolledusersonly'] = 'Om misbruik deur mense wat rommelpos aanstuur te voorkom, word profiel-beskrywings van gebruikers wat nog nie vir enige kursusse ingeskryf het nie weggesteek. Nuwe gebruikers moet vir ten minste een kursus inskryf voordat hulle \'n profiel-beskrywing kan byvoeg.';
$string['configprotectusernames'] = 'Indien ontsper gaan die vergete wagwoord vorm nie enige wenke vertoon wat kan toelaat dat rekening gebruikersname of e-posadresse geraai kan word nie.';
$string['configproxybypass'] = 'Komma-geskeide lys van (gedeeltelike) gasheername of IP-adresse wat die instaanbediener moet omseil (bv. 192.168., .mydomain.com)';
$string['configproxyfixunsafe_help'] = 'Dit poog om interne oproepe reg te stel wat nie deur die instaanbediener gaan nie deur die MoodleBot-gebruikersagent by te voeg en die instaanbediener te gebruik.';
$string['configproxyhost'] = 'Indien hierdie <b>bediener</b> \'n instaanrekenaar benodig (bv. \'n brandmuur) om toegang tot die internet te verkry, voorsien die instaanbediener gasheernaam hier. Andersins moet dit leeg gelaat word.';
$string['configproxylogunsafe_help'] = 'Dit probeer om interne oproepe aan te teken wat nie deur die instaanbediener gaan nie en moet.';
$string['configproxypassword'] = 'Wagwoord wat benodig word om toegang tot die internet deur die instaanbediener te verkry indien vereis. Los dit andersins leeg (PHP cURL uitbreiding word benodig).';
$string['configproxyport'] = 'Indien die bediener \'n instaanrekenaar benodig, verskaf die instaanpoort hier.';
$string['configproxytype'] = 'Tipe web instaanbediener (PHP5 en cURL uitbreinding benodig vir SOCKS5 ondersteuning).';
$string['configproxyuser'] = 'Gebruikersnaam benodig om toegang tot die internet deur instaanbediener te verkry indien vereis. Los leeg indien geen (PHP cURL uitbreiding vereis).
Gebruikersnaam wat benodig word om toegang tot die internet te kry deur die proxy, indien nodig, anders los dit leeg (PHP cURL uitbreiding word benodig).';
$string['configrecaptchaprivatekey'] = 'String van karakters (geheime sleutel) wat gebruik word om tussen jou Moodle bediener en die recaptcha bediener te kommunikeer. ReCAPTCHA sleutels kan vanaf  <a target="_blank" href="https://www.google.com/recaptcha">Google reCAPTCHA</a> verkry word.';
$string['configrecaptchapublickey'] = 'String karakters (werfsleutel) wat gebruik word om die reCAPTCHA-element in die aanmeldvorm en werfondersteuningsvorm te vertoon. ReCAPTCHA-sleutels kan verkry word vanaf <a target = "_blank" href = "https://www.google.com/recaptcha">Google reCAPTCHA</a>.';
$string['configrequestedstudentname'] = 'Woord vir student in kursusse wat aangevra word.';
$string['configrequestedstudentsname'] = 'Woord vir studente in kursusse wat aangevra word.';
$string['configrequestedteachername'] = 'Woord vir onderwyser in kursusse wat aangevra word.';
$string['configrequestedteachersname'] = 'Woord vir onderwysers in kursusse wat aangevra word.';
$string['configreverseproxyignore'] = 'Indien jou bediener agter veelvuldige omgekeerde instaanbedieners is wat tot die X-Forwarded-For opskrif bygevoeg is, spesifiseer \'n komma-geskeide lys van IP-adresse of subnette van die omgekeerde instaanbedieners wat geïgnoreer moet word om die gebruiker se korrekte IP-adres te vind.';
$string['configsectioninterface'] = 'Koppelvlak';
$string['configsectionmail'] = 'Pos';
$string['configsectionmaintenance'] = 'Instandhouding';
$string['configsectionmisc'] = 'Verskeie';
$string['configsectionoperatingsystem'] = 'Bedryfstelsel';
$string['configsectionpermissions'] = 'Toestemmings';
$string['configsectionrequestedcourse'] = 'Kursus aansoeke';
$string['configsectionsecurity'] = 'Sekuriteit';
$string['configsectionstats'] = 'Statistieke';
$string['configsectionuser'] = 'Gebruiker';
$string['configsecureforms'] = 'Moodle kan \'n addisionele vlak van sekuriteit gebruik wanneer data vanaf web vorms aanvaar word. Indien hierdie ontsper is word die blaaier se HTTP_REFERER veranderlike teen die huidige vorm adres gekontroleer. In slegs \'n paar gevalle kan hierdie probleme veroorsaak indien die gebruiker \'n brandmuur (bv. Zonealarm) gebruik wat gekonfigureer is om HTTP_REFERER van hul webverkeer af te haal. Om vas te haak op \'n vorm is een van die simptome hiervan. Indien jou gebruikers byvoorbeeld probleme met die intekenblad ervaar wil jy moontlik hierdie instelling versper. Let daarop dat hierdie aksie jou webwerf kwesbaar kan laat tot brute krag-aanvalle op wagwoorde. Indien jy twyfel, los hierdie instellng op \'Ja\'.';
$string['configsessioncookie'] = 'Hierdie instelling pas die naam van die koekie wat vir Moodle sessies gebruik word aan. Hierdie is opsioneel en slegs nuttig om te voorkom dat koekies met mekaar verwar word indien meer as een kopie van Moodle binne dieselfde webwerf gehardloop word.';
$string['configsessioncookiedomain'] = 'Hierdie instelling laat jou toe om die domein waarvan Moodle koekies beskikbaar is te verander. Hierdie is nuttig vir Moodle aanpassings (bv. verifikasie- of inskrywingsinproppe) wat Moodle se sessie-inligiting met \'n webtoepassing op \'n ander subdomein  moet deel. <strong>WAARSKUWING: dit word streng aanbeveel om hierdie intelling op die verstekwaarde (leeg) te los - \'n foutiewe waarde kan veroorsaak dat niemand op die webblad kan inteken nie.</strong>';
$string['configsessioncookiepath'] = 'Indien jy nodig het om te verander waarheen webblaaiers Moodle koekies stuur, kan jy hierdie instelling verander om \'n subgidslêer van jou webwerf te spesifiseer. Andersins sal die verstek \'/\' voldoende wees.';
$string['configsessiontimeout'] = 'Indien mense wat op hierdie webwerf ingeteken is vir \'n lang tydperk onaktief is (sonder om bladsye te laai), word hulle outomaties uitgeteken (hul sessie word beëindig). Hierdie veranderlike spesifiseer hoe lank hierdie tydperk moet wees.';
$string['configsessiontimeoutwarning'] = 'Indien mense wat op hierdie webwerf ingeteken is vir \'n lang tydperk onaktief is (sonder om bladsye te laai), word hulle gewaarsku dat hul sessie beeïndig gaan word. Hierdie veranderlike spesifiseer hoe lank hierdie tydperk moet wees.';
$string['configsessiontimeoutwarningcheck'] = 'Sessie-spertydperk waarskuwing moet minder as die sessie-spertydperk wees.';
$string['configshowcommentscount'] = 'Vertoon die kommentaar-telling. Dit sal meer as een navraag kos wanneer vertoon-kommentaar met mekaar skakel.';
$string['configshowicalsource'] = 'Vertoon die broninligting vir iCal gebeure';
$string['configshowsiteparticipantslist'] = 'Al hierdie studente en onderwysers op die webwerf sal op die webwerf se deelnemerslys gelys word. Wie sal toegelaat word om hierdie deelnemerslys te sien?';
$string['configsitedefaultlicense'] = 'Verstek webwerf lisensie';
$string['configsitedefaultlicensehelp'] = 'Die verstek lisensie vir publisering van inhoud op hierdie webwerf';
$string['configsitemailcharset'] = 'Hierdie instelling spesifiseer die verstek karakterstel vir alle e-posse wat vanaf die webwerf gestuur word.';
$string['configsitemaxcategorydepth'] = 'Maksimum kategorie-diepte';
$string['configsitemaxcategorydepthhelp'] = 'Hierdie spesifiseer die maksimum diepte van uitgebreide kinder-kategorieë wanneer kategorieë of kombinasielyste vertoon word. Katergorieë op \'n dieper vlak sal as skakels veskyn en die gebruiker kan hulle met die AJAX-versoek uitbrei.';
$string['configslasharguments'] = '\'Slash arguments\' (gebruik <em>PATH_INFO</em>) word benodig vir SCORM pakette en multi-lêer hulpbronne om korrek te vertoon. As jou webbediener nie \'slash arguments\' ondersteun nie en jy nie daarin slaag om dit te konfigureer nie, kan hierdie instelling versper word. Let daarop dat dit sal veroorsaak dat sommige goed nie werk nie. <br />Nota: Die gebruik van \'slash arguments\' sal in toekomstige weergawes van Moodle vereis word.';
$string['configsmartpix'] = 'Met hierdie aangeskakel word ikone bedien deur \'n PHP-skrip wat die huidige tema deursoek, dan alle boliggende temas en dan die Moodle /pix lêer. Hierdie verminder die behoefte om beeldlêers binne temas te dupliseer, maar kos bietjie meer werksverrigting.';
$string['configsmtpauthtype'] = 'Dit stel die verifikasietipe in om op SMTP-bediener te gebruik.';
$string['configsmtphosts'] = 'Verskaf die volle naam van een of meer lokale SMTP bedieners wat Moodle moet gebruik om e-poss te stuur (bv. \'mail.a.com\' of \'mail.a.com;mail.b.com\'). Om \'n nie-verstek poort te spesifiseer (d.w.s. \'n poort anders as poort 25) kan jy die [bediener]:[poort] sintaksis (bv.  \'mail.a.com:587\') gebruik. Vir veilige konneksies word poort 465 gewoonlik saam met SSL gebruik en poort 587 saam met TLS. Spesifiseer dan die sekuriteit-protokol hieronder indien benodig. Indien jy hierdie instelling leeg los sal Moodle die PHP verstek-metode gebruik om e-posse te stuur.';
$string['configsmtpmaxbulk'] = 'Maksimum aantal boodskappe wat per SMTP sessie gestuur kan word. Om boodskappe te groepweer kan moontlik die stuur van e-posse bespoedig. Waardes minder as 2 forseer die skep van \'n nuwe SMTP sessie vir elke e-pos.';
$string['configsmtpoauthservice'] = 'Kies die OAuth 2-diens wat opgestel is om met die SMTP-bediener te praat. As die diens nog nie bestaan nie, sal jy dit moet skep. Let daarop dat jy die SMTP Auth Type op XOAUTH2 moet stel.';
$string['configsmtpsecure'] = 'Indien die SMTP bediener \'n veilige konneksie benodig, spesifiseer die korrekte protokol-tipe.';
$string['configsmtpuser'] = 'Indien jy \'n SMTP bediener hierbo gespesifiseer het en die bediener vereis verifikasie, verskaf die gebruikersnaam en wagwoord hier.';
$string['configstartwday'] = 'Begin van die week';
$string['configstatsfirstrun'] = 'Hierdie spesifiseer hoe ver terug die die logs <b>die eerste keer</b> geprosesseer moet word wanneer cronjob die statistieke wil prosesseer. As jy baie verkeer het en \'n gasheer deel is dit waarskynlik nie \'n goeie idee om te ver terug te gaan nie. Dit kan lank vat om te hardloop en kan redelik hulpbron-intensitief wees. (Let wel dat 1 maand = 28 dae vir hierdie instelling. In die grafieke en verslae wat genereer word is 1 maand gelyk aan 1 kalendermaand.)';
$string['configstatsmaxruntime'] = 'Om statistieke te prosesseer kan redelik intensief wees, so gebruik \'n kombinasie van hierdie veld en die volgende een om te spesifiseer wanneer en vir hoe lank dit moet hardloop.';
$string['configstatsmaxruntime2'] = 'Om statistieke te prosesseer kan redelik intensief wees, so spesifiseer die maksimum toegelate tyd vir die insameling van een dag se statistieke. Die maksimum getal dae wat in een cron uitvoering geprosesseer kan word is 31.';
$string['configstatsmaxruntime3'] = 'Hierdie spesifiseer die maksimum toegelate tyd vir die berekening van een dag se statistieke. Hou in gedagte dat hierdie prosessering van statistieke \'n groot las op die bediener kan plaas.  Die maksimum getal dae wat in een cron geprosesseer word kan hier onder gespesifiseer word.';
$string['configstatsruntimedays'] = 'Hierdie spesifiseer die maksimum aantal dae wat in elke uitvoering van statistieke geprosesseer word. Sodra die statistieke op datum is sal slegs een dag geprosesseer word. Pas hierdie waarde dan aan afhangend van die als wat jou bediener kan hanteer. Verminder dit indien korter cron uitvoerings benodig word.';
$string['configstatsruntimestart'] = 'Hoe laat moet die cronjob wat statistieke prosesseer begin? Dit word voorgestel om verskillende tye te spesifiseer indien daar meer as een Moodle webwerf op een bediener is.';
$string['configstatsuserthreshold'] = 'Hierdie instelling spesifiseer die minimum aantal ingeskryfde gebruikers wat \'n kursus moet hê om in die berekening van statistieke ingesluit te word.';
$string['configstrictformsrequired'] = 'Indien ingestel word gebruikers verhoed om slegs \'n spasie of \'n nuwe lyn in verpligte velde in vorms in te tik.';
$string['configstripalltitletags'] = 'Skakel hierdie insteling af om HTML-etikette in aktiwiteit- en hulpbronname toe te laat.';
$string['configsupportavailability'] = 'Bepaal wie toegang het tot kontak werfondersteuning vanaf die voetskrif.';
$string['configsupportemail'] = 'As SMTP op hierdie webwerf gekonfigureer is en \'n ondersteuningsbladsy nie ingestel is nie, sal hierdie e-posadres boodskappe ontvang wat via die ondersteuningsvorm ingedien word. As die stuur misluk, sal die e-posadres aan aangemelde gebruikers vertoon word.';
$string['configsupportname'] = 'Die naam van die persoon of ander entiteit wat ondersteuning bied via die ondersteuningsvorm of ondersteuningsblad.';
$string['configsupportpage'] = 'Voer die skakel van \'n ondersteuningsbladsy in of laat leeg om na \'n kontakvorm te skakel. Die skakel word in die voetskrif van die webwerf vertoon.';
$string['configtempdatafoldercleanup'] = 'Verwyder tydelike datalêers van die datagids wat ouer as die geselekteerde tyd is.';
$string['configthemedesignermode'] = 'Gewoonweg word alle temabeelde en stylblaaie in blaaiers en op die bediener vir \'n baie lang tyd gekas vir die onthalwe van werksverrigting. Indien jy temas ontwerp of kode ontwikkel sal jy moontlik hierdie modus vir aanskakel sodat jy nie gekasde weergawes bedien word nie. Waarskuwing: hierdie sal jou webwerf vir alle gebruikers stadiger maak! Andersins kan jy ook die tema-kasbergings met die hand herset vanaf die Tema-seleksie bladsy.';
$string['configthemelist'] = 'Los hierdie leeg indien enige geldige tema gebruik kan word. Indien jy die tema-kieslyste korter wil maak, kan jy \'n komma-geskeide lys van name hier spesifiseer (moet nie spasies gebruik nie!). Byvoorbeeld: standard,orangewhite.';
$string['configtimezone'] = 'Hierdie is die verstek tydsone wat gebruik word om datums te vertoon - elke gebruiker kan hierdie instelling in hul eie profiel oorskryf. Cronjob take en ander bediener-instellings word in hierdie tydsone gespesifiseer. Jy moet hierdie instelling verander indien dit as "Invalid timezone" vertoon.';
$string['configuseblogassociations'] = 'Moet gebruikers in staat wees om hul webjoernaal te organiseer deur inskrywings met kursusse en kursus-modules te assosieer?';
$string['configuseexternalyui'] = 'In plaas daarvan om plaaslike lêers te gebruik, gebruik aanlyn lêers wat op Yahoo se bedieners beskikbaar is. WAARSKUWING: Hierdie vereis \'n internet konneksie, anders gaan geen AJAX op jou webwerf werk nie. Hierdie instelling is nie versoenbaar met webwerwe wat https gebruik nie.';
$string['configusesitenameforsitepages'] = 'Indien ontsper sal die webwerf se kort naam vir die webwerf bladsye nodus in die navigasie gebruik word, in plaas van die string \'Site pages\'.';
$string['configusetags'] = 'Moet etiket funksionaliteit oor die hele webwerf ontsper word?';
$string['configvariables'] = 'Veranderlikes';
$string['configverifychangedemail'] = 'Ontsper verifikasie van veranderde e-poadresse deur toelaatbare en geblokkeerde e-pos domein-instellings te gebruik. Indien hierdie instelling versper is, word die domeine slegs afgedwing wanneer nuwe gebruikers geskep word.';
$string['configvisiblecourses'] = 'Vertoon kursusse in weggesteekde kategorieë normaalweg';
$string['configwarning'] = 'Wees versigtig om hierdie instellings te verander - vreemde waardes kan probleme veroorsaak.';
$string['configyuicomboloading'] = 'Hierdie opsie ontsper gekombineerde lêer-laaiing optimalisasie vir YUI biblioteke. Hierdie instelling moet op lewendige webwerwe ontsper word vir werksverrrigting redes.';
$string['confirmation'] = 'Bevestiging';
$string['confirmcontextlock'] = '{$a->contextname} is huidiglik ontvries. Deur dit te vries sal dit leesalleen word en gebruikers verhoed om veranderinge te maak. Is jy seker jy wil hiermee voortgaan?';
$string['confirmcontextunlock'] = '{$a->contextname} is huidiglik gevries. Deur dit te ontvries sal gebruikers in staat wees om veranderinge te maak. Is jy seker jy wil hiermee voortgaan?';
$string['confirmdeletecomments'] = 'Jy gaan kommentaar uitwis. Is jy seker?';
$string['confirmed'] = 'Bevestig';
$string['contactsitesupport'] = 'Kontak werfondersteuning';
$string['contenttypeuninstalling'] = 'Daar is {$a->count} inhoude deur {$a->type} ondersteun. Hulle sal uitgewis word. Is jy seker jy wil voortgaan?';
$string['contextlockappliestoadmin'] = 'Konteks-vriesing is toepaslik op administrateurs';
$string['contextlockappliestoadmin_desc'] = 'Indien onstper sal administrateurs met skryf-toegang tot alle gevriesde kontekste gelaat word.';
$string['contextlocking'] = 'Konteks-vriesing';
$string['contextlocking_desc'] = 'Hierdie instelling laat toe dat leesalleen toegang vir geselekteerde kategorieë, kursusse, aktiwiteite of blokke ingestel kan word.';
$string['cookiehttponly'] = 'Slegs http koekies';
$string['cookiesecure'] = 'Slegs veilige koekies';
$string['country'] = 'Verstek land';
$string['course_customfield'] = 'Kursus doelgemaakte velde';
$string['coursecolor'] = 'Kleur {$a}';
$string['coursecolorheading_desc'] = 'Enige kursusse sonder \'n ingestelde kursusbeeld in die kursus-instellings word op die Paneelbord vertoon as \'n kursuskaart met \'n patroon. Die kleure in die patroon kan hier onder gespesifiseer word.';
$string['coursecolorsettings'] = 'Kursuskaart kleure';
$string['coursecontact'] = 'Kursus kontakte';
$string['coursecontact_desc'] = 'Hierdie instelling laat jou toe om te beheer wie op die kursusbeskrywing verskyn. Gebruikers moet ten minste een van hierdie rolle in \'n kursus hê om op die kursusbeskrywing vir daardie kursus vertoon te word.';
$string['coursecontactduplicates'] = 'Vertoon alle kursus kontak rolle';
$string['coursecontactduplicates_desc'] = 'Indien ontsper sal gebruikers met meer as een van die geselekteerde kursus kontak rolle in die kursusbeskrywing vertoon word, tesame met elkeen van hul rolle. Andersins sal hulle vertoon word met slegs een rol (die rol wat die hoogste gelys is in \'Define Roles\' in die Webwerf administrasie).';
$string['coursegraceperiodafter'] = 'Grasieperiode vir verlede kursusse';
$string['coursegraceperiodbefore'] = 'Grasieperiode vir toekomstige kursusse';
$string['courselistshortnames'] = 'Vertoon uitgebreide kursusname';
$string['courselistshortnames_desc'] = 'Indien ontsper word die kort name van kursusse saam met die uitgebreide kursusname in die kursuslys vertoon. Indien vereis kan die uitgebreide kursusname aangepas word deur die \'courseextendednamedisplay\' taalstring te redigeer in die doelgemaakte taalfunksie.';
$string['coursemgmt'] = 'Bestuur kursusse en kategorieë';
$string['courseoverview'] = 'Kursus oorsig';
$string['coursepage'] = 'Kursus bladsy';
$string['courserequestnotify'] = 'Kusus versoek kennisgewing';
$string['courserequestnotifyemail'] = '{$a->user} het \'n nuwe kursus aangevra <a href=</a>"{$a->link}">{$a->link}';
$string['courserequests'] = 'Kursus versoeke';
$string['courserequestspending'] = 'Uitstaande kursus versoeke';
$string['courses'] = 'Kursusse';
$string['coursesperpage'] = 'Kursusse per bladsy';
$string['courseswithsummarieslimit'] = 'Kursusse met opsommingslimiet';
$string['creatornewroleid'] = 'Rol van gebruiker wat nuwe kursusse skep';
$string['creatornewroleid_help'] = 'Indien die gebruiker nie reeds die toestemming het om die nuwe kursus te bestuur nie, word die gebruiker outomaties in die kursus ingeskryf met hierdie rol.';
$string['cron'] = 'Cron';
$string['cron_enabled'] = 'Ontsper cron';
$string['cron_enabled_desc'] = 'Cron moet gewoonweg ontsper word, maar hierdie instelling laat toe dat dit tydelik versper word vir, byvoorbeeld, voor \'n bediener herbegin word. Indien ontsper word die stelsel verhoed om nuwe take in die agtergrond te begin. Let daarop dat die cron nie vir \'n lang tyd vesper moet word nie, omdat belangrike funksionaliteit verhoed sal word om te werk.';
$string['cron_help'] = 'Die cron.php skrip voer \'n aantal take op intervalle wat verskillend geskeduleer is uit, soos om forum inskrywing e-poskennisgewings uit te stuur. Die skrip moet gereeld gehardloop word - die ideaal is elke minuut.';
$string['cron_link'] = 'admin/cron';
$string['cronclionly'] = 'Cron uitvoering slegs deur beheerlyn';
$string['cronerrorclionly'] = 'Jammer, internet toegang na hierdie bladsy is deur die administrateur versper.';
$string['cronerrorpassword'] = 'Jammer, jy het nie \'n geldige wagwoord voorsien om toegang na hierdie bladsy te verkry nie.';
$string['croninfrequent'] = 'Daar was {$a->actual} tussen die laaste twee uitvoerings van die cron instandhoudingskrip en dit behoort elke {$a->expected} te hardloop. Ons beveel aan dat jy dit konfigureer om meer gereeld te hardloop.';
$string['cronremotepassword'] = 'Cron wagwoord vir afstandstoegang';
$string['cronwarning'] = 'Die <a href="{$a}">cron.php onderhoud skrip</a> het die afgelope {$a->actual} nie gehardloop nie en behoort elke {$a->expected} te hardloop.';
$string['cronwarningcli'] = 'Die <code>admin/cli/cron.php</code> skrip het die afgelope {$a->actual} nie gehardloop nie en behoort elke {$a->expected} te hardloop.';
$string['cronwarningnever'] = 'Die <code>admin/cli/cron.php</code> het nog nooit gehardloop nie en behoort elke {$a->expected} te hardloop.';
$string['cronwarningneverweb'] = 'Die <a href="{$a->url}">admin/cron.php skrip</a> het nog nooit gehardloop nie en behoort elke {$a->expected} te hardloop.';
$string['ctyperequired'] = 'Die ctype PHP uitbreiding is nou \'n vereiste vir Moodle om webwerf werksverrigting te verbeter en meertalige versoenbaarheid aan te bied.';
$string['curlcache'] = 'cURL kas TTL';
$string['curlrequired'] = 'Die cURL PHP uitbreiding is nou \'n vereiste vir Moodle om te kommunikeer met Moodle stoorplekke.';
$string['curlsecurityallowedport'] = 'Lys van toelaatbare poorte vir cURL';
$string['curlsecurityallowedportsyntax'] = 'Lys van poortnommers waaraan cURL aan kan konnekteer. Slegs heelgetalle is geldige inskrywings. Plaas elke inskrywing op \'n nuwe lyn. Indien leeg gelaat, word alle poorte toegelaat. Indien ingestel moet, in amper alle gevalle, beide 443 en 80 vir cURL gespesifiseer word om aan standaard HTTPS en HTTP poorte te konnekteer.';
$string['curlsecurityblockedhosts'] = 'Lys van geblokkeerde gashere vir cURL';
$string['curlsecurityblockedhostssyntax'] = 'Plaas elke inskrywing op \'n nuwe lyn. Geldige inskrywings is volledige IPv4 of IPv6 adresse (soos 192.168.10.1, 0:0:0:0:0:0:0:1, ::1, fe80::) wat ooreenstem met \'n enkele gasheer; CIDR-notasie (soos 231.54.211.0/20 of fe80::/64); \'n reeks IP-adresse (soos 231.3.56.10-20 of fe80::1111-bbbb) waar die reeks van toepassing is op die laaste groep van die adres; domein-name (soos localhost of example.com); of oorheersstring domein-name (soos *.example.com of *.sub.example.com). Leë lyne word nie toegelaat nie.';
$string['curlsecurityurlblocked'] = 'Die URL is geblokkeer.';
$string['curltimeoutkbitrate'] = 'Bistempo om te gebruik wanneer cURL spertye bereken word (Kbps)';
$string['curltimeoutkbitrate_help'] = 'Hierdie instelling word gebruik om \'n geskikte spertyd tydens groot cURL versoeke te bereken. As deel van hierdie berekening word \'n HTTP HEAD versoek gemaak om die grootte van die inhoud te bepaal. As jy hierdie versoek wil versper, stel hierdie in op 0.';
$string['currenttheme'] = 'Huidige tema';
$string['customcheck'] = 'Ander kontroles';
$string['custommenu'] = 'Aangepaste kieslys';
$string['custommenuitems'] = 'Aangepaste kieslys-items';
$string['customusermenuitems'] = 'Gebruiker kieslys-items';
$string['datarootsecurityerror'] = '<p><strong>SEKURITEITSWAARSKUWING!</strong></p><p>Jou datawortel gids is in die verkeerde plek en ontbloot aan die internet. Dit beteken dat al jou privaat lêers aan enigiemand in die wêreld beskikbaar is. Sommige van jou lêers kan deur \'n kraker gebruik word om ongemagtigde administratiewe toegang tot jou webwerf te verkry!</p>
<p>Jy <em>moet</em> jou datawortel gidslêer ({$a}) na \'n nuwe plek verskuif wat nie binne jou publieke webgids is nie. Dateer die <code>$CFG->dataroot</code> instelling in jou config.php lêer daarvolgens op.</p>';
$string['datarootsecuritywarning'] = 'Jou webwerf konfigurasie is moontlik nie veilig nie. Maak asseblief seker dat jou datawortel gidslêer ({$a}) nie direk deur die internet toeganklik is nie.';
$string['dbprefixtoolong'] = 'Jou werf se databasis voorvoegsel ($CFG->voorvoegsel) is te lank ({$a->huidige} karakters). Die maksimum aantal karakters wat toegelaat word, is {$a->maksimum}.';
$string['dbsessions'] = 'Gebruik databasis vir sessie inligting';
$string['debug'] = 'Ontfoutingsboodskappe';
$string['debugall'] = 'ALLE: Vertoon alle redelike PHP ontfoutingsboodskappe';
$string['debugdeveloper'] = 'ONTWIKKELAAR: ekstra Moodle ontfoutingsboodskappe vir ontwikkelaars';
$string['debugdisplay'] = 'Vertoon ontfoutingsboodskappe';
$string['debugging'] = 'Ontfouting';
$string['debugminimal'] = 'MINIMAAL: Vertoon slegs noodlottige foute';
$string['debugnone'] = 'GEEN: Moet nie enige foute of waarskuwings vertoon nie';
$string['debugnormal'] = 'NORMAAL: Vertoon foute, waarskuwing en kennisgewings';
$string['debugpageinfo'] = 'Vertoon bladsy inligting';
$string['debugsqltrace'] = 'Vertoon oorsprong van SQL oproepe';
$string['debugsqltrace1'] = 'Vertoon slegs \'n enkele oproeplyn';
$string['debugsqltrace100'] = 'Vertoon volle stapel spoor';
$string['debugsqltrace2'] = 'Vertoon 2 lyne van stapel spoor';
$string['debugsqltrace_desc'] = 'Indien ontsper word \'n gedeeltelike of volle PHP stapel spoor in die SQL ingevoeg as kommentaar.';
$string['debugstringids'] = 'Vertoon die oorsprong van taalstringe';
$string['debugstringids_desc'] = 'Indien ontsper word taalstring-komponente en identifiseerders vertoon wanneer ?strings=1 of &strings=1 tot die bladsy URL gevoeg word.';
$string['debugvalidators'] = 'Vertoon geldigheid skakels';
$string['defaultcity'] = 'Verstek stad';
$string['defaultcity_help'] = '\'n Stad wat hier ingevoer word sal die verstek stad wees wanneer nuwe gebruiker rekeninge geskep word.';
$string['defaultformatnotset'] = '\'n Fout het onstaan tydens die vasstel van die verstek kursus formaat. Kyk asseblief na die webwerf instellings.';
$string['defaulthomepage'] = 'Begin bladsy vir gebruikers';
$string['defaultrequestcategory'] = 'Verstek kategorie vir kursus versoeke';
$string['defaultsettinginfo'] = 'Verstek: {$a}';
$string['defaultuserroleid'] = 'Verstek rol vir alle gebruikers';
$string['deleteincompleteusers'] = 'Wis onvolledige gebruikers uit na';
$string['deleteunconfirmed'] = 'Wis gebruikers wat nie ten volle opgestel is nie uit na';
$string['deleteuser'] = 'Wis gebruiker uit';
$string['density'] = 'Digtheid';
$string['denyemailaddresses'] = 'Geblokkeerde e-pos domeine';
$string['development'] = 'Ontwikkeling';
$string['devicedetectregex'] = 'Toestel identifisering gereelde uitdrukkings';
$string['devicedetectregex_desc'] = '<p>By verstek kan Moodle toestelle van die verstek-tipe (tafelrekenaars, skootekenaars, ens.), mobiel (fone en klein handtoestelle), tablet (iPads en Android tablette) en argaïes (Intenet Explorer 6 gebruikers) optel. Die tema-kieser kan gebruik word om aparte temas aan al hierdie aan te wend. HIerdie instelling laat gereelde uitdrukkings toe wat toelaat dat ekstra toestel tipes opgetel word (hierdie neem voorkeur oor die verstek tipes).</p>
<p> Jy kan byvoorbeeld die ereelde uitdrukking \'/(MIDP-1.0|Maemo|Windows CE)/\' gebruik om sekere algemene eienskappe op fone te identifiseer en die terugkeerwaarde \'featurephone\' by te voeg. Hierdie voeg \'featurephone\' by tot die tema-kieser wat jou toelaat om \'n tema by te voeg wat op hierdie toestelle gebruik kan word. Ander fone kan steeds die tema gebruik wat vir die mobiele toestel tipe geselekteer is.</p>';
$string['devicedetectregexexpression'] = 'Gereelde uitdrukking';
$string['devicedetectregexvalue'] = 'Terugkeer waarde';
$string['devicetype'] = 'Toestel tipe';
$string['devlibdirpresent'] = 'Lêergidse wat ontwikkelingsprogrammateke bevat, veral <em>/vendor</em> en <em>/node_modules</em>, moet nie op publieke webwerwe beskikbaar wees nie. Sien die  <a href="{$a->moreinfourl}">sekuriteit oorsigverslag</a> vir meer besonderhede.';
$string['disabled'] = 'Versper';
$string['disableuserimages'] = 'Versper gebruikers se profielfoto\'s';
$string['displayerrorswarning'] = 'Om die PHP instelling <em>display_errors</em> te ontsper word nie op lewendige webwerwe  aanbeveel nie. Sommige foutboodskappe kan sensitiewe inligting ontbloot rakende jou bediener.';
$string['displayloginfailures'] = 'Vertoon mislukte inteken pogings';
$string['divertallemails'] = 'E-pos omleiding';
$string['divertallemailsdetail'] = 'Word gebruik as beskerming in ontwikkelingsomstandighede wanneer e-posse getoets word. Moet nie op lewendige webwerwe gebruik word nie.';
$string['divertallemailsexcept'] = 'E-pos omleiding uitsonderings';
$string['divertallemailsexcept_desc'] = '\'n Lys van e-pos uitsonderingsreëls geskei deur kommas of nuwe lyne. Elke reël word as \'n gereelde uitdrukking geïnterpreteer, bv .<pre>simone@acme.com
.*@acme.com
fred(\\+.*)?@acme.com
</pre>';
$string['divertallemailsto'] = 'Omlei alle e-posse';
$string['divertallemailsto_desc'] = 'Indien ingestel sal alle e-posse na hierdie enkele e-posadres omlei word.';
$string['dndallowtextandlinks'] = 'Sleep en los die oplaai van teks/skakels';
$string['doclang'] = 'Taal vir dokumente';
$string['docroot'] = 'Moodle Docs dokument wortel';
$string['doctonewwindow'] = 'Maak in \'n nuwe venster oop';
$string['doesnotfit'] = 'Vertoon-instellings van e-posse';
$string['doesnotfitdetail'] = 'Vertoon-instellings vir e-posse vanuit Moodle.';
$string['download'] = 'Laai af';
$string['downloadcoursecontentallowed'] = 'Eienskap om kursus inhoud af te laai beskikbaar';
$string['downloadcoursecontentallowed_desc'] = 'Of die eienskap om kursus inhoud af te laai beskikbaar is vir kursusse. Wanneer beskikbaar, kan die eienskap om kursus inhoud af te laai ontsper/versper word deur die "Eienskap om kursus inhoud af te laai beskikbaar" instelling binne die kursus redigerings-kieslys te gebruik (die verstek hiervoor kan ingestel word by <a href={$a} target="_blank">Course default settings</a>).';
$string['durationunits'] = 'Tydsduur eenhede';
$string['edithelpdocs'] = 'Redigeer hulpdokumente';
$string['editlang'] = '<b>Redigeer</b>';
$string['editorbackgroundcolor'] = 'Agtergrond kleur';
$string['editordictionary'] = 'Redakteur woordeboek';
$string['editorfontfamily'] = 'Font familie';
$string['editorfontlist'] = 'Font lys';
$string['editorfontsize'] = 'Font grootte';
$string['editorhidebuttons'] = 'Versteekte knoppies';
$string['editorkillword'] = 'Woord formaat filter';
$string['editorspelling'] = 'Redakteur spelling';
$string['editorspellinghelp'] = 'Ontsper of versper speltoets. Wanneer onstper moet <strong>aspell</strong> op die bediener geïnstalleer wees.';
$string['editstrings'] = 'Redigeer woorde of frases';
$string['emailchangeconfirmation'] = 'E-pos verandering bevestiging';
$string['emaildkim'] = '\'DomainKeys Identified Mail\' (DKIM) e-pos tekening';
$string['emaildkiminfo'] = 'Indien beide die DKIM selekteerder ingestel en \'n privaat sertifikaat lêer gevind is wat ooreenkom met die e-pos se "From" adres-domein in $CFG->dataroot/dkim/[domain]/[selector].private sal die e-pos geteken word. In meeste gevalle (byvoorbeeld as allowedemaildomains leeg is) word slegs \'n enkele sertfikaat benodig in <pre>{$a->path}</pre>. Sien die dokumentasie <a href="{$a->docs}">Mail configuration</a> vir meer opstel-besonderhede.';
$string['emaildkimselector'] = 'DKIM selekteerder';
$string['emailfromvia'] = 'E-pos via inligting';
$string['emailheaders'] = 'E-pos opskrifte';
$string['emailsubjectprefix'] = 'E-pos onderwerp voorvoegsel teks';
$string['emoticonalt'] = 'Alternatiewe teks';
$string['emoticoncomponent'] = 'Beeld komponent';
$string['emoticonimagename'] = 'Naam van beeld';
$string['emoticons'] = 'Emotikons';
$string['emoticons_desc'] = 'Hierdie vorm definieer die emotikons (of gesiggies) wat op jou webwerf gebruik word. Om \'n ry van die tabel te verwyder, stoor die vorm met \'n leë waarde in enige van die benodigde velde. Om \'n nuwe emotikon te registreer, vul die velde in die laaste leë ry in. Volg die skakel hierbo om al die velde terug na hul verstekwaardes te stel.

*Teks (vereis) - Hierdie teks sal met die emotikon-beeld vervang word. DIt moet ten minste twee karakters lank wees.
*Beeld naam (vereis) - Die emotikon beeld lêernaam sonder die uitbreiding, relatief aan die komponent pix lêer.
*Alternatiewe teks (opsioneel) - String identifiseerder en komponent van die alternatiewe teks van die emotikon.';
$string['emoticonsreset'] = 'Herstel emotikon-instellings terug na die verstekwaardes';
$string['emoticontext'] = 'Teks';
$string['emptysettingvalue'] = 'Leeg';
$string['enableactivitychooser'] = 'Ontsper die aktiwiteitskieser';
$string['enableanalytics'] = 'Analises';
$string['enableblogs'] = 'Onstper webjoernale';
$string['enablecalendarexport'] = 'Onstper uitvoer van kalender';
$string['enablecomments'] = 'Onsper kommentaar';
$string['enablecourserelativedates'] = 'Onstper datums in verband met kursus';
$string['enablecourserelativedates_desc'] = 'Laat toe dat kursusse opgestel word om datums te vertoon wat verband hou met die gebruiker se begindatum in die kursus.';
$string['enablecourserequests'] = 'Onsper kursus-versoeke';
$string['enabled'] = 'Onsper';
$string['enabledashboard'] = 'Aktiveer Dashboard';
$string['enabledashboard_help'] = 'Die Dashboard wys by verstek Tydlyn, Kalender en Onlangs toegang tot items. Jy kan \'n ander verstek Dashboard vir almal stel en gebruikers toelaat om hul eie Dashboard te pasmaak. As dit gedeaktiveer is, moet jy \'Begin bladsy vir gebruikers\' op \'n ander waarde as Dashboard stel.';
$string['enabledevicedetection'] = 'Ontsper toestel-identifisering';
$string['enableglobalsearch'] = 'Ontsper globale soek';
$string['enableglobalsearch_desc'] = 'Indien ontsper sal data deur \'n geskeduleerde taak geïndekseer en gesinkroniseer word.';
$string['enablegravatar'] = 'Ontsper Gravatar';
$string['enablegravatar_help'] = 'Wanneer ontsper sal Moodle poog om \'n gebruiker se profielfoto vanaf Gravatar te gaan haal indien die gebruiker nie \'n beeld opgelaai het nie.';
$string['enablemobilewebservice'] = 'Ontsper webdienste vir mobiele toestelle';
$string['enablerecordcache'] = 'Ontsper rekord kas';
$string['enablerssfeeds'] = 'Ontsper RSS toevoer';
$string['enablesearchareas'] = 'Ontsper soekareas';
$string['enablestats'] = 'Ontsper statistieke';
$string['enabletrusttext'] = 'Ontsper vertroude inhoud';
$string['enableuserfeedback'] = 'Ontsper terugvoering oor hierdie sagteware';
$string['enableuserfeedback_desc'] = 'Indien ontsper word \'n \'Gee terugvoering oor hierdie sagteware\'-skakel in die opskrif vertoon vir gebruikers om terugvoering oor die Moodle sagteware aan Moodle Hoofkantoor te verskaf. Indien die \'Volgende terugvoering herinnering\'-opsie ingestel is word die gebruiker ook \'n herinnering op die Paneelbord gewys op die gespesifeerde tydsverloop. Deur die \'Volgende terugvoering herinnering\'-opsie na \'Nooit\' in te stel word die Paneelbord herinnering versper, maar die \'Gee terugvoering oor hierdie sagteware\'-skakel bly in die opskrif.';
$string['enablewebservices'] = 'Ontsper webdienste';
$string['enablewsdocumentation'] = 'Webdienste dokumentasie';
$string['encryptedpassword_edit'] = 'Voer nuwe waarde in';
$string['encryptedpassword_set'] = '(Ingestel en enkripteer)';
$string['enroladminnewcourse'] = 'Outo-registreer admin vir nuwe kursusse';
$string['enroladminnewcourse_help'] = 'Wanneer \'n administrateur \'n nuwe kursus byvoeg, moet hulle outomaties ingeskryf word en die skeppers se rol in nuwe kursusse toegeken word?';
$string['enrolinstancedefaults'] = 'Inskrywing eksemplaar verstekwaardes';
$string['enrolinstancedefaults_desc'] = 'Verstek inskrywing-instellings in nuwe kursusse.';
$string['enrolmultipleusers'] = 'Skryf gebruikers in';
$string['entitytasklog'] = 'Taaklogboek';
$string['environment'] = 'Omgewing';
$string['environmenterrortodo'] = 'Jy moet al die omgewingsprobleme (foute) wat hierbo gevind is oplos voordat jy kan voortgaan om hierdie weergawe van Moodle te installeer!';
$string['environmenterrorupgrade'] = 'Waarskuwing: jy moet al die omgewingsprobleme (foute) wat hierbo gevind is oplos voordat jy kan voortgaan om hierdie weergawe van Moodle te installeer! Om op te gradeer sonder om die bogenoemde vereistes reg te maak kan probleme soos \'n verlies van data veroorsaak. Is jy seker jy wil met die opgradering voortgaan?';
$string['environmentmariadbwrongdbtype'] = 'Verkeerde $CFG->dbtype. U moet dit in u konfigurasie.php lêer verander van \'mysqli\' na \'mariadb\'.';
$string['environmentmustfixsetting'] = 'PHP instelling moet verander word.';
$string['environmentok'] = 'Jou bediener-omgewing voldoen aan al die minimum vereistes.';
$string['environmentrecommendcustomcheck'] = 'indien hierdie toets nie slaag nie, dui dit op \'n potensiële probleem';
$string['environmentrecommendinstall'] = 'moet geïnstalleer en ontsper word vir die beste resultate';
$string['environmentrecommendversion'] = 'weergawe {$a->needed} word benodig en jy hardloop tans {$a->current}';
$string['environmentrequirecustomcheck'] = 'hierdie toets moet slaag';
$string['environmentrequireinstall'] = 'moet geïnstalleer en ontsper wees';
$string['environmentrequireversion'] = 'weergawe {$a->needed} word benodig en jy hardloop tans {$a->current}';
$string['environmentsettingok'] = 'voorgestelde instelling opgespoor';
$string['environmentshouldfixcustomcheck'] = 'moet geaktiveer word vir die beste resultate';
$string['environmentshouldfixsetting'] = 'PHP instellings moet verander word.';
$string['environmentxmlerror'] = '\'n Fout het onstaan tydens die lees van die omgewingsdata ({$a->error_code})';
$string['errordeletingconfig'] = '\'n Fout het voorgekom tydens die uitwissing van die konfigurasie-rekords vir inprop \'{$a}\'.';
$string['errorsetting'] = 'Kon nie die instelling stoor nie:';
$string['errorwithsettings'] = 'Sommige instelling is as gevolg van \'n fout nie verander nie.';
$string['eventshandlersinuse'] = 'Die volgende inproppe in u stelsel gebruik \'Events 1 API\'-verouderde hanteerders: \'{$a}\'. Dateer dit asseblief op om \'Events 2 API\' te gebruik. Sien https://docs.moodle.org/dev/Events_API#Event_dispatching_and_observers.';
$string['everyonewhocan'] = 'Almal wat kan \'{$a}\'';
$string['exceptions'] = 'uitsonderings';
$string['execpathnotallowed'] = 'Die instelling van uitvoerbare en lokale bane is versper in config.php';
$string['experimental'] = 'Eksperimenteel';
$string['experimentalsettings'] = 'Eksperimentele instellings';
$string['extendedusernamechars'] = 'Laat uitgebreide karakters in gebruikersname toe';
$string['extramemorylimit'] = 'Ekstra PHP geheue-limiet';
$string['fatalsessionautostart'] = '<p> Ernstige konfigurasie fout is opgespoor, stel asseblief die bediener administrateur in kennis. </p><p> Om behoorlik te werk, vereis Moodle dat die administrateur PHP instellings verander.</p><p><code>session.auto_start</code> moet na <code>off</code> ingestel wees.</p><p>Hierdie instelling word beheer deur <code>php.ini</code>, Apache/IIS <br/>konfigurasie of die <code>.htaccess</code> lêer op die bediener te redigeer.</p>';
$string['favicon'] = 'Gunsteling';
$string['favicon_desc'] = 'Die favicon word langs die bladsytitel in die blaaieroortjie vertoon. \'n Moodle-gunsteling word vertoon as \'n pasgemaakte gunsteling-gunsteling nie verskaf word nie.';
$string['feedbacksettings'] = 'Terugvoering instellings';
$string['fileconversioncleanuptask'] = 'Skoonmaak van tydelike rekords vir omskakeling van dokumente.';
$string['filecreated'] = 'Nuwe lêer geskep';
$string['filescleanupperiod'] = 'Maak rommelpoel lêers skoon';
$string['filescleanupperiod_help'] = 'Hoe gereeld rommelpoel lêers uitgewis word. Hierdie is lêers wat geassosieer word met \'n konteks wat nie meer bestaan nie, byvoorbeeld wanneer \'n kursus uitgewis word. Let asseblief daarop dat hierdie instelling kan veroorsaak dat lêers vermis word in \'n kursus wat gerugsteun, uitgewis en dan herstel word as die instelling \'Sluit lêers in\' (backup_auto_files) in \'Outomatiese rusgsteun instellings\' versper is.';
$string['filesizeunits'] = 'lêer grootte eenhede';
$string['filestoredin'] = 'Stoor lêer in lêergids :';
$string['filestoredinhelp'] = 'Waar die lêer gestoor gaan word';
$string['filterall'] = 'Filter alle stringe';
$string['filtermatchoneperpage'] = 'Filter ooreenstemming een keer per bladsy';
$string['filtermatchonepertext'] = 'Filter ooreenstemming een keer per teks';
$string['filternavigationwithsystemcontext'] = 'Filter navigasie met stelselkonteks';
$string['filters'] = 'Filters';
$string['filtersettings'] = 'Bestuur filters';
$string['filtersettingsgeneral'] = 'Algemene filter instellings';
$string['filteruploadedfiles'] = 'Filter opgelaaide dokumente';
$string['forceclean'] = 'Maak inhoud orals skoon';
$string['forceclean_desc'] = 'Inhoud wat op die webwerf opgelaai word, word normaalweg skoongemaak voordat it vertoon word om enigiets te verwyder wat moontlik \'n sekuriteitsbedreiging kan wees. Inhoud in sekere plekke soos aktiwiteitsbeskrywings, bladsy verwysings of HTML blokke word egter nie skoongemaak nie sodat skriptekste, media en inlyn rame ens. bygevoeg kan word. Indien hierdie instelling ontsper word, sal ALLE inhoud skoongemaak word. Hierdie kan moontlik veroorsaak dat bestaande inhoud nie meer korrek vertoon nie.';
$string['forcelogin'] = 'Dwing gebruikers om in te teken';
$string['forceloginforprofileimage'] = 'Dwing gebruikers om in te teken om gebruikers se foto\'s te sien';
$string['forceloginforprofileimage_help'] = 'Indien ontsper moet gebruikers inteken om gebruikers se profielfoto\'s te sien. Die verstek gebruikersfoto sal in alle kennisgewings e-posse gebruik word.';
$string['forceloginforprofiles'] = 'Dwing gebruikers om in te teken vir profiele';
$string['forcetimezone'] = 'Dwing tydsone af';
$string['formatuninstallwithcourses'] = 'Daar is {$a->count} kursusse wat die {$a->format} gebruik. Hul formaat sal verander word na {$a->defaultformat} (die verstek formaat vir die webblad). Sommige formaat-spesifieke data mag verlore raak. Is jy seker dat jy wil voortgaan?';
$string['frontpage'] = 'Tuisblad.';
$string['frontpagebackup'] = 'Tuisblad rugsteun.';
$string['frontpagedefaultrole'] = 'Verstek rol vir tuisblad';
$string['frontpagefilters'] = 'Tuisblad filters.';
$string['frontpageloggedin'] = 'Tuisblad items wanneer ingeteken is';
$string['frontpageoverrides'] = 'Tuisblad toestemming oorheersing';
$string['frontpagequestions'] = 'Tuisblad vrae.';
$string['frontpagerestore'] = 'Tuisblad herstel.';
$string['frontpageroles'] = 'Tuisblad rolle.';
$string['frontpagesettings'] = 'Tuisblad instellings.';
$string['fullnamedisplay'] = 'Volle naam formaat';
$string['fullnamedisplayprivate'] = 'Volle naam formaat - privaat';
$string['gdrequired'] = 'Die GD uitbreiding word nou deur Moodle vereis om beelde om te skakel.';
$string['generalsettings'] = 'Algemene instellings';
$string['geoipfile'] = 'GeoLite2 City MaxMind DB';
$string['getremoteaddrconf'] = 'Bron van die ingetekende IP-adres';
$string['globalsearch'] = 'Globale soek';
$string['globalsearchmanage'] = 'Bestuur globale soek';
$string['googlemapkey3'] = 'Google Maps API V3 sleutel';
$string['googlemapkey3_help'] = 'Jy moet \'n spesiale sleutel invoer om Google Maps te gebruik om die opsoek van IP-adresse te visualiseer. Jy kan die sleutel gratis by <a href="https://developers.google.com/maps/documentation/javascript/tutorial#api_key" target="_blank">https://developers.google.com/maps/documentation/javascript/tutorial#api_key</a> kry.';
$string['gotofirst'] = 'Gaan na eerste vermisde string';
$string['gradebook'] = 'Punteboek';
$string['gradebookroles'] = 'Geassesseerde rolle';
$string['gradeexport'] = 'Primêre metodes om punte uit te voer';
$string['gravatardefaulturl'] = 'Gravatar verstek beeld URL';
$string['gravatardefaulturl_help'] = 'Gravatar benodig \'n verstek beeld om te vertoon indien dit nie \'n beeld van \'n gegewe gebruiker kan vind nie. Verskaf \'n volle URL vir die beeld. Indien jy hierdie instelling leeg laat sal Moodle poog om die mees gepaste verstek beeld vir die bladsy waarna jy kyk te gebruik. Let ook daarop dat Gravatar \'n aantal kodes het wat gebruik kan word om <a href="https://en.gravatar.com/site/implement/images/#default-image">verstek beelde te genereer</a>.';
$string['groupenrolmentkeypolicy'] = 'Groep-inskrywing sleutelbeleid';
$string['groupenrolmentkeypolicy_desc'] = 'Indien ontsper sal groep-inskrywing sleutels vergelyk word met die wagwoordbeleid soos in die instellings hierbo gespesifiseer.';
$string['guestroleid'] = 'Rol vir gas';
$string['guestroleid_help'] = 'Hierdie rol word outomaties aan die gas-gebruiker toegeken. Dit word ook tydelik toegeken aan gebruikers wat nie ingeskryf is nie en die kursus deur gas-inskrywing inproppe toetree.';
$string['h5pgetcontenttypestask'] = 'Aflaai beskikbaar H5P inhoud tipes van h5p.org';
$string['helpadminseesall'] = 'Sien en filter die administrateurs in die webwerf kalender gebeure van alle kursus kalenders of slegs daardie waarin hulle ingeskryf is? Ongeag die gekose opsie sal administrateurs altyd in staat wees om gebeure vir elke kursus kalender te bestuur deur eerstens na die kursus te navigeer en dan direk die kursus kalender oop te maak.';
$string['helpcalendarcustomexport'] = 'Ontsper die opsie vir doelgemaakte datum-reeks uitvoere in kalender uitvoere. Kalender uitvoere moet onsper wees om hierdie effektief te maak.';
$string['helpexportlookahead'] = 'Hoeveel dae in die toekoms kyk die kalender na vir gebeure gedurende uitvoer vir die doelgemaakte uitvoer opsie?';
$string['helpexportlookback'] = 'Hoeveel dae in die verlede kyk die kalender na vir gebeure gedurende uitvoer vir die doelgemaakte uitvoer opsie?';
$string['helpforcetimezone'] = 'Jy kan gebruikers toelaat om self hul tydsone te kies, of jy kan \'n tydsone op almal afdwing.';
$string['helpshowicalsource'] = 'Indien ontsper sal die inskrywingsnaam en skakel vertoon word vir iCal gebeurtenisse wat ingevoer is.';
$string['helpsitemaintenance'] = 'Vir opgraderings en ander werk';
$string['helpstartofweek'] = 'Op watter dag begin die week in die kalender?';
$string['helpupcominglookahead'] = 'Hoeveel dae in die toekoms in moet die kalender kyk vir opkomende gebeurtenisse by verstek?';
$string['helpupcomingmaxevents'] = 'Hoeveel (maksimum) opkomende gebeurtenisse moet by verstek aan gebruikers vertoon word?';
$string['helpweekenddays'] = 'Watter dae van die week word behandel as "naweek" en word in \'n ander kleur vertoon?';
$string['hiddenuserfields'] = 'Steek gebruikersvelde weg';
$string['hidefromall'] = 'Steek van alle gebruikers weg';
$string['hidefromnone'] = 'Steek van niemand weg';
$string['hidefromstudents'] = 'Steek van studente weg';
$string['hostname'] = 'Gasheernaam';
$string['htmleditor'] = 'HTML redigeerder';
$string['htmleditorsettings'] = 'HTML redigeerder instellings';
$string['htmlsettings'] = 'HTMLinstellings';
$string['http'] = 'HTTP';
$string['httpsecurity'] = 'HTTP sekuriteit';
$string['iconvrequired'] = 'Die installering van die ICONV uitbreiding word vereis.';
$string['igbinary322buggyversion'] = 'Die php-igbinary-uitbreiding wat op die webwerf geïnstalleer is, kan tot probleme lei wanneer jy met PHP 7.2 hardloop. Jy word aanbeveel om óf op te gradeer na php-igbinary 3.2.5 of later, óf alternatiewelik om op te gradeer na PHP 7.3 of later.';
$string['ignore'] = 'Ignoreer';
$string['includemoduleuserdata'] = 'Sluit module gebruikersdata in';
$string['incompatibleblocks'] = 'Onversoenbare blokke';
$string['incompleteunicodesupport'] = 'Die huidige opstelling van MySQL of MariaDB gebruik \'utf8\'. Hierdie karakterstel ondersteun nie vier-greep karakters nie, wat sommige gesiggies insluit. Wanneer daar probeer word om een van hierdie karakters te gebruik sal daar \'n fout onstaan wanneer \'n rekord opgedateer word en alle informasie wat na die databasis gestuur word sal verlore gaan. Oorweeg asseblief om jou instelllings na  \'utf8mb4\' te stel. Sien die dokumentasie vir volle besonderhede.';
$string['indexdata'] = 'Indeks data';
$string['indexinginfo'] = 'Die voorgestelde manier om jou webblad se inligting te indekseer is om die \'Global search indexing\' geskeduleerde taak te gebruik.';
$string['installhijacked'] = 'Installering moet vanaf die oorspronklike IP-adres voltooi word, jammer.';
$string['installsessionerror'] = 'Kan nie \'n PHP-sessie inisialiseer nie, verifieer asseblief dat jou blaaier koekies aanvaar.';
$string['intlrecommended'] = 'Die Intl-uitbreiding word gebruik om internasionaliseringsondersteuning, soos lokaliteits-bewuste sortering, te verbeter.';
$string['intlrequired'] = 'Die Intl-uitbreiding word vereis om internasionaliseringsondersteuning, soos lokaliteits-bewuste sortering en internasionale domein name, te verbeter.';
$string['invalidagedigitalconsent'] = 'Die digitale toestemmingsouderdom is nie geldig vir: {$a}';
$string['invalidforgottenpasswordurl'] = 'Die vergete wagwoord URL is nie \'n geldige URL nie.';
$string['invalidsection'] = 'Ongeldige seksie.';
$string['invalidthemepreset'] = 'Die gekose voorafingestelde lêer is nie versoenbaar met hierdie tema nie. Die SCSS kompileringsfout was: "{$a}"';
$string['invaliduserchangeme'] = 'Die gebruikersnaam \'changeme\' is gereserveer -- jy kan nie \'n rekening daarmee skep nie.';
$string['ipblocked'] = 'Hierdie webwerf is nie tans beskikbaar nie.';
$string['ipblocker'] = 'IP blokkeerder';
$string['ipblockersyntax'] = 'Plaas elke inskrywing op \'n aparte lyn. Geldige inskrywings is of die volle IP-adres (soos <b>192.168.10.1</b>) wat met \'n enkele gasheer ooreenstem; of \'n gedeeltelike adres (soos <b>192.168</b>) wat ooreenstem met enige adres wat met daardie nommers begin; of CIDR-notasie (soos <b>231.54.211.0/20</b>); of \'n reeks IP-adresse (soos <b>231.3.56.10-20</b>) waar die reeks toepaslik is op die laaste deel van die adres. Teksgebaseerde domeinname (soos \'voorbeeld.co.za\') word nie ondersteun nie. Leë lyne en \'n "#" teken gevolg deur teks word geïgnoreer.';
$string['iplookup'] = 'IP-adres opsoek';
$string['iplookupgeoplugin'] = 'Dei <a href="http://www.geoplugin.com">geoPlugin</a> diens word tans gebruik om geografiese inligting op te soek. Vir meer akkurate resultate word dit aanbeveel om \'n plaaslike kopie van die MaxMind GeoLite databasis te installeer.';
$string['iplookupinfo'] = 'Moodle gebruik by verstek die gratis aanlyn NetGeo (Die Internet Geografiese Databasis) bediener om die ligging van IP-adresse op te soek. Ongelukkig word hierdie databasis nie meer onderhou nie en kan dit <em>wild onakkurate</em> data terugvoer.
Dit word voorgestel om \'n plaaslike kopie van die gratis GEoLite2 City databasis van MaxMind te installeer.<br />
IP-adresse se ligging word vertoon op eenvoudige kaarte of met die gebruik van Google Maps. Let asseblief daarop dat jy \'n Google rekening benodig waarna jy aansoek kan doen vir die gratis Google Maps API-sleutel om interaktiewe kaarte te ontsper.';
$string['iplookupmaxmindnote'] = 'Hierdie produk sluit die GeoLite2 data soos geskep deur MaxMind in, beskikbaar vanaf <a href="http://www.maxmind.com">http://www.maxmind.com</a>.';
$string['iscustomadminwarnings'] = 'Daar is bespeur dat jou werf \'n gepasmaakte administrasiegids gebruik. Hierdie kenmerk word nie meer ondersteun nie en sal na Moodle 4.2 verwyder word.';
$string['ishttpswarning'] = 'Dit is waargeneem dat jou webwerf nie beveilig is met HTTPS nie. Dit word sterk aanbeveel om jou webwerf na HTTPS te migreer vir meer sekuriteit en verbeterde integrasie met ander sisteme.';
$string['keeptagnamecase'] = 'Hou etiket naam kassing';
$string['lang'] = 'Verstek taal';
$string['langcache'] = 'Kas taal kieslys';
$string['langcache_desc'] = 'Kas die taal keuselys. Indien ontsper word die lys van beskikbare vertalings gekas. Die kas word outomaties verfris wanneer jy \'n taalpakket installeer of uitwis deur die ingeboude taalpakket bestuur-hulpmiddel. As jy met die hand \'n nuwe taalpakket installeer sal jy die \'Purge all caches\'-funksie moet gebruik om die gekasde lys te verfris.';
$string['langlist'] = 'Tale op die taal kieslys';
$string['langmenu'] = 'Vertoon taal kieslys';
$string['langmenuinsecurelayout'] = 'Vertoon taal kieslys in \'n veilige uitleg';
$string['langmenuinsecurelayout_desc'] = 'Indien ontsper sal \'n gebruiker hul taal kan verander wanneer hulle \'n vasvra of enige ander atiwiteit poog met gebruik van \'n veilige uitleg.';
$string['langpackwillbeupdated'] = 'LET OP: Moodle gaan probeer om opdaterings vir jou taalpakkette af te laai tydens die opgradering.';
$string['langstringcache'] = 'Kas alle taalstringe';
$string['languagesettings'] = 'Taal instellings';
$string['latinexcelexport'] = 'Excel-enkodering';
$string['legacyfilesaddallowed'] = 'Laat toe om by argaïese kursusdokumente te voeg';
$string['legacyfilesaddallowed_help'] = 'Indien \'n kursus argaïese kursusdokumente het, laat toe om nuwe lêers en gidslêers by te voeg.';
$string['legacyfilesinnewcourses'] = 'Argaïese kursuslêers in nuwe kursusse';
$string['legacyfilesinnewcourses_help'] = 'By verstek is argaïese kursuslêer-areas slegs in opgegradeerde kursusse beskikbaar. Let asseblief daarop dat sommige funksies soos aktiwiteit rugsteun en herstel nie versoenbaar is met heirdie instelling nie.';
$string['libcurlwarning'] = 'Dit is waargeneem dat \'libcurl\' nie CURLOPT_PROTOCOL ondersteuning het nie. \'n Opgedateerde \'libcurl\'-installasie word aanbeveel vir sekuriteitsredes.';
$string['licensesettings'] = 'Lisensie instellings';
$string['linkadmincategories'] = 'Koppel admin kategorieë';
$string['linkadmincategories_help'] = 'Indien ontsper sal admin instelling kategorieë as skakels in die navigasie vertoon word. Dit sal na die admin kategorieblaaie lei.';
$string['linkcoursesections'] = 'Koppel altyd kursus seksies';
$string['linkcoursesections_help'] = 'Probeer om altyd \'n skakel te verskaf vir kursus seksies. Kursus seksies word gewoonlik slegs as skakels vertoon indien die kursus formaat \'n enkele seksie per bladsy vertoon. Indien hierdie instelling onsper is sal \'n skakel altyd voorsien word.';
$string['loading'] = 'Besig om te laai';
$string['localetext'] = 'Werfwye ligging';
$string['localstringcustomization'] = 'Plaaslike string doelmaking';
$string['location'] = 'Ligging';
$string['locationsettings'] = 'Ligging instellings';
$string['locked'] = 'Gesluit';
$string['lockoutduration'] = 'Tydsduur van rekening uitsluiting';
$string['lockoutduration_desc'] = 'Vasgesluite rekening word outomaties na hierdie tydsduur ontsluit.';
$string['lockoutemailbody'] = 'Jou rekening met gebruikersnaam {$a->username} op bediener \'{$a->sitename}\' was uitgesluit na veelvuldige ongeldige probeerslae om in te teken.

Om  die rekening dadelik te ontsluit, gaan na die volgende skakel

{$a->link}

In die meeste e-posprogramme sal hierdie as \'n blou skakel vertoon waarop jy slegs kan klik. Indien dit nie werk nie, kopieër en plak die adres in die adreslyn aan die bokant van jou webblaaier venster.

Indien jy hulp benodig, kontak asseblief die webwerf administrateur, {$a->admin}';
$string['lockoutemailsubject'] = 'Jou rekening op {$a} is uitgesluit';
$string['lockouterrorunlock'] = 'Ongeldige inligting voorsien om die rekening te ontsluit.';
$string['lockoutthreshold'] = 'Rekening uitsluitingsdrumpel';
$string['lockoutthreshold_desc'] = 'Selekteer die aantal mislukte inteken pogings wat sal veroorsaak dat \'n rekening uitgelsuit word. Hierdie opsie kan misbruik word deur aanvalle wat poog om gebruikers opsetlik van hul rekeninge te weerhou.';
$string['lockoutwindow'] = 'Rekening uitsluitings-observasievenster';
$string['lockoutwindow_desc'] = 'Observasietyd vir die uitsluitingsdrumpel. Indien daar geen mislukte pogings is nie, sal die drumpel-teller na hierdie tydsduur teruggestel word.';
$string['lockrequestcategory'] = 'Voorkom kategorie seleksie';
$string['log'] = 'Logs';
$string['logguests'] = 'Teken besoeker toegang aan';
$string['logguests_help'] = 'Hierdie instelling ontsper die aanteken van aksies deur gaste rekeninge en nie besoekers wat ingeteken is nie. Hoë-profiel webwerwe wil moontlik hierdie aantekening versper vir werksverrigting redes. Dit word aanbeveel om hierdie instelling ontsper te hou op lewendige webwerwe.';
$string['logininfoinsecurelayout'] = 'Vertoon ingetekende gebruiker in veilige uitleg';
$string['logininfoinsecurelayout_desc'] = 'Indien ontsper sal die ingetekende gebruiker se volle naam in die navigasie-stafie vertoon word wanneer daar probeer word om \'n vasvra of enige ander aktiwiteit te doen wanneer die veilige uitleg gebruik word.';
$string['loginpageautofocus'] = 'Outofokus inteken bladsy vorm';
$string['loginpageautofocus_help'] = 'Deur hierdie opsie te ontsper, word die bruikbaarheid van die inteken-bladsy verhoog, maar om outomaties velde te fokus kan gesien word as \'n toeganklikheidsprobleem.';
$string['loglifetime'] = 'Hou logs vir';
$string['logo'] = 'Logo';
$string['logo_desc'] = '\'n Volledige logo om as versiering deur sommige temas (soos kerntemas) gebruik te word. Hierdie prent kan redelik hoë resolusie wees omdat dit afgeskaal sal word vir gebruik (en gekas vir werkverrigting). Logo\'s wat wyer is as wat hulle hoog is, gee gewoonlik beter resultate.';
$string['logocompact'] = 'Kompakte logo';
$string['logocompact_desc'] = '\'n Kompakte weergawe van dieselfde logo as hierbo, soos \'n embleem, skild of ikoon. Die beeld moet selfs by klein groottes duidelik wees.';
$string['logossettings'] = 'Logos';
$string['logstorenotrequired'] = 'Die stoor van logs word nie vereis nie';
$string['logstoressupported'] = 'Stoor van logs wat hierdie verslag ondersteun';
$string['longtimewarning'] = '<b>Let asseblief daarop dat hierdie proses \'n lang tyd kan neem.</b>';
$string['mailnewline'] = 'Karakters vir \'n nuwe lyn in e-posse';
$string['maintenancemode'] = 'In instandhoudingsmodus';
$string['maintenancemodeisscheduled'] = 'Hierdie webwerf sal in {$a->mins} minute en {$a->sec} sekondes na instandhoudingsmodus oorgeplaas word.';
$string['maintenancemodeisscheduledlong'] = 'Hierdie webwerf sal in {$a->hour} ure, {$a->mins} minute en {$a->sec} sekondes na instandhoudingsmodus oorgeplaas word.';
$string['maintfileopenerror'] = '\'n Fout het onstaan tydens die oopmaak van instandhoudingslêers!';
$string['maintinprogress'] = 'Instandhouding is aan die gang...';
$string['managecontextlock'] = 'Vries hierdie konteks';
$string['managecontextlocklocked'] = '$a->contextname} en enige laer kontekste is nou gevries.';
$string['managecontextlockunlocked'] = '$a->contextname} en enige laer kontekste is nou ontvries.';
$string['managecontextunlock'] = 'Ontvries hierdie konteks';
$string['managecustomfields'] = 'Beheer doelgemaakte veld-tipes';
$string['manageformats'] = 'Beheer kursus formate';
$string['manageformatsgotosettings'] = 'Die verstek formaat kan in {$a} verander word';
$string['managelang'] = 'Bestuur';
$string['manageqbanks'] = 'Bestuur vraagbank-inproppe';
$string['manageqbehaviours'] = 'Bestuur optrede van vrae';
$string['manageqtypes'] = 'Bestuur vraagtipes';
$string['maturity100'] = 'Beta';
$string['maturity150'] = 'Stel kandidaat vry';
$string['maturity200'] = 'Stabiele weergawe';
$string['maturity50'] = 'Alfa';
$string['maturityallowunstable'] = 'Wenk: Jy wil moontlik hierdie skrip hardloop met die --allow-unstable opsie';
$string['maturitycoreinfo'] = 'Jou webwerf hardloop tans onstabiele "{$a}" ontwikkelingskode.';
$string['maturitycorewarning'] = 'Die weergawe van Moodle wat jy wil installeer of opgradeer bevat onstabiele "{$a}" ontwikkelingskode wat nie geskik is vir gebruik op meeste lewendige webwerwe nie. As dit nie is wat jy wil hê nie, maak seker dat jy vanaf \'n STABIELE weergawe van die Moodle kode opdateer. Sien Moodle Docs vir meer besonderhede.';
$string['maxbytes'] = 'Maksimum grootte van lêer wat opgelaai word';
$string['maxconsecutiveidentchars'] = 'Opeenvolgende identiese karakters';
$string['maxeditingtime'] = 'Maksimum tyd om inskrywings te redigeer';
$string['maxsizeperdownloadcoursefile'] = 'Maksimum grootte per lêer';
$string['maxsizeperdownloadcoursefile_desc'] = 'Die maksimum grootte van elke lêer wanneer kursus inhoud afgelaai word. Lêers groter as dit sal van die aflaai uitgeskakel word.';
$string['maxtimelimit'] = 'Maksimum tydslimiet';
$string['maxtimelimit_desc'] = 'Om die maksimum PHP uitvoertyd te beperk wat Moodle sal toelaat sonder om enige afvoer te vertoon, voer \'n waarde in sekondes hier in. 0 beteken dat die verstek Moodle beperkinge gebruik word. Indien jy \'n voorverwerker met sy eie tydlimiet, stel hierdie waarde laer om PHP foute in die logs te kry. Hierdie geld nie vir CLI skrip nie.';
$string['maxusersperpage'] = 'Maksimum aantal gebruikers per bladsy';
$string['mbstringrecommended'] = 'Dit word sterk aanbeveel om die opsionele MBSTRING biblioteek te installeer om die webwerf se werksverrigting te verhoog, veral as jou webwerf nie-Latynse tale ondersteun.';
$string['mbstringrequired'] = 'Die MBSTRING biblioteek moet installeer word om die webwerf se werksverrigting te verhoog, veral as jou blad nie-Latynse tale ondersteun.';
$string['mediapluginavi'] = 'Ontsper .avi filter';
$string['mediapluginflv'] = 'Ontsper .flv filter';
$string['mediapluginimg'] = 'Ontsper die outomatiese inbedding van beelde met skakels';
$string['mediapluginmov'] = 'Ontsper .mov filter';
$string['mediapluginmp3'] = 'Ontsper .mp3 filter';
$string['mediapluginmpg'] = 'Ontsper .mpg filter';
$string['mediapluginogg'] = 'Ontsper .ogg filter';
$string['mediapluginogv'] = 'Ontsper .ogv filter';
$string['mediapluginram'] = 'Ontsper .ram filter';
$string['mediapluginrm'] = 'Ontsper .rm filter';
$string['mediapluginrpm'] = 'Ontsper .rpm filter';
$string['mediapluginswf'] = 'Ontsper .swf filter';
$string['mediapluginswfnote'] = 'As \'n verstek sekuriteitsmaatreel moet gebruikers nie toegelaat word om swf flash lêers in te bed nie.';
$string['mediapluginwmv'] = 'Ontsper .wmv filter';
$string['mediapluginyoutube'] = 'Ontsper YouTube skakels filter';
$string['messaging'] = 'Ontsper boodskapdiens';
$string['messagingallowemailoverride'] = 'Kennisgewing e-pos oorheersing';
$string['messagingallusers'] = 'Laat webwerf-wye boodskappe toe';
$string['messagingcategory'] = 'Boodskappe';
$string['messagingdefaultpressenter'] = 'Gebruik invoersleutel om te stuur by verstek ontsper';
$string['messagingdeleteallnotificationsdelay'] = 'Wis alle kennisgewings uit';
$string['messagingdeletereadnotificationsdelay'] = 'Wis alle "gelees" kennisgewings uit';
$string['messagingssettings'] = 'Boodskap instellings';
$string['minpassworddigits'] = 'Syfers';
$string['minpasswordlength'] = 'Wagwoord lengte';
$string['minpasswordlower'] = 'Kleinletters';
$string['minpasswordnonalphanum'] = 'Nie-alfanumeriese karakters';
$string['minpasswordupper'] = 'Hoofletters';
$string['misc'] = 'Verskeie';
$string['mlbackendsettings'] = 'Masjien-leer naverwerking instellings';
$string['mnetrestore_extusers'] = '<strong>Let op:</strong> Hierdie rugsteun lêer bevat afstand Moodle Netwerk gebruikersrekeninge wat as deel van die proses herstel sal word.';
$string['mnetrestore_extusers_admin'] = '<strong>Let op:</strong> Dit lyk asof hierdie rugsteun lêer vanaf \'n verskillende Moodle installering af kom en afstand Moodle Netwerk gebruikersrekeninge bevat. Hierdie herstel-proses sal probeer om ooreen te stem met die Moodle Netwerk gashere vir alle geskape gebruikers. Daardie wat nie ooreenstem nie sal outomaties na interne verifikasie (in plaas van mnet een) geskakel word. Die herstel log sal jou daarvan in kennis stel.';
$string['mnetrestore_extusers_mismatch'] = '<strong>Let op:</strong> Dit lyk asof hierdie rugsteun lêer vanaf \'n verskillende Moodle installering af kom en afstand Moodle Netwerk gebruikersrekeninge bevat wat dalk nie mag herstel nie. Hierdie opdrag word nie ondersteun nie. Indien jy seker is dat dit op hierdie Moodle installering geskep is of as jy kan verseker dat al die nodige Moodle Netwerk Gashere gekonfigureer is, kan jy moontlik steeds die herstel probeer.';
$string['mnetrestore_extusers_noadmin'] = '<strong>Let op:</strong> Dit lyk asof hierdie rugsteun lêer vanaf \'n verskillende Moodle installering af kom en afstand Moodle Netwerk gebruikersrekeninge bevat. Jy word nie toegelaat om hierdie tipe herstel uit te voer nie. Kontak die administrateur van die webwerf of, as \'n alternatief, herstel hierdie kursus sonder enige gebruikersinligting (modules, lêers...)';
$string['mnetrestore_extusers_switchuserauth'] = 'Afstand Moodle Netwerk gebruiker {$a->username} (komende vanaf {$a->mnethosturl}) is oorgeskakel na {$a->auth} geverifieerde gebruiker.';
$string['mobilenotconfiguredwarning'] = 'Die Moodle toep is nie ontsper nie.';
$string['modassignmentinuse'] = 'Jou werf gebruik steeds die Assignment 2.2-inprop. Voordat jy opgradeer moet jy 1) enige Werkopdrag 2.2-aktiwiteite wat jy wil behou rugsteun en dit as Werkopdragaktiwiteite herstel, en 2) alle Werkopdrag 2.2-data uit die databasis uitvee.';
$string['modassignmentsubpluginsexist'] = 'Opdrag 2.2. subplugins kan teenwoordig wees. Die mod/opdrag-lêergids en al sy subproppe moet verwyder word voor opgradering.';
$string['modchooserdefault'] = 'Verstek aktiwiteit kieser';
$string['modeditdefaults'] = 'Verstek waardes vir aktiwiteitsinstellings';
$string['modsettings'] = 'Bestuur aktiwiteite';
$string['modulesecurity'] = 'Module sekuriteit';
$string['moodleapp'] = 'Moodle toep';
$string['moodleapp_help'] = '<p>Die gratis Moodle toep gee gebruikers toegang tot hul kursusse op mobiele toestelle. Addisionele toep-eienskappe is beskikbaar met \'n Pro of Premium toep plan.</p>
<a href="https://moodle.com/mobile-app">Kry die Moodle toep</a><br />
<a href="https://apps.moodle.com">Moodle Toep Portaal</a>';
$string['moodlebrandedapp'] = 'Gebrandmerkte Moodle toep';
$string['moodlebrandedapp_help'] = '<p>Die Gebrandmerkte Moodle Toep het al die funksionaliteti van ons gratis mobiele toep vir Moodle tesame met jou eie doelgemaakte brandmerk.</p>
<a href="https://moodle.com/branded-app">Oor die Gebrandmerkte Moodle toep </a>';
$string['moodlebrandedappreference'] = 'Andersisnd, kry \'n <a href="https://moodle.com/branded-app/">Gebrandmerkte Moodle toep</a> met jou eie doelgemaakte brandmerk.';
$string['moodlepartners'] = 'Moodle Vennote';
$string['moodlepartners_help'] = '<p>Moodle Vennote is diensverskaffers wat deur Moodle hoofkantoor gesertifiseer is om hoë kwaliteit Moodle dienste vir jou organisasie se aanlyn leeromgewing te bied.</p>
<a href="https://moodle.com/about-partners/">Meer oor ons Vennote</a><br />
<a href="https://moodle.com/partners">Vind \'n Vennoot</a>';
$string['moodleservices'] = 'Moodle dienste';
$string['moodleservices_help'] = 'Maak seker dat jy net die beste vanuit jou Moodle leeromgewing put deur hierdie Moodle dienste te gebruik:';
$string['multilangforceold'] = 'ForseerDwing ou multilang sintaks: &lt;span&gt; sonder die class="multilang" en &lt;lang&gt;';
$string['mustenablestats'] = 'Statistieke is nog nie op hierdie webwerf ontsper nie.';
$string['mycourses'] = 'My kursusse';
$string['mycoursesperpage'] = 'Aantal kursusse';
$string['mydashboard'] = 'Stelsel verstek paneelbord';
$string['mymoodle'] = 'Paneelbord';
$string['mymoodleredirect'] = 'Dwing gebruikers om My Moodle te gebruik';
$string['mypage'] = 'Verstek Paneelbord bladsy';
$string['mypagelocked'] = 'Sluit verstek bladsy';
$string['myprofile'] = 'Verstek profiel bladsy';
$string['navadduserpostslinks'] = 'Voeg skakels by om gebruikers se inskrywings te besigtig';
$string['navadduserpostslinks_help'] = 'Indien ontsper sal twee skakel by elke gebruiker gevoeg in die navigasie gevoeg word om gesprekke wat die gebruiker begin het te sien sowel as inskrywings wat in forums regoor die webwerf of in spesifieke kursusse gemaak is.';
$string['navcourselimit'] = 'Kursus limiet';
$string['navigationupgrade'] = 'Hierdie opgradering bring twee nuwe navigasieblokke in wat die volgende blokke vervang: Administrasie, Kursusse, Aktiwiteite en Deelnemers. Indien jy enige spesiale toestemmings op hierdie blokke ingestel het, maak seker dat alles werk soos beplan.';
$string['navshowallcourses'] = 'Vertoon alle kursusse';
$string['navshowcategories'] = 'Vertoon kursus kategorieë';
$string['navshowfrontpagemods'] = 'Wys tuisblad aktiwiteite in die navigasie';
$string['navshowfrontpagemods_help'] = 'As dit geaktiveer is, sal werftuisaktiwiteite onder op die navigasie werfbladsye gewys word. Hierdie instelling is slegs van toepassing op temas gebaseer op Klassiek.';
$string['navshowfullcoursenames'] = 'Vertoon volle name van die kursusse';
$string['navshowfullcoursenames_help'] = 'Indien ontsper word die volle name van kursusse in die navigasie vertoon, in plaas van die kort name.';
$string['navshowmycoursecategories'] = 'Vertoon my kursus kategorieë';
$string['navshowmycoursecategories_help'] = 'Indien ontsper gaan die kursusse in die gebruiker se \'My kursusse\' tak in kategorieë in die navigasieblok vertoon word (slegs Klassiek-gebaseerde temas).';
$string['navsortmycourseshiddenlast'] = 'Sorteer my versteekte kursusse laaste';
$string['navsortmycourseshiddenlast_help'] = 'Indien ontsper sal enige versteekte kursusse na sigbare kursusse gelys word (vir gebruikers wat versteekte kursusse kan besigtig). Andersins sal alle kursusse (maak nie saak of hulle sigbaar is of nie) gelys word in ooreenstemming met die \'Sorteer my kursusse\' instelling.';
$string['navsortmycoursessort'] = 'Volgorde van kursusse in navigasieblok';
$string['navsortmycoursessort_help'] = 'Moet kursusse gelys word in die sorteervolgorde wat gestel is in Werfadministrasie > Kursusse > Bestuur kursusse en kategorieë, of alfabeties volgens kursusinstelling? Hierdie instelling is slegs van toepassing op temas gebaseer op Classic.';
$string['never'] = 'Nooit';
$string['neverdeleteruns'] = 'Moet nooit lopies uitwis nie';
$string['newestdocindexed'] = 'Nuutste dokument geïndekseer';
$string['nobookmarksforuser'] = 'Jy het nie enige boekmerke nie.';
$string['nodatabase'] = 'Geen databasis';
$string['nohttpsformobilewarning'] = 'Dit word aanbeveel om HTTPS met \'n geldige sertifikaat te gebruik. Die Moodle toep gaan altyd eerste probeer om \'n veilige konneksie te gebruik.';
$string['nomissingstrings'] = 'Geen vermiste stringe';
$string['none'] = 'Geen';
$string['nonewsettings'] = 'Geen nuwe instellings is tydens hierdie opgradering bygevoeg nie';
$string['nonexistentbookmark'] = 'Die boekmerk wat jy aangevra het, bestaan nie.';
$string['noreplyaddress'] = 'Geen-antwoord adres';
$string['noreplydomain'] = 'Geen-antwoord en domein';
$string['noreplydomaindetail'] = 'Instellings vir Geen-antwoord en gekonfigureerde domeins';
$string['noresults'] = 'Geen resultate gevind.';
$string['noroles'] = 'Geen rolle';
$string['nosupportedlogstore'] = 'Geen logstoor gevind wat ondersteun word nie';
$string['noteunneededblocks'] = 'Let wel: Blokke wat gestel is om te wys, sal nie in die \'Voeg \'n blok by\'-kieslys in \'n kursus gelys word as hulle in die tema-instelling \'Onnodige blokke\' gespesifiseer word.';
$string['notifications'] = 'Kennisgewings';
$string['notifyloginfailures'] = 'E-pos mislukte inteken-probeerslae aan';
$string['notifyloginthreshold'] = 'Drumpel vir e-pos kennisgewings';
$string['notloggedinroleid'] = 'Rol vir besoekers';
$string['numberofmissingstrings'] = 'Aantal vermiste stringe: {$a}';
$string['numberofstrings'] = 'Totale aantal stringe:  {$a->strings}<br />Vermis: {$a->missing} ({$a->missingpercent}&nbsp;%)';
$string['oauthrefreshtokenexpired'] = 'Die verfris teken vir een van die OAuth dienste {$a->issuer} op jou webwerf {$a->siteurl} het verval. Dit gaan die funksionaliteit van enige inprop wat hierdie diens gebruik verminder. Om die probleem reg te stel, besoek die OAuth 2 Dienste konfigurasie bladsy en klik op die "Konnekteer stelsel rekening"-ikoon in die tabel ry vir hierdie diens. Maak seker om elke keer in te teken met dieselfde rekening vir die OAuth stelsel.';
$string['oauthrefreshtokenexpiredshort'] = 'OAuth verfris teken het verval vir {$a->issuer} op jou webwefr {$a->siteurl}.';
$string['onlynoreply'] = 'Slegs wanneer vanaf \'n geen-antwoord e-posadres';
$string['opcacherecommended'] = 'PHP opcode kas verbeter werksverrigting en verminder geheue-vereistes, OPcache uitbreiding word voorgestel en ten volle ondersteun.';
$string['opensslrecommended'] = 'Dit word sterk aanbeveel om die OpenSSL biblioteek te installeer -- dit ontsper die Moodle Netwerkwerking funksionaliteit.';
$string['opensslrequired'] = 'Die OpenSSL PHP uitbreiding is nou \'n vereiste deur Moodle om sterker kriptografiese dienste te bied.';
$string['opentowebcrawlers'] = 'Oop vir soekenjins';
$string['optionalmaintenancemessage'] = 'Opsionele instandhoudingsboodskap';
$string['order1'] = 'Eerste';
$string['order2'] = 'Tweede';
$string['order3'] = 'Derde';
$string['order4'] = 'Vierde';
$string['outgoingmailconfig'] = 'Uitgaande e-pos konfigurasie';
$string['overridetossl'] = 'HTTPS vir intekenings is nou opgeskort. Hierdie instansie word nou na SSL gedwing. Om hierdie kennisgewing op te los, verander die wwwroot in config.php na https://';
$string['pageinfodebugsummary'] = 'Hierdie bladsy is: {$a}';
$string['passwordchangelogout'] = 'Teken uit na \'n wagwoord verandering';
$string['passwordchangelogout_desc'] = 'Indien ontsper word alle blaaier sessies getermineer waneer \'n wagwoord verander word, behalwe vir die een waarin die nuwe wagwoord gespesifiseer is. (Hierdie verstelling beïnvloed nie wagwoordveranderings deur middel van massa gebruiker-oplaai nie.)';
$string['passwordchangetokendeletion'] = 'Verwyder webdienste toegangtekens na \'n wagwoord verander word';
$string['passwordchangetokendeletion_desc'] = 'Indien ontsper sal al die gebruiker se webdienste toegangtekens uitgewis word wanneer \'n wagwoord verander word.';
$string['passwordpolicy'] = 'Wagwoordbeleid';
$string['passwordpolicycheckonlogin'] = 'Gaan wagwoord op inteken na';
$string['passwordresettime'] = 'Maksimum tyd om \'n wagwoord terugstel navraag te valideer';
$string['passwordreuselimit'] = 'Wagwoord hergebruik limiet';
$string['passwordreuselimit_desc'] = 'Aantal kere wat \'n gebruiker \'n wagwoord moet verander voordat hulle toegelaat word om \'n wagwoord te hergebruik. Ge-enkripteerde wagwoorde wat voorheen gebruik is word in die plaaslike databasis-tabel gestoor. Hierdie funksie mag dalk nie versoenbaar wees met sekere eksterne verifikasie inproppe nie.';
$string['pathtodot'] = 'Baan na dot';
$string['pathtodot_help'] = 'Baan na dot. Op Linux is dit seker iets soos /usr/bin/dot. Op Windows is dit iets soos C:\\Program Files(x86)Graphviz2.38\\bin.dot.exe. Op \'n Mac is dit iets soos /opt/local/bin/dot. Om in staat te wees om grafika vanaf DOT-lêers te genereer, moes jy die dot uitvoerbare geïnstalleer het en nou hierna verwys.';
$string['pathtodu'] = 'Baan na du';
$string['pathtogs'] = 'Baan na spooksfrif';
$string['pathtogs_help'] = 'Op die meeste Linux installerings kan hierdie gelos word as \'/usr/bin/gs\'. Op Windows sal dit iets wees soos \'c:\\gs\\bin\\gswin32c.exe\' (maak seker dat daar geen spasies in die baan is nie - indien nodig, kopieër die \'gswin32c.exe\' en \'gsdll32.dll\' lêers na \'n nuwe lêergids sonder spasies in die baan.).';
$string['pathtopdftoppm'] = 'Baan na pdftoppm';
$string['pathtopdftoppm_help'] = '<a href="https://poppler.freedesktop.org/">Poppler</a> is \'n PDF uitbeeldingsbiblioteek wat die hulpmiddel pdftoppm insluit om PDF lêers na PNG om te skakel. Werksverrigitng is oor die algemeen beter as met Ghostscript, veral met groot lêers. Indien teenwoordig, sal pdftoppm in plaas van Ghostscript vir hierdie taak gebruik word. Op meeste Linux installasies kan die baan as /usr/bin/pdftoppm gelaat word. Indien nie teenwoordig, installeer die poppler-utils of poppler pakket, afhangend van jou Linux distribusie. Op Windows sal dit deur Cygwin installasies verskaf word.';
$string['pathtopgdump'] = 'Baan na pg_dump';
$string['pathtopgdumpdesc'] = 'Dit is slegs nodig om hierdie in te voer indien jy meer as een pg_dump op jou sisteem het (byvoorbeeld as daar meer as een weergawe van postgresql geïnstalleer is).';
$string['pathtopgdumpinvalid'] = 'Ongeldige baan na pg_dump - dit is of die verkeerde baan of dit is nie uitvoerbaar nie.';
$string['pathtophp'] = 'Baan na PHP CLI';
$string['pathtopsql'] = 'Baan na psql';
$string['pathtopsqldesc'] = 'Dit is slegs nodig om hierdie in te voer indien jy meer as een psql op jou sisteem het (byvoorbeeld as daar meer as een weergawe van postgresql geïnstalleer is).';
$string['pathtopsqlinvalid'] = 'Ongeldige baan na psql - dit is of die verkeerde baan of dit is nie uitvoerbaar nie.';
$string['pathtopython'] = 'Baan na Python';
$string['pathtopythondesc'] = 'Baan na jou uitvoerbare Python binêre lêer (beide Python 2 en Python 3 is aanvaarbaar).';
$string['pathtosassc'] = 'Baan na SassC';
$string['pathtosassc_help'] = 'Deur die plek van die SassC binêre lêer te spesifiseer gaan die SASS samesteller van Moodle se PHP implementasie na SassC verander. Sien https://github.com/sass/sassc vir meer inligting.';
$string['pcreunicodewarning'] = 'Dit word sterk aanbeveel om die PCRE PHP uitbreiding, wat versoenbaar met Unicode karakters is, te gebruik.';
$string['perfdebug'] = 'Werksverrigting inligting';
$string['performance'] = 'Werksverrigting';
$string['pgcluster'] = 'PostgreSQL Kluster';
$string['pgclusterdescription'] = 'PostgreSQL weergawe/kluster parameter vir bevelreël operasies. As jy net een postgresql op jou sisteem het of onseker is oor wat dit is, laat hierdie leeg.';
$string['phpfloatproblem'] = '\'n Onverwagse probleem is opgetel in die hantering van PHP dryfnommers - {$a}';
$string['pid'] = 'PID';
$string['pleaserefreshregistration'] = 'Jou webwerf is geregistreer. Registrasie is laas op {$a} opgedateer.<br /> Die \'Webwerf registrasie\' geskeduleerde opdrag hou jou registrasie op datum. Jy kan enige tyd jou registrasie met die hand opdateer.';
$string['pleaserefreshregistrationnewdata'] = 'Registrasie inligting is verander. Bevestig dit asseblief deur die \'Dateer registrasie op\' -knoppie te gebruik.';
$string['pleaserefreshregistrationunknown'] = 'Jou webwerf is geregistreer, maar die registrasiedatum is onbekend. Dateer asseblief jou registrasie op deur die \'Dateer registrasie op\' -knoppie te gebruik, of maak seker dat die \'Webwerf registrasie\' geskeduleerde opdrag ontsper is sodat jou registrasie outomaties opgedateer kan word.';
$string['plugin'] = 'Inprop';
$string['plugins'] = 'Inproppe';
$string['pluginscheck'] = 'Inprop afhanklikes toets';
$string['pluginscheckfailed'] = 'Afhanklikes toets het gefaal vir {$a->pluginslist}';
$string['pluginschecktodo'] = 'Jy moet al die inprop vereistes oplos voordat jy kan voortgaan met die installering van hierdie weergawe van Moodle!';
$string['pluginsoverview'] = 'Inprop oorsig';
$string['pluginsoverviewsee'] = 'Sien die <a href="{$a->url}">inproppe oorsig</a> bladsy vir meer inligting.';
$string['policysettings'] = 'Beleid instellings';
$string['privacy:metadata'] = 'Die Administrasie inprop stoor nie enige persoonlike data nie.';
$string['privacyandpolicies'] = 'Privaatheid en beleide';
$string['privacysettings'] = 'Privaatheid instellings';
$string['profilecategory'] = 'Kategorie';
$string['profilecategoryname'] = 'Kategorie naam (moet uniek wees)';
$string['profilecategorynamenotunique'] = 'Hierdie kategorie naam is reeds in gebruik';
$string['profilecommonsettings'] = 'Algemene instellings';
$string['profileconfirmcategorydeletion'] = 'Daar is {$a} veld/e in hierdie kategorie wat na die kategorie hierbo geskuif gaan word (of hieronder indien in die boonste kategorie).<br />Wil jy steeds hierdie kategorie uitwis?';
$string['profileconfirmfielddeletion'] = 'Daar is {$a} gebruiker-rekord/s vir die veld wat uitgewis gaan word.<br />Wil jy steeds hierdie veld uitwis?';
$string['profilecreatecategory'] = 'Skep \'n nuwe profiel kategorie';
$string['profilecreatefield'] = 'Skep \'n nuwe profiel veld';
$string['profilecreatenewcategory'] = 'Skepping van \'n nuwe kategorie';
$string['profilecreatenewfield'] = 'Skepping van \'n nuwe \'{$a}\' profiel veld';
$string['profiledefaultcategory'] = 'Ander velde';
$string['profiledefaultchecked'] = 'Gemerk by verstek';
$string['profiledefaultdata'] = 'Verstek waarde';
$string['profiledeletecategory'] = 'Uitwissing van \'n kategorie';
$string['profiledeletefield'] = 'Uitwissing van veld \'{$a}\'';
$string['profiledescription'] = 'Beskrywing van die veld';
$string['profiledscript'] = 'Hierdie skrip is geprofileer';
$string['profiledscriptview'] = 'Besigtig profilering inligting van hierdie skrip';
$string['profileeditcategory'] = 'Redigering van kategorie: {$a}';
$string['profileeditfield'] = 'Redigering van profiel veld: {$a}';
$string['profilefield'] = 'Profiel veld';
$string['profilefieldcolumns'] = 'Kolomme';
$string['profilefieldispassword'] = 'Is hierdie \'n wagwoord veld?';
$string['profilefieldlink'] = 'Skakel';
$string['profilefieldlink_help'] = 'Om die teks na \'n skakel om te skakel, voeg die URL in wat $$ bevat, waar $$ met die teks vervang sal word. Byvoorbeeld, om \'n Twitter ID na \'n skakel om te skakel, sleutel http://twitter.com/$$ in.';
$string['profilefieldlinktarget'] = 'Skakel teiken';
$string['profilefieldmaxlength'] = 'Karakter limiet';
$string['profilefieldmaxlength_help'] = 'Om hierdie veld in die instelling \'Wys gebruikeridentiteit\' te gebruik, moet die limiet 255 karakters of minder wees.';
$string['profilefieldrows'] = 'Rye';
$string['profilefields'] = 'Gebruiker profiel velde';
$string['profilefieldsize'] = 'Vertoon grootte';
$string['profileforceunique'] = 'Moet die data uniek wees?';
$string['profileinvaliddata'] = 'Ongeldige waarde';
$string['profilelocked'] = 'Is hierdie veld gesluit?';
$string['profilemenudefaultnotinoptions'] = 'Die verstek waarde is nie een van die opsies nie';
$string['profilemenunooptions'] = 'Geen kieslys opsies is verskaf nie';
$string['profilemenuoptions'] = 'Kieslys opsies (een per lyn)';
$string['profilemenutoofewoptions'] = 'Jy moet ten minste twee opsies verskaf';
$string['profilename'] = 'Naam';
$string['profilenofieldsdefined'] = 'Geen velde is gedefinieer nie';
$string['profilerequired'] = 'Is hierdie veld \'n vereiste?';
$string['profileroles'] = 'Sigbare profiel rolle';
$string['profilesforenrolledusersonly'] = 'Profiele slegs vir ingeskrewe gebruikers';
$string['profileshortname'] = 'Kort naam (moet uniek wees)';
$string['profileshortnameinvalid'] = 'Die kort naam kan slegs alfanumeriese karakters (letters en nommers) en die onderstreep (_) bevat.';
$string['profileshortnamenotunique'] = 'Hierdie kort naam is reeds in gebruik';
$string['profilesignup'] = 'Vertoon op die opteken bladsy?';
$string['profilespecificsettings'] = 'Spesifieke instellings';
$string['profilevisible'] = 'Vir wie is hierdie veld sigbaar?';
$string['profilevisible_help'] = '* Nie sigbaar nie - Vir privaat data slegs sigbaar deur administrateurs en bestuurders
* Sigbaar vir gebruiker - Vir privaat data slegs sigbaar deur die gebruiker en administrateurs
* Sigbaar vir gebruiker, onderwysers en administrateurs - Vir privaat data slegs sigbaar deur die gebruiker, administrateurs en onderwysers (op kursusprofiel)
* Sigbaar vir almal';
$string['profilevisibleall'] = 'Sigbaar vir almal';
$string['profilevisiblenone'] = 'Nie sigbaar';
$string['profilevisibleprivate'] = 'Sigbaar vir gebruiker';
$string['profilevisibleteachers'] = 'Sigbaar aan gebruiker, onderwysers en administrateurs';
$string['profiling'] = 'Profilering';
$string['profilingallowall'] = 'Aanhoudende profilering';
$string['profilingallowall_help'] = 'Indien hierdie instelling ontsper word kan jy op enige tydstip die PROFILEALL parameter op enige plek (PGC) gebruik om profilering vir al die uitgevoerde skiptekste van die Moodle sessie-lewe te ontsper. Om die proses te stop kan jy die PROFILEALLSTOP parameter gebruik.';
$string['profilingallowme'] = 'Selektiewe profilering';
$string['profilingallowme_help'] = 'Indien hierdie instelling ontsper word kan jy selektief die PROFILEME parameter op enige plek (PGC) gebruik en profilering vir daardie skripteks sal plaasvind. Om die proses te keer kan jy die DONTPROFILEME parameter gebruik.';
$string['profilingautofrec'] = 'Outomatiese profilering';
$string['profilingautofrec_help'] = 'Deur hierdie instelling te konfigureer sal \'n navraag (hierdie sal lukraak gebeur en hang af van die frekwensie wat gespesifiseer word - 1 van N) gekies en outomaties geprofileer word, waarna resultate vir verdere analise gestoor sal word. Let daarop dat hierdie metode van profilering die sluit in/uit instellings nakom. Stel dit na 0 om outomatiese profilering te versper.';
$string['profilingenabled'] = 'Ontsper profilering';
$string['profilingenabled_help'] = 'Indien jy hierdie instelling aktiveer sal profilering in hierdie webwerf beskikbaar wees. Jy sal ook in staat wees om die gedrag te definieer deur die volgende opsies te konfigureer.';
$string['profilingexcluded'] = 'Sluit profilering uit';
$string['profilingexcluded_help'] = 'Lys van (geskei met kommas of \'n nuwe lyn, absoluut deur wwwroot oor te staan, roepbaar) URLs wat van profilering uitgesluit gaan wees vanaf die wat gedefinieer is deur die \'Profileer hierdie\' instelling.';
$string['profilingimportprefix'] = 'Profilering invoer voorvoegsel';
$string['profilingimportprefix_desc'] = 'Vir makliker identifisering sal al die ingevoerde profileringlopies met hierdie voorvoegsel (die waarde wat hier gespesifiseer word) verskyn.';
$string['profilingincluded'] = 'Profileer hierdie';
$string['profilingincluded_help'] = 'Lys van (geskei met kommas of \'n nuwe lyn, absoluut deur wwwroot oor te staan, roepbaar) URLs wat outomaties geprofileer gaan word. Byvoorbeeld: /index.php, /course/view.php. Dit aanvaar ook die * karakter in enige posisie. Byvoorbeeld: /mod/forum/*, /mod/*/view.php';
$string['profilinglifetime'] = 'Hou profileringslopies';
$string['profilinglifetime_help'] = 'Spesifiseer hoe lank jy imformasie oor ou profileringslopies wil hou. Ouer lopies sal periodies gesnoei word. Let op dat hierdie enige profileringslopies wat as \'verwysingslopie\' gemerk is, uitsluit.';
$string['profilingslow'] = 'Profiel stadige bladsye';
$string['profilingslow_help'] = 'Deur \'n minumum tyd in sekondes in te stel sal alle stadiger as dit geprofileer word. Slegs profiele wat stadiger as \'n huidige profiel vir dieselfde teksskrip is sal gehou word. Stel na 0 om te versper. Let daarop dat hierdie die uitsluitings-instellings nakom.';
$string['protectusernames'] = 'Beskerm gebruikersname';
$string['proxybypass'] = 'Instaanbediener omseil gashere';
$string['proxyfixunsafe'] = 'Herstel onbevoegde oproepe';
$string['proxyhost'] = 'Instaanbediener gasheer';
$string['proxylogunsafe'] = 'Teken onbevoegde oproepe aan';
$string['proxypassword'] = 'Instaanbediener wagwoord';
$string['proxyport'] = 'Instaanbediener poort';
$string['proxytype'] = 'Instaanbediener tipe';
$string['proxyuser'] = 'Instaanbediener gebruikersnaam';
$string['purgecaches'] = 'Maak alle kasse skoon';
$string['purgecachesconfirm'] = 'Moodle kan temas, javascript, taalstringe, gefilterde teks, rss voere en vele ander berekende data kas. Om hierdie kasse skoon te maak sal daardie data van die bediener uitwis en blaaiers dwing om weer vars data te gaan haal. Dit verseker dat jy die mees op datum waardes wat deur die huidige kode geproduseer word, sien. Daar is geen gevaar in die skoonmaak van kasse nie, maar dit mag voorkom dat jou webwerf \'n bietjie stadiger is totdat die bedienr en die kliënte nuwe informasie bereken en kas.';
$string['purgecachesfinished'] = 'Alles kasse is skoongemaak.';
$string['purgecachesnoneselected'] = 'Kies een of meer kasse om skoon te maak';
$string['purgecachespage'] = 'Maak kasse skoon';
$string['purgefiltercache'] = 'Teks filters';
$string['purgejscache'] = 'JavaScript';
$string['purgelangcache'] = 'Taalstringe';
$string['purgemuc'] = 'Alle MUC kasse';
$string['purgeothercaches'] = 'Alle lêer en allerlei kasse';
$string['purgeselectedcaches'] = 'Maak geselekteerde kasse skoon';
$string['purgeselectedcachesfinished'] = 'Die geselekteerde kasse is skoongemaak';
$string['purgetemplates'] = 'Template';
$string['purgethemecache'] = 'Temas';
$string['query'] = 'Navraag';
$string['question'] = 'Vraag';
$string['questionbehaviours'] = 'Vraag optredes';
$string['questioncwqpfscheck'] = 'Een of meer lukrake vrae in \'n vasvra word opgestel om vrae uit \'n mengsel van gedeelde en ongedeelde vraagkategorieë te kies. Sien die <a href="{$a->reporturl}">willekeurige vraeverslag</a> en die <a href="{$a->docsurl}">dokumentasie</a>.';
$string['questioncwqpfsok'] = 'Goed. Daar is geen \'lukrake\' vrae in jou vraelyste wat opgestel is om vrae vanuit van \'n mengsel van gedeelde en ongedeelde vraag kategorieë te selekteer nie.';
$string['questiontype'] = 'Vraag tipe';
$string['questiontypes'] = 'Vraag tipes';
$string['quizattemptsupgradedmessage'] = 'In Moodle 2.1 was daar \'n groot opgradering van vrae. Dit was moontlik om sekere dele van die databasis se opgradering uit te stel vir later. Voordat daar na Moodle 2.7 opgegradeer kan word, moet hierdie opgradering voltooi word.';
$string['recaptchaprivatekey'] = 'ReCAPTCHA geheime sleutel';
$string['recaptchapublickey'] = 'ReCAPTCHA webwerf sleutel';
$string['referrernone'] = 'Blaaier verstek';
$string['referrerpolicy'] = 'Verwyser beleid';
$string['referrerpolicydesc'] = 'Stel dat die verwyser beleid opskrif in antwoorde vanaf jou webwerf ingesluit sal word.';
$string['register'] = 'Registreer jou webwerf';
$string['registration'] = 'Registrasie';
$string['registration_help'] = 'Deur te registreer:

*Ontvang jy sekuriteitswaarskuwings
*Kan jy mobiele toep afdruk-boodskappe vanaf jou webwerf aktiveer
*Dra jy by tot ons Moodle statistieke van die wêreldwye gemeenskap';
$string['registrationwarning'] = 'Jou webwerf is nog nie geregistreer nie.';
$string['registrationwarningcontactadmin'] = 'Jou blad is nog nie geregistreer nie. Stel asseblief jou administrateur in kennis.';
$string['releasenoteslink'] = 'Vir meer inligting oor hierdie weergawe van Moodle, sien asbseblief die aanlyn <a target="_blank" href="{$a}">Vrystellingnotas</a>';
$string['rememberuserlicensepref'] = 'Onthou gebruiker lisensie voorkeur';
$string['rememberuserlicensepref_help'] = 'Indien ontsper sal die laaste lisensie wat deur die gebruiker geselekteer is, vooraf gekies word wanneer \'n lêer in die lêerkieser opgelaai word. Andersins word die verstek webwerf lisensie vooraf gekies.';
$string['rememberusername'] = 'Onthou gebruikersnaam';
$string['rememberusername_desc'] = 'Ontsper indien jy permanente koekies met gebruikersname gedurende gebruiker inteken wil stoor. Permanente koekies kan gesien word as \'n privaatheidsprobleem as dit sonder toestemming gebruik word.';
$string['replacefrontsearch'] = 'Word gebruik vir tuiskursussoektog';
$string['reportsmanage'] = 'Beheer verslae';
$string['required'] = 'Vereis';
$string['requiredentrieschanged'] = 'Nota: Na opgradering word die instelling \'Vereisde invoer voor besigtiging\' afgedwing in die volgende databasis aktiwiteite:<br/>{$a->text}<br/>';
$string['requiremodintro'] = 'Vereis aktiwiteitsbeskrywings';
$string['requiremodintro_desc'] = 'Indien ontsper gaan gebruikers gedwing word om \'n beskrywing vir elke aktiwiteit in te voer.';
$string['requires'] = 'Vereis';
$string['restorecourse'] = 'Herstel kursus';
$string['restorernewroleid'] = 'Rol van gebruikers wat rugsteune kan herstel';
$string['restorernewroleid_help'] = 'Indien die gebruiker nie alreeds toestemming het om die nuut-herstelde kursus te bestuur nie, word die gebruiker hierdie rol outomaties toegeken en ingeskryf indien nodig. Kies "Geen" indien jy nie wil hê dat hierdie gebruikers in staat moet wees om elke herstelde kursus te kan beheer nie.';
$string['resultfilter'] = 'Filter deur resultaat';
$string['reverseproxy'] = 'Omgekeerde instaanbediener';
$string['reverseproxyignore'] = 'Ignoreer omgekeerde instaanbedieners';
$string['riskconfig'] = 'Gebruikers kan moontlik webwerf konfigurasie en gedrag verander';
$string['riskconfigshort'] = 'Konifgurasie risiko';
$string['riskdataloss'] = 'Gebruikers kan moontlik groot hoeveelhede inhoud of inligting vernietig';
$string['riskdatalossshort'] = 'Risiko om data te verloor';
$string['riskmanagetrust'] = 'Gebruikers kan moontlik vertroubaarheidsinstellings van ander gebruikers verander';
$string['riskmanagetrustshort'] = 'Bestuur vertroubares';
$string['riskpersonal'] = 'Gebruikers kan moontlik toegang verkry tot privaat inligting van ander gebruikers';
$string['riskpersonalshort'] = 'Privaatheidsrisiko';
$string['riskspam'] = 'Gebruikers kan moontlik rommelpos aan die webwerf of ander gebruikers stuur';
$string['riskspamshort'] = 'Rommelpos risiko';
$string['riskxss'] = 'Gebruikers moontlik lêers en teks  byvoeg wat kruis-webwerf teksskrif (XSS) toelaat';
$string['riskxssshort'] = 'XXS risiko';
$string['roleswithexceptions'] = '{$a->roles}, met {$a->exceptions}';
$string['rssglobaldisabled'] = 'Versper op webwerf vlak';
$string['save'] = 'Stoor';
$string['savechanges'] = 'Stoor veranderinge';
$string['scssinvalid'] = 'SCSS kode is nie geldig nie, dit faal met: {$a}';
$string['search'] = 'Soek';
$string['searchablecourses'] = 'Deursoekbare kursusse';
$string['searchallavailablecourses'] = 'Deursoekbare kursusse';
$string['searchallavailablecourses_desc'] = 'In sommige situasies kan die soekenjin moontlik nie werk nie wanneer daar oor \'n groot aantal kursusse gesoek word. Stel om slegs kursusse te deursoek waar daar gebruikers ingeskryf is indien jy die aantal deursoekte kursusse moet beperk.';
$string['searchallavailablecourses_off'] = 'Soek slegs binne ingeskrewe kursusse';
$string['searchallavailablecourses_on'] = 'Soek binne alle kursusse waartoe die gebruiker toegang het';
$string['searchallavailablecoursesdesc'] = 'Indien ingestel om slegs binne ingeskrewe kursusse te soek, sal kursus inligting (naam en opsomming) en kursus inhoud slegs deursoek word indien die gebruiker in daardie kursus ingeskryf is. Andersins sal die kursus inligting en kursus inhoud van alle kursusse waartoe die gebruiker toegang tot het deursoek word, soos kursusse waar gastetoegang ontsper is.';
$string['searchalldeleted'] = 'Alle geïndekseerde inhoud is uitgewis';
$string['searchalternatesettings'] = 'Slegs-vrae plaasvervanger instellings';
$string['searchalternatesettings_desc'] = 'Indien jy hierdie instellings voltooi kan jy \'plaasvervanger instellings\' vir hierdie soekenjin in die slegs-vrae soekenjin opsie op die \'Bestuur globale soek\' bladsy selekteer. Hierdie is slegs nuttig wanneer daar tussen twee soekenjins van dieselfde tipe beweeg word.';
$string['searchareadisabled'] = 'Soekarea is versper';
$string['searchareaenabled'] = 'Soekarea is ontsper';
$string['searchareas'] = 'Soekareas';
$string['searchbanner'] = 'Soek inligting';
$string['searchbannerenable'] = 'Vertoon soek informasie';
$string['searchbannerenable_desc'] = 'Indien ontsper sal die teks hieronder op die bokant van die soekskerm vir alle gebruikers vertoon word. Dit kan gebruik word om gebruikers in te lig wanneer soekenjin instandhouding uitgevoer word.';
$string['searchdefaultcategory'] = 'Verstek soek kategorie';
$string['searchdefaultcategory_desc'] = 'Resultate vanaf die geselekteerde soekarea kategorie sal by verstek vertoon word.';
$string['searchdeleteindex'] = 'Wis alle geïndekseerde inhoud uit';
$string['searchdisplay'] = 'Vertoonopsies vir soek-resultate';
$string['searchenablecategories'] = 'Vertoon resultate in aparte kategorieë';
$string['searchenablecategories_desc'] = 'Indien ontsper sal soek-resultate in aparte kategorieë vertoon word.';
$string['searchengine'] = 'Soekenjin';
$string['searchenginealternatesettings'] = '{$a} (plaasvervanger instellings)';
$string['searchenginequeryonly'] = 'Slegs-vrae soekenjin';
$string['searchenginequeryonly_desc'] = 'Hierdie soekenjin sal slegs gebruik word om navrae te maak en nie vir indeksering nie. Deur hierdie eienskap te gebruik kan jy in \'n ander soekenjin herindekseer terwyl navrae aanhou om vanaf hierdie een te werk.';
$string['searchenginequeryonly_none'] = 'Geen (gebruik hoof soekenjin vir navrae)';
$string['searchenginequeryonlysame'] = 'Die slegs-vrae soekenjin en die hoof soekenjin kan nie dieselfde waarde hê nie.';
$string['searchhideallcategory'] = 'Versteek Alle reslutaat kategorie';
$string['searchhideallcategory_desc'] = 'Indien gekies sal die kategorie met alle resultate op die soek-resultaat skerm versteek word.';
$string['searchincludeallcourses'] = 'Sluit alle sigbare kursusse in';
$string['searchincludeallcourses_desc'] = 'Indien ontsper sal soek-resultate kursus inligting (naam en opsomming) vanaf kursusse wat aan die gebruiker sigbaar is insluit, al het hulle nie toegang tot die kursus inhoud nie.';
$string['searchindexactions'] = 'Indeks aksies';
$string['searchindexdeleted'] = 'Indeks uitgewis';
$string['searchindextime'] = 'Indeksering tydslimiet';
$string['searchindextime_desc'] = 'Wanneer groot hoeveelhede nuwe inhoud geindekseer word, sal die geskeduleeerde taak stop wanneer hierdie tydslimiet bereik word. Dit sal aanhou totdat die volgende taak hardloop.';
$string['searchindexupdated'] = 'Soekenjin inhoud is opgedateer';
$string['searchindexwhendisabled'] = 'Indekseer wanneer versper';
$string['searchindexwhendisabled_desc'] = 'Laat die geskeduleerde taak toe om die soekindeks op te bou selfs wanneer soek versper is. Hierdie is nuttig indien jy die indeks wil opbou voordat die soekfasiliteit aan studente verskyn.';
$string['searchinsettings'] = 'Soek in instellings';
$string['searchlastrun'] = 'Laaste lopie (tyd, # dokumente, # rekords, # geïgnoreer)';
$string['searchmanagement'] = 'Soek bestuur';
$string['searchmanagement_desc'] = 'Hierdie opsies is nuttig wanneer veranderinge aan webwerwe met groot soek-indekse (wat \'n lang tyd neem om te herbou) gemaak word.';
$string['searchmaxtopresults'] = 'Maksimum top resultate';
$string['searchmaxtopresults_desc'] = 'Die maksimum aantal resultate met die hoogste posisie wat bo die soekresultate vir kursusinhoud, kursusse en gebruikers vertoon moet word.';
$string['searchnotavailable'] = 'Soek is nie beskikbaar nie';
$string['searchoptions'] = 'Soek opsies';
$string['searchpartial'] = '(nog nie ten volle geïndekseer)';
$string['searchreindexed'] = 'Alle inhoud van die webwerf is weer geïndekseer.';
$string['searchreindexindex'] = 'Herindekseer alle inhoud van die webwerf';
$string['searchresults'] = 'Soek resultate';
$string['searchsetupinfo'] = 'Soek opstelling';
$string['searchteacherroles'] = 'Onderwyser rolle';
$string['searchteacherroles_desc'] = 'Kies alle rolle wat gebruikers met die rolrangorder hoër in soekresultate maak.';
$string['searchtopresults'] = 'Top resultate';
$string['searchupdateindex'] = 'Dateer geïndekseerde inhoud op';
$string['sectionerror'] = 'Seksie fout!';
$string['secureforms'] = 'Gebruik addisionele vorm sekuriteit';
$string['security'] = 'Sekuriteit';
$string['selectdevice'] = 'Kies toestel';
$string['selectsearchengine'] = 'Kies soekenjin';
$string['selecttheme'] = 'Kies tema vir {$a} toestel';
$string['server'] = 'Bediener';
$string['serverchecks'] = 'Bediener toetse';
$string['serverlimit'] = 'Bediener limiet';
$string['sessionautostartwarning'] = '<p>Ernstige konfigurasie-foute is opgetel. Laat weet asseblief die bediener administrateur.</p><p> Om behoortlik te funksioneer, vereis Moodle dat die administrateur die PHP instellings moet verander.</p><p><code>session.auto_start</code> moet gestel wees na <code>off</code>.</p><p>Hierdie instelling word beheer deur die  <code>php.ini</code>, Apache/IIS <br />konfigureerder of <code>.htaccess</code> lêer op die bediener te redigeer.</p>';
$string['sessioncookie'] = 'Koekie voorvoegsel';
$string['sessioncookiedomain'] = 'Koekie domein';
$string['sessioncookiepath'] = 'Koekie baan';
$string['sessionhandling'] = 'Sessie hantering';
$string['sessiontimeout'] = 'Tyd verstreke';
$string['sessiontimeoutwarning'] = 'Tyd verstreke Waarskuwing';
$string['settingdependenton'] = 'Hierdie instelling mag versteek wees, gebaseer op die waarde van <strong>{$a}</strong>.';
$string['settingfileuploads'] = 'Die oplaai van lêers is \'n vereiste vir normale gebruik, aktiveer dit asseblief in die PHP konfigurasie.';
$string['settingmaxinputvars'] = 'Dit word voorgestel dat PHP instelling max_input_vars ten minste 5000 moet wees.';
$string['settingmaxinputvarsrequired'] = 'PHP instelling max_input_vars moet ten minste 5000 wees.';
$string['settingmemorylimit'] = 'Onvoldoende geheue is opgetel. Stel die geheue-limiet asseblief hoër in die PHP instellings.';
$string['settingsafemode'] = 'Moodle is nie ten volle versoenbaar met veilige modus nie, vra asseblief die administrateur om dit af te skakel. Om Moodle in veilige modus te hardloop word nie ondersteun nie. Verwag verskeie problem indien so gedoen word.';
$string['setupsearchengine'] = 'Sel soekenjin op';
$string['showcommentscount'] = 'Vertoon kommentaar telling';
$string['showdetails'] = 'Vertoon besonderhede';
$string['showuseridentity'] = 'Vertoon gebruiker identiteit';
$string['showuseridentity_desc'] = 'Wanneer gebruikers geselekteer of na gesoek word, asook wanneer lyste van gebruikers vertoon word, mag hierdie hierdie velde tesame met hul volle name vertoon word. Hierdie velde word slegs vertoon aan gebruikers wat die moodle/site:viewuseridentity vermoë het. By verstek is dit onderwysers en bestuurders. (Hierdie opsie maak die meeste sin as jy een of twee verpligte velde by jou instansie het.)

Velde gemerk met \'n * is doelgemaakte gebruikerprofiel velde. Jy kan hierdie velde selekteer, maar daar is tans sommige skerms waarop hulle nie sal verskyn nie.';
$string['simplexmlrequired'] = 'Die SimpleXML PHP uitbreiding word nou deur Moodle vereis.';
$string['sitemailcharset'] = 'Karakterstel';
$string['sitemaintenance'] = 'Die webwerf ondergaan instandhouding en is nie huidiglik beskikbaar nie';
$string['sitemaintenancemode'] = 'Instandhoudingsmodus';
$string['sitemaintenanceoff'] = 'Instandhoudingsmodus is versper en die webwerf hardloop weer soos normaal';
$string['sitemaintenanceon'] = 'Jou webwerf is tans in instandhoudingsmodus (slegs administrateurs kan inteken of die webwerf gebruik).';
$string['sitemaintenanceoncli'] = 'Jou blad is tans in CLI instandhoudingsmodus. Geen webtoegang word toegelaat nie.';
$string['sitemaintenancetitle'] = '{$a} besig met instandhouding';
$string['sitemaintenancewarning'] = 'Jou webwerf is huidiglik in instandhoudingsmodus (slegs adminsitrateurs kan inteken). om hierdie webwerf na normale werking terug te keer, <a href="maintenance.php">versper instandhoudingsmodus</a>.';
$string['sitemaintenancewarning2'] = 'Jou webwerf is huidiglik in instandhoudingsmodus (slegs adminsitrateurs kan inteken). om hierdie webwerf na normale werking terug te keer, <a href="{$a}">versper instandhoudingsmodus</a>.';
$string['sitemenubar'] = 'Webwerf navigasie';
$string['sitenameintitle'] = 'Sluit werfnaam by bladsytitel in';
$string['sitenameintitle_help'] = 'Hierdie instelling sal die werfnaam aan die einde van die bladsytitel byvoeg. Dit word aangemoedig om die werfnaam by die bladsytitel in te sluit, aangesien dit die werf se toeganklikheid sal verbeter deur gebruikers in staat te stel om vinnig die bladsy waarin hulle tans is, te identifiseer.';
$string['sitepolicies'] = 'Webwerf sekuriteitsinstellings';
$string['sitepolicy'] = 'Webwerf beleid URL';
$string['sitepolicy_help'] = 'Die URL van die webwerf beleid wat alle geregistreerde gebruikers moet sien en mee instem voordat hulle die webwerf kan betree. Let daarop dat hierdie instelling slegs van krag is indien die webwerf beleidshanteerder na die verstek (kern) opsie ingestel is.';
$string['sitepolicyguest'] = 'Webwerf beleid URL vir gaste';
$string['sitepolicyguest_help'] = 'Die URL van die webwerf beleid wat alle gaste moet sien en mee instem voordat hulle die webwerf kan betree. Let daarop dat hierdie instelling slegs van krag is indien die webwerf beleidshanteerder na die verstek (kern) opsie ingestel is.';
$string['sitepolicyhandler'] = 'Webwerf beleidshanteerder';
$string['sitepolicyhandler_desc'] = 'Hierdie bepaal hoe beleide en gebruikerinstemming bestuur word. Die verstek (kern) hanteerder aktiveer \'n webwerf beleid URL en \'n webwerf beleid URL vir gaste wat gespesifiseer moet word. Die beleidshanteerder ontsper die instelling van webwerf, privaatheid en ander beleide wat gespesifiseer moet word. Dit ontsper ook gebruikerinstemmings wat besigtig moet word en waar nodig, instemming namens minderjariges.';
$string['sitepolicyhandlercore'] = 'Verstek (kern)';
$string['sitepolicyhandlerplugin'] = '{$a->name} ({$a->component})';
$string['sitesectionhelp'] = 'Indien geselekteer gaan \'n onderwerp seksie op die webwerf se voorblad vertoon word.';
$string['sixtyfourbitsrequired'] = 'Daar is bespeur dat jou werf nie \'n 64-bis PHP weergawe gebruik nie. U moet u stelsel (bedryfstelsel, PHP...) opgradeer voordat u hierdie Moodle-weergawe installeer.';
$string['sixtyfourbitswarning'] = 'Dit is opgetel dat jou webwerf nie \'n 64-bit PHP weergawe gebruik nie. Dit woord aanbeveel dat jy jou webwerf opgradeer om toekomstige versoenbaarheid te verseker.';
$string['slasharguments'] = 'Gebruik skuinsstreep argumente';
$string['slashargumentswarning'] = 'Dit word voorgestel dat die gebruik van skuinsstreep argumente ontsper moet wees. In die toekoms sal dit vereis word. Vir meer inligting, sien die dokumentasie <a href="https://docs.moodle.org/en/admin/environment/slasharguments">Gebruik van skuinsstreep argumente</a>.';
$string['smartpix'] = 'Smart Pix soek';
$string['smtp'] = 'SMTP';
$string['smtpauthtype'] = 'SMTP Verifikasie Tipe';
$string['smtpdetail'] = 'Eenvoudige E-pos Oordra Protokol (SMTP) instellings vir die stuur van e-pos.';
$string['smtphosts'] = 'SMTP gashere';
$string['smtpmaxbulk'] = 'SMTP sessie limiet';
$string['smtppass'] = 'SMTP wagwoord';
$string['smtpsecure'] = 'SMTP sekuriteit';
$string['smtpuser'] = 'SMTP gebruikersnaam';
$string['soaprecommended'] = 'Installering van die opsionele SOAP uitbreiding is nuttig vir webdienste en sekere inproppe.';
$string['sort_fullname'] = 'Kursus volle naam';
$string['sort_idnumber'] = 'Kursus ID-nommer';
$string['sort_shortname'] = 'Kursus kort naam';
$string['sort_sortorder'] = 'Volgorde vir sortering';
$string['spellengine'] = 'Spel-enijin';
$string['spelllanguagelist'] = 'Spel taallys';
$string['splrequired'] = 'Die SPL PHP uitbreiding word nou deur Moodle vereis.';
$string['stats'] = 'Statistieke';
$string['statsfirstrun'] = 'Maksimum prosessering interval';
$string['statsmaxruntime'] = 'Maksimum looptyd';
$string['statsmoodleorg'] = 'statistieke';
$string['statsruntimedays'] = 'Dae om te prosesseer';
$string['statsruntimestart'] = 'Voer uit op';
$string['statsuserthreshold'] = 'Gebruiker drumpel';
$string['stickyblocks'] = 'Taai blokke';
$string['stickyblockscourseview'] = 'Kursus bladsy';
$string['stickyblocksduplicatenotice'] = 'Indien enige blok wat jy hier byvoeg reeds op \'n sekere bladsy bestaan, sal daar \'n duplikaat ontstaan.<br />Slegs die vasgepende blok sal nie-redigeerbaar wees. Dit sal steeds moontlik wees om die duplikaat te redigeer.';
$string['stickyblocksmymoodle'] = 'My Moodle';
$string['stickyblockspagetype'] = 'Bladsy tipe om te konfigureer';
$string['strictformsrequired'] = 'Streng validasie van vereiste velde';
$string['stripalltitletags'] = 'Verwyder HTML etikette van alle aktiwiteit-name';
$string['supportandservices'] = 'Ondersteuning en dienste';
$string['supportavailability'] = 'Ondersteuning beskikbaarheid';
$string['supportcontact'] = 'Ondersteuning kontak';
$string['supportemail'] = 'Ondersteuning e-posadres';
$string['supportemailsubject'] = 'Werfondersteuningversoek - {$a}';
$string['supportname'] = 'Ondersteuning naam';
$string['supportpage'] = 'Ondersteuning bladsy skakel';
$string['suspenduser'] = 'Skort gebruiker rekening op';
$string['switchlang'] = 'Verander die \'lang\' lêergids';
$string['systempaths'] = 'Stelsel bane';
$string['tablenosave'] = 'Veranderinge in die tabel hierbo word outomaties gestoor.';
$string['tablesnosave'] = 'Veranderinge in die tabelle hierbo word outomaties gestoor.';
$string['tabselectedtofront'] = 'Moet die ry met die huidige geselekteerde oortjie vooraan geplaas word op tabelle met oortjies?';
$string['tabselectedtofronttext'] = 'Bring geselekteerde oortjie ry na tevore';
$string['task_adhoc_concurrency_limit'] = 'Ad hoc taak saamlopenheid limiet';
$string['task_adhoc_concurrency_limit_desc'] = 'Die aantal ad hoc taaklopers wat toegelaat word om saam te loop. As die limiet hoog ingestel is sal geskeduleerde take moontlik nie gereeld hardloop wanneer daar baie ad hoc take is nie. \'n Instelling van 0 sal die prosessering van ad hoc take ten volle versper.';
$string['task_adhoc_max_runtime'] = 'Ad hoc taakloper leeftyd';
$string['task_adhoc_max_runtime_desc'] = 'Die ouderdom van \'n ad hoc taakloper voordat dit vrygestel word. \'n Lae tydsduur word voorgestel aangesien daar geen limiet tot die hoeveelheid ad hoc take in die tou is nie. As hierdie getal te hoog ingestel en jy \'n lang ad hoc tou het,  sal geskeduleerde take moontlik nie gereeld hardloop nie.';
$string['task_dbreads'] = 'Databasis lees';
$string['task_dbstats'] = 'Databasis';
$string['task_dbwrites'] = 'Databasis skryf';
$string['task_duration'] = 'Tydsduur';
$string['task_logmode'] = 'Wanneer om te log';
$string['task_logmode_all'] = 'Stoor die afvoer van alle take';
$string['task_logmode_desc'] = 'Jy kan kies wanneer jy wil hê dat taaklogs plaasvind. By verstek is alle logs altyd vasgevang. Jy kan logs geheel en al versper of slegs die log take wat misluk.';
$string['task_logmode_failonly'] = 'Stoor slegs logs vir take wat misluk';
$string['task_logmode_none'] = 'Moenie enigiets log nie';
$string['task_logretainruns'] = 'Behou lopies';
$string['task_logretainruns_desc'] = 'Die hoeveelheid lopies van elke taak om te behou. Hierdie instelling werk saam met die \'Behoud Periode\' instelling: die een wat eerste bereik word sal van toepassing wees.';
$string['task_logretention'] = 'Behoud periode';
$string['task_logretention_desc'] = 'Die maksimum periode waarvoor logs gehou moet word. Hierdie instelling werk saam met die \'Behou lopies\' instelling: die een wat eerste bereik word sal van toepassing wees.';
$string['task_logtostdout'] = 'Vertoon log uitset';
$string['task_logtostdout_desc'] = 'Wanneer take hardloop en die uitset vasgevang word, of die gevange uitset ook vertoon moet word terwyl die taak hardloop.';
$string['task_result'] = 'Resultaat';
$string['task_result:failed'] = 'Misluk';
$string['task_scheduled_concurrency_limit'] = 'Saamlopende geskeduleerde take limiet';
$string['task_scheduled_concurrency_limit_desc'] = 'Die aantal geskeduleerde taaklopers wat toegelaat word om saam te loop. Indien die limiet hoog is kan die bediener moontlik \'n hoë las ervaar wat werksverrigting gaan affekteer. \'n Instelling van 0 sal die prosessering van geskeduleerde take geheel en al ontsper.';
$string['task_scheduled_max_runtime'] = 'Geskeduleerde taaklopie leeftyd';
$string['task_scheduled_max_runtime_desc'] = 'Die ouderdom van \'n geskeduleerde taaklopie voordat dit vrygestel word.';
$string['task_starttime'] = 'Begin tyd';
$string['task_stats:dbreads'] = '{$a} lees';
$string['task_stats:dbwrites'] = '{$a} skryf';
$string['task_status'] = 'Taak status';
$string['task_status_desc'] = 'Die taak \'{$a->name}\' is {$a->status}. Vir meer inligting, sien {$a->class}{$a->extradescription} in <a href="{$a->gotourl}">Geskeduleerde take</a>.';
$string['task_type:adhoc'] = 'Ad hoc';
$string['task_type:scheduled'] = 'Geskeduleer';
$string['taskadmintitle'] = 'Take';
$string['taskanalyticscleanup'] = 'Analise skoonmaak';
$string['taskautomatedbackup'] = 'Outomatiese rugsteune';
$string['taskbackupcleanup'] = 'Maak rugsteun tabelle, logs en lêers skoon';
$string['taskbadgescron'] = 'Ken kentekens toe';
$string['taskbadgesmessagecron'] = 'Agtergrond prosessering om kennisgewings van kentekens te stuur';
$string['taskblogcron'] = 'Sinkroniseer eksterne webjoernale';
$string['taskcachecleanup'] = 'Verwyder vervalle kas-inskrywings';
$string['taskcachecron'] = 'Agtergrond prosessering vir kasse';
$string['taskcalendarcron'] = 'Stuur kalender kennisgewings';
$string['taskcheckforupdates'] = 'Kyk vir opgraderings';
$string['taskcompletiondaily'] = 'Voltooiteken soos begin';
$string['taskcompletionregular'] = 'Bereken gereelde voltooi data';
$string['taskcontextcleanup'] = 'Maak kontekste skoon';
$string['taskcreatecontexts'] = 'Skep vermiste kontekste';
$string['taskdeletecachetext'] = 'Wis ou teks kas rekords uit';
$string['taskdeleteincompleteusers'] = 'Wis onvoltooide gebruikers uit';
$string['taskdeleteunconfirmedusers'] = 'Wis onbevestigde gebruikers uit';
$string['taskeventscron'] = 'Agtergrond prosessering vir gebeurtenisse';
$string['taskfiletrashcleanup'] = 'Maak lêers skoon in asblik';
$string['taskglobalsearchindex'] = 'Globale soek indeksering';
$string['taskglobalsearchoptimize'] = 'Globale soek indeks optimalisering';
$string['taskgradecron'] = 'Agtergrond prosessering vir punteboek';
$string['taskgradehistorycleanup'] = 'Agtergrond prosessering vir skoonmaak van tabelle se geskiedenis';
$string['taskh5pcleanup'] = 'Ongebruikte H5P lêers skoonmaak';
$string['tasklegacycron'] = 'Argaïese cron prosessering vir inproppe';
$string['tasklockcleanuptask'] = 'Maak ad hoc-taak metadata skoon';
$string['tasklogcleanup'] = 'Skoonmaak van taak logs';
$string['tasklogging'] = 'Taak log konfigurasie';
$string['tasklogs'] = 'Taak logs';
$string['taskmessagingcleanup'] = 'Agtergrond prosessering vir boodskappe';
$string['taskpasswordresetcleanup'] = 'Maak wagwoord herstel probeerslae skoon';
$string['taskplagiarismcron'] = 'Agtergrond prosessering vir argaïese cron in plagiaat inproppe';
$string['taskportfoliocron'] = 'Agtergrond prosessering vir protefeulje inproppe';
$string['taskprocessing'] = 'Taak prosessering';
$string['taskquestioncron'] = 'Agtergrond prosessering vir skoonmaak van vraag voorskoue';
$string['taskquestionstatscleanupcron'] = 'Agtergrond prosessering vir skoonmaak van vraag statistieke kas';
$string['taskrefreshsystemtokens'] = 'Vervris OAuth tekens vir diensprofiele';
$string['taskregistrationcron'] = 'Webwerf registrasie';
$string['tasksendfailedloginnotifications'] = 'Stuur mislukte inteken kennisgewings';
$string['tasksendnewuserpasswords'] = 'Stuur nuwe gebruiker wagwoorde';
$string['tasksessioncleanup'] = 'Maak ou sessies skoon';
$string['taskstatscron'] = 'Agtergrond prosessering vir statistieke';
$string['tasktagcron'] = 'Agtergrond prosessering vir etikette';
$string['tasktempfilecleanup'] = 'Verwyder verouderde tydelike lêers';
$string['tasktype'] = 'Tipe';
$string['tempdatafoldercleanup'] = 'Maak skoon tydelike datalêers ouer as';
$string['templates'] = 'Template';
$string['testoutgoingmailconf'] = 'Toets uitgaande e-pos konfigurasie';
$string['testoutgoingmailconf_errorcommunications'] = 'Jou webwerf kon nie met jou e-posbediener kommunikeer nie. Gaan asseblief jou uitgaande e-pos konfigurasie na.';
$string['testoutgoingmailconf_fromemail'] = 'Van gebruikersnaam of e-pos adres';
$string['testoutgoingmailconf_fromemail_help'] = 'Hierdie veld volg die stuur van die boodskap van die gebruiker na, maar die From-hoof gedeelte wat gebruik word in die regte e-pos wat gestuur word, sal afhang van ander instellings soos allowedemaildomains';
$string['testoutgoingmailconf_fromemail_invalid'] = 'Ongeldig van gebruikersnaam of e-pos. Moet \'n geldige e-posformaat of \'n bestaande gebruikersnaam in Moodle wees.';
$string['testoutgoingmailconf_message'] = 'Dit is \'n toetsboodskap om te bevestig dat u die uitgaande e-pos van u webwerf suksesvol opgestel het.  Gestuur: {$a}';
$string['testoutgoingmailconf_sendtest'] = 'Stuur \'n toetsboodskap';
$string['testoutgoingmailconf_sentmail'] = 'Die webwerf was suksesvol om \'n toetsboodskap na die e-posbediener te stuur..<br />Van: {$a->fromemail}<br />Na: {$a->toemail}';
$string['testoutgoingmailconf_subject'] = '{$a->site}: toets boodskap. {$a->additional} Gestuur: {$a->time}';
$string['testoutgoingmailconf_subjectadditional'] = 'Addisionele onderwerp';
$string['testoutgoingmailconf_toemail'] = 'Na e-posadres';
$string['testoutgoingmaildetail'] = 'Let wel: Voordat jy toets, stoor asseblief jou konfigurasie.<br />{$a}';
$string['testsiteupgradewarning'] = 'Jy gebruik tans die {$a} toets webwerf. Om dit behoorlik op te gradeer gebruik die beheerlyn koppelvlak hulpmiddel.';
$string['themedesignermode'] = 'Tema ontwerper modus';
$string['themedesignermodewarning'] = 'Tema ontwerper modus is ontsper. Hierdie instelling moet nie op lewendige webwerwe ontsper word nie aangesien dit werksverrigting aansienlik kan versleg.';
$string['themelist'] = 'Tema lys';
$string['themenoselected'] = 'Geen tema is geselekteer';
$string['themeresetcaches'] = 'Maak tema kaste skoon';
$string['themeselect'] = 'Verander tema';
$string['themeselector'] = 'Tema kieser';
$string['themesettings'] = 'Tema verstellings';
$string['therewereerrors'] = 'Daar was foute in jou data';
$string['thirdpartylibrary'] = 'Biblioteek';
$string['thirdpartylibrarylocation'] = 'Plek';
$string['thirdpartylibs'] = 'Derde-party biblioteke';
$string['timezone'] = 'Verstek tydsone';
$string['timezoneforced'] = 'Hierdie word deur die webwerf administrateur afgedwing';
$string['timezoneinvalid'] = 'Ongeldige tydsone "{$a}"';
$string['timezoneisforcedto'] = 'Forseer alle gebruikers om te gebruik';
$string['timezonenotforced'] = 'Gebruikers kan hul eie tydsone kies';
$string['timezonephpdefault'] = 'Verstek PHP tydsone ({$a})';
$string['timezoneserver'] = 'Bediener tydsone ({$a})';
$string['tlswarning'] = 'Geen PHP/cURL uitbreiding met TLSv1.2 ondersteuning is opgetel nie.  Sekere dienste mag moontlik nie werk nie. Dit word sterk aanbeveel dat jy jou TLS biblioteke opgradeer.';
$string['tokenduration'] = 'Tydsduur van teken geskep deur gebruiker';
$string['tokenduration_desc'] = 'Tydsduur vir hoe lank \'n webdiens teken wat deur \'n gebruiker geskep is (byvoorbeeld via die mobiele toep), geldig is.';
$string['tokenizerrecommended'] = 'Dit word aanbeveel om die opsionele PHP Tokenizer uitbreiding te installeer -- dit verbeter die Moodle Netwerking funksionaliteit.';
$string['tools'] = 'Admin hulpmiddels';
$string['toolsmanage'] = 'Bestuur admin hulpmiddels';
$string['unattendedoperation'] = 'Onbemande aksie';
$string['unbookmarkthispage'] = 'Verwyder die boekmerk van hierdie bladsy';
$string['unicoderequired'] = 'Dit word vereis dat jy al jou data in Unicode formaat (UTF-8) stoor. Nuwe installasies moet uitgevoer word in databasisse wat hul verstek karakterstel as Unicode het. Indien jy besig is om op te gradeer, moet jy die UTF-8 migrasie proses uitvoer (sien die Admin bladsy).';
$string['uninstallplugin'] = 'Verwyder';
$string['unlockaccount'] = 'Sluit rekening';
$string['unoconvwarning'] = 'Die weergawe van unoconv wat jy geïnstalleer het, word nie ondersteun nie.';
$string['unsettheme'] = 'Verwyder gekose tema';
$string['unsupported'] = 'Word nie ondersteun nie';
$string['unsupporteddbfileformat'] = 'Jou databasis gebruik Antelope as die lêerformaat. Volle UTF-8 ondersteuning in MySQL en MariaDB vereis die Barracuda lêerformaat. Skakel asseblief oor na die Barracuda lêerformaat. Sien die dokumentasie <a href="https://docs.moodle.org/en/admin/environment/custom check/mysql full unicode support">MySQL volle \'unicode\' ondersteuning</a> vir meer besonderhede.';
$string['unsupporteddbfilepertable'] = 'Vir volle ondersteuning van UTF-8 vereis beide MySQL en MariaDB dat jy jou MySQL instelling \'innodb_file_per_table\' na \'ON\' stel. Sien die dokumentasie vir verdere besonderhede.';
$string['unsupporteddblargeprefix'] = 'Vir volle ondersteuning van UTF-8 vereis beide MySQL en MariaDB dat jy jou MySQL instelling \'innodb_large_prefix\' na \'ON\' stel. Sien die dokumentasie vir verdere besonderhede.';
$string['unsupporteddbstorageengine'] = 'Die databasis stoorenjin wat gebruik word, word nie meer ondersteun nie.';
$string['unsupporteddbtablerowformat'] = 'Jou databasis het tabelle wat Antelope as die lêerformaat gebruik. Dit word aanbeveel om die tabelle omr te skakel na die Barracuda lêerformaat. Sien die dokumentasie <a href="https://docs.moodle.org/en/cli">Administrasie deur beheerlyn</a> vir meer besonderhede oor \'n hulpmiddel om InnoDB tabelle na Barracuda om te skakel.';
$string['unsupportedphpversion7'] = 'PHP weergawe 7 en hoër word nie ondersteun nie.';
$string['unsupportedphpversion71'] = 'PHP weergawe 7.1 en hoër word nie ondersteun nie.';
$string['unsupportedphpversion72'] = 'PHP weergawe 7.2 en hoër word nie ondersteun nie.';
$string['unsupportedphpversion73'] = 'PHP weergawe 7.3 en hoër word nie ondersteun nie.';
$string['unsupportedphpversion74'] = 'PHP weergawe 7.4 en hoër word nie ondersteun nie.';
$string['unsupportedphpversion80'] = 'PHP weergawe 8.0 en hoër word nie ondersteun nie.';
$string['unsuspenduser'] = 'Aktiveer gebruiker rekening';
$string['updateaccounts'] = 'Dateer bestaande rekeninge op';
$string['updateautocheck'] = 'Kyk outomaties vir beskikbare opdaterings';
$string['updateautocheck_desc'] = 'Indien ontsper gaan jou webwerf outomaties kyk vir beskikbare opdaterings vir beide Moodle kode en alle addisionele inproppe. Indien daar \'n nuwe opdatering beskikbaar is, sal \'n kennisgewing aan die webwerf administrateurs gestuur word.';
$string['updateavailable'] = 'Daar is \'n nuwe weergawe van Moodle beskikbaar!';
$string['updateavailable_moreinfo'] = 'Meer inligting...';
$string['updateavailable_release'] = 'Moodle {$a}';
$string['updateavailable_version'] = 'Weergawe {$a}';
$string['updateavailabledetailslink'] = 'Sien {$a->url} vir meer besonderhede';
$string['updateavailableforplugin'] = 'Daar is \'n nuwe weergawe vir sekere van jou inproppe beskikbaar!';
$string['updateavailableinstall'] = 'Installeer hierdie opdatering';
$string['updateavailableinstallall'] = 'Installeer beskikbare opdaterings ({$a})';
$string['updateavailableinstallallhead'] = 'Besig om beskikbare opdaterings te installeer';
$string['updateavailablenot'] = 'Jou Moodle kode is op datum!';
$string['updateavailablerecommendation'] = 'Dit word sterk aanbeveel dat jy jou webwerf na die nuutste weergawe opdateer om alle onlangse sekuriteit-en foutoplossings te verkry.';
$string['updatecomponent'] = 'Dateer komponent op';
$string['updateminmaturity'] = 'Vereiste kode volwassenheid';
$string['updateminmaturity_desc'] = 'Stuur kennisgewings van beskikbare opdaterings slegs indien die beskikbare kode ten minste die geselekteerde volwassenheidsvlak het. Opdaterings vir inproppe wat nie hul kode se volwassenheidsvlak verklaar nie word altyd gerapporteer, ongeag heirdie instelling.';
$string['updatenotificationfooter'] = 'Jou Moodle webwerf {$a->siteurl} is gekonfigureer om outomaties vir beskikbare opdaterings te kyk. Jy ontvang hierdie boodskap as die administrateur van die webwerf. Jy kan die outomatiese nagaan vir beskikbare opdaterings buite werking stel in Webwerf administrasie / Bediener / Opdatering kennisgewings of jy kan die aflewering van hierdie boodskap verander deur jou voorkeure bladsy.';
$string['updatenotifications'] = 'Dateer kennisgewings op';
$string['updatenotificationsubject'] = 'Moodle opdaterings is beskikbaar ({$a->siteurl})';
$string['updatenotifybuilds'] = 'Stel in kennis van nuwe opgraderings (\'builds\')';
$string['updatenotifybuilds_desc'] = 'Indien ontsper word die beskikbare weergawe van Moodle kode ook gerapporteer wanneer \'n nuwe \'build\' vir die huidige weergawe beskikbaar is. \'Builds\' is deurlopende verbeterings van \'n gegewe Moodle weergawe. Hulle word gewoonlik elke week vrygestel. Indien versper word die beskikbare opdatering slegs gerapporteer wanneer \'n hoër weergawe van Moodle beskikbaar is. Die nagaan vir inproppe word nie deur hierdie instelling geaffekteer nie.';
$string['upgradeerror'] = 'Onbekende fout met opgradering van {$a->plugin} na weergawe {$a->version}. Kan nie nou voortgaan nie.';
$string['upgradeforumread'] = '\'n Nuwe funksie is bygevoeg in Moodle 1.5 om geleesde/ongeleesde forumplasings op te spoor. <br /> Om hierdie funksie te gebruik, moet jy <a href="{$a}"> jou tabelle opdateer </a>.';
$string['upgradeforumreadinfo'] = '\'n Nuwe funksie is bygevoeg in Moodle 1.5 om geleesde/ongeleesde forumplasings na te spoor. Om hierdie funksie te gebruik, moet jy jou tabelle opdateer met al die opsporingsinligting vir bestaande plasings. Afhangend van die grootte van u webwerf, kan dit lank duur (ure) en kan dit vir die databasis baie veeleisend wees. Dus is dit die beste om dit gedurende \'n rustige periode te doen. Jou webwerf sal egter voortgaan om tydens hierdie opgradering te funksioneer, en gebruikers sal nie geraak word nie. Sodra jy met hierdie proses begin, moet jy dit laat klaar wees (hou jou blaaiervenster oop). As jy egter die proses stop deur die venster te sluit: moenie bekommerd wees nie, jy kan van voor af begin. <br /> <br /> Wil jy die opgraderingsproses nou begin?';
$string['upgradekeyreq'] = 'Opgradering sleutel vereis';
$string['upgradekeyset'] = 'Opgradering sleutel (los oop om nie in te stel nie)';
$string['upgradelogs'] = 'Vir volle funksionaliteit moet al jou ou logs opdateer word. <a href="{$a}">More information</a>';
$string['upgradelogsinfo'] = 'Sommige veranderinge is onlangs gemaak oor die manier waarop ou logs gestoor word. Om in staat te wees om al jou ou logs op \'n per-aktiwiteit basis te besigtig, moet jou ou logs opgradeer word. Afhangend van die grootte van jou webwerf kan hierdie baie lank neem (verskeie ure) en baie veeleisend van die databasis op groot webwerwe wees. As jy eers hierdie proses begin het, is dit beter om dit te laat klaar maak (hou jou blaaier venster oop). Moenie bekommerd wees nie - jou webwerf sal vir ander mense reg werk terwyl die logs opgradeer word.<br /><br />Wil jy nou jou logs opgradeer?';
$string['upgradepluginsfirst'] = 'Dit word aanbeveel om eers alle beskikbare opdaterings te installeer';
$string['upgradepluginsinfo'] = 'Inproppe word opgedateer';
$string['upgradepluginsinfo_help'] = 'Daar is opdaterings vir sekere van jou inproppe beskikbaar. Jy moet hulle almal installeer voordat jy die Moodle databasis installeer. Indien jou webwerf nie outomatiese opdaterings ontplooiing ondersteun nie, moet jy per hand nuwe weergawes van inproppe by jou bediener aflaai en installeer.';
$string['upgradepluginsinfo_link'] = 'admin/upgradepluginsinfo';
$string['upgradesettings'] = 'Nuwe instellings';
$string['upgradesettingsintro'] = 'Die instellings hier onder is tydens jou laaste Moodle opgradering bygevoeg. Maak veranderinge aan die verstek soos benodig en klik dan op die \'Stoor veranderinge\' knoppie onderaan hierdie bladsy.';
$string['upgradestalefiles'] = 'Gemengde weergawes van Moodle is opgetel. Die opgradering kan nie voortgaan nie.';
$string['upgradestalefilesinfo'] = 'Die Moodle opdatering is onderbreek omdat PHP skriptekste van ten minste twee hoof weergawes van Moodle in die Moodle gidslêer opgetel is.

Hierdie kan later beduidende probleme veroorsaak, so om voort te gaan moet jy seker maak dat die Moodle gidslêer slegs lêers vir \'n enkele weergawe van moodle bevat.

Die voorgestelde manier om jou Moodle gidslêer skoon te maak, is as volg:

* herbenoem die huidige Moodle gidslêer na "moodle_old"
* skep \'n nuwe Moodle gidslêer wat slegs lêers van of \'n standaard Moodle pakket wat afgelaai is, of vanaf die Moodle Git bron bevat
* skuif die oorspronklike config.php lêer en enige nie-standaard inproppe vanaf die "moodle_old" gidslêer na die nuwe Moodle gidslêer

Wanneer jy \'n skoon Moodle gidslêer het, verfris hierdie bladsy om die Moodle opdateringsproses voort te sit.

Hierdie waarskuwing word gereeld veroorsaaak wanneer \'n standaard Moodle pakket bo-oor \'n vorige weergawe van Moodle ge-\'unzip\' word. Alhoewel dit OK is vir kleiner opgraderings, word dit glad nie aanbeveel vir groter Moodle graderings nie.

Hierdie waarskuwing kan ook veroorsaak word deur \'n onvolledige uitteken of opdateringstaak vanaf die Git bron. In daardie gevalmag jy moontlik slegs hoef te wag vir die taak om te voltooi, of miskien die gepaste skoonmaak bevel te hardloop en die taak weer te probeer uitvoer.

Jy kan meer inligting in die opgraderingsdokumentasie by <a href="{$a}">{$a}</a> vind.';
$string['upgradestart'] = 'Gradeer Moodle databasis nou op';
$string['upgradesure'] = '<p>Jou Moodle lêers is verander en jy is op die punt om outomaties jou bediener na die volgende weergawe op te gradeer:</p>
<p><strong>{$a}</strong></p>
<p>Sodra jy hierdie gedoen het, kan jy nie teruggaan nie. Let op dat hierdie proses \'n geruime tyd kan neem.</p>
<p>Is jy seker dat jy hierdie bediener wil opgradeer na hierdie weergawe?</p>';
$string['upgradetimedout'] = 'Die opgradering het sy spertyd bereik. Begin asseblief die opgradering van voor af.';
$string['upgradingdata'] = 'Besig om data op te gradeer';
$string['upgradinglogs'] = 'Besig om logs op te gradeer';
$string['upgradingversion'] = 'Besig om na \'n nuwe weergawe op te gradeer';
$string['upwards'] = 'opwaarts';
$string['useblogassociations'] = 'Ontsper assosiasies';
$string['useexternalyui'] = 'Gebruik aanlyn YUI biblioteke';
$string['user'] = 'Gebruiker';
$string['userbulk'] = 'Massa gebruikeraksies';
$string['userbulkdownload'] = 'Voer gebruikers af as';
$string['userdefaultpreferences'] = 'Gebruiker verstek voorkeure';
$string['userfeedbackafterupgrade'] = 'Na elke hoof opgradering';
$string['userfeedbackencouragement'] = '<p> In Moodle 3.9 en vorentoe is \'n nuwe eienskap ingesluit wat gebruikers die opsie gee om terugvoering oor Moodle sagteware aan Moodle hoofkantoor te verskaf deur middel van \'n eksterne opname webwerf waarvan Moodle hoofkantoor die gasheer is. Geen informasie wat die gebruiker kan identifiseer word na die opname webwerf aangestuur nie.<p>
<p>Moodle hoofkantoor streef daarna om oop en deursigtig te wees oor hoe hulle data versamel. Ons wil dus seker maak dat jy bewus en in beheer van hierdie funksionaliteit is.<p>
<p>Terugvoer van die gebruiker sal Moodle hoofkantoor grootliks help om die Moodle sagteware te verbeter. Om hierdie eienskap te ontsper, gaan asseblief na  <a href="{$a}">Terugvoer instellings</a>.</p>';
$string['userfeedbacknextreminder'] = 'Volgende terugvoering herinnering';
$string['userfeedbacknextreminder_desc'] = 'Wanneer moet ons weer die gebruiker vra om vir ons terugvoering te gee?';
$string['userfeedbackperiodically'] = 'Van tyd tot tyd';
$string['userfeedbackremindafter'] = 'Wys herinnering na';
$string['userfeedbackremindafter_desc'] = 'Herinner gebruikers weer om terugvoering te gee na die gegewe aantal dae.';
$string['userfiltersdefault'] = 'Verstek gebruiker filters';
$string['userfiltersdefault_desc'] = 'Selekteer die filters wat op die \'Blaai deur lys van gebruikers\' asook die \'Massa gebruiker aksies\' bladsye vertoon moet word. Hou die Ctrl sleutel in om veelvuldige items te selekteer. Enige filters wat nie geselekteer is nie sal beskikbaar word deur die \'Wys meer\'-skakel te klik.';
$string['userimagesdisabled'] = 'Profilering van gebruikers se beelde is versper';
$string['userlist'] = 'Blaai deur lys van gebruikers';
$string['usermanagement'] = 'Gebruiker bestuur';
$string['userpolicies'] = 'Gebruiker beleide';
$string['userpreference'] = 'Gebruiker voorkeure';
$string['userquota'] = 'Spasie vir privaat lêers';
$string['userquota_desc'] = 'Die maksimum hoeveelheid data wat elke gebruiker in hul area vir privaat lêers kan stoor.';
$string['users'] = 'Gebruikers';
$string['usesitenameforsitepages'] = 'Gebruik webwerf naam vir webwerf bladsye';
$string['usetags'] = 'Ontsper etiket funksionaliteit';
$string['validateemptylineerror'] = 'Leë lyne is nie geldig nie';
$string['validateerror'] = 'Hierdie waarde is nie geldig nie';
$string['validateerrorlist'] = 'Hierdie inskrywings is ongeldig: {$a}';
$string['validateiperror'] = 'Hierdie IP-adresse is ongeldig: {$a}';
$string['verifychangedemail'] = 'Beperk domeine wanneer e-pos verander word';
$string['warningcurrentsetting'] = 'Ongeldige huidige waarde: {$a}';
$string['warningiconvbuggy'] = 'Jou weergawe van die iconv biblioteek ondersteun nie die //IGNORE wysiger nie. Jy moet die mbstring uitbreiding installeer wat in plaas daarvan gebruik kan word om stringe skoon te maak wat ongeldige UTF-8 karakters bevat.';
$string['webproxy'] = 'Web instaanbediener';
$string['webproxyinfo'] = 'Vul volgende opsies in indien jou Moodle bediener nie direkte toegang tot die internet het nie. Internet toegang is \'n vereiste om omgewingsdata, taalpakkette, RSS voere en tydsones ens. af te laai.<br/><em>PHP cURL uitbreiding word ten sterkste aanbeveel.</em>';
$string['xmlrpcwebserviceenabled'] = 'Daar is opgespoor dat die XML-RPC Web Service-protokol op u webwerf geaktiveer is. Hierdie funksie maak staat op die PHP XML-RPC-uitbreiding wat nie meer deur PHP onderhou word nie.';
$string['yuicomboloading'] = 'YUI kombinasie word gelaai';
$string['ziprequired'] = 'Die Zip PHP uitbreiding is nou \'n vereiste vir Moodle. Info-ZIP binêres of PclZIP biblioteek uitbreidings word nie meer gebruik nie.';
