<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_o365', language 'no', version '4.1'.
 *
 * @package     local_o365
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['acp_healthcheck'] = 'Helsesjekk';
$string['acp_maintenance'] = 'Vedlikeholdsverktøy';
$string['acp_maintenance_cleandeltatoken'] = 'Cleanup User Sync Delta Tokens';
$string['acp_maintenance_cleandeltatoken_desc'] = 'Hvis brukersynkronisering ikke fungerer fullt ut etter oppdatering av brukersynkroniseringsinnstillingene, kan det være forårsaket av et gammelt deltasynkroniseringstoken. Å rydde opp i tokenet vil fjerne tvungen en fullstendig re-synkronisering neste gang når brukersynkroniseringen kjøres.';
$string['acp_maintenance_debugdata_desc'] = 'Generer feilsøkingsdatapakke';
$string['acp_maintenance_desc'] = 'Disse verktøyene kan hjelpe deg med å løse noen vanlige problemer.';
$string['acp_maintenance_warning'] = 'Advarsel: Dette er avanserte verktøy. Vennligst bruk dem bare hvis du forstår hva du gjør.';
$string['acp_parentsite_desc'] = 'Nettsted for delte Moodle-kursdata.';
$string['acp_parentsite_name'] = 'Moodle';
$string['acp_teamconnections'] = 'Teamforbindelser';
$string['acp_teamconnections_actions'] = 'Handlinger';
$string['acp_teamconnections_cache_last_updated'] = 'Lagets cache ble sist oppdatert kl. {$a->lastupdated}. Klikk <a href="{$a->updateurl}">her</a> for å oppdatere cachen.';
$string['acp_teamconnections_cache_never_updated'] = 'Lagets cache ble aldri oppdatert. Klikk <a href="{$a->updateurl}">her</a> for å oppdatere.';
$string['acp_teamconnections_connected_team'] = 'Tilknyttet team';
$string['acp_teamconnections_connection_completed'] = 'Kurset har blitt koblet til teamet';
$string['acp_teamconnections_course_connected'] = 'Kurset har blitt koblet til teamet.';
$string['acp_teamconnections_current_connection'] = 'GJELDENDE TILKOBLING';
$string['acp_teamconnections_exception_course_not_exist'] = 'Kurset som skal kobles til eksisterer ikke.';
$string['acp_teamconnections_exception_invalid_team_id'] = 'Ugyldig Team ID';
$string['acp_teamconnections_exception_no_unified_token'] = 'Kunne ikke få enhetlig token for å foreta API-anrop.';
$string['acp_teamconnections_exception_not_configured'] = 'Microsoft 365 er ikke fullstendig konfigurert.';
$string['acp_teamconnections_exception_team_already_connected'] = 'Teamet er allerede koblet til et annet kurs';
$string['acp_teamconnections_exception_team_creation'] = 'Det oppstod en feil under forsøk på å opprette Team. Detaljer: {$a}';
$string['acp_teamconnections_exception_team_no_owner'] = 'Finner ikke passende teameier.';
$string['acp_teamconnections_form_connect_course'] = 'Administrer teamtilkobling for kurs {$a}';
$string['acp_teamconnections_form_team'] = 'Velg Teams';
$string['acp_teamconnections_group_only'] = '(kun gruppe)';
$string['acp_teamconnections_invalid_connection'] = 'Ugyldig tilkobling';
$string['acp_teamconnections_not_connected'] = 'Ikke tilkoblet';
$string['acp_teamconnections_sync_disabled'] = 'Kurssynkronisering må aktiveres før du administrerer Teams-tilkoblinger.';
$string['acp_teamconnections_table_cannot_create_team_from_group'] = 'Kan ikke opprette team fra gruppe - ingen eier';
$string['acp_teamconnections_table_connect'] = 'Koble til';
$string['acp_teamconnections_table_connect_to_different_team'] = 'Koble til et annet team';
$string['acp_teamconnections_table_update'] = 'Oppdatér';
$string['acp_teamconnections_team_already_connected'] = 'Kurset er allerede koblet til et team.';
$string['acp_teamconnections_team_created'] = 'Teamet ble opprettet for kurset.';
$string['acp_teamconnections_team_exists_but_not_connected'] = 'Kurset er konfigurert til kun å være koblet til en gruppe, men det eksisterer et team koblet til gruppen.';
$string['acp_teamconnections_teams_cache_updated'] = 'Teams cache ble oppdatert.';
$string['acp_tenants_actions'] = 'Handlinger';
$string['acp_tenants_add'] = 'Legg til ny tenant';
$string['acp_tenants_errornotsetup'] = 'Fullfør plugin-oppsettsprosessen før du legger til flere tenanter.';
$string['acp_tenants_hosttenant'] = 'Vertstenant: {$a}';
$string['acp_tenants_intro'] = '<b>Slik fungerer multitenancy:</b><br />Multitenancy lar flere Microsoft 365-tenanter få tilgang til Moodle-nettstedet ditt. <br /><br />
    Slik setter du opp:
    <ol>
        <li>Logg på Moodle som en nettstedsadministrator som ikke bruker OpenID Connect-autentiseringsmodulen.</li>
        <li>Sørg for at innstillingene for <b>Authorization Endpoint</b> og <b>Token Endpoint</b> for OpenID Connect-autentiseringsplugin-modulen bruker standard ikke-leietakerspesifikke innstillinger.</li>
        <li>Deaktiver OpenID Connect autentiseringsplugin i Moodle. (Bruk <a href="{$a}/admin/settings.php?section=manageauths">administrasjonssiden for autentiseringsprogramtillegg</a>.)</li>
        <li>Naviger til Azure AD, og finn applikasjonen du konfigurerte for Moodle.</li>
        <li>Aktiver multitenancy i Azure AD-applikasjonen og lagre endringer.</li>
        <li>Gi minst én av følgende Graph Deleged-tillatelser til appen: <b>Directory.Read.All</b>, <b>Domain.Read.All</b> eller <b>Domain.ReadWrite .Alle</b>. Administratorsamtykke for organisasjonen din er ikke nødvendig.</li>
        <li>Hvis du allerede er logget på med Microsoft-kontoen din fra den ekstra leietakeren, logger du deg helt ut og logger på igjen.</li>
        <li>For hver tenant du vil aktivere, klikk "Legg til ny tenant" og logg på med en administratorkonto fra tenanten du vil aktivere.</li>
        <li>Når du har lagt til alle tenanter du ønsker, aktiverer du OpenID Connect-autentiseringsplugin-modulen på nytt i Moodle.</li>
        <li>Du er ferdig! For å legge til flere tenanter i fremtiden, klikker du bare på "Legg til ny tenant"-knappen og logger på med en administratorkonto fra den tenanten.</li>
    </ol>
    <b>Viktig merknad:</b> Azure AD multitenancy lar alle Microsoft 365-tenanter få tilgang til applikasjonen når den er aktivert. Ved å legge til tenantene her kan vi begrense Moodle-tilgangen til tenanter du konfigurerer. <b>Hvis du fjerner alle tenanter fra denne listen før du deaktiverer multitenancy i Azure AD, eller aktiverer OpenID Connect-autentisering i Moodle med en tom liste, vil Moodle-nettstedet ditt være åpent for alle Microsoft 365-tenanter.</b>';
$string['acp_tenants_none'] = 'Du har ikke konfigurert noen tenanter. Hvis du har aktivert multitenancy i Azure AD, kan Moodle-nettstedet ditt være åpent for alle Microsoft 365-brukere.';
$string['acp_tenants_revokeaccess'] = 'Oppheve tilgangen';
$string['acp_tenants_tenant'] = 'Tenant';
$string['acp_tenants_title'] = 'Multitenancy';
$string['acp_tenants_title_desc'] = 'Denne siden hjelper deg med å sette opp multitenant-tilgang til Moodle fra Microsoft 365.';
$string['acp_tenantsadd_desc'] = 'For å gi tilgang til en ekstra tenant, klikk på knappen nedenfor og logg på Microsoft 365 med en administratorkonto til den nye tenanten. Du vil bli returnert til listen over flere tenanter der den nye tenanten vil bli oppført. Du vil da kunne bruke Moodle med den nye tenanten.';
$string['ucp_calsync_desc'] = 'Markerte kalender vil synkroniseres fra Moodle og inn i din Outlook-kalender.';
$string['ucp_calsync_title'] = 'Innstillinger for Outlook kalendersynkronisering';
$string['ucp_connection_desc'] = 'Her kan du sette opp hvordan du ønsker å koble til Office&nbsp;365. For å bruke Office 365 funksjonene må du være koblet til en Office 365 konto. Dette kan gjøres på en av de to måtene beskrevet nedenfor.';
$string['ucp_connection_linked_desc'] = 'Sammenkobling av din Moodle og Office 365 konto lar deg bruke Office 365 funksjonene uten å forandre på hvordan du logger inn i Moodle. <br/> Ved å klikke på lenken nedenfor vil du bli sendt til Office 365 for å utføre e engangsinnlogging, for så å bli returnert hit. Du vil siden kunne bruke alle Office 365 funksjonene uten å gjøre noe mer med Moodlekontoen din.';
$string['ucp_connectionstatus'] = 'Tilkoblingsstatus';
$string['ucp_features'] = 'Office&nbsp;365 funksjoner';
$string['ucp_features_intro'] = 'Nedenfor er en liste med funksjoner fra Office 365 du kan bruke i Moodle.';
$string['ucp_general_intro'] = 'Her kan du administrere tilkoblingen din mot Office&nbsp;365.';
$string['ucp_index_calendar_desc'] = 'Her kan du sette opp synkronisering mellom kalenderne i Moodle og Outlook. Du kan eksportere hendelser fra Moodle til Outlook, og vise hendelser fra Outlokk i Moodlekalenderen.';
$string['ucp_index_calendar_title'] = 'Innstillinger for Outlook kalendersynkronisering';
$string['ucp_index_connectionstatus_title'] = 'Tilkoblingsstatus';
$string['ucp_index_onenote_desc'] = 'OneNote integrasjonen lar deg bruke Office&nbsp;365 OneNote sammen med Moodle. Du kan levere inn oppgaver direkte fra OneNote og det er også enkelt å ta notater i tilknytning til kursene dine.';
$string['ucp_index_onenote_title'] = 'OneNote';
$string['ucp_syncdir_both'] = 'Oppdaterer både Outlook og Moodle';
$string['ucp_syncdir_in'] = 'Fra Outlook til Moodle';
$string['ucp_syncdir_out'] = 'Fra Moodle til Outlook';
$string['ucp_title'] = 'Kontrollpanel Office&nbsp;365 / Moodle';
