<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'completion', language 'no', version '4.1'.
 *
 * @package     completion
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['achievinggrade'] = 'Endelig karakter';
$string['achievingpassinggrade'] = 'Oppnå bestått karakter';
$string['activities'] = 'Aktiviteter';
$string['activitiescompleted'] = 'Aktivitet fullført';
$string['activitiescompletednote'] = 'Merk: Du må slå på aktivitetsfullføring for aktiviteten for at den skal vises i listen over.';
$string['activitieslabel'] = 'Aktiviteter / ressurser';
$string['activityaggregation'] = 'Betingelsen krever';
$string['activityaggregation_all'] = 'ALLE valgte aktiviteter må fullføres';
$string['activityaggregation_any'] = 'EN av aktivitetene må fullføres';
$string['activitycompletion'] = 'Aktivitet fullført';
$string['activitycompletionupdated'] = 'Endringer lagret';
$string['activitygradenotrequired'] = 'Vurdering ikke påkrevd';
$string['activitygradetopassnotset'] = 'Denne aktiviteten har ikke en gyldig karakter for å bestå. Det kan settes i karakterdelen av aktivitetsinnstillingene.';
$string['affectedactivities'] = 'Endringene vil påvirke følgende <b>{$a}</b> aktiviteter og ressurser';
$string['aggregationmethod'] = 'Kursfullføringskrav';
$string['all'] = 'Alle';
$string['any'] = 'En av';
$string['approval'] = 'Godkjennelse';
$string['areyousureoverridecompletion'] = 'Er du sikker på at du ønsker å overstyre denne brukerens nåværende fullførtstatusen for denne aktiviteten og endre den til "{$a}"?';
$string['badautocompletion'] = 'Når du velger automatisk fullføring, må du også velge minst ett fullføringskrav (under).';
$string['badcompletiongradeitemnumber'] = '"Krev karakter" kan ikke aktiveres for <b>{$a}</b> fordi vurdering av {$a} ikke er aktivert.';
$string['bulkactivitycompletion'] = 'Masseredigering av aktivitetsfullføring';
$string['bulkactivitydetail'] = 'Velg aktivitetene som du ønsker å masseredigere';
$string['bulkcompletiontracking'] = 'Fullførtsporing';
$string['bulkcompletiontracking_help'] = '<strong>Ingen:</strong> Ikke bruk aktivvitetsfullføring

<strong>Manuelt:</strong> Studenter kan manuelt merke aktiviteten som fullført

<strong>Med betingelse(r):</strong> Vis aktiviteten som fullført når betingelsen(e) er oppfylt';
$string['checkactivity'] = 'Avkrysningsboks for aktivitet/ressurs: {$a}';
$string['checkall'] = 'Merk eller fjern merking av alle aktiviteter og ressurser';
$string['checkallsection'] = 'Merk eller fjern merking av alle aktiviteter og ressurser i følgende seksjon: {$a}';
$string['completeactivity'] = 'Fullfør aktiviteten';
$string['completed'] = 'Fullført';
$string['completedunlocked'] = 'Fullføringsvalgene er ikke låst';
$string['completedunlockedtext'] = 'Når du lagrer dette skjemaet, vil fullføringsdata bli slettet og deretter beregnet på nytt der det er mulig. For å unngå dette kan du navigere bort uten å lagre.';
$string['completedwarning'] = 'Fullføringsvalgene er låst.';
$string['completedwarningtext'] = 'Denne aktiviteten er merket som utført for en eller flere elever. Hvis du låser opp innstillingene for å gjøre en endring og deretter lagrer skjemaet, vil fullføringsdata bli slettet og deretter beregnet på nytt der det er mulig. Manuell fullføring kan ikke beregnes på nytt, så i dette tilfellet må studenten merke det som ferdig igjen.';
$string['completion'] = 'Fullførtsporing';
$string['completion-alt-auto-enabled'] = 'Systemet merker dette elementet som fullført i henhold til betingelsene: {$a}';
$string['completion-alt-auto-fail'] = 'Gjennomført: {$a} (uten godkjent karakter)';
$string['completion-alt-auto-n'] = 'Ikke fullført: {$a}';
$string['completion-alt-auto-n-override'] = 'Ikke fullført: {$a->modname} (satt av {$a->overrideuser})';
$string['completion-alt-auto-pass'] = 'Fullført: {$a} (med godkjent karakter)';
$string['completion-alt-auto-y'] = 'Fullført: {$a}';
$string['completion-alt-auto-y-override'] = 'Fullført: {$a->modname} (satt av {$a->overrideuser})';
$string['completion-alt-manual-enabled'] = 'Studenter kan selv merke dette elementet som fullført: {$a}';
$string['completion-alt-manual-n'] = 'Ikke fullført: {$a} Velg for å merke som fullført';
$string['completion-alt-manual-n-override'] = 'Ikke fullført: {$a->modname} (set by {$a->overrideuser}). Velg for å markere som fullført.';
$string['completion-alt-manual-y'] = 'Fullført: {$a} Velg for å merke som ikke fullført.';
$string['completion-alt-manual-y-override'] = 'Fullført: {$a->modname} (set by {$a->overrideuser}). Velg for å markere som ikke fullført.';
$string['completion-fail'] = 'Gjennomført (uten godkjent karakter)';
$string['completion-n'] = 'Ikke fullført';
$string['completion-n-override'] = 'Ikke fullført (satt av {$a})';
$string['completion-pass'] = 'Fullført (med godkjent karakter)';
$string['completion-y'] = 'Fullført';
$string['completion-y-override'] = 'Fullført (satt av {$a})';
$string['completion_automatic'] = 'Merk aktiviteten som fullført når betingelsene er oppfylt';
$string['completion_help'] = 'Hvis aktivert, spores aktivitetsfullføring, enten manuelt eller automatisk, basert på visse forhold. Flere betingelser kan stilles om ønskelig. I så fall vil aktiviteten først anses som fullført når ALLE vilkår er oppfylt.';
$string['completion_link'] = 'activity/completion';
$string['completion_manual'] = 'Studenter kan manuelt merke aktiviteten som fullført';
$string['completion_none'] = 'Ikke bruk aktivitetsfullføring';
$string['completionactivitydefault'] = 'Aktivitetssporing aktivert';
$string['completiondefault'] = 'Standard fullførtsporing';
$string['completiondisabled'] = 'Deaktivert, vises ikke i aktivitetsinnstillingene';
$string['completionduration'] = 'Påmelding';
$string['completionenabled'] = 'Aktivert og styres via fullført- og aktivitetsinnstillingene';
$string['completionexpected'] = 'Forventet fullført innen';
$string['completionexpected_help'] = 'Denne innstillingen spesifiserer datoen når aktiviteten forventes å være fullført. Når datoen nærmer seg, er aktiviteten oppført i tidslinjeblokken på dashbordet.';
$string['completionexpecteddesc'] = 'Forventet fullføringsdato {$a}';
$string['completionexpectedfor'] = 'Forventet fullføringsdato for \'{$a->instancename}\'';
$string['completionicons'] = 'Merkebokser for fullført';
$string['completionicons_help'] = 'En avmerkingsboks ved aktivitetsnavnet kan brukes til å vise om aktiviteten er fullført.

Dersom en boks med en prikkete ramme vises, vil en hake fremkomme automatisk straks du har fullført aktiviteten i tråd med de betingelsene som er satt for denne aktiviteten. Det er læreren som styrer dette.

Dersom en boks med en hel ramme vises, kan du klikke på den når du mener at du har fullført aktiviteten. (Et nytt klikk fjerner avmerkingen dersom du angrer.)';
$string['completionmenuitem'] = 'Fullføring';
$string['completionnotenabled'] = 'Fullføring er ikke aktivert';
$string['completionnotenabledforcourse'] = 'Fullføring er ikke aktivert i dette kurset';
$string['completionnotenabledforsite'] = 'Fullføring er ikke aktivert på denne kursportalen';
$string['completionondate'] = 'Dato';
$string['completionondatevalue'] = 'Dato for når kurset skal registreres som fullført';
$string['completionpassgrade'] = 'Krev ståkarakter';
$string['completionpassgrade_desc'] = 'Studenten må få bestått karakter for å fullføre denne aktiviteten';
$string['completionpassgrade_help'] = 'Hvis den er aktivert, anses aktiviteten som fullført når en bruker får en bestått karakter.';
$string['completionsettingslocked'] = 'Innstillinger for fullføring er låst';
$string['completionupdated'] = 'Oppdatert fullføring for aktivitet <b>{$a}</b>';
$string['completionusegrade'] = 'Trenger karakter';
$string['completionusegrade_desc'] = 'Studenten må få en karakter for å fullføre denne aktiviteten';
$string['completionusegrade_help'] = 'Hvis aktivert, anses aktiviteten som fullført når en elev får en karakter. Hvis en bestått karakter for aktiviteten er satt, vises bestått- og ikke-bestått-ikonene i aktivitetsfullføringsrapporten.';
$string['completionview'] = 'Visning påkrevet';
$string['completionview_desc'] = 'Studenten må se denne aktiviteten for å fullføre den.';
$string['configcompletiondefault'] = 'Standardinnstilling for fullførtsporing når nye aktiviteter opprettes.';
$string['configenablecompletion'] = 'Hvis aktivert, kan det være angitt betingelser for kurs- og aktivitetsfullføring. Å angi betingelser for fullføring av aktivitet anbefales, slik at meningsfulle data vises for brukere i kursoversikten på Dashbord.';
$string['confirmselfcompletion'] = 'Bekreft egenregistrering av fullføring';
$string['courseaggregation'] = 'Betingelsen krever';
$string['courseaggregation_all'] = 'ALLE valgte kurs må fullføres';
$string['courseaggregation_any'] = 'ETT av valgte kurs må fullføres';
$string['coursealreadycompleted'] = 'Du har allerede fullført dette kurset';
$string['coursecomplete'] = 'Kurs gjennomført';
$string['coursecompleted'] = 'Fullførte kurs';
$string['coursecompletedmessage'] = '<p> Gratulerer !</p> <p> Du har fullført kurset <a href="{$a->courselink} ">{$a->coursename}</a>. </p>';
$string['coursecompletion'] = 'Angi kursfullføring';
$string['coursecompletioncondition'] = 'Vilkår: {$a}';
$string['coursecompletionnavigation'] = 'Kursgjennomføring tertiær navigasjon';
$string['coursegrade'] = 'Kurskarakter';
$string['coursesavailable'] = 'Kurs tilgjengelig';
$string['coursesavailableexplaination'] = '<i>Kriterier for registrering av fullført må angis for at kurset skal fremkomme i denne listen</i><p><strong>OBS: Hvis du er uheldig og klikker på et eller flere kurs som IKKE skal være noen forutsetning, kan du annulere ved å holde CTRL/CMD-tasten nede og klikke på valgt kurs i listen en gang til.</strong></p>';
$string['criteria'] = 'Kriterier';
$string['criteriagroup'] = 'Kriteriegruppe';
$string['criteriarequiredall'] = 'Alle kriteriene under er obligatoriske';
$string['criteriarequiredany'] = 'Velg obligatoriske kriterier';
$string['csvdownload'] = 'Last ned som regneark (utf-8.csv)';
$string['datepassed'] = 'Data godkjent';
$string['days'] = 'Dager';
$string['daysoftotal'] = '{$a->days} av {$a->total}';
$string['daysuntilcompletion'] = 'Dager til fullføring';
$string['defaultcompletion'] = 'Standard aktivitetsfullføring';
$string['defaultcompletionupdated'] = 'Endringer lagret';
$string['deletecompletiondata'] = 'Siste fullføringsdata';
$string['dependencies'] = 'Avhengigheter';
$string['dependenciescompleted'] = 'Fullføring av andre kurs';
$string['detail_desc:receivegrade'] = 'Motta karakter';
$string['detail_desc:receivepassgrade'] = 'Motta en ståkarakter';
$string['detail_desc:view'] = 'Vis';
$string['done'] = 'Utført';
$string['editcoursecompletionsettings'] = 'Endre innstillinger for kursfullføring';
$string['enablecompletion'] = 'Aktiver fremdriftssporing';
$string['enablecompletion_help'] = 'Hvis den er aktivert, kan du sette betingelser for aktivitetsgjennomføring eller kursgjennomføring.';
$string['enrolmentduration'] = 'Varighet for påmelding';
$string['enrolmentdurationlength'] = 'Bruker må være innlogget i';
$string['err_noactivities'] = 'Fullføringssporing er ikke aktivert for noen aktiviteter og kan derfor ikke vises. Du kan aktivere fullføringsinformasjon ved å redigere innstillingene for en aktivitet.';
$string['err_nocourses'] = 'Sporing av kursfullføring er ikke aktivert for noen andre kurs, og kan derfor ikke vises. Du kan aktivere kursfullføring ved å redigere kursinnstillingene.';
$string['err_nograde'] = 'Det er ikke satt noen minstekrav for fullføring av kurset. For å aktivere dette kriteriet må du angi et minstekrav (karakter) for dette kurset.';
$string['err_noroles'] = 'Det er ingen roller med rettigheten \'moodle/course:markcomplete\' i dette kurset.';
$string['err_nousers'] = 'Det er ingen studenter i dette kurset eller gruppen som det kan vises fremdriftsinformasjon for. (Som standard vises fremdriftsinformasjon bare for studenter. Hvis det ikke er lagt inn studenter vil du derfor få denne feilmeldingen. Administrator kan endre dette valget i det administrative oppsettet.)';
$string['err_settingslocked'] = 'En eller flere studenter har allerede fullført en av betingelsene, så innstillingene er låst. Dersom du låser opp aktivitetsinnstillingene vil eksisterende fullførtdata slettes og det kan skape forvirring.';
$string['err_system'] = 'Det oppstod en intern feil i fremdriftssystemet. (Systemadministrator kan slå på debugging for å få mer detaljert informasjon om feilen.)';
$string['eventcoursecompleted'] = 'Fullført kurs';
$string['eventcoursecompletionupdated'] = 'Fullførtsporing oppdatert';
$string['eventcoursemodulecompletionupdated'] = 'Aktivitetens fullførtsporing er oppdatert';
$string['eventdefaultcompletionupdated'] = 'Standardinnstillinger for aktivitetsfullføring oppdatert';
$string['excelcsvdownload'] = 'Last ned i Excel-kompatibelt format. (.csv)';
$string['failed'] = 'Mislykket';
$string['fraction'] = 'Fraksjon';
$string['graderequired'] = 'Karakter påkrevd';
$string['gradexrequired'] = '{$a} påkrevd';
$string['hiddenrules'] = 'Noen innstillinger som er spesifikke for <b>{$a}</b> har blitt skjult. For å se disse må du fjerne markeringen av andre aktiviteter.';
$string['inprogress'] = 'Pågår';
$string['manual'] = 'Manuelt';
$string['manualcompletionby'] = 'Manuell fullføring av andre';
$string['manualcompletionbynote'] = 'Merk: Rettigheten moodle/course:markcomplete må være tillatt for at rollen skal fremkomme i listen.';
$string['manualselfcompletion'] = 'Manuell egenregistrering av fullføring';
$string['manualselfcompletionnote'] = 'Merk: Blokken for egenfullføring må legges til i kurset hvis du aktiverer manuell egenfullføring.';
$string['markcomplete'] = 'Merk som fullført';
$string['markedcompleteby'] = 'Merket som fullført av {$a}';
$string['markingyourselfcomplete'] = 'Selvregistrering av fullført';
$string['modifybulkactions'] = 'Rediger handlingene du ønsker å masseredigere.';
$string['moredetails'] = 'Flere detaljer';
$string['nocriteriaset'] = 'Det er ikke satt noen fullførtkriterier for dette kurset';
$string['nogradeitem'] = 'Krev karakter kan ikke aktiveres for <b>{$a}</b> fordi aktiviteten ikke kan karaktersettes.';
$string['notcompleted'] = 'Ikke fullført';
$string['notenroled'] = 'Du er ikke påmeldt dette kurset';
$string['nottracked'] = 'For øyeblikket blir ikke din progresjon registrert av fullførtsporingen i dette kurset';
$string['notyetstarted'] = 'Ikke startet ennå';
$string['overallaggregation'] = 'Fullføringsbetingelser';
$string['overallaggregation_all'] = 'Kurset er fullført når ALLE vilkår er oppfylt';
$string['overallaggregation_any'] = 'Kurset er fullført når ETT av vilkårene er oppfylt';
$string['pending'] = 'Behandles';
$string['periodpostenrolment'] = 'Periode etter påmelding';
$string['privacy:metadata:completionstate'] = 'Om aktiviteten har blitt fullført';
$string['privacy:metadata:course'] = 'En kursidentifikator.';
$string['privacy:metadata:coursecompletedsummary'] = 'Inneholder informasjon om brukere som har fullført et kriterie i et kurs.';
$string['privacy:metadata:coursemoduleid'] = 'AktivitetsID\'en.';
$string['privacy:metadata:coursemodulesummary'] = 'Lagrer aktivitetsfullføringsdata for en bruker';
$string['privacy:metadata:coursesummary'] = 'Lagrer kursfullføringsdat for en bruker.';
$string['privacy:metadata:gradefinal'] = 'Endelig karakter mottatt for kursfullføring.';
$string['privacy:metadata:overrideby'] = 'BrukerID\'en til den som overskrev aktivitetsfullføringen.';
$string['privacy:metadata:reaggregate'] = 'Om kursfullføring ble omberegnet.';
$string['privacy:metadata:timecompleted'] = 'Når kurset ble fullført.';
$string['privacy:metadata:timecreated'] = 'Tidspunktet da aktivitetsfullføringen ble opprettet';
$string['privacy:metadata:timeenrolled'] = 'Når brukeren ble meldt inn i kurset';
$string['privacy:metadata:timemodified'] = 'Når aktivitetsfullføringen ble endret';
$string['privacy:metadata:timestarted'] = 'Når kurset startet.';
$string['privacy:metadata:unenroled'] = 'Om brukeren har blitt meldt ut av kurset.';
$string['privacy:metadata:userid'] = 'BrukerID\'en til brukeren med kurs- og aktivitetsfullføringsdata.';
$string['privacy:metadata:viewed'] = 'Om aktiviteten ble vist.';
$string['progress'] = 'Studentens fremdrift';
$string['progress-title'] = '{$a->user}, {$a->activity}: {$a->state} {$a->date}';
$string['progresstotal'] = 'Fremdrift: {$a->complete} / {$a->total}';
$string['recognitionofpriorlearning'] = 'Anerkjennelse av tidligere lært';
$string['remainingenroledfortime'] = 'Forbli innmeldt i en angitt periode';
$string['remainingenroleduntildate'] = 'Forbli innmeldt inntil en angitt dato';
$string['reportpage'] = 'Viser brukerne {$a->from} to {$a->to} of {$a->total}.';
$string['requiredcriteria'] = 'Påkrevde kriterier';
$string['resetactivities'] = 'Fjern fullførtstatus for alle markerte aktiviteter og ressurser';
$string['restoringcompletiondata'] = 'Skriver fullføringsdata';
$string['roleaggregation'] = 'Betingelsen krever';
$string['roleaggregation_all'] = 'Alle valgte roller som kan markere når betingelsen er oppfylt';
$string['roleaggregation_any'] = 'Noen valgte roller som kan markere når betingelsen er oppfylt';
$string['roleidnotfound'] = 'Fant ikke rolleID {$a}';
$string['saved'] = 'Lagret';
$string['seedetails'] = 'Se detaljer';
$string['select'] = 'Velg';
$string['self'] = 'Egen';
$string['selfcompletion'] = 'Egenregistrering av fullføring';
$string['showcompletionconditions'] = 'Vis fullføringsbetingelser';
$string['showcompletionconditions_help'] = 'Vis aktivitetsgjennomføringsbetingelser på kurssiden.';
$string['showinguser'] = 'Viser brukeren';
$string['timecompleted'] = 'Når fullført';
$string['todo'] = 'Gjenstår';
$string['unenrolingfromcourse'] = 'Melder ut fra kurset';
$string['unenrolment'] = 'Utmelding';
$string['unit'] = 'Enhet';
$string['unlockcompletion'] = 'Lås opp fullførtinnstillingene';
$string['unlockcompletiondelete'] = 'Lås opp fullførtinnstillingene og slett brukernes fullføringsdata';
$string['updateactivities'] = 'Oppdater fullførtstatus for markerte aktiviteter';
$string['usealternateselector'] = 'Bruk den alternative kursvelgeren';
$string['usernotenroled'] = 'Brukeren er ikke påmeldt i dette kurset';
$string['viewcoursereport'] = 'Vis kursrapport';
$string['viewingactivity'] = 'Åpne {$a}';
$string['withconditions'] = 'Med betingelser';
$string['writingcompletiondata'] = 'Skriver fullføringsdata';
$string['xdays'] = '{$a} dager';
$string['yourprogress'] = 'Din fremdrift';
