<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'bigbluebuttonbn', language 'no', version '4.1'.
 *
 * @package     bigbluebuttonbn
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['acceptdpa'] = 'Jeg forstår og godtar databehandleravtalen';
$string['activityoverview'] = 'Du har kommende BigBlueButton-sesjoner';
$string['bbbduetimeoverstartingtime'] = 'Sluttiden for denne aktiviteten må være senere enn starttiden';
$string['bbbdurationwarning'] = 'Maksimal varighet for denne sesjonen er %duration% minutes.';
$string['bbbrecordallfromstartwarning'] = 'Denne sesjonen tas opp fra start';
$string['bbbrecordwarning'] = 'Denne sesjonen kan tas opp';
$string['bigbluebuttonbn'] = 'BigBlueButton';
$string['bigbluebuttonbn:addinstance'] = 'Legg til et nytt BBB-møte';
$string['bigbluebuttonbn:addinstancewithmeeting'] = 'Opprett sesjoner med funksjoner for livemøter';
$string['bigbluebuttonbn:addinstancewithrecording'] = 'Lag sesjoner med opptaksmuligheter';
$string['bigbluebuttonbn:deleterecordings'] = 'Slett opptak';
$string['bigbluebuttonbn:importrecordings'] = 'Importér opptak';
$string['bigbluebuttonbn:join'] = 'Delta i et BBB-møte';
$string['bigbluebuttonbn:managerecordings'] = 'Administrer opptak';
$string['bigbluebuttonbn:protectrecordings'] = 'Bli med på et BBB-møte';
$string['bigbluebuttonbn:publishrecordings'] = 'Publiser opptak';
$string['bigbluebuttonbn:unprotectrecordings'] = 'Ubeskyttede opptak';
$string['bigbluebuttonbn:unpublishrecordings'] = 'Upubliserte opptak';
$string['bigbluebuttonbn:view'] = 'Vis et BBB-rom/aktivitet';
$string['bigbluebuttondisablednotification'] = 'BigBlueButton-aktivitetsmodulen er deaktivert og eventuelle eksisterende BigBlueButton-kursaktiviteter er for øyeblikket ikke tilgjengelige. Før du aktiverer dette programtillegget på nytt, må du sørge for at du har lest og godtatt <a href="{$a}" target="_blank">databehandlingsavtalen</a> med Blindside Networks Inc.';
$string['bigbluebuttondisablednotification_subject'] = 'BigBlueButton aktivitetsmodul deaktivert.';
$string['cachedef_currentfetch'] = 'Data for å liste opp opptak som er hentet nylig.';
$string['cachedef_recordings'] = 'Registrering av metadata';
$string['cachedef_serverinfo'] = 'Informasjon om ekstern server';
$string['cachedef_validatedurls'] = 'Buffer for validerte URL-sjekker';
$string['calendarstarts'] = '{$a} er planlagt for';
$string['cannotperformaction'] = 'Kan ikke utføre handlingen {$a} på dette opptaket';
$string['completionattendance'] = 'Studenten må delta på møtet i:';
$string['completionattendance_desc'] = 'Studenten må delta på møtet og forbli i økten i minst {$a} minutt(er)';
$string['completionattendance_event_desc'] = 'Studenten har deltatt på møtet eller vært i økten i minst {$a} minutt(er)';
$string['completionattendancegroup'] = 'Krev tilstedeværelse';
$string['completionattendancegroup_help'] = 'Det kreves deltakelse på møtet i (n) minutter for å fullføre';
$string['completionengagement_desc'] = 'Eleven skal delta i aktiviteter under møtet';
$string['completionengagementchats'] = 'Chatter';
$string['completionengagementchats_desc'] = 'Delta i {$a} chat(er).';
$string['completionengagementchats_event_desc'] = 'Har startet {$a} chat(er)-begivenhet(er)';
$string['completionengagementemojis'] = 'Emojis';
$string['completionengagementemojis_desc'] = 'Endre deres emoji {$a} gang(er).';
$string['completionengagementemojis_event_desc'] = 'Endret deres emoji {$a} gang(er).';
$string['completionengagementgroup'] = 'Krev engasjement';
$string['completionengagementgroup_help'] = 'Aktiv deltakelse under økten kreves for gjennomføring';
$string['completionengagementpollvotes'] = 'Avstemningsstemmer';
$string['completionengagementpollvotes_desc'] = 'Stem i meningsmålingene {$a} gang(er).';
$string['completionengagementpollvotes_event_desc'] = 'Har svart på {$a} meningsmåling(er)';
$string['completionengagementraisehand'] = 'Krev "rekk opp hånda"';
$string['completionengagementraisehand_desc'] = 'Løft opp hånden {$a} gang(er).';
$string['completionengagementraisehand_event_desc'] = 'Har rukket opp hånda {$a} ganger';
$string['completionengagementtalks'] = 'Snakke';
$string['completionengagementtalks_desc'] = 'Snakk {$a} gang(er)';
$string['completionengagementtalks_event_desc'] = 'Har snakket {$a} ganger';
$string['completionupdatestate'] = 'Fullført oppdateringsstatus';
$string['completionvalidatestate'] = 'Bekreft fullføring';
$string['completionvalidatestatetriggered'] = 'Valideringsfullføring har blitt utløst.';
$string['completionview'] = 'Krever visning';
$string['completionview_desc'] = 'Eleven må se rommet for å fullføre det.';
$string['completionview_event_desc'] = 'Har sett på rommet.';
$string['config_default_messages'] = 'Standard meldinger';
$string['config_default_messages_description'] = 'Angi meldingsstandarder for aktiviteter';
$string['config_disablecam_default'] = 'Deaktiver kamera aktivert som standard';
$string['config_disablecam_default_description'] = 'Hvis aktivert, vil webkameraene bli deaktivert.';
$string['config_disablecam_editable'] = 'Deaktiver kamera kan endres';
$string['config_disablecam_editable_description'] = 'Deaktiver kamera som standard kan redigeres når sesjonen legges til eller oppdateres.';
$string['config_disablemic_default'] = 'Deaktiver mikrofon aktivert som standard';
$string['config_disablemic_default_description'] = 'Hvis aktivert, vil mikrofonene bli deaktivert.';
$string['config_disablemic_editable'] = 'Deaktiver mikrofon kan redigeres';
$string['config_disablemic_editable_description'] = 'Deaktiver mikrofon som standard kan redigeres når sesjonen legges til eller oppdateres.';
$string['config_disablenote_default'] = 'Deaktiver delte notater aktivert som standard';
$string['config_disablenote_default_description'] = 'Hvis den er aktivert, vil de delte notatene bli deaktivert.';
$string['config_disablenote_editable'] = 'Deaktiver delte notater kan redigeres';
$string['config_disablenote_editable_description'] = 'Deaktiver delte notater som standard kan redigeres når sesjonen legges til eller oppdateres.';
$string['config_disableprivatechat_default'] = 'Deaktiver privat chat aktivert som standard';
$string['config_disableprivatechat_default_description'] = 'Hvis den er aktivert, vil den private chatten bli deaktivert.';
$string['config_disableprivatechat_editable'] = 'Deaktiver privat chat kan redigeres';
$string['config_disableprivatechat_editable_description'] = 'Deaktiver privat chat som standard kan redigeres når sesjonen legges til eller oppdateres.';
$string['config_disablepublicchat_default'] = 'Deaktiver offentlig chat aktivert som standard';
$string['config_disablepublicchat_default_description'] = 'Hvis den er aktivert, vil den offentlige chatten bli deaktivert.';
$string['config_disablepublicchat_editable'] = 'Deaktiver offentlig chat kan redigeres';
$string['config_disablepublicchat_editable_description'] = 'Deaktiver offentlig chat som standard kan redigeres når forekomsten legges til eller oppdateres.';
$string['config_dpa_note'] = 'Merk: For å oppfylle dine databeskyttelsesforpliktelser, før du bruker en tjenesteleverandør for denne plugin, må du sørge for at du har lest og godtatt tjenesteleverandørens databehandlingsavtale. For standard gratis BigBlueButton er dette <a href="{$a}" target="_blank">databehandlingsavtalen for Blindside Networks</a>. Rådfør deg med dine egne personverneksperter for råd.';
$string['config_experimental_features'] = 'Eksperimentelle funksjoner';
$string['config_experimental_features_description'] = 'Konfigurasjon for eksperimentelle funksjoner.';
$string['config_extended_capabilities'] = 'Utvidede rettigheter';
$string['config_extended_capabilities_description'] = 'Konfigurasjon for utvidede rettigheter når BigBlueButton serveren tilbyr dem.';
$string['config_general'] = 'Generell konfigurasjon';
$string['config_general_description'] = 'Disse innstillinge blir <b>alltid</b> brukt';
$string['config_guestaccess_enabled'] = 'Ekstern gjestetilgang';
$string['config_guestaccess_enabled_description'] = 'Tillat deltakere uten brukerkonto tilgang til rommet.';
$string['config_hideuserlist_default'] = 'Skjul brukerliste aktivert som standard';
$string['config_hideuserlist_default_description'] = 'Hvis aktivert, vil deltakerlisten for sesjonen skjules.';
$string['config_hideuserlist_editable'] = 'Skjul deltakerliste kan redigeres';
$string['config_hideuserlist_editable_description'] = 'Skjul deltakerliste kan som standard redigeres når sesjonen legges til eller oppdateres.';
$string['config_importrecordings'] = 'Importer opptak';
$string['config_importrecordings_description'] = 'Disse innstillingene er funksjonsspesifikke';
$string['config_importrecordings_enabled'] = 'Importer opptak er aktivert';
$string['config_importrecordings_enabled_description'] = 'Når denne og opptaksfunksjonen er aktivert er det mulig å importere opptak fra andre kurs inn i en aktivitet.';
$string['config_importrecordings_from_deleted_enabled'] = 'Importer opptak fra slettede aktiviteter er aktivert';
$string['config_importrecordings_from_deleted_enabled_description'] = 'Når denne og opptaksfunksjonen er aktivert er det mulig å importere opptak fra aktiviteter som ikke lengre er i kurset.';
$string['config_locksettings'] = 'Konfigurasjon for låseinnstillinger';
$string['config_locksettings_description'] = 'Disse innstillingene aktiverer eller deaktiverer alternativer i brukergrensesnittet for låseinnstillinger, og definerer også standardverdier for disse alternativene.';
$string['config_meetingevents_enabled'] = 'Registrer live-arrangementer';
$string['config_meetingevents_enabled_description'] = 'Hvis aktivert, vil live-økter bli behandlet etter at økten er over. Denne funksjonen er nødvendig for fullføring av aktivitet og vil bare fungere hvis BigBlueButton-serveren er i stand til å behandle post_events-skript.';
$string['config_muteonstart'] = 'Demp lyd fra starten';
$string['config_muteonstart_default'] = '"Demp lyd i starten" aktivert som standard';
$string['config_muteonstart_default_description'] = 'Hvis aktivert vil lyden være dempet ved start';
$string['config_muteonstart_description'] = 'Disse innstillingene aktiverer eller deaktiverer valg i brukergrensesnittet og definerer også standardverdier for disse valgene.';
$string['config_muteonstart_editable'] = '"Demp lyd i starten" kan redigeres';
$string['config_muteonstart_editable_description'] = '"Demp lyd i start" som standard kan redigeres når instansen leggestil eller oppdateres.';
$string['config_participant'] = 'Deltakere';
$string['config_participant_description'] = 'Disse innstillingene definerer standardrollen for deltakere.';
$string['config_participant_moderator_default'] = 'Moderator';
$string['config_participant_moderator_default_description'] = 'Denne regelen brukes som standard når et nytt rom legges til';
$string['config_poll_interval'] = 'Avstemningsintervall (i sekunder) for å oppdatere rommets status';
$string['config_poll_interval_description'] = 'Avstemningsintervallet må være minst 2 sekunder. En høyere verdi vil redusere serverbelastningen.';
$string['config_presentation_default'] = 'Standard forhåndsopplastet presentasjon';
$string['config_presentation_default_description'] = 'En fil kan leveres til bruk i alle rom.';
$string['config_preuploadpresentation'] = 'Forhåndsopplastet presentasjon';
$string['config_preuploadpresentation_description'] = 'Disse innstillingene aktiverer eller deaktiverer valg i brukergrensesnittet og definerer standardinnstillingene for disse valgene. Funksjonen fungerer bare dersom Moodleserveren er tilgjengelig for BigBlueButton.';
$string['config_preuploadpresentation_editable'] = 'Presentasjon som kan redigeres på forhånd';
$string['config_preuploadpresentation_editable_description'] = 'Presentasjonsfunksjonen for forhåndsopplasting kan redigeres i brukergrensesnittet når rommet eller konferansen legges til eller oppdateres.';
$string['config_recording'] = 'Opptak';
$string['config_recording_all_from_start_default'] = 'Ta opp alle fra start';
$string['config_recording_all_from_start_default_description'] = 'Bør innstillingen \'Start opptak fra begynnelsen\' være aktivert som standard når du legger til et nytt BigBlueButton-rom?';
$string['config_recording_all_from_start_editable'] = 'Ta opp alle fra start kan redigeres';
$string['config_recording_all_from_start_editable_description'] = 'Bør \'Start opptak fra begynnelsen\' være redigerbar i BigBlueButton-aktivitetsinnstillingene?';
$string['config_recording_default'] = 'Opptaksfunksjonen er aktivert som standard';
$string['config_recording_default_description'] = 'Bør innstillingen \'Møtet kan tas opp\' være aktivert som standard når du legger til et nytt BigBlueButton-rom?';
$string['config_recording_description'] = 'Disse innstillingene er funksjonsspesifikke';
$string['config_recording_editable'] = 'Opptaksfunksjonen kan endres';
$string['config_recording_editable_description'] = 'Bør \'Møtet kan tas opp være redigerbar i BigBlueButton-aktivitetsinnstillingene?';
$string['config_recording_hide_button_default'] = 'Skjul opptaksknappen';
$string['config_recording_hide_button_default_description'] = 'Ved avkrysning vil opptaksknappen være skjult';
$string['config_recording_hide_button_editable'] = 'Skjul opptaksknappen kan endres';
$string['config_recording_hide_button_editable_description'] = 'Bør \'Skjul opptaksknapp\' være redigerbar i BigBlueButton-aktivitetsinnstillingene?';
$string['config_recording_protect_editable'] = 'Status for beskyttede opptak kan redigeres';
$string['config_recording_protect_editable_description'] = 'Hvis det er merket av, inkluderer grensesnittet et alternativ for å beskytte/oppheve beskyttelse av opptak.';
$string['config_recording_refresh_period'] = 'Oppdateringsperiode for opptak (i sekunder)';
$string['config_recording_refresh_period_description'] = 'Hvor ofte bør BigBlueButton-serveren spørres for å oppdatere ekstern informasjon for et opptak?';
$string['config_recordingready_enabled'] = 'Send varsler når et opptak er klart til bruk';
$string['config_recordingready_enabled_description'] = 'Hvis aktivert, vil et varsel bli sendt når en opptakslenke er tilgjengelig. Denne funksjonen krever at skriptet post_publish_recording_ready_callback er aktivert på BigBlueButton-serveren.';
$string['config_recordings'] = 'Vis opptak';
$string['config_recordings_asc_sort'] = 'Sorter opptakene i stigende rekkefølge.';
$string['config_recordings_asc_sort_description'] = 'Opptakene er sortert etter dato, enten kronologisk eller omvendt kronologisk rekkefølge (siste opptak først).';
$string['config_recordings_deleted_default'] = 'Inkluder at opptak fra slettede aktiviteter er aktivert som standard';
$string['config_recordings_deleted_default_description'] = 'Hvis aktivert vil opptakstabllen inkludere opptak fra slettede aktiviteter dersom det eksisterer noen slike.';
$string['config_recordings_deleted_editable'] = '"Inkluder opptak fra slettede aktiviteter" kan redigeres';
$string['config_recordings_deleted_editable_description'] = 'Inkluder at opptak fra slettede aktiviteter som standard kan redigeres når instansen legges til ellr oppdateres.';
$string['config_recordings_description'] = 'Disse innstillingene er funksjonsspesifikke';
$string['config_recordings_general'] = 'Vis opptaksinnstillinger';
$string['config_recordings_general_description'] = 'Disse innstillingene brukes kun ved visning av opptak';
$string['config_recordings_imported_default'] = 'Vis kun importerte lenker som standard';
$string['config_recordings_imported_default_description'] = 'Hvis aktivert vil opptakstabellen kun inkludere importerte lenker til opptakene.';
$string['config_recordings_imported_editable'] = 'Funksjonen "Vis kun importe lenker" kan redigeres';
$string['config_recordings_imported_editable_description'] = 'Funksjonen "Vis kun importe lenker" som standard kan redigeres når instansen legges til eller oppdateres.';
$string['config_recordings_preview_default'] = 'Forhåndsvisning er aktivert som standard';
$string['config_recordings_preview_default_description'] = 'Hvis aktivert vil tabellen inkludere en forhåndsvisning av presentasjonen.';
$string['config_recordings_preview_editable'] = 'Forhåndsvisningsfunksjonen kan redigeres';
$string['config_recordings_preview_editable_description'] = 'Forhåndsvisningsfunksjonen kan redigeres når instansen legges til eller oppdateres.';
$string['config_scheduled'] = 'Planlagte sesjoner';
$string['config_scheduled_description'] = 'Disse innstillingene definerer noe av standardoppførselen for planlagte sesjoner.';
$string['config_scheduled_pre_opening'] = 'Tilgjengelighet før åpningstid (minutter)';
$string['config_scheduled_pre_opening_description'] = 'Antall minutter før starttiden som sesjonen skal være tilgjengelig.';
$string['config_server_url'] = 'BigBlueButton serverURL';
$string['config_server_url_description'] = 'Standardlegitimasjonen er for en <a href="https://bigbluebutton.org/free-bigbluebutton-service-for-moodle/" target="_blank">gratis BigBlueButton-tjeneste for Moodle (åpnes i nytt vindu)</a > levert av Blindside Networks med restriksjoner som følger:
<ol>
<li>Maksimal lengde for hver økt er 60 minutter</li>
<li>Maksimalt antall samtidige brukere per økt er 25</li>
<li>Opptak utløper etter sju (7) dager og kan ikke lastes ned</li>
<li>Studentwebkameraer er bare synlige for moderatoren.</li>
</ol>';
$string['config_shared_secret'] = 'BigBlueButton delt hemmelig streng';
$string['config_shared_secret_description'] = 'Sikkerhetshemmeligheten til BigBlueButton-serveren. Standardhemmeligheten er for en gratis BigBlueButton-tjeneste levert av Blindside Networks.';
$string['config_uidelegation_enabled'] = 'UI-delegering er aktivert';
$string['config_uidelegation_enabled_description'] = 'Disse innstillingene aktiverer eller deaktiverer UI delegeringen til BigBlueButton-serveren.';
$string['config_userlimit'] = 'Brukerbegrensning';
$string['config_userlimit_default'] = 'Brukerbegrensning aktivert som standard';
$string['config_userlimit_default_description'] = 'Antallet bruker tillatt som standard i en sesjon når et nytt rom eller konferanse legges til. Dersom den settes til 0 vil antallet være ubegrenset.';
$string['config_userlimit_description'] = 'Disse innstillingene aktiverer eller deaktiverer valg i brukergensesnitt og definerer også standardverdier for disse valgene.';
$string['config_userlimit_editable'] = 'Brukbegrensningsfunksjonen kan redigeres';
$string['config_userlimit_editable_description'] = 'Standardverdien for brukerbegrensning kan redigeres når rommet eller konferansen legges til eller oppdateres.';
$string['config_voicebridge'] = 'Voice bridge';
$string['config_voicebridge_description'] = 'Disse innstillingene aktiverer eller deaktiverer valg i brukergensesnitt og definerer også standardverdier for disse valgene.';
$string['config_voicebridge_editable'] = 'Konferansen "voice bridge" kan redigeres';
$string['config_voicebridge_editable_description'] = 'Konferanse "Voice bridge" kan tildeles permanent til et rom eller konferanse. Når tildelt kan ikke nummeret brukes av et annet rom eller konferanse.';
$string['config_waitformoderator'] = 'Vent på moderator';
$string['config_waitformoderator_cache_ttl'] = 'Ventr på moderator mellomlagring TTL (sekunder)';
$string['config_waitformoderator_cache_ttl_description'] = 'For å støtte store antall brukere benytter denne modulen seg av mellomlagring. Denne variabelen definerer hvor lenge mellomlageret beholdes for den neste forespørselen sendes til BigBlueButton-serveren.';
$string['config_waitformoderator_default'] = 'Vent på moderator er aktivert som standard';
$string['config_waitformoderator_default_description'] = 'Bør innstillingen \'Vent på moderator\' være aktivert som standard når du legger til et nytt BigBlueButton-rom?';
$string['config_waitformoderator_description'] = 'Disse innstillingene er funksjonsspesifikke';
$string['config_waitformoderator_editable'] = 'Vent på moderator kan endres';
$string['config_waitformoderator_editable_description'] = 'Skal "Vent på moderator" kunne endres i BBB-innstillingene?';
$string['config_waitformoderator_ping_interval'] = 'Vent på moderator ping (sekunder)';
$string['config_waitformoderator_ping_interval_description'] = 'Hvor ofte bør serveren pinges for å sjekke om moderatoren har kommet inn i rommet?';
$string['config_warning_bigbluebuttonbn_cfg_deprecated'] = 'BigBlueButton bruker config.php med en global variabel som har blitt avviklet. Vennligst konverter filen siden den ikke vil bli støttet i fremtidige versjoner';
$string['config_warning_curl_not_installed'] = 'Denne funksjonen krever at CURL-utvidelsen for php er installert og aktivert. Innstillingen vil bare være tilgjengelig om denne betingelsen er oppfylt.';
$string['config_welcome_default'] = 'Standard velkomstmelding';
$string['config_welcome_default_description'] = 'Velkomstmeldingen vises når deltakerne kommer inn i rommet. Hvis feltet er tomt, vises en melding satt på BigBlueButton-serveren.';
$string['config_welcome_editable'] = 'Standard velkomst melding kan redigeres av lærere';
$string['config_welcome_editable_description'] = 'Velkomstmelding kan redigeres når eksempelet legges til eller oppdateres';
$string['dpainfonotsigned'] = 'Før du aktiverer denne modulen må du bekrefte at du har lest og akseptert <a href="{$a}">Blindside Networks databehandlingsavtale</a>.';
$string['enablingbigbluebutton'] = 'Aktiverer BigBlueButton';
$string['enablingbigbluebuttondpainfo'] = 'For å oppfylle dine databeskyttelsesforpliktelser, før du aktiverer dette programtillegget, må du kanskje sørge for at du har lest og godtatt <a href="{$a}" target="_blank">databehandlingsavtalen for Blindside Networks</a> a>. Rådfør deg med dine egne personverneksperter for råd.';
$string['end_session_confirm'] = 'Er du sikker på at du vil avslutte sesjonen?';
$string['end_session_confirm_title'] = 'Virkelig avslutte sesjonen?';
$string['end_session_notification'] = 'Sesjonen er nå avsluttet.';
$string['ends_at'] = 'Slutter';
$string['event_activity_created'] = 'Aktivitet opprettet';
$string['event_activity_deleted'] = 'Aktivitet slettet';
$string['event_activity_updated'] = 'Aktivitet oppdatert';
$string['event_live_session'] = 'Live-sesjon';
$string['event_meeting_created'] = 'Møte opprettet';
$string['event_meeting_ended'] = 'Møtet ble avsluttet';
$string['event_meeting_joined'] = 'Ble med i møte';
$string['event_meeting_left'] = 'Forlot møte';
$string['event_recording_deleted'] = 'Opptak slettet';
$string['event_recording_edited'] = 'Opptak redigert';
$string['event_recording_imported'] = 'Opptak importert';
$string['event_recording_protected'] = 'Opptak beskyttet';
$string['event_recording_published'] = 'Opptak publisert';
$string['event_recording_unprotected'] = 'pptak ubeskyttet';
$string['event_recording_unpublished'] = 'Opptak upublisert';
$string['event_recording_viewed'] = 'Opptak vist';
$string['event_unknown'] = 'Ukjent hendelse';
$string['general_error_cannot_create_meeting'] = 'Kan ikke opprette sesjon.';
$string['general_error_cannot_get_recordings'] = 'Kan ikke hente opptak.';
$string['general_error_no_answer'] = 'Tomt svar. Vennligst sjekk URL-en til BigBlueButton-serveren OG sjekk om BigBlueButton-serveren kjører.';
$string['general_error_not_allowed_to_create_instances'] = 'Bruker har ikke tillatelsen til å opprette noen instanser.';
$string['general_error_not_found'] = 'Kan ikke finne BigBlueButton-aktiviteten med ID {$a}.';
$string['general_error_unable_connect'] = 'Kan ikke koble til. Vennligst sjekk URL-en til BigBlueButton-serveren OG sjekk om BigBlueButton-serveren kjører.
Detaljer: {$a}';
$string['guest_invitation_full_message'] = 'hei!
<p>Du er invitert til en BigBlueButton-økt <strong>{$a->name}</strong> i kurset {$a->course_fullname}.</p>
<p>Link: {$a->guestjoinurl}<br/>
<p>Passord: {$a->guestpassword}</p>
<p>Hvis du trenger hjelp, vennligst kontakt {$a->sender}.</p>';
$string['guest_invitation_small_message'] = 'hei!

Du er invitert til en BigBlueButton-økt {$a->name} i kurset {$a->course_fullname}.

Link: {$a->guestjoinurl}
Passord: {$a->guestpassword}

Hvis du trenger hjelp, vennligst kontakt {$a->sender}.';
$string['guest_invitation_subject'] = 'Invitasjon {$a->name} økt i {$a->course_fullname}';
$string['guestaccess_activitynotfound'] = 'Aktivitet ikke funnet.';
$string['guestaccess_add'] = 'Legg til gjester';
$string['guestaccess_add_no_id'] = 'Mangler BigBlueButton instansID';
$string['guestaccess_copy_link'] = 'Kopier lenke';
$string['guestaccess_copy_password'] = 'Kopier passord';
$string['guestaccess_emails'] = 'Epostadresser for gjester';
$string['guestaccess_emails_help'] = 'En kommaseparert liste med epostadresser.';
$string['guestaccess_emails_invalidemail'] = 'Ugyldig epost: {$a}';
$string['guestaccess_feature_disabled'] = 'Gjestetilgang deaktivert.';
$string['guestaccess_invite_failure'] = 'Feil {$a->errors} ved invitasjon til {$a->emails}.';
$string['guestaccess_invite_success'] = 'En invitasjon vil bli sendt til {$a->emails}.';
$string['guestaccess_join_meeting'] = 'Bli med i møte';
$string['guestaccess_meeting_invalid_password'] = 'Feil passord.';
$string['guestaccess_meeting_link'] = 'Møtelenke';
$string['guestaccess_meeting_not_started'] = 'Møtet har ikke startet. Vennligst kom tilbake senere.';
$string['guestaccess_meeting_password'] = 'Møtepassord';
$string['guestaccess_password'] = 'Passord';
$string['guestaccess_title'] = 'Legg til gjester i møtet';
$string['guestaccess_username'] = 'Gjest brukernavn';
$string['index_confirm_end'] = 'Ønsker du å avslutte sesjonen?';
$string['index_disabled'] = 'deaktivert';
$string['index_enabled'] = 'aktivert';
$string['index_ending'] = 'Avslutter sesjonen... vennligst vent';
$string['index_error_bbtn'] = 'BigBlueButton ID {$a} er feil';
$string['index_error_checksum'] = 'En sjekksumfeil oppstod. Forsikre deg om at du har den korrekte hemmelige strengen.';
$string['index_error_forciblyended'] = 'Det er ikke mulig å bli med i denne sesjonen fordi det har blitt avsluttet manuelt.';
$string['index_error_noinstances'] = 'Det er ingen instanser av BBB';
$string['index_error_unable_display'] = 'Kan ikke vises møtene. Vennligst sjekk url\'en til BigBlueButton-serveren og sjekk om serveren kjører.';
$string['index_heading'] = 'BigBlueButton rom';
$string['index_heading_actions'] = 'Handlinger';
$string['index_heading_group'] = 'Gruppe';
$string['index_heading_moderator'] = 'Moderatorer';
$string['index_heading_name'] = 'Rom';
$string['index_heading_recording'] = 'Opptak';
$string['index_heading_users'] = 'Brukere';
$string['index_heading_viewer'] = 'Seere';
$string['indicator:cognitivedepth'] = 'BigBlueButton kognitiv';
$string['indicator:cognitivedepth_help'] = 'Denne indikatoren er basert på den kognitive forståelsen studenten har vist i en BigBlueButtonBN-aktivitet.';
$string['indicator:socialbreadth'] = 'BigBlueButton sosial';
$string['indicator:socialbreadth_help'] = 'Denne indikatoren er basert på den sosiale forståelsen studenten har vist i en BigBlueButton-aktivitet';
$string['instance_type_default'] = 'BBB-rom med opptak';
$string['instance_type_recording_only'] = 'Kun opptak';
$string['instance_type_room_only'] = 'Kun BBB-rom';
$string['instanceprofilewithoutrecordings'] = 'Denne forekomstprofilen kan ikke vise opptak';
$string['messageprovider:instance_updated'] = 'BigBlueButton-sesjonen oppdatert';
$string['messageprovider:recording_ready'] = 'BigBlueButton-opptak klar til visning';
$string['minute'] = 'minutt';
$string['minutes'] = 'minutter';
$string['mod_form_block_general'] = 'Generelle innstillinger';
$string['mod_form_block_guestaccess'] = 'Gjestetilgang';
$string['mod_form_block_participants'] = 'Rolle tildelt under live-sesjon';
$string['mod_form_block_presentation'] = 'Presentasjonsinnhold';
$string['mod_form_block_presentation_default'] = 'Standard presentasjonsinnhold';
$string['mod_form_block_record'] = 'Opptaksinnstillinger';
$string['mod_form_block_recordings'] = 'Opptaksvisning';
$string['mod_form_block_room'] = 'BBB-rom innstillinger';
$string['mod_form_block_schedule'] = 'Sesjonsplan';
$string['mod_form_field_closingtime'] = 'Frist for å bli med';
$string['mod_form_field_conference_name'] = 'Sesjonsnavn';
$string['mod_form_field_disablecam'] = 'Deaktiver webkameraer';
$string['mod_form_field_disablemic'] = 'Deaktiver mikrofoner';
$string['mod_form_field_disablenote'] = 'Deaktiver delte notater';
$string['mod_form_field_disableprivatechat'] = 'Deaktiver privat chat';
$string['mod_form_field_disablepublicchat'] = 'Deaktiver felles chat';
$string['mod_form_field_duration'] = 'Varighet';
$string['mod_form_field_duration_help'] = 'Ved å sette en varighet for møtet vil det etablere en makstid som møtet vil være aktivt før opptaket avsluttes.';
$string['mod_form_field_guestallowed'] = 'Tillat gjestetilgang';
$string['mod_form_field_hideuserlist'] = 'Skjul deltakerliste';
$string['mod_form_field_instanceprofiles'] = 'Instanstype';
$string['mod_form_field_instanceprofiles_help'] = 'Hvis en økt skal tas opp, velg \'Rom med opptak\', ellers \'Kun rom\'. Etter at en sesjon er tatt opp, hvis det ikke skal være flere sesjoner, velg \'Kun opptak\'.';
$string['mod_form_field_intro'] = 'Beskrivelse';
$string['mod_form_field_intro_help'] = 'En kort beskrivelse for BBB-rommet';
$string['mod_form_field_mustapproveuser'] = 'Gjester må godkjennes av en moderator';
$string['mod_form_field_muteonstart'] = 'Demp lyd ved start';
$string['mod_form_field_name'] = 'Navn på BBB-rom';
$string['mod_form_field_nosettings'] = 'Ingen innstillinger kan redigeres';
$string['mod_form_field_openingtime'] = 'Åpen';
$string['mod_form_field_participant_add'] = 'Legg til mottaker';
$string['mod_form_field_participant_bbb_role_moderator'] = 'Moderator';
$string['mod_form_field_participant_bbb_role_viewer'] = 'Seer';
$string['mod_form_field_participant_list'] = 'Mottaker';
$string['mod_form_field_participant_list_action_add'] = 'Legg til';
$string['mod_form_field_participant_list_action_remove'] = 'Fjern';
$string['mod_form_field_participant_list_text_as'] = 'blir med på økt som';
$string['mod_form_field_participant_list_type_all'] = 'Alle innmeldte brukere';
$string['mod_form_field_participant_list_type_owner'] = 'Eier';
$string['mod_form_field_participant_list_type_role'] = 'Rolle';
$string['mod_form_field_participant_list_type_user'] = 'Bruker';
$string['mod_form_field_record'] = 'Sesjon kan tas opp';
$string['mod_form_field_recordallfromstart'] = 'Ta opp fra start';
$string['mod_form_field_recordhidebutton'] = 'Skjul opptaksknappen';
$string['mod_form_field_recordings_deleted'] = 'Inkluder opptak fra slettede aktiviteter';
$string['mod_form_field_recordings_html'] = 'Vis tabell i ren html';
$string['mod_form_field_recordings_imported'] = 'Vis kun importerte lenker';
$string['mod_form_field_recordings_preview'] = 'Vis opptaksforhåndsvisning';
$string['mod_form_field_room_name'] = 'Romnavn';
$string['mod_form_field_userlimit'] = 'Brukergrense';
$string['mod_form_field_userlimit_help'] = 'Maks antall brukere i en sesjon. Om grensen settes til 0 vil antall brukere være ubegrenset.';
$string['mod_form_field_voicebridge'] = 'Voice bridge [####]';
$string['mod_form_field_voicebridge_format_error'] = 'Feil format. Du må legge inn et tall mellom 1 og 9999.';
$string['mod_form_field_voicebridge_help'] = 'Et tall mellom 1 og 9999 som deltakerne angir for å bli med i taleøkten når de bruker oppringing. Hvis verdien er 0, vil det statiske stemmebronummeret bli ignorert og et tilfeldig tall vil bli generert av BigBlueButton. Et tall 7 vil prefikse de fire sifrene som er skrevet.';
$string['mod_form_field_voicebridge_notunique_error'] = 'Ikke en unik verdi. Dette nummeret brukes av et annet BBB-rom.';
$string['mod_form_field_wait'] = 'Vent på moderator';
$string['mod_form_field_wait_help'] = 'Må deltakere vente til en moderator blir med i sesjonen før de kan bli med?';
$string['mod_form_field_welcome'] = 'Velkomstmelding';
$string['mod_form_field_welcome_default'] = 'Velkommen til %%CONFNAME%%.';
$string['mod_form_field_welcome_help'] = 'Velkomstmeldingen vises når deltakerne kommer inn i rommet. Hvis feltet er tomt, vises en standardmelding som er angitt i portaladministrasjonen.';
$string['mod_form_locksettings'] = 'Lås innstillinger';
$string['modulename'] = 'BigBlueButton';
$string['modulename_help'] = 'BigBlueButton er et åpen kildekode-nettkonferansesystem designet for nettbasert læring, som støtter sanntidsdeling av lyd, video, chat, lysbilder, skjermdeling, en flerbruker whiteboard, grupperom, polling og emojier.

Ved å bruke BigBlueButton kan du opprette et rom for økter som live online klasser, virtuelle kontortider eller gruppesamarbeid med eksterne studenter. Økten kan tas opp for senere avspilling.';
$string['modulename_link'] = 'BigBlueButton/view';
$string['modulenameplural'] = 'BigBlueButton';
$string['new_bigblubuttonbn_activities'] = 'BigBlueButton aktivitet';
$string['nosuchinstance'] = 'Ingen slik forekomst {$a->entity} med id: {$a->id}';
$string['notification_instance_created_intro'] = '<a href="{$a->link}">{$a->name}</a> BigBlueButton-aktiviteten er opprettet.';
$string['notification_instance_created_small'] = 'Et nytt BigBlueButton-rom kalt {$a->name} ble opprettet';
$string['notification_instance_created_subject'] = 'En ny BigBlueButton-rom er opprettet';
$string['notification_instance_description'] = 'Beskrivelse';
$string['notification_instance_end_date'] = 'Sluttdato';
$string['notification_instance_name'] = 'Tittel';
$string['notification_instance_start_date'] = 'Startdato';
$string['notification_instance_updated_intro'] = '<a href="{$a->link}">{$a->name}</a> BigBlueButton-rom har blitt oppdatert.';
$string['notification_instance_updated_small'] = '{$a->name} BigBlueButton-rommet ble oppdatert';
$string['notification_instance_updated_subject'] = 'Din BigBlueButton-rom har blitt oppdatert';
$string['notification_recording_ready_html'] = 'Et opptak er nå tilgjengelig for sesjonen i <b><a href="{$a->link}">{$a->name}</a></b>.';
$string['notification_recording_ready_plain'] = 'Et opptak er nå tilgjengelig for sesjonen {$a->name}. Se {$a->link} for å se opptak av sesjonen.';
$string['notification_recording_ready_small'] = 'Et nytt opptak er tilgjengelig for {$a->name} BigBlueButton-rommet';
$string['notification_recording_ready_subject'] = 'Opptak klar til visning';
$string['pluginadministration'] = 'BigBlueButton administrasjon';
$string['pluginname'] = 'BigBlueButton';
$string['privacy:metadata:bigbluebutton'] = 'For å opprette og bli med i BigBlueButton-økter, må brukerdata utveksles med serveren.';
$string['privacy:metadata:bigbluebutton:fullname'] = 'Fullt navn på brukeren som har tilgang til BigBlueButton-serveren.';
$string['privacy:metadata:bigbluebutton:userid'] = 'Bruker-ID-en til brukeren som har tilgang til BigBlueButton-serveren.';
$string['privacy:metadata:bigbluebuttonbn'] = 'BigBlueButton-sesjonskonfigurasjon';
$string['privacy:metadata:bigbluebuttonbn:participants'] = 'En liste over regler som definerer rollen brukere skal ha i BigBlueButton-sesjonen. En bruker-ID kan lagres ettersom tillatelser kan gis per rolle eller per bruker.';
$string['privacy:metadata:bigbluebuttonbn_logs'] = 'Lagrer hendelser som utløses ved bruk av modulen.';
$string['privacy:metadata:bigbluebuttonbn_logs:log'] = 'Typen hendelse utløst av brukeren.';
$string['privacy:metadata:bigbluebuttonbn_logs:meetingid'] = 'En sesjons-ID som brukeren hadde tilgang til.';
$string['privacy:metadata:bigbluebuttonbn_logs:meta'] = 'Ytterligere informasjon knyttet til sesjonen eller opptaket.';
$string['privacy:metadata:bigbluebuttonbn_logs:timecreated'] = 'Tidspunktet for da loggen ble opprettet.';
$string['privacy:metadata:bigbluebuttonbn_logs:userid'] = 'Bruker-ID-en til brukeren som utløste hendelsen.';
$string['privacy:metadata:bigbluebuttonbn_recordings'] = 'Lagrer metadata om opptak.';
$string['privacy:metadata:bigbluebuttonbn_recordings:userid'] = 'Bruker-ID-en til brukeren som sist endret et opptak.';
$string['recordingnotfound'] = 'Fant ikke opptaket';
$string['recordings_from_deleted_activities'] = 'Opptak fra slettede aktiviteter';
$string['recordingurlnotfound'] = 'Opptakets URL er ugyldig.';
$string['removedevents'] = 'Slettede hendelser';
$string['removedlogs'] = 'Slettet logger';
$string['removedrecordings'] = 'Slettede opptak';
$string['removedtags'] = 'Slettede tagger';
$string['report_join_info'] = '{$a} møte(r)';
$string['report_play_recording_info'] = '{$a} opptak(er) avspilt';
$string['report_room_view'] = 'vist';
$string['resetevents'] = 'Slettede hendelser';
$string['resetlogs'] = 'Slett logger';
$string['resetlogs_help'] = 'Sletting av loggene vil gjøre at opptaksreferansene blir slettet.';
$string['resetrecordings'] = 'Slett opptak';
$string['resetrecordings_help'] = 'Sletting av opptakene vil gjøre dem utilgjengelige fra hvor som helst. Denne handlingen kan ikke angres!';
$string['resettags'] = 'Slett tagger';
$string['search:activity'] = 'BigBlueButton - aktivitetsinformasjon';
$string['search:tags'] = 'BigBlueButton - taggeinformasjon';
$string['sendnotification'] = 'Send melding';
$string['settings'] = 'BigBlueButton innstillinger';
$string['started_at'] = 'Startet';
$string['starts_at'] = 'Starter';
$string['taskname:check_dismissed_recordings'] = 'Se etter opptak som ikke er funnet ennå';
$string['taskname:check_pending_recordings'] = 'Hent ventende opptak';
$string['userlimitreached'] = 'Antall deltakere som er tillatt i en sesjon er nådd.';
$string['view_conference_action_end'] = 'Avslutt sesjon';
$string['view_conference_action_join'] = 'Bli med i sesjon';
$string['view_error_action_not_completed'] = 'Handlingen kunne ikke fullføres';
$string['view_error_bigbluebutton'] = 'BigBlueButton svarte med feil. {$a}';
$string['view_error_create'] = 'BigBlueButton-serveren svarte med en feilmelding. Rommet kunne ikke opprettes.';
$string['view_error_current_state_not_found'] = 'Nåværende status ikke funnet. Opptaket kan være slettet eller så er ikke BigBlueButton-serveren kompatibel med den utførte handlingen.';
$string['view_error_import_no_courses'] = 'Det er ingen kurs å slå opp for opptak.';
$string['view_error_import_no_recordings'] = 'Ingen opptak i dette kurset kan importeres';
$string['view_error_invalid_session'] = 'Sesjonen er utløpt. Vennligst gå tilbake til aktivitetens hovedside.';
$string['view_error_max_concurrent'] = 'Maks antall samtidige sesjoner er nådd.';
$string['view_error_meeting_not_running'] = 'Noe gikk galt, sesjonen kjører ikke.';
$string['view_error_no_group'] = 'Ingen grupper er opprettet. Vennligst opprett gruppene før du fosøker å bli med i sesjonen.';
$string['view_error_no_group_student'] = 'Du er ikke meldt inn i noen gruppe. Vennligst kontakt læreren din.';
$string['view_error_no_group_teacher'] = 'Ingen grupper er satt opp. Vennligst opprett grupper eller kontakt systemadministratoren.';
$string['view_error_unable_join'] = 'Kan ikke bli med i møtet. Vennligst sjekk URL\'en til BigBlueButton-servern og sjekk om BigBlueButton-serveren kjører.';
$string['view_error_unable_join_student'] = 'Kan ikke koble til BigBlueButton-serveren.';
$string['view_error_unable_join_teacher'] = 'Kan ikke koble til BigBlueButton-serveren. Vennligst kontakt administraoren.';
$string['view_error_url_missing_parameters'] = 'URLen mangler parametre';
$string['view_error_userlimit_reached'] = 'Grensen for hvor mange brukere som er tillatt i en økt er nådd.';
$string['view_groups_nogroups_warning'] = 'Dette er rommet er satt opp til å bruke grupper, men kurset har ingen grupper.';
$string['view_groups_notenrolled_warning'] = 'Dette er rommet er satt opp til å bruke grupper, men du er ikke meldt inn i noen grupper.';
$string['view_groups_selection'] = 'Velg gruppen du ønsker å bli med i og bekreft.';
$string['view_groups_selection_join'] = 'Bli med';
$string['view_groups_selection_warning'] = 'Det er et konferanserom for hver gruppe og du har tilgang til mer enn ett. Vennligst velg det riktige.';
$string['view_login_moderator'] = 'Logger på som moderator...';
$string['view_login_viewer'] = 'Logger på som tilskuer...';
$string['view_message_and'] = 'og';
$string['view_message_conference_has_ended'] = 'Denne sesjonen er avsluttet.';
$string['view_message_conference_in_progress'] = 'Denne sesjonen pågår.';
$string['view_message_conference_not_started'] = 'Denne sesjonen har ikke startet ennå.';
$string['view_message_conference_room_ready'] = 'Dette konferanserommet er klart. Du kan bli med i sesjonen nå.';
$string['view_message_conference_user_limit_reached'] = 'Antallet brukere som er tillatt i en økt er nådd';
$string['view_message_conference_wait_for_moderator'] = 'Venter på at en moderator skal bli med.';
$string['view_message_cron_disabled'] = 'Listen med opptak kan være utdatert. Kontakt portaladministratoren med følgende informasjon: {$a}.';
$string['view_message_finished'] = 'Denne aktiiteten er avsluttet.';
$string['view_message_has_joined'] = 'har blitt med';
$string['view_message_have_joined'] = 'har blitt med';
$string['view_message_hour'] = 'time';
$string['view_message_hours'] = 'timer';
$string['view_message_importrecordings_disabled'] = 'Funksjonen for import av opptakslenker er deaktivert på denne serveren.';
$string['view_message_minute'] = 'minutt';
$string['view_message_minutes'] = 'minutter';
$string['view_message_moderator'] = 'Moderator';
$string['view_message_moderators'] = 'Moderatorer';
$string['view_message_norecordings'] = 'Det er ingen opptak å vise.';
$string['view_message_notavailableyet'] = 'Denne sesjonen er ikke tilgjengelig ennå.';
$string['view_message_recordings_disabled'] = 'Opptak er deaktivert på denne serveren. BigBlueButton instanser kun for opptak kan ikke brukes.';
$string['view_message_room_closed'] = 'Dette rommet er stengt.';
$string['view_message_room_open'] = 'Dette rommet er åpent.';
$string['view_message_room_ready'] = 'Dette rommet er klart.';
$string['view_message_session_for'] = 'sesjonen for';
$string['view_message_session_has_user'] = 'Det er';
$string['view_message_session_has_users'] = 'Det er';
$string['view_message_session_no_users'] = 'Det er ingen brukere i denne sesjonen';
$string['view_message_session_running_for'] = 'Denne sesjonen har pågått i';
$string['view_message_session_started_at'] = 'Økten startet';
$string['view_message_tab_close'] = 'Denne fanen/vinduet må lukkes manuelt';
$string['view_message_times'] = 'ganger';
$string['view_message_user'] = 'Bruker';
$string['view_message_users'] = 'Brukere';
$string['view_message_viewer'] = 'Seer';
$string['view_message_viewers'] = 'Seere';
$string['view_mobile_message_groups_not_supported'] = 'Denne forekomsten er aktivert for å jobbe med grupper, men mobilappen støtter den ennå ikke. Vennligst bruk webversjonen.';
$string['view_mobile_message_reload_page_creation_time_meeting'] = 'Du har vært på denne siden i mer enn 45 sekunder. Vennligst last inn siden på nytt før du blir med i møtet.';
$string['view_noguests'] = 'BigBlueButton er ikke tilgjengelig for gjester';
$string['view_nojoin'] = 'Du har ikke en rolle som kreves for å bli med i denne sesjonen.';
$string['view_recording'] = 'tar opp';
$string['view_recording_actionbar'] = 'Verktøylinje';
$string['view_recording_activity'] = 'Aktivitet';
$string['view_recording_button_import'] = 'Importer opptakslenker';
$string['view_recording_button_return'] = 'Gå tilbake';
$string['view_recording_course'] = 'Kurs';
$string['view_recording_date'] = 'Dato';
$string['view_recording_delete_confirmation'] = 'Er du sikker på at du ønsker å slette dette {$a}?';
$string['view_recording_delete_confirmation_warning_p'] = 'Dette opptaket har {$a} assosierte lenker som ble importert i et annet kurs eller aktivitet. Dersom opptaket er slettet vil lenken også fjernes.';
$string['view_recording_delete_confirmation_warning_s'] = 'Dette opptaket har {$a} assosiert lenke som ble importert i et annet kurs eller aktivitet. Dersom opptaket er slettet vil lenken også fjernes.';
$string['view_recording_description'] = 'Beskrivelse';
$string['view_recording_description_edithint'] = 'Rediger beskrivelsen. Det vil hjelpe for å finne opptaket senere';
$string['view_recording_description_editlabel'] = 'Rediger beskrivelse';
$string['view_recording_duration'] = 'Varighet';
$string['view_recording_duration_min'] = 'min';
$string['view_recording_format_errror_unreachable'] = 'URLen til dette opptaksformater kan ikke nås.';
$string['view_recording_format_notes'] = 'Notater';
$string['view_recording_format_podcast'] = 'Podcast';
$string['view_recording_format_presentation'] = 'Presentasjon';
$string['view_recording_format_screenshare'] = 'Skjermdeling';
$string['view_recording_format_statistics'] = 'Statistikk';
$string['view_recording_format_video'] = 'Video';
$string['view_recording_import_confirmation'] = 'Er du sikker på at du ønsker å importere dette opptaket?';
$string['view_recording_length'] = 'Lengde';
$string['view_recording_link'] = 'importet lenke';
$string['view_recording_link_warning'] = 'Dette er en lenke som peker til et opptak som ble gjort i et annet kurs eller aktivitet';
$string['view_recording_list_action_delete'] = 'Sletter';
$string['view_recording_list_action_edit'] = 'Oppdaterer';
$string['view_recording_list_action_play'] = 'Spill';
$string['view_recording_list_action_process'] = 'Behandler';
$string['view_recording_list_action_protect'] = 'Beskytter';
$string['view_recording_list_action_publish'] = 'Publisering';
$string['view_recording_list_action_unprotect'] = 'Ubeskyttet';
$string['view_recording_list_action_unpublish'] = 'Avpubliserer';
$string['view_recording_list_action_update'] = 'Oppdatering';
$string['view_recording_list_actionbar'] = 'Verktøylinje';
$string['view_recording_list_actionbar_delete'] = 'Slett';
$string['view_recording_list_actionbar_edit'] = 'Rediger';
$string['view_recording_list_actionbar_hide'] = 'Skjul';
$string['view_recording_list_actionbar_import'] = 'Importer';
$string['view_recording_list_actionbar_protect'] = 'Gjør privat';
$string['view_recording_list_actionbar_publish'] = 'Publiser';
$string['view_recording_list_actionbar_show'] = 'Vis';
$string['view_recording_list_actionbar_unprotect'] = 'Gjør offentlig';
$string['view_recording_list_actionbar_unpublish'] = 'Avpubliser';
$string['view_recording_list_activity'] = 'Aktivitet';
$string['view_recording_list_course'] = 'Kurs';
$string['view_recording_list_date'] = 'Dato';
$string['view_recording_list_description'] = 'Beskrivelse';
$string['view_recording_list_duration'] = 'Varighet';
$string['view_recording_list_recording'] = 'Tar opp';
$string['view_recording_meeting'] = 'Møte';
$string['view_recording_modal_button'] = 'Anvend';
$string['view_recording_modal_title'] = 'Sett opptaksverdier';
$string['view_recording_name'] = 'Navn';
$string['view_recording_name_edithint'] = 'Rediger navnet. Det vil hjelpe å finne opptaket senere';
$string['view_recording_name_editlabel'] = 'Rediger navn';
$string['view_recording_playback'] = 'Spill på nytt';
$string['view_recording_preview'] = 'Forhåndsvisning';
$string['view_recording_preview_help'] = 'Dra musepekeren over et bilde for å vise i full størrelse';
$string['view_recording_protect_confirmation'] = 'Er du sikker på å beskytte denne {$a}?';
$string['view_recording_protect_confirmation_warning_p'] = 'Dette opptaket har {$a} lenker tilknyttet som ble importert i forskjellige kurs eller aktiviteter. Hvis opptaket er beskyttet, vil det også påvirke de importerte koblingene';
$string['view_recording_protect_confirmation_warning_s'] = 'Dette opptaket har tilknyttet {$a} kobling som ble importert i et annet kurs eller aktivitet. Hvis opptaket er beskyttet, vil det også påvirke de importerte koblingene.';
$string['view_recording_publish_confirmation'] = 'Er du sikker på at du vil publisere denne {$a}?';
$string['view_recording_publish_confirmation_warning_p'] = 'Dette opptaket har {$a} lenker tilknyttet som ble importert i forskjellige kurs eller aktiviteter. Hvis opptaket publiseres, vil disse lenkene også bli publisert';
$string['view_recording_publish_confirmation_warning_s'] = 'Dette opptaket har tilknyttet {$a} kobling som ble importert i et annet kurs eller aktivitet. Hvis opptaket publiseres, vil denne lenken også bli publisert';
$string['view_recording_publish_link_deleted'] = 'Denne lenken kan ikke republiseres siden det aktuelle opptaket ikke eksisterer på BigBlueButton-serveren. Lenken bør fjernes';
$string['view_recording_publish_link_not_published'] = 'Denne lenken kan ikke republiseres siden det aktuelle opptaket er upublisert.';
$string['view_recording_recording'] = 'Opptak';
$string['view_recording_select_course'] = 'Velg et kurs først i rullegardinmenyen';
$string['view_recording_tags'] = 'Tagger';
$string['view_recording_unprotect_confirmation'] = 'Er du sikker på at du vil oppheve beskyttelsen av denne {$a}?';
$string['view_recording_unprotect_confirmation_warning_p'] = 'Dette opptaket har {$a} lenker tilknyttet som ble importert i forskjellige kurs eller aktiviteter. Hvis opptaket er ubeskyttet, vil det også påvirke de importerte koblingene';
$string['view_recording_unprotect_confirmation_warning_s'] = 'Dette opptaket har {$a} lenker tilknyttet som ble importert i forskjellige kurs eller aktiviteter. Hvis opptaket er ubeskyttet, vil det også påvirke de importerte koblingene';
$string['view_recording_unprotect_link_deleted'] = 'Denne lenken kan ikke være ubeskyttet siden opptaket  ikke eksisterer på BigBlueButton-serveren. Lenken bør fjernes';
$string['view_recording_unprotect_link_not_unprotected'] = 'Denne lenken kan ikke være ubeskyttet siden opptaket er beskyttet';
$string['view_recording_unpublish_confirmation'] = 'Er du sikker på at du ønsker å avpublisere dette {$a}?';
$string['view_recording_unpublish_confirmation_warning_p'] = 'Dette opptaket har {$a} assosierte lenker som ble importert i ulike kurs eller aktiviteter. Om opptaket avpubliseres vil også disse lenkene avpubliseres.';
$string['view_recording_unpublish_confirmation_warning_s'] = 'Dette opptaket har {$a} assosiert lenke som ble importert et kurs eller aktiviteter. Om opptaket avpubliseres vil også denne lenken avpubliseres.';
$string['view_recording_yui_first'] = 'Første';
$string['view_recording_yui_go'] = 'Start';
$string['view_recording_yui_last'] = 'Siste';
$string['view_recording_yui_next'] = 'Neste';
$string['view_recording_yui_page'] = 'Side';
$string['view_recording_yui_prev'] = 'Forrige';
$string['view_recording_yui_rows'] = 'Rekker';
$string['view_recording_yui_show_all'] = 'Vis alle';
$string['view_room'] = 'Vis romm';
$string['view_section_title_presentation'] = 'Presentasjonsfil';
$string['view_section_title_recordings'] = 'Opptak';
$string['view_warning_default_server'] = 'Denne portalen bruker en <a href="https://bigbluebutton.org/free-bigbluebutton-service-for-moodle/" target="_blank">gratis BigBlueButton-tjeneste for Moodle (åpnes i nytt vindu)</a> levert av Blindside Networks med begrensninger som følger:
<ol>
<li>Maksimal lengde for hver økt er 60 minutter</li>
<li>Maksimalt antall samtidige brukere per økt er 25</li>
<li>Opptak utløper etter sju (7) dager og kan ikke lastes ned</li>
<li>Studentwebkameraer er bare synlige for moderatoren.</li>
</ol>';
$string['waitformoderator'] = 'Venter på at en moderator skal bli med.';
