<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'auth_oidc', language 'no', version '4.1'.
 *
 * @package     auth_oidc
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['auth_oidcdescription'] = 'OpenID Connect-modulen tilbyr enkel pålogging via konfigurerbare identitetstilbydere.';
$string['cfg_autoappend_desc'] = 'Legg automatisk til en streng til brukernavnet når autentiseringsmetoden \'Ressursinformasjon for kontoeier\' er valgt. Dette er nyttig når IdP-en bruker hele domenenavnet som en del av brukernavnet, men ønsker ikke at brukeren skal behøve å skrive inn alt ved hver innlogging. F.eks. hvis full OpenID brukernavn er \'james@example.com\' og du angir \'@example.com\' her, vil brukeren bare behøve å bruke "james" som sitt brukernavn ved innlogging. <br /><b>MERK:</b>I de tilfeller hvor det kan oppstå konflikt i Moodle mellom brukere med samme navn, vil angitt prioritet av autentiseringsmetode avgjøre saken. Den metoden som har høyest prioritet vinner.';
$string['cfg_autoappend_key'] = 'Tilføy automatisk';
$string['cfg_customicon_desc'] = 'Hvis du vil bruke ditt eget ikon, kan du laste det opp her. Dette overstyrer ethvert ikon valgt ovenfor. <br /> <br /> <b> Merknader om bruk av egendefinerte ikoner: </b> <ul> <li> Dette bildet blir <b> ikke </b> tilpasset i størrelse på innloggingssiden, så vi anbefaler at du laster opp en bilde ikke større enn 35x35 piksler. </li> <li> Hvis du har lastet opp et tilpasset ikon og vil gå tilbake til et av lagerikonene, klikker du på det egendefinerte ikonet i boksen ovenfor, klikker deretter "Slett" og klikker deretter "OK", og klikk deretter "Lagre endringer" nederst på dette skjemaet. Det valgte lagerikonet vil nå vises på Moodle-påloggingssiden. </li> </ul>';
$string['cfg_customicon_key'] = 'Tilpasset ikon';
$string['cfg_debugmode_desc'] = 'Hvis aktivert, vil informasjonen lagres i Moodle loggen til hjelp for å identifisere problemer.';
$string['cfg_debugmode_key'] = 'Lagre debug-meldinger';
$string['cfg_domainhint_desc'] = 'Når du bruker godkjenningsmetoden "Autorisasjonskode", sendes denne verdien som parameteren "domain_hint". "domain_hint" brukes av noen OpenID Connect-leverandører for å gjøre innloggingsprosessen enklere for brukere. Kontakt leverandøren din for å se om de støtter denne parameteren.';
$string['cfg_domainhint_key'] = 'Domenehint';
$string['cfg_err_invalidauthendpoint'] = 'Ugyldig autorisasjonsendepunkt';
$string['cfg_err_invalidclientid'] = 'Ugyldig klientID';
$string['cfg_err_invalidclientsecret'] = 'Ugyldig klient-nøkkel';
$string['cfg_err_invalidtokenendpoint'] = 'Ugyldig token-endepunkt';
$string['cfg_icon_desc'] = 'Et ikon som vises ved siden av tilbydernavnet på innloggingssiden.';
$string['cfg_icon_key'] = 'Ikon';
$string['cfg_iconalt_check'] = 'Ok-ikon';
$string['cfg_iconalt_go'] = 'Grønn sirkel';
$string['cfg_iconalt_group'] = 'Gruppeikon';
$string['cfg_iconalt_group2'] = 'Alternativt gruppeikon';
$string['cfg_iconalt_key'] = 'Nøkkelikon';
$string['cfg_iconalt_lock'] = 'Låse-ikon';
$string['cfg_iconalt_locked'] = 'Låst-ikon';
$string['cfg_iconalt_mnet'] = 'MNET-ikon';
$string['cfg_iconalt_o365'] = 'Office365-ikon';
$string['cfg_iconalt_plus'] = 'Pluss-ikon';
$string['cfg_iconalt_rightarrow'] = 'Høyrevendt pilikon';
$string['cfg_iconalt_stop'] = 'Rød sirkel';
$string['cfg_iconalt_user'] = 'Bruker-ikon';
$string['cfg_iconalt_user2'] = 'Alternativt bruker-ikon';
$string['cfg_iconalt_userlock'] = 'Bruker med låse-ikon';
$string['cfg_loginflow_authcode'] = 'Autorisasjon med prosessflyt (anbefalt)';
$string['cfg_loginflow_authcode_desc'] = 'Ved å bruke denne flyten, klikker brukeren navnet på identitetsleverandøren (se "Navn på leverandør" ovenfor) på Moodle-påloggingssiden og blir omdirigert til leverandøren for å logge på. Når den er logget på, blir brukeren omdirigert tilbake til Moodle der Moodle-pålogging skjer transparent. Dette er den mest standardiserte, sikre måten for brukerpålogging.';
$string['cfg_loginflow_key'] = 'Autentiseringsmetode';
$string['cfg_loginflow_rocreds'] = 'Kun lokal innlogging via identitetstilbyder';
$string['cfg_loginflow_rocreds_desc'] = 'Ved å bruke denne flyten skriver brukeren inn brukernavnet og passordet sitt i Moodle-påloggingsskjemaet slik de ville gjort med en manuell pålogging. Dette vil autorisere brukeren med identitetstilbyder, men vil ikke opprette en økt på identitetstilbyders nettsted. Hvis du for eksempel bruker Office 365 med OpenID Connect, vil brukeren være logget på Moodle, men ikke Office 365-nettprogrammene. Autorisasjon med prosessflyt anbefales hvis du vil at brukere skal være logget på både Moodle og identitetsleverandøren. Merk at ikke alle identitetsleverandører støtter denne flyten. Dette alternativet skal bare brukes når andre godkjenningstyper ikke er tilgjengelige.';
$string['cfg_opname_desc'] = 'Dette er informasjon som vises for sluttbruker, og som identifiserer hvilken innloggingsinformasjon brukeren må benytte for å logge inn. Denne informasjonen brukes i de (for brukere) synlige delene av denne modulen for å identifisere leverandøren din.';
$string['cfg_opname_key'] = 'Tilbydernavn';
