<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'adaptivequiz', language 'no', version '4.1'.
 *
 * @package     adaptivequiz
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abilityestimated'] = 'Estimert ferdighet';
$string['abilityestimated_help'] = 'Den estimerte evnen til en testtaker samsvarer med spørsmålets vanskelighetsgrad der testtakeren har en 50% sannsynlighet for å svare riktig på spørsmålet. For å identifisere prestasjonsnivået, match evneverdien med spørsmålsnivåområdet (se området etter \'/\' -symbolet).';
$string['activityreports'] = 'Forsøksrapport';
$string['adaptivequiz:addinstance'] = 'Legg til en ny adaptiv quiz';
$string['adaptivequiz:attempt'] = 'Forsøk adaptiv quiz';
$string['adaptivequiz:reviewattempts'] = 'Gjennomgå innsendinger av adaptiv quiz';
$string['adaptivequiz:viewreport'] = 'Se rapporter for adaptiv quiz';
$string['adaptivequizname'] = 'Navn';
$string['adaptivequizname_help'] = 'Skriv navnet på adaptiv quiz';
$string['all_attempts_deleted'] = 'Alle forsøk på adaptiv quiz ble slettet';
$string['all_grades_removed'] = 'Alle karakterer fra adaptiv quiz ble fjernet';
$string['answer'] = 'Svar';
$string['answers_display_name'] = 'Svar';
$string['attempt_questiondetails'] = 'Spørsmålsdetaljer';
$string['attempt_state'] = 'Forsøksstatus';
$string['attempt_summary'] = 'Sammendrag av forsøket';
$string['attempt_user'] = 'Bruker';
$string['attemptclosed'] = 'Forsøket er avsluttet manuelt';
$string['attemptclosedstatus'] = 'Manuelt lukket av {a->current_user_name} (bruker-id: {a->current_user_id}) den {$a->now}.';
$string['attemptdeleted'] = 'Forsøk slettet for {a->name} sendt inn den {a->timecompleted}';
$string['attemptfeedback'] = 'Tilbakemelding på forsøk';
$string['attemptfeedback_help'] = 'Tilbakemeldingen på forsøket vises for brukeren når forsøket er ferdig';
$string['attemptfeedbackdefaulttext'] = 'Du har fullført forsøket, takk for at du tok quizen!';
$string['attemptfinishedtimestamp'] = 'Ferdigstillingstid for forsøk';
$string['attemptfirst'] = 'Første forsøk';
$string['attemptlast'] = 'Siste forsøk';
$string['attemptnofirstquestion'] = 'Beklager, men kunne ikke definere det første spørsmålet for å starte forsøket, quizen er muligens feilkonfigurert.';
$string['attemptquestion_ability'] = 'Ferdighetsmål';
$string['attemptquestion_abilitylogits'] = 'Målt ferdighet (logits)';
$string['attemptquestion_difficulty'] = 'Spørsmålets vanskelighetsgrad (logits)';
$string['attemptquestion_diffsum'] = 'Sum vanskelighetsgrad';
$string['attemptquestion_level'] = 'Spørsmålsnivå';
$string['attemptquestion_rightwrong'] = 'Svar rett/galt';
$string['attemptquestion_stderr'] = 'Standardfeil (&plusmn;&nbsp;logits)';
$string['attemptquestionsprogress'] = 'Spørsmålsfremdrift  {$a}';
$string['attemptquestionsprogress_help'] = 'Det maksimale antallet spørsmål som vises her er ikke nødvendigvis antall spørsmål du må ta i løpet av quizen. Det er det MAKSIMALE MULIGE antallet spørsmål du kan ta, quizen kan avsluttes tidligere hvis ferdighetsmålet er tilstrekkelig definert.';
$string['attemptsallowed'] = 'Tillatte forsøk';
$string['attemptsallowed_help'] = 'Antall ganger en student kan forsøke denne aktiviteten';
$string['attemptstarttime'] = 'Forsøkets starttid';
$string['attemptstate'] = 'Forsøksstatus';
$string['attemptstopcriteria'] = 'Grunn til å stoppe forsøket';
$string['attemptsusernoprevious'] = 'Du har ikke gjort denne quizen ennå.';
$string['attemptsuserprevious'] = 'Dine tidligere forsøk';
$string['attempttotaltime'] = 'Total tid  (hh:mm:ss)';
$string['back_to_all_questions'] = '&laquo; Tilbake til alle spørsmål';
$string['bestscore'] = 'Beste resultat';
$string['bestscorestderror'] = 'Standardfeil';
$string['browsersecurity'] = 'Nettlesersikkerhet';
$string['browsersecurity_help'] = 'Hvis "Fullskjerm pop-up med noe JavaScript-sikkerhet" er valgt, vil quizen bare starte hvis studenten har en JavaScript-aktivert nettleser. Quizen vises i et fullskjerms popup-vindu som dekker alle de andre vinduene og har ingen navigasjonskontroller, og studentene forhindres, så langt det er mulig, fra å bruke funksjoner som kopier og lim inn.';
$string['calcerrorwithinlimits'] = 'Beregnet standardfeil av {$a->calerror} er innenfor grensene pålagt av aktiviteten {$a->definederror}';
$string['closeattempt'] = 'Lukk forsøket';
$string['completionattemptcompletedcminfo'] = 'Fullfør et forsøk';
$string['completionattemptcompletedform'] = 'Studenten må ha minst ett fullført forsøk på denne aktiviteten.';
$string['confirmcloseattempt'] = 'Er du sikker på at du ønsker å lukke og avslutte dette forsøket til {$a->name}?';
$string['confirmcloseattemptscore'] = '{$a->num_questions} spørsmål ble besvart og resultatet så langt er {$a->measure} {$a->standarderror}.';
$string['confirmcloseattemptstats'] = 'Dette forsøket startet {a->started} og ble sist oppdatert {$a->modified}.';
$string['confirmdeleteattempt'] = 'Bekrefter sletting av forsøk fra {a->name} sendt inn  {$a->timecompleted}';
$string['deleteattemp'] = 'Slett forsøk';
$string['discrimination_display_name'] = 'Diskriminering';
$string['downloadcsv'] = 'Last ned CSV';
$string['enterrequiredpassword'] = 'Skriv inn påkrevd passord';
$string['errorattemptstate'] = 'Det oppstod en feil ved bestemmelse av forsøkets status.';
$string['errorclosingattempt_alreadycomplete'] = 'Dette forsøket er allerede fullført, det kan ikke lukkes manuelt.';
$string['errorfetchingquest'] = 'Kunne ikke hente et spørsmål for nivå {$a->level}';
$string['errorlastattpquest'] = 'Feil ved sjekking av svarverdien for det siste forsøkte spørsmålet.';
$string['errornumattpzero'] = 'Feil med antall forsøkte spørsmål lik null, men brukeren sendte inn et svar til forrige spørsmål.';
$string['errorsumrightwrong'] = 'Summen av riktige og gale svar tilsvarer ikke det totale antallet forsøkte spørsmål.';
$string['eventattemptcompleted'] = 'Forsøk fullført';
$string['formelementdecimal'] = 'Skriv inn et desimaltall. Maks 10 sifre, og maks 5 desimaler til høyre for desimaltegnet.';
$string['formelementempty'] = 'Skriv inn et positivt heltall fra 1 til 999';
$string['formelementnegative'] = 'Skriv inn et positivt tall fra 1 til 999';
$string['formelementnumeric'] = 'Skriv inn en numerisk verdi fra 1 til 999';
$string['formlowlevelgreaterthan'] = 'Laveste nivå må være mindre enn høyeste nivå';
$string['formminquestgreaterthan'] = 'Minimumsantall spørsmål må være lavere enn maksimalt antall spørsmål.';
$string['formquestionpool'] = 'Velg minst én spørsmålskategori';
$string['formstartleveloutofbounds'] = 'Startnivået må være et tall som er mellom laveste og høyeste nivå';
$string['formstderror'] = 'Må skrive inn en prosent mindre enn 50 og større enn eller lik 0';
$string['functiondisabledbysecuremode'] = 'Den funksjonaliteten er for tiden deaktivert';
$string['gradehighest'] = 'Høyeste karakter';
$string['grademethod'] = 'Karaktersettingsmetode';
$string['grademethod_help'] = 'Når flere forsøk er tillatt, er følgende metoder tilgjengelige for å beregne den endelige quizkarakteren:

* Høyeste karakter av alle forsøk
* Første forsøk (alle andre forsøk ignoreres)
* Siste forsøk (alle andre forsøk ignoreres)';
$string['graphlegend_error'] = 'Standardfeil';
$string['highestlevel'] = 'Høyeste vanskelighetsgrad';
$string['highestlevel_help'] = 'Det høyeste eller mest vanskelige nivået vurderingen kan velge spørsmål fra. Under et forsøk vil aktiviteten ikke gå utover denne vanskelighetsgraden.';
$string['highlevelusers'] = 'Brukere over spørsmålsnivået';
$string['id'] = 'ID';
$string['indvuserreport'] = 'Individuell brukerforsøksrapport for {$a}';
$string['leveloutofbounds'] = 'Forespurt nivå {$a->level} utenfor grensene for forsøket.';
$string['lowestlevel'] = 'Laveste vanskelighetsgrad';
$string['lowestlevel_help'] = 'Det laveste eller minst vanskelige nivået vurderingen kan velge spørsmål fra. Under et forsøk vil aktiviteten ikke gå utover denne vanskelighetsgraden.';
$string['lowlevelusers'] = 'Brukere under spørsmålsnivået';
$string['maximumquestions'] = 'Maksimalt antall spørsmål';
$string['maximumquestions_help'] = 'Det maksimale antall spørsmål studenten kan forsøke';
$string['maxquestattempted'] = 'Maksimalt antall forsøkte spørsmål';
$string['midlevelusers'] = 'Brukere når spørsmålsnivået';
$string['minimumquestions'] = 'Minimum antall spørsmål';
$string['minimumquestions_help'] = 'Det minimum antall spørsmål studenten må forsøke';
$string['missingtagprefix'] = 'Manglende tag-prefiks';
$string['modformshowattemptprogress'] = 'Vis quizfremdrift til studenter';
$string['modformshowattemptprogress_help'] = 'Når valgt, under forsøk, vil en student se en fremdriftslinje som viser hvor mange spørsmål som er besvart av det maksimale antallet.';
$string['modulename'] = 'Adaptiv quiz';
$string['modulename_help'] = 'Aktiviteten Adaptiv Quiz gjør det mulig for en lærer å lage quizer som effektivt måler deltakernes evner. Adaptive quizer består av spørsmål valgt fra spørsmålsbanken som er merket med en score for deres vanskelighetsgrad. Spørsmålene velges for å matche det estimerte ferdighetsnivået til testtakeren. Hvis testtakeren lykkes med et spørsmål, presenteres et mer utfordrende spørsmål neste gang. Hvis testtakeren svarer feil på et spørsmål, presenteres et mindre utfordrende spørsmål neste gang. Denne teknikken vil utvikle seg til en sekvens av spørsmål som konvergerer mot testtakerens effektive ferdighetsnivå. Quizen stopper når testtakerens ferdigheter er bestemt med den nødvendige nøyaktigheten.

Denne aktiviteten er best egnet for å bestemme ferdighetsmål
 langs en endimensjonal skala. Selv om skalaen kan være svært bred, må spørsmålene alle gi et mål på evne eller ferdighet på samme skala. I en plasseringstest, for eksempel, bør spørsmål lavt på skalaen som nybegynnere kan svare riktig på også kunne besvares av eksperter, mens spørsmål høyere på skalaen bare bør kunne besvares av eksperter eller ved et heldig gjetning. Spørsmål som ikke skiller mellom deltakere med forskjellige evner vil gjøre testen ineffektiv og kan gi uklare resultater.

Spørsmål brukt i den adaptive quizen må:

* bli automatisk vurdert som riktig/feil
* merkes med vanskelighetsgrad ved å bruke \'adpq_\' etterfulgt av et positivt heltall som er innenfor området for quizen

Den adaptive quizen kan konfigureres til å:

* definer området for spørsmålsvanskeligheter/brukeferdigheter som skal måles. 1-10, 1-16 og 1-100 er eksempler på gyldige områder.
* definer presisjonen som kreves før quizen stoppes. Ofte er en feil på 5 % i evnemålingen en passende stoppregel.
*kreve at et minimum antall spørsmål besvares
kreve et maksimalt antall spørsmål som kan besvares

Denne beskrivelsen og testprosessen i denne aktiviteten er basert på <a href="http://www.rasch.org/memo69.pdf">Computer-Adaptive Testing: A Methodology Whose Time Has Come</a> av John Michael Linacre, Ph.D. MESA Psychometric Laboratory - University of Chicago. MESA Memorandum No. 69.';
$string['modulenameplural'] = 'adaptive quiz';
$string['na'] = 'ikke tilgjengelig';
$string['name'] = 'Navn';
$string['noattemptsallowed'] = 'Flere forsøk er ikke tillatt på denne aktiviteten.';
$string['nonewmodules'] = 'Ingen adaptive quiz-forekomster funnet';
$string['nopermission'] = 'Du har ikke tillatelse til å se denne ressursen.';
$string['notinprogress'] = 'Dette forsøket er ikke i gang.';
$string['notyourattempt'] = 'Dette er ikke ditt forsøk på aktiviteten.';
$string['numofattemptshdr'] = 'Antall forsøk';
$string['percent_correct_display_name'] = '% korrekt';
$string['pluginadministration'] = 'Adaptive quiz';
$string['pluginname'] = 'Adaptive quiz';
$string['question_report'] = 'Spørsmålsanalyse';
$string['questionanalysisbtn'] = 'Spørsmålsanalyse';
$string['questionnumber'] = 'Spørsmål #';
$string['questionpool'] = 'Spørsmålspool';
$string['questionpool_help'] = 'Velg spørsmålskategori(er) hvor aktiviteten vil hente spørsmål fra under et forsøk.';
$string['questions_report'] = 'Spørsmålsrapport';
$string['questionsattempted'] = 'Sum av spørsmål forsøkt';
$string['questionspoolerrornovalidstartingquestions'] = 'De valgte spørsmålkategoriene inneholder ikke spørsmål som er riktig merket for å matche det valgte startnivået for vanskelighetsgrad.';
$string['recentactquestionsattempted'] = 'Spørsmål forsøkt: {$a}';
$string['recentattemptstate'] = 'Forsøkets status:';
$string['recentcomplete'] = 'Fullført';
$string['recentinprogress'] = 'Pågår';
$string['reportanswersdistributionchartdisplaystacked'] = 'Vis stablede søyler';
$string['reportanswersdistributionchartnumrightlabel'] = 'Antall rette svar';
$string['reportanswersdistributionchartnumwronglabel'] = 'Antall feil svar';
$string['reportanswersdistributionchartxaxislabel'] = 'Vanskelighetsgrad på spørsmål';
$string['reportanswersdistributionchartyaxislabel'] = 'Antall svar';
$string['reportattemptadmanswerright'] = 'R';
$string['reportattemptadmanswerwrong'] = 'G';
$string['reportattemptadmchartadmdifflabel'] = 'Administrert vanskelighetsgrad';
$string['reportattemptadmcharttargetdifflabel'] = 'Mål vanskelighetsgrad';
$string['reportattemptanswerdistributiontab'] = 'Svarfordeling';
$string['reportattemptgraphtab'] = 'Forsøksgraf';
$string['reportattemptgraphtabletitle'] = 'Tabellvisning av forsøksgraf';
$string['reportattemptquestionsdetailstab'] = 'Spørsmålsdetaljer';
$string['reportattemptreviewpageheading'] = '{$a->quizname} - gjennomgang av forsøk av {$a->fullname} levert inn den {$a->finished}';
$string['reportattemptsbothenrolledandnotenrolled'] = 'alle brukere som har gjort forsøk';
$string['reportattemptsdownloadfilename'] = '{$a}_forsøksrapport';
$string['reportattemptsenrolledwithattempts'] = 'deltakere som gjorde forsøk';
$string['reportattemptsenrolledwithnoattempts'] = 'deltakere uten forsøk gjort';
$string['reportattemptsfilterformheader'] = 'Filtrering';
$string['reportattemptsfilterformsubmit'] = 'Filter';
$string['reportattemptsfilterincludeinactiveenrolments'] = 'Inkluder brukere med inaktive påmeldinger';
$string['reportattemptsfilterincludeinactiveenrolments_help'] = 'Om inkludering av brukere med suspenderte påmeldinger.';
$string['reportattemptsfilterusers'] = 'Vis';
$string['reportattemptsnotenrolled'] = 'ikke registrerte brukere som gjorde forsøk';
$string['reportattemptspersistentfilter'] = 'Vedvarende filter';
$string['reportattemptspersistentfilter_help'] = 'Når merket av, vil filterinnstillingene nedenfor lagres når de sendes inn, og deretter brukes hver gang du besøker rapportsiden.';
$string['reportattemptsprefsformheader'] = 'Rapport preferanser';
$string['reportattemptsprefsformsubmit'] = 'Søke';
$string['reportattemptsresetfilter'] = 'Tilbakestill filter';
$string['reportattemptsshowinitialbars'] = 'Vis alfabetisk navigasjonsliste';
$string['reportattemptsummarytab'] = 'Forsøksoppsummering';
$string['reportattemptsusersperpage'] = 'Antall brukere vist:';
$string['reportindividualuserattemptpageheading'] = '{$a->quizname} - individuell brukerrapport for {$a->username}';
$string['reportquestionanalysispageheading'] = '{$a} - spørsmålsrapport';
$string['reportuserattemptstitleshort'] = '{$a}s forsøk';
$string['requirepassword'] = 'Påkrevd passord';
$string['requirepassword_help'] = 'Studentene må oppgi et passord før de begynner forsøket sitt.';
$string['requirepasswordmessage'] = 'For å forsøke denne quizen må du kjenne quiz-passordet.';
$string['resetadaptivequizsall'] = 'Slett alle forsøk på adaptiv quiz.';
$string['result'] = 'Resultat';
$string['reviewattempt'] = 'Gjennomgå forsøk';
$string['reviewattemptreport'] = 'Gjennomgår forsøk av {a->fullname} sendt inn den {a->finished}.';
$string['score'] = 'Resultat';
$string['showabilitymeasure'] = 'Vis ferdighetsmål til studenter';
$string['showabilitymeasure_help'] = 'Noen ganger kan det være nyttig å vise vurderingene til studenter etter å ha tatt en adaptiv quiz. Med denne innstillingen aktivert kan en student se vurderingen i oppsummeringen av forsøk og rett etter at et forsøk er fullført.';
$string['standarderror'] = 'Standardfeil for å stoppe';
$string['standarderror_help'] = 'Når mengden feil i målingen av brukerens evne faller under denne verdien, vil quizen stoppe. Juster denne verdien fra standarden på 5 % for å kreve mer eller mindre presisjon i evnemålingen.';
$string['standarderrorhdr'] = 'Standardfeil';
$string['startattemptbtn'] = 'Start forsøk';
$string['startinglevel'] = 'Startnivå for vanskelighetsgrad';
$string['startinglevel_help'] = 'Når studenten begynner et forsøk, vil aktiviteten tilfeldig velge et spørsmål som samsvarer med vanskelighetsnivået.';
$string['statistic'] = 'Statistikk';
$string['stopingconditionshdr'] = 'Stoppbetingelser';
$string['submitanswer'] = 'Send inn svar';
$string['times_used_display_name'] = 'Antall ganger brukt';
$string['updateattempterror'] = 'Feil ved forsøk på å oppdatere forsøksregistreringen.';
$string['user'] = 'Bruker';
$string['value'] = 'Verdi';
$string['wrongpassword'] = 'Passordet er feil';
