<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_reportbuilder', language 'ja', version '4.1'.
 *
 * @package     tool_reportbuilder
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accesstab'] = 'アクセス';
$string['actions'] = 'アクション';
$string['addacondition'] = 'コンディションの追加';
$string['addafilter'] = 'フィルターの追加';
$string['addaudience'] = 'オーディエンスの追加';
$string['addaudiences'] = 'このレポートにオーディエンスを追加する';
$string['addcolumn'] = 'カラムの追加';
$string['adddefault'] = 'デフォルト設定を追加';
$string['adddefault_help'] = '各レポートはデフォルトの列、条件とフィルタも定義します。デフォルトを使ってレポートを作成したい場合は、このフィールドを選択してください';
$string['addemails'] = 'メールアドレスを手動で追加する';
$string['addfieldbyname'] = 'レポートにフィールド \'{$a}\' を追加する';
$string['addreport'] = '新規レポート';
$string['addschedule'] = '新規スケジュール';
$string['addusers'] = 'ユーザを手動で追加';
$string['addusers_help'] = 'すべての手動追加されたユーザは部門や役職に関わらずこのレポートを受け取ることができます。';
$string['aggregation_avg'] = '平均';
$string['aggregation_count'] = '数';
$string['aggregation_countdistinct'] = '一意の数';
$string['aggregation_groupconcat'] = '半角カンマ区切り';
$string['aggregation_groupconcatdistinct'] = '半角カンマ区切り(重複無し)';
$string['aggregation_max'] = '最大';
$string['aggregation_min'] = '最小';
$string['aggregation_percent'] = 'パーセンテージ';
$string['aggregation_sum'] = '合計';
$string['aggregation_unique'] = '一意の値';
$string['allusers'] = 'すべてのユーザ';
$string['allusersdesc'] = 'このレポートにすべてのユーザを追加';
$string['and'] = 'かつ';
$string['asc'] = '列 \'{$a}\' は昇順です';
$string['audience'] = 'オーディエンス';
$string['audiencejobadd'] = 'ジョブの追加';
$string['audiencejobremove'] = 'ジョブの削除';
$string['audiencejobs'] = 'ジョブ';
$string['audiencejobs_help'] = '以下のいずれかのジョブに所属している場合、ユーザはこのレポートを表示できます';
$string['audiencejobsempty'] = '追加された職種はありません';
$string['audiencemultiselectpostix'] = 'さらに {$a} 件';
$string['audiencenotsaved'] = 'オーディエンスが保存されませんでした。';
$string['audiences'] = 'オーディエンス';
$string['authmethod'] = '認証方法';
$string['availableinalltenants'] = 'すべてのテナントで利用可能';
$string['availableinalltenants_help'] = '有効にすると、すべてのテナントのユーザ（適切な権限を持つ）がこのレポートを表示できるようになります。ほとんどのレポートソースは、表示されるユーザおよびその他のエンティティ（プログラム、認定、コース）をテナント内に表示されるものに自動的に制限します。';
$string['backtoreport'] = 'レポートへ戻る';
$string['basicinformation'] = '基本情報';
$string['cachedef_userreports'] = 'ユーザがアクセスできるカスタムレポート';
$string['canviewallreports'] = 'すべてのレポートを表示できます';
$string['cardview'] = 'カードビュー';
$string['cardview_help'] = 'レポートは、小さな画面や狭いブロックで表示される場合、自動的にカードビューに切り替わります。';
$string['certificatesissues'] = '認定証の発行';
$string['certificatetemplates'] = '認定証テンプレート';
$string['checkboxanyvalue'] = '任意の値';
$string['checkboxischecked'] = 'Yes';
$string['checkboxisnotchecked'] = 'No';
$string['choose'] = '選択してください…';
$string['columncannotbeconverted'] = '列 \'{$a}\' を変換できません。';
$string['conditioncannotbeconverted'] = '条件 \'{$a}\' を変換できません。';
$string['conditionoptioncannotbeconverted'] = '条件 \'{$a->condition}\' のオプション \'{$a->option}\' を変換できません。';
$string['conditionshelp'] = '条件';
$string['conditionshelp_help'] = 'このレポートを表示するときに常に適用される事前定義済みの条件の一覧。';
$string['conditionstab'] = '条件';
$string['confirm'] = '確認';
$string['confirmdeletecondition'] = '本当に条件 \'{$a}\' を削除しますか？';
$string['confirmdeleteschedule'] = '本当にスケジュール \'{$a}\' と関連するすべてのデータを削除しますか？この操作は元に戻せません。';
$string['confirmresetallconditions'] = '本当にすべての条件をリセットしますか？';
$string['confirmresetconditions'] = '本当に条件 \'{$a}\' をリセットしますか？';
$string['confirmsendschedule'] = '本当に送信のためにキュー \'{$a}\' に入れますか？';
$string['contentvisibility'] = '常に表示される列の数';
$string['convertingreport'] = 'レポート \'{$a}\' を変換';
$string['convertnotimplementeddesc'] = 'レポートを変換できませんでした。開発者が変換ルールを指定する必要があります。新しいバージョンのレポートビルダーで同じレポートを最初から作成し、このレポートを削除することもできます。';
$string['convertnotpossibledesc'] = 'レポートを自動的に変換できませんでした。以下のエラーメッセージを確認してください。このレポートの一部の列や属性が、新しいデータソースに正確に対応していない可能性があります。その場合は、レポートを編集し、自動変換できない要素を削除したうえで、再度変換を試してください。
なお、レポート変換中に複数のエラーが発生した場合、ここには最初のエラーのみが表示されます。';
$string['convertocore'] = '最新バージョンに変換する';
$string['course_completion_days_course'] = 'コース受講日数';
$string['course_completion_days_enrolled'] = '登録日数';
$string['course_completion_daysuntilcompletion'] = '完了までの残り日数';
$string['course_completion_progress'] = '進捗';
$string['course_completion_progress_percent'] = '進捗(%)';
$string['course_completion_reaggregate'] = '時間を再集計';
$string['course_completion_reaggregated'] = '時間が再集計されました';
$string['course_completion_timecompleted'] = '完了時間';
$string['course_completion_timeenrolled'] = '登録時間';
$string['course_completion_timestarted'] = '開始時間';
$string['course_enrolment_method'] = '方法';
$string['course_enrolment_status'] = '登録ステータス';
$string['course_enrolment_timeended'] = '登録終了';
$string['course_enrolment_timestarted'] = '登録開始';
$string['coursefullnamewithlink'] = 'リンク付きのコースのフルネーム';
$string['courseidnumberewithlink'] = 'リンク付きのコースID番号';
$string['courseshortnamewithlink'] = 'リンク付きのコースショートネーム';
$string['customessage'] = 'カスタムメッセージ';
$string['customfieldcolumn'] = '{$a}';
$string['customizecondition'] = '条件名を編集';
$string['customizefilter'] = 'フィルタ名を編集';
$string['customizeheader'] = '列ヘッダ \'{$a}\' を編集';
$string['customreports'] = 'カスタムレポート';
$string['customreportsdesc'] = 'レポート閲覧者とスケジュールデータを含むカスタムレポート';
$string['customreportslegacy'] = '旧バージョンのカスタムレポート';
$string['customreportslimit'] = 'カスタムレポートの上限';
$string['customreportslimit_desc'] = 'パフォーマンス上の理由により、カスタムレポートの数に制限が設けられる場合があります。0 に設定すると、制限はありません。';
$string['customreportsliveediting'] = 'カスタムレポートのリアルタイム編集';
$string['customreportsliveediting_desc'] = '有効にすると、ユーザはレポートを編集しながらデータを確認できます。パフォーマンス上の理由により、無効にされる場合があります。';
$string['customreportsliveeditingdisabled'] = 'サイト管理者によって、レポート編集中のデータ表示が無効にされています。レポートを表示するには、プレビューモードに切り替えてください。';
$string['customreportssettings'] = 'カスタムレポートの設定';
$string['dateanyvalue'] = '任意の値';
$string['datecreated'] = '作成日';
$string['datecurrent'] = '現在の';
$string['dateinthefuture'] = '未来';
$string['dateinthepast'] = '過去';
$string['dateisempty'] = '空白';
$string['dateisnotempty'] = '空白ではない';
$string['datelast'] = '過去…日間';
$string['datenext'] = '今後…日間';
$string['dateprevious'] = '以前の';
$string['daterange'] = '日付の範囲';
$string['daterangefrom'] = 'From';
$string['daterangeto'] = 'To';
$string['datetostart'] = '日付';
$string['dateupcoming'] = '直近の';
$string['debugsqlparams'] = 'パラメータ';
$string['debugsqlquery'] = '現在のクエリ';
$string['deleteaudience'] = 'オーディエンス \'{$a}\' を削除';
$string['deletecolumn'] = '列 \'{$a}\' を削除';
$string['deletecondition'] = '条件 \'{$a}\' を削除';
$string['deletefilter'] = 'フィルタを削除';
$string['deletereport'] = 'レポートを削除';
$string['deletereportmsg'] = '本当にレポート \'{$a}\' と関連するすべてのデータを削除しますか？この操作は元に戻せません。';
$string['deletereportsuccess'] = 'レポートが削除されました';
$string['deleteschedule'] = 'スケジュールを削除';
$string['desc'] = '列 \'{$a}\' は降順です';
$string['description'] = '説明';
$string['description_help'] = 'レポートの目的について説明してください。';
$string['duplicate'] = '複製';
$string['duplicatereport'] = 'レポートを複製';
$string['editaudience'] = 'オーディエンスを編集';
$string['editinglegacywarning'] = '古いバージョンのレポートビルダーのレポートを編集しています。最新バージョンに変換することを推奨します。';
$string['editmode'] = '編集ビューに切り替え';
$string['editreport'] = 'コンテンツを編集';
$string['editreportdetails'] = '詳細を編集';
$string['editreportname'] = 'レポート名を編集';
$string['editschedule'] = 'スケジュールを編集';
$string['edittitle'] = 'レポート \'{$a}\' を編集';
$string['enablesortingon'] = '列 \'{$a}\' の並べ替えを利用可能にする';
$string['enteremail'] = '有効なメールアドレスを入力し、Enterを押してください';
$string['entity_course_enrolment'] = '登録';
$string['entitycertificate'] = '認定証';
$string['entitycertificateissue'] = '認定証の発行';
$string['entitycourse'] = 'コース';
$string['entitycourseaccess'] = 'コースアクセス';
$string['entitycoursecompletion'] = 'コース完了';
$string['entitycourseenrolment'] = 'コースの登録';
$string['entitydatastorecoursecompletion'] = 'データストアコースの完了';
$string['entityreportbuilder'] = 'カスタムレポート';
$string['entityschedule'] = 'スケジュール';
$string['entityuser'] = 'ユーザ';
$string['error:mustselectformat'] = '形式を選択する必要があります。';
$string['error:mustselectsource'] = 'レポートソースを選択する必要があります。';
$string['errormanageschedules'] = 'スケジュールを管理するパーミッションがありません';
$string['errormissingreportsource'] = '設定済みのレポートソースが見つかりませんでした';
$string['errornorecipients'] = 'このスケジュールを受ける側の人をいくつか選択する必要があります';
$string['errorunavailablereportsource'] = '構成されたレポートソースは利用できません';
$string['eventreportcreated'] = '作成されたレポート';
$string['eventreportdeleted'] = '削除されたレポート';
$string['eventreportschedulecreated'] = '作成されたレポートスケジュール';
$string['eventreportscheduledeleted'] = '削除されたレポートスケジュール';
$string['eventreportscheduleupdated'] = '更新されたレポートスケジュール';
$string['eventreportupdated'] = '更新されたレポート';
$string['eventreportviewed'] = '表示されたレポート';
$string['expandcardview'] = 'カードビューを展開';
$string['expandconditions'] = '条件を展開';
$string['expandfilters'] = 'フィルターを展開';
$string['expandsorting'] = 'ソートを展開';
$string['exportselectall'] = 'すべてのカスタムレポートをエクスポートする';
$string['exportselectlimit'] = '特定のカスタムレポートをエクスポートする';
$string['filtercannotbeconverted'] = 'フィルター \'{$a}\' を変換できません。';
$string['filternotvalid'] = 'フィルタはfilter_baseのサブクラスである必要があります。';
$string['filtersbutton'] = 'フィルタサイドバーを表示 / 非表示';
$string['filtershelp'] = 'フィルター';
$string['filtershelp_help'] = '自動的に適用されませんが、ユーザが利用できるフィルタの一覧です。';
$string['filterstab'] = 'フィルター';
$string['format'] = 'フォーマット';
$string['fullnamewithlink'] = 'リンク付きフルネーム';
$string['fullnamewithpicture'] = 'アイコン付きフルネーム';
$string['fullnamewithpicturelink'] = 'アイコン・リンク付きフルネーム';
$string['gotocorerb'] = 'カスタムレポートへ移動';
$string['hascurrentjobs'] = '現在のジョブ';
$string['hassystemrole'] = '割り当てられたシステムロール';
$string['importaudiencelogerror'] = '聴講者記録をインポートできませんでした';
$string['importaudiencelogsuccess'] = 'インポートされた聴講者記録';
$string['importexportreportdefinition'] = 'レポートの定義';
$string['importexportreportdefinition_help'] = 'レポートの列、条件、フィルターを含みます';
$string['importlogconversionfailure'] = 'インポートされたカスタムレポート \'{$a->name}\' は古いバージョンのレポートビルダーで作成されており、自動変換できませんでした。手動での変換を行うには、<a href="{$a->url}">レポートビルダー</a> のページにアクセスしてください: \'{$a->message}\'';
$string['importlogconversionsuccess'] = 'インポートされたカスタムレポート \'{$a->name}\' は、古いバージョンのレポートビルダーから変換されました。';
$string['importlogerror'] = 'レポート \'{$a}\' をインポートできませんでした。';
$string['importlogerrorinvalidaudience'] = 'オーディエンスが存在しないか無効です';
$string['importlogerrorinvalidformat'] = 'スケジュール形式がないか無効です';
$string['importlogerrorinvalidsource'] = 'レポートソースがないか無効です';
$string['importlogerrorinvalidtype'] = '無効なレポートタイプ';
$string['importlogerrorlegacyemails'] = 'スケジュールの受信者としてメールアドレスの使用はサポートされなくなりました。';
$string['importlogerrorlegacyemailsimport'] = 'メールアドレスなしでインポート';
$string['importlogerrorlegacyemailslog'] = 'スケジュールの受信者としてメールアドレスの使用はサポートされなくなりました。詳細は<a href="{$a->docslink}">アップグレードノート</a>を参照してください。';
$string['importlogerrornorecipients'] = 'スケジュールの受信者が存在しないか無効です';
$string['importlogsuccess'] = '{$a->columncount} 列、{$a->conditioncount} 条件、{$a->filtercount} フィルターを含む新しいレポート \'<a href="{$a->url}">{$a->name}</a>\' を作成しました';
$string['importschedulelogerror'] = 'スケジュールレコードをインポートできませんでした';
$string['importschedulelogsuccess'] = 'インポートされたスケジュールレコード';
$string['importselectall'] = 'すべてのカスタムレポートをインポートする';
$string['importselectlimit'] = '特定のカスタムレポートをインポートする...';
$string['invalidcolumn'] = '無効な列';
$string['invalidcondition'] = '無効な条件';
$string['invalidemail'] = 'このメールアドレス \'{$a}\' は無効です';
$string['invalidfilter'] = '無効なフィルタ';
$string['ismemberofcohort'] = 'コーホートのメンバー';
$string['isnotempty'] = '空白ではない';
$string['lastcourseaccess'] = '最終コースアクセス';
$string['lastmodified'] = '最終更新日';
$string['lastsenton'] = '最終送信日';
$string['legacyreportsview'] = 'レポートを表示';
$string['legacyreportswarning'] = '一部のレポートが最新バージョンに変換されていません。';
$string['lessthanaday'] = '1日未満';
$string['managereports'] = 'カスタムレポートを管理';
$string['manuallyaddedusers'] = '手動で追加されたユーザ';
$string['message'] = 'メッセージ';
$string['modifiedby'] = '最終更新者';
$string['movecolumn'] = '列 {$a} を移動';
$string['movefilter'] = 'フィルタ \'{$a}\' を移動';
$string['movesorting'] = '列 \'{$a}\' の順番並べ替えを変更';
$string['never'] = 'なし';
$string['newaggregationfor'] = '列 \'{$a}\' の新しい総計';
$string['newschedule'] = '新しいスケジュール';
$string['newvaluefor'] = '\'{$a}\' の新しい値';
$string['noaggregation'] = '総計無し';
$string['noaudiences'] = 'オーディエンスがありません。';
$string['noaudiencesalert'] = 'このレポートをスケジュールするには、1 つ以上のオーディエンスを追加する必要があります。「オーディエンス」タブに移動し、少なくとも 1 つのオーディエンスを作成してから続行してください。';
$string['noavailablecohorts'] = '利用可能なコーホートがありません。';
$string['nocolumnsselected'] = 'レポートに列を追加';
$string['noconditions'] = '条件が選択されていません。';
$string['nofilters'] = 'フィルタが選択されていません。';
$string['nosortablecolumns'] = '並べ替え可能な列がまだ追加されていません。';
$string['numberanyvalue'] = '任意の値';
$string['numberbetween'] = '範囲内';
$string['numberequalorgreaterthan'] = 'より大きいか等しい';
$string['numberequalorlessthan'] = 'より小さいか等しい';
$string['numberequalto'] = '等しい';
$string['numbergreaterthan'] = 'より大きいか等しい';
$string['numberisempty'] = '空白';
$string['numberisnotempty'] = '空白ではない';
$string['numberlessthan'] = 'より小さい';
$string['or'] = 'または';
$string['pluginname'] = 'レポートビルダー - 旧バージョン';
$string['preview'] = 'プレビュー';
$string['previewmode'] = 'プレビュービューに切り替え';
$string['privacy:metadata:preference:filters_report'] = 'レポートのユーザフィルタプロパティを保存';
$string['privacy:metadata:reportbuilder'] = 'カスタムレポートについての情報';
$string['privacy:metadata:reportbuilder:name'] = 'レポートの名前';
$string['privacy:metadata:reportbuilder:source'] = 'レポートのデータソース';
$string['privacy:metadata:reportbuilder:tenantid'] = 'レポートが属するテナントのID';
$string['privacy:metadata:reportbuilder:timecreated'] = 'レポートの作成日時';
$string['privacy:metadata:reportbuilder:timemodified'] = 'レポートの最終更新日';
$string['privacy:metadata:reportbuilder:usercreated'] = 'レポートを作成したユーザのID';
$string['privacy:metadata:reportbuilder:usermodified'] = 'レポートを最終更新したユーザのID';
$string['privacy:metadata:reportbuilder_audience'] = 'カスタムレポートのオーディエンスに関する情報';
$string['privacy:metadata:reportbuilder_audience:classname'] = 'このオーディエンスに使用されるクラス';
$string['privacy:metadata:reportbuilder_audience:configdata'] = 'オーディエンスの設定';
$string['privacy:metadata:reportbuilder_audience:reportid'] = 'オーディエンスが属するレポートの ID';
$string['privacy:metadata:reportbuilder_audience:timecreated'] = 'オーディエンスが作成された時間';
$string['privacy:metadata:reportbuilder_audience:timemodified'] = 'オーディエンスが変更された時間';
$string['privacy:metadata:reportbuilder_audience:usercreated'] = 'オーディエンスを作成したユーザの ID';
$string['privacy:metadata:reportbuilder_audience:usermodified'] = 'オーディエンスを変更したユーザの ID';
$string['privacy:metadata:reportbuilder_schedule'] = 'カスタムレポートスケジュールに関する情報';
$string['privacy:metadata:reportbuilder_schedule:format'] = 'スケジュールされたレポートデータ形式';
$string['privacy:metadata:reportbuilder_schedule:lastsenton'] = 'スケジュールの最終送信日時';
$string['privacy:metadata:reportbuilder_schedule:message'] = 'スケジュールされたメッセージの内容';
$string['privacy:metadata:reportbuilder_schedule:name'] = 'スケジュールの名前';
$string['privacy:metadata:reportbuilder_schedule:recurrence'] = 'スケジュールの繰り返し頻度';
$string['privacy:metadata:reportbuilder_schedule:reportid'] = 'スケジュールが属するレポートID';
$string['privacy:metadata:reportbuilder_schedule:scheduled'] = 'スケジュールの開始予定日時';
$string['privacy:metadata:reportbuilder_schedule:subject'] = '件名はスケジュールされたメッセージに含まれています';
$string['privacy:metadata:reportbuilder_schedule:timecreated'] = 'スケジュールの作成日時';
$string['privacy:metadata:reportbuilder_schedule:timemodified'] = 'スケジュールの最終更新日';
$string['privacy:metadata:reportbuilder_schedule:usercreated'] = 'スケジュールを作成したユーザのID';
$string['privacy:metadata:reportbuilder_schedule:usermodified'] = 'スケジュールを最終更新したユーザのID';
$string['privacywarning'] = '警告：メールを追加する前に、法的根拠があるかどうかを確認してください。組織に適用される関連するプライバシー法に準拠しています。';
$string['profiledepartment'] = '部門のプロファイル';
$string['quarter'] = '4分割';
$string['recipients'] = '受信者';
$string['recurrence'] = '再起(recurrence)';
$string['recurrenceannualy'] = '毎年';
$string['recurrencedaily'] = '毎日';
$string['recurrencedailyweekday'] = '毎日-平日';
$string['recurrencedonorepeat'] = '繰り返しなし';
$string['recurrencemonthly'] = '毎月';
$string['recurrenceweekly'] = '毎週';
$string['reg_wpreports'] = 'カスタムレポート ({$a}) の数';
$string['removechedulesuccess'] = 'スケジュールが削除されました。';
$string['removeconditionsuccess'] = '条件 \'{$a}\' が削除されました。';
$string['report'] = 'レポート';
$string['report_access_list'] = '特定のレポートへのアクセス権を持つユーザを一覧表示するシステムレポート';
$string['reportbuilder:edit'] = 'レポート設定を編集';
$string['reportbuilder:read'] = 'レポートを表示';
$string['reportconverted'] = 'レポートは正常に変換されました。';
$string['reportcoursecompletion'] = 'データストアからのコース完了';
$string['reportcourseenrolmentcompletion'] = 'コースの登録と完了';
$string['reportcourseenrolments'] = 'コースの登録';
$string['reportcourseparticipants'] = 'コースの参加者';
$string['reportlimitreachedsite'] = 'このサイトの最大カスタムフィールド数の制限に到達しました。レポートをいくつか削除するか管理者に連絡してください。';
$string['reportlimitreachedtenant'] = 'このサイトでは {$a} カスタムレポートのみ作成できます。レポートをいくつか削除するか管理者に連絡してください。';
$string['reportlimitreachedtitle'] = '制限に達したレポート';
$string['reportlists'] = 'レポート一覧のシステムレポート';
$string['reportliveeditingdisabled'] = 'データの事前可視化は、サイト管理者によって無効にされています<br />「プレビュー」ボタンをクリックして、レポートの内容を確認してください';
$string['reportname'] = 'レポート名';
$string['reportname_help'] = 'レポート名を入力';
$string['reportschedules'] = 'スケジュール一覧のシステムレポート';
$string['reportsource'] = 'レポートソース';
$string['reportsource_help'] = 'レポートのソースは、レポートのデータがどこから来るかを定義します。';
$string['reportstab'] = 'レポート';
$string['reportuserslist'] = 'ユーザ一覧';
$string['resetall'] = 'すべてリセット';
$string['resetallconditions'] = 'すべての条件をリセット';
$string['resetcondition'] = '条件をリセット';
$string['resetfield'] = '\'{$a}\' フィールドをリセット';
$string['resettable'] = 'テーブルをリセット';
$string['rolemanager'] = 'レポートビルダーマネージャ';
$string['rolemanagerdescription'] = '現在のテナント内でカスタムレポートを作成、管理を許可';
$string['saveandcontinue'] = '保存して続行';
$string['schedule'] = 'スケジュール';
$string['scheduleaddedastask'] = 'スケジュールはできるだけ早く送付されます。';
$string['scheduled'] = 'スケジュールされた日';
$string['schedulename'] = 'スケジュール名';
$string['schedulenotifyupgrade'] = 'アップグレードされたレポートのスケジュール';
$string['schedulenotifyupgrademessage'] = '最近のMoodle Workplaceのアップグレードの一環として、レポート「<a href="{$a->reportlink}">{$a->reportname}</a>」のために作成したカスタムレポートスケジュール「{$a->schedulename}」が変更されました。
<br /><br />
セキュリティ上の理由から、Moodle Workplaceでは未登録のユーザのメールアドレスをスケジュールの受信者として使用することがサポートされなくなりました。削除されたメールアドレスは以下の通りです：
<br /><br />
{$a->emails}
<br /><br />
詳細については、<a href="{$a->docslink}">オーディエンスおよびスケジュールのアップグレードノート</a>をご参照ください。';
$string['schedules'] = 'スケジュール';
$string['selectacondition'] = '条件を選択';
$string['selectafilter'] = 'フィルタを選択';
$string['selectaggregation'] = '列 \'{$a}\' の総計を選択';
$string['selectcohorts'] = 'コーホートの選択';
$string['selectcourses'] = 'コースを選択';
$string['selectsource'] = 'レポートソースを選択';
$string['send'] = '送信';
$string['send_schedulestask'] = 'スケジュールを送信';
$string['settings'] = '設定';
$string['shared'] = '共有';
$string['showfirstcolumntitle'] = '最初の列のタイトルを表示';
$string['sidebarbutton'] = 'サイドバーを表示 / 非表示';
$string['sortingshelp'] = '並べ替え';
$string['sortingshelp_help'] = 'デフォルトのレポート並べ替え';
$string['sortingtab'] = '並べ替え';
$string['subject'] = '件名';
$string['tabletab'] = '表';
$string['teststring2'] = 'テスト文字列 2';
$string['timecreated'] = '作成時間';
$string['userconfirmed'] = '登録確認済み';
$string['userpicture'] = 'ユーザ画像';
$string['usersuspended'] = '登録停止中';
$string['userviewreportas'] = '以下のユーザとしてレポートデータを表示';
$string['userviewreportas_help'] = 'レポートデータは、選択したユーザが閲覧した場合と同様に含まれます。空のままにしておくと、現在のユーザがデフォルトとして使用されます。';
$string['userviewreportasnotice'] = 'レポートにはすべてのテナントからのデータが含まれている可能性があります。';
$string['viewconvertedreport'] = '変換されたレポートを表示';
$string['viewreports'] = 'レポートビルダー';
$string['warningonlegacypage'] = '古いバージョンのレポートビルダーを閲覧しています。';
