<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'scheduler', language 'et', version '4.1'.
 *
 * @package     scheduler
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Toiming';
$string['actions'] = 'Toimingud';
$string['addappointment'] = 'Lisa õppijaid';
$string['addcommands'] = 'Lisa ajavahemikke';
$string['addondays'] = 'Lisa kohtumised järgmistel päevadel:';
$string['addsession'] = 'Korduvate ajavahemike lisamine';
$string['addsingleslot'] = 'Ühe ajavahemiku lisamine';
$string['addslot'] = 'Saate ajavahemikke lisada igal ajal.';
$string['addstudenttogroup'] = 'Lisa see õppija kohtumise rühma';
$string['allappointments'] = 'Kõik kohtumised';
$string['allononepage'] = 'Kõik ajavahemikud ühel lehel';
$string['allowgroup'] = 'Eksklusiivne ajavahemik – klõpsake muutmiseks';
$string['alreadyappointed'] = 'Kohtumist ei saa määrata. Ajavahemik on juba täielikult broneeritud.';
$string['appointagroup_help'] = 'Valige, kas soovite kohtumise määrata ainult endale või kogu rühmale.';
$string['appointfor'] = 'Määra kohtumine:';
$string['appointforgroup'] = 'Määra kohtumine: {$a}';
$string['appointingstudent'] = 'Ajavahemiku kohtumine';
$string['appointingstudentinnew'] = 'Uue ajavahemiku kohtumine';
$string['appointment'] = 'Kohtumine';
$string['appointmentmode'] = 'Kohtumise seadistamisrežiim';
$string['appointmentmode_help'] = '<p>Siin saate valida kohtumise läbiviimiseks eri võimalusi. </p>
<p><ul>
<li><strong>"<emph>n</emph> kohtumist selles plaanuris":</strong> Õppija saab selles tegevuses broneerida ainult määratud arvu kohtumisi. Ka siis, kui õpetaja märgib ta nähtuks, ei saa ta rohkem kohtumisi broneerida. Ainus viis õppijale uuesti broneerimisvõimaluse andmiseks on vanade „nähtud“-kirjete kustutamine.</li>
<li><strong>"<emph>n</emph> kohtumist korraga":</strong> Õppija saab broneerida määratud arvu kohtumisi. Kui kohtumine on läbi ja õpetaja on märkinud õppija olekuks „nähtud“, saab õppija edasisi kohtumisi broneerida. Õppija on siiski piiratud <emph>n</emph> „avatud“ (mittenähtud) ajavahemikuga iga antud aja kohta.
</li>
</ul>
</p>';
$string['appointmentno'] = 'Kohtumine {$a}';
$string['appointmentnote'] = 'Kohtumise märkmed (õppijale nähtavad)';
$string['appointments'] = 'Kohtumised';
$string['appointmentsgrouped'] = 'Ajavahemike järgi rühmitatud kohtumised';
$string['appointmentsummary'] = 'Kohtumine {$a->startdate} kell {$a->starttime} – {$a->endtime} õpetajaga {$a->teacher}';
$string['appointsolo'] = 'ainult mina';
$string['appointsomeone'] = 'Lisa uus kohtumine';
$string['areaappointmentnote'] = 'Kohtumise märkmete failid';
$string['areaslotnote'] = 'Ajavahemiku märkmete failid';
$string['areateachernote'] = 'Konfidentsiaalsete märkmete failid';
$string['attendable'] = 'Osaletav';
$string['attendablelbl'] = 'Broneeringukandidaate kokku';
$string['attended'] = 'Osalenud';
$string['attendedlbl'] = 'Osalenud õppijate arv';
$string['attendedslots'] = 'Osaletud ajavahemikud';
$string['availableslots'] = 'Saadaolevad ajavahemikud';
$string['availableslotsall'] = 'Kõik ajavahemikud';
$string['availableslotsnotowned'] = 'Pole omanik';
$string['availableslotsowned'] = 'Omanik';
$string['bookaslot'] = 'Broneeri ajavahemik';
$string['bookingdetails'] = 'Broneeringu üksikasjad';
$string['bookingformoptions'] = 'Broneerimisvorm ja õppija sisestatud andmed';
$string['bookinginstructions'] = 'Broneerimisjuhised';
$string['bookinginstructions_help'] = 'See tekst kuvatakse õppijatele enne broneeringu tegemist. Sellega saate juhendada õppijaid näiteks valikulist sõnumivälja täitma või vajalikke faile üles laadima.';
$string['bookslot'] = 'Ajavahemiku broneerimine';
$string['bookwithteacher'] = 'Õpetaja';
$string['bookwithteacher_help'] = 'Valige kohtumise jaoks õpetaja.';
$string['break'] = 'Paus ajavahemike vahel';
$string['breaknotnegative'] = 'Pausi pikkus ei või olla negatiivne arv';
$string['canbook1appointment'] = 'Selles plaanuris saate broneerida veel ühe kohtumise.';
$string['canbooknappointments'] = 'Selles plaanuris saate broneerida veel {$a} kohtumist.';
$string['canbooknofurtherappointments'] = 'Selles plaanuris ei saa rohkem kohtumisi broneerida.';
$string['canbooksingleappointment'] = 'Selles plaanuris saate broneerida ühe kohtumise.';
$string['canbookunlimitedappointments'] = 'Selles plaanuris saate broneerida kui tahes palju kohtumisi.';
$string['cancelbooking'] = 'Tühista broneering';
$string['chooseexisting'] = 'Vali olemasolev';
$string['choosingslotstart'] = 'Algusaja valimine';
$string['choosingslotstart_help'] = 'Muutke kohtumise algusaega või valige kohtumise algusaeg. Kui kohtumine on vastuolus mõne teise ajavahemikuga, küsitakse teilt,
kas asendada selle ajavahemikuga kõik konfliktis olevad kohtumised. Pange tähele, et uued ajavahemikuparameetrid kirjutavad üle kõik varasemad
sätted.';
$string['comments'] = 'Kommentaarid';
$string['complete'] = 'Broneeritud';
$string['confirmbooking'] = 'Kinnita broneering';
$string['confirmdelete-all'] = 'Sellega kustutate <b>kõik</b> ajavahemikud selles plaanuris. Kustutamist ei saa tagasi võtta. Kas soovite ikkagi jätkata?';
$string['confirmdelete-mine'] = 'Sellega kustutate kõik oma ajavahemikud selles plaanuris. Kustutamist ei saa tagasi võtta. Kas soovite ikkagi jätkata?';
$string['confirmdelete-myunused'] = 'Sellega kustutate kõik oma kasutamata ajavahemikud selles plaanuris. Kustutamist ei saa tagasi võtta. Kas soovite ikkagi jätkata?';
$string['confirmdelete-one'] = 'Kas soovite ajavahemiku kustutada?';
$string['confirmdelete-selected'] = 'Sellega kustutate valitud ajavahemikud. Kustutamist ei saa tagasi võtta. Kas soovite ikkagi jätkata?';
$string['confirmdelete-unused'] = 'Sellega kustutate selles plaanuris kõik kasutamata ajavahemikud. Kustutamist ei saa tagasi võtta. Kas soovite ikkagi jätkata?';
$string['conflictingslots'] = 'Ajavahemikku päeval {$a} ei saa luua, kuna leidub konfliktis olevaid ajavahemikke:';
$string['conflictlocal'] = '{$a->datetime} ({$a->duration} minutit) selles plaanuris';
$string['conflictremote'] = '{$a->datetime} ({$a->duration} minutit) kursusel {$a->courseshortname}, plaanur {$a->schedulername}';
$string['contentformat'] = 'Vorming';
$string['contentformat_help'] = '<p>Ekspordivormingu jaoks on kolm põhivõimalust,
     mis erinevad selle poolest, kuidas mitme kohtumisega ajavahemikke käsitletakse.
     <dl>
         <dt>Üks rida ajavahemiku kohta</dt>:
         <dd>väljundfailis on iga ajavahemiku kohta üks rida. Kui ajavahemikus on mitu
             kohtumist, kuvatakse õppija nime jms asemel marker "(mitu)".</dd>
         <dt>Üks rida kohtumise kohta</dt>:
         <dd>väljundfailis on iga kohtumise kohta üks rida. Kui ajavahemikus on mitu
             kohtumist, kuvatakse see loendis mitu korda (ka andmed korratakse).</dd>
         <dt>Ajavahemike järgi rühmitatud kohtumised</dt>:
         <dd>Kõik ühe ajavahemiku kohtumised rühmitatakse kokku ja neile eelneb päiserida, mis
             näitab, millise ajavahemikuga on tegu. CSV-vormingus väljundfailide korral ei pruugi see valik toimida,
             kuna veergude arv pole püsiv.</dd>
    </dl>
    Nende valikute toimimist saate uurida nupu Eelvaade abil.</p>';
$string['copytomyself'] = 'Saada koopia mulle';
$string['course'] = 'Kursus';
$string['createexport'] = 'Loo ekspordifail';
$string['csvfieldseparator'] = 'CSV-faili väljaeraldaja';
$string['csvformat'] = 'CSV';
$string['cumulatedduration'] = 'Kohtumiste summeeritud kestus';
$string['datatoinclude'] = 'Kaasatavad andmed';
$string['datatoinclude_help'] = 'Valige väljad, mis tuleks eksporti kaasata. Igaüks neist kuvatakse ühes väljundfaili veerus.';
$string['date'] = 'Kuupäev';
$string['datelist'] = 'Ülevaade';
$string['defaultslotduration'] = 'Ajavahemiku vaikekestus';
$string['defaultslotduration_help'] = 'Kohtumiste jaoks määratavate ajavahemike vaikepikkus (minutites)';
$string['deleteallslots'] = 'Kustuta kõik ajavahemikud';
$string['deleteallunusedslots'] = 'Kustuta kasutamata ajavahemikud';
$string['deletecommands'] = 'Kustuta ajavahemikud';
$string['deletedconflictingslots'] = 'Ajavahemikuga {$a} konfliktis olevad ajavahemikud on kustutatud:';
$string['deletemyslots'] = 'Kustuta kõik minu ajavahemikud';
$string['deleteonsave'] = 'Kustuta see kohtumine (vormi salvestamisel)';
$string['deleteselection'] = 'Kustuta valitud ajavahemikud';
$string['deletetheseslots'] = 'Kustuta need ajavahemikud';
$string['deleteunusedslots'] = 'Kustuta minu kasutamata ajavahemikud';
$string['department'] = 'Kust?';
$string['disengage'] = 'Loobu minu kohtumistest';
$string['displayfrom'] = 'Kuva ajavahemik õppijatele alates';
$string['distributetoslot'] = 'Jaota kogu rühmale';
$string['divide'] = 'Kas soovite jagada ajavahemikeks?';
$string['duration'] = 'Kestus';
$string['durationrange'] = 'Ajavahemiku kestus peab olema {$a->min}–{$a->max} minutit.';
$string['editbooking'] = 'Muuda broneeringut';
$string['email_applied_html'] = '<p>Taotletud on kohtumist {$a->date} kell {$a->time},<br/>
taotles õppija <a href="{$a->attendee_url}">{$a->attendee}</a>, kursus

<p>{$a->course_short}: <a href="{$a->course_url}">{$a->course}</a>,</p>

<p>plaanuris „<em><a href="{$a->scheduler_url}">{$a->module}</a></em>“ veebisaidil <a href="{$a->site_url}">{$a->site}</a>.</p>';
$string['email_applied_plain'] = 'Taotletud on kohtumist {$a->date} kell {$a->time},
taotles õppija {$a->attendee}, kursus

{$a->course_short}: {$a->course},

plaanuris „{$a->module}“ veebisaidil {$a->site}.';
$string['email_applied_subject'] = '{$a->course_short}: Uus kohtumine';
$string['email_cancelled_html'] = '<p>Teie kohtumine <strong>{$a->date}</strong> kell <strong>{$a->time}</strong><br/>
õppijaga <strong><a href="{$a->attendee_url}">{$a->attendee}</a></strong>, kursus</p>

<p><strong>{$a->course_short}: <a href="{$a->course_url}">{$a->course}</a></strong>,</p>

<p>plaanuris „<em><a href="{$a->scheduler_url}">{$a->module}</a></em>“ veebisaidil <strong><a href="{$a->site_url}">{$a->site}</a></strong></p>

<p><strong><span class="error">on tühistatud või mujale nihutatud</span></strong>.</p>';
$string['email_cancelled_plain'] = 'Teie kohtumine {$a->date} kell {$a->time}
õppijaga {$a->attendee}, kursus

{$a->course_short}: {$a->course},

plaanuris „{$a->module}“ veebisaidil {$a->site}

on tühistatud või mujale nihutatud.';
$string['email_cancelled_subject'] = '{$a->course_short}: Õppija on kohtumise tühistanud või mujale nihutanud';
$string['email_invite_html'] = '<p>Valige kohtumiseks ajavahemik plaanuris</p> <p>{$a->scheduler_url}</p>';
$string['email_invite_subject'] = 'Kutse: {$a->module}';
$string['email_invitereminder_html'] = '<p>See on meeldetuletus, et te pole veel kohtumist määranud. Valige võimalikult kiiresti ajavahemik plaanuris</p><p>{$a->scheduler_url}</p>';
$string['email_invitereminder_subject'] = 'Meeldetuletus: {$a->module}';
$string['email_reminder_html'] = '<p>Teil on ees kohtumine <strong>{$a->date}</strong>
kell <strong>{$a->time}</strong>–<strong>{$a->endtime}</strong><br/>
kasutajaga <strong><a href="{$a->attendant_url}">{$a->attendant}</a></strong>.</p>

<p>Asukoht: <strong>{$a->location}</strong></p>';
$string['email_reminder_plain'] = 'Teil on ees kohtumine
 {$a->date} kell {$a->time}–{$a->endtime}
isikuga {$a->attendant}.

Asukoht: {$a->location}';
$string['email_reminder_subject'] = '{$a->course_short}: Kohtumise meeldetuletus';
$string['email_teachercancelled_html'] = '<p>Teie kohtumine <strong>{$a->date}</strong> kell <strong>{$a->time}</strong><br/>
isikuga {$a->staffrole}<strong><a href="{$a->attendant_url}">{$a->attendant}</a></strong>, kursus</p>

<p><strong>{$a->course_short}: <a href="{$a->course_url}">{$a->course}</a></strong>,</p>

<p>plaanuris „<em><a href="{$a->scheduler_url}">{$a->module}</a></em>“ veebisaidil <strong><a href="{$a->site_url}">{$a->site}</a></strong></p>

<p><strong><span class="error">on tühistatud</span></strong>. Taotlege uut ajavahemikku.</p>';
$string['email_teachercancelled_plain'] = 'Teie kohtumine {$a->date} kell {$a->time}
isikuga {$a->staffrole}{$a->attendant}, kursus

{$a->course_short}: {$a->course},

plaanuris „{$a->module}“ veebisaidil {$a->site}

on tühistatud. Taotlege uut ajavahemikku.';
$string['email_teachercancelled_subject'] = '{$a->course_short}: Õpetaja tühistas kohtumise';
$string['emailreminder'] = 'Saada meili teel meeldetuletus';
$string['emailreminderondate'] = 'Saada meili teel meeldetuletus kuupäeval';
$string['end'] = 'Lõpeta';
$string['enddate'] = 'Korda ajavahemikke kuni';
$string['event_appointmentlistviewed'] = 'Plaanuri kohtumisteloendit on vaadatud';
$string['event_bookingadded'] = 'Broneering on plaanurisse lisatud';
$string['event_bookingformviewed'] = 'Plaanuri broneerimisvormi on vaadatud';
$string['event_bookingremoved'] = 'Broneering on plaanurist eemaldatud';
$string['event_slotadded'] = 'Ajavahemik on plaanurisse lisatud';
$string['event_slotdeleted'] = 'Ajavahemik on plaanurist kustutatud';
$string['everyone'] = 'Kõik';
$string['excelformat'] = 'Excel';
$string['exclusive'] = 'Eksklusiivne';
$string['exclusivity'] = 'Eksklusiivsus';
$string['exclusivity_help'] = '<p>Saate piirata õppijate arvu, kes saavad seda ajavahemikku taotleda. </p>
<p>Kui määrate piirarvuks 1 (vaikeväärtus), on ajavahemik ainult ühele õppijale.</p>
<p>Kui määrate piirarvuks näiteks 3, saab seda ajavahemikku broneerida kuni kolm õppijat.</p>
<p>Kui see säte on keelatud, saab ajavahemikku broneerida piiramatul arvul õppijaid, see ei saa kunagi „täis“.</p>';
$string['exclusivityoverload'] = 'Ajavahemikus on {$a} määratud õppijat – rohkem, kui see säte lubab.';
$string['exclusivitypositive'] = 'Õppijate arv ajavahemiku kohta peab olema vähemalt 1.';
$string['explaingeneralconfig'] = 'Neid valikuid saab häälestada ainult õpikeskkonna tasemel ja need rakendatakse Moodle’i selle installi kõigile plaanuritele.';
$string['export'] = 'Ekspordi';
$string['exporthdr'] = 'Ekspordi ajavahemikud ja kohtumised';
$string['field-appointmentnote'] = 'Kohtumise märge (õppijale)';
$string['field-attended'] = 'Osalenud';
$string['field-date'] = 'Kuupäev';
$string['field-endtime'] = 'Lõpuaeg';
$string['field-filecount'] = 'Üleslaaditud failide arv';
$string['field-grade'] = 'Hinne';
$string['field-location'] = 'Asukoht';
$string['field-maxstudents'] = 'Õppijate maksimumarv';
$string['field-slotnotes'] = 'Ajavahemiku märkmed';
$string['field-starttime'] = 'Algusaeg';
$string['field-studentemail'] = 'Õppija meiliaadress';
$string['field-studentfirstname'] = 'Õppija eesnimi';
$string['field-studentfullname'] = 'Õppija täisnimi';
$string['field-studentidnumber'] = 'Õppija ID';
$string['field-studentlastname'] = 'Õppija perekonnanimi';
$string['field-studentnote'] = 'Sõnum õppijalt';
$string['field-studentusername'] = 'Õppija kasutajanimi';
$string['field-teachernote'] = 'Konfidentsiaalne märge (ainult õpetaja)';
$string['fileformat'] = 'Failivorming';
$string['fileformat_help'] = 'Saadaval on järgmised failivormingud.
     <ul>
          <li>Komaeraldusega tekstifailid (CSV). Väljaeraldaja (vaikimisi on selleks koma) saate valida altpoolt.
               CSV-faile saab avada enamikus tabelarvutusrakendustes;</li>
          <li>Microsoft Exceli failid (Excel 2007 vorming);</li>
          <li>OpenDocumenti arvutustabelid (ODS);</li>
          <li>HTML-vorming – veebileht, kus kuvatakse väljundtabel
                ja mille saab brauseri printimisfunktsiooni abil välja printida;</li>
          <li>PDF-dokumendid. Saate valida horisontaal- või vertikaalpaigutuse.</li>
     </ul>';
$string['finalgrade'] = 'Lõpphinne';
$string['firstslotavailable'] = 'Esimene ajavahemik avatakse {$a}';
$string['forbidgroup'] = 'Rühma ajavahemik – klõpsake muutmiseks';
$string['forcewhenoverlap'] = 'Sunni kattumise korral';
$string['forcewhenoverlap_help'] = '<h3>Ajavahemiku loomise sundimine ajavahemike kattumise korral</h3>
<p>See säte määratleb, kuidas toimitakse uute ajavahemikega juhul, kui need kattuvad juba olemasolevate ajavahemikega.</p>
<p>Kui see säte on lubatud, kustutatakse olemasolev kattuv ajavahemik ja luuakse uus ajavahemik.</p>
<p>Kui see säte on keelatud, jäetakse olemasolev kattuv ajavahemik alles ja uut ajavahemikku <em>ei</em> looda.</p>';
$string['forcewhenoverlap_link'] = 'mod/scheduler/conflict';
$string['forcourses'] = 'Õppijate valimine kursustel';
$string['friday'] = 'reede';
$string['generalconfig'] = 'Üldine konfiguratsioon';
$string['grade'] = 'Hinne';
$string['gradeingradebook'] = 'Hinne hinnetelehel';
$string['gradingstrategy'] = 'Hindamisstrateegia';
$string['gradingstrategy_help'] = 'Valige, kuidas koondatakse hinded plaanuris, kus õppijatel saab olla mitu kohtumist.
    Hinnetelehel saab kuvada kas <ul><li>keskmise hinde või</li><li>maksimumhinde,</li></ul> mille õppija on saavutanud.';
$string['group'] = 'rühm';
$string['groupbookings'] = 'Broneerimine rühmades';
$string['groupbookings_help'] = 'Saate lubada õppijatel broneerida ajavahemiku kõigile oma rühma liikmetele.
(Pange tähele, et see on eraldi sättest Rühmarežiim, mis kontrollib seda, millised ajavahemikud õppijale kuvatakse.)';
$string['groupbreakdown'] = 'Rühma suuruse järgi';
$string['groupmodeyourgroups'] = 'Rühmarežiim: {$a->groupmode} Teiega saavad kohtumisi broneerida ainult rühma {$a->grouplist} õppijad.';
$string['groupmodeyourgroupsempty'] = 'Rühmarežiim: {$a->groupmode} Te pole ühegi rühma liige, seepärast ei saa õppijad teiega kohtumisi broneerida.';
$string['groupscheduling'] = 'Luba rühmabroneeringud';
$string['groupscheduling_desc'] = 'Saate lubada broneerida terve rühma korraga.
(Eraldi üldisest valikust peab säte „Broneerimine rühmades“ olema vastavas plaanuris lubatud.)';
$string['groupsession'] = 'Rühmaseanss';
$string['groupsize'] = 'Rühma suurus';
$string['guardtime'] = 'Kaitstud aeg';
$string['guardtime_help'] = 'Kaitstud aeg ei lase õppijatel broneeringut vahetult enne kohtumist muuta.
<p>Kui kaitstud ajaks on määratud näiteks 2 tundi, ei saa õppijad broneerida ajavahemikku, mis algab praegusest ajahetkest vähem kui kahe tunni pärast,
ega loobuda kohtumisest, kui see algab vähem kui kahe tunni pärast.</p>';
$string['guestscantdoanything'] = 'Külalised ei saa siin midagi teha.';
$string['howtoaddstudents'] = 'Üldisesse plaanurisse õppijate lisamiseks kasutage mooduli rollisätet.<br/>Mooduli rollimääratlusi saate kasutada ka oma õppijate osalejate määratlemiseks.';
$string['htmlformat'] = 'HTML';
$string['ignoreconflicts'] = 'Eira broneeringukonflikte';
$string['ignoreconflicts_help'] = 'Kui see ruut on märgitud, teisaldatakse ajavahemik taotletud kuupäevale ja kellaajale isegi siis, kui samaks ajaks on määratud veel ajavahemikke. Selle tagajärjeks võivad olla mõne õppija või õpetaja kattuvad kohtumised ja seetõttu tuleks seda võimalust kasutada ettevaatlikult.';
$string['ignoreconflicts_link'] = 'mod/scheduler/conflict';
$string['includeemptyslots'] = 'Kaasa tühjad ajavahemikud';
$string['includeslotsfor'] = 'Kaasa ajavahemikud:';
$string['incourse'] = 'kursusel';
$string['introduction'] = 'Sissejuhatus';
$string['isnonexclusive'] = 'Mitteeksklusiivne';
$string['landscape'] = 'Horisontaalpaigutus';
$string['lengthbreakdown'] = 'Ajavahemiku kestuse järgi';
$string['limited'] = 'Piiratud (alles {$a})';
$string['location'] = 'Asukoht';
$string['location_help'] = 'Määrake kohtumise plaanitud asukoht.';
$string['markasseennow'] = 'Märgi nähtuks kohe';
$string['markseen'] = 'Kui teil on olnud õppijaga kohtumine, klõpsake tema profiilipildi lähedal olevat märkeruutu ja märkige kohtumine toimunuks.';
$string['maxgrade'] = 'Võta kõrgeim hinne';
$string['maxstudentlistsize'] = 'Õppijate loendi maksimumpikkus';
$string['maxstudentlistsize_desc'] = 'Õppijate, kellel on vaja määrata kohtumine, loendi maksimaalne pikkus plaanuri õpetajavaates. Kui õppijaid on sellest rohkem, siis loendit ei kuvata.';
$string['maxstudentsperslot'] = 'Õppijate maksimumarv ajavahemiku kohta';
$string['maxstudentsperslot_desc'] = 'Rühma ajavahemikes / mitteeksklusiivsetes ajavahemikes saab olla kõige rohkem nii palju õppijaid. Pange tähele, et ajavahemiku kohta saab alati valida ka sätte „piiramatu“.';
$string['meangrade'] = 'Võta keskmine hinne';
$string['meetingwith'] = 'Kohtumine kasutajaga';
$string['meetingwithplural'] = 'Kohtumine kasutajaga';
$string['message'] = 'Sõnum';
$string['messagebody'] = 'Sõnumi sisu';
$string['messageprovider:bookingnotification'] = 'Kutse esitamise või tühistamise teavitus';
$string['messageprovider:invitation'] = 'Ajavahemiku broneerimise kutse';
$string['messageprovider:reminder'] = 'Eelseisva kohtumise meeldetuletus';
$string['messagesent'] = 'Sõnum saadeti {$a} adressaadile';
$string['messagesubject'] = 'Teema';
$string['minutes'] = 'minutit';
$string['minutesperslot'] = 'minutit ajavahemiku kohta';
$string['missingstudents'] = '{$a} õppijat peavad veel kohtumise määrama';
$string['missingstudentsmany'] = '{$a} õppijat peavad veel kohtumise määrama. Mahu tõttu ei kuvata ühtegi loendit.';
$string['mixindivgroup'] = 'Ühenda üksik- ja rühmabroneeringud';
$string['mixindivgroup_desc'] = 'Kui rühmabroneeringud on lubatud, luba ka üksikbroneeringud.';
$string['mode'] = 'Režiim';
$string['modeappointments'] = 'kohtumise/kohtumist';
$string['modeintro'] = 'Õppijad saavad registreerida';
$string['modeoneatatime'] = 'korraga';
$string['modeoneonly'] = 'selles plaanuris';
$string['modulename'] = 'Plaanur';
$string['modulename_help'] = 'Plaanuri abil saate plaanida kohtumisi õppijatega.

Õpetajad määravad kohtumiste jaoks ajavahemikud ja õppijad valivad Moodle’is neist ühe.
Õpetajad saavad plaanuris salvestada kohtumise tulemuse ja soovi korral ka hinde.

Saab teha rühmabroneeringuid, see tähendab, et igasse ajavahemikku saab paigutada mitu õppijat ja soovi korral saab kohtumise määrata kogu rühmale korraga.';
$string['modulename_link'] = 'mod/scheduler/view';
$string['modulenameplural'] = 'Plaanurid';
$string['monday'] = 'esmaspäev';
$string['multiple'] = '(mitu)';
$string['myappointments'] = 'Minu kohtumised';
$string['myself'] = 'Mina ise';
$string['name'] = 'Plaanuri nimi';
$string['needteachers'] = 'Ajavahemikke ei saa lisada, sest sellel kursusel pole õpetajaid';
$string['negativerange'] = 'Vahemik on negatiivne. Nii ei tohi olla.';
$string['never'] = 'Mitte kunagi';
$string['nfiles'] = '{$a} faili';
$string['noappointments'] = 'Kohtumisi pole';
$string['noexistingstudents'] = 'Broneerimiseks pole õppijaid saadaval';
$string['nogroups'] = 'Broneerimiseks pole rühmi saadaval';
$string['noresults'] = 'Tulemeid pole.';
$string['noschedulers'] = 'Plaanureid pole.';
$string['noslots'] = 'Saadaolevaid ajavahemikke pole.';
$string['noslotsavailable'] = 'Praegu pole broneerimiseks ajavahemikke saadaval.';
$string['noslotsopennow'] = 'Praegu pole broneerimiseks avatud ajavahemikke.';
$string['nostudents'] = 'Broneerinud õppijaid pole';
$string['nostudenttobook'] = 'Broneerimiseks pole õppijaid';
$string['note'] = 'Hinne';
$string['noteacherforslot'] = 'Ajavahemiku jaoks pole õpetajat';
$string['noteachershere'] = 'Õpetajaid pole saadaval';
$string['notenoughplaces'] = 'Kahjuks pole selles ajavahemikus piisavalt vabu kohtumisaegu.';
$string['notesrequired'] = 'Enne ajavahemiku broneerimist peate sisestama sellele väljale teksti.';
$string['notifications'] = 'Teatised';
$string['notifications_help'] = 'Kui see valik on lubatud, saadetakse õpetajatele ja õppijatele kohtumiste taotlemise või tühistamise korral teavitused.';
$string['notseen'] = 'Pole nähtud';
$string['now'] = 'Kohe';
$string['occurrences'] = 'Ilmnemised';
$string['odsformat'] = 'ODS';
$string['on'] = 'sees';
$string['onedaybefore'] = '1 päev enne ajavahemikku';
$string['onelineperappointment'] = 'Üks rida kohtumise kohta';
$string['onelineperslot'] = 'Üks rida ajavahemiku kohta';
$string['oneslotadded'] = '1 ajavahemik on lisatud';
$string['oneslotdeleted'] = '1 ajavahemik on kustutatud';
$string['oneweekbefore'] = '1 nädal enne ajavahemikku';
$string['onthemorningofappointment'] = 'Kohtumispäeva hommikul';
$string['options'] = 'Valikud';
$string['otherstudents'] = 'Teised osalejad';
$string['outlineappointments'] = 'Osaletud {$a->attended} kohtumisel, tulemas {$a->upcoming}.';
$string['outlinegrade'] = 'Hinne: {$a}';
$string['overall'] = 'Üldine';
$string['overlappings'] = 'Mõned teised ajavahemikud kattuvad';
$string['pageperteacher'] = 'Üks leht iga kasutaja {$a} jaoks';
$string['pagination'] = 'Lehtede jaotus';
$string['pagination_help'] = 'Saate valida, kas eksport peaks sisaldama iga õpetaja jaoks eraldi lehte.
   Exceli ja ODS-i failivormingutes vastavad need lehed töövihiku vahelehtedele (töölehtedele).';
$string['pdfformat'] = 'PDF';
$string['pdforientation'] = 'PDF-vormingus lehe paigutus';
$string['pluginadministration'] = 'Plaanuri haldus';
$string['pluginname'] = 'Plaanur';
$string['portrait'] = 'Vertikaalpaigutus';
$string['preview'] = 'Eelvaade';
$string['previewlimited'] = '(Eelvaate pikkus on piiratud {$a} reaga.)';
$string['purgeunusedslots'] = 'Kustuta mineviku kasutamata ajavahemikud';
$string['recipients'] = 'Adressaat';
$string['registeredlbl'] = 'Määratud õppijad';
$string['reminder'] = 'Meeldetuletus';
$string['requireupload'] = 'Nõutav on faili üleslaadimine';
$string['resetappointments'] = 'Kustuta kohtumised ja hinded';
$string['resetslots'] = 'Kustuta plaanuri ajavahemikud';
$string['return'] = 'Tagasi kursusele';
$string['revoke'] = 'Tühista kohtumine';
$string['saturday'] = 'laupäev';
$string['save'] = 'Salvesta';
$string['savechoice'] = 'Salvesta minu küsitlus';
$string['saveseen'] = 'Salvesta nähtud';
$string['schedule'] = 'Ajasta';
$string['scheduleappointment'] = 'Määra kohtumine ajaks {$a}';
$string['schedulecancelled'] = '{$a}: Teie kohtumine on tühistatud või mujale nihutatud';
$string['schedulegroups'] = 'Ajasta rühma kaupa';
$string['scheduleinnew'] = 'Ajasta uues ajavahemikus';
$string['scheduleinslot'] = 'Ajasta ajavahemikus';
$string['scheduler'] = 'Plaanur';
$string['scheduler:addinstance'] = 'Uue plaanuri lisamine';
$string['scheduler:appoint'] = 'Ajavahemike broneerimine';
$string['scheduler:attend'] = 'Õppijate lisamine';
$string['scheduler:canscheduletootherteachers'] = 'Kohtumiste ajastamine teiste töötajate jaoks';
$string['scheduler:canseeotherteachersbooking'] = 'Teiste õpetajate broneeringute vaatamine ja sirvimine';
$string['scheduler:disengage'] = 'See tegevusluba on iganenud ega tee midagi';
$string['scheduler:manage'] = 'Ajavahemike ja kohtumiste haldus';
$string['scheduler:manageallappointments'] = 'Plaanuri kõigi andmete haldus';
$string['scheduler:seeotherstudentsbooking'] = 'Kuva teised selle ajavahemiku broneerinud õppijad';
$string['scheduler:seeotherstudentsresults'] = 'Kuva ajavahemiku teise õppija tulemused';
$string['scheduler:seeoverviewoutsideactivity'] = 'Praegusest plaanuritegevusest väljaspool olevaid ajavahemikke saate vaadata ülevaatekuval.';
$string['scheduler:viewfullslots'] = 'Kuva ka täielikult broneeritud ajavahemikud (õppija kuval)';
$string['scheduler:viewslots'] = 'Kuva broneerimiseks vabad ajavahemikud (õppija kuval)';
$string['schedulestudents'] = 'Ajasta õppija kaupa';
$string['scopemenu'] = 'Kuva ajavahemikud: {$a}';
$string['scopemenuself'] = 'Kuva minu ajavahemikud: {$a}';
$string['search:activity'] = 'Plaanur – tegevuse teave';
$string['seen'] = 'Nähtud';
$string['selectedtoomany'] = 'Olete valinud liiga palju ajavahemikke. Valida saab kuni {$a}.';
$string['sendinvitation'] = 'Saada kutse';
$string['sendmessage'] = 'Saada sõnum';
$string['sendreminder'] = 'Saada meeldetuletus';
$string['sendreminders'] = 'Saada eesolevate kohtumiste kohta meili teel meeldetuletused';
$string['sepcolon'] = 'Koolon';
$string['sepcomma'] = 'Koma';
$string['sepsemicolon'] = 'Semikoolon';
$string['septab'] = 'Tabulaator';
$string['showemailplain'] = 'Kuva meiliaadressid lihttekstina';
$string['showemailplain_desc'] = 'Plaanuri õpetajavaates saate kohtumist vajavate õppijate meiliaadressid kuvada lisaks linkidele „mailto:“ ka lihttekstina.';
$string['showparticipants'] = 'Kuva osalejad';
$string['slot'] = 'Ajavahemik';
$string['slot_is_just_in_use'] = 'Kahjuks valis selle kohtumisaja äsja üks teine õpilane. Proovige uuesti.';
$string['slotdatetime'] = '{$a->shortdatetime} {$a->duration} minutit';
$string['slotdatetimelabel'] = 'Kuupäev ja kellaaeg';
$string['slotdatetimelong'] = '{$a->date} {$a->starttime}–{$a->endtime}';
$string['slotdescription'] = '{$a->status} kuupäeval {$a->startdate} kell {$a->starttime}–{$a->endtime} kohas {$a->location} juhendajaga {$a->facilitator}.';
$string['slots'] = 'Ajavahemikud';
$string['slotsadded'] = '{$a} ajavahemikku on lisatud';
$string['slotsdeleted'] = '{$a} ajavahemikku on kustutatud';
$string['slottype'] = 'Ajavahemiku tüüp';
$string['slotupdated'] = '1 ajavahemik on värskendatud';
$string['slotwarning'] = '<strong>Hoiatus.</strong> Selle ajavahemiku teisaldamine valitud ajale tekitab konflikti allpool loetletud ajavahemikega. Kui soovite ajavahemiku ikkagi teisaldada, märkige ruut „Eira broneeringukonflikte“.';
$string['staffbreakdown'] = 'Alus: {$a}';
$string['staffrolename'] = 'Õpetaja rolli nimi';
$string['staffrolename_help'] = 'Õppijaid lisava rolli silt. See ei pea olema „õpetaja“.';
$string['start'] = 'Alusta';
$string['startpast'] = 'Tühja kohtumise ajavahemikku ei saa alustada minevikus.';
$string['statistics'] = 'Statistika';
$string['student'] = 'Õppija';
$string['studentbreakdown'] = 'Õppija kaupa';
$string['studentcomments'] = 'Õppija sõnum';
$string['studentdetails'] = 'Õppija üksikasjad';
$string['studentfiles'] = 'Üleslaaditud failid';
$string['studentmultiselect'] = 'Iga õppijat saab valida selles ajavahemikus ainult üks kord.';
$string['studentnote'] = 'Sõnum õppijalt';
$string['studentprovided'] = 'Õppija sisestatud: {$a}';
$string['students'] = 'Õppijad';
$string['sunday'] = 'pühapäev';
$string['tab-otherappointments'] = 'Kõik selle õppija kohtumised';
$string['tab-otherstudents'] = 'Õppijad selles ajavahemikus';
$string['tab-thisappointment'] = 'See kohtumine';
$string['teacher'] = 'Õpetaja';
$string['teachernote'] = 'Konfidentsiaalsed märkmed (nähtavad ainult õpetajale)';
$string['teachersmenu'] = 'Kuva ajavahemikud: {$a}';
$string['thiscourse'] = 'see kursus';
$string['thisscheduler'] = 'see plaanur';
$string['thissite'] = 'kogu õpikeskkond';
$string['thursday'] = 'neljapäev';
$string['timefrom'] = 'Alates:';
$string['timerange'] = 'Ajavahemik';
$string['timeto'] = 'Kuni:';
$string['totalgrade'] = 'Koguhinne';
$string['tuesday'] = 'teisipäev';
$string['unattended'] = 'Osalemata';
$string['unlimited'] = 'Piiramatu';
$string['unregisteredlbl'] = 'Määramata õppijad';
$string['upcomingslots'] = 'Tulevased ajavahemikud';
$string['updategrades'] = 'Värskenda hinded';
$string['updatesingleslot'] = '';
$string['uploadmaxfiles'] = 'Üleslaaditavate failide maksimumarv';
$string['uploadmaxfiles_help'] = 'Maksimaalne arv faile, mille õppija saab broneerimisvormil üles laadida. Kui ruut „Nõutav on faili üleslaadimine“ on märkimata, on failide üleslaadimine valikuline. Kui väärtuseks on määratud 0, ei kuvata õppijale failide üleslaadimisvälja.';
$string['uploadmaxfilesglobal'] = 'Üleslaaditavate failide maksimumarv';
$string['uploadmaxfilesglobal_desc'] = 'Maksimaalne arv faile, mille õppija saab sellel broneerimisvormil üles laadida. Üksikbroneeringute plaanurite tasandil saab seda arvu veelgi vähendada.';
$string['uploadmaxsize'] = 'Faili maksimummaht';
$string['uploadmaxsize_help'] = 'Õppijate üleslaaditavate failide maksimummaht. See piirang kehtib iga faili kohta eraldi.';
$string['uploadrequired'] = 'Enne ajavahemiku broneerimist peate siin failid üles laadima.';
$string['uploadstudentfiles'] = 'Laadi failid üles';
$string['usebookingform'] = 'Kasuta broneerimisvormi';
$string['usebookingform_help'] = 'Kui see säte on lubatud, näeb õppija eraldi broneerimiskuva, enne kui ta saab ajavahemiku broneerida. Sellel broneerimiskuval võidakse õppijalt nõuda andmete sisestamist, failide üleslaadimist või robotilõksu lahendamist (vt valikuid ülaltpoolt).';
$string['usebookingform_link'] = 'mod/scheduler/bookingform';
$string['usecaptcha'] = 'Kasuta uute broneeringute puhul robotilõksu';
$string['usecaptcha_help'] = 'Kui see säte on lubatud, peavad õppijad enne uue broneeringu tegemist lahendama robotilõksu turbeülesande.
Kasutage seda sätet juhul, kui kahtlustate, et õppijad kasutavad saadaolevate ajavahemike äranapsamiseks automaatprogramme.
<p>Kui õppija muudab olemasolevat broneeringut, siis robotilõksu ei kuvata.</p>';
$string['usenotes'] = 'Kasuta kohtumiste jaoks märkmeid';
$string['usenotesboth'] = 'Mõlemad märkmetüübid';
$string['usenotesnone'] = 'pole';
$string['usenotesstudent'] = 'Kohtumise märge, nähtav nii õpetajale kui ka õppijale';
$string['usenotesteacher'] = 'Konfidentsiaalne märge, nähtav ainult õpetajatele';
$string['usestudentnotes'] = 'Lase õppijal sisestada sõnum';
$string['usestudentnotes_help'] = 'Kui see säte on lubatud, sisaldab broneerimiskuva tekstivälja, kuhu õppijad saavad sisestada sõnumi. Ülalolevate broneerimisjuhiste abil saate õppijaid juhendada, milline teave sinna tuleks lisada.';
$string['viewbooking'] = 'Kuva üksikasjad';
$string['wednesday'] = 'kolmapäev';
$string['welcomebackstudent'] = 'Lisaajavahemike broneerimiseks klõpsake allpool vastavat nuppu „Broneeri ajavahemik“.';
$string['welcomenewstudent'] = 'Allolevas tabelis on näidatud kõik kohtumise jaoks saadaolevad ajavahemikud. Ajavahemiku valimiseks klõpsake vastavat nuppu „Broneeri ajavahemik“. Vajaduse korral saate sellel lehel hiljem muudatusi teha.';
$string['welcomenewteacher'] = 'Kohtumise jaoks ajavahemike lisamiseks klõpsake allolevat nuppu.';
$string['what'] = 'Mis?';
$string['whathappened'] = 'Mis juhtus?';
$string['whatresulted'] = 'Milline oli tagajärg?';
$string['when'] = 'Millal?';
$string['where'] = 'Kus?';
$string['who'] = 'Kellega?';
$string['whosthere'] = 'Kes seal on?';
$string['xdaysbefore'] = '{$a} päeva enne ajavahemikku';
$string['xweeksbefore'] = '{$a} nädalat enne ajavahemikku';
$string['yesallgroups'] = 'Jah, kõigile rühmadele';
$string['yesingrouping'] = 'Jah, rühmakogumis {$a}';
$string['yesoptional'] = 'Jah, õppijale valikuline';
$string['yesrequired'] = 'Jah, õppija peab sisestama sõnumi';
$string['yourappointmentnote'] = 'Privaatsed kommentaarid';
$string['yourslotnotes'] = 'Koosoleku kommentaarid';
$string['yourstudentnote'] = 'Teie sõnum';
$string['yourtotalgrade'] = 'Teie koguhinne selle tegevuse eest on <strong>{$a}</strong>.';
