<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'kialo', language 'fr', version '4.1'.
 *
 * @package     kialo
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['acceptterms'] = 'Accepter les conditions générales d’utilisation';
$string['acceptterms_desc'] = 'Pour activer le plugin Kialo, vous devez accepter les <a href="{$a->terms}" target="_blank">Conditions générales d’utilisation</a> au nom de tous les utilisateurs de cette instance Moodle. Voici un lien vers notre  <a href="{$a->privacy}" target="_blank">Politique de confidentialité</a> et notre <a href="{$a->data_security}" target="_blank">Plan de sécurité des données et de confidentialité.</a>';
$string['cachedef_nonces'] = 'Utilisé pour stocker des nonces temporaires afin de sécuriser les requêtes LTI.';
$string['close_prompt'] = 'Vous pouvez désormais fermer cette fenêtre.';
$string['discussion_title'] = 'Débat';
$string['errors:deeplinking'] = 'Une erreur est survenue lors de la sélection du débat. Veuillez réessayer.';
$string['errors:invalidrequest'] = 'Demande non valide';
$string['errors:ltiauth'] = 'L’authentification a échoué en raison d’une erreur inattendue. Veuillez réessayer.';
$string['errors:missingcourseid'] = 'Identifiant du cours manquant.';
$string['errors:missingidtoken'] = 'Jeton d’identification manquant.';
$string['errors:missingsessiondata'] = 'Données de session manquantes.';
$string['errors:noguestaccess'] = 'Les invités ne peuvent pas accéder à cette activité. Veuillez vous connecter.';
$string['errors:nopermissiontoview'] = 'Vous n’avez pas la permission de voir cette activité.';
$string['errors:resourcelink'] = 'L’activité ne peut pas être affichée en raison d’une erreur inattendue. Veuillez réessayer.';
$string['kialo:addinstance'] = 'Ajouter un nouveau débat Kialo';
$string['kialo:kialo_admin'] = 'Droits d’administrateur accordés dans les débats Kialo';
$string['kialo:view'] = 'Afficher les débats Kialo';
$string['kialofieldset'] = 'Fieldset Kialo';
$string['kialoname'] = 'Nom de l’activité';
$string['kialosettings'] = 'Paramètres';
$string['kialourl'] = 'URL Kialo';
$string['kialourl_desc'] = 'L’URL de l’instance Kialo à utiliser. Laissez vide pour utiliser l’instance par défaut (edu-prod) ou la valeur de la variable d’environnement TARGET_KIALO_URL.';
$string['modulename'] = 'Débat Kialo';
$string['modulename_help'] = 'L’activité de débat Kialo vous permet d’inclure un débat Kialo dans votre cours Moodle. Les étudiants peuvent participer au débat directement depuis Moodle, sans avoir à créer manuellement de comptes Kialo. Les débats Kialo sont un excellent moyen d’enseigner et de développer la pensée critique, l’argumentation, et de faciliter des débats plus réfléchis en classe.';
$string['modulename_link'] = 'https://support.kialo-edu.com/en/hc/moodle';
$string['modulenameplural'] = 'Débats Kialo';
$string['pluginadministration'] = 'Modifier le débat Kialo';
$string['pluginname'] = 'Débat Kialo';
$string['privacy:metadata:kialo'] = 'Les données utilisateur doivent être échangées avec Kialo Edu afin de créer automatiquement des comptes pour les utilisateurs de Moodle sur kialo-edu.com et de rendre l’expérience utilisateur aussi fluide que possible.';
$string['privacy:metadata:kialo:courseid'] = 'L’identifiant du cours de l’utilisateur.';
$string['privacy:metadata:kialo:email'] = 'L’adresse e-mail est envoyée depuis Moodle pour vous permettre d’accéder à vos données sur Kialo Edu.';
$string['privacy:metadata:kialo:fullname'] = 'Votre nom complet est envoyé à Kialo Edu pour offrir une meilleure expérience utilisateur.';
$string['privacy:metadata:kialo:language'] = 'Votre choix de langue est envoyé à Kialo Edu pour configurer automatiquement la langue de l’interface utilisateur.';
$string['privacy:metadata:kialo:nullproviderreason'] = 'Aucune donnée utilisateur n’est stockée par notre plugin dans la base de données Moodle. Toutes les données que nous utilisons sont stockées de manière externe sur kialo-edu.com.';
$string['privacy:metadata:kialo:picture'] = 'La photo d’avatar de votre compte est envoyée à Kialo Edu pour offrir une meilleure expérience utilisateur.';
$string['privacy:metadata:kialo:role'] = 'Le rôle de l’utilisateur dans le cours est utilisé pour déterminer les permissions appropriées dans le débat Kialo.';
$string['privacy:metadata:kialo:timezone'] = 'Votre fuseau horaire préféré est envoyé à Kialo Edu pour configurer automatiquement le fuseau horaire de l’utilisateur.';
$string['privacy:metadata:kialo:userid'] = 'L’identifiant utilisateur est envoyé depuis Moodle pour vous permettre d’accéder à vos données sur Kialo Edu.';
$string['privacy:metadata:kialo:username'] = 'Le nom de l’utilisateur est envoyé depuis Moodle pour définir le nom d’utilisateur par défaut sur Kialo Edu.';
$string['redirect_loading'] = 'Chargement en cours';
$string['redirect_title'] = 'Chargement en cours';
$string['select_discussion'] = 'Sélectionner un débat';
$string['select_discussion_help'] = 'Ouvre Kialo dans un nouvel onglet pour sélectionner un débat pour cette activité. Vous pouvez créer un compte Kialo au cours de ce processus si vous n’en avez pas encore un.';
$string['termsnotaccepted'] = 'Vous devez accepter les <a href="{$a->terms}" target="_blank">Conditions d’utilisation</a> avant de pouvoir activer le plugin Kialo.';
