<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'forum', language 'fr', version '4.1'.
 *
 * @package     forum
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actionsforgraderinterface'] = 'Action d’interface pour l’évaluateur';
$string['actionsforpost'] = 'Actions sur le message';
$string['activitydate:due'] = 'À terminer :';
$string['activityoverview'] = 'Il y a de nouveaux messages de forum';
$string['addanewdiscussion'] = 'Ajouter une discussion';
$string['addanewquestion'] = 'Ajouter une nouvelle question';
$string['addanewtopic'] = 'Ajouter un nouveau sujet';
$string['addreply'] = 'Ajouter une réponse';
$string['addtofavourites'] = 'Marquer la discussion comme favorite';
$string['advancedsearch'] = 'Recherche avancée';
$string['alldiscussions'] = 'Toutes les discussions';
$string['allforums'] = 'Tous les forums';
$string['allowdiscussions'] = 'Est-ce que {$a} peut poster dans ce forum ?';
$string['allowsallsubscribe'] = 'Tout le monde peut choisir de s’abonner ou non à ce forum';
$string['allowsdiscussions'] = 'Tout le monde peut lancer une nouvelle discussion dans ce forum';
$string['allsubscribe'] = 'S’abonner à tous les forums';
$string['allunsubscribe'] = 'Se désabonner de tous les forums';
$string['allusers'] = 'Tous les utilisateurs';
$string['alreadyfirstpost'] = 'Ce message est déjà le premier de la discussion';
$string['anyfile'] = 'Tout fichier';
$string['areaattachment'] = 'Annexes';
$string['areapost'] = 'Messages';
$string['attachment'] = 'Annexe';
$string['attachment_help'] = 'Il vous est possible de joindre un ou plusieurs fichiers à chaque message que vous postez dans un forum. Si vous joignez une image, elle sera affichée en fin de message.';
$string['attachmentname'] = 'Annexe {$a}';
$string['attachmentnameandfilesize'] = '{$a->name} ({$a->size})';
$string['attachmentnopost'] = 'Vous ne pouvez pas exporter les annexes sans identifiant de message';
$string['attachments'] = 'Annexes';
$string['attachmentswordcount'] = 'Annexes et nombre de mots';
$string['authorreplyingprivatelytoauthor'] = '{$a->respondant} répondant en privé à {$a->author}';
$string['authorreplyingtoauthor'] = '{$a->respondant} répondant à {$a->author}';
$string['availability'] = 'Disponibilité';
$string['blockafter'] = 'Nombre maximal de messages';
$string['blockafter_help'] = 'Ce réglage définit le nombre maximal de messages qu’un participant peut poster durant une période donnée. Les utilisateurs ayant la capacité mod/forum:postwithoutthrottling ne sont pas touchés par les limites de message.';
$string['blockperiod'] = 'Durée de blocage';
$string['blockperiod_help'] = 'Il est possible d’empêcher des participants de poster des messages après qu’ils en ont écrit un certain nombre durant une période donnée. Les utilisateurs ayant la capacité mod/forum:postwithoutthrottling ne sont pas touchés par les limites de message.';
$string['blockperioddisabled'] = 'Ne pas bloquer';
$string['blogforum'] = 'Forum standard affiché comme un blog';
$string['bynameondate'] = 'par {$a->name}, {$a->date}';
$string['cachedef_forum_is_tracked'] = 'Statut de suivi des messages de forum pour l’utilisateur';
$string['calendardue'] = 'Délai de {$a}';
$string['cancelreply'] = 'Annuler la réponse';
$string['cannotadd'] = 'Impossible d’ajouter la discussion dans ce forum';
$string['cannotadddiscussion'] = 'Pour créer une discussion dans ce forum, vous devez être membre de ce groupe.';
$string['cannotadddiscussionall'] = 'Vous n’avez pas les permissions requises pour lancer une nouvelle discussion pour tous les participants.';
$string['cannotadddiscussiongroup'] = 'Vous ne pouvez pas créer de discussion parce que vous n’êtes pas membre d’un groupe ou du groupement.';
$string['cannotaddsubscriber'] = 'Impossible d’abonner à ce forum l’utilisateur d’identifiant {$a} !';
$string['cannotaddteacherforumto'] = 'Impossible d’ajouter le forum des enseignants converti à la section 0 du cours';
$string['cannotcreatediscussion'] = 'Impossible de créer une nouvelle discussion';
$string['cannotcreateinstanceforteacher'] = 'Impossible de créer une nouvelle instance de module de cours pour le forum des enseignants';
$string['cannotdeletepost'] = 'Vous ne pouvez pas supprimer ce message !';
$string['cannoteditposts'] = 'Vous ne pouvez pas modifier les messages d’autres participants !';
$string['cannotexportforum'] = 'Vous ne pouvez pas exporter ce forum';
$string['cannotfavourite'] = 'Vous n’avez pas les permissions requises pour marquer les discussions comme favorites.';
$string['cannotfinddiscussion'] = 'Impossible de trouver cette discussion dans ce forum';
$string['cannotfindfirstpost'] = 'Impossible de trouver le premier message de ce forum';
$string['cannotfindorcreateforum'] = 'Impossible de trouver ou de créer le forum des annonces principal pour ce site';
$string['cannotfindparentpost'] = 'Impossible de trouver le parent ultime du message {$a}';
$string['cannotmovefromsingleforum'] = 'Impossible de déplacer une discussion depuis un forum avec une seule discussion';
$string['cannotmovenotvisible'] = 'Forum non visible';
$string['cannotmovetonotexist'] = 'Vous ne pouvez pas déplacer vers ce forum, qui n’existe pas !';
$string['cannotmovetonotfound'] = 'Le forum de destination n’a pas été trouvé dans ce cours.';
$string['cannotmovetosingleforum'] = 'Impossible de déplacer une discussion vers un forum avec une discussion simple';
$string['cannotpindiscussions'] = 'Vous n’avez pas les permissions requises pour épingler les discussions.';
$string['cannotpurgecachedrss'] = 'Impossible de purger le flux RSS en cache pour le forum source et/ou destination. Veuillez vérifier votre fichier permissionsforums';
$string['cannotremovesubscriber'] = 'Impossible de désabonner de ce forum l’utilisateur d’identifiant {$a} !';
$string['cannotreply'] = 'Vous ne pouvez pas répondre à ce message';
$string['cannotsplit'] = 'Les discussions de ce forum ne peuvent pas être séparées';
$string['cannotsubscribe'] = 'Vous devez être un membre du groupe pour vous abonner.';
$string['cannottrack'] = 'Impossible de stopper le suivi des messages de ce forum';
$string['cannotunsubscribe'] = 'Vous ne pouvez pas vous désabonner de ce forum';
$string['cannotupdatepost'] = 'Vous ne pouvez pas modifier ce message';
$string['cannotuseseperategroupsandsingletopic'] = 'Les groupes séparés ne peuvent pas être utilisés avec une discussion simple unique.';
$string['cannotusesingletopicandseperategroups'] = 'Une discussion simple unique ne peut pas être utilisés avec des groupes séparés';
$string['cannotviewpostyet'] = 'Vous ne pouvez pas lire les messages des autres étudiants, car vous n’avez encore rien écrit.';
$string['cannotviewusersposts'] = 'Il n’y a aucun message de cet utilisateur que vous puissiez consulter.';
$string['cleanreadtime'] = 'Heure de nettoyage des messages lus';
$string['clicktofavourite'] = 'Vous n’avez pas marqué cette discussion comme favorite. Cliquer pour marquer.';
$string['clicktolockdiscussion'] = 'Cliquer pour verrouiller cette discussion';
$string['clicktosubscribe'] = 'Vous n’êtes pas abonné à cette discussion. Cliquez pour vous abonner.';
$string['clicktounfavourite'] = 'Vous avez marqué cette discussion comme favorite. Cliquer pour retirer des favoris.';
$string['clicktounlockdiscussion'] = 'Cliquer pour déverrouiller cette discussion';
$string['clicktounsubscribe'] = 'Vous êtes abonné à cette discussion. Cliquez pour vous désabonner.';
$string['close'] = 'Fermer';
$string['closegrader'] = 'Fermer l’interface d’évaluation';
$string['completiondetail:discussions'] = 'Commencer des discussions : {$a}';
$string['completiondetail:posts'] = 'Écrire des messages de forum : {$a}';
$string['completiondetail:replies'] = 'Écrire des réponses : {$a}';
$string['completiondiscussions'] = 'L’étudiant doit créer des discussions :';
$string['completiondiscussionsdesc'] = 'L’étudiant doit créer au moins {$a} discussion(s)';
$string['completiondiscussionsgroup'] = 'Discussions requises';
$string['completiondiscussionshelp'] = 'discussions requises pour terminer';
$string['completionposts'] = 'L’étudiant doit créer des discussions ou écrire des réponses :';
$string['completionpostsdesc'] = 'L’étudiant doit écrire au moins {$a} discussion(s) ou réponse(s)';
$string['completionpostsgroup'] = 'Messages requis';
$string['completionpostshelp'] = 'discussions ou réponses requises pour terminer';
$string['completionreplies'] = 'L’étudiant doit poster des réponses :';
$string['completionrepliesdesc'] = 'L’étudiant doit poster au moins {$a} réponse(s)';
$string['completionrepliesgroup'] = 'Réponses requises';
$string['completionreplieshelp'] = 'réponses requises pour terminer';
$string['configcleanreadtime'] = 'L’heure à laquelle nettoyer les anciens messages de la table des messages lus.';
$string['configdigestmailtime'] = 'Les utilisateurs désirant recevoir un récapitulatif des messages des forums le recevront quotidiennement. Ce réglage détermine l’heure de la journée à laquelle le message sera envoyé (la tâche cron s’exécutant immédiatement après cette heure enverra le message).';
$string['configdisplaymode'] = 'Mode d’affichage par défaut des discussions';
$string['configenablerssfeeds'] = 'Cette option permet l’activation des flux RSS pour tous les forums. Il est en outre nécessaire d’activer manuellement les flux RSS dans les réglages de chaque forum.';
$string['configenabletimedposts'] = 'Si ce réglage est activé, il est possible de définir des périodes d’affichage lors de l’écriture de nouvelles discussions dans les forums.';
$string['configlongpost'] = 'Tout message dépassant cette longueur (nombre de caractères, code HTML non compris) est considéré comme long message. L’affichage des messages sur la page d’accueil, sur la page des cours en format informel et dans le profil des utilisateurs est tronqué à un endroit adéquat, entre les valeurs forum_shortpost et forum_longpost.';
$string['configmanydiscussions'] = 'Nombre maximal de discussions affichées sur une page';
$string['configmaxattachments'] = 'Nombre maximal d’annexes permises par message.';
$string['configmaxbytes'] = 'Taille maximale des annexes des forums (cette taille dépend par ailleurs des limites définies au niveau du cours et d’autres réglages locaux)';
$string['configoldpostdays'] = 'Nombre de jours après lequel tout message est considéré comme lu.';
$string['configreplytouser'] = 'Lorsqu’un message est envoyé par courriel, doit-il contenir l’adresse de courriel de son auteur, afin que le destinataire puisse l’atteindre personnellement ? Même lorsque cette option est activée, les utilisateurs peuvent choisir dans leur profil de garder leur adresse secrète.';
$string['configrssarticlesdefault'] = 'Si les flux RSS sont activés, ce réglage détermine le nombre d’articles par défaut (discussions ou messages).';
$string['configrsstypedefault'] = 'Si les flux RSS sont activés, ce réglage détermine le type d’activité par défaut.';
$string['configshortpost'] = 'Tout message plus court que cette longueur (nombre de caractères, code HTML non compris) est considéré comme message court (voir ci-dessous).';
$string['configsubscriptiontype'] = 'Réglage par défaut pour le mode d’abonnement.';
$string['configtrackingtype'] = 'Réglage par défaut du suivi des messages.';
$string['configtrackreadposts'] = 'Choisissez « Oui » pour activer le suivi des messages pour chaque utilisateur.';
$string['configusermarksread'] = 'Si « Oui », l’utilisateur doit marquer manuellement un message comme lu. Si « Non », le message est automatiquement marqué comme lu après sa lecture.';
$string['confirmsubscribe'] = 'Voulez-vous vraiment vous abonner au forum « {$a} » ?';
$string['confirmsubscribediscussion'] = 'Voulez-vous vraiment vous abonner à la discussion « {$a->discussion} » du forum « {$a->forum} » ?';
$string['confirmunsubscribe'] = 'Voulez-vous vraiment vous désabonner du forum « {$a} » ?';
$string['confirmunsubscribediscussion'] = 'Voulez-vous vraiment vous désabonner de la discussion « {$a->discussion} » du forum « {$a->forum} » ?';
$string['couldnotadd'] = 'Impossible d’ajouter votre message à cause d’une erreur indéterminée';
$string['couldnotdeletereplies'] = 'Désolé, la suppression n’est plus possible car quelqu’un a déjà répondu';
$string['couldnotupdate'] = 'Impossible de modifier votre message à cause d’une erreur inconnue';
$string['created'] = 'Création';
$string['crontask'] = 'Envoi des messages et maintenance des forums';
$string['cutoffdate'] = 'Date butoir';
$string['cutoffdate_help'] = 'Si ce réglage est activé, le forum n’acceptera pas de message après cette date.';
$string['cutoffdatereached'] = 'La date butoir pour poster dans ce forum est atteinte ; il n’est plus possible de poster de message.';
$string['cutoffdatevalidation'] = 'La date butoir ne peut pas être antérieure à la date limite de remise.';
$string['delete'] = 'Supprimer';
$string['deleteddiscussion'] = 'Le sujet de discussion a été supprimé';
$string['deletedpost'] = 'Ce message a été supprimé';
$string['deletedposts'] = 'Ces messages ont été supprimés';
$string['deleteduser'] = 'Utilisateur supprimé';
$string['deletesure'] = 'Voulez-vous vraiment supprimer ce message ?';
$string['deletesureplural'] = 'Voulez-vous vraiment supprimer ces messages et toutes les réponses ? ({$a} messages)';
$string['digestmailheader'] = 'Ceci est le récapitulatif quotidien contenant tous les nouveaux messages des forums de {$a->sitename}. Pour modifier les réglages par défaut de vos notifications des forums, veuillez visiter {$a->userprefs}.';
$string['digestmailpost'] = 'Modifier vos préférences pour les récapitulatifs de messages de forum';
$string['digestmailpostlink'] = 'Modifier vos préférences pour les récapitulatifs de messages de forum : {$a}';
$string['digestmailprefs'] = 'votre profil utilisateur';
$string['digestmailsubject'] = 'Récapitulatif quotidien du forum {$a}';
$string['digestmailtime'] = 'Heure d’envoi des récapitulatifs quotidiens';
$string['digestsentusers'] = 'Les récapitulatifs quotidiens de messages ont été envoyés correctement à {$a} utilisateurs.';
$string['disallowsubscribe'] = 'L’abonnement n’est pas autorisé';
$string['disallowsubscribeteacher'] = 'L’abonnement n’est pas autorisé (sauf pour les enseignants)';
$string['disallowsubscription'] = 'Abonnement';
$string['disallowsubscription_help'] = 'Ce forum ne permet pas de s’abonner aux discussions.';
$string['discussion'] = 'Discussion';
$string['discussionlistsortbycreatedasc'] = 'Trier par date de création, ordre croissant';
$string['discussionlistsortbycreateddesc'] = 'Trier par date de création, ordre décroissant';
$string['discussionlistsortbydiscussionasc'] = 'Trier par nom de discussion, en ordre ascendant';
$string['discussionlistsortbydiscussiondesc'] = 'Trier par nom de discussion, en ordre descendant';
$string['discussionlistsortbygroupasc'] = 'Trier par groupe, en ordre ascendant';
$string['discussionlistsortbygroupdesc'] = 'Trier par groupe, en ordre descendant';
$string['discussionlistsortbylastpostasc'] = 'Trier par date de création du dernier message, ordre croissant';
$string['discussionlistsortbylastpostdesc'] = 'Trier par date de création du dernier message, ordre décroissant';
$string['discussionlistsortbyrepliesasc'] = 'Trier par nombre de réponses, ordre croissant';
$string['discussionlistsortbyrepliesdesc'] = 'Trier par nombre de réponses, ordre décroissant';
$string['discussionlistsortbystarterasc'] = 'Trier par nom de l’auteur de la discussion, par ordre ascendant';
$string['discussionlistsortbystarterdesc'] = 'Trier par nom de l’auteur de la discussion, par ordre descendant';
$string['discussionlocked'] = 'Cette discussion a été verrouillée. Vous ne pouvez plus y répondre.';
$string['discussionlockingdisabled'] = 'Ne pas verrouiller les discussions';
$string['discussionlockingheader'] = 'Verrouillage des discussions';
$string['discussionmoved'] = 'Cette discussion a été déplacée vers « {$a} ».';
$string['discussionmovedpost'] = 'Cette discussion a été déplacée <a href="{$a->discusshref}">ici</a>, dans le forum <a href="{$a->forumhref}">{$a->forumname}</a>';
$string['discussionname'] = 'Nom de la discussion';
$string['discussionnownotsubscribed'] = '{$a->name} ne recevra pas notification de nouveaux messages dans « {$a->discussion} » de « {$a->forum} »';
$string['discussionnowsubscribed'] = 'Vous recevrez notification de nouveaux messages dans « {$a->discussion} » du forum « {$a->forum} ».';
$string['discussionpin'] = 'Épingler';
$string['discussionpinned'] = 'Épinglé';
$string['discussionpinned_help'] = 'Les discussions épinglées apparaissent en haut d’un forum.';
$string['discussions'] = 'Discussions';
$string['discussionsplit'] = 'La discussion a été séparée.';
$string['discussionsstartedby'] = 'Discussions lancées par {$a}';
$string['discussionsstartedbyrecent'] = 'Discussions récentes lancées par {$a}';
$string['discussionsstartedbyuserincourse'] = 'Discussions commencées par {$a->fullname} dans {$a->coursename}';
$string['discussionsstartedincourse'] = 'Discussions lancées dans {$a}';
$string['discussionstartedby'] = 'Discussion commencée par {$a}';
$string['discussionsubscribed'] = 'Vous êtes maintenant abonné à cette discussion';
$string['discussionsubscribestart'] = 'M’envoyer par courriel les notifications de nouveaux messages dans cette discussion';
$string['discussionsubscribestop'] = 'Ne pas m’envoyer par courriel de notification des nouveaux messages dans cette discussion';
$string['discussionsubscription'] = 'Abonnement à la discussion';
$string['discussionsubscription_help'] = 'L’abonnement à une discussion vous permet de recevoir notification de nouveaux messages dans cette discussion.';
$string['discussionunpin'] = 'Dépingler';
$string['discussionunsubscribed'] = 'Vous êtes maintenant désabonné de cette discussion';
$string['discussthistopic'] = 'Discuter sur ce sujet';
$string['discusstopicname'] = 'Discuter sur le sujet {$a}';
$string['displayend'] = 'Fin de l’affichage';
$string['displayend_help'] = 'Ce réglage détermine si un message de forum doit être caché après une certaine date. À noter que les administrateurs peuvent toujours voir les messages.';
$string['displayenddate'] = 'Fin d’affichage : {$a}.';
$string['displaymode'] = 'Type d’affichage';
$string['displayperiod'] = 'Période d’affichage';
$string['displaystart'] = 'Début de l’affichage';
$string['displaystart_help'] = 'Ce réglage détermine si un message de forum doit être affiché à partir d’une certaine date. À noter que les administrateurs peuvent toujours voir les messages.';
$string['displaystartdate'] = 'Début d’affichage : {$a}.';
$string['displaywordcount'] = 'Afficher le nombre de mots';
$string['displaywordcount_help'] = 'Ce réglage détermine si le nombre de mots de chaque message est affiché ou non.';
$string['duedate'] = 'Date limite';
$string['duedate_help'] = 'La date jusqu’à laquelle il faut poster un message dans le forum. Bien que cette date soit affichée dans le calendrier comme date limite du forum, il sera néanmoins possible d’y poster des messages après cette date. Pour empêcher de poster dans un forum après une certaine date, veuillez indiquer une date butoir.';
$string['duedatetodisplayincalendar'] = 'Date limite à afficher dans le calendrier';
$string['eachuserforum'] = 'Chaque personne lance une discussion unique';
$string['edit'] = 'Modifier';
$string['editdiscussion'] = 'Modifier discussion';
$string['editdiscussiontopic'] = 'Modifier le sujet de discussion';
$string['editedby'] = 'Modifié par {$a->name}. Écrit initialement le {$a->date}';
$string['editedpostupdated'] = 'Le message de {$a} a été modifié';
$string['editing'] = 'Modification';
$string['emaildigestcompleteshort'] = 'Messages complets';
$string['emaildigestdefault'] = 'Réglage par défaut ({$a})';
$string['emaildigestoffshort'] = 'Pas de récapitulatif';
$string['emaildigestsubjectsshort'] = 'Objets seulement';
$string['emaildigesttype'] = 'Options des récapitulatifs de messages';
$string['emaildigesttype_help'] = 'Le type de notification que vous recevrez pour chaque forum.

* Réglage par défaut – c’est le réglage de votre profil pour ce paramètre. Si vous le modifiez dans votre profil, cette modification sera prise en compte ici également.
* Pas de récapitulatif – vous recevrez un courriel pour chaque message de forum.
* Récapitulatif - messages complets – vous recevrez un courriel par jour contenant la totalité de chaque message de forum.
* Récapitulatif - objets seulement – vous recevrez un courriel par jour ne contenant que l’objet de chaque message de forum.';
$string['emptymessage'] = 'Il y a eu un problème avec votre message. Peut-être est-il vide ou alors la taille de l’annexe est trop grande. Vos modifications n’ont pas été enregistrées.';
$string['errorcannotlock'] = 'Vous n’avez pas les permissions requises pour verrouiller les discussions.';
$string['errordiscussionnotfound'] = 'La discussion est introuvable';
$string['erroremptymessage'] = 'Un message ne peut pas être vide';
$string['erroremptysubject'] = 'L’objet d’un message ne peut pas être vide';
$string['errorenrolmentrequired'] = 'Vous devez être inscrit dans ce cours pour avoir accès à ce contenu';
$string['errorforumnotfound'] = 'Le forum d’où provient cette discussion est introuvable';
$string['errorwhiledelete'] = 'Une erreur est survenue lors de la suppression de l’enregistrement.';
$string['eventassessableuploaded'] = 'Contenu posté';
$string['eventcoursesearched'] = 'Cours recherché';
$string['eventdiscussioncreated'] = 'Discussion créée';
$string['eventdiscussiondeleted'] = 'Discussion supprimée';
$string['eventdiscussionmoved'] = 'Discussion déplacée';
$string['eventdiscussionpinned'] = 'Discussion épinglée';
$string['eventdiscussionsubscriptioncreated'] = 'Abonnement à une discussion créé';
$string['eventdiscussionsubscriptiondeleted'] = 'Abonnement à une discussion supprimé';
$string['eventdiscussionunpinned'] = 'Discussion dépinglée';
$string['eventdiscussionupdated'] = 'Discussion modifiée';
$string['eventdiscussionviewed'] = 'Discussion consultée';
$string['eventpostcreated'] = 'Message créé';
$string['eventpostdeleted'] = 'Message supprimé';
$string['eventpostupdated'] = 'Message modifié';
$string['eventreadtrackingdisabled'] = 'Suivi de lecture désactivé';
$string['eventreadtrackingenabled'] = 'Suivi de lecture activé';
$string['eventsubscribersviewed'] = 'Liste d’abonnés consultée';
$string['eventsubscriptioncreated'] = 'Abonnement créé';
$string['eventsubscriptiondeleted'] = 'Abonnement supprimé';
$string['eventuserreportviewed'] = 'Rapport utilisateur consulté';
$string['everyonecanchoose'] = 'Tous les participants peuvent s’abonner';
$string['everyonecannowchoose'] = 'Tous les participants peuvent maintenant choisir de s’abonner';
$string['everyoneisnowsubscribed'] = 'Tous les participants sont maintenant abonnés à ce forum';
$string['everyoneissubscribed'] = 'Tous les participants sont abonnés à ce forum';
$string['existingsubscribers'] = 'Abonnés actuels';
$string['export'] = 'Exporter';
$string['exportattachmentname'] = 'Exporter l’annexe {$a} vers le portfolio';
$string['exportdiscussion'] = 'Exporter la discussion vers le portfolio';
$string['exporthumandates'] = 'Dates lisibles par des humains';
$string['exporthumandates_help'] = 'Détermine si les dates doivent être exportées dans un format lisible par les humains ou sous forme horodatée (suite de chiffres).';
$string['exportoptions'] = 'Options d’exportation';
$string['exportstriphtml'] = 'Supprimer le code HTML';
$string['exportstriphtml_help'] = 'Détermine si les balises HTML comme p ou br doivent être supprimées des messages de forum.';
$string['favourites'] = 'Favori';
$string['favouriteupdated'] = 'Le réglage favori a été modifié.';
$string['firstpost'] = 'Premier message';
$string['forcedreadtracking'] = 'Permettre d’imposer le suivi des messages';
$string['forcedreadtracking_desc'] = 'Permet d’imposer le suivi des messages de forums. Ce réglage aura pour conséquence une diminution de performance pour certains utilisateurs, en particulier dans des cours avec de nombreux forums et messages. Si le réglage est désactivé, dans les forums qui étaient en mode de suivi imposé, le suivi sera optionnel.';
$string['forcesubscribed'] = 'Tous les participants sont obligatoirement abonnés à ce forum';
$string['forcesubscribed_help'] = 'Ce forum ne permet pas de se désabonner des discussions.';
$string['forum'] = 'Forum';
$string['forum:addinstance'] = 'Ajouter un forum';
$string['forum:addnews'] = 'Ajouter des annonces';
$string['forum:addquestion'] = 'Ajouter une question';
$string['forum:allowforcesubscribe'] = 'Permettre d’imposer l’abonnement';
$string['forum:canoverridecutoff'] = 'Poster un message dans un forum après sa date butoir';
$string['forum:canoverridediscussionlock'] = 'Répondre aux discussions verrouillées';
$string['forum:canposttomygroups'] = 'Poster dans tous les groupes auxquel on a accès';
$string['forum:cantogglefavourite'] = 'Marquer des discussions comme favorites';
$string['forum:createattachment'] = 'Créer des annexes';
$string['forum:deleteanypost'] = 'Supprimer des messages (en tout temps)';
$string['forum:deleteownpost'] = 'Supprimer ses propres messages (durant un délai)';
$string['forum:editanypost'] = 'Modifier des messages';
$string['forum:exportdiscussion'] = 'Exporter une discussion vers un portfolio';
$string['forum:exportforum'] = 'Exporter forum';
$string['forum:exportownpost'] = 'Exporter ses propres messages vers un portfolio';
$string['forum:exportpost'] = 'Exporter des messages vers un portfolio';
$string['forum:grade'] = 'Évaluer le forum';
$string['forum:managesubscriptions'] = 'Gérer les abonnés';
$string['forum:movediscussions'] = 'Déplacer des discussions';
$string['forum:pindiscussions'] = 'Épingler des discussions';
$string['forum:postprivatereply'] = 'Répondre aux messages en privé';
$string['forum:postwithoutthrottling'] = 'Être exempté des limites de message';
$string['forum:rate'] = 'Évaluer les messages';
$string['forum:readprivatereplies'] = 'Consulter les réponses privées';
$string['forum:replynews'] = 'Répondre aux annonces';
$string['forum:replypost'] = 'Répondre aux messages';
$string['forum:splitdiscussions'] = 'Séparer des discussions';
$string['forum:startdiscussion'] = 'Lancer des discussions';
$string['forum:viewallratings'] = 'Voir toutes les évaluations brutes données par des participants';
$string['forum:viewanyrating'] = 'Voir toutes les évaluations globales';
$string['forum:viewdiscussion'] = 'Voir les discussions';
$string['forum:viewhiddentimedposts'] = 'Voir les messages cachés en attente de publication';
$string['forum:viewqandawithoutposting'] = 'Toujours voir les questions/réponses';
$string['forum:viewrating'] = 'Voir ses propres évaluations globales reçues';
$string['forum:viewsubscribers'] = 'Voir les abonnés';
$string['forumauthorhidden'] = 'Auteur (masqué)';
$string['forumblockingalmosttoomanyposts'] = 'Vous approchez du nombre maximal de messages autorisés. Vous avez écrit {$a->numposts} durant les derniers {$a->blockperiod}. La limite est de {$a->blockafter} messages.';
$string['forumbodydeleted'] = 'Le contenu de ce message de forum a été supprimé et ne peut plus être consulté.';
$string['forumbodyhidden'] = 'Ce message est actuellement caché, très probablement parce que vous devez au préalable participer à cette discussion et que les notifications des messages de forum doivent être envoyées. Une autre possibilité est que la date et l’heure actuelle n’est pas dans l’intervalle d’affichage défini pour ce message.';
$string['forumgrader'] = 'Évaluateur de forum';
$string['forumgradingnavigation'] = 'Navigation de l’évaluation du forum';
$string['forumgradingpanel'] = 'Panneau d’évaluation du forum';
$string['forumintro'] = 'Description';
$string['forumname'] = 'Nom du forum';
$string['forumposts'] = 'Messages des forums';
$string['forums'] = 'Forums';
$string['forumsubjectdeleted'] = 'Ce message de forum a été supprimé';
$string['forumsubjecthidden'] = 'Sujet (masqué)';
$string['forumtracked'] = 'Les messages non lus sont marqués';
$string['forumtrackednot'] = 'Les messages non lus ne sont pas marqués';
$string['forumtype'] = 'Type de forum';
$string['forumtype_help'] = 'Il y a 5 types de forums :

* Une seule discussion simple : un seul sujet de discussion sur lequel chacun peut s’exprimer (ne peut pas être utilisé avec des groupes séparés).
* Chaque personne commence une seule discussion : chaque étudiant ne peut entamer qu’une seule discussion, à laquelle chacun peut répondre.
* Forum questions/réponses : un étudiant doit poster une réponse à la question d’un enseignant avant de pouvoir consulter les messages des autres étudiants.
* Forum standard affiché comme un blog : un forum ouvert, où chacun peut entamer une nouvelle discussion à tout instant. Les sujets de discussion sont affichés sur une page, avec un lien « Discuter sur ce sujet » pour y répondre.
* Forum standard pour utilisation générale : un forum ouvert, où chacun peut entamer une nouvelle discussion à tout instant.';
$string['generalforum'] = 'Forum standard pour utilisation générale';
$string['generalforums'] = 'Forums standards';
$string['grade_forum_header'] = 'Évaluation de tout le forum';
$string['grade_forum_name'] = 'Tout le forum';
$string['grade_forum_title'] = 'Note';
$string['grade_rating_name'] = 'Évaluation';
$string['graded'] = 'Évalué';
$string['gradedby'] = 'Évalué par';
$string['gradeforrating'] = 'Note de l’évaluation : {$a->str_long_grade}';
$string['gradeforratinghidden'] = 'Note de l’évaluation cachée';
$string['gradeforwholeforum'] = 'Note du forum : {$a->str_long_grade}';
$string['gradeforwholeforumhidden'] = 'Note du forum cachée';
$string['gradeitem:forum'] = 'Forum';
$string['gradeitemnameforrating'] = 'Évaluation de {$a->name}';
$string['gradeitemnameforwholeforum'] = 'Tout le forum {$a->name}';
$string['grades:gradesavedfor'] = 'Note enregistrée de {$a->fullname}';
$string['grades:gradesavefailed'] = 'Impossible d’enregistrer la note de {$a->fullname} : {$a->error}';
$string['gradeusers'] = 'Évaluer utilisateurs';
$string['grading'] = 'Évaluation';
$string['gradingstatus'] = 'Statut d’évaluation :';
$string['hiddenforumpost'] = 'Message de forum caché';
$string['hidegraderpanel'] = 'Cacher le volet d’évaluation';
$string['hidepreviousrepliescount'] = 'Cacher les réponse précédentes ({$a})';
$string['hideusersearch'] = 'Cacher la recherche utilisateur';
$string['indexoutoftotal'] = '{$a->index} sur {$a->total}';
$string['indicator:cognitivedepth'] = 'Forum : aspect cognitif';
$string['indicator:cognitivedepth_help'] = 'Cet indicateur est basé sur la profondeur cognitive atteinte par l’étudiant dans une activité Forum.';
$string['indicator:cognitivedepthdef'] = 'Forum : aspect cognitif';
$string['indicator:cognitivedepthdef_help'] = 'Le participant a atteint durant cet intervalle d’analyse ce pourcentage d’engagement cognitif offert par les activités « Forum » (niveaux : pas de vue, vue, envoi, vue du feedback, commentaire du feedback, nouvel envoi après vue du feedback).';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Forum : aspect social';
$string['indicator:socialbreadth_help'] = 'Cet indicateur se base sur l’interaction sociale atteinte par l’étudiant dans une activité Forum.';
$string['indicator:socialbreadthdef'] = 'Forum : aspect social';
$string['indicator:socialbreadthdef_help'] = 'Le participant a atteint durant cet intervalle d’analyse ce pourcentage d’engagement social offert par les activités « Forum » (niveaux : pas de participation, participant seul, participant avec d’autres).';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['inforum'] = 'dans {$a}';
$string['inreplyto'] = 'En réponse à {$a}';
$string['introblog'] = 'Les messages de ce forum ont été copiés depuis les blogs des utilisateurs de ce cours, car ces articles de blog ne sont plus disponibles';
$string['intronews'] = 'Nouvelles diverses et annonces';
$string['introsocial'] = 'Un forum pour discuter de sujets divers';
$string['introteacher'] = 'Un forum réservé aux remarques et discussions entre enseignants';
$string['invalidaccess'] = 'L’accès à cette page n’a pas été effectué correctement';
$string['invaliddigestsetting'] = 'Un réglage non valide a été fourni pour le récapitulatif des messages';
$string['invaliddiscussionid'] = 'Identifiant de discussion incorrect ou inexistant';
$string['invalidforcesubscribe'] = 'Mode d’abonnement imposé non valide';
$string['invalidforumid'] = 'L’identifiant de forum est incorrect';
$string['invalidparentpostid'] = 'Identifiant du message parent incorrect';
$string['invalidpostid'] = 'Identifiant de message incorrect : {$a}';
$string['lastpost'] = 'Dernier message';
$string['learningforums'] = 'Forums d’apprentissage';
$string['lockdiscussion'] = 'Verrouiller cette discussion';
$string['lockdiscussionafter'] = 'Verrouiller les discussions après une période d’inactivité';
$string['lockdiscussionafter_help'] = 'Les discussions peuvent être verrouillées automatiquement après une durée spécifiée écoulée depuis la dernière réponse.

Les utilisateurs disposant de la capacité de répondre aux discussions verrouillées peuvent déverrouiller une discussion en y répondant.';
$string['locked'] = 'Verrouillé';
$string['lockupdated'] = 'Le réglage verrouillé a été modifié.';
$string['longpost'] = 'Message long';
$string['mailnow'] = 'Envoyer les notifications de messages des forums sans délai de modification.';
$string['managesubscriptionsoff'] = 'Terminer la gestion des abonnements';
$string['managesubscriptionson'] = 'Gérer les abonnés';
$string['manydiscussions'] = 'Discussions par page';
$string['markalldread'] = 'Marquer tous les messages de cette discussion comme lus.';
$string['markallread'] = 'Marquer tous les messages de ce forum comme lus.';
$string['markasread'] = 'Marqué comme lu';
$string['markasreadonnotification'] = 'Lors de l’envoi des notifications de messages de forums';
$string['markasreadonnotification_help'] = 'Il est possible de choisir si un message de forum doit être marqué comme lu ou non lorsque l’on reçoit la notification de ce message de forum.';
$string['markasreadonnotificationno'] = 'Ne pas marquer le message comme lu';
$string['markasreadonnotificationyes'] = 'Marquer le message comme lu';
$string['markread'] = 'Marquer comme lu';
$string['markreadbutton'] = 'Marquer<br />comme lu';
$string['markunread'] = 'Marquer comme non lu';
$string['markunreadbutton'] = 'Marquer comme<br />non lu';
$string['maxattachments'] = 'Nombre maximal d’annexes';
$string['maxattachments_help'] = 'Ce réglage vous permet de spécifier le nombre maximal d’annexes de chaque message de forum.';
$string['maxattachmentsize'] = 'Taille maximale de l’annexe';
$string['maxattachmentsize_help'] = 'Ce réglage détermine la taille maximale de chaque fichier joint à un message de forum.';
$string['maxtimehaspassed'] = 'Le délai pour modifier ce message ({$a}) est échu';
$string['message'] = 'Message';
$string['messageinboundattachmentdisallowed'] = 'Impossible de poster votre réponse, car elle comporte une annexe, ce qui n’est pas autorisé dans ce forum.';
$string['messageinboundfilecountexceeded'] = 'Impossible de poster votre réponse, car elle comporte plus d’annexes que le maximum autorisé dans ce forum ({$a->forum->maxattachments}).';
$string['messageinboundfilesizeexceeded'] = 'Impossible de poster votre réponse, car la taille totale des annexes ({$a->filesize}) dépasse la taille maximale permise dans ce forum ({$a->maxbytes}).';
$string['messageinboundforumhidden'] = 'Impossible de poster votre réponse, car le forum n’est actuellement pas disponible.';
$string['messageinboundnopostforum'] = 'Impossible de poster votre réponse, car vous n’avez pas les permissions requises pour écrire dans le forum {$a->forum->name} .';
$string['messageinboundthresholdhit'] = 'Impossible de poster votre réponse. Vous avez dépassé le nombre de messages fixé pour ce forum.';
$string['messageprovider:digests'] = 'Abonnements aux récapitulatifs de messages de forum';
$string['messageprovider:posts'] = 'Abonnements aux messages de forum';
$string['missingsearchterms'] = 'Le terme recherché suivant n’apparaît que dans le code HTML de ce message :';
$string['modeflatnewestfirst'] = 'Réponses en ligne, la plus récente en premier';
$string['modeflatoldestfirst'] = 'Réponses en ligne, la plus ancienne en premier';
$string['modenested'] = 'Réponses emboîtées';
$string['modenestedv2'] = 'Afficher les réponses en format emboîté expérimental';
$string['modethreaded'] = 'Réponses en fils de discussions';
$string['modulename'] = 'Forum';
$string['modulename_help'] = 'Le module d’activité forum permet aux participants de tenir des discussions asynchrones, c’est-à-dire ne nécessitant pas leur participation au même moment.

Divers types de forums peuvent être choisis, comme un forum standard, où chacun peut lancer de nouvelles discussions à n’importe quel moment, ou un forum où chaque participant doit lancer exactement une discussion, ou encore un forum de questions et réponses où ils doivent écrire un message avant de voir ceux des autres participants. L’enseignant peut autoriser que des fichiers soit joints aux messages des forums.

Les images jointes sont affichées dans le message. Les participants peuvent s’abonner à un forum afin de recevoir les messages des forums par courriel. L’enseignant peut rendre l’abonnement facultatif, obligatoire ou l’empêcher complètement. Au besoin, les participants peuvent être empêchés de poster plus d’un nombre donné de messages durant une période donnée, afin d’éviter que l’un d’entre eux domine les discussions.

Les messages des forums peuvent être évalués par les enseignants ou les participants (évaluation par les pairs). Les évaluations sont combinées pour former une note qui est enregistrée dans le carnet de notes.

Les forums ont de nombreuses utilisations, comme :

* un espace de présentation pour que les participants à un cours apprennent à se connaître
* une tribune pour diffuser les informations du cours (à l’aide d’un forum d’annonces avec abonnement imposé)
* un centre d’aide où les enseignants et les participants peuvent donner des conseils
* une façon informelle de partager des documents entre participants (et éventuellement d’évaluer par les pairs)
* poursuivre en ligne une discussion commencée lors d’une session face à face
* un endroit pour des discussions réservées aux enseignants (avec un forum caché)
* pour des activités complémentaires, par exemple des problèmes ouverts où les participants peuvent suggérer des solutions
* un lieu social pour des discussions hors-sujet';
$string['modulename_link'] = 'mod/forum/view';
$string['modulenameplural'] = 'Forums';
$string['more'] = 'plus';
$string['movedmarker'] = '(Déplacée)';
$string['movethisdiscussionlabel'] = 'Déplacer la discussion en cours vers le forum indiqué';
$string['movethisdiscussionto'] = 'Déplacer cette discussion vers…';
$string['mustprovidediscussionorpost'] = 'Vous devez fournir soit l’identifiant de la discussion, soit celui du message à exporter.';
$string['myprofileotherdis'] = 'Discussions de forum';
$string['myprofileowndis'] = 'Mes discussions de forum';
$string['myprofileownpost'] = 'Mes messages de forum';
$string['namenews'] = 'Annonces';
$string['namenews_help'] = 'Le forum des annonces du cours est un forum spécial, destiné aux annonces. Il est automatiquement créé dans chaque nouveau cours. Un cours ne peut avoir qu’un seul forum des annonces. Seuls les enseignants et administrateurs peuvent poster des annonces. Le bloc « Dernières annonces » affiche les annonces récentes.';
$string['namesocial'] = 'Forum informel';
$string['nameteacher'] = 'Forum des enseignants';
$string['newforumposts'] = 'Nouveaux messages dans les forums';
$string['nextdiscussiona'] = 'Discussion suivante : {$a}';
$string['nextuser'] = 'Enregistrer les modifications et passer à l’utilisateur suivant';
$string['noattachments'] = 'Ce message n’a pas d’annexe';
$string['nodiscussions'] = 'Il n’y a pas encore de discussion dans ce forum';
$string['nodiscussionsstartedby'] = '{$a} n’a lancé aucune discussion';
$string['nodiscussionsstartedbyyou'] = 'Vous n’avez pas encore commencé de discussion';
$string['noguestpost'] = 'Les visiteurs anonymes n’ont pas les permissions requises pour poster de messages.';
$string['noguestsubscribe'] = 'Les utilisateurs anonymes ne peuvent pas s’abonner.';
$string['noguesttracking'] = 'Les visiteurs anonymes n’ont pas les permissions requises pour modifier les options de suivi des forums.';
$string['nomorepostscontaining'] = 'Plus aucun message contenant « {$a} » n’a été trouvé';
$string['nonews'] = 'Aucune annonce n’a encore été publiée';
$string['noonecansubscribenow'] = 'L’abonnement n’est maintenant plus autorisé';
$string['nopermissiontosubscribe'] = 'Vous n’avez pas les permissions requises pour voir les abonnés au forum';
$string['nopermissiontoview'] = 'Vous n’avez pas les permissions requises pour voir ce message';
$string['nopostforum'] = 'Désolé, vous ne pouvez pas écrire dans ce forum';
$string['noposts'] = 'Aucun message';
$string['nopostsmadebyuser'] = '{$a} n’a pas écrit de message';
$string['nopostsmadebyyou'] = 'Vous n’avez pas écrit de message';
$string['noquestions'] = 'Il n’y a pas encore de question dans ce forum';
$string['nosubscribers'] = 'Personne n’est abonné à ce forum';
$string['notexists'] = 'La discussion n’existe plus';
$string['notgraded'] = 'Non évalué';
$string['nothingnew'] = 'Rien de neuf pour {$a}';
$string['notingroup'] = 'Vous devez faire partie d’un groupe pour consulter ce forum.';
$string['notinstalled'] = 'Le module forum n’est pas installé';
$string['notlocked'] = 'Verrouiller';
$string['notpartofdiscussion'] = 'Ce message n’appartient pas à une discussion !';
$string['notrackforum'] = 'Ne pas signaler les messages non lus';
$string['notsubscribed'] = 'M’abonner';
$string['nousersmatch'] = 'Aucun utilisateur trouvé pour les critères données';
$string['noviewdiscussionspermission'] = 'Vous n’avez pas les permissions requises pour voir les discussions de ce forum';
$string['nowallsubscribed'] = 'Vous êtes maintenant abonné à tous les forums de {$a}.';
$string['nowallunsubscribed'] = 'Vous êtes maintenant désabonné de tous les forums de {$a}.';
$string['nowgradinguser'] = 'Évaluation de {$a}';
$string['nownotsubscribed'] = '{$a->name} ne sera pas informé des nouveaux messages de « {$a->forum} »';
$string['nownottracking'] = '{$a->name} ne désire plus le suivi des messages du forum « {$a->forum} ».';
$string['nowsubscribed'] = 'Vous serez informé des nouveaux messages du forum « {$a->forum} »';
$string['nowtracking'] = '{$a->name} désire le suivi des messages du forum « {$a->forum} ».';
$string['numberofreplies'] = 'Nombre de réponses : {$a}';
$string['numposts'] = '{$a} messages';
$string['olderdiscussions'] = 'Discussions antérieures';
$string['oldertopics'] = 'Sujets antérieurs';
$string['oldpostdays'] = 'Délai de lecture';
$string['page-mod-forum-discuss'] = 'Page de discussion du module forum';
$string['page-mod-forum-view'] = 'Page principale du module forum';
$string['page-mod-forum-x'] = 'Toute page du module forum';
$string['parent'] = 'Niveau supérieur';
$string['parentofthispost'] = 'Niveau supérieur de ce message';
$string['permalink'] = 'Permalien';
$string['permanentlinktoparentpost'] = 'Lien permanent vers le parent de ce message';
$string['permanentlinktopost'] = 'Lien permanent vers ce message';
$string['pindiscussion'] = 'Épingler cette discussion';
$string['pinupdated'] = 'Le réglage épinglé a été modifié.';
$string['pluginadministration'] = 'Administration forum';
$string['pluginname'] = 'Forum';
$string['postadded'] = '<p>Votre message a été enregistré.</p><p>Il vous est possible de le modifier pendant {$a}.</p>';
$string['postaddedsuccess'] = 'Votre message a été enregistré.';
$string['postaddedtimeleft'] = 'Il vous est possible de le modifier pendant {$a}.';
$string['postbymailsuccess'] = 'Votre réponse « {$a->subject} » a été postée correctement : {$a->discussionurl}';
$string['postbymailsuccess_html'] = 'Votre réponse <a href="{$a->discussionurl}">{$a->subject}</a> a été postée correctement.';
$string['postbyuser'] = '{$a->post} de {$a->user}';
$string['postincontext'] = 'Voir ce message dans son contexte';
$string['postisprivatereply'] = 'Ceci est une réponse privée (les enseignants et autres utilisateurs ayant la capacité de voir les réponses privées peuvent aussi la voir).';
$string['postmailinfo'] = 'Ceci est une copie du message posté sur le site {$a}.';
$string['postmailinfolink'] = 'Ce message est une copie du message posté dans {$a->coursename}.

Pour y répondre, cliquez sur ce lien : {$a->replylink}';
$string['postmailnow'] = '<p>Ce message sera envoyé immédiatement à tous les participants abonnés à ce forum.</p>';
$string['postmailreply'] = 'Pour répondre, cliquer ce lien : {$a}';
$string['postmailsubject'] = '{$a->courseshortname} : {$a->subject}';
$string['postrating1'] = 'Pas très pertinent';
$string['postrating2'] = 'Moyennement intéressant';
$string['postrating3'] = 'Plutôt pertinent';
$string['posts'] = 'Messages';
$string['postsfrom'] = 'Messages de';
$string['postsmadebyuser'] = 'Messages écrits par {$a}';
$string['postsmadebyuserincourse'] = 'Messages écrits par {$a->fullname} dans {$a->coursename}';
$string['postsmadeincourse'] = 'Messages postés dans {$a}';
$string['poststo'] = 'Messages à';
$string['posttoforum'] = 'Envoyer';
$string['posttomygroups'] = 'Envoyer une copie à tous mes groupes';
$string['posttomygroups_help'] = 'Poste une copie de ce message dans tous les groupes auxquels vous avez accès. Les participants aux groupes auxquels vous n’avez pas accès ne verront pas ce message.';
$string['postupdated'] = 'Votre message a été modifié';
$string['potentialsubscribers'] = 'Abonnés potentiels';
$string['prevdiscussiona'] = 'Discussion précédente : {$a}';
$string['previoususer'] = 'Enregistrer les modifications et passer à l’utilisateur précédent';
$string['privacy:digesttypenone'] = 'Aucune donnée concernant le type de récapitulatif des messages n’est conservée pour ce forum.';
$string['privacy:digesttypepreference'] = 'Vous avez choisi de recevoir le type de récapitulatif des messages suivant : {$a->type}.';
$string['privacy:discussionsubscriptionpreference'] = 'Vous avez choisi la préférence d’abonnement de discussion suivante pour ce forum : {$a->preference}';
$string['privacy:metadata:core_rating'] = 'Le forum utilise le sous-système d’évaluation pour permettre l’évaluation des messages.';
$string['privacy:metadata:core_tag'] = 'Le forum utilise le sous-système de tags pour permettre de tagger des messages.';
$string['privacy:metadata:forum_digests'] = 'Informations sur les préférences de récapitulatif de messages de chaque forum.';
$string['privacy:metadata:forum_digests:forum'] = 'Le forum auquel l’abonnement est relié.';
$string['privacy:metadata:forum_digests:maildigest'] = 'La préférence de récapitulatif des messages.';
$string['privacy:metadata:forum_digests:userid'] = 'L’identifiant de l’utilisateur avec la préférence de récapitulatif des messages.';
$string['privacy:metadata:forum_discussion_subs'] = 'Informations sur les abonnements aux discussions de forum';
$string['privacy:metadata:forum_discussion_subs:discussionid'] = 'L’identifiant de la discussion auquel l’abonnement est relié.';
$string['privacy:metadata:forum_discussion_subs:preference'] = 'La date et l’heure du début de l’abonnement.';
$string['privacy:metadata:forum_discussion_subs:userid'] = 'L’identifiant de l’utilisateur qui s’est abonné à la discussion.';
$string['privacy:metadata:forum_discussions'] = 'Informations sur les discussions de forum qu’un utilisateur a créé';
$string['privacy:metadata:forum_discussions:assessed'] = 'TODO - ce que ce champ enregistre';
$string['privacy:metadata:forum_discussions:name'] = 'Le nom de la discussion, tel que choisi par l’auteur.';
$string['privacy:metadata:forum_discussions:timemodified'] = 'La date et l’heure de la dernière modification de la discussion.';
$string['privacy:metadata:forum_discussions:userid'] = 'L’identifiant de l’utilisateur qui a créé la discussion';
$string['privacy:metadata:forum_discussions:usermodified'] = 'L’identifiant de l’utilisateur qui a modifié en dernier la discussion.';
$string['privacy:metadata:forum_grades'] = 'Données d’évaluation du forum';
$string['privacy:metadata:forum_grades:forum'] = 'Le forum qui a été évalué';
$string['privacy:metadata:forum_grades:grade'] = 'La note donnée';
$string['privacy:metadata:forum_grades:userid'] = 'L’utilisateur qui a été évalué';
$string['privacy:metadata:forum_posts'] = 'Informations sur les préférences de récapitulatif de messages de chaque forum.';
$string['privacy:metadata:forum_posts:created'] = 'La date et l’heure de la création du message.';
$string['privacy:metadata:forum_posts:discussion'] = 'La discussion dans laquelle se trouvent les messages.';
$string['privacy:metadata:forum_posts:message'] = 'Le contenu du message de forum.';
$string['privacy:metadata:forum_posts:modified'] = 'La date et l’heure de la dernière modification du message.';
$string['privacy:metadata:forum_posts:parent'] = 'Le message auquel il a été répondu.';
$string['privacy:metadata:forum_posts:privatereplyto'] = 'L’ID de l’utilisateur auquel cette réponse a été envoyée.';
$string['privacy:metadata:forum_posts:subject'] = 'L’objet du message de forum.';
$string['privacy:metadata:forum_posts:totalscore'] = 'Le contenu du message de forum.';
$string['privacy:metadata:forum_posts:userid'] = 'L’identifiant de l’utilisateur qui a écrit le message.';
$string['privacy:metadata:forum_queue'] = 'Journal temporaire des messages qui seront envoyés dans le récapitulatif de messages';
$string['privacy:metadata:forum_queue:discussionid'] = 'Identifiant de discussion de forum';
$string['privacy:metadata:forum_queue:postid'] = 'Identifiant de message de forum';
$string['privacy:metadata:forum_queue:timemodified'] = 'La date et l’heure de modification du message original';
$string['privacy:metadata:forum_queue:userid'] = 'L’utilisateur qui doit être notifié du message';
$string['privacy:metadata:forum_read'] = 'Informations sur les messages consultés par l’utilisateur.';
$string['privacy:metadata:forum_read:discussionid'] = 'La discussion dans laquelle se trouve le message.';
$string['privacy:metadata:forum_read:firstread'] = 'La date et l’heure de la première consultation du message.';
$string['privacy:metadata:forum_read:lastread'] = 'La date et l’heure de la consultation la plus récente du message.';
$string['privacy:metadata:forum_read:postid'] = 'Le message qui a été consulté.';
$string['privacy:metadata:forum_read:userid'] = 'L’identifiant de l’utilisateur auquel l’enregistrement est relié.';
$string['privacy:metadata:forum_subscriptions'] = 'Informations sur les forums auxquels l’utilisateur est abonné.';
$string['privacy:metadata:forum_subscriptions:forum'] = 'Le forum auquel on s’est abonné.';
$string['privacy:metadata:forum_subscriptions:userid'] = 'L’identifiant de l’utilisateur auquel cet abonnement de forum est relié.';
$string['privacy:metadata:forum_track_prefs'] = 'Les informations sur les forums dans lesquels l’utilisateur a choisi de suivre les messages consultés.';
$string['privacy:metadata:forum_track_prefs:forumid'] = 'Le forum dans lequel le suivi des messages est activé.';
$string['privacy:metadata:forum_track_prefs:userid'] = 'L’identifiant de l’utilisateur auquel la préférence de suivi des messages de ce forum est reliée.';
$string['privacy:metadata:preference:autosubscribe'] = 'S’il faut s’abonner aux discussions lorsqu’on répond aux messages qui s’y trouvent.';
$string['privacy:metadata:preference:forum_discussionlistsortorder'] = 'L’ordre de tri préféré pour la liste des discussions';
$string['privacy:metadata:preference:maildigest'] = 'La préférence globale des récapitulatifs de messages';
$string['privacy:metadata:preference:markasreadonnotification'] = 'S’il faut marquer les messages comme lus quand on les reçoit par messagerie.';
$string['privacy:metadata:preference:trackforums'] = 'S’il faut activer le suivi des messages.';
$string['privacy:postwasread'] = 'Ce message a été consulté pour la première fois le {$a->firstread} et consulté pour la dernière fois le {$a->lastread}';
$string['privacy:readtrackingdisabled'] = 'Vous avez choisi de ne pas suivre les messages que vous avez consultés dans ce forum.';
$string['privacy:request:delete:discussion:name'] = 'Supprimé à la demande de l’auteur';
$string['privacy:request:delete:post:message'] = 'Le contenu de ce message a été supprimé à la demande de son auteur.';
$string['privacy:request:delete:post:subject'] = 'Supprimer à la demande de l’auteur';
$string['privacy:subscribedtoforum'] = 'Vous êtes abonné à ce forum.';
$string['privatereply'] = 'Répondre en privé';
$string['privatereply_help'] = 'Lorsque vous répondez en privé, votre message est aussi visible par les utilisateurs ayant la capacité de voir les réponses privées, comme les enseignants.';
$string['processingdigest'] = 'Traitement du récapitulatif des messages pour l’utilisateur {$a}';
$string['processingpost'] = 'Enregistrement du message {$a}';
$string['prune'] = 'Séparer';
$string['prunediscussion'] = 'Séparer la discussion';
$string['prunedpost'] = 'Une nouvelle discussion a été créée à partir de ce message';
$string['pruneheading'] = 'Séparer la discussion et déplacer ce message vers une nouvelle discussion';
$string['qandaforum'] = 'Forum questions/réponses';
$string['qandanotify'] = 'Ce forum est un forum Questions et réponses. Pour voir les autres réponses, vous devez d’abord poster votre propre réponse.';
$string['re'] = 'Re:';
$string['readtherest'] = 'Lire le reste de la discussion';
$string['removeallforumtags'] = 'Supprimer tous les tags de forum';
$string['removefromfavourites'] = 'Retirer cette discussion des favoris';
$string['replies'] = 'Réponses';
$string['repliesmany'] = '{$a} réponses';
$string['repliesone'] = '{$a} réponse';
$string['reply'] = 'Répondre';
$string['reply_handler'] = 'Ce gestionnaire permet de répondre aux messages des forums par courriel';
$string['reply_handler_name'] = 'Réponse aux messages des forums';
$string['replyauthorself'] = '{$a} (vous)';
$string['replyforum'] = 'Répondre au forum';
$string['replyingtoauthor'] = 'Réponse à {$a}…';
$string['replyplaceholder'] = 'Écrivez votre réponse…';
$string['replypostdiscussion'] = 'Répondre à la discussion';
$string['replytopostbyemail'] = 'Vous pouvez répondre à ce message par courriel.';
$string['replytouser'] = 'Utiliser l’adresse de l’auteur';
$string['resetdigests'] = 'Supprimer toutes les préférences des utilisateurs pour les récapitulatifs de messages de forum';
$string['resetforums'] = 'Supprimer les messages du';
$string['resetforumsall'] = 'Supprimer tous les messages';
$string['resetsubscriptions'] = 'Supprimer tous les abonnements aux forums';
$string['resettrackprefs'] = 'Supprimer toutes les préférences de suivi des messages de forum';
$string['rssarticles'] = 'Nombre d’articles récents RSS';
$string['rssarticles_help'] = '<p>Cette option vous permet de fixer le nombre d’articles récents à inclure dans le flux RSS.</p>

<p>Un nombre entre 5 et 20 est adéquat pour la plupart des forums. Si le forum est très actif, il est souhaitable d’augmenter ce nombre.</p>';
$string['rsssubscriberssdiscussions'] = 'Flux RSS des discussions';
$string['rsssubscriberssposts'] = 'Flux RSS des messages';
$string['rsstype'] = 'Flux RSS de cette activité';
$string['rsstype_help'] = 'Pour activer le flux RSS de cette activité, choisissez soit les discussions, soit les messages à inclure dans le flux.';
$string['rsstypedefault'] = 'Type de flux RSS';
$string['search'] = 'Rechercher';
$string['search:activity'] = 'Forum – information sur l’activité';
$string['search:post'] = 'Forum – messages';
$string['searchdatefrom'] = 'Dans les messages postérieurs à';
$string['searchdateto'] = 'Dans les messages antérieurs à';
$string['searchforumintro'] = 'Veuillez saisir les termes à rechercher dans l’un ou plusieurs des champs ci-dessous :';
$string['searchforums'] = 'Recherche (forums)';
$string['searchfullwords'] = 'Mots entiers';
$string['searchnotwords'] = 'Termes à exclure';
$string['searcholderposts'] = 'Rechercher les anciens messages…';
$string['searchphrase'] = 'Phrase exacte dans le corps du message';
$string['searchresults'] = 'Résultats de la recherche';
$string['searchsubject'] = 'Terme dans le sujet du message';
$string['searchtags'] = 'Est tag avec';
$string['searchuser'] = 'Nom de l’auteur';
$string['searchuserid'] = 'Identifiant (Moodle ID) de l’auteur';
$string['searchusers'] = 'Rechercher utilisateurs';
$string['searchwhichforums'] = 'Rechercher dans quels forums ?';
$string['searchwords'] = 'Termes apparaissant n’importe où dans le message';
$string['seeallposts'] = 'Afficher tous les messages écrits par cet utilisateur';
$string['sendstudentnotificationsdefault'] = 'Réglage par défaut pour « Notifier les étudiants »';
$string['sendstudentnotificationsdefault_help'] = 'Définit la valeur par défaut de la case à cocher « Notifier les étudiants » sur le formulaire d’évaluation';
$string['sendstudentnotificationsno'] = 'Non';
$string['sendstudentnotificationsyes'] = 'Oui, envoyer une notification à l’étudiant';
$string['settings'] = 'Réglages';
$string['shortpost'] = 'Message court';
$string['showgraderpanel'] = 'Afficher le volet d’évaluation';
$string['showingcountoftotaldiscussions'] = 'Liste des discussions. Affichage de {$a->count} sur {$a->total} discussions';
$string['showmoreusers'] = 'Afficher plus d’utilisateurs';
$string['showpreviousrepliescount'] = 'Afficher les réponses précédentes ({$a})';
$string['showsubscribers'] = 'Afficher/modifier les abonnés à ce forum';
$string['showusersearch'] = 'Afficher la recherche utilisateur';
$string['singleforum'] = 'Une seule discussion';
$string['smallmessage'] = '{$a->user} a écrit dans {$a->forumname}';
$string['smallmessagedigest'] = 'Récapitulatif contenant {$a} messages de forum';
$string['starredonly'] = 'Ne chercher que dans les discussions favorites';
$string['startedby'] = 'lancée par';
$string['subject'] = 'Sujet';
$string['subplugintype_forumreport'] = 'Rapport de forum';
$string['subplugintype_forumreport_plural'] = 'Rapports de forum';
$string['subscribe'] = 'S’abonner au forum';
$string['subscribeall'] = 'Abonner tous les participants';
$string['subscribed'] = 'Abonné';
$string['subscribediscussion'] = 'S’abonner à cette discussion';
$string['subscribeenrolledonly'] = 'Seuls les utilisateurs inscrits au cours sont autorisés à s’abonner aux notifications des messages des forums.';
$string['subscribenone'] = 'Désabonner tous les participants';
$string['subscribers'] = 'Abonnés';
$string['subscriberstowithcount'] = 'Abonnés à « {$a->name} » ({$a->count})';
$string['subscribestart'] = 'M’envoyer par courriel les notifications de nouveaux messages dans ce forum';
$string['subscribestop'] = 'Ne pas m’envoyer par courriel de notification des nouveaux messages dans ce forum';
$string['subscription'] = 'Abonnement';
$string['subscription_help'] = 'Si vous êtes abonné à un forum, vous recevrez par courriel une notification des nouveaux messages postés sur ce forum. Habituellement, vous pouvez décider de vous abonner, mais dans certains forums, l’abonnement est imposé, de sorte que tout le monde reçoit les notifications.';
$string['subscriptionandtracking'] = 'Inscription et suivi des messages';
$string['subscriptionauto'] = 'Abonnement automatique';
$string['subscriptiondisabled'] = 'Abonnement désactivé';
$string['subscriptionforced'] = 'Abonnement imposé';
$string['subscriptionmode'] = 'Mode d’abonnement';
$string['subscriptionmode_help'] = 'Lorsqu’un participant est abonné à un forum, il reçoit par courriel une copie de tous les messages postés sur ce forum. Il existe 4 modes pour cet abonnement :

* Abonnement facultatif : les participants peuvent décider de s’abonner ou non.
* Abonnement imposé : tous les participants sont abonnés et ne peuvent pas se désabonner.
* Abonnement automatique : tous les participants sont initialement abonnés, mais peuvent choisir de se désabonner quand ils le veulent.
* Abonnement désactivé : l’abonnement n’est pas autorisé.';
$string['subscriptionmodeconfirm'] = 'Voulez-vous vraiment modifier le mode d’abonnement à {$a} ?';
$string['subscriptionoptional'] = 'Abonnement facultatif';
$string['subscriptions'] = 'Abonnements';
$string['tagarea_forum_posts'] = 'Messages de forum';
$string['tagsdeleted'] = 'Les tags de forum ont été supprimés';
$string['thisforumhasduedate'] = 'La date limite pour poster dans ce forum est le {$a}.';
$string['thisforumisdue'] = 'La date limite pour poster dans ce forum était le {$a}.';
$string['thisforumisthrottled'] = 'Ce forum a une limite du nombre de messages que vous pouvez poster durant une période donnée. Cette limite est actuellement de {$a->blockafter} message(s) durant {$a->blockperiod}';
$string['timed'] = 'Temporisé';
$string['timeddiscussion'] = 'Discussion temporisée';
$string['timedhidden'] = 'Temporisation : caché pour les étudiants';
$string['timedposts'] = 'Messages temporisés';
$string['timedvisible'] = 'Temporisation : visible pour tous les utilisateurs';
$string['timestartenderror'] = 'La date de fin d’affichage ne peut pas être antérieure à la date du début de l’affichage';
$string['togglediscussionmenu'] = 'Afficher/cacher le menu discussion';
$string['togglefullscreen'] = 'Activer/désactiver plein écran';
$string['togglesettingsdrawer'] = 'Afficher le tiroir des réglages';
$string['trackforum'] = 'Activer le suivi des messages';
$string['tracking'] = 'Suivi des messages';
$string['trackingoff'] = 'Désactivé';
$string['trackingon'] = 'Imposé';
$string['trackingoptional'] = 'Facultatif';
$string['trackingtype'] = 'Suivi des messages';
$string['trackingtype_help'] = 'Le suivi des messages permet aux participants de vérifier facilement les messages qu’ils n’ont pas encore vu en les signalant visuellement.

Si le réglage est mis sur « Facultatif », les participants peuvent activer ou désactiver à discrétion le suivi des messages pour le forum (le suivi des messages doit d’abord être activé dans leurs préférences de forum).

Si le réglage « Permettre d’imposer le suivi des messages » est activée par un administrateur du site, une option supplémentaire est affichée : « Imposé ». Le suivi est alors toujours activé, indépendamment des préférences de forum de l’utilisateur.';
$string['trackreadposts_header'] = 'Suivi des messages de forum';
$string['unlockdiscussion'] = 'Déverrouiller cette discussion';
$string['unpindiscussion'] = 'Dépingler cette discussion';
$string['unread'] = 'Non lu';
$string['unreadpost'] = 'Message non lu';
$string['unreadposts'] = 'Messages non lus';
$string['unreadpostsnumber'] = '{$a} messages non lus';
$string['unreadpostsone'] = '1 message non lu';
$string['unsubscribe'] = 'Se désabonner du forum';
$string['unsubscribeall'] = 'Se désabonner de tous les forums';
$string['unsubscribeallconfirm'] = 'Vous êtes actuellement abonné à {$a->forums} forums et à {$a->discussions} discussions. Voulez-vous vraiment vous désabonner de tous les forums et discussions, ainsi que désactiver l’abonnement automatique aux discussions ?';
$string['unsubscribeallconfirmdiscussions'] = 'Vous êtes actuellement abonné à {$a->discussions} discussions. Voulez-vous vraiment vous désabonner de toutes les discussions et désactiver l’abonnement automatique aux discussions ?';
$string['unsubscribeallconfirmforums'] = 'Vous êtes actuellement abonné à {$a->forums} forums. Voulez-vous vraiment vous désabonner de tous les forums et désactiver l’abonnement automatique aux discussions ?';
$string['unsubscribealldone'] = 'Tous vos abonnements ont été annulés. Vous recevrez encore les notifications de messages des forums pour lesquels l’abonnement est imposé. Vous pouvez modifier la notification des messages dans les réglages de votre profil.';
$string['unsubscribeallempty'] = 'Vous n’êtes abonné à aucun forum. Si vous voulez désactiver toutes les notifications de ce serveur, modifiez la notification des messages dans les réglages de votre profil.';
$string['unsubscribed'] = 'Désabonné';
$string['unsubscribediscussion'] = 'Se désabonner de cette discussion';
$string['unsubscribediscussionlink'] = 'Me désabonner de cette discussion : {$a}';
$string['unsubscribelink'] = 'Me désabonner de ce forum : {$a}';
$string['unsubscribeshort'] = 'Désabonner';
$string['useexperimentalui'] = 'Utiliser la vue expérimentale emboîtée pour la discussion';
$string['usermarksread'] = 'Marquage manuel des messages lus';
$string['usernavigation'] = 'Navigation utilisateur';
$string['usersforumposts'] = 'Messages de forum de l’utilisateur';
$string['viewalldiscussions'] = 'Afficher toutes les discussions';
$string['viewconversation'] = 'Afficher la discussion';
$string['viewgrades'] = 'Afficher les notes';
$string['viewparentpost'] = 'Voir le message parent';
$string['viewthediscussion'] = 'Consulter la discussion';
$string['warnafter'] = 'Nombre de messages avant notification';
$string['warnafter_help'] = 'Les participants peuvent être avertis lorsque le nombre de messages écrits s’approche du nombre maximal autorisé dans une période donnée. Ce réglage détermine après combien de messages écrits ils recevront cette notification. Les utilisateurs ayant la capacité mod/forum:postwithoutthrottling ne sont pas touchés par les limites de message.';
$string['warnformorepost'] = 'Attention ! Il y a plus d’une discussion dans ce forum. La plus récente sera utilisée';
$string['yournewquestion'] = 'Nouvelle question';
$string['yournewtopic'] = 'Nouveau sujet de discussion';
$string['yourreply'] = 'Votre réponse';
