<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'editor_tinymce', language 'fr', version '4.1'.
 *
 * @package     editor_tinymce
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['advanced:address'] = 'Adresse';
$string['advanced:anchor_delta_height'] = '';
$string['advanced:anchor_delta_width'] = '';
$string['advanced:anchor_desc'] = 'Insérer / éditer une ancre';
$string['advanced:backcolor_desc'] = 'Choisir la couleur de surlignage';
$string['advanced:block'] = 'Format';
$string['advanced:blockquote'] = 'Citation';
$string['advanced:blockquote_desc'] = 'Citation';
$string['advanced:bold_desc'] = 'Gras (Ctrl+B)';
$string['advanced:bullist_desc'] = 'Insérer/supprimer liste à puces';
$string['advanced:charmap_delta_height'] = '';
$string['advanced:charmap_delta_width'] = '';
$string['advanced:charmap_desc'] = 'Insérer un caractère spécial';
$string['advanced:cleanup_desc'] = 'Nettoyer le code';
$string['advanced:clipboard_msg'] = 'Les fonctions Copier/Couper/Coller ne sont pas valables sur Mozilla et Firefox.
Souhaitez-vous avoir plus d’informations sur ce sujet ?';
$string['advanced:code'] = 'Code';
$string['advanced:code_desc'] = 'Éditer le code source HTML';
$string['advanced:colorpicker_delta_height'] = '';
$string['advanced:colorpicker_delta_width'] = '';
$string['advanced:copy_desc'] = 'Copier';
$string['advanced:custom1_desc'] = 'Votre description personnalisée ici';
$string['advanced:cut_desc'] = 'Couper';
$string['advanced:dd'] = 'Définition du terme';
$string['advanced:div'] = 'DIV';
$string['advanced:dt'] = 'Terme à définir';
$string['advanced:font_size'] = 'Taille de police';
$string['advanced:fontdefault'] = 'Police';
$string['advanced:forecolor_desc'] = 'Choisir la couleur du texte';
$string['advanced:h1'] = 'Titre 1';
$string['advanced:h2'] = 'Titre 2';
$string['advanced:h3'] = 'Titre 3';
$string['advanced:h4'] = 'Titre 4';
$string['advanced:h5'] = 'Titre 5';
$string['advanced:h6'] = 'Titre 6';
$string['advanced:help_desc'] = 'Aide';
$string['advanced:help_shortcut'] = 'Presser Alt-F10 pour la barre d’outil ou Alt-0 pour de l’aide';
$string['advanced:hr_desc'] = 'Insérer un filet horizontal';
$string['advanced:image_delta_height'] = '';
$string['advanced:image_delta_width'] = '';
$string['advanced:image_desc'] = 'Insérer / éditer l’image';
$string['advanced:image_props_desc'] = 'Propriétés de l’image';
$string['advanced:indent_desc'] = 'Augmenter le retrait';
$string['advanced:italic_desc'] = 'Italique (Ctrl+I)';
$string['advanced:justifycenter_desc'] = 'Centré';
$string['advanced:justifyfull_desc'] = 'Justifié';
$string['advanced:justifyleft_desc'] = 'Aligné à gauche';
$string['advanced:justifyright_desc'] = 'Aligné à droite';
$string['advanced:link_delta_height'] = '';
$string['advanced:link_delta_width'] = '';
$string['advanced:link_desc'] = 'Insérer / éditer le lien';
$string['advanced:more_colors'] = 'Plus de couleurs…';
$string['advanced:newdocument'] = 'Voulez-vous vraiment effacer l’intégralité du document ?';
$string['advanced:newdocument_desc'] = 'Nouveau document';
$string['advanced:numlist_desc'] = 'Insérer/supprimer liste numérotée';
$string['advanced:outdent_desc'] = 'Diminuer le retrait';
$string['advanced:paragraph'] = 'Paragraphe';
$string['advanced:paste_desc'] = 'Coller';
$string['advanced:path'] = 'Chemin';
$string['advanced:pre'] = 'Préformaté';
$string['advanced:redo_desc'] = 'Rétablir (Ctrl+Y)';
$string['advanced:removeformat_desc'] = 'Supprimer le formatage';
$string['advanced:rich_text_area'] = 'Zone de texte riche';
$string['advanced:samp'] = 'Exemple de code';
$string['advanced:shortcuts_desc'] = 'Aide d’accessibilité';
$string['advanced:striketrough_desc'] = 'Barré';
$string['advanced:style_select'] = 'Styles';
$string['advanced:sub_desc'] = 'Indice';
$string['advanced:sup_desc'] = 'Exposant';
$string['advanced:toolbar'] = 'Barre d’outils';
$string['advanced:toolbar_focus'] = 'Aller les boutons de l’éditeur - Alt+Q, Aller à l’éditeur - Alt-Z, Aller au chemin de l’élément - Alt-X';
$string['advanced:underline_desc'] = 'Souligné (Ctrl+U)';
$string['advanced:undo_desc'] = 'Annuler (Ctrl+Z)';
$string['advanced:unlink_desc'] = 'Supprimer le lien';
$string['advanced:visualaid_desc'] = 'Activer/désactiver les guides et les éléments invisibles';
$string['advanced_dlg:'] = '';
$string['advanced_dlg:about_author'] = 'Auteur';
$string['advanced_dlg:about_general'] = 'À propos';
$string['advanced_dlg:about_help'] = 'Aide';
$string['advanced_dlg:about_license'] = 'Licence';
$string['advanced_dlg:about_loaded'] = 'Plugins chargés';
$string['advanced_dlg:about_plugin'] = 'Plugin';
$string['advanced_dlg:about_plugins'] = 'Plugins';
$string['advanced_dlg:about_title'] = 'À propos de TinyMCE';
$string['advanced_dlg:about_version'] = 'Version';
$string['advanced_dlg:accessibility_help'] = 'Aide d’accessibilité';
$string['advanced_dlg:accessibility_usage_title'] = 'Usage général';
$string['advanced_dlg:anchor_invalid'] = 'Veuillez indiquer un nom d’ancrage valide';
$string['advanced_dlg:anchor_name'] = 'Nom de l’ancre';
$string['advanced_dlg:anchor_title'] = 'Insérer / éditer une ancre';
$string['advanced_dlg:charmap_title'] = 'Choisir le caractère spécial';
$string['advanced_dlg:charmap_usage'] = 'Utiliser les flèches gauche et droite pour naviguer.';
$string['advanced_dlg:code_title'] = 'Éditeur de source HTML';
$string['advanced_dlg:code_wordwrap'] = 'Retour à la ligne';
$string['advanced_dlg:colorpicker_color'] = 'Couleur :';
$string['advanced_dlg:colorpicker_name'] = 'Nom :';
$string['advanced_dlg:colorpicker_named_tab'] = 'Noms';
$string['advanced_dlg:colorpicker_named_title'] = 'Couleurs nommées';
$string['advanced_dlg:colorpicker_palette_tab'] = 'Palette';
$string['advanced_dlg:colorpicker_palette_title'] = 'Couleurs de la palette';
$string['advanced_dlg:colorpicker_picker_tab'] = 'Nuancier';
$string['advanced_dlg:colorpicker_picker_title'] = 'Nuancier';
$string['advanced_dlg:colorpicker_title'] = 'Choisir une couleur';
$string['advanced_dlg:image_align'] = 'Alignement';
$string['advanced_dlg:image_align_baseline'] = 'Normal';
$string['advanced_dlg:image_align_bottom'] = 'En bas';
$string['advanced_dlg:image_align_left'] = 'Gauche (flottant)';
$string['advanced_dlg:image_align_middle'] = 'Au milieu';
$string['advanced_dlg:image_align_right'] = 'Droite (flottant)';
$string['advanced_dlg:image_align_textbottom'] = 'Texte en bas';
$string['advanced_dlg:image_align_texttop'] = 'Texte en haut';
$string['advanced_dlg:image_align_top'] = 'En haut';
$string['advanced_dlg:image_alt'] = 'Description de l’image';
$string['advanced_dlg:image_border'] = 'Bordure';
$string['advanced_dlg:image_dimensions'] = 'Dimensions';
$string['advanced_dlg:image_hspace'] = 'Espacement horizontal';
$string['advanced_dlg:image_list'] = 'Liste d’images';
$string['advanced_dlg:image_src'] = 'URL de l’image';
$string['advanced_dlg:image_title'] = 'Insérer / éditer une image';
$string['advanced_dlg:image_vspace'] = 'Espacement vertical';
$string['advanced_dlg:invalid_color_value'] = 'Code couleur non valide';
$string['advanced_dlg:link_is_email'] = 'L’URL que vous avez saisie semble être une adresse e-mail, souhaitez-vous ajouter le préfixe « mailto: » ?';
$string['advanced_dlg:link_is_external'] = 'L’URL que vous avez saisie semble être une adresse web externe. Souhaitez-vous ajouter le préfixe « http:// » ?';
$string['advanced_dlg:link_list'] = 'Liste de liens';
$string['advanced_dlg:link_target'] = 'Cible';
$string['advanced_dlg:link_target_blank'] = 'Ouvrir dans une nouvelle fenêtre';
$string['advanced_dlg:link_target_same'] = 'Ouvrir dans la même fenêtre';
$string['advanced_dlg:link_title'] = 'Insérer / éditer un lien';
$string['advanced_dlg:link_titlefield'] = 'Titre';
$string['advanced_dlg:link_url'] = 'URL du lien';
$string['advhr:advhr_desc'] = 'Insérer un filet horizontal';
$string['advhr:delta_height'] = 'Ecart de hauteur';
$string['advhr:delta_width'] = 'Ecart de largeur';
$string['advhr_dlg:normal'] = 'Normal';
$string['advhr_dlg:noshade'] = 'Pas d’ombre';
$string['advhr_dlg:size'] = 'Hauteur';
$string['advhr_dlg:width'] = 'Largeur';
$string['advhr_dlg:widthunits'] = 'Unités';
$string['advimage:delta_height'] = '';
$string['advimage:delta_width'] = '';
$string['advimage:image_desc'] = 'Insérer / éditer une image';
$string['advimage_dlg:align'] = 'Alignement';
$string['advimage_dlg:align_baseline'] = 'Normal';
$string['advimage_dlg:align_bottom'] = 'En bas';
$string['advimage_dlg:align_left'] = 'Gauche (flottant)';
$string['advimage_dlg:align_middle'] = 'Au milieu';
$string['advimage_dlg:align_right'] = 'Droite (flottant)';
$string['advimage_dlg:align_textbottom'] = 'Texte en bas';
$string['advimage_dlg:align_texttop'] = 'Texte en haut';
$string['advimage_dlg:align_top'] = 'En haut';
$string['advimage_dlg:alt'] = 'Description de l’image';
$string['advimage_dlg:alt_image'] = 'Image alternative';
$string['advimage_dlg:border'] = 'Bordure';
$string['advimage_dlg:classes'] = 'Classes';
$string['advimage_dlg:constrain_proportions'] = 'Conserver les proportions';
$string['advimage_dlg:dialog_title'] = 'Insérer / éditer une image';
$string['advimage_dlg:dimensions'] = 'Dimensions';
$string['advimage_dlg:example_img'] = 'Apparence de l’image';
$string['advimage_dlg:general'] = 'Général';
$string['advimage_dlg:height'] = 'Hauteur';
$string['advimage_dlg:hspace'] = 'Espacement horizontal';
$string['advimage_dlg:id'] = 'ID';
$string['advimage_dlg:image_list'] = 'Liste d’images';
$string['advimage_dlg:langcode'] = 'Code de la langue';
$string['advimage_dlg:langdir'] = 'Sens de lecture';
$string['advimage_dlg:list'] = 'Liste d’images';
$string['advimage_dlg:long_desc'] = 'Description longue du lien';
$string['advimage_dlg:ltr'] = 'De gauche à droite';
$string['advimage_dlg:map'] = 'Image cliquable';
$string['advimage_dlg:misc'] = 'Divers';
$string['advimage_dlg:missing_alt'] = 'Voulez-vous vraiment continuer sans définir de description pour l’image ? Sans elle, l’image peut ne pas être accessible pour certains utilisateurs handicapés, ou pour ceux utilisant un navigateur texte ou ceux qui naviguent sans affichage des images.';
$string['advimage_dlg:mouseout'] = 'à la sortie de la souris';
$string['advimage_dlg:mouseover'] = 'au survol de la souris';
$string['advimage_dlg:preview'] = 'Prévisualisation';
$string['advimage_dlg:rtl'] = 'De droite à gauche';
$string['advimage_dlg:src'] = 'URL de l’image';
$string['advimage_dlg:style'] = 'Style';
$string['advimage_dlg:swap_image'] = 'Image de remplacement';
$string['advimage_dlg:tab_advanced'] = 'Avancé';
$string['advimage_dlg:tab_appearance'] = 'Apparence';
$string['advimage_dlg:tab_general'] = 'Général';
$string['advimage_dlg:title'] = 'Titre';
$string['advimage_dlg:vspace'] = 'Espacement vertical';
$string['advimage_dlg:width'] = 'Largeur';
$string['advlink:delta_height'] = '';
$string['advlink:delta_width'] = '';
$string['advlink:link_desc'] = 'Insérer / éditer un lien';
$string['advlink_dlg:accesskey'] = 'Touche d’accès rapide';
$string['advlink_dlg:advanced_props'] = 'Propriétés avancées';
$string['advlink_dlg:advanced_tab'] = 'Avancé';
$string['advlink_dlg:anchor_names'] = 'Ancres';
$string['advlink_dlg:classes'] = 'Classes';
$string['advlink_dlg:encoding'] = 'Encodage de la cible';
$string['advlink_dlg:event_props'] = 'Événements';
$string['advlink_dlg:events_tab'] = 'Événements';
$string['advlink_dlg:general_props'] = 'Propriétés générales';
$string['advlink_dlg:general_tab'] = 'Général';
$string['advlink_dlg:height'] = 'Hauteur';
$string['advlink_dlg:id'] = 'ID';
$string['advlink_dlg:is_email'] = 'L’URL que vous avez saisie semble être une adresse de courriel. Souhaitez-vous ajouter le préfixe « mailto: » ?';
$string['advlink_dlg:is_external'] = 'L’URL que vous avez saisie semble être une adresse web externe. Souhaitez-vous ajouter le préfixe « http:// » ?';
$string['advlink_dlg:langcode'] = 'Code de la langue';
$string['advlink_dlg:langdir'] = 'Sens de lecture';
$string['advlink_dlg:link_list'] = 'Liste des liens';
$string['advlink_dlg:list'] = 'Liste de liens';
$string['advlink_dlg:ltr'] = 'Gauche à droite';
$string['advlink_dlg:mime'] = 'Type MIME de la cible';
$string['advlink_dlg:popup'] = 'Fenêtre Javascript';
$string['advlink_dlg:popup_dependent'] = 'Dépendante (seulement sous Mozilla/Firefox)';
$string['advlink_dlg:popup_location'] = 'Afficher la barre d’adresse';
$string['advlink_dlg:popup_menubar'] = 'Afficher la barre de menu';
$string['advlink_dlg:popup_name'] = 'Nom de la fenêtre';
$string['advlink_dlg:popup_opts'] = 'Options';
$string['advlink_dlg:popup_position'] = 'Position (X/Y)';
$string['advlink_dlg:popup_props'] = 'Propriétés de la popup';
$string['advlink_dlg:popup_resizable'] = 'Autoriser le redimensionnement de la fenêtre';
$string['advlink_dlg:popup_return'] = 'Insérer \'return false';
$string['advlink_dlg:popup_scrollbars'] = 'Afficher les ascenseurs';
$string['advlink_dlg:popup_size'] = 'Taille';
$string['advlink_dlg:popup_statusbar'] = 'Afficher la barre d’état';
$string['advlink_dlg:popup_tab'] = 'Popup';
$string['advlink_dlg:popup_toolbar'] = 'Afficher les barres d’outils';
$string['advlink_dlg:popup_url'] = 'URL de la popup';
$string['advlink_dlg:rel'] = 'Relation de la page à la cible';
$string['advlink_dlg:rev'] = 'Relation de la cible à la page';
$string['advlink_dlg:rtl'] = 'De droite à gauche';
$string['advlink_dlg:style'] = 'Style';
$string['advlink_dlg:tabindex'] = 'TabIndex';
$string['advlink_dlg:target'] = 'Cible';
$string['advlink_dlg:target_blank'] = 'Ouvrir dans une nouvelle fenêtre';
$string['advlink_dlg:target_langcode'] = 'Langue de la cible';
$string['advlink_dlg:target_name'] = 'Nom de la cible';
$string['advlink_dlg:target_parent'] = 'Ouvrir dans la fenêtre/le cadre parent';
$string['advlink_dlg:target_same'] = 'Ouvrir dans cette fenêtre/dans ce cadre';
$string['advlink_dlg:target_top'] = 'Ouvrir dans le cadre principal (remplace tous les cadres)';
$string['advlink_dlg:title'] = 'Insérer/éditer un lien';
$string['advlink_dlg:titlefield'] = 'Titre';
$string['advlink_dlg:url'] = 'URL du lien';
$string['advlink_dlg:width'] = 'Largeur';
$string['advlist:circle'] = 'Cercle';
$string['advlist:def'] = 'Défaut';
$string['advlist:disc'] = 'Disque';
$string['advlist:lower_alpha'] = 'Alpha minuscule';
$string['advlist:lower_greek'] = 'Grec minuscule';
$string['advlist:lower_roman'] = 'Romain minuscule';
$string['advlist:square'] = 'Carré';
$string['advlist:types'] = 'Types';
$string['advlist:upper_alpha'] = 'Alpha majuscule';
$string['advlist:upper_roman'] = 'Romain majuscule';
$string['aria:rich_text_area'] = 'Zone de texte WYSIWYG';
$string['autosave:restore_content'] = 'Restaurer le contenu enregistré automatiquement';
$string['autosave:unload_msg'] = 'Les modifications apportées seront perdues si vous quittez cette page.';
$string['autosave:warning_message'] = 'Si vous restaurez le contenu enregistré, vous perdrez le contenu actuel de l’éditeur.

Voulez-vous vraiment restaurer le contenu enregistré ?';
$string['availablebuttons'] = 'Boutons disponibles';
$string['colors:000000'] = 'Noir';
$string['colors:000080'] = 'Bleu marine';
$string['colors:0000FF'] = 'Bleu';
$string['colors:003300'] = 'Vert foncé';
$string['colors:003366'] = 'Bleu foncé';
$string['colors:008000'] = 'Vert';
$string['colors:008080'] = 'Bleu vert';
$string['colors:00CCFF'] = 'Bleu ciel';
$string['colors:00FF00'] = 'Citron vert';
$string['colors:00FFFF'] = 'Eau';
$string['colors:333300'] = 'Olive foncé';
$string['colors:333333'] = 'Gris très foncé';
$string['colors:333399'] = 'Indigo';
$string['colors:3366FF'] = 'Bleu royal';
$string['colors:339966'] = 'Vert d’eau';
$string['colors:33CCCC'] = 'Turquoise';
$string['colors:666699'] = 'Bleu gris';
$string['colors:800000'] = 'Bordeaux';
$string['colors:800080'] = 'Violet';
$string['colors:808000'] = 'Vert olive';
$string['colors:808080'] = 'Gris';
$string['colors:993300'] = 'Orange brûlée';
$string['colors:993366'] = 'Marron';
$string['colors:999999'] = 'Gris moyen';
$string['colors:99CC00'] = 'Vert clair';
$string['colors:99CCFF'] = 'Bleu clair';
$string['colors:C0C0C0'] = 'Argent';
$string['colors:CC99FF'] = 'Prune';
$string['colors:CCFFCC'] = 'Vert pâle';
$string['colors:CCFFFF'] = 'Bleu pâle';
$string['colors:FF0000'] = 'Rouge';
$string['colors:FF00FF'] = 'Magenta';
$string['colors:FF6600'] = 'Orange';
$string['colors:FF9900'] = 'Ambre';
$string['colors:FF99CC'] = 'Rose';
$string['colors:FFCC00'] = 'Or';
$string['colors:FFCC99'] = 'Pêche';
$string['colors:FFFF00'] = 'Jaune';
$string['colors:FFFF99'] = 'Jaune clair';
$string['colors:FFFFFF'] = 'Blanc';
$string['common:apply'] = 'Appliquer';
$string['common:browse'] = 'Parcourir';
$string['common:cancel'] = 'Annuler';
$string['common:class_name'] = 'Classe';
$string['common:clipboard_msg'] = 'Les fonctions Copier/Couper/Coller ne sont pas disponibles sur Mozilla et Firefox.
Souhaitez-vous avoir plus d’informations sur ce sujet ?';
$string['common:clipboard_no_support'] = 'Actuellement non supporté par votre navigateur.
 Veuillez utiliser les raccourcis clavier à la place.';
$string['common:close'] = 'Fermer';
$string['common:edit_confirm'] = 'Souhaitez-vous utiliser le mode WYSIWYG pour cette zone de texte ?';
$string['common:insert'] = 'Insérer';
$string['common:invalid_data'] = 'Erreur : saisie de valeurs incorrectes. Elles sont mises en évidence en rouge.';
$string['common:invalid_data_min'] = '{#field} doit être un nombre plus grand que {#min}';
$string['common:invalid_data_number'] = '{#field} doit être un nombre';
$string['common:invalid_data_size'] = '{#field} doit être un nombre ou un pourcentage';
$string['common:more_colors'] = 'Plus de couleurs…';
$string['common:not_set'] = '-- Non défini --';
$string['common:popup_blocked'] = 'Désolé, nous avons détecté que votre bloqueur de popup a bloqué une fenêtre dont l’application a besoin. Vous devez désactiver votre bloqueur de popup pour pouvoir utiliser cet outil.';
$string['common:update'] = 'Mettre à jour';
$string['common:value'] = '(valeur)';
$string['contextmenu:align'] = 'Alignement';
$string['contextmenu:center'] = 'Centré';
$string['contextmenu:full'] = 'Justifié';
$string['contextmenu:left'] = 'Gauche';
$string['contextmenu:right'] = 'Droite';
$string['customconfig'] = 'Configuration personnalisée';
$string['customconfig_desc'] = 'Configuration personnalisée avancée de TinyMCE en format JSON, par exemple : {"option1" : "valeur1", "option2" : "valeur2"}. Les options indiquées ici auront précédence sur les réglages standards et ceux des plugins.';
$string['customtoolbar'] = 'Barre d’édition';
$string['customtoolbar_desc'] = 'Chaque ligne contient une liste de noms de boutons, séparés par des virgules. Le mot « wrap » doit être utilisé comme séparateur de groupes. Les lignes vides sont ignorées. Voir sur <a href="{$a}" target="_blank">{$a}</a> la liste des boutons TinyMCE par défaut.<br />La première rangée de boutons est toujours affichée, alors que la visibilité des deuxième et troisième rangées peut être activée ou non.';
$string['directionality:ltr_desc'] = 'Écriture de gauche à droite';
$string['directionality:rtl_desc'] = 'Écriture de droite à gauche';
$string['emotions:delta_height'] = '';
$string['emotions:delta_width'] = '';
$string['emotions:emotions_desc'] = 'Émoticônes';
$string['emotions_dlg:cool'] = 'Cool';
$string['emotions_dlg:cry'] = 'En pleurs';
$string['emotions_dlg:desc'] = 'Émoticônes';
$string['emotions_dlg:embarassed'] = 'Embarrassé';
$string['emotions_dlg:foot_in_mouth'] = 'Pied de nez';
$string['emotions_dlg:frown'] = 'Déçu';
$string['emotions_dlg:innocent'] = 'Innocent';
$string['emotions_dlg:kiss'] = 'Bisou';
$string['emotions_dlg:laughing'] = 'Rigolant';
$string['emotions_dlg:money_mouth'] = 'Avare';
$string['emotions_dlg:sealed'] = 'Bouche cousue';
$string['emotions_dlg:smile'] = 'Sourire';
$string['emotions_dlg:surprised'] = 'Surpris';
$string['emotions_dlg:title'] = 'Insérer une émoticône';
$string['emotions_dlg:tongue_out'] = 'Langue tirée';
$string['emotions_dlg:undecided'] = 'Incertain';
$string['emotions_dlg:usage'] = 'Utiliser les flèches gauche et droite pour naviguer.';
$string['emotions_dlg:wink'] = 'Clin d’œil';
$string['emotions_dlg:yell'] = 'Criant';
$string['fontselectlist'] = 'Liste des polices disponibles';
$string['fullpage:delta_height'] = '';
$string['fullpage:delta_width'] = '';
$string['fullpage:desc'] = 'Propriétés du document';
$string['fullpage_dlg:active_color'] = 'Couleur du lien actif';
$string['fullpage_dlg:add'] = 'Ajouter un nouvel élément';
$string['fullpage_dlg:add_base'] = 'Élément de base';
$string['fullpage_dlg:add_comment'] = 'Commentaire';
$string['fullpage_dlg:add_link'] = 'Élément de lien';
$string['fullpage_dlg:add_meta'] = 'Élément Meta';
$string['fullpage_dlg:add_script'] = 'Élément de script';
$string['fullpage_dlg:add_style'] = 'Élément de style';
$string['fullpage_dlg:add_title'] = 'Élément de titre';
$string['fullpage_dlg:advanced_props'] = 'Avancé';
$string['fullpage_dlg:advanced_tab'] = 'Avancé';
$string['fullpage_dlg:appearance_bgprops'] = 'Propriétés du fond';
$string['fullpage_dlg:appearance_linkprops'] = 'Couleurs des liens';
$string['fullpage_dlg:appearance_marginprops'] = 'Marge du corps de la page';
$string['fullpage_dlg:appearance_style'] = 'Propriétés de la feuille de style et du style';
$string['fullpage_dlg:appearance_tab'] = 'Apparence';
$string['fullpage_dlg:appearance_textprops'] = 'Propriétés du texte';
$string['fullpage_dlg:author'] = 'Auteur';
$string['fullpage_dlg:base_element'] = 'Élément de base';
$string['fullpage_dlg:bgcolor'] = 'Couleur de fond';
$string['fullpage_dlg:bgimage'] = 'Image de fond';
$string['fullpage_dlg:bottom_margin'] = 'Marge du bas';
$string['fullpage_dlg:charset'] = 'Charset';
$string['fullpage_dlg:comment_element'] = 'Commentaire';
$string['fullpage_dlg:content'] = 'Contenu';
$string['fullpage_dlg:copyright'] = 'Copyright';
$string['fullpage_dlg:defer'] = 'Déférer';
$string['fullpage_dlg:doctypes'] = 'Doctype';
$string['fullpage_dlg:encoding'] = 'Encodage des caractères';
$string['fullpage_dlg:font_face'] = 'Nom de la police';
$string['fullpage_dlg:font_size'] = 'Taille de police';
$string['fullpage_dlg:fontface'] = 'Nom de la police';
$string['fullpage_dlg:fontsize'] = 'Taille de police';
$string['fullpage_dlg:general_props'] = 'Général';
$string['fullpage_dlg:head_elements'] = 'Éléments d’en-tête';
$string['fullpage_dlg:hover_color'] = 'Couleur au survol';
$string['fullpage_dlg:href'] = 'HREF';
$string['fullpage_dlg:hreflang'] = 'HREF langue';
$string['fullpage_dlg:info'] = 'Information';
$string['fullpage_dlg:langcode'] = 'Code de la langue';
$string['fullpage_dlg:langdir'] = 'Sens de lecture';
$string['fullpage_dlg:langprops'] = 'Langue et encodage';
$string['fullpage_dlg:language'] = 'Langue';
$string['fullpage_dlg:left_margin'] = 'Marge de gauche';
$string['fullpage_dlg:link_color'] = 'Couleur des liens';
$string['fullpage_dlg:link_element'] = 'Élément de lien';
$string['fullpage_dlg:ltr'] = 'De gauche à droite';
$string['fullpage_dlg:media'] = 'Média';
$string['fullpage_dlg:meta_description'] = 'Description';
$string['fullpage_dlg:meta_element'] = 'Élément Meta';
$string['fullpage_dlg:meta_index_follow'] = 'Indexer et suivre les liens';
$string['fullpage_dlg:meta_index_nofollow'] = 'Indexer et ne pas suivre les liens';
$string['fullpage_dlg:meta_keywords'] = 'Mots-clefs';
$string['fullpage_dlg:meta_noindex_follow'] = 'Ne pas indexer et suivre les liens';
$string['fullpage_dlg:meta_noindex_nofollow'] = 'Ne pas indexer et ne pas suivre les liens';
$string['fullpage_dlg:meta_props'] = 'Metadonnées';
$string['fullpage_dlg:meta_robots'] = 'Robots';
$string['fullpage_dlg:meta_tab'] = 'Général';
$string['fullpage_dlg:meta_title'] = 'Titre';
$string['fullpage_dlg:movedown'] = 'Déplacer l’élément sélectionné vers le bas';
$string['fullpage_dlg:moveup'] = 'Déplacer l’élément sélectionné vers le haut';
$string['fullpage_dlg:name'] = 'Nom';
$string['fullpage_dlg:properties'] = 'Propriétés';
$string['fullpage_dlg:rel'] = 'Rel';
$string['fullpage_dlg:remove'] = 'Retirer l’élément sélectionné';
$string['fullpage_dlg:rev'] = 'Rev';
$string['fullpage_dlg:right_margin'] = 'Marge de droite';
$string['fullpage_dlg:rtl'] = 'De droite à gauche';
$string['fullpage_dlg:script_element'] = 'Élément de script';
$string['fullpage_dlg:src'] = 'Source';
$string['fullpage_dlg:style'] = 'Style';
$string['fullpage_dlg:style_element'] = 'Élément de style';
$string['fullpage_dlg:stylesheet'] = 'Feuille de style';
$string['fullpage_dlg:target'] = 'Cible';
$string['fullpage_dlg:text_color'] = 'Couleur du texte';
$string['fullpage_dlg:textcolor'] = 'Couleur';
$string['fullpage_dlg:title'] = 'Propriétés du document';
$string['fullpage_dlg:title_element'] = 'Élément de titre';
$string['fullpage_dlg:top_margin'] = 'Marge du haut';
$string['fullpage_dlg:type'] = 'Type';
$string['fullpage_dlg:value'] = 'Valeur';
$string['fullpage_dlg:visited_color'] = 'Couleur des liens visités';
$string['fullpage_dlg:xml_pi'] = 'Déclaration XML';
$string['fullscreen:desc'] = 'Passer en mode plein écran';
$string['iespell:download'] = 'ieSpell n’est pas installé. Souhaitez-vous l’installer maintenant ?';
$string['iespell:iespell_desc'] = 'Lancer le vérificateur d’orthographe';
$string['insertdatetime:date_fmt'] = '%d-%m-%Y';
$string['insertdatetime:day_long'] = 'Dimanche,Lundi,Mardi,Mercredi,Jeudi,Vendredi,Samedi,Dimanche';
$string['insertdatetime:day_short'] = 'Dim,Lun,Mar,Mer,Jeu,Ven,Sam,Dim';
$string['insertdatetime:insertdate_desc'] = 'Insérer la date';
$string['insertdatetime:inserttime_desc'] = 'Insérer l’heure';
$string['insertdatetime:months_long'] = 'Janvier,Février,Mars,Avril,Mai,Juin,Juillet,Août,Septembre,Octobre,Novembre,Décembre';
$string['insertdatetime:months_short'] = 'Jan,Fév,Mar,Avr,Mai,Juin,Juil,Août,Sep,Oct,Nov,Déc';
$string['insertdatetime:time_fmt'] = '%H:%M:%S';
$string['layer:absolute_desc'] = 'Activer le positionnement absolu';
$string['layer:backward_desc'] = 'Déplacer vers l’arrière';
$string['layer:content'] = 'Nouvelle couche…';
$string['layer:forward_desc'] = 'Déplacer vers l’avant';
$string['layer:insertlayer_desc'] = 'Insérer une nouvelle couche';
$string['media:delta_height'] = '';
$string['media:delta_width'] = '';
$string['media:desc'] = 'Insérer/modifier un média intégré';
$string['media:edit'] = 'Éditer un média intégré';
$string['media_dlg:advanced'] = 'Avancé';
$string['media_dlg:align'] = 'Alignement';
$string['media_dlg:align_bottom'] = 'Bas';
$string['media_dlg:align_bottom_left'] = 'En bas à gauche';
$string['media_dlg:align_bottom_right'] = 'En bas à droite';
$string['media_dlg:align_center'] = 'Centré';
$string['media_dlg:align_left'] = 'Gauche';
$string['media_dlg:align_right'] = 'Droite';
$string['media_dlg:align_top'] = 'Haut';
$string['media_dlg:align_top_left'] = 'En haut à gauche';
$string['media_dlg:align_top_right'] = 'En haut à droite';
$string['media_dlg:altsource1'] = 'Source alternative 1';
$string['media_dlg:altsource2'] = 'Source alternative 2';
$string['media_dlg:audio'] = 'Audio HTML5';
$string['media_dlg:autogotourl'] = 'Aller automatiquement à l’URL';
$string['media_dlg:autohref'] = 'Auto HREF';
$string['media_dlg:autostart'] = 'Lire automatiquement';
$string['media_dlg:balance'] = 'Balance';
$string['media_dlg:base'] = 'Base';
$string['media_dlg:baseurl'] = 'Adresse de base';
$string['media_dlg:bgcolor'] = 'Fond';
$string['media_dlg:cache'] = 'Cache';
$string['media_dlg:captioningid'] = 'ID sous-titre';
$string['media_dlg:center'] = 'Centrer';
$string['media_dlg:class_name'] = 'Classe';
$string['media_dlg:console'] = 'Console';
$string['media_dlg:constrain_proportions'] = 'Conserver les proportions';
$string['media_dlg:controller'] = 'Contrôleur';
$string['media_dlg:controls'] = 'Contrôles';
$string['media_dlg:correction'] = 'Pas de correction';
$string['media_dlg:currentmarker'] = 'Marqueur actuel';
$string['media_dlg:currentposition'] = 'Position actuelle';
$string['media_dlg:defaultframe'] = 'Image par défaut';
$string['media_dlg:embedded_audio_options'] = 'Options d’audio intégré';
$string['media_dlg:embeddedaudio'] = 'Audio intégré';
$string['media_dlg:enabled'] = 'Activé';
$string['media_dlg:enablejavascript'] = 'Activer le Javascript';
$string['media_dlg:endtime'] = 'Fin';
$string['media_dlg:file'] = 'Fichier / URL';
$string['media_dlg:flash'] = 'Flash';
$string['media_dlg:flash_options'] = 'Options Flash';
$string['media_dlg:flashvars'] = 'Variables flash';
$string['media_dlg:fullscreen'] = 'Plein écran';
$string['media_dlg:general'] = 'Général';
$string['media_dlg:hidden'] = 'Caché';
$string['media_dlg:href'] = 'HREF';
$string['media_dlg:hspace'] = 'Espacement horizontal';
$string['media_dlg:html5_audio_options'] = 'Options audio';
$string['media_dlg:html5_video_options'] = 'Options de vidéo HTML5 intégrée';
$string['media_dlg:id'] = 'ID';
$string['media_dlg:iframe'] = 'IFRAME';
$string['media_dlg:imagestatus'] = 'Statut de l’image';
$string['media_dlg:invokeurls'] = 'Invoquer URLs';
$string['media_dlg:kioskmode'] = 'Mode kiosque';
$string['media_dlg:list'] = 'Liste';
$string['media_dlg:liveconnect'] = 'SWLiveConnect';
$string['media_dlg:loop'] = 'Lire en boucle';
$string['media_dlg:maintainaspect'] = 'Maintenir l’aspect';
$string['media_dlg:menu'] = 'Afficher le menu';
$string['media_dlg:mute'] = 'Muet';
$string['media_dlg:name'] = 'Nom';
$string['media_dlg:nojava'] = 'Pas de java';
$string['media_dlg:numloop'] = 'Nombre de tours';
$string['media_dlg:play'] = 'Lecture automatique';
$string['media_dlg:playcount'] = 'Compteur';
$string['media_dlg:playeveryframe'] = 'Jouer toutes les images';
$string['media_dlg:poster'] = 'Poster';
$string['media_dlg:prefetch'] = 'Préchargement';
$string['media_dlg:preload'] = 'Précharger';
$string['media_dlg:preload_auto'] = 'Utiliser le réglage du navigateur';
$string['media_dlg:preload_metadata'] = 'Préchargement des métadonnées vidéo';
$string['media_dlg:preload_none'] = 'Ne pas précharger';
$string['media_dlg:preview'] = 'Prévisualisation';
$string['media_dlg:progress'] = 'Progression';
$string['media_dlg:qt_options'] = 'Options QuickTime';
$string['media_dlg:qt_stream_warn'] = 'Les séquences flux RTSP doivent être ajoutées au champ « Source QT » dans l’onglet avancé.
Veuillez indiquer aussi une version non streamée au champ source.';
$string['media_dlg:qtsrc'] = 'Source QT';
$string['media_dlg:qtsrcchokespeed'] = 'Débit maximum';
$string['media_dlg:quality'] = 'Qualité';
$string['media_dlg:quicktime'] = 'QuickTime';
$string['media_dlg:rate'] = 'Taux';
$string['media_dlg:realmedia'] = 'Real Media';
$string['media_dlg:rmp_options'] = 'Options Real Media Player';
$string['media_dlg:salign'] = 'SAlign';
$string['media_dlg:scale'] = 'Échelle';
$string['media_dlg:scriptcallbacks'] = 'Callbacks de script';
$string['media_dlg:shockwave'] = 'Shockwave';
$string['media_dlg:shockwave_options'] = 'Options Shockwave';
$string['media_dlg:shuffle'] = 'Aléatoire';
$string['media_dlg:size'] = 'Dimensions';
$string['media_dlg:sound'] = 'Son';
$string['media_dlg:source'] = 'Source';
$string['media_dlg:starttime'] = 'Début';
$string['media_dlg:stretchtofit'] = 'Étendre pour adapter la taille';
$string['media_dlg:swstretchhalign'] = 'Stretch horizontal';
$string['media_dlg:swstretchstyle'] = 'Style Stretch';
$string['media_dlg:swstretchvalign'] = 'Stretch vertical';
$string['media_dlg:target'] = 'Cible';
$string['media_dlg:targetcache'] = 'Cache cible';
$string['media_dlg:title'] = 'Insérer/éditer un fichier média';
$string['media_dlg:type'] = 'Type';
$string['media_dlg:uimode'] = 'Mode UI';
$string['media_dlg:video'] = 'Vidéo HTML5';
$string['media_dlg:volume'] = 'Volume';
$string['media_dlg:vspace'] = 'Espacement vertical';
$string['media_dlg:windowlessvideo'] = 'Vidéo sans fenêtre';
$string['media_dlg:windowsmedia'] = 'Windows Media';
$string['media_dlg:wmode'] = 'WMode';
$string['media_dlg:wmp_options'] = 'Option Windows Media Player';
$string['nonbreaking:nonbreaking_desc'] = 'Insérer une espace insécable';
$string['pagebreak:desc'] = 'Insérer un saut de page pour l’impression';
$string['paste:paste_text_desc'] = 'Coller comme texte brut';
$string['paste:paste_word_desc'] = 'Coller un texte créé sous Word';
$string['paste:plaintext_mode'] = 'Le collage est actuellement en mode texte non formaté. Après avoir collé quelque chose, le collage retournera en mode ordinaire.';
$string['paste:plaintext_mode_stick'] = 'Le collage est actuellement en mode texte non formaté. Veuillez cliquer à nouveau pour retourner en mode de collage ordinaire.';
$string['paste:selectall_desc'] = 'Tout sélectionner';
$string['paste_dlg:text_linebreaks'] = 'Conserver les retours à la ligne';
$string['paste_dlg:text_title'] = 'Utilisez CTRL+V pour coller le texte dans la fenêtre.';
$string['paste_dlg:word_title'] = 'Utilisez CTRL+V pour coller le texte dans la fenêtre.';
$string['pluginname'] = 'Éditeur TinyMCE (obsolète)';
$string['preview:preview_desc'] = 'Prévisualiser';
$string['print:print_desc'] = 'Imprimer';
$string['privacy:metadata'] = 'Le plugin Éditeur TinyMCE n’enregistre aucune donnée personnelle.';
$string['save:cancel_desc'] = 'Annuler toutes les modifications';
$string['save:save_desc'] = 'Enregistrer';
$string['searchreplace:delta_height'] = '';
$string['searchreplace:delta_width'] = '';
$string['searchreplace:replace_desc'] = 'Rechercher/remplacer';
$string['searchreplace:search_desc'] = 'Rechercher';
$string['searchreplace_dlg:allreplaced'] = 'Toutes les occurrences de la chaîne recherchée ont été remplacées.';
$string['searchreplace_dlg:direction'] = 'Direction';
$string['searchreplace_dlg:down'] = 'Vers le bas';
$string['searchreplace_dlg:findnext'] = 'Rechercher le suivant';
$string['searchreplace_dlg:findwhat'] = 'Rechercher ceci';
$string['searchreplace_dlg:mcase'] = 'Sensible à la casse';
$string['searchreplace_dlg:notfound'] = 'La recherche est terminée. La chaîne recherchée n’a pas été trouvée.';
$string['searchreplace_dlg:replace'] = 'Remplacer';
$string['searchreplace_dlg:replace_title'] = 'Rechercher/remplacer';
$string['searchreplace_dlg:replaceall'] = 'Tout remplacer';
$string['searchreplace_dlg:replacewith'] = 'Remplacer par';
$string['searchreplace_dlg:search_title'] = 'Rechercher';
$string['searchreplace_dlg:searchnext_desc'] = 'Suivant';
$string['searchreplace_dlg:up'] = 'Vers le haut';
$string['settings'] = 'Réglages généraux';
$string['simple:bold_desc'] = 'Gras (Ctrl+B)';
$string['simple:bullist_desc'] = 'Ajouter/supprimer liste à puces';
$string['simple:cleanup_desc'] = 'Nettoyer le code';
$string['simple:italic_desc'] = 'Italique (Ctrl+I)';
$string['simple:numlist_desc'] = 'Ajouter/supprimer liste numérotée';
$string['simple:redo_desc'] = 'Rétablir (Ctrl+Y)';
$string['simple:striketrough_desc'] = 'Barré';
$string['simple:underline_desc'] = 'Souligné (Ctrl+U)';
$string['simple:undo_desc'] = 'Annuler (Ctrl+Z)';
$string['spellchecker:desc'] = 'Activer/désactiver le vérificateur d’orthographe';
$string['spellchecker:ignore_word'] = 'Ignorer le mot';
$string['spellchecker:ignore_words'] = 'Tout ignorer';
$string['spellchecker:langs'] = 'Langues';
$string['spellchecker:learn_word'] = 'Ajouter le mot';
$string['spellchecker:menu'] = 'Paramètres du vérificateur d’orthographe';
$string['spellchecker:no_mpell'] = 'Aucune erreur trouvée.';
$string['spellchecker:no_sug'] = 'Aucune suggestion';
$string['spellchecker:sug'] = 'Suggestions';
$string['spellchecker:wait'] = 'Veuillez patienter…';
$string['style:delta_height'] = '';
$string['style:delta_width'] = '';
$string['style:desc'] = 'Éditer le style CSS';
$string['style_dlg:apply'] = 'Appliquer';
$string['style_dlg:background'] = 'Arrière-plan';
$string['style_dlg:background_attachment'] = 'Attachement';
$string['style_dlg:background_color'] = 'Couleur de fond';
$string['style_dlg:background_hpos'] = 'Position horizontale';
$string['style_dlg:background_image'] = 'Image de fond';
$string['style_dlg:background_repeat'] = 'Répéter';
$string['style_dlg:background_tab'] = 'Fond';
$string['style_dlg:background_vpos'] = 'Position verticale';
$string['style_dlg:block'] = 'Bloc';
$string['style_dlg:block_display'] = 'Affichage';
$string['style_dlg:block_letterspacing'] = 'Espacement des lettres';
$string['style_dlg:block_tab'] = 'Bloc';
$string['style_dlg:block_text_align'] = 'Alignement du texte';
$string['style_dlg:block_text_indent'] = 'Indentation du texte';
$string['style_dlg:block_vertical_alignment'] = 'Alignement vertical';
$string['style_dlg:block_whitespace'] = 'Fin de ligne';
$string['style_dlg:block_wordspacing'] = 'Espacement des mots';
$string['style_dlg:border'] = 'Bordure';
$string['style_dlg:border_tab'] = 'Bordure';
$string['style_dlg:bottom'] = 'Bas';
$string['style_dlg:box'] = 'Boîte';
$string['style_dlg:box_clear'] = 'Vider';
$string['style_dlg:box_float'] = 'Flottant';
$string['style_dlg:box_height'] = 'Hauteur';
$string['style_dlg:box_tab'] = 'Boîte';
$string['style_dlg:box_width'] = 'Largeur';
$string['style_dlg:bullet_image'] = 'Image de puce';
$string['style_dlg:clip'] = 'Clip';
$string['style_dlg:color'] = 'Couleur';
$string['style_dlg:height'] = 'Hauteur';
$string['style_dlg:left'] = 'Gauche';
$string['style_dlg:list'] = 'Liste';
$string['style_dlg:list_tab'] = 'Liste';
$string['style_dlg:list_type'] = 'Type';
$string['style_dlg:margin'] = 'Marge';
$string['style_dlg:overflow'] = 'Débordement';
$string['style_dlg:padding'] = 'Espacement';
$string['style_dlg:placement'] = 'Placement';
$string['style_dlg:position'] = 'Position';
$string['style_dlg:positioning_tab'] = 'Positionnement';
$string['style_dlg:positioning_type'] = 'Type';
$string['style_dlg:right'] = 'Droit';
$string['style_dlg:same'] = 'Identique pour tous';
$string['style_dlg:style'] = 'Style';
$string['style_dlg:text'] = 'Texte';
$string['style_dlg:text_blink'] = 'Clignotant';
$string['style_dlg:text_case'] = 'Casse';
$string['style_dlg:text_color'] = 'Couleur';
$string['style_dlg:text_decoration'] = 'Décoration';
$string['style_dlg:text_font'] = 'Police';
$string['style_dlg:text_lineheight'] = 'Hauteur de ligne';
$string['style_dlg:text_none'] = 'Aucun';
$string['style_dlg:text_overline'] = 'Ligne au-dessus';
$string['style_dlg:text_props'] = 'Texte';
$string['style_dlg:text_size'] = 'Taille';
$string['style_dlg:text_striketrough'] = 'Barré';
$string['style_dlg:text_style'] = 'Style';
$string['style_dlg:text_tab'] = 'Texte';
$string['style_dlg:text_underline'] = 'Souligné';
$string['style_dlg:text_variant'] = 'Variante';
$string['style_dlg:text_weight'] = 'Gras';
$string['style_dlg:title'] = 'Modifier le style CSS';
$string['style_dlg:toggle_insert_span'] = 'Insérer une balise span à la sélection';
$string['style_dlg:top'] = 'Haut';
$string['style_dlg:visibility'] = 'Visibilité';
$string['style_dlg:width'] = 'Largeur';
$string['style_dlg:zindex'] = 'Z-index';
$string['subplugintype_tinymce'] = 'Plugin';
$string['subplugintype_tinymce_plural'] = 'Plugins';
$string['table:cell'] = 'Cellule';
$string['table:cell_desc'] = 'Propriétés de la cellule';
$string['table:cellprops_delta_height'] = '';
$string['table:cellprops_delta_width'] = '';
$string['table:col'] = 'Colonne';
$string['table:col_after_desc'] = 'Insérer une colonne après';
$string['table:col_before_desc'] = 'Insérer une colonne avant';
$string['table:copy_row_desc'] = 'Copier la ligne';
$string['table:cut_row_desc'] = 'Couper la ligne';
$string['table:del'] = 'Supprimer le tableau';
$string['table:delete_col_desc'] = 'Supprimer la colonne';
$string['table:delete_row_desc'] = 'Effacer la ligne';
$string['table:desc'] = 'Insérer/modifier tableau';
$string['table:merge_cells_delta_height'] = '';
$string['table:merge_cells_delta_width'] = '';
$string['table:merge_cells_desc'] = 'Fusionner les cellules';
$string['table:paste_row_after_desc'] = 'Coller la ligne après';
$string['table:paste_row_before_desc'] = 'Coller la ligne avant';
$string['table:props_desc'] = 'Propriétés du tableau';
$string['table:row'] = 'Ligne';
$string['table:row_after_desc'] = 'Insérer une ligne après';
$string['table:row_before_desc'] = 'Insérer une ligne avant';
$string['table:row_desc'] = 'Propriétés de la ligne';
$string['table:rowprops_delta_height'] = '';
$string['table:rowprops_delta_width'] = '';
$string['table:split_cells_desc'] = 'Scinder les cellules fusionnées';
$string['table:table_delta_height'] = '';
$string['table:table_delta_width'] = '';
$string['table_dlg:advanced_props'] = 'Propriétés avancées';
$string['table_dlg:advanced_tab'] = 'Avancé';
$string['table_dlg:align'] = 'Alignement';
$string['table_dlg:align_bottom'] = 'Bas';
$string['table_dlg:align_default'] = 'Par défaut';
$string['table_dlg:align_left'] = 'Gauche';
$string['table_dlg:align_middle'] = 'Centré';
$string['table_dlg:align_right'] = 'Droite';
$string['table_dlg:align_top'] = 'Haut';
$string['table_dlg:bgcolor'] = 'Couleur du fond';
$string['table_dlg:bgimage'] = 'Image de fond';
$string['table_dlg:border'] = 'Bordure';
$string['table_dlg:bordercolor'] = 'Couleur de la bordure';
$string['table_dlg:caption'] = 'Afficher la légende du tableau';
$string['table_dlg:cell_all'] = 'Mettre à jour toutes les cellules du tableau';
$string['table_dlg:cell_cell'] = 'Mettre à jour la cellule courante';
$string['table_dlg:cell_col'] = 'Modifier toutes les cellules de la colonne';
$string['table_dlg:cell_limit'] = 'Vous avez dépassé le nombre maximum de cellules ({$cells}).';
$string['table_dlg:cell_row'] = 'Mettre à jour toutes les cellules de la ligne';
$string['table_dlg:cell_title'] = 'Propriétés de la cellule';
$string['table_dlg:cell_type'] = 'Type de cellule';
$string['table_dlg:cellpadding'] = 'Espacement dans les cellules';
$string['table_dlg:cellspacing'] = 'Espacement entre cellules';
$string['table_dlg:col_limit'] = 'Vous avez dépassé le nombre maximum de colonnes ({$cols}).';
$string['table_dlg:colgroup'] = 'Groupe de colonnes';
$string['table_dlg:cols'] = 'Colonnes';
$string['table_dlg:frame'] = 'Cadre';
$string['table_dlg:frame_all'] = 'tous';
$string['table_dlg:frame_cols'] = 'colonnes';
$string['table_dlg:frame_groups'] = 'groupe';
$string['table_dlg:frame_none'] = 'aucun';
$string['table_dlg:frame_rows'] = 'lignes';
$string['table_dlg:general_props'] = 'Propriétés générales';
$string['table_dlg:general_tab'] = 'Général';
$string['table_dlg:height'] = 'Hauteur';
$string['table_dlg:id'] = 'ID';
$string['table_dlg:langcode'] = 'Code de la langue';
$string['table_dlg:langdir'] = 'Sens de lecture';
$string['table_dlg:ltr'] = 'De gauche à droite';
$string['table_dlg:merge_cells_title'] = 'Fusionner les cellules';
$string['table_dlg:mime'] = 'Type MIME de la cible';
$string['table_dlg:missing_scope'] = 'Voulez-vous vraiment continuer sans spécifier de portée pour cette cellule de titre ? Sans cela, il sera difficile pour certains utilisateurs de comprendre le contenu ou les données affichées dans le tableau.';
$string['table_dlg:row_all'] = 'Mettre à jour toutes les lignes du tableau';
$string['table_dlg:row_even'] = 'Mettre à jour les lignes paires';
$string['table_dlg:row_limit'] = 'Vous avez dépassé le nombre maximum de lignes ({$rows}).';
$string['table_dlg:row_odd'] = 'Mettre à jour les lignes impaires';
$string['table_dlg:row_row'] = 'Mettre à jour la ligne courante';
$string['table_dlg:row_title'] = 'Propriétés de la ligne';
$string['table_dlg:rowgroup'] = 'Groupe de rangées';
$string['table_dlg:rows'] = 'Lignes';
$string['table_dlg:rowtype'] = 'Type de rangée';
$string['table_dlg:rtl'] = 'de droite à gauche';
$string['table_dlg:rules'] = 'Règles';
$string['table_dlg:rules_above'] = 'au-dessus';
$string['table_dlg:rules_below'] = 'au-dessous';
$string['table_dlg:rules_border'] = 'bordure';
$string['table_dlg:rules_box'] = 'boîte';
$string['table_dlg:rules_hsides'] = 'horizontales';
$string['table_dlg:rules_lhs'] = 'à gauche';
$string['table_dlg:rules_rhs'] = 'à droite';
$string['table_dlg:rules_void'] = 'aucune';
$string['table_dlg:rules_vsides'] = 'verticales';
$string['table_dlg:scope'] = 'Portée';
$string['table_dlg:style'] = 'Style';
$string['table_dlg:summary'] = 'Résumé';
$string['table_dlg:tbody'] = 'Corps';
$string['table_dlg:td'] = 'Données';
$string['table_dlg:tfoot'] = 'Pied';
$string['table_dlg:th'] = 'Titre';
$string['table_dlg:thead'] = 'En-tête';
$string['table_dlg:title'] = 'Insérer/modifier tableau';
$string['table_dlg:valign'] = 'Alignement vertical';
$string['table_dlg:width'] = 'Largeur';
$string['template:desc'] = 'Insérer un modèle prédéfini.';
$string['template_dlg:cdate_format'] = '%d/%m/%Y %H:%M:%S';
$string['template_dlg:day_long'] = 'Dimanche,Lundi,Mardi,Mercredi,Jeudi,Vendredi,Samedi,Dimanche';
$string['template_dlg:day_short'] = 'Dim,Lun,Mar,Mer,Jeu,Ven,Sam,Dim';
$string['template_dlg:desc'] = 'Insérer un modèle prédéfini';
$string['template_dlg:desc_label'] = 'Description';
$string['template_dlg:label'] = 'Modèle';
$string['template_dlg:mdate_format'] = '%d/%m/%Y %H:%M:%S';
$string['template_dlg:months_long'] = 'Janvier,Février,Mars,Avril,Mai,Juin,Juillet,Août,Septembre,Octobre,Novembre,Décembre';
$string['template_dlg:months_short'] = 'Jan,Fév,Mar,Avr,Mai,Juin,Juil,Août,Sep,Oct,Nov,Déc';
$string['template_dlg:preview'] = 'Prévisualisation';
$string['template_dlg:select'] = 'Choisir un modèle';
$string['template_dlg:title'] = 'Modèles';
$string['template_dlg:warning'] = 'Attention : la modification d’un modèle sur la base d’un autre peut entraîner une perte de données !';
$string['visualblocks:desc'] = 'Afficher/cacher les éléments blocs';
$string['visualchars:desc'] = 'Afficher/cacher les caractères de mise en page.';
$string['wordcount:words'] = 'Mots :';
$string['xhtmlxtras:abbr_delta_height'] = '';
$string['xhtmlxtras:abbr_delta_width'] = '';
$string['xhtmlxtras:abbr_desc'] = 'Abréviation';
$string['xhtmlxtras:acronym_delta_height'] = '';
$string['xhtmlxtras:acronym_delta_width'] = '';
$string['xhtmlxtras:acronym_desc'] = 'Acronyme';
$string['xhtmlxtras:attribs_delta_height'] = '';
$string['xhtmlxtras:attribs_delta_width'] = '';
$string['xhtmlxtras:attribs_desc'] = 'Insérer/modifier les attributs';
$string['xhtmlxtras:cite_delta_height'] = '';
$string['xhtmlxtras:cite_delta_width'] = '';
$string['xhtmlxtras:cite_desc'] = 'Citation';
$string['xhtmlxtras:del_delta_height'] = '';
$string['xhtmlxtras:del_delta_width'] = '';
$string['xhtmlxtras:del_desc'] = 'Barré';
$string['xhtmlxtras:ins_delta_height'] = '';
$string['xhtmlxtras:ins_delta_width'] = '';
$string['xhtmlxtras:ins_desc'] = 'Inséré';
$string['xhtmlxtras_dlg:attrib_tab'] = 'Attributs';
$string['xhtmlxtras_dlg:attribs_title'] = 'Insérer/modifier les attributs';
$string['xhtmlxtras_dlg:attribute_attrib_tab'] = 'Attributs';
$string['xhtmlxtras_dlg:attribute_events_tab'] = 'Événements';
$string['xhtmlxtras_dlg:attribute_label_accesskey'] = 'Accesskey';
$string['xhtmlxtras_dlg:attribute_label_cite'] = 'Citation';
$string['xhtmlxtras_dlg:attribute_label_class'] = 'Classe';
$string['xhtmlxtras_dlg:attribute_label_datetime'] = 'Date/heure';
$string['xhtmlxtras_dlg:attribute_label_id'] = 'ID';
$string['xhtmlxtras_dlg:attribute_label_langcode'] = 'Langue';
$string['xhtmlxtras_dlg:attribute_label_langdir'] = 'Sens de lecture';
$string['xhtmlxtras_dlg:attribute_label_style'] = 'Style';
$string['xhtmlxtras_dlg:attribute_label_tabindex'] = 'TabIndex';
$string['xhtmlxtras_dlg:attribute_label_title'] = 'Titre';
$string['xhtmlxtras_dlg:attribute_option_ltr'] = 'De gauche à droite';
$string['xhtmlxtras_dlg:attribute_option_rtl'] = 'De droite à gauche';
$string['xhtmlxtras_dlg:events_tab'] = 'Événements';
$string['xhtmlxtras_dlg:fieldset_attrib_tab'] = 'Attributs de l’élément';
$string['xhtmlxtras_dlg:fieldset_events_tab'] = 'Événements de l’élément';
$string['xhtmlxtras_dlg:fieldset_general_tab'] = 'Paramètres généraux';
$string['xhtmlxtras_dlg:general_tab'] = 'Général';
$string['xhtmlxtras_dlg:insert_date'] = 'Insérer la date et l’heure actuelles';
$string['xhtmlxtras_dlg:option_ltr'] = 'De gauche à droite';
$string['xhtmlxtras_dlg:option_rtl'] = 'De droite à gauche';
$string['xhtmlxtras_dlg:remove'] = 'Enlever';
$string['xhtmlxtras_dlg:title_abbr_element'] = 'Abréviation';
$string['xhtmlxtras_dlg:title_acronym_element'] = 'Acronyme';
$string['xhtmlxtras_dlg:title_cite_element'] = 'Citation';
$string['xhtmlxtras_dlg:title_del_element'] = 'Suppression';
$string['xhtmlxtras_dlg:title_ins_element'] = 'Insertion';
