<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_boost_magnific', language 'el', version '4.1'.
 *
 * @package     theme_boost_magnific
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['background_color'] = 'Χρώμα Φόντου';
$string['background_color_desc'] = 'Χρώμα φόντου για την κορυφή και το υποσέλιδο!';
$string['background_color_random'] = 'Τυχαίο Θέμα {$a}';
$string['background_text_color'] = 'Χρώμα Κειμένου';
$string['background_text_color_desc'] = 'Χρώμα Κειμένου Κορυφής και Υποσέλιδου!';
$string['choosereadme'] = 'Το Boost Magnific είναι ένα θέμα φτιαγμένο με φροντίδα για να φέρει χαρούμενα χρώματα στο Moodle.';
$string['contact_address'] = 'Διεύθυνση';
$string['contact_email'] = 'Ηλεκτρονικό ταχυδρομείο';
$string['contact_phone'] = 'Αριθμός Τηλεφώνου';
$string['content_type_default'] = 'Προεπιλογή Moodle';
$string['content_type_empty'] = '(Χωρίς περιεχόμενο)';
$string['content_type_footer'] = 'Τύπος περιεχομένου για το υποσέλιδο';
$string['content_type_footer_desc'] = 'Επιλέξτε τον τύπο περιεχομένου που θέλετε να εμφανίζεται στο υποσέλιδο.';
$string['content_type_home'] = 'Τύπος περιεχομένου για την αρχική σελίδα';
$string['content_type_home_desc'] = 'Επιλέξτε τον τύπο περιεχομένου που θέλετε να εμφανίζεται στην αρχική σελίδα.';
$string['content_type_html'] = 'Σελίδα που θα δημιουργηθεί με τον επεξεργαστή';
$string['continuar'] = 'Συνεχίστε να μελετάτε';
$string['countlesson'] = '{$a} μάθημα';
$string['countlessons'] = '{$a} μαθήματα';
$string['course_access'] = 'Πρόσβαση στο μάθημα';
$string['course_moore'] = 'Περισσότερες λεπτομέρειες';
$string['customcss'] = 'Προσαρμοσμένο CSS';
$string['customcss_desc'] = 'Όποιες κανόνες CSS προσθέσετε σε αυτή την περιοχή κειμένου θα εφαρμόζονται σε όλες τις σελίδες, κάνοντάς το εύκολο να προσαρμόσετε αυτό το θέμα.';
$string['custommenuitems'] = 'Προσαρμοσμένα Στοιχεία Κορυφαίου Μενού';
$string['custommenuitems_desc'] = 'Μπορείτε να δημιουργήσετε ένα προσαρμοσμένο μενού δίπλα στα κορυφαία μενού. Το κύριο μενού πρέπει να ξεκινάει στο χείλος και τα υπομενού πρέπει να προηγούνται από έναν παύλα (-). Ο αριθμός των παυλών καθορίζει το βάθος του στοιχείου. Έτσι, τα στοιχεία με μία παύλα εμφανίζονται σε ένα υπομενού κάτω από το προηγούμενο κορυφαίο στοιχείο, και τα στοιχεία με δύο παυλές εμφανίζονται σε ένα υπομενού κάτω από το προηγούμενο υπομενού.
Το περιεχόμενο κάθε στοιχείου μενού πρέπει να αποτελείται από έως τρία στοιχεία (<strong>ετικέτα</strong> | <strong>διεύθυνση URL</strong> | <strong>υποσημείωση</strong> | <strong>γλώσσα</strong>), το καθένα χωρισμένο από το χαρακτήρα "|".
<ul>
<li><strong>ετικέτα</strong>: Αυτό είναι το κείμενο που θα εμφανίζεται εντός του στοιχείου μενού. Πρέπει να προσδιορίσετε μια ετικέτα για κάθε στοιχείο μενού.</li>
<li><strong>διεύθυνση URL</strong>: Αυτή είναι η διεύθυνση URL στην οποία θα μεταφερθεί ο χρήστης κατά το κλικ στο στοιχείο μενού. Αυτό είναι προαιρετικό; αν δεν παρασχεθεί, το στοιχείο δεν θα συνδεθεί πουθενά.<br>
Άλλα χαρακτηριστικά, όπως το "target", μπορούν να προστεθούν στο τέλος της διεύθυνσης URL.</li>
<li><strong>υποσημείωση</strong>: Αν παρέχετε μια διεύθυνση URL, μπορείτε επίσης να επιλέξετε να παρέχετε μια υποσημείωση για το σύνδεσμο που δημιουργείται με την URL. Αυτό είναι προαιρετικό και, αν δεν οριστεί, η ετικέτα χρησιμοποιείται ως υποσημείωση για το στοιχείο μενού.</li>
<li><strong>γλώσσα</strong>: Μπορείτε να προσθέσετε έναν κωδικό γλώσσας (ή μια λίστα κωδίκων χωρισμένη με κόμμα) ως το τέταρτο στοιχείο της γραμμής. Η γραμμή θα εμφανίζεται μόνο αν ο χρήστης έχει επιλέξει τη γλώσσα (ες) που παρατίθενται.</li>
</ul>
Παρακάτω είναι ένα παράδειγμα για το πώς να δημιουργήσετε ένα προσαρμοσμένο μενού:
<blockquote><pre>
Μαθήματα
-Όλα τα μαθήματα | /course/
-Τα μαθήματά μου
--Παράδειγμα Μάθημα
---Παράδειγμα Μάθημα 7 | /course/view.php?id=7
---Παράδειγμα Μάθημα 9 | /course/view.php?id=9
--Δοκιμαστικό Μάθημα
---Δοκιμαστικό Μάθημα 2 | /course/view.php?id=2
---Δοκιμαστικό Μάθημα 5 | /course/view.php?id=5
Google
-Google σε οποιαδήποτε γλώσσα | https://google.com/" target="_blank
-Google στο Μεξικό | https://www.google.com.mx/" target="_blank|Ετικέτα Google|en
-Google στα Πορτογαλικά | https://google.com.br/" target="_blank|Ετικέτα Google|pt,pt_br,pt_br_kids
Σελίδα Υποστήριξης | https://support.com/" target="_blank
</pre></blockquote>
Για το Moodle με υποστήριξη για πολλές γλώσσες, η τιμή της <strong>ετικέτας</strong> θα πρέπει να είναι διαμορφωμένη ως <strong>"langstringname,componentname"</strong>.
<blockquote><pre>
profile,moodle | /user/profile.php
messages,message | /message/index.php
</pre></blockquote>
<a href="https://docs.moodle.org/404/en/Advanced_theme_settings" target="_blank">Περισσότερες πληροφορίες μενού</a>';
$string['editor_link_footer'] = 'Επεξεργαστείτε το μπλοκ υποσέλιδου για τη γλώσσα {$a}';
$string['editor_link_footer_all'] = 'Επεξεργαστείτε το μπλοκ υποσέλιδου για όλες τις γλώσσες';
$string['editor_link_home'] = 'Επεξεργαστείτε την αρχική σελίδα για τη γλώσσα {$a}';
$string['editor_link_home_all'] = 'Επεξεργαστείτε την αρχική σελίδα για όλες τις γλώσσες';
$string['favicon'] = 'Αγαπ.εικονίδιο';
$string['favicon_desc'] = 'Το favicon εμφανίζεται δίπλα στον τίτλο της σελίδας στην καρτέλα του προγράμματος περιήγησης. Εμφανίζεται το favicon του Moodle αν δεν παρέχεται κάποιο προσαρμοσμένο favicon.';
$string['fontfamily'] = 'Γραμματοσειρές Κειμένου Ιστοσελίδας';
$string['fontfamily_desc'] = 'Επιλέξτε ποια γραμματοσειρά θέλετε να χρησιμοποιήσετε για το κείμενο στον ιστότοπο Moodle σας.';
$string['fontfamily_menus'] = 'Γραμματοσειρές Μενού';
$string['fontfamily_menus_desc'] = 'Επιλέξτε ποια γραμματοσειρά θέλετε να χρησιμοποιήσετε για τα μενού στον ιστότοπο Moodle σας.';
$string['fontfamily_sitename'] = 'Γραμματοσειρά για το όνομα του ιστότοπου';
$string['fontfamily_sitename_desc'] = 'Η γραμματοσειρά που θα εφαρμοστεί στο όνομα του ιστότοπου αν δεν παρέχεται λογότυπο.';
$string['fontfamily_title'] = 'Γραμματοσειρές Τίτλων Κειμένων';
$string['fontfamily_title_desc'] = 'Επιλέξτε ποια γραμματοσειρά θέλετε να χρησιμοποιήσετε για τους τίτλους στον ιστότοπο Moodle σας.';
$string['fontpreview'] = 'Προεπισκόπηση Λίστας Γραμματοσειρών';
$string['footer_contact_title'] = 'Τίτλος Μπλοκ Επικοινωνίας';
$string['footer_contact_title_default'] = 'Επικοινωνήστε μαζί μας';
$string['footer_contact_title_desc'] = 'Εισάγετε τον τίτλο του μπλοκ που θα εμφανίζεται στο υποσέλιδο με τα στοιχεία επικοινωνίας.';
$string['footer_description'] = 'Περιγραφή';
$string['footer_description_desc'] = 'Περιγράψτε το Moodle σας, τι κάνετε, και αυτή η πληροφορία θα εμφανίζεται κάτω από το λογότυπο στο υποσέλιδο του Moodle';
$string['footer_frontpage_blockcourses_instructor'] = 'Εμφάνιση του ονόματος του Καθηγητή';
$string['footer_frontpage_blockcourses_instructor_desc'] = 'Αν επιλεγεί, εμφανίζονται τα ονόματα των καθηγητών στη λίστα των μαθημάτων!';
$string['footer_frontpage_blockcourses_text'] = 'Σύντομο κείμενο εξηγώντας το μπλοκ "{$a}"';
$string['footer_frontpage_blockcourses_text_desc'] = 'Προσθέστε ένα κείμενο που μιλάει για "{$a}"!';
$string['footer_links_title'] = 'Τίτλος μπλοκ Συνδέσμων';
$string['footer_links_title_default'] = 'Σημαντικοί Σύνδεσμοι';
$string['footer_show_copywriter'] = 'Εμφάνιση Φτιαγμένο με ❤️';
$string['footer_show_copywriter_desc'] = 'Αποεπιλέξτε αν θέλετε να κρύψετε το "Φτιαγμένο με ❤️"';
$string['footer_social_title'] = 'Τίτλος Κοινωνικού Μπλοκ Συνδέσμων';
$string['footer_social_title_default'] = 'Ακολουθήστε μας στα κοινωνικά μέσα';
$string['footer_social_title_desc'] = 'Εισαγάγετε τον τίτλο του μπλοκ που θα εμφανίζεται στο υποσέλιδο με τα δεδομένα από τα κοινωνικά σας δίκτυα.';
$string['footerblink'] = 'Σύνδεσμοι Υποσέλιδου Μπλοκ';
$string['footerblink_desc'] = 'Μπορείτε να ρυθμίσετε έναν Σύνδεσμο Υποσέλιδου Μπλοκ εδώ για να εμφανίζεται από τα θέματα.<br>Κάθε γραμμή αποτελείται από κάποιο κείμενο μενού ή κλειδί γλώσσας ή κείμενο, μια διεύθυνση URL σύνδεσμου (προαιρετικά), χωρισμένα με κάθετους διαχωριστές. Για παράδειγμα:<br><pre>Υποστήριξη Moodle|https://moodle.org/support</pre>';
$string['footerblock_contact'] = 'Μπλοκ Επαφής';
$string['footerblock_copywriter'] = 'Φτιαγμένο με ❤️';
$string['footerblock_description'] = 'Μπλοκ Περιγραφής';
$string['footerblock_links'] = 'Μπλοκ Συνδέσμων';
$string['footerblock_social'] = 'Κοινωνικό μπλοκ';
$string['free_name'] = 'Δωρεάν';
$string['frontpage_about_description'] = 'Περιγράψτε τι κάνετε';
$string['frontpage_about_description_desc'] = 'Περιγράψτε σε το πολύ 5 γραμμές τον σκοπό του Moodle σας';
$string['frontpage_about_enable'] = 'Ενεργοποιήστε το μπλοκ Σχετικά';
$string['frontpage_about_enable_desc'] = 'Αν είναι επιλεγμένο, το μπλοκ Σχετικά θα εμφανίζεται κάτω από την Κορυφή!';
$string['frontpage_about_info'] = 'Πλαίσιο δεδομένων {$a}';
$string['frontpage_about_logo'] = 'Διαφορετικό λογότυπο που θα εμφανίζεται εδώ';
$string['frontpage_about_logo_desc'] = 'Αν οριστεί, αυτό το λογότυπο θα χρησιμοποιηθεί εδώ αντί του Κορυφαίου λογότυπου.<br>Η κενή χρήση χρησιμοποιεί το Κορυφαίο Λογότυπο!';
$string['frontpage_about_number'] = 'Ποσότητα δεδομένων';
$string['frontpage_about_number_desc'] = 'Εισαγάγετε την ποσότητα των πληροφοριών που αναφέρθηκαν παραπάνω';
$string['frontpage_about_text'] = 'Όνομα δεδομένων';
$string['frontpage_about_text_1_defalt'] = 'Μαθήματα';
$string['frontpage_about_text_2_defalt'] = 'Δάσκαλοι';
$string['frontpage_about_text_3_defalt'] = 'Σπουδαστές';
$string['frontpage_about_text_4_defalt'] = 'Μαθήματα';
$string['frontpage_about_text_desc'] = 'Εισαγάγετε το όνομα των δεδομένων που θα εμφανίζονται στην αρχική σελίδα';
$string['frontpage_about_title'] = 'Τίτλος μπλοκ Σχετικά';
$string['frontpage_about_title_default'] = 'Η Παγκόσμια Κοινότητά μας';
$string['heart'] = 'Αν σας αρέσει αυτό το θέμα, μην ξεχάσετε να κάνετε κλικ ❤️ στη σελίδα θεμάτων <a href="{$a}" target="_blank">κάνοντας κλικ εδώ</a>';
$string['instructor'] = 'Εκπαιδευτής';
$string['login_backgroundcolor'] = 'Χρώμα Φόντου';
$string['login_backgroundcolor_desc'] = 'Επιλέξτε το χρώμα φόντου για την σελίδα ανάκτησης κωδικού';
$string['login_backgroundfoto'] = 'Εικόνα Φόντου';
$string['login_backgroundfoto_desc'] = 'Επιλέξτε την εικόνα φόντου για την οθόνη Σύνδεσης/Ανάκτησης Κωδικού/Δημιουργίας Λογαριασμού. Η προεπιλεγμένη εικόνα είναι: {$a}';
$string['login_forgot_description'] = 'Κείμενο στο πλάι της Οθόνης Ξεχασμένου Κωδικού';
$string['login_forgot_description_desc'] = 'Κείμενο που θα εμφανίζεται μόνο στην οθόνη Ξεχασμένου Κωδικού';
$string['login_login_description'] = 'Κείμενο στο πλάι της Οθόνης Σύνδεσης';
$string['login_login_description_desc'] = 'Κείμενο που θα εμφανίζεται μόνο στην οθόνη σύνδεσης';
$string['login_signup_description'] = 'Κείμενο στο πλάι της Οθόνης Δημιουργίας Λογαριασμού';
$string['login_signup_description_desc'] = 'Κείμενο που θα εμφανίζεται μόνο στην οθόνη Δημιουργίας Λογαριασμού';
$string['login_theme'] = 'Θέμα σύνδεσης';
$string['login_theme_block'] = 'Κεντρικό λευκό μπλοκ με προαιρετικό φόντο';
$string['login_theme_desc'] = 'Επιλέξτε ποιο θέμα θέλετε στην περιοχή σύνδεσης';
$string['login_theme_login'] = 'Μόνο οθόνη σύνδεσης, χωρίς πλευρική εικόνα';
$string['logo_color'] = 'Χρωματιστό Λογότυπο';
$string['logo_color_desc'] = 'Παρακαλώ ανεβάστε το χρωματιστό ΛΟΓΟΤΥΠΟ σας εάν θέλετε να το συμπεριλάβετε στην κορυφή. Αυτό το λογότυπο θα εμφανίζεται καθώς η σελίδα κυλάει, και το μενού θα εμφανίζεται σε λευκό φόντο.';
$string['logo_write'] = 'Λογότυπο κεντρικού μενού κατά την κύλιση';
$string['logo_write_desc'] = 'Φορτώστε το λογότυπό σας αν επιθυμείτε να το συμπεριλάβετε στην κορυφή. Αυτό το λογότυπο θα εμφανίζεται όταν η κύλιση παραμένει στην κορυφή, και το μενού θα εμφανίζεται σε έναν χρωματισμένο φόντο.';
$string['matricular'] = 'Εγγραφή';
$string['mycourses_color'] = 'Χρώμα φόντου Μπλοκ';
$string['mycourses_color_desc'] = 'Το χρώμα φόντου για το μπλοκ.';
$string['mycourses_icon'] = 'Εικονίδιο';
$string['mycourses_icon_desc'] = 'Ένα αντιπροσωπευτικό εικονίδιο για το μπλοκ. Το μέγεθος του εικονιδίου πρέπει να είναι 48x48 pixels.';
$string['mycourses_info'] = 'Μπλοκ {$a}';
$string['mycourses_numblocos'] = 'Χωρίς μπλοκ';
$string['mycourses_numblocos_desc'] = 'Πόσες εικόνες θέλετε στην παρουσίαση διαφανειών;';
$string['mycourses_numblocos_nenhum'] = 'Χωρίς διαφάνειες στην αρχική σελίδα';
$string['mycourses_title'] = 'Σύντομος Τίτλος Μπλοκ';
$string['mycourses_title_desc'] = 'Ένας σύντομος και περιγραφικός τίτλος για το μπλοκ.';
$string['mycourses_url'] = 'Σύνδεσμος Μπλοκ';
$string['mycourses_url_desc'] = 'Η διεύθυνση URL στην οποία θα μεταφερθεί ο χρήστης όταν κάνει κλικ στο μπλοκ. Μπορεί να είναι εξωτερικός ή εσωτερικός σύνδεσμος στην πλατφόρμα.';
$string['pluginname'] = 'Boost Magnific';
$string['privacy:metadata'] = 'Το θέμα Boost Magnific δεν αποθηκεύει προσωπικά δεδομένα για οποιονδήποτε χρήστη.';
$string['settings_about_heading'] = 'Σχετικά με το Moodle σας';
$string['settings_css_heading'] = 'Γραμματοσειρές και CSS';
$string['settings_footer_heading'] = 'Μπλοκ υποσέλιδου';
$string['settings_icons_change_icons'] = 'Αλλαγή του προεπιλεγμένου εικονιδίου στη λίστα μαθημάτων';
$string['settings_login_heading'] = 'Οθόνη σύνδεσης';
$string['settings_mycourses_heading'] = 'Μπλοκ Μαθημάτων μου';
$string['settings_slideshow_heading'] = 'SlideShow';
$string['settings_theme_heading'] = 'Θέμα';
$string['settings_top_heading'] = 'Κορυφαίο Μενού';
$string['sitefonts'] = 'Επιπλέον Γραμματοσειρές Google';
$string['sitefonts_desc'] = 'Εισάγετε τον κώδικα @import από τις Γραμματοσειρές Google όπως υποδεικνύεται στην εικόνα παρακάτω. Μετά την αποθήκευση, το πεδίο "Γραμματοσειρά Ιστοσελίδας" θα ενημερωθεί, εμφανίζοντας αυτές τις γραμματοσειρές. Μπορείτε να προσθέσετε πολλαπλά @import αν χρειαστεί.';
$string['slidecaption_desc'] = 'Εισάγετε το κείμενο λεζάντας που θα χρησιμοποιηθεί στην εικόνα';
$string['slideshow_image'] = 'Εικόνα διαφάνειας';
$string['slideshow_image_desc'] = 'Η εικόνα πρέπει να είναι 1250px X 400px.';
$string['slideshow_info'] = 'Διαφάνεια {$a}';
$string['slideshow_numslides'] = 'Πόσες εικόνες στην Παρουσίαση Διαφανειών';
$string['slideshow_numslides_desc'] = 'Πόσες εικόνες θέλετε στην Παρουσίαση Διαφανειών;';
$string['slideshow_numslides_nenhum'] = 'Καμία διαφάνεια στην Αρχική';
$string['slideshow_text'] = 'Σύντομο περιγραφικό κείμενο για τη Διαφάνεια';
$string['slideshow_text_desc'] = 'Εισαγάγετε ένα σύντομο κείμενο για τη διαφάνεια.';
$string['slideshow_url'] = 'Σύνδεσμος κουμπιού διαφάνειας';
$string['slideshow_url_desc'] = 'Εισαγάγετε τον σύνδεσμο προορισμού για το κουμπί εικόνας της διαφάνειας';
$string['social_facebook'] = 'Το Facebook σας';
$string['social_facebook_desc'] = 'Η διεύθυνση URL του Facebook του οργανισμού σας.';
$string['social_instagram'] = 'Το Instagram σας';
$string['social_instagram_desc'] = 'Η διεύθυνση URL του Instagram του οργανισμού σας.';
$string['social_linkedin'] = 'Το Linkedin σας';
$string['social_linkedin_desc'] = 'Η διεύθυνση URL του Linkedin του οργανισμού σας.';
$string['social_twitter'] = 'Το Twitter σας';
$string['social_twitter_desc'] = 'Η διεύθυνση URL του Twitter του οργανισμού σας.';
$string['social_youtube'] = 'Το Youtube σας';
$string['social_youtube_desc'] = 'Η διεύθυνση URL του Youtube του οργανισμού σας.';
$string['theme_boost_magnific_about_editbooton'] = 'Επεξεργασία μπλοκ Σχετικά';
$string['theme_boost_magnific_frontpage_bloco'] = 'Μπλοκ "{$a}"';
$string['theme_boost_magnific_frontpage_home'] = 'Μπλοκ Αρχικής Σελίδας';
$string['theme_color-color_primary'] = 'Κύριο Χρώμα';
$string['theme_color-color_primary_desc'] = 'Το κύριο χρώμα του θέματος, συνήθως χρησιμοποιούμενο για τόνωση και επισήμανση στοιχείων.';
$string['theme_color-color_secondary'] = 'Δευτερεύον Χρώμα';
$string['theme_color-color_secondary_desc'] = 'Ένα δευτερεύον χρώμα που συμπληρώνει το κύριο χρώμα, χρησιμοποιούμενο για την επισήμανση δευτερευόντων στοιχείων ή για αντίθεση με το κύριο χρώμα.';
$string['theme_color_desc'] = 'Επιλέξτε τα χρώματα των κειμένων και κουμπιών του Moodle ή κάντε κλικ στη γραμμή παρακάτω:';
$string['theme_color_heading'] = 'Επιλογή Χρώματος Περιβάλλοντος';
$string['theme_color_sugestion'] = 'Πρόταση Χρώματος';
$string['theme_color_sugestion_text'] = 'Κάντε κλικ στη γραμμή για να εφαρμόσετε το χρώμα στα πεδία παρακάτω:';
$string['theme_login_branco'] = 'Οθόνη σύνδεσης μόνο, χωρίς εικόνα στο πλάι, με τη φόρμα σε λευκό φόντο';
$string['top_color_heading'] = 'Χρώμα Κύλισης Πάνω';
$string['top_scroll'] = 'Καρφώστε το μενού κατά την κύλιση της σελίδας';
$string['top_scroll_background_color'] = 'Χρώμα Φόντου Κύριου Μενού κατά την Κύλιση';
$string['top_scroll_background_color_desc'] = 'Ορίστε το χρώμα φόντου όταν κυλάτε τη σελίδα.';
$string['top_scroll_desc'] = 'Όταν είναι ενεργοποιημένο, το μενού θα καρφωθεί στην κορυφή της οθόνης καθώς κυλάτε τη σελίδα, εξασφαλίζοντας εύκολη πρόσβαση στις επιλογές του μενού.';
$string['top_scroll_text_color'] = 'Χρώμα Κειμένου Μενού κατά την Κύλιση';
$string['top_scroll_text_color_desc'] = 'Ορίστε το χρώμα κειμένου του μενού κατά την κύλιση της σελίδας.';
$string['vvveb_footer_contact_title_default'] = 'Επικοινωνήστε μαζί μας';
$string['vvveb_home_access'] = 'Πρόσβαση στο μάθημα';
$string['vvveb_home_automatically_catalogo'] = 'Μην επεξεργαστείτε. Αυτό το μπλοκ θα αντικατασταθεί αυτόματα με τον κατάλογο μαθημάτων.';
$string['vvveb_home_automatically_category'] = 'Μην επεξεργαστείτε. Αυτό το μπλοκ θα αντικατασταθεί αυτόματα με τις κατηγορίες μαθημάτων.';
$string['vvveb_home_automatically_my_course'] = 'Μην τροποποιείτε. Αυτός ο τομέας θα αντικατασταθεί αυτόματα με τα μαθήματα στα οποία ο μαθητής είναι εγγεγραμμένος.';
$string['vvveb_home_automatically_popular'] = 'Μην επεξεργαστείτε. Αυτό το μπλοκ θα αντικατασταθεί αυτόματα με τα πιο δημοφιλή μαθήματα.';
$string['vvveb_home_catalogo_heading'] = 'Κατάλογος Μαθημάτων';
$string['vvveb_home_category_heading'] = 'Κατηγορίες Μαθημάτων';
$string['vvveb_home_mycourses_heading'] = 'Τα Μαθήματά Μου';
$string['vvveb_home_popular_course'] = 'Δημοφιλείς Μαθήματα';
$string['vvveb_home_team_subtitle'] = 'Είμαστε μια ομάδα επαγγελματιών αφοσιωμένων στη δουλειά τους';
$string['vvveb_home_team_title'] = 'Γνωρίστε την Ομάδα μας';
