<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'moodle', language 'el', version '4.1'.
 *
 * @package     moodle
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abouttobeinstalled'] = 'πρόκειται να εγκατασταθεί';
$string['accept'] = 'Αποδοχή';
$string['action'] = 'Ενέργεια';
$string['actionchoice'] = 'Τι θέλετε να κάνετε με το αρχείο «{$a}»;';
$string['actions'] = 'Ενέργειες';
$string['actionsfor'] = 'Ενέργειες για το {$a}';
$string['actionsmenu'] = 'Μενού ενεργειών';
$string['active'] = 'Ενεργό';
$string['activeusers'] = 'Ενεργοί χρήστες';
$string['activities'] = 'Δραστηριότητες';
$string['activities_help'] = 'Δραστηριότητες όπως φόρουμ, κουίζ και wiki επιτρέπουν την προσθήκη διαδραστικού περιεχομένου στο μάθημα.';
$string['activity'] = 'Δραστηριότητα';
$string['activityclipboard'] = 'Μετακίνηση αυτής της δραστηριότητας: {$a}';
$string['activityheader'] = 'Μενού δραστηριοτήτων';
$string['activityicon'] = '{$a} εικονίδιο';
$string['activityiscurrentlyhidden'] = 'Λυπούμαστε, αυτή η δραστηριότητα είναι προς το παρόν κρυμμένη';
$string['activitymodule'] = 'Άρθρωμα δραστηριότητας';
$string['activitymodules'] = 'Αρθρώματα δραστηριοτήτων';
$string['activitynotready'] = 'Η δραστηριότητα δεν είναι έτοιμη ακόμα.';
$string['activityreport'] = 'Αναφορά δραστηριότητας';
$string['activityreports'] = 'Αναφορές δραστηριοτήτων';
$string['activityselect'] = 'Επιλέξτε αυτή τη δραστηριότητα για να τη μετακινήσετε';
$string['activitysince'] = 'Δραστηριότητα από {$a}';
$string['activitytypetitle'] = '{$a->activity} - {$a->type}';
$string['activityweighted'] = 'Δραστηριότητα ανά χρήστη';
$string['add'] = 'Προσθήκη';
$string['addactivity'] = 'Προσθήκη δραστηριότητας...';
$string['addactivitytosection'] = 'Προσθήκη μιας δραστηριότητας στην ενότητα «{$a}»';
$string['addadmin'] = 'Προσθήκη διαχειριστή';
$string['addblock'] = 'Προσθήκη ενός μπλοκ';
$string['addcomment'] = 'Προσθήκη σχολίου...';
$string['addcondition'] = 'Προσθήκη συνθήκης';
$string['addcountertousername'] = 'Δημιουργία χρήστη με την προσθήκη ενός αριθμού στο όνομα χρήστη';
$string['addcreator'] = 'Προσθήκη δημιουργού μαθήματος';
$string['adddots'] = 'Προσθήκη...';
$string['added'] = 'Προστέθηκε {$a}';
$string['addedtogroup'] = 'Προστέθηκε στην ομάδα «{$a}»';
$string['addedtogroupnot'] = 'Δεν προστέθηκε στην ομάδα «{$a}»';
$string['addedtogroupnotenrolled'] = 'Δεν προστέθηκε στην ομάδα «{$a}», γιατί δεν είναι εγγεγραμμένος/η στο μάθημα';
$string['addfilehere'] = 'Εναποθέστε αρχείο/α εδώ για να τα προσθέσετε στο κάτω μέρος αυτής της ενότητας';
$string['addinganew'] = 'Προσθήκη νέας/νέου {$a}';
$string['addinganewto'] = 'Προσθήκη {$a->what} σε {$a->to}';
$string['addingdatatoexisting'] = 'Προσθήκη δεδομένων στα υπάρχοντα';
$string['additionalnames'] = 'Επιπρόσθετα ονόματα';
$string['addlinkhere'] = 'Πρόσθεσε έναν σύνδεσμο εδώ';
$string['addnew'] = 'Προσθήκη νέου {$a}';
$string['addnewcategory'] = 'Προσθήκη νέας κατηγορίας';
$string['addnewcourse'] = 'Προσθήκη νέου μαθήματος';
$string['addnewuser'] = 'Προσθήκη νέου χρήστη';
$string['addnousersrecip'] = 'Προσθήκη στη λίστα παραληπτών όλων των χρηστών που δεν έχουν προσπελάσει το {$a}';
$string['addpagehere'] = 'Προσθήκη κειμένου εδώ';
$string['addresource'] = 'Προσθήκη πηγής πληροφοριών...';
$string['addresourceoractivity'] = 'Προσθήκη δραστηριότητας ή πόρου';
$string['addresourcetosection'] = 'Προσθήκη ενός πόρου στην ενότητα «{$a}»';
$string['address'] = 'Διεύθυνση';
$string['addsections'] = 'Προσθήκη ενοτήτων';
$string['addstudent'] = 'Προσθήκη μαθητή';
$string['addsubcategory'] = 'Προσθήκη υποκατηγορίας';
$string['addteacher'] = 'Προσθήκη διδάσκοντα';
$string['admin'] = 'Διαχειριστής';
$string['adminhelpaddnewuser'] = 'Δημιουργία λογαριασμού ενός νέου χρήστη χειροκίνητα';
$string['adminhelpassignadmins'] = 'Οι διαχειριστές μπορούν να κάνουν οτιδήποτε και να πάνε οπουδήποτε σε ολόκληρο τον ιστότοπο';
$string['adminhelpassigncreators'] = 'Οι δημιουργοί μπορούν να δημιουργήσουν νέα μαθήματα';
$string['adminhelpassignsiteroles'] = 'Εφαρμογή ρόλων σε χρήστες του ιστοτόπου';
$string['adminhelpassignstudents'] = 'Μπείτε σε ένα μάθημα και προσθέστε μαθητές από το μενού του διαχειριστή';
$string['adminhelpauthentication'] = 'Μπορείτε να χρησιμοποιήσετε εσωτερικούς λογαριασμούς χρηστών ή εξωτερικές βάσεις δεδομένων';
$string['adminhelpbackup'] = 'Ρυθμίσεις δημιουργίας αυτόματων αντιγράφων ασφαλείας και του χρονοπρογραμματισμού τους';
$string['adminhelpconfiguration'] = 'Ρύθμιση της εμφάνισης και της λειτουργίας του ιστοτόπου';
$string['adminhelpconfigvariables'] = 'Διαμόρφωση των μεταβλητών που επηρεάζουν τη γενική λειτουργία του ιστοτόπου';
$string['adminhelpcourses'] = 'Δημιουργία μαθημάτων και κατηγοριών και εγγραφή χρηστών σε αυτά, επεξεργασία μαθημάτων που εκκρεμούν';
$string['adminhelpeditorsettings'] = 'Ορισμός βασικών ρυθμίσεων του επεξεργαστή HTML';
$string['adminhelpedituser'] = 'Εμφάνιση και επεξεργασία των λογαριασμών χρηστών';
$string['adminhelpenvironment'] = 'Έλεγχος αν ο εξυπηρετητής ικανοποιεί τις απαιτήσεις της τρέχουσας και μελλοντικής εγκατάστασης';
$string['adminhelpfailurelogs'] = 'Εμφάνιση της αναφοράς εσφαλμένων προσπαθειών σύνδεσης';
$string['adminhelplanguage'] = 'Για έλεγχο και επεξεργασία του τρέχοντος πακέτου γλώσσας';
$string['adminhelplogs'] = 'Εμφάνιση καταγραφών κάθε δραστηριότητας στον ιστότοπο';
$string['adminhelpmanageblocks'] = 'Διαχείριση των εγκατεστημένων μπλοκ';
$string['adminhelpmanagedatabase'] = 'Απευθείας πρόσβαση στη βάση δεδομένων (προσοχή!)';
$string['adminhelpmanagefilters'] = 'Διαχείριση φίλτρων κειμένου και σχετικών ρυθμίσεων';
$string['adminhelpmanagemodules'] = 'Διαχείριση των εγκατεστημένων αρθρωμάτων';
$string['adminhelpmanageroles'] = 'Δημιουργία και καθορισμός ρόλων που μπορούν να αποδοθούν στους χρήστες';
$string['adminhelpmymoodle'] = 'Ρυθμίσεις των μπλοκ του Ταμπλό για τους χρήστες';
$string['adminhelpreports'] = 'Αναφορές σε επίπεδο ιστοτόπου';
$string['adminhelpsitefiles'] = 'Για τη δημοσίευση γενικών αρχείων ή το ανέβασμα εξωτερικών αντιγράφων ασφαλείας';
$string['adminhelpsitesettings'] = 'Ορισμός εμφάνισης της αρχικής σελίδας του ιστοτόπου';
$string['adminhelpstickyblocks'] = 'Ρύθμιση αυτοκόλλητων μπλοκ για ολόκληρο το Moodle';
$string['adminhelpthemes'] = 'Επιλογές εμφάνισης του ιστοτόπου (χρώματα, γραμματοσειρές κλπ.)';
$string['adminhelpuploadusers'] = 'Εισαγωγή χρηστών από αρχείο κειμένου';
$string['adminhelpusers'] = 'Ορισμός χρηστών και ρύθμιση αυθεντικοποίησης';
$string['adminhelpxmldbeditor'] = 'Διεπαφή για την επεξεργασία αρχείων XMLDB. Μόνο για προγραμματιστές.';
$string['administration'] = 'Διαχείριση';
$string['administrationsite'] = 'Διαχείριση ιστοτόπου';
$string['administrator'] = 'Διαχειριστής';
$string['administratordescription'] = 'Συνήθως, οι διαχειριστές μπορούν κάνουν οτιδήποτε, σε όλα τα μαθήματα.';
$string['administrators'] = 'Διαχειριστές';
$string['administratorsall'] = 'Όλοι οι διαχειριστές';
$string['administratorsandteachers'] = 'Διαχειριστές και διδάσκοντες';
$string['advanced'] = 'Προχωρημένο';
$string['advancedfilter'] = 'Προχωρημένη αναζήτηση';
$string['advancedsettings'] = 'Προχωρημένες ρυθμίσεις';
$string['afterresource'] = 'Μετά τον πόρο «{$a}»';
$string['aftersection'] = 'Μετά την ενότητα «{$a}»';
$string['again'] = 'πάλι';
$string['agelocationverification'] = 'Επαλήθευση ηλικίας και τοποθεσίας';
$string['aimid'] = 'Αναγνωριστικό  AIM';
$string['ajaxuse'] = 'AJAX και Javascript';
$string['all'] = 'Όλα';
$string['allactions'] = 'Όλες οι ενέργειες';
$string['allactivities'] = 'Όλες οι δραστηριότητες';
$string['allcategories'] = 'Όλες οι κατηγορίες';
$string['allchanges'] = 'Όλες οι αλλαγές';
$string['alldays'] = 'Όλες τις ημέρες';
$string['allfiles'] = 'Όλα τα αρχεία';
$string['allgroups'] = 'Όλες οι ομάδες';
$string['alllogs'] = 'Όλες οι καταγραφές';
$string['allmods'] = 'Όλα τα {$a}';
$string['allow'] = 'Επιτρέπεται';
$string['allowinternal'] = 'Να επιτρέπονται και οι εσωτερικές μέθοδοι';
$string['allownone'] = 'Να μην επιτρέπεται τίποτα';
$string['allownot'] = 'Δεν επιτρέπεται';
$string['allowstealthmodules'] = 'Να επιτρέπονται αόρατες δραστηριότητες';
$string['allowstealthmodules_help'] = 'Αν ενεργοποιηθεί, οι δραστηριότητες μπορεί να είναι διαθέσιμες αλλά δεν εμφανίζονται σε ορατές ενότητες της σελίδας του μαθήματος. Αν είναι έτσι, πρέπει να παρέχονται σύνδεσμοι στις αόρατες δραστηριότητες από αλλού, όπως από έναν πόρο σελίδας. Οι αόρατες δραστηριότητες συνεχίζουν να εμφανίζονται στο βαθμολόγιο και σε άλλες αναφορές.';
$string['allparticipants'] = 'Όλοι οι συμμετέχοντες';
$string['allteachers'] = 'Όλοι οι διδάσκοντες';
$string['alphanumerical'] = 'Μπορεί μόνο να περιέχει γράμματα της αλφαβήτου, αριθμούς, παύλα (-) ή τελεία (.)';
$string['alreadyconfirmed'] = 'Η δημιουργία του λογαριασμού έχει ήδη επιβεβαιωθεί';
$string['alternatename'] = 'Εναλλακτικό όνομα';
$string['always'] = 'Πάντα';
$string['and'] = '{$a->one} και {$a->two}';
$string['answer'] = 'Απάντηση';
$string['any'] = 'Κάθε';
$string['appearance'] = 'Εμφάνιση';
$string['applyfilters'] = 'Εφαρμογή φίλτρων';
$string['approve'] = 'Έγκριση';
$string['areyousure'] = 'Είστε σίγουρος ;';
$string['areyousuretorestorethis'] = 'Θέλετε να συνεχίσετε;';
$string['areyousuretorestorethisinfo'] = 'Αργότερα σε αυτή τη διαδικασία θα έχετε την επιλογή της προσθήκης αυτού του αντιγράφου ασφαλείας σε ένα υπάρχον μάθημα ή της δημιουργίας ενός εντελώς νέου μαθήματος.';
$string['asc'] = 'Αύξουσα';
$string['assessment'] = 'Αξιολόγηση';
$string['assignadmins'] = 'Προσδιορισμός διαχειριστών';
$string['assigncreators'] = 'Προσδιορισμός δημιουργών';
$string['assignedrolecount'] = 'Πλήθος αναθέσεων ρόλου {$a->role}: {$a->count}';
$string['assignsiteroles'] = 'Προσδιορισμός ρόλων στον δικτυακό τόπο';
$string['authenticateduser'] = 'Πιστοποιημένος χρήστης';
$string['authenticateduserdescription'] = 'Όλοι οι συνδεδεμένοι χρήστες';
$string['authentication'] = 'Αυθεντικοποίηση';
$string['authenticationplugins'] = 'Πρόσθετα αυθεντικοποίησης';
$string['autosubscribe'] = 'Αυτόματη εγγραφή στα φόρουμ';
$string['autosubscribeno'] = 'Όχι: να μην εγγράφομαι αυτόματα σε συζητήσεις φόρουμ';
$string['autosubscribeyes'] = 'Ναι: όταν αναρτώ, να εγγράφομαι αυτόματα σε αυτή τη συζήτηση φόρουμ';
$string['availability'] = 'Διαθεσιμότητα';
$string['availablecourses'] = 'Διαθέσιμα μαθήματα';
$string['back'] = 'Επιστροφή';
$string['backto'] = 'Επιστροφή σε {$a}';
$string['backtocourselisting'] = 'Επιστροφή στη λίστα μαθημάτων';
$string['backtohome'] = 'Επιστροφή στην αρχική ιστοτόπου';
$string['backtopageyouwereon'] = 'Επιστροφή στην προηγούμενη σελίδα';
$string['backup'] = 'Αντίγραφο ασφαλείας';
$string['backupactivehelp'] = 'Δημιουργία ή όχι αυτόματων αντιγράφων ασφαλείας';
$string['backupadhocpending'] = 'Εκκρεμεί η εργασία ειδικού σκοπού αντιγράφου ασφαλείας μαθήματος';
$string['backupcancelled'] = 'Η δημιουργία αντιγράφου ασφαλείας ακυρώθηκε';
$string['backupcoursefileshelp'] = 'Προσθήκη των αρχείων του μαθήματος κατά την αυτόματη δημιουργία αντιγράφων ασφαλείας';
$string['backupdate'] = 'Ημερομηνία αντιγράφου ασφαλείας';
$string['backupdatenew'] = '  {$a->TAG} τώρα είναι {$a->weekday}, {$a->mday} {$a->month} {$a->year}<br />';
$string['backupdateold'] = '{$a->TAG} ήταν {$a->weekday}, {$a->mday} {$a->month} {$a->year}';
$string['backupdaterecordtype'] = '<br />{$a->recordtype} - {$a->recordname}<br />';
$string['backupdetails'] = 'Λεπτομέρειες αντιγράφου ασφαλείας';
$string['backuperrorinvaliddestination'] = 'Ο προορισμός φακέλου αντιγράφων ασφάλειας δεν υπάρχει ή δεν είναι προσβάσιμος';
$string['backupexecuteathelp'] = 'Επιλέξτε την ώρα δημιουργίας αυτόματων αντιγράφων ασφαλείας.';
$string['backupfailed'] = 'Κάποια από τα μαθήματα δεν αποθηκεύτηκαν!!';
$string['backupfilename'] = 'αντίγραφο ασφαλείας';
$string['backupfinished'] = 'Η δημιουργία του αντίγραφου ασφαλείας ολοκληρώθηκε επιτυχώς';
$string['backupfromthissite'] = 'Το αντίγραφο ασφαλείας έχει παρθεί από αυτόν τον ιστότοπο;';
$string['backupgradebookhistoryhelp'] = 'Εάν ενεργοποιηθεί, το ιστορικό βαθμολογίου θα συμπεριλαμβάνεται σε αυτόματα αντίγραφα ασφαλείας. Σημειώστε πως το ιστορικό βαθμών δεν πρέπει να είναι απενεργοποιημένο στις ρυθμίσεις του εξυπηρετητή (disablegradehistory) για να ισχύσει αυτή η λειτουργία';
$string['backupincludemoduleshelp'] = 'Επιλέξτε εάν θέλετε να συμπεριλαμβάνονται τα αρθρώματα μαθημάτων με ή χωρίς δεδομένα χρηστών, κατά τη δημιουργία των αυτόματων αντιγράφων ασφαλείας';
$string['backupincludemoduleuserdatahelp'] = 'Επιλέξτε εάν θέλετε να συμπεριλαμβάνονται τα δεδομένα χρηστών αρθρωμάτων, κατά τη δημιουργία των αυτόματων αντιγράφων ασφαλείας.';
$string['backuplogdetailed'] = 'Λεπτομερής αναφορά εκτέλεσης';
$string['backuploglaststatus'] = 'Τελευταία αναφορά εκτέλεσης';
$string['backupmissinguserinfoperms'] = 'Σημείωση: Αυτό το αντίγραφο ασφάλειας δεν περιέχει στοιχεία χρηστών. Οι δραστηριότητες τύπου Exercise και Workshop δεν θα συμπεριληφθούν σε αυτό το αντίγραφό ασφαλείας, εφόσον δεν είναι συμβατές.';
$string['backupnext'] = 'Επόμενο αντίγραφο ασφαλείας';
$string['backupnonisowarning'] = 'Προειδοποίηση: Αυτό το αντίγραφο ασφαλείας προέρχεται από μία έκδοση του Moodle η οποία δεν υποστηρίζει Unicode. Αν αυτό το αντίγραφο ασφαλείας περιέχει κείμενο διαφορετικής κωδικοποίησης από το πρότυπο ISO-8859-1 τότε μπορεί να καταστεί ΚΑΤΕΣΤΡΑΜΕΝΟ αν προσπαθήσετε να το επαναφέρετε σε αυτή την έκδοση Unicode του Moodle. Δείτε τις <a href="https://docs.moodle.org/en/Backup_FAQ">Συχνές ερωτήσεις για τα Εφεδρικά αντίγραφα ασφαλείας</a> για περισσότερες πληροφορίες για σωστή επαναφορά αυτού του αντιγράφου ασφαλείας.';
$string['backupnotyetrun'] = 'Το αυτοματοποιημένο αντίγραφο ασφαλείας αναμένει';
$string['backuporiginalname'] = 'Όνομα αντιγράφου ασφαλείας';
$string['backuproleassignments'] = 'Δημιουργία αντιγράφων ασφαλείας των αναθέσεων ρόλων για αυτούς τους ρόλους';
$string['backupsavetohelp'] = 'Η πλήρης διαδρομή του φακέλου στον οποίο θέλετε να αποθηκεύσετε το αντίγραφο ασφαλείας.
<br /> (Προεπιλογή: ο φάκελος μαθήματος)';
$string['backupsitefileshelp'] = 'Εάν ενεργοποιηθεί, τότε τα αρχεία του ιστοτόπου που χρησιμοποιούνται σε μαθήματα θα συμπεριληφθούν στα αυτόματα αντίγραφα ασφαλείας';
$string['backuptakealook'] = 'Παρακαλούμε δείτε τις καταγραφές των αντιγράφων ασφαλείας στο: {$a}';
$string['backupuserfileshelp'] = 'Επιλέξτε εάν θα συμπεριλαμβάνονται τα αρχεία των χρηστών (π.χ. εικόνες προφίλ) στα αυτόματα αντίγραφα ασφαλείας.';
$string['backupversion'] = 'Έκδοση αντιγράφου ασφαλείας';
$string['badges'] = 'Διακριτικά';
$string['block'] = 'Μπλοκ';
$string['blockconfiga'] = 'Ρύθμιση ενός μπλοκ {$a}';
$string['blockconfigbad'] = 'Αυτό το μπλοκ δεν έχει υλοποιηθεί σωστά και δεν παρέχει διεπαφή ρυθμίσεων.';
$string['blocks'] = 'Μπλοκ';
$string['blocksaddedit'] = 'Προσθήκη/επεξεργασία μπλοκ';
$string['blockseditoff'] = 'Απενεργοποίηση επεξεργασίας μπλοκ';
$string['blocksediton'] = 'Ενεργοποίηση επεξεργασίας μπλοκ';
$string['blocksetup'] = 'Ρύθμιση πινάκων μπλοκ';
$string['blocksuccess'] = '{$a} πίνακες έχουν ρυθμιστεί σωστά';
$string['brief'] = 'Συνοπτική αναφορά';
$string['bulkactions'] = 'Μαζικές ενέργειες';
$string['bulkactionselect'] = '{$a} επιλογή μαζικών ενεργειών';
$string['bulkmovecoursessuccess'] = 'Επιτυχής μεταφορά {$a->courses} μαθημάτων στη κατηγορία {$a->category}';
$string['bycourseorder'] = 'Επιτυχής μεταφορά {$a->courses} μαθημάτων στη κατηγορία {$a->category}';
$string['byname'] = 'κατά {$a}';
$string['bypassed'] = 'Προσπεράστηκαν';
$string['cachecontrols'] = 'Χειριστήρια κρυφής μνήμης';
$string['calltofeedback'] = 'Οι δημιουργοί αυτού του λογισμικού θα ήθελαν την ανατροφοδότησή σας.';
$string['calltofeedback_give'] = 'Δώστε ανατροφοδότηση για αυτό το λογισμικό';
$string['calltofeedback_remind'] = 'Υπενθύμιση αργότερα';
$string['cancel'] = 'Άκυρο';
$string['cancelled'] = 'Ακυρώθηκε';
$string['categories'] = 'Κατηγορίες μαθημάτων';
$string['categoriesandcourses'] = 'Κατηγορίες μαθημάτων και μαθήματα';
$string['category'] = 'Κατηγορία';
$string['categoryadded'] = 'Η κατηγορία «{$a}» προστέθηκε';
$string['categorybulkaction'] = 'Μαζικές ενέργειες για τις επιλεγμένες κατηγορίες';
$string['categorycontents'] = 'Υποκατηγορίες και μαθήματα';
$string['categorycurrentcontents'] = 'Περιεχόμενα του {$a}';
$string['categorydeleted'] = 'Η κατηγορία «{$a}» διαγράφηκε';
$string['categoryduplicate'] = 'Υπάρχει ήδη κατηγορία με το όνομα «{$a}»!';
$string['categoryheader'] = 'Μενού κατηγοριών';
$string['categoryhidden'] = '(σε απόκρυψη)';
$string['categorymodifiedcancel'] = 'Η κατηγορία έχει τροποποιηθεί! Παρακαλούμε ακυρώστε και ξαναπροσπαθήστε.';
$string['categoryname'] = 'Όνομα κατηγορίας';
$string['categorysubcategoryof'] = '{$a->category} - υποκατηγορία {$a->parentcategory}';
$string['categoryupdated'] = 'Η κατηγορία «{$a}» ενημερώθηκε';
$string['changedpassword'] = 'Ο κωδικός πρόσβασης άλλαξε';
$string['changepassword'] = 'Αλλαγή του κωδικού πρόσβασης';
$string['changesmade'] = 'Πραγματοποιήθηκαν αλλαγές';
$string['changesmadereallygoaway'] = 'Έχετε κάνει αλλαγές. Είστε βέβαιοι ότι θέλετε να φύγετε και να χάσετε τις αλλαγές σας;';
$string['changessaved'] = 'Οι αλλαγές αποθηκεύτηκαν';
$string['check'] = 'Επιλογή';
$string['checkactual'] = 'Πραγματικός';
$string['checkall'] = 'Επιλογή όλων';
$string['checkexpected'] = 'Αναμενόμενος';
$string['checkingbackup'] = 'Έλεγχος αντιγράφου ασφαλείας';
$string['checkingcourse'] = 'Έλεγχος μαθήματος';
$string['checkingforbbexport'] = 'Έλεγχος για εξαγωγή σε Blackboard';
$string['checkinginstances'] = 'Έλεγχος στιγμιοτύπων';
$string['checkingsections'] = 'Έλεγχος ενοτήτων';
$string['checklanguage'] = 'Έλεγχος γλώσσας';
$string['checknone'] = 'Αποεπιλογή όλων';
$string['checks'] = 'Έλεγχοι';
$string['checksok'] = 'Όλοι οι «{$a}» έλεγχοι OK';
$string['childcoursenotfound'] = 'Αδυναμία εύρεσης θυγατρικού μαθήματος!';
$string['childcourses'] = 'Θυγατρικά μαθήματα';
$string['choose'] = 'Επιλέξτε';
$string['choosecourse'] = 'Επιλέξτε ένα μάθημα';
$string['choosedots'] = 'Επιλέξτε...';
$string['chooselivelogs'] = 'Ή παρακολουθήστε την τρέχουσα δραστηριότητα';
$string['chooselogs'] = 'Επιλέξτε τις καταγραφές που θέλετε να δείτε';
$string['choosereportfilter'] = 'Επιλέξτε κάποιο φίλτρο για την αναφορά';
$string['choosetheme'] = 'Επιλέξτε αισθητικό θέμα';
$string['chooseuser'] = 'Επιλέξτε ένα χρήστη';
$string['city'] = 'Πόλη/χωριό';
$string['cleaningtempdata'] = 'Διαγραφή προσωρινών δεδομένων';
$string['clear'] = 'Καθαρισμός';
$string['clearfilterrow'] = 'Κατάργηση σειράς φίλτρων';
$string['clearfilters'] = 'Καθαρισμός φίλτρων';
$string['clearsearch'] = 'Εκκαθάριση εισόδου αναζήτησης';
$string['clickhelpiconformoreinfo'] = '... συνεχίζεται ... Κάντε κλικ στο εικονίδιο Βοήθεια για να διαβάσετε το πλήρες άρθρο';
$string['clickhere'] = 'Πατήστε εδώ ...';
$string['clicktochangeinbrackets'] = '{$a} (Κάντε κλικ για να αλλάξετε)';
$string['clicktohideshow'] = 'Πατήστε για ανάπτυξη ή σύμπτυξη';
$string['closebuttontitle'] = 'Κλείσιμο';
$string['closedrawer'] = 'Κλείσιμο συρταριού';
$string['closewindow'] = 'Κλείσιμο αυτού του παραθύρου';
$string['collapse'] = 'Σύμπτυξη';
$string['collapseall'] = 'Σύμπτυξη όλων';
$string['collapsecategory'] = 'Σύμπτυξη {$a}';
$string['comebacklater'] = 'Παρακαλώ ελάτε αργότερα';
$string['commentincontext'] = 'Εύρεση του σχολίου στα συμφραζόμενα';
$string['comments'] = 'Σχόλια';
$string['commentscount'] = 'Σχόλια ({$a})';
$string['commentsnotenabled'] = 'Τα σχόλια δεν είναι ενεργοποιημένα';
$string['commentsrequirelogin'] = 'Πρέπει να συνδεθείτε για να δείτε τα σχόλια.';
$string['comparelanguage'] = 'Σύγκριση και επεξεργασία του γλωσσικού πακέτου';
$string['complete'] = 'Ολοκλήρωση';
$string['completed'] = 'Ολοκληρώθηκε';
$string['completereport'] = 'Πλήρης αναφορά';
$string['configuration'] = 'Ρυθμίσεις';
$string['confirm'] = 'Επιβεβαίωση';
$string['confirmcheckfull'] = 'Είστε απολύτως σίγουροι πως θέλετε να επιβεβαιώσετε το {$a} ;';
$string['confirmcoursemove'] = 'Είστε σίγουροι ότι θέλετε να μετακινήσετε αυτό το μάθημα ({$a->course}) σε αυτή την κατηγορία ({$a->category});';
$string['confirmdeletesection'] = 'Είστε απολύτως σίγουροι ότι θέλετε να διαγράψετε εντελώς το «{$a}» και όλες τις δραστηριότητες που περιέχει;';
$string['confirmed'] = 'Η καταχώρησή σας επιβεβαιώθηκε';
$string['confirmednot'] = 'Η καταχώρησή σας δεν έχει επιβεβαιωθεί ακόμη! Παρακαλούμε, ελέγξτε το γραμματοκιβώτιο του ηλε.ταχυδρομείου σας για ένα μήνυμα επιβεβαίωσης.';
$string['considereddigitalminor'] = 'Είστε πολύ νέος για να δημιουργήσετε λογαριασμό σε αυτόν τον ιστότοπο.';
$string['content'] = 'Περιεχόμενο';
$string['contentbank'] = 'Τράπεζα περιεχομένου';
$string['contentexport_aboutthiscourse'] = 'Περίληψη μαθήματος';
$string['contentexport_coursesummary'] = 'Αυτό το αρχείο είναι μέρος του περιεχομένου του οποίου έγινε λήψη από <a href="{$a->courselink}">{$a->coursename}</a>.';
$string['contentexport_footersummary'] = 'Αυτό το αρχείο είναι μέρος του περιεχομένου του οποίου έγινε λήψη από <a href="{$a->courselink}">{$a->coursename}</a> από τον/την {$a->userfullname} στις {$a->date}.';
$string['contentexport_modulesummary'] = 'Αυτό το αρχείο είναι μέρος του περιεχομένου του οποίου έγινε λήψη από <a href="{$a->modulelink}">{$a->modulename}</a> στις {$a->date}. Σημειώστε ότι δεν γίνεται λήψη όλου του περιεχομένου και οποιουδήποτε αρχείου μεγαλύτερου από {$a->maxfilesize}.';
$string['contentexport_viewfilename'] = 'Εμφάνιση του αρχείου {$a}';
$string['continue'] = 'Συνέχεια';
$string['continuetocourse'] = 'Πατήστε εδώ για να μπείτε στο μάθημα';
$string['convertingwikitomarkdown'] = 'Μετατροπή από Wiki σε Markdown';
$string['cookiesenabled'] = 'Τα cookies πρέπει να είναι ενεργοποιημένα στον περιηγητή σας';
$string['cookiesenabled_help'] = 'Δύο cookies χρησιμοποιούνται από αυτόν τον ιστότοπο:

Το βασικό είναι το cookie συνόδου, που συνήθως ονομάζεται MoodleSession. Πρέπει να επιτρέψετε αυτό το cookie στον περιηγητή σας για να εξασφαλίσετε τη συνέχεια και να διατηρήσετε τα στοιχεία σύνδεσης από σελίδα σε σελίδα. Όταν αποσυνδεθείτε ή κλείσετε τον περιηγητή, αυτό το cookie καταστρέφεται (στον περιηγητή σας και στον εξυπηρετητή).

Το άλλο cookie είναι καθαρά για λόγους ευκολίας και συνήθως ονομάζεται κάτι σαν MOODLEID. Απλά θυμάται το όνομα χρήστη σας στον περιηγητή. Αυτό σημαίνει ότι όταν επιστρέφετε σε αυτόν τον ιστότοπο, το πεδίο ονόματος χρήστη στη σελίδα σύνδεσης θα είναι ήδη προσυμπληρωμένο για εσάς. Είναι ασφαλές να απορρίψετε αυτό το cookie - θα πρέπει απλώς να πληκτρολογείτε ξανά το όνομα χρήστη σας κάθε φορά που συνδέεστε.';
$string['cookiesenabled_help_html'] = 'Σε αυτόν τον ιστότοπο χρησιμοποιούνται δύο cookies:<br/><br/>

Το βασικό είναι το cookie περιόδου λειτουργίας, που συνήθως ονομάζεται MoodleSession. Πρέπει να επιτρέψετε σε αυτό το cookie στο πρόγραμμα περιήγησής σας ώστε να παρέχει συνέχεια και να παραμένει συνδεδεμένο κατά την περιήγηση στον ιστότοπο. Όταν αποσυνδέεστε ή κλείνετε το πρόγραμμα περιήγησης, αυτό το cookie καταστρέφεται (στο πρόγραμμα περιήγησής σας και στο διακομιστή).<br/><br/>

Το άλλο cookie είναι καθαρά για λόγους ευκολίας, που συνήθως ονομάζεται MOODLEID ή παρόμοιο. Απλώς θυμάται το όνομα χρήστη σας στο πρόγραμμα περιήγησης. Αυτό σημαίνει ότι όταν επιστρέψετε σε αυτόν τον ιστότοπο, το πεδίο ονόματος χρήστη στη σελίδα σύνδεσης έχει ήδη συμπληρωθεί για εσάς. Είναι ασφαλές να αρνηθείτε αυτό το cookie - θα πρέπει απλώς να πληκτρολογείτε ξανά το όνομα χρήστη σας κάθε φορά που συνδέεστε.';
$string['cookiesenabledonlysession'] = 'Τα cookies πρέπει να είναι ενεργοποιημένα στον περιηγητή σας';
$string['cookiesenabledonlysession_help'] = 'Αυτή η ιστοσελίδα χρησιμοποιεί ένα cookie συνόδου, που συνήθως ονομάζεται MoodleSession. Πρέπει να επιτρέψετε αυτό το cookie στον περιηγητή σας για να εξασφαλίσετε τη συνέχεια και να διατηρήσετε τα στοιχεία σύνδεσης από σελίδα σε σελίδα. Όταν αποσυνδεθείτε ή κλείσετε τον περιηγητή, αυτό το cookie καταστρέφεται (στον περιηγητή σας και στον εξυπηρετητή).';
$string['cookiesnotenabled'] = 'Δυστυχώς, τα cookies δεν είναι ενεργοποιημένα στο περιηγητή σας';
$string['cookiesnotice'] = 'Ειδοποίηση για τα cookies';
$string['copy'] = 'αντιγραφή';
$string['copyasnoun'] = 'αντιγραφή';
$string['copycourse'] = 'Αντιγραφή μαθήματος';
$string['copyingcoursefiles'] = 'Αντιγραφή αρχείων μαθημάτων';
$string['copyingsitefiles'] = 'Αντιγραφή αρχείων ιστοτόπου που χρησιμοποιούνται στο μάθημα';
$string['copyinguserfiles'] = 'Αντιγραφή αρχείων χρήστη';
$string['copyingzipfile'] = 'Αντιγραφή συμπιεσμένου αρχείου';
$string['copyrightnotice'] = 'Σημείωση πνευματικών δικαιωμάτων';
$string['coresystem'] = 'Πυρήνας συστήματος';
$string['cost'] = 'Κόστος';
$string['costdefault'] = 'Προεπιλεγμένο κόστος';
$string['counteditems'] = '{$a->count} {$a->items}';
$string['country'] = 'Χώρα';
$string['course'] = 'Μάθημα';
$string['courseadministration'] = 'Διαχείριση μαθήματος';
$string['courseapprovedemail'] = 'Η αίτηση δημιουργίας νέου μαθήματος ({$a->name}) έγινε αποδεκτή και έχετε πάρει δικαιώματα διδάσκοντα. Για να μπείτε στο μάθημά σας πατήστε στον επόμενο σύνδεσμο {$a->url}';
$string['courseapprovedemail2'] = 'Το μάθημα που αιτηθήκατε, {$a->name}, έχει εγκριθεί. Για να το δείτε, πηγαίνετε στο {$a->url}';
$string['courseapprovedfailed'] = 'Παρουσιάστηκε ένα σφάλμα και δεν αποθηκεύτηκε η αίτηση ως αποδεκτή!';
$string['courseapprovedsubject'] = 'Η αίτηση για δημιουργία νέου μαθήματος που κάνατε έγινε αποδεκτή';
$string['courseavailable'] = 'Αυτό το μάθημα είναι διαθέσιμο στους μαθητές';
$string['courseavailablenot'] = 'Αυτό το μάθημα δεν είναι διαθέσιμο στους μαθητές';
$string['coursebackup'] = 'Αντίγραφο ασφαλείας μαθήματος';
$string['coursebulkaction'] = 'Μαζικές ενέργειες για τα επιλεγμένα μαθήματα';
$string['coursecategories'] = 'Κατηγορίες μαθημάτων';
$string['coursecategory'] = 'Κατηγορία μαθήματος';
$string['coursecategory_help'] = 'Αυτή η ρύθμιση καθορίζει την κατηγορία στην οποία θα εμφανιστεί το μάθημα στη λίστα μαθημάτων.';
$string['coursecategorydeleted'] = 'Η κατηγορία μαθημάτων {$a} διαγράφηκε';
$string['coursecatmanagement'] = 'Διαχείριση κατηγορίας και μαθήματος';
$string['coursecompletion'] = 'Ολοκλήρωση μαθήματος';
$string['coursecompletions'] = 'Ολοκληρώσεις μαθήματος';
$string['coursecreators'] = 'Δημιουργός μαθήματος';
$string['coursecreatorsdescription'] = 'Οι δημιουργοί μαθημάτων μπορούν να δημιουργούν νέα μαθήματα.';
$string['coursedeleted'] = 'Το μάθημα {$a} διαγράφηκε';
$string['coursedetails'] = 'Λεπτομέρειες μαθήματος';
$string['coursedisplay'] = 'Διάταξη μαθήματος';
$string['coursedisplay_help'] = 'Οι ενότητες μαθημάτων μπορούν να εμφανιστούν όλες σε μία σελίδα ή να χωριστούν σε πολλές σελίδες.';
$string['coursedisplay_multi'] = 'Παρουσίαση μιας ενότητας ανά σελίδα';
$string['coursedisplay_single'] = 'Εμφάνιση όλων των ενοτήτων σε μία σελίδα';
$string['courseduration'] = 'Διάρκεια μαθήματος';
$string['courseduration_desc'] = 'Η διάρκεια του μαθήματος χρησιμοποιείται για να υπολογιστεί η καταληκτική ημερομηνία του μαθήματος. Η καταληκτική ημερομηνία μαθήματος χρησιμοποιείται για το αν ένα μάθημα θα πρέπει να συμπεριλαμβάνεται στη λίστα μαθημάτων ενός χρήστη. Μπορεί επίσης να χρησιμοποιηθεί από προσαρμοσμένες αναφορές. Οι χρήστες εξακολουθούν να έχουν πρόσβαση στο μάθημα και μετά τη καταληκτική ημερομηνία.';
$string['courseenddateenabled'] = 'Καταληκτική ημερομηνία μαθήματος ενεργοποιημένη από προεπιλογή';
$string['courseenddateenabled_desc'] = 'Αυτή η ρύθμιση ορίζει αν η καταληκτική ημερομηνία μαθήματος θα είναι προεπιλεγμένα ενεργοποιημένη για νέα μαθήματα και θα υπολογίζεται μέσω της διάρκειας του μαθήματος.';
$string['courseextendednamedisplay'] = '{$a->shortname} {$a->fullname}';
$string['coursefiles'] = 'Αρχεία μαθήματος παλαιού τύπου';
$string['coursefilesedit'] = 'Επεξεργασία αρχείων μαθήματος παλαιού τύπου';
$string['coursefileswarning'] = 'Τα αρχεία του μαθήματος είναι παλιά.';
$string['coursefileswarning_help'] = 'Τα αρχεία του μαθήματος είναι παλαιότερα από το Moodle 2.0, παρακαλούμε όπως χρησιμοποιήσετε εξωτερικές πηγές όπου είναι δυνατόν.';
$string['courseformatdata'] = 'Δεδομένα μορφότυπου μαθήματος';
$string['courseformatoptions'] = 'Επιλογές μορφοποίησης για {$a}';
$string['courseformats'] = 'Μορφότυποι μαθήματος';
$string['courseformatudpate'] = 'Ενημέρωση μορφότυπου';
$string['coursegrades'] = 'Βαθμοί μαθήματος';
$string['courseheader'] = 'Μενού μαθήματος';
$string['coursehelpcategory'] = 'Τοποθετήστε το μάθημα στη λίστα μαθημάτων και κάντε το ευκολότερο να το βρουν οι μαθητές.';
$string['coursehelpforce'] = 'Επιβολή της ομαδοποίησης μαθημάτων σε όλες τις δραστηριότητες στο μάθημα.';
$string['coursehelpformat'] = 'Η κύρια σελίδα του μαθήματος θα φαίνεται με αυτόν τον μορφότυπο.';
$string['coursehelphiddensections'] = 'Πώς θα φαίνονται οι κρυμμένες ενότητες του μαθήματος στους μαθητές.';
$string['coursehelpmaximumupload'] = 'Καθορισμός του μέγιστου μεγέθους αρχείου που μπορεί να ανεβεί (από μαθητές) σε αυτό το μάθημα, αν δεν υπερβαίνει το όριο του ιστοτόπου.';
$string['coursehelpnewsitemsnumber'] = 'Αριθμός πρόσφατων ανακοινώσεων που θα εμφανίζονται στο μπλοκ τελευταίων ανακοινώσεων στην σελίδα μαθήματος. Αν δοθεί 0, το φόρουμ ανακοινώσεων δεν θα δημιουργηθεί.';
$string['coursehelpnumberweeks'] = 'Αριθμός ενοτήτων στο μάθημα (ισχύει για συγκεκριμένους μορφότυπους μαθημάτων μόνο).';
$string['coursehelpshowgrades'] = 'Ενεργοποίηση της εμφάνισης του βαθμολογίου. Αυτό δεν εμποδίζει του βαθμούς από το να εμφανίζονται μέσα σε κάθε δραστηριότητα.';
$string['coursehidden'] = 'Αυτό το μάθημα είναι προσωρινά μη διαθέσιμο στους μαθητές';
$string['courseinfo'] = 'Πληροφορίες μαθήματος';
$string['courselegacyfiles'] = 'Αρχεία μαθήματος παλαιού τύπου';
$string['courselegacyfiles_help'] = 'Η περιοχή αρχείων μαθήματος παρέχει συμβατότητα προς τα πίσω με την έκδοση Moodle 1.9 και προγενέστερα. Όλα τα αρχεία σε αυτή την περιοχή είναι πάντα προσβάσιμα σε όλους τους συμμετέχοντες στο μάθημα (είτε συνδέεστε με αυτά είτε όχι) και δεν υπάρχει τρόπος να γνωρίζετε που χρησιμοποιούνται αυτά τα αρχεία στο Moodle. <br/><br/> Αν χρησιμοποιείτε αυτή την περιοχή για να αποθηκεύσετε αρχεία μαθήματος, μπορεί να εκτεθείτε σε μια σειρά προβλημάτων ιδιωτικότητας και ασφάλειας, καθώς και να αντιμετωπίζετε ελλείποντα αρχεία σε αντίγραφα ασφαλείας, εισαγωγές μαθημάτων και κάθε φορά που διαμοιράζεται ή επαναχρησιμοποιείται περιεχόμενο. Συνεπώς, συνιστάται να μην χρησιμοποιείτε αυτή την περιοχή εκτός αν είστε απολύτως σίγουροι.';
$string['courselegacyfiles_link'] = 'αρχείαμαθήματος2';
$string['courselegacyfilesofcourse'] = 'Αρχεία μαθήματος παλαιού τύπου: {$a}';
$string['coursenotaccessible'] = 'Σε αυτό το μάθημα δεν επιτρέπονται επισκέπτες';
$string['courseoverview'] = 'Επισκόπηση μαθήματος';
$string['courseoverviewfiles'] = 'Εικόνα μαθήματος';
$string['courseoverviewfiles_help'] = 'Η εικόνα του μαθήματος εμφανίζεται στην ενότητα Τα μαθήματά μου και στη λίστα με τα διαθέσιμα μαθήματα στην Αρχική σελίδα. Οι διαχειριστές του ιστότοπου μπορούν να ενεργοποιήσουν πρόσθετους τύπους αρχείων και τη χρήση πολλαπλών αρχείων. Εάν χρησιμοποιείτε πολλά αρχεία, θα εμφανίζονται όλα στη λίστα με τα διαθέσιμα μαθήματα στην Αρχική σελίδα.';
$string['courseoverviewfilesext'] = 'Επεκτάσεις αρχείων εικόνας μαθήματος';
$string['courseoverviewfileslimit'] = 'Όριο αρχείων εικόνας μαθήματος';
$string['courseoverviewgraph'] = 'Γράφημα επισκόπησης μαθημάτων';
$string['coursepreferences'] = 'Προτιμήσεις μαθημάτων';
$string['courseprofiles'] = 'Προφίλ μαθημάτων';
$string['coursereasonforrejecting'] = 'Οι λόγοι για τους οποίους απορρίπτετε αυτό το αίτημα';
$string['coursereasonforrejectingemail'] = 'Αυτό το μήνυμα θα σταλεί ως email στον αιτούντα';
$string['coursereject'] = 'Απόρριψη αίτησης δημιουργίας μαθήματος';
$string['courserejected'] = 'Η αίτηση δημιουργίας νέου μαθήματος απορρίφθηκε και στάλθηκε ειδοποίηση σε αυτόν που έκανε την αίτηση.';
$string['courserejectemail'] = 'Η αίτηση δημιουργίας νέου μαθήματος που κάνατε απορρίφθηκε διότι: {$a}';
$string['courserejectreason'] = 'Περιγράψτε τους λόγους για τους οποίος απορρίφθηκε η αίτηση δημιουργίας νέου μαθήματος (θα σταλεί σε αυτόν που έκανε την αίτηση)';
$string['courserejectsubject'] = 'Η αίτηση δημιουργίας νέου μαθήματος απορρίφθηκε';
$string['coursereport'] = 'Αναφορά μαθήματος';
$string['coursereports'] = 'Αναφορές μαθήματος';
$string['courserequest'] = 'Αίτηση δημιουργίας μαθήματος';
$string['courserequestdetails'] = 'Λεπτομέρειες σχετικά με το μάθημα για το οποίο κάνετε αίτηση';
$string['courserequestfailed'] = 'Δεν ήταν δυνατή η αποθήκευση της αίτησης δημιουργίας μαθήματος';
$string['courserequestintro'] = 'Χρησιμοποιήστε αυτή τη φόρμα για να στείλετε μία αίτηση δημιουργίας ενός νέου μαθήματος.
<br />Προσπαθήστε να συμπληρώσετε όσες περισσότερες πληροφορίες μπορείτε για
<br />να καταλάβει ο διαχειριστής το λόγο για τον οποίο επιθυμείτε το μάθημα αυτό.';
$string['courserequestreason'] = 'Λόγοι για τους οποίους θέλετε αυτό το μάθημα';
$string['courserequestsuccess'] = 'Η αίτηση σας δημιουργίας μαθήματος έχει αποθηκευτεί επιτυχώς. Θα σας αποσταλεί ένα μήνυμα ηλε.ταχυδρομείου για να σας ενημερώσουμε αν το αίτημά σας εγκρίθηκε.';
$string['courserequestsupport'] = 'Υποστηρικτικές πληροφορίες που θα βοηθήσουν το διαχειριστή να αξιολογήσει αυτή την αίτηση';
$string['courserequestwarning'] = 'Ο χρήστης ο οποίος ζήτησε αυτό το μάθημα θα εγγραφή αυτόματα σε αυτό με το ρόλο {$a}.';
$string['courserestore'] = 'Επαναφορά μαθήματος';
$string['coursereuse'] = 'Επαναχρησιμοποίηση μαθήματος';
$string['courses'] = 'Μαθήματα';
$string['coursesearch'] = 'Αναζήτηση μαθημάτων';
$string['coursesearch_help'] = 'Μπορείτε να αναζητήσετε πολλές λέξεις τη φορά και να κάνετε πιο συγκεκριμένη την αναζήτησή σας ως εξής:

* word: εύρεση οποιουδήποτε ταιριάσματος αυτής της λέξης μέσα στο κείμενο
* +word: εύρεση μόνο ακριβούς ταιριάσματος αυτής της λέξης
* -word: να μην συμπεριλαμβάνονται αποτελέσματα που περιέχουν αυτή τη λέξη.';
$string['coursesectionsummaries'] = 'Περιλήψεις ενοτήτων μαθήματος';
$string['coursesectiontitle'] = '{$a->sectionname}: {$a->sectiontitle} | {$a->course}';
$string['coursesectiontitleediting'] = 'Επεξεργασία {$a->sectionname}: {$a->sectiontitle} | {$a->course}';
$string['coursesettings'] = 'Προεπιλογές ρυθμίσεων μαθήματος';
$string['coursesmovedout'] = 'Τα μαθήματα μεταφέρθηκαν από το {$a}';
$string['coursespending'] = 'Μαθήματα που αναμένουν έγκριση';
$string['coursestart'] = 'Αρχή μαθήματος';
$string['coursesummary'] = 'Περίληψη μαθήματος';
$string['coursesummary_help'] = 'Μια σύντομη περιγραφή της πορείας σας. Το περιεχόμενο που προσθέτετε εδώ έχει δυνατότητα αναζήτησης.';
$string['coursetitle'] = 'Μάθημα: {$a->course}';
$string['coursetitleediting'] = 'Επεξεργασία μαθήματος: {$a->course}';
$string['courseupdates'] = 'Ενημερώσεις στο μάθημα';
$string['coursevisibility'] = 'Ορατότητα μαθήματος';
$string['coursevisibility_help'] = '* Εμφάνιση: Το μάθημα εμφανίζεται στη λίστα μαθημάτων και οι μαθητές μπορούν να έχουν πρόσβαση σε αυτό.
* Απόκρυψη: Η πρόσβαση περιορίζεται σε καθηγητές και άλλους χρήστες με δυνατότητα προβολής κρυφών μαθημάτων.';
$string['create'] = 'Δημιουργία';
$string['createaccount'] = 'Δημιουργία του λογαριασμού μου';
$string['createcategory'] = 'Δημιουργία κατηγορίας';
$string['createfolder'] = 'Δημιουργία φακέλου στο {$a}';
$string['createnew'] = 'Δημιουργία νέου';
$string['createnewcategory'] = 'Δημιουργία νέας κατηγορίας';
$string['createnewcourse'] = 'Δημιουργία νέου μαθήματος';
$string['createnewsubcategory'] = 'Δημιουργία νέας υποκατηγορίας';
$string['createsubcategoryof'] = 'Δημιουργία υποκατηγορίας του {$a}';
$string['createuser'] = 'Δημιουργία χρήστη';
$string['createuserandpass'] = 'Δημιουργία ενός νέου ονόματος χρήστη και κωδικού πρόσβασης για σύνδεση στον δικτυακό τόπο';
$string['createziparchive'] = 'Δημιουργία συμπιεσμένου αρχείου';
$string['creatingblocks'] = 'Δημιουργία μπλοκ';
$string['creatingblocksroles'] = 'Δημιουργία αναθέσεων ρόλων σε επίπεδο μπλοκ και παρακάμψεις';
$string['creatingblogsinfo'] = 'Δημιουργία πληροφοριών ιστολογίου';
$string['creatingcategoriesandquestions'] = 'Δημιουργία κατηγοριών και ερωτήσεων';
$string['creatingcoursemodules'] = 'Δημιουργία ενοτήτων μαθήματος';
$string['creatingcourseroles'] = 'Δημιουργία αναθέσεων ρόλων σε επίπεδο μαθήματος και παρακάμψεις';
$string['creatingevents'] = 'Δημιουργία γεγονότων';
$string['creatinggradebook'] = 'Δημιουργία βαθμολογίου';
$string['creatinggroupings'] = 'Δημιουργία ομαδοποιήσεων';
$string['creatinggroupingsgroups'] = 'Προσθήκη ομάδων σε ομαδοποιήσεις';
$string['creatinggroups'] = 'Δημιουργία ομάδων';
$string['creatinglogentries'] = 'Δημιουργία καταγραφών συνδέσεων';
$string['creatingmessagesinfo'] = 'Δημιουργία μηνυμάτων πληροφοριών';
$string['creatingmodroles'] = 'Δημιουργία αναθέσεων ρόλων σε επίπεδο αρθρώματος και παρακάμψεις';
$string['creatingnewcourse'] = 'Δημιουργία νέου μαθήματος';
$string['creatingrolesdefinitions'] = 'Δημιουργία ορισμών ρόλων';
$string['creatingscales'] = 'Δημιουργία κλίμακας';
$string['creatingsections'] = 'Δημιουργία ενοτήτων';
$string['creatingtemporarystructures'] = 'Δημιουργία προσωρινών δομών';
$string['creatinguserroles'] = 'Δημιουργία αναθέσεων ρόλων σε επίπεδο χρήστη και παρακάμψεις';
$string['creatingusers'] = 'Δημιουργία χρηστών';
$string['creatingxmlfile'] = 'Δημιουργία αρχείου XML';
$string['currency'] = 'Νόμισμα';
$string['currentcourse'] = 'Τρέχον μάθημα';
$string['currentcourseadding'] = 'Τρέχον μάθημα, προσθήκη δεδομένων σε αυτό';
$string['currentcoursedeleting'] = 'Τρέχον μάθημα, διαγραφή του πρώτα';
$string['currentlanguage'] = 'Επιλεγμένη γλώσσα';
$string['currentlocaltime'] = 'η τρέχουσα τοπική ώρα';
$string['currentpicture'] = 'Τρέχουσα φωτογραφία';
$string['currentrelease'] = 'Πληροφορίες τρέχουσας έκδοσης/διανομής';
$string['currentversion'] = 'Τρέχουσα έκδοση';
$string['databasechecking'] = 'Αναβάθμιση της βάσης δεδομένων του Moodle από την έκδοση {$a->oldversion} στην {$a->newversion}';
$string['databaseperformance'] = 'Επίδοση βάσης δεδομένων';
$string['databasesetup'] = 'Ρύθμιση της βάσης δεδομένων';
$string['databasesuccess'] = 'Η βάση δεδομένων αναβαθμίστηκε επιτυχώς';
$string['databaseupgradebackups'] = 'Η έκδοση αντιγράφου ασφαλείας είναι τώρα {$a}';
$string['databaseupgradeblocks'] = 'Η έκδοση των μπλοκ είναι τώρα {$a}';
$string['databaseupgradegroups'] = 'Η έκδοση των ομάδων είναι τώρα {$a}';
$string['databaseupgradelocal'] = 'Η έκδοση προσαρμογών της τοπικής βάσης δεδομένων είναι τώρα {$a}';
$string['databaseupgrades'] = 'Αναβάθμιση της βάσης δεδομένων';
$string['dataformats'] = 'Μορφότυποι δεδομένων';
$string['date'] = 'Ημερομηνία';
$string['datechanged'] = 'Ημερομηνία άλλαξε';
$string['datemostrecentfirst'] = 'Ημερομηνία - τα πιο πρόσφατα πρώτα';
$string['datemostrecentlast'] = 'Ημερομηνία - τα πιο πρόσφατα τελευταία';
$string['day'] = 'ημέρα';
$string['days'] = 'ημέρες';
$string['decodinginternallinks'] = 'Αποκωδικοποίηση εσωτερικών συνδέσμων';
$string['default'] = 'Προεπιλογή';
$string['defaultcategoryname'] = 'Κατηγορία 1';
$string['defaultcompetencescale'] = 'Προεπιλεγμένη κλίμακα προσόντος';
$string['defaultcompetencescaledesc'] = 'Μια δυαδική κλίμακα αξιολόγησης που δεν παρέχει περαιτέρω πληροφορίες πέρα από το αν κάποιος έχει αποδεδειγμένη επάρκεια ή όχι.';
$string['defaultcompetencescalenotproficient'] = 'Όχι ακόμα επαρκής';
$string['defaultcompetencescaleproficient'] = 'Επαρκής';
$string['defaultcoursestudent'] = 'Μαθητής';
$string['defaultcoursestudentdescription'] = 'Οι μαθητές έχουν λιγότερα δικαιώματα σε ένα μάθημα';
$string['defaultcoursestudents'] = 'Μαθητές';
$string['defaultcoursesummary'] = 'Γράψτε μια παράγραφο που να εξηγεί το περιεχόμενο και τους στόχους του μαθήματος';
$string['defaultcourseteacher'] = 'Διδάσκων';
$string['defaultcourseteacherdescription'] = 'Οι διδάσκοντες μπορούν να κάνουν οτιδήποτε σε ένα μάθημα καθώς επίσης και να αλλάξουν τις δραστηριότητες και τους βαθμούς των μαθητών.';
$string['defaultcourseteachers'] = 'Διδάσκοντες';
$string['defaulteditor'] = 'Προεπιλεγμένος επεξεργαστής κειμένου';
$string['defaulthomepageuser'] = 'Σελίδα έναρξης';
$string['defaulthomepageuser_help'] = 'Σε ποια σελίδα πρέπει να ανακατευθυνθείτε αφού συνδεθείτε στον ιστότοπο;';
$string['delete'] = 'Διαγραφή';
$string['deleteablock'] = 'Διαγραφή πλαισίου';
$string['deleteall'] = 'Διαγραφή όλων';
$string['deleteallcannotundo'] = 'Διαγραφή όλων - δεν μπορεί να αναιρεθεί';
$string['deleteallcomments'] = 'Διαγραφή όλων των σχολίων';
$string['deleteallratings'] = 'Διαγραφή όλων των αξιολογήσεων';
$string['deletecategory'] = 'Διαγραφή κατηγορίας: {$a}';
$string['deletecategorycheck'] = 'Είστε απόλυτα σίγουροι ότι θέλετε να διαγράψετε την κατηγορία <b>«{$a}»</b>;<br /> Αυτό θα έχει σαν αποτέλεσμα τη μεταφορά όλων των μαθημάτων στην πατρική κατηγορία αν υπάρχει ή στην κατηγορία «Miscellaneous» (Διάφορα).';
$string['deletecategorycheck2'] = 'Εάν διαγράψετε αυτή την κατηγορία, πρέπει να επιλέξετε τι θα κάνετε με τα μαθήματα και τις υποκατηγορίες που περιέχει.';
$string['deletecategoryempty'] = 'Αυτή η κατηγορία είναι κενή.';
$string['deletecheck'] = '{$a} - να διαγραφεί;';
$string['deletecheckfiles'] = 'Είστε απολύτως σίγουροι ότι θέλετε να διαγράψετε αυτά τα αρχεία;';
$string['deletecheckfull'] = 'Είστε απολύτως σίγουροι ότι θέλετε να διαγράψετε το χρήστη {$a}, μαζί με τις εγγραφές του, την δραστηριότητά του και άλλα δεδομένα του χρήστη;';
$string['deletechecktype'] = 'Είστε σίγουροι ότι θέλετε να διαγράψετε αυτό το {$a->type};';
$string['deletechecktypename'] = 'Είστε σίγουροι ότι θέλετε να διαγράψετε το {$a->type} «{$a->name}»;';
$string['deletecheckwarning'] = 'Πρόκειται να διαγραφούν αυτά τα αρχεία';
$string['deletecommentbyon'] = 'Διαγραφή σχολίου που αναρτήθηκε από {$a->user} στις {$a->time}';
$string['deletecompletely'] = 'Απόλυτη διαγραφή';
$string['deletecourse'] = 'Διαγραφή ενός μαθήματος';
$string['deletecoursecheck'] = 'Είστε απολύτως βέβαιοι ότι θέλετε να διαγράψετε εντελώς αυτό το μάθημα και όλα τα δεδομένα που περιέχει;';
$string['deleted'] = 'Διαγράφηκε';
$string['deletedactivity'] = '{$a} - διαγράφηκε';
$string['deletedcourse'] = '{$a} διαγράφηκε εντελώς';
$string['deletednot'] = 'Δεν ήταν δυνατή η διαγραφή του {$a}!';
$string['deletepicture'] = 'Διαγραφή';
$string['deletesection'] = 'Διαγραφή ενότητας';
$string['deleteselected'] = 'Διαγραφή του επιλεγμένου';
$string['deleteselectedkey'] = 'Διαγραφή επιλεγμένου κλειδιού';
$string['deletingcourse'] = '{$a} - διαγραφή σε εξέλιξη';
$string['deletingexistingcoursedata'] = 'Διαγραφή υπαρχόντων δεδομένων μαθήματος';
$string['deletingolddata'] = 'Διαγραφή παλαιών δεδομένων';
$string['department'] = 'Τμήμα';
$string['deprecatedeventname'] = '{$a} (δεν χρησιμοποιείται πλέον)';
$string['desc'] = 'Φθίνουσα';
$string['description'] = 'Περιγραφή';
$string['descriptiona'] = 'Περιγραφή: {$a}';
$string['deselectall'] = 'Αποεπιλογή όλων';
$string['deselectnos'] = 'Αποεπιλογή όλων των «Όχι»';
$string['detailedless'] = 'Λιγότερες λεπτομέρειες';
$string['detailedmore'] = 'Περισσότερες λεπτομέρειες';
$string['details'] = 'Λεπτομέρειες';
$string['digitalminor'] = 'Ψηφιακά ανήλικος';
$string['digitalminor_desc'] = 'Παρακαλούμε, ζητήστε από τον γονέα/κηδεμόνα σας να επικοινωνήσει με:';
$string['directory'] = 'Κατάλογος';
$string['disable'] = 'Απενεργοποίηση';
$string['disabledcomments'] = 'Τα σχόλια είναι απενεργοποιημένα';
$string['dismissnotification'] = 'Απόρριψη αυτής της ειδοποίησης';
$string['displayingfirst'] = 'Μόνο τα πρώτα {$a->count} {$a->things} προβάλλονται';
$string['displayingrecords'] = 'Εμφάνιση {$a} εγγραφών';
$string['displayingusers'] = 'Εμφάνιση χρηστών {$a->start} μέχρι {$a->end}';
$string['displayonpage'] = 'Εμφάνιση στην σελίδα';
$string['dndcourse'] = 'Μπορείτε να κάνετε μεταφορά & απόθεση αυτού του μαθήματος για να αλλάξετε τη σειρά του ή να το μετακινήσετε σε άλλη κατηγορία.';
$string['dndenabled_inbox'] = 'Εδώ μπορείτε να κάνετε μεταφορά & απόθεση αρχείων, για να τα προσθέσετε.';
$string['dndnotsupported'] = 'Το ανέβασμα με μεταφορά & απόθεση δεν υποστηρίζεται';
$string['dndnotsupported_help'] = 'Ο περιηγητής σας δεν υποστηρίζει ανέβασμα με μεταφορά & απόθεση. Αυτή η λειτουργία είναι διαθέσιμη σε όλες τις πρόσφατες εκδόσεις του Chrome, Firefox και Safari, καθώς και στον Internet Explorer έκδοσης 10 και πάνω.';
$string['dndnotsupported_insentence'] = 'δεν υποστηρίζεται μεταφορά & απόθεση';
$string['dnduploadwithoutcontent'] = 'Αυτό το ανέβασμα δεν έχει κανένα περιεχόμενο';
$string['dndworkingfile'] = 'Κάντε μεταφορά & απόθεση αρχείων, σε ενότητες μαθήματος, για να τα ανεβάσετε';
$string['dndworkingfilelink'] = 'Κάντε μεταφορά & απόθεση αρχείων ή συνδέσμων, σε ενότητες μαθήματος, για να τα ανεβάσετε';
$string['dndworkingfiletext'] = 'Κάντε μεταφορά & απόθεση αρχείων ή κειμένου, σε ενότητες μαθήματος, για να τα ανεβάσετε';
$string['dndworkingfiletextlink'] = 'Κάντε μεταφορά & απόθεση αρχείων, κειμένου ή συνδέσμων, σε ενότητες μαθήματος, για να τα ανεβάσετε';
$string['dndworkinglink'] = 'Κάντε μεταφορά & απόθεση συνδέσμων, σε ενότητες μαθήματος, για να τα ανεβάσετε';
$string['dndworkingtext'] = 'Κάντε μεταφορά & απόθεση κειμένου, σε ενότητες μαθήματος, για να το ανεβάσετε';
$string['dndworkingtextlink'] = 'Κάντε μεταφορά & απόθεση κειμένου ή συνδέσμων, σε ενότητες μαθήματος, για να τα ανεβάσετε';
$string['documentation'] = 'Τεκμηρίωση Moodle';
$string['dontsortcategories'] = 'Μην ταξινομήσετε τις κατηγορίες';
$string['dontsortcourses'] = 'Μην ταξινομήσετε τα μαθήματα';
$string['down'] = 'Κάτω';
$string['download'] = 'Λήψη';
$string['downloadall'] = 'Λήψη όλων';
$string['downloadexcel'] = 'Λήψη σε μορφότυπο Excel';
$string['downloadfile'] = 'Λήψη αρχείου';
$string['downloadods'] = 'Λήψη σε μορφότυπο ODS';
$string['downloadtext'] = 'Λήψη σε μορφότυπο κειμένου';
$string['doyouagree'] = 'Έχετε διαβάσει και κατανοήσει αυτούς τους όρους;';
$string['droptoupload'] = 'Ρίξτε τα αρχεία εδώ για να τα ανεβάσετε';
$string['duplicate'] = 'Διπλότυπο';
$string['duplicatedmodule'] = '{$a} (αντιγραφή)';
$string['edhelpaspellpath'] = 'Για να χρησιμοποιήσετε τον ορθογραφικό έλεγχο στον επεξεργαστή κειμένου, θα ΠΡΕΠΕΙ πρώτα να έχετε το <strong>aspell 0.50 (ή νεώτερη έκδοση)</strong> εγκατεστημένο στον εξυπηρετητή σας, και πρέπει να καθορίσετε το σωστό μονοπάτι μέχρι το εκτελέσιμο αρχείο του aspell. Στα συστήματα Unix/Linux αυτό το μονοπάτι είναι συνήθως <strong>/usr/bin/aspell</strong>, αλλά μπορεί και να διαφέρει.';
$string['edhelpbgcolor'] = 'Ορίστε το χρώμα υπόβαθρου της περιοχής επεξεργασίας. <br />Έγκυρες τιμές είναι, για παράδειγμα: #FFFFFF ή white';
$string['edhelpcleanword'] = 'Αυτή η ρύθμιση ενεργοποιεί ή απενεργοποιεί το φιλτράρισμα του μορφότυπου, απομακρύνοντας χαρακτηριστικά που λειτουργούν μόνο στο Word.';
$string['edhelpenablespelling'] = 'Ενεργοποίηση ή απενεργοποίηση του ορθογραφικού ελέγχου. Αν τον ενεργοποιήσετε, το <strong>aspell</strong> θα πρέπει να είναι εγκατεστημένο στον εξυπηρετητή. Η δεύτερη τιμή είναι το <strong>προεπιλεγμένο λεξικό</strong>. Αυτή η τιμή θα χρησιμοποιηθεί αν το aspell δεν έχει λεξικό για την γλώσσα του χρήστη.';
$string['edhelpfontfamily'] = 'Η ιδιότητα οικογένεια γραμματοσειράς είναι μια λίστα με ονόματα οικογενειών γραμματοσειρών και/ή γενικά ονόματα οικογενειών. Τα ονόματα οικογενειών θα πρέπει να χωρίζονται με κόμμα.';
$string['edhelpfontlist'] = 'Καθορίστε τις γραμματοσειρές που θα χρησιμοποιούνται στο αναδυόμενο μενού του επεξεργαστή κειμένου.';
$string['edhelpfontsize'] = 'Προεπιλεγμένο μέγεθος γραμματοσειράς (αποδεκτές τιμές 10pt, 10px).';
$string['edit'] = 'Επεξεργασία ';
$string['edita'] = 'Επεξεργασία {$a}';
$string['editcategorysettings'] = 'Επεξεργασία ρυθμίσεων κατηγορίας';
$string['editcategorythis'] = 'Επεξεργασία κατηγορίας';
$string['editcoursesettings'] = 'Επεξεργασία των ρυθμίσεων του μαθήματος';
$string['editfiles'] = 'Επεξεργασία αρχείων';
$string['editgroupprofile'] = 'Επεξεργασία του προφίλ της ομάδας';
$string['editinga'] = 'Επεξεργασία {$a}';
$string['editingteachershort'] = 'Επεξεργαστής κειμένου';
$string['editlock'] = 'Αυτή η τιμή δε μπορεί να αλλάξει!';
$string['editmode'] = 'Κατάσταση επεξεργασίας';
$string['editmyprofile'] = 'Επεξεργασία του προφίλ';
$string['editorbgcolor'] = 'Χρώμα-υπόβαθρου';
$string['editorcleanonpaste'] = 'Αφαίρεση περιττών μορφοποιήσεων του MS-Word';
$string['editorcommonsettings'] = 'Κοινές ρυθμίσεις';
$string['editordefaultfont'] = 'Προεπιλεγμένη γραμματοσειρά';
$string['editorenablespelling'] = 'Ενεργοποίηση ελέγχου ορθογραφίας';
$string['editorfontlist'] = 'Λίστα γραμματοσειρών';
$string['editorfontsize'] = 'Προεπιλεγμένο μέγεθος γραμματοσειράς';
$string['editorpreferences'] = 'Προτιμήσεις επεξεργαστή κειμένου';
$string['editorresettodefaults'] = 'Επαναρχικοποίηση στις προεπιλεγμένες ρυθμίσεις';
$string['editorsettings'] = 'Ρυθμίσεις του επεξεργαστή κειμένου';
$string['editorshortcutkeys'] = 'Πλήκτρα συντόμευσης του επεξεργαστή κειμένου';
$string['editsection'] = 'Επεξεργασία ενότητας';
$string['editsectionname'] = 'Επεξεργασία τίτλου ενότητας';
$string['editsettings'] = 'Επεξεργασία ρυθμίσεων';
$string['editsummary'] = 'Επεξεργασία περίληψης';
$string['editthisactivity'] = 'Επεξεργασία της δραστηριότητας';
$string['editthiscategory'] = 'Επεξεργασία κατηγορίας';
$string['edittitle'] = 'Επεξεργασία τίτλου';
$string['edittitleinstructions'] = 'Escape για να ακυρώσετε, Enter όταν τελειώσετε';
$string['edituser'] = 'Επεξεργασία των λογαριασμών των χρηστών';
$string['edulevel'] = 'Όλα τα γεγονότα';
$string['edulevel_help'] = '* Διδασκαλία - ενέργειες που εκτελούνται από έναν διδάσκοντα, π.χ. ενημέρωση ενός πόρου.
* Συμμετοχή - ενέργειες που εκτελούνται από έναν μαθητή, π.χ. ανάρτηση σε φόρουμ.
* Άλλο - ενέργειες που εκτελούνται από ένα χρήστη με ρόλο διαφορετικό από διδάσκοντα ή μαθητή.';
$string['edulevelother'] = 'Άλλο';
$string['edulevelparticipating'] = 'Συμμετοχή';
$string['edulevelteacher'] = 'Διδασκαλία';
$string['email'] = 'Διεύθυνση ηλε.ταχυδρομείου';
$string['emailactive'] = 'Η αποστολή ηλε.ταχυδρομείου ενεργοποιήθηκε';
$string['emailagain'] = 'Διεύθυνση ηλε.ταχυδρομείου (ξανά)';
$string['emailalreadysent'] = 'Ένα μήνυμα ηλε.ταχυδρομείου για την επαναφορά του κωδικού πρόσβασης έχει ήδη σταλεί. Παρακαλούμε ελέγξτε τα μηνύματά σας.';
$string['emailcharset'] = 'Κωδικοποίηση ηλε.ταχυδρομείου';
$string['emailconfirm'] = 'Επιβεβαιώστε το λογαριασμό σας';
$string['emailconfirmation'] = 'Γεια σας, Έχει γίνει αίτηση δημιουργίας νέου λογαριασμού στο «{$a->sitename}» με χρήση της διεύθυνσης ηλε.ταχυδρομείου σας. Για να επιβεβαιώσετε το νέο λογαριασμό σας, παρακαλούμε μεταβείτε στην παρακάτω διεύθυνση ιστού: {$a->link}
<br />Στα περισσότερα προγράμματα ηλε.ταχυδρομείου, εμφανίζεται ως μπλε σύνδεσμος στον οποίο μπορείτε να απλά να κάνετε κλικ. Αν αυτό δεν λειτουργήσει, τότε κάντε αποκοπή και επικόλληση της διεύθυνσης στη γραμμή διευθύνσεων στο επάνω μέρος του παραθύρου του περιηγητή σας. Αν χρειάζεστε βοήθεια, παρακαλούμε επικοινωνήστε με τον διαχειριστή του ιστοτόπου,
{$a->admin}';
$string['emailconfirmationresend'] = 'Επαναποστολή μηνύματος επιβεβαίωσης με ηλε.ταχυδρομείο.';
$string['emailconfirmationsubject'] = '{$a}: επιβεβαίωση λογαριασμού';
$string['emailconfirmsent'] = '<p>Ένα μήνυμα ηλε.ταχυδρομείου θα πρέπει να έχει σταλεί στη διεύθυνσή σας, <b>{$a}</b></p>
<p>Περιέχει απλές οδηγίες για την ολοκλήρωση της καταχώρησής σας.</p>
<p>Αν συνεχίζετε να αντιμετωπίζετε δυσκολίες, επικοινωνήστε με το διαχειριστή του ιστοτόπου.</p>';
$string['emailconfirmsentfailure'] = 'Αποτυχία αποστολής μηνύματος επιβεβαίωσης με ηλε.ταχυδρομείο.';
$string['emailconfirmsentsuccess'] = 'Η αποστολή μηνύματος επιβεβαίωσης με ηλε.ταχυδρομείο έγινε με επιτυχία.';
$string['emaildigest'] = 'Τύπος σύνοψης ηλε.ταχυδρομείου';
$string['emaildigest_help'] = 'Αυτή είναι η ρύθμιση καθημερινής σύνοψης που θα χρησιμοποιούν τα φόρουμ από προεπιλογή.

* Χωρίς σύνοψη - θα λαμβάνετε ένα μήνυμα ηλε.ταχυδρομείου ανά ανακοίνωση στο φόρουμ.
* Σύνοψη - πλήρεις αναρτήσεις - θα λαμβάνετε μια σύνοψη ανά ημέρα, μέσω ηλε.ταχυδρομείου, που θα περιέχει το πλήρες περιεχόμενο κάθε ανακοίνωσης στο φόρουμ.
* Σύνοψη - θέματα μόνο - θα λαμβάνετε μια σύνοψη ανά ημέρα, μέσω ηλε.ταχυδρομείου, που θα περιέχει μόνο το θέμα της κάθε ανακοίνωσης στο φόρουμ.

Μπορείτε επίσης να επιλέξετε μια διαφορετική ρύθμιση για κάθε φόρουμ, αν το επιθυμείτε.';
$string['emaildigestcomplete'] = 'Ολοκληρωμένη (καθημερινό μήνυμα ηλε.ταχυδρομείου με ολόκληρες τις αναρτήσεις)';
$string['emaildigestoff'] = 'Χωρίς σύνοψη (ένα μήνυμα ηλε.ταχυδρομείου για κάθε ανάρτηση σε φόρουμ)';
$string['emaildigestsubjects'] = 'Θέματα (καθημερινό μήνυμα ηλε.ταχυδρομείου με θέματα μόνο)';
$string['emaildisable'] = 'Η διεύθυνση ηλε.ταχυδρομείου είναι απενεργοποιημένη';
$string['emaildisableclick'] = 'Πατήστε εδώ για να απενεργοποιήσετε την αποστολή όλων των μηνυμάτων ηλε.ταχυδρομείου σε αυτή τη διεύθυνση';
$string['emaildisplay'] = 'Εμφάνιση διεύθυνσης ηλ. ταχυδρομείου';
$string['emaildisplay_help'] = '* Κρυφό - Μόνο οι χρήστες με τα κατάλληλα δικαιώματα, όπως οι εκπαιδευτές, μπορούν να δουν τη διεύθυνση email σας.
* Ορατό σε όλους - Όλοι οι χρήστες στον ιστότοπο μπορούν να δουν τη διεύθυνση email σας.
* Ορατό στους συμμετέχοντες στο μάθημα - Μόνο οι συμμετέχοντες των μαθημάτων στα οποία έχετε εγγραφεί μπορούν να δουν τη διεύθυνση email σας.';
$string['emaildisplaycourse'] = 'Ορατό στους συμμετέχοντες του μαθήματος';
$string['emaildisplaycoursemembersonly'] = '(Ορατό στους άλλους συμμετέχοντες στο μάθημα)';
$string['emaildisplayeveryone'] = '(Ορατό σε όλους)';
$string['emaildisplayhide'] = '(Κρυφό από όλους εκτός από χρήστες με τα κατάλληλα δικαιώματα)';
$string['emaildisplayno'] = 'Κρυφή';
$string['emaildisplayyes'] = 'Oρατή σε όλους';
$string['emailenable'] = 'Αυτή η διεύθυνση ηλε.ταχυδρομείου είναι ενεργοποιημένη';
$string['emailenableclick'] = 'Πατήστε εδώ για να ενεργοποιήσετε ξανά την αποστολή όλων των μηνυμάτων ηλε.ταχυδρομείου σε αυτή τη διεύθυνση';
$string['emailexists'] = 'Υπάρχει ήδη κάποιος άλλος καταχωρημένος χρήστης με αυτή την διεύθυνση ηλε.ταχυδρομείου.';
$string['emailexistshintlink'] = 'Ανάκτηση ξεχασμένου ονόματος χρήστη ή κωδικού';
$string['emailexistssignuphint'] = 'Μήπως έχετε δημιουργήσει ένα λογαριασμό στο παρελθόν; {$a}';
$string['emailformat'] = 'Μορφότυπος μηνύματος ηλε.ταχυδρομείου';
$string['emailmustbereal'] = 'Σημείωση: η διεύθυνση ηλε.ταχυδρομείου πρέπει να είναι πραγματική';
$string['emailnotallowed'] = 'Δεν επιτρέπονται οι διευθύνσεις ηλε.ταχυδρομείου από αυτούς τους τομείς ({$a})';
$string['emailnotfound'] = 'Αδυναμία εύρεσης διεύθυνσης ηλε.ταχυδρομείου στη βάση δεδομένων';
$string['emailonlyallowed'] = 'Αυτή η διεύθυνση ηλε.ταχυδρομείου δεν ανήκει στις επιτρεπόμενες ({$a})';
$string['emailpasswordchangeinfo'] = 'Γεια σας {$a->firstname},

Κάποιος (μάλλον εσείς ο ίδιος) έχει ζητήσει νέο κωδικό πρόσβασης για το λογαριασμό σας στο «{$a->sitename}».

 Για να αλλάξετε τον κωδικό πρόσβασης, παρακαλούμε μεταβείτε στην παρακάτω διεύθυνση ιστού:

{$a->link}

 Στα περισσότερα προγράμματα ηλε.ταχυδρομείου, αυτό θα πρέπει να εμφανίζεται ως μπλε σύνδεσμος στον οποίο μπορείτε να κάνετε κλικ.

 Εάν αυτό δε λειτουργεί, τότε αποκόψτε και επικολλήστε τη διεύθυνση στη γραμμή διεύθυνσης στο επάνω μέρος του παραθύρου του περιηγητή σας.

 Εάν χρειάζεστε βοήθεια, παρακαλούμε επικοινωνήστε με το διαχειριστή του ιστοτόπου, {$a->admin}.';
$string['emailpasswordchangeinfodisabled'] = 'Γεια σας {$a->firstname}. Κάποιος (μάλλον εσείς ο ίδιος) έχει ζητήσει νέο κωδικό πρόσβασης για το λογαριασμό σας στο «{$a->sitename}». Δυστυχώς, ο λογαριασμός σας σε αυτόν τον ιστότοπο είναι απενεργοποιημένος, οπότε ο κωδικός πρόσβασης δεν μπορεί να επαναφερθεί. Παρακαλούμε επικοινωνήστε με το διαχειριστή του ιστοτόπου, {$a->admin}.';
$string['emailpasswordchangeinfofail'] = 'Γεια σας {$a->firstname}. Κάποιος (μάλλον εσείς ο ίδιος) έχει ζητήσει νέο κωδικό πρόσβασης για το λογαριασμό σας στο «{$a->sitename}». Δυστυχώς, δεν είναι δυνατή η επαναφορά κωδικών πρόσβασης σε αυτόν τον ιστότοπο. Παρακαλούμε επικοινωνήστε με το διαχειριστή του ιστοτόπου, {$a->admin}.';
$string['emailpasswordchangeinfosubject'] = '{$a}: Αλλαγή πληροφοριών κωδικού πρόσβασης';
$string['emailpasswordconfirmation'] = 'Γεια σας {$a->firstname}. Κάποιος (μάλλον εσείς ο ίδιος) έχει ζητήσει νέο κωδικό πρόσβασης για το λογαριασμό σας στο «{$a->sitename}». Για να το επιβεβαιώσετε και για να παραλάβετε ένα νέο κωδικό πρόσβασης μέσω ηλε.ταχυδρομείου, επισκεφτείτε την παρακάτω διεύθυνση: {$a->link}. Στα περισσότερα προγράμματα ηλε.ταχυδρομείου, αυτό θα εμφανιστεί ως ένας μπλε σύνδεσμος, στον οποίο μπορείτε να κάνετε κλικ. Αν αυτό δεν λειτουργήσει, τότε κάντε αποκοπή της διεύθυνσης και επικόλληση στην πάνω-πάνω γραμμή (διευθύνσεων) του περιηγητή σας. Αν χρειάζεστε βοήθεια, παρακαλούμε επικοινωνήστε με το διαχειριστή του ιστοτόπου, {$a->admin}.';
$string['emailpasswordconfirmationsubject'] = '{$a}: Επιβεβαίωση αλλαγής κωδικού πρόσβασης';
$string['emailpasswordconfirmmaybesent'] = '<p>Αν έχετε δώσει σωστό όνομα χρήστη ή μοναδική διεύθυνση ηλε.ταχυδρομείου, τότε ένα μήνυμα ηλε.ταχυδρομείου θα έχει σταλεί σε εσάς.</p>
<p>Περιέχει εύκολες πληροφορίες για την επιβεβαίωση και την ολοκλήρωση της αλλαγής του κωδικού πρόσβασης.
Αν συνεχίσετε να έχετε δυσκολίες, παρακαλούμε επικοινωνήστε με τον διαχειριστή του ιστοτόπου.</p>';
$string['emailpasswordconfirmnoemail'] = '<p>Ο λογαριασμός χρήστη που έχετε ορίσει δεν έχει μια καταγεγραμμένη διεύθυνση ηλε.ταχυδρομείου.</p><p>Παρακαλούμε επικοινωνήστε τον διαχειριστή του ιστοτόπου.</p>';
$string['emailpasswordconfirmnotsent'] = '<p>Οι λεπτομέρειες χρήστη που δώσατε δεν προσδιορίζουν έναν υπάρχοντα λογαριασμό χρήστη.</p><p>Παρακαλούμε ελέγξτε τις πληροφορίες που καταχωρήσατε και δοκιμάστε ξανά. Αν συνεχίζετε να αντιμετωπίζετε δυσκολίες, επικοινωνήστε με τον διαχειριστή του ιστοτόπου.</p>';
$string['emailpasswordconfirmsent'] = 'Ένα μήνυμα ηλε.ταχυδρομείου έχει σταλεί στην διεύθυνσή σας στο <b>{$a}</b>. <p>Περιέχει εύκολες οδηγίες για επιβεβαίωση και ολοκλήρωση της αλλαγής του κωδικού πρόσβασης. Αν συνεχίσετε να αντιμετωπίζετε δυσκολίες, επικοινωνήστε με το διαχειριστή.';
$string['emailpasswordsent'] = 'Σας ευχαριστούμε για την επιβεβαίωση της αλλαγής του κωδικού πρόσβασης. Ένα μήνυμα ηλε.ταχυδρομείου που περιέχει τον νέο κωδικό πρόσβασής σας σάς έχει σταλεί στη διεύθυνση σας <br /><b>{$a->email}</b>.<br /> Ο νέος κωδικός πρόσβασης δημιουργήθηκε αυτόματα - ίσως να θέλετε να <a href="{$a->link}">αλλάξετε τον κωδικό πρόσβασής σας</a> με κάποιον που να μπορείτε να θυμηθείτε πιο εύκολα.';
$string['emailresetconfirmation'] = 'Γεια σας {$a->firstname},

Έγινε αίτηση αλλαγής κωδικού πρόσβασης για τον λογαριασμό σας «{$a->username}» στο {$a->sitename}.

Για να επιβεβαιώσετε αυτό το αίτημα και να ορίσετε ένα νέο κωδικό για τον λογαριασμό σας παρακαλούμε πατήστε στον παρακάτω σύνδεσμο: {$a->link}

(Αυτός ο σύνδεσμος είναι ενεργός για {$a->resetminutes} λεπτά  από τη στιγμή που έγινε η αίτηση αλλαγής).

Αν το αίτημα αλλαγής κωδικού δεν έγινε από εσάς, τότε δεν χρειάζεται περαιτέρω ενέργεια.

Αν χρειάζεστε βοήθεια, παρακαλούμε επικοινωνήστε με τον διαχειριστή του ιστοτόπου, {$a->admin}.';
$string['emailresetconfirmationsubject'] = '{$a}: αίτημα επαναφοράς κωδικού πρόσβασης';
$string['emailresetconfirmsent'] = 'Ένα μήνυμα ηλε.ταχυδρομείου έχει σταλεί στη διεύθυνση σας στο <b>{$a}.</b>
<br />Περιέχει απλές οδηγίες για να επιβεβαιώσετε και να ολοκληρωθεί αυτή η αλλαγή του κωδικού πρόσβασης.
Εάν συνεχίσετε να αντιμετωπίζετε δυσκολίες, επικοινωνήστε με το διαχειριστή του ιστοτόπου.';
$string['emailstop'] = 'Απενεργοποίηση ειδοποιήσεων';
$string['emailtoprivatefiles'] = 'Μπορείτε επίσης να στείλετε αρχεία ως συνημμένα μέσω ηλε.ταχυδρομείου απευθείας στο χώρο των ιδιωτικών αρχείων σας. Απλά επισυνάψτε τα αρχεία σας σε ένα μήνυμα ηλε.ταχυδρομείου και στείλτε το στο {$a}';
$string['emailtoprivatefilesdenied'] = 'Ο διαχειριστής σας έχει απενεργοποιήσει τη δυνατότητα να ανεβάσετε τα δικά σας ιδιωτικά αρχεία.';
$string['emailvia'] = '{$a->name} (μέσω {$a->siteshortname})';
$string['emojicategoryactivities'] = 'Δραστηριότητες';
$string['emojicategoryanimalsnature'] = 'Ζώα & φύση';
$string['emojicategoryflags'] = 'Σημαίες';
$string['emojicategoryfooddrink'] = 'Φαγητό & ποτό';
$string['emojicategoryobjects'] = 'Αντικείμενα';
$string['emojicategorypeoplebody'] = 'Άνθρωποι και σώμα';
$string['emojicategoryrecent'] = 'Πρόσφατα';
$string['emojicategorysmileysemotion'] = 'Φατσούλες & συναίσθημα';
$string['emojicategorysymbols'] = 'Σύμβολα';
$string['emojicategorytravelplaces'] = 'Ταξίδια & μέρη';
$string['emptycmids'] = 'Κενά αναγνωριστικά αρθρωμάτων μαθημάτων';
$string['emptydragdropregion'] = 'κενή περιοχή';
$string['emptysectionids'] = 'Κενά αναγνωριστικά ενοτήτων';
$string['enable'] = 'Ενεργοποίηση';
$string['encryptedcode'] = 'Κρυπτογραφημένος κωδικός';
$string['enddate'] = 'Καταληκτική ημερομηνία μαθήματος';
$string['enddate_help'] = 'Η ημερομηνία λήξης δεν περιορίζει την πρόσβαση των μαθητών στο μάθημα. Καθορίζει εάν ένα μάθημα αναφέρεται ως Παλιότερο στα μαθήματά μου.';
$string['english'] = 'Αγγλικά';
$string['enrolmentmethods'] = 'Μέθοδοι εγγραφής';
$string['entercourse'] = 'Πατήστε για να εισέλθετε σε αυτό το μάθημα';
$string['enteremail'] = 'Εισάγετε τη διεύθυνση ηλε.ταχυδρομείου σας';
$string['enteremailaddress'] = 'Εισάγετε τη διεύθυνση ηλε.ταχυδρομείου για επαναφορά του κωδικού πρόσβασής σας και ο νέος κωδικός πρόσβασης θα σας αποσταλεί μέσω ηλε.ταχυδρομείου';
$string['enterusername'] = 'Εισάγετε το όνομα χρήστη σας';
$string['entries'] = 'Καταχωρήσεις';
$string['error'] = 'Σφάλμα';
$string['errorcreatingactivity'] = 'Αδυναμία δημιουργίας ενός στιγμιοτύπου της δραστηριότητας «{$a}»';
$string['errorfiletoobig'] = 'Το αρχείο ήταν μεγαλύτερο από το καθορισμένο όριο';
$string['errornouploadrepo'] = 'Δεν υπάρχει κανένα ενεργοποιημένο αποθετήριο για ανέβασμα (αρχείων) για αυτόν τον ιστότοπο';
$string['errorwhenconfirming'] = 'Δεν έχει γίνει η επιβεβαίωσή σας ακόμα γιατί προκλήθηκε σφάλμα. Αν βρεθήκατε εδώ πατώντας ένα σύνδεσμο σε μήνυμα ηλε.ταχυδρομείου, βεβαιωθείτε ότι η γραμμή του συνδέσμου δεν ήταν σπασμένη ή συνεχιζόταν σε επόμενη γραμμή. Πιθανώς να χρειαστεί να κάνετε αποκοπή και επικόλληση για να επανασχηματίσετε μόνοι σας το σύνδεσμο.';
$string['eventcommentcreated'] = 'Δημιουργία σχολίου';
$string['eventcommentdeleted'] = 'Το σχόλιο διαγράφηκε';
$string['eventcommentsviewed'] = 'Εμφάνιση σχολίων';
$string['eventconfiglogcreated'] = 'Δημιουργήθηκε καταγραφή/ιστορικό διαμόρφωσης';
$string['eventcontentviewed'] = 'Εμφάνιση περιεχομένου';
$string['eventcoursebackupcreated'] = 'Το αντίγραφο ασφαλείας του μαθήματος δημιουργήθηκε';
$string['eventcoursecategorycreated'] = 'Δημιουργία κατηγορίας';
$string['eventcoursecategorydeleted'] = 'Διαγραφή κατηγορίας';
$string['eventcoursecategoryupdated'] = 'Ενημέρωση κατηγορίας';
$string['eventcoursecategoryviewed'] = 'Εμφάνιση κατηγορίας';
$string['eventcoursecontentdeleted'] = 'Το περιεχόμενο του μαθήματος διαγράφηκε';
$string['eventcoursecreated'] = 'Δημιουργία μαθήματος';
$string['eventcoursedeleted'] = 'Το μάθημα διαγράφηκε';
$string['eventcourseinformationviewed'] = 'Εμφάνιση περίληψης μαθήματος';
$string['eventcoursemodulecreated'] = 'Το αρθρώματος μαθήματος δημιουργήθηκε';
$string['eventcoursemoduledeleted'] = 'Διαγραφή αρθρώματος μαθήματος';
$string['eventcoursemoduleinstancelistviewed'] = 'Εμφάνιση λίστας στιγμιοτύπων αρθρώματος μαθήματος';
$string['eventcoursemoduleupdated'] = 'Ενημέρωση αρθρώματος μαθήματος';
$string['eventcoursemoduleviewed'] = 'Εμφάνιση αρθρώματος μαθήματος';
$string['eventcourseresetended'] = 'Ολοκλήρωση επαναφοράς μαθήματος';
$string['eventcourseresetstarted'] = 'Έναρξη επαναφοράς μαθήματος';
$string['eventcourserestored'] = 'Η επαναφορά μαθήματος ολοκληρώθηκε';
$string['eventcoursesectioncreated'] = 'Η ενότητα μαθήματος δημιουργήθηκε';
$string['eventcoursesectiondeleted'] = 'Διαγραφή ενότητας μαθήματος';
$string['eventcoursesectionupdated'] = 'Ενημέρωση ενότητας μαθήματος';
$string['eventcoursessearched'] = 'Μαθήματα που αναζητήθηκαν';
$string['eventcourseupdated'] = 'Το μάθημα ενημερώθηκε';
$string['eventcourseuserreportviewed'] = 'Εμφάνιση αναφοράς χρηστών μαθήματος';
$string['eventcourseviewed'] = 'Εμφάνιση μαθήματος';
$string['eventdashboardreset'] = 'Επαναφορά του Ταμπλό';
$string['eventdashboardsreset'] = 'Επαναφορά των Ταμπλό';
$string['eventdashboardviewed'] = 'Το Ταμπλό εμφανίστηκε';
$string['eventdatabasetextfieldcontentreplaced'] = 'Καθολική αναζήτηση και αντικατάσταση βάσης δεδομένων';
$string['eventemailfailed'] = 'Αποτυχία αποστολής ηλε.ταχυδρομείου';
$string['eventname'] = 'Όνομα γεγονότος';
$string['eventrecentactivityviewed'] = 'Εμφάνιση πρόσφατης δραστηριότητας';
$string['eventsearchindexed'] = 'Αναζήτηση στα δεδομένα με ευρετήριο';
$string['eventsearchresultsviewed'] = 'Εμφάνιση αποτελεσμάτων αναζήτησης';
$string['eventunknownlogged'] = 'Άγνωστο γεγονός';
$string['eventusercreated'] = 'Δημιουργία χρήστη';
$string['eventuserdeleted'] = 'Διαγραφή χρήστη';
$string['eventuserfeedbackgiven'] = 'Έγινε κλικ στον σύνδεσμο σχολίων';
$string['eventuserfeedbackremind'] = 'Έγινε κλικ στο σύνδεσμο για μελλοντική υπενθύμιση σχολιασμού';
$string['eventuserinfocategorycreated'] = 'Η κατηγορία πεδίου προφίλ χρήστη δημιουργήθηκε';
$string['eventuserinfocategorydeleted'] = 'Η κατηγορία πεδίου του προφίλ χρήστη διαγράφηκε';
$string['eventuserinfocategoryupdated'] = 'Η κατηγορία πεδίου προφίλ χρήστη ενημερώθηκε';
$string['eventuserinfofieldcreated'] = 'Το πεδίο προφίλ χρήστη δημιουργήθηκε';
$string['eventuserinfofielddeleted'] = 'Το πεδίο προφίλ χρήστη διαγράφηκε';
$string['eventuserinfofieldupdated'] = 'Το πεδίο προφίλ χρήστη ενημερώθηκε';
$string['eventuserlistviewed'] = 'Εμφάνιση λίστας χρηστών';
$string['eventuserloggedout'] = 'Αποσύνδεση χρήστη';
$string['eventuserpasswordpolicyfailed'] = 'Ο κωδικός πρόσβασης χρήστη δεν ικανοποιεί την πολιτική κωδικού πρόσβασης';
$string['eventuserpasswordupdated'] = 'Ενημέρωση κωδικού πρόσβασης χρήστη';
$string['eventuserprofileviewed'] = 'Εμφάνιση προφίλ χρήστη';
$string['eventuserupdated'] = 'Ενημέρωση προφίλ χρήστη';
$string['everybody'] = 'Όλοι';
$string['executeat'] = 'Εκτέλεση στις';
$string['existing'] = 'Υπάρχει';
$string['existingadmins'] = 'Υπάρχοντες διαχειριστές';
$string['existingcourse'] = 'Υπάρχον μάθημα';
$string['existingcourseadding'] = 'Υπάρχον μάθημα, προσθήκη δεδομένων σε αυτό';
$string['existingcoursedeleting'] = 'Υπάρχον μάθημα, διαγραφή του πρώτα';
$string['existingcreators'] = 'Υπάρχοντες δημιουργοί μαθημάτων';
$string['existingstudents'] = 'Εγγεγραμμένοι μαθητές';
$string['existingteachers'] = 'Υπάρχοντες διδάσκοντες';
$string['expand'] = 'Ανάπτυξη';
$string['expandall'] = 'Ανάπτυξη όλων';
$string['expandcategory'] = 'Ανάπτυξη {$a}';
$string['explanation'] = 'Επεξήγηση';
$string['explanationdigitalminor'] = 'Αυτές οι πληροφορίες είναι απαραίτητες για να καθοριστεί αν η ηλικία σας είναι πάνω από την ηλικία ψηφιακής συγκατάθεσης. Αυτή είναι η ηλικία κατά την οποία ένα άτομο μπορεί να συναινέσει στους όρους και τις προϋποθέσεις και στην νόμιμη αποθήκευση και επεξεργασία των δεδομένων του.';
$string['extendperiod'] = 'Επέκταση περιόδου';
$string['extendsession'] = 'Επέκταση συνόδου';
$string['failedloginattempts'] = '{$a->attempts} αποτυχημένες προσπάθειες σύνδεσης από την τελευταία σας σύνδεση';
$string['favourites'] = 'Με αστερίσκο';
$string['feedback'] = 'Σχόλια χρηστών';
$string['file'] = 'Αρχείο';
$string['fileexists'] = 'Υπάρχει ήδη το αρχείο με όνομα {$a}';
$string['filemissing'] = '{$a} - λείπει';
$string['filereaderror'] = 'Δεν είναι δυνατή η ανάγνωση του αρχείου «{$a}». Ελέγξτε ότι είναι πραγματικά ένα αρχείο και όχι φάκελος.';
$string['files'] = 'Αρχεία';
$string['filesanduploads'] = 'Αρχεία και μεταφορτώσεις';
$string['filesfolders'] = 'Αρχεία/φάκελοι';
$string['fileuploadwithcontent'] = 'Τα ανεβασμένα αρχεία δεν πρέπει να περιλαμβάνουν την παράμετρο περιεχομένου';
$string['filloutallfields'] = 'Παρακαλούμε συμπληρώστε όλα τα πεδία σε αυτή τη φόρμα';
$string['filter'] = 'Φίλτρο';
$string['filteroption'] = '{$a->criteria}: {$a->value}';
$string['filterrowlegend'] = 'Φίλτρο {$a}';
$string['filters'] = 'Φίλτρα';
$string['filtersetmatchdescription'] = 'Πώς πρέπει να συνδυάζονται πολλαπλά φίλτρα';
$string['filtertype'] = 'Τύπος φίλτρου';
$string['findmorecourses'] = 'Εύρεση περισσότερων μαθημάτων...';
$string['first'] = 'Πρώτο';
$string['firstaccess'] = 'Πρώτη πρόσβαση';
$string['firstname'] = 'Μικρό/Βαπτιστικό όνομα';
$string['firstnamephonetic'] = 'Όνομα (φωνητικό)';
$string['firstpage'] = 'Πρώτη σελίδα';
$string['firstsiteaccess'] = 'Πρώτη πρόσβαση στον ιστότοπο';
$string['firsttime'] = 'Είναι η πρώτη σας φορά εδώ;';
$string['folder'] = 'Φάκελος';
$string['folderclosed'] = 'Κλειστός φάκελος';
$string['folderopened'] = 'Ανοικτός φάκελος';
$string['followingoptional'] = 'Τα επόμενα είναι προαιρετικά';
$string['followingrequired'] = 'Τα επόμενα είναι απαραίτητα';
$string['for'] = 'Για';
$string['force'] = 'Επιβολή';
$string['forcelanguage'] = 'Επιβολή γλώσσας';
$string['forceno'] = 'Χωρίς επιβολή';
$string['forcepasswordchange'] = 'Επιβολή αλλαγής κωδικού πρόσβασης';
$string['forcepasswordchange_help'] = 'Αν αυτό το πλαίσιο επιλογής είναι επιλεγμένο, ο χρήστης προτρέπεται να αλλάξει τον κωδικό πρόσβασής του κατά την επόμενη σύνδεσή του';
$string['forcepasswordchangecheckfull'] = 'Είστε βέβαιοι ότι θέλετε να επιβάλετε αλλαγή κωδικού πρόσβασης στον/στην {$a};';
$string['forcepasswordchangenot'] = 'Δεν ήταν δυνατή η επιβολή αλλαγής κωδικού πρόσβασης στον/στην {$a}';
$string['forcepasswordchangenotice'] = 'Πρέπει να αλλάξετε τον κωδικό πρόσβασης για να συνεχίσετε.';
$string['forcepasswordresetfailurenotice'] = 'Ο τρέχων κωδικός πρόσβασης σας, δεν ικανοποιεί πλέον την καθορισμένη πολιτική κωδικών πρόσβασης. Παρακαλούμε, επικοινωνήστε με το διαχειριστή του Moodle για βοήθεια.
   {$a}';
$string['forcepasswordresetnotice'] = 'Ο τρέχων κωδικός πρόσβασης σας, δεν ικανοποιεί πλέον την καθορισμένη πολιτική κωδικών πρόσβασης. Για να συνδεθείτε πρέπει ο κωδικός πρόσβασής σας να επαναρχικοποιηθεί.
   {$a}';
$string['forcetheme'] = 'Επιβολή αισθητικού θέματος';
$string['forgotaccount'] = 'Ξεχάσατε τον κωδικό σας;';
$string['forgotten'] = 'Ξεχάσατε το όνομα χρήστη ή τον κωδικό πρόσβασης;';
$string['forgottenduplicate'] = 'Αυτή η διεύθυνση ηλε.ταχυδρομείου είναι κοινόχρηστη από πολλούς λογαριασμούς. Παρακαλούμε, αντί της διεύθυνσης αυτής, να εισαγάγετε το όνομα χρήστη.';
$string['forgotteninvalidurl'] = 'Μη αποδεκτός σύνδεσμος αλλαγής του κωδικού πρόσβασης';
$string['format'] = 'Μορφότυπος';
$string['format_help'] = 'Ο μορφότυπος του μαθήματος καθορίζει την εμφάνιση της σελίδας μαθήματος.

* Μορφότυπος ενιαίας δραστηριότητας - Για εμφάνιση μίας μόνο δραστηριότητας ή πόρου (όπως ένα Κουίζ ή ένα πακέτο SCORM) στην σελίδα μαθήματος.
* Κοινωνικός μορφότυπος - Ένα φόρουμ εμφανίζεται στην σελίδα μαθήματος.
* Μορφότυπος θεμάτων - Η σελίδα μαθήματος οργανώνεται σε ενότητες θεμάτων.
* Εβδομαδιαίος μορφότυπος - Η σελίδα μαθήματος οργανώνεται σε εβδομαδιαίες ενότητες, με την πρώτη εβδομάδα να αρχίζει την ημερομηνία έναρξης του μαθήματος.';
$string['formathtml'] = 'Μορφότυπος HTML';
$string['formatmarkdown'] = 'Μορφότυπος Markdown';
$string['formatplain'] = 'Μορφότυπος απλού κειμένου';
$string['formattext'] = 'Μορφότυπος αυτόματης μορφοποίησης από το Moodle';
$string['forumpreferences'] = 'Προτιμήσεις φόρουμ';
$string['framesetinfo'] = 'Αυτό το frameset περιέχει:';
$string['from'] = 'Από';
$string['frontpagecategorycombo'] = 'Λίστα συνδυασμού';
$string['frontpagecategorynames'] = 'Εμφάνιση μιας λίστας κατηγοριών';
$string['frontpagecourselist'] = 'Εμφάνιση μιας λίστας μαθημάτων';
$string['frontpagecoursesearch'] = 'Πλαίσιο αναζήτησης μαθήματος';
$string['frontpagedescription'] = 'Σύνοψη αρχικής σελίδας ιστοτόπου';
$string['frontpagedescriptionhelp'] = 'Αυτή η περίληψη μπορεί να εμφανιστεί στην αρχική σελίδα του ιστότοπου χρησιμοποιώντας το μπλοκ περίληψης μαθημάτων/ιστοτόπου.';
$string['frontpageenrolledcourselist'] = 'Μαθήματα που έχει γίνει εγγραφή';
$string['frontpageformat'] = 'Μορφότυπος αρχικής σελίδας';
$string['frontpageformatloggedin'] = 'Μορφότυπος αρχικής σελίδας μετά από σύνδεση';
$string['frontpagenews'] = 'Ανακοινώσεις';
$string['frontpagesettings'] = 'Ρυθμίσεις αρχικής σελίδας';
$string['fulllistofcourses'] = 'Όλα τα μαθήματα';
$string['fullname'] = 'Πλήρες όνομα';
$string['fullnamecourse'] = 'Πλήρες όνομα μαθήματος';
$string['fullnamecourse_help'] = 'Το όνομα που εμφανίζεται στην ενότητα Τα μαθήματά μου και στη λίστα με τα διαθέσιμα μαθήματα στην Αρχική σελίδα.';
$string['fullnamedisplay'] = '{$a->firstname} {$a->lastname}';
$string['fullnameuser'] = 'Πλήρες όνομα χρήστη';
$string['fullprofile'] = 'Πλήρες προφίλ';
$string['fullsitename'] = 'Πλήρες όνομα ιστοτόπου';
$string['functiondisabled'] = 'Αυτή η λειτουργία είναι απενεργοποιημένη';
$string['general'] = 'Γενικά';
$string['geolocation'] = 'γεωγραφικό πλάτος - μήκος';
$string['gettheselogs'] = 'Φέρτε αυτές τις καταγραφές';
$string['go'] = 'Μεταβείτε';
$string['gpl'] = 'Πνευματικά Δικαιώματα (C) 1999 Martin Dougiamas  (https://moodle.com)

Αυτό το πρόγραμμα είναι δωρεάν λογισμικό· μπορείτε να το αναδιανείμετε και/ή να το τροποποιήσετε υπό τους όρους της άδειας GNU General Public Licence όπως δημοσιεύεται στο Free Software Foundation, είτε στην έκδοση 2 της Άδειας ή (κατά δική σας επιλογή) μιας επόμενης έκδοσης.

Αυτό το πρόγραμμα διανέμεται ελπίζοντας ότι θα φανεί χρήσιμο, όμως ΧΩΡΙΣ ΚΑΜΙΑ ΕΓΓΥΗΣΗ, χωρίς ακόμα και την υπονοούμενη εγγύηση ΕΜΠΟΡΕΥΣΙΜΟΤΗΤΑΣ ή ΚΑΤΑΛΛΗΛΟΤΗΤΑΣ ΓΙΑ ΣΥΓΚΕΚΡΙΜΕΝΟ ΣΚΟΠΟ.

Δείτε τη σελίδα πληροφοριών Άδειας Moodle για περισσότερες λεπτομέρειες: https://moodledev.io/general/license';
$string['gpl3'] = 'Πνευματικά Δικαιώματα (C) 1999 Martin Dougiamas (https://moodle.com)

 Αυτό το πρόγραμμα είναι δωρεάν λογισμικό· μπορείτε να το αναδιανείμετε και/ή να το τροποποιήσετε υπό τους όρους της άδειας GNU General Public License όπως δημοσιεύεται στο Free Software Foundation, είτε στην έκδοση 3 της Άδειας ή (κατά δική σας επιλογή) μιας επόμενης έκδοσης.

Αυτό το πρόγραμμα διανέμεται ελπίζοντας ότι θα φανεί χρήσιμο, όμως ΧΩΡΙΣ ΚΑΜΙΑ ΕΓΓΥΗΣΗ, χωρίς ακόμα και την υπονοούμενη εγγύηση ΕΜΠΟΡΕΥΣΙΜΟΤΗΤΑΣ ή ΚΑΤΑΛΛΗΛΟΤΗΤΑΣ ΓΙΑ ΣΥΓΚΕΚΡΙΜΕΝΟ ΣΚΟΠΟ.

Δείτε τη σελίδα πληροφοριών Άδειας Moodle για περισσότερες λεπτομέρειες: https://moodledev.io/general/license';
$string['gpllicense'] = 'Άδεια χρήσης GPL';
$string['grade'] = 'Βαθμός';
$string['gradenoun'] = 'Βαθμός';
$string['grades'] = 'Βαθμοί';
$string['gradeverb'] = 'Βαθμολόγηση';
$string['gravatarenabled'] = 'Το <a href="https://www.gravatar.com/">Gravatar</a> έχει ενεργοποιηθεί για αυτό τον ιστότοπο. Αν δεν ανεβάσετε μια φωτογραφία προφίλ, το Moodle θα προσπαθήσει να φορτώσει μια εικόνα προφίλ για εσάς από το Gravatar.';
$string['group'] = 'Ομάδα';
$string['groupadd'] = 'Προσθήκη νέας ομάδας';
$string['groupaddusers'] = 'Προσθήκη επιλεγμένων στην ομάδα';
$string['groupfor'] = 'για την ομάδα';
$string['groupinfo'] = 'Πληροφορίες για επιλεγμένη ομάδα';
$string['groupinfoedit'] = 'Επεξεργασία των ρυθμίσεων της ομάδας';
$string['groupinfomembers'] = 'Πληροφορίες για τα επιλεγμένα μέλη';
$string['groupinfopeople'] = 'Πληροφορίες για τα επιλεγμένα άτομα';
$string['groupmembers'] = 'Μέλη της ομάδας';
$string['groupmemberssee'] = 'Εμφάνιση των μελών της ομάδας';
$string['groupmembersselected'] = 'Μέλη της επιλεγμένης ομάδας';
$string['groupmode'] = 'Μορφή ομάδων';
$string['groupmodeforce'] = 'Επιβολή τρόπου λειτουργίας ομάδων';
$string['groupmy'] = 'Η ομάδα μου';
$string['groupnonmembers'] = 'Χρήστες που δεν ανήκουν σε ομάδα';
$string['groupnotamember'] = 'Συγγνώμη, αλλά δεν είστε μέλος αυτής της ομάδας';
$string['grouprandomassign'] = 'Τυχαία κατανομή σε ομάδες';
$string['groupremove'] = 'Αφαίρεση επιλεγμένης ομάδας';
$string['groupremovemembers'] = 'Αφαίρεση επιλεγμένων μελών';
$string['groups'] = 'Ομάδες';
$string['groupsnone'] = 'Χωρίς ομάδες';
$string['groupsseparate'] = 'Ξεχωριστές ομάδες';
$string['groupsvisible'] = 'Ορατές ομάδες';
$string['guest'] = 'Επισκέπτης';
$string['guestdescription'] = 'Οι επισκέπτες έχουν τα λιγότερα δυνατά δικαιώματα και δε μπορούν να εισάγουν κείμενο πουθενά.';
$string['guestskey'] = 'Επιτρέπονται επισκέπτες που έχουν το κλειδί';
$string['guestsno'] = 'Να μην επιτρέπονται επισκέπτες';
$string['guestsnotallowed'] = 'Δυστυχώς, το «{$a}» δεν επιτρέπει την πρόσβαση στους επισκέπτες.';
$string['guestsyes'] = 'Επιτρέπονται επισκέπτες που δεν έχουν το κλειδί';
$string['guestuser'] = 'Επισκέπτης (Guest user)';
$string['guestuserinfo'] = 'Αυτός είναι ένας ειδικός χρήστης που έχει πρόσβαση μόνο για ανάγνωση σε μερικά μαθήματα.';
$string['help'] = 'Βοήθεια';
$string['helpprefix2'] = 'Βοήθεια για {$a}';
$string['helpwiththis'] = 'Βοήθεια για αυτό';
$string['hiddenassign'] = 'Κρυμμένη εργασία';
$string['hiddenfromstudents'] = 'Κρυμμένο από τους μαθητές';
$string['hiddenoncoursepage'] = 'Διαθέσιμο αλλά δεν εμφανίζεται στη σελίδα του μαθήματος';
$string['hiddensections'] = 'Ενότητες που έχετε αποκρύψει';
$string['hiddensections_help'] = 'Οι κρυφές ενότητες μπορούν να εμφανιστούν στους μαθητές ως «μη διαθέσιμες» στη σελίδα του μαθήματος ή να διατηρηθούν εντελώς κρυφές.';
$string['hiddensectionscollapsed'] = 'Οι κρυφές ενότητες εμφανίζονται ως μη διαθέσιμες';
$string['hiddensectionsinvisible'] = 'Οι ενότητες που έχετε αποκρύψει δεν θα προβάλλονται καθόλου';
$string['hiddenwithbrackets'] = '(σε απόκρυψη)';
$string['hide'] = 'Απόκρυψη';
$string['hideadvancedsettings'] = 'Απόκρυψη των προχωρημένων ρυθμίσεων';
$string['hidechartdata'] = 'Απόκρυψη δεδομένων γραφήματος';
$string['hidefromstudents'] = 'Απόκρυψη στη σελίδα του μαθήματος';
$string['hideoncoursepage'] = 'Να είναι διαθέσιμο αλλά να μην εμφανίζεται στη σελίδα του μαθήματος';
$string['hidepicture'] = 'Απόκρυψη εικόνας';
$string['hidepopoverwindow'] = 'Απόκρυψη αναπτυσσόμενου παραθύρου';
$string['hidesection'] = 'Απόκρυψη ενότητας {$a}';
$string['hidesettings'] = 'Απόκρυψη ρυθμίσεων';
$string['hideshowblocks'] = 'Σύμπτυξη ή ανάπτυξη μπλοκ';
$string['highlight'] = 'Φωτο-επισήμανση';
$string['highlighted'] = 'Φωτοεπισημασμένο';
$string['highlightoff'] = 'Αφαίρεση φωτο-επισήμανσης';
$string['hits'] = 'Επισκέψεις';
$string['hitsoncourse'] = 'Επισκέψεις στο {$a->coursename} από την/τον {$a->username}';
$string['hitsoncoursetoday'] = 'Σημερινές επισκέψεις στο {$a->coursename} από το χρήστη {$a->username}';
$string['home'] = 'Αρχική';
$string['homeheader'] = 'Αρχικό μενού';
$string['hour'] = 'ώρα';
$string['hours'] = 'ώρες';
$string['howtomakethemes'] = 'Πως να δημιουργήσετε νέα αισθητικά θέματα';
$string['htmleditor'] = 'Χρήση επεξεργαστή HTML';
$string['htmleditoravailable'] = 'Ο επεξεργαστής HTML είναι διαθέσιμος';
$string['htmleditordisabled'] = 'Έχετε απενεργοποιήσει τον επεξεργαστή HTML στο προφίλ σας';
$string['htmleditordisabledadmin'] = 'Ο διαχειριστής έχει απενεργοποιήσει τον επεξεργαστή HTML σε αυτόν τον ιστότοπο';
$string['htmleditordisabledbrowser'] = 'Ο επεξεργαστής HTML δεν είναι διαθέσιμος επειδή ο περιηγητής ιστού σας είναι ασύμβατος';
$string['htmlfilesonly'] = 'Μόνο αρχεία HTML';
$string['htmlformat'] = 'Μορφή Pretty HTML';
$string['icon'] = 'Εικονίδιο';
$string['icqnumber'] = 'Αριθμός  ICQ';
$string['idnumber'] = 'Αναγνωριστικός αριθμός';
$string['idnumbercourse'] = 'Αναγνωριστικός αριθμός μαθήματος';
$string['idnumbercourse_help'] = 'Χρησιμοποιείται μόνο για τη σύνδεση του μαθήματος με εξωτερικά συστήματα. Αφήστε κενό εάν δεν έχετε επίσημο  ID μαθήματος.';
$string['idnumbercoursecategory'] = 'Αναγνωριστικός αριθμός κατηγορίας';
$string['idnumbercoursecategory_help'] = 'Ο αναγνωριστικός αριθμός μιας κατηγορίας μαθημάτων χρησιμοποιείται μόνο κατά την αντιστοίχιση της κατηγορίας με εξωτερικά συστήματα και δεν εμφανίζεται πουθενά στον ιστότοπο. Αν η κατηγορία έχει κάποιο επίσημο κωδικό όνομα, μπορεί να εισαχθεί αυτό, διαφορετικά το πεδίο μπορεί να παραμείνει κενό.';
$string['idnumbergroup'] = 'Αναγνωριστικός αριθμός ομάδας';
$string['idnumbergroup_help'] = 'Ο αναγνωριστικός αριθμός μιας ομάδας συμμετεχόντων χρησιμοποιείται μόνο όταν γίνεται αντιστοίχιση της ομάδας με εξωτερικά συστήματα και δεν εμφανίζεται πουθενά αλλού στον ιστότοπο. Αν η ομάδα έχει ένα επίσημο κωδικό όνομα, μπορεί να εισαχθεί, αλλιώς το πεδίο μπορεί να παραμείνει κενό.';
$string['idnumbergrouping'] = 'Αναγνωριστικός αριθμός ομαδοποίησης';
$string['idnumbergrouping_help'] = 'Ο αναγνωριστικός αριθμός μιας ομαδοποίησης χρησιμοποιείται μόνο κατά την αντιστοίχιση της ομαδοποίησης με εξωτερικά συστήματα και δεν εμφανίζεται πουθενά αλλού στον ιστότοπο. Αν η ομαδοποίηση έχει ένα επίσημο κωδικό όνομα, μπορεί να εισαχθεί, αλλιώς το πεδίο μπορεί να παραμείνει κενό.';
$string['idnumbermod'] = 'Αναγνωριστικός αριθμός';
$string['idnumbermod_help'] = 'Ο ορισμός ενός αναγνωριστικού αριθμού παρέχει έναν τρόπο προσδιορισμού της δραστηριότητας για σκοπούς υπολογισμού βαθμού. Εάν η δραστηριότητα δεν συμπεριλαμβάνεται σε κανέναν υπολογισμό βαθμού τότε το πεδίο του αναγνωριστικού αριθμού μπορεί να παραμείνει κενό. Ο αναγνωριστικός αριθμός μπορεί επίσης να οριστεί στο βαθμολόγιο, αν και μπορεί να γίνει επεξεργασία του μόνο στη σελίδα ρυθμίσεων της δραστηριότητας.';
$string['idnumbertaken'] = 'Αυτός ο αναγνωριστικός αριθμός έχει ήδη επιλεγεί';
$string['imagealt'] = 'Περιγραφή εικόνας';
$string['import'] = 'Εισαγωγή';
$string['importdata'] = 'Εισαγωγή δεδομένων μαθήματος';
$string['importdataexported'] = 'Επιτυχής εξαγωγή δεδομένων από το μάθημα «από».<br />Συνέχεια με την εισαγωγή δεδομένων προς το μάθημα «στο».';
$string['importdatafinished'] = 'Η εισαγωγή ολοκληρώθηκε! Μπορείτε να μπείτε στο μάθημά σας.';
$string['importdatafrom'] = 'Εύρεση ενός μαθήματος για εισαγωγή δεδομένων:';
$string['inactive'] = 'Μη ενεργό';
$string['include'] = 'Συμπερίληψη';
$string['includeallusers'] = 'Συμπερίληψη όλων των χρηστών';
$string['includecoursefiles'] = 'Συμπερίληψη αρχείων μαθήματος';
$string['includecourseusers'] = 'Συμπερίληψη χρηστών μαθήματος';
$string['included'] = 'Συμπεριλήφθηκε';
$string['includelogentries'] = 'Συμπερίληψη εγγραφών καταγραφής';
$string['includemodules'] = 'Συμπερίληψη αρθρωμάτων';
$string['includemoduleuserdata'] = 'Συμπερίληψη των δεδομένων των αρθρωμάτων';
$string['includeneededusers'] = 'Συμπερίληψη απαραίτητων χρηστών';
$string['includenoneusers'] = 'Να μη συμπεριλαμβάνονται χρήστες';
$string['includeroleassignments'] = 'Συμπερίληψη αναθέσεων ρόλων';
$string['includesitefiles'] = 'Συμπερίληψη αρχείων ιστοτόπου που χρησιμοποιούνται σε αυτό το μάθημα';
$string['includeuserfiles'] = 'Συμπερίληψη αρχείων χρηστών';
$string['increasesections'] = 'Αύξηση του αριθμού των ενοτήτων';
$string['indicator:accessesafterend'] = 'Προσβάσεις στο μάθημα μετά την ημερομηνία λήξης';
$string['indicator:accessesafterend_help'] = 'Αυτός ο δείκτης δείχνει εάν ο μαθητής πραγματοποίησε πρόσβαση στο μάθημα μετά την ημερομηνία λήξης του.';
$string['indicator:accessesbeforestart'] = 'Προσβάσεις στο μάθημα πριν την ημερομηνία έναρξης';
$string['indicator:accessesbeforestart_help'] = 'Αυτός ο δείκτης δείχνει εάν ο μαθητής πραγματοποίησε πρόσβαση στο μάθημα πριν την ημερομηνία έναρξής του.';
$string['indicator:activitiesdue'] = 'Οφειλόμενες δραστηριότητες';
$string['indicator:activitiesdue_help'] = 'Ο χρήστης έχει δραστηριότητες που οφείλονται.';
$string['indicator:anycourseaccess'] = 'Κάθε πρόσβαση μαθήματος';
$string['indicator:anycourseaccess_help'] = 'Αυτός ο δείκτης αντανακλά πρόσβαση σε κάθε μάθημα στο οποίο είναι εγγεγραμμένος ο χρήστης.';
$string['indicator:anywrite'] = 'Οποιαδήποτε ενέργεια εγγραφής';
$string['indicator:anywrite_help'] = 'Αυτός ο δείκτης δείχνει εάν ο μαθητής πραγματοποίησε οποιαδήποτε ενέργεια εγγραφής (υποβολής).';
$string['indicator:anywriteincourse'] = 'Οποιαδήποτε ενέργεια εγγραφής μέσα στο μάθημα';
$string['indicator:anywriteincourse_help'] = 'Αυτός ο δείκτης δείχνει εάν ο μαθητής πραγματοποίησε οποιαδήποτε ενέργεια εγγραφής (υποβολής) σε οποιαδήποτε δραστηριότητα μαθήματος.';
$string['indicator:completeduserprofile'] = 'Το προφίλ χρήστη ολοκληρώθηκε';
$string['indicator:completeduserprofile_help'] = 'Αυτός ο δείκτης δείχνει εάν ο μαθητής ολοκλήρωσε το προφίλ χρήστη του.';
$string['indicator:completeduserprofiledef'] = 'Το προφίλ χρήστη ολοκληρώθηκε';
$string['indicator:completeduserprofiledef_help'] = 'Ο χρήστης συμφώνησε με τις πολιτικές ιστοτόπου και συμπλήρωσε τα ακόλουθα πεδία: Ίδρυμα, Τμήμα, Διεύθυνση, Πόλη, Χώρα, Διεύθυνση URL.';
$string['indicator:completionenabled'] = 'Παρακολούθηση ολοκλήρωσης ενεργοποιημένη';
$string['indicator:completionenabled_help'] = 'Αυτός ο δείκτης δείχνει εάν η παρακολούθηση ολοκλήρωσης έχει ενεργοποιηθεί για αυτό το μάθημα.';
$string['indicator:nostudent'] = 'Εγγραφές μαθητών';
$string['indicator:nostudent_help'] = 'Ο δείκτης αυτός δείχνει τη διαθεσιμότητα μαθητών στο μάθημα.';
$string['indicator:noteacher'] = 'Διαθεσιμότητα διδασκόντων';
$string['indicator:noteacher_help'] = 'Ο δείκτης αυτός δείχνει τη διαθεσιμότητα διδασκόντων στο μάθημα.';
$string['indicator:potentialcognitive'] = 'Μέγιστο δυνατό βάθος κατανόησης του μαθήματος';
$string['indicator:potentialcognitive_help'] = 'Αυτός ο δείκτης βασίζεται στο μέγιστο δυνατό βάθος κατανόησης που θα μπορούσε να επιτευχθεί από έναν μαθητή που συμμετέχει στις δραστηριότητες του μαθήματος.';
$string['indicator:potentialcognitivedef'] = 'Μέγιστο δυνατό βάθος κατανόησης του μαθήματος';
$string['indicator:potentialcognitivedef_help'] = 'Ο βαθμός στον οποίο το μάθημα προσφέρει «βαθιά» αφοσίωση στο βάθος κατανόησης, π.χ. υποβολή της εργασίας για ανατροφοδότηση, ευκαιρία για εξέταση της εργασίας από άλλους, και ευκαιρία αναθεωρήσεων και επανυποβολής της εργασίας.';
$string['indicator:potentialcognitivedef_link'] = 'Δείκτες_μαθησιακής_αναλυτικής#Βάθος_κατανόησης';
$string['indicator:potentialsocial'] = 'Μέγιστο κοινωνικό εύρος μαθήματος';
$string['indicator:potentialsocial_help'] = 'Αυτός ο δείκτης βασίζεται στο μέγιστο δυνατό κοινωνικό εύρος που θα μπορούσε να επιτευχθεί από έναν μαθητή που συμμετέχει στις δραστηριότητες του μαθήματος.';
$string['indicator:potentialsocialdef'] = 'Μέγιστο κοινωνικό εύρος μαθήματος';
$string['indicator:potentialsocialdef_help'] = 'Ο βαθμός στον οποίο το μάθημα προσφέρει «ευρεία» κοινωνική αφοσίωση, με αλληλεπίδραση με άλλους συμμετέχοντες και με την κοινότητα στην πρακτική εκτός της τάξης.';
$string['indicator:potentialsocialdef_link'] = 'Δείκτες_μαθησιακής_αναλυτικής#Κοινωνικό_εύρος';
$string['indicator:readactions'] = 'Ποσότητα ενεργειών ανάγνωσης';
$string['indicator:readactions_help'] = 'Αυτός ο δείκτης δείχνει τον αριθμό ενεργειών αναγνώσεων (εμφανίσεων) που πραγματοποίησε ο μαθητής.';
$string['indicator:userforumstracking'] = 'Ο χρήστης παρακολουθεί φόρουμ';
$string['indicator:userforumstracking_help'] = 'Αυτός ο δείκτης δείχνει εάν ο μαθητής έχει ή όχι ενεργοποιημένη την παρακολούθηση στα φόρουμ.';
$string['info'] = 'Πληροφορίες';
$string['inprogress'] = 'Σε εξέλιξη';
$string['institution'] = 'Ίδρυμα';
$string['instudentview'] = 'στην προβολή μαθητή';
$string['interests'] = 'Ενδιαφέροντα';
$string['interestslist'] = 'Λίστα με ενδιαφέροντα';
$string['interestslist_help'] = 'Εισάγετε τα ενδιαφέροντά σας, ένα προς ένα, τα οποία θα εμφανίζονται στη σελίδα του προφίλ σας ως ετικέτες.';
$string['invalidemail'] = 'Εσφαλμένη διεύθυνση ηλε.ταχυδρομείου';
$string['invalidlogin'] = 'Αποτυχημένη προσπάθεια σύνδεσης. Παρακαλούμε δοκιμάστε ξανά.';
$string['invalidusername'] = 'Το όνομα χρήστη μπορεί να περιέχει μόνο αλφαριθμητικούς πεζούς χαρακτήρες (γράμματα και αριθμούς), κάτω παύλα (_), παύλα (-), τελεία (.) ή παπάκι (@).';
$string['invalidusernameupload'] = 'Μη έγκυρο όνομα χρήστη';
$string['ip_address'] = 'Διεύθυνση IP';
$string['jump'] = 'Μεταπήδηση';
$string['jumpto'] = 'Μεταπήδηση σε...';
$string['keep'] = 'Συνέχιση';
$string['labelvalue'] = '{$a->label}: {$a->value}';
$string['langltr'] = 'Το κείμενο γράφεται από αριστερά προς τα δεξιά';
$string['langrtl'] = 'Το κείμενο γράφεται από δεξιά προς τα αριστερά';
$string['language'] = 'Γλώσσα';
$string['languagegood'] = 'Αυτό το γλωσσικό πακέτο είναι ενημερωμένο! :-)';
$string['languageselector'] = 'Επιλογέας γλώσσας';
$string['last'] = 'Τελευταίο';
$string['lastaccess'] = 'Τελευταία πρόσβαση';
$string['lastcourseaccess'] = 'Τελευταία πρόσβαση στο μάθημα';
$string['lastedited'] = 'Τελευταία επεξεργασία';
$string['lastip'] = 'Τελευταία IP διεύθυνση';
$string['lastlogin'] = 'Τελευταία σύνδεση';
$string['lastmodified'] = 'Τελευταία τροποποίηση';
$string['lastname'] = 'Επίθετο';
$string['lastnamephonetic'] = 'Επίθετο (φωνητικό)';
$string['lastpage'] = 'Τελευταία σελίδα';
$string['lastsiteaccess'] = 'Τελευταία πρόσβαση στον ιστότοπο';
$string['lastyear'] = 'Προηγούμενο έτος';
$string['latestlanguagepack'] = 'Έλεγχος για το τελευταίο πακέτο γλώσσας στο moodle.org';
$string['layouttable'] = 'Πίνακας διάταξης';
$string['leavetokeep'] = 'Αφήστε κενό για να διατηρήσετε τον υπάρχοντα κωδικό πρόσβασης';
$string['legacylogginginuse'] = 'Αυτός ο ιστότοπος έχει αυτή τη στιγμή ενεργοποιημένη την εγγραφή σε αποθήκη καταγραφών παλαιού τύπου. Η εγγραφή σε αυτή την αποθήκη είναι απαρχαιωμένη. Σας παρακαλούμε να γράφετε σε μια υποστηριζόμενη αποθήκη καταγραφών, όπως «τυπική» ή «εξωτερική».';
$string['legacythemeinuse'] = 'Ο ιστότοπος αυτός εμφανίζεται σε λειτουργία συμβατότητας διότι ο περιηγητής σας είναι παλαιότερος (του υποστηριζόμενου).';
$string['license'] = 'Άδεια χρήσης';
$string['licenses'] = 'Άδειες χρήσης';
$string['liketologin'] = 'Θέλετε να συνδεθείτε τώρα με έναν πλήρη λογαριασμό χρήστη;';
$string['list'] = 'Λίστα';
$string['listfiles'] = 'Λίστα αρχείων στο {$a}';
$string['listofallpeople'] = 'Λίστα όλων των ατόμων';
$string['listofcourses'] = 'Λίστα των μαθημάτων';
$string['loading'] = 'Φόρτωση';
$string['loadinghelp'] = 'Φόρτωση...';
$string['local'] = 'Τοπικό';
$string['localplugins'] = 'Τοπικά πρόσθετα';
$string['localpluginsmanage'] = 'Διαχείριση τοπικών πρόσθετων';
$string['location'] = 'Τόπος';
$string['locktimeout'] = 'Ο διαθέσιμος χρόνος για τη λειτουργία έληξε, σε αναμονή ενός κλειδώματος.';
$string['log_excel_date_format'] = 'yyyy mmmm d h:mm';
$string['loggedinas'] = 'Έχετε συνδεθεί ως {$a}';
$string['loggedinasguest'] = 'Αυτή τη στιγμή χρησιμοποιείτε πρόσβαση επισκέπτη';
$string['loggedinnot'] = 'Δεν έχετε συνδεθεί.';
$string['login'] = 'Σύνδεση';
$string['login_failure_logs'] = 'Καταγραφές αποτυχημένων προσπαθειών σύνδεσης';
$string['loginactivity'] = 'Συνδέσεις';
$string['loginagain'] = 'Συνδεθείτε ξανά';
$string['loginalready'] = 'Έχετε ήδη συνδεθεί';
$string['loginas'] = 'Σύνδεση ως';
$string['loginaspasswordexplain'] = '<p>Πρέπει να εισαγάγετε τον ειδικό «loginas κωδικό πρόσβασης» για να χρησιμοποιήσετε αυτή τη λειτουργία.<br />Αν δεν τον γνωρίζετε, επικοινωνήστε με το διαχειριστή του εξυπηρετητή σας.</p>';
$string['loginguest'] = 'Πρόσβαση ως επισκέπτης';
$string['loginsite'] = 'Σύνδεση στον ιστότοπο';
$string['loginsteps'] = 'Για πλήρη πρόσβαση σε αυτόν τον ιστότοπο, πρέπει πρώτα να δημιουργήσετε έναν λογαριασμό.';
$string['loginstepsnone'] = '<p>Γεια σας,</p>
<p>για να έχετε πλήρη πρόσβαση στα μαθήματα θα πρέπει να δημιουργήσετε έναν λογαριασμό.</p>
<p>Το μόνο που χρειάζεται να κάνετε είναι να δημιουργήσετε ένα όνομα χρήστη και έναν κωδικό πρόσβασης και να τα χρησιμοποιήσετε στη φόρμα αυτής της σελίδας! </p>
<p>Εάν κάποιος άλλος έχει ήδη επιλέξει το όνομα χρήστη σας, θα πρέπει να δοκιμάσετε ξανά χρησιμοποιώντας διαφορετικό όνομα χρήστη.</p>';
$string['loginto'] = 'Σύνδεση στο {$a}';
$string['logoof'] = 'Λογότυπο του {$a}';
$string['logout'] = 'Αποσύνδεση';
$string['logoutconfirm'] = 'Θέλετε σίγουρα να αποσυνδεθείτε;';
$string['logs'] = 'Καταγραφές';
$string['logtoomanycourses'] = '[ <a href="{$a->url}">περισσότερα</a> ]';
$string['logtoomanyusers'] = '[ <a href="{$a->url}">περισσότερα</a> ]';
$string['lookback'] = 'Προηγούμενες ημέρες';
$string['mailadmins'] = 'Ενημέρωση των διαχειριστών';
$string['mailstudents'] = 'Πληροφόρηση μαθητών';
$string['mailteachers'] = 'Ενημέρωση των διδασκόντων';
$string['maincoursepage'] = 'Κύρια σελίδα του μαθήματος';
$string['makeafolder'] = 'Δημιουργία φακέλου';
$string['makeavailable'] = 'Να είναι διαθέσιμο';
$string['makeeditable'] = 'Αν κάνετε το «{$a}» τροποποιήσιμο από την διεργασία εξυπηρετητή ιστού (π.χ. apache) τότε θα μπορείτε να επεξεργαστείτε αυτό το αρχείο απευθείας από αυτή τη σελίδα.';
$string['makethismyhome'] = 'Να γίνει αυτή η αρχική σελίδα σας';
$string['makeunavailable'] = 'Να είναι διαθέσιμο';
$string['manageblocks'] = 'Μπλοκ';
$string['managecategories'] = 'Διαχείριση κατηγοριών μαθημάτων';
$string['managecategorythis'] = 'Διαχειριστείτε την κατηγορία αυτή';
$string['managecombined'] = 'Διαχείριση κατηγοριών μαθημάτων και μαθημάτων';
$string['managecontentbanktypes'] = 'Διαχείριση τύπων περιεχομένου';
$string['managecourses'] = 'Διαχείριση μαθημάτων';
$string['managedatabase'] = 'Βάση δεδομένων';
$string['managedataformats'] = 'Διαχείριση μορφών δεδομένων';
$string['manageeditorfiles'] = 'Διαχείριση αρχείων που χρησιμοποιούνται από τον επεξεργαστή κειμένου';
$string['managefilters'] = 'Φίλτρα';
$string['managemodules'] = 'Αρθρώματα';
$string['manageroles'] = 'Ρόλοι και δικαιώματα';
$string['markallread'] = 'Σημείωση όλων ως αναγνωσμένων';
$string['markedthistopic'] = 'Αυτό το θέμα φωτο-επισημαίνεται ως το τρέχον θέμα';
$string['markthistopic'] = 'Φωτο-επισήμανση αυτού του θέματος ως το τρέχον θέμα';
$string['match'] = 'Αντιστοίχηση';
$string['matchingsearchandrole'] = 'Αντιστοίχιση «{$a->search}» και {$a->role}';
$string['matchofthefollowing'] = 'των ακόλουθων:';
$string['maxareabytesreached'] = 'Το αρχείο (ή το συνολικό μέγεθος πολλών αρχείων) είναι μεγαλύτερο από τον διαθέσιμο χώρο σε αυτή την περιοχή.';
$string['maxfilesize'] = 'Μέγιστο μέγεθος για νέα αρχεία: {$a}';
$string['maxfilesreached'] = 'Επιτρέπεται να επισυνάψετε το πολύ {$a} αρχεία/ο σε αυτό το στοιχείο';
$string['maximumchars'] = 'Το πολύ {$a} χαρακτήρες';
$string['maximumgrade'] = 'Μέγιστος βαθμός';
$string['maximumgradex'] = 'Μέγιστος βαθμός: {$a}';
$string['maximumshort'] = 'Μέγιστο';
$string['maximumupload'] = 'Μέγιστο μέγεθος ανεβασμένου αρχείου';
$string['maximumupload_help'] = 'Το μέγιστο μέγεθος αρχείου που επιτρέπεται για τις μεταφορτώσεις μαθητών στο μάθημα. Επιπλέον, μπορείτε να περιορίσετε περαιτέρω το μέγιστο μέγεθος μεταφόρτωσης για κάθε δραστηριότητα.';
$string['maxnumberweeks'] = 'Μέγιστος αριθμός ενοτήτων';
$string['maxnumberweeks_desc'] = 'Η μέγιστη τιμή στον αριθμό ενοτήτων στο πτυσσόμενο μενού (ισχύει για συγκεκριμένους μορφότυπους μαθημάτων μόνο).';
$string['maxnumcoursesincombo'] = 'Περιηγηθείτε στα <a href="{$a->link}">{$a->numberofcourses} μαθήματα </a>.';
$string['maxsectionslimit'] = 'Δεν είναι δυνατή η δημιουργία νέας ενότητας, καθώς θα υπερέβαινε τον μέγιστο αριθμό ενοτήτων που επιτρέπονται για αυτό το μάθημα ({$a}).';
$string['maxsize'] = 'Μέγιστο μέγεθος: {$a}';
$string['maxsizeandareasize'] = 'Μέγιστο μέγεθος για νέα αρχεία: {$a->size}. Συνολικό όριο: {$a->areasize}.';
$string['maxsizeandattachments'] = 'Μέγιστο μέγεθος αρχείου: {$a->size}. Μέγιστος αριθμός συνημμένων: {$a->attachments}.';
$string['maxsizeandattachmentsandareasize'] = 'Μέγιστο μέγεθος αρχείου: {$a->size}. Μέγιστος αριθμός συνημμένων: {$a->attachments}. Συνολικό όριο: {$a->areasize}.';
$string['memberincourse'] = 'Μέλη του μαθήματος';
$string['menu'] = 'Μενού';
$string['message'] = 'Μήνυμα';
$string['messagebody'] = 'Σώμα μηνύματος';
$string['messagedselectedusers'] = 'Έχει σταλεί μήνυμα στους επιλεγμένους χρήστες και επαναφορτώθηκε η λίστα των παραληπτών.';
$string['messagedselectedusersfailed'] = 'Παρουσιάστηκε ένα σφάλμα κατά την αποστολή μηνύματος στους επιλεγμένους χρήστες. Ορισμένοι μπορεί να έχουν λάβει το μήνυμα ηλε.ταχυδρομείου.';
$string['messageprovider:asyncbackupnotification'] = 'Ειδοποιήσεις ασύγχρονης δημιουργίας/επαναφοράς αντιγράφων ασφαλείας';
$string['messageprovider:availableupdate'] = 'Διαθέσιμες ειδοποιήσεις ενημέρωσης';
$string['messageprovider:backup'] = 'Ειδοποιήσεις αντιγράφων ασφαλείας';
$string['messageprovider:badgecreatornotice'] = 'Ειδοποιήσεις δημιουργού διακριτικού';
$string['messageprovider:badgerecipientnotice'] = 'Ειδοποιήσεις αποδέκτη διακριτικού';
$string['messageprovider:competencyplancomment'] = 'Σχόλιο αναρτημένο σε ένα σχέδιο μάθησης';
$string['messageprovider:competencyusercompcomment'] = 'Σχόλιο που αναρτήθηκε για ένα προσόν';
$string['messageprovider:coursecompleted'] = 'Το μάθημα ολοκληρώθηκε';
$string['messageprovider:coursecontentupdated'] = 'Αλλαγές στο περιεχόμενο του μαθήματος';
$string['messageprovider:courserequestapproved'] = 'Ειδοποίηση έγκρισης αιτήματος δημιουργίας μαθήματος';
$string['messageprovider:courserequested'] = 'Ειδοποίηση αιτήματος δημιουργίας μαθήματος';
$string['messageprovider:courserequestrejected'] = 'Ειδοποίηση απόρριψης αιτήματος δημιουργίας μαθήματος';
$string['messageprovider:errors'] = 'Σημαντικά σφάλματα με τον ιστότοπο';
$string['messageprovider:errors_help'] = 'Αυτά είναι σημαντικά λάθη που πρέπει να τα μάθει κάποιος διαχειριστής.';
$string['messageprovider:gradenotifications'] = 'Ειδοποιήσεις βαθμού';
$string['messageprovider:infected'] = 'Ειδοποιήσεις αποτυχίας αντιιικού λογισμικού.';
$string['messageprovider:insights'] = 'Στοιχεία που προκύπτουν από μοντέλα πρόβλεψης';
$string['messageprovider:instantmessage'] = 'Προσωπικά μηνύματα μεταξύ χρηστών';
$string['messageprovider:instantmessage_help'] = 'Αυτή η ενότητα ρυθμίζει τι θα συμβαίνει με τα μηνύματα που σας αποστέλλονται απευθείας από άλλους χρήστες αυτού του ιστοτόπου.';
$string['messageprovider:messagecontactrequests'] = 'Μήνυμα ειδοποίησης για αίτημα επικοινωνίας';
$string['messageprovider:newlogin'] = 'Eιδοποιήσεις νέας σύνδεσης';
$string['messageprovider:notices'] = 'Ειδοποιήσεις σχετικά με δευτερεύοντα προβλήματα';
$string['messageprovider:notices_help'] = 'Αυτές είναι ειδοποιήσεις που ίσως ένας διαχειριστής ενδιαφέρεται να δει.';
$string['messageselect'] = 'Επιλέξτε αυτό το χρήστη ως παραλήπτη μηνύματος';
$string['messageselectadd'] = 'Αποστολή μηνύματος';
$string['middlename'] = 'Μεσαίο όνομα';
$string['migratinggrades'] = 'Μετεγκατάσταση (μεταφορά/μετατροπή) βαθμών';
$string['min'] = 'λεπτό';
$string['mins'] = 'λεπτά';
$string['minute'] = 'λεπτό';
$string['minutes'] = 'λεπτά';
$string['miscellaneous'] = 'Διάφορα';
$string['missingcategory'] = 'Πρέπει να επιλέξετε μια κατηγορία';
$string['missingdescription'] = 'Λείπει η περιγραφή';
$string['missingemail'] = 'Λείπει η διεύθυνση ηλε.ταχυδρομείου';
$string['missingfirstname'] = 'Λείπει το όνομα';
$string['missingfromdisk'] = 'Λείπει από το δίσκο';
$string['missingfullname'] = 'Λείπει το πλήρες όνομα';
$string['missinglastname'] = 'Λείπει το επίθετο';
$string['missingname'] = 'Λείπει το όνομα';
$string['missingnewpassword'] = 'Λείπει ο νέος κωδικός πρόσβασης';
$string['missingpassword'] = 'Λείπει ο κωδικός πρόσβασης';
$string['missingrecaptchachallengefield'] = 'Αποτυχία στο πεδίο πρόκλησης reCAPTCHA. Προσπαθήστε ξανά.';
$string['missingreqreason'] = 'Λείπει η δικαιολογία';
$string['missingshortname'] = 'Λείπει το σύντομο όνομα';
$string['missingshortsitename'] = 'Λείπει το σύντομο όνομα του δικτυακού τόπου';
$string['missingsitedescription'] = 'Λείπει η περιγραφή του δικτυακού τόπου';
$string['missingsitename'] = 'Λείπει το όνομα του δικτυακού τόπου';
$string['missingstrings'] = 'Έλεγχος για μη μεταφρασμένες λέξεις ή φράσεις';
$string['missingstudent'] = 'Πρέπει να επιλέξετε κάτι';
$string['missingsummary'] = 'Λείπει η περίληψη';
$string['missingteacher'] = 'Πρέπει να επιλέξετε κάτι';
$string['missingurl'] = 'Λείπει το URL';
$string['missingusername'] = 'Λείπει το όνομα χρήστη';
$string['moddoesnotsupporttype'] = 'Το άρθρωμα {$a->modname} δεν υποστηρίζει ανέβασμα αρχείου του τύπου {$a->type}';
$string['modhide'] = 'Απόκρυψη';
$string['modified'] = 'Τροποποιημένο';
$string['modshow'] = 'Προβολή';
$string['moduleintro'] = 'Περιγραφή';
$string['modulesetup'] = 'Ρύθμιση των πινάκων του αρθρώματος';
$string['modulesuccess'] = '{$a} έχουν ρυθμιστεί σωστά';
$string['modulesused'] = 'Αρθρώματα που χρησιμοποιήθηκαν';
$string['modvisible'] = 'Διαθεσιμότητα';
$string['modvisible_help'] = '* Εμφάνιση στη σελίδα του μαθήματος: Διατίθεται στους μαθητές (με την επιφύλαξη τυχόν περιορισμών πρόσβασης που ενδέχεται να τεθούν).
* Απόκρυψη στη σελίδα του μαθήματος: Δεν διατίθεται στους μαθητές.';
$string['modvisiblehiddensection'] = 'Διαθεσιμότητα';
$string['modvisiblehiddensection_help'] = '* Απόκρυψη στη σελίδα του μαθήματος: Δεν διατίθεται στους μαθητές.
* Διαθέσιμο αλλά δεν εμφανίζεται στη σελίδα του μαθήματος: Διατίθεται στους φοιτητές εάν παρέχετε έναν σύνδεσμο. Οι δραστηριότητες θα εξακολουθούν να εμφανίζονται στο βιβλίο βαθμών και σε άλλες αναφορές.';
$string['modvisiblewithstealth'] = 'Διαθεσιμότητα';
$string['modvisiblewithstealth_help'] = '* Εμφάνιση στη σελίδα του μαθήματος: Διατίθεται στους μαθητές (με την επιφύλαξη τυχόν περιορισμών πρόσβασης που ενδέχεται να τεθούν).
* Απόκρυψη στη σελίδα του μαθήματος: Δεν διατίθεται στους μαθητές.
* Διαθέσιμο αλλά δεν εμφανίζεται στη σελίδα του μαθήματος: Διατίθεται στους μαθητές εάν παρέχετε σύνδεσμο. Οι δραστηριότητες θα εξακολουθούν να εμφανίζονται στο βιβλίο βαθμών και σε άλλες αναφορές.';
$string['month'] = 'Μήνας';
$string['months'] = 'Μήνες';
$string['moodledocs'] = 'Τεκμηρίωση του Moodle';
$string['moodledocslink'] = 'Τεκμηρίωση του Moodle για αυτή τη σελίδα';
$string['moodlelogo'] = 'Λογότυπο Moodle';
$string['moodlerelease'] = 'Διανομή Moodle';
$string['moodleservicesandsupport'] = 'Υπηρεσίες και υποστήριξη';
$string['moodleversion'] = 'Έκδοση του Moodle';
$string['more'] = 'περισσότερα';
$string['moreactions'] = 'Περισσότερες ενέργειες';
$string['morehelp'] = 'Περισσότερη βοήθεια';
$string['morehelpaboutmodule'] = 'Περισσότερη βοήθεια σχετικά με την δραστηριότητα {$a}';
$string['moreinfo'] = 'Περισσότερες πληροφορίες';
$string['moreinformation'] = 'Περισσότερες πληροφορίες για αυτό το λάθος';
$string['moremenu'] = 'Περισσότερα';
$string['morenavigationlinks'] = 'Περισσότερα...';
$string['moreprofileinfoneeded'] = 'Παρακαλούμε, γράψτε κάτι για τον εαυτό σας';
$string['mostrecently'] = 'πιο πρόσφατα';
$string['move'] = 'Μετακίνηση';
$string['movecategoriessuccess'] = 'Μεταφέρθηκαν με επιτυχία {$a->count} κατηγορίες στην κατηγορία «{$a->to}»';
$string['movecategoriestotopsuccess'] = 'Μεταφέρθηκαν με επιτυχία {$a->count} κατηγορίες στο ανώτατο επίπεδο';
$string['movecategorycontentto'] = 'Μετακίνηση σε';
$string['movecategorysuccess'] = 'Μεταφέρθηκε με επιτυχία η κατηγορία «{$a->moved}» στην κατηγορία «{$a->to}»';
$string['movecategoryto'] = 'Μετακίνηση κατηγορίας στο:';
$string['movecategorytotopsuccess'] = 'Μεταφέρθηκε με επιτυχία η κατηγορία «{$a->moved}» στο ανώτατο επίπεδο';
$string['movecontent'] = 'Μετακίνηση {$a}';
$string['movecontentafter'] = 'Μετά το «{$a}»';
$string['movecontentstoanothercategory'] = 'Μετακίνηση περιεχομένων σε άλλη κατηγορία';
$string['movecontenttothetop'] = 'Προς την αρχή της λίστας';
$string['movecoursemodule'] = 'Μετακίνηση δραστηριότητας';
$string['movecoursesection'] = 'Μετακίνηση ενότητας';
$string['movecourseto'] = 'Μετακίνηση μαθήματος σε:';
$string['movedown'] = 'Μετακίνηση κάτω';
$string['movefilestohere'] = 'Μετακίνηση των αρχείων εδώ';
$string['movefull'] = 'Μετακίνηση {$a} σε αυτή την τοποθεσία';
$string['movehere'] = 'Μετακίνηση εδώ';
$string['moveleft'] = 'Μετακίνηση αριστερά';
$string['moveright'] = 'Μετακίνηση δεξιά';
$string['movesection'] = 'Μετακίνηση ενότητας {$a}';
$string['moveselectedcategoriesto'] = 'Μετακίνηση επιλεγμένων κατηγοριών στο';
$string['moveselectedcoursesto'] = 'Μετακίνηση επιλεγμένων μαθημάτων σε...';
$string['movetoanotherfolder'] = 'Μετακίνηση σε άλλο φάκελο';
$string['moveup'] = 'Μετακίνηση πάνω';
$string['msnid'] = 'Αναγνωριστικό  MSN';
$string['mustchangepassword'] = 'Ο καινούριος κωδικός πρόσβασης πρέπει να είναι διαφορετικός από τον τρέχοντα';
$string['mustconfirm'] = 'Πρέπει να επιβεβαιώσετε τον λογαριασμό σας';
$string['mycourses'] = 'Τα μαθήματά μου';
$string['myfiles'] = 'Προσωπικά αρχεία';
$string['myfilesmanage'] = 'Διαχείριση αρχείων';
$string['myhome'] = 'Ταμπλό';
$string['mymoodledashboard'] = 'Ταμπλό «Το Moodle μου»';
$string['myprofile'] = 'Το προφίλ μου';
$string['name'] = 'Όνομα';
$string['namedfiletoolarge'] = 'Το αρχείο «{$a->filename}» είναι πολύ μεγάλο και δεν μπορεί να ανεβεί';
$string['nameforlink'] = 'Πώς θέλετε να ονομάσετε αυτόν τον σύνδεσμο;';
$string['nameforpage'] = 'Όνομα';
$string['navigation'] = 'Πλοήγηση';
$string['needed'] = 'Απαραίτητο';
$string['networkdropped'] = 'Διαπιστώσαμε ότι η σύνδεσή σας στο Διαδίκτυο είναι αναξιόπιστη ή έχει διακοπεί.<br /> Έχετε υπόψη ότι οι αλλαγές ενδέχεται να μην αποθηκευτούν σωστά μέχρι να βελτιωθεί η σύνδεσή σας.';
$string['never'] = 'Ποτέ';
$string['neverdeletelogs'] = 'Ποτέ να μη διαγράφονται καταγραφές';
$string['new'] = 'Νέο';
$string['newaccount'] = 'Νέος λογαριασμός';
$string['newactivityname'] = 'Νέο όνομα για την δραστηριότητα {$a}';
$string['newcourse'] = 'Νέο μάθημα';
$string['newloginnotificationbodyfull'] = '<p>Γεια σας {$a->userfullname},</p>
<p>Μόλις έγινε σύνδεση από μία νέα συσκευή στον λογαριασμό σας στο {$a->sitename}.</p>
<ul>
<li>Ο λογαριασμός σας: {$a->username} {$a->useremail}</li>
<li>{$a->logintime}</li>
<li>Συσκευή: {$a->logindevice}</li>
<li>IP: {$a->loginip}</li>
</ul>
<p>Αν ήσασταν εσείς, τότε δεν χρειάζεται να κάνετε τίποτα.</p>
<p>Εάν δεν αναγνωρίζετε αυτήν τη δραστηριότητα, <a href="{$a->changepasswordlink}">αλλάξτε τον κωδικό πρόσβασής σας</a>.</p>';
$string['newloginnotificationbodysmall'] = 'Μόλις έγινε σύνδεση από μία νέα συσκευή στον λογαριασμό σας {$a}';
$string['newloginnotificationtitle'] = 'Νέα είσοδος με τον λογαριασμό σας {$a}';
$string['newpassword'] = 'Νέος κωδικός πρόσβασης';
$string['newpassword_help'] = 'Αφήστε κενό για να κρατήσετε τον τρέχοντα κωδικό πρόσβασης';
$string['newpasswordfromlost'] = '<strong>ΕΙΔΟΠΟΙΗΣΗ:</strong> Ο <strong> τρέχων κωδικός πρόσβασης</strong> θα σας έχει σταλεί στο <strong> δεύτερο</strong> εκ των δύο μηνυμάτων ηλε.ταχυδρομείου που θα αποσταλούν στο πλαίσιο της διαδικασίας ανάκτησης κωδικού πρόσβασης. Επιβεβαιώστε ότι έχετε λάβει τον κωδικό πρόσβασης αντικατάστασης πριν συνεχίσετε με αυτή την οθόνη.';
$string['newpasswordtext'] = 'Γεια σας, {$a->firstname}, Ο κωδικός πρόσβασης του λογαριασμού σας στο «{$a->sitename}» έχει αλλάξει. Αυτή τη στιγμή οι πληροφορίες σύνδεσής σας είναι: Όνομα χρήστη: {$a->username} Κωδικός πρόσβασης: {$a->newpassword} Παρακαλούμε επισκεφθείτε αυτή τη σελίδα για να αλλάξτε τον κωδικό πρόσβασής σας: {$a->link}. Στα περισσότερα προγράμματα ηλε.ταχυδρομείου, αυτό θα εμφανιστεί μάλλον ως ένας μπλε σύνδεσμος, στον οποίο μπορείτε να κάνετε κλικ. Αν αυτό δεν λειτουργήσει, τότε κάντε αποκοπή της διεύθυνσης και επικόλληση στην πάνω-πάνω γραμμή (διευθύνσεων) του περιηγητή σας. Ευχαριστίες από τον διαχειριστή «{$a->sitename}» administrator, {$a->signoff}';
$string['newpicture'] = 'Νέα εικόνα';
$string['newpicture_help'] = 'Για να προσθέσετε μια νέα εικόνα, περιηγηθείτε και επιλέξτε μια εικόνα (σε μορφότυπο JPG ή PNG) και κάντε κλικ στο «Ενημέρωση προφίλ». Η εικόνα θα περικοπεί σε ένα τετράγωνο και θα αλλάξει σε 100x100 εικονοστοιχεία.';
$string['newpictureusernotsetup'] = 'Μια εικόνα προφίλ μπορεί να προστεθεί μόνο αφού έχουν αποθηκευτεί όλες οι απαιτούμενες πληροφορίες στο προφίλ.';
$string['newsectionname'] = 'Νέο όνομα για την ενότητα {$a}';
$string['newsitem'] = 'αντικείμενο νέων';
$string['newsitems'] = 'ανακοινώσεις';
$string['newsitemsnumber'] = 'Αριθμός ανακοινώσεων';
$string['newsitemsnumber_help'] = 'Το φόρουμ ανακοινώσεων έχει υποχρεωτική εγγραφή σε αυτό από προεπιλογή. Μόνο εκπαιδευτές και άλλοι χρήστες με την κατάλληλη άδεια μπορούν να δημοσιεύουν σε αυτό.

Εάν δεν χρειάζεστε ένα φόρουμ ανακοινώσεων, ορίστε το στο μηδέν.

Αυτή η ρύθμιση καθορίζει επίσης πόσες πρόσφατες ανακοινώσεις εμφανίζονται στο μπλοκ πιο πρόσφατων ανακοινώσεων.';
$string['newuser'] = 'Νέος χρήστης';
$string['newusernewpasswordsubj'] = 'Νέος λογαριασμός χρήστη';
$string['newusernewpasswordtext'] = 'Γεια σας {$a->firstname}, Έχει δημιουργηθεί ένας καινούριος λογαριασμός χρήστη στο «{$a->sitename}» με έναν προσωρινό κωδικό πρόσβασης. Για να συνδεθείτε θα πρέπει να χρησιμοποιήσετε τα παρακάτω στοιχεία: όνομα χρήστη: {$a->username} κωδικός πρόσβασης: {$a->newpassword} (θα πρέπει να αλλάξετε τον κωδικό πρόσβασης την πρώτη φορά που θα συνδεθείτε) Για να συνδεθείτε, πατήστε τον επόμενο σύνδεσμο {$a->link}';
$string['newusers'] = 'Νέοι χρήστες';
$string['newwindow'] = 'Νέο παράθυρο';
$string['next'] = 'Επόμενο';
$string['nextpage'] = 'Επόμενη σελίδα';
$string['nextsection'] = 'Επόμενη ενότητα';
$string['no'] = 'Όχι';
$string['noblockstoaddhere'] = 'Δεν υπάρχουν μπλοκ που μπορείτε να προσθέσετε σε αυτή τη σελίδα.';
$string['nobody'] = 'Κανένας';
$string['nochange'] = 'Καμία αλλαγή';
$string['nocomments'] = 'Χωρίς σχόλια';
$string['nocourses'] = 'Κανένα μάθημα';
$string['nocoursesfound'] = 'Δε βρέθηκαν μαθήματα με τις λέξεις «{$a}»';
$string['nocoursestarttime'] = 'Το μάθημα δεν έχει ώρα έναρξης.';
$string['nocoursesyet'] = 'Δεν υπάρχουν μαθήματα σε αυτή την κατηγορία';
$string['nodstpresets'] = 'Ο διαχειριστής δεν έχει ενεργοποιήσει την Αυτόματη Αλλαγή Ώρας.';
$string['nofilesselected'] = 'Δεν έχουν επιλεγεί αρχεία για επαναφορά';
$string['nofilesyet'] = 'Δεν έχουν ανεβεί αρχεία στο μάθημά σας ακόμα';
$string['nofiltersapplied'] = 'Δεν εφαρμόστηκαν καθόλου φίλτρα';
$string['nograde'] = 'Κανένας βαθμός';
$string['nohelpforactivityorresource'] = 'Δεν υπάρχει προς το παρόν βοήθεια σχετική με αυτό τον πόρο ή αυτή την δραστηριότητα';
$string['noimagesyet'] = 'Δεν έχουν ανεβεί εικόνες στο μάθημά σας ακόμα';
$string['nologsfound'] = 'Δεν έχουν βρεθεί καταγραφές';
$string['nomatchingusers'] = 'Δεν ταιριάζει κανένας χρήστης με «{$a}»';
$string['nomorecourses'] = 'Δεν βρέθηκαν μαθήματα που να ταιριάζουν με τα κριτήριά σας';
$string['nomoreidnumber'] = 'Δεν χρησιμοποιείται αναγνωριστικός αριθμός για την αποφυγή συγκρούσεων';
$string['none'] = 'Καμία';
$string['noneditingteacher'] = 'Περιορισμένος διδάσκων';
$string['noneditingteacherdescription'] = 'Ο περιορισμένος διδάσκων μπορεί να διδάξει μαθήματα και να βαθμολογήσει τους μαθητές αλλά δεν μπορεί να τροποποιήσει δραστηριότητες.';
$string['nonstandard'] = 'Μη-τυπική';
$string['nopendingcourses'] = 'Δεν υπάρχουν μαθήματα που αναμένουν έγκριση';
$string['nopotentialadmins'] = 'Δεν υπάρχει κανένας πιθανός διαχειριστής';
$string['nopotentialcreators'] = 'Δεν υπάρχει κανένας πιθανός δημιουργός';
$string['nopotentialstudents'] = 'Δεν υπάρχει κανένας πιθανός μαθητής';
$string['nopotentialteachers'] = 'Δεν υπάρχει κανένας πιθανός διδάσκων';
$string['norecentactivity'] = 'Δεν υπάρχει πρόσφατη δραστηριότητα';
$string['noreplybouncemessage'] = 'Έχετε απαντήσει σε μία διεύθυνση ηλε.ταχυδρομείου που δεν δέχεται απαντήσεις (no-reply: μη-απάντηση). Αν προσπαθούσατε να απαντήσετε σε μια ανακοίνωση φόρουμ, παρακαλούμε απαντήστε χρησιμοποιώντας τα {$a} φόρουμ. Ακολουθεί το περιεχόμενο του μηνύματός σας:';
$string['noreplybouncesubject'] = '{$a} - το μήνυμα ηλε.ταχυδρομείου αποκρούστηκε.';
$string['noreplyname'] = 'Μην απαντήσετε σε αυτή τη διεύθυνση ηλε.ταχυδρομείου';
$string['noresetrecord'] = 'Δεν υπάρχει ιστορικό αυτού του αιτήματος επαναφοράς. Παρακαλούμε, ξεκινήστε μια νέα αίτηση επαναφοράς κωδικού πρόσβασης.';
$string['noresults'] = 'Κανένα αποτέλεσμα';
$string['normal'] = 'Κανονικά';
$string['normalfilter'] = 'Κανονική αναζήτηση';
$string['nosite'] = 'Αδυναμία εύρεσης μαθήματος σε επίπεδο ιστοτόπου';
$string['nostudentsfound'] = 'Δεν βρέθηκαν {$a}';
$string['nostudentsingroup'] = 'Δεν υπάρχουν μαθητές σε αυτή την ομάδα ακόμα';
$string['nostudentsyet'] = 'Δεν υπάρχουν εγγεγραμμένοι μαθητές σε αυτό το μάθημα.';
$string['nosuchemail'] = 'Δεν υπάρχει τέτοια διεύθυνση ηλε.ταχυδρομείου';
$string['notavailable'] = 'Δεν είναι διαθέσιμο';
$string['notavailablecourse'] = '{$a} δεν είναι διαθέσιμο';
$string['noteachersyet'] = 'Δεν υπάρχουν ακόμη διδάσκοντες σε αυτό το μάθημα';
$string['noteachingupcomingcourses'] = 'Επερχόμενα μαθήματα δεν έχουν εκπαιδευτικούς ή μαθητές';
$string['notenrolled'] = '{$a} - δεν είναι εγγεγραμμένος σε αυτό το μάθημα.';
$string['notenrolledprofile'] = 'Αυτό το προφίλ δεν είναι διαθέσιμο γιατί ο χρήστης δεν έχει γραφτεί σε αυτό το μάθημα.';
$string['noteusercannotrolldatesoncontext'] = '<strong>Σημείωση:</strong> Η δυνατότητα αλλαγής ημερομηνιών κατά την επαναφορά αυτού του αντιγράφου ασφαλείας έχει απενεργοποιηθεί επειδή δεν έχετε τα απαιτούμενα δικαιώματα.';
$string['noteuserschangednonetocourse'] = '<strong>Σημείωση:</strong> Κατά την επαναφορά δεδομένων χρήστη (σε δραστηριότητες, αρχεία ή μηνύματα), πρέπει να γίνει επαναφορά των χρηστών μαθήματος. Αυτή η ρύθμιση έχει αλλάξει για εσάς.';
$string['nothingnew'] = 'Δεν υπάρχει πρόσφατη δραστηριότητα';
$string['nothingtodisplay'] = 'Δεν υπάρχει τίποτα προς προβολή';
$string['notice'] = 'Ειδοποίηση';
$string['noticenewerbackup'] = 'Αυτό το αντίγραφο ασφαλείας έχει δημιουργηθεί με το Moodle {$a->backuprelease} ({$a->backupversion}) (διανομή/έκδοση) και είναι νεότερο από το Moodle {$a->serverrelease} ({$a->serverversion}) που έχετε εγκατεστημένο. Αυτό μπορεί να προκαλέσει ασυνέπειες, καθώς δεν θα είναι εγγυημένη η συμβατότητα προς τα πίσω των αντιγράφων ασφαλείας.';
$string['notifications'] = 'Ειδοποιήσεις';
$string['notifyloginfailuresmessage'] = '{$a->time}, IP: {$a->ip}, Χρήστης: {$a->info}, Πλήρες όνομα χρήστη: {$a->name}';
$string['notifyloginfailuresmessageend'] = 'Μπορείτε να δείτε αυτές τις καταγραφές στο {$a}/course/log.php?id=1&chooselog=1&modid=site_errors.';
$string['notifyloginfailuresmessagestart'] = 'Λίστα με αποτυχημένες προσπάθειες σύνδεσης {$a} από την τελευταία φορά που ειδοποιηθήκατε';
$string['notifyloginfailuressubject'] = '{$a} :: Ειδοποίηση αποτυχημένων συνδέσεων';
$string['notincluded'] = 'Δεν έχει συμπεριληφθεί';
$string['notingroup'] = 'Συγνώμη, αλλά θα πρέπει να είστε μέλος μιας ομάδας για να δείτε αυτή τη σελίδα.';
$string['notpublic'] = 'Όχι δημόσια!';
$string['nousersfound'] = 'Δε βρέθηκαν χρήστες';
$string['nousersmatching'] = 'Δε βρέθηκε χρήστης που να ταιριάζει με «{$a}»';
$string['nousersyet'] = 'Δεν υπάρχουν χρήστες ακόμη';
$string['novalidcourses'] = 'Δεν υπάρχουν έγκυρα μαθήματα προς προβολή';
$string['now'] = 'τώρα';
$string['numattempts'] = '{$a} αποτυχημένες προσπάθειες σύνδεσης';
$string['numberofcourses'] = 'Αριθμός μαθημάτων';
$string['numberweeks'] = 'Αριθμός ενοτήτων';
$string['numday'] = '{$a} ημέρα';
$string['numdays'] = '{$a} ημέρες';
$string['numhours'] = '{$a} ώρες';
$string['numletters'] = '{$a} γράμματα';
$string['numminutes'] = '{$a} λεπτά';
$string['nummonth'] = '{$a} μήνα';
$string['nummonths'] = '{$a} μήνες';
$string['numseconds'] = '{$a} δευτερόλεπτα';
$string['numviews'] = '{$a} προβολές';
$string['numweek'] = '{$a} εβδομάδα';
$string['numweeks'] = '{$a} εβδομάδες';
$string['numwords'] = '{$a} λέξεις';
$string['numyear'] = '{$a} έτος';
$string['numyears'] = '{$a} έτη';
$string['ok'] = 'ΟΚ';
$string['oldpassword'] = 'Τρέχων κωδικός πρόσβασης';
$string['olduserdirectory'] = 'Αυτός είναι ο φάκελος ΠΑΛΑΙΩΝ χρηστών και δε χρειάζεται πλέον. Μπορείτε να το σβήσετε με ασφάλεια. Τα αρχεία που περιέχει έχουν αντιγραφεί στο φάκελο ΝΕΩΝ χρηστών.';
$string['opendrawerblocks'] = 'Άνοιγμα συρταριού μπλοκ';
$string['opendrawerindex'] = 'Άνοιγμα ευρετηρίου μαθήματος';
$string['opensinnewwindow'] = 'Ανοίγει σε νέο παράθυρο';
$string['operator_and'] = 'και';
$string['operator_andnot'] = 'και';
$string['operator_or'] = 'ή';
$string['optional'] = 'προαιρετικό';
$string['options'] = 'επιλογές';
$string['order'] = 'Ταξινόμηση';
$string['originalpath'] = 'Αρχική διαδρομή';
$string['orphanedactivitiesinsectionno'] = 'Ορφανές δραστηριότητες (ενότητα {$a})';
$string['other'] = 'Άλλο';
$string['outline'] = 'Σύνοψη';
$string['outlinereport'] = 'Συνοπτική αναφορά';
$string['page'] = 'Σελίδα';
$string['pagea'] = 'Σελίδα {$a}';
$string['pagedcontentnavigation'] = 'Πλοήγηση σελιδοποίησης';
$string['pagedcontentnavigationactiveitem'] = 'Τρέχουσα σελίδα, σελίδα {$a}';
$string['pagedcontentnavigationitem'] = 'Μετάβαση στη σελίδα {$a}';
$string['pagedcontentpagingbaritemsperpage'] = 'Εμφάνιση {$a} αντικειμένων ανά σελίδα';
$string['pageheaderconfigablock'] = 'Ρυθμίσεις ενός μπλοκ στο {$a->fullname}';
$string['pagepath'] = 'Μονοπάτι σελίδας';
$string['pageshouldredirect'] = 'Αυτή η σελίδα θα έπρεπε να ανακατευθύνει αυτόματα. Εάν δεν συμβαίνει τίποτα, χρησιμοποιήστε τον παρακάτω σύνδεσμο για συνέχεια.';
$string['parentcategory'] = 'Γονική κατηγορία';
$string['parentcoursenotfound'] = 'Δεν είναι δυνατή η εύρεση γονικού μαθήματος!';
$string['parentfolder'] = 'Φάκελος-γονέας';
$string['participants'] = 'Συμμετέχοντες';
$string['participantslist'] = 'Λίστα συμμετεχόντων';
$string['participationratio'] = 'Ρυθμός συμμετεχόντων';
$string['participationreport'] = 'Αναφορά συμμετοχής';
$string['password'] = 'Κωδικός πρόσβασης';
$string['passwordchanged'] = 'Ο κωδικός πρόσβασης έχει αλλάξει';
$string['passwordconfirmchange'] = 'Επιβεβαίωση αλλαγής κωδικού πρόσβασης';
$string['passwordextlink'] = 'Για να ανακτήσετε τον κωδικό σας, πατήστε στον επόμενο σύνδεσμο. Θα βγείτε από το Moodle.';
$string['passwordforgotten'] = 'Ξεχάσατε τον κωδικό σας;';
$string['passwordforgotteninstructions'] = 'Τα στοιχεία σας πρέπει πρώτα να υπάρχουν στην βάση δεδομένων χρηστών. Παρακαλούμε, εισαγάγετε <strong>είτε</strong> το όνομα χρήστη <strong>ή</strong> την καταχωρημένη διεύθυνση ηλε.ταχυδρομείου σας στο κατάλληλο πεδίο. Δε χρειάζεται να εισάγετε και τα δύο.';
$string['passwordforgotteninstructions2'] = 'Για να επαναφέρετε τον κωδικό πρόσβασής σας, συμπληρώστε το όνομα χρήστη σας ή τη διεύθυνση email σας παρακάτω. Εάν βρεθεί στη βάση δεδομένων, ένα μήνυμα θα αποσταλεί στη διεύθυνση ηλε.ταχυδρομείου σας, με οδηγίες για το πώς να έχετε και πάλι πρόσβαση.';
$string['passwordnohelp'] = 'Δεν υπάρχει διαθέσιμη βοήθεια για να βρείτε τον χαμένο σας κωδικό πρόσβασης. Παρακαλούμε επικοινωνήστε με το διαχειριστή του Moodle σας.';
$string['passwordpolicynomatch'] = 'Ο τρέχων κωδικός πρόσβασης σας, δεν συμφωνεί πλέον με την καθορισμένη πολιτική κωδικών πρόσβασης.
   {$a}';
$string['passwordrecovery'] = 'Ναι, βοηθήστε με να συνδεθώ';
$string['passwordsdiffer'] = 'Αυτοί οι κωδικοί πρόσβασης δεν ταιριάζουν';
$string['passwordsent'] = 'Ο κωδικός πρόσβασης έχει αποσταλεί';
$string['passwordsenttext'] = '<p>Ένα μήνυμα ηλε.ταχυδρομείου έχει σταλεί στη διεύθυνση {$a->email}.</p><p><b>Παρακαλούμε ελέγξτε το ηλε.ταχυδρομείο σας για να μάθετε τον νέο κωδικό πρόσβασής σας.</b></p><p>Ο νέος κωδικός δημιουργήθηκε αυτόματα. Ίσως να θέλετε να τον <a href={$a->link}>αλλάξετε σε κάτι πιο ευκολομνημόνευτο</a>.</p>';
$string['passwordset'] = 'Ο κωδικός πρόσβασής σας έχει οριστεί.';
$string['path'] = 'Μονοπάτι';
$string['pathnotexists'] = 'Το μονοπάτι δεν υπάρχει στον εξυπηρετητή σας!';
$string['pathslasherror'] = 'Το μονοπάτι δεν μπορεί να τελειώνει με κάθετο!!';
$string['paymentinstant'] = 'Χρησιμοποιήστε το παρακάτω πλήκτρο για να πληρώσετε και να εγγραφείτε μέσα σε λίγα λεπτά!';
$string['paymentpending'] = '(<small><b><u>{$a}</u></b> εκκρεμεί</small>)';
$string['paymentrequired'] = 'Αυτό το μάθημα απαιτεί πληρωμή για την είσοδο.';
$string['payments'] = 'Πληρωμές';
$string['paymentsorry'] = 'Ευχαριστούμε για την πληρωμή σας! Δυστυχώς δεν έχει ακόμη ολοκληρωθεί η επεξεργασία της πληρωμής σας και έτσι δεν είστε προς το παρόν γραμμένος στο μάθημα «{$a->fullname}». Παρακαλούμε προσπαθήστε να συνεχίσετε στο μάθημα σε λίγα δευτερόλεπτα αλλά αν συνεχίσετε να έχετε προβλήματα, τότε παρακαλούμε ειδοποιήστε τον διδάσκοντα {$a->teacher} ή τον διαχειριστή του ιστοτόπου.';
$string['paymentthanks'] = 'Ευχαριστούμε για την πληρωμή! Έχετε πλέον εγγραφεί στο μάθημά σας:<br />«{$a}»';
$string['pendingrequests'] = 'Αιτήσεις που εκκρεμούν';
$string['percents'] = '{$a}%';
$string['periodending'] = 'Η περίοδος λήγει ({$a})';
$string['perpage'] = 'Ανά σελίδα';
$string['perpagea'] = 'Ανά σελίδα: {$a}';
$string['personal'] = 'Προσωπικό';
$string['personalprofile'] = 'Προσωπικό προφίλ';
$string['phone'] = 'Τηλέφωνο';
$string['phone1'] = 'Τηλέφωνο';
$string['phone2'] = 'Κινητό τηλέφωνο';
$string['phpinfo'] = 'Πληροφορίες PHP';
$string['picture'] = 'Εικόνα';
$string['pictureof'] = 'Φωτογραφία {$a}';
$string['pictureofuser'] = 'Εικόνα χρήστη';
$string['placeholdertypeorselect'] = 'Πληκτρολογήστε ή επιλέξτε...';
$string['pleaseclose'] = 'Παρακαλούμε κλείστε αυτό το παράθυρο τώρα.';
$string['pleasesearchmore'] = 'Περισσότερη αναζήτηση';
$string['pleaseusesearch'] = 'Παρακαλούμε χρησιμοποιήστε την αναζήτηση';
$string['plugin'] = 'Πρόσθετο';
$string['pluginarea'] = 'Περιοχή';
$string['plugincheck'] = 'Έλεγχος πρόσθετων';
$string['plugindeletefiles'] = 'Όλα τα σχετικά δεδομένα με το πρόσθετο «{$a->name}» έχουν διαγραφεί από την βάση δεδομένων. Για να εμποδίσετε το πρόσθετο να επανεγκατασταθεί μόνο του, πρέπει τώρα να διαγράψετε αυτόν τον φάκελο από τον εξυπηρετητή σας: {$a->directory}';
$string['pluginitemid'] = 'ID αντικειμένου';
$string['pluginsetup'] = 'Ρύθμιση πινάκων πρόσθετων';
$string['policyaccept'] = 'Καταλαβαίνω και συμφωνώ';
$string['policyagree'] = 'Πρέπει να συμφωνήσετε με αυτή την πολιτική για να συνεχίσετε να χρησιμοποιείτε αυτόν τον ιστότοπο. Συμφωνείτε;';
$string['policyagreement'] = 'Συμφωνία με την πολιτική ιστοτόπου';
$string['policyagreementclick'] = 'Πατήστε εδώ για να διαβάσετε τους όρους χρήσης';
$string['popup'] = 'αναδυόμενο';
$string['popupwindow'] = 'Άνοιγμα του αρχείου σε νέο παράθυρο';
$string['popupwindowname'] = 'Αναδυόμενο παράθυρο';
$string['post'] = 'Ανάρτηση';
$string['posts'] = 'Αναρτήσεις';
$string['potentialadmins'] = 'Πιθανοί διαχειριστές';
$string['potentialcreators'] = 'Πιθανοί δημιουργοί μαθημάτων';
$string['potentialstudents'] = 'Πιθανοί μαθητές';
$string['potentialteachers'] = 'Πιθανοί διδάσκοντες';
$string['poweredbymoodle'] = 'Με την υποστήριξη του <a href="https://moodle.com">Moodle</a>';
$string['preferences'] = 'Προτιμήσεις';
$string['preferredlanguage'] = 'Προτιμώμενη γλώσσα';
$string['preferredtheme'] = 'Προτιμώμενο αισθητικό θέμα';
$string['preprocessingbackupfile'] = 'Προ-επεξεργασία αντιγράφου ασφαλείας';
$string['prev'] = 'Προηγούμενο';
$string['preview'] = 'Προεπισκόπηση';
$string['previeworchoose'] = 'Προεπισκόπηση ή επιλογή αισθητικού θέματος';
$string['previous'] = 'Προηγούμενο';
$string['previouslyselectedusers'] = 'Οι προηγουμένως επιλεγμένοι χρήστες δεν ταιριάζουν με «{$a}»';
$string['previouspage'] = 'Προηγούμενη σελίδα';
$string['previoussection'] = 'Προηγούμενη ενότητα';
$string['primaryadminsetup'] = 'Στήσιμο λογαριασμού διαχειριστή';
$string['privacy:metadata:config_log'] = 'Οι καταγραφές των αλλαγών ρυθμίσεων.';
$string['privacy:metadata:config_log:name'] = 'Το όνομα της ρύθμισης αλλάζει.';
$string['privacy:metadata:config_log:oldvalue'] = 'Η προηγούμενη τιμή για αυτή τη ρύθμιση.';
$string['privacy:metadata:config_log:plugin'] = 'Το πρόσθετο τροποποιήθηκε.';
$string['privacy:metadata:config_log:timemodified'] = 'Πότε έγινε η αλλαγή.';
$string['privacy:metadata:config_log:userid'] = 'Ο χρήστης που έκανε την αλλαγή.';
$string['privacy:metadata:config_log:value'] = 'Η νέα τιμή για αυτή τη ρύθμιση.';
$string['privacy:metadata:events_queue'] = 'Η ουρά των γεγονότων χρήστη σε αναμονή επεξεργασίας.';
$string['privacy:metadata:events_queue:eventdata'] = 'Τα δεδομένα που αποθηκεύτηκαν στο γεγονός.';
$string['privacy:metadata:events_queue:stackdump'] = 'Οποιοδήποτε ίχνος στοίβας (stacktrace) σχετίζεται με αυτό το γεγονός.';
$string['privacy:metadata:events_queue:timecreated'] = 'Πότε δημιουργήθηκε αυτό το γεγονός.';
$string['privacy:metadata:events_queue:userid'] = 'Το αναγνωριστικό χρήστη που σχετίζεται με αυτό το γεγονός.';
$string['privacy:metadata:log'] = 'Μια συλλογή από παρελθόντα γεγονότα';
$string['privacy:metadata:log:action'] = 'Περιγραφή της ενέργειας';
$string['privacy:metadata:log:cmid'] = 'cmid';
$string['privacy:metadata:log:course'] = 'μάθημα';
$string['privacy:metadata:log:info'] = 'Επιπρόσθετη πληροφόρηση';
$string['privacy:metadata:log:ip'] = 'Η διεύθυνση IP που χρησιμοποιούνταν την ώρα του γεγονότος';
$string['privacy:metadata:log:module'] = 'άρθρωμα';
$string['privacy:metadata:log:time'] = 'Η ώρα κατά την οποία έλαβε χώρα η ενέργεια';
$string['privacy:metadata:log:url'] = 'Η διεύθυνση URL που σχετίζεται με το γεγονός';
$string['privacy:metadata:log:userid'] = 'Το αναγνωριστικό του χρήστη που εκτέλεσε την ενέργεια';
$string['privacy:metadata:oauth2_refresh_token'] = 'Ανανέωση κουπονιού που χρησιμοποιείται στην επικοινωνία OAuth 2.0';
$string['privacy:metadata:oauth2_refresh_token:issuerid'] = 'Το αναγνωριστικό του εκδότη στον οποίο αντιστοιχεί το κουπόνι';
$string['privacy:metadata:oauth2_refresh_token:scopehash'] = 'Το αναγνωριστικό του χρήστη στον οποίο αντιστοιχεί το κουπόνι';
$string['privacy:metadata:oauth2_refresh_token:timecreated'] = 'Η χρονική στιγμή κατά την οποία δημιουργήθηκε το κουπόνι';
$string['privacy:metadata:oauth2_refresh_token:timemodified'] = 'Η ώρα τελευταίας ενημέρωσης του κουπονιού';
$string['privacy:metadata:oauth2_refresh_token:token'] = 'Το κουπόνι ανανέωσης για τις αντίστοιχες εμβέλειες και το χρήστη';
$string['privacy:metadata:oauth2_refresh_token:userid'] = 'Το αναγνωριστικό του χρήστη στον οποίο αντιστοιχεί το κουπόνι';
$string['privacy:metadata:task_adhoc'] = 'Η κατάσταση των εργασιών ειδικού σκοπού.';
$string['privacy:metadata:task_adhoc:component'] = 'Το στοιχείο λογισμικού που κατέχει την εργασία.';
$string['privacy:metadata:task_adhoc:nextruntime'] = 'Ο νωρίτερος χρόνος για να εκτελέσετε αυτή την εργασία.';
$string['privacy:metadata:task_adhoc:userid'] = 'Ο χρήστης με τα δικαιώματα του οποίου θα εκτελεστεί η εργασία.';
$string['privacy:metadata:task_log'] = 'Έξοδος καταγραφής για μια καταγραφή';
$string['privacy:metadata:task_log:component'] = 'Το στοιχείο (λογισμικού) που κατέχει την εργασία.';
$string['privacy:metadata:task_log:userid'] = 'Ο χρήστης στον οποίο ανήκε η εργασία.';
$string['privacy:metadata:upgrade_log'] = 'Η καταγραφή αναβάθμισης.';
$string['privacy:metadata:upgrade_log:backtrace'] = 'Οποιοδήποτε (στο παρελθόν) ίχνος στοίβας σχετίζεται με αυτό το βήμα αναβάθμισης.';
$string['privacy:metadata:upgrade_log:details'] = 'Επιπλέον πληροφορίες σχετικά με την αναβάθμιση.';
$string['privacy:metadata:upgrade_log:info'] = 'Οι κύριες πληροφορίες για αυτό το βήμα αναβάθμισης.';
$string['privacy:metadata:upgrade_log:plugin'] = 'Το πρόσθετο που αναβαθμίστηκε.';
$string['privacy:metadata:upgrade_log:targetversion'] = 'Η νέα έκδοση που διατίθεται αν επιθυμείτε αναβάθμιση.';
$string['privacy:metadata:upgrade_log:timemodified'] = 'Πότε έγινε η αναβάθμιση.';
$string['privacy:metadata:upgrade_log:type'] = 'Ο τύπος καταχώρησης καταγραφής.';
$string['privacy:metadata:upgrade_log:userid'] = 'Ο χρήστης που πραγματοποίησε την αναβάθμιση.';
$string['privacy:metadata:upgrade_log:version'] = 'Η παλιά έκδοση του πρόσθετου.';
$string['private_files_handler'] = 'Αποθήκευση συνημμένων σε ένα μήνυμα ηλε.ταχυδρομείου στον χώρο αποθήκευσης ιδιωτικών αρχείων του χρήστη.';
$string['private_files_handler_name'] = 'Αποστολή (συνημμένων) μέσω ηλε.ταχυδρομείου στο χώρο ιδιωτικών αρχείων';
$string['privatefiles'] = 'Προσωπικά αρχεία';
$string['privatefilesmanage'] = 'Διαχείριση ιδιωτικών αρχείων';
$string['proceed'] = 'Συνέχεια';
$string['profile'] = 'Προφίλ';
$string['profilenotshown'] = 'Αυτή η περιγραφή προφίλ δε θα φαίνεται μέχρι αυτό το άτομο να εγγραφεί σε ένα τουλάχιστον μάθημα.';
$string['publicprofile'] = 'Δημόσιο προφίλ';
$string['publicsitefileswarning'] = 'Σημείωση: τα αρχεία που τοποθετούνται εδώ μπορούν να προσπελαστούν από οποιονδήποτε';
$string['publicsitefileswarning2'] = 'Σημείωση: Τα αρχεία που τοποθετούνται εδώ είναι προσβάσιμα σε όποιον γνωρίζει (ή μπορεί να μαντέψει) τη διεύθυνση URL. Για λόγους ασφαλείας, συνιστάται η διαγραφή όλων των αρχείων αντιγράφων ασφαλείας αμέσως μετά την επαναφορά τους.';
$string['publicsitefileswarning3'] = 'Σημείωση: Τα αρχεία που τοποθετούνται εδώ μπορούν να γίνουν προσβάσιμα από όποιον γνωρίζει (ή μπορεί να μαντέψει) τη διεύθυνση URL. <br /> Για λόγους ασφαλείας, τα αρχεία αντιγράφων ασφαλείας θα πρέπει να αποθηκεύονται μόνο στον ασφαλή φάκελο backupdata.';
$string['question'] = 'Ερώτηση';
$string['questionsinthequestionbank'] = 'Ερωτήσεις στην τράπεζα ερωτήσεων';
$string['queued'] = 'Σε ουρά';
$string['quotausage'] = 'Χρησιμοποιείτε αυτή τη στιγμή {$a->used} από το συνολικό όριο {$a->total}.';
$string['readinginfofrombackup'] = 'Ανάγνωση πληροφοριών από το αντίγραφο ασφαλείας';
$string['readme'] = 'ΔΙΑΒΑΣΤΕ ΜΕ';
$string['recentactivity'] = 'Πρόσφατη δραστηριότητα';
$string['recentactivityreport'] = 'Πλήρης αναφορά για την πρόσφατη δραστηριότητα...';
$string['recipientslist'] = 'Λίστα παραληπτών';
$string['recommended'] = 'Συνιστώμενη';
$string['recreatedcategory'] = 'Επαναδημιουργημένη κατηγορία {$a}';
$string['redirect'] = 'Ανακατεύθυνση';
$string['reducesections'] = 'Μείωση του αριθμού των ενοτήτων';
$string['refresh'] = 'Ανανέωση';
$string['refreshingevents'] = 'Ανανέωση γεγονότων';
$string['registration'] = 'Καταχώρηση του ιστοτόπου στο moodle.net';
$string['registrationcontact'] = 'Επικοινωνία από το κοινό';
$string['registrationcontactno'] = 'Όχι, δεν θέλω να έρθουν σε επαφή μαζί μου άλλα άτομα';
$string['registrationcontactyes'] = 'Ναι, να παρέχεται μια φόρμα για να επικοινωνούν μαζί μου άλλοι χρήστες του Moodle';
$string['registrationemail'] = 'Ειδοποιήσεις μέσω ηλε.ταχυδρομείου';
$string['registrationinfo'] = '<p>Αυτή η σελίδα σας επιτρέπει να καταχωρήσετε το Moodle σας στο moodle.org. Η καταχώρηση είναι δωρεάν. Το κύριο πλεονέκτημα είναι ότι θα προστεθείτε σε μια λίστα ηλε.ταχυδρομείου χαμηλής κίνησης για σημαντικές ειδοποιήσεις όπως επαγρυπνήσεις ασφαλείας και νέες εκδόσεις του Moodle.</p><p>Από προεπιλογή, οι πληροφορίες σας θα είναι εμπιστευτικές και δεν θα πωληθούν ούτε θα προωθηθούν ποτέ σε κανέναν άλλο. Ο μόνος λόγος για τη συλλογή αυτής της πληροφορίας είναι για λόγους υποστήριξης και για να δημιουργηθεί μια στατιστική εικόνα της κοινότητας του Moodle ως συνόλου.</p><p>Αν θέλετε, μπορείτε να επιλέξετε το όνομα του δικτυακού σας τόπου, της χώρας και το URL να προστεθούν στο δημόσιο κατάλογο δικτυακών τόπων Moodle.</p><p>Όλες οι νέες καταχωρήσεις επαληθεύονται χειροκίνητα πριν προστεθούν στη λίστα, αλλά μπορείτε να ενημερώνετε την καταχώρηση (και στο δημόσιο κατάλογο) οποιαδήποτε στιγμή απλά υποβάλλοντας ξανά αυτή τη φόρμα.</p>';
$string['registrationinfotitle'] = 'Πληροφορίες καταχώρησης';
$string['registrationno'] = 'Όχι, δεν επιθυμώ να λαμβάνω οποιαδήποτε μηνύματα ηλε.ταχυδρομείου';
$string['registrationsend'] = 'Αποστολή πληροφοριών καταχώρησης στο moodle.org';
$string['registrationyes'] = 'Ναι, ειδοποιήστε με για νέες διανομές Moodle, επαγρυπνήσεις ασφαλείας και άλλα σημαντικά νέα';
$string['reject'] = 'Απόρριψη';
$string['rejectdots'] = 'Απόρριψη...';
$string['relativedatesmode'] = 'Κατάσταση λειτουργίας σχετικών ημερομηνιών';
$string['relativedatesmode_help'] = 'Εμφάνιση ημερομηνιών μαθήματος ή δραστηριότητας σε σχέση με την ημερομηνία έναρξης του μαθήματος από τον χρήστη .<br />Η ημερομηνία έναρξης του μαθήματος από τον χρήστη θα είναι η ημερομηνία έναρξης εγγραφής, εκτός εάν έχει εγγραφεί πριν αρχίσει το μάθημα, οπότε η ημερομηνία έναρξής του θα είναι η ημερομηνία έναρξης του μαθήματος.<br/><strong>ΠΡΟΕΙΔΟΠΟΙΗΣΗ: Πρόκειται για ένα πειραματικό χαρακτηριστικό και ίσως δεν υποστηρίζεται από όλες τις δραστηριότητες. Μόλις δημιουργηθεί το μάθημα, αυτή η ρύθμιση του μαθήματος δεν μπορεί πλέον να αλλάξει.</strong>';
$string['relativedatesmode_warning'] = '<strong>Προειδοποίηση:</strong> Η κατάσταση λειτουργίας σχετικών ημερομηνιών δεν μπορεί να αλλάξει μόλις δημιουργηθεί το μάθημα.';
$string['reload'] = 'Επαναφόρτωση';
$string['remoteappuser'] = 'Απομακρυσμένος χρήστης {$a}';
$string['remove'] = 'Αφαίρεση';
$string['removeadmin'] = 'Αφαίρεση διαχειριστή';
$string['removecreator'] = 'Αφαίρεση δημιουργού μαθημάτων';
$string['removestudent'] = 'Αφαίρεση μαθητή';
$string['removeteacher'] = 'Αφαίρεση διδάσκοντα';
$string['rename'] = 'Μετονομασία';
$string['renamefileto'] = 'Μετονομασία <b>{$a}</b> σε';
$string['report'] = 'Αναφορά';
$string['reports'] = 'Αναφορές';
$string['reporttype'] = 'Τύπος αναφοράς';
$string['repositories'] = 'Αποθετήρια';
$string['requestcourse'] = 'Αίτηση δημιουργίας μαθήματος';
$string['requestedby'] = 'Η αίτηση έγινε από';
$string['requestedcourses'] = 'Ζητούμενα μαθήματα';
$string['requestreason'] = 'Λόγος αίτησης δημιουργίας μαθήματος';
$string['requests'] = 'Αιτήματα';
$string['required'] = 'Απαιτείται';
$string['requirespayment'] = 'Απαιτείται πληρωμή για την εγγραφή στο μάθημα';
$string['resendemail'] = 'Επαναποστολή μηνύματος ηλε.ταχυδρομείου';
$string['reset'] = 'Επαναρχικοποίηση';
$string['resetcomponent'] = 'Στοιχείο λογισμικού';
$string['resetcourse'] = 'Επαναρχικοποίηση μαθήματος';
$string['resetinfo'] = 'Αυτή η σελίδα σας επιτρέπει να διαγράψετε όλα τα αρχεία των χρηστών του μαθήματος, χωρίς ωστόσο να διαγράφονται οι δραστηριότητες και οι πηγές πληροφοριών.';
$string['resetnotimplemented'] = 'Δεν υλοποιήθηκε η επαναρχικοποίηση';
$string['resetrecordexpired'] = 'Ο σύνδεσμος επαναφοράς κωδικού πρόσβασης που χρησιμοποιήσατε είναι περισσότερο από {$a} λεπτά παλαιός και έχει λήξει. Παρακαλούμε, ξεκινήστε μια νέα επαναφορά κωδικού πρόσβασης.';
$string['resetstartdate'] = 'Επαναρχικοποίηση ημερομηνίας έναρξης';
$string['resetstatus'] = 'Κατάσταση';
$string['resettable'] = 'Επαναρχικοποίηση προτιμήσεων πίνακα';
$string['resettask'] = 'Εργασία';
$string['resettodefaults'] = 'Επαναρχικοποίηση στις προεπιλογές';
$string['resortcourses'] = 'Ταξινόμηση μαθημάτων';
$string['resortsubcategoriesby'] = 'Ταξινόμηση υποκατηγοριών κατά {$a} αύξουσα';
$string['resortsubcategoriesbyreverse'] = 'Ταξινόμηση υποκατηγοριών κατά {$a} φθίνουσα';
$string['resource'] = 'Πόρος';
$string['resourcedisplayauto'] = 'Αυτόματα';
$string['resourcedisplaydownload'] = 'Επιβολή λήψης αρχείου';
$string['resourcedisplayembed'] = 'Ενσωμάτωση';
$string['resourcedisplayframe'] = 'Σε πλαίσιο';
$string['resourcedisplaynew'] = 'Νέο παράθυρο';
$string['resourcedisplayopen'] = 'Άνοιγμα';
$string['resourcedisplaypopup'] = 'Σε αναδυόμενο παράθυρο';
$string['resources'] = 'Πόροι';
$string['resources_help'] = 'Οι τύποι εκπαιδευτικών πόρων επιτρέπουν σχεδόν σε κάθε είδος διαδικτυακού περιεχομένου να εισαχθεί στο μάθημα.';
$string['restore'] = 'Επαναφορά';
$string['restorecancelled'] = 'Η επαναφορά ακυρώθηκε';
$string['restorecannotassignroles'] = 'Η επαναφορά χρειάζεται να εκχωρήσει ρόλους και δεν έχετε την άδεια να το κάνετε';
$string['restorecannotcreateorassignroles'] = 'Η επαναφορά χρειάζεται να δημιουργήσει ή να αντιστοιχίσει ρόλους και δεν έχετε την άδεια να το κάνετε';
$string['restorecannotcreateuser'] = 'Η επαναφορά χρειάζεται να δημιουργήσει το χρήστη «{$a}» από το αρχείο αντιγράφου ασφαλείας και δεν έχετε την άδεια να το κάνετε';
$string['restorecannotoverrideperms'] = 'Η επαναφορά χρειάζεται να παρακάμψει δικαιώματα και δεν έχετε την άδεια να το κάνετε';
$string['restorecoursenow'] = 'Επαναφορά του μαθήματος τώρα!';
$string['restoredaccount'] = 'Λογαριασμός που επαναφέρθηκε';
$string['restoredaccountinfo'] = 'Αυτός ο λογαριασμός έχει εισαχθεί από άλλο εξυπηρετητή και ο κωδικός πρόσβασης έχει χαθεί. Για να ορίσετε έναν νέο κωδικό πρόσβασης μέσω ηλε.ταχυδρομείου, παρακαλούμε κάντε κλικ στο «Συνέχεια»';
$string['restorefinished'] = 'Η επαναφορά ολοκληρώθηκε επιτυχώς';
$string['restoremnethostidmismatch'] = 'Το αναγνωριστικό Η/Υ MNet του χρήστη «{$a}» δεν ταιριάζει με το τοπικό αναγνωριστικό Η/Υ MNet.';
$string['restoreto'] = 'Επαναφορά σε';
$string['restoretositeadding'] = 'Προειδοποίηση: Πρόκειται να κάνετε επαναφορά στην αρχική σελίδα του ιστότοπου, προσθέτοντας δεδομένα σε αυτό!';
$string['restoretositedeleting'] = 'Προειδοποίηση: Πρόκειται να κάνετε επαναφορά στην αρχική σελίδα του ιστότοπου, διαγράφοντας πρώτα δεδομένα από αυτόν!';
$string['restoreuserconflict'] = 'Η προσπάθεια επαναφοράς του χρήστη «{$a}» από το αρχείο αντιγράφου ασφαλείας θα προκαλέσει σύγκρουση';
$string['restoreuserinfofailed'] = 'Η διαδικασία επαναφοράς έχει σταματήσει επειδή δεν έχετε άδεια επαναφοράς δεδομένων χρήστη.';
$string['restoreusersprecheck'] = 'Έλεγχος δεδομένων χρήστη';
$string['restoreusersprecheckerror'] = 'Παρουσιάστηκαν ορισμένα προβλήματα κατά τον έλεγχο των δεδομένων χρήστη';
$string['restricted'] = 'Περιορισμένο';
$string['resultsfound'] = 'Βρέθηκαν {$a} αποτελέσματα';
$string['retry'] = 'Προσπάθεια ξανά';
$string['returningtosite'] = 'Επιστρέφετε σε αυτόν τον ιστότοπο;';
$string['returntooriginaluser'] = 'Επιστροφή στο {$a}';
$string['revert'] = 'Επαναφορά';
$string['role'] = 'Ρόλος';
$string['roleassignments'] = 'Αναθέσεις ρόλων';
$string['rolemappings'] = 'Αντιστοιχίσεις ρόλων';
$string['rolerenaming'] = 'Μετονομασία ρόλου';
$string['rolerenaming_help'] = 'Αυτή η ρύθμιση επιτρέπει την αλλαγή των εμφανιζόμενων ονομάτων για τους ρόλους που χρησιμοποιούνται στο μάθημα. Αλλάζει μόνο το εμφανιζόμενο όνομα - δεν επηρεάζονται τα δικαιώματα ρόλου. Τα νέα ονόματα ρόλων θα εμφανιστούν στη σελίδα συμμετεχόντων στο μάθημα και οπουδήποτε αλλού μέσα στο μάθημα. Αν ο μετονομασμένος ρόλος είναι αυτός που ο διαχειριστής έχει επιλέξει ως ρόλος διαχειριστή μαθημάτων, τότε το νέο όνομα ρόλου θα εμφανίζεται επίσης ως μέρος των καταχωρήσεων του μαθήματος.';
$string['roles'] = 'Ρόλοι';
$string['rss'] = 'Τροφοδοσία RSS';
$string['rssarticles'] = 'Πλήθος πρόσφατων άρθρων τροφοδοσίας RSS';
$string['rsserror'] = 'Σφάλμα κατά την ανάγνωση των δεδομένων τροφοδοσίας RSS';
$string['rsserrorauth'] = 'Ο σύνδεσμός σας τροφοδοσίας RSS δεν περιέχει ένα έγκυρο κουπόνι αυθεντικοποίησης.';
$string['rsserrorguest'] = 'Αυτή η τροφοδοσία χρησιμοποιεί πρόσβαση επισκέπτη για την πρόσβαση στα δεδομένα, αλλά ο επισκέπτης δεν έχει άδεια να διαβάσει τα δεδομένα. Επισκεφθείτε την αρχική τοποθεσία από την οποία προέρχεται αυτή η τροφοδοσία (URL) ως έγκυρος χρήστης και αποκτήστε έναν νέο σύνδεσμο τροφοδοσίας RSS από εκεί.';
$string['rsskeyshelp'] = 'Για τη διασφάλιση της ασφάλειας και της ιδιωτικότητας, οι διευθύνσεις URL τροφοδοσιών RSS περιέχουν ένα ειδικό κουπόνι που προσδιορίζει τον χρήστη από τον οποίο προήλθαν. Αυτό αποτρέπει άλλους χρήστες, από την πρόσβασή τους σε περιοχές του Moodle που δεν έχουν πρόσβαση μέσω τροφοδοσιών RSS.</p><p>Αυτό το κουπόνι δημιουργείται αυτόματα την πρώτη φορά που εισέρχεστε σε μία περιοχή του Moodle που παράγει τροφοδοσίες RSS. Αν αισθάνεστε ότι το κουπόνι RSS τροφοδοσιών σας έχει παραβιαστεί με κάποιο τρόπο μπορείτε να υποβάλετε αίτημα για ένα καινούργιο επιλέγοντας τον σύνδεσμο επαναρχικοποίησης. Παρακαλούμε σημειώστε ότι οι τρέχουσες διευθύνσεις URL τροφοδοσιών RSS θα καταστούν άκυρες.</p>';
$string['rsstype'] = 'Τροφοδοσία RSS για αυτή τη δραστηριότητα';
$string['save'] = 'Αποθήκευση';
$string['saveandnext'] = 'Αποθήκευση και προβολή του επόμενου';
$string['savechanges'] = 'Αποθήκευση αλλαγών';
$string['savechangesanddisplay'] = 'Αποθήκευση και προβολή';
$string['savechangesandreturn'] = 'Αποθήκευση και επιστροφή';
$string['savechangesandreturntocourse'] = 'Αποθήκευση κι επιστροφή στο μάθημα';
$string['savecomment'] = 'Αποθήκευση σχολίου';
$string['savedat'] = 'Η αποθήκευση έγινε στις:';
$string['savepreferences'] = 'Αποθήκευση προτιμήσεων';
$string['saveto'] = 'Αποθήκευση σε';
$string['scale'] = 'Κλίμακα';
$string['scale_help'] = 'Μια κλίμακα παρέχει έναν τρόπο αξιολόγησης ή βαθμολόγησης της απόδοσης σε μια δραστηριότητα. Ορίζεται από μια ταξινομημένη λίστα τιμών, που κυμαίνονται από αρνητικές έως θετικές, διαχωρισμένες με κόμμα, για παράδειγμα «Απογοητευτικά, Όχι αρκετά καλά, Μέτρια, Καλά, Πολύ καλά, Άριστα!»';
$string['scale_link'] = '';
$string['scales'] = 'Κλίμακες';
$string['scalescustom'] = 'Προσαρμοσμένες κλίμακες';
$string['scalescustomcreate'] = 'Προσθήκη νέας κλίμακας';
$string['scalescustomno'] = 'Δεν έχουν δημιουργηθεί προσαρμοσμένες κλίμακες ακόμα';
$string['scalesstandard'] = 'Τυπικές κλίμακες';
$string['scalestandard'] = 'Τυπική κλίμακα';
$string['scalestandard_help'] = 'Μια τυπική κλίμακα είναι διαθέσιμη σε όλον τον ιστότοπο, για όλα τα μαθήματα.';
$string['scalestandard_link'] = '';
$string['scalestip'] = 'Για να δημιουργήσετε προσαρμοσμένες κλίμακες, χρησιμοποιήστε το σύνδεσμο «Κλίμακες...» στο μενού διαχείρισης του μαθήματός σας.';
$string['scalestip2'] = 'Για να δημιουργήσετε προσαρμοσμένες κλίμακες, χρησιμοποιήστε το σύνδεσμο «Βαθμοί» στο μενού διαχείρισης του μαθήματος και μετά επιλέξτε Επεξεργασία, Κλίμακες.';
$string['schedule'] = 'Χρονοπρόγραμμα';
$string['screenshot'] = 'Στιγμιότυπο οθόνης';
$string['search'] = 'Αναζήτηση';
$string['search_help'] = 'Για βασική αναζήτηση μιας ή περισσότερων λέξεων οπουδήποτε στο κείμενο, απλώς πληκτρολογήστε τις χωρισμένες με κενά. Χρησιμοποιούνται όλες οι λέξεις μεγαλύτερες από δύο χαρακτήρες. Για προχωρημένη αναζήτηση, πατήστε το κουμπί αναζήτησης χωρίς να πληκτρολογήσετε τίποτα στο πλαίσιο αναζήτησης για πρόσβαση στη φόρμα σύνθετης αναζήτησης.';
$string['searchactivities'] = 'Αναζήτηση δραστηριοτήτων με βάση το όνομα ή την περιγραφή';
$string['searchagain'] = 'Αναζήτηση ξανά';
$string['searchbyemail'] = 'Αναζήτηση με βάση τη διεύθυνση ηλε.ταχυδρομείου';
$string['searchbyusername'] = 'Αναζήτηση με βάση το όνομα χρήστη';
$string['searchcoursecategories'] = 'Αναζήτηση κατηγοριών';
$string['searchcourses'] = 'Αναζήτηση μαθημάτων';
$string['searchoptions'] = 'Επιλογές αναζήτησης';
$string['searchresults'] = 'Αποτελέσματα αναζήτησης';
$string['sec'] = 'δευτερόλεπτο';
$string['seconds'] = 'δευτερόλεπτα';
$string['secondsleft'] = '{$a} δευτερόλεπτα';
$string['secondstotime172800'] = '2 μέρες';
$string['secondstotime259200'] = '3 μέρες';
$string['secondstotime345600'] = '4 μέρες';
$string['secondstotime432000'] = '5 μέρες';
$string['secondstotime518400'] = '6 μέρες';
$string['secondstotime604800'] = '1 εβδομάδα';
$string['secondstotime86400'] = 'μία μέρα';
$string['secretalreadyused'] = 'Ο σύνδεσμος επιβεβαίωσης αλλαγής κωδικού πρόσβασης έχει ήδη χρησιμοποιηθεί· ο κωδικός πρόσβασης δεν άλλαξε.';
$string['secs'] = 'δευτερόλεπτα';
$string['section'] = 'Ενότητα';
$string['sectionactionnotsupported'] = 'Η ενέργεια ενότητας «{$a}» δεν υποστηρίζεται εδώ';
$string['sectionname'] = 'Όνομα ενότητας';
$string['sections'] = 'Ενότητες';
$string['seealsostats'] = 'Δείτε επίσης: Στατιστικά';
$string['selctauser'] = 'Επιλέξτε ένα χρήστη';
$string['select'] = 'Επιλογή';
$string['selectacategory'] = 'Παρακαλούμε, επιλέξτε μια κατηγορία';
$string['selectacountry'] = 'Επιλέξτε μια χώρα';
$string['selectacourse'] = 'Επιλέξτε ένα μάθημα';
$string['selectacoursesite'] = 'Επιλέξτε ένα μάθημα ή έναν ιστότοπο';
$string['selectagroup'] = 'Επιλέξτε μια ομάδα';
$string['selectall'] = 'Επιλογή όλων';
$string['selectallusersonpage'] = 'Επέλεξε όλους τους χρήστες της σελίδας';
$string['selectalluserswithcount'] = 'Επέλεξε όλους τους {$a} χρήστες';
$string['selectamodule'] = 'Παρακαλούμε, επιλέξτε ένα άρθρωμα δραστηριότητας';
$string['selectanaction'] = 'Επιλέξτε μια ενέργεια';
$string['selectanoptions'] = 'Επιλέξτε μια επιλογή';
$string['selectaregion'] = 'Επιλογή μιας περιοχής';
$string['selectcategorysort'] = 'Ποιες κατηγορίες θα θέλατε να ταξινομήσετε;';
$string['selectcategorysortby'] = 'Επιλέξτε τον τρόπο που θέλετε να ταξινομήσετε τις κατηγορίες';
$string['selectcoursesortby'] = 'Επιλέξτε πώς θα θέλατε να ταξινομήσετε τα μαθήματα';
$string['selectdefault'] = 'Επιλογή προεπιλεγμένων τιμών';
$string['selectedcategories'] = 'Επιλεγμένες κατηγορίες';
$string['selectedfile'] = 'Επιλεγμένο αρχείο';
$string['selectednowmove'] = '{$a} αρχεία επιλέχθηκαν για μετακίνηση. Τώρα επιλέξτε τον προορισμό και πατήστε «Μετακίνηση των αρχείων εδώ»';
$string['selectfiles'] = 'Επιλέξτε αρχεία';
$string['selectfiltertype'] = 'Επιλογή';
$string['selectgroupsseparate'] = 'Επιλέξτε ξεχωριστές ομάδες';
$string['selectgroupsvisible'] = 'Επιλέξτε ορατές ομάδες';
$string['selectitem'] = 'Επιλογή «{$a}»';
$string['selectmoduletoviewhelp'] = 'Επιλέξτε μια δραστηριότητα ή ένα πόρο για να δείτε τη βοήθεια του. Κάντε διπλό κλικ στο όνομα μιας δραστηριότητας ή ενός πόρου για γρήγορη προσθήκη.';
$string['selectnos'] = 'Επιλέξτε όλα «όχι»';
$string['selectperiod'] = 'Επέλεξε περίοδο';
$string['senddetails'] = 'Αποστολή των στοιχείων μου μέσω email';
$string['separate'] = 'Διαχωρισμός';
$string['separateandconnected'] = 'Ξεχωριστοί και Συνδεδεμένοι τρόποι γνώσης';
$string['separateandconnectedinfo'] = 'Η κλίμακα που βασίζεται στη θεωρία της ξεχωριστής και της συνδεδεμένης γνώσης. Αυτή η θεωρία περιγράφει δύο διαφορετικούς τρόπους με τους οποίους μπορούμε να αξιολογήσουμε και να μάθουμε για τα πράγματα που βλέπουμε και ακούμε.<ul>
<li><strong>Οι ξεχωριστοί γνώστες</strong> παραμένουν όσο το δυνατόν πιο αντικειμενικοί χωρίς να συμπεριλαμβάνουν αισθήματα και συναισθήματα. Σε μια συζήτηση με άλλους ανθρώπους, τους αρέσει να υπερασπίζονται τις ιδέες τους, χρησιμοποιώντας τη λογική για να βρουν τρύπες στις ιδέες του αντιπάλου.</li>
<li><strong>Οι συνδεδεμένοι γνώστες</strong> είναι πιο ευαίσθητοι προς άλλους ανθρώπους. Είναι εξειδικευμένοι στην ενσυναίσθηση και τείνουν να ακούν και να κάνουν ερωτήσεις μέχρι να αισθάνονται ότι μπορούν να συνδεθούν και να «κατανοήσουν τα πράγματα από την δική τους οπτική άποψη». Μαθαίνουν προσπαθώντας να μοιραστούν τις εμπειρίες που οδήγησαν στη γνώση που βρίσκουν σε άλλους ανθρώπους.</li></ul>';
$string['servererror'] = 'Παρουσιάστηκε σφάλμα κατά τη διάρκεια επικοινωνίας με τον εξυπηρετητή';
$string['serverlocaltime'] = 'Τοπική ώρα εξυπηρετητή';
$string['sessionforceclean'] = 'Ως προφύλαξη ασφαλείας, τα σενάρια που δημιουργούνται από χρήστες έχουν απενεργοποιηθεί σε αυτή τη σύνοδο.';
$string['sessiontimeoutsoon'] = 'Η σύνοδός σας πρόκειται να λήξει σύντομα. Θέλετε να επεκτείνετε την τρέχουσα σύνοδό σας;';
$string['setcategorytheme'] = 'Ορισμός κατηγορίας αισθητικού θέματος';
$string['setmode'] = 'Ορισμός κατάστασης λειτουργίας';
$string['setpassword'] = 'Ορισμός κωδικού πρόσβασης';
$string['setpasswordinstructions'] = 'Παρακαλούμε δώστε τον νέο κωδικό πρόσβασής σας παρακάτω και μετά αποθηκεύστε τις αλλαγές.';
$string['settings'] = 'Ρυθμίσεις';
$string['shortname'] = 'Σύντομο όνομα';
$string['shortnamecollisionwarning'] = '[*] = Το σύντομο όνομα που πληκτρολογήσατε χρησιμοποιείται ήδη από άλλο μάθημα';
$string['shortnamecourse'] = 'Σύντομο όνομα μαθήματος';
$string['shortnamecourse_help'] = 'Το όνομα εμφανίζεται σε περιοχές με περιορισμένο χώρο. Πρέπει να είναι μοναδικό.';
$string['shortnametaken'] = 'Το σύντομο όνομα χρησιμοποιείται ήδη από άλλο μάθημα ({$a})';
$string['shortnameuser'] = 'Σύντομο όνομα χρήστη';
$string['shortsitename'] = 'Σύντομο όνομα του ιστοτόπου (π.χ. μοναδική λέξη)';
$string['show'] = 'Προβολή';
$string['showactions'] = 'Εμφάνιση ενεργειών';
$string['showactivitydates'] = 'Εμφάνιση ημερομηνιών δραστηριότητας';
$string['showactivitydates_help'] = 'Εμφάνιση ημερομηνιών δραστηριότητας στη σελίδα του μαθήματος.';
$string['showadvancededitor'] = 'Προχωρημένο';
$string['showadvancedsettings'] = 'Εμφάνιση προχωρημένων ρυθμίσεων';
$string['showall'] = 'Εμφάνιση όλων {$a}';
$string['showallcourses'] = 'Εμφάνιση όλων των μαθημάτων';
$string['showallusers'] = 'Εμφάνιση όλων των χρηστών';
$string['showblockcourse'] = 'Εμφάνιση λίστας μαθημάτων που περιέχουν μπλοκ';
$string['showcategory'] = 'Εμφάνιση {$a}';
$string['showchartdata'] = 'Εμφάνιση δεδομένων γραφήματος';
$string['showcomments'] = 'Εμφάνιση/απόκρυψη σχολίων';
$string['showcommentsnonjs'] = 'Εμφάνιση σχολίων';
$string['showdescription'] = 'Εμφάνιση περιγραφής στην σελίδα του μαθήματος';
$string['showdescription_help'] = 'Αν ενεργοποιηθεί, η παραπάνω περιγραφή θα εμφανίζεται στη σελίδα του μαθήματος ακριβώς κάτω από το σύνδεσμο προς τη δραστηριότητα ή τον πόρο.';
$string['showgrades'] = 'Εμφάνιση βαθμολογίου στους μαθητές';
$string['showgrades_help'] = 'Επιτρέψτε στους μαθητές να δουν μια λίστα με όλους τους βαθμούς τους στο μάθημα.';
$string['showingacourses'] = 'Εμφάνιση όλων των {$a} μαθημάτων';
$string['showingxofycourses'] = 'Παρουσίαση μαθημάτων από {$a->start} έως {$a->end} από συνολικά {$a->total} μαθήματα';
$string['showlistofcourses'] = 'Εμφάνιση λίστας μαθημάτων';
$string['showmodulecourse'] = 'Εμφάνιση λίστας μαθημάτων που περιέχουν δραστηριότητα';
$string['showoncoursepage'] = 'Εμφάνιση στη σελίδα του μαθήματος';
$string['showonly'] = 'Εμφάνιση μόνο';
$string['showperpage'] = 'Εμφάνιση {$a} ανά σελίδα';
$string['showpopoverwindow'] = 'Εμφάνιση αναπτυσσόμενου παράθυρου';
$string['showrecent'] = 'Εμφάνιση πρόσφατης δραστηριότητας';
$string['showreports'] = 'Εμφάνιση αναφορών δραστηριοτήτων';
$string['showreports_help'] = 'Επιτρέψτε στους μαθητές να βλέπουν τις δικές τους αναφορές δραστηριότητας μέσω της σελίδας προφίλ τους.';
$string['showsettings'] = 'Εμφάνιση ρυθμίσεων';
$string['showtheselogs'] = 'Εμφάνιση αυτών των καταγραφών';
$string['showthishelpinlanguage'] = 'Εμφάνιση αυτής της βοήθειας στη γλώσσα: {$a}';
$string['sidepanel'] = 'Πλευρικός πίνακας';
$string['signoutofotherservices'] = 'Αποσυνδεθείτε από παντού';
$string['signoutofotherservices_help'] = 'Αν επιλεγεί, ο λογαριασμός θα αποσυνδεθεί από όλες τις συσκευές και τα συστήματα που χρησιμοποιούν υπηρεσίες ιστού, όπως η εφαρμογή κινητού.';
$string['since'] = 'Από';
$string['sincelast'] = 'από την τελευταία σύνδεση';
$string['site'] = 'Ιστότοπος';
$string['sitedefault'] = 'Προεπιλογή ιστοτόπου';
$string['sitedefaultspecified'] = 'Προεπιλογή ιστοτόπου ({$a})';
$string['siteerrors'] = 'Σφάλματα ιστοτόπου';
$string['sitefiles'] = 'Αρχεία ιστοτόπου';
$string['sitefilesused'] = 'Αρχεία του ιστοτόπου που χρησιμοποιούνται σε αυτό το μάθημα';
$string['sitehome'] = 'Αρχική ιστοτόπου';
$string['sitelegacyfiles'] = 'Αρχεία ιστοτόπου παλαιού τύπου';
$string['sitelogs'] = 'Καταγραφές του ιστοτόπου';
$string['sitenews'] = 'Ανακοινώσεις ιστοτόπου';
$string['sitepages'] = 'Σελίδες ιστοτόπου';
$string['sitepartlist'] = 'Δεν έχετε τα απαραίτητα δικαιώματα για να δείτε τη λίστα των συμμετεχόντων';
$string['sitepartlist0'] = 'Πρέπει να είστε διδάσκων του ιστοτόπου για να έχετε το δικαίωμα να δείτε τους συμμετέχοντες';
$string['sitepartlist1'] = 'Πρέπει να είστε διδάσκων για να έχετε το δικαίωμα να δείτε τους συμμετέχοντες';
$string['sites'] = 'Δικτυακοί τόποι';
$string['sitesection'] = 'Συμπεριλάβετε μια ενότητα θέματος';
$string['sitesettings'] = 'Ρυθμίσεις του ιστοτόπου';
$string['siteteachers'] = 'Διδάσκοντες ιστοτόπου';
$string['size'] = 'Μέγεθος';
$string['sizeb'] = 'bytes';
$string['sizegb'] = 'GB';
$string['sizekb'] = 'KB';
$string['sizemb'] = 'MB';
$string['sizepb'] = 'PB';
$string['sizetb'] = 'TB';
$string['skipped'] = 'Προσπεράστηκε';
$string['skiptocategorylisting'] = 'Μετάβαση στις λίστες κατηγοριών';
$string['skiptocoursedetails'] = 'Μετάβαση στις λεπτομερείς πληροφορίες για το μάθημα';
$string['skiptocourselisting'] = 'Μετάβαση στις λίστες μαθημάτων';
$string['skypeid'] = 'Αναγνωριστικό Skype';
$string['socialheadline'] = 'Κοινωνικό φόρουμ - τελευταία θέματα';
$string['someallowguest'] = 'Μερικά μαθήματα μπορεί να επιτρέπουν πρόσβαση επισκεπτών';
$string['someerrorswerefound'] = 'Κάποια πληροφορία έλειπε ή ήταν εσφαλμένη. Κοιτάξτε κάτω για λεπτομέρειες.';
$string['sort'] = 'Ταξινόμηση';
$string['sortby'] = 'Ταξινόμηση κατά';
$string['sortbyx'] = 'Αύξουσα ταξινόμηση κατά {$a}';
$string['sortbyxreverse'] = 'Φθίνουσα ταξινόμηση κατά {$a}';
$string['sorting'] = 'Ταξινόμηση';
$string['sourcerole'] = 'Πηγή ρόλου';
$string['specifyname'] = 'Πρέπει να πληκτρολογήσετε ένα όνομα';
$string['standard'] = 'Τυπικός';
$string['starpending'] = '([*] = μάθημα σε αναμονή έγκρισης)';
$string['startdate'] = 'Ημερομηνία έναρξης μαθήματος';
$string['startdate_help'] = 'Αυτή η ημερομηνία καθορίζει την έναρξη της πρώτης εβδομάδας για ένα μάθημα σε εβδομαδιαία μορφή. Είναι επίσης η ημερομηνία έναρξης για τα αρχεία καταγραφής των δραστηριοτήτων μαθημάτων.

Εάν αρχικοποιήσετε το μάθημα και αλλάξετε αυτήν την ημερομηνία, όλες οι ημερομηνίες στο μάθημα θα μετακινηθούν σε σχέση με τη νέα ημερομηνία έναρξης.';
$string['startingfrom'] = 'Αρχίζοντας από';
$string['startsignup'] = 'Δημιουργήστε νέο λογαριασμό';
$string['state'] = 'Νομός';
$string['statistics'] = 'Στατιστικά';
$string['statisticsgraph'] = 'Γράφημα στατιστικών';
$string['stats'] = 'Στατιστικά';
$string['statslogins'] = 'Συνδέσεις';
$string['statsmodedetailed'] = 'Λεπτομερής εμφάνιση χρήστη';
$string['statsmodegeneral'] = 'Γενική προβολή';
$string['statsnodata'] = 'Δεν υπάρχουν διαθέσιμα δεδομένα για αυτό το συνδυασμό μαθήματος και χρονικής περιόδου.';
$string['statsnodatauser'] = 'Δεν υπάρχουν διαθέσιμα δεδομένα για αυτό το συνδυασμό μαθήματος, χρήστη και χρονικής περιόδου.';
$string['statsoff'] = 'Τα στατιστικά δεν είναι ενεργοποιημένα';
$string['statsreads'] = 'Προβολές';
$string['statsreport1'] = 'Συνδέσεις';
$string['statsreport10'] = 'Δραστηριότητα χρήστη';
$string['statsreport11'] = 'Περισσότεροι ενεργοί χρήστες';
$string['statsreport12'] = 'Τα πιο δραστήρια μαθήματα (με στάθμιση)';
$string['statsreport13'] = 'Τα μαθήματα με τη μεγαλύτερη συμμετοχή (εγγραφές)';
$string['statsreport14'] = 'Τα μαθήματα με τη μεγαλύτερη συμμετοχή (αναρτήσεις/προβολές)';
$string['statsreport2'] = 'Προβολές (όλοι οι ρόλοι)';
$string['statsreport3'] = 'Posts (όλοι οι ρόλοι)';
$string['statsreport4'] = 'Δραστηριότητα (όλοι οι ρόλοι)';
$string['statsreport5'] = 'Δραστηριότητα (προβολές και μηνύματα)';
$string['statsreport7'] = 'Δραστηριότητα χρηστών (προβολές και μηνύματα)';
$string['statsreport8'] = 'Δραστηριότητα όλων των χρηστών';
$string['statsreport9'] = 'Συνδέσεις';
$string['statsreportactivity'] = 'Όλες οι δραστηριότητες (όλοι οι ρόλοι)';
$string['statsreportactivitybyrole'] = 'Όλες οι δραστηριότητες (προβολές και μηνύματα)';
$string['statsreportforuser'] = 'για';
$string['statsreportlogins'] = 'Συνδέσεις';
$string['statsreportreads'] = 'Προβολές (όλοι οι ρόλοι)';
$string['statsreporttype'] = 'Τύπος αναφοράς';
$string['statsreportwrites'] = 'Αναρτήσεις (όλοι οι ρόλοι)';
$string['statsstudentactivity'] = 'Δραστηριότητα μαθητή';
$string['statsstudentreads'] = 'Προβολές μαθητή';
$string['statsstudentwrites'] = 'Αναρτήσεις μαθητή';
$string['statsteacheractivity'] = 'Δραστηριότητα διδάσκοντα';
$string['statsteacherreads'] = 'Προβολές διδάσκοντα';
$string['statsteacherwrites'] = 'Αναρτήσεις διδάσκοντα';
$string['statstimeperiod'] = 'Χρονική περίοδος';
$string['statsuniquelogins'] = 'Μοναδικές συνδέσεις';
$string['statsuseractivity'] = 'Όλη η δραστηριότητα';
$string['statsuserlogins'] = 'Συνδέσεις';
$string['statsuserreads'] = 'Προβολές';
$string['statsuserwrites'] = 'Αναρτήσεις';
$string['statswrites'] = 'Αναρτήσεις';
$string['status'] = 'Κατάσταση';
$string['statuscritical'] = 'Κρίσιμο';
$string['statuserror'] = 'Σφάλμα';
$string['statusinfo'] = 'Πληροφορίες';
$string['statusna'] = 'Δ/Υ';
$string['statusok'] = 'OK';
$string['statusunknown'] = 'Άγνωστο';
$string['statuswarning'] = 'Προειδοποίηση';
$string['stringsnotset'] = 'Οι ακόλουθες συμβολοσειρές δεν είναι ορισμένες στο {$a}';
$string['studentnotallowed'] = 'Δυστυχώς δεν μπορείτε να εισέλθετε σε αυτό το μάθημα ως «{$a}»';
$string['students'] = 'Μαθητές';
$string['studentsandteachers'] = 'Μαθητές και διδάσκοντες';
$string['subcategories'] = 'Υποκατηγορίες';
$string['subcategory'] = 'Υποκατηγορία';
$string['subcategoryof'] = 'Υποκατηγορία του {$a}';
$string['subject'] = 'Θέμα';
$string['submit'] = 'Υποβολή';
$string['success'] = 'Επιτυχία';
$string['successduration'] = 'Επιτυχία ({$a} δευτερόλεπτα)';
$string['summary'] = 'Περίληψη';
$string['summary_help'] = 'Η ιδέα μιας περίληψης είναι ένα σύντομο κείμενο που προετοιμάζει τους μαθητές για τις δραστηριότητες εντός του θέματος ή της εβδομάδας. Το κείμενο εμφανίζεται στη σελίδα του μαθήματος κάτω από το όνομα της ενότητας.';
$string['summaryof'] = 'Περίληψη από {$a}';
$string['supplyinfo'] = 'Περισσότερες πληροφορίες';
$string['suspended'] = 'Σε αναστολή';
$string['suspendedusers'] = 'Χρήστες σε αναστολή';
$string['switchdevicedefault'] = 'Εναλλαγή στο τυπικό αισθητικό θέμα';
$string['switchdevicerecommended'] = 'Μετάβαση στο συνιστώμενο αισθητικό θέμα για τη συσκευή σας';
$string['switchrolereturn'] = 'Επιστροφή στον κανονικό ρόλο μου';
$string['switchroleto'] = 'Μετάβαση σε ρόλο...';
$string['switchroleto_help'] = 'Επιλέξτε ένα ρόλο για να πάρετε μια ιδέα για το πώς κάποιος με αυτόν τον ρόλο θα δει αυτό το μάθημα.

Παρακαλούμε, λάβετε υπόψη ότι αυτή η προβολή ενδέχεται να μην είναι τέλεια. (<a href="https://docs.moodle.org/en/Switch_roles">Δείτε λεπτομέρειες και εναλλακτικές</a>).';
$string['tag'] = 'Ετικέτα';
$string['tagalready'] = 'Αυτή η ετικέτα υπάρχει ήδη';
$string['tagmanagement'] = 'Προσθέστε/σβήστε ετικέτες';
$string['tags'] = 'Ετικέτες';
$string['targetrole'] = 'Ρόλος στόχος';
$string['teacheronly'] = 'για τον/την {$a} μόνο';
$string['teacherroles'] = '{$a} ρόλοι';
$string['teachers'] = 'Διδάσκοντες';
$string['textcopiedtoclipboard'] = 'Το κείμενο αντιγράφηκε στο πρόχειρο';
$string['textediting'] = 'Επεξεργαστής κειμένου';
$string['textediting_help'] = 'Αν επιλεγεί ένας επεξεργαστής HTML όπως ο Atto ή ο TinyMCE, οι περιοχές καταχώρησης κειμένου θα έχουν μια γραμμή εργαλείων με πλήκτρα εύκολης προσθήκης περιεχομένου. Αν επιλεγεί «Περιοχή εισόδου απλού κειμένου», μπορεί στη συνέχεια να επιλεγεί και ένας μορφότυπος π.χ. HTML, Markdown κ.α. Η λίστα των διαθέσιμων επεξεργαστών κειμένου ορίζεται από τον διαχειριστή του ιστοτόπου.';
$string['texteditor'] = 'Χρήση τυπικών φορμών ιστού';
$string['textellipsis'] = '{$a}...';
$string['textformat'] = 'Μορφή απλού κειμένου';
$string['thanks'] = 'Ευχαριστώ';
$string['theme'] = 'Αισθητικό θέμα';
$string['themes'] = 'Αισθητικά θέματα';
$string['themesaved'] = 'Το νέο αισθητικό θέμα αποθηκεύτηκε';
$string['therearecourses'] = 'Υπάρχουν {$a} μαθήματα';
$string['thereareno'] = 'Δεν υπάρχουν {$a} σε αυτό το μάθημα';
$string['thiscategory'] = 'Αυτή η κατηγορία';
$string['thiscategorycontains'] = 'Αυτή η κατηγορία περιέχει';
$string['time'] = 'Ώρα';
$string['timecreated'] = 'Χρόνος δημιουργίας';
$string['timecreatedcourse'] = 'Ο χρόνος μαθήματος δημιουργήθηκε';
$string['timesplitting:deciles'] = 'Τελευταίο δεκατημόριο';
$string['timesplitting:deciles_help'] = 'Αυτό το διάστημα ανάλυσης διαιρεί το μάθημα σε δέκατα (10 ίσα μέρη), με κάθε πρόβλεψη να βασίζεται στα δεδομένα μόνο του τελευταίου προηγούμενου δεκάτου.';
$string['timesplitting:decilesaccum'] = 'Όλα τα προηγούμενα δεκατημόρια';
$string['timesplitting:decilesaccum_help'] = 'Αυτό το διάστημα ανάλυσης διαιρεί το μάθημα σε δέκατα (10 ίσα μέρη), με κάθε πρόβλεψη να βασίζεται στα αθροιστικά δεδομένα όλων των προηγούμενων δεκάτων.';
$string['timesplitting:nosplitting'] = 'Χωρίς χρονικά όρια';
$string['timesplitting:nosplitting_help'] = 'Δεν έχει οριστεί χρονικό διάστημα για αυτό το μοντέλο.';
$string['timesplitting:onemonthafterstart'] = 'Ένας μήνας μετά την έναρξη';
$string['timesplitting:onemonthafterstart_help'] = 'Αυτό το διάστημα ανάλυσης δημιουργεί μια πρόβλεψη 1 μήνα μετά την αναλυόμενη έναρξη.';
$string['timesplitting:oneweekafterstart'] = 'Μία εβδομάδα μετά την έναρξη';
$string['timesplitting:oneweekafterstart_help'] = 'Αυτό το διάστημα ανάλυσης δημιουργεί μια πρόβλεψη 1 εβδομάδα μετά την αναλυόμενη έναρξη.';
$string['timesplitting:past3days'] = 'Περασμένες 3 ημέρες';
$string['timesplitting:past3days_help'] = 'Αυτό το διάστημα ανάλυσης δημιουργεί προβλέψεις κάθε 3 ημέρες. Οι υπολογισμοί δεικτών θα βασιστούν στις 3 τελευταίες ημέρες.';
$string['timesplitting:pastmonth'] = 'Περασμένος μήνας';
$string['timesplitting:pastmonth_help'] = 'Αυτό το διάστημα ανάλυσης δημιουργεί προβλέψεις κάθε μήνα. Οι υπολογισμοί δεικτών θα βασιστούν στον τελευταίο μήνα.';
$string['timesplitting:pastweek'] = 'Περασμένη εβδομάδα';
$string['timesplitting:pastweek_help'] = 'Αυτό το διάστημα ανάλυσης δημιουργεί προβλέψεις κάθε εβδομάδα. Οι υπολογισμοί δεικτών θα βασιστούν στην τελευταία εβδομάδα.';
$string['timesplitting:quarters'] = 'Τελευταίο τεταρτημόριο';
$string['timesplitting:quarters_help'] = 'Αυτό το χρονικό διάστημα διαιρεί το μάθημα σε τέταρτα (4 ίσα μέρη, τεταρτημόρια), με κάθε πρόβλεψη να βασίζεται στα δεδομένα μόνο του τελευταίου προηγούμενου τετάρτου.';
$string['timesplitting:quartersaccum'] = 'Όλα τα προηγούμενα τεταρτημόρια';
$string['timesplitting:quartersaccum_help'] = 'Αυτό το χρονικό διάστημα διαιρεί το μάθημα σε τέταρτα (4 ίσα μέρη, τεταρτημόρια), με κάθε πρόβλεψη να βασίζεται στα αθροιστικά δεδομένα όλων των προηγούμενων τετάρτων.';
$string['timesplitting:singlerange'] = 'Από την αρχή μέχρι το τέλος';
$string['timesplitting:singlerange_help'] = 'Αυτό το διάστημα ανάλυσης θεωρεί το σύνολο του μαθήματος ως ενιαίο διάστημα.';
$string['timesplitting:tenpercentafterstart'] = '10% μετά την έναρξη';
$string['timesplitting:tenpercentafterstart_help'] = 'Αυτό το διάστημα ανάλυσης παράγει μια πρόβλεψη αφού ολοκληρωθεί το 10% του μαθήματος.';
$string['timesplitting:upcoming3days'] = 'Προσεχές τριήμερο';
$string['timesplitting:upcoming3days_help'] = 'Αυτό το διάστημα ανάλυσης παράγει προβλέψεις κάθε 3 ημέρες. Οι υπολογισμοί των δεικτών θα βασίζονται στο επερχόμενο τριήμερο.';
$string['timesplitting:upcomingfortnight'] = 'Προσεχές δεκαπενθήμερο';
$string['timesplitting:upcomingfortnight_help'] = 'Αυτό το διάστημα ανάλυσης δημιουργεί προβλέψεις κάθε δεκαπενθήμερο. Οι υπολογισμοί των δεικτών θα βασίζονται στο επερχόμενο δεκαπενθήμερο.';
$string['timesplitting:upcomingweek'] = 'Επερχόμενη εβδομάδα';
$string['timesplitting:upcomingweek_help'] = 'Αυτό το διάστημα ανάλυσης δημιουργεί προβλέψεις κάθε εβδομάδα. Οι υπολογισμοί των δεικτών θα βασίζονται στην επερχόμενη εβδομάδα.';
$string['timezone'] = 'Ζώνη ώρας';
$string['to'] = 'Έως';
$string['tocontent'] = 'Έως στοιχείο «{$a}»';
$string['tocreatenewaccount'] = 'Μετάβαση για να δημιουργήσετε νέο λογαριασμό';
$string['today'] = 'Σήμερα';
$string['todaylogs'] = 'Σημερινές καταγραφές';
$string['toeveryone'] = 'στον καθένα';
$string['toggleemojipicker'] = 'Εναλλαγή επιλογέα εμότζι';
$string['togglesearch'] = 'Εναλλαγή εισόδου αναζήτησης';
$string['toomanybounces'] = 'Αυτή η διεύθυνση email έχει υπερβολικά πολλές αποκρούσεις. <b>Πρέπει</b> να την αλλάξετε για να συνεχίσετε.';
$string['toomanytags'] = 'Αυτή η αναζήτηση περιελάμβανε πάρα πολλές ετικέτες· μερικές θα έχουν αγνοηθεί.';
$string['toomanytoshow'] = 'Οι χρήστες είναι πάρα πολλοί για να προβληθούν.';
$string['toomanyusersmatchsearch'] = 'Υπερβολικά πολλοί χρήστες ({$a->count}) ταιριάζουν με «{$a->search}»';
$string['toomanyuserstoshow'] = 'Υπερβολικά πολλοί χρήστες ({$a}) προς εμφάνιση';
$string['toonly'] = 'μόνο στον/στην {$a}';
$string['top'] = 'Πάνω';
$string['topic'] = 'Θέμα';
$string['topichide'] = 'Απόκρυψη του θέματος από {$a}';
$string['topicoutline'] = 'Περιγραφή θέματος';
$string['topicshow'] = 'Εμφάνιση του θέματος στον/στην {$a}';
$string['toplevelcategory'] = 'Κατηγορία ανωτάτου επιπέδου';
$string['total'] = 'Συνολικά';
$string['totopofsection'] = 'Στην κορυφή της ενότητας «{$a}»';
$string['trackforums'] = 'Παρακολούθηση φόρουμ';
$string['trackforumsno'] = 'Όχι: μην παρακολουθείς τις αναρτήσεις που έχω δει';
$string['trackforumsyes'] = 'Ναι: να φωτο-επισημαίνονται οι καινούργιες αναρτήσεις για μένα';
$string['trysearching'] = 'Προσπαθήστε την αναζήτηση';
$string['turneditingoff'] = 'Απενεργοποίηση επεξεργασίας';
$string['turneditingon'] = 'Ενεργοποίηση επεξεργασίας';
$string['unabletocopytoclipboard'] = 'Αδυναμία αντιγραφής κειμένου στο πρόχειρο';
$string['unauthorisedlogin'] = 'Ο λογαριασμός χρήστη «{$a}» δεν είναι διαθέσιμος σε αυτόν τον ιστότοπο';
$string['undecided'] = 'Δεν έχει αποφασιστεί';
$string['unexistingcmid'] = 'Το αναγνωριστικό αρθρώματος μαθήματος δεν βρέθηκε';
$string['unexistingsectionid'] = 'Το αναγνωριστικό ενότητας μαθήματος δεν βρέθηκε';
$string['unfinished'] = 'Όχι ολοκληρωμένο';
$string['unknowncategory'] = 'Άγνωστη κατηγορία';
$string['unknownerror'] = 'Άγνωστο σφάλμα';
$string['unknownuser'] = 'Άγνωστος χρήστης';
$string['unlimited'] = 'Χωρίς περιορισμό';
$string['unpacking'] = 'Αποσυμπίεση του {$a}';
$string['unsafepassword'] = 'Ο κωδικός πρόσβασης δεν είναι ασφαλής - δοκιμάστε κάτι άλλο';
$string['untilcomplete'] = 'Μέχρι την ολοκλήρωση';
$string['unusedaccounts'] = 'Για λογαριασμούς που δεν έχουν χρησιμοποιηθεί για περισσότερο από {$a} ημέρες ακυρώνεται αυτόματα η εγγραφή';
$string['unzip'] = 'Αποσυμπίεση';
$string['unzippingbackup'] = 'Αποσυμπίεση αντιγράφου ασφαλείας';
$string['up'] = 'Πάνω';
$string['update'] = 'Ενημέρωση';
$string['updated'] = '{$a} - τροποποιήθηκε';
$string['updatemymoodleoff'] = 'Διακοπή προσαρμογής αυτής της σελίδας';
$string['updatemymoodleon'] = 'Προσαρμογή αυτής της σελίδας';
$string['updatemyprofile'] = 'Αποθήκευση αλλαγών';
$string['updatesevery'] = 'Ενημέρωση κάθε {$a} δευτερόλεπτα';
$string['updatethis'] = 'Επεξεργασία του/της {$a}';
$string['updatethiscourse'] = 'Επεξεργασία του μαθήματος';
$string['updatinga'] = 'Επεξεργασία: {$a}';
$string['updatingain'] = 'Επεξεργασία: {$a->what} σε {$a->in}';
$string['upload'] = 'Μεταφόρτωση';
$string['uploadafile'] = 'Ανέβασμα ενός αρχείου';
$string['uploadcantwrite'] = 'Αποτυχία εγγραφής του αρχείου στο δίσκο';
$string['uploadedfile'] = 'Το ανέβασμα του αρχείου έγινε με επιτυχία';
$string['uploadedfileto'] = 'Το αρχείο {$a->file} ανέβηκε στον φάκελο {$a->directory}';
$string['uploadedfiletoobig'] = 'Το μέγεθος του αρχείου που προσπαθείτε να στείλετε είναι μεγαλύτερο από το επιτρεπόμενο (το όριο είναι {$a} bytes)';
$string['uploadextension'] = 'Το ανέβασμα του αρχείου σταμάτησε λόγω μιας επέκτασης PHP';
$string['uploadfailednotrecovering'] = 'Το ανέβασμα του αρχείου σας απέτυχε γιατί εντοπίστηκε σφάλμα με ένα από τα αρχεία, {$a->name}.<br />Εδώ είναι μια καταγραφή των προβλημάτων:<br />{$a->problem}<br />Δεν ανακτήθηκε.';
$string['uploadfilelog'] = 'Αρχείο καταγραφής ανεβάσματος του αρχείου {$a}';
$string['uploadformlimit'] = 'Το μέγεθος του αρχείου {$a} που ανεβάζετε ξεπέρασε το μέγιστο όριο μεγέθους που ορίστηκε από τη φόρμα';
$string['uploadlabel'] = 'Τίτλος:';
$string['uploadlimitwithsize'] = '{$a->displaysize} Όριο ανεβάσματος πλαισίου «{$a->contextname}»';
$string['uploadnewfile'] = 'Ανεβάστε νέο αρχείο';
$string['uploadnofilefound'] = 'Κανένα αρχείο δε βρέθηκε - είστε σίγουροι πως επιλέξατε κάποιο για αποστολή;';
$string['uploadnotallowed'] = 'Δεν επιτρέπεται η αποστολή αρχείων';
$string['uploadnotempdir'] = 'Λείπει προσωρινός φάκελος';
$string['uploadoldfilesdeleted'] = 'Τα παλιά σας αρχεία στην περιοχή ανεβάσματος έχουν διαγραφεί';
$string['uploadpartialfile'] = 'Το ανέβασμα του αρχείου δεν ολοκληρώθηκε';
$string['uploadproblem'] = 'Παρουσιάστηκε ένα άγνωστο σφάλμα κατά τη αποστολή του αρχείου «{$a}» (ίσως ήταν πολύ μεγάλο;)';
$string['uploadrenamedchars'] = 'Το αρχείο μετονομάστηκε από {$a->oldname} σε {$a->newname} λόγω ύπαρξης μη επιτρεπόμενων χαρακτήρων';
$string['uploadrenamedcollision'] = 'Το αρχείο μετονομάστηκε από {$a->oldname} σε {$a->newname} λόγω ενός προβλήματος που σχετίζεται με την ονομασία του';
$string['uploadserverlimit'] = 'Το μέγεθος του αρχείου που προσπαθείτε να ανεβάσετε είναι μεγαλύτερο από το επιτρεπόμενο για αυτόν τον εξυπηρετητή';
$string['uploadthisfile'] = 'Ανέβασμα αυτού του αρχείου (όνομα με λατινικούς χαρακτήρες)';
$string['url'] = 'Διεύθυνση URL';
$string['used'] = 'Χρησιμοποιημένο';
$string['usedinnplaces'] = 'Χρησιμοποιείται σε {$a} σημεία';
$string['user'] = 'Χρήστης';
$string['useraccount'] = 'Λογαριασμός χρήστη';
$string['useractivity'] = 'Δραστηριότητα';
$string['userconfirmed'] = 'Έγινε επιβεβαίωση του χρήστη {$a}';
$string['userdata'] = 'Δεδομένα χρήστη';
$string['userdeleted'] = 'Αυτός ο λογαριασμός χρήστη έχει διαγραφεί';
$string['userdescription'] = 'Περιγραφή';
$string['userdescription_help'] = 'Το πλαίσιο σας επιτρέπει να εισάγετε κάποιο κείμενο για τον εαυτό σας το οποίο έπειτα θα εμφανίζεται στη σελίδα του προφίλ σας για να το βλέπουν οι άλλοι.';
$string['userdetails'] = 'Λεπτομέρειες χρήστη';
$string['userfiles'] = 'Αρχεία χρήστη';
$string['userlist'] = 'Λίστα χρηστών';
$string['usermenu'] = 'Μενού Χρήστη';
$string['usermenugoback'] = 'Επιστρέψτε στο μενού χρήστη';
$string['username'] = 'Όνομα χρήστη';
$string['usernameemail'] = 'Όνομα χρήστη ή e-mail';
$string['usernameemailmatch'] = 'Το όνομα χρήστη και το email δεν σχετίζονται με τον ίδιο χρήστη';
$string['usernameexists'] = 'Αυτό το όνομα χρήστη υπάρχει ήδη. Παρακαλούμε επιλέξτε άλλο.';
$string['usernamelowercase'] = 'Επιτρέπονται μόνο πεζοί χαρακτήρες';
$string['usernamenotfound'] = 'Αδυναμία εύρεσης ονόματος χρήστη στη βάση δεδομένων';
$string['usernameoremail'] = 'Εισαγάγετε όνομα χρήστη ή διεύθυνση email';
$string['usernotconfirmed'] = 'Δεν ήταν δυνατή η επιβεβαίωση του χρήστη {$a}';
$string['userpic'] = 'Εικόνα χρήστη';
$string['userpreferences'] = 'Προτιμήσεις χρηστών';
$string['users'] = 'Χρήστες';
$string['userselectorautoselectunique'] = 'Εάν μόνο ένας χρήστης ταιριάζει στην αναζήτηση, επίλεξέ τον αυτόματα';
$string['userselectorpreserveselected'] = 'Διατήρηση επιλεγμένων χρηστών, ακόμη κι αν δεν ταιριάζουν στην αναζήτηση';
$string['userselectorsearchanywhere'] = 'Ταίριασμα των κριτηρίων αναζήτησης οπουδήποτε μέσα στα εμφανιζόμενα πεδία';
$string['usersnew'] = 'Νέοι χρήστες';
$string['usersnoaccesssince'] = 'Καμία σύνδεση για περισσότερο από';
$string['userswithfiles'] = 'Χρήστες με αρχεία';
$string['useruploadtype'] = 'Τύπος ανεβάσματος χρήστη : {$a}';
$string['userzones'] = 'Ζώνες χρηστών';
$string['usetheme'] = 'Χρήση αυτού του θέματος';
$string['usingexistingcourse'] = 'Χρήση υπάρχοντος μαθήματος';
$string['validatehtml'] = 'Επικύρωση HTML';
$string['valuealreadyused'] = 'Αυτή η τιμή έχει χρησιμοποιηθεί ήδη.';
$string['version'] = 'Έκδοση';
$string['view'] = 'Προβολή';
$string['viewallcourses'] = 'Εμφάνιση όλων των μαθημάτων';
$string['viewallcoursescategories'] = 'Εμφάνιση όλων των μαθημάτων και κατηγοριών';
$string['viewallsubcategories'] = 'Δείτε όλες τις υποκατηγορίες';
$string['viewfileinpopup'] = 'Εμφάνιση αρχείου σε αναδυόμενο παράθυρο';
$string['viewing'] = 'Προβολή:';
$string['viewmore'] = 'Δείτε περισσότερα';
$string['viewprofile'] = 'Επισκόπηση του προφίλ';
$string['views'] = 'Προβολές';
$string['viewsolution'] = 'προβολή της λύσης';
$string['visible'] = 'Ορατό';
$string['visible_help'] = 'Αυτή η ρύθμιση καθορίζει εάν το μάθημα εμφανίζεται στη λίστα των μαθημάτων. Εκτός από διδάσκοντες και διαχειριστές, οι χρήστες δεν θα επιτρέπεται να μπαίνουν στο μάθημα.';
$string['visibletostudents'] = 'Ορατό στον/στην {$a}';
$string['warning'] = 'Προειδοποίηση';
$string['warningdeleteresource'] = 'Προσοχή: {$a} αναφέρεται σε μια πηγή. Θα θέλατε να ενημερώσετε την πηγή;';
$string['wcagcheck'] = 'Έλεγχος Web Content Accessibility Guidelines (WCAG)';
$string['webpage'] = 'Ιστο-σελίδα';
$string['week'] = 'Εβδομάδα';
$string['weekhide'] = 'Απόκρυψη αυτής της εβδομάδας από τον/την «{$a}»';
$string['weeklyoutline'] = 'Περιγραφή εβδομάδας';
$string['weeks'] = 'εβδομάδες';
$string['weekshow'] = 'Εμφάνιση της εβδομάδας στον/στην {$a}';
$string['welcomeback'] = 'Καλώς ορίσατε πάλι, {$a->firstname}! 👋';
$string['welcometocourse'] = 'Καλώς ορίσατε στο {$a}';
$string['welcometocoursetext'] = 'Καλώς ορίσατε στο {$a->coursename}!

Ένα από τα πρώτα πράγματα που θα πρέπει να κάνετε είναι να επεξεργαστείτε τη σελίδα του προφίλ σας ώστε να μάθουμε περισσότερα για εσάς:

  {$a->profileurl}';
$string['welcometosite'] = 'Καλώς ορίσατε, {$a->firstname}! 👋';
$string['whatforlink'] = 'Τι θέλετε να κάνετε με τον σύνδεσμο ;';
$string['whatforpage'] = 'Τι θέλετε να κάνετε με το κείμενο ;';
$string['whatisyourage'] = 'Ποιά είναι η ηλικία σας;';
$string['whattocallzip'] = 'Όνομα συμπιεσμένου αρχείου';
$string['whattodo'] = 'Ενέργειες';
$string['wheredoyoulive'] = 'Σε ποιά χώρα ζείτε;';
$string['whyisthisrequired'] = 'Γιατί απαιτούνται αυτά;';
$string['windowclosing'] = 'Αυτό το παράθυρο θα πρέπει να κλείσει αυτόματα. Σε αντίθετη περίπτωση, παρακαλούμε κλείστε το τώρα.';
$string['withchosenfiles'] = 'Με τα επιλεγμένα αρχεία';
$string['withdisablednote'] = '{$a} (ανενεργό)';
$string['withoutuserdata'] = 'χωρίς τα δεδομένα του χρήστη';
$string['withselectedusers'] = 'Με τους επιλεγμένους χρήστες...';
$string['withuserdata'] = 'με τα δεδομένα του χρήστη';
$string['wordforstudent'] = 'Η λέξη σας για Μαθητής';
$string['wordforstudenteg'] = 'π.χ. Μαθητής, Συμμετέχων κτλ.';
$string['wordforstudents'] = 'Η λέξη σας για Μαθητές';
$string['wordforstudentseg'] = 'π.χ. Μαθητές, Συμμετέχοντες, κτλ.';
$string['wordforteacher'] = 'Η λέξη σας για Διδάσκων';
$string['wordforteachereg'] = 'π.χ. Διδάσκων, Εκπαιδευτικός, Συντονιστής, Εκπαιδευτής, Δάσκαλος, Καθηγητής, Φροντιστής, Προσωπικός Εκπαιδευτικός κτλ';
$string['wordforteachers'] = 'Η λέξη σας για Διδάσκοντες';
$string['wordforteacherseg'] = 'π.χ. Διδάσκοντες, Εκπαιδευτικοί, Συντονιστές, Εκπαιδευτές, Δάσκαλοι, Καθηγητές, Φροντιστές, Προσωπικοί Εκπαιδευτικοί κτλ';
$string['writingblogsinfo'] = 'Εγγραφή πληροφοριών ιστολογίου';
$string['writingcategoriesandquestions'] = 'Εγγραφή κατηγοριών και ερωτήσεων';
$string['writingcoursedata'] = 'Εγγραφή δεδομένων μαθήματος';
$string['writingeventsinfo'] = 'Εγγραφή πληροφοριών γεγονότων';
$string['writinggeneralinfo'] = 'Εγγραφή γενικών πληροφοριών';
$string['writinggradebookinfo'] = 'Εγγραφή πληροφοριών βαθμολογίου';
$string['writinggroupingsgroupsinfo'] = 'Εγγραφή πληροφοριών ομαδοποιήσεων-ομάδων';
$string['writinggroupingsinfo'] = 'Εγγραφή πληροφοριών ομαδοποιήσεων';
$string['writinggroupsinfo'] = 'Εγγραφή πληροφοριών ομάδων';
$string['writingheader'] = 'Εγγραφή επικεφαλίδας';
$string['writingloginfo'] = 'Εγγραφή πληροφοριών καταγραφών';
$string['writingmessagesinfo'] = 'Εγγραφή πληροφοριών μηνυμάτων';
$string['writingmoduleinfo'] = 'Εγγραφή πληροφοριών αρθρωμάτων';
$string['writingscalesinfo'] = 'Εγγραφή πληροφοριών κλίμακας';
$string['writinguserinfo'] = 'Εγγραφές πληροφοριών χρηστών';
$string['wrongpassword'] = 'Λάθος κωδικός πρόσβασης για αυτό το όνομα χρήστη';
$string['yahooid'] = 'Αναγνωριστικό  Yahoo';
$string['year'] = 'έτος';
$string['years'] = 'έτη';
$string['yes'] = 'Ναι';
$string['youareabouttocreatezip'] = 'Πρόκειται να δημιουργήσετε ένα συμπιεσμένο αρχείο, το οποίο θα περιέχει';
$string['youaregoingtorestorefrom'] = 'Θα ξεκινήσετε τη διαδικασία επαναφοράς για';
$string['youhaveupcomingactivitiesdue'] = 'Υπάρχουν επερχόμενες λήξεις δραστηριοτήτων σας';
$string['youhaveupcomingactivitiesdueinfo'] = 'Γεια σας {$a},

<br/><br/>Έχετε επερχόμενες λήξεις οφειλόμενων δραστηριοτήτων:';
$string['youneedtoenrol'] = 'Για να εκτελέσετε αυτή την ενέργεια θα πρέπει να εγγραφείτε στο μάθημα.';
$string['yourlastlogin'] = 'Η τελευταία σας σύνδεση ήταν';
$string['yourself'] = 'εσείς ο ίδιος';
$string['yourteacher'] = 'η/ο {$a} σας';
$string['yourwordforx'] = 'Ο όρος σας για «{$a}»';
$string['zippingbackup'] = 'Συμπίεση αντιγράφου ασφαλείας';
