<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'quiz', language 'id', version '4.1'.
 *
 * @package     quiz
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessnoticesheader'] = 'Anda dapat melakukan pratinjau kuis ini, tetapi jika kuis yang sebenarnya, Anda akan diblokir karena:';
$string['action'] = 'Aksi';
$string['activityoverview'] = 'Anda memiliki kuis yang hampir jatuh tempo';
$string['adaptive'] = 'Mode adaptif';
$string['adaptive_help'] = 'Jika diaktifkan, beberapa jawaban pada soal diizinkan pada pengerjaan kuis. Jadi misalnya jika jawaban salah, siswa akan diizinkan untuk mencoba kembali dengan segera. Namun, tergantung pada setelan "Terapkan penalti", penalti biasanya akan dikurangkan untuk setiap pengerjaan yang salah.';
$string['add'] = 'Tambah';
$string['addaquestion'] = 'soal baru';
$string['addarandomquestion'] = 'soal acak';
$string['addarandomquestion_help'] = 'Ketika menambahkan soal acak, hasilnya akan dipilih secara acak dari kategori yang dimasukkan dalam kuis. Artinya bahwa setiap siswa mengerjakan akan menerima soal yang berbeda. Bagitu pula pada saat siswa mengerjakan kembali di kesempatan berikutnya.';
$string['addarandomselectedquestion'] = 'Tambahkan soal acak terpilih';
$string['addasection'] = 'Tambahkan tajuk bagian';
$string['adddescriptionlabel'] = 'Tambahkah deskripsi item';
$string['addingquestion'] = 'Tambahkan soal';
$string['addingquestions'] = 'Bagian dari halaman ini adalah tempat di mana Anda mengatur basis data soal Anda. Soal disimpan di dalam kategori untuk membantu Anda mengorganisirnya, dan dapat digunakan pada kuis apapun di dalam kursus Anda atau bahkan kursus yang lain jika Anda memilih untuk mempublikasikannya.<br /><br />Setelah Anda memilih atau membuat suatu kategori, Anda akan dapat membuat atau mengedit soal. Anda dapat memilih yang mana pun dari soal ini untuk ditambahkan pada kuis di bagian lain dari halaman ini.';
$string['addmoreoverallfeedbacks'] = 'Tambahkan {no} ruas umpan balik';
$string['addnewgroupoverride'] = 'Tambahkan penyampingan grup';
$string['addnewpagesafterselected'] = 'Tambahkan halaman baru setelah soal terpilih';
$string['addnewquestionsqbank'] = 'Tambahkan soal pada kategori {$a->catname}: {$a->link}';
$string['addnewuseroverride'] = 'Tambahkan penyampingan pengguna';
$string['addpagebreak'] = 'Tambahkan pembatas halaman';
$string['addpagehere'] = 'Tambahkan halaman di sini';
$string['addquestion'] = 'Tambahkan soal';
$string['addquestionfrombankatend'] = 'Tambahkan dari bank soal di akhir';
$string['addquestionfrombanktopage'] = 'Tambahkan dari bank soal pada halaman {$a}';
$string['addquestions'] = 'Tambahkan soal';
$string['addquestionstoquiz'] = 'Tambahkan soal ke kuis ini';
$string['addrandom'] = 'Tambahkan {$a} soal acak';
$string['addrandom1'] = '<< Tambahkan';
$string['addrandom2'] = 'soal acak';
$string['addrandomfromcategory'] = 'Tambahkan soal acak dari kategori:';
$string['addrandomquestion'] = 'Tambahkan soal acak';
$string['addrandomquestionatend'] = 'Tambahkan soal acak di akhir';
$string['addrandomquestiontopage'] = 'Tambahkan soal acak pada halaman {$a}';
$string['addrandomquestiontoquiz'] = 'Tambahkan soal acak pada kuis {$a}';
$string['addselectedquestionstoquiz'] = 'Tambahkan soal terpilih pada kuis';
$string['addselectedtoquiz'] = 'Tambahkan yang terpilih ke kuis';
$string['addtoquiz'] = 'Tambahkan ke kuis';
$string['affectedstudents'] = 'Terdampak {$a}';
$string['aftereachquestion'] = 'Setelah menambahkan setiap soal';
$string['afternquestions'] = 'Setelah menambahkan {$a} soal';
$string['age'] = 'usia';
$string['allattempts'] = 'Semua upaya mengerjakan';
$string['allinone'] = 'Tak terbatas';
$string['allowreview'] = 'Izinkan reviu';
$string['alreadysubmitted'] = 'Kemungkinan Anda telah mengerjakan kuis ini';
$string['alternativeunits'] = 'Unit alternatif';
$string['alwaysavailable'] = 'Selalu ada';
$string['alwayslatest'] = 'Selalu terbaru';
$string['analysisoptions'] = 'Opsi analisis';
$string['analysistitle'] = 'Tabel item analisis';
$string['answer'] = 'Jawab';
$string['answered'] = 'Dijawab';
$string['answerhowmany'] = 'Satu atau beberapa jawaban?';
$string['answers'] = 'Jawaban';
$string['answersingleno'] = 'Beberapa jawaban diizinkan';
$string['answersingleyes'] = 'Hanya satu jawaban';
$string['answertoolong'] = 'Jawaban terlalu panjang setelah baris {$a} (maks. 255 karakter)';
$string['anytags'] = 'Label apa pun';
$string['aon'] = 'Format AON';
$string['areyousureremoveselected'] = 'Anda yakin ingin menghapus semua soal terpilih?';
$string['asshownoneditscreen'] = 'Seperti terlihat pada layar edit';
$string['attempt'] = 'Pengerjaan {$a}';
$string['attemptalreadyclosed'] = 'Telah dikerjakan.';
$string['attemptclosed'] = 'Waktu pengerjaan belum ditutup';
$string['attemptduration'] = 'Waktu mengerjakan';
$string['attemptedon'] = 'Dikerjakan pada';
$string['attempterror'] = 'Anda tidak diizinkan mengerjakan kuis sekarang karena: {$a}';
$string['attempterrorcontentchange'] = 'Pratinjau kuis ini tidak ada lagi. (Ketika kuis diedit, pratinjau yang sedang berlangsung akan dihapus secara otomatis.)';
$string['attempterrorcontentchangeforuser'] = 'Hasil pengerjaan kuis ini tidak ada lagi.';
$string['attempterrorinvalid'] = 'ID Pengerjaan kuis tidak valid';
$string['attemptfirst'] = 'Pengerjaan pertama';
$string['attemptgradeddelay'] = 'Coba penundaan notifikasi bertingkat';
$string['attemptgradeddelay_desc'] = 'Penundaan diterapkan sebelum mengirim pemberitahuan upaya penilaian untuk memberikan waktu bagi pengajar untuk mengedit nilai.';
$string['attemptincomplete'] = 'Pengerjaan kuis (oleh {$a}) belum selesai.';
$string['attemptlast'] = 'Pengerjaan terakhir';
$string['attemptnumber'] = 'Pengerjaan kuis';
$string['attemptquiz'] = 'Kerjakan kuis';
$string['attemptquiznow'] = 'Kerjakan kuis sekarang';
$string['attemptreviewtitle'] = '{$a}: Reviu pengerjaan kuis';
$string['attemptreviewtitlepaged'] = '{$a->name}: Reviu pengerjaan kuis (halaman {$a->currentpage} dari {$a->totalpages})';
$string['attempts'] = 'Pengerjaan kuis';
$string['attempts_help'] = 'Jumlah total pengerjaan yang diperbolehkan (bukan jumlah pengerjaan ekstra).';
$string['attemptsallowed'] = 'Diizinkan mengerjakan';
$string['attemptsdeleted'] = 'Hasil pengerjaan kuis dihapus';
$string['attemptselection'] = 'Pilih hasil pengerjaan kuis mana yang akan dianalisis per pengguna:';
$string['attemptsexist'] = 'Anda tidak dapat lagi menambah atau menghapus soal.';
$string['attemptsnum'] = 'Yang telah mengerjakan: {$a} orang';
$string['attemptsnumthisgroup'] = 'Siswa yang mengerjakan: {$a->total} ({$a->group} dari grup ini)';
$string['attemptsnumyourgroups'] = 'Jumlah yang mengerjakan: {$a->total} ({$a->group} dari grup Anda)';
$string['attemptsonly'] = 'Tampilkan hanya siswa yang mengerjakan';
$string['attemptstate'] = 'Status';
$string['attemptstillinprogress'] = 'Masih mengerjakan';
$string['attemptsummarytitle'] = '{$a}: Ringkasan hasil pengerjaan kuis';
$string['attemptsunlimited'] = 'Pengerjaan kuis tidak dibatasi';
$string['attempttitle'] = '{$a}';
$string['attempttitlepaged'] = '{$a->name} (page {$a->currentpage} of {$a->totalpages})';
$string['autosaveperiod'] = 'Jeda penyimpanan otomatis';
$string['autosaveperiod_desc'] = 'Jawaban disimpan secara otomatis ketika mengerjakan kuis. Jawaban tersimpan setiap kali ada perubahan,  dan kemudian setelah penundaan ini. Ada pertukaran: penundaan yang lebih singkat meningkatkan beban server, tetapi mengurangi kemungkinan siswa kehilangan pekerjaan mereka. Jika Anda ingin membuat penundaan ini lebih pendek, Anda harus mengubah nilainya secara bertahap dan memonitor beban server. Jika beban terlalu tinggi, buat penundaan lebih lama lagi. Mengatur penundaan ke 0 mematikan penyimpanan otomatis.';
$string['back'] = 'Kembali ke soal pratinjau';
$string['backtocourse'] = 'Kembali ke kursus';
$string['backtoquestionlist'] = 'Kembali ke daftar soal';
$string['backtoquiz'] = 'Kembali mengedit kuis';
$string['basicideasofquiz'] = 'Ide dasar pembuatan kuis';
$string['bestgrade'] = 'Nilai terbaik';
$string['bothattempts'] = 'Tampilkan siswa yang sudah mengerjakan atau pun belum';
$string['browsersecurity'] = 'Keamanan peramban web';
$string['browsersecurity_help'] = 'Jika "Layar penuh sembulan dengan beberapa keamanan JavaScript" dipilih, * Kuis hanya akan dimulai jika siswa memiliki peramban web yang mengaktifkan JavaScript * Kuis muncul di jendela sembulan layar penuh yang mencakup semua jendela lain dan memiliki tidak ada kontrol navigasi * Sedapat mungkin siswa dilarang menggunakan fasilitas seperti salin dan tempel';
$string['cachedef_overrides'] = 'Informasi penyampingan pengguna dan grup';
$string['calculated'] = 'Perhitungan';
$string['calculatedquestion'] = 'Soal perhitungan pada baris {$a} tidak didukung. Soal akan diabaikan';
$string['cannotcreatepath'] = 'Jalur tidak dapat dibuat ({$a})';
$string['cannoteditafterattempts'] = 'Anda tidak dapat menambah atau menghapus soal yang telah dikerjakan ({$a})';
$string['cannotfindprevattempt'] = 'Hasil pengerjaan kuis sebelumnya tidak ditemukan.';
$string['cannotfindquestionregard'] = 'Gagal mendapatkan soal untuk dinilai ulang!';
$string['cannotinsert'] = 'Tidak dapat menyisipkan soal';
$string['cannotinsertrandomquestion'] = 'Tidak dapat memasukkan soal acak';
$string['cannotloadquestion'] = 'Tidak dapat memuat opsi soal';
$string['cannotloadtypeinfo'] = 'Tidak dapat memuat informasi khusus mengenai jenis soal';
$string['cannotopen'] = 'Tidak dapat membuka berkas ekspor ({$a})';
$string['cannotremoveallsectionslots'] = 'Anda telah memilih semua soal di bawah judul bagian \'{$a}\'. Tidak diperbolehkan untuk menghapus semua soal di bawah judul bagian.';
$string['cannotremoveslots'] = 'Tidak dapat menghapus soal';
$string['cannotrestore'] = 'Tidak dapat memulihkan sesi soal';
$string['cannotreviewopen'] = 'Anda tidak dapat mereviu pengerjaan kuis ini karena masih dikerjakan.';
$string['cannotsavelayout'] = 'Tidak dapat menyimpan tata letak';
$string['cannotsavenumberofquestion'] = 'Tidak dapat menyimpan jumlah soal per halaman';
$string['cannotsavequestion'] = 'Tidak dapat menyimpan daftar soal';
$string['cannotsetgrade'] = 'Tidak dapat menyetel nilai maksimum baru untuk kuis';
$string['cannotsetsumgrades'] = 'gagal untuk menyetel jumlah';
$string['cannotstartgradesmismatch'] = 'Tidak dapat mulai mengerjakan kuis ini. Kuis disetel untuk dinilai dari {$a->grade}, tetapi tidak ada soal dalam kuis yang memiliki nilai. Ini dapat diperbaiki pada halaman \'Edit kuis\'.';
$string['cannotstartmissingquestion'] = 'Tidak dapat mulai mengerjakan kuis ini. Definisi kuis mencakup soal yang tidak ada.';
$string['cannotstartnoquestions'] = 'Tidak dapat mulai mengerjakan kuis ini. Kuis belum disiapkan. Belum ada soal.';
$string['cannotwrite'] = 'Tidak dapat menulis untuk mengekspor berkas ({$a})';
$string['canredoquestions'] = 'Izinkan mengulang ketika mengerjakan';
$string['canredoquestions_desc'] = 'Jika diaktifkan, setelah selesai mengerjakan soal, tombol \'Coba soal lain seperti ini\' akan ditampilkan. Hal ini memungkinkan soal serupa (dipilih secara acak) mengerjakan kembali soal tanpa harus mengawali dari awal kuis. Opsi ini berguna untuk latihan kuis. Setelan ini hanya memengaruhi soal dan perilaku (seperti umpan balik langsung atau interaktif dengan beberapa upaya pengerjaan kuis) di mana dimungkinkan untuk menyelesaikan soal sebelum hasil pengerjaan kuis diserahkan.';
$string['canredoquestions_help'] = 'Jika diaktifkan, setelah selesai mengerjakan soal, tombol \'Coba soal lain seperti ini\' akan ditampilkan. Hal ini memungkinkan soal serupa (dipilih secara acak) mengerjakan kembali soal tanpa harus mengawali dari awal kuis. Opsi ini berguna untuk latihan kuis. Setelan ini hanya memengaruhi soal dan perilaku (seperti umpan balik langsung atau interaktif dengan beberapa upaya pengerjaan kuis) di mana dimungkinkan untuk menyelesaikan soal sebelum hasil pengerjaan kuis diserahkan.';
$string['canredoquestionsyes'] = 'Ya, berikan opsi untuk mencoba soal lain';
$string['caseno'] = 'Tidak, huruf besar/kecil tidak masalah';
$string['casesensitive'] = 'Penulisan huruf besar/kecil berpengaruh';
$string['caseyes'] = 'Ya, huruf besar/kecil harus cocok';
$string['categoryadded'] = 'Kategori \'{$a}\' telah ditambahkan';
$string['categorydeleted'] = 'Kategori \'{$a}\' telah dihapus';
$string['categorynoedit'] = 'Anda tidak memiliki hak mengedit kategori \'{$a}\'.';
$string['categoryupdated'] = 'Kategori berhasil diperbarui';
$string['close'] = 'Tutup jendela';
$string['closebeforeopen'] = 'Tidak dapat memperbarui kuis. Anda telah menentukan tanggal tutup sebelum tanggal buka.';
$string['closed'] = 'Ditutup';
$string['closepreview'] = 'Tutup pratinjau';
$string['closereview'] = 'Tutup reviu';
$string['comment'] = 'Komentar';
$string['commentorgrade'] = 'Beri komentar atau beri nilai';
$string['comments'] = 'Komentar';
$string['completedon'] = 'Selesai pada';
$string['completionattemptsexhausted'] = 'Atau kesempatan mengerjakan selesai.';
$string['completionattemptsexhausted_help'] = 'Tandai siswa selesai ketika siswa kehabisan kesempatan mengerjakan kuis.';
$string['completionattemptsexhausteddesc'] = 'Selesaikan jika kesempatan mengerjakan habis.';
$string['completiondetail:minattempts'] = 'Kerjakan kuis: {$a}';
$string['completiondetail:passgrade'] = 'Dapatkan nilai kelulusan';
$string['completiondetail:passorexhaust'] = 'Terima nilai kelulusan atau kerjakan semua kuis yang tersedia';
$string['completionminattempts'] = 'Pengerjaan kuis minimum:';
$string['completionminattemptsdesc'] = 'Pengerjaan kuis minimum yang harus dilakukan: {$a}';
$string['completionminattemptserror'] = 'Jumlah pengerjaan kuis tidak boleh lebih dari atau sama dengan kesempatan yang diberikan.';
$string['completionminattemptsgroup'] = 'Harus dikerjakan';
$string['completionpass'] = 'Memerlukan nilai kelulusan';
$string['completionpass_help'] = 'Jika diaktifkan, aktivitas ini dianggap selesai saat siswa menerima nilai kelulusan (sebagaimana ditentukan di bagian Nilai pada pengaturan kuis) atau lebih tinggi.';
$string['completionpassdesc'] = 'Siswa harus mencapai nilai kelulusan untuk menyelesaikan aktivitas ini';
$string['completionpassorattemptsexhausteddesc'] = 'Siswa harus mencapai nilai kelulusan, atau habiskan kesempatan mengerjakan kuis agar aktivitas ini selesai';
$string['configadaptive'] = 'Jika Anda memilih Ya untuk opsi ini, maka siswa akan menjawab soal berkali-kali dalam satu pengerjaan kuis yang sama.';
$string['configattemptsallowed'] = 'Pembatasan jumlah pengerjaan kuis.';
$string['configdecimaldigits'] = 'Jumlah digit yang harus ditampilkan setelah titik desimal saat menampilkan nilai.';
$string['configdecimalplaces'] = 'Jumlah digit yang harus ditampilkan setelah titik desimal saat menampilkan nilai kuis.';
$string['configdecimalplacesquestion'] = 'Jumlah digit yang harus ditampilkan setelah titik desimal saat menampilkan poin untuk pertanyaan individual.';
$string['configdelay1'] = 'Jika Anda menyetel waktu tunda, maka siswa harus menunggu jeda waktu untuk mengerjakan kuis kembali setelah pengerjaan pertama.';
$string['configdelay1st2nd'] = 'Jika Anda menyetel waktu tunda di sini, siswa tidak dapat mulai mengerjakan kuis kudua kalinya sebelum waktu pengerjaan kuis pertama mereka selesai.';
$string['configdelay2'] = 'Jika Anda menyetel waktu tunda di sini, maka seorang siswa harus menunggu waktu tersebut sebelum mereka dapat mengerjakan kuis ketiga kalinya dan selanjutnya.';
$string['configdelaylater'] = 'Jika Anda menyetel waktu tunda di sini, siswa tidak dapat mulai mengerjakan kuis ketiga, keempat, ... sampai waktu sebanyak ini telah berlalu sejak akhir pengerjaan kuis sebelumnya.';
$string['configeachattemptbuildsonthelast'] = 'Jika diizinkan mengerjakan berkali-kali, setiap mulai mengerjakan kuis baru aakn berisi hasil dari pengerjaan kuis sebelumnya.';
$string['configgrademethod'] = 'Jika diizinkan mengerjakan berkali-kali, metode mana yang harus digunakan untuk menghitung nilai akhir siswa untuk kuis tersebut.';
$string['configintro'] = 'Nilai yang Anda atur di sini menentukan nilai bawaan yang digunakan dalam formulir setelan saat Anda membuat kuis baru. Anda juga dapat mengonfigurasi setelan kuis mana yang dianggap lanjutan.';
$string['configmaximumgrade'] = 'Nilai bawaan di mana nilai kuis diskalakan.';
$string['confignavmethod'] = 'Dalam navigasi bebas, soal dapat dijawab dalam urutan apa pun menggunakan navigasi. Dalam Sekuensial, soal harus dijawab dalam urutan yang ketat.';
$string['confignewpageevery'] = 'Saat menambahkan soal ke jeda halaman kuis akan secara otomatis dimasukkan sesuai dengan setelan yang Anda pilih di sini.';
$string['configoutcomesadvanced'] = 'Jika opsi ini diaktifkan, capaian formulir pengeditan kuis adalah setelan tingkat lanjut.';
$string['configpenaltyscheme'] = 'Penalti akan mengurangi untuk setiap jawaban yang salah dalam mode adaptif.';
$string['configpopup'] = 'Paksa siswa untuk mengerjakan di di jendela sembulan, dan gunakan trik JavaScript untuk mencoba membatasi salin dan tempel, dll. selama mengerjakan kuis.';
$string['configrequirepassword'] = 'Siswa harus memasukkan kata sandi ini sebelum mereka dapat mengerjakan kuis.';
$string['configrequiresubnet'] = 'Siswa hanya dapat mengerjakan kuis dari komputer ini.';
$string['configreviewoptions'] = 'Opsi ini mengontrol informasi apa yang dapat dilihat pengguna saat mereka mereviu pengerjaan atau melihat laporan kuis.';
$string['configshowblocks'] = 'Tampilkan blok selama mengerjakan kuis.';
$string['configshowuserpicture'] = 'Tampilkan gambar pengguna di layar selama mengerjakan.';
$string['configshufflewithin'] = 'Jika Anda mengaktifkan opsi ini, maka bagian yang membentuk soal individual akan secara acak dikocok setiap kali seorang siswa mengerjakan kuis ini, asalkan opsi tersebut juga diaktifkan dalam setelan soal.';
$string['configtimelimit'] = 'Batas waktu bawaan untuk kuis dalam hitungan menit. 0 berarti tidak ada batas waktu.';
$string['configtimelimitsec'] = 'Batas waktu bawaan untuk kuis dalam hitungan detik. 0 berarti tidak ada batas waktu.';
$string['configurerandomquestion'] = 'Konfigurasi soal';
$string['confirmclose'] = 'Setelah mengirimkan jawaban, Anda tidak akan dapat mengubahnya.';
$string['confirmremovequestion'] = 'Anda yakin ingin menghapus soal {$a} ini?';
$string['confirmremovesectionheading'] = 'Yakin ingin menghapus judul bagian \'{$a}\'?';
$string['confirmserverdelete'] = 'Yakin ingin menghapus server <b>{$a}</b> dari daftar?';
$string['connectionerror'] = 'Koneksi jaringan terputus. (Penyimpanan otomatis gagal). Catat setiap tanggapan yang dimasukkan di halaman ini dalam beberapa menit terakhir, lalu coba sambungkan kembali. Setelah koneksi terjalin kembali, jawaban Anda akan disimpan dan pesan ini akan hilang.';
$string['connectionok'] = 'Koneksi jaringan dipulihkan. Anda dapat melanjutkan dengan aman.';
$string['containercategorycreated'] = 'Kategori ini telah dibuat untuk menyimpan semua kategori asli yang dipindahkan ke tingkat situs karena penyebab yang ditentukan di bawah ini.';
$string['continueattemptquiz'] = 'Lanjutkan pengerjaan kuis yang terakhir';
$string['continuepreview'] = 'Lanjutkan pratinjau terakhir';
$string['copyingfrom'] = 'Membuat salinan soal \'{$a}\'';
$string['copyingquestion'] = 'Menyalin soal';
$string['correct'] = 'Benar';
$string['correctanswer'] = 'Jawaban benar';
$string['correctanswerformula'] = 'rumus jawaban benar';
$string['correctansweris'] = 'Jawaban benar: {$a}';
$string['correctanswerlength'] = 'Sosok penting';
$string['correctanswers'] = 'Jawaban benar';
$string['correctanswershows'] = 'Tampilkan jawaban benar';
$string['corrresp'] = 'Jawaban benar';
$string['countdown'] = 'Hitung Mundur';
$string['countdownfinished'] = 'Kuis akan ditutup, Anda harus mengirimkan jawaban Anda sekarang.';
$string['countdowntenminutes'] = 'Kuis akan ditutup dalam sepuluh menit.';
$string['coursetestmanager'] = 'Format Setelan Test Kursus';
$string['createcategoryandaddrandomquestion'] = 'Buat kategori dan tambahkan soal acak';
$string['createfirst'] = 'Anda harus membuat beberapa soal jawaban singkat terlebih dahulu.';
$string['createmultiple'] = 'Membuat beberapa soal acak pada kuis';
$string['createnewquestion'] = 'Buat soal baru';
$string['createquestionandadd'] = 'Buat soal baru dan menambahkannya pada kuis';
$string['custom'] = 'Format kustom';
$string['dataitemneed'] = 'Anda perlu menambahkan setidaknya satu set item data untuk mendapatkan soal yang valid';
$string['datasetdefinitions'] = 'Definisi kumpulan data yang dapat digunakan kembali untuk kategori {$a}';
$string['datasetnumber'] = 'Jumlah';
$string['daysavailable'] = 'Hari tersedia';
$string['decimaldigits'] = 'Digit desimal';
$string['decimalplaces'] = 'Digit desimal pada nilai';
$string['decimalplaces_help'] = 'Setelan ini menentukan jumlah digit ditampilkan setelah titik desimal ketika menampilkan nilai. Hanya mempengaruhi tampilan nilai, bukan nilai yang disimpan dalam basis data, maupun perhitungan internal, yang dilakukan untuk akurasi penuh.';
$string['decimalplacesquestion'] = 'Jumlah digit desimal soal';
$string['decimalplacesquestion_help'] = 'Jumlah digit yang ditampilkan setelah titik desimal saat menampilkan tanda untuk masing-masing soal.';
$string['decimalpoints'] = 'Digit desimal';
$string['default'] = 'Bawaan';
$string['defaultgrade'] = 'Nilai soal bawaan';
$string['defaultinfo'] = 'Kategori bawaan untuk soal.';
$string['delay1'] = 'Waktu tunda antara pengerjaan kuis pertama dan kedua';
$string['delay1st2nd'] = 'Penundaan paksa antara pengerjaan kuis pertama dan kedua';
$string['delay1st2nd_help'] = 'Jika diaktifkan, siswa harus menunggu waktu yang ditentukan berlalu sebelum dapat mengerjakan kuis untuk kedua kalinya.';
$string['delay2'] = 'Waktu tunda antara pengerjaan kuis selanjutnya';
$string['delaylater'] = 'Penundaan paksa antara pengerjaan kuis selanjutnya';
$string['delaylater_help'] = 'Jika diaktifkan, siswa harus menunggu waktu yang ditentukan berlalu sebelum mengerjakan kuis untuk ketiga kalinya dan berikutnya.';
$string['deleteattemptcheck'] = 'Apakah anda yakin ingin menghapus pengerjaan kuis ini secara permanen?';
$string['deleteselected'] = 'Hapus yang terpilih';
$string['deletingquestionattempts'] = 'Menghapus pengerjaan soal';
$string['description'] = 'Deskripsi';
$string['disabled'] = 'Dinonaktifkan';
$string['displayoptions'] = 'Opsi tampilan';
$string['donotuseautosave'] = 'Jangan gunakan simpan otomatis';
$string['download'] = 'Klik untuk mengunduh berkas kategori yang diekspor';
$string['downloadextra'] = '(berkas juga disimpan di berkas kursus di folder /backupdata/quiz)';
$string['dragtoafter'] = 'Setelah {$a}';
$string['dragtostart'] = 'Untuk memulai';
$string['duplicateresponse'] = 'Pengerjaan kuis ini diabaikan karena Anda memberikan jawaban yang sama dengan sebelumnya.';
$string['eachattemptbuildsonthelast'] = 'Tiap pengerjaan kuis dibangun pada saat terakhir';
$string['eachattemptbuildsonthelast_help'] = 'Jika pengerjaan kuis diizinkan lebih dari sekali dan setelan ini diaktifkan, setiap pengerjaan kuis baru akan berisi hasil dari pengerjaan sebelumnya. Ini memungkinkan kuis diselesaikan beberapa kali.';
$string['editcategories'] = 'Ubah kategori';
$string['editcategory'] = 'Edit kategori';
$string['editcatquestions'] = 'Edit kategori soal';
$string['editingquestion'] = 'Edit soal';
$string['editingquiz'] = 'Mengedit kuis';
$string['editingquiz_help'] = 'Saat membuat kuis, konsep utamanya adalah: * Kuis, berisi soal di satu atau lebih halaman * Bank soal, yang menyimpan salinan semua soal yang disusun ke dalam kategori * Pertanyaan acak - Seorang siswa mendapat pertanyaan berbeda setiap kali mereka mengerjakan kuis dan siswa yang berbeda bisa mendapatkan soal yang berbeda';
$string['editingquiz_link'] = 'mod/quiz/edit';
$string['editingquizx'] = 'Mengedit kuis: {$a}';
$string['editmaxmark'] = 'Edit nilai maksimum';
$string['editoverride'] = 'Edit penyampingan';
$string['editqcats'] = 'Edit kategori soal';
$string['editquestion'] = 'Edit soal';
$string['editquestions'] = 'Edit soal';
$string['editquiz'] = 'Edit kuis';
$string['editquizquestions'] = 'Edit soal kuis';
$string['emailconfirmautosubmitsmall'] = 'Terima kasih telah mengirimkan jawaban Anda ke \'{$a->quizname}\'';
$string['emailconfirmbody'] = 'Hai {$a->username},

Terima kasih telah menyerahkan jawaban Anda ke \'{$a->quizname}\' dalam kursus \'{$a->coursename}\' pada {$a->submissiontime}.

Pesan ini mengonfirmasi bahwa jawaban Anda telah disimpan.

Anda dapat mengakses kuis ini di {$a->quizurl}.';
$string['emailconfirmbodyautosubmit'] = 'Hai {$a->username},

Waktu untuk kuis \'{$a->quizname}\' dalam kursus \'{$a->coursename}\' telah berakhir. Jawaban Anda dikirimkan secara otomatis pada {$a->submissiontime}.

Pesan ini mengonfirmasi bahwa jawaban Anda telah disimpan.

Anda dapat mengakses kuis ini di {$a->quizurl}.';
$string['emailconfirmsmall'] = 'Terima kasih telah menyerahkan jawaban Anda ke \'{$a->quizname}\'';
$string['emailconfirmsubject'] = 'Konfirmasi ajuan: {$a->quizname}';
$string['emailmanualgradedbody'] = 'Hai {$a->studentname},

Jawaban Anda untuk \'{$a->quizname}\' dalam kursus \'{$a->coursename}\' di {$a->attempttimefinish} sekarang telah dinilai.

Anda akan dapat melihat skor dan umpan balik Anda dengan mengunjungi \'{$a->quizurl}\' dan mereviu upaya Anda.';
$string['emailmanualgradedsubject'] = 'Upaya Anda di {$a->quizname} telah dinilai';
$string['emailnotifybody'] = 'Hai {$a->username},

{$a->studentname} telah menyelesaikan \'{$a->quizname}\' ({$a->quizurl}) dalam kursus \'{$a->coursename}\'.

Anda dapat mereviu pengerjaan kuis ini di {$a->quizreviewurl}.';
$string['emailnotifysmall'] = '{$a->studentname} telah menyelesaikan {$a->quizname}. Lihat {$a->quizreviewurl}';
$string['emailnotifysubject'] = '{$a->studentname} telah menyelesaikan {$a->quizname}';
$string['emailoverduebody'] = '{$a->studentname} yang terhormat,

 Anda telah mengerjakan   \'{$a->quizname}\' pada kursus \'{$a->coursename}\', namun Anda tidak pernah mengirimkannya. Seharusnya sudah dikirimkan pada {$a->attemptduedate}.

Jika Anda masih ingin mengirimkan pengerjaan kuis ini, silakan kunjungi {$a->attemptsummaryurl} dan klik tombol kirim. Anda harus melakukan ini sebelum {$a->attemptgraceend}. Jika tidak, usaha Anda tidak akan dihitung.';
$string['emailoverduesmall'] = 'Anda tidak menyerahkan pengerjaan kuis Anda pada {$a->quizname}. Harap buka {$a->attemptummaryurl} sebelum {$a->attemptgraceend} jika Anda masih ingin menyerahkannya.';
$string['emailoverduesubject'] = 'Pengerjaan kuis sekarang terlambat: {$a->quizname}';
$string['empty'] = 'Kosong';
$string['enabled'] = 'Diaktifkan';
$string['endtest'] = 'Selesaikan kuis';
$string['erroraccessingreport'] = 'Anda tidak dapat mengakses laporan ini';
$string['errorinquestion'] = 'Galat di soal';
$string['errormissingquestion'] = 'Galat: Sistem tidak memiliki soal dengan id {$a}';
$string['errornotnumbers'] = 'Galat - jawaban harus berupa angka';
$string['errorunexpectedevent'] = 'Kode kejadian tak terduga {$a->event} ditemukan untuk soal {$a->questionid} dalam pengerjaan kuis {$a->attemptid}.';
$string['essay'] = 'Esai';
$string['essayquestions'] = 'Soal';
$string['eventattemptautosaved'] = 'Upaya kuis disimpan otomatis';
$string['eventattemptdeleted'] = 'Menghapus pengerjaan kuis';
$string['eventattemptmanualgradingcomplete'] = 'Penilaian manual upaya kuis selesai';
$string['eventattemptpreviewstarted'] = 'Mulai pratinjau pengerjaan kuis';
$string['eventattemptquestionrestarted'] = 'Pertanyaan upayta kuis dimulai kembali';
$string['eventattemptreviewed'] = 'Reviu pengerjaan kuis';
$string['eventattemptsummaryviewed'] = 'Melihat ringkasan pengerjaan kuis';
$string['eventattemptupdated'] = 'Upaya kuis diperbarui';
$string['eventattemptviewed'] = 'Melihat pengerjaan kuis';
$string['eventeditpageviewed'] = 'Melihat halaman edit kuis';
$string['eventoverridecreated'] = 'Membuat penyampingan kuis';
$string['eventoverridedeleted'] = 'Menghapus penyampingan kuis';
$string['eventoverrideupdated'] = 'Memperbarui penyampingan kuis';
$string['eventpagebreakcreated'] = 'Pemutus halaman dibuat';
$string['eventpagebreakdeleted'] = 'Pemutus halaman dihapus';
$string['eventquestionmanuallygraded'] = 'Soal dinilai manual';
$string['eventquizattemptabandoned'] = 'Abaikan pengerjaan kuis';
$string['eventquizattemptregraded'] = 'Menilai ulang pengerjaan kuis';
$string['eventquizattemptstarted'] = 'Mulai pengerjaan kuis';
$string['eventquizattemptsubmitted'] = 'Menyerahkan pengerjaan kuis';
$string['eventquizattempttimelimitexceeded'] = 'Melampaui batas waktu pengerjaan kuis';
$string['eventquizgradeupdated'] = 'Nilai kuis diperbarui';
$string['eventquizrepaginated'] = 'Kuis di-paginasi';
$string['eventreportviewed'] = 'Melihat laporan kuis';
$string['eventsectionbreakcreated'] = 'Pemisahan bagian dibuat';
$string['eventsectionbreakdeleted'] = 'Batas bagian dihapus';
$string['eventsectionshuffleupdated'] = 'Acak bagian diperbarui';
$string['eventsectiontitleupdated'] = 'Judul bagian diperbarui';
$string['eventslotcreated'] = 'Slot dibuat';
$string['eventslotdeleted'] = 'Slot dihapus';
$string['eventslotmarkupdated'] = 'Tanda slot diperbarui';
$string['eventslotmoved'] = 'Slot dipindah';
$string['eventslotrequirepreviousupdated'] = 'Slot membutuhkan pembaruan sebelumnya';
$string['everynquestions'] = 'Setiap {$a} soal';
$string['everyquestion'] = 'Tiap soal';
$string['everythingon'] = 'Semuanya pada';
$string['existingcategory'] = 'Kategori yang ada';
$string['exportcategory'] = 'Ekspor kategori';
$string['exporterror'] = 'Galat selama pemrosesan ekspor';
$string['exportingquestions'] = 'Soal sedang diekspor ke berkas';
$string['exportname'] = 'Nama berkas';
$string['exportquestions'] = 'Ekspor soal ke berkas';
$string['extraattemptrestrictions'] = 'Pembatasan tambahan pada pengerjaan kuis';
$string['false'] = 'Salah';
$string['feedback'] = 'Umpan balik';
$string['feedbackerrorboundaryformat'] = 'Batas nilai umpan balik harus berupa persentase atau angka. Nilai yang Anda masukkan dalam batas {$a} tidak dikenali.';
$string['feedbackerrorboundaryoutofrange'] = 'Batas nilai umpan balik harus antara 0% dan 100%. Nilai yang Anda masukkan di batas {$a} berada di luar jangkauan.';
$string['feedbackerrorjunkinboundary'] = 'Anda harus mengisi kotak batasan nilai umpan balik tanpa ada celah';
$string['feedbackerrorjunkinfeedback'] = 'Anda harus mengisi kotak umpan balik tanpa meninggalkan celah.';
$string['feedbackerrororder'] = 'Batas nilai umpan balik harus berurutan, tertinggi terlebih dahulu. Nilai yang Anda masukkan dalam batas {$a} tidak berurutan.';
$string['file'] = 'Berkas';
$string['fileformat'] = 'Format berkas';
$string['fillcorrect'] = 'Isi yang benar';
$string['filloutnumericalanswer'] = 'Anda memberikan setidaknya satu kemungkinan jawaban dan toleransi. Jawaban pertama yang cocok akan digunakan untuk menentukan nilai dan umpan balik. Jika Anda memberikan beberapa umpan balik tanpa jawaban di akhir, itu akan ditunjukkan kepada siswa yang jawabannya tidak cocok dengan jawaban lainnya.';
$string['filloutoneanswer'] = 'Anda harus memilih paling tidak satu kemungkinan jawaban. Jawaban yang dikosongkan tidak akan dinilai.';
$string['filloutthreequestions'] = 'Anda harus mengisi paling sedikit 3 soal. Soal yang dikosongkan tidak akan digunakan.';
$string['fillouttwochoices'] = 'Anda harus memilih paling tidak dua pilihan.  Pilihan yang dikosongkan tidak akan dinilai.';
$string['finishattemptdots'] = 'Selesaikan pengerjaan kuis';
$string['finishreview'] = 'Selesaikan reviu';
$string['forceregeneration'] = 'Paksa regenerasi';
$string['formatnotfound'] = 'Format impor/ekspor {$a} tidak ditemukan';
$string['formulaerror'] = 'Kesalahan rumus!';
$string['fractionsaddwrong'] = 'Jumlah nilai Anda tidak mencapai 100%<br /> tapi hanya mencapai {$a}% <br /> Apakah Anda ingin kembali untuk memperbaiki soal ini?';
$string['fractionsnomax'] = 'Satu dari jawaban harus bernilai 100%, jadi <br />memungkinkan untuk mendapat tingkatan tertinggi pada soal ini. <br />Anda ingin kembali untuk memperbaiki soal ini?';
$string['fromfile'] = 'dari berkas:';
$string['functiondisabledbysecuremode'] = 'Fungsi tersebut saat ini dinonaktifkan';
$string['generalfeedback'] = 'Umpan balik umum';
$string['generalfeedback_help'] = 'Umpan balik umum adalah teks yang ditampilkan setelah soal dikerjakan. Tidak seperti umpan balik untuk soal tertentu yang bergantung pada jawaban yang diberikan, umpan balik umum yang sama selalu ditampilkan.';
$string['gobacktoquiz'] = 'Kembali';
$string['graceperiod'] = 'Masa tenggang pengajuan';
$string['graceperiod_desc'] = 'Jika apa yang harus dilakukan ketika waktu berakhir diatur ke \'Ada masa tenggang...\', maka ini adalah jumlah bawaan waktu tambahan yang diperbolehkan.';
$string['graceperiod_help'] = 'Jika apa yang harus dilakukan ketika waktu berakhir diatur ke \'Ada masa tenggang...\', maka ini adalah jumlah waktu tambahan yang diperbolehkan.';
$string['graceperiodmin'] = 'Tambahan waktu';
$string['graceperiodmin_desc'] = 'Ada masalah potensial tepat di akhir kuis. Di satu sisi, kami ingin membiarkan siswa terus bekerja sampai detik terakhir - dengan bantuan timer yang secara otomatis mengirimkan kuis ketika waktu habis. Di sisi lain, server mungkin kelebihan beban, dan membutuhkan waktu untuk memproses jawaban. Oleh karena itu, kami akan menerima jawaban selama ini setelah waktu berakhir, sehingga mereka tidak dikenakan sanksi karena server menjadi lambat. Namun, siswa bisa menyontek dan mendapatkan beberapa detik ini untuk menjawab kuis. Anda harus melakukan pertukaran berdasarkan seberapa besar Anda mempercayai kinerja server Anda selama kuis.';
$string['graceperiodtoosmall'] = 'Masa tenggang harus lebih dari {$a}.';
$string['grade'] = 'Nilai';
$string['gradeall'] = 'Nilai semua';
$string['gradeaverage'] = 'Nilai rata-rata';
$string['gradeboundary'] = 'Batasan nilai';
$string['gradeessays'] = 'Nilai esai';
$string['gradehighest'] = 'Nilai tertinggi';
$string['grademethod'] = 'Metode penilaian';
$string['grademethod_help'] = 'Ketika diizinkan mengerjakan lebih dari satu kali, ada beberapa cara yang dapat Anda gunakan untuk menghitung nilai akhir siswa untuk kuis tersebut: * Nilai tertinggi (terbaik) dari setiap percobaan * Nilai rata-rata dari semua pengerjaan * Nilai pengerjaan pertama (pengerjaan lain diabaikan) * Nilai pada pengerjaan terakhir (pengerjaan lain diabaikan)';
$string['gradesdeleted'] = 'Nilai kuis dihapus';
$string['gradesofar'] = '{$a->method}: {$a->mygrade} / {$a->quizgrade}.';
$string['gradetopassmustbeset'] = 'Nilai kelulusan tidak boleh nol karena kuis ini telah menyetel metode penyelesaian untuk mewajibkan nilai kelulusan. Harap tetapkan nilai bukan nol.';
$string['gradetopassnotset'] = 'Kuis ini belum menetapkan nilai kelulusan. Ini dapat diatur di bagian penilaian dari setelan kuis.';
$string['gradetopassoutof'] = 'Nilai kelulusan: {$a->grade} dari {$a->maxgrade}';
$string['gradingdetails'] = 'Nilai pengerjaan ini: {$a->raw}/{$a->max}.';
$string['gradingdetailsadjustment'] = 'Dengan penalti sebelumnya, ini memberikan <strong>{$a->cur}/{$a->max}</strong>.';
$string['gradingdetailspenalty'] = 'Pengerjaan ini dikenakan penalti {$a}.';
$string['gradingdetailszeropenalty'] = 'Anda tidak dihukum untuk pengajuan ini.';
$string['gradingmethod'] = 'Metode penilaian: {$a}';
$string['groupoverrides'] = 'Penyampingan grup';
$string['groupoverridesdeleted'] = 'Penyampingan grup dihapus';
$string['groupsnone'] = 'Tidak ada grup dalam kursus ini';
$string['guestsno'] = 'Maaf, tamu tidak diperbolehkan menjawab kuis';
$string['hidebreaks'] = 'Sembunyikan jeda halaman';
$string['hidereordertool'] = 'Sembunyikan alat pengurutan ulang';
$string['history'] = 'Riwayat jawaban:';
$string['howquestionsbehave_desc'] = 'Setelan bawaan untuk bagaimana perilaku soal dalam kuis.';
$string['imagedisplay'] = 'Gambar untuk ditampilkan';
$string['import_help'] = 'Fungsi ini memungkinkan Anda untuk mengimpor soal dari berkas teks eksternal.

Jika berkas Anda berisi karakter non-ascii, maka berkas tersebut harus menggunakan pengodean UTF-8. Berhati-hatilah dengan berkas yang dibuat oleh aplikasi Microsoft Office, karena ini biasanya menggunakan pengodean khusus yang terkadang tidak dapat ditangani dengan benar.

Format Impor dan Ekspor adalah sumber  yang dapat dicopot-pasang. Format opsional lainnya mungkin tersedia di basis data Modul dan Pengaya.';
$string['import_link'] = 'question/import';
$string['importcategory'] = 'Impor kategori';
$string['importerror'] = 'Galat selama pemrosesan impor';
$string['importfilearea'] = 'Impor dari berkas yang sudah ada di berkas kursus ...';
$string['importfileupload'] = 'Impor dari berkas yang diunggah...';
$string['importfromthisfile'] = 'Impor dari berkas ini';
$string['importingquestions'] = 'Mengimpor {$a} soal dari berkas';
$string['importmax10error'] = 'Ada kesalahan dalam soal. Anda mungkin tidak memiliki lebih dari sepuluh jawaban';
$string['importmaxerror'] = 'Ada kesalahan dalam soal. Ada terlalu banyak jawaban.';
$string['importquestions'] = 'Impor soal dari berkas';
$string['inactiveoverridehelp'] = '* Penyampingan ini tidak aktif karena akses pengguna ke aktivitas dibatasi. Hal ini dapat terjadi karena penetapan grup atau peran, pembatasan akses lainnya, atau aktivitas disembunyikan.';
$string['incorrect'] = 'Salah';
$string['indicator:cognitivedepth'] = 'Kuis kognitif';
$string['indicator:cognitivedepth_help'] = 'Indikator ini didasarkan pada kedalaman kognitif yang dicapai siswa dalam aktivitas Kuis.';
$string['indicator:cognitivedepthdef'] = 'Kuis kognitif';
$string['indicator:cognitivedepthdef_help'] = 'Peserta telah mencapai persentase keterlibatan kognitif yang ditawarkan oleh aktivitas Kuis ini selama interval analisis ini (Tingkat = Tidak ada tampilan, Lihat, Ajukan, Lihat umpan balik, komentari umpan balik, Ajukan ulang setelah melihat umpan balik)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Kuis sosial';
$string['indicator:socialbreadth_help'] = 'Indikator ini didasarkan pada keluasan sosial yang dicapai siswa dalam aktivitas Kuis.';
$string['indicator:socialbreadthdef'] = 'Kuis sosial';
$string['indicator:socialbreadthdef_help'] = 'Peserta telah mencapai persentase keterlibatan sosial yang ditawarkan oleh kegiatan Kuis selama interval analisis ini (Tingkat = Tidak ada partisipasi, Peserta sendiri, Peserta dengan orang lain)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['indivresp'] = 'Jawaban perorangan untuk tiap item';
$string['info'] = 'Info';
$string['infoshort'] = 'i';
$string['initialnumfeedbacks'] = 'Jumlah awal ruas umpan balik keseluruhan';
$string['initialnumfeedbacks_desc'] = 'Saat membuat kuis baru, berikan banyak kotak masukan keseluruhan yang kosong ini. Setelah kuis dibuat, formulir menunjukkan jumlah bidang yang diperlukan untuk jumlah umpan balik dalam kuis. Setelan minimal paling tidak 1.';
$string['inprogress'] = 'Sedang dikerjakan';
$string['introduction'] = 'Deskripsi';
$string['invalidattemptid'] = 'Tidak ada ID Pengerjaan kuis tersebut';
$string['invalidcategory'] = 'ID kategori salah';
$string['invalidoverrideid'] = 'ID penyampingan tidak valid';
$string['invalidquestionid'] = 'ID soal salah';
$string['invalidquizid'] = 'ID kuis salah';
$string['invalidrandomslot'] = 'ID slot pertanyaan acak tidak valid.';
$string['invalidsource'] = 'Sumber tidak diterima sebagai valid.';
$string['invalidsourcetype'] = 'Jenis sumber tidak valid.';
$string['invalidstateid'] = 'ID status tidak valid';
$string['lastanswer'] = 'Jawaban terakhir Anda adalah';
$string['layout'] = 'Tata letak';
$string['layoutasshown'] = 'Tata letak seperti yang terlihat';
$string['layoutasshownwithpages'] = 'Tata letak seperti yang terlihat. <small>(Otomatis membuat halaman baru setiap {$a} soal.)</small>';
$string['layoutshuffledandpaged'] = 'Soal diacak sejumlah {$a} soal per halaman.';
$string['layoutshuffledsinglepage'] = 'Soal diacak, semua dalam satu halaman.';
$string['legacyquizaccessrulescron'] = 'Aturan akses kuis cron lama';
$string['legacyquizreportscron'] = 'Laporan kuis cron lama';
$string['link'] = 'Tautan';
$string['listitems'] = 'Daftar item dalam kuis';
$string['literal'] = 'Harfiah';
$string['loadingquestionsfailed'] = 'Gagal memuat soal: {$a}';
$string['makecopy'] = 'Simpan sebagai soal baru';
$string['managetypes'] = 'Kelola tipe soal dan server';
$string['manualgradequestion'] = 'Menilai soal  secara manual {$a->question} pada {$a->quiz} oleh {$a->user}';
$string['manualgrading'] = 'Penilaian';
$string['mark'] = 'Kirim';
$string['markall'] = 'Halaman Pengiriman';
$string['marks'] = 'Poin';
$string['marks_help'] = 'Nilai numerik untuk setiap soal, dan skor upaya keseluruhan.';
$string['match'] = 'Cocok';
$string['matchanswer'] = 'Mencocokkan';
$string['matchanswerno'] = 'Mencocokkan {$a}';
$string['max'] = 'Maks';
$string['maxmark'] = 'Nilai maksimum';
$string['messageprovider:attempt_grading_complete'] = 'Pemberitahuan bahwa upaya Anda telah dinilai';
$string['messageprovider:attempt_overdue'] = 'Peringatan ketika upaya kuis Anda terlambat';
$string['messageprovider:confirmation'] = 'Konfirmasi pengiriman kuis Anda sendiri';
$string['messageprovider:submission'] = 'Pemberitahuan penyerahan kuis';
$string['min'] = 'Min';
$string['minutes'] = 'Menit';
$string['missingcorrectanswer'] = 'Jawaban yang benar harus ditetapkan';
$string['missingitemtypename'] = 'Nama yang hilang';
$string['missingquestion'] = 'Soal ini sepertinya tidak ada lagi';
$string['modulename'] = 'Kuis';
$string['modulename_help'] = 'Aktivitas kuis memungkinkan seorang pengajar membuat kuis yang terdiri dari berbagai jenis soal, termasuk pilihan ganda, pencocokan, jawaban singkat dan numerik.

Pengajar dapat membuat kuis yang dapat dikerjakan berkali-kali, dengan soal yang dikocok atau dipilih secara acak dari bank soal. Batas waktu dapat ditetapkan.

Setiap kuis dinilai secara otomatis, kecuali soal esai, dan nilainya dicatat dalam buku nilai. Pengajar dapat memilih kapan dan jika petunjuk, umpan balik dan jawaban yang benar ditunjukkan kepada siswa.

Kuis dapat digunakan

* Sebagai ujian kursus
* Sebagai tes mini untuk tugas membaca atau di akhir topik
* Sebagai praktik ujian dengan menggunakan soal dari ujian lama
* Memberikan umpan balik langsung tentang kinerja
* Untuk penilaian mandiri';
$string['modulename_link'] = 'mod/quiz/view';
$string['modulenameplural'] = 'Kuis';
$string['moveselectedonpage'] = 'Pindahkan soal terpilih ke halaman: {$a}';
$string['multichoice'] = 'Pilihan ganda';
$string['multipleanswers'] = 'Pilih setidaknya satu soal.';
$string['mustbesubmittedby'] = 'Pengerjaan kuis ini harus dikirimkan sebelum {$a}';
$string['name'] = 'Nama';
$string['navigatenext'] = 'Halaman selanjutnya';
$string['navigateprevious'] = 'Halaman sebelumnya';
$string['navmethod'] = 'Metode navigasi';
$string['navmethod_free'] = 'Bebas';
$string['navmethod_help'] = 'Ketika navigasi sekuensial diaktifkan, siswa harus mengikuti kuis secara berurutan dan tidak boleh kembali ke halaman sebelumnya atau melompat ke depan.';
$string['navmethod_seq'] = 'Sekuensial';
$string['navnojswarning'] = 'Peringatan: tautan ini tidak akan menyimpan jawaban Anda. Gunakan tombol berikutnya di bagian bawah halaman.';
$string['neverallononepage'] = 'Tidak pernah, semua soal dalam satu halaman';
$string['newattemptfail'] = 'Galat: Tidak dapat mengerjakan kuis lagi';
$string['newcategory'] = 'Kategori baru';
$string['newpage'] = 'Halaman baru';
$string['newpage_help'] = 'Untuk kuis yang lebih panjang, masuk akal untuk merentangkan kuis di beberapa halaman dengan membatasi jumlah soal per halaman. Saat menambahkan soal ke kuis, Hentian halaman akan secara otomatis disisipkan sesuai dengan setelan ini. Namun Hentian halaman nanti dapat dipindahkan secara manual pada halaman pengeditan.';
$string['newpageevery'] = 'Otomatis mulai halaman baru';
$string['newsectionheading'] = 'Tajuk baru';
$string['noanswers'] = 'Belum memilih jawaban';
$string['noattempts'] = 'Belum ada yang mengerjakan kuis ini';
$string['noattemptsfound'] = 'Tidak ada pengerjaan kuis yang ditemukan.';
$string['noattemptstoshow'] = 'Belum ada pengerjaan kuis yang ditampilkan';
$string['nocategory'] = 'Salah atau tidak ada kategori yang ditentukan';
$string['noclose'] = 'Tidak ada tanggal tutup';
$string['nocommentsyet'] = 'Belum ada komentar';
$string['noconnection'] = 'Saat ini tidak ada koneksi ke layanan web yang dapat memproses soal ini. Silakan hubungi administrator Anda';
$string['nodataset'] = 'tidak ada - ini bukan wild card';
$string['nodatasubmitted'] = 'Tidak ada data terkirim.';
$string['noessayquestionsfound'] = 'Tidak ditemukan soal yg dinilai manual';
$string['nogradewarning'] = 'Kuis ini tidak dinilai, jadi Anda tidak dapat menetapkan umpan balik keseluruhan yang berbeda berdasarkan nilai.';
$string['nomoreattempts'] = 'Sudah tidak diizinkan mengerjakan lagi';
$string['none'] = 'Tidak ada';
$string['noopen'] = 'Tidak ada tanggal buka';
$string['nooverridedata'] = 'Anda harus mengesampingkan setidaknya satu setelan kuis.';
$string['nopossibledatasets'] = 'Tidak ada kumpulan data yang memungkinkan';
$string['noquestionintext'] = 'Teks soal tidak tercantum soal.';
$string['noquestions'] = 'Belum ditambahkan soal';
$string['noquestionsfound'] = 'Soal tidak ditemukan';
$string['noquestionsinquiz'] = 'Tidak ada soal dalam kuis ini.';
$string['noquestionsnotinuse'] = 'Soal acak ini tidak digunakan, karena kategorinya kosong.';
$string['noquestionsonpage'] = 'Halaman kosong';
$string['noresponse'] = 'Tidak ada jawaban';
$string['noreview'] = 'Anda tidak diperbolehkan mereviu pada kuis ini';
$string['noreviewattempt'] = 'Anda tidak diizinkan untuk mereviu hasil pengerjaan kuis ini.';
$string['noreviewshort'] = 'Tidak diizinkan';
$string['noreviewuntil'] = 'Anda tidak diperbolehkan memberi reviu pada kuis ini sampai {$a}';
$string['noreviewuntilshort'] = 'Tersedia {$a}';
$string['noscript'] = 'JavaScript harus diaktifkan untuk dapat melanjutkan';
$string['notavailabletostudents'] = 'Catatan: kuis ini tidak tersedia untuk siswa sekarang';
$string['notenoughrandomquestions'] = 'Soal dalam kategori {$a->category} tidak cukup untuk membuat soal {$a->name} ({$a->id}).';
$string['notenoughsubquestions'] = 'Tidak cukup subsoal yang telah ditentukan!<br />Apakah Anda ingin kembali dan memperbaiki soal ini?';
$string['notifyattemptsgradedtask'] = 'Kirim pemberitahuan upaya kuis yang dinilai';
$string['notimedependentitems'] = 'Item yang bergantung pada waktu saat ini tidak didukung oleh modul kuis. Sebagai solusinya, tetapkan batas waktu untuk seluruh kuis. Apakah Anda ingin memilih item yang berbeda (atau tetap menggunakan item saat ini)?';
$string['notyetgraded'] = 'Belum dinilai';
$string['notyetviewed'] = 'Belum dilihat';
$string['notyourattempt'] = 'Ini bukan hasil pekerjaanmu!';
$string['noview'] = 'Pengguna yang masuk tidak diizinkan untuk melihat kuis ini';
$string['numattempts'] = '{$a->studentnum} {$a->studentstring} telah mengerjakan {$a->attemptnum}';
$string['numberabbr'] = '#';
$string['numerical'] = 'Numerik';
$string['numquestionsx'] = 'Soal: {$a}';
$string['oneminute'] = '1 menit';
$string['onlyteachersexport'] = 'Hanya pengajar dapat mengekspor soal';
$string['onlyteachersimport'] = 'Hanya pengajar dengan kemampuan edit yang dapat mengimpor soal';
$string['onthispage'] = 'Halaman ini';
$string['open'] = 'Tidak dijawab';
$string['openafterclose'] = 'Tidak dapat memperbarui kuis. Anda telah menentukan tanggal buka setelah tanggal tutup.';
$string['openclosedatesupdated'] = 'Tanggal buka dan tutup kuis Diperbarui';
$string['optional'] = 'opsional';
$string['orderandpaging'] = 'urutan dan halaman';
$string['orderandpaging_help'] = 'Angka 10, 20, 30, ... di seberang setiap soal menunjukkan urutan soal. Jumlahnya bertambah dalam langkah 10 untuk menyisakan ruang untuk soal tambahan yang akan dimasukkan. Untuk menyusun ulang soal, ubah nomor, lalu klik tombol "Susun ulang soal". Untuk menambahkan jeda halaman setelah soal tertentu, centang kotak di samping soal, lalu klik tombol "Tambahkan halaman baru setelah soal yang dipilih". Untuk menyusun soal pada beberapa halaman, klik tombol Tata halaman dan pilih jumlah soal yang diinginkan per halaman.';
$string['orderingquiz'] = 'Urutan dan halaman';
$string['orderingquizx'] = 'Urutan dan halaman: {$a}';
$string['outcomesadvanced'] = 'Capaian adalah setelan lanjutan';
$string['outof'] = '{$a->grade} dari {$a->maxgrade}';
$string['outofpercent'] = '{$a->grade} dari {$a->maxgrade} ({$a->percent}%)';
$string['outofshort'] = '{$a->grade}/{$a->maxgrade}';
$string['overallfeedback'] = 'Umpan balik keseluruhan';
$string['overallfeedback_help'] = 'Umpan balik keseluruhan adalah teks yang ditampilkan setelah kuis dikerjakan. Dengan menentukan batas kelas tambahan (sebagai persentase atau sebagai angka), teks yang ditampilkan dapat bergantung pada nilai yang diperoleh.';
$string['overdue'] = 'Terlambat';
$string['overduehandling'] = 'Waktu pengerjaan berakhir';
$string['overduehandling_desc'] = 'Apa yang harus terjadi secara bawaan jika seorang siswa tidak mengirimkan kuis sebelum kedaluwarsa.';
$string['overduehandling_help'] = 'Setelan ini mengontrol apa yang terjadi jika seorang siswa gagal mengirimkan pengerjaan kuis mereka sebelum waktunya habis. Jika siswa sedang aktif mengerjakan kuis pada saat itu, maka penghitung waktu mundur akan selalu mengirimkan pekerjaan mereka secara otomatis, tetapi jika mereka telah keluar, maka setelan ini mengontrol apa yang terjadi.';
$string['overduehandling_link'] = 'mod/quiz/timing';
$string['overduehandlingautoabandon'] = 'harus diserahkan sebelum kedaluwarsa jika tidak semua hasil pekerjaan tidak akan dihitung';
$string['overduehandlingautosubmit'] = 'secara otomatis soal yang telah dikerjakan terkirim';
$string['overduehandlinggraceperiod'] = 'Ada tambahan waktu untuk mengirim tapi tidak dapat mengisi soal yg belum terjawab';
$string['overduemustbesubmittedby'] = 'Pengerjaan kuis ini sekarang sudah terlambat. Seharusnya sudah diserahkan. Jika Anda ingin kuis ini dinilai, Anda harus mengirimkannya dengan {$a}. Jika Anda tidak mengirimkannya saat itu, tidak akan mendapatkan nilai.';
$string['override'] = 'Penyampingan';
$string['overridedeletegroupsure'] = 'Anda yakin ingin menghapus penyampingan untuk grup {$a}?';
$string['overridedeleteusersure'] = 'Apakah Anda yakin ingin menghapus penyampingan untuk pengguna {$a}?';
$string['overridegroup'] = 'Penyampingan grup';
$string['overridegroupeventname'] = '{$a->quiz} - {$a->group}';
$string['overrides'] = 'Penyampingan';
$string['overridesforquiz'] = 'Setelan penyampingan: {$a}';
$string['overridesnoneforgroups'] = 'Tidak ada setelan penyampingan grup yang dibuat untuk kuis ini.';
$string['overridesnoneforusers'] = 'Tidak ada setelan penyampingan pengguna yang dibuat untuk kuis ini.';
$string['overridessummary'] = 'Setelan penyampingan yang ada ({$a})';
$string['overridessummarygroup'] = 'Grup: {$a}';
$string['overridessummarythisgroup'] = 'Setelan penyampingan yang ada {$a} untuk grup ini';
$string['overridessummaryuser'] = 'Pengguna: {$a}';
$string['overridessummaryyourgroups'] = 'Setelan penyampingan ({$a}) ada untuk grup Anda';
$string['overrideuser'] = 'Penyampingan pengguna';
$string['overrideusereventname'] = '{$a->quiz} - Penyampingan';
$string['page-mod-quiz-attempt'] = 'Halaman mengerjakan kuis';
$string['page-mod-quiz-edit'] = 'Edit halaman kuis';
$string['page-mod-quiz-report'] = 'Setiap halaman laporan kuis';
$string['page-mod-quiz-review'] = 'Reviu halaman pengerjaan kuis';
$string['page-mod-quiz-summary'] = 'Halaman ringkasan upaya kuis';
$string['page-mod-quiz-view'] = 'Halaman informasi kuis';
$string['page-mod-quiz-x'] = 'Setiap halaman modul kuis';
$string['pageshort'] = 'H';
$string['pagesize'] = 'Ukuran halaman';
$string['parent'] = 'Induk';
$string['parentcategory'] = 'Kategori induk';
$string['parsingquestions'] = 'Urai soal dari berkas impor.';
$string['partiallycorrect'] = 'Sebagian benar';
$string['penalty'] = 'Penalti';
$string['penaltyscheme'] = 'Terapkan penalti';
$string['penaltyscheme_help'] = 'Jika diaktifkan, penalti akan mengurangi nilai akhir untuk soal pada jawaban yang salah. Jumlah penalti ditentukan dalam setelan soal. Setelan ini hanya berlaku jika mode adaptif diaktifkan.';
$string['percentcorrect'] = 'persen benar';
$string['pleaseclose'] = 'Permintaan anda telah diproses. Anda sekarang dapat menutup jendela ini';
$string['pluginadministration'] = 'Administrasi kuis';
$string['pluginname'] = 'Kuis';
$string['popup'] = 'Tampilkan kuis pada jendela \'aman\'';
$string['popupblockerwarning'] = 'Bagian tes ini dalam mode aman, ini berarti Anda harus mengikuti kuis di jendela aman. Harap matikan pemblokir sembulan Anda. Terima kasih.';
$string['popupnotice'] = 'Siswa akan melihat kuis ini di jendela aman';
$string['preprocesserror'] = 'Galat selama pra-pemrosesan!';
$string['preview'] = 'Pratinjau';
$string['previewquestion'] = 'Pratinjau soal';
$string['previewquiz'] = 'Pratinjau {$a}';
$string['previewquiznow'] = 'Pratinjau kuis sekarang';
$string['previewquizstart'] = 'Pratinjau kuis';
$string['previous'] = 'Status pratinjau';
$string['privacy:metadata:core_question'] = 'Aktivitas kuis menyimpan informasi penggunaan soal di subsistem core_question.';
$string['privacy:metadata:quiz'] = 'Aktivitas kuis memanfaatkan laporan kuis.';
$string['privacy:metadata:quiz_attempts'] = 'Detail setiap pengerjaan kuis.';
$string['privacy:metadata:quiz_attempts:attempt'] = 'Jumlah mengerjakan.';
$string['privacy:metadata:quiz_attempts:currentpage'] = 'Halaman saat ini tempat pengguna berada.';
$string['privacy:metadata:quiz_attempts:gradednotificationsenttime'] = 'Waktu pengguna diberi tahu bahwa penilaian manual dari upaya mereka telah selesai';
$string['privacy:metadata:quiz_attempts:preview'] = 'Apakah ini pratinjau kuis.';
$string['privacy:metadata:quiz_attempts:state'] = 'Status pengerjaan kuis saat ini.';
$string['privacy:metadata:quiz_attempts:sumgrades'] = 'Jumlah nilai dalam pengerjaan kuis.';
$string['privacy:metadata:quiz_attempts:timecheckstate'] = 'Waktu pengecekan status.';
$string['privacy:metadata:quiz_attempts:timefinish'] = 'Waktu pengerjaan kuis selesai.';
$string['privacy:metadata:quiz_attempts:timemodified'] = 'Waktu pengerjaan kuis diperbarui.';
$string['privacy:metadata:quiz_attempts:timemodifiedoffline'] = 'Waktu pengerjaan kuis diperbarui melalui pembaruan luring.';
$string['privacy:metadata:quiz_attempts:timestart'] = 'Waktu pengerjaan kuis dimulai.';
$string['privacy:metadata:quiz_grades'] = 'Detail nilai keseluruhan kuis ini.';
$string['privacy:metadata:quiz_grades:grade'] = 'Nilai keseluruhan kuis ini.';
$string['privacy:metadata:quiz_grades:quiz'] = 'Kuis yang dinilai.';
$string['privacy:metadata:quiz_grades:timemodified'] = 'Waktu saat nilai diubah.';
$string['privacy:metadata:quiz_grades:userid'] = 'Pengguna yang dinilai.';
$string['privacy:metadata:quiz_overrides'] = 'Detail penyampingan kuis ini';
$string['privacy:metadata:quiz_overrides:quiz'] = 'Kuis dengan informasi penyampingan';
$string['privacy:metadata:quiz_overrides:timeclose'] = 'Waktu penutupan baru untuk kuis.';
$string['privacy:metadata:quiz_overrides:timelimit'] = 'Batas waktu baru untuk kuis.';
$string['privacy:metadata:quiz_overrides:timeopen'] = 'Waktu buka baru untuk kuis.';
$string['privacy:metadata:quiz_overrides:userid'] = 'Pengguna disampingkan';
$string['privacy:metadata:quizaccess'] = 'Aktivitas kuis menggunakan aturan akses kuis.';
$string['publish'] = 'Terbitkan';
$string['publishedit'] = 'Anda harus memiliki izin di penerbitan kursus untuk menambahkan atau mengedit soal dalam kategori ini';
$string['qbrief'] = 'S. {$a}';
$string['qname'] = 'nama';
$string['qti'] = 'Format IMS QTI';
$string['qtypename'] = 'tipe, nama';
$string['question'] = 'Soal';
$string['questionbank'] = 'dari bank soal';
$string['questionbankmanagement'] = 'Pengelolaan bank soal';
$string['questionbehaviour'] = 'Perilaku soal';
$string['questioncats'] = 'Kategori soal';
$string['questiondeleted'] = 'Soal ini telah dihapus. Silakan hubungi pengajar Anda.';
$string['questiondependencyadd'] = 'Tidak ada batasan kapan soal {$a->thisq} dapat dikerjakan • Klik untuk mengubah';
$string['questiondependencyfree'] = 'Tidak ada batasan untuk soal ini';
$string['questiondependencyremove'] = 'Soal {$a->thisq} tidak dapat dikerjakan sampai soal sebelumnya {$a->previousq} diselesaikan • Klik untuk mengubah';
$string['questiondependsonprevious'] = 'Soal ini tidak dapat dikerjakan sampai pertanyaan sebelumnya selesai.';
$string['questiondraftonly'] = 'Soal {$a} dalam status draf. Kunjungi bank soal dan atur statusnya menjadi siap.';
$string['questiondraftwillnotwork'] = 'Soal ini dalam status draf. Untuk menggunakannya dalam kuis, buka bank soal dan ubah status menjadi siap.';
$string['questioninuse'] = 'Soal \'{$a->questionname}\' sedang digunakan pada: <br />{$a->quiznames}<br /> Soal tidak akan dihapus dari kuis tapi hanya dari daftar kategori.';
$string['questionmissing'] = 'Soal untuk sesi ini hilang';
$string['questionname'] = 'Nama soal';
$string['questionnonav'] = '<span class = "accesshide"> Soal </span> {$a->number}<span class="accesshide"> {$a->attributes}</span>';
$string['questionnonavinfo'] = '<span class="accesshide">Information </span>{$a->number}<span class="accesshide"> {$a->attributes}</span>';
$string['questionnotloaded'] = 'Soal {$a} belum dimuat dari basis data';
$string['questionorder'] = 'Urutan soal';
$string['questionposition'] = 'Posisi baru untuk soal {$a}';
$string['questions'] = 'Soal';
$string['questionsetpreview'] = 'Pratinjau kumpulan soal';
$string['questionsinclhidden'] = 'Soal (termasuk yang tersembunyi)';
$string['questionsinthisquiz'] = 'Soal dalam kuis ini';
$string['questionsmatchingfilter'] = 'Soal yang sesuai dengan filter:';
$string['questionsperpage'] = 'Soal per halaman';
$string['questionsperpageselected'] = 'Soal per halaman telah disetel sehingga halaman saat ini diperbaiki. Akibatnya, kontrol halaman telah dinonaktifkan. Anda dapat mengubahnya di {$a}.';
$string['questionsperpagex'] = 'Soal per halaman: {$a}';
$string['questiontext'] = 'Teks soal';
$string['questiontextisempty'] = '[Teks soal kosong]';
$string['questiontype'] = 'Tipe soal  {$a}';
$string['questiontypesetupoptions'] = 'Opsi setelan untuk tipe soal:';
$string['questionversion'] = 'v{$a}';
$string['questionversionlatest'] = 'v{$a} (terbaru)';
$string['quiz:addinstance'] = 'Tambahkan kuis baru';
$string['quiz:attempt'] = 'Kerjakan kuis';
$string['quiz:deleteattempts'] = 'Hapus pengerjaan kuis';
$string['quiz:emailconfirmsubmission'] = 'Dapatkan pesan konfirmasi saat menyerahkan';
$string['quiz:emailnotifyattemptgraded'] = 'Terima pemberitahuan ketika upaya Anda telah dinilai';
$string['quiz:emailnotifysubmission'] = 'Dapatkan pesan pemberitahuan ketika pengerjaan kuis diserahkan';
$string['quiz:emailwarnoverdue'] = 'Dapatkan pesan pemberitahuan ketika pengerjaan kuis jatuh tempo dan perlu diserahkan.';
$string['quiz:grade'] = 'Penilaian secara manual';
$string['quiz:ignoretimelimits'] = 'Abaikan batas waktu kuis';
$string['quiz:manage'] = 'Kelola kuis';
$string['quiz:manageoverrides'] = 'Kelola penyampingan kuis';
$string['quiz:preview'] = 'Pratinjau kuis';
$string['quiz:regrade'] = 'Nilai ulang upaya kuis';
$string['quiz:reviewmyattempts'] = 'Reviu upaya Anda sendiri';
$string['quiz:view'] = 'Lihat informasi kuis';
$string['quiz:viewoverrides'] = 'Lihat  setelan penyampingan kuis';
$string['quiz:viewreports'] = 'Lihat laporan kuis';
$string['quizavailable'] = 'Kuis ini dibuka sampai: {$a}';
$string['quizclose'] = 'Tutup kuis';
$string['quizclosed'] = 'Kuis ditutup pada {$a}';
$string['quizcloses'] = 'Kuis ditutup';
$string['quizcloseson'] = 'Kuis ini akan ditutup pada {$a}';
$string['quizeventcloses'] = '{$a} akan berakhir';
$string['quizeventopens'] = '{$a} dibuka';
$string['quizisclosed'] = 'Kuis ini telah ditutup';
$string['quizisclosedwillopen'] = 'Kuis ditutup (dibuka pada  {$a})';
$string['quizisopen'] = 'Kuis ini sedang dibuka';
$string['quizisopenwillclose'] = 'Kuis dibuka (ditutup {$a})';
$string['quiznavigation'] = 'Navigasi kuis';
$string['quizopen'] = 'Kuis dimulai';
$string['quizopenclose'] = 'Tanggal buka dan tutup';
$string['quizopenclose_help'] = 'Siswa hanya dapat mengerjakan kuis setelah waktu dibuka dan harus menyelesaikannya sebelum waktu ditutup.';
$string['quizopenclose_link'] = 'mod/quiz/timing';
$string['quizopened'] = 'Kuis ini sedang dibuka';
$string['quizopenedon'] = 'Kuis ini dibuka pada {$a}';
$string['quizopens'] = 'Kuis dibuka';
$string['quizopenwillclose'] = 'Kuis ini sedang dibuka, akan ditutup pada {$a}';
$string['quizordernotrandom'] = 'Urutan kuis tidak diacak';
$string['quizorderrandom'] = '* Urutan kuis diacak';
$string['quizreport'] = 'Laporan kuis';
$string['quizsettings'] = 'Setelan kuis';
$string['quiztimer'] = 'Penghitung waktu kuis';
$string['quizwillopen'] = 'Kuis ini akan dibuka {$a}';
$string['random'] = 'Soal acak';
$string['randomcreate'] = 'Buat soal acak';
$string['randomediting'] = 'Mengedit soal acak';
$string['randomfromcategory'] = 'Soal acak dari kategori:';
$string['randomfromexistingcategory'] = 'Soal acak dari kategori yang ada';
$string['randomfromunavailabletag'] = '{$a} (tidak tersedia)';
$string['randomnosubcat'] = 'Soal dari kategori ini saja, bukan subkategorinya.';
$string['randomnumber'] = 'Jumlah soal acak';
$string['randomquestion'] = 'Soal acak';
$string['randomquestion_help'] = 'Soal acak adalah cara memasukkan soal yang dipilih secara acak dari kategori tertentu atau dengan label tertentu ke dalam suatu aktivitas.';
$string['randomquestiontags'] = 'Label';
$string['randomquestiontags_help'] = 'Anda dapat membatasi kriteria pemilihan lebih lanjut dengan menentukan beberapa label soal di sini. Soal "acak" akan dipilih dari soal yang memiliki semua label ini.';
$string['randomquestionusinganewcategory'] = 'Soal acak menggunakan kategori baru';
$string['randomwithsubcat'] = 'Pertanyaan dari kategori ini dan subkategorinya.';
$string['readytosend'] = 'Anda akan mengirimkan keseluruhan kuis Anda untuk dinilai. Anda yakin akan melanjutkannya?';
$string['reattemptquiz'] = 'Mengerjakan kuis kembali';
$string['recentlyaddedquestion'] = 'Soal terbaru yang ditambahkan!';
$string['recurse'] = 'Termasuk soal dari subkategori juga';
$string['redoesofthisquestion'] = 'Soal lain dikerjakan di sini: {$a}';
$string['redoquestion'] = 'Coba soal lain seperti ini';
$string['regrade'] = 'Nilai ulang semua pengerjaan kuis';
$string['regradecomplete'] = 'Semua pengerjaan kuis telah dinilai ulang';
$string['regradecount'] = 'Nilai pengerjaan kuis berubah {$a->changed} dari {$a->attempt}';
$string['regradedisplayexplanation'] = 'Pengerjaan kuis yang berubah selama penilaian ulang ditampilkan sebagai tautan ke jendela reviu kuis';
$string['regradenotallowed'] = 'Anda tidak memiliki izin untuk menilai ulang kuis ini';
$string['regradingquestion'] = 'Menilai ulang "{$a}"';
$string['regradingquiz'] = 'Menilai ulang kuis "{$a}"';
$string['remove'] = 'Hapus';
$string['removeallgroupoverrides'] = 'Hapus semua penyampingan grup';
$string['removeallquizattempts'] = 'Hapus semua upaya kuis';
$string['removealluseroverrides'] = 'Hapus semua penyampingan pengguna';
$string['removeemptypage'] = 'Hapus halaman kosong';
$string['removepagebreak'] = 'Hapus jeda halaman';
$string['removeselected'] = 'Hapus yang terpilih';
$string['rename'] = 'Ganti nama';
$string['renderingserverconnectfailed'] = 'Server {$a} gagal memproses permintaan RQP. Periksa apakah URL sudah benar.';
$string['reorderquestions'] = 'Susun ulang soal';
$string['reordertool'] = 'Tampilkan penyusun ulang soal';
$string['repaginate'] = 'Tata dengan {$a} soal per halaman';
$string['repaginatecommand'] = 'Tata halaman';
$string['repaginatenow'] = 'Tata halaman sekarang';
$string['replace'] = 'Ganti';
$string['replacementoptions'] = 'Opsi pengganti';
$string['report'] = 'Laporan';
$string['reportanalysis'] = 'Analisis item';
$string['reportattemptsfrom'] = 'Dikerjakan dari';
$string['reportattemptsthatare'] = 'Pengerjaan kuis yang';
$string['reportdisplayoptions'] = 'Opsi tampilan';
$string['reportfullstat'] = 'Rincian Statistik';
$string['reportmulti_percent'] = 'Multi-persentase';
$string['reportmulti_q_x_student'] = 'Pilihan Multi-Siswa';
$string['reportmulti_resp'] = 'Jawaban individu';
$string['reportmustselectstate'] = 'Anda setidaknya memilih salah satu status.';
$string['reportnotfound'] = 'Laporan tidak diketahui ({$a})';
$string['reportoverview'] = 'Ikhtisar';
$string['reportregrade'] = 'Nilai ulang pengerjaan kuis';
$string['reportresponses'] = 'Jawaban detail';
$string['reports'] = 'Laporan';
$string['reportshowonly'] = 'Hanya tampilkan pengerjaan kuis';
$string['reportshowonlyfinished'] = 'Tunjukan salah satu saja pengerjaan kuis dengan ({$a}) tiap pengguna';
$string['reportsimplestat'] = 'Statistik sederhana';
$string['reportusersall'] = 'semua pengguna yang telah mengerjakan kuis';
$string['reportuserswith'] = 'pengguna terdaftar yang telah mengerjakan kuis';
$string['reportuserswithorwithout'] = 'pengguna terdaftar yang telah atau belum mengerjakan kuis';
$string['reportuserswithout'] = 'pengguna terdaftar yang belum mengerjakan kuis';
$string['reportwhattoinclude'] = 'Apa yang tercantum pada laporan';
$string['requirepassword'] = 'Membutuhkan kata kunci';
$string['requirepassword_help'] = 'Jika kata sandi ditentukan, siswa harus memasukkannya untuk mengerjakan kuis.';
$string['requiresubnet'] = 'Membutuhkan alamat jaringan';
$string['requiresubnet_help'] = 'Akses kuis dapat dibatasi untuk subnet tertentu di LAN atau Internet dengan menentukan daftar nomor alamat IP sebagian atau lengkap yang dipisahkan koma. Ini dapat berguna untuk kuis yang diawasi (terjaga), untuk memastikan bahwa hanya orang di lokasi tertentu yang dapat mengakses kuis.';
$string['response'] = 'Jawaban';
$string['responses'] = 'Jawaban';
$string['results'] = 'Hasil';
$string['returnattempt'] = 'Mengerjakan kembali';
$string['reuseifpossible'] = 'gunakan kembali yang sebelumnya dihapus';
$string['reverttodefaults'] = 'Kembali ke setelan bawaan kuis';
$string['review'] = 'Reviu';
$string['reviewafter'] = 'Izinkan reviu setelah kuis ditutup';
$string['reviewalways'] = 'Izinkan reviu kapan pun';
$string['reviewattempt'] = 'Reviu pengerjaan kuis';
$string['reviewbefore'] = 'Izinkan reviu saat kuis terbuka';
$string['reviewclosed'] = 'Setelah kuis ditutup';
$string['reviewduring'] = 'Ketika mengerjakan';
$string['reviewimmediately'] = 'Segera setelah mengerjakan';
$string['reviewnever'] = 'Jangan pernah izinkan reviu';
$string['reviewofquestion'] = 'Reviu soal {$a->question} di {$a->quiz} oleh {$a->user}';
$string['reviewopen'] = 'Nanti, ketika kuis masih dibuka';
$string['reviewoptions'] = 'Siswa dapat mereviu';
$string['reviewoptionsheading'] = 'Opsi reviu';
$string['reviewoptionsheading_help'] = 'Opsi ini mengontrol informasi apa yang dapat dilihat siswa saat mereka mengulas pengerjaan kuis atau melihat laporan kuis.

** Ketika mengerjakan ** setelan hanya relevan untuk beberapa perilaku, seperti \'interaktif dengan banyak pengerjaan kuis\', yang mungkin menampilkan umpan balik selama sedang mengerjakan.

** Segera setelah mengerjakan ** setelan berlaku untuk dua menit pertama setelah \'Kirimkan semua dan selesai\' di-klik.
** Nanti ketika kuis masih dibuka ** setelan berlaku setelah ini, dan sebelum tanggal kuis.

** Setelah kuis ditutup ** setelan berlaku setelah tanggal penutupan kuis sudah lewat. Jika kuis tidak memiliki tanggal tutup, keadaan ini tidak pernah tercapai.';
$string['reviewoverallfeedback'] = 'Masukan secara umum';
$string['reviewoverallfeedback_help'] = 'Umpan balik yang diberikan pada akhir pengerjaan kuis, tergantung pada nilai total siswa.';
$string['reviewresponse'] = 'Reviu jawaban';
$string['reviewresponsetoq'] = 'Reviu jawaban (soal {$a})';
$string['reviewthisattempt'] = 'Reviu jawaban Anda terhadap pengerjaan kuis ini';
$string['rqp'] = 'Soal jarak jauh';
$string['rqps'] = 'Soal jarak jauh';
$string['sameasoverall'] = 'Sama seperti nilai keseluruhan';
$string['save'] = 'Simpan';
$string['saveandedit'] = 'Simpan perubahan dan edit soal';
$string['saveattemptfailed'] = 'Gagal menyimpan penyimpanan kuis saat ini.';
$string['savedfromdeletedcourse'] = 'Disimpan dari pelajaran yang dihapus "{$a}"';
$string['savegrades'] = 'Simpan nilai';
$string['savemyanswers'] = 'Simpan jawaban saya';
$string['savenosubmit'] = 'Simpan tanpa menyerahkan';
$string['saveoverrideandstay'] = 'Simpan dan masukkan penyampingan lain';
$string['savequiz'] = 'Simpan keseluruhan kuis ini';
$string['saving'] = 'Menyimpan';
$string['savingnewgradeforquestion'] = 'Menyimpan nilai baru untuk id soal {$a}.';
$string['savingnewmaximumgrade'] = 'Menyimpan nilai maksimum baru.';
$string['score'] = 'Skor mentah';
$string['scores'] = 'Skor';
$string['search:activity'] = 'Kuis - informasi aktivitas';
$string['sectionheadingedit'] = 'Edit tajuk \'{$a}\'';
$string['sectionheadingremove'] = 'Hapus tajuk \'{$a}\'';
$string['sectionnoname'] = 'Bagian tanpa judul';
$string['seequestions'] = '(lihat soal)';
$string['select'] = 'Pilih';
$string['selectall'] = 'Pilih semua';
$string['selectattempt'] = 'Pilih pengerjaan kuis';
$string['selectcategory'] = 'Pilih kategori';
$string['selectedattempts'] = 'Pengerjaan kuis yang dipilih...';
$string['selectmultipleitems'] = 'Pilih beberapa item';
$string['selectmultipletoolbar'] = 'Pilih beberapa bilah alat';
$string['selectnone'] = 'Hilangkan semua seleksi';
$string['selectquestionslot'] = 'Pilih soal {$a}';
$string['selectquestiontype'] = '-- Pilih jenis soal --';
$string['serveradded'] = 'Server ditambahkan';
$string['serveridentifier'] = 'Pengenal';
$string['serverinfo'] = 'Informasi server';
$string['servers'] = 'Server';
$string['serverurl'] = 'URL server';
$string['shortanswer'] = 'Jawaban pendek';
$string['show'] = 'Tampilkan';
$string['showall'] = 'Tampilkan seluruh soal dalam satu halaman';
$string['showblocks'] = 'Tampilkan blok selama mengerjakan kuis';
$string['showblocks_help'] = 'Jika diatur ke \'ya\' maka blok normal akan ditampilkan selama mengerjaan kuis';
$string['showbreaks'] = 'Tampilkan jeda halaman';
$string['showcategorycontents'] = 'Tampilkan konten kategori {$a->arrow}';
$string['showcorrectanswer'] = 'Pada umpan balik, tampilkan jawaban yang benar?';
$string['showdetailedmarks'] = 'Tunjukkan detail nilai';
$string['showeachpage'] = 'Tampilkan 1 soal satu halaman';
$string['showfeedback'] = 'Setelah menjawab, tampilkan umpan balik?';
$string['showinsecurepopup'] = 'Gunakan jendela sembulan \'aman\' untuk mengerjakan';
$string['showlargeimage'] = 'Gambar besar';
$string['shownoattempts'] = 'Tampilkan siswa yang tidak mengerjakan';
$string['shownoattemptsonly'] = 'Tampilkan hanya siswa yang tidak mengerjakan';
$string['shownoimage'] = 'Tanpa gambar';
$string['showreport'] = 'Tampilkan laporan';
$string['showsmallimage'] = 'Gambar kecil';
$string['showteacherattempts'] = 'Tampilkan pengerjaan kuis pengajar';
$string['showuserpicture'] = 'Tunjukkan gambar pengguna';
$string['showuserpicture_help'] = 'Jika diaktifkan, nama dan gambar siswa akan ditampilkan di layar selama mengerjakan kuis, dan di layar reviu, membuatnya lebih mudah untuk memeriksa apakah siswa masuk sebagai dirinya sendiri dalam ujian yang diawasi (dilindungi).';
$string['shuffle'] = 'Acak';
$string['shuffleanswers'] = 'Acak jawaban';
$string['shuffledrandomly'] = 'Kocok acak';
$string['shufflequestions'] = 'Kocok soal';
$string['shufflequestions_help'] = 'Jika Anda mengaktifkannya, maka setiap kali mengerjakan kuis, urutan soal di bagian ini akan dikocok menjadi urutan acak yang berbeda. Ini dapat mempersulit siswa untuk membagikan jawaban, tetapi juga mempersulit siswa mendiskusikan soal tertentu dengan Anda.';
$string['shufflewithin'] = 'Acak dalam soal';
$string['shufflewithin_help'] = 'Jika diaktifkan, bagian-bagian yang membentuk setiap soal akan diacak secara acak setiap kali seorang siswa mengerjakan kuis, asalkan opsi tersebut juga diaktifkan dalam setelan soal. Setelan ini hanya berlaku untuk soal yang memiliki beberapa bagian, seperti beberapa pilihan atau soal yang cocok.';
$string['singleanswer'] = 'PIlih satu jawaban.';
$string['sortage'] = 'Urut umur';
$string['sortalpha'] = 'Urut nama';
$string['sortquestionsbyx'] = 'Urut soal menurut: {$a}';
$string['sortsubmit'] = 'Urutkan soal';
$string['sorttypealpha'] = 'Urutkan tipe, nama';
$string['specificapathnotonquestion'] = 'Jalur berkas yang ditentukan tidak ada pada soal yang ditentukan';
$string['specificquestionnotonquiz'] = 'Soal yang ditentukan tidak ada dalam kuis yang ditentukan';
$string['startagain'] = 'Mulai lagi';
$string['startattempt'] = 'Mulai mengerjakan';
$string['startedon'] = 'Dimulai pada';
$string['startnewpreview'] = 'Mulai pratinjau baru';
$string['stateabandoned'] = 'Tidak pernah mengerjakan';
$string['statefinished'] = 'Selesai mengerjakan';
$string['statefinisheddetails'] = 'Diserahkan {$a}';
$string['stateinprogress'] = 'Sedang dikerjakan';
$string['statenotloaded'] = 'Status soal {$a} belum dimuat dari basis data.';
$string['stateoverdue'] = 'Terlambat';
$string['stateoverduedetails'] = 'Harus diserahkan sebelum {$a}';
$string['status'] = 'Status';
$string['stoponerror'] = 'Setop ketika galat';
$string['submission_confirmation'] = 'Kirimkan semua jawaban Anda dan selesaikan?';
$string['submission_confirmation_unanswered'] = 'Soal tanpa jawaban: {$a}';
$string['submitallandfinish'] = 'Kirim semua dan selesai';
$string['subneterror'] = 'Maaf, kuis ini telah dikunci sehingga hanya dapat diakses dari lokasi tertentu. Saat ini komputer Anda bukan salah satu dari yang diizinkan untuk membuka kuis ini.';
$string['subnetnotice'] = 'Kuis ini telah dikunci sehingga hanya dapat diakses dari lokasi tertentu. Komputer Anda tidak berada di subnet yang diizinkan. Sebagai pengajar, Anda tetap diizinkan untuk melakukan pratinjau.';
$string['subplugintype_quiz'] = 'Laporan';
$string['subplugintype_quiz_plural'] = 'Laporan';
$string['subplugintype_quizaccess'] = 'Aturan akses';
$string['subplugintype_quizaccess_plural'] = 'Aturan akses';
$string['substitutedby'] = 'akan digantikan oleh';
$string['summaryofattempt'] = 'Rangkuman hasil pengerjaan kuis';
$string['summaryofattempts'] = 'Ringkasan pengerjaan kuis sebelumnya';
$string['temporaryblocked'] = 'Untuk sementara Anda tidak diizinkan untuk mengerjakan kembali kuis. <br /> Anda dapat melakukan mengerjakan lagi pada:';
$string['theattempt'] = 'Pengerjaan kuis';
$string['theattempt_help'] = 'Apakah siswa dapat mereviu ulang pengerjaan kuis atau tidak.';
$string['time'] = 'Waktu';
$string['timecompleted'] = 'Selesai';
$string['timedelay'] = 'Anda tidak diperbolehkan mengerjakan kuis karena Anda belum melewati waktu tunda sebelum mengerjakan kuis lain';
$string['timeleft'] = 'Sisa waktu';
$string['timelimit'] = 'Waktu pengerjaan';
$string['timelimit_help'] = 'Jika diaktifkan, batas waktu dinyatakan di halaman kuis awal dan penghitung waktu mundur ditampilkan di blok navigasi kuis.';
$string['timelimit_link'] = 'mod/quiz/timing';
$string['timelimitexeeded'] = 'Maaf! Waktu pengerjaan sudah melampai batas!';
$string['timestr'] = '%H:%M:%S on %d/%m/%y';
$string['timesup'] = 'Waktu berakhir!';
$string['timetaken'] = 'Waktu pengerjaan';
$string['timing'] = 'Waktu Pengerjaan';
$string['tofile'] = 'ke berkas';
$string['tolerance'] = 'Toleransi';
$string['toomanyrandom'] = 'Jumlah soal acak yang dibutuhkan lebih dari yang masih tersedia dalam kategori!';
$string['top'] = 'Puncak';
$string['totalmarksx'] = 'Total nilai: {$a}';
$string['totalquestionsinrandomqcategory'] = 'Terdapat {$a} soal dalam kategori.';
$string['true'] = 'Benar';
$string['truefalse'] = 'Benar/Salah';
$string['type'] = 'Tipe';
$string['unfinished'] = 'buka';
$string['ungraded'] = 'Belum dinilai';
$string['unit'] = 'Unit';
$string['unknowntype'] = 'Jenis soal tidak didukung pada baris {$a}. Soalnya akan diabaikan';
$string['updateoverdueattemptstask'] = 'Memperbarui pengerjaan kuis yang lewat waktu';
$string['updatequizslotswithrandomxofy'] = 'Perbaharui slot kuis dengan data \'soal acak\'  ({$a->done}/{$a->total})';
$string['updatesettings'] = 'Perbarui setelan kuis';
$string['updatingatttemptgrades'] = 'Perbaharui nilai pengerjaan kuis.';
$string['updatingfinalgrades'] = 'Perbaharui nilai akhir';
$string['updatingthegradebook'] = 'Perbaharui buku nilai';
$string['upgradesure'] = '<div> Khususnya modul kuis akan melakukan perubahan ekstensif pada tabel kuis dan peningkatan ini belum cukup diuji. Anda sangat disarankan untuk membuat cadangan tabel basis data Anda sebelum melanjutkan. </div>';
$string['upgradingquizattempts'] = 'Perbarui pengerjaan kuis: kuis {$a->done}/{$a->outof} (ID kuis {$a->info})';
$string['upgradingveryoldquizattempts'] = 'Meningkatkan pengerjaan kuis yang sangat lama: {$a->done}/{$a->outof}';
$string['url'] = 'URL';
$string['usedcategorymoved'] = 'Kategori ini telah disimpan dan dipindahkan ke tingkat situs karena ini adalah kategori yang diterbitkan dan masih digunakan oleh kursus lain.';
$string['useroverrides'] = 'Penyampingan pengguna';
$string['useroverridesdeleted'] = 'Penyampingan pengguna dihapus';
$string['usersnone'] = 'Tidak ada siswa yang memiliki akses ke kuis ini';
$string['validate'] = 'Validasi';
$string['viewallanswers'] = 'Lihat pengerjaan kuis {$a}';
$string['viewallreports'] = 'Tampilkan laporan untuk {$a} pengerjaan kuis';
$string['viewed'] = 'Dilihat';
$string['warningmissingtype'] = '<b> Soal ini adalah jenis yang belum dipasang pada Moodle Anda. <br /> Harap beri tahu administrator Moodle Anda. </b>';
$string['wheregrade'] = 'Dimana nilaiku?';
$string['wildcard'] = 'Wild card';
$string['windowclosing'] = 'Jendela ini akan segara menutup';
$string['withsummary'] = 'dengan ringkasan statistik';
$string['wronguse'] = 'Anda tidak dapat menggunakan halaman ini seperti itu.';
$string['xhtml'] = 'XHTML';
$string['youneedtoenrol'] = 'Anda perlu mendaftarkan diri pada kursus sebelum mengerjakan kuis ini';
$string['yourfinalgradeis'] = 'Nilai akhir Anda untuk kuis ini adalah {$a}';
