<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'h5p', language 'id', version '4.1'.
 *
 * @package     h5p
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['a11yTitle:label'] = 'Label Teknologi Bantuan';
$string['acceptTerms'] = 'Saya menerima <a href=":url" target="_blank">persyaratan penggunaan</a>';
$string['accountDetailsLinkText'] = 'di sini';
$string['actions'] = 'Tindakan';
$string['add'] = 'Tambahkan';
$string['addedandupdatedpp'] = 'Menambahkan {$a->%new} pustaka H5P baru dan memperbarui {$a->%old} yang lama.';
$string['addedandupdatedps'] = 'Menambahkan {$a->%new} pustaka H5P baru dan memperbarui {$a->%old} yang lama.';
$string['addedandupdatedsp'] = 'Menambahkan {$a->%new} pustaka H5P baru dan memperbarui {$a->%old} yang lama.';
$string['addedandupdatedss'] = 'Menambahkan {$a->%new} pustaka H5P baru dan memperbarui {$a->%old} yang lama.';
$string['addednewlibraries'] = 'Menambahkan {$a->%new} pustaka H5P baru.';
$string['addednewlibrary'] = 'Menambahkan {$a->%new} pustaka H5P baru.';
$string['additionallicenseinfo'] = 'Informasi tambahan tentang lisensi';
$string['address'] = 'Alamat';
$string['age'] = 'Usia tipikal';
$string['ageDescription'] = 'Target pemirsa konten ini. Kemungkinan format masukan dipisahkan dengan koma: "1,34-45,-50,59-".';
$string['altText'] = 'Teks alternatif';
$string['atto_h5p'] = 'Sisipkan tombol H5P';
$string['atto_h5p_description'] = 'Tombol Sisipkan H5P di editor Atto memungkinkan pengguna memasukkan konten H5P dengan memasukkan URL atau kode sematan, atau dengan mengunggah berkas H5P.';
$string['author'] = 'Penulis';
$string['authorcomments'] = 'Komentar penulis';
$string['authorcommentsdescription'] = 'Komentar untuk editor konten. (Teks ini tidak akan dipublikasikan sebagai bagian dari info hak cipta.)';
$string['authorname'] = 'Nama penulis';
$string['authorrole'] = 'Peran penulis';
$string['back'] = 'Kembali';
$string['by'] = 'oleh';
$string['cancelPublishConfirmationDialogCancelButtonText'] = 'Tidak';
$string['cancelPublishConfirmationDialogConfirmButtonText'] = 'Ya';
$string['cancelPublishConfirmationDialogDescription'] = 'Yakin ingin membatalkan proses berbagi?';
$string['cancelPublishConfirmationDialogTitle'] = 'Batalkan berbagi';
$string['cancellabel'] = 'Batalkan';
$string['ccattribution'] = 'Atribusi (CC BY)';
$string['ccattributionnc'] = 'Atribusi-Nonkomersial (CC BY-NC)';
$string['ccattributionncnd'] = 'Attribusi-Nonkomersial-NoDerivs (CC BY-NC-ND)';
$string['ccattributionncsa'] = 'Attribusi-Nonkomersial-ShareAlike (CC BY-NC-SA)';
$string['ccattributionnd'] = 'Attribusi-NoDerivs (CC BY-ND)';
$string['ccattributionsa'] = 'Attribusi-ShareAlike (CC BY-SA)';
$string['ccpdd'] = 'Dedikasi Domain Publik (CC0)';
$string['changeHasBeenSubmitted'] = 'Perubahan telah diajukan untuk';
$string['changedby'] = 'Diubah oleh';
$string['changedescription'] = 'Deskripsi ubahan';
$string['changelog'] = 'Catatan ubahan';
$string['changeplaceholder'] = 'Foto terpotong, teks berubah, dll.';
$string['city'] = 'Kota';
$string['close'] = 'Tutup';
$string['confirmdialogbody'] = 'Harap konfirmasi bahwa Anda ingin melanjutkan. Tindakan ini tidak bisa dibatalkan.';
$string['confirmdialogheader'] = 'Konfirmasikan tindakan';
$string['confirmlabel'] = 'Konfirmasi';
$string['connectionLost'] = 'Koneksi terputus. Hasil akan disimpan dan dikirim ketika koneksi dibangun kembali.';
$string['connectionReestablished'] = 'Koneksi dibangun kembali.';
$string['contactPerson'] = 'Kontak pribadi';
$string['contactPersonDescription'] = 'H5P akan menghubungi narahubung jika ada masalah dengan konten yang dibagikan oleh penerbit. Nama narahubung atau informasi lainnya tidak akan dipublikasikan atau dibagikan dengan pihak ketiga';
$string['contentAvailable'] = 'Konten Anda biasanya akan tersedia di Hub dalam satu hari kerja.';
$string['contentCopied'] = 'Konten disalin ke papan klip';
$string['contentLicenseTitle'] = 'Info lisensi konten';
$string['contentUpdateSoon'] = 'Konten Anda akan segera diperbarui';
$string['contentchanged'] = 'Konten ini telah berubah sejak terakhir kali Anda menggunakannya.';
$string['contentinuse'] = 'Konten ini mungkin digunakan di tempat lain.';
$string['contenttype'] = 'Tipe konten';
$string['copyright'] = 'Hak pakai';
$string['copyrightWarning'] = 'Materi berhak cipta tidak dapat dibagikan di H5P Content Hub. Jika konten dilisensikan dengan lisensi ramah OER seperti Creative Commons, silakan pilih lisensi yang sesuai. Jika tidak, konten ini tidak dapat dibagikan.';
$string['copyrightinfo'] = 'Informasi hak cipta';
$string['copyrightstring'] = 'Hak cipta';
$string['copyrighttitle'] = 'Lihat informasi hak cipta untuk konten ini.';
$string['couldNotParseJSONFromZip'] = 'Tidak dapat mengurai JSON dari paket: {$a->%fileName}';
$string['couldNotReadFileFromZip'] = 'Tidak dapat membaca file dari paket: {$a->%fileName}';
$string['country'] = 'Negara';
$string['creativecommons'] = 'Creative Commons';
$string['currentStep'] = 'Langkah :step dari :total';
$string['date'] = 'Tanggal';
$string['deletelibraryconfirm'] = '<p>Yakin ingin menghapus versi <em>\'{$a->version}\'</em> dari pustaka <em>\'{$a->name}\'</em>? Ini akan menghapus pustaka dan semua kegunaannya.</p><p>Operasi ini tidak dapat diurungkan.</p>';
$string['deletelibraryversion'] = 'Hapus versi';
$string['deleting'] = 'Menghapus pustaka';
$string['description'] = 'Keterangan';
$string['disablefullscreen'] = 'Nonaktifkan layar penuh';
$string['discipline:dropdownButton'] = 'Tombol tarik-turun';
$string['discipline:in'] = 'dalam';
$string['discipline:searchPlaceholder'] = 'Ketik untuk mencari disiplin ilmu';
$string['disciplineDescription'] = 'Anda dapat memilih beberapa disiplin ilmu';
$string['disciplineLabel'] = 'Disiplin';
$string['disciplineLimitReachedMessage'] = 'Anda dapat memilih hingga :numDisciplines disiplin ilmu';
$string['disciplines'] = 'Disiplin';
$string['download'] = 'Unduh';
$string['downloadtitle'] = 'Unduh konten ini sebagai file H5P.';
$string['editInfoTitle'] = 'Edit info untuk <strong>:title</strong>';
$string['editcontent'] = 'Edit konten H5P';
$string['editingFailed'] = 'Pengeditan gagal.';
$string['editor'] = 'Editor';
$string['emailAddress'] = 'Alamat surel';
$string['emailAddressDescription'] = 'Alamat surel akan digunakan oleh H5P untuk menghubungi penerbit jika ada masalah dengan konten atau jika penerbit perlu memulihkan akun mereka. Itu tidak akan dipublikasikan atau dibagikan dengan pihak ketiga mana pun';
$string['embed'] = 'Tanamkan';
$string['embedtitle'] = 'Lihat kode sematan untuk konten ini.';
$string['error:emptycontentid'] = 'URL yang diberikan salah atau Anda tidak dapat mengedit berkas ini.';
$string['eventh5pdeleted'] = 'H5P dihapus';
$string['eventh5pviewed'] = 'Melihat konten H5P';
$string['feature'] = 'Fitur';
$string['fetchtypesfailure'] = 'Tidak ada informasi yang dapat diperoleh tentang jenis konten H5P yang tersedia. Kegagalan koneksi repositori H5P';
$string['fileExceedsMaxSize'] = 'Salah satu berkas di dalam paket melebihi ukuran berkas maksimum yang diizinkan. ({$a->%file} {$a->%used} > {$a->%max})';
$string['filter_displayh5p'] = 'Tampilkan filter H5P';
$string['filter_displayh5p_description'] = 'Filter Display H5P mengonversi URL menjadi konten H5P yang disematkan.';
$string['fullscreen'] = 'Layar penuh';
$string['gpl'] = 'General Public License v3';
$string['h5p'] = 'H5P';
$string['h5peditor'] = 'Editor H5P';
$string['h5pfilenotfound'] = 'Berkas H5P tidak ditemukan';
$string['h5pinvalidurl'] = 'URL konten H5P tidak valid.';
$string['h5plibraryhandler'] = 'Pengendali kerangka kerja H5P';
$string['h5plibraryhandler_help'] = 'Kerangka kerja H5P digunakan untuk menampilkan konten H5P. Versi terbaru direkomendasikan.';
$string['h5pmanage'] = 'Kelola jenis konten H5P';
$string['h5poverview'] = 'Ikhtisar H5P';
$string['h5ppackage'] = 'Jenis konten H5P';
$string['h5ppackage_help'] = 'Tipe konten H5P adalah file dengan ekstensi H5P atau ZIP yang berisi semua pustaka yang diperlukan untuk menampilkan konten.';
$string['h5pprivatefile'] = 'Konten H5P ini tidak dapat ditampilkan karena Anda tidak memiliki akses ke file .h5p.';
$string['h5psettings'] = 'Setelan H5P';
$string['h5ptitle'] = 'Kunjungi h5p.org untuk melihat lebih banyak konten.';
$string['helpChoosingLicense'] = 'Bantu saya memilih lisensi';
$string['hideadvanced'] = 'Sembunyikan lanjut';
$string['icon'] = 'ikon';
$string['iconDescription'] = '640x480px. Jika tidak dipilih konten akan menggunakan ikon kategori';
$string['installedcontentlibraries'] = 'Pustaka H5P yang terpasang';
$string['installedcontenttypes'] = 'Jenis konten H5P yang diinstal';
$string['installedh5p'] = 'Terpasang H5P';
$string['invalidAge'] = 'Format input tidak valid untuk Usia normal. Format masukan yang mungkin dipisahkan dengan koma: "1, 34-45, -50, -59-".';
$string['invalidcontextid'] = 'File H5P tidak ditemukan (contextid tidak valid)';
$string['invalidfile'] = 'Berkas "{$a->%filename}" tidak diizinkan. Hanya berkas dengan ekstensi berikut yang diizinkan: {$a->%files-allowed}.';
$string['invalidlanguagefile'] = 'File bahasa tidak valid {$a->%file} di perpustakaan {$a->%library}';
$string['invalidlanguagefile2'] = 'File bahasa yang tidak valid {$a->%languageFile} telah disertakan di perpustakaan {$a->%name}';
$string['invalidlibrarydata'] = 'Data tidak valid disediakan untuk {$a->%property} di {$a->%library}';
$string['invalidlibrarydataboolean'] = 'Data tidak valid diberikan untuk {$a->%property} di {$a->%library}. Boolean diharapkan.';
$string['invalidlibraryname'] = 'Nama perpustakaan tidak valid: {$a->%name}';
$string['invalidlibrarynamed'] = 'Pustaka H5P {$a->%library} yang digunakan dalam konten tidak valid';
$string['invalidlibraryoption'] = 'Opsi ilegal {$a->%option} di {$a->%library}';
$string['invalidlibraryproperty'] = 'Tidak dapat membaca properti {$a->%property} di {$a->%library}';
$string['invalidmainjson'] = 'File h5p.json utama yang valid tidak ada';
$string['invalidmultiselectoption'] = 'Opsi yang dipilih tidak valid dalam multi-pilihan.';
$string['invalidpackage'] = 'Jenis konten H5P tidak valid';
$string['invalidselectoption'] = 'Opsi yang dipilih tidak valid di pilih.';
$string['invalidsemanticsjson'] = 'File semantics.json yang tidak valid telah disertakan di perpustakaan {$a->%name}';
$string['invalidsemanticstype'] = 'Kesalahan internal H5P: jenis konten tidak dikenal "{$a->@type}" dalam semantik. Menghapus konten!';
$string['invalidstring'] = 'String yang diberikan tidak valid menurut regexp dalam semantik. (nilai: "{$a->%nilai}", regexp: "{$a->%regexp}")';
$string['isNowSubmitted'] = 'Sekarang dikirim ke H5P Hub';
$string['keywordExists'] = 'Kata kunci sudah ada!';
$string['keywords'] = 'Kata kunci';
$string['keywordsDescription'] = 'Anda dapat menambahkan beberapa kata kunci yang dipisahkan dengan koma. Tekan "Enter" atau "Add" untuk mengonfirmasi kata kunci';
$string['keywordsExits'] = 'Kata kunci sudah ada!';
$string['keywordsPlaceholder'] = 'Tambahkan kata kunci';
$string['language'] = 'Bahasa';
$string['level'] = 'Level';
$string['librariesmanagerdescription'] = '<p>H5P memungkinkan pengguna membuat konten interaktif dengan menyediakan berbagai jenis konten. </p><p>Untuk memastikan bahwa hanya jenis konten H5P tepercaya yang digunakan di situs Anda, Anda perlu <i>salah satu</i></p><ul><li>Mengunggah jenis konten H5P dari h5p.org <i>atau</i></li><li>Aktifkan tugas terjadwal \'Unduh jenis konten H5P yang tersedia dari h5p.org\'</li></ul><p>Perhatikan bahwa pengguna hanya dapat menggunakan jenis konten H5P yang dipasang di situs Anda.</p>';
$string['librarydirectoryerror'] = 'Nama direktori pustaka harus cocok dengan machineName atau machineName-majorVersion.minorVersion (dari library.json). (Direktori: {$a->%directoryName} , machineName: {$a->%machineName}, majorVersion: {$a->%majorVersion}, minorVersion: {$a->%minorVersion})';
$string['license'] = 'Lisensi';
$string['licenseCC010'] = 'CC0 1.0 Universal (CC0 1.0) Dedikasi Domain Publik';
$string['licenseCC010U'] = 'CC0 1.0 Universal';
$string['licenseCC10'] = '1.0 Generik';
$string['licenseCC20'] = '2.0 Generik';
$string['licenseCC25'] = '2.5 Generik';
$string['licenseCC30'] = '3.0 Unported';
$string['licenseCC40'] = '4.0 Internasional';
$string['licenseDescription'] = 'Pilih lisensi untuk konten Anda';
$string['licenseDetails'] = 'Detail lisensi';
$string['licenseDialogDescription'] = 'Klik lisensi tertentu untuk mendapatkan info tentang penggunaan yang tepat';
$string['licenseGPL'] = 'General Public License';
$string['licenseV1'] = 'Versi 1';
$string['licenseV2'] = 'Versi 2';
$string['licenseV3'] = 'Versi 3';
$string['licenseVersionDescription'] = 'Pilih versi lisensi';
$string['licensee'] = 'Penerima Lisensi';
$string['licenseextras'] = 'Ekstra lisensi';
$string['licenseversion'] = 'Versi lisensi';
$string['lockh5pdeploy'] = 'Konten H5P ini tidak dapat diakses karena sedang di-deploy. Silakan coba lagi nanti.';
$string['logoUploadText'] = 'Logo organisasi atau avatar';
$string['longDescription'] = 'Deskripsi panjang';
$string['longDescriptionPlaceholder'] = 'Deskripsi panjang tentang konten Anda';
$string['mainTitle'] = 'Berbagi <strong>:title</strong>';
$string['mainlibrarydisabled'] = 'Berkas ini tidak dapat ditampilkan karena tipe kontennya dinonaktifkan. Harap hubungi administrator Anda untuk meminta jenis konten diaktifkan.';
$string['maxLength'] = ':length adalah jumlah maksimum karakter';
$string['missingcontentfolder'] = 'Folder konten yang valid tidak ada';
$string['missingcoreversion'] = 'Sistem tidak dapat menginstal komponen {$a->%component} dari paket, karena memerlukan versi server H5P yang lebih baru. Situs ini saat ini menjalankan versi {$a->%current}, sedangkan versi yang diperlukan adalah {$a->%required} atau lebih tinggi. Harap tingkatkan dan coba lagi.';
$string['missingdependency'] = 'Ketergantungan {$a->@dep} tidak ada yang diperlukan oleh {$a->@lib}.';
$string['missinglibrary'] = 'Pustaka wajib {$a->@library} tidak ada';
$string['missinglibraryfile'] = 'Berkas "{$a->%file}" hilang dari pustaka: "{$a->%name}"';
$string['missinglibraryjson'] = 'Tidak dapat menemukan berkas library.json dengan format json yang valid untuk pustaka {$a->%name}';
$string['missinglibraryproperty'] = 'Properti wajib {$a->%property} tidak ada di {$a->%library}';
$string['missingmbstring'] = 'Ekstensi PHP mbstring tidak dimuat. Diperlukan agar H5P berfungsi dengan baik.';
$string['missinguploadpermissions'] = 'Perhatikan bahwa pustaka mungkin ada di berkas yang Anda unggah, tetapi Anda tidak diizinkan untuk mengunggah pustaka baru. Silakan hubungi administrator Anda.';
$string['next'] = 'Selanjutnya';
$string['nocopyright'] = 'Tidak ada informasi hak cipta untuk konten ini.';
$string['noextension'] = 'Berkas yang Anda unggah bukan Paket HTML5 yang valid. (Tidak memiliki ekstensi berkas .h5p.)';
$string['noh5plibhandlerdefined'] = 'Tidak ada pengendali kerangka H5P yang diinstal, jadi konten H5P tidak dapat ditampilkan.';
$string['nojson'] = 'File h5p.json utama tidak valid';
$string['nopermissiontodeploy'] = 'Berkas ini tidak dapat ditampilkan karena telah diunggah oleh pengguna tanpa kemampuan yang diperlukan untuk menyebarkan konten H5P.';
$string['nopermissiontoedit'] = 'Anda tidak memiliki izin untuk mengedit konten H5P.';
$string['notrustablefile'] = 'Berkas ini tidak dapat ditampilkan karena telah diunggah oleh pengguna tanpa kemampuan untuk memperbarui tipe konten H5P. Harap hubungi administrator Anda untuk meminta jenis konten yang akan diinstal.';
$string['nounzip'] = 'Berkas yang Anda unggah bukan Paket HTML5 yang valid. (Tidak mungkin untuk mengurainya.)';
$string['offlineDialogBody'] = 'Kami tidak dapat mengirim informasi tentang penyelesaian tugas Anda ini. Silakan periksa koneksi internet Anda.';
$string['offlineDialogHeader'] = 'Koneksi Anda ke server terputus';
$string['offlineDialogRetryButtonLabel'] = 'Coba lagi';
$string['offlineDialogRetryMessage'] = 'Sedang mencoba dalam :nomer...';
$string['offlineSuccessfulSubmit'] = 'Berhasil menyerahkan hasil.';
$string['optionalInfo'] = 'Informasi opsional';
$string['originator'] = 'Pencipta';
$string['pd'] = 'Domain publik';
$string['pddl'] = 'Dedikasi domain publik dan lisensi';
$string['pdm'] = 'Public Domain Mark (PDM)';
$string['phone'] = 'Telepon';
$string['pleaseWait'] = 'Harap tunggu...';
$string['pluginname'] = 'Paket H5P';
$string['privacy:metadata'] = 'Subsistem H5P tidak menyimpan data pribadi apa pun.';
$string['publisherDescription'] = 'Deskripsi penerbit';
$string['publisherDescriptionText'] = 'Ini akan ditampilkan di bawah "Info penerbit" pada konten yang dibagikan';
$string['publisherFieldDescription'] = 'Ini akan ditampilkan sebagai "Nama penerbit" pada konten yang dibagikan';
$string['publisherFieldTitle'] = 'Penerbit';
$string['registerOnHub'] = 'Daftar di H5P Hub';
$string['registrationFailed'] = 'Terjadi kesalahan';
$string['registrationFailedDescription'] = 'Kami tidak dapat membuat akun saat ini. Ada yang salah. Coba lagi nanti.';
$string['registrationTitle'] = 'Registrasi Hub H5P';
$string['remove'] = 'Hapus';
$string['removeChip'] = 'Hapus :chip dari daftar';
$string['removeImage'] = 'Hapus gambar';
$string['requiredInfo'] = 'informasi yang diperlukan';
$string['resizescript'] = 'Sertakan skrip ini di situs web Anda jika Anda ingin ukuran dinamis dari konten yang disematkan:';
$string['resubmitScores'] = 'Mencoba mengirim hasil yang disimpan.';
$string['reuse'] = 'Gunakan kembali';
$string['reuseContent'] = 'Gunakan kembali konten';
$string['reuseDescription'] = 'Gunakan kembali konten ini';
$string['reviewAndSave'] = 'Tinjau & Simpan';
$string['reviewAndShare'] = 'Tinjau & Bagikan';
$string['reviewInfo'] = 'Tinjau info';
$string['reviewMessage'] = 'Harap tinjau info di bawah ini sebelum Anda berbagi';
$string['saveChanges'] = 'Simpan perubahan';
$string['screenshots'] = 'Tangkapan layar';
$string['screenshotsDescription'] = 'Tambahkan hingga lima tangkapan layar konten Anda';
$string['share'] = 'Bagikan';
$string['shareFailed'] = 'Gagal berbagi.';
$string['shareTryAgain'] = 'Ada yang tidak beres, coba bagikan lagi.';
$string['shared'] = 'Dibagikan';
$string['sharingNote'] = 'Semua detail konten dapat diedit setelah dibagikan';
$string['shortDescription'] = 'Deskripsi Singkat';
$string['shortDescriptionPlaceholder'] = 'Deskripsi singkat tentang konten Anda';
$string['showadvanced'] = 'Tampilkan lanjut';
$string['showless'] = 'Tampilkan sedikit';
$string['showmore'] = 'Tampilkan lebih';
$string['size'] = 'Ukuran';
$string['someKeywordsExits'] = 'Beberapa dari kata kunci ini sudah ada';
$string['source'] = 'Sumber';
$string['startingover'] = 'Anda akan memulai dari awal.';
$string['status'] = 'Status';
$string['subContentWarning'] = 'Sub-konten (gambar, pertanyaan, dll.) akan dibagikan di bawah :license kecuali ditentukan lain dalam alat pembuat';
$string['sublevel'] = 'Subtingkat';
$string['submitted'] = 'Terkirim!';
$string['successfullyRegistred'] = 'Anda telah berhasil mendaftarkan akun di H5P Hub';
$string['successfullyRegistredDescription'] = 'Detail akun Anda dapat diubah';
$string['successfullyUpdated'] = 'Setelan akun H5P Hub Anda telah berhasil diubah';
$string['task_h5p'] = 'Tugas terjadwal H5P';
$string['task_h5p_description'] = 'Tugas terjadwal H5P mengunduh jenis konten H5P yang tersedia dari h5p.org.';
$string['thumbnail'] = 'Gambar kecil';
$string['title'] = 'Judul';
$string['undisclosed'] = 'Tidak diungkapkan';
$string['unpackedFilesExceedsMaxSize'] = 'Ukuran total berkas yang dibongkar melebihi ukuran maksimum yang diizinkan. ({$a->%used} > {$a->%max})';
$string['updateRegistrationOnHub'] = 'Simpan setelan akun';
$string['updatedlibraries'] = 'Pustaka H5P {$a->%old} diperbarui.';
$string['updatedlibrary'] = 'Pustaka H5P {$a->%old} diperbarui.';
$string['uploadlibraries'] = 'Unggah jenis konten H5P';
$string['uploadsuccess'] = 'Jenis konten H5P berhasil diunggah';
$string['wrongversion'] = 'Versi pustaka H5P {$a->%machineName} yang digunakan dalam konten ini tidak valid. Konten berisi {$a->%contentLibrary}, tetapi seharusnya {$a->%semanticsLibrary}.';
$string['year'] = 'Tahun';
$string['years'] = 'Tahun';
$string['yearsfrom'] = 'Tahun (dari)';
$string['yearsto'] = 'Tahun (ke)';
$string['zip'] = 'Zip';
