<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'appointment', language 'id', version '4.1'.
 *
 * @package     appointment
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addingappointment'] = 'Menambahkan janji temu';
$string['addingappointments'] = 'Menambahkan janji temu';
$string['addremoveattendees'] = 'Tambah/hapus peserta
';
$string['addsession'] = 'Tambahkan sesi';
$string['addtimeframe'] = 'Tambahkan jangka waktu';
$string['advanced'] = 'Lanjutan';
$string['allowcancellations'] = 'Izinkan pembatalan';
$string['allowcancellations_help'] = 'Jika dicentang, peserta sesi akan dapat membatalkan pendaftaran mereka';
$string['allowcancellationsdefault'] = 'Izinkan membatalkan bawaan';
$string['allowcancellationsdefault_help'] = 'Jika dicentang, setelan bawaan, saat membuat sesi baru untuk aktivitas ini, adalah mengizinkan pembatalan pendaftaran';
$string['allowwaitlist'] = 'Izinkan daftar tunggu';
$string['allowwaitlist_help'] = 'Ketika "Izinkan daftar tunggu" diperiksa, peserta akan dapat mendaftar untuk sesi janji temu bahkan jika sudah penuh. <br />

Ketika peserta mendaftar untuk sesi yang sudah penuh, mereka akan menerima surel yang memberi tahu bahwa mereka telah ditunggu -tunggu untuk sesi dan akan diberitahu ketika pemesanan tersedia.';
$string['alreadysignedup'] = 'Anda telah mendaftar untuk aktivitas Janji Temu ini.';
$string['appointment'] = 'Janji temu';
$string['appointment:addattendees'] = 'Menambahkan peserta ke sesi Janji Temu';
$string['appointment:addinstance'] = 'Tambahkan model';
$string['appointment:configurecancellation'] = 'Izinkan konfigurasi pembatalan pendaftaran, setelah menambahkan/mengedit aktivitas Janji Temu.';
$string['appointment:editsessions'] = 'Tambah, edit, salin, dan hapus sesi Janji Temu';
$string['appointment:managecustomfields'] = 'Kelola kolom kustom untuk sesi Janji Temu.';
$string['appointment:overbook'] = 'Daftar ke sesi penuh yang tidak mengaktifkan daftar tunggu.';
$string['appointment:removeattendees'] = 'Menghapus peserta dari sesi Janji Temu';
$string['appointment:signup'] = 'Mendaftar sesi';
$string['appointment:takeattendance'] = 'Presensi';
$string['appointment:view'] = 'Lihat aktivitas dan sesi Janji Temu';
$string['appointment:viewattendees'] = 'Lihat daftar kehadiran dan peserta';
$string['appointment:viewcancellations'] = 'Lihat pembatalan';
$string['appointmentactivity'] = 'Aktivitas janji bertemu';
$string['appointmentcustomfields'] = 'Kolom kustom janji temu';
$string['appointmentname'] = 'Nama janji temu';
$string['appointments'] = 'Janji temu';
$string['appointmentsession'] = 'Sesi janji temu';
$string['appointmentsessiondates'] = 'Tanggal sesi janji temu';
$string['appointmentsessions'] = 'Sesi janji temu';
$string['appointmentsettings'] = 'Pengaturan janji temu';
$string['approvalreqd'] = 'Persetujuan diperlukan';
$string['approvalreqd_help'] = 'Ketika "Persetujuan diperlukan" dicentang, peserta akan membutuhkan persetujuan dari manajer mereka untuk diizinkan menghadiri sesi janji bertemu';
$string['approve'] = 'Menyetujui';
$string['attendance'] = 'Kehadiran';
$string['attendanceinstructions'] = 'Pilih pengguna yang menghadiri sesi:';
$string['attendedsession'] = 'Sesi yang dihadiri';
$string['attendees'] = 'Hadirin';
$string['attendeestablesummary'] = 'Orang yang berencana atau pernah menghadiri sesi ini.';
$string['availableseats'] = 'Tersedia {$a} kursi';
$string['book'] = 'Memesan';
$string['bookedat'] = '<strong>Dipesan:</strong> {$a}';
$string['bookedvscapacity'] = 'Dipesan / Kapasitas';
$string['bookingcancelled'] = 'Pemesanan Anda telah dibatalkan.';
$string['bookingcompleted'] = 'Pemesanan Anda telah selesai.';
$string['bookingfull'] = 'Penuh';
$string['bookingopen'] = 'Buka';
$string['break'] = 'Waktu istirahat';
$string['break_help'] = 'Pengaturan ini menentukan waktu istirahat antar sesi. Menyetel ke 0 berarti tidak perlu istirahat.';
$string['calendareventdescriptionbooking'] = 'Anda dipesan untuk <a href="{$a}">Sesi janji bertemu</a> ini.';
$string['calendareventdescriptionsession'] = 'Anda telah membuat <a href="{$a}">Sesi janji bertemu</a> ini.';
$string['calendaroptions'] = 'Opsi kalender';
$string['cancel'] = 'Membatalkan';
$string['cancelbooking'] = 'Batalkan pemesanan';
$string['cancellationinstrmngr'] = '# Pemberitahuan untuk manajer';
$string['cancellationinstrmngr_help'] = 'Bila **Kirim pemberitahuan kepada manajer** dicentang, teks dalam kolom **Pemberitahuan untuk manajer** akan dikirimkan kepada manajer peserta didik yang memberitahukan bahwa mereka telah membatalkan pemesanan Janji Temu.';
$string['cancellationmessage'] = 'Pesan pembatalan';
$string['cancellationmessage_help'] = 'Pesan ini dikirim setiap kali pengguna membatalkan pemesanan mereka untuk suatu sesi.';
$string['cancellations'] = 'Pembatalan';
$string['cancellationstablesummary'] = 'Daftar orang yang telah membatalkan pendaftaran sesi mereka.';
$string['cancelreason'] = 'Alasan pembatalan';
$string['cannotapproveatcapacity'] = 'Anda tidak dapat menyetujui peserta lagi karena sesi ini sudah penuh.';
$string['cannotsignupsessioninprogress'] = 'Anda tidak dapat mendaftar, sesi ini sedang berlangsung';
$string['cannotsignupsessionover'] = 'Anda tidak dapat mendaftar, sesi ini sudah berakhir.';
$string['capacity'] = 'Kapasitas';
$string['capacity_help'] = '**Kapasitas** adalah jumlah kursi yang tersedia dalam satu sesi.

Ketika sesi Janji bertemu mencapai kapasitasnya, detail sesi tidak muncul di halaman kursus. Rincian akan tampak abu-abu di halaman \'Lihat semua sesi\' dan pelajar tidak dapat mendaftar di sesi tersebut.
&nbsp;';
$string['closed'] = 'Tutup';
$string['completionattended_help'] = 'Jika diaktifkan, aktivitas akan dianggap selesai jika pemesanan kehadiran pelajar ditandai sebagai "Hadir sepenuhnya" atau "Hadir sebagian".';
$string['completionbooked'] = 'Pelajar harus membuat janji temu untuk menyelesaikan aktivitas ini';
$string['completionbooked_help'] = 'Jika diaktifkan, aktivitas akan dianggap selesai jika status pelajar adalah "Sudah dipesan", "Sudah dihadiri penuh", atau "Sudah dihadiri sebagian". Jika pelajar telah membatalkan, masuk daftar tunggu, atau kehadirannya ditandai sebagai "Tidak hadir", aktivitas tidak akan dianggap selesai.';
$string['completiondetail:attended'] = 'Hadiri janji temu';
$string['completiondetail:booked'] = 'Pesan janji temu';
$string['confirmationinstrmngr'] = '# Pemberitahuan untuk manajer';
$string['confirmationinstrmngr_help'] = 'Bila "Kirim pemberitahuan kepada manajer" dicentang, teks dalam kolom "Pemberitahuan untuk manajer" dikirimkan kepada manajer yang memberitahukan bahwa anggota staf telah mendaftar untuk sesi Janji Temu.';
$string['confirmationmessage'] = 'pesan konfirmasi';
$string['confirmationmessage_help'] = 'Pesan ini dikirim setiap kali pengguna mendaftar untuk sesi.';
$string['confirmcancelbooking'] = 'Konfirmasikan pembatalan';
$string['courseresetsessions'] = 'Hapus semua sesi';
$string['courseresetsignups'] = 'Hapus semua pendaftaran sesi';
$string['crontask'] = 'Pekerjaan pemeliharaan janji';
$string['currentstatus'] = 'Status terkini';
$string['customisednotifications'] = 'Pemberitahuan yang disesuaikan';
$string['date'] = 'Tanggal';
$string['decidelater'] = 'Putuskan Nanti';
$string['decline'] = 'Menurun';
$string['delete'] = 'Menghapus';
$string['deleteappointmentconfirm'] = 'Apakah Anda benar-benar yakin ingin menghapus janji bertemu ini dan semua pemesanannya?';
$string['deletesession'] = 'Hapus sesi';
$string['deletetimeframe'] = 'Hapus jangka waktu';
$string['details'] = 'Detail';
$string['duplicate'] = 'Duplikat';
$string['duplicateappointment'] = 'Janji rangkap';
$string['editingappointment'] = 'Menyunting janji temu';
$string['email:message'] = 'Pesan';
$string['email:subject'] = 'Subyek';
$string['emailmanager'] = 'Kirim pemberitahuan ke manajer';
$string['emailmanagercancellation'] = '# Kirim pemberitahuan ke manajer';
$string['emailmanagercancellation_help'] = 'Ketika "Kirim pemberitahuan ke manajer" dicentang, email akan dikirim ke manajer pelajar yang memberi tahu mereka bahwa pemesanan janji bertemu telah dibatalkan.';
$string['emailmanagerconfirmation'] = '# Kirim pemberitahuan ke manajer';
$string['emailmanagerconfirmation_help'] = 'Saat "Kirim pemberitahuan ke manajer" dicentang, email konfirmasi akan dikirim ke manajer pelajar saat pelajar mendaftar untuk sesi Janji bertemu.';
$string['emailmanagerreminder'] = '# Kirim pemberitahuan ke manajer';
$string['emailmanagerreminder_help'] = 'Bila "Kirim pemberitahuan ke manajer" dicentang, pesan pengingat akan dikirim ke manajer pelajar beberapa hari sebelum tanggal dimulainya sesi Janji Temu.';
$string['empty'] = 'Kosong';
$string['endtime'] = 'Akhir waktu';
$string['entitiysession'] = 'Sesi';
$string['error:cancellationsnotallowed'] = 'Anda tidak diizinkan untuk membatalkan pendaftaran ini.';
$string['error:canttakeattendanceforunstartedsession'] = 'Tidak dapat mengambil kehadiran untuk sesi yang belum dimulai.';
$string['error:eventoccurred'] = 'Anda tidak dapat membatalkan acara yang sudah terjadi.';
$string['error:invaliduserid'] = 'ID pengguna tidak valid';
$string['error:manageremailaddressmissing'] = 'Anda saat ini tidak ditugaskan ke manajer dalam sistem. Silakan hubungi administrator situs.';
$string['error:sessionsplitexceeds'] = 'Waktu pemisahan sesi melebihi durasi sesi.';
$string['error:sessionstartafterend'] = 'Waktu mulai sesi lebih lambat dari waktu akhir sesi.';
$string['errorcannoteditsessions'] = 'Anda tidak memiliki izin untuk mengedit sesi';
$string['errorcannotviewappointment'] = 'Anda tidak memiliki izin untuk melihat janji bertemu ini';
$string['errorcannotviewattendees'] = 'Anda tidak memiliki izin untuk melihat peserta';
$string['eventaddsession'] = 'Sesi ditambahkan';
$string['eventapproverequests'] = 'Sesi menyetujui permintaan';
$string['eventattendancetaken'] = 'Kehadiran sesi diambil';
$string['eventattendeesviewed'] = 'Peserta sesi dilihat';
$string['eventcancelbooking'] = 'Sesi pembatalan pemesanan';
$string['eventcourseappointmentviewed'] = 'Model janji temu kursus dilihat';
$string['eventcoursemoduleviewed'] = 'Model modul janji temu dilihat';
$string['eventdeletesession'] = 'Sesi dihapus';
$string['eventsignup'] = 'Pendaftaran sesi';
$string['eventupdatesession'] = 'Sesi diperbarui';
$string['full'] = 'Tanggal terisi penuh';
$string['fullfilter'] = 'Penuh';
$string['goback'] = 'Kembali';
$string['icalendarheading'] = 'Lampiran iCalendar';
$string['joinwaitlist'] = 'Bergabunglah dengan daftar tunggu';
$string['location'] = 'Lokasi';
$string['managecustomfields'] = 'Kelola kolom kustom';
$string['modulename'] = 'Pemesanan janji temu';
$string['modulename_help'] = 'Janji temu adalah modul aktivitas bagi pengajar untuk melacak aktivitas tatap muka.

Modul ini memungkinkan pengajar untuk menyiapkan sistem pemesanan untuk satu atau banyak sesi tatap muka atau berbasis kelas, agar siswa dapat mendaftar.

Modul aktivitas ini cocok untuk sesi 1 lawan 1 atau aktivitas multi-sesi seperti seminar.

Sesi dapat memiliki beberapa tanggal dan waktu dalam satu aktivitas Janji temu, dan dapat dibuat secara massal menggunakan slot waktu yang ditentukan dalam konfigurasi.

Aktivitas ini memungkinkan pelacakan kehadiran.';
$string['modulename_link'] = 'Appointments';
$string['modulenameplural'] = 'Janji temu';
$string['multipleappointments'] = 'Banyak janji bertemu';
$string['noactionableunapprovedrequests'] = 'Tidak ada permintaan tidak disetujui yang dapat ditindaklanjuti';
$string['noremindersneedtobesent'] = 'Tidak ada pengingat perlu dikirim.';
$string['nosignedupusers'] = 'Tidak ada pengguna yang mendaftar untuk sesi ini.';
$string['notset'] = 'Tidak diatur';
$string['notsignedup'] = 'Anda tidak terdaftar untuk sesi ini.';
$string['partiallyfull'] = 'Sebagian penuh';
$string['placeholder:alldates'] = '[alldates]';
$string['placeholder:appointmentname'] = '[appointmentname]';
$string['placeholder:attendeeslink'] = '[attendeeslink]';
$string['placeholder:details'] = '[details]';
$string['placeholder:finishtime'] = '[finishtime]';
$string['placeholder:firstname'] = '[firstname]';
$string['placeholder:lastname'] = '[lastname]';
$string['placeholder:reminderperiod'] = '[reminderperiod]';
$string['placeholder:sessiondate'] = '[sessiondate]';
$string['placeholder:starttime'] = '[starttime]';
$string['pluginadministration'] = 'Administrasi janji temu';
$string['pluginname'] = 'Janji';
$string['potentialattendees'] = 'Calon Peserta';
$string['privacy:metadata:appointment_signups'] = 'Pengguna mendaftar ke sesi Janji bertemu';
$string['privacy:metadata:appointment_signups:id'] = 'ID pendaftaran';
$string['privacy:metadata:appointment_signups:mailedreminder'] = 'Waktu pengingat terakhir dikirim';
$string['privacy:metadata:appointment_signups:sessionid'] = 'ID sesi';
$string['privacy:metadata:appointment_signups_status'] = 'Status pengguna yang mendaftar ke sebuah sesi';
$string['privacy:metadata:appointment_signups_status:grade'] = 'Nilai yang diberikan untuk menghadiri sesi';
$string['privacy:metadata:appointment_signups_status:note'] = 'Menyimpan alasan sesi yang dibatalkan';
$string['privacy:metadata:appointment_signups_status:signupid'] = 'ID pendaftaran';
$string['privacy:metadata:appointment_signups_status:statuscode'] = 'Status pendaftaran mis. Dibatalkan, ditolak, dijaga sepenuhnya';
$string['privacy:metadata:appointment_signups_status:timecreated'] = 'Waktu pendaftaran dibuat.';
$string['privacy:metadata:userid'] = 'ID pengguna yang mengakses aktivitas Janji Temu';
$string['remindermessage'] = 'Pesan pengingat';
$string['remindermessage_help'] = 'Pesan ini dikirim beberapa hari sebelum tanggal mulai sesi.';
$string['reminderperiod'] = 'Beberapa hari sebelum pesan dikirim';
$string['reminderperiod_help'] = 'Pesan pengingat akan dikirim beberapa hari ini sebelum dimulainya sesi.';
$string['requestmessage'] = 'Minta pesan';
$string['requestmessage_help'] = 'Bila **Persetujuan diperlukan** diaktifkan, bagian **Permintaan pesan** tersedia.

Bagian **Permintaan pesan** menampilkan pemberitahuan yang dikirim ke pelajar dan manajer mereka mengenai proses persetujuan bagi pelajar untuk menghadiri sesi Janji Temu.

**Subjek:** adalah baris subjek yang muncul pada surel persetujuan permintaan yang dikirim ke manajer dan pelajar.

**Pesan:** adalah teks surel yang dikirim ke pelajar yang memberi tahu mereka bahwa permintaan mereka untuk menghadiri sesi Janji Temu telah dikirim ke manajer mereka untuk disetujui.

**Pemberitahuan untuk manajer:** adalah teks surel yang dikirim ke manajer pelajar yang meminta persetujuan untuk menghadiri sesi Janji Temu.';
$string['requeststablesummary'] = 'Orang yang meminta untuk menghadiri sesi ini.';
$string['room'] = 'Ruangan';
$string['saveattendance'] = 'Simpan kehadiran';
$string['search:activity'] = 'Aktivitas janji temu';
$string['seatsavailable'] = 'Kursi tersedia';
$string['seatsbooked'] = 'Kursi yang dipesan';
$string['sessionavailability'] = 'Ketersediaan sesi';
$string['sessiondatetime'] = 'Tanggal / waktu sesi';
$string['sessiondescription'] = 'Deskripsi';
$string['sessionduration'] = 'Durasi sesi';
$string['sessionfinished'] = 'Selesai';
$string['sessionfinishtime'] = 'Waktu selesai sesi';
$string['sessioninprogress'] = 'sesi sedang berlangsung';
$string['sessionisfull'] = 'Sesi ini sekarang sudah penuh. Anda perlu memilih waktu lain atau berbicara dengan instruktur.';
$string['sessionnotstarted'] = 'Belum dimulai';
$string['sessionrequiresmanagerapproval'] = 'Sesi ini membutuhkan persetujuan manajer untuk memesan.';
$string['sessions'] = 'Sesi';
$string['sessionsdetailstablesummary'] = 'Deskripsi lengkap dari sesi saat ini.';
$string['sessionstartdate'] = 'Tanggal mulai sesi';
$string['sessionstartdateandtime'] = '{$a->startdate}, {$a->starttime} - {$a->endtime} (time zone: {$a->timezone})';
$string['sessionstartdateandtimewithouttimezone'] = '{$a->startdate}, {$a->starttime} - {$a->endtime}';
$string['sessionstartfinishdateandtime'] = '{$a->startdate} - {$a->enddate}, {$a->starttime} - {$a->endtime} (time zone: {$a->timezone})';
$string['sessionstartfinishdateandtimewithouttimezone'] = '{$a->startdate} - {$a->enddate}, {$a->starttime} - {$a->endtime}';
$string['sessionstarttime'] = 'Waktu mulai sesi';
$string['sessionstatus'] = 'Status sesi';
$string['setting:defaultcancellationmessagedefault'] = 'Dengan ini kami sampaikan bahwa pemesanan Anda untuk janji temu berikut telah dibatalkan:<br><br>
***PEMESANAN DIBATALKAN***<br><br>
Peserta:   [firstname] [lastname]<br>
Janji temu:   [appointmentname]<br><br>
Tanggal:<br>
[alldates]<br><br>
Lokasi:   [session:location]<br>
Tempat:   [session:venue]<br>
Ruang:   [session:room]';
$string['setting:defaultcancellationsubjectdefault'] = 'Pembatalan pemesanan janji temu';
$string['setting:defaultconfirmationmessagedefault'] = 'Dengan ini kami mengonfirmasi bahwa Anda sekarang telah memesan janji temu berikut:<br><br>
Peserta:   [firstname] [lastname]<br>
Janji temu:   [appointmentname]<br><br>
Tanggal:<br>
[alldates]<br><br>
Lokasi:   [session:location]<br>
Tempat:   [session:venue]<br>
Ruang:   [session:room]<br><br>
***Harap datang sepuluh menit sebelum janji temu dimulai***<br><br>
Untuk menjadwalkan ulang atau membatalkan pemesanan Anda<br>
Untuk menjadwalkan ulang pemesanan Anda, Anda perlu membatalkan pemesanan ini dan kemudian memesan ulang sesi baru.<br>
Untuk membatalkan pemesanan Anda, kembali ke halaman janji temu, lalu pilih \'Batal\'.<br><br>
[details]<br><br>
Anda akan menerima pengingat [reminderperiod] hari kerja sebelum janji temu ini.<br><br>';
$string['setting:defaultconfirmationsubjectdefault'] = 'Konfirmasi pemesanan janji temu: [appointmentname], [starttime]-[finishtime], [sessiondate]';
$string['setting:defaultremindermessagedefault'] = 'Ini adalah pengingat bahwa Anda telah memesan janji temu berikut:<br><br>
Peserta:   [firstname] [lastname]<br>
Janji temu:   [appointmentname]<br><br>
Tanggal:<br>
[alldates]<br><br>
Lokasi:   [session:location]<br>
Tempat:   [session:venue]<br>
Ruang:   [session:room]<br><br>
***Harap datang sepuluh menit sebelum janji temu dimulai***<br><br>
Untuk menjadwalkan ulang atau membatalkan pemesanan Anda<br>
Untuk menjadwalkan ulang pemesanan Anda, Anda perlu membatalkan pemesanan ini dan kemudian memesan ulang sesi baru.<br>
Untuk membatalkan pemesanan Anda, kembali ke halaman janji temu, lalu pilih \'Batal\'.<br><br>
[details]';
$string['setting:defaultremindersubjectdefault'] = 'Pengingat pemesanan janji temu: [appointmentname], [starttime]-[finishtime], [sessiondate]';
$string['setting:defaultrequestmessagedefault'] = 'Permintaan Anda untuk memesan janji temu berikut telah dikirim ke manajer Anda:

Peserta:   [firstname] [lastname]
Janji temu:   [appointmentname]

Tanggal:
[alldates]

Lokasi:   [session:location]
Tempat:   [session:venue]
Ruang:   [session:room]';
$string['setting:defaultrequestsubjectdefault'] = 'Permintaan pemesanan janji temu: [appointmentname], [starttime]-[finishtime]';
$string['setting:defaultupdatemessagedefault'] = 'Dengan ini kami informasikan bahwa janji temu yang Anda pesan atau daftar tunggu yang Anda ikuti telah berubah:<br><br>
Perserta:   [firstname] [lastname]<br>
Janji temu:   [appointmentname]<br><br>
Tanggal:<br>
[alldates]<br><br>
Lokasi:   [session:location]<br>
Tempat:   [session:venue]<br>
Ruang:   [session:room]<br><br>
***Harap dicatat bahwa ini bukan konfirmasi pemesanan janji temu***<br><br>
Untuk membatalkan pemesanan atau masuk daftar tunggu, kembali ke halaman janji temu, lalu pilih \'Batal\'.<br><br>
[details]<br><br>';
$string['setting:defaultupdatesubjectdefault'] = 'Pembaruan janji temu: [appointmentname], [starttime]-[finishtime], [sessiondate]';
$string['setting:defaultwaitlistedmessagedefault'] = 'Dengan ini kami sampaikan bahwa Anda telah ditambahkan ke daftar tunggu untuk:<br><br>
Janji temu:   [appointmentname]<br>
Lokasi:  [session:location]<br>
Peserta:   [firstname] [lastname]<br><br>
***Harap dicatat bahwa ini bukan konfirmasi pemesanan janji temu***<br><br>
Dengan memasukkan daftar tunggu, Anda telah mendaftarkan minat Anda pada janji temu ini dan akan dihubungi secara langsung saat sesi tersedia.<br><br>
Untuk menghapus diri Anda dari daftar tunggu ini, silakan kembali ke janji temu ini dan klik Batal. Harap dicatat bahwa tidak ada surel konfirmasi penghapusan daftar tunggu.';
$string['setting:defaultwaitlistedsubjectdefault'] = 'Saran daftar tunggu untuk [appointmentname]';
$string['setting:oneemailperday'] = 'Kirim surel terpisah untuk setiap hari dalam acara yang berlangsung beberapa hari';
$string['setting:oneemailperday_caption'] = 'Surel terpisah untuk setiap hari';
$string['settings'] = 'Pengaturan';
$string['shortname'] = '# Nama pendek';
$string['shortname_help'] = '** Nama pendek ** adalah deskripsi sesi yang muncul di kalender pelatihan ketika ** Tampilkan di kalender ** diaktifkan.';
$string['showoncalendar'] = 'Pengaturan tampilan kalender';
$string['showoncalendar_help'] = 'Bila **Situs** dipilih, sesi aktivitas Janji Temu akan ditampilkan di kalender situs sebagai Acara Global. Semua pengguna situs akan dapat melihat sesi ini.

Bila **Kursus** dipilih, semua sesi aktivitas Janji Temu akan ditampilkan di kalender kursus dan sebagai Acara Kursus di kalender tingkat situs dan dapat dilihat oleh semua pengguna yang terdaftar di kursus.

Bila **Tidak Ada** dipilih, sesi aktivitas Janji Temu hanya akan ditampilkan sebagai Acara Pengguna di kalender peserta yang dikonfirmasi, asalkan opsi **Tampilkan di kalender pengguna** telah dipilih.';
$string['sign-ups'] = 'Mendaftar';
$string['signupforthissession'] = 'Mendaftar untuk sesi janji bertemu ini';
$string['split'] = 'Pembagian otomatis';
$string['split_help'] = 'Pengaturan ini menentukan durasi setiap sesi yang dibuat dalam jangka waktu tersebut. Menyetelnya ke 0 menonaktifkan opsi.';
$string['status'] = 'Status';
$string['status_approved'] = 'Disetujui';
$string['status_booked'] = 'Dipesan';
$string['status_declined'] = 'Ditolak';
$string['status_fully_attended'] = 'Sepenuhnya dihadiri';
$string['status_no_show'] = 'Tidak ada pertunjukan';
$string['status_partially_attended'] = 'Hadir sebagian';
$string['status_requested'] = 'Diminta';
$string['status_user_cancelled'] = 'Pengguna Dibatalkan';
$string['status_waitlisted'] = 'Dalam daftar tunggu';
$string['suppressemail'] = 'Sembunyikan pemberitahuan email';
$string['suppressemail_help'] = 'Gunakan opsi ini jika Anda ingin menambahkan/menghapus pengguna secara diam-diam dari sesi Janji Temu. Saat opsi ini diaktifkan, konfirmasi surel
  biasa tidak akan dikirim ke pengguna yang dipilih.';
$string['takeattendance'] = 'Ambil kehadiran';
$string['thirdpartyemailaddress'] = 'Alamat email pihak ketiga';
$string['thirdpartyemailaddress_help'] = '**Alamat surel pihak ketiga** adalah kolom opsional yang digunakan untuk menentukan alamat surel pihak ketiga (seperti instruktur eksternal) yang kemudian akan menerima pesan konfirmasi setiap kali pengguna mendaftar untuk suatu sesi.
Saat memasukkan **beberapa alamat surel**, pisahkan setiap alamat dengan koma. Misalnya: bob@example.com,joe@example.com';
$string['thirdpartywaitlist'] = 'Beri tahu pihak ketiga tentang sesi dalam daftar tunggu';
$string['thirdpartywaitlist_help'] = 'Bila **Beritahu pihak ketiga tentang sesi daftar tunggu** dipilih, pihak ketiga akan diberi tahu saat peserta didik mendaftar untuk sesi daftar tunggu. Bila

**Beritahu pihak ketiga tentang sesi daftar tunggu** tidak diaktifkan, pihak ketiga hanya akan diberi tahu saat pengguna mendaftar (atau membatalkan) untuk sesi terjadwal.';
$string['timecancelled'] = 'Waktu Dibatalkan';
$string['timeframes'] = 'Jangka waktu';
$string['timerequested'] = 'Waktu Diminta';
$string['timesignedup'] = 'Waktu Mendaftar';
$string['timestart'] = 'Waktu mulai';
$string['unapprovedrequests'] = 'Permintaan yang Tidak Disetujui';
$string['unknowndate'] = '(tanggal tidak diketahui)';
$string['unknowntime'] = '(waktu tidak diketahui)';
$string['updatemessage'] = 'Perbarui pesan';
$string['updatemessage_help'] = 'Pesan ini dikirimkan setiap kali sesi diubah.';
$string['usercalentry'] = 'Tampilkan entri di kalender pengguna';
$string['usercalentry_help'] = 'Bila aktif pengaturan ini akan menambahkan entri Acara Pengguna ke kalender peserta sesi Janji Temu. Bila dinonaktifkan, ini akan mencegah acara duplikat muncul di kalender peserta sesi, jika Anda telah menyetel pengaturan tampilan kalender ke Kursus atau Situs.';
$string['usercancelledon'] = 'Pengguna dibatalkan pada {$a}';
$string['usernotsignedup'] = 'Status: tidak terdaftar';
$string['usersignedup'] = 'Status: mendaftar';
$string['usersignedupon'] = 'Pengguna mendaftar di {$a}';
$string['userwillbewaitlisted'] = 'Sesi ini sudah penuh. Dengan mengklik tombol "Daftar", Anda akan dimasukkan ke dalam daftar tunggu sesi.';
$string['venue'] = 'Lokasi';
$string['waitlistedmessage'] = 'Pesan dalam daftar tunggu';
$string['waitlistedmessage_help'] = 'Pesan ini dikirim setiap kali pengguna mendaftar untuk sesi daftar tunggu.';
