<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_brickfield', language 'sv', version '4.1'.
 *
 * @package     tool_brickfield
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessibility'] = 'Tillgänglighet';
$string['accessibilitydisabled'] = 'Tillgänglighetsverktygslådan Brickfield är inte aktiverad på den här webbplatsen. Kontakta administratören för att aktivera den.';
$string['accessibilityreport'] = 'Tillgänglighetsverktygslåda';
$string['accessibilitytool'] = 'Brickfield tillgänglighetsverktyg';
$string['accessibilitytools'] = 'Brickfield tillgänglighetsverktyg';
$string['activate'] = 'Aktivera';
$string['activated'] = 'Pluginmodulen är aktiverad och klar att användas.';
$string['activationform'] = 'Brickfieldregistrering';
$string['activationheader'] = 'Brickfieldaktivering';
$string['activationinfo'] = '<p>För att kunna använda den här pluginmodulen måste du ange giltiga nycklar för den här webbplatsen i det här formuläret.</p><p>Vänligen <a href="{$a}" data-action="send_info" target="_blank"> registrera dig på Brickfield-portalen (öppnas i nytt fönster)</a> för att ta emot dessa nycklar om du inte redan har dem.</p><p>Efter aktiveringen kommer dina nycklar sedan att valideras via schemalagda cron-aktiviteter.</p>';
$string['activityresults:pluginname'] = 'Tillgänglighetsverktygsrapport uppdelad per aktivitet';
$string['activityresults:toolname'] = 'Sammanfattning per aktivitet';
$string['activityresults:toolshortname'] = 'Fördelat per aktivitet';
$string['advanced:pluginname'] = 'Avancerad tillgänglighetsverktygsrapport';
$string['advanced:toolname'] = 'Avancerad sammanfattning';
$string['advanced:toolshortname'] = 'Avancerad';
$string['allcourses'] = 'Alla granskade kurser ({$a})';
$string['allcoursescat'] = 'Alla granskade kurser i kategorin {$a->catname} ({$a->count})';
$string['analysis:byrequest'] = 'Efter förfrågan';
$string['analysis:disabled'] = 'Inaktiverad';
$string['analysistype'] = 'Aktivera analysförfrågningar';
$string['analysistype_desc'] = 'Tillåt att innehållstillgänglighetsanalys begärs';
$string['analysistypedisabled'] = 'Innehållsanalys är inaktiverad';
$string['bannercontentone'] = 'Verktygslådan för tillgänglighet för företag har en fullständig uppsättning funktioner som hjälper din organisation att förbättra tillgängligheten hos dina kurser. <a href="{$a}">Kontakta Brickfield Education Labs</a> för att boka en gratis demo av de avancerade funktionerna.';
$string['bannercontenttwo'] = 'Skapa en effektiv och inkluderande undervisnings- och inlärningsplattform genom att hitta innehåll som inte uppfyller riktlinjerna, åtgärda problemen och framtidssäkra ditt kursinnehåll i Moodle med tillgänglighetsanpassade filer, redigerare och förbättrade funktioner.';
$string['bannerheadingone'] = 'Uppgradera till Tillgänglighet för företag-verktygen';
$string['batch'] = 'Batchgräns';
$string['brickfield'] = 'Brickfield-verktyg';
$string['brickfield:viewcoursetools'] = 'Visa rapporter per kurser';
$string['brickfield:viewsystemtools'] = 'Visa rapporter för alla kurser';
$string['bulkprocesscaches'] = 'Bearbeta masscachning';
$string['bulkprocesscourses'] = 'Bearbeta masskontroll av tillgänglighet';
$string['buttonone'] = 'Prova gratis';
$string['cachepending'] = 'Sammanfattningen håller på att sammanställas';
$string['checkdesc:alinksdontopennewwindow'] = 'Länkar som öppnas i ett nytt fönster ska varna om detta i förväg.';
$string['checkdesc:amustcontaintext'] = 'En länk måste innehålla text för att gå att uppfatta.';
$string['checkdesc:areadontopennewwindow'] = 'Områden i bilder som öppnas i nytt fönster ska varna om detta i förväg.';
$string['checkdesc:areahasaltvalue'] = 'Områden som används i bilder måste innehålla "alt"-text, liknande som hos bilder.';
$string['checkdesc:asuspiciouslinktext'] = 'Länktext ska vara beskrivande och ge ett sammanhang för dess destination.';
$string['checkdesc:basefontisnotused'] = 'Badefont-element (traditionellt använt för formatering) erbjuder inte god tillgänglighet och ska inte användas.';
$string['checkdesc:blinkisnotused'] = 'Blink-element som blinkar erbjuder inte god tillgänglighet och ska inte användas.';
$string['checkdesc:boldisnotused'] = '"Fet" (b)-element  ska inte användas. Använd "strong" istället.';
$string['checkdesc:contenttoolong'] = 'Totalt antal ord på en sida bör inte överstiga 500 ord.';
$string['checkdesc:csstexthascontrast'] = 'Kontrasten mellan text och bakgrund är för låg.';
$string['checkdesc:embedhasassociatednoembed'] = '"Embed"-element (för att bädda in multimedia) får inte sakna deras motsvarande "noembed"-element.';
$string['checkdesc:headerh3'] = 'Rubriker efter H3-rubriker (stor rubrik) bör inte bryta rubrikhierarkin på sidan.';
$string['checkdesc:headershavetext'] = 'En rubrik måste innehålla text för att kunna uppfattas.';
$string['checkdesc:iisnotused'] = '"Kursiv" \\<i\\>-element bör inte användas. Använd \\<em\\> istället.';
$string['checkdesc:imgaltisdifferent'] = 'Image Alt (alternativ)-text bör inte vara bildens filnamn.';
$string['checkdesc:imgaltistoolong'] = 'Alternativtexten (alt) för en bild får inte vara längre än högst antal tillåtna tecken (125).';
$string['checkdesc:imgaltnotemptyinanchor'] = 'Alternativtexten (alt) för en bild får inte vara tom - i synnerhet inte då bilden innehåller en länk som leder någon annanstans.';
$string['checkdesc:imgaltnotplaceholder'] = 'Alternativtexten (alt) för en bild får inte bestå av en enkel platshållare som t.ex. "bild".';
$string['checkdesc:imghasalt'] = 'Alternativtexten (alt) för en bild får inte saknas för bildelement, såvida den inte enbart fyller ett dekorativt syfte.';
$string['checkdesc:imgwithmaphasusemap'] = 'Bilder med klickbara områden behöver matchande "usermap"- och "map"-element.';
$string['checkdesc:legendtextnotempty'] = '"Legend"-element, som används för att rubriksätta "fieldset"-element måste innehålla text.';
$string['checkdesc:marqueeisnotused'] = '"Marquee" (automatisk rullning)-element är inte tillgänglighetsanpassade och får inte användas.';
$string['checkdesc:noheadings'] = 'Frånvaro av rubriker gör innehåll mindre strukturerat och svårare att läsa.';
$string['checkdesc:objectmusthaveembed'] = '"Object"-element (som används för att bädda in externt innehåll) får inte vara utan motsvarande "embed"-element.';
$string['checkdesc:objectmusthavetitle'] = '"Object"-element (som används för att bädda in externt innehåll) får inte vara utan motsvarande "title"-element.';
$string['checkdesc:objectmusthavevalidtitle'] = '"Object"-element (som används för att bädda in externt innehåll) måste ha motsvarande "title"-element innehållandes text.';
$string['checkdesc:strikeisnotused'] = '"Strike" (överstrykning)-element får inte användas. Använd "del" (borttaget) istället.';
$string['checkdesc:tabledatashouldhaveth'] = 'Tabeller bör ha rubriker.';
$string['checkdesc:tablesummarydoesnotduplicatecaption'] = 'Tabellsammanfattningar och -rubriker ska inte vara identiska.';
$string['checkdesc:tabletdshouldnotmerge'] = 'Tabeller ska helst inte ha några sammanslagna celler.';
$string['checkdesc:tablethshouldhavescope'] = 'Tabellrad och -kolumnomfång (som används för att mappa rad och kolumn mot varje cell) måste vara deklarerade.';
$string['checkidvalidation'] = 'Aktivitet för att söka efter ogiltiga checkids.';
$string['checkscompleted'] = 'Slutförda kontroller: {$a}';
$string['checktype'] = 'Kontrollera grupp';
$string['checktype:form'] = 'Formulär';
$string['checktype:image'] = 'Bild';
$string['checktype:layout'] = 'Layout';
$string['checktype:link'] = 'Länk';
$string['checktype:media'] = 'Media';
$string['checktype:table'] = 'Tabell';
$string['checktype:text'] = 'Text';
$string['checktyperesults:pluginname'] = 'Rapport för hjälpmedel för innehållstyper';
$string['checktyperesults:toolname'] = 'Sammanfattning av innehållstyper';
$string['checktyperesults:toolshortname'] = 'Innehållstyper';
$string['cmpercent'] = 'Procentandel av aktiviteter totalt';
$string['cmpercenterrors'] = 'Procentandel av fel totalt';
$string['cmpercenttitle'] = 'Procentuell fördelning mellan aktiviteter och fel';
$string['confirmationmessage'] = 'Kursen har schemalagts för analys. Analysen kommer att slutföras tidigast {$a}. Kom tillbaka efter det.';
$string['contactadmin'] = 'Kontakta administratören för att slutföra registreringen.';
$string['contactus'] = 'Kontakta oss';
$string['contentfive'] = 'Reparera automatiskt föråldrade HTML-taggar.';
$string['contentfour'] = 'Identifiera de aktiviteter där problem med tillgängligheten är som störst för att prioritera insatserna.';
$string['contentone'] = 'Utvärdera automatiskt ditt kursinnehåll och bedömningar med avseende på tillgänglighet.';
$string['contentsix'] = 'Visa tips för lärare på hur de kan skapa bättre innehåll.';
$string['contentthree'] = 'Erbjud dina studenter innehåll i tillgängliga format, inklusive ljud, ePub och elektronisk punktskrift.';
$string['contenttwo'] = 'Massuppdatera otydlig eller saknad text i webblänkar, bildbeskrivningar och undertexter.';
$string['contenttypeerrors'] = 'Totalt resultat av aktivitetsinnehållstester per kurs och per innehållstyp.';
$string['contentyperesults'] = 'Totalt godkänt/misslyckat för innehållsområden per kurs.';
$string['contextid'] = 'Kontext-ID';
$string['core_course'] = 'Kurs';
$string['core_question'] = 'Frågebanker';
$string['count'] = 'Antal';
$string['country'] = 'Land';
$string['country_help'] = 'Land för webbplatsen';
$string['coursecount'] = 'Antal kurser';
$string['deletehistoricaldata'] = 'Ta bort historiska kontrollresultat';
$string['dependency'] = 'Beroende av';
$string['emptycategory'] = 'Hittade inga kurser i kategorin {$a}';
$string['emptytagcourses'] = 'Inga resultat hittades för kurser med konfigurerade taggar';
$string['enableaccessibilitytools'] = 'Aktivera verktyg för tillgänglighet';
$string['enableaccessibilitytools_desc'] = 'Verktygslådan för tillgänglighet hjälper till att identifiera tillgänglighetsproblem i kurser.';
$string['error:nocoursespecified'] = 'Den här sammanfattningsrapporten kräver ett giltigt kurs-ID. Vänligen gå till tillgänglighetsverktygslådan inifrån en kurs.';
$string['errorlink'] = 'Redigera felinstans för {$a}';
$string['errors'] = 'Fel: {$a}';
$string['errors:pluginname'] = 'Hjälpmedelsverktyg för fellista';
$string['errors:toolname'] = 'Sammanfattning av fellista';
$string['errors:toolshortname'] = 'Fellista';
$string['eventanalysis_requested'] = 'Innehållsanalys begärd';
$string['eventanalysis_requesteddesc'] = 'Innehållsanalys begärdes för kursen {$a}.';
$string['eventreport_downloaded'] = 'Tillgänglighetssammanfattning nedladdad';
$string['eventreport_downloadeddesc'] = 'Tillgänglighetssammanfattning nedladdad för kurs-id {$a}.';
$string['eventreport_viewed'] = 'Tillgänglighetsrapport visad';
$string['eventreport_vieweddesc'] = 'Tillgänglighetsrapporten visades för kurs-ID {$a->course},
kategori-ID {$a->category}, flik {$a->tab}.';
$string['failed'] = 'Misslyckades';
$string['failedcount'] = 'Misslyckades: {$a}';
$string['footerheading'] = 'Sidfot';
$string['fullcachedone'] = 'Inaktivera för att köra cachning igen';
$string['hashcorrect'] = 'Den angivna koden är korrekt.';
$string['hashincorrect'] = 'Den angivna koden är felaktig.';
$string['headingfive'] = 'HTML-korrigeringar';
$string['headingfour'] = 'Fokusera insats';
$string['headingone'] = 'Utvärderingsinnehåll';
$string['headingsix'] = 'Prestandasupport';
$string['headingthree'] = 'Tillgängliga filformat';
$string['headingtwo'] = 'Åtgärd';
$string['hideshow'] = 'Dölj/visa';
$string['inactive'] = 'Pluginmodulen är inaktiv och kan inte användas. Ange giltiga registreringsnycklar och tryck på "Aktivera".';
$string['innercontextid'] = 'Inte kontext-ID';
$string['installed'] = 'Pluginmodulen är installerad';
$string['installedcli'] = 'Pluginmodulen är installerad via kommandoraden';
$string['installeddescription'] = 'Pluginmodulen har installerats, omdirigera till aktiveringsformuläret.';
$string['invalidaccessibilitytool'] = 'Ogiltig hjälpmedelsunderplugin begärdes.';
$string['invalidcategoryid'] = 'Ogiltig kategori. Vänligen kontrollera att du matat in korrekt information.';
$string['invalidcourseid'] = 'Ogiltig kurs. Kontrollera din inmatning';
$string['invalidlinkphrases'] = 'klicka|klicka här|här|mer|mer här|info|info här|information|information här|läs mer|läs mer här|ytterligare information|ytterligare information här|ytterligare detaljer|ytterligare detaljer här';
$string['language'] = 'Språk';
$string['language_help'] = 'Språk för webbplatsen';
$string['messageprovider:warningcheckid'] = 'Varning för ogiltiga checkids';
$string['mobileservice'] = 'Mobiltjänster är aktiverade ({$a})';
$string['module'] = 'Modul';
$string['modulename'] = 'Namn';
$string['moreinfo'] = 'Mer information';
$string['noerrorsfound'] = 'Inga vanliga tillgänglighetsfel hittades för dina sökparametrar. Grattis!';
$string['norecords'] = 'Inga relevanta poster hittades';
$string['notregistered'] = 'Ditt tillgänglighetsverktyg behöver registreras.';
$string['notvalidated'] = 'Ditt tillgänglighetsverktyg går att använda under tiden det valideras.';
$string['numcourses'] = 'Antal kurser ({$a})';
$string['numfactivities'] = 'Antal aktiviteter ({$a})';
$string['numfiles'] = 'Antal filer ({$a})';
$string['numinstances'] = 'Antal instanser';
$string['numusers'] = 'Antal användare ({$a})';
$string['pagedesc:checktype'] = '<p>För att sammanfatta och analysera resultaten för de olika kontroller som genomförts grupperar vi dessa kontroller i olika innehållstyper. Därför finns alla bildrelaterade tillgänglighetskontrollresultat i gruppen "Bild". Alla layoutrelaterade tillgänglighetskontrollresultat finns i gruppen "Layout" och så vidare.</p> <p>Aktiviteter ingår som antingen aktiviteter, resurser eller innehållsområden som rör själva kurserna.</p> <p> Diagramsidan för innehållstyp visar feluppdelningen per grupp och innehållstyp: Bild, Layout, Länk, Media, Tabell och Text.</p>';
$string['pagedesc:pertarget'] = '<p>För att sammanfatta och analysera kontrollresultaten per aktivitet grupperar vi dessa kontrollresultat i de olika aktiviteter som upptäckts.</p> <p>Aktiviteter ingår som antingen aktiviteter, resurser eller andra innehållsområden som rör själva kurserna. Varje aktivitet utan upptäckta fel räknas som godkänd. Varje aktivitet med ett eller flera identifierade fel räknas som misslyckad. Förhållandet mellan godkända och misslyckade aktiviteter visas sedan.</p> <p>Sidan för aktivitetsuppdelningsdiagram visar förhållandet mellan godkända och misslyckade instanser totalt, per aktivitet, till exempel uppgift, kurs, etikett etc.</p>';
$string['pagedesctitle:checktype'] = 'Förklaring av innehållstyper';
$string['pagedesctitle:pertarget'] = 'Förklaring av aktivitetsuppdelning';
$string['passed'] = 'Godkänd';
$string['passedcount'] = 'Godkända: {$a}';
$string['passrate'] = 'Godkännandegrad: {$a}%';
$string['pdf:filename'] = 'Brickfield_Sammanfattning_KursID-{$a}';
$string['percheckerrors'] = 'Antal specifika test och fel per kontroll och kurs.';
$string['perpage'] = 'Objekt att visa per sida';
$string['pluginname'] = 'Tillgänglighetsverktyg';
$string['printable:downloadpdf'] = 'Ladda ned PDF';
$string['printable:pluginname'] = 'Sammanfattande tillgänglighetsrapport';
$string['printable:printreport'] = 'Rapport för utskrift';
$string['printable:toolname'] = 'Sammanfattningsrapport';
$string['printable:toolshortname'] = 'Sammanfattningsrapport';
$string['privacy:metadata'] = 'Pluginmodulen Tillgänglighetskontroller lagrar ingen personinformation.';
$string['processanalysisrequests'] = 'Bearbeta förfrågningar om innehållsanalyser';
$string['registernow'] = 'Vänligen registrera nu.';
$string['registration'] = 'Registreringsformulär';
$string['registrationinfo'] = '<p>I den här registreringsprocessen kan du använda Brickfield accessibility toolkit startversion för din registrerade Moodlewebbplats.</p> <p>Användningen omfattas av villkoren för <a href="{$a}" target="_blank">Brickfield Education Labs (öppnas i nytt fönster)</a> och som du samtycker till genom att använda denna produkt.</p>';
$string['release'] = 'Moodle-release ({$a})';
$string['remaining'] = '({$a} fel återstår)';
$string['response:0'] = 'Denna URL pekar inte på något';
$string['response:404'] = 'Den här URL-sidan kunde inte hittas';
$string['schedule:blocknotscheduled'] = '<p>Denna kurs har ännu inte schemalagts för analys för att upptäcka vanliga tillgänglighetsproblem.</p>';
$string['schedule:notscheduled'] = '<p>Denna kurs har ännu inte schemalagts för analys för att upptäcka vanliga tillgänglighetsproblem.</p> <p>Genom att klicka på knappen "Skicka för analys" bekräftar du att du vill att allt relevant kurs HTML-innehåll, till exempel kursavsnittsbeskrivningar, aktivitetsbeskrivningar, frågor, sidor med mera, ska schemaläggas för analys.</p> <p> Denna analys kommer att utföra flera vanliga tillgänglighetskontroller av ditt kurs HTML-innehåll och dessa resultat visas sedan på verktygssatsrapportsidorns för hjälpmedel. Analysen bearbetas i bakgrunden av schemalagda aktiviteter, så dess slutförandehastighet beror på aktivitetstiderna och aktivitetskörningsscheman.</p>';
$string['schedule:requestanalysis'] = 'Schemalägg för analys';
$string['schedule:scheduled'] = 'Denna kurs har schemalagts för analys.';
$string['schedule:sitenotscheduled'] = '<p>Det globala (ej kursberoende) innehållet har schemalagts för analys.</p><p>Genom att klicka på knappen "Skicka för analys" bekräftar du att du vill att allt relevant globalt kurs HTML-innehåll ska schemaläggas för analys.</p> <p> Denna analys kommer att utföra flera vanliga tillgänglighetskontroller av ditt kurs HTML-innehåll och dessa resultat visas sedan på verktygssatsrapportsidorns för hjälpmedel. Analysen bearbetas i bakgrunden av schemalagda aktiviteter, så dess slutförandehastighet beror på aktivitetstiderna och aktivitetskörningsscheman.</p>';
$string['schedule:sitescheduled'] = 'Det globala (ej kursberoende) innehållet har schemalagts för analys.';
$string['secretkey'] = 'API-nyckel';
$string['secretkey_help'] = 'Den här koden erhålls via e-post efter registreringen.';
$string['sendfollowinginfo'] = '<p>Följande information kommer periodvis skickas för att bidra till den övergripande statistiken. Den kommer inte göras publik eller visas någonstans.</p> {$a}';
$string['settings'] = 'Inställningar för tillgänglighetsverktyg';
$string['sitehash'] = 'Hemlig nyckel';
$string['sitehash_help'] = 'Den här koden erhålls via e-post efter registreringen.';
$string['taberrors'] = 'Felkontroll';
$string['targetavetitle'] = 'Genomsnittlig antal fel per aktivitet';
$string['targetpercentage'] = 'Procentandel godkända/icke godkända per aktivitet';
$string['targetratio'] = 'Godkännandegrad för aktivitet';
$string['tblcheck'] = 'Kontrollera';
$string['tblcheckexample'] = 'Exempel';
$string['tblcheckfailed'] = 'Kontrollerna misslyckades';
$string['tblchecksummary'] = 'Sammanfattning';
$string['tbledit'] = 'Redigera';
$string['tblerrorcount'] = 'Fel';
$string['tblhtmlcode'] = 'Befintlig HTML-kod';
$string['tblinstance'] = 'Instans';
$string['tblline'] = 'Rad';
$string['tbloverallpercentage'] = 'Övergripande fel %';
$string['tblpercentage'] = 'Procent';
$string['tblpreview'] = 'Förhandsgranskning';
$string['tbltarget'] = 'Aktivitet';
$string['tblupdateto'] = 'Uppdatera till';
$string['titleactivityresultsall'] = 'Resultat per aktivitet: alla granskade kurser ({$a->count} kurser)';
$string['titleactivityresultspartial'] = 'Resultat per aktivitet: kurs {$a->name}';
$string['titleall'] = 'Felbeskrivningar: alla granskade kurser ({$a->count} kurser)';
$string['titlechecktyperesultsall'] = 'Resultat per innehållstyp: alla granskade kurser ({$a->count} kurser)';
$string['titlechecktyperesultspartial'] = 'Resultat per innehållstyp: kurs {$a->name}';
$string['titleerrorsall'] = 'Felbeskrivningar: alla granskade kurser ({$a->count} kurser)';
$string['titleerrorscount'] = 'Felbeskrivningar: (visar de översta {$a} felen)';
$string['titleerrorspartial'] = 'Feldetaljer: kurs {$a->name}';
$string['titlepartial'] = 'Feldetaljer: kurs {$a->name}';
$string['titleprintableall'] = 'Kurs {$a->name}';
$string['titleprintablepartial'] = 'Kurs {$a->name}';
$string['tools'] = 'Rapporter';
$string['toperrors'] = 'Mest förekommande felen';
$string['toptargets'] = 'Misslyckade aktiviteter';
$string['totalactivities'] = 'Totalt antal aktiviteter';
$string['totalactivitiescount'] = 'Totalt antal aktiviteter: {$a}';
$string['totalareas'] = 'Totalt antal områden';
$string['totalerrors'] = 'Totalt antal fel';
$string['totalgrouperrors'] = 'Totalt (summan) för fel per innehållstyp';
$string['updatesummarydata'] = 'Uppdatera sammanfattning för webbplats';
$string['usersmobileregistered'] = 'Antal användare med registrerade mobilenheter ({$a})';
$string['validationerror'] = 'Valideringen av registreringsnyckeln misslyckades. Kontrollera att nyckeln och webbplats-URL:en är korrekt.';
$string['warningcheckidbody'] = 'Det är problem med en Brickfield-kontroll som är aktiv men inte listad i databasen. Vänligen kontrollera vad det kan bero på.';
$string['warningcheckidsubject'] = 'Varning om Brickfield checkID';
