<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'enrol_invitation', language 'sv', version '4.1'.
 *
 * @package     enrol_invitation
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['a_day'] = '1 dag';
$string['a_minute'] = '1 minute';
$string['about_hour'] = 'ungefär 1 timme';
$string['about_x_hours'] = 'ungefär {$a} timmar';
$string['accepteddescription'] = 'Användar-ID {$a->userid} accepterade en inbjudan till kursen med id {$a->courseid}".';
$string['action_extend_invite'] = 'Förläng inbjudan';
$string['action_resend_invite'] = 'Skicka inbjudan igen';
$string['action_revoke_invite'] = 'Återkalla inbjudan';
$string['anonymoususer'] = '(okänd)';
$string['assignrole'] = 'Tilldela rollen';
$string['customnamecourse'] = 'Anpassat format';
$string['customsubjectformat'] = '{$a->shortname} - {$a->fullname}';
$string['default_subject'] = 'Kursinbjudan: {$a}';
$string['defaultinvitevalues'] = 'Standardvärden för inbjudan';
$string['defaultsubjectformat'] = 'Standardformat för ämne';
$string['defaultsubjectformat_desc'] = 'Det här är standardformatet för kursnamn som kommer att användas på ämnesraden när du skickar e-postmeddelanden om inbjudningar. Observera att detta endast påverkar instanser av registreringsmetoden när de först skapas. Om du väljer <strong>anpassat format</strong> kan du <a href="../admin/tool/customlang/">anpassa <strong>\'customsubjectformat\'</strong>-språksträngen</a> hos <strong>enrol_invitation</strong>-pluginmodulen genom att använda en valfri kombination av de korta och långa kursnamnen. Direkt efter installationen av pluginmodulen är det anpassade namnet satt till \'kortnamn - kursnamn\'.';
$string['deleteddescription'] = 'Användar-ID {$a->userid} tog bort en inbjudan till kursen med id {$a->courseid}" till {$a->email}.';
$string['editenrolment'] = 'Redigera kursregistrering';
$string['email_clarification'] = 'Du kan ange flera e-postadresser genom att separera dem med semikolon, kommatecken, blanksteg eller nya rader';
$string['emailaddressnumber'] = 'E-postadress';
$string['emailmessageuserenrolled'] = 'Hej

{$a->userfullname} ({$a->useremail}) har accepterat din inbjudan till {$a->coursefullname} som "{$a->rolename}". Du kan verifiera statusen för den här inbjudan genom att titta i:

* Deltagarlistan: {$a->courseenrolledusersurl}
* Inbjudningshistoriken: {$a->invitehistoryurl}

{$a->sitename}
-------------
{$a->supportemail}';
$string['emailmsghtml'] = 'Förhandsgranska';
$string['emailmsghtml_help'] = '<p>Hej!</p>
<p>Du är inbjuden till följande kurs:</p>
<ul>
  <li>Kursnamn: <b>{$a->coursename}</b></li>
  <li>Startdatum: <b>{$a->start}</b></li>
  <li>Slutdatum: <b>{$a->end}</b></li>
</ul>
<p>{$a->message}</p>
<p>Logga in för att bekräfta din anmälan till kursen.</p>
<p>Genom att använda den här länken bekräftar du att du är den person som det här e-postmeddelandet skickats till och för vilken inbjudan är avsedd.</p>
<p><a class="btn btn-primary" href="{$a->inviteurl}">{$a->acceptinvitation}</a></p>
<p>Om du inte vill gå med i den här kursen använder du följande länk i stället:</p>
<p><a class="btn btn-danger" href="{$a->rejecturl}">{$a->rejectinvitation}</a></p>
<p>Observera att dessa länkar upphör att gälla <b> {$a->expiration}</b></p>
<p>Välkommen!</p><p>SOC Utbildningar</p>';
$string['emailmsgunsubscribe'] = '<span class="apple-link">Om du tror att du har fått det här meddelandet av misstag, är i behov av hjälp eller inte vill få ytterligare inbjudningar till den här kursen, vänligen kontakta:</span> <a href="mailto:{$a->supportemail}">{$a->supportemail}</a>.';
$string['emailtitleuserenrolled'] = '{$a->userfullname} har accepterat inbjudan till {$a->coursefullname}.';
$string['enrolconfimation'] = 'Kräv studentbekräftelse av registrering';
$string['err_cohortlist'] = 'Du måste välja kohorter här.';
$string['err_userlist'] = 'Eller så måste du välja användare här.';
$string['event_invitation_accepted'] = 'Acceptera';
$string['event_invitation_attempted'] = 'Försök';
$string['event_invitation_deleted'] = 'Borttagen';
$string['event_invitation_rejected'] = 'Avvisning';
$string['event_invitation_sent'] = 'Skicka';
$string['event_invitation_updated'] = 'Uppdaterad';
$string['event_invitation_viewed'] = 'Visad';
$string['expiredtoken'] = 'Inbjudan har upphört att gälla, eller så har den redan använts.';
$string['extend_invite_sucess'] = 'Inbjudan förlängdes';
$string['failuredescription'] = 'Fel: Användar-ID {$a->userid}, kurs-ID \'{$a->courseid}\'. Orsak: {$a->errormsg}.';
$string['half_minute'] = 'en halv minut';
$string['header_email'] = 'Vem vill du bjuda in?';
$string['header_role'] = 'Vilken roll vill du tilldela deltagaren?';
$string['historyactions'] = 'Åtgärder';
$string['historydateexpiration'] = 'Förfallodatum';
$string['historydatesent'] = 'Skickad den';
$string['historyexpires_in'] = 'förfaller om';
$string['historyinvitee'] = 'Deltagare';
$string['historyrole'] = 'Roll';
$string['historystatus'] = 'Status';
$string['historyundefinedrole'] = 'Det gick inte att hitta rollen. Skicka inbjudan igen och välj en annan roll.';
$string['invitation:config'] = 'Konfigurera inbjudningsinstanser';
$string['invitation:enrol'] = 'Bjud in användare';
$string['invitation:manage'] = 'Hantera inbjudningar';
$string['invitation:unenrol'] = 'Avregistrera användare från kursen';
$string['invitation:unenrolself'] = 'Avregistrera sig själv från kursen';
$string['invitation_acceptance_title'] = 'Accepterande av inbjudan';
$string['invitationacceptance'] = '<p>Du är inbjuden att få tillgång till <strong>{$a->coursefullname}</strong> som en <strong>{$a->rolename}</strong>. Vänligen bekräfta din inbjudan till kursen.</p>';
$string['invitationacceptancebutton'] = 'Tacka ja';
$string['invitationrejectbutton'] = 'Tacka nej';
$string['invitationrejected'] = 'Inbjudan avvisad';
$string['invitationsuccess'] = 'Inbjudan skickades';
$string['inviteexpiration'] = 'Giltighetstid för inbjudan';
$string['inviteexpiration_desc'] = 'Giltighetstid för inbjudan (i sekunder)';
$string['invitehistory'] = 'Tidigare inbjudningar';
$string['inviteusers'] = 'Bjud in användare';
$string['invtitation_rejected_notice'] = '<p>Den här inbjudan har avvisats.</p>';
$string['less_minute'] = 'mindre än en minut';
$string['less_than_x_seconds'] = 'mindre än {$a} sekunder';
$string['loggedinnot'] = '<p>Du behöver logga in för att kunna acceptera denna inbjudan.</p>';
$string['message'] = 'Meddelande';
$string['noenddate'] = 'Inget slutdatum';
$string['noinvitationinstanceset'] = 'Ingen instans för registrering av inbjudningar har hittats. Lägg till en instans för registrering av inbjudningar i din kurs.';
$string['noinvitehistory'] = 'Inga inbjudningar har skickats ut ännu';
$string['nopermissiontosendinvitation'] = 'Ingen behörighet att skicka inbjudan';
$string['norole'] = 'Välj en roll.';
$string['notify_inviter'] = 'Meddela mig på {$a->email} när inbjudna användare accepterar den här inbjudan';
$string['notsentdescription'] = 'Användar-ID {$a->userid} kunde inte skicka en inbjudan till kursen med id \'{$a->courseid}\' eftersom det inte finns något konto som har e-postadressen \'{$a->email}\'.';
$string['pluginname'] = 'Inbjudan';
$string['pluginname_desc'] = 'Pluginmodulen Inbjudan gör det möjligt att skicka inbjudningar via e-post. Dessa inbjudningar kan bara användas en gång. Användare som klickar på e-postlänken registreras automatiskt.';
$string['registeredonly'] = 'Skicka endast inbjudan för registrerade användare';
$string['registeredonly_help'] = 'Inbjudan skickas endast till e-postkonton som tillhör registrerade användare.';
$string['rejecteddescription'] = 'Användar-ID {$a->userid} avvisade en inbjudan till kursen med id \'{$a->courseid}".';
$string['reminder'] = 'Påminnelse:';
$string['resend_invite_sucess'] = 'Inbjudan har skickats på nytt';
$string['returntocourse'] = 'Tillbaka till kurs';
$string['returntoinvite'] = 'Skicka en ny inbjudan';
$string['revoke_invite_sucess'] = 'Inbjudan återkallad';
$string['sentdescription'] = 'Användar-ID {$a->userid} skickade en inbjudan till kursen med id \'{$a->courseid}\' till \'{$a->email}\'.';
$string['show_from_email'] = 'Tillåt inbjudna användare att kontakta mig på {$a->email} (din adress kommer att finnas i fältet "FRÅN". Om det inte är markerat blir fältet "FRÅN" {$a->supportemail})';
$string['status'] = 'Tillåt inbjudningar';
$string['status_desc'] = 'Tillåt användare att bjuda in personer att anmäla sig till en kurs som standard.';
$string['status_invite_active'] = 'Aktiv';
$string['status_invite_expired'] = 'Förfallen';
$string['status_invite_invalid'] = 'Ogiltig';
$string['status_invite_rejected'] = 'Avvisad';
$string['status_invite_resent'] = 'Omskickad';
$string['status_invite_revoked'] = 'Återkallad';
$string['status_invite_used'] = 'Accepterad';
$string['status_invite_used_expiration'] = '(åtkomst upphör {$a})';
$string['status_invite_used_noaccess'] = '(har inte längre åtkomst)';
$string['subject'] = 'Ämne';
$string['unenrol'] = 'Avregistrera användare';
$string['unenroluser'] = 'Vill du verkligen avregistrera <strong>"{$a->user}"</strong> från kursen <strong>"{$a->course}"</strong>?';
$string['updateddescription'] = 'Användare med id {$a->userid} förlängde inbjudan till kursen med id \'{$a->courseid}\' för \'{$a->email}\'.';
$string['used_by'] = 'av {$a->username} ({$a->roles}, {$a->useremail}) den {$a->timeused}';
$string['usedefaultvalues'] = 'Använd inbjudan med standardvärden';
$string['usernotmatch'] = '<p>Inbjudan är avsedd för en annan användare.</p>';
$string['vieweddescription'] = 'Användare med id {$a->userid} visade inbjudan för kursen med id \'{$a->courseid}\'.';
$string['x_days'] = '{$a} dagar';
$string['x_minutes'] = '{$a} minuter';
