<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_clean', language 'da', version '4.1'.
 *
 * @package     theme_clean
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['choosereadme'] = '<div class="clearfix">
<div class="well">
<h2>Clean</h2>
<p><img class="img-polaroid" src="clean/pix/screenshot.jpg" /></p>
</div>
<div class="well">
<h3>About</h3>
<p>Clean er et modificeret Bootstrap-layout til Moodle, og arver stil og renderer fra dets moderlayout.</p>
<h3>Moder</h3>
<p>Layoutet er baseretpå Bootstrap-layoutet, som blev lavet til Moodle 2.5 med hjælp fra:<br>
Stuart Lamour, Mark Aberdour, Paul Hibbitts, Mary Evans.</p>
<h3>Bidragsydere</h3>
<p>Forfattere: Bas Brands, David Scotson, Mary Evans <br>
Kontakt: bas@sonsbeekmedia.nl<br>
Webside: <a href="http://www.basbrands.nl">www.basbrands.nl</a>
</p>
<h3>Rapportering af bugs</h3>
<p><a href="http://tracker.moodle.org">http://tracker.moodle.org</a></p>
<h3>Yderligere oplysninger</h3>
<p><a href="clean/README.txt">Hvordan kopiere og tilpasse dette layout</a></p>
</div></div>';
$string['configtitle'] = 'Clean';
$string['customcss'] = 'Brugerdefineret CSS';
$string['customcssdesc'] = 'De regler du skriver her vil blive brugt på alle sider - en nem måde at tilpasse layoutet på.';
$string['footnote'] = 'Fodnote';
$string['footnotedesc'] = 'Det du skriver her, vises nederst på alle dine sider i Moodle.';
$string['invert'] = 'Inverter navigationslinje';
$string['invertdesc'] = 'Skifter mellem sort og hvid som baggrunds- og tekstfarve i navigationslinjen øverst på siden.';
$string['logo'] = 'Logo';
$string['logodesc'] = 'Logoet vises kun i sidehovedet på forsiden og på loginsiden. <br />Hvis højden på dit logo er mere end 75px, så tilføj div.logo {height: 100px;} (eller hvilken højde du bruger) i dit tilpassede CSS herunder. Tilføjer du ikke et logo her, bruges logoet fra Udseende > Logoer.';
$string['pluginname'] = 'Clean';
$string['privacy:metadata'] = 'Clean gemmer ikke personlige data om brugere.';
$string['region-side-post'] = 'Højre';
$string['region-side-pre'] = 'Venstre';
$string['sitelogo'] = 'Site logo';
$string['sitename'] = 'Vis webstedets navn sammen med et lille logo';
$string['sitenamedesc'] = 'Der er ikke noget lille logo, sidens navn vises altid i navigationslinjen. Hvis et lille logo angives, vil det blive vist med eller uden sidens navn.';
$string['smalllogo'] = 'Lille logo';
$string['smalllogodesc'] = 'Det lille logo vises i navigationslinjen. Hvis der er et logo i sidehovedet på forsiden og på loginsiden, vises det lille logo ikke på disse sider. Hvis ikke et logo tilføjes her, vil det kompakte logo i Udseende > Logoer blive vist.';
