<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'assign', language 'da', version '4.1'.
 *
 * @package     assign
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityattachments'] = 'Vedhæftninger til opgaveaktiviteter';
$string['activitydate:submissionsdue'] = 'Forfalder:';
$string['activitydate:submissionsopen'] = 'Åbner:';
$string['activitydate:submissionsopened'] = 'Åbnet:';
$string['activityeditor'] = 'Instruktion';
$string['activityeditor_help'] = 'De handlinger, du ønsker, at den studerende skal udføre i forbindelse med denne opgave. Dette vises kun på afleveringssiden, hvor en studerende redigerer og afleverer sin opgave.';
$string['activityoverview'] = 'Du har opgaver, som kræver din opmærksomhed';
$string['addattempt'] = 'Tillad endnu et forsøg på besvarelse';
$string['addnewattempt'] = 'Tillad et nyt forsøg på besvarelse';
$string['addnewattempt_help'] = 'Dette vil oprette en ny tom aflevering som du kan arbejde på.';
$string['addnewattemptfromprevious'] = 'Tilføj et nyt forsøg baseret på tidligere aflevering';
$string['addnewattemptfromprevious_help'] = 'Dette vil kopiere indholdet af din tidligere aflevering til en ny opgave som du kan arbejde på.';
$string['addnewgroupoverride'] = 'Tilføj gruppeundtagelse';
$string['addnewuseroverride'] = 'Tilføj brugerundtagelse';
$string['addsubmission'] = 'Besvar opgaven';
$string['addsubmission_help'] = 'Du har ikke afleveret noget endnu';
$string['allocatedmarker'] = 'Den der skal bedømme opgaven';
$string['allocatedmarker_help'] = 'Bedømmer tildelt denne opgave.';
$string['allowsubmissions'] = 'Tillad brugerne at fortsætte med at aflevere besvarelser til denne opgave.';
$string['allowsubmissionsanddescriptionfromdatesummary'] = 'Opgaveinformationer og afleveringsblanket er tilgængelig fra <strong>{$a}</strong>';
$string['allowsubmissionsfromdate'] = 'Aflevering tilladt fra';
$string['allowsubmissionsfromdate_help'] = 'Når indstillingen er aktiveret, vil studerende ikke kunne aflevere opgaver før denne dato. Er indstillingen deaktiveret, vil studerende kunne aflevere opgaver med det samme.';
$string['allowsubmissionsfromdatesummary'] = 'Denne opgave accepterer afleveringer fra <strong>{$a}</strong>';
$string['allowsubmissionsshort'] = 'Tillad ændring i afleveringer';
$string['alwaysshowdescription'] = 'Vis altid beskrivelsen';
$string['alwaysshowdescription_help'] = 'Hvis indstillingen er deaktiveret, vil ovenstående opgavebeskrivelse kun blive vist fra datoen "Tillad aflevering fra"';
$string['applytoteam'] = 'Anvend karakterer og feedback til hele gruppen';
$string['assign:addinstance'] = 'Tilføj en ny opgave';
$string['assign:editothersubmission'] = 'Rediger en anden brugers aflevering';
$string['assign:exportownsubmission'] = 'Eksporter din aflevering';
$string['assign:grade'] = 'Bedøm opgaven';
$string['assign:grantextension'] = 'Tildel forlængelse';
$string['assign:manageallocations'] = 'Administrer bedømmere tildelt afleveringer';
$string['assign:managegrades'] = 'Gennemgå og frigiv karakterer';
$string['assign:manageoverrides'] = 'Håndter opgaveundtagelser';
$string['assign:receivegradernotifications'] = 'Modtag karaktergiver afleverings notifikationer';
$string['assign:releasegrades'] = 'Frigiv karakterer';
$string['assign:revealidentities'] = 'Vis studerendes identitet';
$string['assign:reviewgrades'] = 'Gennemse karakterer';
$string['assign:showhiddengrader'] = 'Se en skjult bedømmers identitet';
$string['assign:submit'] = 'Aflever';
$string['assign:view'] = 'Vis opgaven';
$string['assign:viewblinddetails'] = 'Vis de studerendes identitet, når anonyme afleveringer er aktiveret';
$string['assign:viewgrades'] = 'Vis karakterer';
$string['assign:viewownsubmissionsummary'] = 'Se egen afleveringsoversigt';
$string['assignfeedback'] = 'Feedback-plugin';
$string['assignfeedbackpluginname'] = 'Feedback-plugin';
$string['assignmentisdue'] = 'Afleveringsfristen er overskredet';
$string['assignmentmail'] = '{$a->grader} har givet feedback på din opgave "{$a->assignment}".

Du kan se det føjet til din opgavebesvarelse her:

{$a->url}';
$string['assignmentmailhtml'] = '<p>{$a->grader} har givet feedback på din opgave <i>"{$a->assignment}"</i></p>
<p>Du kan se det tilføjet din <a href="{$a->url}">opgavebesvarelse</a>.</p>';
$string['assignmentmailsmall'] = '{$a->grader} har givet feedback på din opgave "{$a->assignment}". Du kan se det føjet til din opgavebesvarelse';
$string['assignmentname'] = 'Opgavenavn';
$string['assignmentplugins'] = 'Opave-plugins';
$string['assignmentsperpage'] = 'Afleveringer pr. side';
$string['assignsubmission'] = 'Afleverings-plugin';
$string['assignsubmissionpluginname'] = 'Afleverings-plugin';
$string['assigntimeleft'] = 'Tid tilbage';
$string['attemptheading'] = 'Forsøg {$a->attemptnumber}: {$a->submissionsummary}';
$string['attempthistory'] = 'Tidligere forsøg';
$string['attemptnumber'] = 'Antal forsøg på besvarelse';
$string['attemptreopenmethod'] = 'Flere opgavebesvarelser';
$string['attemptreopenmethod_help'] = 'Denne indstilling bestemmer, om en studerende kan gøre yderligere forsøg på at løse opgaven. For hvert forsøg gemmes karakteren og feedback og kan ses af læreren og den studerende. De tilgængelige indstillinger er:

* Aldrig - Opgaven kan ikke genåbnes.
* Manuelt - En lærer kan tillade flere besvarelser
* Automatisk indtil bestået - Flere besvarelser er automatisk tilladt indtil den studerende har opnået beståelseskarakter for opgaven.';
$string['attemptreopenmethod_manual'] = 'Manuelt';
$string['attemptreopenmethod_none'] = 'Aldrig';
$string['attemptreopenmethod_untilpass'] = 'Automatisk indtil bestået';
$string['attemptsettings'] = 'Indstillinger for besvarelsesforsøg';
$string['availability'] = 'Tilgængelighed';
$string['back'] = 'Tilbage';
$string['backtoassignment'] = 'Tilbage til opgaven';
$string['batchoperationconfirmaddattempt'] = 'Tillad et nyt besvarelsesforsøg på valgte afleveringer?';
$string['batchoperationconfirmdownloadselected'] = 'Download valgte afleveringer?';
$string['batchoperationconfirmgrantextension'] = 'Forlæng alle valgte afleveringer?';
$string['batchoperationconfirmlock'] = 'Lås alle valgte afleveringer?';
$string['batchoperationconfirmremovesubmission'] = 'Fjern valgte afleveringer?';
$string['batchoperationconfirmreverttodraft'] = 'Marker valgte afleveringer som kladde?';
$string['batchoperationconfirmsetmarkingallocation'] = 'Tildel  bedømmer til alle valgte afleveringer?';
$string['batchoperationconfirmsetmarkingworkflowstate'] = 'Sæt bedømmelsesfase for alle valgte afleveringer?';
$string['batchoperationconfirmunlock'] = 'Lås alle markerede afleveringer op?';
$string['batchoperationlock'] = 'Lås afleveringerne';
$string['batchoperationreverttodraft'] = 'marker afleveringer som kladde';
$string['batchoperationsdescription'] = 'Med valgte...';
$string['batchoperationunlock'] = 'Lås afleveringerne op';
$string['batchsetallocatedmarker'] = 'Tildel bedømmer til {$a} valgt(e) bruger(e).';
$string['batchsetmarkingworkflowstateforusers'] = 'Sæt bedømmelsesfase for {$a} valgt(e) bruger(e).';
$string['beginassignment'] = 'Begynd aflevering';
$string['blindmarking'] = 'Anonyme afleveringer';
$string['blindmarking_help'] = 'Anonyme afleveringer skjuler den studerendes identitet for bedømmerne. Indstillingerne for anonyme afleveringer låses når en opgave er afleveret eller bedømt.';
$string['blindmarkingenabledwarning'] = 'Anonyme afleveringer er aktiveret i denne aktivitet. Karakterer vil ikke blive tilføjet karakterbogen før identiteten på den studerende afsløres via karakterhandlingsmenuen.';
$string['cachedef_overrides'] = 'Oplysninger om tilsidesættelse af brugere og grupper';
$string['calendardue'] = '{$a} skal afleveres';
$string['calendargradingdue'] = '{$a} skal vurderes';
$string['caneditsubmission'] = 'Du kan redigere din aflevering og indsende den, når fristen er udløbet, men den vil blive markeret som afleveret for sent.';
$string['changefilters'] = 'Skift filtre';
$string['changeuser'] = 'Skift bruger';
$string['choosegradingaction'] = 'Bedømmelse';
$string['choosemarker'] = 'Vælg...';
$string['chooseoperation'] = 'Vælg operation';
$string['clickexpandreviewpanel'] = 'Klik for at udvide gennemsynspanelet';
$string['collapsegradepanel'] = 'Sammenklap karakterpanelet';
$string['collapsereviewpanel'] = 'Sammenklap gennemsynspanelet';
$string['comment'] = 'Kommentar';
$string['completiondetail:submit'] = 'Aflever en besvarelse';
$string['completionsubmit'] = 'Studerende skal aflevere en opgave';
$string['configshowrecentsubmissions'] = 'Alle kan se notifikationer på afleveringer i seneste aktivitetsrapporter.';
$string['confirmbatchgradingoperation'] = 'Er du sikker på at du vil {$a->operation} for {$a->count} studerende?';
$string['confirmstart'] = 'Du har {$a} til at fuldføre denne opgave. Når du begynder, begynder timeren at tælle ned og kan ikke sættes på pause.';
$string['confirmsubmission'] = 'Er du sikker på at du vil aflevere opgaven til bedømmelse nu? Bagefter vil du ikke kunne ændre den';
$string['confirmsubmissionheading'] = 'Bekræft aflevering';
$string['conversionexception'] = 'Kunne ikke konvertere opgaven. Fejlen var: {$a}.';
$string['couldnotconvertgrade'] = 'Kunne ikke omregne opgavekarakteren for brugeren {$a}.';
$string['couldnotconvertsubmission'] = 'Kunne ikke omregne bedømmelse af opgaven for bruger {$a}.';
$string['couldnotcreatecoursemodule'] = 'Kunne ikke oprette kursusmodul.';
$string['couldnotcreatenewassignmentinstance'] = 'Kunne ikke oprette en ny opgave.';
$string['couldnotfindassignmenttoupgrade'] = 'Kunne ikke finde en gammel opgave at opgradere.';
$string['crontask'] = 'Baggrundsbehandling af opgavemodulet';
$string['currentassigngrade'] = 'Aktuel karakter for opgaven';
$string['currentattempt'] = 'Dette er besvarelsesforsøg {$a}.';
$string['currentattemptof'] = 'Dette er besvarelsesforsøg {$a->attemptnumber} ({$a->maxattempts} tilladte).';
$string['currentgrade'] = 'Aktuelle karakter i karakterbogen';
$string['cutoffdate'] = 'Seneste afleveringsdato';
$string['cutoffdate_help'] = 'Hvis angivet, vil afleveringer ikke blive accepteret efter denne dato uden en forlængelse. Hvis ikke angivet, vil afleveringer altid blive accepteret.';
$string['cutoffdatecolon'] = 'Seneste skæringsdato: {$a}';
$string['cutoffdatefromdatevalidation'] = 'Skæringsdatoen kan ikke ligge før datoen for "Tillad aflevering fra".';
$string['cutoffdatevalidation'] = 'Skæringsdatoen kan ikke ligge før afleveringsdatoen.';
$string['defaultlayout'] = 'Gendan standardlayout';
$string['defaultsettings'] = 'Standard for opgaveindstillinger';
$string['defaultsettings_help'] = 'Indstillingerne styrer standardindstillingerne i nye opgaver.';
$string['defaultteam'] = 'Standardgruppe';
$string['deleteallsubmissions'] = 'Slet alle afleveringer';
$string['description'] = 'Kort beskrivelse';
$string['disabled'] = 'Deaktiveret';
$string['downloadall'] = 'Download alle afleverede opgaver';
$string['downloadasfolders'] = 'Download afleveringer i mapper';
$string['downloadasfolders_help'] = 'Opgaveafleveringer kan downloades i mapper. Hver aflevering lægges i sin mappe, med mappestruktur og filnavne bevaret.';
$string['downloadselectedsubmissions'] = 'Download valgte afleveringer';
$string['duedate'] = 'Afleveringsdato';
$string['duedate_help'] = 'Dette er seneste afleveringstidspunkt. Opgaver vil stadig kunne afleveres efter dette tidspunkt, men bliver markeret som for sent afleveret. Skæringsdatoen sætter grænsen for hvor længe opgaver kan afleveres.';
$string['duedateaftersubmissionvalidation'] = 'Afleveringsdatoer skal være efter tilladelsesdatoen for afleveringer';
$string['duedatecolon'] = 'Afleveringsfrist: {$a}';
$string['duedatereached'] = 'Afleveringsfristen er overskredet';
$string['duedatevalidation'] = 'Skæringsdatoen kan ikke ligge før datoen for hvornår der tidligst kan afleveres.';
$string['duplicateoverride'] = 'Dubler undtagelse';
$string['editaction'] = 'Handlinger...';
$string['editattemptfeedback'] = 'Rediger bedømmelse og feedback på besvarelse nummer {$a}.';
$string['editingpreviousfeedbackwarning'] = 'Du redigerer feedback på en tidligere besvarelse. Denne er besvarelse {$a->attemptnumber} ud af {$a->totalattempts}.';
$string['editingstatus'] = 'Redigeringsstatus';
$string['editonline'] = 'Rediger online';
$string['editoverride'] = 'Rediger undtagelse';
$string['editsubmission'] = 'Rediger opgavebesvarelse';
$string['editsubmission_help'] = 'Du kan stadig ændre din opgavebesvarelse.';
$string['editsubmissionother'] = 'Rediger aflevering for {$a}';
$string['enabled'] = 'Aktiveret';
$string['enabletimelimit'] = 'Aktiver tidsafgrænsede opgaver';
$string['enabletimelimit_help'] = 'Er indstillingen aktiveret, kan du angive en tidsbegrænsning på siden med opgaveindstillinger.';
$string['errornosubmissions'] = 'Der er ingen afleveringer at downloade';
$string['errorquickgradingvsadvancedgrading'] = 'Karaktereren blev ikke gemt, fordi denne opgave i øjeblikket bruger avanceret bedømmelse';
$string['errorrecordmodified'] = 'Karakteren blev ikke gemt, fordi nogen har redigeret en eller flere poster siden du indlæste siden.';
$string['eventallsubmissionsdownloaded'] = 'Alle afleveringer er ved at blive downloadet.';
$string['eventassessablesubmitted'] = 'En besvarelse er blevet afleveret.';
$string['eventbatchsetmarkerallocationviewed'] = 'Tildeling af batch sæt-bedømmer set';
$string['eventbatchsetworkflowstateviewed'] = 'Batch sæt status for bedømmelsesfase set';
$string['eventextensiongranted'] = 'Der er givet udsættelse.';
$string['eventfeedbackupdated'] = 'Feedback opdateret';
$string['eventfeedbackviewed'] = 'Feedback set';
$string['eventgradingformviewed'] = 'Bedømmelsesformular set';
$string['eventgradingtableviewed'] = 'Bedømmelsestabel set';
$string['eventidentitiesrevealed'] = 'Identiteterne er blevet afdækket.';
$string['eventmarkerupdated'] = 'Den tildelte bedømmer er blevet opdateret.';
$string['eventoverridecreated'] = 'Opgaveundtagelse oprettet';
$string['eventoverridedeleted'] = 'Opgaveundtagelse slettet';
$string['eventoverrideupdated'] = 'Opgaveundtagelse opdateret';
$string['eventremovesubmissionformviewed'] = 'Bekræftelse af fjernet aflevering set.';
$string['eventrevealidentitiesconfirmationpageviewed'] = 'Bekræftelsessiden afdæk identiteter set.';
$string['eventstatementaccepted'] = 'Brugeren har accepteret erklæringen for opgaven.';
$string['eventsubmissionconfirmationformviewed'] = 'Bekræftelsesformular set.';
$string['eventsubmissioncreated'] = 'Opgave oprettet.';
$string['eventsubmissionduplicated'] = 'Brugeren har dubleret sin aflevering.';
$string['eventsubmissionformviewed'] = 'Opgaveformular set.';
$string['eventsubmissiongraded'] = 'Opgaven er bedømt.';
$string['eventsubmissionlocked'] = 'Opgaven er låst for en bruger.';
$string['eventsubmissionremoved'] = 'Aflevering fjernet.';
$string['eventsubmissionstatusupdated'] = 'Opgavens status er opdateret.';
$string['eventsubmissionstatusviewed'] = 'Opgavens status er set.';
$string['eventsubmissionunlocked'] = 'Opgaven er låst op for en bruger.';
$string['eventsubmissionupdated'] = 'Aflevering opdateret.';
$string['eventsubmissionviewed'] = 'Aflevering set.';
$string['eventworkflowstateupdated'] = 'Tilstanden for bedømmelsesfase er opdateret.';
$string['expandreviewpanel'] = 'Udvid gennemsynspanelet';
$string['extensionduedate'] = 'Afleveringsfrist forlænget';
$string['extensionnotafterduedate'] = 'Den forlængede afleveringsfrist skal ligge efter afleveringsdatoen';
$string['extensionnotafterfromdate'] = 'Den forlængede afleveringsfrist skal ligge efter datoen for hvornår opgaven tidligst kan afleveres';
$string['feedback'] = 'Feedback';
$string['feedbackavailableanonhtml'] = 'Du har ny feedback på din aflevering af "<i>{$a->assignment}</i>"<br /><br />Du kan se den tilføjet din <a href="{$a->url}">afleverede opgave her</a>.';
$string['feedbackavailableanonsmall'] = 'Ny feedback på opgaven {$a->assignment}';
$string['feedbackavailableanontext'] = 'Du har ny feedback på din aflevering af "{$a->assignment}". Du kan se den tilføjet din <a href="{$a->url}">afleverede opgave her</a>.';
$string['feedbackavailablehtml'] = '{$a->username} har givet feedback på din opgave <i>"{$a->assignment}"</i> <br /><br />Du kan se <a href="{$a->url}">opgaven med feedback her</a>.';
$string['feedbackavailablesmall'] = '{$a->username} har givet feedback på opgaven {$a->assignment}';
$string['feedbackavailabletext'] = '{$a->username} har givet feedback på din opgave "{$a->assignment}". Du kan se det tilføjet opgaven her: {$a->url}';
$string['feedbackplugin'] = 'Feedback-plugin';
$string['feedbackpluginforgradebook'] = 'Feedback-plugin, der sender kommentarer til karakterbogen';
$string['feedbackpluginforgradebook_help'] = 'Kun et opgave-feedback-plugin kan lægge feedback i karakterbogen.';
$string['feedbackplugins'] = 'Feedback-plugins';
$string['feedbacksettings'] = 'Feedback-indstillinger';
$string['feedbacktypes'] = 'Feedbacktyper';
$string['filesubmissions'] = 'Filafleveringer';
$string['filter'] = 'Filter';
$string['filterdraft'] = 'Kladde';
$string['filtergrantedextension'] = 'Forlængelse bevilget';
$string['filternone'] = 'Ingen filter';
$string['filternotsubmitted'] = 'Ikke afleveret';
$string['filterrequiregrading'] = 'Kræver bedømmelse';
$string['filtersubmitted'] = 'Afleveret';
$string['fixrescalednullgrades'] = 'Denne opgave indeholder nogle fejlagtige karakterer. Du kan <a href="{$a->link}">fikse dem automatisk</a>. Det kan influere på kursustotaler.';
$string['fixrescalednullgradesconfirm'] = 'Er du sikker på at du vil fikse fejlagtige karakterer? Alle berørte karakterer vil blive fjernet. Det kan påvirke kursets samlede karakterer.';
$string['fixrescalednullgradesdone'] = 'Karakterer fikset.';
$string['gradeabovemaximum'] = 'Karakteren skal være mindre end eller lig med {$a}.';
$string['gradebelowzero'] = 'Karakteren skal være højere end eller lig med nul.';
$string['gradebreakdown'] = 'Karakterfordeling';
$string['gradecanbechanged'] = 'Karakteren kan ændres';
$string['gradechangessaveddetail'] = 'Ændringer af karakter og feedback gemt';
$string['graded'] = 'Bedømt';
$string['gradedby'] = 'Bedømt af';
$string['gradedfollowupsubmit'] = 'Bedømt - genafleveret';
$string['gradedon'] = 'Bedømt';
$string['gradeitem:submissions'] = 'Afleveringer';
$string['gradelocked'] = 'Denne bedømmelse er låst eller overskrevet i karakterbogen.';
$string['gradeoutof'] = 'Bedømmelse af {$a}';
$string['gradeoutofhelp'] = 'Bedømmelse';
$string['gradeoutofhelp_help'] = 'Skriv bedømmelsen her. Du kan bruge decimaler.';
$string['gradersubmissionupdatedhtml'] = '{$a->username} har opdateret sin opgaveaflevering for <i>"{$a->assignment}"</i> {$a->timeupdated}<br /><br />Den er tilgængelig på <a href="{$a->url}">websiden</a>.';
$string['gradersubmissionupdatedsmall'] = '{$a->username} har opdateret sin afleverede opgave {$a->assignment}.';
$string['gradersubmissionupdatedtext'] = '{$a->username} har opdateret sin opgaveaflevering for "{$a->assignment}" {$a->timeupdated}.

Den er tilgængelig her:

{$a->url}';
$string['gradestudent'] = 'Bedøm studerende: (id={$a->id}, fullname={$a->fullname}).';
$string['gradeuser'] = 'Bedømmelse {$a}';
$string['grading'] = 'Bedømmelse';
$string['gradingchangessaved'] = 'Ændringerne er gemt';
$string['gradingduedate'] = 'Mind mig om at rette opgaver';
$string['gradingduedate_help'] = 'Den dag afleverede opgaver forventes vurderet. Datoen bruges til prioritering af påmindelser til lærere.';
$string['gradingdueduedatevalidation'] = 'Påmindelse om at vurdere kan ikke gives inden forfaldsdagen.';
$string['gradingduefromdatevalidation'] = 'Påmindelse om at vurdere kan ikke gives inden der er åbent for aflevering.';
$string['gradingmethodpreview'] = 'Bedømmelseskriterier';
$string['gradingoptions'] = 'Valgmuligheder';
$string['gradingstatus'] = 'Vurderingsstatus';
$string['gradingstudent'] = 'Bedømmer studerende';
$string['gradingsummary'] = 'Bedømmelsesopsummering';
$string['grantextension'] = 'Tildel forlængelse';
$string['grantextensionforusers'] = 'Tildel forlængelse til {$a} studerende';
$string['groupoverrides'] = 'Gruppeundtagelser';
$string['groupoverridesdeleted'] = 'Gruppeundtagelser slettet';
$string['groupsnone'] = 'Du har ikke adgang til nogen grupper.';
$string['groupsubmissionsettings'] = 'Indstillinger for gruppeaflevering';
$string['hiddenuser'] = 'Deltager';
$string['hidegrader'] = 'Skjul den der vurderers identitet for de studerende';
$string['hidegrader_help'] = 'Er indstillingen aktiveret, vil identiteten på brugere der giver en opgave karakter, ikke vises, så studerende får ikke at vide hvem der bedømte deres arbejde. Bemærk at indstillingen ikke berører kommentarbokse på karaktergivningssiden.';
$string['hideshow'] = 'Skjul/vis';
$string['inactiveoverridehelp'] = '* Denne tilsidesættelse er inaktiv fordi den studerendes adgang til aktiviteten er begrænset. Det kan skyldes gruppe- eller rolledildelinger, andre adgangsbegrænsninger, eller at aktiviteten er skjult.';
$string['indicator:cognitivedepth'] = 'Kognitiv opgave';
$string['indicator:cognitivedepth_help'] = 'Denne indikator er baseret på den kognitive dybde, som en studerende har opnået i en opgaveaktivitet.';
$string['indicator:cognitivedepthdef'] = 'Kognitiv opgave';
$string['indicator:cognitivedepthdef_help'] = 'Deltageren har nået denne procentdel af den kognitive engagement, der tilbydes af opgaveaktiviteterne i løbet af analyseintervallet (Niveauer = Ingen visning, Visning, Aflevering, Vis feedback, Kommenter feedback, Genaflevering efter visning af feedback)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Social opgave';
$string['indicator:socialbreadth_help'] = 'Denne indikator er baseret på den sociale bredde, som den studerende har opnået i en opgaveaktivitet';
$string['indicator:socialbreadthdef'] = 'Social opgave';
$string['indicator:socialbreadthdef_help'] = 'Deltageren har nået denne procentdel af det sociale engagement, der tilbydes af opgaveaktiviteterne i løbet af analyseintervallet (Niveauer = Ingen deltagelse, Deltager alene, Deltager med andre)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['instructionfiles'] = 'Instruktionsfiler';
$string['introattachments'] = 'Supplerende filer';
$string['introattachments_help'] = 'Der kan tilføjes yderligere filer til brug i opgaven, f.eks. svarskabeloner.';
$string['invalidfloatforgrade'] = 'Bedømmelsen kunne ikke forstås: {$a}';
$string['invalidgradeforscale'] = 'Bedømmelsen er ikke gyldig på den aktuelle skala';
$string['invalidoverrideid'] = 'Ugyldig undtagelses-id';
$string['lastmodifiedgrade'] = 'Senest redigeret (karakter)';
$string['lastmodifiedsubmission'] = 'Senest redigeret (aflevering)';
$string['latesubmissions'] = 'Forsinkede opgaveafleveringer';
$string['latesubmissionsaccepted'] = 'Tilladt indtil {$a}';
$string['loading'] = 'Henter...';
$string['locksubmissionforstudent'] = 'Undgå flere afleveringer fra: (id = {$a->id}, fullname = {$a->fullname}).';
$string['locksubmissions'] = 'Lås afleveringer';
$string['manageassignfeedbackplugins'] = 'Administrer plugins for opgavefeedback';
$string['manageassignsubmissionplugins'] = 'Administrer plugins for opgaveaflevering';
$string['marker'] = 'Bedømmer';
$string['markerfilter'] = 'Bedømmerfilter';
$string['markerfilternomarker'] = 'Ingen bedømmer';
$string['markingallocation'] = 'Brug tildeling af bedømmer';
$string['markingallocation_help'] = 'Er indstillingen aktiveret sammen med bedømmelsesfaser, kan bedømmere tildeles bestemte studerende.';
$string['markingworkflow'] = 'Brug bedømmelsesfaser';
$string['markingworkflow_help'] = 'Hvis dette er aktiveret, vil bedømmelser gennemgå en række faser, før de bliver frigivet til de studerende. Dette giver mulighed for flere bedømmelsesrunder og gør det muligt at frigive bedømmelserne til alle studerende på samme tid.';
$string['markingworkflowstate'] = 'Status på bedømmelsesfase';
$string['markingworkflowstate_help'] = 'Mulige bedømmelsesfaser kan (afhængig af dine beføjelser) inkludere:

* Ikke bedømt - bedømmeren er endnu ikke gået i gang
* Bedømmelse i gang - bedømmeren er gået i gang, men er endnu ikke færdig
* Bedømmelse afsluttet - bedømmeren er færdig men skal måske tilbage og tjekke/rette
* Gennemgås - bedømmelsen ligger hos den lærer, der er ansvarlig for at kvalitetstjekke
* Klar til udgivelse - den ansvarlige lærer er tilfreds med bedømmelsen, men venter måske med at give studerende adgang til bedømmelsen
* Udgivet - den studerende har adgang til bedømmelserne/feedback';
$string['markingworkflowstateinmarking'] = 'Bedømmelse i gang';
$string['markingworkflowstateinreview'] = 'Gennemgås';
$string['markingworkflowstatenotmarked'] = 'Ikke bedømt';
$string['markingworkflowstatereadyforrelease'] = 'Klar til udgivelse';
$string['markingworkflowstatereadyforreview'] = 'Bedømmelse fuldført';
$string['markingworkflowstatereleased'] = 'Udgivet';
$string['maxattempts'] = 'Maksimum besvarelsesforsøg';
$string['maxattempts_help'] = 'Det maksimale antal afleveringsforsøg en studerende kan foretage. Efter dette antal kan den opgavebesvarelsen ikke åbnes igen.';
$string['maxgrade'] = 'Højeste karakter';
$string['maxperpage'] = 'Højeste antal opgaver per side';
$string['maxperpage_help'] = 'Det højeste antal opgaver en bedømmer kan vise på bedømmelsessiden. Kan bruges til at undgå timeout på kurser med mange deltagere.';
$string['messageprovider:assign_notification'] = 'Opgave-meddelelser';
$string['modulename'] = 'Opgave';
$string['modulename_help'] = 'Med opgavemodulet kan en lærer stille opgaver, samle besvarelser og give karakterer og feedback.

Studerende kan aflevere digitalt i form af f.eks. tekstbehandlingsdokumenter, regneark, billeder, lyd eller videoklip. Opgaven kan også være at skrive en tekst online direkte i teksteditoren. Desuden kan opgaver rettes mod arbejde afleveret i den fysiske verden, f.eks. et kunst- eller håndværk, der ikke kræver digitalt indhold. De studerende kan aflevere opgaver som medlemmer af en gruppe.

Læreren kan kommentere afleverede opgaver og uploadede filer såsom "marked-up"-afleveringer, dokumenter med kommentarer eller indtalt feedback i lydfiler. Opgaver kan gives karakterer numerisk med en skræddersyet skala, eller ved brug af en avanceret karaktergivningsmetode såsom "rubric". Karakterer opføres i karakterbogen.';
$string['modulename_link'] = 'mod/assignment/view';
$string['modulenameplural'] = 'Opgaver';
$string['moreusers'] = '{$a} flere...';
$string['multipleteams'] = 'Medlem af mere end en gruppe';
$string['multipleteams_desc'] = 'Opgaven kræver gruppeaflevering. Du er medlem af flere grupper. For at kunne aflevere må du kun være med i en gruppe. Kontakt din lærer og få ændret dit gruppemedlemskab.';
$string['multipleteamsgrader'] = 'Medlem af mere end en gruppe og kan derfor ikke foretage afleveringer';
$string['newsubmissions'] = 'Opgaver afleveret';
$string['nextuser'] = 'Næste bruger';
$string['noattempt'] = 'Intet besvarelsesforsøg';
$string['noclose'] = 'Ingen lukkedato';
$string['nofiles'] = 'Ingen filer.';
$string['nofilters'] = 'Ingen filtre';
$string['nograde'] = 'Ingen bedømmelse.';
$string['nogroupoverrides'] = 'Der er i øjeblikket ingen gruppe-overstyringer';
$string['nomoresubmissionsaccepted'] = 'Kun tilladt for deltagere, der har fået udsættelse';
$string['none'] = 'Ingen';
$string['noonlinesubmissions'] = 'Denne opgave kræver ikke at du afleverer noget online';
$string['noopen'] = 'Ingen åbningsdato';
$string['nooverridedata'] = 'Du skal overskrive mindst en af opgaveindstillingerne.';
$string['nosavebutnext'] = 'Næste';
$string['nosubmission'] = 'Der er endnu ikke afleveret noget til denne opgave';
$string['nosubmissionyet'] = 'Der er endnu ikke foretaget nogle afleveringer';
$string['noteam'] = 'Ikke medlem af nogen grupper';
$string['noteam_desc'] = 'Opgaven kræver gruppeaflevering. Du er ikke med i en gruppe, så du kan ikke aflevere opgaven. Kontakt din lærer for at komme med i en gruppe.';
$string['noteamgrader'] = 'Er ikke medlem af en gruppe, og kan dermed heller ikke aflevere opgaver.';
$string['notgraded'] = 'Ikke bedømt';
$string['notgradedyet'] = 'Ikke bedømt endnu';
$string['notifications'] = 'Meddelelser';
$string['nouseroverrides'] = 'Der er i øjeblikket ingen bruger-overstyringer';
$string['nousers'] = 'Ingen brugere';
$string['nousersselected'] = 'Ingen brugere er valgt';
$string['numberofdraftsubmissions'] = 'Kladder';
$string['numberofparticipants'] = 'Deltagere';
$string['numberofsubmissionsneedgrading'] = 'Mangler bedømmelse';
$string['numberofsubmissionsneedgradinglabel'] = 'Skal bedømmes: {$a}';
$string['numberofsubmittedassignments'] = 'Afleveret';
$string['numberofteams'] = 'Grupper';
$string['offline'] = 'Der kræves ikke online-aflevering';
$string['open'] = 'Åben';
$string['opensubmissionexists'] = 'Der eksistere allerede en åben opgaveaflevering.';
$string['outlinegrade'] = 'Karakter: {$a}';
$string['outof'] = '{$a->current} ud af {$a->total}';
$string['overdue'] = 'Afleveringsdatoen er overskredet med: {$a}';
$string['override'] = 'Undtagelser';
$string['overridedeletegroupsure'] = 'Bekræft at du vil slette undtagelse for gruppen {$a}?';
$string['overridedeleteusersure'] = 'Bekræft at du vil slette undtagelse for brugeren {$a}?';
$string['overridegroup'] = 'Gruppe';
$string['overridegroupeventname'] = '{$a->assign} - {$a->group}';
$string['overrides'] = 'Undtagelser';
$string['overrideuser'] = 'Bruger';
$string['overrideusereventname'] = '{$a->assign} - Undtagelse';
$string['page-mod-assign-view'] = 'Opgavemodulets hoved- og afleveringsside';
$string['page-mod-assign-x'] = 'En hvilken som helst opgaveside';
$string['paramtimeremaining'] = '{$a} tilbage';
$string['participant'] = 'Deltager';
$string['pluginadministration'] = 'Opgaveadministration';
$string['pluginname'] = 'Opgave';
$string['preventsubmissionnotingroup'] = 'Kræv gruppeaflevering';
$string['preventsubmissionnotingroup_help'] = 'Når dette er aktiveret, kan brugere der ikke er medlem af en gruppe, ikke aflevere opgaver.';
$string['preventsubmissions'] = 'Undgå at brugeren afleverer denne opgave igen.';
$string['preventsubmissionsshort'] = 'Undgå ændringer i afleveringer';
$string['previous'] = 'Forrige';
$string['previoususer'] = 'Forrige bruger';
$string['privacy:attemptpath'] = 'forsøg {$a}';
$string['privacy:blindmarkingidentifier'] = 'Bruger-id brugt til anonyme afleveringer';
$string['privacy:gradepath'] = 'karakter';
$string['privacy:metadata:assigndownloadasfolders'] = 'En brugerindstilling for hvorvidt flere filafleveringer skal downloades i mapper';
$string['privacy:metadata:assignfeedbackpluginsummary'] = 'Feedback på opgaven';
$string['privacy:metadata:assignfilter'] = 'Filtreringer såsom "Afleveret", "Ikke afleveret", "Kræver bedømmelse" og "Udsættelse givet"';
$string['privacy:metadata:assigngrades'] = 'Gemmer brugers karakter for opgaver';
$string['privacy:metadata:assignmarkerfilter'] = 'Filtrer opgavesammenfatningen efter den tildelte bedømmer.';
$string['privacy:metadata:assignmentid'] = 'Opgavens id';
$string['privacy:metadata:assignmessageexplanation'] = 'Beskeder sendes til de studerende via beskedsystemet.';
$string['privacy:metadata:assignoverrides'] = 'Gemmer information om undtagelser for opgaven';
$string['privacy:metadata:assignperpage'] = 'Antal opgaver vist per side.';
$string['privacy:metadata:assignquickgrading'] = 'En indstilling om hvorvidt hurtig bedømmelse bruges.';
$string['privacy:metadata:assignsubmissiondetail'] = 'Gemmer information om brugers aflevering';
$string['privacy:metadata:assignsubmissionpluginsummary'] = 'Afleveringsdata for opgaven.';
$string['privacy:metadata:assignuserflags'] = 'Gemmer metadata om bruger såsom udsættelse af afleveringsfrist';
$string['privacy:metadata:assignusermapping'] = 'Mapping for anonyme afleveringer';
$string['privacy:metadata:assignworkflowfilter'] = 'Filtrer efter de forskellige workflowtrin.';
$string['privacy:metadata:grade'] = 'Den numeriske karakter for denne opgaveaflevering. Kan bestemmes af scales/advancedgradingforms osv., men vil altid blive konverteret tilbage til et flydende pointantal.';
$string['privacy:metadata:grader'] = 'Bruger-id for den der har givet karakter.';
$string['privacy:metadata:groupid'] = 'Id for den gruppe brugeren er medlem af.';
$string['privacy:metadata:latest'] = 'Forsimpler kraftigt forespørgsler på information om seneste forsøg på løsning af opgaven.';
$string['privacy:metadata:mailed'] = 'Har brugeren fået tilsendt en mail?';
$string['privacy:metadata:timecreated'] = 'Oprettelsestidspunkt';
$string['privacy:metadata:timestarted'] = 'Tid startet';
$string['privacy:metadata:userid'] = 'Bruger-id';
$string['privacy:studentpath'] = 'deltagerafleveringer';
$string['privacy:submissionpath'] = 'aflevering';
$string['quickgrading'] = 'Hurtig bedømmelse';
$string['quickgrading_help'] = 'Hurtig bedømmelse gør det muligt at rette opgaver direkte i tabellen med afleveringer. Hurtig bedømmelse kan ikke bruges sammen med avanceret karaktergivning og anbefales ikke når der er flere om at bedømme opgaver.';
$string['quickgradingchangessaved'] = 'Bedømmelsesændringerne er gemt';
$string['quickgradingresult'] = 'Hurtig bedømmelse';
$string['recordid'] = 'Identifikator';
$string['relativedatessubmissionduedateafter'] = '{$a->datediffstr} efter kursusstart';
$string['relativedatessubmissionduedatebefore'] = '{$a->datediffstr} inden kursusstart';
$string['relativedatessubmissiontimeleft'] = 'Beregnet for hver studerende';
$string['removeallgroupoverrides'] = 'Slet alle gruppeundtagelser';
$string['removealluseroverrides'] = 'Slet alle brugerundtagelser';
$string['removesubmission'] = 'Fjern aflevering';
$string['removesubmissionconfirm'] = 'Er du sikker på at du vil fjerne afleveringen?';
$string['removesubmissionconfirmforstudent'] = 'Er du sikker på at du vil fjerne {$a}s aflevering?';
$string['removesubmissionconfirmforstudentwithtimelimit'] = 'Er du sikker på, at du vil fjerne afleveringen for {$a}? Vær opmærksom på, at dette ikke nulstiller elevens tidsbegrænsning. Du kan give mere tid ved at tilføje en tidsbegrænsning brugeroverskrivelse.';
$string['removesubmissionconfirmwithtimelimit'] = 'Er du sikker på, at du vil fjerne din aflevering? Vær opmærksom på, at dette ikke nulstiller din tidsbegrænsning.';
$string['removesubmissionforstudent'] = 'Fjern (id={$a->id}, fullname={$a->fullname})s aflevering.';
$string['reopenuntilpassincompatiblewithblindmarking'] = 'Genåbn indtil bestået er inkompatibel med anonym bedømmelse, fordi karaktererne ikke sendes til karakterbogen før brugernes identitet er afsløret.';
$string['requireallteammemberssubmit'] = 'Kræv at alle medlemmer af gruppen afleverer';
$string['requireallteammemberssubmit_help'] = 'Er indstillingen aktiveret, skal alle medlemmer af gruppen klikke på opgavens aflever-knap, før gruppeopgaven betragtes som afleveret. Hvis indstillingen er deaktiveret, vil gruppeopgaven blive betragtet som værende afleveret, så snart et medlem af gruppen klikker på "Aflever".';
$string['requiresubmissionstatement'] = 'Kræv at studerende accepterer afleveringserklæringen';
$string['requiresubmissionstatement_help'] = 'Kræv at studerende accepterer afleveringserklæringen for alle afleveringer af denne opgave.';
$string['revealidentities'] = 'Vis de studerendes identiteter';
$string['revealidentitiesconfirm'] = 'Er du sikker på, du vil vise de studerendes identiteter for denne opgave? Dette kan ikke fortrydes. Når de studerendes identiteter er afsløret, vil bedømmelserne blive frigivet til karakterbogen.';
$string['reverttodefaults'] = 'Gendan opgavestandarder';
$string['reverttodraft'] = 'Marker opgavens status som kladde';
$string['reverttodraftforgroup'] = 'Nulstil afleveringen til kladde for gruppen {$a}.';
$string['reverttodraftforstudent'] = 'Marker opgavens status som kladde for den studerende (id={$a->id}, fullname={$a->fullname}).';
$string['reverttodraftshort'] = 'Marker opgavens status som kladde';
$string['reviewed'] = 'Gennemset';
$string['save'] = 'Gem';
$string['saveallquickgradingchanges'] = 'Gem alle ændringer i hurtig bedømmelse';
$string['saveandcontinue'] = 'Gem og fortsæt';
$string['savechanges'] = 'Gem ændringer';
$string['savegradingresult'] = 'Bedømmelse';
$string['savenext'] = 'Gem og vis den næste';
$string['saveoverrideandstay'] = 'Gem og gå til næste undtagelse';
$string['savingchanges'] = 'Gemmer ændringer...';
$string['scale'] = 'Skala';
$string['search:activity'] = 'Opgave - aktivitetsinformation';
$string['selectedusers'] = 'Valgte brugere';
$string['selectlink'] = 'Vælg...';
$string['selectuser'] = 'Vælg {$a}';
$string['sendlatenotifications'] = 'Notificer lærere om for sene afleveringer';
$string['sendlatenotifications_help'] = 'Er indstillingen aktiveret, vil lærere (eller andre, der kan rette opgaver) modtage besked når en studerende for sent afleverer en opgave. Notifikationsmetoder kan konfigureres.';
$string['sendnotifications'] = 'Notificer lærere om afleveringer';
$string['sendnotifications_help'] = 'Er indstillingen aktiveret, vil lærere (eller andre, der kan rette opgaver) modtage besked når en studerende afleverer en opgave inden- eller udenfor fristen. Notifikationsmetoder kan konfigureres.';
$string['sendstudentnotifications'] = 'Underret studerende';
$string['sendstudentnotifications_help'] = 'Hvis indstillingen er aktiveret, modtager de studerende besked om opdaterede bedømmelser eller feedback. Hvis der bruges bedømmelsesfaser i denne opgave, vil underretninger først sendes ud når karakteren er "frigivet".';
$string['sendstudentnotificationsdefault'] = 'Standardindstilling for "Underret studerende"';
$string['sendstudentnotificationsdefault_help'] = 'Skal der som standard være et flueben i "Underret den studerende" ved bedømmelse af hver enkelt studerende?';
$string['sendsubmissionreceipts'] = 'Send kvittering for aflevering';
$string['sendsubmissionreceipts_help'] = 'Kontakt til at sende kvittering for modtagelse af opgaver til de studerende. De studerende vil få besked, hver gang de har indsendt en opgave.';
$string['setmarkerallocationforlog'] = 'Sæt bedømmelsestildeling: (id={$a->id}, fullname={$a->fullname}, bedømmer={$a->marker}).';
$string['setmarkingallocation'] = 'Tildel bedømmer';
$string['setmarkingworkflowstate'] = 'Sæt tilstand på bedømmelsesfase';
$string['setmarkingworkflowstateforlog'] = 'Sæt tilstand på bedømmelsesfase: (id={$a->id}, fullname={$a->fullname}, state={$a->state}).';
$string['settings'] = 'Opgaveindstillinger';
$string['showrecentsubmissions'] = 'Se de seneste afleveringer';
$string['status'] = 'Status';
$string['studentnotificationworkflowstateerror'] = 'Tilstand på bedømmelsesfase skal være "Frigivet", for at de studerende kan underrettes.';
$string['submission'] = 'Aflevering';
$string['submissionattachments'] = 'Vis kun filer under aflevering';
$string['submissionattachments_help'] = 'Marker boksen for kun at vise filer på afleveringssiden. Ellers vises filer både på opgave- og afleveringssiderne.';
$string['submissioncopiedhtml'] = '<p>Du har oprettet en kopi af din tidligere opgavebesvarelse til <i>"{$a->assignment}".</i> </p><p> Du kan se status for din <a href="{$a->url}">afleverede opgave</a>.</p>';
$string['submissioncopiedsmall'] = 'Du har kopieret din tidligere afleverede opgave til {$a->assignment}';
$string['submissioncopiedtext'] = 'Du har kopieret din tidligere afleverede opgave for "{$a->assignment}".

Se status på din afleverede opgave:

{$a->url}';
$string['submissiondrafts'] = 'Kræv at de studerende klikker på afleveringsknappen';
$string['submissiondrafts_help'] = 'Er indstillingen aktiveret, skal studerende klikke på en knap for at aflevere opgaven. Dette gør det muligt for de studerende at arbejde på og gemme en kladde, inden opgaven afleveres. Hvis denne indstilling ændres fra "Nej" til "Ja" efter at de studerende har afleveret, vil disse afleveringer blive betragtet som endelige.';
$string['submissioneditable'] = 'Den studerende kan redigere opgaven.';
$string['submissionempty'] = 'Der blev ikke afleveret noget.';
$string['submissionlog'] = 'Studerende: {$a->fullname}, Status: {$a->status}';
$string['submissionmodified'] = 'Du har eksisterende afleveringsdata. Forlad denne side og prøv igen.';
$string['submissionmodifiedgroup'] = 'Opgavebesvarelsen er ændret af en anden. Forlad denne side og prøv igen.';
$string['submissionnotcopiedinvalidstatus'] = 'Opgaven blev ikke kopieret, fordi den har været redigeret, efter at den blev genåbnet.';
$string['submissionnoteditable'] = 'Den studerende kan ikke redigere denne opgave';
$string['submissionnotopen'] = 'Denne opgave er ikke åben for afleveringer';
$string['submissionnotready'] = 'Denne opgave er ikke klar til aflevering:';
$string['submissionplugins'] = 'Afleverings-plugins';
$string['submissionreceipthtml'] = '<p>Du har afleveret en opgavebesvarelse til "<i>{$a->assignment}</i>".</p> <p>Du kan se status for din <a href="{$a->url}">opgaveaflevering her</a>.</p>';
$string['submissionreceiptotherhtml'] = 'Din opgavebesvarelse for "<i>{$a->assignment}</i>" er afleveret.<br /><br />Du kan se status for din <a href="{$a->url}">opgaveaflevering her</a>.';
$string['submissionreceiptothersmall'] = 'Din opgavebesvarelse til {$a->assignment} er afleveret.';
$string['submissionreceiptothertext'] = 'Din opgavebesvarelse til
"{$a->assignment}" er afleveret.

Se status for din opgaveaflevering:

{$a->url}';
$string['submissionreceipts'] = 'Send kvitteringer for afleveringer';
$string['submissionreceiptsmall'] = 'Du har afleveret din opgavebesvarelse til {$a->assignment}';
$string['submissionreceipttext'] = 'Du har afleveret din opgavebesvarelse til "{$a->assignment}".

Du kan se status på din opgaveaflevering:

{$a->url}';
$string['submissionsclosed'] = 'Afleveringer lukket';
$string['submissionsettings'] = 'Afleveringsindstillinger';
$string['submissionslocked'] = 'Denne opgave accepterer ikke afleveringer';
$string['submissionslockedshort'] = 'Ændringer til afleveringer er ikke tilladt';
$string['submissionstatement'] = 'Afleveringserklæring';
$string['submissionstatement_help'] = 'Erklæring den studerende skal acceptere for at kunne aflevere opgaver';
$string['submissionstatementacceptedlog'] = 'Afleveringserklæringen er accepteret af brugeren {$a}';
$string['submissionstatementdefault'] = 'Denne aflevering er mit eget arbejde, medmindre jeg har erkendt brug af andres værker.';
$string['submissionstatementteamsubmission'] = 'Gruppe-afleveringserklæring';
$string['submissionstatementteamsubmission_help'] = 'Erklæring hver enkelt studerende skal acceptere for at kunne aflevere gruppens arbejde.';
$string['submissionstatementteamsubmissionallsubmit'] = 'Gruppe-afleveringserklæring til når alle gruppemedlemmer afleverer';
$string['submissionstatementteamsubmissionallsubmit_help'] = 'Erklæring hver enkelt studerende skal acceptere for at kunne aflevere sit arbejde som gruppemedlem.';
$string['submissionstatementteamsubmissionallsubmitdefault'] = 'Denne aflevering er mit eget arbejde som gruppemedlem, bortset fra hvor jeg har brugt og krediteret andre for deres arbejde.';
$string['submissionstatementteamsubmissiondefault'] = 'Denne aflevering er min gruppes arbejde, bortset fra hvor vi har brugt og krediteret andre for deres arbejde.';
$string['submissionstatus'] = 'Afleveringsstatus';
$string['submissionstatus_'] = 'Ingen opgavebesvarelse';
$string['submissionstatus_draft'] = 'Kladde (ikke afleveret)';
$string['submissionstatus_marked'] = 'Bedømt';
$string['submissionstatus_new'] = 'Ingen aflevering';
$string['submissionstatus_reopened'] = 'Genåbnet';
$string['submissionstatus_submitted'] = 'Afleveret til bedømmelse';
$string['submissionstatusheading'] = 'Afleveringsstatus';
$string['submissionsummary'] = '{$a->status}. Sidst ændret på {$a->timemodified}';
$string['submissionteam'] = 'Gruppe';
$string['submissiontypes'] = 'Afleveringstype';
$string['submitaction'] = 'Aflever';
$string['submitassignment'] = 'Aflever';
$string['submitassignment_help'] = 'Når opgaven er afleveret kan du ikke længere foretage ændringer i den.';
$string['submitforgrading'] = 'Aflever til bedømmelse';
$string['submitted'] = 'Afleveret';
$string['submittedearly'] = 'Opgaven blev afleveret {$a} inden fristens udløb.';
$string['submittedlate'] = 'Opgaven blev afleveret {$a} for sent';
$string['submittedlateshort'] = '{$a} for sent';
$string['submittedovertime'] = 'Opgaven blev indleveret {$a} for sent';
$string['submittedundertime'] = 'Opgaven blev indleveret {$a} før tidsgrænsen';
$string['subpagetitle'] = '{$a->contextname} - {$a->subpage}';
$string['subplugintype_assignfeedback'] = 'Feedback-plugin';
$string['subplugintype_assignfeedback_plural'] = 'Feedback-plugins';
$string['subplugintype_assignsubmission'] = 'Afleverings-plugin';
$string['subplugintype_assignsubmission_plural'] = 'Afleverings-plugins';
$string['teamname'] = 'Team: {$a}';
$string['teamsubmission'] = 'De studerende afleverer i grupper';
$string['teamsubmission_help'] = 'Er indstillingen aktiveret, vil de studerende blive inddelt i grupper baseret på standardgruppeindstillinger eller skræddersyet gruppering. En gruppeaflevering vil blive delt mellem gruppens medlemmer, og alle medlemmer af gruppen vil se hinandens ændringer til afleveringen.';
$string['teamsubmissiongroupingid'] = 'Gruppering af studerende';
$string['teamsubmissiongroupingid_help'] = 'Dette er den gruppering som opgaven vil bruge til at finde grupper til indeling af de studerende i grupper. Er indstillingen ikke aktiveret, vil standardgruppeindstillingerne blive brugt.';
$string['textinstructions'] = 'Opgave-instrukser';
$string['timelimit'] = 'Tidsbegrænsning';
$string['timelimit_help'] = 'Hvis aktiveret, vises tidsbegrænsningen på opgavesiden, og en nedtællingstimer vises under opgaven.';
$string['timelimitnotenabled'] = 'Tidsbegrænsning er ikke aktiveret for opgaven.';
$string['timelimitpassed'] = 'Tidsbegrænsningen er overskredet';
$string['timemodified'] = 'Seneste ændring';
$string['timeremaining'] = 'Resterende tid';
$string['timeremainingcolon'] = 'Tid tilbage: {$a}';
$string['togglezoom'] = 'Zoom ind/ud af region';
$string['ungroupedusers'] = 'Indstillingen \'Kræv gruppeaflevering\' er slået til, og nogle brugere er forhindret i at aflevere opgaver da de ikke er med i en gruppe eller er medlem af mere end en gruppe.';
$string['ungroupedusersoptional'] = 'Indstillingen "De studerende afleverer i grupper" er aktiveret og nogle brugere er enten ikke medlem af en gruppe eller er med i mere end en gruppe. Vær opmærksom på at disse studerende vil aflevere som medlem af "Standardgruppe".';
$string['unlimitedattempts'] = 'Ubegrænset';
$string['unlimitedattemptsallowed'] = 'Ubegrænset antal besvarelsesforsøg tilladt.';
$string['unlimitedpages'] = 'Ubegrænset';
$string['unlocksubmissionforstudent'] = 'Tillad afleveringer for studerende: (id={$a->id}, fullname={$a->fullname}).';
$string['unlocksubmissions'] = 'Lås afleveringer op';
$string['unsavedchanges'] = 'Ugemte ændringer';
$string['unsavedchangesquestion'] = 'Der er ændringer i karakterer eller feedback. Vil du gemme ændringerne og fortsætte?';
$string['updategrade'] = 'Opdater bedømmelse';
$string['updatetable'] = 'Gem og opdater tabel';
$string['upgradenotimplemented'] = 'Opdater ikke-implementeret plugin ({$a->type} {$a->subtype})';
$string['userassignmentdefaults'] = 'Standardindstillinger for brugertildeling';
$string['userextensiondate'] = 'Forlængelse indtil: {$a}';
$string['usergrade'] = 'Brugerbedømmelse';
$string['useridlistnotcached'] = 'Karakterændringerne blev IKKE gemt da det ikke var muligt at afgøre hvilken aflevering de tilhørte.';
$string['useroverrides'] = 'Brugerundertagelser';
$string['useroverridesdeleted'] = 'Brugerundtagelse slettet';
$string['usersnone'] = 'Ingen studerende har adgang til denne opgave.';
$string['usersubmissioncannotberemoved'] = 'Afleveringen af {$a} kan ikke fjernes.';
$string['userswhoneedtosubmit'] = 'Brugere, der skal aflevere: {$a}';
$string['validmarkingworkflowstates'] = 'Gyldige bedømmelsesfaser';
$string['viewadifferentattempt'] = 'Vis et andet forsøg';
$string['viewbatchmarkingallocation'] = 'Vis side for tildeling af gruppebedømmelse.';
$string['viewbatchsetmarkingworkflowstate'] = 'Vis side for gruppebedømmelsesfase-tilstand.';
$string['viewfeedback'] = 'Vis feedback';
$string['viewfeedbackforuser'] = 'Vis feedback for brugeren: {$a}';
$string['viewfull'] = 'Vis det hele';
$string['viewfullgradingpage'] = 'Se hele bedømmelsessiden for at give feedback';
$string['viewgradebook'] = 'Vis karakterbog';
$string['viewgrading'] = 'Vis alle afleveringer';
$string['viewgradingformforstudent'] = 'Vis bedømmelsesside for studerende: (id={$a->id}, fullname={$a->fullname}).';
$string['viewownsubmissionform'] = 'Vis egen opgaveafleveringsside.';
$string['viewownsubmissionstatus'] = 'Vis side med egen afleveringsstatus';
$string['viewrevealidentitiesconfirm'] = 'Vis bekræftelsesside for "Vis de studerendes identiteter".';
$string['viewsubmission'] = 'Vis aflevering';
$string['viewsubmissionforuser'] = 'Vis aflevering for brugeren: {$a}';
$string['viewsubmissiongradingtable'] = 'Vis bedømmelsestabel for aflevering.';
$string['viewsummary'] = 'Vis resumé';
$string['workflowfilter'] = 'Bedømmelsesfasefilter';
$string['xofy'] = '{$a->x} af {$a->y}';
