<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_learnr', language 'es_mx', version '4.1'.
 *
 * @package     theme_learnr
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityiconcoloradministrationsetting'] = 'Color del ícono de actividad para "Administración"';
$string['activityiconcoloradministrationsetting_desc'] = 'El color del ícono de actividad para "Administración"';
$string['activityiconcolorassessmentsetting'] = 'Color del ícono de actividad para "Evaluación"';
$string['activityiconcolorassessmentsetting_desc'] = 'El color del ícono de actividad para "Evaluación"';
$string['activityiconcolorcollaborationsetting'] = 'Color del ícono de actividad para "Colaboración"';
$string['activityiconcolorcollaborationsetting_desc'] = 'El color del ícono de actividad para "Colaboración"';
$string['activityiconcolorcommunicationsetting'] = 'Color del ícono de actividad para "Comunicación"';
$string['activityiconcolorcommunicationsetting_desc'] = 'El color del ícono de actividad para "Comunicación"';
$string['activityiconcolorcontentsetting'] = 'Color del ícono de actividad para "Contenido"';
$string['activityiconcolorcontentsetting_desc'] = 'El color del ícono de actividad para "Contenido"';
$string['activityiconcolorinterfacesetting'] = 'Color del ícono de actividad para "Interfase"';
$string['activityiconcolorinterfacesetting_desc'] = 'El color del ícono de actividad para "Interfase"';
$string['activityiconcolorsheading'] = 'Colores de ícono de actividad';
$string['activitynavigation'] = 'Navegación de actividad';
$string['activitynavigationsetting'] = 'Elementos de navegación de actividad';
$string['additionalresourcesfileurlpersistent'] = 'URL (persistente)';
$string['additionalresourcesfileurlrevisioned'] = 'URL (revisionada)';
$string['additionalresourcesheading'] = 'Recursos adicionales';
$string['additionalresourceslistsetting'] = 'Lista de recursos adicionales';
$string['additionalresourcessetting'] = 'Recursos adicionales';
$string['backgroundimagesetting'] = 'Imagen del fondo';
$string['backgroundimagesetting_desc'] = 'Aquí puede subir una imagen personalizada para mostrar como un fondo del sitio. La imagen del fondo que usted suba aquí anulará la imagen del fondo de los archivos de pre-configuración del tema.';
$string['backgroundimagesheading'] = 'Imágenes gnerales del fondo';
$string['backtotop'] = 'Regresar a superior';
$string['backtotopbuttonsetting'] = 'Regresar al botón superior';
$string['bgdark'] = 'Color oscuro de BarradeNavegación';
$string['bgdark_desc'] = 'Cambiar el valor de la clase .bg-dark.';
$string['bgwhite'] = 'Color claro de BarradeNavegación';
$string['bgwhite_desc'] = 'Cambiar el valor de la clase .bg-white.';
$string['blockregionoutsidebottomwidth'] = 'Ancho de región de bloque para región \'Afuera (fondo)\'';
$string['blockregionoutsideleftwidth'] = 'Ancho de región de bloque para región \'Afuera (izquierda)\'';
$string['blockregionoutsiderightwidth'] = 'Ancho de región de bloque para región \'Afuera (derecha)\'';
$string['blockregionoutsidetopwidth'] = 'Ancho de región de bloque para región \'Afuera (superior)\'';
$string['blockregionsforlayout'] = 'Regiones de bloque adicionales para diseño \'{$a}\'';
$string['blockregionsforlayout_desc'] = 'Con esta configuración usted puede habilitar regiones adicionales de bloque para el diseño \'{$a}\'.';
$string['blockregionsheading'] = 'Regiones de bloque adicionales';
$string['blocksgeneralheading'] = 'Bloques generales';
$string['blockstab'] = 'Bloques';
$string['bodybg'] = 'Color del fondo del cuerpo';
$string['bodybg_desc'] = 'Cambiar el color del fondo del cuerpo';
$string['bootstrapcolordangersetting'] = 'Color Bootstrap para "Peligro"';
$string['bootstrapcolordangersetting_desc'] = 'El color Bootstrap para "Peligro"';
$string['bootstrapcolorinfosetting'] = 'Color Bootstrap para "Info"';
$string['bootstrapcolorinfosetting_desc'] = 'El color Bootstrap para "Info"';
$string['bootstrapcolorsheading'] = 'Colores Bootstrap';
$string['bootstrapcolorsuccesssetting'] = 'Color Bootstrap para "Éxito"';
$string['bootstrapcolorsuccesssetting_desc'] = 'El color Bootstrap para "Éxito"';
$string['bootstrapcolorwarningsetting'] = 'Color Bootstrap para "Advertencia"';
$string['bootstrapcolorwarningsetting_desc'] = 'El color Bootstrap para "Advertencia"';
$string['bootstrapdangercolor'] = 'Color de peligro';
$string['bootstrapdarkcolor'] = 'Color oscuro';
$string['bootstrapinfocolor'] = 'Color de Info';
$string['bootstraplightcolor'] = 'Color claro';
$string['bootstrapnone'] = 'Sin color Bootstrap';
$string['bootstrapprimarycolor'] = 'Color primario';
$string['bootstrapsecondarycolor'] = 'Color secundario';
$string['bootstrapsuccesscolor'] = 'Color de éxito';
$string['bootstrapwarningcolor'] = 'Color de advertencia';
$string['brandcolorsheading'] = 'Color de la marca';
$string['brandingtab'] = 'Marcado personalizado';
$string['cachedef_flavours'] = 'Sabores que aplican a una ID de categoría de una página dada para el usuario actual';
$string['cachedef_fontawesome'] = 'Archivos de FontAwesome (que son cargados en las configuraciones de LearnR)';
$string['choosereadme'] = 'El tema LearnR es un tema mejorado hijo del tema  Boost proporcionado por Moodle.';
$string['closeoffcanvas'] = 'Cerrar cajón Afuera-del-lienzo';
$string['configtitle'] = 'LearnR';
$string['configtitlecontent'] = 'Contenido';
$string['configtitlefeel'] = 'Aspecto';
$string['configtitleflavours'] = 'Sabores';
$string['configtitlefunctionality'] = 'Funcionalidad';
$string['configtitlelook'] = 'Aspecto';
$string['contactcontentsetting'] = 'Contenido de página para contacto';
$string['contactcontentsetting_desc'] = 'En esta configuración, usted puede añadir contenido de texto enriquecido que será mostrado en una página para contacto (que NO es la misma que la estándar incorporada en Moodle \'Ponerse en contacto con soporte del sitio\').';
$string['contactdisabled'] = 'La página para contacto está deshabilitada para este sitio. Aquí no hay nada para ver.';
$string['contactheading'] = 'Contacto';
$string['contactlinkpositionboth'] = 'Añadir un enlace a la página de contacto al pie de página y al ícono del (signo de interrogación del) pie de página';
$string['contactlinkpositionfooter'] = 'Añadir un enlace a la página de contacto al ícono del (signo de interrogación del) pie de página';
$string['contactlinkpositionfootnote'] = 'Añadir un enlace a la página de contacto al pie de página';
$string['contactlinkpositionnone'] = 'NO mostrar automáticamente un enlace a la página de contacto';
$string['contactlinkpositionsetting'] = 'Posición del enlace a la página de contacto';
$string['contactpagetitledefault'] = 'Contacto';
$string['contactpagetitlesetting'] = 'Título de página de contacto';
$string['contentwidthheading'] = 'Ancho del contenido';
$string['courseactivitiesbtntext'] = 'Actividades del Curso';
$string['courseblockpanelbtn'] = 'Gestión del Curso';
$string['courseblockpanelbtnclose'] = 'Cerrar';
$string['courseboxheight'] = 'Altura de Mosaico del Curso';
$string['courseboxheight_desc'] = 'Controla la altura del mosaico del curso en la Portada y en categorías de curso.';
$string['coursecontentmaxwidthsetting'] = 'Ancho máximo del contenido del curso';
$string['coursecontentmaxwidthsetting_desc'] = 'Con esta configuración, usted puede anular el ancho del contenido del curso Moodle sin modificaciones manuales por SCSS. Este ancho es usado como el ancho de página de las páginas del curso y dentro de varias actividades. de forma predeterminada, Moodle usa un ancho máximo del contenido del curso de 830px. Usted puede ingresar otros valores basados en pixeles como por ejemplo 1200px, pero usted también puede ingresar un valor basado en  porcentaje como por ejemplo 100%, o un valor del ancho del \'viewport\' (mirador) como 90vw.';
$string['courseenrollmentcode'] = 'Código de Inscripción al Curso';
$string['courseheaderheading'] = 'encabezado del Curso';
$string['courseheaderimageenabled'] = 'Mostrar la imagen del curso en el encabezado del curso';
$string['courseheaderimageenabled_desc'] = 'Cuando se habilita, la imagen del curso (que puede ser subida en las configuraciones del curso) es mostrada en el encabezado de un curso. Las imágenes del curso son mostradas aquí además de en la página de \'Mis cursos\' donde siempre son mostradas.';
$string['courseheaderimagefallback'] = 'Imagen del encabezado de curso (plan B)';
$string['courseheaderimageheight'] = 'Altura de imagen del encabezado del curso';
$string['courseheaderimageheight_desc'] = 'Con esta configuración usted controla la altura de la imagen presentada del encabezado del curso.';
$string['courseheaderimagelayout'] = 'Diseño de imagen del encabezado del curso';
$string['courseheaderimagelayout_desc'] = 'Con esta configuración usted controla el diseño de la imagen del encabezado del curso y el título del curso.';
$string['courseheaderimagelayoutheadingabove'] = 'Título del curso arriba de imagen del curso';
$string['courseheaderimagelayoutstackeddark'] = 'Título del curso apilado sobre la imagen del curso (color blanco del font para imágenes de fondo oscuro)';
$string['courseheaderimagelayoutstackedlight'] = 'Título del curso apilado sobre la imagen del curso (color negro del font para imágenes de fondo claro)';
$string['courseheaderimageposition'] = 'Posición de imagen de encabezado del curso';
$string['coursemanagementbutton'] = 'Gestión del Curso';
$string['coursemanagetitle'] = 'Curso';
$string['courserelatedhintsheading'] = 'Pistas relacionadas con el curso';
$string['coursestab'] = 'Cursos';
$string['coursestyle1'] = 'Estilo de Mosaico Uno';
$string['coursestyle2'] = 'Estilo de Mosaico Dos';
$string['coursestyle3'] = 'Estilo de Mosaico Tres';
$string['coursestyle4'] = 'Mosaico Estilo Cuatro c/resumen del curso';
$string['coursestyle5'] = 'Horizontal Estilo Uno';
$string['coursestyle6'] = 'Horizontal Imagen del Fondo Detalles Completos';
$string['coursestyle7'] = 'Imagen de Fondo Horizontal Solamente Profesores y Título';
$string['coursestyle8'] = 'Visualización Predeterminada de Curso Moodle';
$string['coursetab'] = 'Curso';
$string['coursetilestyle'] = 'Visualización de Título del Curso';
$string['coursetilestyle_desc'] = 'Al ver categorías de curso usted puede elegir de entre los siguientes estilos para mostrar cursos en la página inicial y las áreas de categoría de cursos.';
$string['createinfo'] = 'Botón para Creador de Curso Especial';
$string['createinfodesc'] = 'Este botón aparece en la página inicial cuando un usuario puede crear nuevos cursos. Aquellos con el rol de Creador de Curso al nivel del sitio verán este botón.';
$string['cssh5pheading'] = 'CSS crudo para H5P';
$string['cssh5psetting'] = 'CSS crudo para H5P';
$string['customfontsfileurlpersistent'] = 'URL (persistente)';
$string['customfontsfileurlrevisioned'] = 'URL (revisionada)';
$string['customfontsheading'] = 'Fonts personalizados';
$string['customfontslistsetting'] = 'Lista de fonts personalizados';
$string['customfontssetting'] = 'Fonts personalizados';
$string['drawerbg'] = 'Color de Fondo del Cajón';
$string['drawerbg_desc'] = 'Cambiar el color del fondo del cajón';
$string['easyenrollbtn'] = 'Códigos para Inscripción';
$string['emailbrandinghtmlheading'] = 'Previsualización de E-mail en HTML';
$string['emailbrandinghtmlintro'] = 'Esta es una previsualización de un E-mail HTML basado en prejijos y sufijos de la imagen de la marca que actualmente están configurados en el paquete del idioma.';
$string['emailbrandinghtmlnopreview'] = 'Hasta ahora, los E-mails HTML no habían sido personalizados dentro de esta característica. Los E-mails estarán compuestos y enviados normalmente.';
$string['emailbrandinginstruction'] = 'Cómo-hacerle';
$string['emailbrandinginstructionli2'] = 'Buscar y modificar estas cadenas de caracteres (strings) en el paquete del  <code>theme_learnr language</code>:';
$string['emailbrandinginstructionli3'] = 'Guardar los cambios al paquete del idioma.';
$string['emailbrandinginstructionli4'] = 'Regresar a esta página y echar un vistazo a la previsualización de E-mail inferior.';
$string['emailbrandingintroheading'] = 'Introducción';
$string['emailbrandingpitfalls'] = 'Inconvenientes';
$string['emailbrandingpitfalls0'] = 'Al usar esta característica, hay algunos inconvenientes que usted debería de conocer.';
$string['emailbrandingpitfallsli2'] = 'No es posible respetar el idioma del destinatario. Por esto, usted debería de usar términos agnósticos del idioma dentro de los snippets (fragmentitos de código) de marca de E-mail.';
$string['emailbrandingtab'] = 'Marcado personalizado de E-mail';
$string['emailbrandingtextdemobody'] = 'El cuerpo del E-mail comienza aquí.

Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.

Id donec ultrices tincidunt arcu non sodales. Id volutpat lacus laoreet non curabitur gravida arcu.

Cursus turpis massa tincidunt dui. Pellentesque nec nam aliquam sem et tortor consequat id. In ornare quam viverra orci sagittis eu volutpat. Sem nulla pharetra diam sit amet nisl suscipit. Justo donec enim diam vulputate ut pharetra.

El cuerpo del E-mail termina aquí.';
$string['emailbrandingtextheading'] = 'Previsualización de E-mail en texto simple';
$string['enablecontactsetting'] = 'Habilitar página para contacto';
$string['enablehelpsetting'] = 'Habilitar página para ayuda';
$string['enableimprintsetting'] = 'Habilitar imprimir';
$string['enablemaintenancesetting'] = 'Habilitar página de información de mantenimiento';
$string['enrollcoursecard'] = 'Ver curso';
$string['error:infobannerdismissnonotdismissible'] = 'El banner de info no es descartable';
$string['error:infobannerdismissnonotvalid'] = 'El número dado del banner de info no es válido';
$string['exporttomistar'] = 'Exportar a MIStar';
$string['faviconheading'] = 'Favicon';
$string['faviconsetting'] = 'Favicon';
$string['faviconsetting_desc'] = 'Aquí puede subir una imagen personalizada  (formato .ico o .png) que el navegador mostrará como el favicon de su sitio web Moodle. Si no se sube un favicon personalizado, será usado un favicon estándar Moodle.';
$string['flavoursappliesto'] = 'Aplica a';
$string['flavoursapplytocategories'] = 'Aplica a categorías de curso';
$string['flavoursapplytocategories_help'] = 'Aquí usted define si es que este sabor debería ser aplicado a categorías de curso.';
$string['flavoursapplytocategories_ids'] = 'Categorías de curso';
$string['flavoursapplytocohorts'] = 'Aplica a cohortes';
$string['flavoursapplytocohorts_help'] = 'Aquí usted define si es que este sabor debería ser aplicado a cohortes.';
$string['flavoursapplytocohorts_ids'] = 'Cohortes';
$string['flavoursbackgroundimage'] = 'Imagen del fondo';
$string['flavoursbackgroundimage_help'] = 'Con esta configuración, el sabor anulará la imagen del fondo, la cual está configurada en las configuraciones de apariencia de LearnR.';
$string['flavoursbacktooverview'] = 'Regresar a vista general de sabor';
$string['flavourscreateflavour'] = 'Crear sabor';
$string['flavourscustomcss'] = 'CSS personalizado';
$string['flavoursdelete'] = 'Eliminar';
$string['flavoursdeleteconfirmation'] = '¿Realmente quiere eliminar el sabor <em>{$a}</em>?';
$string['flavoursdeleteflavour'] = 'Eliminar sabor';
$string['flavoursdescription'] = 'Descripción';
$string['flavoursdescription_help'] = 'La descripción del sabor solamente es usada de forma interna para permitirle identificar un sabor particular en la lista de sabores.';
$string['flavoursedit'] = 'Editar';
$string['flavourseditflavour'] = 'editar sabor';
$string['flavoursfavicon'] = 'Favicon';
$string['flavoursfavicon_help'] = 'Con esta configuración, el sabor sobre-escribirá el favicon que está configurado en las configuraciones de LearnR.';
$string['flavoursflavours'] = 'Sabores';
$string['flavoursgeneralsettings'] = 'Configuraciones generales';
$string['flavoursincludesubcategories'] = 'Incluir sub-categorías';
$string['flavoursincludesubcategories_help'] = 'Si se activa, el sabor también será aplicado a las subcategorías de las categorías elegidas.';
$string['flavourslogo'] = 'Logo';
$string['flavourslogo_help'] = 'Con esta configuración, el sabor sobre-escribirá el logo que está configurado en las configuraciones de LearnR.';
$string['flavourslogocompact'] = 'Logo compacto';
$string['flavourslogocompact_help'] = 'Con esta configuración, el sabor sobre-escribirá el logo que está configurado en las configuraciones de LearnR.';
$string['flavoursnothingtodisplay'] = 'No hay ningún sabor ya creado. Por favor cree usted su primer sabor para que ande la cosa.';
$string['flavoursnotificationcreated'] = 'El sabor fue creado exitosamente';
$string['flavoursnotificationdeleted'] = 'El sabor fue eliminado exitosamente';
$string['flavoursnotificationedited'] = 'El sabor fue editado exitosamente';
$string['flavourspreview'] = 'Previsualizar';
$string['flavourspreviewblindtext'] = 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Nunc id cursus metus aliquam eleifend mi in nulla. Felis imperdiet proin fermentum leo vel orci porta. Sed nisi lacus sed viverra tellus in hac habitasse. Vivamus arcu felis bibendum ut. Nisi porta lorem mollis aliquam ut porttitor. Odio euismod lacinia at quis risus sed vulputate odio. Sed felis eget velit aliquet sagittis id consectetur purus. Nec ullamcorper sit amet risus nullam eget. Pellentesque sit amet porttitor eget dolor. Cursus mattis molestie a iaculis at erat pellentesque.';
$string['flavourspreviewflavour'] = 'Pre-visualizar sabor';
$string['flavourstitle'] = 'Título';
$string['flavourstitle_help'] = 'El título del sabor solamente es usado de forma interna para permitirle a usted documentar un sabor particular en la lista de sabores.';
$string['fontawesomecheck-fa6free-filter-title'] = 'Filtro FontAwesome';
$string['fontawesomecheck-fa6free-general-description'] = 'Si ve el ícono de una palomita del lado izquierdo, FontAwesome  está generalmente funcionando en su sitio.';
$string['fontawesomecheck-fa6free-general-title'] = 'Funcionalidad general';
$string['fontawesomecheck-fa6free-newstuff-title'] = 'Íconos de FontAwesome  6';
$string['fontawesomecheckssetting'] = 'Comprobaciones de FontAwesome';
$string['fontawesomefilessetting'] = 'Archivos de FontAwesome';
$string['fontawesomeheading'] = 'FontAwesome';
$string['fontawesomelistfileinfo-fa6free-css-brands.min.css'] = 'Este es un archivo CSS adicional que añade el font para los íconos de marca FontAwesome a la página de Moodle.';
$string['fontawesomelistfileinfo-fa6free-css-fontawesome.min.css'] = 'Este es el archivo CSS principal que añade todos los glifos FontAwesome a la página de Moodle.';
$string['fontawesomelistfileinfo-fa6free-css-regular.min.css'] = 'Este es un archivo CSS adicional que añade el font para los íconos regulares FontAwesome a la página de Moodle.';
$string['fontawesomelistfileinfo-fa6free-css-solid.min.css'] = 'Este es un archivo CSS adicional que añade el font para los íconos sólidos FontAwesome a la página de Moodle.';
$string['fontawesomelistfileinfo-fa6free-css-v4-font-face.min.css'] = 'Este es el archivo CSS que se asegura que los íconos FontAwesome 4 en Moodle todavía son mostrados correctamente.';
$string['fontawesomelistfileinfo-fa6free-webfonts-fa-brands-400.ttf'] = 'Este es el archivo del font para los íconos de la marca FontAwesome 4 (en el formato TTF).';
$string['fontawesomelistfileinfo-fa6free-webfonts-fa-brands-400.woff2'] = 'Este es el archivo del font para los íconos de la marca FontAwesome 4 (en el formato WOFF2).';
$string['fontawesomelistfileinfo-fa6free-webfonts-fa-regular-400.ttf'] = 'Este es el archivo del font para los íconos regulares FontAwesome 4 (en el formato TTF).';
$string['fontawesomelistfileinfo-fa6free-webfonts-fa-regular-400.woff2'] = 'Este es el archivo del font para los íconos regulares FontAwesome 4 (en el formato WOFF2).';
$string['fontawesomelistfileinfo-fa6free-webfonts-fa-solid-900.ttf'] = 'Este es el archivo del font para los íconos sólidos FontAwesome 4 (en el formato TTF).';
$string['fontawesomelistfileinfo-fa6free-webfonts-fa-solid-900.woff2'] = 'Este es el archivo del font para los íconos sólidos FontAwesome 4 (en el formato WOFF2).';
$string['fontawesomelistfileinfo-fa6free-webfonts-fa-v4compatibility.ttf'] = 'Este es el archivo del font para la compatibilidad con v4 FontAwesome (en el formato TTF).';
$string['fontawesomelistfileinfo-fa6free-webfonts-fa-v4compatibility.woff2'] = 'Este es el archivo del font para la compatibilidad con v4 FontAwesome (en el formato WOFF2).';
$string['fontawesomelistmandatorymissing'] = 'Es un archivo obligatorio para que funcione FontAwesome, pero no fue subido apropiadamente. Por favor, intente subirlo apropiadamente.';
$string['fontawesomelistmandatoryuploaded'] = 'Este es un archivo obligatorio para que FonAwesome funcione y fue cargado apropiadamente.';
$string['fontawesomelistoptionaluploaded'] = 'Este es un archivo opcional apara el conjunto de íconos de FontAwesome y fue cargado apropiadamente.';
$string['fontawesomelistsetting'] = 'Lista de archivos de FontAwesome';
$string['fontawesomeversionfa6free'] = 'Actualizar a FontAwesome 6 Free';
$string['fontawesomeversionnone'] = 'Conservar FontAwesome 4 (tal como fue incluido con el núcleo de Moodle)';
$string['fontawesomeversionsetting'] = 'Versión de FontAwesome';
$string['footertab'] = 'Pie de página';
$string['footnoteheading'] = 'Nota al pie';
$string['footnotesetting'] = 'Nota al pie';
$string['footnotesetting_desc'] = 'Todo lo que usted añada a esta área de texto será mostrado al final de una página, en el pie de página (no el pie de página flotante) en  todas las páginas que usen los diseños "cajones", "columnas2" o "ingreso". el contenido en esta área podría ser, por ejemplo, el aviso de Copyright, los términos de uso o el nombre de su organización. <br/> Si usted quiere quitar la nota al pie, solamente vacíe el área de texto..';
$string['gradebooktitle'] = 'Libro de calificaciones';
$string['h5pcontentmaxwidthsetting'] = 'Ancho máximo del Banco de contenido H5P';
$string['h5pcontentmaxwidthsetting_desc'] = 'Con esta configuración, usted puede anular el ancho del Banco de contenido H5P de Moodle sin modificaciones manuales por SCSS. Este ancho es usado por el editor H5P dentro del Banco de contenido. <em>NO</em> es usado para el ancho de la actividad H5P. De forma predeterminada, Moodle usa un ancho máximo del Banco de contenido H5P de 960px. Usted puede ingresar otros valores basados en pixeles como por ejemplo 1200px, pero usted también puede ingresar un valor basado en  porcentaje como por ejemplo 100%, o un valor del ancho del \'viewport\' (mirador) como 90vw.';
$string['h5ptab'] = 'H5P';
$string['helpcontentsetting'] = 'Contenido de pagina de ayuda';
$string['helpcontentsetting_desc'] = 'En esta configuración, usted puede añadir contenido con texto enriquecido que será mostrado en una página de ayuda.';
$string['helpdisabled'] = 'La página de ayuda está des-habilitada para este sitio. Aquí no hay nada para ver.';
$string['helpheading'] = 'Ayuda';
$string['helplinkpositionboth'] = 'Añadir un enlace a la página de ayuda a la nota al pie y al ícono (signo de interrogación) del pie de página';
$string['helplinkpositionfooter'] = 'Añadir un enlace a la página de ayuda al ícono (?) del pie de página';
$string['helplinkpositionfootnote'] = 'Añadir un enlace a la página de ayuda en el pie de página';
$string['helplinkpositionnone'] = 'NO mostrar automáticamente un enlace a la página de ayuda';
$string['helplinkpositionsetting'] = 'Posición del enlace a página de ayuda';
$string['helppagetitledefault'] = 'Ayuda';
$string['helppagetitlesetting'] = 'Título de página de ayuda';
$string['hideloginform'] = 'Ocultar Formato para Ingresar al sitio';
$string['hideloginform_desc'] = '<b>¡TENGA CUIDADO!  Al activar esta característica se quitará el formato para ingreso.</b>  Solamente oculte el formato para ingreso si usted está usando otro método para ingresar como por ejemplo Google Login y usted nunca necesita usar el formato para ingreso.  Para recuperarse usted necesita quitar el archivo /moodle/theme/learnr/templates/core/loginform.mustache.  El eliminar este archivo le permitirá que re-aparezca el formato de ingreso si usted es expulsado completamente.';
$string['hidenodesprimarynavigationsetting'] = 'Ocultar nodos en navegación primaria';
$string['hidenodesprimarynavigationsetting_desc'] = 'Con esta configuración usted puede ocultar uno o varios nodos de la navegación primaria.';
$string['iconnavbartab'] = 'Navegación por Íconos';
$string['iconnavheading'] = 'Navegación por Ícono';
$string['iconnavinfo'] = 'Navegación por Ícono del Tablero';
$string['iconnavinfo_desc'] = 'Crear botones con íconos para usar en la página inicial. Estos aparecen en la parte superior del Tablero.';
$string['imprintcontentsetting'] = 'Imprimir contenido';
$string['imprintcontentsetting_desc'] = 'En esta configuración usted puede añadir contenido de texto enriquecido que será mostrado en la página de imprimir.';
$string['imprintdisabled'] = 'La página de imprimir está deshabilitada para este sitio. Auií no hay nada que ver.';
$string['imprintheading'] = 'Imprimir';
$string['imprintlinkpositionboth'] = 'Añadir un enlace a la página de Imprimir a la nota al pie y al ícono (signo de interrogación) del pie de página';
$string['imprintlinkpositionfooter'] = 'Añadir un enlace a la página de Imprimir al ícono (signo de interrogación) del pie de página';
$string['imprintlinkpositionfootnote'] = 'Añadir un enlace a la página de Imprimir a la nota al pie.';
$string['imprintlinkpositionnone'] = 'No mostrar automáticamente un enlace a la página para Imprimir';
$string['imprintlinkpositionsetting'] = 'Posición de enlace a Imprimir';
$string['imprintpagetitledefault'] = 'Imprimir';
$string['imprintpagetitlesetting'] = 'Título de página de Imprimir';
$string['infobannerbsclasssetting'] = 'Clase Bootstrap de banner info {$a->no}';
$string['infobannerclose'] = 'Cerrar';
$string['infobannercontentsetting'] = 'Contenido de banner info {$a->no}';
$string['infobannercontentsetting_desc'] = 'Aquí usted escribe la información que debería ser mostrada dentro del banner de info {$a->no}.';
$string['infobannerdismissfail'] = 'El reinicio de visibilidad de banner info {$a->no} hafallado para al menos un usuario';
$string['infobannerdismissiblesetting'] = 'Banner info {$a->no} descartable';
$string['infobannerdismissreset'] = 'Reiniciar visibilidad de banner info descartado';
$string['infobannerdismissresetbutton'] = 'Reiniciar visibilidad de banner info {$a->no}';
$string['infobannerdismisssuccess'] = 'La visibilidad de banner info {$a->no} ha sido reiniciada.';
$string['infobannerenabledsetting'] = 'Habilitar banner info {$a->no}';
$string['infobannerenabledsetting_desc'] = 'Con esta configuración, usted puede habilitar banner info {$a->no}';
$string['infobannerendsetting'] = 'Hora de terminación de banner info {$a->no}';
$string['infobannerheading'] = 'Banner info {$a->no}';
$string['infobannermodeperpetual'] = 'Perpetuo';
$string['infobannermodesetting'] = 'Modo de visualización de banner info {$a->no}';
$string['infobannermodesetting_desc'] = 'Con esta configuración usted puede decidir si el banner de información {$a->no} debería ser un banner perpetuo (que es mostrado siempre) o un banner controlado por tiempo (que es mostrado solamente dentro del intervalo de tiempo configurado).';
$string['infobannermodetimebased'] = 'Controlado por tiempo';
$string['infobannerordersetting'] = 'Posición de ordenamiento de banner info {$a->no}';
$string['infobannerpageloginpage'] = 'Página para ingresar al sitio';
$string['infobannerpagessetting'] = 'Diseños de página para mostrar banner info {$a->no}';
$string['infobannerpagessetting_desc'] = 'Con esta configuración usted puede seleccionar los diseños de página en los cuales debería ser mostrado el banner info {$a->no}.';
$string['infobannerstartsetting'] = 'Hora de inicio banner info {$a->no}';
$string['infobannertab'] = 'Banner info';
$string['javascriptdisabledhint'] = 'Pista JavaScript deshabilitado';
$string['javascriptdisabledhint_desc'] = 'Con esta configuración, aparecerá una pista en la parte superior de la página de Moodle si JavaScript no estuviera habilitado. Esto es particularmente útil porque varias características de Moodle no funcionan sin JavaScript.';
$string['javascriptheading'] = 'JavaScript';
$string['latestcourses'] = 'Cursos Recientes';
$string['learnr:configure'] = 'Poder configurar el tema como no-admin';
$string['learnr:editregioncontentlower'] = 'Poder editar la región del bloque contenido (inferior)';
$string['learnr:editregioncontentupper'] = 'Poder editar la región del bloque contenido (superior)';
$string['learnr:editregionfootercenter'] = 'Poder editar la región del bloque Pie de página (centro)';
$string['learnr:editregionfooterleft'] = 'Poder editar la región del bloque Pie de página (izquierda)';
$string['learnr:editregionfooterright'] = 'Poder editar la región del bloque Pie de página (derecha)';
$string['learnr:editregionheader'] = 'Poder editar la región del bloque Encabezado';
$string['learnr:editregionoffcanvascenter'] = 'Poder editar la región del bloque Afuera-del-lienzo (centro)';
$string['learnr:editregionoffcanvasleft'] = 'Poder editar la región del bloque Afuera-del-lienzo (izquierda)';
$string['learnr:editregionoffcanvasright'] = 'Poder editar la región del bloque Afuera-del-lienzo (derecha)';
$string['learnr:editregionoutsidebottom'] = 'Poder editar la región del bloque Afuera (fondo)';
$string['learnr:editregionoutsideleft'] = 'Poder editar la región del bloque Afuera (izquierda)';
$string['learnr:editregionoutsideright'] = 'Poder editar la región del bloque Afuera (derecha)';
$string['learnr:editregionoutsidetop'] = 'Poder editar la región del bloque Afuera (superior)';
$string['learnr:viewhintcourseselfenrol'] = 'Poder ver una pista para auto inscripción irrestricta en un curso visible.';
$string['learnr:viewhintinhiddencourse'] = 'Poder ver una  pista en un curso oculto';
$string['learnr:viewregioncontentlower'] = 'Poder ver la región del bloque Contenido (inferior)';
$string['learnr:viewregioncontentupper'] = 'Poder ver la región del bloque Contenido (superior)';
$string['learnr:viewregionfootercenter'] = 'Poder ver la región del bloque Pie de página (centro)';
$string['learnr:viewregionfooterleft'] = 'Poder ver la región del bloque Pie de página (izquierda)';
$string['learnr:viewregionfooterright'] = 'Poder ver la región del bloque Pie de página (derecha)';
$string['learnr:viewregionheader'] = 'Poder ver la región del bloque Encabezado';
$string['learnr:viewregionoffcanvascenter'] = 'Poder ver la región del bloque Afuera-del-lienzo (centro)';
$string['learnr:viewregionoffcanvasleft'] = 'Poder ver la región del bloque Afuera-del-lienzo (izquierda)';
$string['learnr:viewregionoffcanvasright'] = 'Poder ver la región del bloque Afuera-del-lienzo (derecha)';
$string['learnr:viewregionoutsidebottom'] = 'Poder ver la región del bloque Afuera (fondo)';
$string['learnr:viewregionoutsideleft'] = 'Poder ver la región del bloque Afuera (izquierda)';
$string['learnr:viewregionoutsideright'] = 'Poder ver la región del bloque Afuera (derecha)';
$string['learnr:viewregionoutsidetop'] = 'Poder ver la región del bloque Afuera (superior)';
$string['loginbackgroundimage'] = 'Imágenes del fondo de la página para ingresar al sitio';
$string['loginbackgroundimage_desc'] = 'Las imágenes a mostrar como un fondo de la página para ingresar al sitio. Una de estas imágenes será elegida aleatoriamente y será mostrada cuando el usuario visite la página para ingresar al sitio. Por favor asegúrese de NO usar caracteres-NO-ASCII en el nombre del archivo si es que usted quiere mostrar texto para las imágenes de fondo de la página para ingresar al sitio.';
$string['loginbackgroundimagesheading'] = 'Imágenes del fondo de la página para ingresar al sitio';
$string['loginbackgroundimagetextsetting'] = 'Mostrar texto para imágenes de fondo de página para ingresar al sitio';
$string['loginformheading'] = 'Formato para ingresar al sitio';
$string['loginformpositionsetting'] = 'Posición del Formato para ingresar al sitio';
$string['loginformpositionsetting_center'] = 'Centrado';
$string['loginformpositionsetting_left'] = 'Alineado a la izquierda';
$string['loginformpositionsetting_right'] = 'Alineado a la derecha';
$string['loginformtransparencysetting'] = 'Transparencia del formato para ingresar al sitio';
$string['loginformtransparencysetting_desc'] = 'Con esta configuración, usted puede facer el formato para ingresar al sitio ligeramente transparente, para permitir que la imagen del fondo brille aun más.';
$string['loginpagetab'] = 'Página para ingresar al sitio';
$string['logocompactsetting'] = 'Logo compacto';
$string['logocompactsetting_desc'] = 'Aquí puede usted subir una versión compacta del mismo logo de arriba, como por ejemplo un emblema, escudo o ícono. Esta imagen es especialmente usada en la Barra de Navegación en la parte superior de cada página de Moodle. La imagen deberá ser clara aun en tamaños pequeños.';
$string['logosetting'] = 'Logo';
$string['logosetting_desc'] = 'Aquí puede usted subir un logo completo para ser usado como decoración. esta imagen es usada especialmente en la página para ingresar al sitio. esta imagen puede ser de resolución bastante alta, porque será reducida para su uso.';
$string['logosheading'] = 'Logos';
$string['maintenancecontentsetting'] = 'Contenido de la página de información de mantenimiento';
$string['maintenancecontentsetting_desc'] = 'En esta configuración, usted puede añadir contenido de texto enriquecido que será mostrado en una página de información de mantenimiento (que no es la misma que la página de modo de mantenimiento estándar de Moodle).';
$string['maintenancedisabled'] = 'La página de información de mantenimiento está deshabilitada para este sitio. Aquí no hay nada para ver.';
$string['maintenanceheading'] = 'Mantenimiento';
$string['maintenancelinkpositionboth'] = 'Añadir un enlace a la página de información de mantenimiento al ícono (signo de interrogación) del pie de página y a la nota al pie';
$string['maintenancelinkpositionfooter'] = 'Añadir un enlace a la página de información de mantenimiento al ícono (signo de interrogación) del pie de página';
$string['maintenancelinkpositionfootnote'] = 'Añadir un enlace a la página de información de mantenimiento a la nota al pie';
$string['maintenancelinkpositionnone'] = 'No mostrar automáticamente un enlace a la página de información de mantenimiento';
$string['maintenancelinkpositionsetting'] = 'Posición de enlace a página de información de mantenimiento';
$string['maintenancepagetitledefault'] = 'Mantenimiento';
$string['maintenancepagetitlesetting'] = 'Título de página de información de mantenimiento';
$string['manageuserstitle'] = 'Usuarios';
$string['marketingurltarget'] = 'Destino del enlace';
$string['marketingurltargetdesc'] = 'Elija como debería de abrirse el enlace';
$string['marketingurltargetnew'] = 'Página Nueva';
$string['marketingurltargetparent'] = 'Marco Paterno';
$string['marketingurltargetself'] = 'Página Actual';
$string['mediumcontentmaxwidthsetting'] = 'Ancho máximo del contenido medio';
$string['mediumcontentmaxwidthsetting_desc'] = 'Con esta configuración, usted puede anular el ancho del contenido medio de Moodle sin modificaciones manuales por SCSS. Este ancho es usado en ciertas actividades como por ejemplo la actividad Base de Datos. De forma predeterminada, Moodle usa un ancho máximo medio del contenido de 1120px. Usted puede ingresar otros valores basados en pixeles como por ejemplo 1200px, pero usted también puede ingresar un valor basado en  porcentaje como por ejemplo 100%, o un valor del ancho del \'viewport\' (mirador) como 90vw.';
$string['misctab'] = 'Misceláneos';
$string['mobileappearanceheading'] = 'Apariencia Mobile';
$string['mobilecss'] = 'CSS adicional para App Mobile';
$string['mobiletab'] = 'App Mobile';
$string['myprogresspercentage'] = '%';
$string['navbarcolorsetting'] = 'Color de BarradeNavegación';
$string['navbarcolorsetting_dark'] = 'BarradeNavegación oscura con color de font claro';
$string['navbarcolorsetting_desc'] = 'Con esta configuración, usted puede cambiar el color de la BarradeNavegación del predeterminado de Barra clara, a una oscura o una coloreada.';
$string['navbarcolorsetting_light'] = 'BarradeNavegación clara con color de font oscuro (sin cambios, como es presentada por el núcleo de Moodle)';
$string['navbarcolorsetting_primarydark'] = 'BarradeNavegación color primario con font de color claro';
$string['navbarcolorsetting_primarylight'] = 'BarradeNavegación color primario con font de color oscuro';
$string['navbarheading'] = 'BarradeNavegación';
$string['navicon'] = 'Ícono';
$string['navicon1'] = 'Ícono Uno de Página Inicial';
$string['navicon2'] = 'Ícono Dos de Página Inicial';
$string['navicon3'] = 'Ícono Tres de Página Inicial';
$string['navicon4'] = 'Ícono Cuatro de Página Inicial';
$string['navicon5'] = 'Ícono Cinco de Página Inicial';
$string['navicon6'] = 'Ícono Seis de Página Inicial';
$string['navicon7'] = 'Ícono Siete de Página Inicial';
$string['navicon8'] = 'Ícono Ocho de Página Inicial';
$string['naviconbuttoncreatetextdefault'] = 'Crear un Curso';
$string['naviconbuttontext'] = 'Texto del Enlace';
$string['naviconbuttontextdesc'] = 'Texto a aparecer debajo del ícono';
$string['naviconbuttonurl'] = 'URL del enlace';
$string['naviconbuttonurldesc'] = 'URL adonde apuntará el botón. Usted puede enlazar a cualquier lugar incluyendo sitios web afuera de Moodle al simplemente escribir la URL apropiada. Si su sitio Moodle está dentro de un subdirectorio la URL predeterminada no funcionará- Por favor, ajuste la URL para que refleje el subdirectorio. Por ejemplo, si "moodle" fuera la carpeta de su subdirectorio entonces la URL necesitaría ser cambiada a  /moodle/my/';
$string['navicondesc'] = 'Nombre del ícono que desea usar. La lista está <a href="https://fontawesome.com/v4.7.0/icons/" target="_new">aquí</a>.  Solamente escriba lo que está después de "fa-", por ejemplo: "star".';
$string['naviconslidedesc'] = 'Texto de ícono sugerido: flecha-círculo-abajo (arrow-circle-down) . O elija de la lista que está <a href="https://fontawesome.com/v4.7.0/icons/" target="_new">aquí</a>.  Solo escriba lo que va después de "fa-", como por ejemplo "star".';
$string['navigationheading'] = 'Navegación';
$string['navigationtab'] = 'Navegación';
$string['nomycourses'] = 'Usted no está inscrito en ningún curso';
$string['openoffcanvas'] = 'Abrir cajón Afuera-del-lienzo';
$string['outsideregionsheading'] = 'Regiones de Afuera';
$string['outsideregionsheading_desc'] = 'Las regiones de Afuera pueden no solo ser habilitadas con las configuraciones de diseño de arriba; sus apariencias también pueden ser personalizadas.';
$string['outsideregionsplacement'] = 'Colocación horizontal de regiones de Afuera';
$string['outsideregionswidthcoursecontentwidth'] = 'Ancho del contenido del curso';
$string['outsideregionswidthfullwidth'] = 'Ancho completo';
$string['outsideregionswidthherowidth'] = 'Ancho de héroe';
$string['pagenavbuttonsbg'] = 'Botones de Cajón, Ayuda, Regresar a superior';
$string['pagenavbuttonsbg_desc'] = 'Cambiar el color de los botones del cajón lateral, botón de ayuda, y botón para regresar a superior.';
$string['pagetab'] = 'Página';
$string['pagewidthheading'] = 'Ancho de página';
$string['pluginname'] = 'LearnR';
$string['presetheading'] = 'Pre-configuraciones del tema';
$string['primarynavigationheading'] = 'Navegación primaria';
$string['privacy:metadata'] = 'El tema LearnR no almacena ningún dato personal acerca de ningún usuario.';
$string['progresstitle'] = 'Progreso';
$string['region-content-lower'] = 'Contenido (más abajo)';
$string['region-content-upper'] = 'Contenido (más arriba)';
$string['region-footer-center'] = 'Pie de página (centro)';
$string['region-footer-left'] = 'Pie de página (izquierda)';
$string['region-footer-right'] = 'Pie de página (derecha)';
$string['region-header'] = 'Encabezado';
$string['region-none'] = 'Ninguna';
$string['region-offcanvas-center'] = 'Afuera-del-lienzo (centro)';
$string['region-offcanvas-left'] = 'Afuera-del-lienzo (izquierda)';
$string['region-offcanvas-right'] = 'Afuera-del-lienzo (derecha)';
$string['region-outside-bottom'] = 'Afuera (abajo)';
$string['region-outside-left'] = 'Afuera (izquierda)';
$string['region-outside-right'] = 'Afuera (derecha)';
$string['region-outside-top'] = 'Afuera (superior)';
$string['resourcestab'] = 'Recursos';
$string['scssheading'] = 'SCSS crudo';
$string['scsstab'] = 'SCSS';
$string['sections-bars'] = 'Estilo de Barras de Sección Sólidas';
$string['sections-boost'] = 'Boost Predeterminado';
$string['sections-boxed'] = 'Estilo Cuadrado';
$string['sections-learnr'] = 'Estilo Predeterminado LearnR';
$string['sectionstyle'] = 'Selector de estilo de Sección del Curso';
$string['sectionstyle_desc'] = 'Elegir un estilo para secciones del curso';
$string['showadvertonpages'] = 'Selector de Página para Anuncios';
$string['showadvertonpages-course'] = 'Página Inicial del Curso';
$string['showadvertonpages-dash'] = 'Pagina del Tablero';
$string['showadvertonpages-home'] = 'Página Inicial';
$string['showadvertonpages-mycourses'] = 'Página de Mis Cursos';
$string['showadvertonpages_desc'] = 'Elegir en cuales páginas mostrar los Mosaicos de Anuncios';
$string['showcourseactivities'] = 'Mostrar Menú de Actividades del Curso';
$string['showcourseactivities_desc'] = 'Mostrar un ícono del Menú de Actividades del Curso en el encabezado.';
$string['showcourseindexnav'] = 'Mostrar Cajones de Página';
$string['showcourseindexnav_desc'] = 'Desactive esta casilla para ocultar los paneles del cajón de navegación. No recomendable, pero podría ser útil para instalaciones de Moodle de entrenamiento organizacional o corporativo. El quitar los cajones simplifica la interfase del usuario y podría ser deseable para entrenamiento simple.';
$string['showcoursemanagement'] = 'Mostrar Gestión del Curso';
$string['showcoursemanagement_desc'] = 'La Gestión del Curso es una colección de los enlaces más usados para profesores. Este es un panel deslizable que es alternado desde el encabezado del curso.';
$string['showeasyenrolbtn'] = 'Mostrar Botón de Inscripción Fácil';
$string['showeasyenrolbtn_desc'] = 'Mostrar un enlace rápido en el encabezado para el plugin Easy Enrollment. Esto le permite a los profesores el obtener rápidamente códigos de inscripción fáciles en un curso.';
$string['showhintcourseguestaccessgeneral'] = 'Usted actualmente está viendo este curso como <strong>{$a->role}</strong>.';
$string['showhintcourseguestaccesssetting_desc'] = 'Con esta configuración aparecerá una pista en el encabezado del curso cuando un usuario está accediéndolo con la característica de acceso de invitado. Si el curso proporciona una auto inscripción activa, un enlace a esa página es también presentado al usuario.';
$string['showhintcoursehiddensetting'] = 'Mostrar pista en cursos ocultos';
$string['showhintcoursehiddensetting_desc'] = 'Con esta configuración aparecerá una pista en el encabezado del curso mientras la visibilidad del curso esté oculta. Esto ayuda a identificar el estado de visibilidad de un curso de un vistazo sin la necesidad de buscar dentro de las configuraciones del curso.';
$string['showhintcourseselfenrolsetting'] = 'Mostrar pista para auto inscripción sin clave de inscripción';
$string['showhintcourseselfenrolsetting_desc'] = 'Con esta configuración aparecerá una pista en el encabezado del curso si el curso es visible y actualmente es posible una inscripción sin clave de inscripción.';
$string['showhintcoursguestaccesssetting'] = 'Mostrar pista para acceso de invitados';
$string['showlatestcourses'] = 'Mostrar menú desplegable de Cursos Recientes';
$string['showlatestcourses_desc'] = 'Esto mostrará los últimos 7 cursos que un usuario ha visitado en un menú desplegable a la derecha del título del curso. En este momento, no es parte de la Navegación principal, sino más bien es un elemento de navegación en páginas del curso.';
$string['showprogressbar'] = 'Mostrar Barra de Progreso del Curso';
$string['showprogressbar_desc'] = 'Mostrar una Barra de Progreso para estudiantes en la parte superior de cada página principal de curso.';
$string['showswitchedroleincoursesetting'] = 'Mostrar pista para rol cambiado';
$string['showswitchedroleincoursesetting_desc'] = 'Con esta configuración aparecerá una pista en el encabezado del curso si el usuario ha cambiado el rol en el curso. De forma predeterminada, esta información solamente es mostrada junto al avatar del usuario en el menú del usuario. Al habilitar esta opción, usted puede mostrar esta información - junto con un enlace para regresar al rol - dentro de la página del curso además.';
$string['sliderinfo'] = 'Botón de Ícono de Diapositiva Especial';
$string['sliderinfodesc'] = 'Este botón mostrará/ocultará una caja de texto especial que desliza hacia abajo desde la barra de navegación por íconos. esto es ideal para cursos destacados.';
$string['slidetextbox'] = 'Caja de texto de Diapositiva';
$string['slidetextbox_desc'] = 'Este contenido de caja de texto será mostrado cuando se presione el Botón de Diapositiva.';
$string['staticpagestab'] = 'Páginas estáticas';
$string['switchedroleto'] = 'Usted está viendo este curso actualmente con el rol de: <strong>{$a->role}</strong>';
$string['tilebackgroundimagepositionsetting'] = 'Posición de imagen de fondo de mosaico de Anuncio {$a->no}';
$string['tilebackgroundimagesetting'] = 'Imagen de fondo de mosaico de Anuncio {$a->no}';
$string['tilecolumnssetting'] = 'Número de columnas de mosaicos de anuncios por fila';
$string['tilecontentsetting'] = 'Contenido del  mosaico de Anuncio {$a->no}';
$string['tilecontentsetting_desc'] = 'Aquí usted ingresa el contenido que será mostrado en el mosaico del anuncio {$a->no}. El contenido es mostrado a la mitad del mosaico. Esta es una configuración opcional; el mosaico del anuncio será mostrado aun y cuando usted no configure ningún contenido..';
$string['tileenabledsetting'] = 'Habilitar mosaico de Anuncio {$a->no}';
$string['tileenabledsetting_desc'] = 'Con esta configuración usted puede habilitar el Mosaico de Anuncio {$a->no}.';
$string['tilefrontpagepositionsetting'] = 'Posición de los mosaicos de anuncios en la página inicial del sitio';
$string['tilefrontpagepositionsetting_after'] = 'Después del contenido de la página inicial del sitio';
$string['tilefrontpagepositionsetting_before'] = 'Antes del contenido de la página inicial del sitio';
$string['tilefrontpagepositionsetting_desc'] = 'Los mosaicos de anuncios solamente son mostrados en la página inicial del sitio. Con esta configuración, usted controla si los mosaicos de anuncios son mostrados ANTES del contenido de la página inicial o DESPUÉS del contenido de la página inicial. Si usted quiere mostrar solamente los mosaicos de anuncios en la página inicial y en ningún otro lado más, todos los otros contenidos de la página inicial pueden ser quitados al cambiar las <a href="{$a->url}">configuraciones de la página inicial del sitio</a>.';
$string['tileheading'] = 'Mosaico de Anuncio {$a->no}';
$string['tileheightsetting'] = 'Altura de mosaicos de anuncio';
$string['tilelinksetting'] = 'URL de enlace de Mosaico de Anuncio {$a->no}';
$string['tilelinktargetsetting'] = 'Destino del enlace de Mosaico de Anuncio {$a->no}';
$string['tilelinktargetsetting_desc'] = 'Aquí puede usted configurar el destino del enlace que es configurado para el botón del enlace tan pronto como usted configure una URL del enlace en el mosaico de anuncio {$a->no}.';
$string['tilelinktargetsetting_newtab'] = 'Pestaña nueva';
$string['tilelinktargetsetting_samewindow'] = 'Misma ventana';
$string['tilelinktitlefallback'] = 'Enlace';
$string['tilelinktitlesetting'] = 'Título del enlace de mosaico de Anuncio {$a->no}';
$string['tileordersetting'] = 'Posición de ordenamiento de mosaico de Anuncio {$a->no}';
$string['tilesgeneralheading'] = 'Mosaicos de anuncio general';
$string['tilestab'] = 'Mosaicos de Anuncios';
$string['tiletitlesetting'] = 'Título de Mosaico de Anuncio  {$a->no}';
$string['tiletitlesetting_desc'] = 'Aquí usted ingresa el título que será mostrado en el título del anuncio {$a->no}. Esta es una configuración opcional; el mosaico del anuncio será mostrado aun y cuando usted no configure ningún título.';
$string['trimsummary'] = 'Acortar Resumen del Curso';
$string['trimsummary_desc'] = 'Escriba un número para recortar la longitud del resumen. El número representa caracteres que serán mostrados.';
$string['trimtitle'] = 'Acortar Título del Curso';
$string['trimtitle_desc'] = 'Escriba un número para recortar la longitud del título. El número representa caracteres que serán mostrados.';
$string['upgradenotice_2022080922_logo'] = 'logo';
$string['upgradenotice_2022080922_logocompact'] = 'logo compacto';
$string['userreportgradebook'] = 'Reporte del Usuario';
$string['viewallcourses'] = 'Ver Todos los Cursos';
