<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_enlightlite', language 'es_mx', version '4.1'.
 *
 * @package     theme_enlightlite
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['about'] = 'Acerca de';
$string['aboutus'] = '<b>Acerca de</b> Nosotros';
$string['aboutusdesc'] = 'Cada uno de nuestros cursos lo conducirá a una carrera específica. Las compañías no quieren simplemente un graduado de la Universidad; quieren empleados con conjuntos específicos de habilidades. Por una explosión de redes sociales; nuevos dispositivos, como tabletas y teléfonos inteligentes, y aumento en el uso del Internet, las compañías están aumentando sus empleados de Tecnologías de la Información (TI). Además, muchos nuevos negocios están buscando más programadores y diseñadores. La seguridad de datos preocupa cada vez más. El campo de las TI cubre un rango amplio que incluye gestión de bases de datos, desarrollo web, análisis de sistemas, seguridad informática, y más. El crecimiento de empleos está estimado en 53% para 2018, de acuerdo al departamento del Trabajo de los EEUUAA. Los salarios en muchos trabajos de TI se espera que crezcan en 4 a 6 por ciento.';
$string['aboutustxt'] = 'Acerca de Nosotros';
$string['acourse_displaytype'] = 'Estilo de visualización de cursos disponible';
$string['acourse_displaytypedesc'] = 'Seleccionar un estilo de visualización para listado de cursos disponibles.';
$string['activateblock'] = 'Activar este bloque';
$string['address'] = 'Dirección';
$string['address_desc'] = 'Usted puede ingresar su dirección.';
$string['autoslideshow'] = 'Auto reproducir';
$string['autoslideshowdesc'] = 'Usar esta opción para deslizar imágenes automáticamente después de cargar la página.';
$string['availablecoursebg_type'] = 'Opciones de color del fondo para bloque de cursos disponibles';
$string['availablecoursebg_typedesc'] = 'Elegir una opción de color del fondo que a Usted le gustaría tener para el bloque de cursos disponibles.';
$string['availablecoursesbg'] = 'Imagen del fondo para bloque de cursos disponibles';
$string['availablecoursesbg_desc'] = 'Subir una imagen para el fondo del bloque de cursos disponibles.<br>El ancho de imagen recomendado es = 1350 pixeles y el alto = 450px';
$string['backToTop_status'] = 'Añadir botón para regresar a superior';
$string['backToTop_statusdesc'] = 'Esta opción controla si es que Usted habilita o no un botón de \'Regresar a superior\' en sus páginas.';
$string['bgcolor'] = 'Color del Fondo';
$string['bgnone'] = 'Fondo Blanco';
$string['blindCurtainBottomLeft'] = 'PersianaFondoIzquierda';
$string['blindCurtainBottomRight'] = 'PersianaFondoDerecha';
$string['blindCurtainSliceBottom'] = 'PersianaRebanadaFondo';
$string['blindCurtainSliceTop'] = 'PersianarebanadaSuperior';
$string['blindCurtainTopLeft'] = 'PersianaSuperiorIzquierda';
$string['blindCurtainTopRight'] = 'PersianaSuperiorDerecha';
$string['blog'] = 'Blog';
$string['blue'] = 'Azul';
$string['bottomCenter'] = 'FondoCentro';
$string['bottomLeft'] = 'FondoIzquierda';
$string['bottomLeftTopRight'] = 'FondoIzquierdaSuperiorDerecha';
$string['bottomRight'] = 'FondoDerecha';
$string['bottomRightTopLeft'] = 'FondoDerechaSuperiorIzquierda';
$string['bounceIn'] = 'RebotarEn';
$string['bounceInDown'] = 'RebotarEnAbajo';
$string['bounceInLeft'] = 'RebotarEnIzquierda';
$string['bounceInRight'] = 'RebotarEnDerecha';
$string['bounceInUp'] = 'RebotarEnArriba';
$string['button'] = 'Botón';
$string['buttonAnimate'] = 'Animación de Botón de Letrerito de Imagen';
$string['buttonAnimatedesc'] = 'botonAnimardesc';
$string['cat-placeholder'] = 'Escriba aquí el nombre del curso...';
$string['categories'] = 'Categorías';
$string['categories_displaytype'] = 'Estilo de visualización de categorías de curso';
$string['categories_displaytypedesc'] = 'Seleccionar un estilo de visualización para listado de categorías de curso.';
$string['categoriesbg_desc'] = 'Subir una imagen para fondo del bloque de categorías de curso.<br>El ancho de imagen recomendado = 1350 pixeles y la altura =450 pixeles';
$string['categoriesbg_type'] = 'Opciones de color del fondo para bloque de categorías de curso';
$string['categoriesbg_typedesc'] = 'elegir una opción de fondo que le gustaría tener para bloque de categorías de curso.';
$string['categoriescoursesbg'] = 'Imagen del fondo para bloque de categorías de curso';
$string['categoryimgcategory'] = 'La imagen para la categoría: {$a->category}.';
$string['categoryimgdesc'] = 'Esta sección le permite configurar imágenes para cada categoría de curso de nivel superior. El ancho recomendado de imagen es =360 pixeles y la altura = 360 pixeles';
$string['categoryimgheading'] = 'Imágenes de categoría';
$string['categoryimgheadingsub'] = 'USE IMÁGENES PARA REPRESENTAR CATEGORÍAS DE CURSO DE SU NIVEL SUPERIOR';
$string['center'] = 'Centro';
$string['centerLeft'] = 'CentroIzquierda';
$string['centerRight'] = 'CentroDerecha';
$string['choosereadme'] = '<div class="clearfix"><div class="theme_screenshot"><img class=img-polaroid src="enlightlite/pix/screenshot.jpg" /><h3>Créditos del Tema</h3><p><h3>Tema Moodle Enlightlite</h3><p>Este tema está basado en el tema  Bootstrapbase de Moodle..</p><p><a href="http://getbootstrap.com">http://getbootstrap.com</a></p><p>Autores: LMSACE Dev Team<br>Contacto: info@lmsace.com<br>Website: <a target="_blank" href="http://www.lmsace.com">www.lmsace.com</a><br></p>';
$string['cmenuPosition'] = 'Posición de mega menú cursos';
$string['cmenuPosition_desc'] = 'Use esta configuración para configurar la posición del mega menú de cursos en menúes primarios.';
$string['cmenushow'] = 'Habilitar mega menú de cursos';
$string['cmenushowdesc'] = 'Use esta configuración para mostrar u ocultar la aparición de "Mega Menú de Cursos" en menúes primarios.';
$string['collapse'] = 'Colapsado';
$string['comboListboxType'] = 'Estilo de visualización de lista combo';
$string['comboListboxType_desc'] = 'Seleccionar un estilo de visualización para bloque de lista combo.';
$string['community'] = 'Comunidad';
$string['configtitle'] = 'Enlightlite';
$string['contactus'] = 'Contáctenos';
$string['contentAnimate'] = 'Animación del contenido (Imagen #{$a->slide})';
$string['contentAnimatedesc'] = 'Use esta opción para configurar un tipo de animación para contenido de imagen (por ejemplo, Título de imagen, descripción y botón)';
$string['contentOverlay'] = 'Capa sobrepuesta de Contenido';
$string['copyright'] = 'Copyright del contenido';
$string['copyrightdefault'] = 'Copyright © 2017 - Desarrollado por <a href="http://lmsace.com">LMSACE.com</a>. Impulsado por <a href="https://moodle.org">Moodle</a>';
$string['copyrightdesc'] = 'Ingresar la información del copyright como texto simple o
lang:código_de_idioma para soporte multi-idioma (Ejemplo <b>lang:information</b>).
<br/>Usted puede encontrar los códigos_de_idioma por defecto aquí : : /theme/enlightlite/lang[FOLDER].';
$string['copyrightheading'] = 'Cambiar información del copyright';
$string['courseexp'] = 'Experiencia del curso';
$string['courselayout'] = 'Diseño de categoría del curso';
$string['courselayoutdesc'] = 'Para cambiar el formato de visualización de la página del listado de categoría de curso, elija uno de los listados personalizados aquí enlistados; esto anulará el diseño de course/index.php (por ejemplo coursecategory). Ahora el archivo de diseño personalizado será usado en lugar del diseño predeterminado de Moodle.';
$string['courses'] = 'Cursos';
$string['curtainBottomLeft'] = 'CortinaInferiorIzquierda';
$string['curtainBottomRight'] = 'CortinaInferiorDrecha';
$string['curtainSliceLeft'] = 'CortinaRebanadaIzquierda';
$string['curtainSliceRight'] = 'cortinaRebanadaDerecha';
$string['curtainTopLeft'] = 'CortinaSuperiorIzquierda';
$string['curtainTopRight'] = 'CotinaSuperiorDerecha';
$string['custom'] = 'Personalizado';
$string['custom_layout'] = 'Disño personalizado';
$string['customcss'] = 'CSS Personalizado';
$string['customcssdesc'] = 'Usar este campo para proporcionar código SCCSS o CSS que será inyectado al final de la hoja de estilo.';
$string['default'] = 'Valor por defecto';
$string['default_layout'] = 'Diseño por defecto de Moodle';
$string['default_type'] = 'Por defecto de Moodle';
$string['defaultaddress'] = '20-A , Nehru Street , Sathyamoorthi Nagar Madurai - 625010 , Tamilnadu , India.';
$string['defaultemailid'] = 'su_id_correo@ejemplo.com';
$string['defaultphoneno'] = '+123456789';
$string['describtionAnimate'] = 'Animación de Descripción de Letrerito de Imagen';
$string['describtionAnimatedesc'] = 'Descripción de letrerito de imagen';
$string['disable'] = 'Deshabilitar';
$string['dotThumb'] = 'Puntos y Miniaturas';
$string['dots'] = 'Puntos';
$string['doubleHeading'] = 'Doble título';
$string['double_heading_content'] = 'Contenido_doble_encabezado';
$string['email_desc'] = 'Usted puede ingresar su Email';
$string['emailid'] = 'E-mail';
$string['enable'] = 'Habilitar';
$string['enlightlite_settings'] = 'CONFIGURACIONES DE TEMA ENLIGHTLITE';
$string['enlightlite_type'] = 'Estilo personalizado de tema Enlightlite';
$string['enrolledcoursebg_type'] = 'Opciones de color del fondo para bloque de cursos inscritos';
$string['enrolledcoursebg_typedesc'] = 'Elegir una opción de fondo que le gustaría tener para bloque de cursos inscritos.';
$string['enrolledcoursesbg'] = 'Imagen del fondo para bloque de cursos inscritos';
$string['enrolledcoursesbg_desc'] = 'Subir una imagen para fondo de bloque de categorías de curso.<br>El ancho recomendado de imagen es = 1350 pixeles y la altura = 450 pixeles';
$string['expand'] = 'Expandido';
$string['fadeIn'] = 'Aparecer';
$string['fadeInDown'] = 'AparecerAbajo';
$string['fadeInDownBig'] = 'AparecerAbajoGrande';
$string['fadeInLeft'] = 'AparecerIzquierda';
$string['fadeInLeftBig'] = 'AparecerIzquierdaGrande';
$string['fadeInRight'] = 'AparecerDerecha';
$string['fadeInRightBig'] = 'AparecerDerechaGrande';
$string['fadeInUp'] = 'AparecerArriba';
$string['fadeInUpBig'] = 'AparecerArribaGrande';
$string['fadeOut'] = 'Desaparecer';
$string['featuredcoursesheading'] = 'Cursos Destacados';
$string['feedbackprogram'] = 'Retroalimentación Programa';
$string['flash'] = 'Flash';
$string['flip'] = 'Voltear';
$string['flipInX'] = 'VoltearEnX';
$string['flipInY'] = 'VoltearEnY';
$string['flipOutX'] = 'VoltearFueraX';
$string['flipOutY'] = 'VoltearFueraY';
$string['followuson'] = 'Síganos en';
$string['footbgimg'] = 'Imagen del fondo para sección del pie de página';
$string['footbgimg_desc'] = 'Suba una imagen para el fondo de la sección del pie de página. El ancho de imagen recomendado =1350 pixeles y altura = 350 pixeles';
$string['footbgimg_type'] = 'Opciones de color del fondo para sección del pie de página';
$string['footbgimg_type_desc'] = 'Elegir una opción de fondo que le gustaría tener para sección de pie de página.';
$string['footerb1_status'] = 'Opción de Visualización Pie de Página Bloque 1';
$string['footerb1_statusdesc'] = 'Si Usted desea deshabilitar este bloque en la sección del pie de página, desactive la casilla <i>Activar este bloque</i>.';
$string['footerb2_status'] = 'Opción de Visualización Pie de Página Bloque 2';
$string['footerb2_statusdesc'] = '';
$string['footerb3_status'] = 'Opción de Visualización Pie de Página Bloque 3';
$string['footerb3_statusdesc'] = '';
$string['footerb4_status'] = 'Opción de Visualización Pie de Página Bloque 4';
$string['footerb4_statusdesc'] = '';
$string['footerblink'] = 'Enlace a Bloque de Pie de página';
$string['footerblink1default'] = '<div><p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut et lobortis diam.&nbsp;</p><p>Duis tellus enim, vestibulum eget varius id, vulputate et mi. Nullam feugiat, diam quis interdum varius</p></div><a href="#"><span style="color: #fff; font-weight: bold; border-bottom: 1px solid #fff">Empiece a Aprender Ahora</span></a>';
$string['footerblink2default'] = 'Estudiantes futuros|http://www.ejemplo.com/
Estudiantes internacionales |http://www.ejemplo.com/
Investigadores|http://www.ejemplo.com/';
$string['footerblink3default'] = 'Accesibilidad|http://www.ejemplo.com/
Contáctenos|http://www.ejemplo.com/
Empleos|http://www.ejemplo.com/';
$string['footerblink_desc'] = 'Usted puede configurar aquí los enlaces del Bloque del Pie de página {$a->blockno} a ser mostrados por el tema.
Cada línea consiste de un poco de texto de menú (lang:language_key o texto simple) , una  URL de un enlace separada por carcteres de barra vertical. Por ejemplo:
<pre> lang:moodlecommunity|https://moodle.org
Soporte Moodle|https://moodle.org/support </pre>';
$string['footerblock'] = 'Bloque de Pie de página';
$string['footerbtitle1default'] = 'Acerca de Nosotros';
$string['footerbtitle2default'] = 'INFORMACIÓN PARA';
$string['footerbtitle3default'] = 'ENLACES RÁPIDOS';
$string['footerbtitle4default'] = 'CONTÁCTENOS';
$string['footerbtitledesc'] = 'Ingresar un título para este bloque como texto simple o lang:clave_de_idioma para soporte multi-idioma. Usted puede encontrar las claves_de_idioma aquí: /theme/enlightlite/lang/en/theme_enlightlite.php';
$string['footerdescription'] = 'Una breve descripción en el contexto del título del bloque, para soporte multi-idioma ingrese lang:clave_de_idioma.';
$string['footerdescription_desc'] = 'Una breve descripción en el contexto del título del bloque; para soporte multi-idioma ingresar lang:clave_de_idioma.';
$string['footerheading'] = 'Bloques de pie de página';
$string['footnote'] = 'Nota al pie';
$string['footphone_desc'] = 'Usted puede ingresar su número de teléfono.';
$string['for_content'] = 'solamente para contenido de imagen';
$string['for_slide'] = 'para imagen completa';
$string['frontpageheading'] = 'Bloques Publicitarios';
$string['generallogo_menu'] = 'ESQUEMAS DE COLOR, ESTILOS DE ENCABEZADO, LOGOS Y MENÚES';
$string['green'] = 'Verde';
$string['header'] = 'Estilo {$a->no}';
$string['headerStyle'] = 'Estilo del Encabezado';
$string['headerStyle_desc'] = 'Use esta opción para configurar un estilo del encabezado para su sitio.';
$string['helpfaq'] = 'Ayuda y FAQ';
$string['hinge'] = 'Girar';
$string['id_base'] = 'Cursos personalizados';
$string['image'] = 'Imagen';
$string['imagecolor'] = 'Color del tema + Imagen del fondo';
$string['imagecolor_parellax'] = 'Imagen con paralaje de capa sobrepuesta';
$string['imageparelex'] = 'Paralaje de imagen';
$string['importDemo'] = 'Importar contenido demo';
$string['importDemo_desc'] = 'Por favor active la casilla superior para importar los datos demostrativos que harán que su instalación luzca como nuestro sitio <a href=\'http://www.lmsace.com/lab/m32/\'>demo</a> .<br> <b>¡ADVERTENCIA!</b> No instale los datos de muestra en su sitio web existente, a menos que sea una instalación fresca nuevecita vacía. <br> Es posible que sus datos actuales sean corrompidos. Nosotros recomendamos encarecidamente instalar los datos de muestra en una instalación fresca vacía nuevecita de Moodle.';
$string['information'] = 'Información';
$string['informationdesc'] = '<div><p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut et lobortis diam.&nbsp;</p><p>Duis tellus enim, vestibulum eget varius id, vulputate et mi. Nullam feugiat, diam quis interdum varius</p></div><a href="#" style="color: #353535;">Empiece a Aprender Ahora</a>';
$string['jobs'] = 'Empleos';
$string['knowmore'] = 'Saber Más';
$string['lavender'] = 'Lavanda';
$string['layout'] = 'Diseño';
$string['learnanytime'] = 'Aprenda en cualquier momento, en cualquier lugar';
$string['learnanytimedesc'] = 'Disfrute de nuestros cursos en-línea gratuitos, dondequiera que esté y cuando Usted quiera. Acceda al contenido del curso en dispositivo móvil, tableta o PC de escritorio.';
$string['learntitle'] = 'APRENDA EN CUALQUIER INSTANTE, EN CUALQUIER LUGAR';
$string['left'] = 'Izquierda';
$string['legal'] = 'Legal';
$string['lightSpeedIn'] = 'ClaroVeloz';
$string['link'] = 'Enlace';
$string['links'] = 'Enlaces';
$string['loaderStatus'] = 'Mostrar barra de progreso';
$string['loaderStatus_desc'] = 'Use esta opción para ostrar / ocultar barra de eprogreso.';
$string['loadmore_type'] = 'Cargar más estilo';
$string['loginbg'] = 'Imagen del fondo para página para ingresar';
$string['loginbgdesc'] = 'Subir una imagen de fondo para la página de ingreso del usuario. El tamaño recomendado de imagen es ancho = 1350 pixeles y altura =650 pixeles';
$string['loginheader'] = 'Ingresar a su cuenta';
$string['loginpageType'] = 'Diseño de página para ingresar';
$string['loginpageType_desc'] = 'Use esta opción para anular el diseño de la página para ingresar.';
$string['logintheme'] = 'Estilo del tema Enlightlite';
$string['logo'] = 'Logo';
$string['logodesc'] = 'Suba un logo para su sitio web.<br> La imagen debe ser de 50 pixels de alto y de cualquier ancho razonable (minímo:235 pixeles) que quepa.';
$string['managebgimages'] = 'GESTIONAR COLORES E IMÁGENES DE FONDO';
$string['managefrontpage_items'] = 'GESTIONAR ÍTEMS DE PÁGINA DE PORTADA';
$string['marketingSpot1_status'] = 'Activar este bloque';
$string['marketingSpot1_statusdesc'] = 'Si Usted desea deshabilitar este bloque en la Portada, desactive la casilla <i>Activar este bloque</i>.';
$string['marketingSpot2_status'] = 'Activar este bloque';
$string['marketingSpot2_statusdesc'] = 'Si Usted desea deshabilitar este bloque en la Portada, desactive la casilla <i>Activar este bloque</i>.';
$string['marketingspot'] = 'Bloques Publicitarios';
$string['marketingspot1_content'] = '<div class="site-info"><div class="container"><div class="info-content"><div class="info-video"><video width="540px" controls><source src="" type="video/mp4"><source src="" type="video/ogg"></video></div><div class="info-block"><h2><b>Acerca det</b> Us</h2><p>Cada uno de nuestros cursos lo conduce hacia una carrera específica. Las compañías ya no quieren solamente un graduado de Universidad, quieren empleados con conjuntos de habilidades específicas. Una explosión de redes sociales, nuevos dispositivos como tabletas y teléfonos inteligentes, y un aumento en el uso de Internet, hacen que las compañías aumenten su personal de Tecnologías de la Información. Además, muchos nuevos negocios están buscando más programadores y diseñadores. La precupación por la seguridad de los datos sigue creciendo. El campo de las Tecnologías de la Información cubre un rango amplio que incluye bases de datos, desarrollo web, análisis de sistemas, seguridad de la información y más..</p><div class="read-more"><a href="#">Lea más</a></div></div><div class="clearfix"></div></div></div></div>';
$string['marketingspot1desc'] = 'Ingrese el contenido del Bloque Publicitario 1, ya sea en texto simple o con código_de_idioma. Por ejemplo: lang:mostrar o Mostrar';
$string['marketingspot2desc'] = 'Ingrese el contenido del Bloque Publicitario 2, ya sea en texto simple o con código_de_idioma. Por ejemplo: lang:mostrar o Mostrar';
$string['media'] = 'Medios';
$string['meetups'] = 'Meetups';
$string['miscellaneous'] = 'ÍTEMS MISCELÁNEEOS';
$string['mosaic'] = 'Mosaico';
$string['mosaicRandom'] = 'MosaicoAleatorio';
$string['mosaicReverse'] = 'MosaicoReverso';
$string['mosaicSpiral'] = 'MosaicoEspiral';
$string['mosaicSpiralReverse'] = 'MosaicoEspiralReverso';
$string['mspot1media'] = '<iframe src="https://www.youtube.com/embed/fNE7pyDyw3Y" allowfullscreen="" frameborder="0" height="391" width="545"></iframe>';
$string['mspot2urldesc'] = 'Use esta opción para configurar el enlace para botón.';
$string['mspot2urltarget_desc'] = 'Use esta opción para configurar el destino del enlace para botón.';
$string['mspot2urltxtdesc'] = 'Use esta opción para configurar el texto para el botón. Si no desea tener botón, configure esta opción a vacío. Ingrese el texto del  botón como texto simple o lang:language_key para soporte multi-idioma.
Usted puede encontrar las claves_de_idioma del tema aquí: /theme/theme/enlightlite/lang/en/theme_enlightlite.php';
$string['mspotdescdesc'] = 'Ingresar la descripción como texto simple o lang:clave_de_idioma para soporte multi-idioma.<br>
Usted puede encontrar las claves_de_idioma del tema aquí:  /theme/enlightlite/lang/en/theme_enlightlite.php.';
$string['mspotmediadesc'] = 'Insertar una imagen o contenido.';
$string['mspottitledesc'] = 'Ingresar  el título del bloque como texto simple o lang:clave_de_idioma para soporte multi-idioma.<br>
Usted puede encontrar las claves_de_idioma aquí: /theme/enlightlite/lang/en/theme_enlightlite.php.
<br/>Usted puede encontrar las claves_de_idioma por defecto aquí :  /theme/enlightlite/lang[CARPETA].';
$string['mycourse_displaytype'] = 'Estilo de visualización de Mis Cursos';
$string['mycourse_displaytypedesc'] = 'Seleccionar un estilo para listado de mis cursos.';
$string['name'] = 'Nombre';
$string['newWindow'] = 'Nueva Ventana';
$string['newcourses'] = 'Nuevos Cursos';
$string['newsmedia'] = 'Novedades y Medios';
$string['no_enrol'] = 'Número de usuarios inscritos';
$string['none'] = 'Ninguno';
$string['numberofslides'] = 'Número de imágenes';
$string['numberofslidesdesc'] = 'Use esta opción para seleccionar el número de imágenes primeramente y haga clic en el botón para Guardar Cambios al fondo de la página de configuraciones. Después la página se recargará y Usted tendrá opciones y campos_de_texto para el número deseado de imágenes.';
$string['numberoftmonials'] = 'Número de testimoniales';
$string['numberoftmonials_desc'] = 'Use esta opción para configurar primeramente el número de testimoniales y haga clic en el botón para Guardar Cambios al fondo de la página de configuraciones. La página se recargará después y Usted tiene opciones y campos_de_texto para el número deseado de testimoniales.';
$string['ourorg'] = 'Nuestra Organización';
$string['oursiteorg'] = 'Nuestro Sitio para Organizaciones';
$string['ourteamAutoplay'] = 'NuestroEquipo AutoReproducir';
$string['ourteamAutoplay_desc'] = '';
$string['ourteamTitle_desc'] = '';
$string['overlay'] = 'Color del tema';
$string['overlay_type'] = 'Capa Sobrepuesta (Imagen#{$a->slide})';
$string['overlaytype_desc'] = 'Use esta opción para configurar una capa sobrepuesta para toda la imagen o el contenido de la imagen (por ejemplo, descripción y botón) Con esto Usted garantizará la legibilidad del contenido textual de la imagen.';
$string['pagi_none'] = 'Sin paginación';
$string['pagination'] = 'Paginación';
$string['pagination_desc'] = 'Use esta opción para configurar estilos de paginación en el carrusel de imágenes.';
$string['patternselect'] = 'Elegir esquema de color de sitio web';
$string['patternselectdesc'] = 'Seleccionar el esquema de color que desea tener para su sitio.';
$string['phoneno'] = 'Número de teléfono';
$string['pluginname'] = 'Enlightlite';
$string['popularCourse_iddesc'] = 'Por favor ingrese las IDs de los cursos separadas por comas.';
$string['popularCourse_status'] = 'Mostrar cursos populares';
$string['popularCourse_statusdesc'] = 'Habilitar o deshabilitar el bloque de cursos populares en la Portada';
$string['popularCourse_typedesc'] = 'Por favor elija su criterio para generar cursos populares.<br> Si elige la opción de cursos personalizados, Usted debe mencionar las IDs de los cursos que desea tener en el bloque de cursos populares en la configuración inferior.';
$string['popularCourses_id'] = 'IDs de cursos populares';
$string['popularCourses_type'] = 'Generar cursos populares basados en';
$string['popularcoursebg_type'] = 'Opciones de color del fondo para bloque de cursos populares';
$string['popularcoursebg_typedesc'] = 'Elegir una opción de fondo que a Usted le gustaría tener para el bloque de cursos populares.';
$string['popularcourses'] = 'Cursos Populares';
$string['popularcoursesbg'] = 'Imagen del fondo para bloque de cursos populares';
$string['popularcoursesbg_desc'] = 'Suba una imagen para el fondo del bloque de cursos populares.<br> El tamaño recomendado es de ancho = 1350 pixeles y altura = 450 pixeles';
$string['preloader'] = 'Precargador de imagen';
$string['preloader_desc'] = 'Use esta opción para cambiar la imagen (GIF) de animación del pre-cargador';
$string['preloader_status'] = 'Habilitar precargador';
$string['preloader_statusdesc'] = 'Esta opción le permite a Usted mostrar / ocultar animación de precargador mientras se abren las páginas del sitio.';
$string['preloaderbg_color'] = 'Color del fondo de precargador';
$string['preloaderbg_colordesc'] = 'Use esta opción para cambiar el color del fondo de la página del pre-cargador.';
$string['primary_menu'] = 'Inicio|#';
$string['primarymenu'] = 'Ítems del menú primario';
$string['primarymenudesc'] = 'Usted puede configurar aquí un menú primario a ser mostrado por el tema. Cada línea consiste de un poco de texto del menú, una URL del enlace (opcional), un título de herramientita (opcional) y un código de idioma o una lista separada por comas de códigos de idiomas (opcional, para mostrar la línea solamente a usuarios del idioma especificado), separadas por el caracter de barra vertical. Las líneas que comiencen con un guión aparecerán como ítems del menú en el menú del nivel superior anterior, y pueden usarse divisores al añadir una línea de uno o más caracteres  # adonde se desee. <br>
Por ejemplo: <br> Comunidad Moodle |https://moodle.org <br>
-Soporte Moodle gratuito|https://moodle.org/support <br>
-Moodle Docs|http://docs.moodle.org|Moodle Docs <br>
-German Moodle Docs|http://docs.moodle.org/de|Documentación en idioma español|es <br>
-### <br>
-Desarrollo Moodle |https://moodle.org/development <br>
Moodle.com|http://moodle.com/ <br>';
$string['privacy:metadata'] = 'El tema Enlighten no almacena ningún dato personal acerca de ningún usuario.';
$string['purple'] = 'Morado';
$string['random'] = 'Aleatorio';
$string['readmore'] = 'Leer Más';
$string['red'] = 'Rojo';
$string['region-side-post'] = 'Derecha';
$string['region-side-pre'] = 'Izquierda';
$string['right'] = 'Derecha';
$string['rollIn'] = 'Rodar';
$string['rotateIn'] = 'RotarEn';
$string['rotateInDownLeft'] = 'RotarEnAbajoIzquierda';
$string['rotateInDownRight'] = 'RotarEnAbajoDerecha';
$string['rotateInUpLeft'] = 'RotarEnArribaIzquierda';
$string['rotateInUpRight'] = 'RotarEnArribaDerecha';
$string['sameWindow'] = 'Misma Ventana';
$string['scrollBottom'] = 'DeslizarFondo';
$string['scrollHorz'] = 'DeslizarHoriz';
$string['scrollLeft'] = 'DeslizarIzquierda';
$string['scrollRight'] = 'DeslizarDerecha';
$string['scrollTop'] = 'DeslizarSuperior';
$string['search'] = 'Buscar';
$string['search_courses'] = 'Buscar Sus Cursos';
$string['seeallcourses'] = 'Ver todos los cursos';
$string['seeprofile'] = 'VER PERFIL';
$string['siconbgc1default'] = '#47caf6';
$string['siconbgc2default'] = '#e84c3d';
$string['siconbgc3default'] = '#cd2129';
$string['siconbgc4default'] = '#3598dc';
$string['siconbgcdesc'] = 'Cambiar los colores en el color del fondo de Íconos de Medios Sociales';
$string['siconurl'] = 'URL de Ícono de Medios Sociales';
$string['siconurl1default'] = 'https://twitter.com/su_nombre_twitter';
$string['siconurl2default'] = 'https://www.google.com/+su_ID_de_GooglePlus';
$string['siconurl3default'] = 'https://in.pinterest.com/yoursu_nombre_pinterest/';
$string['siconurl4default'] = 'https://www.facebook.com/su_ID_de_Facebook';
$string['siconurldesc'] = 'La URL de Redes Sociales de su organización';
$string['signup'] = 'Apuntarse';
$string['simpleFade'] = 'SimpleDesvanecer';
$string['sitenewsType'] = 'Estilo de visualización de novedades del sitio';
$string['sitenewsType_desc'] = 'Seleccionar un estilo de visualización para el listado de  novedades del sitio.';
$string['slideCont_full'] = 'Ancho del  Contenido';
$string['slideCont_fulldesc'] = 'Use esta opción para configurar el ancho del contenido para la imagen. Este ancho será calculado como un porcentaje del ancho de la rejilla principal. El valor por defecto para esta opción es 50%.';
$string['slideContentStyle'] = 'Estilo del contenido';
$string['slideContentStyle_desc'] = 'Use esta opción para configurar el estilo del contenido en la imagen. <br>Si elige para estilo del contenido a "Título Doble" deberá de mencionar los dos títulos en la opción del título de la imagen.<br>
Los títulos deben estar separados con el caracter de la barra vertical (|) , Ejemplo : <i>Título1 | Título2</i>.';
$string['slideEffect'] = 'Animación de imagen';
$string['slideEffectdesc'] = 'Use esta opción para configurar un tipo de animación para transcisión de imagen.';
$string['slideImgpos'] = 'Punto focal de imagen';
$string['slideImgpos_desc'] = 'Use esta opción para configurar el punto focal de la imagen.';
$string['slideInDown'] = 'DeslizarAbajo';
$string['slideInLeft'] = 'DeslizarIzquierda';
$string['slideInRight'] = 'DeslizarDerecha';
$string['slideInUp'] = 'DeslizarArriba';
$string['slideOverlay'] = 'Opacidad de capa encimada';
$string['slideOverlay_desc'] = 'Use esta opción para configurar el nivel de opacidad; el valor por defecto para esta opción es 0.4';
$string['slideStatus'] = 'Estatus (Imagen #{$a->slide})';
$string['slideStatus_desc'] = 'Elegir "Deshabilitar" si Usted no desea mostrar esta imagen en el deslizador de la página inicial.';
$string['slidecaption'] = 'Título (Imagen #{$a->slide})';
$string['slidecaption1default'] = 'UN TEMA MOODLE RESPONSIVO ENFOCADO A EDUCACIÓN';
$string['slidecaption2default'] = 'El Mejor || TEMA MOODLE PARA LMS';
$string['slidecaption3default'] = 'DISEÑO TOTALMENTE RESPONSIVO';
$string['slidecaptiondefault'] = 'LA MEJOR SOLUCIÓN';
$string['slidecaptiondesc'] = 'Ingrese el título para su imagen como texto simple o lang:clave_del_idioma para soporte multi-idioma.
<br/>Usted puede encontrar las claves para idioma aquí : /theme/enlightlite/lang/en/theme_enlightlite.php';
$string['slidecontent'] = 'Posición del contenido (Imagen #{$a->slide})';
$string['slidecontentdesc'] = 'Use esta opción para configurar la ubicación del título de la imagen, descripción y fondo en la imagen.';
$string['slidedesc'] = 'Descripción (Imagen #{$a->slide})';
$string['slidedesc1default'] = 'LLeno de características para un deslumbrante sitio web de escuela o universidad';
$string['slidedesc2default'] = 'Fabricado para sistema de gestión dl aprendizaje';
$string['slidedesc3default'] = 'Se ve perfecto en todos los dispositivos móviles';
$string['slidedescdefault'] = 'Educación en tema Moodle único asombroso.';
$string['slidedesctext'] = 'Ingrese la descripción para su sitio como texto simple o lang:código_de_idioma para soporte ,multi-idioma.<br>
Usted puede encontrar los códigos_de_idioma aquí: /theme/enlightlite/lang/en/theme_enlightlite.php';
$string['slideheight'] = 'Altura del carrusel';
$string['slideheight_desc'] = 'Use esta opción para configurar la altura del carrusel';
$string['slideimage'] = 'Imagen (Imagen #{$a->slide})';
$string['slideimagedesc'] = 'Suba la imagen que le gustaría mostrar como la imagen de fondo de la imagen. El ancho recomendado de la imagen  = 1600 pixeles y la altura = 1080 pixeles.';
$string['slideinterval'] = 'Tiempo de Pausa';
$string['slideintervaldesc'] = 'Use esta opción para configurar la pausa o tiempo de espera entre cada cambio en el carrusel. El valor es en milisegundos (1 segundo = 10000 milisegundos)';
$string['slideno'] = 'Imagen #{$a->slide}';
$string['slidenodesc'] = 'Ingresar las configuraciones para imagen {$a->slide}.';
$string['sliderOverlay'] = 'Capa Sobrepuesta ImagenCompleta';
$string['slider_type'] = 'Carrusel';
$string['slideshowStatus'] = 'Mostrar deslizador de página inicial';
$string['slideshowStatus_desc'] = 'Elegir "No" si Usted no desea un deslizador de imagen en su página inicial.';
$string['slideshowdesc'] = 'El deslizador de la página inicial le permitirá promocionar elementos importantes de su sitio; Usted tiene que subir al menos una imagen para hacer que aparezca el carrusel. El título de la imagen, la descripción y el botón son opcionales. Use imágenes más grandes para mejores resultados; el deslizador achicará sus imágenes para que quepan en alto y ancho de su carrusel. Si Usted usa imágenes demasiado pequeñas, no funcionará correctamente.';
$string['slideshowheading'] = 'Deslizador de página inicial';
$string['slideshowheadingsub'] = 'OPCIONES DEL DESLIZADOR';
$string['slideurl1'] = 'URL de Botón 1';
$string['slideurl1desc'] = 'Use esta opción para configurar el enlace para el primer botón de la imagen.';
$string['slideurl1text'] = 'Texto de Botón 1';
$string['slideurl1textdesc'] = 'Use esta opción para configurar el texto para el primer botón de la imagen. Si Usted no desea tener botón en su imagen, configure esta opción a vacía.<br>
Ingrese el texto del botón como texto simple o lang:clave_de_idioma para soporte multi-idioma.<br>
Usted puede encontrar las claves_de_idioma aquí  /theme/enlightlite/lang/en/theme_enlightlite.php';
$string['slideurl2'] = 'URL de Botón 2';
$string['slideurl2desc'] = 'Use esta opción para configurar el enlace para el segundo botón de la imagen.';
$string['slideurl2text'] = 'Texto de Botón 2';
$string['slideurl2textdesc'] = 'Use esta opción para configurar el texto para el segundo botón de la imagen. Si Usted no desea tener botón en su imagen, configure esta opción a vacía.<br>
Ingrese el texto del botón como texto simple o lang:clave_de_idioma para soporte multi-idioma.<br>
Usted puede encontrar las claves_de_idioma aquí  /theme/enlightlite/lang/en/theme_enlightlite.php';
$string['socialicon'] = 'Ícono de Redes Sociales';
$string['socialicon1default'] = 'twitter';
$string['socialicon2default'] = 'google-plus';
$string['socialicon3default'] = 'pinterest-p';
$string['socialicon4default'] = 'facebook-f';
$string['socialicondesc'] = 'Escriba el nombre del ícono que desea usar. La lista está  <a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">aquí</a>. Solamente escriba lo que aparece después de "fa-".';
$string['socialmediadesc'] = '<strong>Este bloque contiene íconos de redes sociales</strong>';
$string['stampede'] = 'Estampida';
$string['style'] = 'Estilo';
$string['target'] = 'Destino';
$string['testiGeneral'] = 'Configuraciones generales de testimoniales';
$string['testimonial'] = 'Testimonial';
$string['testimonialAutoplay'] = 'Auto Reproducir';
$string['testimonialAutoplay_desc'] = '';
$string['testimonialno'] = 'Testimonial {$a->tmonial}';
$string['testimonialnodesc'] = 'Igresar las configuraciones para  testimonial {$a->tmonial}.';
$string['testimonialsbg'] = 'Imagen del fondo para bloque testimonial';
$string['testimonialsbg_desc'] = 'Subir una imagen para el fondo del bloque testimonial. El ancho recomendado de la imagen = 1350 pixeles y altura = 350 pixeles';
$string['testimonialsbg_type'] = 'Opciones de color del fondo para bloque testimonial';
$string['testimonialsbg_typedesc'] = 'Elegir una opción de fondo que le gustaría tener para bloque testimonial.';
$string['text'] = 'Texto';
$string['textFillContent'] = 'LLenarTextoContenido';
$string['text_item_content'] = 'Contenido_item_texto';
$string['themebased'] = 'Coloreado tema simple';
$string['themecolorsettings'] = 'Colores del Tema';
$string['themegeneralsettings'] = 'General';
$string['thumbnails'] = 'Miniaturas';
$string['title'] = 'Título';
$string['tmonialTraversal_status'] = 'Mostrar paginación';
$string['tmonialTraversal_statusdesc'] = '';
$string['tmonialheading'] = 'Testimoniales';
$string['tmonialheadingsub_desc'] = 'Esta sección le permite mostrar testimoniales de usuarios en la página de Portada.';
$string['tmonialimg'] = 'Imagen del Usuario';
$string['tmonialimgdesc'] = 'El ancho recomendado de imagen =1350 pixeles y alto = 450 pixeles';
$string['tmonialtext'] = 'Testimonial';
$string['tmonialtext_default'] = 'Estamos construyendo este curriculum con Enlightlite porque creemos que refleja lo que los desarrolladores de todas partes deberían de saber.';
$string['tmonialtextdesc'] = '';
$string['tmonialuname'] = 'Nombre del Usuario';
$string['tmonialuname_default'] = 'Peter Lubbers';
$string['tmonialunamedesc'] = '';
$string['toggletmonial'] = 'Visualización testimoniales';
$string['toggletmonialdesc'] = 'Si Usted desea deshabilitar este bloque en la Portada, desactive la casilla <i>Activar este bloque</i>.';
$string['topCenter'] = 'SuperiorCentro';
$string['topLeft'] = 'SuperiorIzquierda';
$string['topLeftBottomRight'] = 'SuperiorIzquierdaInferiorDerecha';
$string['topRight'] = 'SuperiorDerecha';
$string['typesearch'] = 'Escribir y presionar Buscar';
$string['typography'] = 'Tipografía';
$string['url'] = 'URL';
$string['urltarget1'] = 'Destino de Botón 1';
$string['urltarget2'] = 'Destino de Botón 2';
$string['urltarget_desc'] = 'Configurar esta opción a  <i>Nueva Ventana</i> si Usted desea abrir la URL en una nueva pestaña.';
$string['viewall'] = 'Ver todos';
$string['viewallcourses'] = 'Ver todos los cursos';
$string['whatweoffer'] = 'Lo que ofrecemos';
$string['zoom-In'] = 'Zoom-In';
$string['zoomInDown'] = 'ZoomInAbajo';
$string['zoomInLeft'] = 'ZoomInIzquierda';
$string['zoomInRight'] = 'ZoomInDerecha';
$string['zoomInUp'] = 'ZoomInArriba';
