<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'h5p', language 'sr_lt', version '4.1'.
 *
 * @package     h5p
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['a11yTitle:label'] = 'Oznaka za asistivne tehnologije (Assistive Technologies)';
$string['acceptTerms'] = 'Prihvatam <a href=":url" target="_blank">uslove korišćenja</a>';
$string['accountDetailsLinkText'] = 'ovde';
$string['actions'] = 'Akcije';
$string['add'] = 'Dodaj';
$string['addedandupdatedpp'] = 'Dodato {$a->%new} novih H5P biblioteka i ažurirano {$a->%old} starih.';
$string['addedandupdatedps'] = 'Dodato {$a->%new} novih H5P biblioteka i ažurirana {$a->%old} stara.';
$string['addedandupdatedsp'] = 'Dodata {$a->%new} nova H5P biblioteka i ažurirano {$a->%old} starih.';
$string['addedandupdatedss'] = 'Dodata {$a->%new} nova H5P biblioteka i ažuriranа {$a->%old} stara.';
$string['addednewlibraries'] = 'Dodato {$a->%new} novih H5P biblioteka.';
$string['addednewlibrary'] = 'Dodata {$a->%new} nova H5P biblioteka.';
$string['additionallicenseinfo'] = 'Bilo koja dodatna informacija o licenci';
$string['address'] = 'Adresa';
$string['age'] = 'Tipičan uzrast';
$string['ageDescription'] = 'Ciljna publika ovog sadržaja. Mogući formati unosa, odvojeni zarezima: "1,34-45,-50,59-".';
$string['altText'] = 'Alternativni (Alt ) tekst';
$string['atto_h5p'] = 'Umetni H5P dugme';
$string['atto_h5p_description'] = 'Dugme dodaj HP5 iz Atto editora omogućava korisnicima da dodaju H5P sadržaj bilo unosom URL-a ili koda za ugradnju, ili postavljanjem HP5 fajla.';
$string['author'] = 'Autor';
$string['authorcomments'] = 'Komentari autora';
$string['authorcommentsdescription'] = 'Komentari za urednika sadržaja. (Ovaj tekst neće biti objavljen kao deo informacija o autorskim pravima.)';
$string['authorname'] = 'Ime autora';
$string['authorrole'] = 'Uloga autora';
$string['back'] = 'Nazad';
$string['by'] = 'od';
$string['cancelPublishConfirmationDialogCancelButtonText'] = 'Ne';
$string['cancelPublishConfirmationDialogConfirmButtonText'] = 'Da';
$string['cancelPublishConfirmationDialogDescription'] = 'Da li ste sigurni da želite da otkažete proces deljenja?';
$string['cancelPublishConfirmationDialogTitle'] = 'Otkaži deljenje';
$string['cancellabel'] = 'Otkaži';
$string['ccattribution'] = 'Autorstvo (CC BY)';
$string['ccattributionnc'] = 'Autorstvo-Nekomercijalno (CC BY-NC)';
$string['ccattributionncnd'] = 'Autorstvo-Nekomercijalno-Bez prerada (CC BY-NC-ND)';
$string['ccattributionncsa'] = 'Autorstvo-Nekomercijalno-Deliti pod istim uslovima (CC BY-NC-SA)';
$string['ccattributionnd'] = 'Autorstvo-Bez prerada (CC BY-ND)';
$string['ccattributionsa'] = 'Autorstvo-Deliti pod istim uslovima (CC BY-SA)';
$string['ccpdd'] = 'Prenos u javni domen (CC0)';
$string['changeHasBeenSubmitted'] = 'Promena je predata';
$string['changedby'] = 'Promenio/la';
$string['changedescription'] = 'Opis promene';
$string['changelog'] = 'Dnevnik promena';
$string['changeplaceholder'] = 'Fotografija je isečena, tekst promenjen itd.';
$string['city'] = 'Grad';
$string['close'] = 'Zatvori';
$string['confirmdialogbody'] = 'Molim Vas potvrdite da želite da nastavite. Ova akcija se ne može poništiti.';
$string['confirmdialogheader'] = 'Potvrdi akciju';
$string['confirmlabel'] = 'Potvrdi';
$string['connectionLost'] = 'Veza je prekinuta. Rezultati će biti sačuvani i poslati kada se veza ponovo uspostavi.';
$string['connectionReestablished'] = 'Veza je ponovo uspostavljena.';
$string['contactPerson'] = 'Kontakt osoba';
$string['contactPersonDescription'] = 'H5P će kontaktirati osobu za kontakt u slučaju da postoje problemi sa sadržajem koji deli izdavač. Ime kontakt osobe ili druge informacije neće biti objavljene niti deljene sa trećim licima';
$string['contentAvailable'] = 'Vaš sadržaj će obično biti dostupan na čvorištu (H5P Content Hub) u roku od jednog radnog dana.';
$string['contentCopied'] = 'Sadržaj je kopiran u klipbord.';
$string['contentLicenseTitle'] = 'Informacije o licenci za sadržaj';
$string['contentUpdateSoon'] = 'Vaš sadržaj će uskoro biti ažuriran';
$string['contentchanged'] = 'Ovaj sadržaj se promenio od kada ste ga poslednji put koristili.';
$string['contentinuse'] = 'Ovaj sadržaj se možda koristi na drugim mestima.';
$string['contenttype'] = 'Tip sadržaja';
$string['copyright'] = 'Prava korišćenja';
$string['copyrightWarning'] = 'Materijal zaštićen autorskim pravima se ne može deliti na H5P Content Hubu. Ako je sadržaj licenciran pod licencom koja prilagođena OER-u kao što je Creative Commons, izaberite odgovarajuću licencu. Ako nije, ovaj sadržaj se ne može deliti.';
$string['copyrightinfo'] = 'Informacije o autorskim pravima';
$string['copyrightstring'] = 'Autorska prava';
$string['copyrighttitle'] = 'Pregledaj informacije o autorskim pravima za ovaj sadržaj.';
$string['couldNotParseJSONFromZip'] = 'Nije moguće parsirati JSON iz paketa: {$a->%fileName}';
$string['couldNotReadFileFromZip'] = 'Nije moguće pročitati fajl iz paketa: {$a->%fileName}';
$string['country'] = 'Zemlja';
$string['creativecommons'] = 'Creative Commons';
$string['currentStep'] = 'Korak :step od :total';
$string['date'] = 'Datum';
$string['deletelibraryconfirm'] = '<p>Da li ste sigurni da želite da izbrišete verziju <em>\'{$a->version}\'</em> iz biblioteke <em>\'{$a->name}\'</em>? Biće uklonjenja biblioteka i sve njene zavisnosti.</p><p>Ova operacija ne može biti poništena.</p>';
$string['deletelibraryversion'] = 'Izbriši verziju';
$string['deleting'] = 'Brisanje biblioteke';
$string['description'] = 'Opis';
$string['disablefullscreen'] = 'Onemogući prikaz preko celog ekrana';
$string['discipline:dropdownButton'] = 'Dugme za padajući meni';
$string['discipline:in'] = 'u';
$string['discipline:searchPlaceholder'] = 'Ukucajte da biste potražili discipline';
$string['disciplineDescription'] = 'Možete izabrati više disciplina';
$string['disciplineLabel'] = 'Discipline';
$string['disciplineLimitReachedMessage'] = 'Možete odabrati najviše :numDisciplines discipline/a';
$string['disciplines'] = 'Discipline';
$string['download'] = 'Preuzmi';
$string['downloadtitle'] = 'Preuzmi ovaj sadržaj kao H5P fajl.';
$string['editInfoTitle'] = 'Uredite informacije za <strong>:title</strong>';
$string['editcontent'] = 'Uredi H5P sadržaj';
$string['editingFailed'] = 'Uređivanje nije uspelo.';
$string['editor'] = 'Editor';
$string['emailAddress'] = 'Adresa e-pošte';
$string['emailAddressDescription'] = 'H5P će koristiti adresu e-pošte da stupi u kontakt sa izdavačem u slučaju bilo kakvih problema sa sadržajem ili u slučaju da izdavač treba da povrati svoj nalog. Adresa neće biti objavljena niti deljena sa trećim licima';
$string['embed'] = 'Ugradi';
$string['embedtitle'] = 'Pregled koda za ugradnju za ovaj sadržaj.';
$string['error:emptycontentid'] = 'Navedena URL adresa je netačna ili ne možete urediti ovu datoteku.';
$string['eventh5pdeleted'] = 'H5P je izbrisan';
$string['eventh5pviewed'] = 'H5P sadržaj je pregledan';
$string['feature'] = 'Mogućnost';
$string['fetchtypesfailure'] = 'Nije moguće dobiti informacije o dostupnim tipovima H5P sadržaja. Neuspešno povezivanje sa H5P repozitorijumom';
$string['fileExceedsMaxSize'] = 'Jedan od fajlova unutar paketa premašuje maksimalnu dozvoljenu veličinu.  ({$a->%file} {$a->%used} > {$a->%max})';
$string['filter_displayh5p'] = 'Prikaz H5P filtera';
$string['filter_displayh5p_description'] = 'H5P filter za prikaz konvertuje URL adrese u ugrađeni H5P sadržaj.';
$string['fullscreen'] = 'Prikaz preko celog ekrana';
$string['gpl'] = 'General Public License v3';
$string['h5p'] = 'H5P';
$string['h5peditor'] = 'H5P editor';
$string['h5pfilenotfound'] = 'H5P fajl nije nađen';
$string['h5pinvalidurl'] = 'Neispravan URL H5P sadržaja.';
$string['h5plibraryhandler'] = 'Procedura za obradu H5P okvira';
$string['h5plibraryhandler_help'] = 'H5P okvir koji se koristi za prikaz H5P sadržaja. Preporučuje se najnovija verzija.';
$string['h5pmanage'] = 'Upravljanje H5P tipovima sadržaja';
$string['h5poverview'] = 'H5P pregled';
$string['h5ppackage'] = 'H5P tip sadržaja';
$string['h5ppackage_help'] = 'H5P tip sadržaja je fajl sa H5P ili ZIP ekstenzijom koji sadrže sve biblioteke neophodne za prikaz sadržaja.';
$string['h5pprivatefile'] = 'Ovaj H5P sadržaj ne može biti prikazan jer nemate pristup .h5p fajlu.';
$string['h5psettings'] = 'H5P podešavanja';
$string['h5ptitle'] = 'Posetite h5p.org kako biste pronašli više sadržaja.';
$string['helpChoosingLicense'] = 'Pomozite mi da izaberem licencu';
$string['hideadvanced'] = 'Sakrij napredne mogućnosti';
$string['icon'] = 'ikonica';
$string['iconDescription'] = '640x480px. Ako nije izabrano sadržaj će koristiti ikonicu kategorije';
$string['installedcontentlibraries'] = 'Instalirane H5P biblioteke';
$string['installedcontenttypes'] = 'Instalirani H5P tipovi sadržaja';
$string['installedh5p'] = 'Instaliran H5P';
$string['invalidAge'] = 'Unet je neispravan format podatka za tipičan uzrast. Mogući formati podataka, odvojeni zarezima, su: "1, 34-45, -50, -59-".';
$string['invalidcontextid'] = 'H5P fajl nije nađen (neispravan contextid)';
$string['invalidfile'] = 'Fajl "{$a->%filename}" nije dozvoljen. Dozvoljeni su samo fajlovi sa sledećim ekstenzijama: {$a->%files-allowed}.';
$string['invalidlanguagefile'] = 'Neispravan jezički fajl {$a->%file} u biblioteci {$a->%library}';
$string['invalidlanguagefile2'] = 'Neispravan jezički fajl {$a->%languageFile} je uključen u biblioteku {$a->%name}';
$string['invalidlibrarydata'] = 'Neispravan podatak je unet za  {$a->%property} iz {$a->%library}';
$string['invalidlibrarydataboolean'] = 'Neispravan podatak je unet za  {$a->%property} u {$a->%library}. Očekivana je logička vrednost (tačno/netačno).';
$string['invalidlibraryname'] = 'Neispravan naziv biblioteke: {$a->%name}';
$string['invalidlibrarynamed'] = 'H5P biblioteka {$a->%library} koja se koristi u sadržaju nije ispravna';
$string['invalidlibraryoption'] = 'Nedozvoljena opcija {$a->%option} u {$a->%library}';
$string['invalidlibraryproperty'] = 'Svojstvo {$a->%property} u {$a->%library} ne može biti pročitano';
$string['invalidmainjson'] = 'Nedostaje ispravan glavni h5p.json fajl';
$string['invalidmultiselectoption'] = 'Izabrana je neispravna opcija u kontroli sa mogućnošću višestrukog izbora.';
$string['invalidpackage'] = 'Neispravan H5P tip sadržaja';
$string['invalidselectoption'] = 'Izabrana je neispravna opcija.';
$string['invalidsemanticsjson'] = 'Neispravna semantics.json datoteka je uključena u biblioteku {$a->%name}';
$string['invalidsemanticstype'] = 'H5P interna greška: nepoznat tip sadržaja "{$a->@type}" u semantici. Sadržaj se uklanja!';
$string['invalidstring'] = 'Dati string nije semantički validan prema regularnom izrazu. (vrednost: "{$a->%value}", regularni izraz: "{$a->%regexp}")';
$string['isNowSubmitted'] = 'H5P sadržaj je poslat na H5P Hub';
$string['keywordExists'] = 'Ključna reč već postoji!';
$string['keywords'] = 'Ključne reči';
$string['keywordsDescription'] = 'Možete dodati više ključnih reči odvojenih zarezima. Pritisnite "Enter" ili "Dodaj" da biste potvrdili ključne reči';
$string['keywordsExits'] = 'Ključne reči već postoje!';
$string['keywordsPlaceholder'] = 'Dodaj ključne reči';
$string['language'] = 'Jezik';
$string['level'] = 'Nivo';
$string['librariesmanagerdescription'] = '<p>H5P omogućava korisnicima da kreiraju interaktivni sadržaj pružajući čitav niz različitih tipova sadržaja.</p><p>Da biste bili sigurni da se na vašem veb sajtu koriste samo pouzdani H5P tipovi sadržaja, morate <i>ili</i></p><ul><li>da postavite H5P tipove sadržajasa h5p.org <i>ili</i></li><li>da omogućite planirani zadatak \'Preuzmite dostupne H5P tipove sadržaja sa h5p.org\'</li></ul><p>Imajte u vidu da će korisnici moći da koriste samo one H5P tipove sadržaja koji su instalirani na vašem veb sajtu.</p>';
$string['librarydirectoryerror'] = 'Naziv direktorija biblioteke mora da se poklapa sa machineName ili machineName-majorVersion.minorVersion (iz library.json). (Directory: {$a->%directoryName} , machineName: {$a->%machineName}, majorVersion: {$a->%majorVersion}, minorVersion: {$a->%minorVersion})';
$string['license'] = 'Licenca';
$string['licenseCC010'] = 'CC0 1.0 Univerzalna (CC0 1.0) Prenos u Javni domen';
$string['licenseCC010U'] = 'CC0 1.0 Univerzalna';
$string['licenseCC10'] = '1.0 Generic';
$string['licenseCC20'] = '2.0 Generic';
$string['licenseCC25'] = '2.5 Generic';
$string['licenseCC30'] = '3.0 Unported';
$string['licenseCC40'] = '4.0 Međunarodna';
$string['licenseDescription'] = 'Izaberite licencu za svoj sadržaj';
$string['licenseDetails'] = 'Detalji licence';
$string['licenseDialogDescription'] = 'Kliknite na na neku od licenci kako biste dobili informacije o pravilnom korišćenju';
$string['licenseGPL'] = 'General Public License';
$string['licenseV1'] = 'Verzija 1';
$string['licenseV2'] = 'Verzija 2';
$string['licenseV3'] = 'Verzija 3';
$string['licenseVersionDescription'] = 'Izaberite verziju licence';
$string['licensee'] = 'Vlasnik licence';
$string['licenseextras'] = 'Dodaci za licence';
$string['licenseversion'] = 'Verzija licence';
$string['lockh5pdeploy'] = 'Ovom H5P sadržaju nije moguće pristupiti jer je u primeni. Pokušajte ponovo kasnije.';
$string['logoUploadText'] = 'Logo ili avatar organizacije';
$string['longDescription'] = 'Duži opis';
$string['longDescriptionPlaceholder'] = 'Dugačak opis vašeg sadržaja';
$string['mainTitle'] = 'Deljenje <strong>:title</strong>';
$string['mainlibrarydisabled'] = 'Ova datoteka ne može biti prikazana jer je njen tip sadržaja onemogućen. Kontaktirajte svog administratora i zatražite da se odgovarajući tip sadržaja omogući.';
$string['maxLength'] = ':length je maksimalan broj znakova';
$string['missingcontentfolder'] = 'Nedostaje ispravan direktorijum sadržaja';
$string['missingcoreversion'] = 'Sistem nije mogao da instalira komponentu {$a->%component} iz paketa, jer ona zahteva noviju verziju H5P dodatka. Na ovom sajt trenutno se koristi verzija {$a->%current}, a neophodna je verzija {$a->%required} ili novija. Instalirajte potrebnu verziju H5P dodatka i pokušajte ponovo.';
$string['missingdependency'] = 'Nedostaje zavisnost {$a->@dep} koju zahteva {$a->@lib}.';
$string['missinglibrary'] = 'Nedostaje obavezna biblioteka {$a->@library}';
$string['missinglibraryfile'] = 'Datoteka "{$a->%file}" nedostaje u biblioteci: "{$a->%name}"';
$string['missinglibraryjson'] = 'Nije moguće pronaći datoteku library.json sa važećim json formatom za biblioteku {$a->%name}';
$string['missinglibraryproperty'] = 'Potrebno svojstvo {$a->%property} nedostaje u {$a->%library}';
$string['missingmbstring'] = 'PHP dodatak mbstring nije učitan. Neophodan je da bi H5P ispravno funkcionisao.';
$string['missinguploadpermissions'] = 'Imajte u vidu da biblioteke mogu postojati u datoteci koju ste postavili, ali nije vam dozvoljeno postavljanje novih biblioteka. Obratite se svom administratoru.';
$string['next'] = 'Sledeći';
$string['nocopyright'] = 'Informacije o autorskim pravima nisu dostupne za ovaj sadržaj.';
$string['noextension'] = 'Datoteka koju ste postavili nije ispravan HTML5 paket (datoteka nema ekstenziju .hp5).';
$string['noh5plibhandlerdefined'] = 'Nije instalirana nijedan procedura za obradu H5P okvira, tako da H5P sadržaj ne može biti prikazan.';
$string['nojson'] = 'Glavna h5p.json datoteka nije ispravna';
$string['nopermissiontodeploy'] = 'Ova datoteka ne može biti prikazana jer ju je postavio korisnik koji nema neophodnu sposobnost za objavljivanje H5P sadržaja.';
$string['nopermissiontoedit'] = 'Nemate ovlašćenja da uređujete H5P sadržaj.';
$string['notrustablefile'] = 'Ova datoteka se ne može prikazati jer ju je postavio korisnik bez sposobnosti  da ažurira H5P tipove sadržaja. Obratite se svom administratora i zatražite od njega da instalira tip sadržaja.';
$string['nounzip'] = 'Datoteka koju ste otpremili nije ispravan HTML5 paket (nije moguće raspakovati ga).';
$string['offlineDialogBody'] = 'Nismo mogli da pošaljemo informacije o vašem završetku ovog zadatka. Molimo, proverite svoju internet vezu';
$string['offlineDialogHeader'] = 'Vaša veza sa serverom je izgubljena';
$string['offlineDialogRetryButtonLabel'] = 'Pokušajte ponovo sada';
$string['offlineDialogRetryMessage'] = 'Ponovni pokušaj za :num....';
$string['offlineSuccessfulSubmit'] = 'Uspešno predati rezultati.';
$string['optionalInfo'] = 'Opcione informacije';
$string['originator'] = 'Kreator';
$string['pd'] = 'Javni domen';
$string['pddl'] = 'Prenos u javni domen i licenca';
$string['pdm'] = 'Public Domain Mark (PDM)';
$string['phone'] = 'Telefon';
$string['pleaseWait'] = 'Molimo. sačekajte...';
$string['pluginname'] = 'H5P paket';
$string['privacy:metadata'] = 'Podsistem H5P ne čuva nikakve lične podatke.';
$string['publisherDescription'] = 'Opis izdavača';
$string['publisherDescriptionText'] = 'Ovo će biti prikazano u odeljku "Informacije o izdavaču" na deljenom sadržaju';
$string['publisherFieldDescription'] = 'Ovo će biti prikazano kao "Ime izdavača" na deljenom sadržaju';
$string['publisherFieldTitle'] = 'Izdavač';
$string['registerOnHub'] = 'Registrujte se na H5P Hubu';
$string['registrationFailed'] = 'Došlo je do greške';
$string['registrationFailedDescription'] = 'Nismo bili u mogućnosti da otvorimo nalog u ovom trenutku. Nešto nije u redu. Pokušajte ponovo kasnije.';
$string['registrationTitle'] = 'H5P Hub Registracija';
$string['remove'] = 'Ukloni';
$string['removeChip'] = 'Ukloni :chip sa spiska';
$string['removeImage'] = 'Ukloni sliku';
$string['requiredInfo'] = 'Potrebne informacije';
$string['resizescript'] = 'Uključite ovaj skript na svoj veb sajt ako želite dinamičku promenu veličinu ugrađenog sadržaja:';
$string['resubmitScores'] = 'Pokušaj slanja sačuvanih rezultata.';
$string['reuse'] = 'Upotrebi ponovo';
$string['reuseContent'] = 'Upotrebi ponovo sadržaj';
$string['reuseDescription'] = 'Ponovo upotrebite ovaj sadržaj.';
$string['reviewAndSave'] = 'Pregledaj i sačuvaj';
$string['reviewAndShare'] = 'Pregledaj i podel';
$string['reviewInfo'] = 'Pregledaj informacije';
$string['reviewMessage'] = 'Molimo vas da pregledajte informacije u nastavku, pre nego što podelite svoj H5P sadržaj';
$string['saveChanges'] = 'Sačuvaj promene';
$string['screenshots'] = 'Snimci ekrana';
$string['screenshotsDescription'] = 'Dodajte do pet snimaka ekrana svog sadržaja';
$string['share'] = 'Podeli';
$string['shareFailed'] = 'Deljenje nije uspelo.';
$string['shareTryAgain'] = 'Nešto nije u redu, pokušajte ponovo da podelite.';
$string['shared'] = 'Podeljeno';
$string['sharingNote'] = 'Svi detalji sadržaja mogu se uređivati/menjati nakon deljenja';
$string['shortDescription'] = 'Kratak opis';
$string['shortDescriptionPlaceholder'] = 'Kratak opis vašeg sadržaja';
$string['showadvanced'] = 'Prikaži napredne';
$string['showless'] = 'Prikaži manje';
$string['showmore'] = 'Prikaži više';
$string['size'] = 'Veličina';
$string['someKeywordsExits'] = 'Neke od ovih ključnih reči već postoje';
$string['source'] = 'Izvor';
$string['startingover'] = 'Počećete ispočetka.';
$string['status'] = 'Status';
$string['subContentWarning'] = 'Elementi unutar sadržaja (slikie, pitanja itd,) će se deliti pod licencom :license. osim ako nije drugačije navedeno u alatu za kreiranje sadržaja';
$string['sublevel'] = 'Podnivo';
$string['submitted'] = 'Predato!';
$string['successfullyRegistred'] = 'Uspešno ste registrovali nalog na H5P Hubu';
$string['successfullyRegistredDescription'] = 'Detalji vašeg naloga se mogu promeniti';
$string['successfullyUpdated'] = 'Podešavanja vašeg H5P Hub naloga su uspešno promenjena';
$string['task_h5p'] = 'H5P planirani zadatak';
$string['task_h5p_description'] = 'Planirani zadatak H5P preuzima dostupne H5P tipove sadržaja sa h5p.org.';
$string['thumbnail'] = 'Sličica';
$string['title'] = 'Naslov';
$string['undisclosed'] = 'Neotkriveno';
$string['unpackedFilesExceedsMaxSize'] = 'Ukupna veličina raspakovanih datoteka premašuje maksimalnu dozvoljenu veličinu. ({$a->%used} > {$a->%max})';
$string['updateRegistrationOnHub'] = 'Sačuvajte podešavanja naloga';
$string['updatedlibraries'] = 'Ažurirano {$a->%old} H5P biblioteka.';
$string['updatedlibrary'] = 'Ažurirano {$a->%old} H5P biblioteke.';
$string['uploadlibraries'] = 'Postavi H5P tipove sadržaja';
$string['uploadsuccess'] = 'H5P tipovi sadržaja su uspešno postavljeni';
$string['wrongversion'] = 'Verzija H5P biblioteke {$a->%machineName} koja se koristi u ovom sadržaju nije ispravna. U sadražju se nalazi {$a->%contentLibrary}, a trebalo bi da bude {$a->%semanticsLibrary}.';
$string['year'] = 'Godina';
$string['years'] = 'Godina(e)';
$string['yearsfrom'] = 'Godine (od)';
$string['yearsto'] = 'Godine (do)';
$string['zip'] = 'Zip';
