<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'format_tiles', language 'sr_lt', version '4.1'.
 *
 * @package     format_tiles
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addsections'] = 'Dodaj pločicu';
$string['admintools'] = 'Administratorski alati';
$string['all'] = 'Sve';
$string['allcomplete'] = 'Sve je završeno';
$string['allcoursescomplypalette'] = 'Svi kursevi već imaju dozvoljene boje pločica. Nema ničega za resetovanje. Uverite se da ste sačuvali sve promene dozvoljenih boja pre nego što pritisnete dugme za resetovanje.';
$string['allowphototiles'] = 'Dozvoli foto pločice';
$string['allowphototiles_desc'] = 'Ako je izabrana ova opcija, predavači će moći da postave fotografiju koja će služiti kao pozadina pločice. Bez obzira na to, oni će i dalje moći da koriste standardne ikonice na istom kursu (ako pak nije izabrano, samo će ikonice biti dozvoljene, a ostala podešavanja koja se odnose na foto pločice biće zanemarena).';
$string['allowsubtilesview'] = 'Dozvoli prikaz podpločica';
$string['allowsubtilesview_desc'] = 'Dozvoli korišćenje podešavanja kursa koje, ako je izabrano, omogućava da se aktivnosti i resursi (osim natpisa) unutar pločice prikazuju  kao podpločice, umesto standardne liste';
$string['alternativelink'] = 'alternativni link';
$string['areyousure'] = 'Da li ste sigurni?';
$string['asfraction'] = 'Prikaži kao razlomak';
$string['aspectratiotootallorwide'] = 'Postavljena slika je sačuvana, ali molim vas proverite, jer bi mogla da bude <strong>{$a->tallorwide}</strong>. Ukoliko ne izgleda dobro isecite je na standardne dimenzije položene slike i postavite ponovo. Na primer, dimenzije slike 300 piskela širine x 200 piksela visina bi bile sasvim odgovarajuće.';
$string['aspercentagedial'] = 'Prikaži kao % u krugu';
$string['assumedatastoreconsent'] = 'Pretpostavite saglasnost korisnika da se podaci skladište u lokalnoj memoriji veb čitača';
$string['assumedatastoreconsent_desc'] = 'Ako je izabrana ova opcija, korisniku <b>neće</b> biti prikazan dijalog u kojem se traži saglasnost da se podaci čuvaju u lokalnoj memoriji veb čitača';
$string['backupfailed'] = 'Kreiranje rezervne kopije nije uspelo';
$string['basecolour'] = 'Boja za pločice';
$string['basecolour_help'] = 'Ovde podešena boja biće primenjena na sve pločice na kursu (dostupne boje određuje administrator sajta na stranici za podešavanje dodatka \'Pločice\').';
$string['brandcolour'] = 'Boja brenda';
$string['cachedef_modalcmids'] = 'ID oznake modula na kursu koji treba da se pokrenu pomoću modalnog prozora';
$string['canceltask'] = 'Otkaži zadatak';
$string['changedcolour'] = 'Boja pločica je resetovana na podrazumevanu za kurs {$a}';
$string['checkforproblemcourses'] = 'Proverite da li postoje eventualni problemi unutar kurseva i ispravite ih';
$string['clearphoto'] = 'Resetujte ovu pločicu';
$string['clickiffailstoload'] = 'Kliknite ako se stranica ne učita';
$string['close'] = 'Zatvori';
$string['closetopsection'] = 'Zatvorite sekciju na vrhu';
$string['collapse'] = 'Skupi sekciju';
$string['collapsesections'] = 'Skupi sve';
$string['colourblue'] = 'Plavo';
$string['colourdarkgreen'] = 'Tamno zeleno';
$string['colourgreen'] = 'Zeleno';
$string['colourlightblue'] = 'Svetlo plavo';
$string['colourname_descr'] = 'Prikazuje naziv za boju (korisnici obično ne vide ovaj naziv, već uzorak boje)';
$string['colournamegeneral'] = 'Prikaži naziv za boju iznad';
$string['colourpurple'] = 'Ljubičasto';
$string['colourred'] = 'Crveno';
$string['colours'] = 'Boje';
$string['complete'] = 'Završeno';
$string['complete-n-auto'] = 'Stavka nije završena. Biće označena kao završena tek kada ispunite sve kriterijume za završetak. Ovo ne možete promeniti ručno.';
$string['complete-y-auto'] = 'Stavka je završena. Označena je kao završena onog trenutka kada ste ispunili kriterijume za završetak. Ovo ne možete promeniti ručno.';
$string['completion_help'] = 'Kvačica sa desne strane aktivnosti može se koristiti da označi kada je aktivnost završena (prazan krug biće prikazan ako nije).<br><br>
U zavisnosti od podešavanja, kvačica se može pojaviti automatski kada ste završili aktivnost, a na osnovu uslova koje je postavio predavač.<br><br>
U ostalim slučajevima možete kliknuti na prazan krug kada mislite da ste završili aktivnost i on će se pretvoriti u zelenu kvačicu (ako se predomislite, ponovnim klikom kvačica se uklanja ).';
$string['completionswitchhelp'] = '<p>Izabrali ste da prikažete praćenje završetka na svakoj pločici.  Stoga smo opciju "Praćenje završetka > Omogući praćenje završetka" u nastavku ove stranice podesili na "Da".</p>
<p>Pored toga, potrebno je da uključite praćenje završetka za <b>svaku stavku</b> koju pratite, kao npr. za  PDF datoteku, kliknite na "Uredi podešavanja", a zatim u okviru opcije "Završetak aktivnosti", izaberite podešavanje koje želite.</p>
<p>Ovo takođe možete učiniti i <b>grupno</b> (za veći broj stavki istovremeno) kao što je već detaljno objašnjeno u <a href="https://docs.moodle.org/35/en/Activity_completion_settings" target="_blank">Dokumentaciji o praćenju završetka na moodle.org</a></p>';
$string['completionwarning'] = 'Iako ste u podešavanjima kursa uključili praćenje završetka, na nivou pojedinačnih aktivnosti ni kod jedne od aktivnosti praćenje završetka nije omogućeno, tako da nema šta da se prati.';
$string['completionwarning_changeinbulk'] = 'Grupna promena završetka aktivnosti';
$string['completionwarning_help'] = 'Morate da omogućite praćenje završetka pojedinačnih aktivnosti tako što ćete uključiti praćenje  u podešavanjima svake od aktivnosti, pojedinačno (Završetak aktivnost > Praćenje završetka). Ovo možete učiniti, i istovremeno za veći broj aktivnost na nivou samog kursa tako što ćete u okviru kartice \'Više\' izabrati \'Završetak kursa\', a zatim, na sledećoj stranici, iz padajućeg menija \'Grupno uređivanje završetka aktivnosti\'';
$string['contact'] = 'Budimo u kontaktu';
$string['contactdeveloper'] = 'Kontaktirajte programera';
$string['contents'] = 'Sadržaji';
$string['controls'] = 'Kontrolni elementi';
$string['coursephotomigrationincomplete'] = 'Ikonice pločica i fotografije još uvek nisu migrirane nakon prelaska na novu verziju sistema. Stavke koje nedostaju trebalo bi da se pojave u roku od nekoliko sati od nadogradnje.';
$string['courseshowtileprogress'] = 'Napredak na svakoj pločici';
$string['courseshowtileprogress_error'] = 'Podesili ste \'Praćenje završetka >Omogući praćenje završetka\' na \'Ne\' (pogledajte dalje, u nastavku ove stranici) što je u suprotnosti sa ovim podešavanjem. Ako želite da prikažete napredak na pločicama, podesite \'Praćenje završetka >Omogući praćenje završetka\' na \'Da\'. U suprotnom, postavite ovo podešavanje na \'Ne\'.';
$string['courseshowtileprogress_help'] = '<p>Kada se izabere ova opcija, napredak korisnika sa aktivnostima biće prikazano u svakoj pločici, bilo kao <em>razlomak</em> (npr. \'Napredak 2/10\' znači da je korisnik završio 2 od 10 aktivnosti), ili kao <em>procenat</em> u krugu.</p><p>Ovo se može koristiti samo ako je podešavanje \'Praćenje završetka >Omogući praćenje završetka\' uključeno.</p><p>Ako unutar date pločice nema aktivnosti čiji završetak može da se prati, onda indikator za tu pločicu neće biti prikazan.</p>';
$string['courseshowtileprogress_link'] = 'Activity_completion_settings#Activity_settings';
$string['coursetoomanysections'] = 'Upozorenje za korisnike sa uređivačkim pravima: ovaj kurs ima više pločica od maksimalno dozvoljenog broja. Polaznicima će biti prikazano najviše {$a->max} pločice/a (do "{$a->tilename}") (korisnici sa uređivačkim pravima mogu da vide više).';
$string['courseusebarforheadings'] = 'Istakni naslove obojenim jezičkom';
$string['courseusebarforheadings_help'] = 'Prikažite obojenu karticu levo od naslova u kursu kad god je stil naslova izabran u editoru teksta';
$string['courseusesubtiles'] = 'Koristite podpločice za aktivnosti';
$string['courseusesubtiles_help'] = 'Unutar svake pločice, prikažite svaku aktivnost kao podpločicu, umesto kao listu aktivnosti na stranici. Ovo se ne odnosi na natpise koje neće biti prikazane kao podpločice pa se mogu koristiti kao naslovi između pločica.';
$string['currentsection'] = 'Ova pločica';
$string['customcss'] = 'Prilagođeni CSS';
$string['customcssdesc'] = 'Prilagođeni CSS koji se primenjuje na sekciju sa sadržajem kursa kada se koristi format pločica. CSS neće biti proveravan, pa vodite računa da unesete ispravan kôd. Na primer: <p>.section { color: red; }</p><p>li.activity.subtile.resource.pdf { background-color: orange !important; }</p>';
$string['datapref'] = 'Podešavanje skladišta podataka';
$string['datapreferror'] = 'Funkcija podešavanja skladišta podataka je dostupna samo ako je JavaScript dostupan u vašem veb čitaču. U suprotnom, skladištenje podataka ne može biti omogućeno.
Podešavanje skladišta podataka je dostupno samo ako je omogućen JavaScript u Vašem veb pregledaču.';
$string['dataprefquestion'] = '<p>Kako bi sajt bio jednostavniji za korišćenje, u okviru veb čitača čuvamo funkcionalne informacije poput ID broja pločice koju ste poslednju otvorli. Ti podaci ostaju zapamćeni kratko na vašem računaru, u slučaju da ponovo posetite istu stranicu. Ne koristimo ih za praćenje. Da li je to u redu?</p>
<p>Vaš izbor će biti zapamćen sve dok ne izbrišete istoriju posećenih sajtova u vašem veb čitaču. Da biste isključili ovu opciju kliknite na "Otkaži".</p>';
$string['defaultthiscourse'] = 'Podrazumevano za ovaj kurs';
$string['defaulttilecolour'] = 'Podrazumevana boja pločice';
$string['defaulttileicon'] = 'Ikonica pločice';
$string['defaulttileicon_help'] = 'Ovde izabrana ikonica standardno će se pojavljivati na <em>svim</em> pločicama u ovom kursu. Za pojedinačne pločice mogu se izabrati druge ikonice ili pozadinske fotografije, korišćenjem različitih podešavanja na nivou pločice.';
$string['deleteemptytiles'] = 'Obriši prazne pločice';
$string['deleteimage'] = 'Obriši sliku';
$string['deletesection'] = 'Obriši pločicu';
$string['deletetile'] = 'Obriši pločicu';
$string['developedby'] = 'Format pločica razvio je {$a}';
$string['developer'] = 'Programer';
$string['disabledbyadmin'] = 'Onemogućio administrator sajta';
$string['displayfilterbar'] = 'Traka filtera';
$string['displayfilterbar_error'] = 'Možete prikazati traku filtera samo na osnovu brojeva pločica, a ne na osnovu ishoda, osim ako niste prethodno podesili ishode za ovaj kurs,  Prvo kreirajte ishode pa se zatim vratite ovde.';
$string['displayfilterbar_help'] = '<p>Kada se izabere ova opcija, na početku glavne stranice kurs biće automatski prikazan niz dugmadi, na koje korisnici mogu da kliknu kako bi filtrirali pločice iz odgovarajućeg opsega</p><p>
Kada se izabere  opcija \'na osnovu brojeva pločica\', biće prikazan niz dugmadi, npr. dugme za pločice 1-4, dugme za pločice 5-8 itd.</p><p>Kada se izabere opcija \'na osnovu ishoda kursa\', za svaki ishod kursa biće prikazano jedno dugme. Svaka pločica može biti dodeljena datom ishodu (a samim tim i datom dugmetu) sa stranice za podešavanja te pločice.</p>';
$string['displayfilterbar_link'] = 'Outcomes';
$string['displaytitle_mod_doc'] = 'Word dokument';
$string['displaytitle_mod_html'] = 'Veb stranica';
$string['displaytitle_mod_jpeg'] = 'Slika';
$string['displaytitle_mod_mp3'] = 'Audio';
$string['displaytitle_mod_mp4'] = 'Video';
$string['displaytitle_mod_pdf'] = 'PDF';
$string['displaytitle_mod_ppt'] = 'Powerpoint prezentacija';
$string['displaytitle_mod_txt'] = 'Tekst';
$string['displaytitle_mod_xls'] = 'Radna tabela';
$string['displaytitle_mod_zip'] = 'Zip arhiva';
$string['documentation'] = 'Dokumentacija';
$string['documentationurl'] = 'URL adresa dokumentacije';
$string['documentationurl_descr'] = 'URL adresa na kojoj se može naći dokumentacija o \'Formatu pločica\'.';
$string['download'] = 'Preuzmi';
$string['editoradvicesubtiles'] = 'U ovoj verziji dodatka \'Format pločica\', aktivnosti će se pojavljivati kao podpločice samo ako je režim uređivanja isključen';
$string['editsection'] = 'Uredi pločicu';
$string['editsectionname'] = 'Uredi naziv pločice';
$string['embeddedurlerror'] = 'Ako eksterni veb sajt odbije da bude prikazan u prozoru iznad, upotrebite ovo:';
$string['enablelinebreakfilter'] = 'Omogući filter za prelom reda';
$string['enablelinebreakfilter_desc'] = 'Filtrirajte naslove pločica za nevidljivi znak za spajanje reči {$a} i, ako on postoji, a naslov pločice je dugačak, zamenite ga sa  "- " kako biste dozvolili prelom reda. U suprotnom ga nemojte zamenite ni sa čim (tj. bez preloma reda).';
$string['entersection'] = 'Uđi na sekciju';
$string['existingimage'] = 'Postojeća slika za ovu pločicu';
$string['expand'] = 'Proširi';
$string['expandall'] = 'Proširi sve';
$string['expandsections'] = 'Otkrijte sve aktivnosti (sve sekcije)';
$string['expandtopsection'] = 'Otvorite sekciju na vrhu';
$string['experimental'] = 'eksperimentalno';
$string['experimentalfeatures'] = 'Eksperimentalne funkcije';
$string['fileaddedtobottom'] = 'Datoteka je dodata na kraj sekcije';
$string['filenoshowtext'] = 'Ako se datoteka ne prikazuje ovde, upotrebite dugmad sa desne strane kako biste je preuzeli ili videli u novom prozoru';
$string['filterboth'] = 'Prikaži dugmad na osnovu brojeva pločica i ishoda kursa';
$string['filternumbers'] = 'Prikaži dugmad na osnovu brojeva pločica';
$string['filteroutcomes'] = 'Prikaži dugmad na osnovu ishoda kursa';
$string['filteroutcomesrestore'] = 'Originalni kurs koristio je ishode u traci filtera, koji još nisu podržani tokom procesa restauriranja. Podešavanje trake filtera je stoga promenjeno u restauriranom kursu. Ukoliko želite da koristite ishode za filtriranje pločica u restauriranom kursu, podesite ih ponovo. Prvobitni kurs nije promenjen.';
$string['filters'] = 'Filteri';
$string['fittilestowidth'] = 'Prilagodite pločice širini ekrana';
$string['fittilestowidth_desc'] = 'Ako je označeno, kada korisnik pristupa kursu na uređaju koji nije mobilan, učitavanje pločice biće odloženo na pola sekunde dok se napravi proračun za najbolji raspored pločica na stranici. Na primer, izbegavajte da jedan red ima samo jednu pločicu, ili da pločicu postavite u centar ekrana. Ovo će se dogoditi samo kada korisnici prvi put uđu na kurs u datoj sesiji, a onda će raspored pločica biti zapamćeno za tu sesiju ili dok korisnik ne podesi veličinu ekrana.';
$string['fixproblems'] = 'Reši probleme';
$string['folderdisplayerror'] = 'Direktorijumi podešeni da prikazuju sadržaj unutar početne stranice kursa nisu kompatibilni sa formatom podpločica. Ovaj<a href="{$a}">direktorijum</a> je zato podešen da sadražj prikazuje na zasebnoj stranici';
$string['followthemecolour'] = 'Obavezna upotreba boja grafičke teme';
$string['followthemecolour_desc'] = 'Ako je podešeno na \'Da\', ova dodatak neće dati predavačima mogućnost da biraju boje, i sve boje podešene u nastavku ove stranice biće ignorisane. Umesto toga, koristiće se glavna brend boja grafičke teme';
$string['guidance'] = 'Uputstvo';
$string['height'] = 'visina';
$string['hidden'] = 'Sakriveno';
$string['hide'] = 'Sakrij';
$string['hidefromothers'] = 'Sakrij pločicu';
$string['highestsectionnum'] = 'Pronađen najveći broj sekcija';
$string['home'] = 'Početna stranica kursa';
$string['icontitle-address-book-o'] = 'Adresar';
$string['icontitle-assessment_graded'] = 'Provera znanja A+';
$string['icontitle-assessment_timer'] = 'Tajmer za proveru znanja';
$string['icontitle-asterisk'] = 'Zvezdica';
$string['icontitle-award-solid'] = 'Nagradna rozeta';
$string['icontitle-balance-scale'] = 'Vaga';
$string['icontitle-bar-chart'] = 'Trakasti grafikon';
$string['icontitle-bell-o'] = 'Zvono';
$string['icontitle-binoculars'] = 'Dvogled';
$string['icontitle-bitcoin'] = 'Bitkoin';
$string['icontitle-book'] = 'Knjiga';
$string['icontitle-bookmark-o'] = 'Obeleživač';
$string['icontitle-briefcase'] = 'Aktovka';
$string['icontitle-building'] = 'Zgrada';
$string['icontitle-bullhorn'] = 'Megafon';
$string['icontitle-bullseye'] = 'Centar mete';
$string['icontitle-calculator'] = 'Kalkulator';
$string['icontitle-calendar'] = 'Kalendar';
$string['icontitle-calendar-check-o'] = 'Kalendar sa štriklom';
$string['icontitle-check'] = 'Štrikla';
$string['icontitle-child'] = 'Dete';
$string['icontitle-clock-o'] = 'Sat';
$string['icontitle-clone'] = 'Klon';
$string['icontitle-cloud-download'] = 'Oblak (preuzimanje)';
$string['icontitle-cloud-upload'] = 'Oblak (postavljanje)';
$string['icontitle-comment-o'] = 'Komentar';
$string['icontitle-comments-o'] = 'Komentari';
$string['icontitle-compass'] = 'Kompas';
$string['icontitle-diamond'] = 'Dijamant';
$string['icontitle-dollar'] = 'Dolar';
$string['icontitle-euro'] = 'Evro';
$string['icontitle-exclamation-triangle'] = 'Znak uzvika u trouglu';
$string['icontitle-feed'] = 'Izvor vesti';
$string['icontitle-file-text-o'] = 'Tekstualna datoteka';
$string['icontitle-film'] = 'Film';
$string['icontitle-flag-checkered'] = 'Zastavica (karirana)';
$string['icontitle-flag-o'] = 'Zastavica';
$string['icontitle-flash'] = 'Bljesak';
$string['icontitle-flask'] = 'Boca';
$string['icontitle-flipchart'] = 'Flip čart (tabla sa papirom)';
$string['icontitle-frown-o'] = 'Namršteno lice';
$string['icontitle-gavel'] = 'Čekić';
$string['icontitle-gbp'] = 'Britanska funta';
$string['icontitle-globe'] = 'Globus';
$string['icontitle-handshake-o'] = 'Rukovanje';
$string['icontitle-headphones'] = 'Slušalice';
$string['icontitle-heartbeat'] = 'Otkucaj srca';
$string['icontitle-history'] = 'Istorijski časovnik';
$string['icontitle-home'] = 'Kuća';
$string['icontitle-id-card-o'] = 'ID kartica';
$string['icontitle-info'] = 'Info';
$string['icontitle-jigsaw'] = 'Slagalica';
$string['icontitle-key'] = 'Ključ';
$string['icontitle-laptop'] = 'Prenosivi računar';
$string['icontitle-life-buoy'] = 'Pojas za spasavanje';
$string['icontitle-lightbulb-o'] = 'Sijalica';
$string['icontitle-line-chart'] = 'Linijski grafikon';
$string['icontitle-list'] = 'Neuređena lista';
$string['icontitle-list-ol'] = 'Uređena lista';
$string['icontitle-location-arrow'] = 'Strelica za lokaciju';
$string['icontitle-map-marker'] = 'Marker na mapi';
$string['icontitle-map-o'] = 'Mapa';
$string['icontitle-map-signs'] = 'Putokazi';
$string['icontitle-microphone'] = 'Mikrofon';
$string['icontitle-mobile-phone'] = 'Mobilni telefon';
$string['icontitle-mortar-board'] = 'Akademska kapa';
$string['icontitle-music'] = 'Muzika';
$string['icontitle-newspaper-o'] = 'Novine';
$string['icontitle-number'] = 'Broj {$a}';
$string['icontitle-pencil-square-o'] = 'Olovka u kvadratu';
$string['icontitle-person'] = 'Osoba';
$string['icontitle-pie-chart'] = 'Kružni grafikon';
$string['icontitle-podcast'] = 'Podkast';
$string['icontitle-puzzle-piece'] = 'Komad slagalice';
$string['icontitle-question-circle'] = 'Znak pitanja u krugu';
$string['icontitle-random'] = 'Nasumičan izbor';
$string['icontitle-refresh'] = 'Osveži';
$string['icontitle-road'] = 'Put';
$string['icontitle-search'] = 'Lupa';
$string['icontitle-sliders'] = 'Klizači';
$string['icontitle-smile-o'] = 'Osmeh';
$string['icontitle-star'] = 'Zvezdica (osenčena)';
$string['icontitle-star-half-o'] = 'Zvezdica (poluosenčena)';
$string['icontitle-star-o'] = 'Zvezdica (neosenčena)';
$string['icontitle-survey'] = 'Istraživanje';
$string['icontitle-tags'] = 'Oznake';
$string['icontitle-tasks'] = 'Zadaci';
$string['icontitle-television'] = 'Televizija';
$string['icontitle-thinking-person'] = 'Osoba sa sijalicom';
$string['icontitle-thumbs-o-down'] = 'Znak neodobravanja (palac na dole)';
$string['icontitle-thumbs-o-up'] = 'Znak odobravanja (palac na gore)';
$string['icontitle-trophy'] = 'Trofej';
$string['icontitle-umbrella'] = 'Kišobran';
$string['icontitle-university'] = 'Univerzitet';
$string['icontitle-user-o'] = 'Osoba (neosenčeno)';
$string['icontitle-users'] = 'Ljudi';
$string['icontitle-volume-up'] = 'Zvučnik';
$string['icontitle-wrench'] = 'Viljuškasti ključ';
$string['imagecannotbeused'] = 'Slika se ne može koristiti';
$string['imagedeletedfrom'] = 'Slika je obrisana sa "{$a}"';
$string['imagesavedfor'] = 'Slika je sačuvana za pločicu {$a}';
$string['imagesize'] = 'Veličina slike';
$string['jsactivate'] = 'Animirana navigacija - isključi';
$string['jsdeactivate'] = 'Animirana navigacija - uključi';
$string['jsdeactivated'] = 'Deaktivirali ste animiranu navigaciju na svom nalogu';
$string['jsnavsettings'] = 'JavaScript navigacija';
$string['jsreactivated'] = 'Aktivirali ste animiranu navigaciju na svom nalogu. Ovo može biti brže za upotrebu. Zahteva da JavaScript bude omogućen.';
$string['legacytiledata'] = 'Broj podataka starih, nasleđenih pločica';
$string['links'] = 'Linkovi';
$string['loading'] = 'Učitavanje';
$string['maxcoursesectionsallowed'] = 'Maksimalan broj sekcija kursa dozvoljen u ovom okruženju je {$a}.';
$string['migratecoursedata'] = 'Migrirajte podatke kursa';
$string['migratedcourseid'] = 'ID oznaka migiranog kursa {$a}';
$string['migratenow'] = 'Migrirajte sada';
$string['modalmodules'] = 'Modalni moduli';
$string['modalmodules_desc'] = 'Pokrenite ove module kursa u modalnom prozoru (ostali moduli mogu biti dodati u kasnijim izdanjima)';
$string['modalresources'] = 'Modalni resursi';
$string['modalresources_desc'] = 'Pokrenite ove resurse u modalnom prozoru. Napomena: ako je ovde dozvoljeno, resurs URL adresa će se otvarati samo u modalnom prozoru ako je na nivou aktivnosti opcija za izgled podešena na  {$a->displayembed} (npr. YouTube ili Vimeo video). Čak i tada, vlasnik veb sajta može da blokira ovo podešavanje, tj. da spreči da se video klipovi prikazuju kao ugrađeni - pogledajte {$a->link}';
$string['modalwindows'] = 'Modalni prozori';
$string['newsectionname'] = 'Novi naziv za temu {$a}';
$string['newtiledata'] = 'Broj podataka novih pločica';
$string['nexttopic'] = 'Sledeća tema';
$string['noconnectionerror'] = 'Nije moguće učitati sadržaj. Proverite svoju internet vezu';
$string['nojswarning'] = 'Vaš veb čitač izgleda ne podržava JavaScript ili je isti onemogućen. Unapređeni interfejs biće dostupan ako omogućite JavaScript';
$string['none'] = 'Nijedan';
$string['noproblemsfound'] = 'Nisu pronađeni problemi';
$string['notcomplete'] = 'Nije završeno';
$string['notrecommended'] = 'Ne preporučuje se';
$string['notregistered'] = 'Vaš dodatak \'Format pločica\' još uvek nije registrovan kod programera koji je razvio ovaj dodatak.';
$string['novaliddefaultcolour'] = 'Nije podešena ispravna boja za podrazumevanu boju pločice';
$string['numberofsections'] = 'Broj sekcija unutar kursa';
$string['numbers'] = 'Brojevi';
$string['numbers_desc'] = 'Izaberite ikonicu broja za ovu pločicu';
$string['ok'] = 'OK';
$string['onlywhenediting'] = 'Samo prilikom uređivanja';
$string['other'] = 'Ostala podešavanja';
$string['outcomes'] = 'ishodi';
$string['outcomesunavailable'] = 'Nedostupni ishodi';
$string['overall'] = 'Sveukupno';
$string['overallprogress'] = 'Završetak aktivnosti - sveukupni napredak';
$string['overallprogressshort'] = 'Sveukupni napredak';
$string['photoguidance_desc'] = '<p>Postavite fotografiju u formatu <strong>položene slike</strong>.  Širina treba da bude oko 1,35 puta veća od visine. Na primer, dimenzije fotografije 270 piksela širine x 200 piksela visine će sasvim odgovarati.  Ne morate biti skroz precizni.</p>
<p>Fotografije u formatu uspravne slike neće odgovarati obliku pločice. Velike slike ili datoteke biće, nakon postavljanja, smanjene i komprimovane ako je to potrebno.</p>';
$string['photolibrary'] = 'Biblioteka fotografija';
$string['photolibrary_desc'] = 'Ovo su fotografije koje ste nedavno postavili ili koristili. Kako biste neku od njih iskoristili kao pozadinu za ovu pločicu, kliknite na željenu fotografiju. Da postavite novu fotografiju, upotrebite  gornju karticu za postavljanje.';
$string['phototilesaltstyle'] = 'Alternativni stil foto pločica';
$string['phototilesaltstyle_desc'] = 'Ako nije izabrano (što je podrazumevana vrednost), naslov će biti prikazan na vrhu foto pločice. Alternativni stil prikazuje naslov na dnu pločice';
$string['phototilesettings'] = 'Foto pločice';
$string['phototiletitletransarency'] = 'Transparentnost naslova foto pločice';
$string['phototiletitletransarency_desc'] = 'Naslov na foto pločici može imati blago providnu ili jednobojnu pozadinu (0%)';
$string['phototitletitlelineheight'] = 'Visina naslovnog reda';
$string['phototitletitlepadding'] = 'Vertikalni razmak između naslovnog reda i ivice';
$string['picknewicon'] = 'Izaberi novu ikonicu';
$string['picknewiconphoto'] = 'Izaberi novu ikonicu ili sliku pozadine';
$string['pluginname'] = 'Format pločica';
$string['previoustopic'] = 'Prethodna tema';
$string['privacy:metadata:preference:format_tiles_stopjsnav'] = 'Da li je korisnik onemogućio animiranu JavaScript navigaciju.';
$string['privacypolicy'] = 'Pravilnik o privatnosti';
$string['problemcourses'] = 'Problematični kursevi';
$string['problemcoursesintro'] = 'Sledeći kursevi imaju brojeve sekcija veći od očekivanog. Upotrebite dugmad u nastavku kako biste rešili probleme.';
$string['progress'] = 'Napredak';
$string['progresstitle'] = '{$a->numComplete} / {$a->numOutOf} procenat završenih stavki ({$a->percent}%)';
$string['reactivate'] = 'aktivirajte ponovo';
$string['register'] = 'Registrujte dodatak';
$string['registeragreeprivacy'] = 'Slažem se sa pravilnikom o privatnosti programera koji je razvio dodatak {$a->privacypolicylink}';
$string['registerclicktocomplete'] = 'Kliknite na OK kako biste dovršili registraciju';
$string['registeredthanks'] = 'Vaš dodatak je registrovan. Hvala vam.';
$string['registeremailno'] = 'Ne, ne želim da primam bilo kakva obaveštenja';
$string['registeremailyes'] = 'Da, voljan sam da povremena primam obaveštenja o novim verzijama, kao i druge informacije o dodatku \'Format pločica\'';
$string['registerintro1'] = 'Voleli bismo da ostanemo u kontaktu, kada se registrujete';
$string['registerintro2'] = 'podržavate budući razvoj ovog dodatka';
$string['registerintro3'] = 'možete odmah saznati više o važnim unapređenjima dodatka i budućim planovima';
$string['registerintro4'] = 'možemo da saznamo više o tome šta želite da ovaj dodatak radi.';
$string['registerintro5'] = 'Programer će čuvati vaše podatke kao privatne kao što je navedeno u pravilniku o privatnosti na linku ispod. Hvala vam na podršci!';
$string['registermissingemail'] = 'Molim vas, da unesite svoju adresu e-pošte (u padajućem meniju ispod izabrali ste opciju "Da" za primanje obaveštenja putem e-pošte)';
$string['registerpickemailpref'] = 'Molimo, izaberite željenu adresu e-pošte';
$string['registerpolicyagreedlinktext'] = 'Pravilnik o privatnosti i Ugovor o obradi podataka';
$string['registrationdeferred'] = 'Hvala vam. Pokušavamo da registrujemo vaš dodatak (ova procedura još nije završena).';
$string['reopenlastsection'] = 'Ponovo otvori pločicu koju ste poslednju posetili';
$string['reopenlastsection_desc'] = 'Kada je označeno, ako korisnik ponovo pristupi kursu, sekcija (tj. pločica) koju je poslednju otvorio prilikom prethodnog pristupa kurs, biće mu ponovo prikazana po dolasku';
$string['resetallcoursecolours'] = 'Resetujte sve boje kursa';
$string['resetalltiles'] = 'Resetujte fotografije i ikonice pločica';
$string['resetalltilessure'] = 'Da li ste sigurni da želite da resetujete pločice za ovaj kurs? Ovo će obrisati sve fotografije pločica i resetovati sve ikonice na podrazumevane vrednosti? Sadržaj neće biti obrisan. Ovo je destruktivna akcija i ne može se poništiti. Ukoliko niste sigurni prvo napravite rezervnu kopiju kursa.';
$string['resetcolours'] = 'Resetovanje boja';
$string['resetcolours_desc'] = 'Pritisnite ovo dugme kako biste resetovali boju pločice za sve kurseve koji nemaju neku od dole podešenih boja. Kursevi će biti promenjeni u podrazumevanu boju pločice dole podešenu. Ovo možete da koristite nakon što promenite paletu boja ispod, ali uverite se da ste <strong>sačuvali sve promene</strong> boja pre nego što pritisnete ovo dugme. Budite oprezni jer ovo može promeniti boju mnogih kurseva!';
$string['resetincomplete'] = 'Resetovanje nije dovršeno';
$string['restorefailed'] = 'Restauriranje nije uspelo';
$string['restoreincorrectsections'] = 'Greška: nije moguće završiti jer izvorni kurs sadrži netačan broj numerisanih sekcija (npr. broj sekcija ({$a->sectionnum}) je veći od makasimalno dozveoljenih ({$a->maxallowed}). Pokušajte da izuzmete ili obrišete sekcije sa velikim brojevima.';
$string['restoretoomanysections'] = 'Nije moguće kreirati rezervnu kopiju ili restaurirati jer je uključeno previše sekcija kursa ({$a->numsections}) a ovo je više od dozvoljenih ({$a->maxallowed}). Pokušajte da izuzmete ili obrišete neke sekcije';
$string['revealcontents'] = 'Otkrijte sadržaj pločica';
$string['scheduleddeleteemptysections'] = 'Zakazan je zadatak brisanja praznih sekcija sa kursa. Proverite ponovo kasnije.';
$string['section0name'] = 'Opšta sekcija';
$string['sectionerrorstring'] = 'Vaša sesija je možda istekla. Pokušajte da osvežite ovu stranicu.';
$string['sectionerrortitle'] = 'Greška pri učitavanju sadržaja';
$string['sectionname'] = 'Pločica';
$string['sectionnumber'] = 'Broj sekcije / pločice';
$string['selected'] = 'Izabrano';
$string['setavailabletilecolours'] = 'Dozvoljene boje pločica (na čitavom sajtu)';
$string['setbackgroundphoto'] = 'Podesite fotografiju / ikonicu';
$string['settings'] = 'Podešavanja formata pločica';
$string['show'] = 'Prikaži';
$string['showalltiles'] = 'Prikaži sve pločice';
$string['showfromothers'] = 'Prikaži pločicu';
$string['showoverallprogress'] = 'Prikaži indikator ukupnog napretka';
$string['showoverallprogress_desc'] = 'Prikaži indikator "Sveukupni napredak %“ u gornjem desnom uglu kursa (prikazana vrednost predstavlja zbir % završetka svake pločice, na osnovu završetka aktivnosti, a ne završetka kursa)';
$string['showprogresssphototiles_desc'] = 'Ako je izabrana ova opcija, napredak polaznika (npr. Napredak 2/5) biće prikazan na foto pločici';
$string['showseczerocoursewide'] = 'Prikaži uvodnu sekciju na vrhu, iznad svih sekcija';
$string['showseczerocoursewide_desc'] = 'Ako je označeno, uvodna sekcija (na samom vrhu početne stranice kursa) biće prikazana kada se na kurs uđe, ali, takođe i na vrhu, iznad <b>svake stranice sekcije kursa</b> (tj. na vrhu iznad sadržaja svake pločice).  Ako nije označeno (što se preporučuje), uvodna sekcija biće prikazana samo na početnoj stranici kursa';
$string['showseparatewin'] = 'Prikaži datoteku u zasebnom prozoru';
$string['sitename'] = 'Naziv sajta';
$string['snapwarning'] = 'Možda će biti moguće da urediti svoj kurs u formatu pločica koristeći drugu grafičku temu, a zatim se vratiti na Snap temu kada završite sa uređivanjem.';
$string['snapwarning_help'] = 'Theme_settings#Allow_user_themes';
$string['style'] = 'Stil';
$string['subtileszeczerotoggled'] = 'Prekidač promene prikaza uvodne sekcije - format spiska aktivnosti/format podpločica';
$string['suremigratelegacyoptions'] = 'Da li ste sigurni da želite da migrirate fotografije ili ikonice pločica ({$ a}) za ovaj kurs?';
$string['sureresetcolours'] = 'Da li ste sigurni da želite da resetujete boje pločica na kursevima na podrazumevane vrednosti? Ovo će imati uticaja na {$a} kurs/a/eva';
$string['tilearialabel'] = '{$a}, otvara detalje u iskačućem prozoru, link';
$string['tilecolourgeneral'] = 'Paleta boja - boja po izboru';
$string['tilecolourgeneral_descr'] = 'Ova podešavanja omogućavaju administratoru da podesi koje boje će biti dostupne predavačim za korišćenje na kursevima. Ako želite da onemogućite neku od boja podesite njen heksadecimalni kod na crnu boju tj. #000.  Ako promenite boje ovde, neće biti promena u postojećim kursevima, sve dok sledeći put predavač ne pokuša da promeni boju pločica. U tom trenutku, predavaču će biti dostupne samo boje koje ste ovde podesili.';
$string['tilecolourschanged'] = 'Boje pločica su resetovane. Sve pločice sada imaju boje u skladu sa bojama koje su podešene u nastavku ove stranice.';
$string['tileicon'] = 'Ikonica za prikaz samo na ovoj pločici';
$string['tileicon_help'] = 'Ovde izabrana ikonica će zameniti, samo za ovu pločicu, bilo koju ikonicu pločice koja je podešena na nivou kursa.';
$string['tileicons'] = 'Ikonice pločica';
$string['tileoutcome'] = 'Ishod za ovu pločicu';
$string['tileoutcome_help'] = 'Ako izaberete ishod za ovu pločicu, tada ćete u podešavanjima kursa moći da prikažete skup <em>dugmadi za filtriranje</em>, po jedno dugme za svaki ishod, koja kada se pritisnu filtriraju prikazane pločice zavisno od ishoda koji su tim pločicama pridruženi';
$string['tilesformatregistration'] = 'Registracija dodatka \'Format pločica\'';
$string['tilesreset'] = 'Pločice i ikonice su resetovane za ovaj kurs';
$string['tilestyle'] = 'Stil pločica';
$string['tilestyle_desc'] = 'Stil 1 = foto pločice će prikazati naslov na vrhu pločice, stil 2 = naslov na dnu';
$string['togglecompletion'] = 'Kliknite da biste promenili status završetka';
$string['togglecompletioncomplete'] = 'Kliknite da biste promenili status završetka (završeno)';
$string['togglecompletionincomplete'] = 'Kliknite da biste promenili status završetka (nezavršeno)';
$string['tootall'] = 'previsoko za pločicu';
$string['toowide'] = 'preširoko za pločicu';
$string['transparenttitleadjustments'] = 'Podešavanja transparentnosti naslova';
$string['transparenttitleadjustments_desc'] = 'Na foto pločicama sa trasnparentnom pozadinom naslova, u zavisnosti od grafičke teme koju koristite, možda ćete želeti da ih prilagodite kako biste osigurali da se transparentni redovi naslova ne preklapaju kada se prelamaju.
Imajte na umu da se ovi parametri malo razlikuju između različtih veb čitača. Predložene vrednosti za Chrome veb čitač: Boost i teme bazirane na temi Clean: 30.5 i 4 | Adaptable: 32 i 4 | Moove: 32 i 2 | Remui: 32 i 2.5';
$string['unmigratedcoursesintro'] = 'Čini se da sledeći kursevi {$a} nisu migrirali sve ikonice pločica i fotografije nakon prelaska na novu verziju sistema. Kliknite na dugme da obradite kurs sada. Ako sačekate, pozadinski "cron" proces bi trebalo da obradi sve ovo, ali ako želite da procesuirate dati kurs sada, kliknite na dugme';
$string['uploadnewphoto'] = 'Postavite novu fotografiju';
$string['uploadnewphoto_help'] = 'Postavite sliku koja će se koristiti na ovoj pločici';
$string['usecourseindex'] = 'Koristite indeks kursa';
$string['usecourseindex_desc'] = 'Kada je kurs u format pločica, da li treba prikazati indeks kursa sa leve strane?';
$string['usejavascriptnav'] = 'Koristite JavaScript navigaciju na glavnoj stranici sa pločicama';
$string['usejavascriptnav_desc'] = 'Kada je označeno, ako korisnik klikne na pločicu na početnoj stranici kursa, a JavaScript je aktiviran, JS će se koristiti za prelazak na sadržaj pločice. Sadržaj pločica će biti uskladišten lokalno u veb čitaču u skladu sa ostalim podešavanjima u nastavku ove stranice. Ako nije označeno, JS se neće biti korišćen i umesto njega će se koristiti nasleđena navigacija. Ostala JS podešavanja u nastavku biće ignorisana.';
$string['usejseditingexpandcollapse'] = 'Režim uređivanja - koristite JavaScript kako biste proširili/skupili pločice';
$string['usejseditingexpandcollapse_desc'] = 'Ako je izabrana ova opcija, u režimu uređivanja predavač može da proširi i skupi pločice sa animiranim prelazima. Sadržaj pločice će se učitavati prilikom njenog širenja, bez ponovnog učitavanja stranice.';
$string['usejsnavforsinglesection'] = 'Koristite JS navigaciju za prikaz stranice pojedinačne sekcije';
$string['usejsnavforsinglesection_desc'] = 'Kada je označeno, svaki poziv stranice pojedinačne sekcije (&section=xx) biće obrađen pomoću JavaScripta, pokretanjem početne stranice kursa, animirane da se otvori u traženoj sekciji preko JS-a, umesto da se poziva stari PHP stil prikaza stranice pojedinačne sekcije';
$string['usesubtilesseczero'] = 'Koristi podnivo sa pločicama u sekciji na vrhu';
$string['usesubtilesseczero_help'] = 'Ako je izabrana ova opcija, podpločice će se koristiti u uvodnoj sekciji (pločici) kursa, isto kao i unutar svih pločica. Opcija je dostupna samo ako koristite podpločice na čitavom kursu. Ovo je zbog toga što podpločice zauzimaju mnogo prostora na samom vrhu kursa. Možda bi bilo bolje da ne izaberete ovu opciju, tako da sve stavke u uvodnoj sekciju budu prikazane u standardnom formatu spiska aktivnosti/resursa.';
$string['usetooltips'] = 'Koristite JavaScript kratke opise alata';
$string['usetooltips_desc'] = 'Koristite JavaScript kratke opise alata, kada korisnik pređe kursorom preko određenih stavki, npr. polja za potvrdu završšetka, pločice itd.';
$string['version'] = 'Verzija {$a}';
$string['width'] = 'širina';
