<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'competency', language 'sr_lt', version '4.1'.
 *
 * @package     competency
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['allchildrenarecomplete'] = 'Sve podređene kompetencije su završene';
$string['competencies'] = 'Kompetencije';
$string['competenciesarenotenabled'] = 'Kompetencije nisu omogućene.';
$string['competenciessettings'] = 'Podešavanja kompetencija';
$string['completeplanstask'] = 'Završi planove učenja kojima se približava rok';
$string['coursecompetencyoutcome_complete'] = 'Završi kompetenciju';
$string['coursecompetencyoutcome_evidence'] = 'Priloži dokaz';
$string['coursecompetencyoutcome_none'] = 'Ne radi ništa';
$string['coursecompetencyoutcome_recommend'] = 'Pošalji na pregled';
$string['coursemodulecompetencyoutcome_complete'] = 'Završi kompetenciju';
$string['coursemodulecompetencyoutcome_evidence'] = 'Priloži dokaz';
$string['coursemodulecompetencyoutcome_none'] = 'Ne radi ništa';
$string['coursemodulecompetencyoutcome_recommend'] = 'Pošalji na pregled';
$string['deletecompetencyratings'] = 'Obriši procene kompetencije';
$string['duplicateditemname'] = '{$a} (kopija)';
$string['enablecompetencies'] = 'Omogući kompetencije';
$string['enablecompetencies_desc'] = 'Kompetencije dozvoljavaju ocenjivanje korisnika prema planovima učenja.';
$string['errorcannotchangeapastduedate'] = 'Krajnji rok je istekao; ne može se menjati.';
$string['errorcannotsetduedateinthepast'] = 'Krajnji rok nije moguće postaviti u prošlosti.';
$string['errorcannotsetduedatetoosoon'] = 'Krajnji rok uskoro ističe.';
$string['errorcompetencyrule'] = 'Pravilo kompetencije kursa \'{$a}\' nije poznato';
$string['errorcoursecompetencyrule'] = 'Pravilo kompetencije kursa \'{$a}\' nije poznato';
$string['errorinvalidcourse'] = 'Neispravan kurs';
$string['errornocompetency'] = '{$a} kompetencija ne može biti pronađena';
$string['errorplanstatus'] = 'Status planova učenja \'{$a}\' je nepoznat';
$string['errorscalealreadyused'] = 'Skala ne može biti izmenjena jer se već koristi.';
$string['errorscaleconfiguration'] = 'Skala treba da se podesi odabirom podrazumevanih i naprednih stavki.';
$string['errorusercomptencystatus'] = 'Korisnički status kompetencija \'{$a}\' je nepoznat';
$string['eventcompetencycreated'] = 'Kompetencija je kreirana.';
$string['eventcompetencydeleted'] = 'Kompetencija je obrisana.';
$string['eventcompetencyframeworkcreated'] = 'Okvir kompetencija je kreiran.';
$string['eventcompetencyframeworkdeleted'] = 'Okvir kompetencija je obrisan.';
$string['eventcompetencyframeworkupdated'] = 'Okvir kompetencija je ažuriran.';
$string['eventcompetencyframeworkviewed'] = 'Okvir kompetencija prikazan.';
$string['eventcompetencyupdated'] = 'Kompetencija ažurirana.';
$string['eventcompetencyviewed'] = 'Kompetencija prikazan.';
$string['eventevidencecreated'] = 'Dokaz kreiran.';
$string['eventplanapproved'] = 'Plan učenja odobren.';
$string['eventplancompleted'] = 'Plan učenja ispunjen.';
$string['eventplancreated'] = 'Plan učenja kreiran.';
$string['eventplandeleted'] = 'Plan učenja obrisan.';
$string['eventplanreopened'] = 'Plan učenja ponovo aktiviran.';
$string['eventplanreviewrequestcancelled'] = 'Zahtevani pregled plana učenja otkazan.';
$string['eventplanreviewrequested'] = 'Pregled plana učenja zatražen.';
$string['eventplanreviewstarted'] = 'Pregled plana učenja započet.';
$string['eventplanreviewstopped'] = 'Pregled plana učenja zaustavljen.';
$string['eventplanunapproved'] = 'Plan učenja neodobren.';
$string['eventplanunlinked'] = 'Plan učenja nije više povezan.';
$string['eventplanupdated'] = 'Plan učenja ažuriran.';
$string['eventplanviewed'] = 'Plan učenja prikazan.';
$string['eventtemplatecreated'] = 'Šablon plana učenja kreiran.';
$string['eventtemplatedeleted'] = 'Šablon plana učenja obrisan.';
$string['eventtemplateupdated'] = 'Šablon plana učenja ažuriran.';
$string['eventtemplateviewed'] = 'Šablon plana učenja prikazan.';
$string['eventusercompetencyplanviewed'] = 'Plan kompetencije korisnika  prikazan.';
$string['eventusercompetencyrated'] = 'Kompetencija korisnika rangirana.';
$string['eventusercompetencyratedincourse'] = 'Kompetencija korisnika rangirana u okviru kursa.';
$string['eventusercompetencyratedinplan'] = 'Kompetencija korisnika rangirana u planu učenja.';
$string['eventusercompetencyreviewrequestcancelled'] = 'Zahtevani pregled kompetencija korisnika otkazan.';
$string['eventusercompetencyreviewrequested'] = 'Pregled kompetencija korisnika zatražen.';
$string['eventusercompetencyreviewstarted'] = 'Pregled kompetencije korisnika započet.';
$string['eventusercompetencyreviewstopped'] = 'Pregled kompetencije korisnika zaustavljen.';
$string['eventusercompetencyviewed'] = 'Kompetencija korisnika prikazan.';
$string['eventusercompetencyviewedincourse'] = 'Kompetencija korisnika prikazana u okviru kursa.';
$string['eventusercompetencyviewedinplan'] = 'Kompetencija korisnika prikazana u planu učenja.';
$string['eventuserevidencecreated'] = 'Dokaz o prethodnom učenju kreiran.';
$string['eventuserevidencedeleted'] = 'Dokaz o prethodnom učenju obrisan.';
$string['eventuserevidenceupdated'] = 'Dokaz o prethodnom učenju ažuriran.';
$string['evidence_competencyrule'] = 'Pravilo kompetencije ispunjeno.';
$string['evidence_coursecompleted'] = 'Kurs \'{$a}\' je završen.';
$string['evidence_coursemodulecompleted'] = 'Aktivnost \'{$a}\' je završena.';
$string['evidence_courserestored'] = 'Procena kompetencija je restaurisana zajedno sa kursom \'{$a}\'.';
$string['evidence_evidenceofpriorlearninglinked'] = 'Dokaz o prethodnom učenju \'{$a}\' je povezan.';
$string['evidence_evidenceofpriorlearningunlinked'] = 'Veza sa dokaza o prethodnom učenju \'{$a}\' je uklonjena.';
$string['evidence_manualoverride'] = 'Procena kompetencije je ručno podešena';
$string['evidence_manualoverrideincourse'] = 'Procena kompetencije je ručno podešena na kursu \'{$a}\'.';
$string['evidence_manualoverrideinplan'] = 'Procena kompetencije je ručno podešena u planu učenja \'{$a}\'.';
$string['invalidevidencedesc'] = 'Neispravan opis dokaza';
$string['invalidgrade'] = 'Neispravna procena';
$string['invalidpersistenterror'] = 'Greška: {$a}';
$string['invalidplan'] = 'Neispravan plan učenja';
$string['invalidtaxonomy'] = 'Neispravna taksonomija: {$a}';
$string['invalidurl'] = 'URL adresa nije ispravna. Pobrinite se da počne sa \'http://\' ili \'https://\'.';
$string['nouserplanswithcompetency'] = 'Nijedan plan za učenje ne sadrži ovu kompetenciju.';
$string['planstatusactive'] = 'Aktivan';
$string['planstatuscomplete'] = 'Ispunjen';
$string['planstatusdraft'] = 'Radna verzija';
$string['planstatusinreview'] = 'Na pregledu';
$string['planstatuswaitingforreview'] = 'Čeka na pregled';
$string['pointsrequiredaremet'] = 'Dostignut je traženi broj poena';
$string['privacy:evidence:action:complete'] = 'Završi kompetenciju ako je neocenjena';
$string['privacy:evidence:action:log'] = 'Akcija zapisa';
$string['privacy:evidence:action:override'] = 'Izmena ocene kompetencije';
$string['privacy:metadata:competency'] = 'Evidencija kompetencija';
$string['privacy:metadata:competency_coursecomp'] = 'Evidencija kompetencija vezanih za kurs';
$string['privacy:metadata:competency_coursecompsetting'] = 'Evidencija o podešavanjima kompetencija na kursu';
$string['privacy:metadata:competency_evidence'] = 'Evidencija dokaza koji utiču na stanje kompetencije';
$string['privacy:metadata:competency_framework'] = 'Evidencija okvira kompetencija';
$string['privacy:metadata:competency_modulecomp'] = 'Evidencija kompetencija povezanih sa modulom';
$string['privacy:metadata:competency_plan'] = 'Evidencija planova učenja';
$string['privacy:metadata:competency_plancomp'] = 'Evidencija kompetencija u planu učenja';
$string['privacy:metadata:competency_relatedcomp'] = 'Evidencija o odnosu između kompetencija';
$string['privacy:metadata:competency_template'] = 'Evidencija šablona plana učenja';
$string['privacy:metadata:competency_templatecohort'] = 'Evidencija o kohortama povezanim sa šablonom plana učenja';
$string['privacy:metadata:competency_templatecomp'] = 'Evidencija kompetencija u šablonu plana učenja';
$string['privacy:metadata:competency_usercomp'] = 'Evidencija stanja kompetencija korisnika';
$string['privacy:metadata:competency_usercompcourse'] = 'Evidencija stanja kompetencija korisnika na kursu';
$string['privacy:metadata:competency_usercompplan'] = 'Evidencija stanja kompetencija u planu učenja';
$string['privacy:metadata:competency_userevidence'] = 'Evidencija dokaza o prethodnom učenju';
$string['privacy:metadata:competency_userevidencecomp'] = 'Evidencija kompetencija povezanih sa dokazima o prethodnom učenju';
$string['privacy:metadata:core_comments'] = 'Komentari o planovima učenja i kompetencijama';
$string['privacy:metadata:evidence:action'] = 'Vrsta akcije preduzete sa dokazima';
$string['privacy:metadata:evidence:actionuserid'] = 'Korisnik koji izvodi akciju';
$string['privacy:metadata:evidence:desca'] = 'Opcioni parametri opisa dokaza koji se mogu prevesti';
$string['privacy:metadata:evidence:desccomponent'] = 'Komponenta opisa dokaza koji se mogu prevesti';
$string['privacy:metadata:evidence:descidentifier'] = 'Identifikator opisa dokaza koji se mogu prevesti';
$string['privacy:metadata:evidence:grade'] = 'Ocena povezana sa dokazima';
$string['privacy:metadata:evidence:note'] = 'Nelokalizovana beleška priložena uz dokaze';
$string['privacy:metadata:evidence:url'] = 'URL adresa povezana sa dokazima';
$string['privacy:metadata:plan:description'] = 'Opis plana učenja';
$string['privacy:metadata:plan:duedate'] = 'Rok završetka plana učenja';
$string['privacy:metadata:plan:name'] = 'Naziv plana učenje';
$string['privacy:metadata:plan:reviewerid'] = 'ID oznaka recenzenta plana učenja';
$string['privacy:metadata:plan:status'] = 'Status plana učenja';
$string['privacy:metadata:plan:userid'] = 'ID oznaka korisnika čiji je plan učenja';
$string['privacy:metadata:timecreated'] = 'Vreme kada je evidencija kreirana';
$string['privacy:metadata:timemodified'] = 'Vreme kada je evidencija uređivana';
$string['privacy:metadata:usercomp:grade'] = 'Ocena koja se daje za kompetenciju';
$string['privacy:metadata:usercomp:proficiency'] = 'Da li je postignuta stručnost';
$string['privacy:metadata:usercomp:reviewerid'] = 'ID oznaka recenzenta';
$string['privacy:metadata:usercomp:status'] = 'Status kompetencije';
$string['privacy:metadata:usercomp:userid'] = 'ID oznaka korisnika čiji je kompetencija';
$string['privacy:metadata:userevidence:description'] = 'Opis dokaza';
$string['privacy:metadata:userevidence:name'] = 'Naziv dokaza o prethodnom učenju';
$string['privacy:metadata:userevidence:url'] = 'URL adresa povezana sa dokazima';
$string['privacy:metadata:usermodified'] = 'Korisnik koji je kreirao ili izmenio evidenciju';
$string['privacy:path:plans'] = 'Planovi učenja';
$string['privacy:path:relatedtome'] = 'Povezano sa mnom';
$string['privacy:path:userevidence'] = 'Dokazi o prethodnom učenju';
$string['pushcourseratingstouserplans'] = 'Pomeri procene na nivou kursa u individualne planove učenja';
$string['pushcourseratingstouserplans_desc'] = 'Podrazumevana vrednost za podešavanje kursa koja služi za ažuriranje individualnih planova učenja kad se vrednuju kompetencije kursa.';
$string['syncplanscohorts'] = 'Planovi za sinhronizaciju iz kohorti šablona planova učenja';
$string['taxonomy_behaviour'] = 'Ponašanje';
$string['taxonomy_competency'] = 'Kompetencija';
$string['taxonomy_concept'] = 'Koncept';
$string['taxonomy_domain'] = 'Domen';
$string['taxonomy_indicator'] = 'Indikator';
$string['taxonomy_level'] = 'Nivo';
$string['taxonomy_outcome'] = 'Ishod';
$string['taxonomy_practice'] = 'Praksa';
$string['taxonomy_proficiency'] = 'Stručnost';
$string['taxonomy_skill'] = 'Veština';
$string['taxonomy_value'] = 'Vrednost';
$string['usercommentedonacompetency'] = '{$a->fullname} je komentarisao/la kompetenciju "{$a->competency}":

{$a->comment}

Pogledajte: {$a->url}';
$string['usercommentedonacompetencyhtml'] = '<p>{$a->fullname} je komentarisao/la kompetenciju "{$a->competency}":</p>
<div>{$a->comment}</div>
<p>Pogledajte: <a href="{$a->url}">{$a->urlname}</a>.</p>';
$string['usercommentedonacompetencysmall'] = '{$a->fullname} je komentarisao/la kompetenciju "{$a->competency}".';
$string['usercommentedonacompetencysubject'] = '{$a} je komentarisao/la kompetenciju.';
$string['usercommentedonaplan'] = '{$a->fullname} je komentarisao/la plan učenja "{$a->plan}":

{$a->comment}

Pogledajte: {$a->url}';
$string['usercommentedonaplanhtml'] = '<p>{$a->fullname} je komentarisao/la plan učenja "{$a->plan}":</p>
<div>{$a->comment}</div>
<p>Pogledajte: <a href="{$a->url}">{$a->urlname}</a>.</p>';
$string['usercommentedonaplansmall'] = '{$a->fullname} je komentarisao/la plan učenja "{$a->plan}".';
$string['usercommentedonaplansubject'] = '{$a} je komentarisao/la plan učenja.';
$string['usercompetencystatus_idle'] = 'U stanju mirovanja';
$string['usercompetencystatus_inreview'] = 'Na pregledu';
$string['usercompetencystatus_waitingforreview'] = 'Čeka na pregled';
$string['userplans'] = 'Planovi učenja';
