<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_fordson', language 'de', version '4.1'.
 *
 * @package     theme_fordson
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityiconsize'] = 'Größe des Aktivitätssymbols';
$string['activityiconsize_desc'] = 'Größe des Aktivitätssymbols anpassen';
$string['activitylinkstitle'] = 'Aktivitäten';
$string['activitylinkstitle_desc'] = 'Alle Aktivitäten des Kurses anzeigen';
$string['activitymenu'] = 'Menü "Gruppierte Aktivitäten" anzeigen';
$string['activitymenu_desc'] = 'Gruppierte Aktivitätenliste im Panel der Teilnehmer/innen und Trainer/innen. Dieses Menü zeigt eine gruppierte Liste.';
$string['advancedsettings'] = 'Erweiterte Einstellungen';
$string['alert'] = 'Homepage Benachrichtigung';
$string['alert_desc'] = 'Diese spezielle Benachrichtigung erscheint auf der Homepage';
$string['backgroundimage'] = 'Standard-Hintergrundbild';
$string['backgroundimage_desc'] = 'Hintergrundbilder für Seiten';
$string['backtotop'] = 'Zurück zum Anfang';
$string['badges'] = 'Auszeichnungen';
$string['badges_desc'] = 'Auszeichnungen für Ihre Studierenden.';
$string['blockdisplay'] = 'Block-Anzeige';
$string['blockdisplay_desc'] = 'Legt fest, wie Blöcke auf der Startseite und auf Kursseiten angezeigt werden. Fordson fügt einen dreispaltigen einklappbaren Blockbereich ein, der ausgeblendet werden kann. Wählen Sie die Boost Standard-Variante, wenn Sie Blöcke in einer Spalte auf der rechten Seite anzeigen wollen. In der Boost Standard-Variante wird der "Block hinzufügen"-Button zurück in den Navigationsvereich am linken Rand verlegt. Wir empfehlen bei der Nutzung von Boost-Seitenlayouts die Verwendung des "Einspaltigen Boost Standards".';
$string['blockdisplay_off'] = 'Einspaltiger Boost Standard';
$string['blockdisplay_on'] = 'Dreispaltiger Fordson Standard';
$string['blockwidthfordson'] = 'Kolonnenbreite fixieren';
$string['blockwidthfordson_desc'] = 'Breite der Blockspalte einstellen';
$string['blog'] = 'Adresse des Blogs';
$string['blogdesc'] = 'Geben Sie die Adresse des Blogs ein.';
$string['bodybackground'] = 'Farbe der Hintergrundseite';
$string['bodybackground_desc'] = 'Die Hauptfarbe des Hintergrundes.';
$string['brandColour'] = 'Markenfarbe';
$string['brandColour_desc'] = 'Ihre Hauptmarkenfarbe.';
$string['branddanger'] = 'Markenfarbe für Gefahr.';
$string['branddanger_desc'] = 'Markenfarbe für Gefahrenmeldungen etc.';
$string['brandemail'] = 'E-Mail-Adresse Ihrer Organisation';
$string['brandemaildesc'] = 'Die E-Mail-Adresse Ihrer Organisation erscheint in der Fusszeile.';
$string['brandinfo'] = 'Informationen zu Ihrer Marke/Schule';
$string['brandinfo_desc'] = 'Informationen zu den Farben Ihrer Marke';
$string['brandorganization'] = 'Name der Organisation';
$string['brandorganizationdesc'] = 'Der Name der Organisation erscheint im Footer.';
$string['brandphone'] = 'Telefonnummer der Organisation';
$string['brandphonedesc'] = 'Die Telefonnummer der Organisation erscheint im Footer.';
$string['brandprimary'] = 'Hauptfarbe';
$string['brandprimary_desc'] = 'Ihre Hauptfarbe.';
$string['brandsuccess'] = 'Erfolgsfarbe';
$string['brandsuccess_desc'] = 'Diese Farbei erscheint bei erfolgreichen Alarmen, erfolgreichen Rückmeldungen.';
$string['brandwarning'] = 'Warnfarbe';
$string['brandwarning_desc'] = 'Diese Farbe warnt bei Alarmen.';
$string['brandwebsite'] = 'Webseite der Organisation';
$string['brandwebsitedesc'] = 'Die Adresse der Webseite der Organisation erscheint im Footer.';
$string['breadcrumbbkg'] = 'Breadcrumb Hintergrundfarbe';
$string['breadcrumbbkg_desc'] = 'Breadcrumb Hintergrundfarbe.';
$string['cardbkg'] = 'Inhaltshintergrundfarbe';
$string['cardbkg_desc'] = 'Inhaltshintergrundfarbe';
$string['catsicon'] = 'Kategoriensymbol';
$string['catsicon_desc'] = 'Wählen Sie ein Symbol für Ihre Kursekategorien';
$string['choosereadme'] = 'Fordson unterstützt einzigartige visuelle Erfahrungen für das Boost-Design mit veränderbaren Zusatzfunktionen wie Farbauswahl oder erweiterte Homepage.';
$string['collapsibletopics'] = 'Ausklappbares Themenformat';
$string['collapsibletopics_desc'] = 'Wenn Sie das ausklappbare Themenformat installieren ( <a href="https://moodle.org/plugins/format_collapsibletopics">format_collapsibletopics</a> ), kann Fordson die Kursdarstellung mit einer Ansicht versehen, die sich besser in das Erscheinungsbild von Fordson integriert. In der Entwicklung wurde besondere Aufmerksamkeit auf die Darstellung für Nutzer/innen aller Altersklassen und Fähigkeiten gelegt.';
$string['colours_desc'] = 'Farbauswahl erlaubt es, das Look and Feel der Hauptelemente zu verändern. Wenn Sie eine andere Vorlage verwenden, müssen jegliche veränderte Farben entfernt werden, um das beste Ergebnis zu erreichen.';
$string['colours_headingsub'] = 'Farbeinstellungen';
$string['colours_settings'] = 'Farben';
$string['configtitle'] = 'Fordson';
$string['contentsettings'] = 'Inhaltsbereiche';
$string['courseactivities'] = 'Kursaktivitäten';
$string['courseblockpanelbtn'] = 'Kurs-Block-Panel';
$string['courseblockpanelbtnclose'] = 'Schließen';
$string['courseboxheight'] = 'Kursübersichtshöhe';
$string['courseboxheight_desc'] = 'Verändern Sie die Höhe der Kursliste';
$string['courseeditingcog'] = 'Zeige das standard Kurseinstellungsmenü';
$string['courseeditingcog_desc'] = 'Diese Einstellung ist verteckt, falls Sie Kursmanagement-Kacheln verwenden. Dieses Menü brauchen Sie unter Umständen, falls ein Plugin das Kursmenü benötigt, um auf Einstellungen zuzugreifen';
$string['coursehome'] = 'Kurs-Startseite';
$string['courseinfo'] = 'Kursbeschreibung';
$string['coursemanage'] = 'Kurseinstellungen';
$string['coursemanage_desc'] = 'Organisiert den ganzen Kurs';
$string['coursemanagementbutton'] = 'Kursmanagement';
$string['coursemanagementinfo'] = 'Kursmanagementkachel';
$string['coursemanagementinfodesc'] = 'Diese Einstellung aktiviert die Kursmanagementkachel. Das Kursmanagement-Menü beinhaltet damit die Kursliste und die Kursadministrations-Kachel.';
$string['coursemanagementtextbox'] = 'Kursmanagement-Nachricht';
$string['coursemanagementtextbox_desc'] = 'Fügen Sie eine Nachricht für Lehrende in der  Kursmanagement-Kachel ein.';
$string['coursemanagementtoggle'] = 'Zeige Studierenden und Lehrenden die Dashboard-Kachel';
$string['coursemanagementtoggle_desc'] = 'Diese Kachel erlaubt es Lehrenden, den Kurs einfach zu managemnt.';
$string['coursestaff'] = 'Lehrender';
$string['coursestyle1'] = 'Stil Eins';
$string['coursestyle10'] = 'Standard Moodle Kursanzeige';
$string['coursestyle2'] = 'Stil Zwei';
$string['coursestyle3'] = 'Stil Drei';
$string['coursestyle4'] = 'Stil Vier /Kurszusammenfassung';
$string['coursestyle5'] = 'Horizontaler Stil 1';
$string['coursestyle6'] = 'Horizonales Bild Hintergrund Alle Details';
$string['coursestyle7'] = 'Horizontals Bild Hintergrund Nur Titel & Trainer/in';
$string['coursestyle8'] = 'Standard Moodle Kursansicht';
$string['coursestyle9'] = 'Standard Moodle-Kursanzeige';
$string['coursetileinfo'] = 'Kurs Anzeigeoptionen';
$string['coursetileinfodesc'] = 'Mit diesen Einstellungen können Sie festlegen, wie Kurse als auch Kursbereiche auf der Startseite dargestellt werden.';
$string['coursetilestyle'] = 'Anzeige Kurskachel';
$string['coursetilestyle_desc'] = 'Bei der Anzeige von Kurskategorien können Sie zwischen Darstellungsvarianten wählen';
$string['createinfo'] = 'Button zur Kurserstellung';
$string['createinfodesc'] = 'Dieser Button erscheint auf der Seite, wenn ein Nutzer einen neuen Kurs erzeugen kann.';
$string['currentinparentheses'] = '(aktuell)';
$string['customloginheading'] = 'Angepasste Login-Seite';
$string['customlogininfo'] = 'Einstellungen für eine angepasste Login-Seite';
$string['customlogininfo_desc'] = 'Auf diese Weise können Sie eine benutzerdefinierte Anmeldeseite erstellen. Weitere Einstellungen im Design, die auf der Anmeldeseite angezeigt werden: <br>
<b> * Website-Administration > Sicherheit > Sicherheitsregeln > Anmeldung notwendig = Stellen Sie sicher, dass diese Option aktiviert ist, damit Benutzer auf Ihre benutzerdefinierte Anmeldeseite weitergeleitet werden. <br>
* Website-Administration > Darstellung > Logos > Logo = Laden Sie hier ein Bild hoch und es erscheint oberhalb des Login-Formulars. <br>
* Fordson > individuelle Bildeinstellungen > Standard-Login-Bild kann verwendet werden, um das Hintergrundbild für die Anmeldeseite zu ändern. <br>
* Fordson > Inhaltsbereiche > Homepage Alert kann verwendet werden, um oben auf der Seite einen Hinweis zu geben. </b>';
$string['dashactivityoverview'] = 'Aktivitätsübersicht';
$string['displaybottom'] = 'Zeige den Button am Ende der Seite';
$string['displaymycourses'] = 'Zeige eingeschriebene Kurse';
$string['displaymycoursesdesc'] = 'Zeige eingeschriebene Kurse in der Top-Navigationsleiste';
$string['displaythiscourse'] = '"Dieser Kurs"-Menü anzeigen';
$string['displaythiscoursedesc'] = 'Zeigt in der Navigationsleiste ein Menü an, mit dem direkt in die einzelnen Kursabschnitte gesprungen werden kann. Dies enthält Elemente, die früher im Nav-Drawer gefunden wurden.';
$string['displaytop'] = 'Zeige am Anfang der Seite';
$string['drawerbkg'] = 'Drawer für die Hintergrundfarbe';
$string['drawerbkg_desc'] = 'Drawer für die Hintergrundfarbe des Menüs';
$string['editoff'] = 'Bearbeiten ausschalten';
$string['editon'] = 'Bearbeiten einschalten';
$string['enablecategoryicon'] = 'Icons für Kurskategorien';
$string['enablecategoryicon_desc'] = 'Wenn diese Option ausgewählt wurde, werden die Kurskategorien als Icons angezeigt';
$string['enhancedmydashboard'] = 'Erweitertes Dashboard';
$string['enhancedmydashboard_desc'] = 'Wenn Sie diese Option aktivieren, wird die Dashboard-Seite so erweitert, dass alle Funktionen von Fordson enthalten sind, z.B. das einfache Registrierungsformular, Blöcke-Slider, Icon-Navigationsleiste, benutzerdefinierte Startseite, Diashow und vieles mehr.';
$string['enrollcoursecard'] = 'Einschreiben';
$string['facebook'] = 'Facebook-Adresse';
$string['facebookdesc'] = 'Geben Sie hier die Adresse der Facebook-Seite ein. (bspw. http://www.facebook.com/)';
$string['favicon'] = 'Favicon';
$string['favicon_desc'] = 'Ändert das Favicon für Fordson. Bilder mit transparentem Hintergrund und 32px Höhe sind am besten geeignet. Erlaubte Dateitypen: PNG, JPG, ICO';
$string['feature1info'] = 'Feature Eins';
$string['feature2info'] = 'Feature Zwei';
$string['feature3info'] = 'Feature Drei';
$string['featureimage'] = 'Feature-Bild';
$string['featureimage_desc'] = 'Dieses Bild erscheint mit dem Feature-Text in einer Zeile.';
$string['featureinfo_desc'] = 'Ein Feature besteht aus einem Bild und einem Text, die auf der angepassten Login-Seite in einer Zeile erscheinen. Sie müssen sowohl Bild als auch Text hinzufügen, damit das Feature angezeigt wird.';
$string['featuretext'] = 'Feature-Text';
$string['featuretext_desc'] = 'Dieser Text erscheint neben dem Feature-Bild in einer Zeile. Benutzen Sie Überschrift H4 um eine zusätzliche Überschrift im Textfeld zu erzeugen. Im Atto-Editor ist H4 "Überschrift (mittel)".';
$string['flickr'] = 'Flickr-Adresse';
$string['flickrdesc'] = 'Geben Sie hier die Adresse der Flickr-Seite ein. (bspw. http://www.flickr.com/)';
$string['footerbkg'] = 'Hintergrundfarbe Footer';
$string['footerbkg_desc'] = 'Hintergrundfarbe des Footers am unteren Seitenrand';
$string['footerdesc'] = 'Die unteren Punkte erlauben ein angepasstes Erscheinungsbild für den Footer';
$string['footerheading'] = 'Footer';
$string['footerheadingsocial'] = 'Socialmedia-Symbole';
$string['footerheadingsub'] = 'Passen Sie den Footer an.';
$string['footnote'] = 'Fußnote';
$string['footnotedesc'] = 'Editor für die Fußnote im Haupt-Footer';
$string['fploginform'] = 'Farbe Anmeldeformular';
$string['fploginform_desc'] = 'Hintergrundfarbe des Anmeldeformulars auf der angepassten Startseite.';
$string['fpsignup'] = 'Einschreiben';
$string['fptextbox'] = 'Textbox für eingeschriebene Nutzer';
$string['fptextbox_desc'] = 'Diese Textbox erscheint bei eingeschriebenen Nutzern. Sie eignet sich für Willkommensnachrichten oder Anleitungen.';
$string['fptextboxlogout'] = 'Textbox für Besucher';
$string['fptextboxlogout_desc'] = 'Diese Textbox erscheint bei Besuchern. Sie eignet sich für Willkommensnachrichten oder als Link zur Login-Seite';
$string['frontpagemycoursessorting'] = 'Startseite - Meine Kurse nach letztem Zugriff sortieren';
$string['frontpagemycoursessorting_desc'] = 'Wenn diese Option ausgewählt wird, wird der Bereich "Meine Kurse" (eingeschriebene Kurse) auf der Startseite nach dem letzten Zugriff des Nutzers sortiert. Dies überschreibt die Einstellung "Meine Kurse sortieren" unter Navigation. Wenn nicht ausgewählt, wird der Bereich auf der Startseite wie normal dargestellt.';
$string['generalcontentinfo'] = 'Allgemeine Einstellungen für die Anzeige der Inhalte';
$string['generalcontentinfodesc'] = 'Diese Optionen helfen Ihnen, die Anzeige der Inhalte anzupassen und zusätzliche Möglichkeiten des Themes Fordson zu aktivieren.';
$string['generalsettings'] = 'allgemeine Einstellungen';
$string['googleplus'] = 'Google+-Adresse';
$string['googleplusdesc'] = 'Geben Sie die Adresse Ihres Google+-Profiles ein (bspw. https://google.com)';
$string['gutterwidth'] = 'Abstände für den Inhaltsbereich';
$string['gutterwidth_desc'] = 'Mit dieser Einstellung legen Sie den linken und rechten Rand des Inhaltsbereiches fest.';
$string['headerdefaultimage'] = 'TitelStandard-Kopfbild';
$string['headerdefaultimage_desc'] = 'Standardbild für den Kurstitel';
$string['headerimagepadding'] = 'Höhe des Titelbildes';
$string['headerimagepadding_desc'] = 'Breite und Höhe des Titelbildes eines Kurses.';
$string['headerlogo'] = 'Titellogo';
$string['headerlogo_desc'] = 'Dieses Logo erscheint am Anfang einer Seite. Es benutzt das "bootrstrap responsive image scalling."';
$string['homemyclasses'] = 'Startseite Klasse';
$string['homemycomp'] = 'Startseite Kompetzenzen';
$string['homemycourses'] = 'Startseite Kurs';
$string['homemycred'] = 'Startseite Referenzen';
$string['homemylectures'] = 'Startseite Vorlesung';
$string['homemylessons'] = 'Startseite Lektion';
$string['homemymodules'] = 'Startseite Modul';
$string['homemyplans'] = 'Startseite Plan';
$string['homemyprofessionaldevelopment'] = 'Startseite PD';
$string['homemyprograms'] = 'Startseite Programm';
$string['homemytraining'] = 'Startseite Training';
$string['homemyunits'] = 'Startseite Einheit';
$string['iconnavheading'] = 'Navigationssymbol';
$string['iconnavheadingsub'] = 'Erstelle Buttons mit Symbolen für diese Seite. Auch externe Links sind möglich.';
$string['iconwidth'] = 'Webseiten-Symbolbreite';
$string['iconwidth_desc'] = 'Breite der 8 einzelnen Symbole in der Symbol-Navigationsleite.';
$string['iconwidthinfo'] = 'Einstellungen der Symbolbutton-Breite';
$string['iconwidthinfodesc'] = 'Geben Sie eine Breite der Buttons an, damit der Linktext im Button Platz findet.';
$string['ilearnsecurebrowser'] = 'Dieses Quiz wird gesichert mit dem iLearn Secure Browser (es muss ein Chromebook mit der iLearn-Appe verwendet werden, um an diesem Quiz teilzunehmen)';
$string['imagesettings'] = 'individuelle Bildeinstellungen';
$string['instagram'] = 'Instragramm-Adresse';
$string['instagramdesc'] = 'Geben Sie die Adresse Ihrer Instagrammseite ein. (bspw. http://instagram.com)';
$string['layoutinfo'] = 'Layout-Einstellungen';
$string['layoutinfodesc'] = 'Legen Sie durch die Wahl eines Designs das Seitenlayout fest.';
$string['learningcontentpadding'] = 'Seite mit Lerninhalt';
$string['learningcontentpadding_desc'] = 'Diese Einstellung gibt den Platz zwischen dem Seitenanfang und dem Kursinhalt an.';
$string['linkedin'] = 'LinkedIn-Adresse';
$string['linkedindesc'] = 'Geben Sie die Adresse Ihres LinkedIn-Profiles an. (bspw. http://linkedin.com)';
$string['loginimage'] = 'Standard-Loginbild';
$string['loginimage_desc'] = 'Hintergrundbild für die Login-Seite';
$string['loginnavicon1'] = 'Icon Eins';
$string['loginnavicon2'] = 'Icon Zwei';
$string['loginnavicon3'] = 'Icon Drei';
$string['loginnavicon4'] = 'Icon Vier';
$string['loginnavicontext'] = 'Icon-Text';
$string['loginnavicontextdesc'] = 'Text, der unter dem Icon erscheint. Für beste Ergebnisse möglichst kurz halten.';
$string['loginnavicontitletext'] = 'Icon-Title';
$string['loginnavicontitletextdesc'] = 'Text der als Titel unter dem Icon erscheint.';
$string['logintopimage'] = 'Bannerbild Login-Seite';
$string['logintopimage_desc'] = 'Dieses Bild erscheint auf der Login-Seite rechts neben dem Anmeldeformular. Ideal ist ein Logo oder Banner mit transparentem Hintergrund.';
$string['marketboxbuttoncolor'] = 'Farbe des Buttons des Werbebereichs.';
$string['marketboxbuttoncolor_desc'] = 'Die Farbe des Buttons des Werbebereichs.';
$string['marketboxcolor'] = 'Hintergrundfarbe des Werbebereichs';
$string['marketboxcolor_desc'] = 'Die Hintergrundfarbe des Werbebereichs.';
$string['marketboxcontentcolor'] = 'Hintergrundfarbe des Werbebereichinhalts';
$string['marketboxcontentcolor_desc'] = 'Die Farbe des Hintergrundes der Werbereichinhalts.';
$string['marketing1'] = 'Werbungsspot 1';
$string['marketing2'] = 'Werbungsspot 2';
$string['marketing3'] = 'Werbungsspot 3';
$string['marketing4'] = 'Werbungsspot 4';
$string['marketing5'] = 'Werbungsspot 5';
$string['marketing6'] = 'Werbungsspot 6';
$string['marketing7'] = 'Werbungsspot 7';
$string['marketing8'] = 'Werbungssport 8';
$string['marketing9'] = 'Werbungsspot 9';
$string['marketingbuttontext'] = 'Linktext';
$string['marketingbuttontextdesc'] = 'Dieser Text erscheint auf dem Button.';
$string['marketingbuttonurl'] = 'Linkadresse';
$string['marketingbuttonurldesc'] = 'Auf diese Adresse zeigt der Button.';
$string['marketingcontent'] = 'Inhalt';
$string['marketingcontentdesc'] = 'Inhalt des Werbebereichs.';
$string['marketingdesc'] = 'Dieses Design erlaubt die Aktivierung von 3 "Werbespots" unterhalb der Präsentation.';
$string['marketingheading'] = 'Werbetitel';
$string['marketingheadingsub'] = '3 Orte auf der Startseite, um Informationen und Links anzuzeigen';
$string['marketingheight'] = 'Höhe der Werbebilder';
$string['marketingheightdesc'] = 'Wenn im Werbereich Bilder eingefügt werden, kann hier ihre Höhe bestimmt werden.';
$string['marketingicon'] = 'Linksymbol';
$string['marketingicondesc'] = 'Symbol des Werbe-Buttons. Die Liste findet sich <a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">hier</a>.  Die Buchstabenfolge nach "fa-" eingeben.';
$string['marketingimage'] = 'Bild';
$string['marketingimage_desc'] = 'Hier kann ein Bild in den Werbespot eingefügt werden.';
$string['marketinginfodesc'] = 'Einstellungen zum Werbespot. Damit ein Werbespot angezeigt wird, braucht er einen Titel';
$string['marketingtitle'] = 'Titel';
$string['marketingtitledesc'] = 'Titel des Werbespots.';
$string['marketingurltarget'] = 'Linkadresse';
$string['marketingurltargetdesc'] = 'Adresse, wohin der Link zeigen soll';
$string['marketingurltargetnew'] = 'Neue Seite';
$string['marketingurltargetparent'] = 'Parent Frame';
$string['marketingurltargetself'] = 'Aktuelle Seite';
$string['markettextbg'] = 'Werbekachel Texthintergrundsfarbe';
$string['markettextbg_desc'] = 'Farbe des Hintergrundes des Textbereichs einer Werbekachel';
$string['menusettings'] = 'Einstellungsmenü';
$string['myclasses'] = 'Meine Klassen';
$string['mycomp'] = 'Meine Kompetenzen';
$string['mycourses'] = 'Meine Kurse';
$string['mycoursesinfo'] = 'Dynamische Liste der eingeschriebenen Kurse';
$string['mycoursesinfodesc'] = 'Dynamische Liste aller Kurse anzeigen, in die eine Person eingeschrieben sind. Die Liste wird in der Navigationszeile angezeigt.';
$string['mycoursetitle'] = 'Terminologie';
$string['mycoursetitledesc'] = 'Terminologie für den "Meine Kurse"-Link im Dropdown-Menü ändern.';
$string['mycred'] = 'Meine Anmeldeinformationen';
$string['mygradestext'] = 'Meine Bewertungen';
$string['mylectures'] = 'Meine Vorträge';
$string['mylessons'] = 'Meine Lektionen';
$string['mymodules'] = 'Meine Module';
$string['myplans'] = 'Meine Pläne';
$string['myprofessionaldevelopment'] = 'Mein PD';
$string['myprograms'] = 'Meine Programme';
$string['myprogresspercentage'] = '% fertig gestellt';
$string['myprogresstext'] = 'Mein Fortschritt';
$string['mytraining'] = 'Meine Übungen';
$string['myunits'] = 'Meine Einheiten';
$string['navbarcolorswitch'] = 'Navigationsleiste Farbwähler';
$string['navdrawerbtn'] = 'Navigation';
$string['navicon'] = 'Symbol';
$string['navicon1'] = 'Kursseite Symbol eins';
$string['navicon2'] = 'Kursseite Symbol zwei';
$string['navicon3'] = 'Kursseite Symbol drei';
$string['navicon4'] = 'Kursseite Symbol vier';
$string['navicon5'] = 'Kursseite Symbol fünf';
$string['navicon6'] = 'Kursseite Symbol sechs';
$string['navicon7'] = 'Kursseite Symbol sieben';
$string['navicon8'] = 'Kursseite Symbol acht';
$string['naviconbutton1textdefault'] = 'Dashboard';
$string['naviconbutton2textdefault'] = 'Kalender';
$string['naviconbutton3textdefault'] = 'Auszeichnungen';
$string['naviconbutton4textdefault'] = 'Alle Kurse';
$string['naviconbuttoncreatetextdefault'] = 'neuen Kurs anlegen';
$string['naviconbuttontext'] = 'Linktext';
$string['naviconbuttontextdesc'] = 'Dieser Text erscheint zwischen zwei Symbolen.';
$string['naviconbuttonurl'] = 'Linkadresse';
$string['naviconbuttonurldesc'] = 'Der Button wird auf diese Seite verweisen. Sie auf jede Seite verweisen, auch ausserhalb von Moodle.';
$string['navicondesc'] = 'Name des gewünschten Symbols. Die Liste findet sich unter <a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">diesem Link</a>. Einfach den Teil nach "fa-" eingeben, bspw. "star".';
$string['naviconslidedesc'] = 'Vorgeschlagener Symboltext: arrow-circle-down oder wählen Sie aus <a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">dieser Liste</a>.';
$string['noenrolments'] = 'Sie haben zur Zeit keine Einschreibungen';
$string['nomycourses'] = 'Sie sind in keinem Kurs eingeschrieben.';
$string['pagelayout'] = 'Layout-Auswahl';
$string['pagelayout1'] = 'Standard Boost-Layout';
$string['pagelayout2'] = 'Volle Breite / Kopfbereich mit Bild';
$string['pagelayout3'] = 'Zentrierter Inhalt / Überlappendes Bild im Kopfbereich';
$string['pagelayout4'] = 'Zentrierter Inhalt / Bild Kopfbereich als Hintergrundbild (ganzer Bildschirm)';
$string['pagelayout5'] = 'Standard Boost Layout / Bild Kopfbereich im Kasten Kurstitel';
$string['pagelayout_desc'] = 'Wählen Sie aus den folgenden Layouts.  <a href="#" target="_new">In diesem Google Doc</a>finden Sie eine Beschreibung zu jedem Layout.';
$string['pinterest'] = 'Pinterest-Adresse';
$string['pinterestdesc'] = 'Geben Sie die Adresse Ihrer Pinterestseite an. (bspw. http://pinterest.com/)';
$string['pluginname'] = 'Fordson';
$string['preset'] = 'Designvorlage';
$string['preset_desc'] = 'Wählen Sie eine Vorlage aus, um das Design zu verändern.';
$string['presetadjustmentsettings'] = 'Preset-Anpassungen';
$string['presetfiles'] = 'Zusätzliche Designvorlagen';
$string['presetfiles_desc'] = 'Vorlagen können dazu benutzt werden, das Erscheinungsbild des Designs massiv zu verändern. Siehe https://docs.moodle.org/dev/Boost_Presets für zusätzliche Information.';
$string['presets_settings'] = 'Vorlage';
$string['privacy:metadata'] = 'Das Fordson-Theme speichert keine nutzerbezogenen Daten.';
$string['qbank'] = 'Fragensammlung';
$string['qbank_desc'] = 'Erstellen und Organisieren von Quizfragen';
$string['rawscss'] = 'Reines SCSS';
$string['rawscss_desc'] = 'Nutzen Sie dieses Feld für zusätzlichen SCSS-Code. Dieser wird am Ende des Style Sheets abgelegt.';
$string['rawscsspre'] = 'ursprüngliches SCSS';
$string['rawscsspre_desc'] = 'In diesem Feld kann zusätzlicher SCSS-Code eingefügt werden, dieser wird vor allem anderen eingefügt. Normalerweise wird dies gebraucht, um Variablen zu definieren';
$string['region-fp-a'] = 'Spalte A';
$string['region-fp-b'] = 'Spalte B';
$string['region-fp-c'] = 'Spalte C';
$string['region-side-pre'] = 'rechts';
$string['section_mods'] = 'Module:';
$string['sectionlayout'] = 'Auswahl Abschnitts-Stil';
$string['sectionlayout1'] = 'Boost Standard';
$string['sectionlayout2'] = 'Notizkarten';
$string['sectionlayout3'] = 'Registerkarten';
$string['sectionlayout4'] = 'Clipboard';
$string['sectionlayout5'] = 'Einfacher Kasten';
$string['sectionlayout6'] = 'Schicker Abschnittstitel';
$string['sectionlayout7'] = 'Lerner Universität';
$string['sectionlayout8'] = 'Lerner Unternehmen';
$string['sectionlayout_desc'] = 'Wahlen Sie aus den folgenden Themen-/Wochen-Abschnittsstilen. <a href="#" target="_new">In diesem Google Doc</a> finden Sie eine Beschreibung für jeden Stil.';
$string['setting_navdrawersettings'] = 'Einstellungen Navigation';
$string['setting_navdrawersettings_desc'] = 'Ermöglicht die Boost Navigation. Fordson benötigt die Boost Navigation nicht unbedingt. Wir haben Sie durch ein Menü mit Dropdown-Liste ersetzt. Sie können die Boost Navigation mit dieser Einstellung wieder aktivieren.';
$string['showblockregions'] = 'Zusätzliche Blöcke auf der Startseite anzeigen.';
$string['showblockregions_desc'] = 'Drei weitere Blockbereiche auf der Startseite einschalten. Diese erscheinen direkt unter der Navigationsleiste.';
$string['showcourseadminstudents'] = 'Teilnehmern Kurseinstellungen zeigen';
$string['showcourseadminstudents_desc'] = 'Dies zeigt den Teilnehmern den Bereich "Kurseinstellungen". Dies ist erforderlich, wenn sich die Teilnehmer selbst aus dem Kurs abmelden können sollen.';
$string['showcourseheaderimage'] = 'Zeige Kursbilder';
$string['showcourseheaderimage_desc'] = 'Erlaubt dem Lehrer das Headerbild des Kurses zu verändern.';
$string['showcustomlogin'] = 'Angepasster Login';
$string['showcustomlogin_desc'] = 'Sie müssen das einschalten, um die folgenden Einstellungen zu aktivieren.';
$string['showloginform'] = 'Zeige das Login-Fenster';
$string['showloginform_desc'] = 'Entferne diese Einstellung um das angepasste Loginfenster auf der Startseite von eingeloggten Nutzern zu verbergen';
$string['shownavclosed'] = 'Navigation drawer ist standardmässig geschlossen';
$string['shownavclosed_desc'] = 'Zeige den Navigation drawer standardmässig komprimiert.';
$string['shownavdrawer'] = 'Standardnavigation anzeigen.';
$string['shownavdrawer_desc'] = 'In Fordson wird die Standardnavigation durch das Dropdown-Menü für die Kursnavigation nicht zwingend benötigt. Wenn Sie die Standardnavigation doch verwenden wollen/müssen, können Sie sie hiermit reaktivieren.';
$string['showslideshow'] = 'Aktiviere die Präsentation';
$string['showslideshow_desc'] = 'Wähle diese Option um die Präsentationsfunktion zu aktivieren';
$string['showstudentcompletion'] = 'Zeige den Fortschrittsanzeiger';
$string['showstudentcompletion_desc'] = 'Zeige den Studierendenfortschritt radial im Studierendendashboard.';
$string['showstudentgrades'] = 'Zeige Studierendenbewertung';
$string['showstudentgrades_desc'] = 'Zeige die Studierendenbewertung im Studierendendashboard.';
$string['siteadminquicklink'] = 'Webseitenadministration';
$string['skype'] = 'Skype-Konto';
$string['skypedesc'] = 'Geben Sie Ihren Skype Benutzername ein';
$string['slide1info'] = 'Folie 1';
$string['slide1infodesc'] = 'Details Folie 1.';
$string['slide2info'] = 'Folie 2';
$string['slide2infodesc'] = 'Details Folie 2.';
$string['slide3info'] = 'Folie 3';
$string['slide3infodesc'] = 'Details Folie 3.';
$string['slidecontent'] = 'Folienbeschreibung';
$string['slidecontent_desc'] = 'Füge eine Beschreibung für die Folie hinzu.';
$string['slideimage'] = 'Folienbild';
$string['slideimage_desc'] = 'Füge ein Hintergrundbild für diese Folie hinzu.';
$string['sliderinfo'] = 'Spezieller Slide Icon Button';
$string['sliderinfodesc'] = 'Dieser Button zeigt/versteckt eine spezielle Textbox, welche aus der Navigationszeile ausfährt. Dies ist ideal, um Kurse anzukündigen, Hilfe anzubieten oder anderes darzustellen';
$string['slideshowheight'] = 'Höhe der Präsentation';
$string['slideshowheight_desc'] = 'Einstellen der Höhe der Präsentation.';
$string['slideshowsettings'] = 'Präsentation';
$string['slidetextbox'] = 'Präsentationstextbox.';
$string['slidetextbox_desc'] = 'Der Inhalt dieser Textbox wird dargestellt, wenn der Slide-Button angewählt wird.';
$string['slidetitle'] = 'Folientitel';
$string['slidetitle_desc'] = 'Fügen Sie einen Folientitel hinzu.';
$string['sociallink'] = 'Eigenen Social Link';
$string['sociallinkdesc'] = 'Geben Sie die Adresse eines eigenen Sozialen Netzwerks an.';
$string['sociallinkicon'] = 'Linksymbol';
$string['sociallinkicondesc'] = 'Geben Sie einen Font-Awesome-Namen für das Symbol Ihres Links ein. Die komplette Liste findet sich unter http://fontawesome.io/icons/.';
$string['socialnetworks'] = 'Soziale Netzwerke';
$string['studentdashboardtextbox'] = 'Nachrichten des Studierenden Dashboards';
$string['studentdashboardtextbox_desc'] = 'Nachricht für Teilnehmer/innen hinzufügen. Diese Nachricht wird Teilnehmer/innen im Dashboard auf jeder Kursseite angezeigt.';
$string['studentdashbutton'] = 'Dieser Kurs';
$string['textcontentinfo'] = 'Benutzerdefinierte Inhalte';
$string['textcontentinfodesc'] = 'Benutzen Sie die Textboxen, um benutzerdefinierte Informationen für Ihre Nutzer einzufügen.';
$string['thiscourse'] = 'Dieser Kurs';
$string['thismyclasses'] = 'Diese Klasse';
$string['thismycomp'] = 'Diese Kompetenz';
$string['thismycourses'] = 'Dieser Kurs';
$string['thismycred'] = 'Diese Anmeldeinformation';
$string['thismylectures'] = 'Dieser Vortrag';
$string['thismylessons'] = 'Diese Lektion';
$string['thismymodules'] = 'Dieses Modul';
$string['thismyplans'] = 'Dieser Plan';
$string['thismyprofessionaldevelopment'] = 'Dieser PD';
$string['thismyprograms'] = 'Dieses Programm';
$string['thismytraining'] = 'Diese Übung';
$string['thismyunits'] = 'Diese Einheit';
$string['titletooltip'] = 'Kurstitel Tooltipp';
$string['titletooltip_desc'] = 'Wenn Sie den Kurstitel kürzen, können Sie Tooltipps verwenden, um den ganzen Kurstitel anzuzeigen.';
$string['togglemarketing'] = 'Position der Werbekachel';
$string['togglemarketing_desc'] = 'Ort festlegen, wo die Werbekachel dargestellt wird.';
$string['topnavbarbg'] = 'Top-Navigationsleiste';
$string['topnavbarbg_desc'] = 'Hintergrundfarbe für die Top-Navigationsleiste';
$string['trimsummary'] = 'Kurszusammenfassung kürzen';
$string['trimsummary_desc'] = 'Geben Sie die Anzahl der Zeichen ein, um die Kürzung der Kurszusammenfassung einzustellen.';
$string['trimtitle'] = 'Länge des gekürzten Kurstitels';
$string['trimtitle_desc'] = 'Anzahl der Zeichen angeben, um die Kürzung des Kurstitels einzustellen.';
$string['tumblr'] = 'Tumblr-Adresse';
$string['tumblrdesc'] = 'Adresse Ihres Tumblrs eingeben. (bspw. http://tumblr.com)';
$string['twitter'] = 'Twitter-Adresse';
$string['twitterdesc'] = 'Geben Sie die Adresse Ihres Twitterfeeds ein. (bspw. http://twitter.com)';
$string['userlinks'] = 'Nutzer-Links';
$string['userlinks_desc'] = 'Organisieren Sie Ihre Lernenden.';
$string['viewsectionmodules'] = 'Elemente anzeigen';
$string['vimeo'] = 'Vimeo-Adresse';
$string['vimeodesc'] = 'Adresse des Vimeo-Kanals eingeben. (bspw. http://vimeo.com)';
$string['vk'] = 'Vkontakte-Adresse';
$string['vkdesc'] = 'Adresse der Vkontakte-Seite eingeben. (bspw. http://www.vk.com)';
$string['website'] = 'Webseite-Adresse';
$string['websitedesc'] = 'Adresse der Webseite eingeben';
$string['youtube'] = 'Youtube-Adresse';
$string['youtubedesc'] = 'Adresse des Youtube-Kanals eingeben. (bspw. http://youtube.com)';
