<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'scheduler', language 'de', version '4.1'.
 *
 * @package     scheduler
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Aktion';
$string['actions'] = 'Aktionen';
$string['addappointment'] = 'Teilnehmer/in hinzufügen';
$string['addcommands'] = 'Zeitfenster hinzufügen';
$string['addondays'] = 'Termine hinzufügen am';
$string['addsession'] = 'Sich wiederholende Zeitfenster hinzufügen';
$string['addsingleslot'] = 'Einzelnes Zeitfenster hinzufügen';
$string['addslot'] = 'Sie können jederzeit zusätzliche Zeitfenster hinzufügen.';
$string['addstudenttogroup'] = 'Teilnehmer/in zur Gruppe hinzufügen';
$string['allappointments'] = 'Alle Termine';
$string['allononepage'] = 'Alle Zeitfenster auf einer Seite';
$string['allowgroup'] = 'Einzelnes Zeitfenster (mit Klick änderbar)';
$string['alreadyappointed'] = 'Kein Termin gelegt. Das Terminfenster ist bereits ausgebucht.';
$string['appointagroup_help'] = 'Wählen Sie, ob Sie den Termin nur für sich selbst oder für eine ganze Gruppe festlegen.';
$string['appointfor'] = 'Termin festlegen für';
$string['appointforgroup'] = 'Termine vereinbaren für: {$a}';
$string['appointingstudent'] = 'Termin für Zeitfenster';
$string['appointingstudentinnew'] = 'Termin für neues Zeitfenster';
$string['appointment'] = 'Termin';
$string['appointmentmode'] = 'Modus wählen';
$string['appointmentmode_help'] = '<p>Sie können hier zwischen einigen Varianten wählen, wie Verabredungen getroffen werden können.</p>
<p><ul>
<li><strong>"<emph>n </emph>Termin(e) festlegen in diesem Planer": </strong>Teilnehmer/innen können nur eine feste Anzahl von Terminen in dieser Aktivität buchen. Selbst wenn die/der Trainer/in sie als "gesehen" markiert, wird es den die/den Teilnehmern/innen nicht erlaubt, weitere Treffen zu buchen. Der einzige Weg, die Fähigkeit einer/eines Teilnehmer/in zum Buchen zurückzusetzen ist, die alten "gesehen" Einträge zu löschen.</li>
<li><strong>"<emph>n </emph>Termin(e) festlegen auf ein Mal": </strong>Teilnehmer/innen können eine feste Anzahl von Terminen buchen. Sobald das Treffen vorbei ist und die/der Trainer/in die/den Teilnehmer/in als "gesehen" markiert, kann die/der Teilnehmer/in weitere Termine buchen. Doch die/der Teilnehmer/in ist zu jedem Zeitpunkt auf <emph>n</emph> "offene" (noch nicht gesehen) Termine beschränkt.
</li>
</ul>
</p>';
$string['appointmentno'] = 'Termin {$a}';
$string['appointmentnote'] = 'Termin-Bemerkungen (für Teilnehmer/in sichtbar)';
$string['appointments'] = 'Termine';
$string['appointmentsgrouped'] = 'Termine nach Zeitfenstern';
$string['appointmentsummary'] = 'Termin am {$a->startdate} von {$a->starttime} bis {$a->endtime} mit {$a->teacher}';
$string['appointsolo'] = 'nur mich';
$string['appointsomeone'] = 'Neuen Termin hinzufügen';
$string['areaappointmentnote'] = 'Dateien in Termin-Bemerkungen';
$string['areaslotnote'] = 'Dateien in Zeitfenster-Bemerkungen';
$string['areateachernote'] = 'Dateien in vertraulichen Bemerkungen';
$string['attendable'] = 'Wahrzunehmen';
$string['attendablelbl'] = 'Gesamtzahl für die Terminplanung';
$string['attended'] = 'Wahrgenommen';
$string['attendedlbl'] = 'Anzahl Teilnehmer/innen, die wahrgenommen haben';
$string['attendedslots'] = 'Wahrgenommene Zeitfenster';
$string['availableslots'] = 'Verfügbare Zeitfenster';
$string['availableslotsall'] = 'Alle Zeitfenster';
$string['availableslotsnotowned'] = 'Ohne Person';
$string['availableslotsowned'] = 'Mit Person';
$string['bookaslot'] = 'Zeitfenster buchen';
$string['bookingdetails'] = 'Details der Buchung';
$string['bookingformoptions'] = 'Buchungsformular und von Teilnehmer/innen bereitgestellte Daten';
$string['bookinginstructions'] = 'Buchungsanleitung';
$string['bookinginstructions_help'] = 'Dieser Text wird den Teilnehmer/innen vor der Buchung angezeigt. Der Text kann anleiten, wie das optionale Mitteilungsfeld ausgefüllt wird oder welche Dateien hochgeladen werden sollen.';
$string['bookslot'] = 'Zeitfenster buchen';
$string['bookwithteacher'] = 'Trainer/in';
$string['bookwithteacher_help'] = 'Trainer/in für den Termin wählen';
$string['break'] = 'Pause zwischen Zeitfenstern';
$string['breaknotnegative'] = 'Die Dauer der Pause darf nicht negativ sein-';
$string['canbook1appointment'] = 'Sie können einen weiteren Termin in diesem Planer buchen.';
$string['canbooknappointments'] = 'Sie können {$a} Termine in diesem Planer buchen.';
$string['canbooknofurtherappointments'] = 'Ihre Buchung war erfolgreich. Sie können keine weiteren Termine in diesem Planer buchen.';
$string['canbooksingleappointment'] = 'Sie können einen Termin in diesem Planer buchen.';
$string['canbookunlimitedappointments'] = 'Sie können eine beliebige Anzahl von Terminen in diesem Planer buchen.';
$string['cancelbooking'] = 'Buchung abbrechen';
$string['chooseexisting'] = 'Vorhandenes wählen';
$string['choosingslotstart'] = 'Anfangszeit wählen';
$string['choosingslotstart_help'] = 'Wählen (oder ändern) Sie die Startzeit des Termins. Falls dieser Termin mit anderen Zeitfenstern kollidiert, werden Sie gefragt, ob dieses Zeitfenster alle kollidierenden Termine ersetzen soll. Beachten Sie, dass die Parameter des neuen Zeitfensters alle bisherigen Einstellungen überschreiben werden.';
$string['comments'] = 'Kommentare';
$string['complete'] = 'Gebucht';
$string['confirmbooking'] = 'Buchung bestätigen';
$string['confirmdelete-all'] = 'Dies wird <strong>alle</strong> Zeitfenster in diesem Planer löschen. Eine Wiederherstellung ist nicht möglich. Wirklich löschen?';
$string['confirmdelete-mine'] = 'Dies wird alle Ihre Zeitfenster in diesem Planer löschen. Eine Wiederherstellung ist nicht möglich. Wirklich löschen?';
$string['confirmdelete-myunused'] = 'Dies wird alle Ihre ungenutzten Zeitfenster in diesem Planer löschen. Eine Wiederherstellung ist nicht möglich. Wirklich löschen?';
$string['confirmdelete-one'] = 'Zeitfenster löschen?';
$string['confirmdelete-selected'] = 'Dies wird die gewählten Zeitfenster löschen. Eine Wiederherstellung ist nicht möglich. Wirklich löschen?';
$string['confirmdelete-unused'] = 'Dies wird alle ungenutzten Zeitfenster in diesem Planer löschen. Eine Wiederherstellung ist nicht möglich. Wirklich löschen?';
$string['confirmrevoke'] = 'Alle Termine dieses Zeitfensters absagen?';
$string['conflictingslots'] = 'Das Zeitfenster für {$a} konnte nicht angelegt werden. Konflikte:';
$string['conflictlocal'] = '{$a->datetime} ({$a->duration} Minuten) in diesem Planer';
$string['conflictremote'] = '{$a->datetime} ({$a->duration} Minuten) in Kurs {$a->courseshortname}, Planer {$a->schedulername}';
$string['contentformat'] = 'Format';
$string['contentformat_help'] = '<p>Es gibt drei grundlegende Optionen für das Exportformat,
      die sich darin unterscheiden, wie Zeitfenster mit mehreren Terminen gehandhabt werden.
      <dl>
         <dt>Eine Zeile pro Zeitfenster:</dt>
         <dd>Die Ausgabedatei wird eine Zeile pro Zeitfenster enthalten. Wenn ein
                  Zeitfenster mehrere Termine enthält, wird anstelle der Teilnehmernamen o.Ä. eine Markierung "(mehrere)" angezeigt.
        </dd>
        <dt>Eine Zeile pro Termin:</dt>
        <dd>Die Ausgabedatei wird eine Zeile für jeden Termin enthalten. Wenn ein
                 Zeitfenster mehrere Termine enthält, wird das Zeitfenster mehrfach in
                 der Liste erscheinen (mit Wiederholung der Daten des Zeitfensters).
        </dd>
        <dt>Termine nach Zeitfenster gruppiert:</dt>
        <dd>Alle Termine eines Zeitfensters werden zusammen gruppiert und erhalten
                 eine Kopfzeile vorangestellt, die das entsprechende Zeitfenster anzeigt.
                 Das funktioniert potenziell nicht gut zusammen mit einer CSV-Ausgabe,
                 da die Anzahl Spalten nicht konstant ist.</dd>
     </dl>
    Sie können die Effekt dieser Optionen durch Anklicken des "Vorschau"-Buttons erkunden.</p>';
$string['copytomyself'] = 'Kopie an mich';
$string['course'] = 'Kurs';
$string['createexport'] = 'Exportdatei erstellen';
$string['csvfieldseparator'] = 'Trennzeichen für CSV-Datei';
$string['csvformat'] = 'CSV';
$string['cumulatedduration'] = 'Summierte Dauer der Termine';
$string['datatoinclude'] = 'Einzufügende Daten';
$string['datatoinclude_help'] = 'Wählen Sie die Felder für den Export. Jedes Feld wird als eine Spalte in der Ausgabedatei angezeigt.';
$string['date'] = 'Datum';
$string['datelist'] = 'Übersicht';
$string['defaultslotduration'] = 'Standardmäßiges Zeitfenster';
$string['defaultslotduration_help'] = 'Die standardmäßige Dauer (in Minuten) der Zeitfenster, die Sie einrichten';
$string['deleteallslots'] = 'Alle Zeitfenster löschen';
$string['deleteallunusedslots'] = 'Unbenutzte Zeitfenster löschen';
$string['deletecommands'] = 'Zeitfenster löschen';
$string['deletedconflictingslots'] = 'Für das Zeitfenster am {$a} wurden folgende kollidierende Zeitfenster gelöscht:';
$string['deletemyslots'] = 'Alle meine Zeitfenster löschen';
$string['deleteonsave'] = 'Termin löschen (sobald das Formular gespeichert wird)';
$string['deleteselection'] = 'Ausgewählte Zeitfenster löschen';
$string['deletetheseslots'] = 'Diese Zeitfenster löschen';
$string['deleteunusedslots'] = 'Meine unbenutzten Zeitfenster löschen';
$string['department'] = 'Von wo?';
$string['disengage'] = 'Meine Termine absagen';
$string['displayfrom'] = 'Zeitfenster für Teilnehmer/innen sichtbar ab';
$string['distributetoslot'] = 'An die ganze Gruppe verteilen';
$string['divide'] = 'In Zeitfenster aufteilen?';
$string['duration'] = 'Dauer';
$string['durationrange'] = 'Die Dauer der Zeitfensters muss zwischen {$a->min} und {$a->max} Minuten sein.';
$string['editbooking'] = 'Buchung bearbeiten';
$string['email_applied_html'] = '<p>Ein Termin wurde beantragt am {$a->date} um {$a->time},<br/> von <a href="{$a->attendee_url}">{$a->attendee}</a> für den Kurs:

<p>{$a->course_short}: <a href="{$a->course_url}">{$a->course}</a></p>

<p>über den Planer "<em><a href="{$a->scheduler_url}">{$a->module}</a></em>" auf der Website: <a href="{$a->site_url}">{$a->site}</a>.</p>';
$string['email_applied_plain'] = 'Ein Termin wurde beantragt am {$a->date} um {$a->time},<br/> von {$a->attendee} ({$a->attendee_url}) für den Kurs:

{$a->course_short}: {$a->course}

über den Planer "{$a->module}" auf der Website: {$a->site}.';
$string['email_applied_subject'] = '{$a->course_short}: Neuer Termin';
$string['email_cancelled_html'] = '<p>Ihr Termin am <strong>{$a->date}</strong> um <strong>{$a->time}</strong>,<br/> mit <strong><a href="{$a->attendee_url}">{$a->attendee}</a></strong> für den Kurs:</p>

<p><strong>{$a->course_short} : <a href="{$a->course_url}">{$a->course}</a></strong></p>

<p>im Planer "<em>{$a->module}</em>" auf der Website: <strong><a href="{$a->site_url}">{$a->site}</a></strong></p>

<p><strong><span class="error">wurde abgesagt oder verschoben</span></strong>.</p>';
$string['email_cancelled_plain'] = 'Ihr Termin am {$a->date} um {$a->time} mit der/m Teilnehmer/in {$a->attendee} für den Kurs:

{$a->course_short}: {$a->course}

im Planer mit dem Titel "{$a->module}" auf der Website: {$a->site}

wurde abgesagt oder verschoben.';
$string['email_cancelled_subject'] = '{$a->course_short}: Termin abgesagt oder verschoben';
$string['email_invite_html'] = '<p>Wählen Sie bitte ein Zeitfenster für einen Termin unter:</p> <p>{$a->scheduler_url}</p>';
$string['email_invite_subject'] = 'Einladung: {$a->module}';
$string['email_invitereminder_html'] = '<p>Dies ist eine Erinnerung, dass Sie noch keinen Termin vereinbart haben. Wählen Sie bitte möglichst bald ein Zeitfenster unter:</p> <p>{$a->scheduler_url}</p>';
$string['email_invitereminder_subject'] = 'Erinnerung: {$a->module}';
$string['email_reminder_html'] = '<p>Sie haben einen bevorstehenden Termin am <strong>{$a->date}</strong> von <strong>{$a->time}</strong> bis <strong>{$a->endtime}</strong><br/> mit <strong><a href="{$a->attendant_url}">{$a->attendant}</a></strong>.</p>

<p>Ort: <strong>{$a->location}</strong></p>';
$string['email_reminder_plain'] = 'Sie haben einen bevorstehenden Termin am {$a->date} von {$a->time} bis {$a->endtime} mit {$a->attendant}.

Ort: {$a->location}';
$string['email_reminder_subject'] = '{$a->course_short}: Terminerinnerung';
$string['email_teachercancelled_html'] = '<p>Ihr Termin am <strong>{$a->date}</strong> um <strong>{$a->time}</strong>,<br/>
mit dem {$a->staffrole} <strong><a href="{$a->attendant_url}">{$a->attendant}</a></strong> für den Kurs:</p>

<p><strong>{$a->course_short}: <a href="{$a->course_url}">{$a->course}</a></strong></p>

<p>im Planer "<em>{$a->module}</em>" auf der Website: <strong><a href="{$a->site_url}">{$a->site}</a></strong></p>

<p><strong><span class="error">wurde abgesagt</span></strong>. Bitte wählen Sie ein neues Zeitfenster.</p>';
$string['email_teachercancelled_plain'] = 'Ihr Termin am {$ a->date} um {$ a->time} mit dem {$a->staffrole} {$a->attendant} für den Kurs:

{$a->course_short}: {$a->course}

im Planer "{$a->module}" auf der Website: {$a->site}

wurde abgesagt. Bitte wählen Sie ein neues Zeitfenster.';
$string['email_teachercancelled_subject'] = '{$a->course_short}: Termin von der/vom Trainer/in abgesagt';
$string['emailreminder'] = 'Per E-Mail eine Erinnerung schicken';
$string['emailreminderondate'] = 'Per E-Mail eine Erinnerung schicken am';
$string['end'] = 'Ende';
$string['enddate'] = 'Wiederhole Zeitfenster bis';
$string['event_appointmentlistviewed'] = 'Planer Terminliste angezeigt';
$string['event_bookingadded'] = 'Planer Buchung hinzugefügt';
$string['event_bookingformviewed'] = 'Planer Buchungsformular angezeigt';
$string['event_bookingremoved'] = 'Planer Buchung entfernt';
$string['event_slotadded'] = 'Planer Zeitfenster hinzugefügt';
$string['event_slotdeleted'] = 'Planer Zeitfenster gelöscht';
$string['everyone'] = 'alle';
$string['excelformat'] = 'Excel';
$string['exclusive'] = 'Exklusiv';
$string['exclusivity'] = 'Exklusivität';
$string['exclusivity_help'] = '<p>Sie können die maximale Anzahl von Teilnehmer/innen festlegen, die sich für ein bestimmtes Zeitfenster einschreiben können.</p>
<p>Mit dem Wert 1 (Standard) kann das Zeitfenster nur für einzelne Teilnehmer/innen gebucht werden. Mit einem anderen Wert (z.B. etwa 3) kann das Zeitfenster von mehreren Teilnehmer/innen (bis zu 3) gebucht werden.</p>
<p>Wenn die Option deaktiviert ist, kann das Zeitfenster ohne Einschränkungen gebucht werden und nie als "Voll" angesehen.</p>';
$string['exclusivityoverload'] = 'Das Zeitfenster hat {$a} gebuchte Teilnehmer/innen, mehr als durch diese Einstellung erlaubt.';
$string['exclusivitypositive'] = 'Die Anzahl der Teilnehmer/innen pro Zeitfenster muss 1 oder mehr sein.';
$string['explaingeneralconfig'] = 'Diese Einstellungen können nur für die gesamte Moodle-Plattform gemacht werden.';
$string['export'] = 'Export';
$string['exporthdr'] = 'Zeitfenster und Termine exportieren';
$string['exporttimerange'] = 'Zeitspanne';
$string['exporttimerangeall'] = 'Zukünftige und vergangene Zeitfenster';
$string['exporttimerangefuture'] = 'Nur zukünftige Zeitfenster';
$string['exporttimerangepast'] = 'Nur vergangene Zeitfenster';
$string['field-appointmentnote'] = 'Terminbemerkung (für Teilnehmer/in)';
$string['field-attended'] = 'Teilgenommen';
$string['field-date'] = 'Datum';
$string['field-endtime'] = 'Endzeit';
$string['field-filecount'] = 'Anzahl von hochgeladenen Dateien';
$string['field-grade'] = 'Bewertung';
$string['field-groupsmulti'] = 'Gruppen (mehrere Spalten)';
$string['field-groupssingle'] = 'Gruppen';
$string['field-groupssingle-label'] = 'Gruppen (mehrere Spalten)';
$string['field-location'] = 'Ort';
$string['field-maxstudents'] = 'Max. Teilnehmer/innen';
$string['field-slotnotes'] = 'Notizen Zeitfenster';
$string['field-starttime'] = 'Startzeit';
$string['field-studentemail'] = 'E-Mail-Adresse';
$string['field-studentfirstname'] = 'Vorname';
$string['field-studentfullname'] = 'Voller Name';
$string['field-studentidnumber'] = 'Teilnehmer-ID';
$string['field-studentlastname'] = 'Nachname';
$string['field-studentnote'] = 'Mitteilung von Teilnehmer/in';
$string['field-studentusername'] = 'Nutzername';
$string['field-teachernote'] = 'Vertrauliche Bemerkung (nur Trainer/innen)';
$string['fileformat'] = 'Dateiformat';
$string['fileformat_help'] = 'Die folgenden Dateiformate sind verfügbar:
  <ul>
    <li>Komma-getrennte Werte (CSV) als Textdatei. Der Separator, standardmäßig ein Komma, kann unten ausgewählt werden.
          CSV-Dateien können von den meisten Tabellenkalkulationen geöffnet werden;</li>
   <li>Microsoft Excel Format (Excel 2007);</li>
   <li>Open Document Tabellenkalkulation (ODS);</li>
   <li>HTML Format - eine Webseite, die die Ausgabetabelle anzeigt und die über
         die Browser-Funktionen gedruckt werden kann;</li>
   <li>PDF Dokument. Sie können zwischen Hoch- und Querformat auswählen.</li>
   </ul>';
$string['finalgrade'] = 'Schlussbewertung';
$string['firstslotavailable'] = 'Das erste Zeitfenster öffnet: {$a}';
$string['forbidgroup'] = 'Gruppen-Zeitfenster (mit Klick änderbar)';
$string['forcewhenoverlap'] = 'Bei Überlappung erzwingen';
$string['forcewhenoverlap_help'] = '<h3>Erstellung eines Zeitfenster falls Zeitfenster überlappen</h3>
<p>Diese Einstellung legt fest, wie mit neuen Zeitfenstern umgegangen werden soll, falls sie sich mit anderen, bestehenden Zeitfenstern überlappen.</p>
<p>Wenn aktiviert, wird das bestehenden überlappende Zeitfenster gelöscht und ein neues Zeitfenster wird erstellt.</p>
<p>Wenn deaktiviert, wird das bestehende überlappende Zeitfenster beibehalten und ein neues Zeitfenster wird <em>nicht</em> erstellt.</p>';
$string['forcewhenoverlap_link'] = 'mod/scheduler/conflict';
$string['forcourses'] = 'Teilnehmer/innen in Kursen auswählen';
$string['friday'] = 'Freitag';
$string['generalconfig'] = 'Allgemeine Konfiguration';
$string['grade'] = 'Bewertung';
$string['gradeingradebook'] = 'Bewertung in Bewertungen';
$string['gradingstrategy'] = 'Bewertungsstrategie';
$string['gradingstrategy_help'] = 'In einem Planer, in welchem Teilnehmer/innen mehrere Treffen haben können, wählen Sie, wie die Bewertung aggregiert wird.
    Die Bewertungen können entweder <ul><li>die durchschnittliche Bewertung oder</li><li>die beste Bewertung</li></ul> welche die/der Teilnehmer/in erreicht hat, anzeigen.';
$string['group'] = 'Gruppe';
$string['groupbookings'] = 'Buchung in Gruppen';
$string['groupbookings_help'] = 'Erlaubt Teilnehmer/innen ein Zeitfenster für ihre gesamte Gruppe zu buchen.
(Beachten Sie, dass diese Einstellung losgelöst ist vom "Gruppenmodus", welcher die Sichtbarkeit der Zeitfenster, die die Teilnehmer/innen sehen können, kontrolliert.)';
$string['groupbreakdown'] = 'Nach Gruppengröße';
$string['groupmodeyourgroups'] = 'Gruppenmodus: {$a->groupmode}. Nur Teilnehmer/innen von {$a->grouplist} können Termine auswählen.';
$string['groupmodeyourgroupsempty'] = 'Gruppenmodus: {$a->groupmode}. Sie sind nicht in einer Gruppe, daher können keine Termine mit Ihnen vereinbart werden.';
$string['groupscheduling'] = 'Gruppeneinschreibung aktivieren';
$string['groupscheduling_desc'] = 'Kompletten Gruppen gemeinsame Terminplanung erlauben.
(Der Gruppenmodus für diese Aktivität muss auf Sichtbare oder Getrennte Gruppen gestellt sein.)';
$string['groupsession'] = 'Gruppentermin';
$string['groupsize'] = 'Gruppengröße';
$string['guardtime'] = 'Änderungssperre ab';
$string['guardtime_help'] = 'Die Änderungssperre verhindert, dass Teilnehmer/innen ihre Buchung kurz vor dem Termin ändern.
<p>Wenn die Änderungssperre aktiviert und beispielsweise auf 2 Stunden eingestellt ist, können Teilnehmer/innen keinen neuen Termin buchen, der in weniger als 2 Stunden beginnt. Sie können aber auch keinen bestehenden Termin löschen, der in weniger als 2 Stunden beginnt.</p>';
$string['guestscantdoanything'] = 'Gäste können hier nichts tun.';
$string['howtoaddstudents'] = 'Um Teilnehmer/innen zu einem Planer globaler Reichweite hinzuzufügen, verwenden Sie die Einstellungen der Rollen für das Modul.<br/>Sie können auch die Rollendefinitionen des Moduls verwenden, um die Anwesenheiten Ihrer Teilnehmer/innen zu definieren.';
$string['htmlformat'] = 'HTML';
$string['ignoreconflicts'] = 'Terminkollisionen ignorieren';
$string['ignoreconflicts_help'] = 'Wenn dieses Feld angekreuzt ist, wird das Zeifenster zum gewählten Zeitpunkt verschoben, selbst falls andere Zeitfenster zur gleichen Zeit existieren. Dies kann zu überlappenden Terminen für einige Trainer/innen oder Teilnehmer/innen führen und sollte daher mit Vorsicht verwendet werden.';
$string['ignoreconflicts_link'] = 'mod/scheduler/conflict';
$string['includeemptyslots'] = 'Leere Zeitfenster einbeziehen';
$string['includeslotsfor'] = 'Zeitfenster einbeziehen für';
$string['incourse'] = 'in Kurs';
$string['introduction'] = 'Einführung';
$string['isnonexclusive'] = 'Nicht-exklusive';
$string['landscape'] = 'quer';
$string['lengthbreakdown'] = 'Nach Dauer des Zeitfensters';
$string['limited'] = 'Beschränkt (noch {$a})';
$string['location'] = 'Ort';
$string['location_help'] = 'Legen Sie den vorgesehenen Ort für das Treffen fest.';
$string['markasseennow'] = 'Als gesehen markieren';
$string['markseen'] = 'Nachdem Sie einen Termin mit einem/einer Teilnehmer/in wahrgenommen haben, markieren Sie ihn/sie bitte durch Anklicken der entsprechenden Checkbox in der obigen Übersicht als "gesehen".';
$string['maxgrade'] = 'Beste Bewertung verwenden';
$string['maxstudentlistsize'] = 'Maximale Länge der Teilnehmerliste';
$string['maxstudentlistsize_desc'] = 'Die maximale Länge der Teilnehmerliste ohne Termin, die für Trainer/innnen angezeigt wird. Wenn mehr Teilnehmer/innen ohne Termin sind, wird die Liste nicht angezeigt.';
$string['maxstudentsperslot'] = 'Maximale Anzahl von Teilnehmer/innen pro Zeitfenster';
$string['maxstudentsperslot_desc'] = 'Gruppenzeitfenster / nicht-exklusive Zeitfenster können diese Anzahl an Teilnehmern haben. Es kann auch die Einstellung "unbegrenzt" ausgewählt werden.';
$string['meangrade'] = 'Durchschnittliche Bewertung verwenden';
$string['meetingwith'] = 'Treffen mit Ihrer/m';
$string['meetingwithplural'] = 'Treffen mit Ihren';
$string['message'] = 'Mitteilung';
$string['messagebody'] = 'Inhalt';
$string['messageprovider:bookingnotification'] = 'Benachrichtigung wenn eine Buchung getätigt oder gelöscht wurde';
$string['messageprovider:invitation'] = 'Einladung um ein Zeitfenster zu buchen';
$string['messageprovider:reminder'] = 'Erinnerung an einen bevorstehenden Termin';
$string['messagesent'] = 'Nachricht an {$a} Empfänger gesendet';
$string['messagesubject'] = 'Betreff';
$string['minutes'] = 'Minuten';
$string['minutesperslot'] = 'Minuten pro Zeitfenster';
$string['missingstudents'] = '{$a} Teilnehmer/innen müssen noch einen Termin festlegen';
$string['missingstudentsmany'] = '{$a} Teilnehmer/innen müssen noch einen Termin festlegen. Aufgrund der Grösse wird keine Liste angezeigt.';
$string['mixindivgroup'] = 'Einzel- und Gruppenbuchungen mischen';
$string['mixindivgroup_desc'] = 'Wo Gruppenbuchung aktiviert ist auch individuelle Buchungen erlauben.';
$string['mode'] = 'Modus';
$string['modeappointments'] = 'Termin(e) buchen';
$string['modeintro'] = 'Teilnehmer/innen können';
$string['modeoneatatime'] = 'auf ein Mal';
$string['modeoneonly'] = 'in diesem Planer';
$string['modulename'] = 'Planer';
$string['modulename_help'] = 'Die Aktivität "Planer" hilft Ihnen bei der Planung von Terminen mit Ihren Teilnehmern/innen.

Trainer/innen geben Zeitfenster für Treffen vor, Teilnehmer/innen wählen dann eines davon in Moodle. Trainer/innen können Resultate - und optional eine Bewertung - eines Treffens im Planer erfassen.

Die Planung von Gruppentermin wird unterstützt. Jedes Zeitfenster kann dabei mehrere Teilnehmer/innen aufnehmen. Optional ist es möglich, Termine auch für ganze Gruppen gleichzeitig zu vereinbaren.';
$string['modulename_link'] = 'mod/scheduler/view';
$string['modulenameplural'] = 'Planer';
$string['monday'] = 'Montag';
$string['multiple'] = '(mehrere)';
$string['myappointments'] = 'Meine Termine';
$string['myself'] = 'eigene';
$string['name'] = 'Name des Planers';
$string['needteachers'] = 'Es können keine Zeitfenster hinzugefügt werden, da der Kurs keine Trainer/innen hat.';
$string['negativerange'] = 'Negativer Wert ist nicht möglich-';
$string['negativetimerange'] = 'Endzeit muss nach Startzeit liegen.';
$string['never'] = 'Nie';
$string['nfiles'] = '{$a} Dateien';
$string['noappointments'] = 'Keine Termine';
$string['noexistingstudents'] = 'Keine Teilnehmer/innen vorhanden';
$string['nogroups'] = 'Keine Gruppe vorhanden';
$string['noresults'] = 'Keine Ergebnisse.';
$string['noschedulers'] = 'Keine Planer vorhanden';
$string['noslots'] = 'Keine Zeitfenster verfügbar';
$string['noslotsavailable'] = 'Keine Zeitfenster verfügbar oder alle angekündigten Termine sind ausgebucht.';
$string['noslotsopennow'] = 'Keine offenen Zeitfenster bisher';
$string['nostudents'] = 'Keine Teilnehmer/innen mit Terminen';
$string['nostudenttobook'] = 'Kein/e Teilnehmer/in buchbar';
$string['note'] = 'Bewertung';
$string['noteacherforslot'] = 'Kein/e Trainer/in für das Zeitfenster';
$string['noteachershere'] = 'Kein/e Trainer/in verfügbar';
$string['notenoughplaces'] = 'Für diesen Termin sind keine Plätze mehr frei.';
$string['notesrequired'] = 'Sie müssen hier Text eingeben, bevor Sie das Zeitfenster buchen.';
$string['notifications'] = 'Benachrichtigungen';
$string['notifications_help'] = 'Wenn diese Option aktiviert ist, werden Trainer/innen und Teilnehmer/innen Benachrichtigungen erhalten, wenn Termine beantragt oder abgesagt werden.';
$string['notseen'] = 'Nicht gesehen';
$string['now'] = 'Jetzt';
$string['occurrences'] = 'Fundstellen';
$string['odsformat'] = 'ODS';
$string['on'] = 'an';
$string['onedaybefore'] = '1 Tag vor Zeitfenster';
$string['onelineperappointment'] = 'Eine Zeile pro Termin';
$string['onelineperslot'] = 'Eine Zeile pro Zeitfenster';
$string['oneslotadded'] = '1 Zeitfenster hinzugefügt';
$string['oneslotdeleted'] = '1 Zeitfenster gelöscht';
$string['oneweekbefore'] = '1 Woche vor Zeitfenster';
$string['onthemorningofappointment'] = 'Am Morgen des Termins';
$string['options'] = 'Optionen';
$string['otherstudents'] = 'Andere Teilnehmende';
$string['outlineappointments'] = '{$a->attended} Termine wahrgenommen, {$a->upcoming} anstehende.';
$string['outlinegrade'] = 'Bewertung: {$a}.';
$string['overall'] = 'Übersicht';
$string['overlappings'] = 'Andere Zeitfenster überlappen';
$string['pageperteacher'] = 'Eine Seite für jede {$a}';
$string['pagination'] = 'Seitenzahlen';
$string['pagination_help'] = 'Auwählen, ob der Export für jeden Trainer eine eigene Seite enthält.
In Excel und ODS werden diese Seiten als Tabs (Arbeitsblätter) dargestellt.';
$string['pdfformat'] = 'PDF';
$string['pdforientation'] = 'PDF Seitenausrichtung';
$string['pluginadministration'] = 'Planer-Administration';
$string['pluginname'] = 'Planer';
$string['portrait'] = 'Bild';
$string['preview'] = 'Vorschau';
$string['previewlimited'] = '(Vorschau ist begrenzt auf {$a} Reihen.)';
$string['privacy:metadata:filepurpose'] = 'Datei, die in den Notizen für das Zeitfenster oder den Termin verwendet wird';
$string['privacy:metadata:scheduler_appointment'] = 'Stellt einen Teilnehmertermin in einem Planer dar';
$string['privacy:metadata:scheduler_appointment:appointmentnote'] = 'Bemerkung des Trainers (sichtbar für Teilnehmer)';
$string['privacy:metadata:scheduler_appointment:appointmentnoteformat'] = 'Format der Lehrernotiz';
$string['privacy:metadata:scheduler_appointment:attended'] = 'Ob der Termin besucht wurde';
$string['privacy:metadata:scheduler_appointment:grade'] = 'Bewertung für Terminvereinbarung';
$string['privacy:metadata:scheduler_appointment:studentid'] = 'Teilnehmer/in, der/die den Termin vereinbart hat.';
$string['privacy:metadata:scheduler_appointment:studentnote'] = 'Bemerkung von Teilnehmer/in';
$string['privacy:metadata:scheduler_appointment:studentnoteformat'] = 'Format der Teilnehmernotiz';
$string['privacy:metadata:scheduler_appointment:teachernote'] = 'Bemerkung von Trainer/in (nur für Trainer/in sichtbar)';
$string['privacy:metadata:scheduler_appointment:teachernoteformat'] = 'Format der persönlichen Trainernotiz';
$string['privacy:metadata:scheduler_slots'] = 'Repräsentiert ein Zeitfenster in einem Planer';
$string['privacy:metadata:scheduler_slots:appointmentlocation'] = 'Ort';
$string['privacy:metadata:scheduler_slots:duration'] = 'Länge in Minuten';
$string['privacy:metadata:scheduler_slots:exclusivity'] = 'Max. Anzahl an Teilnehmer/-innen';
$string['privacy:metadata:scheduler_slots:notes'] = 'Bemerkung zu diesem Zeitfenster';
$string['privacy:metadata:scheduler_slots:notesformat'] = 'Format der Notizen';
$string['privacy:metadata:scheduler_slots:starttime'] = 'Beginn';
$string['privacy:metadata:scheduler_slots:teacherid'] = 'Trainer für dieses Zeitfenster';
$string['purgeunusedslots'] = 'Ungenutzte Zeitfenster in der Vergangenheit löschen';
$string['recipients'] = 'Empfänger';
$string['registeredlbl'] = 'Teilnehmer/innen mit Terminen';
$string['reminder'] = 'Erinnerung';
$string['requireupload'] = 'Datei-Upload erforderlich';
$string['resetappointments'] = 'Termine und Bewertungen löschen';
$string['resetslots'] = 'Planer-Zeitfenster löschen';
$string['return'] = 'Zurück zum Kurs';
$string['revealteachernotes'] = 'Trainernotizen in Exporten zum Datenschutz anzeigen';
$string['revealteachernotes_desc'] = 'Wenn diese Option ausgewählt ist, werden vertrauliche Trainernotizen (die normalerweise nicht sichtbar sind) den Teilnehmer/innen in Datenexportanfragen, d.h. über die Datenschutz-API, mitgeteilt. Sie sollten sich bei einer individuellen Verwendung dieses Feldes entscheiden, ob es in Datenexporte für Teilnehmer/innen im Rahmen der DSGVO einbezogen werden muss.';
$string['revoke'] = 'Termin absagen';
$string['saturday'] = 'Samstag';
$string['save'] = 'Sichern';
$string['savechoice'] = 'Auswahl speichern';
$string['saveseen'] = 'Als gesehen speichern';
$string['schedule'] = 'Festlegen';
$string['scheduleappointment'] = 'Termin festlegen für {$a}';
$string['schedulecancelled'] = '{$a}: Ihr Termin wurde abgesagt oder verschoben';
$string['schedulegroups'] = 'Für Gruppen festlegen';
$string['scheduleinnew'] = 'In neuem Zeitfenster festlegen';
$string['scheduleinslot'] = 'In Zeitfenster festlegen';
$string['scheduler'] = 'Planer';
$string['scheduler:addinstance'] = 'Planer hinzufügen';
$string['scheduler:appoint'] = 'Zeitfenster buchen';
$string['scheduler:attend'] = 'Teilnehmer/innen betreuen';
$string['scheduler:canscheduletootherteachers'] = 'Termine für andere Mitarbeiter festlegen';
$string['scheduler:canseeotherteachersbooking'] = 'Buchungen anderer Trainer/innen sehen und browsen';
$string['scheduler:disengage'] = 'Diese Fähigkeit ist veraltet und hat keine Funktion';
$string['scheduler:editallattended'] = 'Teilnehmer/innen in allen Terminen als besucht / nicht besucht markieren';
$string['scheduler:editallgrades'] = 'Noten in allen Terminen bearbeiten';
$string['scheduler:editallnotes'] = 'Notizen in allen Terminen bearbeiten';
$string['scheduler:manage'] = 'Zeitfenster und Termine verwalten';
$string['scheduler:manageallappointments'] = 'Alle Planer-Einträge verwalten';
$string['scheduler:seeotherstudentsbooking'] = 'Die Buchung anderer Teilnehmer/innen im Zeitfenster sehen';
$string['scheduler:seeotherstudentsresults'] = 'Die Bewertung anderer Teilnehmer/innen im Zeitfenster sehen';
$string['scheduler:seeoverviewoutsideactivity'] = 'Nutzen Sie die Übersicht, um Zeitfenster außerhalb der aktuellen Planer Aktivität zu sehen.';
$string['scheduler:viewfullslots'] = 'Zeitfenster anzeigen auch wenn sie voll ausgebucht sind (in der Teilnehmeransicht)';
$string['scheduler:viewslots'] = 'Zeitfenster anzeigen, die buchbar sind (in der Teilnehmeransicht)';
$string['schedulestudents'] = 'Planer nach Teilnehmer/in';
$string['scopemenu'] = 'Zeige Zeitfenster in {$a}';
$string['scopemenuself'] = 'Zeige meine Zeitfenster in {$a}';
$string['search:activity'] = 'Planer - Aktivitätsinformation';
$string['seen'] = 'Gesehen';
$string['selectedtoomany'] = 'Sie haben zu viele Zeitfenster ausgewählt. Sie können maximal {$a} auswählen.';
$string['sendinvitation'] = 'Einladung senden';
$string['sendmessage'] = 'Nachricht senden';
$string['sendreminder'] = 'Erinnerung senden';
$string['sendreminders'] = 'E-Mail für anstehende Termine versenden';
$string['sepcolon'] = 'Doppelpunkt';
$string['sepcomma'] = 'Komma';
$string['sepsemicolon'] = 'Semikolon';
$string['septab'] = 'Tab';
$string['showemailplain'] = 'Mail-Adresse anzeigen';
$string['showemailplain_desc'] = 'In der Trainer-Ansicht: E-Mail-Adressen der Teilnehmer/innen ohne Termin anzeigen';
$string['showparticipants'] = 'Teilnehmer/innen anzeigen';
$string['slot'] = 'Zeitfenster';
$string['slot_is_just_in_use'] = 'Sorry, das Zeitfenster wurde gerade von einer/m anderen Teilnehmer/in gewählt! Bitte versuchen Sie noch einmal.';
$string['slotdatetime'] = '{$a->shortdatetime} für {$a->duration} Minuten';
$string['slotdatetimelabel'] = 'Datum und Zeit';
$string['slotdatetimelong'] = '{$a->date}, {$a->starttime} &ndash; {$a->endtime}';
$string['slotdescription'] = '{$a->status} am {$a->startdate} von {$a->starttime} bis {$a->endtime} in {$a->location} mit {$a->facilitator}.';
$string['slots'] = 'Zeitfenster';
$string['slotsadded'] = '{$a} Zeitfenster wurden hinzugefügt';
$string['slotsdeleted'] = '{$a} Zeitfenster wurden gelöscht';
$string['slottype'] = 'Zeitfenstertyp';
$string['slotupdated'] = '1 Zeitfenster aktualisiert';
$string['slotwarning'] = '<strong>Warnung: </strong>Dieses Zeitfenster an die gewählte Zeit verschieben kollidiert mit dem/n untenstehenden Zeitfenster(n). Kreuzen Sie "Terminkollisionen ignorieren" an, wenn Sie das Zeitfenster trotzdem verschieben möchten.';
$string['staffbreakdown'] = 'Nach {$a}';
$string['staffrolename'] = 'Rollenname der/s Trainers/in';
$string['staffrolename_help'] = 'Name der Rolle, welche die Teilnehmer/innen betreut. Das ist nicht unbedingt ein/e "Trainer/in".';
$string['start'] = 'Start';
$string['startpast'] = 'Sie können kein Zeitfenster in der Vergangenheit erstellen';
$string['statistics'] = 'Statistik';
$string['student'] = 'Teilnehmer/in';
$string['studentbreakdown'] = 'Nach Teilnehmer/in';
$string['studentcomments'] = 'Mitteilung von Teilnehmer/in';
$string['studentdetails'] = 'Details zu Teilnehmer/in';
$string['studentfiles'] = 'Hochgeladene Dateien';
$string['studentmultiselect'] = 'Jede/r Teilnehmer/in kann nur einmal in diesem Zeitfenster ausgewählt werden.';
$string['studentnote'] = 'Mitteilung von Teilnehmer/in';
$string['studentprovided'] = 'Von  bereitgestellt: {$a}';
$string['students'] = 'Teilnehmer/innen';
$string['sunday'] = 'Sonntag';
$string['tab-otherappointments'] = 'Alle Termine dieser/s Teilnehmers/in';
$string['tab-otherstudents'] = 'Teilnehmer/innen in diesem Zeitfenster';
$string['tab-thisappointment'] = 'Dieser Termin';
$string['teacher'] = 'Trainer/in';
$string['teachernote'] = 'Vertrauliche Bemerkungen (nur für Trainer/innen sichtbar)';
$string['teachersmenu'] = 'Zeitfenster anzeigen für {$a}';
$string['thiscourse'] = 'diesem Kurs';
$string['thisscheduler'] = 'diesem Planer';
$string['thissite'] = 'komplette Seite';
$string['thursday'] = 'Donnerstag';
$string['timefrom'] = 'von:';
$string['timerange'] = 'Zeitspanne';
$string['timeto'] = 'bis:';
$string['totalgrade'] = 'Gesamtbewertung';
$string['tuesday'] = 'Dienstag';
$string['unattended'] = 'Nicht wahrgenommen';
$string['unlimited'] = 'Unbegrenzt';
$string['unregisteredlbl'] = 'Teilnehmer/innen ohne Termin';
$string['upcomingslots'] = 'Aktuelle Zeitfenster';
$string['updategrades'] = 'Bewertungen aktualisieren';
$string['updatesingleslot'] = '';
$string['uploadmaxfiles'] = 'Anzahl hochladbarer Dateien';
$string['uploadmaxfiles_help'] = 'Die maximale Anzahl der Dateien, die Studierende im Buchungsformular hochladen können. Der Datei-Upload ist optional, es sei denn, das Feld "Datei-Upload erforderlich" wird angekreuzt. Wenn auf 0 gesetzt, werden die Studierende kein Dateiauswahl-Feld sehen.';
$string['uploadmaxfilesglobal'] = 'Anzahl hochladbarer Dateien';
$string['uploadmaxfilesglobal_desc'] = 'Die maximale Anzahl von Dateien, die Studierende in einem Buchungsformular hochladen können. Dies kann auf der Ebene der einzelnen Planer weiter reduziert werden.';
$string['uploadmaxsize'] = 'Maximale Dateigröße';
$string['uploadmaxsize_help'] = 'Maximale Dateigröße für Uploads von Teilnehmer/innen. Diese Grenze gilt pro Datei.';
$string['uploadrequired'] = 'Sie müssen hier Dateien hochladen, bevor Sie das Zeitfenster buchen.';
$string['uploadstudentfiles'] = 'Dateien hochladen';
$string['usebookingform'] = 'Buchungsformular verwenden';
$string['usebookingform_help'] = 'Wenn diese Option aktiviert ist, sehen Studierende einen separaten Buchungsbildschirm, bevor sie ein Zeitfenster buchen können. Der Buchungsbildschirm kann verlangen, dass sie Daten eingeben, Dateien hochladen oder ein Captcha lösen; siehe untenstehende Optionen';
$string['usebookingform_link'] = 'mod/scheduler/bookingform';
$string['usecaptcha'] = 'Captcha verwenden für neue Buchungen';
$string['usecaptcha_help'] = 'Wenn diese Option aktiviert ist, müssen die Teilnehmer/innen eine Captcha-Sicherheitsfrage lösen, bevor sie eine neue Buchung machen.
Verwenden Sie diese Einstellung, wenn Sie vermuten, dass automatisierte Programme verwendet werden, um verfügbare Slots zu schnappen.
<p>Es wird kein Captcha angezeigt, wenn eine bestehende Buchung bearbeitet wird.</p>';
$string['usenotes'] = 'Bemerkungen für Termin verwenden';
$string['usenotesboth'] = 'Beide Arten von Bemerkungen';
$string['usenotesnone'] = 'keine';
$string['usenotesstudent'] = 'Termin-Bemerkungen, für Trainer/innen und Teilnehmer/in sichtbar';
$string['usenotesteacher'] = 'Vertrauliche Bemerkung, nur für Trainer/innen sichtbar';
$string['usestudentnotes'] = 'Mitteilung eingeben lassen';
$string['usestudentnotes_help'] = 'Wenn diese Option aktiviert ist, enthält der Buchungsbildschirm ein Textfeld, in dem die Teilnehmer/innen eine Nachricht eingeben können. Beschreiben Sie in den "Buchungsanweisungen" oben, welche Informationen nötig sind..';
$string['viewbooking'] = 'Details ansehen';
$string['wednesday'] = 'Mittwoch';
$string['welcomebackstudent'] = 'Sie können zusätzliche Zeitfenster buchen, indem Sie unten auf den Button "Zeitfenster buchen" klicken.';
$string['welcomenewstudent'] = 'Die folgende Übersicht zeigt alle verfügbaren Zeitfenster für einen Termin. Wählen Sie Ihren Termin, indem Sie auf den entsprechenden Button "Zeitfenster buchen" klicken. Wenn Sie eine Änderung vornehmen möchten, können Sie diese Seite erneut besuchen.';
$string['welcomenewteacher'] = 'Bitte klicken Sie auf den Button unten, um Zeitfenster für Termine hinzuzufügen.';
$string['what'] = 'Kommentar';
$string['whathappened'] = 'Feedback';
$string['whatresulted'] = 'Bewertung';
$string['when'] = 'Wann?';
$string['where'] = 'Wo?';
$string['who'] = 'Mit wem?';
$string['whosthere'] = 'Wer ist dort?';
$string['xdaysbefore'] = '{$a} Tage vor Zeitfenster';
$string['xweeksbefore'] = '{$a} Wochen vor Zeitfenster';
$string['yesallgroups'] = 'Ja, für alle Gruppen';
$string['yesingrouping'] = 'Ja, in Gruppierung {$a}';
$string['yesoptional'] = 'Ja, optional für Teilnehmer/innen';
$string['yesrequired'] = 'Ja, Teilnehmer/innen müssen eine Mitteilung eingeben';
$string['yourappointmentnote'] = 'Kommentar für Sie persönlich';
$string['yourslotnotes'] = 'Kommentare zum Zeitfenster';
$string['yourstudentnote'] = 'Ihre Nachricht';
$string['yourtotalgrade'] = 'Ihre Gesamtbewertung lautet <strong>{$a}</strong>';
