<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'glossary', language 'de', version '4.1'.
 *
 * @package     glossary
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addcategory'] = 'Kategorie hinzufügen';
$string['addcomment'] = 'Kommentar hinzufügen';
$string['addentry'] = 'Eintrag hinzufügen';
$string['addingcomment'] = 'Kommentar hinzufügen';
$string['addsingleentry'] = 'Eintrag hinzufügen';
$string['alias'] = 'Alternativbegriff';
$string['aliases'] = 'Alternativbegriffe';
$string['aliases_help'] = 'Zu jedem Glossareintrag kann eine Reihe von Alternativbegriffen (Tags, Schlagwörter, Synonyme, Keywords) angegeben werden. Tragen Sie jeden Begriff in einer neuen Zeile ein (nicht als kommagetrennte Liste).

Wenn ein Glossareintrag automatisch verlinkt wird wird jeder dieser Begriffe ebenfalls markiert.';
$string['allcategories'] = 'Alle Kategorien';
$string['allentries'] = 'Alle';
$string['allowcomments'] = 'Kommentare';
$string['allowcomments_help'] = 'Wenn diese Option aktiviert ist, dürfen zu den Glossareinträgen Kommentare abgegeben werden.';
$string['allowduplicatedentries'] = 'Mehrfacheinträge';
$string['allowduplicatedentries_help'] = 'Wenn diese Option aktiviert ist, sind im Glossar mehrere Einträge zum selben Begriff erlaubt.';
$string['allowprintview'] = 'Druckansicht erlauben';
$string['allowprintview_help'] = 'Wenn diese Option aktiviert ist, wird allen Personen ein Link zu einer druckfreundlichen Version des Glossars angezeigt. Trainer/innen sehen diesen Link immer.';
$string['andmorenewentries'] = 'und {$a} weitere neue Einträge.';
$string['answer'] = 'Antwort';
$string['approvaldisplayformat'] = 'Anzeigeformat für die Zulassung';
$string['approvaldisplayformat_help'] = 'Wenn die Zulassung von Glossareinträgen verlangt ist, können unterschiedliche Anzeigeformate gewählt werden.';
$string['approve'] = 'Freigeben';
$string['areaattachment'] = 'Anhänge';
$string['areaentry'] = 'Definitionen';
$string['areyousuredelete'] = 'Möchten Sie diesen Eintrag wirklich löschen?';
$string['areyousuredeletecomment'] = 'Möchten Sie diesen Kommentar wirklich löschen?';
$string['areyousureexport'] = 'Möchten Sie diesen Eintrag exportieren?';
$string['ascending'] = '(aufsteigend)';
$string['attachment'] = 'Anhang';
$string['attachment_help'] = 'Sie können optional eine oder mehrere Dateien an einen Glossareintrag anhängen.';
$string['author'] = 'Autor/in';
$string['authorview'] = 'Nach Autor/in';
$string['back'] = 'Zurück';
$string['cachedef_concepts'] = 'Konzeptverknüpfung';
$string['cantinsertcat'] = 'Kategorie kann nicht angelegt werden';
$string['cantinsertrec'] = 'Eintrag kann nicht angelegt werden';
$string['cantinsertrel'] = 'Verbindung zur Kategorie kann nicht angelegt werden.';
$string['casesensitive'] = 'Groß-/Kleinschreibung';
$string['casesensitive_help'] = 'Diese Einstellung bestimmt, ob bei der automatischen Verlinkung die Groß-/Kleinschreibung berücksichtigt wird.';
$string['cat'] = 'Kategorie';
$string['categories'] = 'Kategorien';
$string['category'] = 'Kategorie';
$string['categorydeleted'] = 'Kategorie gelöscht';
$string['categoryview'] = 'Nach Kategorie';
$string['changeto'] = 'ändern nach {$a}';
$string['cnfallowcomments'] = 'Wenn diese Option aktiviert ist, dürfen zu den Glossareinträgen dürfen Kommentare abgegeben werden.';
$string['cnfallowdupentries'] = 'Wenn diese Option aktiviert ist, sind Mehrfacheinträge im Glossar erlaubt.';
$string['cnfapprovalstatus'] = 'Wenn diese Option aktiviert ist, müssen Glossareinträge nicht durch Trainer/innen geprüft und freigegeben werden.';
$string['cnfcasesensitive'] = 'Wenn diese Option aktiviert ist, wird bei der Verlinkung von Einträgen die Groß-/Kleinschreibung berücksichtigt.';
$string['cnfdefaulthook'] = 'Standardansicht für Glossar wählen';
$string['cnfdefaultmode'] = 'Standardframe für Glossar wählen';
$string['cnffullmatch'] = 'Wenn diese Option aktiviert ist, wird ein Wort automatisch verlinkt, wenn es vollständig mit einem Glossareintrag übereinstimmt.';
$string['cnflinkentry'] = 'Wenn diese Option aktiviert ist, wird ein neuer Eintrag automatisch verlinkt.';
$string['cnflinkglossaries'] = 'Wenn diese Option aktiviert ist, werden Glossare automatisch verlinkt.';
$string['cnfrelatedview'] = 'Wählen Sie das Anzeigeformat für die automatische Verlinkung und die Eintragsdarstellung.';
$string['cnfshowgroup'] = 'Legen Sie fest, ob zwischen einzelnen Abschnitten (z.B. Buchstaben) eine visuelle Trennung erfolgen soll.';
$string['cnfsortkey'] = 'Wählen Sie ein Sortierkriterium.';
$string['cnfsortorder'] = 'Wählen Sie die Sortierfolge.';
$string['cnfstudentcanpost'] = 'Teilnehmer/innen dürfen eigene Einträge anlegen, bearbeiten und löschen.';
$string['cnftabs'] = 'Wählen Sie sichtbare Tabs für dieses Glossarformat aus.';
$string['comment'] = 'Kommentar';
$string['commentdeleted'] = 'Der Kommentar wurde gelöscht.';
$string['comments'] = 'Kommentare';
$string['commentson'] = 'Kommentare eingeschaltet';
$string['commentupdated'] = 'Der Kommentar wurde geändert.';
$string['completiondetail:entries'] = 'Einträge hinzufügen: {$a}';
$string['completionentries'] = 'Teilnehmer/innen müssen Einträge anlegen:';
$string['completionentriesdesc'] = 'Teilnehmer/in muss mindestens {$a} Einträge anlegen';
$string['completionentriesgroup'] = 'Einträge notwendig';
$string['concept'] = 'Begriff';
$string['concepts'] = 'Begriffe';
$string['configenablerssfeeds'] = 'Wenn diese Option aktiviert ist, sind RSS Feeds global für alle Glossare eingeschaltet. Sie können jetzt für jedes Glossar einzeln einstellen, ob die RSS-Feeds für das jeweilige Glossar ein- oder ausgeschaltet sein sollen.';
$string['current'] = 'Aktuelle Sortierung {$a}';
$string['currentglossary'] = 'Aktuelles Glossar';
$string['date'] = 'Datum';
$string['dateview'] = 'Nach Datum';
$string['defaultapproval'] = 'Ohne Prüfung';
$string['defaultapproval_help'] = 'Diese Option legt fest, ob Glossareinträge sofort ohne Prüfung sichtbar werden:

* Ja - Einträge werden sofort nach dem Speichern für alle angezeigt
* Nein - Einträge werden von Trainer/innen geprüft und freigegeben';
$string['defaulthook'] = 'Standardverbindung';
$string['defaultmode'] = 'Standardmodus';
$string['defaultsortkey'] = 'Standardschlüssel';
$string['defaultsortorder'] = 'Standardsortierung';
$string['definition'] = 'Definition';
$string['definitions'] = 'Definitionen';
$string['deletecategory'] = 'Kategorie löschen';
$string['deleteentry'] = 'Eintrag löschen';
$string['deleteentrya'] = 'Eintrag löschen: {$a}';
$string['deletenotenrolled'] = 'Einträge von nicht eingeschriebenen Nutzer/innen löschen';
$string['deletingcomment'] = 'Lösche Kommentar';
$string['deletingnoneemptycategory'] = 'Wenn diese Kategorie gelöscht wird, werden die Einträge daraus nicht gelöscht. Sie werden als \'keiner Kategorie zugeordnet\' gekennzeichnet.';
$string['descending'] = '(absteigend)';
$string['destination'] = 'Ziel für importierte Einträge';
$string['destination_help'] = 'Beim Import können Sie wählen, wo importierte Glossareinträge abgelegt werden sollen:

* Aktuelles Glossar - die Einträge werden zum aktuellen Glossar hinzugefügt
* Neues Glossar - mit den Informationen der XML-Datei wird ein neues Glossar erstellt und die Einträge dahin übernommen
';
$string['disapprove'] = 'Freigegebenen Eintrag sperren';
$string['displayformat'] = 'Anzeigeformat';
$string['displayformat_help'] = 'Für ein Glossar können 7 Anzeigeformate gewählt werden:

* Wörterbuch (mit Synonymen) - Einträge werden in einem Absatz angezeigt. Angabe von synonymen Begriffen. Ohne Autor/in. Anhänge werden als Links angezeigt.
* Wörterbuch (ohne Synonyme) - Einträge werden fortlaufend angezeigt, ohne Angabe synonymer Begriffe.
* Vollständig (mit Autor/in) - Einträge werden forumsähnlich mit Autor/in dargestellt. Anhänge werden als Links angezeigt.
* Vollständig (ohne Autor/in) - Einträge werden forumsähnlich ohne Autor/in dargestellt. Anhänge werden als Links angezeigt.
* Enzyklopädie - Einträge werden forumsähnlich mit Autor/in dargestellt. Bilder sind in den Text eingebettet.
* Liste - Alphabetische Liste ohne Erläuterung. Einträge werden als Links angezeigt, die zur zugehörigen Erläuterung führen.
* FAQ (Frequently Asked Questions) - Die Worte \'Frage\' und \'Antwort\' werden automatisch eingefügt.';
$string['displayformatcontinuous'] = 'Wörterbuch (ohne Synonyme)';
$string['displayformatdefault'] = 'Standard: wie das Anzeigeformat';
$string['displayformatdictionary'] = 'Wörterbuch (mit Synonymen)';
$string['displayformatencyclopedia'] = 'Enzyklopädie';
$string['displayformatentrylist'] = 'Liste';
$string['displayformatfaq'] = 'Häufig gestellte Fragen';
$string['displayformatfullwithauthor'] = 'Vollständig mit Autor/in';
$string['displayformatfullwithoutauthor'] = 'Vollständig ohne Autor/in';
$string['displayformats'] = 'Anzeigeformat';
$string['displayformatssetup'] = 'Einstellungen zum Anzeigeformat';
$string['duplicatecategory'] = 'Kategorie duplizieren';
$string['duplicateentry'] = 'Eintrag duplizieren';
$string['editalways'] = 'Immer bearbeitbar';
$string['editalways_help'] = 'Diese Option legt fest, wie Teilnehmer/innen ihre Einträge bearbeiten dürfen:

* Ja - Einträge sind jederzeit bearbeitbar
* Nein - Einträge sind nur im festgelegten Zeitraum bearbeitbar (oft 30 Minuten)';
$string['editcategories'] = 'Kategorien bearbeiten';
$string['editcategory'] = 'Kategorie bearbeiten';
$string['editentry'] = 'Eintrag bearbeiten';
$string['editentrya'] = 'Eintrag bearbeiten: {$a}';
$string['editingcomment'] = 'Kommentar bearbeiten';
$string['entbypage'] = 'Einträge pro Seite';
$string['entries'] = 'Einträge';
$string['entrieswithoutcategory'] = 'Nicht kategorisierte Einträge';
$string['entry'] = 'Eintrag';
$string['entryalreadyexist'] = 'Der Eintrag existiert bereits.';
$string['entryapproved'] = 'Der Eintrag wurde freigegeben';
$string['entrydeleted'] = 'Eintrag gelöscht';
$string['entryexported'] = 'Der Eintrag wurde erfolgreich exportiert';
$string['entryishidden'] = '(Dieser Eintrag ist aktuell nicht sichtbar)';
$string['entryleveldefaultsettings'] = 'Grundeinstellungen für Einträge';
$string['entrylink'] = 'Eingabelink: {$a}';
$string['entrynotapproved'] = 'Eintrag nicht freigegeben';
$string['entrysaved'] = 'Der Eintrag wurde gespeichert';
$string['entryupdated'] = 'Der Eintrag wurde geändert';
$string['entryusedynalink'] = 'Eintrag automatisch verlinken';
$string['entryusedynalink_help'] = 'Wenn diese Option aktiviert ist, werden Einträge automatisch verlinkt. Wenn der Begriff in einem innerhalb des Kurses erstellten Text vorkommt, wird dieser Begriff automatisch mit diesem Eintrag verlinkt. In hochgeladen Dateien (doc, odt, pdf) werden keine Links erzeugt.

Voraussetzung ist die globale Freischaltung der Glossarverlinkung durch die Administrator/innen.';
$string['errcannoteditothers'] = 'Sie dürfen keine fremden Einträge bearbeiten.';
$string['errconceptalreadyexists'] = 'Diesen Begriff gibt es bereits. In diesem Glossar sind keine Doppeleinträge erlaubt.';
$string['errdeltimeexpired'] = 'Sie dürfen dies nicht löschen. Die Zeit ist abgelaufen!';
$string['erredittimeexpired'] = 'Die Bearbeitungszeit für diesen Eintrag wurde überschritten.';
$string['errorparsingxml'] = 'Es sind Fehler bei der Analyse der Datei aufgetreten. Stellen Sie sicher, dass die  XML-Syntax zulässig ist.';
$string['errreservedkeywords'] = 'Manche Schlüsselwörter können nicht verwendet werden, da sie Sonderzeichen enthalten.';
$string['eventcategorycreated'] = 'Kategorie angelegt';
$string['eventcategorydeleted'] = 'Kategorie gelöscht';
$string['eventcategoryupdated'] = 'Kategorie aktualisiert';
$string['evententryapproved'] = 'Eintrag freigeben';
$string['evententrycreated'] = 'Eintrag angelegt';
$string['evententrydeleted'] = 'Eintrag gelöscht';
$string['evententrydisapproved'] = 'Eintrag abgelehnt';
$string['evententryupdated'] = 'Eintrag aktualisiert';
$string['evententryviewed'] = 'Eintrag angezeigt';
$string['explainaddentry'] = 'Neuen Eintrag ins Glossar hinzufügen. <br />Begriff und Definition sind Pflichtfelder.';
$string['explainall'] = 'Alle Einträge des Glossars auf einer Seite anzeigen';
$string['explainalphabet'] = 'Sie können das Glossar über das Suchfeld oder das Stichwortalphabet durchsuchen.';
$string['explainexport'] = 'Klicken Sie auf den untenstehenden Button, um das Glossar zu exportieren. <br />Es wird eine Datei erstellt, die Sie herunterladen und jederzeit in einen anderen Kurs importieren können.<p>Beachten Sie, dass Anhänge (z.B. Bilder) und Autoren dabei verloren gehen.</p>';
$string['explainimport'] = 'Wählen Sie die zu importierende Datei aus und legen Sie die Kriterien des weiteren Vorgehens fest.';
$string['explainspecial'] = 'Sonderzeichen: alle Einträge anzeigen, die nicht mit einem Buchstaben beginnen';
$string['export'] = 'Export';
$string['exportedentry'] = 'Exportierte Einträge';
$string['exportentries'] = 'Einträge exportieren';
$string['exportentriestoxml'] = 'Glossar als XML-Datei exportieren';
$string['exportfile'] = 'Glossar in Datei exportieren';
$string['exportglossary'] = 'Glossar exportieren';
$string['exporttomainglossary'] = 'Ins Hauptglossar exportieren';
$string['filetoimport'] = 'Datei importieren';
$string['filetoimport_help'] = 'Wählen Sie eine lokal auf Ihrem Computer befindliche XML-Datei aus, die die zu importierenden Einträge enthält.';
$string['fillfields'] = 'Begriff und Definition sind Pflichtfelder.';
$string['filtername'] = 'Autoverlinkung zum Glossar';
$string['fullmatch'] = 'Nur vollständige Wörter';
$string['fullmatch_help'] = 'Wenn diese Option aktiviert ist, wird ein Eintrag nur dann verlinkt, wenn ein vollständiges Wort im Text mit dem Eintrag im Glossar übereinstimmt. Dabei wird beispielsweise keine Verlinkung erzeugt, wenn ein im Glossar eingetragener Begriff "Konstrukt" lautet, aber im Text das Wort "Konstruktivität" vorkommt.';
$string['glossary:addinstance'] = 'Neues Glossar hinzufügen';
$string['glossary:approve'] = 'Einträge freigeben oder nicht freigegeben';
$string['glossary:comment'] = 'Kommentare';
$string['glossary:export'] = 'Einträge exportieren';
$string['glossary:exportentry'] = 'Einzeleintrag exportieren';
$string['glossary:exportownentry'] = 'Ihren Einzeleintrag exportieren';
$string['glossary:import'] = 'Einträge importieren';
$string['glossary:managecategories'] = 'Kategorien verwalten';
$string['glossary:managecomments'] = 'Kommentare verwalten';
$string['glossary:manageentries'] = 'Einträge verwalten';
$string['glossary:rate'] = 'Einträge bewerten';
$string['glossary:view'] = 'Glossar anzeigen';
$string['glossary:viewallratings'] = 'Alle Teilwertungen anzeigen';
$string['glossary:viewanyrating'] = 'Alle Gesamtwertungen anzeigen';
$string['glossary:viewrating'] = 'Eigene Gesamtwertung anzeigen';
$string['glossary:write'] = 'Neue Einträge erstellen';
$string['glossaryleveldefaultsettings'] = 'Grundeinstellungen für Glossare';
$string['glossarytype'] = 'Glossartyp';
$string['glossarytype_help'] = 'Ein Hauptglossar ist ein Glossar, in das Einträge aus Sekundärglossaren importiert werden können. In einem Kurs kann nur ein Hauptglossar vorhanden sein. Wenn der Import nicht genutzt wird, können alle Glossare als Sekundärglossare angelegt sein.';
$string['guestnoedit'] = 'Gäste dürfen das Glossar nicht bearbeiten.';
$string['importcategories'] = 'Kategorien importieren';
$string['importedcategories'] = 'Importierte Kategorien';
$string['importedentries'] = 'Importierte Einträge';
$string['importentries'] = 'Einträge importieren';
$string['importentriesfromxml'] = 'Einträge aus XML-Datei importieren';
$string['includegroupbreaks'] = 'Gruppentrennung einbeziehen';
$string['indicator:cognitivedepth'] = 'Glossar kognitiv';
$string['indicator:cognitivedepth_help'] = 'Dieser Indikator basiert auf der kognitiven Tiefe, die eine Person in einer Glossaraktivität erreicht hat.';
$string['indicator:cognitivedepthdef'] = 'Glossar kognitiv';
$string['indicator:cognitivedepthdef_help'] = 'Die Person hat diesen Prozentsatz des kognitiven Engagements erreicht, das die Glossaraktivitäten während dieses Analyseintervalls aufzeigen (Ebenen = Keine Ansicht, Ansicht, Beiträge).';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Glossar sozial';
$string['indicator:socialbreadth_help'] = 'Dieser Indikator basiert auf der sozialen Breite, die eine Person in einer Glossaraktivität erreicht hat.';
$string['indicator:socialbreadthdef'] = 'Glossar sozial';
$string['indicator:socialbreadthdef_help'] = 'Die Person hat diesen Prozentsatz des soziale Engagements erreicht, das die Glossaraktivitäten während dieses Analyseintervalls aufzeigen (Ebenen = Keine Teilnahme, Teilnahme allein).';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['isglobal'] = 'Kursübergreifendes Glossar 
';
$string['isglobal_help'] = 'Ein kursübergreifendes Glossar enthält Einträge, die im gesamten Moodle verlinkt werden. Ist ein Glossar nicht global, werden die Einträge nur lokal im Kurs verlinkt. Ausschließlich Administrator/innen können Glossare als kursübergreifend definieren.';
$string['letter'] = 'Buchstabe';
$string['linkcategory'] = 'Kategorie automatisch verlinken';
$string['linkcategory_help'] = 'Wenn die Option \'Eintrag automatisch verlinken\' und zusätzlich diese Option aktiviert sind, wird automatisch der Kategoriename verlinkt, wo immer er im Kurs erscheint. Wenn Teilnehmer/innen einem Kategorielink folgen, werden sie auf die Anzeige \'Nach Kategorie\' im Glossar geleitet.';
$string['linking'] = 'Autoverlinkung';
$string['mainglossary'] = 'Hauptglossar';
$string['maxtimehaspassed'] = 'Die maximale Bearbeitungszeit für den Kommentar wurde überschritten! ({$a})';
$string['modulename'] = 'Glossar';
$string['modulename_help'] = 'Das Glossar ermöglicht es den Teilnehmer/innen, eine Liste von Definitionen, wie ein Wörterbuch, zu erstellen und zu pflegen oder Ressourcen oder Informationen zu sammeln und zu organisieren. Zuerst legen Sie das Glossar an, danach werden die Begriffe und die Erläuterungen eingetragen.

Trainer/innen können zulassen, dass Dateien an Glossareinträge angehängt werden. Angehängte Bilder werden im Eintrag angezeigt. Einträge können alphabetisch oder nach Kategorie, Datum oder Autor dargestellt oder durchsucht werden. Einträge können standardmäßig genehmigt werden oder müssen von einer/m Trainer/in genehmigt werden, bevor sie von allen angezeigt werden können.

Tipp: Wenn die Autoverlinkung für Glossare aktiviert ist, werden Glossarbegriffe in allen Texten Ihres Kurses direkt verlinkt. Diese Funktion ist z.B. für Tests abschaltbar.

Trainer/innen können Kommentare zu den Einträgen zulassen. Die Einträge können auch von Trainer/innen oder Teilnehmer/innen bewertet werden (Peer-Bewertung). Die Bewertungen können zu einer Endnote aggregiert werden, die in den Bewertungen festgehalten wird.

Die Glossar-Aktivität hat viele Verwendungsmöglichkeiten, wie z.B.

* Eine kollaborative Sammlung von Schlüsselbegriffen
* Ein Bereich zum Kennenlernen, in welchem neue Teilnehmer/innen ihren Namen und ihre persönlichen Daten eingeben
* Eine Ressource mit praktischen Tipps für good practices in einem Arbeitsgebiet
* Ein Bereich zur gemeinsamen Sammlung von nützlichen Videos, Bildern oder Audiodateien
* Eine Sammlung für die Repetition von Dingen, die Sie sich merken sollten';
$string['modulename_link'] = 'mod/glossary/view';
$string['modulenameplural'] = 'Glossare';
$string['newentries'] = 'Neue Einträge im Glossar';
$string['newglossary'] = 'Neues Glossar';
$string['newglossarycreated'] = 'Neues Glossar wurde erstellt';
$string['newglossaryentries'] = 'Neue Einträge im Glossar:';
$string['nocomment'] = 'Keine Kommentare gefunden';
$string['nocomments'] = '(Keine Kommentare für diesen Eintrag gefunden)';
$string['noconceptfound'] = 'Kein Begriff und keine Definition gefunden';
$string['noentries'] = 'Keine Einträge in diesem Bereich';
$string['noentry'] = 'Keine Einträge gefunden';
$string['nopermissiontodelcomment'] = 'Sie dürfen keine fremden Kommentare löschen!';
$string['nopermissiontodelinglossary'] = 'Sie dürfen in diesem Glossar keine Kommentare schreiben!';
$string['nopermissiontoviewresult'] = 'Sie dürfen ausschließlich Ergebnisse Ihrer eigenen Einträge anschauen.';
$string['notapproved'] = 'Der Glossareintrag wurde bisher nicht freigegeben';
$string['notcategorised'] = 'Nicht kategorisiert';
$string['numberofentries'] = 'Zahl der Einträge';
$string['onebyline'] = '(ein Eintrag pro Zeile)';
$string['page-mod-glossary-edit'] = 'Glossareintragbearbeitungsseite
';
$string['page-mod-glossary-view'] = 'Glossaransichtsseite
';
$string['page-mod-glossary-x'] = 'Jede Glossarseite';
$string['pendingapproval'] = 'Genehmigung ausstehend';
$string['pluginadministration'] = 'Glossar-Administration';
$string['pluginname'] = 'Glossar';
$string['popupformat'] = 'Popup-Format';
$string['print'] = 'Drucken';
$string['printerfriendly'] = 'Druckfreundliche Version';
$string['printviewnotallowed'] = 'Druckansicht ist nicht erlaubt.';
$string['privacy'] = 'Datenschutz der Ergebnisse';
$string['privacy:metadata:core_comments'] = 'Kommentare für Glossareinträge werden im core_comment System gespeichert';
$string['privacy:metadata:core_files'] = 'Dateien als Anhänge zu Forenbeiträgen werden im core_files System gespeichert';
$string['privacy:metadata:core_rating'] = 'Bewertungen zu Glossraeinträgen werden im core_ratings-System gespeichert.';
$string['privacy:metadata:core_tag'] = 'Tags zu Glossareinträgen werden im core_rating-System gespeichert.';
$string['privacy:metadata:glossary_entries'] = 'Informationen  über Nutzereinträge in einer Glossaraktivität';
$string['privacy:metadata:glossary_entries:attachment'] = 'Anhänge am Eintrag eines Nutzers';
$string['privacy:metadata:glossary_entries:concept'] = 'Konzept des hinzugefügten Nutzereintrags';
$string['privacy:metadata:glossary_entries:definition'] = 'Definition des Nutzereintrags';
$string['privacy:metadata:glossary_entries:glossaryid'] = 'Glossaraktivitäts-ID';
$string['privacy:metadata:glossary_entries:timemodified'] = 'Zeitpunkt wann Glossareintrag vom Nutzer bearbeitet wurde';
$string['privacy:metadata:glossary_entries:userid'] = 'ID des Nutzers der Glossareintrag erstellt hat';
$string['question'] = 'Frage';
$string['rejectedentries'] = 'Abgelehnte Einträge';
$string['rejectionrpt'] = 'Übersicht über abgelehnte Einträge';
$string['removeallglossarytags'] = 'Alle Glossar-Tags entfernen';
$string['resetglossaries'] = 'Einträge löschen von';
$string['resetglossariesall'] = 'Einträge aus allen Glossaren löschen';
$string['rssarticles'] = 'Anzahl neuer RSS-Artikel ';
$string['rssarticles_help'] = 'Diese Option legt fest, wie viele neue Glossarbegriffe in den RSS-Feed übernommen werden. Eine Zahl zwischen 5 und 20 sollte angemessen sein. Die Zahl sollte höher sein, wenn das Glossar häufig bearbeitet wird.';
$string['rssfeed'] = 'RSS Feed';
$string['rsssubscriberss'] = 'RSS Feed-Anzeige für \'{$a}\' Begriffe';
$string['rsstype'] = 'RSS Feed für dieses Glossar';
$string['rsstype_help'] = 'Diese Option ermöglicht es, RSS Feeds für dieses Glossar zu aktivieren, wobei im Feed die Begriffe mit oder ohne Autor/in einbezogen werden können.';
$string['search:activity'] = 'Glossar - Aktivitätsinfo';
$string['search:entry'] = 'Glossar - Einträge';
$string['searchindefinition'] = 'Volltext-Suche';
$string['secondaryglossary'] = 'Sekundärglossar';
$string['showall'] = 'Link \'Alle\' anzeigen';
$string['showall_help'] = 'Wenn die Option aktiviert ist, enthält der Index einen Link \'Alle\', über den alle Einträge des Glossars angezeigt werden.';
$string['showalphabet'] = 'Alphabet anzeigen';
$string['showalphabet_help'] = 'Wenn diese Option aktiviert ist, kann im Index über Buchstaben auf alle Einträge zugegriffen, die mit dem jeweiligen Buchstaben beginnen.';
$string['showspecial'] = 'Link \'@\' anzeigen';
$string['showspecial_help'] = 'Wenn diese Option aktiviert ist, enthält der Index einen Link \'@\', über den alle Einträge beginnend mit Sonderzeichen (z.B. #@_%&) oder Ziffern angezeigt werden.';
$string['sortby'] = 'Sortiert nach';
$string['sortbycreation'] = 'Erstellungsdatum';
$string['sortbylastupdate'] = 'Änderungsdatum';
$string['sortchronogically'] = 'Sortiere chronologisch';
$string['special'] = '@';
$string['standardview'] = 'Alphabetisch';
$string['studentcanpost'] = 'Teilnehmer/innen können eigene Einträge anlegen, bearbeiten und löschen.';
$string['tagarea_glossary_entries'] = 'Glossareinträge';
$string['tagsdeleted'] = 'Glossar-Tags wurden gelöscht';
$string['totalentries'] = 'Gesamtzahl der Einträge';
$string['usedynalink'] = 'Automatisch verlinken';
$string['usedynalink_help'] = 'Wenn diese Option aktiviert ist, wird beim Hinzufügen eines neuen Eintrages die Option "Eintrag automatisch verlinken" angezeigt.

Voraussetzung ist die globale Freischaltung der Glossarverlinkung durch die Administrator/innen.';
$string['visibletabs'] = 'Sichtbare Tabs';
$string['waitingapproval'] = 'Einträge zur Prüfung';
$string['warningstudentcapost'] = '(gilt nur, wenn dieses Glossar kein Hauptglossar ist)';
$string['withauthor'] = 'Begriffe mit Autor/in';
$string['withoutauthor'] = 'Begriffe ohne Autor/in';
$string['writtenby'] = 'von';
$string['youarenottheauthor'] = 'Sie dürfen diesen Kommentar nicht bearbeiten, weil Sie ihn nicht selbst geschrieben haben.';
